/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.TableGridModel;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.DocumentSerializerImpl;

public class TableConverter
extends ConverterHelper {
    protected Vector sheetNames = new Vector();

    public TableConverter(WriterStyleCollection wsc, Config config, DocumentSerializerImpl converter) {
        super(wsc, config, converter);
    }

    public void convertTableContent(Element onode) {
        Element hnode = null;
        if (!onode.hasChildNodes()) {
            return;
        }
        if (!this.config.xhtmlCalcSplit()) {
            hnode = this.converter.nextOutFile();
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            String sNodeName;
            Node child = nList.item(i);
            if (child.getNodeType() == 1 && (sNodeName = child.getNodeName()).equals("table:table")) {
                if (this.config.xhtmlCalcSplit()) {
                    hnode = this.converter.nextOutFile();
                }
                String sName = Misc.getAttribute(child, "table:name");
                this.sheetNames.add(sName);
                Element heading = this.converter.createElement("h2");
                hnode.appendChild(heading);
                heading.setAttribute("id", "tableheading" + (this.sheetNames.size() - 1));
                heading.appendChild(this.converter.createTextNode(sName));
                this.handleTable(child, hnode);
            }
            ++i;
        }
    }

    public void handleTable(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "table:name");
        TableGridModel tgm = new TableGridModel(onode);
        Element table = this.converter.createElement("table");
        this.converter.addTarget(table, sName + "%7Ctable");
        hnode.appendChild(table);
        table.setAttribute("cellspacing", "0");
        boolean bIsSubtable = "table:sub-table".equals(onode.getNodeName());
        if (bIsSubtable) {
            table.setAttribute("style", "margin:0");
        } else {
            String sStyleName = Misc.getAttribute(onode, "table:style-name");
            this.getStyleCv().applyTableStyle(sStyleName, table);
        }
        int nColCount = tgm.getMaxColCount();
        int nCol = 0;
        while (nCol < nColCount) {
            Element col = this.converter.createElement("col");
            table.appendChild(col);
            this.getStyleCv().applyColumnStyle(tgm.getCol(nCol).getStyleName(), col);
            ++nCol;
        }
        Element thead = this.converter.createElement("thead");
        Element tbody = this.converter.createElement("tbody");
        int nRowCount = tgm.getRowCount();
        Element tgroup = thead;
        if (tgm.getRow(nRowCount - 1).isHeader()) {
            tgroup = tbody;
        }
        int nRow = 0;
        while (nRow < nRowCount) {
            if (!tgm.getRow(nRow).isHeader()) {
                tgroup = tbody;
            }
            Element tr = this.converter.createElement("tr");
            tgroup.appendChild(tr);
            this.getStyleCv().applyRowStyle(tgm.getRow(nRow).getStyleName(), tr);
            int nCol2 = 0;
            while (nCol2 < nColCount) {
                Node cell = tgm.getCell(nRow, nCol2);
                if (cell != null && "table:table-cell".equals(cell.getNodeName())) {
                    Element subTable;
                    String sColSpan;
                    Element td = this.converter.createElement("td");
                    tr.appendChild(td);
                    String sRowSpan = Misc.getAttribute(cell, "table:number-rows-spanned");
                    if (Misc.getPosInteger(sRowSpan, 1) > 1) {
                        td.setAttribute("rowspan", sRowSpan);
                    }
                    if (Misc.getPosInteger(sColSpan = Misc.getAttribute(cell, "table:number-columns-spanned"), 1) > 1) {
                        td.setAttribute("colspan", sColSpan);
                    }
                    if ((subTable = Misc.getChildByTagName(cell, "table:sub-table")) != null) {
                        td.setAttribute("style", "padding:0");
                    } else {
                        String sStyleName = Misc.getAttribute(cell, "table:style-name");
                        if (sStyleName == null) {
                            sStyleName = tgm.getCol(nCol2).getDefaultCellStyleName();
                        }
                        String sValueType = Misc.getAttribute(cell, "table:value-type");
                        this.getStyleCv().applyCellStyle(sStyleName, sValueType, td);
                    }
                    if (cell.hasChildNodes()) {
                        this.getTextCv().traverseBlockText(cell, td);
                    }
                    if (!td.hasChildNodes()) {
                        td.appendChild(this.converter.createTextNode("\u00a0"));
                    }
                }
                ++nCol2;
            }
            ++nRow;
        }
        if (thead.hasChildNodes()) {
            table.appendChild(thead);
        }
        table.appendChild(tbody);
    }
}

