/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// ResourceRequestApplyConfiguration represents an declarative configuration of the ResourceRequest type for use
// with apply.
type ResourceRequestApplyConfiguration struct {
	VendorParameters                       *runtime.RawExtension `json:"vendorParameters,omitempty"`
	ResourceRequestModelApplyConfiguration `json:",inline"`
}

// ResourceRequestApplyConfiguration constructs an declarative configuration of the ResourceRequest type for use with
// apply.
func ResourceRequest() *ResourceRequestApplyConfiguration {
	return &ResourceRequestApplyConfiguration{}
}

// WithVendorParameters sets the VendorParameters field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the VendorParameters field is set to the value of the last call.
func (b *ResourceRequestApplyConfiguration) WithVendorParameters(value runtime.RawExtension) *ResourceRequestApplyConfiguration {
	b.VendorParameters = &value
	return b
}

// WithNamedResources sets the NamedResources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NamedResources field is set to the value of the last call.
func (b *ResourceRequestApplyConfiguration) WithNamedResources(value *NamedResourcesRequestApplyConfiguration) *ResourceRequestApplyConfiguration {
	b.NamedResources = value
	return b
}
