// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package analyticshub provides access to the Analytics Hub API.
//
// For product documentation, see: https://cloud.google.com/bigquery/docs/analytics-hub-introduction
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/analyticshub/v1"
//	...
//	ctx := context.Background()
//	analyticshubService, err := analyticshub.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	analyticshubService, err := analyticshub.NewService(ctx, option.WithScopes(analyticshub.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	analyticshubService, err := analyticshub.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	analyticshubService, err := analyticshub.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package analyticshub // import "google.golang.org/api/analyticshub/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "analyticshub:v1"
const apiName = "analyticshub"
const apiVersion = "v1"
const basePath = "https://analyticshub.googleapis.com/"
const basePathTemplate = "https://analyticshub.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://analyticshub.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data in Google BigQuery and see the email address for
	// your Google Account
	BigqueryScope = "https://www.googleapis.com/auth/bigquery"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/bigquery",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.DataExchanges = NewOrganizationsLocationsDataExchangesService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	DataExchanges *OrganizationsLocationsDataExchangesService
}

func NewOrganizationsLocationsDataExchangesService(s *Service) *OrganizationsLocationsDataExchangesService {
	rs := &OrganizationsLocationsDataExchangesService{s: s}
	return rs
}

type OrganizationsLocationsDataExchangesService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.DataExchanges = NewProjectsLocationsDataExchangesService(s)
	rs.Subscriptions = NewProjectsLocationsSubscriptionsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	DataExchanges *ProjectsLocationsDataExchangesService

	Subscriptions *ProjectsLocationsSubscriptionsService
}

func NewProjectsLocationsDataExchangesService(s *Service) *ProjectsLocationsDataExchangesService {
	rs := &ProjectsLocationsDataExchangesService{s: s}
	rs.Listings = NewProjectsLocationsDataExchangesListingsService(s)
	rs.QueryTemplates = NewProjectsLocationsDataExchangesQueryTemplatesService(s)
	return rs
}

type ProjectsLocationsDataExchangesService struct {
	s *Service

	Listings *ProjectsLocationsDataExchangesListingsService

	QueryTemplates *ProjectsLocationsDataExchangesQueryTemplatesService
}

func NewProjectsLocationsDataExchangesListingsService(s *Service) *ProjectsLocationsDataExchangesListingsService {
	rs := &ProjectsLocationsDataExchangesListingsService{s: s}
	return rs
}

type ProjectsLocationsDataExchangesListingsService struct {
	s *Service
}

func NewProjectsLocationsDataExchangesQueryTemplatesService(s *Service) *ProjectsLocationsDataExchangesQueryTemplatesService {
	rs := &ProjectsLocationsDataExchangesQueryTemplatesService{s: s}
	return rs
}

type ProjectsLocationsDataExchangesQueryTemplatesService struct {
	s *Service
}

func NewProjectsLocationsSubscriptionsService(s *Service) *ProjectsLocationsSubscriptionsService {
	rs := &ProjectsLocationsSubscriptionsService{s: s}
	return rs
}

type ProjectsLocationsSubscriptionsService struct {
	s *Service
}

// ApproveQueryTemplateRequest: Message for approving a QueryTemplate.
type ApproveQueryTemplateRequest struct {
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AvroConfig: Configuration for writing message data in Avro format. Message
// payloads and metadata will be written to files as an Avro binary.
type AvroConfig struct {
	// UseTopicSchema: Optional. When true, the output Cloud Storage file will be
	// serialized using the topic schema, if it exists.
	UseTopicSchema bool `json:"useTopicSchema,omitempty"`
	// WriteMetadata: Optional. When true, write the subscription name, message_id,
	// publish_time, attributes, and ordering_key as additional fields in the
	// output. The subscription name, message_id, and publish_time fields are put
	// in their own fields while all other message properties other than data (for
	// example, an ordering_key, if present) are added as entries in the attributes
	// map.
	WriteMetadata bool `json:"writeMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UseTopicSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UseTopicSchema") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AvroConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AvroConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigQueryConfig: Configuration for a BigQuery subscription.
type BigQueryConfig struct {
	// DropUnknownFields: Optional. When true and use_topic_schema is true, any
	// fields that are a part of the topic schema that are not part of the BigQuery
	// table schema are dropped when writing to BigQuery. Otherwise, the schemas
	// must be kept in sync and any messages with extra fields are not written and
	// remain in the subscription's backlog.
	DropUnknownFields bool `json:"dropUnknownFields,omitempty"`
	// ServiceAccountEmail: Optional. The service account to use to write to
	// BigQuery. The subscription creator or updater that specifies this field must
	// have `iam.serviceAccounts.actAs` permission on the service account. If not
	// specified, the Pub/Sub service agent
	// (https://cloud.google.com/iam/docs/service-agents),
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// Table: Optional. The name of the table to which to write data, of the form
	// {projectId}.{datasetId}.{tableId}
	Table string `json:"table,omitempty"`
	// UseTableSchema: Optional. When true, use the BigQuery table's schema as the
	// columns to write to in BigQuery. `use_table_schema` and `use_topic_schema`
	// cannot be enabled at the same time.
	UseTableSchema bool `json:"useTableSchema,omitempty"`
	// UseTopicSchema: Optional. When true, use the topic's schema as the columns
	// to write to in BigQuery, if it exists. `use_topic_schema` and
	// `use_table_schema` cannot be enabled at the same time.
	UseTopicSchema bool `json:"useTopicSchema,omitempty"`
	// WriteMetadata: Optional. When true, write the subscription name, message_id,
	// publish_time, attributes, and ordering_key to additional columns in the
	// table. The subscription name, message_id, and publish_time fields are put in
	// their own columns while all other message properties (other than data) are
	// written to a JSON object in the attributes column.
	WriteMetadata bool `json:"writeMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DropUnknownFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DropUnknownFields") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigQueryDatasetSource: A reference to a shared dataset. It is an existing
// BigQuery dataset with a collection of objects such as tables and views that
// you want to share with subscribers. When subscriber's subscribe to a
// listing, Analytics Hub creates a linked dataset in the subscriber's project.
// A Linked dataset is an opaque, read-only BigQuery dataset that serves as a
// _symbolic link_ to a shared dataset.
type BigQueryDatasetSource struct {
	// Dataset: Optional. Resource name of the dataset source for this listing.
	// e.g. `projects/myproject/datasets/123`
	Dataset string `json:"dataset,omitempty"`
	// RestrictedExportPolicy: Optional. If set, restricted export policy will be
	// propagated and enforced on the linked dataset.
	RestrictedExportPolicy *RestrictedExportPolicy `json:"restrictedExportPolicy,omitempty"`
	// SelectedResources: Optional. Resource in this dataset that is selectively
	// shared. This field is required for data clean room exchanges.
	SelectedResources []*SelectedResource `json:"selectedResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryDatasetSource) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryDatasetSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudStorageConfig: Configuration for a Cloud Storage subscription.
type CloudStorageConfig struct {
	// AvroConfig: Optional. If set, message data will be written to Cloud Storage
	// in Avro format.
	AvroConfig *AvroConfig `json:"avroConfig,omitempty"`
	// Bucket: Required. User-provided name for the Cloud Storage bucket. The
	// bucket must be created by the user. The bucket name must be without any
	// prefix like "gs://". See the [bucket naming requirements]
	// (https://cloud.google.com/storage/docs/buckets#naming).
	Bucket string `json:"bucket,omitempty"`
	// FilenameDatetimeFormat: Optional. User-provided format string specifying how
	// to represent datetimes in Cloud Storage filenames. See the datetime format
	// guidance
	// (https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
	FilenameDatetimeFormat string `json:"filenameDatetimeFormat,omitempty"`
	// FilenamePrefix: Optional. User-provided prefix for Cloud Storage filename.
	// See the object naming requirements
	// (https://cloud.google.com/storage/docs/objects#naming).
	FilenamePrefix string `json:"filenamePrefix,omitempty"`
	// FilenameSuffix: Optional. User-provided suffix for Cloud Storage filename.
	// See the object naming requirements
	// (https://cloud.google.com/storage/docs/objects#naming). Must not end in "/".
	FilenameSuffix string `json:"filenameSuffix,omitempty"`
	// MaxBytes: Optional. The maximum bytes that can be written to a Cloud Storage
	// file before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit
	// may be exceeded in cases where messages are larger than the limit.
	MaxBytes int64 `json:"maxBytes,omitempty,string"`
	// MaxDuration: Optional. File batching settings. If no max_duration setting is
	// specified, a max_duration of 5 minutes will be set by default. max_duration
	// is required regardless of whether other file batching settings are
	// specified. The maximum duration that can elapse before a new Cloud Storage
	// file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
	// exceed the subscription's acknowledgement deadline.
	MaxDuration string `json:"maxDuration,omitempty"`
	// MaxMessages: Optional. The maximum number of messages that can be written to
	// a Cloud Storage file before a new file is created. Min 1000 messages.
	MaxMessages int64 `json:"maxMessages,omitempty,string"`
	// ServiceAccountEmail: Optional. The service account to use to write to Cloud
	// Storage. The subscription creator or updater that specifies this field must
	// have `iam.serviceAccounts.actAs` permission on the service account. If not
	// specified, the Pub/Sub service agent
	// (https://cloud.google.com/iam/docs/service-agents),
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com, is used.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// TextConfig: Optional. If set, message data will be written to Cloud Storage
	// in text format.
	TextConfig *TextConfig `json:"textConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvroConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvroConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CloudStorageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataExchange: A data exchange is a container that lets you share data. Along
// with the descriptive information about the data exchange, it contains
// listings that reference shared datasets.
type DataExchange struct {
	// Description: Optional. Description of the data exchange. The description
	// must not contain Unicode non-characters as well as C0 and C1 control codes
	// except tabs (HT), new lines (LF), carriage returns (CR), and page breaks
	// (FF). Default value is an empty string. Max length: 2000 bytes.
	Description string `json:"description,omitempty"`
	// DiscoveryType: Optional. Type of discovery on the discovery page for all the
	// listings under this exchange. Updating this field also updates (overwrites)
	// the discovery_type field for all the listings under this exchange.
	//
	// Possible values:
	//   "DISCOVERY_TYPE_UNSPECIFIED" - Unspecified. Defaults to
	// DISCOVERY_TYPE_PRIVATE.
	//   "DISCOVERY_TYPE_PRIVATE" - The Data exchange/listing can be discovered in
	// the 'Private' results list.
	//   "DISCOVERY_TYPE_PUBLIC" - The Data exchange/listing can be discovered in
	// the 'Public' results list.
	DiscoveryType string `json:"discoveryType,omitempty"`
	// DisplayName: Required. Human-readable display name of the data exchange. The
	// display name must contain only Unicode letters, numbers (0-9), underscores
	// (_), dashes (-), spaces ( ), ampersands (&) and must not start or end with
	// spaces. Default value is an empty string. Max length: 63 bytes.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. Documentation describing the data exchange.
	Documentation string `json:"documentation,omitempty"`
	// Icon: Optional. Base64 encoded image representing the data exchange. Max
	// Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
	// only performs validation on size of the encoded data. Note: For byte fields,
	// the content of the fields are base64-encoded (which increases the size of
	// the data by 33-36%) when using JSON on the wire.
	Icon string `json:"icon,omitempty"`
	// ListingCount: Output only. Number of listings contained in the data
	// exchange.
	ListingCount int64 `json:"listingCount,omitempty"`
	// LogLinkedDatasetQueryUserEmail: Optional. By default, false. If true, the
	// DataExchange has an email sharing mandate enabled.
	LogLinkedDatasetQueryUserEmail bool `json:"logLinkedDatasetQueryUserEmail,omitempty"`
	// Name: Output only. The resource name of the data exchange. e.g.
	// `projects/myproject/locations/us/dataExchanges/123`.
	Name string `json:"name,omitempty"`
	// PrimaryContact: Optional. Email or URL of the primary point of contact of
	// the data exchange. Max Length: 1000 bytes.
	PrimaryContact string `json:"primaryContact,omitempty"`
	// SharingEnvironmentConfig: Optional. Configurable data sharing environment
	// option for a data exchange.
	SharingEnvironmentConfig *SharingEnvironmentConfig `json:"sharingEnvironmentConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataExchange) MarshalJSON() ([]byte, error) {
	type NoMethod DataExchange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataProvider: Contains details of the data provider.
type DataProvider struct {
	// Name: Optional. Name of the data provider.
	Name string `json:"name,omitempty"`
	// PrimaryContact: Optional. Email or URL of the data provider. Max Length:
	// 1000 bytes.
	PrimaryContact string `json:"primaryContact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataProvider) MarshalJSON() ([]byte, error) {
	type NoMethod DataProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DcrExchangeConfig: Data Clean Room (DCR), used for privacy-safe and secured
// data sharing.
type DcrExchangeConfig struct {
	// SingleLinkedDatasetPerCleanroom: Output only. If True, when subscribing to
	// this DCR, it will create only one linked dataset containing all resources
	// shared within the cleanroom. If False, when subscribing to this DCR, it will
	// create 1 linked dataset per listing. This is not configurable, and by
	// default, all new DCRs will have the restriction set to True.
	SingleLinkedDatasetPerCleanroom bool `json:"singleLinkedDatasetPerCleanroom,omitempty"`
	// SingleSelectedResourceSharingRestriction: Output only. If True, this DCR
	// restricts the contributors to sharing only a single resource in a Listing.
	// And no two resources should have the same IDs. So if a contributor adds a
	// view with a conflicting name, the CreateListing API will reject the request.
	// if False, the data contributor can publish an entire dataset (as before).
	// This is not configurable, and by default, all new DCRs will have the
	// restriction set to True.
	SingleSelectedResourceSharingRestriction bool `json:"singleSelectedResourceSharingRestriction,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "SingleLinkedDatasetPerCleanroom") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SingleLinkedDatasetPerCleanroom")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DcrExchangeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DcrExchangeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeadLetterPolicy: Dead lettering is done on a best effort basis. The same
// message might be dead lettered multiple times. If validation on any of the
// fields fails at subscription creation/updation, the create/update
// subscription request will fail.
type DeadLetterPolicy struct {
	// DeadLetterTopic: Optional. The name of the topic to which dead letter
	// messages should be published. Format is
	// `projects/{project}/topics/{topic}`.The Pub/Sub service account associated
	// with the enclosing subscription's parent project (i.e.,
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
	// permission to Publish() to this topic. The operation will fail if the topic
	// does not exist. Users should ensure that there is a subscription attached to
	// this topic since messages published to a topic with no subscriptions are
	// lost.
	DeadLetterTopic string `json:"deadLetterTopic,omitempty"`
	// MaxDeliveryAttempts: Optional. The maximum number of delivery attempts for
	// any message. The value must be between 5 and 100. The number of delivery
	// attempts is defined as 1 + (the sum of number of NACKs and number of times
	// the acknowledgement deadline has been exceeded for the message). A NACK is
	// any call to ModifyAckDeadline with a 0 deadline. Note that client libraries
	// may automatically extend ack_deadlines. This field will be honored on a best
	// effort basis. If this parameter is 0, a default value of 5 is used.
	MaxDeliveryAttempts int64 `json:"maxDeliveryAttempts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeadLetterTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeadLetterTopic") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeadLetterPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod DeadLetterPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultExchangeConfig: Default Analytics Hub data exchange, used for secured
// data sharing.
type DefaultExchangeConfig struct {
}

// DestinationDataset: Defines the destination bigquery dataset.
type DestinationDataset struct {
	// DatasetReference: Required. A reference that identifies the destination
	// dataset.
	DatasetReference *DestinationDatasetReference `json:"datasetReference,omitempty"`
	// Description: Optional. A user-friendly description of the dataset.
	Description string `json:"description,omitempty"`
	// FriendlyName: Optional. A descriptive name for the dataset.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Labels: Optional. The labels associated with this dataset. You can use these
	// to organize and group your datasets. You can set this property when
	// inserting or updating a dataset. See
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels for
	// more information.
	Labels map[string]string `json:"labels,omitempty"`
	// Location: Required. The geographic location where the dataset should reside.
	// See https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	Location string `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetReference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetReference") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationDataset) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DestinationDatasetReference struct {
	// DatasetId: Required. A unique ID for this dataset, without the project name.
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores
	// (_). The maximum length is 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: Required. The ID of the project containing this dataset.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationDatasetReference) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationDatasetReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DestinationPubSubSubscription: Defines the destination Pub/Sub subscription.
type DestinationPubSubSubscription struct {
	// PubsubSubscription: Required. Destination Pub/Sub subscription resource.
	PubsubSubscription *GooglePubsubV1Subscription `json:"pubsubSubscription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubSubscription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubSubscription") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationPubSubSubscription) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationPubSubSubscription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExpirationPolicy: A policy that specifies the conditions for resource
// expiration (i.e., automatic resource deletion).
type ExpirationPolicy struct {
	// Ttl: Optional. Specifies the "time-to-live" duration for an associated
	// resource. The resource expires if it is not active for a period of `ttl`.
	// The definition of "activity" depends on the type of the associated resource.
	// The minimum and maximum allowed values for `ttl` depend on the type of the
	// associated resource, as well. If `ttl` is not set, the associated resource
	// never expires.
	Ttl string `json:"ttl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ttl") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ttl") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExpirationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ExpirationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetIamPolicyRequest: Request message for `GetIamPolicy` method.
type GetIamPolicyRequest struct {
	// Options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
	// `GetIamPolicy`.
	Options *GetPolicyOptions `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetPolicyOptions: Encapsulates settings provided to GetIamPolicy.
type GetPolicyOptions struct {
	// RequestedPolicyVersion: Optional. The maximum policy version that will be
	// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
	// an invalid value will be rejected. Requests for policies with any
	// conditional role bindings must specify version 3. Policies with no
	// conditional role bindings may specify any valid value or leave the field
	// unset. The policy in the response might use the policy version that you
	// specified, or it might use a lower policy version. For example, if you
	// specify version 3, but the policy has no conditional role bindings, the
	// response uses version 1. To learn which resources support conditions in
	// their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	RequestedPolicyVersion int64 `json:"requestedPolicyVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetPolicyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GetPolicyOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfo: Commercial info
// contains the information about the commercial data products associated with
// the listing.
type GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfo struct {
	// CloudMarketplace: Output only. Details of the Marketplace Data Product
	// associated with the Listing.
	CloudMarketplace *GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfoGoogleCloudMarketplaceInfo `json:"cloudMarketplace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudMarketplace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudMarketplace") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfoGoogleCloudMarketplaceI
// nfo: Specifies the details of the Marketplace Data Product associated with
// the Listing.
type GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfoGoogleCloudMarketplaceInfo struct {
	// CommercialState: Output only. Commercial state of the Marketplace Data
	// Product.
	//
	// Possible values:
	//   "COMMERCIAL_STATE_UNSPECIFIED" - Commercialization is incomplete and
	// cannot be used.
	//   "ONBOARDING" - Commercialization has been initialized.
	//   "ACTIVE" - Commercialization is complete and available for use.
	CommercialState string `json:"commercialState,omitempty"`
	// Service: Output only. Resource name of the commercial service associated
	// with the Marketplace Data Product. e.g. example.com
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommercialState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommercialState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfoGoogleCloudMarketplaceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfoGoogleCloudMarketplaceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfo: Commercial info
// metadata for this subscription.
type GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfo struct {
	// CloudMarketplace: Output only. This is set when the subscription is
	// commercialised via Cloud Marketplace.
	CloudMarketplace *GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfoGoogleCloudMarketplaceInfo `json:"cloudMarketplace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudMarketplace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudMarketplace") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfoGoogleCloudMarketp
// laceInfo: Cloud Marketplace commercial metadata for this subscription.
type GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfoGoogleCloudMarketplaceInfo struct {
	// Order: Resource name of the Marketplace Order.
	Order string `json:"order,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Order") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Order") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfoGoogleCloudMarketplaceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfoGoogleCloudMarketplaceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePubsubV1Subscription: Defines the destination Pub/Sub subscription. If
// none of `push_config`, `bigquery_config`, `cloud_storage_config`,
// `pubsub_export_config`, or `pubsublite_export_config` is set, then the
// subscriber will pull and ack messages using API methods. At most one of
// these fields may be set.
type GooglePubsubV1Subscription struct {
	// AckDeadlineSeconds: Optional. The approximate amount of time (on a
	// best-effort basis) Pub/Sub waits for the subscriber to acknowledge receipt
	// before resending the message. In the interval after the message is delivered
	// and before it is acknowledged, it is considered to be _outstanding_. During
	// that time period, the message will not be redelivered (on a best-effort
	// basis). For pull subscriptions, this value is used as the initial value for
	// the ack deadline. To override this value for a given message, call
	// `ModifyAckDeadline` with the corresponding `ack_id` if using non-streaming
	// pull or send the `ack_id` in a `StreamingModifyAckDeadlineRequest` if using
	// streaming pull. The minimum custom deadline you can specify is 10 seconds.
	// The maximum custom deadline you can specify is 600 seconds (10 minutes). If
	// this parameter is 0, a default value of 10 seconds is used. For push
	// delivery, this value is also used to set the request timeout for the call to
	// the push endpoint. If the subscriber never acknowledges the message, the
	// Pub/Sub system will eventually redeliver the message.
	AckDeadlineSeconds int64 `json:"ackDeadlineSeconds,omitempty"`
	// BigqueryConfig: Optional. If delivery to BigQuery is used with this
	// subscription, this field is used to configure it.
	BigqueryConfig *BigQueryConfig `json:"bigqueryConfig,omitempty"`
	// CloudStorageConfig: Optional. If delivery to Google Cloud Storage is used
	// with this subscription, this field is used to configure it.
	CloudStorageConfig *CloudStorageConfig `json:"cloudStorageConfig,omitempty"`
	// DeadLetterPolicy: Optional. A policy that specifies the conditions for dead
	// lettering messages in this subscription. If dead_letter_policy is not set,
	// dead lettering is disabled. The Pub/Sub service account associated with this
	// subscriptions's parent project (i.e.,
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
	// permission to Acknowledge() messages on this subscription.
	DeadLetterPolicy *DeadLetterPolicy `json:"deadLetterPolicy,omitempty"`
	// Detached: Optional. Indicates whether the subscription is detached from its
	// topic. Detached subscriptions don't receive messages from their topic and
	// don't retain any backlog. `Pull` and `StreamingPull` requests will return
	// FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
	// the endpoint will not be made.
	Detached bool `json:"detached,omitempty"`
	// EnableExactlyOnceDelivery: Optional. If true, Pub/Sub provides the following
	// guarantees for the delivery of a message with a given value of `message_id`
	// on this subscription: * The message sent to a subscriber is guaranteed not
	// to be resent before the message's acknowledgement deadline expires. * An
	// acknowledged message will not be resent to a subscriber. Note that
	// subscribers may still receive multiple copies of a message when
	// `enable_exactly_once_delivery` is true if the message was published multiple
	// times by a publisher client. These copies are considered distinct by Pub/Sub
	// and have distinct `message_id` values.
	EnableExactlyOnceDelivery bool `json:"enableExactlyOnceDelivery,omitempty"`
	// EnableMessageOrdering: Optional. If true, messages published with the same
	// `ordering_key` in `PubsubMessage` will be delivered to the subscribers in
	// the order in which they are received by the Pub/Sub system. Otherwise, they
	// may be delivered in any order.
	EnableMessageOrdering bool `json:"enableMessageOrdering,omitempty"`
	// ExpirationPolicy: Optional. A policy that specifies the conditions for this
	// subscription's expiration. A subscription is considered active as long as
	// any connected subscriber is successfully consuming messages from the
	// subscription or is issuing operations on the subscription. If
	// `expiration_policy` is not set, a *default policy* with `ttl` of 31 days
	// will be used. The minimum allowed value for `expiration_policy.ttl` is 1
	// day. If `expiration_policy` is set, but `expiration_policy.ttl` is not set,
	// the subscription never expires.
	ExpirationPolicy *ExpirationPolicy `json:"expirationPolicy,omitempty"`
	// Filter: Optional. An expression written in the Pub/Sub filter language
	// (https://cloud.google.com/pubsub/docs/filtering). If non-empty, then only
	// `PubsubMessage`s whose `attributes` field matches the filter are delivered
	// on this subscription. If empty, then no messages are filtered out.
	Filter string `json:"filter,omitempty"`
	// Labels: Optional. See Creating and managing labels
	// (https://cloud.google.com/pubsub/docs/labels).
	Labels map[string]string `json:"labels,omitempty"`
	// MessageRetentionDuration: Optional. How long to retain unacknowledged
	// messages in the subscription's backlog, from the moment a message is
	// published. If `retain_acked_messages` is true, then this also configures the
	// retention of acknowledged messages, and thus configures how far back in time
	// a `Seek` can be done. Defaults to 7 days. Cannot be more than 31 days or
	// less than 10 minutes.
	MessageRetentionDuration string `json:"messageRetentionDuration,omitempty"`
	// MessageTransforms: Optional. Transforms to be applied to messages before
	// they are delivered to subscribers. Transforms are applied in the order
	// specified.
	MessageTransforms []*MessageTransform `json:"messageTransforms,omitempty"`
	// Name: Required. Name of the subscription. Format is
	// `projects/{project}/subscriptions/{sub}`.
	Name string `json:"name,omitempty"`
	// PushConfig: Optional. If push delivery is used with this subscription, this
	// field is used to configure it.
	PushConfig *PushConfig `json:"pushConfig,omitempty"`
	// RetainAckedMessages: Optional. Indicates whether to retain acknowledged
	// messages. If true, then messages are not expunged from the subscription's
	// backlog, even if they are acknowledged, until they fall out of the
	// `message_retention_duration` window. This must be true if you would like to
	// [`Seek` to a timestamp]
	// (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in the
	// past to replay previously-acknowledged messages.
	RetainAckedMessages bool `json:"retainAckedMessages,omitempty"`
	// RetryPolicy: Optional. A policy that specifies how Pub/Sub retries message
	// delivery for this subscription. If not set, the default retry policy is
	// applied. This generally implies that messages will be retried as soon as
	// possible for healthy subscribers. RetryPolicy will be triggered on NACKs or
	// acknowledgement deadline exceeded events for a given message.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AckDeadlineSeconds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AckDeadlineSeconds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePubsubV1Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePubsubV1Subscription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JavaScriptUDF: User-defined JavaScript function that can transform or filter
// a Pub/Sub message.
type JavaScriptUDF struct {
	// Code: Required. JavaScript code that contains a function `function_name`
	// with the below signature: ``` /** * Transforms a Pub/Sub message. * @return
	// {(Object)>|null)} - To * filter a message, return `null`. To transform a
	// message return a map * with the following keys: * - (required) 'data' :
	// {string} * - (optional) 'attributes' : {Object} * Returning empty
	// `attributes` will remove all attributes from the * message. * * @param
	// {(Object)>} Pub/Sub * message. Keys: * - (required) 'data' : {string} * -
	// (required) 'attributes' : {Object} * * @param {Object} metadata - Pub/Sub
	// message metadata. * Keys: * - (required) 'message_id' : {string} * -
	// (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format * -
	// (optional) 'ordering_key': {string} */ function (message, metadata) { } ```
	Code string `json:"code,omitempty"`
	// FunctionName: Required. Name of the JavasScript function that should applied
	// to Pub/Sub messages.
	FunctionName string `json:"functionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JavaScriptUDF) MarshalJSON() ([]byte, error) {
	type NoMethod JavaScriptUDF
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LinkedResource: Reference to a linked resource tracked by this Subscription.
type LinkedResource struct {
	// LinkedDataset: Output only. Name of the linked dataset, e.g.
	// projects/subscriberproject/datasets/linked_dataset
	LinkedDataset string `json:"linkedDataset,omitempty"`
	// LinkedPubsubSubscription: Output only. Name of the Pub/Sub subscription,
	// e.g. projects/subscriberproject/subscriptions/subscriptions/sub_id
	LinkedPubsubSubscription string `json:"linkedPubsubSubscription,omitempty"`
	// Listing: Output only. Listing for which linked resource is created.
	Listing string `json:"listing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LinkedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LinkedDataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkedResource) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDataExchangesResponse: Message for response to the list of data
// exchanges.
type ListDataExchangesResponse struct {
	// DataExchanges: The list of data exchanges.
	DataExchanges []*DataExchange `json:"dataExchanges,omitempty"`
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataExchanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataExchanges") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDataExchangesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDataExchangesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListListingsResponse: Message for response to the list of Listings.
type ListListingsResponse struct {
	// Listings: The list of Listing.
	Listings []*Listing `json:"listings,omitempty"`
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Listings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Listings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListListingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListListingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOrgDataExchangesResponse: Message for response to listing data exchanges
// in an organization and location.
type ListOrgDataExchangesResponse struct {
	// DataExchanges: The list of data exchanges.
	DataExchanges []*DataExchange `json:"dataExchanges,omitempty"`
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataExchanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataExchanges") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOrgDataExchangesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOrgDataExchangesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListQueryTemplatesResponse: Message for response to the list of
// QueryTemplates.
type ListQueryTemplatesResponse struct {
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QueryTemplates: The list of QueryTemplates.
	QueryTemplates []*QueryTemplate `json:"queryTemplates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListQueryTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListQueryTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSharedResourceSubscriptionsResponse: Message for response to the listing
// of shared resource subscriptions.
type ListSharedResourceSubscriptionsResponse struct {
	// NextPageToken: Next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SharedResourceSubscriptions: The list of subscriptions.
	SharedResourceSubscriptions []*Subscription `json:"sharedResourceSubscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSharedResourceSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSharedResourceSubscriptionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSubscriptionsResponse: Message for response to the listing of
// subscriptions.
type ListSubscriptionsResponse struct {
	// NextPageToken: Next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Subscriptions: The list of subscriptions.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSubscriptionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Listing: A listing is what gets published into a data exchange that a
// subscriber can subscribe to. It contains a reference to the data source
// along with descriptive information that will help subscribers find and
// subscribe the data.
type Listing struct {
	// AllowOnlyMetadataSharing: Optional. If true, the listing is only available
	// to get the resource metadata. Listing is non subscribable.
	AllowOnlyMetadataSharing bool `json:"allowOnlyMetadataSharing,omitempty"`
	// BigqueryDataset: Shared dataset i.e. BigQuery dataset source.
	BigqueryDataset *BigQueryDatasetSource `json:"bigqueryDataset,omitempty"`
	// Categories: Optional. Categories of the listing. Up to five categories are
	// allowed.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED"
	//   "CATEGORY_OTHERS"
	//   "CATEGORY_ADVERTISING_AND_MARKETING"
	//   "CATEGORY_COMMERCE"
	//   "CATEGORY_CLIMATE_AND_ENVIRONMENT"
	//   "CATEGORY_DEMOGRAPHICS"
	//   "CATEGORY_ECONOMICS"
	//   "CATEGORY_EDUCATION"
	//   "CATEGORY_ENERGY"
	//   "CATEGORY_FINANCIAL"
	//   "CATEGORY_GAMING"
	//   "CATEGORY_GEOSPATIAL"
	//   "CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE"
	//   "CATEGORY_MEDIA"
	//   "CATEGORY_PUBLIC_SECTOR"
	//   "CATEGORY_RETAIL"
	//   "CATEGORY_SPORTS"
	//   "CATEGORY_SCIENCE_AND_RESEARCH"
	//   "CATEGORY_TRANSPORTATION_AND_LOGISTICS"
	//   "CATEGORY_TRAVEL_AND_TOURISM"
	//   "CATEGORY_GOOGLE_EARTH_ENGINE"
	Categories []string `json:"categories,omitempty"`
	// CommercialInfo: Output only. Commercial info contains the information about
	// the commercial data products associated with the listing.
	CommercialInfo *GoogleCloudBigqueryAnalyticshubV1ListingCommercialInfo `json:"commercialInfo,omitempty"`
	// DataProvider: Optional. Details of the data provider who owns the source
	// data.
	DataProvider *DataProvider `json:"dataProvider,omitempty"`
	// Description: Optional. Short description of the listing. The description
	// must not contain Unicode non-characters and C0 and C1 control codes except
	// tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
	// Default value is an empty string. Max length: 2000 bytes.
	Description string `json:"description,omitempty"`
	// DiscoveryType: Optional. Type of discovery of the listing on the discovery
	// page.
	//
	// Possible values:
	//   "DISCOVERY_TYPE_UNSPECIFIED" - Unspecified. Defaults to
	// DISCOVERY_TYPE_PRIVATE.
	//   "DISCOVERY_TYPE_PRIVATE" - The Data exchange/listing can be discovered in
	// the 'Private' results list.
	//   "DISCOVERY_TYPE_PUBLIC" - The Data exchange/listing can be discovered in
	// the 'Public' results list.
	DiscoveryType string `json:"discoveryType,omitempty"`
	// DisplayName: Required. Human-readable display name of the listing. The
	// display name must contain only Unicode letters, numbers (0-9), underscores
	// (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with
	// spaces. Default value is an empty string. Max length: 63 bytes.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. Documentation describing the listing.
	Documentation string `json:"documentation,omitempty"`
	// Icon: Optional. Base64 encoded image representing the listing. Max Size:
	// 3.0MiB Expected image dimensions are 512x512 pixels, however the API only
	// performs validation on size of the encoded data. Note: For byte fields, the
	// contents of the field are base64-encoded (which increases the size of the
	// data by 33-36%) when using JSON on the wire.
	Icon string `json:"icon,omitempty"`
	// LogLinkedDatasetQueryUserEmail: Optional. By default, false. If true, the
	// Listing has an email sharing mandate enabled.
	LogLinkedDatasetQueryUserEmail bool `json:"logLinkedDatasetQueryUserEmail,omitempty"`
	// Name: Output only. The resource name of the listing. e.g.
	// `projects/myproject/locations/us/dataExchanges/123/listings/456`
	Name string `json:"name,omitempty"`
	// PrimaryContact: Optional. Email or URL of the primary point of contact of
	// the listing. Max Length: 1000 bytes.
	PrimaryContact string `json:"primaryContact,omitempty"`
	// Publisher: Optional. Details of the publisher who owns the listing and who
	// can share the source data.
	Publisher *Publisher `json:"publisher,omitempty"`
	// PubsubTopic: Pub/Sub topic source.
	PubsubTopic *PubSubTopicSource `json:"pubsubTopic,omitempty"`
	// RequestAccess: Optional. Email or URL of the request access of the listing.
	// Subscribers can use this reference to request access. Max Length: 1000
	// bytes.
	RequestAccess string `json:"requestAccess,omitempty"`
	// ResourceType: Output only. Listing shared asset type.
	//
	// Possible values:
	//   "SHARED_RESOURCE_TYPE_UNSPECIFIED" - Not specified.
	//   "BIGQUERY_DATASET" - BigQuery Dataset Asset.
	//   "PUBSUB_TOPIC" - Pub/Sub Topic Asset.
	ResourceType string `json:"resourceType,omitempty"`
	// RestrictedExportConfig: Optional. If set, restricted export configuration
	// will be propagated and enforced on the linked dataset.
	RestrictedExportConfig *RestrictedExportConfig `json:"restrictedExportConfig,omitempty"`
	// State: Output only. Current state of the listing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "ACTIVE" - Subscribable state. Users with dataexchange.listings.subscribe
	// permission can subscribe to this listing.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowOnlyMetadataSharing")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowOnlyMetadataSharing") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Listing) MarshalJSON() ([]byte, error) {
	type NoMethod Listing
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MessageTransform: All supported message transforms types.
type MessageTransform struct {
	// Disabled: Optional. If true, the transform is disabled and will not be
	// applied to messages. Defaults to `false`.
	Disabled bool `json:"disabled,omitempty"`
	// Enabled: Optional. This field is deprecated, use the `disabled` field to
	// disable transforms.
	Enabled bool `json:"enabled,omitempty"`
	// JavascriptUdf: Optional. JavaScript User Defined Function. If multiple
	// JavaScriptUDF's are specified on a resource, each must have a unique
	// `function_name`.
	JavascriptUdf *JavaScriptUDF `json:"javascriptUdf,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MessageTransform) MarshalJSON() ([]byte, error) {
	type NoMethod MessageTransform
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NoWrapper: Sets the `data` field as the HTTP body for delivery.
type NoWrapper struct {
	// WriteMetadata: Optional. When true, writes the Pub/Sub message metadata to
	// `x-goog-pubsub-:` headers of the HTTP request. Writes the Pub/Sub message
	// attributes to `:` headers of the HTTP request.
	WriteMetadata bool `json:"writeMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WriteMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WriteMetadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NoWrapper) MarshalJSON() ([]byte, error) {
	type NoMethod NoWrapper
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OidcToken: Contains information needed for generating an OpenID Connect
// token (https://developers.google.com/identity/protocols/OpenIDConnect).
type OidcToken struct {
	// Audience: Optional. Audience to be used when generating OIDC token. The
	// audience claim identifies the recipients that the JWT is intended for. The
	// audience value is a single case-sensitive string. Having multiple values
	// (array) for the audience field is not supported. More info about the OIDC
	// JWT token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
	// Note: if not specified, the Push endpoint URL will be used.
	Audience string `json:"audience,omitempty"`
	// ServiceAccountEmail: Optional. Service account email
	// (https://cloud.google.com/iam/docs/service-accounts) used for generating the
	// OIDC token. For more information on setting up authentication, see Push
	// subscriptions (https://cloud.google.com/pubsub/docs/push).
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audience") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audience") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OidcToken) MarshalJSON() ([]byte, error) {
	type NoMethod OidcToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of a long-running operation in
// Analytics Hub.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have Operation.error value with a google.rpc.Status.code of
	// 1, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubSubTopicSource: Pub/Sub topic source.
type PubSubTopicSource struct {
	// DataAffinityRegions: Optional. Region hint on where the data might be
	// published. Data affinity regions are modifiable. See
	// https://cloud.google.com/about/locations for full listing of possible Cloud
	// regions.
	DataAffinityRegions []string `json:"dataAffinityRegions,omitempty"`
	// Topic: Required. Resource name of the Pub/Sub topic source for this listing.
	// e.g. projects/myproject/topics/topicId
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataAffinityRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataAffinityRegions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PubSubTopicSource) MarshalJSON() ([]byte, error) {
	type NoMethod PubSubTopicSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Publisher: Contains details of the listing publisher.
type Publisher struct {
	// Name: Optional. Name of the listing publisher.
	Name string `json:"name,omitempty"`
	// PrimaryContact: Optional. Email or URL of the listing publisher. Max Length:
	// 1000 bytes.
	PrimaryContact string `json:"primaryContact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Publisher) MarshalJSON() ([]byte, error) {
	type NoMethod Publisher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubsubWrapper: The payload to the push endpoint is in the form of the JSON
// representation of a PubsubMessage
// (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
type PubsubWrapper struct {
}

// PushConfig: Configuration for a push delivery endpoint.
type PushConfig struct {
	// Attributes: Optional. Endpoint configuration attributes that can be used to
	// control different aspects of the message delivery. The only currently
	// supported attribute is `x-goog-version`, which you can use to change the
	// format of the pushed message. This attribute indicates the version of the
	// data expected by the endpoint. This controls the shape of the pushed message
	// (i.e., its fields and metadata). If not present during the
	// `CreateSubscription` call, it will default to the version of the Pub/Sub API
	// used to make such call. If not present in a `ModifyPushConfig` call, its
	// value will not be changed. `GetSubscription` calls will always return a
	// valid version, even if the subscription was created without this attribute.
	// The only supported values for the `x-goog-version` attribute are: *
	// `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API. * `v1`
	// or `v1beta2`: uses the push format defined in the v1 Pub/Sub API. For
	// example: `attributes { "x-goog-version": "v1" }`
	Attributes map[string]string `json:"attributes,omitempty"`
	// NoWrapper: Optional. When set, the payload to the push endpoint is not
	// wrapped.
	NoWrapper *NoWrapper `json:"noWrapper,omitempty"`
	// OidcToken: Optional. If specified, Pub/Sub will generate and attach an OIDC
	// JWT token as an `Authorization` header in the HTTP request for every pushed
	// message.
	OidcToken *OidcToken `json:"oidcToken,omitempty"`
	// PubsubWrapper: Optional. When set, the payload to the push endpoint is in
	// the form of the JSON representation of a PubsubMessage
	// (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
	PubsubWrapper *PubsubWrapper `json:"pubsubWrapper,omitempty"`
	// PushEndpoint: Optional. A URL locating the endpoint to which messages should
	// be pushed. For example, a Webhook endpoint might use
	// `https://example.com/push`.
	PushEndpoint string `json:"pushEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PushConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PushConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryTemplate: A query template is a container for sharing table-valued
// functions defined by contributors in a data clean room.
type QueryTemplate struct {
	// CreateTime: Output only. Timestamp when the QueryTemplate was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Short description of the QueryTemplate. The
	// description must not contain Unicode non-characters and C0 and C1 control
	// codes except tabs (HT), new lines (LF), carriage returns (CR), and page
	// breaks (FF). Default value is an empty string. Max length: 2000 bytes.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Human-readable display name of the QueryTemplate. The
	// display name must contain only Unicode letters, numbers (0-9), underscores
	// (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with
	// spaces. Default value is an empty string. Max length: 63 bytes.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. Documentation describing the QueryTemplate.
	Documentation string `json:"documentation,omitempty"`
	// Name: Output only. The resource name of the QueryTemplate. e.g.
	// `projects/myproject/locations/us/dataExchanges/123/queryTemplates/456`
	Name string `json:"name,omitempty"`
	// PrimaryContact: Optional. Email or URL of the primary point of contact of
	// the QueryTemplate. Max Length: 1000 bytes.
	PrimaryContact string `json:"primaryContact,omitempty"`
	// Proposer: Optional. Will be deprecated. Email or URL of the primary point of
	// contact of the QueryTemplate. Max Length: 1000 bytes.
	Proposer string `json:"proposer,omitempty"`
	// Routine: Optional. The routine associated with the QueryTemplate.
	Routine *Routine `json:"routine,omitempty"`
	// State: Output only. The QueryTemplate lifecycle state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "DRAFTED" - The QueryTemplate is in draft state.
	//   "PENDING" - The QueryTemplate is in pending state.
	//   "DELETED" - The QueryTemplate is in deleted state.
	//   "APPROVED" - The QueryTemplate is in approved state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when the QueryTemplate was last modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod QueryTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RefreshSubscriptionRequest: Message for refreshing a subscription.
type RefreshSubscriptionRequest struct {
}

// RefreshSubscriptionResponse: Message for response when you refresh a
// subscription.
type RefreshSubscriptionResponse struct {
	// Subscription: The refreshed subscription resource.
	Subscription *Subscription `json:"subscription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Subscription") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RefreshSubscriptionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RefreshSubscriptionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestrictedExportConfig: Restricted export config, used to configure
// restricted export on linked dataset.
type RestrictedExportConfig struct {
	// Enabled: Optional. If true, enable restricted export.
	Enabled bool `json:"enabled,omitempty"`
	// RestrictDirectTableAccess: Output only. If true, restrict direct table
	// access(read api/tabledata.list) on linked table.
	RestrictDirectTableAccess bool `json:"restrictDirectTableAccess,omitempty"`
	// RestrictQueryResult: Optional. If true, restrict export of query result
	// derived from restricted linked dataset table.
	RestrictQueryResult bool `json:"restrictQueryResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestrictedExportConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictedExportConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestrictedExportPolicy: Restricted export policy used to configure
// restricted export on linked dataset.
type RestrictedExportPolicy struct {
	// Enabled: Optional. If true, enable restricted export.
	Enabled bool `json:"enabled,omitempty"`
	// RestrictDirectTableAccess: Optional. If true, restrict direct table access
	// (read api/tabledata.list) on linked table.
	RestrictDirectTableAccess bool `json:"restrictDirectTableAccess,omitempty"`
	// RestrictQueryResult: Optional. If true, restrict export of query result
	// derived from restricted linked dataset table.
	RestrictQueryResult bool `json:"restrictQueryResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestrictedExportPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictedExportPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RetryPolicy: A policy that specifies how Pub/Sub retries message delivery.
// Retry delay will be exponential based on provided minimum and maximum
// backoffs. https://en.wikipedia.org/wiki/Exponential_backoff. RetryPolicy
// will be triggered on NACKs or acknowledgement deadline exceeded events for a
// given message. Retry Policy is implemented on a best effort basis. At times,
// the delay between consecutive deliveries may not match the configuration.
// That is, delay can be more or less than configured backoff.
type RetryPolicy struct {
	// MaximumBackoff: Optional. The maximum delay between consecutive deliveries
	// of a given message. Value should be between 0 and 600 seconds. Defaults to
	// 600 seconds.
	MaximumBackoff string `json:"maximumBackoff,omitempty"`
	// MinimumBackoff: Optional. The minimum delay between consecutive deliveries
	// of a given message. Value should be between 0 and 600 seconds. Defaults to
	// 10 seconds.
	MinimumBackoff string `json:"minimumBackoff,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaximumBackoff") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaximumBackoff") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetryPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod RetryPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevokeSubscriptionRequest: Message for revoking a subscription.
type RevokeSubscriptionRequest struct {
	// RevokeCommercial: Optional. If the subscription is commercial then this
	// field must be set to true, otherwise a failure is thrown. This acts as a
	// safety guard to avoid revoking commercial subscriptions accidentally.
	RevokeCommercial bool `json:"revokeCommercial,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RevokeCommercial") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RevokeCommercial") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevokeSubscriptionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RevokeSubscriptionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevokeSubscriptionResponse: Message for response when you revoke a
// subscription. Empty for now.
type RevokeSubscriptionResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Routine: Represents a bigquery routine.
type Routine struct {
	// DefinitionBody: Optional. The definition body of the routine.
	DefinitionBody string `json:"definitionBody,omitempty"`
	// RoutineType: Required. The type of routine.
	//
	// Possible values:
	//   "ROUTINE_TYPE_UNSPECIFIED" - Default value.
	//   "TABLE_VALUED_FUNCTION" - Non-built-in persistent TVF.
	RoutineType string `json:"routineType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefinitionBody") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefinitionBody") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Routine) MarshalJSON() ([]byte, error) {
	type NoMethod Routine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SelectedResource: Resource in this dataset that is selectively shared.
type SelectedResource struct {
	// Routine: Optional. Format: For routine:
	// `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
	// Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
	Routine string `json:"routine,omitempty"`
	// Table: Optional. Format: For table:
	// `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
	// Example:"projects/test_project/datasets/test_dataset/tables/test_table"
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Routine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Routine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SelectedResource) MarshalJSON() ([]byte, error) {
	type NoMethod SelectedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SharingEnvironmentConfig: Sharing environment is a behavior model for
// sharing data within a data exchange. This option is configurable for a data
// exchange.
type SharingEnvironmentConfig struct {
	// DcrExchangeConfig: Data Clean Room (DCR), used for privacy-safe and secured
	// data sharing.
	DcrExchangeConfig *DcrExchangeConfig `json:"dcrExchangeConfig,omitempty"`
	// DefaultExchangeConfig: Default Analytics Hub data exchange, used for secured
	// data sharing.
	DefaultExchangeConfig *DefaultExchangeConfig `json:"defaultExchangeConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DcrExchangeConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DcrExchangeConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SharingEnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SharingEnvironmentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SubmitQueryTemplateRequest: Message for submitting a QueryTemplate.
type SubmitQueryTemplateRequest struct {
}

// SubscribeDataExchangeRequest: Message for subscribing to a Data Exchange.
type SubscribeDataExchangeRequest struct {
	// Destination: Required. The parent resource path of the Subscription. e.g.
	// `projects/subscriberproject/locations/us`
	Destination string `json:"destination,omitempty"`
	// DestinationDataset: Optional. BigQuery destination dataset to create for the
	// subscriber.
	DestinationDataset *DestinationDataset `json:"destinationDataset,omitempty"`
	// SubscriberContact: Email of the subscriber.
	SubscriberContact string `json:"subscriberContact,omitempty"`
	// Subscription: Required. Name of the subscription to create. e.g.
	// `subscription1`
	Subscription string `json:"subscription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubscribeDataExchangeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SubscribeDataExchangeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SubscribeDataExchangeResponse: Message for response when you subscribe to a
// Data Exchange.
type SubscribeDataExchangeResponse struct {
	// Subscription: Subscription object created from this subscribe action.
	Subscription *Subscription `json:"subscription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Subscription") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubscribeDataExchangeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SubscribeDataExchangeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SubscribeListingRequest: Message for subscribing to a listing.
type SubscribeListingRequest struct {
	// DestinationDataset: Input only. BigQuery destination dataset to create for
	// the subscriber.
	DestinationDataset *DestinationDataset `json:"destinationDataset,omitempty"`
	// DestinationPubsubSubscription: Input only. Destination Pub/Sub subscription
	// to create for the subscriber.
	DestinationPubsubSubscription *DestinationPubSubSubscription `json:"destinationPubsubSubscription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubscribeListingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SubscribeListingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SubscribeListingResponse: Message for response when you subscribe to a
// listing.
type SubscribeListingResponse struct {
	// Subscription: Subscription object created from this subscribe action.
	Subscription *Subscription `json:"subscription,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Subscription") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubscribeListingResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SubscribeListingResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Subscription: A subscription represents a subscribers' access to a
// particular set of published data. It contains references to associated
// listings, data exchanges, and linked datasets.
type Subscription struct {
	// CommercialInfo: Output only. This is set if this is a commercial
	// subscription i.e. if this subscription was created from subscribing to a
	// commercial listing.
	CommercialInfo *GoogleCloudBigqueryAnalyticshubV1SubscriptionCommercialInfo `json:"commercialInfo,omitempty"`
	// CreationTime: Output only. Timestamp when the subscription was created.
	CreationTime string `json:"creationTime,omitempty"`
	// DataExchange: Output only. Resource name of the source Data Exchange. e.g.
	// projects/123/locations/us/dataExchanges/456
	DataExchange string `json:"dataExchange,omitempty"`
	// DestinationDataset: Optional. BigQuery destination dataset to create for the
	// subscriber.
	DestinationDataset *DestinationDataset `json:"destinationDataset,omitempty"`
	// LastModifyTime: Output only. Timestamp when the subscription was last
	// modified.
	LastModifyTime string `json:"lastModifyTime,omitempty"`
	// LinkedDatasetMap: Output only. Map of listing resource names to associated
	// linked resource, e.g.
	// projects/123/locations/us/dataExchanges/456/listings/789 ->
	// projects/123/datasets/my_dataset For listing-level subscriptions, this is a
	// map of size 1. Only contains values if state == STATE_ACTIVE.
	LinkedDatasetMap map[string]LinkedResource `json:"linkedDatasetMap,omitempty"`
	// LinkedResources: Output only. Linked resources created in the subscription.
	// Only contains values if state = STATE_ACTIVE.
	LinkedResources []*LinkedResource `json:"linkedResources,omitempty"`
	// Listing: Output only. Resource name of the source Listing. e.g.
	// projects/123/locations/us/dataExchanges/456/listings/789
	Listing string `json:"listing,omitempty"`
	// LogLinkedDatasetQueryUserEmail: Output only. By default, false. If true, the
	// Subscriber agreed to the email sharing mandate that is enabled for
	// DataExchange/Listing.
	LogLinkedDatasetQueryUserEmail bool `json:"logLinkedDatasetQueryUserEmail,omitempty"`
	// Name: Output only. The resource name of the subscription. e.g.
	// `projects/myproject/locations/us/subscriptions/123`.
	Name string `json:"name,omitempty"`
	// OrganizationDisplayName: Output only. Display name of the project of this
	// subscription.
	OrganizationDisplayName string `json:"organizationDisplayName,omitempty"`
	// OrganizationId: Output only. Organization of the project this subscription
	// belongs to.
	OrganizationId string `json:"organizationId,omitempty"`
	// ResourceType: Output only. Listing shared asset type.
	//
	// Possible values:
	//   "SHARED_RESOURCE_TYPE_UNSPECIFIED" - Not specified.
	//   "BIGQUERY_DATASET" - BigQuery Dataset Asset.
	//   "PUBSUB_TOPIC" - Pub/Sub Topic Asset.
	ResourceType string `json:"resourceType,omitempty"`
	// State: Output only. Current state of the subscription.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STATE_ACTIVE" - This subscription is active and the data is accessible.
	//   "STATE_STALE" - The data referenced by this subscription is out of date
	// and should be refreshed. This can happen when a data provider adds or
	// removes datasets.
	//   "STATE_INACTIVE" - This subscription has been cancelled or revoked and the
	// data is no longer accessible.
	State string `json:"state,omitempty"`
	// SubscriberContact: Output only. Email of the subscriber.
	SubscriberContact string `json:"subscriberContact,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommercialInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommercialInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod Subscription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextConfig: Configuration for writing message data in text format. Message
// payloads will be written to files as raw text, separated by a newline.
type TextConfig struct {
}

type OrganizationsLocationsDataExchangesListCall struct {
	s            *Service
	organization string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all data exchanges from projects in a given organization and
// location.
//
//   - organization: The organization resource path of the projects containing
//     DataExchanges. e.g. `organizations/myorg/locations/us`.
func (r *OrganizationsLocationsDataExchangesService) List(organization string) *OrganizationsLocationsDataExchangesListCall {
	c := &OrganizationsLocationsDataExchangesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.organization = organization
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *OrganizationsLocationsDataExchangesListCall) PageSize(pageSize int64) *OrganizationsLocationsDataExchangesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *OrganizationsLocationsDataExchangesListCall) PageToken(pageToken string) *OrganizationsLocationsDataExchangesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDataExchangesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDataExchangesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsDataExchangesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsDataExchangesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDataExchangesListCall) Context(ctx context.Context) *OrganizationsLocationsDataExchangesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDataExchangesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDataExchangesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+organization}/dataExchanges")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"organization": c.organization,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.organizations.locations.dataExchanges.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.organizations.locations.dataExchanges.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOrgDataExchangesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDataExchangesListCall) Do(opts ...googleapi.CallOption) (*ListOrgDataExchangesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOrgDataExchangesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.organizations.locations.dataExchanges.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsDataExchangesListCall) Pages(ctx context.Context, f func(*ListOrgDataExchangesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDataExchangesCreateCall struct {
	s            *Service
	parent       string
	dataexchange *DataExchange
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new data exchange.
//
//   - parent: The parent resource path of the data exchange. e.g.
//     `projects/myproject/locations/us`.
func (r *ProjectsLocationsDataExchangesService) Create(parent string, dataexchange *DataExchange) *ProjectsLocationsDataExchangesCreateCall {
	c := &ProjectsLocationsDataExchangesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dataexchange = dataexchange
	return c
}

// DataExchangeId sets the optional parameter "dataExchangeId": Required. The
// ID of the data exchange. Must contain only Unicode letters, numbers (0-9),
// underscores (_). Max length: 100 bytes.
func (c *ProjectsLocationsDataExchangesCreateCall) DataExchangeId(dataExchangeId string) *ProjectsLocationsDataExchangesCreateCall {
	c.urlParams_.Set("dataExchangeId", dataExchangeId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesCreateCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataexchange)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataExchanges")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataExchange.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesCreateCall) Do(opts ...googleapi.CallOption) (*DataExchange, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataExchange{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing data exchange.
//
//   - name: The full name of the data exchange resource that you want to delete.
//     For example, `projects/myproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesService) Delete(name string) *ProjectsLocationsDataExchangesDeleteCall {
	c := &ProjectsLocationsDataExchangesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a data exchange.
//
//   - name: The resource name of the data exchange. e.g.
//     `projects/myproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesService) Get(name string) *ProjectsLocationsDataExchangesGetCall {
	c := &ProjectsLocationsDataExchangesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesGetCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataExchange.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesGetCall) Do(opts ...googleapi.CallOption) (*DataExchange, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataExchange{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the IAM policy.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDataExchangesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsLocationsDataExchangesGetIamPolicyCall {
	c := &ProjectsLocationsDataExchangesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all data exchanges in a given project and location.
//
//   - parent: The parent resource path of the data exchanges. e.g.
//     `projects/myproject/locations/us`.
func (r *ProjectsLocationsDataExchangesService) List(parent string) *ProjectsLocationsDataExchangesListCall {
	c := &ProjectsLocationsDataExchangesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *ProjectsLocationsDataExchangesListCall) PageSize(pageSize int64) *ProjectsLocationsDataExchangesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *ProjectsLocationsDataExchangesListCall) PageToken(pageToken string) *ProjectsLocationsDataExchangesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataExchanges")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDataExchangesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListCall) Do(opts ...googleapi.CallOption) (*ListDataExchangesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDataExchangesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataExchangesListCall) Pages(ctx context.Context, f func(*ListDataExchangesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDataExchangesListSubscriptionsCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListSubscriptions: Lists all subscriptions on a given Data Exchange or
// Listing.
//
//   - resource: Resource name of the requested target. This resource may be
//     either a Listing or a DataExchange. e.g.
//     projects/123/locations/us/dataExchanges/456 OR e.g.
//     projects/123/locations/us/dataExchanges/456/listings/789.
func (r *ProjectsLocationsDataExchangesService) ListSubscriptions(resource string) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c := &ProjectsLocationsDataExchangesListSubscriptionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// IncludeDeletedSubscriptions sets the optional parameter
// "includeDeletedSubscriptions": If selected, includes deleted subscriptions
// in the response (up to 63 days after deletion).
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) IncludeDeletedSubscriptions(includeDeletedSubscriptions bool) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c.urlParams_.Set("includeDeletedSubscriptions", fmt.Sprint(includeDeletedSubscriptions))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) PageSize(pageSize int64) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) PageToken(pageToken string) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListSubscriptionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:listSubscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listSubscriptions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listSubscriptions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSharedResourceSubscriptionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) Do(opts ...googleapi.CallOption) (*ListSharedResourceSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSharedResourceSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listSubscriptions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataExchangesListSubscriptionsCall) Pages(ctx context.Context, f func(*ListSharedResourceSubscriptionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDataExchangesPatchCall struct {
	s            *Service
	name         string
	dataexchange *DataExchange
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates an existing data exchange.
//
//   - name: Output only. The resource name of the data exchange. e.g.
//     `projects/myproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesService) Patch(name string, dataexchange *DataExchange) *ProjectsLocationsDataExchangesPatchCall {
	c := &ProjectsLocationsDataExchangesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.dataexchange = dataexchange
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// specifies the fields to update in the data exchange resource. The fields
// specified in the `updateMask` are relative to the resource and are not a
// full request.
func (c *ProjectsLocationsDataExchangesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataExchangesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesPatchCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataexchange)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataExchange.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesPatchCall) Do(opts ...googleapi.CallOption) (*DataExchange, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataExchange{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the IAM policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDataExchangesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDataExchangesSetIamPolicyCall {
	c := &ProjectsLocationsDataExchangesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesSubscribeCall struct {
	s                            *Service
	name                         string
	subscribedataexchangerequest *SubscribeDataExchangeRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Subscribe: Creates a Subscription to a Data Clean Room. This is a
// long-running operation as it will create one or more linked datasets. Throws
// a Bad Request error if the Data Exchange does not contain any listings.
//
//   - name: Resource name of the Data Exchange. e.g.
//     `projects/publisherproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesService) Subscribe(name string, subscribedataexchangerequest *SubscribeDataExchangeRequest) *ProjectsLocationsDataExchangesSubscribeCall {
	c := &ProjectsLocationsDataExchangesSubscribeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.subscribedataexchangerequest = subscribedataexchangerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesSubscribeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesSubscribeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesSubscribeCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesSubscribeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesSubscribeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesSubscribeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.subscribedataexchangerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:subscribe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.subscribe", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.subscribe" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesSubscribeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.subscribe", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns the permissions that a caller has.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDataExchangesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDataExchangesTestIamPermissionsCall {
	c := &ProjectsLocationsDataExchangesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsCreateCall struct {
	s          *Service
	parent     string
	listing    *Listing
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new listing.
//
//   - parent: The parent resource path of the listing. e.g.
//     `projects/myproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesListingsService) Create(parent string, listing *Listing) *ProjectsLocationsDataExchangesListingsCreateCall {
	c := &ProjectsLocationsDataExchangesListingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.listing = listing
	return c
}

// ListingId sets the optional parameter "listingId": Required. The ID of the
// listing to create. Must contain only Unicode letters, numbers (0-9),
// underscores (_). Max length: 100 bytes.
func (c *ProjectsLocationsDataExchangesListingsCreateCall) ListingId(listingId string) *ProjectsLocationsDataExchangesListingsCreateCall {
	c.urlParams_.Set("listingId", listingId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsCreateCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.listing)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/listings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Listing.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsCreateCall) Do(opts ...googleapi.CallOption) (*Listing, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Listing{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a listing.
//
//   - name: Resource name of the listing to delete. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/listings/456`.
func (r *ProjectsLocationsDataExchangesListingsService) Delete(name string) *ProjectsLocationsDataExchangesListingsDeleteCall {
	c := &ProjectsLocationsDataExchangesListingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// DeleteCommercial sets the optional parameter "deleteCommercial": If the
// listing is commercial then this field must be set to true, otherwise a
// failure is thrown. This acts as a safety guard to avoid deleting commercial
// listings accidentally.
func (c *ProjectsLocationsDataExchangesListingsDeleteCall) DeleteCommercial(deleteCommercial bool) *ProjectsLocationsDataExchangesListingsDeleteCall {
	c.urlParams_.Set("deleteCommercial", fmt.Sprint(deleteCommercial))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a listing.
//
//   - name: The resource name of the listing. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/listings/456`.
func (r *ProjectsLocationsDataExchangesListingsService) Get(name string) *ProjectsLocationsDataExchangesListingsGetCall {
	c := &ProjectsLocationsDataExchangesListingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesListingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesListingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsGetCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Listing.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsGetCall) Do(opts ...googleapi.CallOption) (*Listing, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Listing{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the IAM policy.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDataExchangesListingsService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsLocationsDataExchangesListingsGetIamPolicyCall {
	c := &ProjectsLocationsDataExchangesListingsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all listings in a given project and location.
//
//   - parent: The parent resource path of the listing. e.g.
//     `projects/myproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesListingsService) List(parent string) *ProjectsLocationsDataExchangesListingsListCall {
	c := &ProjectsLocationsDataExchangesListingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *ProjectsLocationsDataExchangesListingsListCall) PageSize(pageSize int64) *ProjectsLocationsDataExchangesListingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *ProjectsLocationsDataExchangesListingsListCall) PageToken(pageToken string) *ProjectsLocationsDataExchangesListingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesListingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesListingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsListCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/listings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListListingsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataExchangesListingsListCall) Do(opts ...googleapi.CallOption) (*ListListingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListListingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataExchangesListingsListCall) Pages(ctx context.Context, f func(*ListListingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDataExchangesListingsListSubscriptionsCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListSubscriptions: Lists all subscriptions on a given Data Exchange or
// Listing.
//
//   - resource: Resource name of the requested target. This resource may be
//     either a Listing or a DataExchange. e.g.
//     projects/123/locations/us/dataExchanges/456 OR e.g.
//     projects/123/locations/us/dataExchanges/456/listings/789.
func (r *ProjectsLocationsDataExchangesListingsService) ListSubscriptions(resource string) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c := &ProjectsLocationsDataExchangesListingsListSubscriptionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// IncludeDeletedSubscriptions sets the optional parameter
// "includeDeletedSubscriptions": If selected, includes deleted subscriptions
// in the response (up to 63 days after deletion).
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) IncludeDeletedSubscriptions(includeDeletedSubscriptions bool) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c.urlParams_.Set("includeDeletedSubscriptions", fmt.Sprint(includeDeletedSubscriptions))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) PageSize(pageSize int64) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) PageToken(pageToken string) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsListSubscriptionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:listSubscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.listSubscriptions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.listSubscriptions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSharedResourceSubscriptionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) Do(opts ...googleapi.CallOption) (*ListSharedResourceSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSharedResourceSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.listSubscriptions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataExchangesListingsListSubscriptionsCall) Pages(ctx context.Context, f func(*ListSharedResourceSubscriptionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDataExchangesListingsPatchCall struct {
	s          *Service
	name       string
	listing    *Listing
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing listing.
//
//   - name: Output only. The resource name of the listing. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/listings/456`.
func (r *ProjectsLocationsDataExchangesListingsService) Patch(name string, listing *Listing) *ProjectsLocationsDataExchangesListingsPatchCall {
	c := &ProjectsLocationsDataExchangesListingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.listing = listing
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// specifies the fields to update in the listing resource. The fields specified
// in the `updateMask` are relative to the resource and are not a full request.
func (c *ProjectsLocationsDataExchangesListingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataExchangesListingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsPatchCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.listing)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Listing.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsPatchCall) Do(opts ...googleapi.CallOption) (*Listing, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Listing{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the IAM policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDataExchangesListingsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDataExchangesListingsSetIamPolicyCall {
	c := &ProjectsLocationsDataExchangesListingsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsSubscribeCall struct {
	s                       *Service
	name                    string
	subscribelistingrequest *SubscribeListingRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Subscribe: Subscribes to a listing. Currently, with Analytics Hub, you can
// create listings that reference only BigQuery datasets. Upon subscription to
// a listing for a BigQuery dataset, Analytics Hub creates a linked dataset in
// the subscriber's project.
//
//   - name: Resource name of the listing that you want to subscribe to. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/listings/456`.
func (r *ProjectsLocationsDataExchangesListingsService) Subscribe(name string, subscribelistingrequest *SubscribeListingRequest) *ProjectsLocationsDataExchangesListingsSubscribeCall {
	c := &ProjectsLocationsDataExchangesListingsSubscribeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.subscribelistingrequest = subscribelistingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsSubscribeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsSubscribeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsSubscribeCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsSubscribeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsSubscribeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsSubscribeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.subscribelistingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:subscribe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.subscribe", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.subscribe" call.
// Any non-2xx status code is an error. Response headers are in either
// *SubscribeListingResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsSubscribeCall) Do(opts ...googleapi.CallOption) (*SubscribeListingResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscribeListingResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.subscribe", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesListingsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns the permissions that a caller has.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDataExchangesListingsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall {
	c := &ProjectsLocationsDataExchangesListingsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.listings.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesListingsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.listings.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesQueryTemplatesApproveCall struct {
	s                           *Service
	name                        string
	approvequerytemplaterequest *ApproveQueryTemplateRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Approve: Approves a query template.
//
//   - name: The resource path of the QueryTemplate. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTe
//     mplate`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) Approve(name string, approvequerytemplaterequest *ApproveQueryTemplateRequest) *ProjectsLocationsDataExchangesQueryTemplatesApproveCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.approvequerytemplaterequest = approvequerytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesApproveCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesApproveCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.approvequerytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:approve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.approve", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.approve" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryTemplate.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesApproveCall) Do(opts ...googleapi.CallOption) (*QueryTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.approve", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesQueryTemplatesCreateCall struct {
	s             *Service
	parent        string
	querytemplate *QueryTemplate
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates a new QueryTemplate
//
//   - parent: The parent resource path of the QueryTemplate. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myQueryTe
//     mplate`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) Create(parent string, querytemplate *QueryTemplate) *ProjectsLocationsDataExchangesQueryTemplatesCreateCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.querytemplate = querytemplate
	return c
}

// QueryTemplateId sets the optional parameter "queryTemplateId": Required. The
// ID of the QueryTemplate to create. Must contain only Unicode letters,
// numbers (0-9), underscores (_). Max length: 100 bytes.
func (c *ProjectsLocationsDataExchangesQueryTemplatesCreateCall) QueryTemplateId(queryTemplateId string) *ProjectsLocationsDataExchangesQueryTemplatesCreateCall {
	c.urlParams_.Set("queryTemplateId", queryTemplateId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesCreateCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.querytemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/queryTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryTemplate.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*QueryTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesQueryTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a query template.
//
//   - name: The resource path of the QueryTemplate. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTe
//     mplate`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) Delete(name string) *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesQueryTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a QueryTemplate
//
//   - name: The parent resource path of the QueryTemplate. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTe
//     mplate`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) Get(name string) *ProjectsLocationsDataExchangesQueryTemplatesGetCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesQueryTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesGetCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryTemplate.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesGetCall) Do(opts ...googleapi.CallOption) (*QueryTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesQueryTemplatesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all QueryTemplates in a given project and location.
//
//   - parent: The parent resource path of the QueryTemplates. e.g.
//     `projects/myproject/locations/us/dataExchanges/123`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) List(parent string) *ProjectsLocationsDataExchangesQueryTemplatesListCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) PageSize(pageSize int64) *ProjectsLocationsDataExchangesQueryTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) PageToken(pageToken string) *ProjectsLocationsDataExchangesQueryTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataExchangesQueryTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/queryTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListQueryTemplatesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) Do(opts ...googleapi.CallOption) (*ListQueryTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListQueryTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesListCall) Pages(ctx context.Context, f func(*ListQueryTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDataExchangesQueryTemplatesPatchCall struct {
	s             *Service
	name          string
	querytemplate *QueryTemplate
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates an existing QueryTemplate
//
//   - name: Output only. The resource name of the QueryTemplate. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/456`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) Patch(name string, querytemplate *QueryTemplate) *ProjectsLocationsDataExchangesQueryTemplatesPatchCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.querytemplate = querytemplate
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask specifies
// the fields to update in the query template resource. The fields specified in
// the `updateMask` are relative to the resource and are not a full request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataExchangesQueryTemplatesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesPatchCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.querytemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryTemplate.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*QueryTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDataExchangesQueryTemplatesSubmitCall struct {
	s                          *Service
	name                       string
	submitquerytemplaterequest *SubmitQueryTemplateRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Submit: Submits a query template for approval.
//
//   - name: The resource path of the QueryTemplate. e.g.
//     `projects/myproject/locations/us/dataExchanges/123/queryTemplates/myqueryTe
//     mplate`.
func (r *ProjectsLocationsDataExchangesQueryTemplatesService) Submit(name string, submitquerytemplaterequest *SubmitQueryTemplateRequest) *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall {
	c := &ProjectsLocationsDataExchangesQueryTemplatesSubmitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.submitquerytemplaterequest = submitquerytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall) Context(ctx context.Context) *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.submitquerytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:submit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.submit", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.dataExchanges.queryTemplates.submit" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryTemplate.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataExchangesQueryTemplatesSubmitCall) Do(opts ...googleapi.CallOption) (*QueryTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.dataExchanges.queryTemplates.submit", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSubscriptionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a subscription.
//
//   - name: Resource name of the subscription to delete. e.g.
//     projects/123/locations/us/subscriptions/456.
func (r *ProjectsLocationsSubscriptionsService) Delete(name string) *ProjectsLocationsSubscriptionsDeleteCall {
	c := &ProjectsLocationsSubscriptionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSubscriptionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a Subscription.
//
//   - name: Resource name of the subscription. e.g.
//     projects/123/locations/us/subscriptions/456.
func (r *ProjectsLocationsSubscriptionsService) Get(name string) *ProjectsLocationsSubscriptionsGetCall {
	c := &ProjectsLocationsSubscriptionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSubscriptionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSubscriptionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsGetCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsGetCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSubscriptionsGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the IAM policy.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsSubscriptionsService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsLocationsSubscriptionsGetIamPolicyCall {
	c := &ProjectsLocationsSubscriptionsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSubscriptionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all subscriptions in a given project and location.
//
//   - parent: The parent resource path of the subscription. e.g.
//     projects/myproject/locations/us.
func (r *ProjectsLocationsSubscriptionsService) List(parent string) *ProjectsLocationsSubscriptionsListCall {
	c := &ProjectsLocationsSubscriptionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Eligible fields for filtering are: + `listing` +
// `data_exchange` Alternatively, a literal wrapped in double quotes may be
// provided. This will be checked for an exact match against both fields above.
// In all cases, the full Data Exchange or Listing resource name must be
// provided. Some example of using filters: +
// data_exchange="projects/myproject/locations/us/dataExchanges/123" +
// listing="projects/123/locations/us/dataExchanges/456/listings/789" +
// "projects/myproject/locations/us/dataExchanges/123"
func (c *ProjectsLocationsSubscriptionsListCall) Filter(filter string) *ProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page.
func (c *ProjectsLocationsSubscriptionsListCall) PageSize(pageSize int64) *ProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call.
func (c *ProjectsLocationsSubscriptionsListCall) PageToken(pageToken string) *ProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSubscriptionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSubscriptionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsListCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSubscriptionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsListCall) Do(opts ...googleapi.CallOption) (*ListSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSubscriptionsListCall) Pages(ctx context.Context, f func(*ListSubscriptionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSubscriptionsRefreshCall struct {
	s                          *Service
	name                       string
	refreshsubscriptionrequest *RefreshSubscriptionRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Refresh: Refreshes a Subscription to a Data Exchange. A Data Exchange can
// become stale when a publisher adds or removes data. This is a long-running
// operation as it may create many linked datasets.
//
//   - name: Resource name of the Subscription to refresh. e.g.
//     `projects/subscriberproject/locations/us/subscriptions/123`.
func (r *ProjectsLocationsSubscriptionsService) Refresh(name string, refreshsubscriptionrequest *RefreshSubscriptionRequest) *ProjectsLocationsSubscriptionsRefreshCall {
	c := &ProjectsLocationsSubscriptionsRefreshCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.refreshsubscriptionrequest = refreshsubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsRefreshCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsRefreshCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsRefreshCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsRefreshCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsRefreshCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsRefreshCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.refreshsubscriptionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:refresh")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.refresh", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.refresh" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsRefreshCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.refresh", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSubscriptionsRevokeCall struct {
	s                         *Service
	name                      string
	revokesubscriptionrequest *RevokeSubscriptionRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Revoke: Revokes a given subscription.
//
//   - name: Resource name of the subscription to revoke. e.g.
//     projects/123/locations/us/subscriptions/456.
func (r *ProjectsLocationsSubscriptionsService) Revoke(name string, revokesubscriptionrequest *RevokeSubscriptionRequest) *ProjectsLocationsSubscriptionsRevokeCall {
	c := &ProjectsLocationsSubscriptionsRevokeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.revokesubscriptionrequest = revokesubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsRevokeCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsRevokeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsRevokeCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsRevokeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsRevokeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsRevokeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.revokesubscriptionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:revoke")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.revoke", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.revoke" call.
// Any non-2xx status code is an error. Response headers are in either
// *RevokeSubscriptionResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsRevokeCall) Do(opts ...googleapi.CallOption) (*RevokeSubscriptionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RevokeSubscriptionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.revoke", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSubscriptionsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the IAM policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsSubscriptionsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsSubscriptionsSetIamPolicyCall {
	c := &ProjectsLocationsSubscriptionsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSubscriptionsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsSubscriptionsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSubscriptionsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsSubscriptionsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSubscriptionsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSubscriptionsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticshub.projects.locations.subscriptions.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSubscriptionsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticshub.projects.locations.subscriptions.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
