// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: vector_tile.proto

package vectortile

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Tile_GeomType int32

const (
	Tile_UNKNOWN    Tile_GeomType = 0
	Tile_POINT      Tile_GeomType = 1
	Tile_LINESTRING Tile_GeomType = 2
	Tile_POLYGON    Tile_GeomType = 3
)

var Tile_GeomType_name = map[int32]string{
	0: "UNKNOWN",
	1: "POINT",
	2: "LINESTRING",
	3: "POLYGON",
}

var Tile_GeomType_value = map[string]int32{
	"UNKNOWN":    0,
	"POINT":      1,
	"LINESTRING": 2,
	"POLYGON":    3,
}

func (x Tile_GeomType) Enum() *Tile_GeomType {
	p := new(Tile_GeomType)
	*p = x
	return p
}

func (x Tile_GeomType) String() string {
	return proto.EnumName(Tile_GeomType_name, int32(x))
}

func (x *Tile_GeomType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Tile_GeomType_value, data, "Tile_GeomType")
	if err != nil {
		return err
	}
	*x = Tile_GeomType(value)
	return nil
}

func (Tile_GeomType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ca433dd0d9fb7008, []int{0, 0}
}

type Tile struct {
	Layers                       []*Tile_Layer `protobuf:"bytes,3,rep,name=layers" json:"layers,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}      `json:"-"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
	XXX_sizecache                int32  `json:"-"`
}

func (m *Tile) Reset()         { *m = Tile{} }
func (m *Tile) String() string { return proto.CompactTextString(m) }
func (*Tile) ProtoMessage()    {}
func (*Tile) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca433dd0d9fb7008, []int{0}
}

var extRange_Tile = []proto.ExtensionRange{
	{Start: 16, End: 8191},
}

func (*Tile) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_Tile
}

func (m *Tile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tile.Merge(m, src)
}
func (m *Tile) XXX_Size() int {
	return m.Size()
}
func (m *Tile) XXX_DiscardUnknown() {
	xxx_messageInfo_Tile.DiscardUnknown(m)
}

var xxx_messageInfo_Tile proto.InternalMessageInfo

func (m *Tile) GetLayers() []*Tile_Layer {
	if m != nil {
		return m.Layers
	}
	return nil
}

// Variant type encoding
type Tile_Value struct {
	// Exactly one of these values may be present in a valid message
	StringValue                  *string  `protobuf:"bytes,1,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	FloatValue                   *float32 `protobuf:"fixed32,2,opt,name=float_value,json=floatValue" json:"float_value,omitempty"`
	DoubleValue                  *float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue" json:"double_value,omitempty"`
	IntValue                     *int64   `protobuf:"varint,4,opt,name=int_value,json=intValue" json:"int_value,omitempty"`
	UintValue                    *uint64  `protobuf:"varint,5,opt,name=uint_value,json=uintValue" json:"uint_value,omitempty"`
	SintValue                    *int64   `protobuf:"zigzag64,6,opt,name=sint_value,json=sintValue" json:"sint_value,omitempty"`
	BoolValue                    *bool    `protobuf:"varint,7,opt,name=bool_value,json=boolValue" json:"bool_value,omitempty"`
	XXX_NoUnkeyedLiteral         struct{} `json:"-"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
	XXX_sizecache                int32  `json:"-"`
}

func (m *Tile_Value) Reset()         { *m = Tile_Value{} }
func (m *Tile_Value) String() string { return proto.CompactTextString(m) }
func (*Tile_Value) ProtoMessage()    {}
func (*Tile_Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca433dd0d9fb7008, []int{0, 0}
}

var extRange_Tile_Value = []proto.ExtensionRange{
	{Start: 8, End: 536870911},
}

func (*Tile_Value) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_Tile_Value
}

func (m *Tile_Value) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tile_Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tile_Value.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tile_Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tile_Value.Merge(m, src)
}
func (m *Tile_Value) XXX_Size() int {
	return m.Size()
}
func (m *Tile_Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Tile_Value.DiscardUnknown(m)
}

var xxx_messageInfo_Tile_Value proto.InternalMessageInfo

func (m *Tile_Value) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *Tile_Value) GetFloatValue() float32 {
	if m != nil && m.FloatValue != nil {
		return *m.FloatValue
	}
	return 0
}

func (m *Tile_Value) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

func (m *Tile_Value) GetIntValue() int64 {
	if m != nil && m.IntValue != nil {
		return *m.IntValue
	}
	return 0
}

func (m *Tile_Value) GetUintValue() uint64 {
	if m != nil && m.UintValue != nil {
		return *m.UintValue
	}
	return 0
}

func (m *Tile_Value) GetSintValue() int64 {
	if m != nil && m.SintValue != nil {
		return *m.SintValue
	}
	return 0
}

func (m *Tile_Value) GetBoolValue() bool {
	if m != nil && m.BoolValue != nil {
		return *m.BoolValue
	}
	return false
}

type Tile_Feature struct {
	Id *uint64 `protobuf:"varint,1,opt,name=id,def=0" json:"id,omitempty"`
	// Tags of this feature are encoded as repeated pairs of
	// integers. Even indexed values (n, beginning with 0) are
	// themselves indexes into the layer's keys list. Odd indexed
	// values (n+1) are indexes into the layer's values list.
	// The first (n=0) tag of a feature, therefore, has a key of
	// layer.keys[feature.tags[0]] and a value of
	// layer.values[feature.tags[1]].
	Tags []uint32 `protobuf:"varint,2,rep,packed,name=tags" json:"tags,omitempty"`
	// The type of geometry stored in this feature.
	Type *Tile_GeomType `protobuf:"varint,3,opt,name=type,enum=vector_tile.Tile_GeomType,def=0" json:"type,omitempty"`
	// Contains a stream of commands and parameters (vertices). The
	// repeat count is shifted to the left by 3 bits. This means
	// that the command has 3 bits (0-7). The repeat count
	// indicates how often this command is to be repeated. Defined
	// commands are:
	// - MoveTo:    1   (2 parameters follow)
	// - LineTo:    2   (2 parameters follow)
	// - ClosePath: 7   (no parameters follow)
	//
	// Commands are encoded as uint32 varints. Vertex parameters
	// are encoded as deltas to the previous position and, as they
	// may be negative, are further "zigzag" encoded as unsigned
	// 32-bit ints:
	//
	//   n = (n << 1) ^ (n >> 31)
	//
	// Ex.: MoveTo(3, 6), LineTo(8, 12), LineTo(20, 34), ClosePath
	// Encoded as: [ 9 6 12 18 10 12 24 44 15 ]
	//               |       |              `> [00001 111] command type 7 (ClosePath), length 1
	//               |       |       ===== relative LineTo(+12, +22) == LineTo(20, 34)
	//               |       | ===== relative LineTo(+5, +6) == LineTo(8, 12)
	//               |       `> [00010 010] = command type 2 (LineTo), length 2
	//               | ==== relative MoveTo(+3, +6)
	//               `> [00001 001] = command type 1 (MoveTo), length 1
	//
	// The original position is (0,0).
	Geometry             []uint32 `protobuf:"varint,4,rep,packed,name=geometry" json:"geometry,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tile_Feature) Reset()         { *m = Tile_Feature{} }
func (m *Tile_Feature) String() string { return proto.CompactTextString(m) }
func (*Tile_Feature) ProtoMessage()    {}
func (*Tile_Feature) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca433dd0d9fb7008, []int{0, 1}
}
func (m *Tile_Feature) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tile_Feature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tile_Feature.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tile_Feature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tile_Feature.Merge(m, src)
}
func (m *Tile_Feature) XXX_Size() int {
	return m.Size()
}
func (m *Tile_Feature) XXX_DiscardUnknown() {
	xxx_messageInfo_Tile_Feature.DiscardUnknown(m)
}

var xxx_messageInfo_Tile_Feature proto.InternalMessageInfo

const Default_Tile_Feature_Id uint64 = 0
const Default_Tile_Feature_Type Tile_GeomType = Tile_UNKNOWN

func (m *Tile_Feature) GetId() uint64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return Default_Tile_Feature_Id
}

func (m *Tile_Feature) GetTags() []uint32 {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Tile_Feature) GetType() Tile_GeomType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_Tile_Feature_Type
}

func (m *Tile_Feature) GetGeometry() []uint32 {
	if m != nil {
		return m.Geometry
	}
	return nil
}

type Tile_Layer struct {
	// Any compliant implementation must first read the version
	// number encoded in this message and choose the correct
	// implementation for this version number before proceeding to
	// decode other parts of this message.
	Version *uint32 `protobuf:"varint,15,req,name=version,def=1" json:"version,omitempty"`
	Name    *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The actual features in this tile.
	Features []*Tile_Feature `protobuf:"bytes,2,rep,name=features" json:"features,omitempty"`
	// Dictionary encoding for keys
	Keys []string `protobuf:"bytes,3,rep,name=keys" json:"keys,omitempty"`
	// Dictionary encoding for values
	Values []*Tile_Value `protobuf:"bytes,4,rep,name=values" json:"values,omitempty"`
	// The bounding box in this tile spans from 0..4095 units
	Extent                       *uint32  `protobuf:"varint,5,opt,name=extent,def=4096" json:"extent,omitempty"`
	XXX_NoUnkeyedLiteral         struct{} `json:"-"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
	XXX_sizecache                int32  `json:"-"`
}

func (m *Tile_Layer) Reset()         { *m = Tile_Layer{} }
func (m *Tile_Layer) String() string { return proto.CompactTextString(m) }
func (*Tile_Layer) ProtoMessage()    {}
func (*Tile_Layer) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca433dd0d9fb7008, []int{0, 2}
}

var extRange_Tile_Layer = []proto.ExtensionRange{
	{Start: 16, End: 536870911},
}

func (*Tile_Layer) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_Tile_Layer
}

func (m *Tile_Layer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tile_Layer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tile_Layer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tile_Layer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tile_Layer.Merge(m, src)
}
func (m *Tile_Layer) XXX_Size() int {
	return m.Size()
}
func (m *Tile_Layer) XXX_DiscardUnknown() {
	xxx_messageInfo_Tile_Layer.DiscardUnknown(m)
}

var xxx_messageInfo_Tile_Layer proto.InternalMessageInfo

const Default_Tile_Layer_Version uint32 = 1
const Default_Tile_Layer_Extent uint32 = 4096

func (m *Tile_Layer) GetVersion() uint32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return Default_Tile_Layer_Version
}

func (m *Tile_Layer) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Tile_Layer) GetFeatures() []*Tile_Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *Tile_Layer) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *Tile_Layer) GetValues() []*Tile_Value {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Tile_Layer) GetExtent() uint32 {
	if m != nil && m.Extent != nil {
		return *m.Extent
	}
	return Default_Tile_Layer_Extent
}

func init() {
	proto.RegisterEnum("vector_tile.Tile_GeomType", Tile_GeomType_name, Tile_GeomType_value)
	proto.RegisterType((*Tile)(nil), "vector_tile.Tile")
	proto.RegisterType((*Tile_Value)(nil), "vector_tile.Tile.Value")
	proto.RegisterType((*Tile_Feature)(nil), "vector_tile.Tile.Feature")
	proto.RegisterType((*Tile_Layer)(nil), "vector_tile.Tile.Layer")
}

func init() { proto.RegisterFile("vector_tile.proto", fileDescriptor_ca433dd0d9fb7008) }

var fileDescriptor_ca433dd0d9fb7008 = []byte{
	// 498 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x52, 0xcd, 0x8e, 0xd3, 0x30,
	0x10, 0xc6, 0x4e, 0xb2, 0x75, 0x26, 0xb4, 0x64, 0x7d, 0x80, 0xd2, 0x85, 0x62, 0xf6, 0x64, 0xf5,
	0x50, 0x96, 0x8a, 0x1f, 0xd1, 0x0b, 0x68, 0x25, 0x28, 0x15, 0x55, 0xba, 0x32, 0x05, 0xc4, 0x69,
	0x95, 0xa5, 0xde, 0x2a, 0x22, 0x8d, 0xab, 0xc4, 0xad, 0xc8, 0xad, 0x2f, 0xc0, 0x7b, 0x71, 0xe4,
	0x01, 0x38, 0xa0, 0xf2, 0x06, 0x3c, 0x01, 0x8a, 0x93, 0x76, 0x2b, 0x2d, 0x37, 0xfb, 0xfb, 0xbe,
	0xf9, 0x34, 0xf3, 0xcd, 0xc0, 0xe1, 0x4a, 0x7e, 0xd1, 0x2a, 0x3d, 0xd7, 0x51, 0x2c, 0xbb, 0x8b,
	0x54, 0x69, 0x45, 0xbd, 0x3d, 0xe8, 0xf8, 0x8f, 0x03, 0xf6, 0x24, 0x8a, 0x25, 0x7d, 0x04, 0x07,
	0x71, 0x98, 0xcb, 0x34, 0x6b, 0x5a, 0xcc, 0xe2, 0x5e, 0xef, 0x4e, 0x77, 0xbf, 0xb2, 0x90, 0x74,
	0x47, 0x05, 0x2f, 0x2a, 0x59, 0xeb, 0x2f, 0x02, 0xe7, 0x63, 0x18, 0x2f, 0x25, 0x7d, 0x08, 0x37,
	0x33, 0x9d, 0x46, 0xc9, 0xec, 0x7c, 0x55, 0xfc, 0x9b, 0x88, 0x21, 0xee, 0x0a, 0xaf, 0xc4, 0x4a,
	0xc9, 0x03, 0xf0, 0x2e, 0x63, 0x15, 0xea, 0x4a, 0x81, 0x19, 0xe2, 0x58, 0x80, 0x81, 0x76, 0x1e,
	0x53, 0xb5, 0xbc, 0x88, 0x65, 0xa5, 0xb0, 0x18, 0xe2, 0x48, 0x78, 0x25, 0x56, 0x4a, 0x8e, 0xc0,
	0x8d, 0x92, 0xad, 0x83, 0xcd, 0x10, 0xb7, 0x04, 0x89, 0x92, 0xaa, 0xfe, 0x3e, 0xc0, 0xf2, 0x8a,
	0x75, 0x18, 0xe2, 0xb6, 0x70, 0x97, 0xfb, 0x74, 0x76, 0x45, 0x1f, 0x30, 0xc4, 0xa9, 0x70, 0xb3,
	0x7d, 0xfa, 0x42, 0xa9, 0xb8, 0xa2, 0x6b, 0x0c, 0x71, 0x22, 0xdc, 0x02, 0x31, 0x74, 0x87, 0x10,
	0xe2, 0xaf, 0xd7, 0xeb, 0x35, 0x6e, 0x7d, 0x47, 0x50, 0x7b, 0x23, 0x43, 0xbd, 0x4c, 0x25, 0x3d,
	0x04, 0x1c, 0x4d, 0xcd, 0xb0, 0x76, 0x1f, 0x9d, 0x08, 0x1c, 0x4d, 0xe9, 0x6d, 0xb0, 0x75, 0x38,
	0xcb, 0x9a, 0x98, 0x59, 0xbc, 0x7e, 0x8a, 0x7d, 0x24, 0xcc, 0x9f, 0x3e, 0x07, 0x5b, 0xe7, 0x8b,
	0x72, 0xaa, 0x46, 0xaf, 0x75, 0x3d, 0xda, 0x81, 0x54, 0xf3, 0x49, 0xbe, 0x90, 0xfd, 0xda, 0x87,
	0xe0, 0x5d, 0x30, 0xfe, 0x14, 0x08, 0x53, 0x40, 0xdb, 0x40, 0x66, 0x52, 0xcd, 0xa5, 0x4e, 0xf3,
	0xa6, 0xbd, 0x33, 0xdd, 0x61, 0xad, 0x5f, 0x08, 0x1c, 0xb3, 0x16, 0x7a, 0x04, 0xb5, 0x95, 0x4c,
	0xb3, 0x48, 0x25, 0xcd, 0x5b, 0x0c, 0xf3, 0x7a, 0x1f, 0x3d, 0x16, 0x5b, 0x84, 0x52, 0xb0, 0x93,
	0x70, 0x5e, 0x6c, 0x06, 0x73, 0x57, 0x98, 0x37, 0x7d, 0x0a, 0xe4, 0xb2, 0x9c, 0xa4, 0xec, 0xd7,
	0xeb, 0xdd, 0xbd, 0xde, 0x57, 0x35, 0xab, 0xd8, 0x49, 0x0b, 0xab, 0xaf, 0x32, 0x2f, 0xaf, 0xc4,
	0x15, 0xe6, 0x5d, 0xdc, 0x8e, 0x49, 0x2e, 0x33, 0x3d, 0xfe, 0xf7, 0x76, 0x4c, 0x90, 0xa2, 0x92,
	0xd1, 0x7b, 0x70, 0x20, 0xbf, 0x69, 0x99, 0x68, 0xb3, 0xa9, 0x7a, 0xdf, 0x7e, 0x72, 0xf2, 0xe2,
	0x99, 0xa8, 0xb0, 0x0e, 0x21, 0x7e, 0x19, 0xf7, 0xf1, 0x4b, 0x20, 0xdb, 0x64, 0xa8, 0x07, 0xdb,
	0x6c, 0xfc, 0x1b, 0xd4, 0x05, 0xe7, 0x6c, 0x3c, 0x0c, 0x26, 0x3e, 0xa2, 0x0d, 0x80, 0xd1, 0x30,
	0x78, 0xfd, 0x7e, 0x22, 0x86, 0xc1, 0xc0, 0xc7, 0x85, 0xee, 0x6c, 0x3c, 0xfa, 0x3c, 0x18, 0x07,
	0xbe, 0xd5, 0x71, 0x0a, 0xab, 0x57, 0xa7, 0x8d, 0x1f, 0x9b, 0x36, 0xfa, 0xb9, 0x69, 0xa3, 0xdf,
	0x9b, 0x36, 0x7a, 0x6b, 0xfd, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xa3, 0x3c, 0xd7, 0x26, 0x16, 0x03,
	0x00, 0x00,
}

func (m *Tile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if n, err := github_com_gogo_protobuf_proto.EncodeInternalExtensionBackwards(m, dAtA[:i]); err != nil {
		return 0, err
	} else {
		i -= n
	}
	if len(m.Layers) > 0 {
		for iNdEx := len(m.Layers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Layers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVectorTile(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tile_Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile_Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tile_Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if n, err := github_com_gogo_protobuf_proto.EncodeInternalExtensionBackwards(m, dAtA[:i]); err != nil {
		return 0, err
	} else {
		i -= n
	}
	if m.BoolValue != nil {
		i--
		if *m.BoolValue {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.SintValue != nil {
		i = encodeVarintVectorTile(dAtA, i, uint64((uint64(*m.SintValue)<<1)^uint64((*m.SintValue>>63))))
		i--
		dAtA[i] = 0x30
	}
	if m.UintValue != nil {
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.UintValue))
		i--
		dAtA[i] = 0x28
	}
	if m.IntValue != nil {
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.IntValue))
		i--
		dAtA[i] = 0x20
	}
	if m.DoubleValue != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.DoubleValue))))
		i--
		dAtA[i] = 0x19
	}
	if m.FloatValue != nil {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(*m.FloatValue))))
		i--
		dAtA[i] = 0x15
	}
	if m.StringValue != nil {
		i -= len(*m.StringValue)
		copy(dAtA[i:], *m.StringValue)
		i = encodeVarintVectorTile(dAtA, i, uint64(len(*m.StringValue)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tile_Feature) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile_Feature) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tile_Feature) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Geometry) > 0 {
		dAtA2 := make([]byte, len(m.Geometry)*10)
		var j1 int
		for _, num := range m.Geometry {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		i -= j1
		copy(dAtA[i:], dAtA2[:j1])
		i = encodeVarintVectorTile(dAtA, i, uint64(j1))
		i--
		dAtA[i] = 0x22
	}
	if m.Type != nil {
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Type))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Tags) > 0 {
		dAtA4 := make([]byte, len(m.Tags)*10)
		var j3 int
		for _, num := range m.Tags {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		i -= j3
		copy(dAtA[i:], dAtA4[:j3])
		i = encodeVarintVectorTile(dAtA, i, uint64(j3))
		i--
		dAtA[i] = 0x12
	}
	if m.Id != nil {
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Tile_Layer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tile_Layer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tile_Layer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if n, err := github_com_gogo_protobuf_proto.EncodeInternalExtensionBackwards(m, dAtA[:i]); err != nil {
		return 0, err
	} else {
		i -= n
	}
	if m.Version == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	} else {
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Version))
		i--
		dAtA[i] = 0x78
	}
	if m.Extent != nil {
		i = encodeVarintVectorTile(dAtA, i, uint64(*m.Extent))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Values[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVectorTile(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintVectorTile(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Features) > 0 {
		for iNdEx := len(m.Features) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Features[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVectorTile(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintVectorTile(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintVectorTile(dAtA []byte, offset int, v uint64) int {
	offset -= sovVectorTile(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Tile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Layers) > 0 {
		for _, e := range m.Layers {
			l = e.Size()
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	n += github_com_gogo_protobuf_proto.SizeOfInternalExtension(m)
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tile_Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StringValue != nil {
		l = len(*m.StringValue)
		n += 1 + l + sovVectorTile(uint64(l))
	}
	if m.FloatValue != nil {
		n += 5
	}
	if m.DoubleValue != nil {
		n += 9
	}
	if m.IntValue != nil {
		n += 1 + sovVectorTile(uint64(*m.IntValue))
	}
	if m.UintValue != nil {
		n += 1 + sovVectorTile(uint64(*m.UintValue))
	}
	if m.SintValue != nil {
		n += 1 + sozVectorTile(uint64(*m.SintValue))
	}
	if m.BoolValue != nil {
		n += 2
	}
	n += github_com_gogo_protobuf_proto.SizeOfInternalExtension(m)
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tile_Feature) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != nil {
		n += 1 + sovVectorTile(uint64(*m.Id))
	}
	if len(m.Tags) > 0 {
		l = 0
		for _, e := range m.Tags {
			l += sovVectorTile(uint64(e))
		}
		n += 1 + sovVectorTile(uint64(l)) + l
	}
	if m.Type != nil {
		n += 1 + sovVectorTile(uint64(*m.Type))
	}
	if len(m.Geometry) > 0 {
		l = 0
		for _, e := range m.Geometry {
			l += sovVectorTile(uint64(e))
		}
		n += 1 + sovVectorTile(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tile_Layer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovVectorTile(uint64(l))
	}
	if len(m.Features) > 0 {
		for _, e := range m.Features {
			l = e.Size()
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovVectorTile(uint64(l))
		}
	}
	if m.Extent != nil {
		n += 1 + sovVectorTile(uint64(*m.Extent))
	}
	if m.Version != nil {
		n += 1 + sovVectorTile(uint64(*m.Version))
	}
	n += github_com_gogo_protobuf_proto.SizeOfInternalExtension(m)
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovVectorTile(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozVectorTile(x uint64) (n int) {
	return sovVectorTile(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Tile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Layers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVectorTile
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Layers = append(m.Layers, &Tile_Layer{})
			if err := m.Layers[len(m.Layers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			if (fieldNum >= 16) && (fieldNum < 8192) {
				var sizeOfWire int
				for {
					sizeOfWire++
					wire >>= 7
					if wire == 0 {
						break
					}
				}
				iNdEx -= sizeOfWire
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				github_com_gogo_protobuf_proto.AppendExtension(m, int32(fieldNum), dAtA[iNdEx:iNdEx+skippy])
				iNdEx += skippy
			} else {
				iNdEx = preIndex
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
				iNdEx += skippy
			}
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tile_Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVectorTile
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.StringValue = &s
			iNdEx = postIndex
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field FloatValue", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			v2 := float32(math.Float32frombits(v))
			m.FloatValue = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.DoubleValue = &v2
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntValue = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UintValue", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UintValue = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SintValue", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			v2 := int64(v)
			m.SintValue = &v2
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.BoolValue = &b
		default:
			if (fieldNum >= 8) && (fieldNum < 536870912) {
				var sizeOfWire int
				for {
					sizeOfWire++
					wire >>= 7
					if wire == 0 {
						break
					}
				}
				iNdEx -= sizeOfWire
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				github_com_gogo_protobuf_proto.AppendExtension(m, int32(fieldNum), dAtA[iNdEx:iNdEx+skippy])
				iNdEx += skippy
			} else {
				iNdEx = preIndex
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
				iNdEx += skippy
			}
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tile_Feature) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Feature: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Feature: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Id = &v
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Tags = append(m.Tags, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthVectorTile
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthVectorTile
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Tags) == 0 {
					m.Tags = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVectorTile
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Tags = append(m.Tags, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Tile_GeomType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Tile_GeomType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 4:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Geometry = append(m.Geometry, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVectorTile
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthVectorTile
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthVectorTile
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Geometry) == 0 {
					m.Geometry = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVectorTile
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Geometry = append(m.Geometry, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Geometry", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipVectorTile(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVectorTile
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVectorTile
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tile_Layer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Layer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Layer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVectorTile
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Features", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVectorTile
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Features = append(m.Features, &Tile_Feature{})
			if err := m.Features[len(m.Features)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVectorTile
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVectorTile
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVectorTile
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &Tile_Value{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extent", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Extent = &v
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Version = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			if (fieldNum >= 16) && (fieldNum < 536870912) {
				var sizeOfWire int
				for {
					sizeOfWire++
					wire >>= 7
					if wire == 0 {
						break
					}
				}
				iNdEx -= sizeOfWire
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				github_com_gogo_protobuf_proto.AppendExtension(m, int32(fieldNum), dAtA[iNdEx:iNdEx+skippy])
				iNdEx += skippy
			} else {
				iNdEx = preIndex
				skippy, err := skipVectorTile(dAtA[iNdEx:])
				if err != nil {
					return err
				}
				if skippy < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) < 0 {
					return ErrInvalidLengthVectorTile
				}
				if (iNdEx + skippy) > l {
					return io.ErrUnexpectedEOF
				}
				m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
				iNdEx += skippy
			}
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipVectorTile(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowVectorTile
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVectorTile
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthVectorTile
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupVectorTile
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthVectorTile
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthVectorTile        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowVectorTile          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupVectorTile = fmt.Errorf("proto: unexpected end of group")
)
