// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Web Application Acceleration (WAA) API
//
// API for the Web Application Acceleration service.
// Use this API to manage regional Web App Acceleration policies such as Caching and Compression
// for accelerating HTTP services.
//

package waa

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ResponseCompressionPolicy An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.
// This compression policy can be used to enable support for HTTP response compression algorithms like gzip and
// configure the conditions of when a compression algorithm will be used.
// HTTP responses will only be compressed if the client indicates support for one of the enabled compression
// algorithms via the "Accept-Encoding" request header.
type ResponseCompressionPolicy struct {
	GzipCompression *GzipCompressionPolicy `mandatory:"false" json:"gzipCompression"`
}

func (m ResponseCompressionPolicy) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ResponseCompressionPolicy) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
