// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CveDetails Details on a CVE.
type CveDetails struct {

	// CVE ID.
	CveReference *string `mandatory:"true" json:"cveReference"`

	// Vulnerability title.
	Title *string `mandatory:"true" json:"title"`

	// CVSS 3 Score.
	Cvss3 *string `mandatory:"true" json:"cvss3"`

	// Date/time the CVE was published.
	TimePublished *common.SDKTime `mandatory:"true" json:"timePublished"`

	// Date/time the CVE was last modified.
	TimeUpdated *common.SDKTime `mandatory:"true" json:"timeUpdated"`

	// CVE description.
	Description *string `mandatory:"false" json:"description"`

	// ID of related CVE, if applicable.
	RelatedCveReference *string `mandatory:"false" json:"relatedCveReference"`

	// Threat this item poses to resource.
	Threat *string `mandatory:"false" json:"threat"`

	// Impact on resource if this vulnerability is exploited.
	Impact *string `mandatory:"false" json:"impact"`

	// Recommended solution to fix this vulnerability.
	Solution *string `mandatory:"false" json:"solution"`

	// Can this vulnerability be patched.
	Patchable *string `mandatory:"false" json:"patchable"`

	// Can this vulnerability be exploited.
	Exploitable *string `mandatory:"false" json:"exploitable"`

	// Reference link to know more about this vulnerability.
	ReferenceUrl *string `mandatory:"false" json:"referenceUrl"`
}

func (m CveDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CveDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
