// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Science API
//
// Use the Data Science API to organize your data science work, access data and computing resources, and build, train, deploy and manage models and model deployments. For more information, see Data Science (https://docs.oracle.com/iaas/data-science/using/data-science.htm).
//

package datascience

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ModelGroup Model group is a collection of the models. Model groups are represented by their associated metadata.
type ModelGroup struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
	Id *string `mandatory:"true" json:"id"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup's compartment.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the modelGroup.
	ProjectId *string `mandatory:"true" json:"projectId"`

	ModelGroupDetails ModelGroupDetails `mandatory:"true" json:"modelGroupDetails"`

	MemberModelEntries *MemberModelEntries `mandatory:"true" json:"memberModelEntries"`

	// The state of the modelGroup.
	LifecycleState ModelGroupLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`

	// The date and time the resource was created in the timestamp format defined by RFC3339 (https://tools.ietf.org/html/rfc3339).
	// Example: 2019-08-25T21:10:29.41Z
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`

	// The date and time the resource was updated in the timestamp format defined by RFC3339 (https://tools.ietf.org/html/rfc3339).
	// Example: 2019-08-25T21:10:29.41Z
	TimeUpdated *common.SDKTime `mandatory:"true" json:"timeUpdated"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the modelGroup.
	CreatedBy *string `mandatory:"true" json:"createdBy"`

	// A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// A short description of the modelGroup.
	Description *string `mandatory:"false" json:"description"`

	// Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Department": "Finance"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace. See Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Operations": {"CostCenter": "42"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// Usage of system tag keys. These predefined keys are scoped to namespaces.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`

	// Details about the lifecycle state of the model group.
	LifecycleDetails *string `mandatory:"false" json:"lifecycleDetails"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group version history to which the modelGroup is associated.
	ModelGroupVersionHistoryId *string `mandatory:"false" json:"modelGroupVersionHistoryId"`

	// The name of the model group version history to which the model group is associated.
	ModelGroupVersionHistoryName *string `mandatory:"false" json:"modelGroupVersionHistoryName"`

	// An additional description of the lifecycle state of the model group.
	VersionLabel *string `mandatory:"false" json:"versionLabel"`

	// Unique identifier assigned to each version of the model group. It would be auto-incremented number generated by service.
	VersionId *int64 `mandatory:"false" json:"versionId"`

	// The type of the model group create operation.
	CreateType *string `mandatory:"false" json:"createType"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model group used for the clone operation.
	SourceModelGroupId *string `mandatory:"false" json:"sourceModelGroupId"`
}

func (m ModelGroup) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ModelGroup) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingModelGroupLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetModelGroupLifecycleStateEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *ModelGroup) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		DisplayName                  *string                           `json:"displayName"`
		Description                  *string                           `json:"description"`
		FreeformTags                 map[string]string                 `json:"freeformTags"`
		DefinedTags                  map[string]map[string]interface{} `json:"definedTags"`
		SystemTags                   map[string]map[string]interface{} `json:"systemTags"`
		LifecycleDetails             *string                           `json:"lifecycleDetails"`
		ModelGroupVersionHistoryId   *string                           `json:"modelGroupVersionHistoryId"`
		ModelGroupVersionHistoryName *string                           `json:"modelGroupVersionHistoryName"`
		VersionLabel                 *string                           `json:"versionLabel"`
		VersionId                    *int64                            `json:"versionId"`
		CreateType                   *string                           `json:"createType"`
		SourceModelGroupId           *string                           `json:"sourceModelGroupId"`
		Id                           *string                           `json:"id"`
		CompartmentId                *string                           `json:"compartmentId"`
		ProjectId                    *string                           `json:"projectId"`
		ModelGroupDetails            modelgroupdetails                 `json:"modelGroupDetails"`
		MemberModelEntries           *MemberModelEntries               `json:"memberModelEntries"`
		LifecycleState               ModelGroupLifecycleStateEnum      `json:"lifecycleState"`
		TimeCreated                  *common.SDKTime                   `json:"timeCreated"`
		TimeUpdated                  *common.SDKTime                   `json:"timeUpdated"`
		CreatedBy                    *string                           `json:"createdBy"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.DisplayName = model.DisplayName

	m.Description = model.Description

	m.FreeformTags = model.FreeformTags

	m.DefinedTags = model.DefinedTags

	m.SystemTags = model.SystemTags

	m.LifecycleDetails = model.LifecycleDetails

	m.ModelGroupVersionHistoryId = model.ModelGroupVersionHistoryId

	m.ModelGroupVersionHistoryName = model.ModelGroupVersionHistoryName

	m.VersionLabel = model.VersionLabel

	m.VersionId = model.VersionId

	m.CreateType = model.CreateType

	m.SourceModelGroupId = model.SourceModelGroupId

	m.Id = model.Id

	m.CompartmentId = model.CompartmentId

	m.ProjectId = model.ProjectId

	nn, e = model.ModelGroupDetails.UnmarshalPolymorphicJSON(model.ModelGroupDetails.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.ModelGroupDetails = nn.(ModelGroupDetails)
	} else {
		m.ModelGroupDetails = nil
	}

	m.MemberModelEntries = model.MemberModelEntries

	m.LifecycleState = model.LifecycleState

	m.TimeCreated = model.TimeCreated

	m.TimeUpdated = model.TimeUpdated

	m.CreatedBy = model.CreatedBy

	return
}
