// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package certificatesmanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListCaBundlesRequest wrapper for the ListCaBundles operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/certificatesmanagement/ListCaBundles.go.html to see an example of how to use ListCaBundlesRequest.
type ListCaBundlesRequest struct {

	// Unique Oracle-assigned identifier for the request. If provided, the returned request ID
	// will include this value. Otherwise, a random request ID will be
	// generated by the service.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A filter that returns only resources that match the given compartment OCID.
	CompartmentId *string `mandatory:"false" contributesTo:"query" name:"compartmentId"`

	// A filter that returns only resources that match the given lifecycle state. The state value is case-insensitive.
	LifecycleState ListCaBundlesLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter that returns only resources that match the specified name.
	Name *string `mandatory:"false" contributesTo:"query" name:"name"`

	// The field to sort by. You can specify only one sort order. The default order for `TIMECREATED` is descending.
	// The default order for `NAME` is ascending.
	SortBy ListCaBundlesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The sort order to use, either ascending (`ASC`) or descending (`DESC`).
	SortOrder ListCaBundlesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The maximum number of items to return in a paginated "List" call.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The value of the `opc-next-page` response header
	// from the previous "List" call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The OCID of the CA bundle.
	CaBundleId *string `mandatory:"false" contributesTo:"query" name:"caBundleId"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListCaBundlesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListCaBundlesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListCaBundlesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListCaBundlesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListCaBundlesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListCaBundlesLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListCaBundlesLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListCaBundlesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListCaBundlesSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListCaBundlesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListCaBundlesSortOrderEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListCaBundlesResponse wrapper for the ListCaBundles operation
type ListCaBundlesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of CaBundleCollection instances
	CaBundleCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about
	// a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then there are additional items still to get. Include this value as the `page` parameter for the
	// subsequent GET request. For information about pagination, see
	// List Pagination (https://docs.oracle.com/iaas/Content/API/Concepts/usingapi.htm#List_Pagination).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListCaBundlesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListCaBundlesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListCaBundlesLifecycleStateEnum Enum with underlying type: string
type ListCaBundlesLifecycleStateEnum string

// Set of constants representing the allowable values for ListCaBundlesLifecycleStateEnum
const (
	ListCaBundlesLifecycleStateCreating ListCaBundlesLifecycleStateEnum = "CREATING"
	ListCaBundlesLifecycleStateActive   ListCaBundlesLifecycleStateEnum = "ACTIVE"
	ListCaBundlesLifecycleStateUpdating ListCaBundlesLifecycleStateEnum = "UPDATING"
	ListCaBundlesLifecycleStateDeleting ListCaBundlesLifecycleStateEnum = "DELETING"
	ListCaBundlesLifecycleStateDeleted  ListCaBundlesLifecycleStateEnum = "DELETED"
	ListCaBundlesLifecycleStateFailed   ListCaBundlesLifecycleStateEnum = "FAILED"
)

var mappingListCaBundlesLifecycleStateEnum = map[string]ListCaBundlesLifecycleStateEnum{
	"CREATING": ListCaBundlesLifecycleStateCreating,
	"ACTIVE":   ListCaBundlesLifecycleStateActive,
	"UPDATING": ListCaBundlesLifecycleStateUpdating,
	"DELETING": ListCaBundlesLifecycleStateDeleting,
	"DELETED":  ListCaBundlesLifecycleStateDeleted,
	"FAILED":   ListCaBundlesLifecycleStateFailed,
}

var mappingListCaBundlesLifecycleStateEnumLowerCase = map[string]ListCaBundlesLifecycleStateEnum{
	"creating": ListCaBundlesLifecycleStateCreating,
	"active":   ListCaBundlesLifecycleStateActive,
	"updating": ListCaBundlesLifecycleStateUpdating,
	"deleting": ListCaBundlesLifecycleStateDeleting,
	"deleted":  ListCaBundlesLifecycleStateDeleted,
	"failed":   ListCaBundlesLifecycleStateFailed,
}

// GetListCaBundlesLifecycleStateEnumValues Enumerates the set of values for ListCaBundlesLifecycleStateEnum
func GetListCaBundlesLifecycleStateEnumValues() []ListCaBundlesLifecycleStateEnum {
	values := make([]ListCaBundlesLifecycleStateEnum, 0)
	for _, v := range mappingListCaBundlesLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListCaBundlesLifecycleStateEnumStringValues Enumerates the set of values in String for ListCaBundlesLifecycleStateEnum
func GetListCaBundlesLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"ACTIVE",
		"UPDATING",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListCaBundlesLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListCaBundlesLifecycleStateEnum(val string) (ListCaBundlesLifecycleStateEnum, bool) {
	enum, ok := mappingListCaBundlesLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListCaBundlesSortByEnum Enum with underlying type: string
type ListCaBundlesSortByEnum string

// Set of constants representing the allowable values for ListCaBundlesSortByEnum
const (
	ListCaBundlesSortByName        ListCaBundlesSortByEnum = "NAME"
	ListCaBundlesSortByTimecreated ListCaBundlesSortByEnum = "TIMECREATED"
)

var mappingListCaBundlesSortByEnum = map[string]ListCaBundlesSortByEnum{
	"NAME":        ListCaBundlesSortByName,
	"TIMECREATED": ListCaBundlesSortByTimecreated,
}

var mappingListCaBundlesSortByEnumLowerCase = map[string]ListCaBundlesSortByEnum{
	"name":        ListCaBundlesSortByName,
	"timecreated": ListCaBundlesSortByTimecreated,
}

// GetListCaBundlesSortByEnumValues Enumerates the set of values for ListCaBundlesSortByEnum
func GetListCaBundlesSortByEnumValues() []ListCaBundlesSortByEnum {
	values := make([]ListCaBundlesSortByEnum, 0)
	for _, v := range mappingListCaBundlesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListCaBundlesSortByEnumStringValues Enumerates the set of values in String for ListCaBundlesSortByEnum
func GetListCaBundlesSortByEnumStringValues() []string {
	return []string{
		"NAME",
		"TIMECREATED",
	}
}

// GetMappingListCaBundlesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListCaBundlesSortByEnum(val string) (ListCaBundlesSortByEnum, bool) {
	enum, ok := mappingListCaBundlesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListCaBundlesSortOrderEnum Enum with underlying type: string
type ListCaBundlesSortOrderEnum string

// Set of constants representing the allowable values for ListCaBundlesSortOrderEnum
const (
	ListCaBundlesSortOrderAsc  ListCaBundlesSortOrderEnum = "ASC"
	ListCaBundlesSortOrderDesc ListCaBundlesSortOrderEnum = "DESC"
)

var mappingListCaBundlesSortOrderEnum = map[string]ListCaBundlesSortOrderEnum{
	"ASC":  ListCaBundlesSortOrderAsc,
	"DESC": ListCaBundlesSortOrderDesc,
}

var mappingListCaBundlesSortOrderEnumLowerCase = map[string]ListCaBundlesSortOrderEnum{
	"asc":  ListCaBundlesSortOrderAsc,
	"desc": ListCaBundlesSortOrderDesc,
}

// GetListCaBundlesSortOrderEnumValues Enumerates the set of values for ListCaBundlesSortOrderEnum
func GetListCaBundlesSortOrderEnumValues() []ListCaBundlesSortOrderEnum {
	values := make([]ListCaBundlesSortOrderEnum, 0)
	for _, v := range mappingListCaBundlesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListCaBundlesSortOrderEnumStringValues Enumerates the set of values in String for ListCaBundlesSortOrderEnum
func GetListCaBundlesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListCaBundlesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListCaBundlesSortOrderEnum(val string) (ListCaBundlesSortOrderEnum, bool) {
	enum, ok := mappingListCaBundlesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
