---
layout: default
title: Flag - Reference Manual - csvq
category: reference
---

# Flag

A flag is a representation of a [command option]({{ '/reference/command.html#options' | relative_url }}). 

## Flags

| name                        | type    | description                                                                    |
|:----------------------------|:--------|:-------------------------------------------------------------------------------|
| @@REPOSITORY                | string  | Directory path where files are located                                         |
| @@TIMEZONE                  | string  | Default TimeZone                                                               |
| @@DATETIME_FORMAT           | string  | Datetime Format to parse strings                                               |
| @@ANSI_QUOTES               | boolean | Use double quotation mark as identifier enclosure                              |
| @@STRICT_EQUAL              | boolean | Compare strictly that two values are equal for DISTINCT, GROUP BY and ORDER BY |
| @@WAIT_TIMEOUT              | float   | Limit of the waiting time in seconds to wait for locked files to be released   |
| @@IMPORT_FORMAT             | string  | Default format to load files                                                   |
| @@DELIMITER                 | string  | Field delimiter for CSV                                                        |
| @@ALLOW_UNEVEN_FIELDS       | boolean | Allow loading CSV files with uneven field length                               |
| @@DELIMITER_POSITIONS       | string  | Delimiter positions for Fixed-Length Format                                    |
| @@JSON_QUERY                | string  | Query for JSON data                                                            |
| @@ENCODING                  | string  | Character encoding                                                             |
| @@NO_HEADER                 | boolean | Import first line as a record                                                  |
| @@WITHOUT_NULL              | boolean | Parse empty fields as empty strings                                            |
| @@STRIP_ENDING_LINE_BREAK   | boolean | Strip line break from the end of files and query results                       |
| @@FORMAT                    | string  | Format of query results                                                        |
| @@WRITE_ENCODING            | string  | Character encoding of query results                                            |
| @@WRITE_DELIMITER           | string  | Field delimiter for query results in CSV                                       |
| @@WRITE_DELIMITER_POSITIONS | string  | Delimiter positions for query results in Fixed-Length Format                   |
| @@WITHOUT_HEADER            | boolean | Write without the header line in query results                                 |
| @@LINE_BREAK                | string  | Line Break in query results                                                    |
| @@ENCLOSE_ALL               | boolean | Enclose all string values in CSV                                               |
| @@JSON_ESCAPE               | string  | JSON escape type of query results                                              |
| @@PRETTY_PRINT              | boolean | Make JSON output easier to read in query results                               |
| @@SCIENTIFIC_NOTATION       | boolean | Use Scientific Notation for large exponents in output                          |
| @@EAST_ASIAN_ENCODING       | boolean | Count ambiguous characters as fullwidth                                        |
| @@COUNT_DIACRITICAL_SIGN    | boolean | Count diacritical signs as halfwidth                                           |
| @@COUNT_FORMAT_CODE         | boolean | Count format characters and zero-width spaces as halfwidth                     |
| @@COLOR                     | boolean | Use ANSI color escape sequences                                                |
| @@QUIET                     | boolean | Suppress operation log output                                                  |
| @@LIMIT_RECURSION           | integer | Maximum number of iterations for recursive queries                             |
| @@CPU                       | integer | Hint for the number of cpu cores to be used                                    |
| @@STATS                     | boolean | Show execution time                                                            |


### SET FLAG

```sql
SET @@flag_name TO value;
SET @@flag_name = value;
```

_value_
: [value]({{ '/reference/value.html' | relative_url }}) or [identifier]({{ '/reference/statement.html#parsing' | relative_url }})

A Set Flag statement is used to overwrite the flag value passed by using the command option. 

> @@DATETIME_FORMAT flag is appended to the current formats, not overwritten. 


### SHOW FLAG

```sql
SHOW @@flag_name;
```

A Show Flag statement outputs the flag value. 


### ADD FLAG ELEMENT

```sql
ADD value TO @@DATETIME_FORMAT;
```

_value_
: [string]({{ '/reference/value.html#string' | relative_url }})

An Add Flag Element statement is used to add datetime formats to _@@DATETIME_FORMAT_.

You can use JSON array of strings to set multiple format at once.


### REMOVE FLAG ELEMENT

```sql
REMOVE value FROM @@DATETIME_FORMAT;
```

_value_
: [string]({{ '/reference/value.html#string' | relative_url }}) or [integer]({{ '/reference/value.html#integer' | relative_url }})

A Remove Flag Element statement is used to remove a format from _@@DATETIME_FORMAT_.

If _value_ is a string, then the same element in the _@@DATETIME_FORMAT_ is removed.
If _value_ is an integer, then an element existing at the index number is removed.
