// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateChannelReader is a Reader for the PackerServiceUpdateChannel structure.
type PackerServiceUpdateChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateChannelDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateChannelOK creates a PackerServiceUpdateChannelOK with default headers values
func NewPackerServiceUpdateChannelOK() *PackerServiceUpdateChannelOK {
	return &PackerServiceUpdateChannelOK{}
}

/*
PackerServiceUpdateChannelOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateChannelOK struct {
	Payload *models.HashicorpCloudPackerUpdateChannelResponse
}

// IsSuccess returns true when this packer service update channel o k response has a 2xx status code
func (o *PackerServiceUpdateChannelOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update channel o k response has a 3xx status code
func (o *PackerServiceUpdateChannelOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update channel o k response has a 4xx status code
func (o *PackerServiceUpdateChannelOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update channel o k response has a 5xx status code
func (o *PackerServiceUpdateChannelOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update channel o k response a status code equal to that given
func (o *PackerServiceUpdateChannelOK) IsCode(code int) bool {
	return code == 200
}

func (o *PackerServiceUpdateChannelOK) Error() string {
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] packerServiceUpdateChannelOK  %+v", 200, o.Payload)
}

func (o *PackerServiceUpdateChannelOK) String() string {
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] packerServiceUpdateChannelOK  %+v", 200, o.Payload)
}

func (o *PackerServiceUpdateChannelOK) GetPayload() *models.HashicorpCloudPackerUpdateChannelResponse {
	return o.Payload
}

func (o *PackerServiceUpdateChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerUpdateChannelResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateChannelDefault creates a PackerServiceUpdateChannelDefault with default headers values
func NewPackerServiceUpdateChannelDefault(code int) *PackerServiceUpdateChannelDefault {
	return &PackerServiceUpdateChannelDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateChannelDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateChannelDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// Code gets the status code for the packer service update channel default response
func (o *PackerServiceUpdateChannelDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this packer service update channel default response has a 2xx status code
func (o *PackerServiceUpdateChannelDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update channel default response has a 3xx status code
func (o *PackerServiceUpdateChannelDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update channel default response has a 4xx status code
func (o *PackerServiceUpdateChannelDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update channel default response has a 5xx status code
func (o *PackerServiceUpdateChannelDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update channel default response a status code equal to that given
func (o *PackerServiceUpdateChannelDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *PackerServiceUpdateChannelDefault) Error() string {
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] PackerService_UpdateChannel default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceUpdateChannelDefault) String() string {
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] PackerService_UpdateChannel default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceUpdateChannelDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUpdateChannelDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PackerServiceUpdateChannelBody packer service update channel body
swagger:model PackerServiceUpdateChannelBody
*/
type PackerServiceUpdateChannelBody struct {

	// Fingerprint of the iteration. The fingerprint is set by Packer when you
	// call `packer build`. It will most often correspond to a git commit sha,
	// but can be manually overridden by setting the environment variable
	// `HCP_PACKER_BUILD_FINGERPRINT`.
	Fingerprint string `json:"fingerprint,omitempty"`

	// The human-readable version number assigned to this iteration.
	IncrementalVersion int32 `json:"incremental_version,omitempty"`

	// ULID of the iteration. This was created and set by the
	// HCP Packer registry when the iteration was created.
	IterationID string `json:"iteration_id,omitempty"`

	// location
	Location *PackerServiceUpdateChannelParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this packer service update channel body
func (o *PackerServiceUpdateChannelBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateChannelBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service update channel body based on the context it is used
func (o *PackerServiceUpdateChannelBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateChannelBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceUpdateChannelBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceUpdateChannelBody) UnmarshalBinary(b []byte) error {
	var res PackerServiceUpdateChannelBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PackerServiceUpdateChannelParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model PackerServiceUpdateChannelParamsBodyLocation
*/
type PackerServiceUpdateChannelParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this packer service update channel params body location
func (o *PackerServiceUpdateChannelParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateChannelParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service update channel params body location based on the context it is used
func (o *PackerServiceUpdateChannelParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateChannelParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {
		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceUpdateChannelParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceUpdateChannelParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res PackerServiceUpdateChannelParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
