// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// CreateClusterReader is a Reader for the CreateCluster structure.
type CreateClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateClusterOK creates a CreateClusterOK with default headers values
func NewCreateClusterOK() *CreateClusterOK {
	return &CreateClusterOK{}
}

/*
CreateClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateClusterOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215CreateClusterResponse
}

// IsSuccess returns true when this create cluster o k response has a 2xx status code
func (o *CreateClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create cluster o k response has a 3xx status code
func (o *CreateClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create cluster o k response has a 4xx status code
func (o *CreateClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create cluster o k response has a 5xx status code
func (o *CreateClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create cluster o k response a status code equal to that given
func (o *CreateClusterOK) IsCode(code int) bool {
	return code == 200
}

func (o *CreateClusterOK) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] createClusterOK  %+v", 200, o.Payload)
}

func (o *CreateClusterOK) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] createClusterOK  %+v", 200, o.Payload)
}

func (o *CreateClusterOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215CreateClusterResponse {
	return o.Payload
}

func (o *CreateClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215CreateClusterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateClusterDefault creates a CreateClusterDefault with default headers values
func NewCreateClusterDefault(code int) *CreateClusterDefault {
	return &CreateClusterDefault{
		_statusCode: code,
	}
}

/*
CreateClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateClusterDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the create cluster default response
func (o *CreateClusterDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this create cluster default response has a 2xx status code
func (o *CreateClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create cluster default response has a 3xx status code
func (o *CreateClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create cluster default response has a 4xx status code
func (o *CreateClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create cluster default response has a 5xx status code
func (o *CreateClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create cluster default response a status code equal to that given
func (o *CreateClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *CreateClusterDefault) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] CreateCluster default  %+v", o._statusCode, o.Payload)
}

func (o *CreateClusterDefault) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters][%d] CreateCluster default  %+v", o._statusCode, o.Payload)
}

func (o *CreateClusterDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *CreateClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
