// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fis

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateExperimentTemplate = "CreateExperimentTemplate"

// CreateExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExperimentTemplate for more information on using the CreateExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExperimentTemplateRequest method.
//    req, resp := client.CreateExperimentTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate
func (c *FIS) CreateExperimentTemplateRequest(input *CreateExperimentTemplateInput) (req *request.Request, output *CreateExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateExperimentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/experimentTemplates",
	}

	if input == nil {
		input = &CreateExperimentTemplateInput{}
	}

	output = &CreateExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Creates an experiment template.
//
// To create a template, specify the following information:
//
//    * Targets: A target can be a specific resource in your AWS environment,
//    or one or more resources that match criteria that you specify, for example,
//    resources that have specific tags.
//
//    * Actions: The actions to carry out on the target. You can specify multiple
//    actions, the duration of each action, and when to start each action during
//    an experiment.
//
//    * Stop conditions: If a stop condition is triggered while an experiment
//    is running, the experiment is automatically stopped. You can define a
//    stop condition as a CloudWatch alarm.
//
// For more information, see the AWS Fault Injection Simulator User Guide (https://docs.aws.amazon.com/fis/latest/userguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation CreateExperimentTemplate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ConflictException
//   The request could not be processed because of a conflict.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
//   * ServiceQuotaExceededException
//   You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplate
func (c *FIS) CreateExperimentTemplate(input *CreateExperimentTemplateInput) (*CreateExperimentTemplateOutput, error) {
	req, out := c.CreateExperimentTemplateRequest(input)
	return out, req.Send()
}

// CreateExperimentTemplateWithContext is the same as CreateExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) CreateExperimentTemplateWithContext(ctx aws.Context, input *CreateExperimentTemplateInput, opts ...request.Option) (*CreateExperimentTemplateOutput, error) {
	req, out := c.CreateExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExperimentTemplate = "DeleteExperimentTemplate"

// DeleteExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExperimentTemplate for more information on using the DeleteExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteExperimentTemplateRequest method.
//    req, resp := client.DeleteExperimentTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate
func (c *FIS) DeleteExperimentTemplateRequest(input *DeleteExperimentTemplateInput) (req *request.Request, output *DeleteExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteExperimentTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/experimentTemplates/{id}",
	}

	if input == nil {
		input = &DeleteExperimentTemplateInput{}
	}

	output = &DeleteExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Deletes the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation DeleteExperimentTemplate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/DeleteExperimentTemplate
func (c *FIS) DeleteExperimentTemplate(input *DeleteExperimentTemplateInput) (*DeleteExperimentTemplateOutput, error) {
	req, out := c.DeleteExperimentTemplateRequest(input)
	return out, req.Send()
}

// DeleteExperimentTemplateWithContext is the same as DeleteExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) DeleteExperimentTemplateWithContext(ctx aws.Context, input *DeleteExperimentTemplateInput, opts ...request.Option) (*DeleteExperimentTemplateOutput, error) {
	req, out := c.DeleteExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAction = "GetAction"

// GetActionRequest generates a "aws/request.Request" representing the
// client's request for the GetAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAction for more information on using the GetAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetActionRequest method.
//    req, resp := client.GetActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction
func (c *FIS) GetActionRequest(input *GetActionInput) (req *request.Request, output *GetActionOutput) {
	op := &request.Operation{
		Name:       opGetAction,
		HTTPMethod: "GET",
		HTTPPath:   "/actions/{id}",
	}

	if input == nil {
		input = &GetActionInput{}
	}

	output = &GetActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAction API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified AWS FIS action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetAction for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetAction
func (c *FIS) GetAction(input *GetActionInput) (*GetActionOutput, error) {
	req, out := c.GetActionRequest(input)
	return out, req.Send()
}

// GetActionWithContext is the same as GetAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetActionWithContext(ctx aws.Context, input *GetActionInput, opts ...request.Option) (*GetActionOutput, error) {
	req, out := c.GetActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperiment = "GetExperiment"

// GetExperimentRequest generates a "aws/request.Request" representing the
// client's request for the GetExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperiment for more information on using the GetExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExperimentRequest method.
//    req, resp := client.GetExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment
func (c *FIS) GetExperimentRequest(input *GetExperimentInput) (req *request.Request, output *GetExperimentOutput) {
	op := &request.Operation{
		Name:       opGetExperiment,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments/{id}",
	}

	if input == nil {
		input = &GetExperimentInput{}
	}

	output = &GetExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperiment API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetExperiment for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperiment
func (c *FIS) GetExperiment(input *GetExperimentInput) (*GetExperimentOutput, error) {
	req, out := c.GetExperimentRequest(input)
	return out, req.Send()
}

// GetExperimentWithContext is the same as GetExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetExperimentWithContext(ctx aws.Context, input *GetExperimentInput, opts ...request.Option) (*GetExperimentOutput, error) {
	req, out := c.GetExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperimentTemplate = "GetExperimentTemplate"

// GetExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperimentTemplate for more information on using the GetExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExperimentTemplateRequest method.
//    req, resp := client.GetExperimentTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate
func (c *FIS) GetExperimentTemplateRequest(input *GetExperimentTemplateInput) (req *request.Request, output *GetExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opGetExperimentTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/experimentTemplates/{id}",
	}

	if input == nil {
		input = &GetExperimentTemplateInput{}
	}

	output = &GetExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Gets information about the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation GetExperimentTemplate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/GetExperimentTemplate
func (c *FIS) GetExperimentTemplate(input *GetExperimentTemplateInput) (*GetExperimentTemplateOutput, error) {
	req, out := c.GetExperimentTemplateRequest(input)
	return out, req.Send()
}

// GetExperimentTemplateWithContext is the same as GetExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) GetExperimentTemplateWithContext(ctx aws.Context, input *GetExperimentTemplateInput, opts ...request.Option) (*GetExperimentTemplateOutput, error) {
	req, out := c.GetExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActions = "ListActions"

// ListActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActions for more information on using the ListActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActionsRequest method.
//    req, resp := client.ListActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions
func (c *FIS) ListActionsRequest(input *ListActionsInput) (req *request.Request, output *ListActionsOutput) {
	op := &request.Operation{
		Name:       opListActions,
		HTTPMethod: "GET",
		HTTPPath:   "/actions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActionsInput{}
	}

	output = &ListActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActions API operation for AWS Fault Injection Simulator.
//
// Lists the available AWS FIS actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListActions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListActions
func (c *FIS) ListActions(input *ListActionsInput) (*ListActionsOutput, error) {
	req, out := c.ListActionsRequest(input)
	return out, req.Send()
}

// ListActionsWithContext is the same as ListActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListActionsWithContext(ctx aws.Context, input *ListActionsInput, opts ...request.Option) (*ListActionsOutput, error) {
	req, out := c.ListActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActionsPages iterates over the pages of a ListActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListActions operation.
//    pageNum := 0
//    err := client.ListActionsPages(params,
//        func(page *fis.ListActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FIS) ListActionsPages(input *ListActionsInput, fn func(*ListActionsOutput, bool) bool) error {
	return c.ListActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActionsPagesWithContext same as ListActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListActionsPagesWithContext(ctx aws.Context, input *ListActionsInput, fn func(*ListActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperimentTemplates = "ListExperimentTemplates"

// ListExperimentTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListExperimentTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperimentTemplates for more information on using the ListExperimentTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExperimentTemplatesRequest method.
//    req, resp := client.ListExperimentTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates
func (c *FIS) ListExperimentTemplatesRequest(input *ListExperimentTemplatesInput) (req *request.Request, output *ListExperimentTemplatesOutput) {
	op := &request.Operation{
		Name:       opListExperimentTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/experimentTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentTemplatesInput{}
	}

	output = &ListExperimentTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperimentTemplates API operation for AWS Fault Injection Simulator.
//
// Lists your experiment templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListExperimentTemplates for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentTemplates
func (c *FIS) ListExperimentTemplates(input *ListExperimentTemplatesInput) (*ListExperimentTemplatesOutput, error) {
	req, out := c.ListExperimentTemplatesRequest(input)
	return out, req.Send()
}

// ListExperimentTemplatesWithContext is the same as ListExperimentTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperimentTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentTemplatesWithContext(ctx aws.Context, input *ListExperimentTemplatesInput, opts ...request.Option) (*ListExperimentTemplatesOutput, error) {
	req, out := c.ListExperimentTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentTemplatesPages iterates over the pages of a ListExperimentTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperimentTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExperimentTemplates operation.
//    pageNum := 0
//    err := client.ListExperimentTemplatesPages(params,
//        func(page *fis.ListExperimentTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FIS) ListExperimentTemplatesPages(input *ListExperimentTemplatesInput, fn func(*ListExperimentTemplatesOutput, bool) bool) error {
	return c.ListExperimentTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentTemplatesPagesWithContext same as ListExperimentTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentTemplatesPagesWithContext(ctx aws.Context, input *ListExperimentTemplatesInput, fn func(*ListExperimentTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperiments = "ListExperiments"

// ListExperimentsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperiments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperiments for more information on using the ListExperiments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExperimentsRequest method.
//    req, resp := client.ListExperimentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments
func (c *FIS) ListExperimentsRequest(input *ListExperimentsInput) (req *request.Request, output *ListExperimentsOutput) {
	op := &request.Operation{
		Name:       opListExperiments,
		HTTPMethod: "GET",
		HTTPPath:   "/experiments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentsInput{}
	}

	output = &ListExperimentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperiments API operation for AWS Fault Injection Simulator.
//
// Lists your experiments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListExperiments for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperiments
func (c *FIS) ListExperiments(input *ListExperimentsInput) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	return out, req.Send()
}

// ListExperimentsWithContext is the same as ListExperiments with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperiments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentsWithContext(ctx aws.Context, input *ListExperimentsInput, opts ...request.Option) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentsPages iterates over the pages of a ListExperiments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperiments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExperiments operation.
//    pageNum := 0
//    err := client.ListExperimentsPages(params,
//        func(page *fis.ListExperimentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FIS) ListExperimentsPages(input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool) error {
	return c.ListExperimentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentsPagesWithContext same as ListExperimentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListExperimentsPagesWithContext(ctx aws.Context, input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource
func (c *FIS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Fault Injection Simulator.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListTagsForResource
func (c *FIS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExperiment = "StartExperiment"

// StartExperimentRequest generates a "aws/request.Request" representing the
// client's request for the StartExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExperiment for more information on using the StartExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExperimentRequest method.
//    req, resp := client.StartExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment
func (c *FIS) StartExperimentRequest(input *StartExperimentInput) (req *request.Request, output *StartExperimentOutput) {
	op := &request.Operation{
		Name:       opStartExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/experiments",
	}

	if input == nil {
		input = &StartExperimentInput{}
	}

	output = &StartExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExperiment API operation for AWS Fault Injection Simulator.
//
// Starts running an experiment from the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation StartExperiment for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ConflictException
//   The request could not be processed because of a conflict.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
//   * ServiceQuotaExceededException
//   You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StartExperiment
func (c *FIS) StartExperiment(input *StartExperimentInput) (*StartExperimentOutput, error) {
	req, out := c.StartExperimentRequest(input)
	return out, req.Send()
}

// StartExperimentWithContext is the same as StartExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See StartExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) StartExperimentWithContext(ctx aws.Context, input *StartExperimentInput, opts ...request.Option) (*StartExperimentOutput, error) {
	req, out := c.StartExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopExperiment = "StopExperiment"

// StopExperimentRequest generates a "aws/request.Request" representing the
// client's request for the StopExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopExperiment for more information on using the StopExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopExperimentRequest method.
//    req, resp := client.StopExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment
func (c *FIS) StopExperimentRequest(input *StopExperimentInput) (req *request.Request, output *StopExperimentOutput) {
	op := &request.Operation{
		Name:       opStopExperiment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/experiments/{id}",
	}

	if input == nil {
		input = &StopExperimentInput{}
	}

	output = &StopExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopExperiment API operation for AWS Fault Injection Simulator.
//
// Stops the specified experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation StopExperiment for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/StopExperiment
func (c *FIS) StopExperiment(input *StopExperimentInput) (*StopExperimentOutput, error) {
	req, out := c.StopExperimentRequest(input)
	return out, req.Send()
}

// StopExperimentWithContext is the same as StopExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See StopExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) StopExperimentWithContext(ctx aws.Context, input *StopExperimentInput, opts ...request.Option) (*StopExperimentOutput, error) {
	req, out := c.StopExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource
func (c *FIS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Fault Injection Simulator.
//
// Applies the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/TagResource
func (c *FIS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource
func (c *FIS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Fault Injection Simulator.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UntagResource
func (c *FIS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExperimentTemplate = "UpdateExperimentTemplate"

// UpdateExperimentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExperimentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExperimentTemplate for more information on using the UpdateExperimentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateExperimentTemplateRequest method.
//    req, resp := client.UpdateExperimentTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate
func (c *FIS) UpdateExperimentTemplateRequest(input *UpdateExperimentTemplateInput) (req *request.Request, output *UpdateExperimentTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateExperimentTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/experimentTemplates/{id}",
	}

	if input == nil {
		input = &UpdateExperimentTemplateInput{}
	}

	output = &UpdateExperimentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExperimentTemplate API operation for AWS Fault Injection Simulator.
//
// Updates the specified experiment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Fault Injection Simulator's
// API operation UpdateExperimentTemplate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is not valid, or fails to satisfy the constraints for
//   the request.
//
//   * ResourceNotFoundException
//   The specified resource cannot be found.
//
//   * ServiceQuotaExceededException
//   You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/UpdateExperimentTemplate
func (c *FIS) UpdateExperimentTemplate(input *UpdateExperimentTemplateInput) (*UpdateExperimentTemplateOutput, error) {
	req, out := c.UpdateExperimentTemplateRequest(input)
	return out, req.Send()
}

// UpdateExperimentTemplateWithContext is the same as UpdateExperimentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExperimentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FIS) UpdateExperimentTemplateWithContext(ctx aws.Context, input *UpdateExperimentTemplateInput, opts ...request.Option) (*UpdateExperimentTemplateOutput, error) {
	req, out := c.UpdateExperimentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes an action. For more information, see AWS FIS actions (https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html)
// in the AWS Fault Injection Simulator User Guide.
type Action struct {
	_ struct{} `type:"structure"`

	// The description for the action.
	Description *string `locationName:"description" type:"string"`

	// The ID of the action.
	Id *string `locationName:"id" type:"string"`

	// The action parameters, if applicable.
	Parameters map[string]*ActionParameter `locationName:"parameters" type:"map"`

	// The tags for the action.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The supported targets for the action.
	Targets map[string]*ActionTarget `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Action) SetDescription(v string) *Action {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Action) SetId(v string) *Action {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Action) SetParameters(v map[string]*ActionParameter) *Action {
	s.Parameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Action) SetTags(v map[string]*string) *Action {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Action) SetTargets(v map[string]*ActionTarget) *Action {
	s.Targets = v
	return s
}

// Describes a parameter for an action.
type ActionParameter struct {
	_ struct{} `type:"structure"`

	// The parameter description.
	Description *string `locationName:"description" type:"string"`

	// Indicates whether the parameter is required.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation
func (s ActionParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionParameter) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ActionParameter) SetDescription(v string) *ActionParameter {
	s.Description = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ActionParameter) SetRequired(v bool) *ActionParameter {
	s.Required = &v
	return s
}

// Provides a summary of an action.
type ActionSummary struct {
	_ struct{} `type:"structure"`

	// The description for the action.
	Description *string `locationName:"description" type:"string"`

	// The ID of the action.
	Id *string `locationName:"id" type:"string"`

	// The tags for the action.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the action.
	Targets map[string]*ActionTarget `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s ActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ActionSummary) SetDescription(v string) *ActionSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActionSummary) SetId(v string) *ActionSummary {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ActionSummary) SetTags(v map[string]*string) *ActionSummary {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ActionSummary) SetTargets(v map[string]*ActionTarget) *ActionSummary {
	s.Targets = v
	return s
}

// Describes a target for an action.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The resource type of the target.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetResourceType sets the ResourceType field's value.
func (s *ActionTarget) SetResourceType(v string) *ActionTarget {
	s.ResourceType = &v
	return s
}

// The request could not be processed because of a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies an action for an experiment template.
type CreateExperimentTemplateActionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	//
	// ActionId is a required field
	ActionId *string `locationName:"actionId" type:"string" required:"true"`

	// A description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action, if applicable.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before the current action starts.
	// Omit this parameter to run the action at the start of the experiment.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s CreateExperimentTemplateActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentTemplateActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateActionInput"}
	if s.ActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionId sets the ActionId field's value.
func (s *CreateExperimentTemplateActionInput) SetActionId(v string) *CreateExperimentTemplateActionInput {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateExperimentTemplateActionInput) SetDescription(v string) *CreateExperimentTemplateActionInput {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExperimentTemplateActionInput) SetParameters(v map[string]*string) *CreateExperimentTemplateActionInput {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *CreateExperimentTemplateActionInput) SetStartAfter(v []*string) *CreateExperimentTemplateActionInput {
	s.StartAfter = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateExperimentTemplateActionInput) SetTargets(v map[string]*string) *CreateExperimentTemplateActionInput {
	s.Targets = v
	return s
}

type CreateExperimentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	//
	// Actions is a required field
	Actions map[string]*CreateExperimentTemplateActionInput `locationName:"actions" type:"map" required:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description for the experiment template. Can contain up to 64 letters (A-Z
	// and a-z).
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service
	// permission to perform service actions on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The stop conditions.
	//
	// StopConditions is a required field
	StopConditions []*CreateExperimentTemplateStopConditionInput `locationName:"stopConditions" type:"list" required:"true"`

	// The tags to apply to the experiment template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the experiment.
	Targets map[string]*CreateExperimentTemplateTargetInput `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s CreateExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StopConditions == nil {
		invalidParams.Add(request.NewErrParamRequired("StopConditions"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StopConditions != nil {
		for i, v := range s.StopConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StopConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateExperimentTemplateInput) SetActions(v map[string]*CreateExperimentTemplateActionInput) *CreateExperimentTemplateInput {
	s.Actions = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateExperimentTemplateInput) SetClientToken(v string) *CreateExperimentTemplateInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateExperimentTemplateInput) SetDescription(v string) *CreateExperimentTemplateInput {
	s.Description = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateExperimentTemplateInput) SetRoleArn(v string) *CreateExperimentTemplateInput {
	s.RoleArn = &v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *CreateExperimentTemplateInput) SetStopConditions(v []*CreateExperimentTemplateStopConditionInput) *CreateExperimentTemplateInput {
	s.StopConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExperimentTemplateInput) SetTags(v map[string]*string) *CreateExperimentTemplateInput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateExperimentTemplateInput) SetTargets(v map[string]*CreateExperimentTemplateTargetInput) *CreateExperimentTemplateInput {
	s.Targets = v
	return s
}

type CreateExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation
func (s CreateExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *CreateExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *CreateExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

// Specifies a stop condition for an experiment template.
type CreateExperimentTemplateStopConditionInput struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition. Specify aws:cloudwatch:alarm if the stop
	// condition is defined by a CloudWatch alarm. Specify none if there is no stop
	// condition.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required
	// if the source is a CloudWatch alarm.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation
func (s CreateExperimentTemplateStopConditionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentTemplateStopConditionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateStopConditionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateStopConditionInput"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Value != nil && len(*s.Value) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *CreateExperimentTemplateStopConditionInput) SetSource(v string) *CreateExperimentTemplateStopConditionInput {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CreateExperimentTemplateStopConditionInput) SetValue(v string) *CreateExperimentTemplateStopConditionInput {
	s.Value = &v
	return s
}

// Specifies a target for an experiment. You must specify at least one Amazon
// Resource Name (ARN) or at least one resource tag. You cannot specify both
// ARNs and tags.
type CreateExperimentTemplateTargetInput struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTemplateTargetInputFilter `locationName:"filters" type:"list"`

	// The Amazon Resource Names (ARNs) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The AWS resource type. The resource type must be supported for the specified
	// action.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Scopes the identified resources to a specific count of the resources at random,
	// or a percentage of the resources. All identified resources are included in
	// the target.
	//
	//    * ALL - Run the action on all identified targets. This is the default.
	//
	//    * COUNT(n) - Run the action on the specified number of targets, chosen
	//    from the identified targets at random. For example, COUNT(1) selects one
	//    of the targets.
	//
	//    * PERCENT(n) - Run the action on the specified percentage of targets,
	//    chosen from the identified targets at random. For example, PERCENT(25)
	//    selects 25% of the targets.
	//
	// SelectionMode is a required field
	SelectionMode *string `locationName:"selectionMode" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateExperimentTemplateTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExperimentTemplateTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentTemplateTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentTemplateTargetInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.SelectionMode == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionMode"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *CreateExperimentTemplateTargetInput) SetFilters(v []*ExperimentTemplateTargetInputFilter) *CreateExperimentTemplateTargetInput {
	s.Filters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *CreateExperimentTemplateTargetInput) SetResourceArns(v []*string) *CreateExperimentTemplateTargetInput {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateExperimentTemplateTargetInput) SetResourceTags(v map[string]*string) *CreateExperimentTemplateTargetInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreateExperimentTemplateTargetInput) SetResourceType(v string) *CreateExperimentTemplateTargetInput {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *CreateExperimentTemplateTargetInput) SetSelectionMode(v string) *CreateExperimentTemplateTargetInput {
	s.SelectionMode = &v
	return s
}

type DeleteExperimentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the experiment template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExperimentTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteExperimentTemplateInput) SetId(v string) *DeleteExperimentTemplateInput {
	s.Id = &v
	return s
}

type DeleteExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation
func (s DeleteExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *DeleteExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *DeleteExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

// Describes an experiment.
type Experiment struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	Actions map[string]*ExperimentAction `locationName:"actions" type:"map"`

	// The time the experiment was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time that the experiment ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of the experiment template.
	ExperimentTemplateId *string `locationName:"experimentTemplateId" type:"string"`

	// The ID of the experiment.
	Id *string `locationName:"id" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service
	// permission to perform service actions on your behalf.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The time that the experiment was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The state of the experiment.
	State *ExperimentState `locationName:"state" type:"structure"`

	// The stop conditions for the experiment.
	StopConditions []*ExperimentStopCondition `locationName:"stopConditions" type:"list"`

	// The tags for the experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the experiment.
	Targets map[string]*ExperimentTarget `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s Experiment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Experiment) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Experiment) SetActions(v map[string]*ExperimentAction) *Experiment {
	s.Actions = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Experiment) SetCreationTime(v time.Time) *Experiment {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Experiment) SetEndTime(v time.Time) *Experiment {
	s.EndTime = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *Experiment) SetExperimentTemplateId(v string) *Experiment {
	s.ExperimentTemplateId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Experiment) SetId(v string) *Experiment {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Experiment) SetRoleArn(v string) *Experiment {
	s.RoleArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Experiment) SetStartTime(v time.Time) *Experiment {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Experiment) SetState(v *ExperimentState) *Experiment {
	s.State = v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *Experiment) SetStopConditions(v []*ExperimentStopCondition) *Experiment {
	s.StopConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Experiment) SetTags(v map[string]*string) *Experiment {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Experiment) SetTargets(v map[string]*ExperimentTarget) *Experiment {
	s.Targets = v
	return s
}

// Describes the action for an experiment.
type ExperimentAction struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	ActionId *string `locationName:"actionId" type:"string"`

	// The description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before this action starts.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The state of the action.
	State *ExperimentActionState `locationName:"state" type:"structure"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s ExperimentAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentAction) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *ExperimentAction) SetActionId(v string) *ExperimentAction {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentAction) SetDescription(v string) *ExperimentAction {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExperimentAction) SetParameters(v map[string]*string) *ExperimentAction {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ExperimentAction) SetStartAfter(v []*string) *ExperimentAction {
	s.StartAfter = v
	return s
}

// SetState sets the State field's value.
func (s *ExperimentAction) SetState(v *ExperimentActionState) *ExperimentAction {
	s.State = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ExperimentAction) SetTargets(v map[string]*string) *ExperimentAction {
	s.Targets = v
	return s
}

// Describes the state of an action.
type ExperimentActionState struct {
	_ struct{} `type:"structure"`

	// The reason for the state.
	Reason *string `locationName:"reason" type:"string"`

	// The state of the action.
	Status *string `locationName:"status" type:"string" enum:"ExperimentActionStatus"`
}

// String returns the string representation
func (s ExperimentActionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentActionState) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ExperimentActionState) SetReason(v string) *ExperimentActionState {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExperimentActionState) SetStatus(v string) *ExperimentActionState {
	s.Status = &v
	return s
}

// Describes the state of an experiment.
type ExperimentState struct {
	_ struct{} `type:"structure"`

	// The reason for the state.
	Reason *string `locationName:"reason" type:"string"`

	// The state of the experiment.
	Status *string `locationName:"status" type:"string" enum:"ExperimentStatus"`
}

// String returns the string representation
func (s ExperimentState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentState) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ExperimentState) SetReason(v string) *ExperimentState {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExperimentState) SetStatus(v string) *ExperimentState {
	s.Status = &v
	return s
}

// Describes the stop condition for an experiment.
type ExperimentStopCondition struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition.
	Source *string `locationName:"source" type:"string"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation
func (s ExperimentStopCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentStopCondition) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *ExperimentStopCondition) SetSource(v string) *ExperimentStopCondition {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExperimentStopCondition) SetValue(v string) *ExperimentStopCondition {
	s.Value = &v
	return s
}

// Provides a summary of an experiment.
type ExperimentSummary struct {
	_ struct{} `type:"structure"`

	// The time that the experiment was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ID of the experiment template.
	ExperimentTemplateId *string `locationName:"experimentTemplateId" type:"string"`

	// The ID of the experiment.
	Id *string `locationName:"id" type:"string"`

	// The state of the experiment.
	State *ExperimentState `locationName:"state" type:"structure"`

	// The tags for the experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ExperimentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentSummary) SetCreationTime(v time.Time) *ExperimentSummary {
	s.CreationTime = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *ExperimentSummary) SetExperimentTemplateId(v string) *ExperimentSummary {
	s.ExperimentTemplateId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExperimentSummary) SetId(v string) *ExperimentSummary {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *ExperimentSummary) SetState(v *ExperimentState) *ExperimentSummary {
	s.State = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ExperimentSummary) SetTags(v map[string]*string) *ExperimentSummary {
	s.Tags = v
	return s
}

// Describes a target for an experiment.
type ExperimentTarget struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTargetFilter `locationName:"filters" type:"list"`

	// The Amazon Resource Names (ARNs) of the resources.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Scopes the identified resources to a specific count or percentage.
	SelectionMode *string `locationName:"selectionMode" type:"string"`
}

// String returns the string representation
func (s ExperimentTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTarget) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ExperimentTarget) SetFilters(v []*ExperimentTargetFilter) *ExperimentTarget {
	s.Filters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ExperimentTarget) SetResourceArns(v []*string) *ExperimentTarget {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ExperimentTarget) SetResourceTags(v map[string]*string) *ExperimentTarget {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ExperimentTarget) SetResourceType(v string) *ExperimentTarget {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *ExperimentTarget) SetSelectionMode(v string) *ExperimentTarget {
	s.SelectionMode = &v
	return s
}

// Describes a filter used for the target resources in an experiment.
type ExperimentTargetFilter struct {
	_ struct{} `type:"structure"`

	// The attribute path for the filter.
	Path *string `locationName:"path" type:"string"`

	// The attribute values for the filter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s ExperimentTargetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTargetFilter) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *ExperimentTargetFilter) SetPath(v string) *ExperimentTargetFilter {
	s.Path = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentTargetFilter) SetValues(v []*string) *ExperimentTargetFilter {
	s.Values = v
	return s
}

// Describes an experiment template.
type ExperimentTemplate struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	Actions map[string]*ExperimentTemplateAction `locationName:"actions" type:"map"`

	// The time the experiment template was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description for the experiment template.
	Description *string `locationName:"description" type:"string"`

	// The ID of the experiment template.
	Id *string `locationName:"id" type:"string"`

	// The time the experiment template was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of an IAM role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The stop conditions for the experiment.
	StopConditions []*ExperimentTemplateStopCondition `locationName:"stopConditions" type:"list"`

	// The tags for the experiment template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the experiment.
	Targets map[string]*ExperimentTemplateTarget `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s ExperimentTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplate) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *ExperimentTemplate) SetActions(v map[string]*ExperimentTemplateAction) *ExperimentTemplate {
	s.Actions = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentTemplate) SetCreationTime(v time.Time) *ExperimentTemplate {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTemplate) SetDescription(v string) *ExperimentTemplate {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExperimentTemplate) SetId(v string) *ExperimentTemplate {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ExperimentTemplate) SetLastUpdateTime(v time.Time) *ExperimentTemplate {
	s.LastUpdateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExperimentTemplate) SetRoleArn(v string) *ExperimentTemplate {
	s.RoleArn = &v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *ExperimentTemplate) SetStopConditions(v []*ExperimentTemplateStopCondition) *ExperimentTemplate {
	s.StopConditions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ExperimentTemplate) SetTags(v map[string]*string) *ExperimentTemplate {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ExperimentTemplate) SetTargets(v map[string]*ExperimentTemplateTarget) *ExperimentTemplate {
	s.Targets = v
	return s
}

// Describes an action for an experiment template.
type ExperimentTemplateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	ActionId *string `locationName:"actionId" type:"string"`

	// A description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before the current action starts.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s ExperimentTemplateAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplateAction) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *ExperimentTemplateAction) SetActionId(v string) *ExperimentTemplateAction {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTemplateAction) SetDescription(v string) *ExperimentTemplateAction {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExperimentTemplateAction) SetParameters(v map[string]*string) *ExperimentTemplateAction {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ExperimentTemplateAction) SetStartAfter(v []*string) *ExperimentTemplateAction {
	s.StartAfter = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ExperimentTemplateAction) SetTargets(v map[string]*string) *ExperimentTemplateAction {
	s.Targets = v
	return s
}

// Describes a stop condition for an experiment template.
type ExperimentTemplateStopCondition struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition.
	Source *string `locationName:"source" type:"string"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation
func (s ExperimentTemplateStopCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplateStopCondition) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *ExperimentTemplateStopCondition) SetSource(v string) *ExperimentTemplateStopCondition {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExperimentTemplateStopCondition) SetValue(v string) *ExperimentTemplateStopCondition {
	s.Value = &v
	return s
}

// Provides a summary of an experiment template.
type ExperimentTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The time that the experiment template was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the experiment template.
	Description *string `locationName:"description" type:"string"`

	// The ID of the experiment template.
	Id *string `locationName:"id" type:"string"`

	// The time that the experiment template was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The tags for the experiment template.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ExperimentTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplateSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExperimentTemplateSummary) SetCreationTime(v time.Time) *ExperimentTemplateSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExperimentTemplateSummary) SetDescription(v string) *ExperimentTemplateSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExperimentTemplateSummary) SetId(v string) *ExperimentTemplateSummary {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ExperimentTemplateSummary) SetLastUpdateTime(v time.Time) *ExperimentTemplateSummary {
	s.LastUpdateTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ExperimentTemplateSummary) SetTags(v map[string]*string) *ExperimentTemplateSummary {
	s.Tags = v
	return s
}

// Describes a target for an experiment template.
type ExperimentTemplateTarget struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTemplateTargetFilter `locationName:"filters" type:"list"`

	// The Amazon Resource Names (ARNs) of the targets.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Scopes the identified resources to a specific count or percentage.
	SelectionMode *string `locationName:"selectionMode" type:"string"`
}

// String returns the string representation
func (s ExperimentTemplateTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplateTarget) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ExperimentTemplateTarget) SetFilters(v []*ExperimentTemplateTargetFilter) *ExperimentTemplateTarget {
	s.Filters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ExperimentTemplateTarget) SetResourceArns(v []*string) *ExperimentTemplateTarget {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ExperimentTemplateTarget) SetResourceTags(v map[string]*string) *ExperimentTemplateTarget {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ExperimentTemplateTarget) SetResourceType(v string) *ExperimentTemplateTarget {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *ExperimentTemplateTarget) SetSelectionMode(v string) *ExperimentTemplateTarget {
	s.SelectionMode = &v
	return s
}

// Describes a filter used for the target resources in an experiment template.
type ExperimentTemplateTargetFilter struct {
	_ struct{} `type:"structure"`

	// The attribute path for the filter.
	Path *string `locationName:"path" type:"string"`

	// The attribute values for the filter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s ExperimentTemplateTargetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplateTargetFilter) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *ExperimentTemplateTargetFilter) SetPath(v string) *ExperimentTemplateTargetFilter {
	s.Path = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentTemplateTargetFilter) SetValues(v []*string) *ExperimentTemplateTargetFilter {
	s.Values = v
	return s
}

// Describes a filter used for the target resource input in an experiment template.
type ExperimentTemplateTargetInputFilter struct {
	_ struct{} `type:"structure"`

	// The attribute path for the filter.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`

	// The attribute values for the filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s ExperimentTemplateTargetInputFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExperimentTemplateTargetInputFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExperimentTemplateTargetInputFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExperimentTemplateTargetInputFilter"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPath sets the Path field's value.
func (s *ExperimentTemplateTargetInputFilter) SetPath(v string) *ExperimentTemplateTargetInputFilter {
	s.Path = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentTemplateTargetInputFilter) SetValues(v []*string) *ExperimentTemplateTargetInputFilter {
	s.Values = v
	return s
}

type GetActionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetActionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetActionInput) SetId(v string) *GetActionInput {
	s.Id = &v
	return s
}

type GetActionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the action.
	Action *Action `locationName:"action" type:"structure"`
}

// String returns the string representation
func (s GetActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActionOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetActionOutput) SetAction(v *Action) *GetActionOutput {
	s.Action = v
	return s
}

type GetExperimentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the experiment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetExperimentInput) SetId(v string) *GetExperimentInput {
	s.Id = &v
	return s
}

type GetExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation
func (s GetExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *GetExperimentOutput) SetExperiment(v *Experiment) *GetExperimentOutput {
	s.Experiment = v
	return s
}

type GetExperimentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the experiment template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetExperimentTemplateInput) SetId(v string) *GetExperimentTemplateInput {
	s.Id = &v
	return s
}

type GetExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation
func (s GetExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *GetExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *GetExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

type ListActionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListActionsInput) SetMaxResults(v int64) *ListActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionsInput) SetNextToken(v string) *ListActionsInput {
	s.NextToken = &v
	return s
}

type ListActionsOutput struct {
	_ struct{} `type:"structure"`

	// The actions.
	Actions []*ActionSummary `locationName:"actions" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActionsOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *ListActionsOutput) SetActions(v []*ActionSummary) *ListActionsOutput {
	s.Actions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionsOutput) SetNextToken(v string) *ListActionsOutput {
	s.NextToken = &v
	return s
}

type ListExperimentTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExperimentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExperimentTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExperimentTemplatesInput) SetMaxResults(v int64) *ListExperimentTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentTemplatesInput) SetNextToken(v string) *ListExperimentTemplatesInput {
	s.NextToken = &v
	return s
}

type ListExperimentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The experiment templates.
	ExperimentTemplates []*ExperimentTemplateSummary `locationName:"experimentTemplates" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExperimentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExperimentTemplatesOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplates sets the ExperimentTemplates field's value.
func (s *ListExperimentTemplatesOutput) SetExperimentTemplates(v []*ExperimentTemplateSummary) *ListExperimentTemplatesOutput {
	s.ExperimentTemplates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentTemplatesOutput) SetNextToken(v string) *ListExperimentTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListExperimentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExperimentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExperimentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExperimentsInput) SetMaxResults(v int64) *ListExperimentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentsInput) SetNextToken(v string) *ListExperimentsInput {
	s.NextToken = &v
	return s
}

type ListExperimentsOutput struct {
	_ struct{} `type:"structure"`

	// The experiments.
	Experiments []*ExperimentSummary `locationName:"experiments" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExperimentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExperimentsOutput) GoString() string {
	return s.String()
}

// SetExperiments sets the Experiments field's value.
func (s *ListExperimentsOutput) SetExperiments(v []*ExperimentSummary) *ListExperimentsOutput {
	s.Experiments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentsOutput) SetNextToken(v string) *ListExperimentsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified resource cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded your service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartExperimentInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the experiment template.
	//
	// ExperimentTemplateId is a required field
	ExperimentTemplateId *string `locationName:"experimentTemplateId" type:"string" required:"true"`

	// The tags to apply to the experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StartExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExperimentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExperimentTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperimentTemplateId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartExperimentInput) SetClientToken(v string) *StartExperimentInput {
	s.ClientToken = &v
	return s
}

// SetExperimentTemplateId sets the ExperimentTemplateId field's value.
func (s *StartExperimentInput) SetExperimentTemplateId(v string) *StartExperimentInput {
	s.ExperimentTemplateId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartExperimentInput) SetTags(v map[string]*string) *StartExperimentInput {
	s.Tags = v
	return s
}

type StartExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation
func (s StartExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *StartExperimentOutput) SetExperiment(v *Experiment) *StartExperimentOutput {
	s.Experiment = v
	return s
}

type StopExperimentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the experiment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s StopExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopExperimentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopExperimentInput) SetId(v string) *StopExperimentInput {
	s.Id = &v
	return s
}

type StopExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation
func (s StopExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *StopExperimentOutput) SetExperiment(v *Experiment) *StopExperimentOutput {
	s.Experiment = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tag keys to remove.
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Specifies an action for an experiment template.
type UpdateExperimentTemplateActionInputItem struct {
	_ struct{} `type:"structure"`

	// The ID of the action.
	ActionId *string `locationName:"actionId" type:"string"`

	// A description for the action.
	Description *string `locationName:"description" type:"string"`

	// The parameters for the action, if applicable.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The name of the action that must be completed before the current action starts.
	// Omit this parameter to run the action at the start of the experiment.
	StartAfter []*string `locationName:"startAfter" type:"list"`

	// The targets for the action.
	Targets map[string]*string `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s UpdateExperimentTemplateActionInputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExperimentTemplateActionInputItem) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetActionId(v string) *UpdateExperimentTemplateActionInputItem {
	s.ActionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetDescription(v string) *UpdateExperimentTemplateActionInputItem {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetParameters(v map[string]*string) *UpdateExperimentTemplateActionInputItem {
	s.Parameters = v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetStartAfter(v []*string) *UpdateExperimentTemplateActionInputItem {
	s.StartAfter = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateExperimentTemplateActionInputItem) SetTargets(v map[string]*string) *UpdateExperimentTemplateActionInputItem {
	s.Targets = v
	return s
}

type UpdateExperimentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The actions for the experiment.
	Actions map[string]*UpdateExperimentTemplateActionInputItem `locationName:"actions" type:"map"`

	// A description for the template.
	Description *string `locationName:"description" type:"string"`

	// The ID of the experiment template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service
	// permission to perform service actions on your behalf.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The stop conditions for the experiment.
	StopConditions []*UpdateExperimentTemplateStopConditionInput `locationName:"stopConditions" type:"list"`

	// The targets for the experiment.
	Targets map[string]*UpdateExperimentTemplateTargetInput `locationName:"targets" type:"map"`
}

// String returns the string representation
func (s UpdateExperimentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExperimentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StopConditions != nil {
		for i, v := range s.StopConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StopConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *UpdateExperimentTemplateInput) SetActions(v map[string]*UpdateExperimentTemplateActionInputItem) *UpdateExperimentTemplateInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateExperimentTemplateInput) SetDescription(v string) *UpdateExperimentTemplateInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateExperimentTemplateInput) SetId(v string) *UpdateExperimentTemplateInput {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateExperimentTemplateInput) SetRoleArn(v string) *UpdateExperimentTemplateInput {
	s.RoleArn = &v
	return s
}

// SetStopConditions sets the StopConditions field's value.
func (s *UpdateExperimentTemplateInput) SetStopConditions(v []*UpdateExperimentTemplateStopConditionInput) *UpdateExperimentTemplateInput {
	s.StopConditions = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateExperimentTemplateInput) SetTargets(v map[string]*UpdateExperimentTemplateTargetInput) *UpdateExperimentTemplateInput {
	s.Targets = v
	return s
}

type UpdateExperimentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the experiment template.
	ExperimentTemplate *ExperimentTemplate `locationName:"experimentTemplate" type:"structure"`
}

// String returns the string representation
func (s UpdateExperimentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExperimentTemplateOutput) GoString() string {
	return s.String()
}

// SetExperimentTemplate sets the ExperimentTemplate field's value.
func (s *UpdateExperimentTemplateOutput) SetExperimentTemplate(v *ExperimentTemplate) *UpdateExperimentTemplateOutput {
	s.ExperimentTemplate = v
	return s
}

// Specifies a stop condition for an experiment. You can define a stop condition
// as a CloudWatch alarm.
type UpdateExperimentTemplateStopConditionInput struct {
	_ struct{} `type:"structure"`

	// The source for the stop condition. Specify aws:cloudwatch:alarm if the stop
	// condition is defined by a CloudWatch alarm. Specify none if there is no stop
	// condition.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch alarm.
	Value *string `locationName:"value" min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateExperimentTemplateStopConditionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExperimentTemplateStopConditionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateStopConditionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateStopConditionInput"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Value != nil && len(*s.Value) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *UpdateExperimentTemplateStopConditionInput) SetSource(v string) *UpdateExperimentTemplateStopConditionInput {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateExperimentTemplateStopConditionInput) SetValue(v string) *UpdateExperimentTemplateStopConditionInput {
	s.Value = &v
	return s
}

// Specifies a target for an experiment. You must specify at least one Amazon
// Resource Name (ARN) or at least one resource tag. You cannot specify both.
type UpdateExperimentTemplateTargetInput struct {
	_ struct{} `type:"structure"`

	// The filters to apply to identify target resources using specific attributes.
	Filters []*ExperimentTemplateTargetInputFilter `locationName:"filters" type:"list"`

	// The Amazon Resource Names (ARNs) of the targets.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// The tags for the target resources.
	ResourceTags map[string]*string `locationName:"resourceTags" type:"map"`

	// The AWS resource type. The resource type must be supported for the specified
	// action.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Scopes the identified resources to a specific count or percentage.
	//
	// SelectionMode is a required field
	SelectionMode *string `locationName:"selectionMode" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateExperimentTemplateTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExperimentTemplateTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentTemplateTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentTemplateTargetInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.SelectionMode == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionMode"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateExperimentTemplateTargetInput) SetFilters(v []*ExperimentTemplateTargetInputFilter) *UpdateExperimentTemplateTargetInput {
	s.Filters = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *UpdateExperimentTemplateTargetInput) SetResourceArns(v []*string) *UpdateExperimentTemplateTargetInput {
	s.ResourceArns = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *UpdateExperimentTemplateTargetInput) SetResourceTags(v map[string]*string) *UpdateExperimentTemplateTargetInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UpdateExperimentTemplateTargetInput) SetResourceType(v string) *UpdateExperimentTemplateTargetInput {
	s.ResourceType = &v
	return s
}

// SetSelectionMode sets the SelectionMode field's value.
func (s *UpdateExperimentTemplateTargetInput) SetSelectionMode(v string) *UpdateExperimentTemplateTargetInput {
	s.SelectionMode = &v
	return s
}

// The specified input is not valid, or fails to satisfy the constraints for
// the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ExperimentActionStatusPending is a ExperimentActionStatus enum value
	ExperimentActionStatusPending = "pending"

	// ExperimentActionStatusInitiating is a ExperimentActionStatus enum value
	ExperimentActionStatusInitiating = "initiating"

	// ExperimentActionStatusRunning is a ExperimentActionStatus enum value
	ExperimentActionStatusRunning = "running"

	// ExperimentActionStatusCompleted is a ExperimentActionStatus enum value
	ExperimentActionStatusCompleted = "completed"

	// ExperimentActionStatusCancelled is a ExperimentActionStatus enum value
	ExperimentActionStatusCancelled = "cancelled"

	// ExperimentActionStatusStopping is a ExperimentActionStatus enum value
	ExperimentActionStatusStopping = "stopping"

	// ExperimentActionStatusStopped is a ExperimentActionStatus enum value
	ExperimentActionStatusStopped = "stopped"

	// ExperimentActionStatusFailed is a ExperimentActionStatus enum value
	ExperimentActionStatusFailed = "failed"
)

// ExperimentActionStatus_Values returns all elements of the ExperimentActionStatus enum
func ExperimentActionStatus_Values() []string {
	return []string{
		ExperimentActionStatusPending,
		ExperimentActionStatusInitiating,
		ExperimentActionStatusRunning,
		ExperimentActionStatusCompleted,
		ExperimentActionStatusCancelled,
		ExperimentActionStatusStopping,
		ExperimentActionStatusStopped,
		ExperimentActionStatusFailed,
	}
}

const (
	// ExperimentStatusPending is a ExperimentStatus enum value
	ExperimentStatusPending = "pending"

	// ExperimentStatusInitiating is a ExperimentStatus enum value
	ExperimentStatusInitiating = "initiating"

	// ExperimentStatusRunning is a ExperimentStatus enum value
	ExperimentStatusRunning = "running"

	// ExperimentStatusCompleted is a ExperimentStatus enum value
	ExperimentStatusCompleted = "completed"

	// ExperimentStatusStopping is a ExperimentStatus enum value
	ExperimentStatusStopping = "stopping"

	// ExperimentStatusStopped is a ExperimentStatus enum value
	ExperimentStatusStopped = "stopped"

	// ExperimentStatusFailed is a ExperimentStatus enum value
	ExperimentStatusFailed = "failed"
)

// ExperimentStatus_Values returns all elements of the ExperimentStatus enum
func ExperimentStatus_Values() []string {
	return []string{
		ExperimentStatusPending,
		ExperimentStatusInitiating,
		ExperimentStatusRunning,
		ExperimentStatusCompleted,
		ExperimentStatusStopping,
		ExperimentStatusStopped,
		ExperimentStatusFailed,
	}
}
