// Copyright 2020 The mqtt-go authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package mqtt

import (
	"bytes"
	"fmt"
	"testing"
)

func BenchmarkReadPacket(b *testing.B) {
	for _, l := range []int{16, 256, 65536} {
		b.Run(fmt.Sprintf("%dBytes", l), func(b *testing.B) {
			data := (&pktPublish{Message: &Message{
				Topic:   "topicString",
				Payload: make([]byte, l),
			}}).Pack()

			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				_, _, _, err := readPacket(bytes.NewReader(data))
				if err != nil {
					b.Fatalf("Unexpected error: '%v'", err)
				}
			}
		})
	}
}
