package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMedia invokes the unimkt.ListMedia API synchronously
func (client *Client) ListMedia(request *ListMediaRequest) (response *ListMediaResponse, err error) {
	response = CreateListMediaResponse()
	err = client.DoAction(request, response)
	return
}

// ListMediaWithChan invokes the unimkt.ListMedia API asynchronously
func (client *Client) ListMediaWithChan(request *ListMediaRequest) (<-chan *ListMediaResponse, <-chan error) {
	responseChan := make(chan *ListMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMediaWithCallback invokes the unimkt.ListMedia API asynchronously
func (client *Client) ListMediaWithCallback(request *ListMediaRequest, callback func(response *ListMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMediaResponse
		var err error
		defer close(result)
		response, err = client.ListMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMediaRequest is the request struct for api ListMedia
type ListMediaRequest struct {
	*requests.RpcRequest
	EndCreateTime    requests.Integer `position:"Query" name:"EndCreateTime"`
	Business         string           `position:"Query" name:"Business"`
	Os               string           `position:"Query" name:"Os"`
	MediaStatus      string           `position:"Query" name:"MediaStatus"`
	UserId           string           `position:"Query" name:"UserId"`
	OriginSiteUserId string           `position:"Query" name:"OriginSiteUserId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	MediaName        string           `position:"Query" name:"MediaName"`
	Environment      string           `position:"Query" name:"Environment"`
	AppName          string           `position:"Query" name:"AppName"`
	StartCreateTime  requests.Integer `position:"Query" name:"StartCreateTime"`
	TenantId         string           `position:"Query" name:"TenantId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	UserSite         string           `position:"Query" name:"UserSite"`
	MediaType        string           `position:"Query" name:"MediaType"`
	AccessStatus     string           `position:"Query" name:"AccessStatus"`
}

// ListMediaResponse is the response struct for api ListMedia
type ListMediaResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Success    bool    `json:"Success" xml:"Success"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	Total      int64   `json:"Total" xml:"Total"`
	Model      []Media `json:"Model" xml:"Model"`
}

// CreateListMediaRequest creates a request to invoke ListMedia API
func CreateListMediaRequest() (request *ListMediaRequest) {
	request = &ListMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ListMedia", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMediaResponse creates a response to parse from ListMedia response
func CreateListMediaResponse() (response *ListMediaResponse) {
	response = &ListMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
