package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceResourceUsage invokes the petadata.DescribeInstanceResourceUsage API synchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceresourceusage.html
func (client *Client) DescribeInstanceResourceUsage(request *DescribeInstanceResourceUsageRequest) (response *DescribeInstanceResourceUsageResponse, err error) {
	response = CreateDescribeInstanceResourceUsageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceResourceUsageWithChan invokes the petadata.DescribeInstanceResourceUsage API asynchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceresourceusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceResourceUsageWithChan(request *DescribeInstanceResourceUsageRequest) (<-chan *DescribeInstanceResourceUsageResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceResourceUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceResourceUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceResourceUsageWithCallback invokes the petadata.DescribeInstanceResourceUsage API asynchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceresourceusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceResourceUsageWithCallback(request *DescribeInstanceResourceUsageRequest, callback func(response *DescribeInstanceResourceUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceResourceUsageResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceResourceUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceResourceUsageRequest is the request struct for api DescribeInstanceResourceUsage
type DescribeInstanceResourceUsageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	Interval             string           `position:"Query" name:"Interval"`
	StartTime            string           `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeInstanceResourceUsageResponse is the response struct for api DescribeInstanceResourceUsage
type DescribeInstanceResourceUsageResponse struct {
	*responses.BaseResponse
	RequestId    string                                      `json:"RequestId" xml:"RequestId"`
	MonitorDatas MonitorDatasInDescribeInstanceResourceUsage `json:"MonitorDatas" xml:"MonitorDatas"`
}

// CreateDescribeInstanceResourceUsageRequest creates a request to invoke DescribeInstanceResourceUsage API
func CreateDescribeInstanceResourceUsageRequest() (request *DescribeInstanceResourceUsageRequest) {
	request = &DescribeInstanceResourceUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "DescribeInstanceResourceUsage", "petadata", "openAPI")
	return
}

// CreateDescribeInstanceResourceUsageResponse creates a response to parse from DescribeInstanceResourceUsage response
func CreateDescribeInstanceResourceUsageResponse() (response *DescribeInstanceResourceUsageResponse) {
	response = &DescribeInstanceResourceUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
