package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTaskExecutions invokes the oos.ListTaskExecutions API synchronously
func (client *Client) ListTaskExecutions(request *ListTaskExecutionsRequest) (response *ListTaskExecutionsResponse, err error) {
	response = CreateListTaskExecutionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskExecutionsWithChan invokes the oos.ListTaskExecutions API asynchronously
func (client *Client) ListTaskExecutionsWithChan(request *ListTaskExecutionsRequest) (<-chan *ListTaskExecutionsResponse, <-chan error) {
	responseChan := make(chan *ListTaskExecutionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTaskExecutions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskExecutionsWithCallback invokes the oos.ListTaskExecutions API asynchronously
func (client *Client) ListTaskExecutionsWithCallback(request *ListTaskExecutionsRequest, callback func(response *ListTaskExecutionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskExecutionsResponse
		var err error
		defer close(result)
		response, err = client.ListTaskExecutions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskExecutionsRequest is the request struct for api ListTaskExecutions
type ListTaskExecutionsRequest struct {
	*requests.RpcRequest
	TaskName                  string           `position:"Query" name:"TaskName"`
	IncludeChildTaskExecution requests.Boolean `position:"Query" name:"IncludeChildTaskExecution"`
	ExecutionId               string           `position:"Query" name:"ExecutionId"`
	ParentTaskExecutionId     string           `position:"Query" name:"ParentTaskExecutionId"`
	NextToken                 string           `position:"Query" name:"NextToken"`
	EndDateBefore             string           `position:"Query" name:"EndDateBefore"`
	SortOrder                 string           `position:"Query" name:"SortOrder"`
	StartDateAfter            string           `position:"Query" name:"StartDateAfter"`
	StartDateBefore           string           `position:"Query" name:"StartDateBefore"`
	EndDateAfter              string           `position:"Query" name:"EndDateAfter"`
	MaxResults                requests.Integer `position:"Query" name:"MaxResults"`
	TaskExecutionId           string           `position:"Query" name:"TaskExecutionId"`
	SortField                 string           `position:"Query" name:"SortField"`
	TaskAction                string           `position:"Query" name:"TaskAction"`
	Status                    string           `position:"Query" name:"Status"`
}

// ListTaskExecutionsResponse is the response struct for api ListTaskExecutions
type ListTaskExecutionsResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	MaxResults     int             `json:"MaxResults" xml:"MaxResults"`
	NextToken      string          `json:"NextToken" xml:"NextToken"`
	TaskExecutions []TaskExecution `json:"TaskExecutions" xml:"TaskExecutions"`
}

// CreateListTaskExecutionsRequest creates a request to invoke ListTaskExecutions API
func CreateListTaskExecutionsRequest() (request *ListTaskExecutionsRequest) {
	request = &ListTaskExecutionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListTaskExecutions", "", "")
	request.Method = requests.POST
	return
}

// CreateListTaskExecutionsResponse creates a response to parse from ListTaskExecutions response
func CreateListTaskExecutionsResponse() (response *ListTaskExecutionsResponse) {
	response = &ListTaskExecutionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
