package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveAudioAuditNotifyConfig invokes the live.UpdateLiveAudioAuditNotifyConfig API synchronously
func (client *Client) UpdateLiveAudioAuditNotifyConfig(request *UpdateLiveAudioAuditNotifyConfigRequest) (response *UpdateLiveAudioAuditNotifyConfigResponse, err error) {
	response = CreateUpdateLiveAudioAuditNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveAudioAuditNotifyConfigWithChan invokes the live.UpdateLiveAudioAuditNotifyConfig API asynchronously
func (client *Client) UpdateLiveAudioAuditNotifyConfigWithChan(request *UpdateLiveAudioAuditNotifyConfigRequest) (<-chan *UpdateLiveAudioAuditNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveAudioAuditNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveAudioAuditNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveAudioAuditNotifyConfigWithCallback invokes the live.UpdateLiveAudioAuditNotifyConfig API asynchronously
func (client *Client) UpdateLiveAudioAuditNotifyConfigWithCallback(request *UpdateLiveAudioAuditNotifyConfigRequest, callback func(response *UpdateLiveAudioAuditNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveAudioAuditNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveAudioAuditNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveAudioAuditNotifyConfigRequest is the request struct for api UpdateLiveAudioAuditNotifyConfig
type UpdateLiveAudioAuditNotifyConfigRequest struct {
	*requests.RpcRequest
	DomainName       string           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	CallbackTemplate string           `position:"Query" name:"CallbackTemplate"`
	Callback         string           `position:"Query" name:"Callback"`
}

// UpdateLiveAudioAuditNotifyConfigResponse is the response struct for api UpdateLiveAudioAuditNotifyConfig
type UpdateLiveAudioAuditNotifyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveAudioAuditNotifyConfigRequest creates a request to invoke UpdateLiveAudioAuditNotifyConfig API
func CreateUpdateLiveAudioAuditNotifyConfigRequest() (request *UpdateLiveAudioAuditNotifyConfigRequest) {
	request = &UpdateLiveAudioAuditNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveAudioAuditNotifyConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveAudioAuditNotifyConfigResponse creates a response to parse from UpdateLiveAudioAuditNotifyConfig response
func CreateUpdateLiveAudioAuditNotifyConfigResponse() (response *UpdateLiveAudioAuditNotifyConfigResponse) {
	response = &UpdateLiveAudioAuditNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
