package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStatisticsTask invokes the idrsservice.ListStatisticsTask API synchronously
func (client *Client) ListStatisticsTask(request *ListStatisticsTaskRequest) (response *ListStatisticsTaskResponse, err error) {
	response = CreateListStatisticsTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListStatisticsTaskWithChan invokes the idrsservice.ListStatisticsTask API asynchronously
func (client *Client) ListStatisticsTaskWithChan(request *ListStatisticsTaskRequest) (<-chan *ListStatisticsTaskResponse, <-chan error) {
	responseChan := make(chan *ListStatisticsTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStatisticsTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStatisticsTaskWithCallback invokes the idrsservice.ListStatisticsTask API asynchronously
func (client *Client) ListStatisticsTaskWithCallback(request *ListStatisticsTaskRequest, callback func(response *ListStatisticsTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStatisticsTaskResponse
		var err error
		defer close(result)
		response, err = client.ListStatisticsTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStatisticsTaskRequest is the request struct for api ListStatisticsTask
type ListStatisticsTaskRequest struct {
	*requests.RpcRequest
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
}

// ListStatisticsTaskResponse is the response struct for api ListStatisticsTask
type ListStatisticsTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListStatisticsTaskRequest creates a request to invoke ListStatisticsTask API
func CreateListStatisticsTaskRequest() (request *ListStatisticsTaskRequest) {
	request = &ListStatisticsTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "ListStatisticsTask", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListStatisticsTaskResponse creates a response to parse from ListStatisticsTask response
func CreateListStatisticsTaskResponse() (response *ListStatisticsTaskResponse) {
	response = &ListStatisticsTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
