package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFlowCategory invokes the emr.CreateFlowCategory API synchronously
func (client *Client) CreateFlowCategory(request *CreateFlowCategoryRequest) (response *CreateFlowCategoryResponse, err error) {
	response = CreateCreateFlowCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFlowCategoryWithChan invokes the emr.CreateFlowCategory API asynchronously
func (client *Client) CreateFlowCategoryWithChan(request *CreateFlowCategoryRequest) (<-chan *CreateFlowCategoryResponse, <-chan error) {
	responseChan := make(chan *CreateFlowCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFlowCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFlowCategoryWithCallback invokes the emr.CreateFlowCategory API asynchronously
func (client *Client) CreateFlowCategoryWithCallback(request *CreateFlowCategoryRequest, callback func(response *CreateFlowCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFlowCategoryResponse
		var err error
		defer close(result)
		response, err = client.CreateFlowCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFlowCategoryRequest is the request struct for api CreateFlowCategory
type CreateFlowCategoryRequest struct {
	*requests.RpcRequest
	Type      string `position:"Query" name:"Type"`
	ParentId  string `position:"Query" name:"ParentId"`
	Name      string `position:"Query" name:"Name"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// CreateFlowCategoryResponse is the response struct for api CreateFlowCategory
type CreateFlowCategoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateFlowCategoryRequest creates a request to invoke CreateFlowCategory API
func CreateCreateFlowCategoryRequest() (request *CreateFlowCategoryRequest) {
	request = &CreateFlowCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateFlowCategory", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFlowCategoryResponse creates a response to parse from CreateFlowCategory response
func CreateCreateFlowCategoryResponse() (response *CreateFlowCategoryResponse) {
	response = &CreateFlowCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
