package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGWSInstance invokes the ehpc.DeleteGWSInstance API synchronously
func (client *Client) DeleteGWSInstance(request *DeleteGWSInstanceRequest) (response *DeleteGWSInstanceResponse, err error) {
	response = CreateDeleteGWSInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGWSInstanceWithChan invokes the ehpc.DeleteGWSInstance API asynchronously
func (client *Client) DeleteGWSInstanceWithChan(request *DeleteGWSInstanceRequest) (<-chan *DeleteGWSInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteGWSInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGWSInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGWSInstanceWithCallback invokes the ehpc.DeleteGWSInstance API asynchronously
func (client *Client) DeleteGWSInstanceWithCallback(request *DeleteGWSInstanceRequest, callback func(response *DeleteGWSInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGWSInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteGWSInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGWSInstanceRequest is the request struct for api DeleteGWSInstance
type DeleteGWSInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteGWSInstanceResponse is the response struct for api DeleteGWSInstance
type DeleteGWSInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGWSInstanceRequest creates a request to invoke DeleteGWSInstance API
func CreateDeleteGWSInstanceRequest() (request *DeleteGWSInstanceRequest) {
	request = &DeleteGWSInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DeleteGWSInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteGWSInstanceResponse creates a response to parse from DeleteGWSInstance response
func CreateDeleteGWSInstanceResponse() (response *DeleteGWSInstanceResponse) {
	response = &DeleteGWSInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
