package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLayer7Rule invokes the ddoscoo.CreateLayer7Rule API synchronously
func (client *Client) CreateLayer7Rule(request *CreateLayer7RuleRequest) (response *CreateLayer7RuleResponse, err error) {
	response = CreateCreateLayer7RuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLayer7RuleWithChan invokes the ddoscoo.CreateLayer7Rule API asynchronously
func (client *Client) CreateLayer7RuleWithChan(request *CreateLayer7RuleRequest) (<-chan *CreateLayer7RuleResponse, <-chan error) {
	responseChan := make(chan *CreateLayer7RuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLayer7Rule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLayer7RuleWithCallback invokes the ddoscoo.CreateLayer7Rule API asynchronously
func (client *Client) CreateLayer7RuleWithCallback(request *CreateLayer7RuleRequest, callback func(response *CreateLayer7RuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLayer7RuleResponse
		var err error
		defer close(result)
		response, err = client.CreateLayer7Rule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLayer7RuleRequest is the request struct for api CreateLayer7Rule
type CreateLayer7RuleRequest struct {
	*requests.RpcRequest
	Rules           string           `position:"Query" name:"Rules"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	RsType          requests.Integer `position:"Query" name:"RsType"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Domain          string           `position:"Query" name:"Domain"`
}

// CreateLayer7RuleResponse is the response struct for api CreateLayer7Rule
type CreateLayer7RuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLayer7RuleRequest creates a request to invoke CreateLayer7Rule API
func CreateCreateLayer7RuleRequest() (request *CreateLayer7RuleRequest) {
	request = &CreateLayer7RuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "CreateLayer7Rule", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateLayer7RuleResponse creates a response to parse from CreateLayer7Rule response
func CreateCreateLayer7RuleResponse() (response *CreateLayer7RuleResponse) {
	response = &CreateLayer7RuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
