package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobGroupAgentsDetail invokes the cloudcallcenter.GetJobGroupAgentsDetail API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobgroupagentsdetail.html
func (client *Client) GetJobGroupAgentsDetail(request *GetJobGroupAgentsDetailRequest) (response *GetJobGroupAgentsDetailResponse, err error) {
	response = CreateGetJobGroupAgentsDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobGroupAgentsDetailWithChan invokes the cloudcallcenter.GetJobGroupAgentsDetail API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobgroupagentsdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobGroupAgentsDetailWithChan(request *GetJobGroupAgentsDetailRequest) (<-chan *GetJobGroupAgentsDetailResponse, <-chan error) {
	responseChan := make(chan *GetJobGroupAgentsDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobGroupAgentsDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobGroupAgentsDetailWithCallback invokes the cloudcallcenter.GetJobGroupAgentsDetail API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobgroupagentsdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobGroupAgentsDetailWithCallback(request *GetJobGroupAgentsDetailRequest, callback func(response *GetJobGroupAgentsDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobGroupAgentsDetailResponse
		var err error
		defer close(result)
		response, err = client.GetJobGroupAgentsDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobGroupAgentsDetailRequest is the request struct for api GetJobGroupAgentsDetail
type GetJobGroupAgentsDetailRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
}

// GetJobGroupAgentsDetailResponse is the response struct for api GetJobGroupAgentsDetail
type GetJobGroupAgentsDetailResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Detail         Detail `json:"detail" xml:"detail"`
}

// CreateGetJobGroupAgentsDetailRequest creates a request to invoke GetJobGroupAgentsDetail API
func CreateGetJobGroupAgentsDetailRequest() (request *GetJobGroupAgentsDetailRequest) {
	request = &GetJobGroupAgentsDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetJobGroupAgentsDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateGetJobGroupAgentsDetailResponse creates a response to parse from GetJobGroupAgentsDetail response
func CreateGetJobGroupAgentsDetailResponse() (response *GetJobGroupAgentsDetailResponse) {
	response = &GetJobGroupAgentsDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
