package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableLiveSpeaker invokes the aliyuncvc.EnableLiveSpeaker API synchronously
func (client *Client) EnableLiveSpeaker(request *EnableLiveSpeakerRequest) (response *EnableLiveSpeakerResponse, err error) {
	response = CreateEnableLiveSpeakerResponse()
	err = client.DoAction(request, response)
	return
}

// EnableLiveSpeakerWithChan invokes the aliyuncvc.EnableLiveSpeaker API asynchronously
func (client *Client) EnableLiveSpeakerWithChan(request *EnableLiveSpeakerRequest) (<-chan *EnableLiveSpeakerResponse, <-chan error) {
	responseChan := make(chan *EnableLiveSpeakerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableLiveSpeaker(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableLiveSpeakerWithCallback invokes the aliyuncvc.EnableLiveSpeaker API asynchronously
func (client *Client) EnableLiveSpeakerWithCallback(request *EnableLiveSpeakerRequest, callback func(response *EnableLiveSpeakerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableLiveSpeakerResponse
		var err error
		defer close(result)
		response, err = client.EnableLiveSpeaker(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableLiveSpeakerRequest is the request struct for api EnableLiveSpeaker
type EnableLiveSpeakerRequest struct {
	*requests.RpcRequest
	LiveUUID          string           `position:"Body" name:"LiveUUID"`
	EnableSpeakerFlag requests.Boolean `position:"Body" name:"EnableSpeakerFlag"`
}

// EnableLiveSpeakerResponse is the response struct for api EnableLiveSpeaker
type EnableLiveSpeakerResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableLiveSpeakerRequest creates a request to invoke EnableLiveSpeaker API
func CreateEnableLiveSpeakerRequest() (request *EnableLiveSpeakerRequest) {
	request = &EnableLiveSpeakerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "EnableLiveSpeaker", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableLiveSpeakerResponse creates a response to parse from EnableLiveSpeaker response
func CreateEnableLiveSpeakerResponse() (response *EnableLiveSpeakerResponse) {
	response = &EnableLiveSpeakerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
