package cdnapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cdn/mgmt/2020-09-01/cdn"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CheckNameAvailability(ctx context.Context, checkNameAvailabilityInput cdn.CheckNameAvailabilityInput) (result cdn.CheckNameAvailabilityOutput, err error)
	CheckNameAvailabilityWithSubscription(ctx context.Context, checkNameAvailabilityInput cdn.CheckNameAvailabilityInput) (result cdn.CheckNameAvailabilityOutput, err error)
	ValidateProbe(ctx context.Context, validateProbeInput cdn.ValidateProbeInput) (result cdn.ValidateProbeOutput, err error)
}

var _ BaseClientAPI = (*cdn.BaseClient)(nil)

// ProfilesClientAPI contains the set of methods on the ProfilesClient type.
type ProfilesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, profile cdn.Profile) (result cdn.ProfilesCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.ProfilesDeleteFuture, err error)
	GenerateSsoURI(ctx context.Context, resourceGroupName string, profileName string) (result cdn.SsoURI, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string) (result cdn.Profile, err error)
	List(ctx context.Context) (result cdn.ProfileListResultPage, err error)
	ListComplete(ctx context.Context) (result cdn.ProfileListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result cdn.ProfileListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result cdn.ProfileListResultIterator, err error)
	ListResourceUsage(ctx context.Context, resourceGroupName string, profileName string) (result cdn.ResourceUsageListResultPage, err error)
	ListResourceUsageComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.ResourceUsageListResultIterator, err error)
	ListSupportedOptimizationTypes(ctx context.Context, resourceGroupName string, profileName string) (result cdn.SupportedOptimizationTypesListResult, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, profileUpdateParameters cdn.ProfileUpdateParameters) (result cdn.ProfilesUpdateFuture, err error)
}

var _ ProfilesClientAPI = (*cdn.ProfilesClient)(nil)

// EndpointsClientAPI contains the set of methods on the EndpointsClient type.
type EndpointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, endpointName string, endpoint cdn.Endpoint) (result cdn.EndpointsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.EndpointsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.Endpoint, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.EndpointListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.EndpointListResultIterator, err error)
	ListResourceUsage(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.ResourceUsageListResultPage, err error)
	ListResourceUsageComplete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.ResourceUsageListResultIterator, err error)
	LoadContent(ctx context.Context, resourceGroupName string, profileName string, endpointName string, contentFilePaths cdn.LoadParameters) (result cdn.EndpointsLoadContentFuture, err error)
	PurgeContent(ctx context.Context, resourceGroupName string, profileName string, endpointName string, contentFilePaths cdn.PurgeParameters) (result cdn.EndpointsPurgeContentFuture, err error)
	Start(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.EndpointsStartFuture, err error)
	Stop(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.EndpointsStopFuture, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointName string, endpointUpdateProperties cdn.EndpointUpdateParameters) (result cdn.EndpointsUpdateFuture, err error)
	ValidateCustomDomain(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainProperties cdn.ValidateCustomDomainInput) (result cdn.ValidateCustomDomainOutput, err error)
}

var _ EndpointsClientAPI = (*cdn.EndpointsClient)(nil)

// OriginsClientAPI contains the set of methods on the OriginsClient type.
type OriginsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originName string, origin cdn.Origin) (result cdn.OriginsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originName string) (result cdn.OriginsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originName string) (result cdn.Origin, err error)
	ListByEndpoint(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.OriginListResultPage, err error)
	ListByEndpointComplete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.OriginListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originName string, originUpdateProperties cdn.OriginUpdateParameters) (result cdn.OriginsUpdateFuture, err error)
}

var _ OriginsClientAPI = (*cdn.OriginsClient)(nil)

// OriginGroupsClientAPI contains the set of methods on the OriginGroupsClient type.
type OriginGroupsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originGroupName string, originGroup cdn.OriginGroup) (result cdn.OriginGroupsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originGroupName string) (result cdn.OriginGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originGroupName string) (result cdn.OriginGroup, err error)
	ListByEndpoint(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.OriginGroupListResultPage, err error)
	ListByEndpointComplete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.OriginGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointName string, originGroupName string, originGroupUpdateProperties cdn.OriginGroupUpdateParameters) (result cdn.OriginGroupsUpdateFuture, err error)
}

var _ OriginGroupsClientAPI = (*cdn.OriginGroupsClient)(nil)

// CustomDomainsClientAPI contains the set of methods on the CustomDomainsClient type.
type CustomDomainsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, customDomainProperties cdn.CustomDomainParameters) (result cdn.CustomDomainsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string) (result cdn.CustomDomainsDeleteFuture, err error)
	DisableCustomHTTPS(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string) (result cdn.CustomDomainsDisableCustomHTTPSFuture, err error)
	EnableCustomHTTPS(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, customDomainHTTPSParameters *cdn.BasicCustomDomainHTTPSParameters) (result cdn.CustomDomainsEnableCustomHTTPSFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string) (result cdn.CustomDomain, err error)
	ListByEndpoint(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.CustomDomainListResultPage, err error)
	ListByEndpointComplete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.CustomDomainListResultIterator, err error)
}

var _ CustomDomainsClientAPI = (*cdn.CustomDomainsClient)(nil)

// ResourceUsageClientAPI contains the set of methods on the ResourceUsageClient type.
type ResourceUsageClientAPI interface {
	List(ctx context.Context) (result cdn.ResourceUsageListResultPage, err error)
	ListComplete(ctx context.Context) (result cdn.ResourceUsageListResultIterator, err error)
}

var _ ResourceUsageClientAPI = (*cdn.ResourceUsageClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result cdn.OperationsListResultPage, err error)
	ListComplete(ctx context.Context) (result cdn.OperationsListResultIterator, err error)
}

var _ OperationsClientAPI = (*cdn.OperationsClient)(nil)

// EdgeNodesClientAPI contains the set of methods on the EdgeNodesClient type.
type EdgeNodesClientAPI interface {
	List(ctx context.Context) (result cdn.EdgenodeResultPage, err error)
	ListComplete(ctx context.Context) (result cdn.EdgenodeResultIterator, err error)
}

var _ EdgeNodesClientAPI = (*cdn.EdgeNodesClient)(nil)

// AFDProfilesClientAPI contains the set of methods on the AFDProfilesClient type.
type AFDProfilesClientAPI interface {
	CheckHostNameAvailability(ctx context.Context, resourceGroupName string, profileName string, checkHostNameAvailabilityInput cdn.ValidateCustomDomainInput) (result cdn.ValidateCustomDomainOutput, err error)
	ListResourceUsage(ctx context.Context, resourceGroupName string, profileName string) (result cdn.UsagesListResultPage, err error)
	ListResourceUsageComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.UsagesListResultIterator, err error)
}

var _ AFDProfilesClientAPI = (*cdn.AFDProfilesClient)(nil)

// AFDCustomDomainsClientAPI contains the set of methods on the AFDCustomDomainsClient type.
type AFDCustomDomainsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, customDomain cdn.AFDDomain) (result cdn.AFDCustomDomainsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, customDomainName string) (result cdn.AFDCustomDomainsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, customDomainName string) (result cdn.AFDDomain, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.AFDDomainListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.AFDDomainListResultIterator, err error)
	RefreshValidationToken(ctx context.Context, resourceGroupName string, profileName string, customDomainName string) (result cdn.AFDCustomDomainsRefreshValidationTokenFuture, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, customDomainName string, customDomainUpdateProperties cdn.AFDDomainUpdateParameters) (result cdn.AFDCustomDomainsUpdateFuture, err error)
}

var _ AFDCustomDomainsClientAPI = (*cdn.AFDCustomDomainsClient)(nil)

// AFDEndpointsClientAPI contains the set of methods on the AFDEndpointsClient type.
type AFDEndpointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, endpointName string, endpoint cdn.AFDEndpoint) (result cdn.AFDEndpointsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.AFDEndpointsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.AFDEndpoint, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.AFDEndpointListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.AFDEndpointListResultIterator, err error)
	ListResourceUsage(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.UsagesListResultPage, err error)
	ListResourceUsageComplete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.UsagesListResultIterator, err error)
	PurgeContent(ctx context.Context, resourceGroupName string, profileName string, endpointName string, contents cdn.AfdPurgeParameters) (result cdn.AFDEndpointsPurgeContentFuture, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointName string, endpointUpdateProperties cdn.AFDEndpointUpdateParameters) (result cdn.AFDEndpointsUpdateFuture, err error)
	ValidateCustomDomain(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainProperties cdn.ValidateCustomDomainInput) (result cdn.ValidateCustomDomainOutput, err error)
}

var _ AFDEndpointsClientAPI = (*cdn.AFDEndpointsClient)(nil)

// AFDOriginGroupsClientAPI contains the set of methods on the AFDOriginGroupsClient type.
type AFDOriginGroupsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originGroup cdn.AFDOriginGroup) (result cdn.AFDOriginGroupsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result cdn.AFDOriginGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result cdn.AFDOriginGroup, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.AFDOriginGroupListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.AFDOriginGroupListResultIterator, err error)
	ListResourceUsage(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result cdn.UsagesListResultPage, err error)
	ListResourceUsageComplete(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result cdn.UsagesListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originGroupUpdateProperties cdn.AFDOriginGroupUpdateParameters) (result cdn.AFDOriginGroupsUpdateFuture, err error)
}

var _ AFDOriginGroupsClientAPI = (*cdn.AFDOriginGroupsClient)(nil)

// AFDOriginsClientAPI contains the set of methods on the AFDOriginsClient type.
type AFDOriginsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, origin cdn.AFDOrigin) (result cdn.AFDOriginsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string) (result cdn.AFDOriginsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string) (result cdn.AFDOrigin, err error)
	ListByOriginGroup(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result cdn.AFDOriginListResultPage, err error)
	ListByOriginGroupComplete(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result cdn.AFDOriginListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, originUpdateProperties cdn.AFDOriginUpdateParameters) (result cdn.AFDOriginsUpdateFuture, err error)
}

var _ AFDOriginsClientAPI = (*cdn.AFDOriginsClient)(nil)

// RoutesClientAPI contains the set of methods on the RoutesClient type.
type RoutesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, endpointName string, routeName string, route cdn.Route) (result cdn.RoutesCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointName string, routeName string) (result cdn.RoutesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointName string, routeName string) (result cdn.Route, err error)
	ListByEndpoint(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.RouteListResultPage, err error)
	ListByEndpointComplete(ctx context.Context, resourceGroupName string, profileName string, endpointName string) (result cdn.RouteListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointName string, routeName string, routeUpdateProperties cdn.RouteUpdateParameters) (result cdn.RoutesUpdateFuture, err error)
}

var _ RoutesClientAPI = (*cdn.RoutesClient)(nil)

// RuleSetsClientAPI contains the set of methods on the RuleSetsClient type.
type RuleSetsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.RuleSetsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.RuleSetsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.RuleSet, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.RuleSetListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.RuleSetListResultIterator, err error)
	ListResourceUsage(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.UsagesListResultPage, err error)
	ListResourceUsageComplete(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.UsagesListResultIterator, err error)
}

var _ RuleSetsClientAPI = (*cdn.RuleSetsClient)(nil)

// RulesClientAPI contains the set of methods on the RulesClient type.
type RulesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string, ruleName string, rule cdn.Rule) (result cdn.RulesCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string, ruleName string) (result cdn.RulesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string, ruleName string) (result cdn.Rule, err error)
	ListByRuleSet(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.RuleListResultPage, err error)
	ListByRuleSetComplete(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string) (result cdn.RuleListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, ruleSetName string, ruleName string, ruleUpdateProperties cdn.RuleUpdateParameters) (result cdn.RulesUpdateFuture, err error)
}

var _ RulesClientAPI = (*cdn.RulesClient)(nil)

// SecurityPoliciesClientAPI contains the set of methods on the SecurityPoliciesClient type.
type SecurityPoliciesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, securityPolicyName string, securityPolicy cdn.SecurityPolicy) (result cdn.SecurityPoliciesCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, securityPolicyName string) (result cdn.SecurityPoliciesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, securityPolicyName string) (result cdn.SecurityPolicy, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.SecurityPolicyListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.SecurityPolicyListResultIterator, err error)
	Patch(ctx context.Context, resourceGroupName string, profileName string, securityPolicyName string, securityPolicyProperties cdn.SecurityPolicyProperties) (result cdn.SecurityPoliciesPatchFuture, err error)
}

var _ SecurityPoliciesClientAPI = (*cdn.SecurityPoliciesClient)(nil)

// SecretsClientAPI contains the set of methods on the SecretsClient type.
type SecretsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, profileName string, secretName string, secret cdn.Secret) (result cdn.SecretsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, secretName string) (result cdn.SecretsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, secretName string) (result cdn.Secret, err error)
	ListByProfile(ctx context.Context, resourceGroupName string, profileName string) (result cdn.SecretListResultPage, err error)
	ListByProfileComplete(ctx context.Context, resourceGroupName string, profileName string) (result cdn.SecretListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, secretName string, secretProperties cdn.SecretProperties) (result cdn.SecretsUpdateFuture, err error)
}

var _ SecretsClientAPI = (*cdn.SecretsClient)(nil)

// ValidateClientAPI contains the set of methods on the ValidateClient type.
type ValidateClientAPI interface {
	SecretMethod(ctx context.Context, validateSecretInput cdn.ValidateSecretInput) (result cdn.ValidateSecretOutput, err error)
}

var _ ValidateClientAPI = (*cdn.ValidateClient)(nil)

// LogAnalyticsClientAPI contains the set of methods on the LogAnalyticsClient type.
type LogAnalyticsClientAPI interface {
	GetLogAnalyticsLocations(ctx context.Context, resourceGroupName string, profileName string) (result cdn.ContinentsResponse, err error)
	GetLogAnalyticsMetrics(ctx context.Context, resourceGroupName string, profileName string, metrics []cdn.LogMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, granularity cdn.LogMetricsGranularity, customDomains []string, protocols []string, groupBy []cdn.LogMetricsGroupBy, continents []string, countryOrRegions []string) (result cdn.MetricsResponse, err error)
	GetLogAnalyticsRankings(ctx context.Context, resourceGroupName string, profileName string, rankings []cdn.LogRanking, metrics []cdn.LogRankingMetric, maxRanking int32, dateTimeBegin date.Time, dateTimeEnd date.Time, customDomains []string) (result cdn.RankingsResponse, err error)
	GetLogAnalyticsResources(ctx context.Context, resourceGroupName string, profileName string) (result cdn.ResourcesResponse, err error)
	GetWafLogAnalyticsMetrics(ctx context.Context, resourceGroupName string, profileName string, metrics []cdn.WafMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, granularity cdn.WafGranularity, actions []cdn.WafAction, groupBy []cdn.WafRankingGroupBy, ruleTypes []cdn.WafRuleType) (result cdn.WafMetricsResponse, err error)
	GetWafLogAnalyticsRankings(ctx context.Context, resourceGroupName string, profileName string, metrics []cdn.WafMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, maxRanking int32, rankings []cdn.WafRankingType, actions []cdn.WafAction, ruleTypes []cdn.WafRuleType) (result cdn.WafRankingsResponse, err error)
}

var _ LogAnalyticsClientAPI = (*cdn.LogAnalyticsClient)(nil)

// PoliciesClientAPI contains the set of methods on the PoliciesClient type.
type PoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, policyName string, cdnWebApplicationFirewallPolicy cdn.WebApplicationFirewallPolicy) (result cdn.PoliciesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, policyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, policyName string) (result cdn.WebApplicationFirewallPolicy, err error)
	List(ctx context.Context, resourceGroupName string) (result cdn.WebApplicationFirewallPolicyListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result cdn.WebApplicationFirewallPolicyListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, policyName string, cdnWebApplicationFirewallPolicyPatchParameters cdn.WebApplicationFirewallPolicyPatchParameters) (result cdn.PoliciesUpdateFuture, err error)
}

var _ PoliciesClientAPI = (*cdn.PoliciesClient)(nil)

// ManagedRuleSetsClientAPI contains the set of methods on the ManagedRuleSetsClient type.
type ManagedRuleSetsClientAPI interface {
	List(ctx context.Context) (result cdn.ManagedRuleSetDefinitionListPage, err error)
	ListComplete(ctx context.Context) (result cdn.ManagedRuleSetDefinitionListIterator, err error)
}

var _ ManagedRuleSetsClientAPI = (*cdn.ManagedRuleSetsClient)(nil)
