package timeseriesinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessPolicyRole enumerates the values for access policy role.
type AccessPolicyRole string

const (
	// Contributor ...
	Contributor AccessPolicyRole = "Contributor"
	// Reader ...
	Reader AccessPolicyRole = "Reader"
)

// PossibleAccessPolicyRoleValues returns an array of possible values for the AccessPolicyRole const type.
func PossibleAccessPolicyRoleValues() []AccessPolicyRole {
	return []AccessPolicyRole{Contributor, Reader}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindEventSourceCreateOrUpdateParameters ...
	KindEventSourceCreateOrUpdateParameters Kind = "EventSourceCreateOrUpdateParameters"
	// KindMicrosoftEventHub ...
	KindMicrosoftEventHub Kind = "Microsoft.EventHub"
	// KindMicrosoftIoTHub ...
	KindMicrosoftIoTHub Kind = "Microsoft.IoTHub"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindEventSourceCreateOrUpdateParameters, KindMicrosoftEventHub, KindMicrosoftIoTHub}
}

// KindBasicEventSourceResource enumerates the values for kind basic event source resource.
type KindBasicEventSourceResource string

const (
	// KindBasicEventSourceResourceKindEventSourceResource ...
	KindBasicEventSourceResourceKindEventSourceResource KindBasicEventSourceResource = "EventSourceResource"
	// KindBasicEventSourceResourceKindMicrosoftEventHub ...
	KindBasicEventSourceResourceKindMicrosoftEventHub KindBasicEventSourceResource = "Microsoft.EventHub"
	// KindBasicEventSourceResourceKindMicrosoftIotHub ...
	KindBasicEventSourceResourceKindMicrosoftIotHub KindBasicEventSourceResource = "Microsoft.IotHub"
)

// PossibleKindBasicEventSourceResourceValues returns an array of possible values for the KindBasicEventSourceResource const type.
func PossibleKindBasicEventSourceResourceValues() []KindBasicEventSourceResource {
	return []KindBasicEventSourceResource{KindBasicEventSourceResourceKindEventSourceResource, KindBasicEventSourceResourceKindMicrosoftEventHub, KindBasicEventSourceResourceKindMicrosoftIotHub}
}

// LocalTimestampFormat enumerates the values for local timestamp format.
type LocalTimestampFormat string

const (
	// Embedded ...
	Embedded LocalTimestampFormat = "Embedded"
	// Iana ...
	Iana LocalTimestampFormat = "Iana"
	// TimeSpan ...
	TimeSpan LocalTimestampFormat = "TimeSpan"
)

// PossibleLocalTimestampFormatValues returns an array of possible values for the LocalTimestampFormat const type.
func PossibleLocalTimestampFormatValues() []LocalTimestampFormat {
	return []LocalTimestampFormat{Embedded, Iana, TimeSpan}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Creating, Deleting, Failed, Succeeded, Updating}
}

// ReferenceDataKeyPropertyType enumerates the values for reference data key property type.
type ReferenceDataKeyPropertyType string

const (
	// Bool ...
	Bool ReferenceDataKeyPropertyType = "Bool"
	// DateTime ...
	DateTime ReferenceDataKeyPropertyType = "DateTime"
	// Double ...
	Double ReferenceDataKeyPropertyType = "Double"
	// String ...
	String ReferenceDataKeyPropertyType = "String"
)

// PossibleReferenceDataKeyPropertyTypeValues returns an array of possible values for the ReferenceDataKeyPropertyType const type.
func PossibleReferenceDataKeyPropertyTypeValues() []ReferenceDataKeyPropertyType {
	return []ReferenceDataKeyPropertyType{Bool, DateTime, Double, String}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// S1 ...
	S1 SkuName = "S1"
	// S2 ...
	S2 SkuName = "S2"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{S1, S2}
}

// StorageLimitExceededBehavior enumerates the values for storage limit exceeded behavior.
type StorageLimitExceededBehavior string

const (
	// PauseIngress ...
	PauseIngress StorageLimitExceededBehavior = "PauseIngress"
	// PurgeOldData ...
	PurgeOldData StorageLimitExceededBehavior = "PurgeOldData"
)

// PossibleStorageLimitExceededBehaviorValues returns an array of possible values for the StorageLimitExceededBehavior const type.
func PossibleStorageLimitExceededBehaviorValues() []StorageLimitExceededBehavior {
	return []StorageLimitExceededBehavior{PauseIngress, PurgeOldData}
}
