// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package reservation

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	reservationpb "google.golang.org/genproto/googleapis/cloud/bigquery/reservation/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	CreateReservation        []gax.CallOption
	ListReservations         []gax.CallOption
	GetReservation           []gax.CallOption
	DeleteReservation        []gax.CallOption
	UpdateReservation        []gax.CallOption
	CreateCapacityCommitment []gax.CallOption
	ListCapacityCommitments  []gax.CallOption
	GetCapacityCommitment    []gax.CallOption
	DeleteCapacityCommitment []gax.CallOption
	UpdateCapacityCommitment []gax.CallOption
	SplitCapacityCommitment  []gax.CallOption
	MergeCapacityCommitments []gax.CallOption
	CreateAssignment         []gax.CallOption
	ListAssignments          []gax.CallOption
	DeleteAssignment         []gax.CallOption
	SearchAssignments        []gax.CallOption
	SearchAllAssignments     []gax.CallOption
	MoveAssignment           []gax.CallOption
	UpdateAssignment         []gax.CallOption
	GetBiReservation         []gax.CallOption
	UpdateBiReservation      []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("bigqueryreservation.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("bigqueryreservation.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://bigqueryreservation.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		CreateReservation: []gax.CallOption{},
		ListReservations: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetReservation: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteReservation: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateReservation:        []gax.CallOption{},
		CreateCapacityCommitment: []gax.CallOption{},
		ListCapacityCommitments: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetCapacityCommitment: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteCapacityCommitment: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateCapacityCommitment: []gax.CallOption{},
		SplitCapacityCommitment:  []gax.CallOption{},
		MergeCapacityCommitments: []gax.CallOption{},
		CreateAssignment:         []gax.CallOption{},
		ListAssignments: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAssignment: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchAssignments: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchAllAssignments: []gax.CallOption{},
		MoveAssignment:       []gax.CallOption{},
		UpdateAssignment:     []gax.CallOption{},
		GetBiReservation: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateBiReservation: []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from BigQuery Reservation API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateReservation(context.Context, *reservationpb.CreateReservationRequest, ...gax.CallOption) (*reservationpb.Reservation, error)
	ListReservations(context.Context, *reservationpb.ListReservationsRequest, ...gax.CallOption) *ReservationIterator
	GetReservation(context.Context, *reservationpb.GetReservationRequest, ...gax.CallOption) (*reservationpb.Reservation, error)
	DeleteReservation(context.Context, *reservationpb.DeleteReservationRequest, ...gax.CallOption) error
	UpdateReservation(context.Context, *reservationpb.UpdateReservationRequest, ...gax.CallOption) (*reservationpb.Reservation, error)
	CreateCapacityCommitment(context.Context, *reservationpb.CreateCapacityCommitmentRequest, ...gax.CallOption) (*reservationpb.CapacityCommitment, error)
	ListCapacityCommitments(context.Context, *reservationpb.ListCapacityCommitmentsRequest, ...gax.CallOption) *CapacityCommitmentIterator
	GetCapacityCommitment(context.Context, *reservationpb.GetCapacityCommitmentRequest, ...gax.CallOption) (*reservationpb.CapacityCommitment, error)
	DeleteCapacityCommitment(context.Context, *reservationpb.DeleteCapacityCommitmentRequest, ...gax.CallOption) error
	UpdateCapacityCommitment(context.Context, *reservationpb.UpdateCapacityCommitmentRequest, ...gax.CallOption) (*reservationpb.CapacityCommitment, error)
	SplitCapacityCommitment(context.Context, *reservationpb.SplitCapacityCommitmentRequest, ...gax.CallOption) (*reservationpb.SplitCapacityCommitmentResponse, error)
	MergeCapacityCommitments(context.Context, *reservationpb.MergeCapacityCommitmentsRequest, ...gax.CallOption) (*reservationpb.CapacityCommitment, error)
	CreateAssignment(context.Context, *reservationpb.CreateAssignmentRequest, ...gax.CallOption) (*reservationpb.Assignment, error)
	ListAssignments(context.Context, *reservationpb.ListAssignmentsRequest, ...gax.CallOption) *AssignmentIterator
	DeleteAssignment(context.Context, *reservationpb.DeleteAssignmentRequest, ...gax.CallOption) error
	SearchAssignments(context.Context, *reservationpb.SearchAssignmentsRequest, ...gax.CallOption) *AssignmentIterator
	SearchAllAssignments(context.Context, *reservationpb.SearchAllAssignmentsRequest, ...gax.CallOption) *AssignmentIterator
	MoveAssignment(context.Context, *reservationpb.MoveAssignmentRequest, ...gax.CallOption) (*reservationpb.Assignment, error)
	UpdateAssignment(context.Context, *reservationpb.UpdateAssignmentRequest, ...gax.CallOption) (*reservationpb.Assignment, error)
	GetBiReservation(context.Context, *reservationpb.GetBiReservationRequest, ...gax.CallOption) (*reservationpb.BiReservation, error)
	UpdateBiReservation(context.Context, *reservationpb.UpdateBiReservationRequest, ...gax.CallOption) (*reservationpb.BiReservation, error)
}

// Client is a client for interacting with BigQuery Reservation API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// This API allows users to manage their flat-rate BigQuery reservations.
//
// A reservation provides computational resource guarantees, in the form of
// slots (at https://cloud.google.com/bigquery/docs/slots), to users. A slot is a
// unit of computational power in BigQuery, and serves as the basic unit of
// parallelism. In a scan of a multi-partitioned table, a single slot operates
// on a single partition of the table. A reservation resource exists as a child
// resource of the admin project and location, e.g.:
// projects/myproject/locations/US/reservations/reservationName.
//
// A capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. A capacity
// commitment resource exists as a child resource of the admin project and
// location, e.g.:
// projects/myproject/locations/US/capacityCommitments/id.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateReservation creates a new reservation resource.
func (c *Client) CreateReservation(ctx context.Context, req *reservationpb.CreateReservationRequest, opts ...gax.CallOption) (*reservationpb.Reservation, error) {
	return c.internalClient.CreateReservation(ctx, req, opts...)
}

// ListReservations lists all the reservations for the project in the specified location.
func (c *Client) ListReservations(ctx context.Context, req *reservationpb.ListReservationsRequest, opts ...gax.CallOption) *ReservationIterator {
	return c.internalClient.ListReservations(ctx, req, opts...)
}

// GetReservation returns information about the reservation.
func (c *Client) GetReservation(ctx context.Context, req *reservationpb.GetReservationRequest, opts ...gax.CallOption) (*reservationpb.Reservation, error) {
	return c.internalClient.GetReservation(ctx, req, opts...)
}

// DeleteReservation deletes a reservation.
// Returns google.rpc.Code.FAILED_PRECONDITION when reservation has
// assignments.
func (c *Client) DeleteReservation(ctx context.Context, req *reservationpb.DeleteReservationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteReservation(ctx, req, opts...)
}

// UpdateReservation updates an existing reservation resource.
func (c *Client) UpdateReservation(ctx context.Context, req *reservationpb.UpdateReservationRequest, opts ...gax.CallOption) (*reservationpb.Reservation, error) {
	return c.internalClient.UpdateReservation(ctx, req, opts...)
}

// CreateCapacityCommitment creates a new capacity commitment resource.
func (c *Client) CreateCapacityCommitment(ctx context.Context, req *reservationpb.CreateCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	return c.internalClient.CreateCapacityCommitment(ctx, req, opts...)
}

// ListCapacityCommitments lists all the capacity commitments for the admin project.
func (c *Client) ListCapacityCommitments(ctx context.Context, req *reservationpb.ListCapacityCommitmentsRequest, opts ...gax.CallOption) *CapacityCommitmentIterator {
	return c.internalClient.ListCapacityCommitments(ctx, req, opts...)
}

// GetCapacityCommitment returns information about the capacity commitment.
func (c *Client) GetCapacityCommitment(ctx context.Context, req *reservationpb.GetCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	return c.internalClient.GetCapacityCommitment(ctx, req, opts...)
}

// DeleteCapacityCommitment deletes a capacity commitment. Attempting to delete capacity commitment
// before its commitment_end_time will fail with the error code
// google.rpc.Code.FAILED_PRECONDITION.
func (c *Client) DeleteCapacityCommitment(ctx context.Context, req *reservationpb.DeleteCapacityCommitmentRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteCapacityCommitment(ctx, req, opts...)
}

// UpdateCapacityCommitment updates an existing capacity commitment.
//
// Only plan and renewal_plan fields can be updated.
//
// Plan can only be changed to a plan of a longer commitment period.
// Attempting to change to a plan with shorter commitment period will fail
// with the error code google.rpc.Code.FAILED_PRECONDITION.
func (c *Client) UpdateCapacityCommitment(ctx context.Context, req *reservationpb.UpdateCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	return c.internalClient.UpdateCapacityCommitment(ctx, req, opts...)
}

// SplitCapacityCommitment splits capacity commitment to two commitments of the same plan and
// commitment_end_time.
//
// A common use case is to enable downgrading commitments.
//
// For example, in order to downgrade from 10000 slots to 8000, you might
// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
// you delete the first one after the commitment end time passes.
func (c *Client) SplitCapacityCommitment(ctx context.Context, req *reservationpb.SplitCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.SplitCapacityCommitmentResponse, error) {
	return c.internalClient.SplitCapacityCommitment(ctx, req, opts...)
}

// MergeCapacityCommitments merges capacity commitments of the same plan into a single commitment.
//
// The resulting capacity commitment has the greater commitment_end_time
// out of the to-be-merged capacity commitments.
//
// Attempting to merge capacity commitments of different plan will fail
// with the error code google.rpc.Code.FAILED_PRECONDITION.
func (c *Client) MergeCapacityCommitments(ctx context.Context, req *reservationpb.MergeCapacityCommitmentsRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	return c.internalClient.MergeCapacityCommitments(ctx, req, opts...)
}

// CreateAssignment creates an assignment object which allows the given project to submit jobs
// of a certain type using slots from the specified reservation.
//
// Currently a
// resource (project, folder, organization) can only have one assignment per
// each (job_type, location) combination, and that reservation will be used
// for all jobs of the matching type.
//
// Different assignments can be created on different levels of the
// projects, folders or organization hierarchy.  During query execution,
// the assignment is looked up at the project, folder and organization levels
// in that order. The first assignment found is applied to the query.
//
// When creating assignments, it does not matter if other assignments exist at
// higher levels.
//
// Example:
//
//	The organization organizationA contains two projects, project1
//	and project2.
//
//	Assignments for all three entities (organizationA, project1, and
//	project2) could all be created and mapped to the same or different
//	reservations.
//
// “None” assignments represent an absence of the assignment. Projects
// assigned to None use on-demand pricing. To create a “None” assignment, use
// “none” as a reservation_id in the parent. Example parent:
// projects/myproject/locations/US/reservations/none.
//
// Returns google.rpc.Code.PERMISSION_DENIED if user does not have
// ‘bigquery.admin’ permissions on the project using the reservation
// and the project that owns this reservation.
//
// Returns google.rpc.Code.INVALID_ARGUMENT when location of the assignment
// does not match location of the reservation.
func (c *Client) CreateAssignment(ctx context.Context, req *reservationpb.CreateAssignmentRequest, opts ...gax.CallOption) (*reservationpb.Assignment, error) {
	return c.internalClient.CreateAssignment(ctx, req, opts...)
}

// ListAssignments lists assignments.
//
// Only explicitly created assignments will be returned.
//
// Example:
//
//	Organization organizationA contains two projects, project1 and
//	project2.
//
//	Reservation res1 exists and was created previously.
//
//	CreateAssignment was used previously to define the following
//	associations between entities and reservations: <organizationA, res1>
//	and <project1, res1>
//
// In this example, ListAssignments will just return the above two assignments
// for reservation res1, and no expansion/merge will happen.
//
// The wildcard “-” can be used for
// reservations in the request. In that case all assignments belongs to the
// specified project and location will be listed.
//
// Note "-" cannot be used for projects nor locations.
func (c *Client) ListAssignments(ctx context.Context, req *reservationpb.ListAssignmentsRequest, opts ...gax.CallOption) *AssignmentIterator {
	return c.internalClient.ListAssignments(ctx, req, opts...)
}

// DeleteAssignment deletes a assignment. No expansion will happen.
//
// Example:
//
//	Organization organizationA contains two projects, project1 and
//	project2.
//
//	Reservation res1 exists and was created previously.
//
//	CreateAssignment was used previously to define the following
//	associations between entities and reservations: <organizationA, res1>
//	and <project1, res1>
//
// In this example, deletion of the <organizationA, res1> assignment won’t
// affect the other assignment <project1, res1>. After said deletion,
// queries from project1 will still use res1 while queries from
// project2 will switch to use on-demand mode.
func (c *Client) DeleteAssignment(ctx context.Context, req *reservationpb.DeleteAssignmentRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteAssignment(ctx, req, opts...)
}

// SearchAssignments deprecated: Looks up assignments for a specified resource for a particular
// region. If the request is about a project:
//
// Assignments created on the project will be returned if they exist.
//
// Otherwise assignments created on the closest ancestor will be
// returned.
//
// Assignments for different JobTypes will all be returned.
//
// The same logic applies if the request is about a folder.
//
// If the request is about an organization, then assignments created on the
// organization will be returned (organization doesn’t have ancestors).
//
// Comparing to ListAssignments, there are some behavior
// differences:
//
// permission on the assignee will be verified in this API.
//
// Hierarchy lookup (project->folder->organization) happens in this API.
//
// Parent here is projects/*/locations/*, instead of
// projects/*/locations/*reservations/*.
//
// Note "-" cannot be used for projects
// nor locations.
//
// Deprecated: SearchAssignments may be removed in a future version.
func (c *Client) SearchAssignments(ctx context.Context, req *reservationpb.SearchAssignmentsRequest, opts ...gax.CallOption) *AssignmentIterator {
	return c.internalClient.SearchAssignments(ctx, req, opts...)
}

// SearchAllAssignments looks up assignments for a specified resource for a particular region.
// If the request is about a project:
//
// Assignments created on the project will be returned if they exist.
//
// Otherwise assignments created on the closest ancestor will be
// returned.
//
// Assignments for different JobTypes will all be returned.
//
// The same logic applies if the request is about a folder.
//
// If the request is about an organization, then assignments created on the
// organization will be returned (organization doesn’t have ancestors).
//
// Comparing to ListAssignments, there are some behavior
// differences:
//
// permission on the assignee will be verified in this API.
//
// Hierarchy lookup (project->folder->organization) happens in this API.
//
// Parent here is projects/*/locations/*, instead of
// projects/*/locations/*reservations/*.
func (c *Client) SearchAllAssignments(ctx context.Context, req *reservationpb.SearchAllAssignmentsRequest, opts ...gax.CallOption) *AssignmentIterator {
	return c.internalClient.SearchAllAssignments(ctx, req, opts...)
}

// MoveAssignment moves an assignment under a new reservation.
//
// This differs from removing an existing assignment and recreating a new one
// by providing a transactional change that ensures an assignee always has an
// associated reservation.
func (c *Client) MoveAssignment(ctx context.Context, req *reservationpb.MoveAssignmentRequest, opts ...gax.CallOption) (*reservationpb.Assignment, error) {
	return c.internalClient.MoveAssignment(ctx, req, opts...)
}

// UpdateAssignment updates an existing assignment.
//
// Only the priority field can be updated.
func (c *Client) UpdateAssignment(ctx context.Context, req *reservationpb.UpdateAssignmentRequest, opts ...gax.CallOption) (*reservationpb.Assignment, error) {
	return c.internalClient.UpdateAssignment(ctx, req, opts...)
}

// GetBiReservation retrieves a BI reservation.
func (c *Client) GetBiReservation(ctx context.Context, req *reservationpb.GetBiReservationRequest, opts ...gax.CallOption) (*reservationpb.BiReservation, error) {
	return c.internalClient.GetBiReservation(ctx, req, opts...)
}

// UpdateBiReservation updates a BI reservation.
//
// Only fields specified in the field_mask are updated.
//
// A singleton BI reservation always exists with default size 0.
// In order to reserve BI capacity it needs to be updated to an amount
// greater than 0. In order to release BI capacity reservation size
// must be set to 0.
func (c *Client) UpdateBiReservation(ctx context.Context, req *reservationpb.UpdateBiReservationRequest, opts ...gax.CallOption) (*reservationpb.BiReservation, error) {
	return c.internalClient.UpdateBiReservation(ctx, req, opts...)
}

// gRPCClient is a client for interacting with BigQuery Reservation API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client reservationpb.ReservationServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewClient creates a new reservation service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// This API allows users to manage their flat-rate BigQuery reservations.
//
// A reservation provides computational resource guarantees, in the form of
// slots (at https://cloud.google.com/bigquery/docs/slots), to users. A slot is a
// unit of computational power in BigQuery, and serves as the basic unit of
// parallelism. In a scan of a multi-partitioned table, a single slot operates
// on a single partition of the table. A reservation resource exists as a child
// resource of the admin project and location, e.g.:
// projects/myproject/locations/US/reservations/reservationName.
//
// A capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. A capacity
// commitment resource exists as a child resource of the admin project and
// location, e.g.:
// projects/myproject/locations/US/capacityCommitments/id.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		disableDeadlines: disableDeadlines,
		client:           reservationpb.NewReservationServiceClient(connPool),
		CallOptions:      &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *gRPCClient) CreateReservation(ctx context.Context, req *reservationpb.CreateReservationRequest, opts ...gax.CallOption) (*reservationpb.Reservation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateReservation[0:len((*c.CallOptions).CreateReservation):len((*c.CallOptions).CreateReservation)], opts...)
	var resp *reservationpb.Reservation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateReservation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListReservations(ctx context.Context, req *reservationpb.ListReservationsRequest, opts ...gax.CallOption) *ReservationIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListReservations[0:len((*c.CallOptions).ListReservations):len((*c.CallOptions).ListReservations)], opts...)
	it := &ReservationIterator{}
	req = proto.Clone(req).(*reservationpb.ListReservationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*reservationpb.Reservation, string, error) {
		resp := &reservationpb.ListReservationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListReservations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReservations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetReservation(ctx context.Context, req *reservationpb.GetReservationRequest, opts ...gax.CallOption) (*reservationpb.Reservation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetReservation[0:len((*c.CallOptions).GetReservation):len((*c.CallOptions).GetReservation)], opts...)
	var resp *reservationpb.Reservation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetReservation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteReservation(ctx context.Context, req *reservationpb.DeleteReservationRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteReservation[0:len((*c.CallOptions).DeleteReservation):len((*c.CallOptions).DeleteReservation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteReservation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) UpdateReservation(ctx context.Context, req *reservationpb.UpdateReservationRequest, opts ...gax.CallOption) (*reservationpb.Reservation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "reservation.name", url.QueryEscape(req.GetReservation().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateReservation[0:len((*c.CallOptions).UpdateReservation):len((*c.CallOptions).UpdateReservation)], opts...)
	var resp *reservationpb.Reservation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateReservation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateCapacityCommitment(ctx context.Context, req *reservationpb.CreateCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateCapacityCommitment[0:len((*c.CallOptions).CreateCapacityCommitment):len((*c.CallOptions).CreateCapacityCommitment)], opts...)
	var resp *reservationpb.CapacityCommitment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateCapacityCommitment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListCapacityCommitments(ctx context.Context, req *reservationpb.ListCapacityCommitmentsRequest, opts ...gax.CallOption) *CapacityCommitmentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListCapacityCommitments[0:len((*c.CallOptions).ListCapacityCommitments):len((*c.CallOptions).ListCapacityCommitments)], opts...)
	it := &CapacityCommitmentIterator{}
	req = proto.Clone(req).(*reservationpb.ListCapacityCommitmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*reservationpb.CapacityCommitment, string, error) {
		resp := &reservationpb.ListCapacityCommitmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListCapacityCommitments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCapacityCommitments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetCapacityCommitment(ctx context.Context, req *reservationpb.GetCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetCapacityCommitment[0:len((*c.CallOptions).GetCapacityCommitment):len((*c.CallOptions).GetCapacityCommitment)], opts...)
	var resp *reservationpb.CapacityCommitment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetCapacityCommitment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteCapacityCommitment(ctx context.Context, req *reservationpb.DeleteCapacityCommitmentRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteCapacityCommitment[0:len((*c.CallOptions).DeleteCapacityCommitment):len((*c.CallOptions).DeleteCapacityCommitment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteCapacityCommitment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) UpdateCapacityCommitment(ctx context.Context, req *reservationpb.UpdateCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "capacity_commitment.name", url.QueryEscape(req.GetCapacityCommitment().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateCapacityCommitment[0:len((*c.CallOptions).UpdateCapacityCommitment):len((*c.CallOptions).UpdateCapacityCommitment)], opts...)
	var resp *reservationpb.CapacityCommitment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateCapacityCommitment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) SplitCapacityCommitment(ctx context.Context, req *reservationpb.SplitCapacityCommitmentRequest, opts ...gax.CallOption) (*reservationpb.SplitCapacityCommitmentResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).SplitCapacityCommitment[0:len((*c.CallOptions).SplitCapacityCommitment):len((*c.CallOptions).SplitCapacityCommitment)], opts...)
	var resp *reservationpb.SplitCapacityCommitmentResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.SplitCapacityCommitment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) MergeCapacityCommitments(ctx context.Context, req *reservationpb.MergeCapacityCommitmentsRequest, opts ...gax.CallOption) (*reservationpb.CapacityCommitment, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).MergeCapacityCommitments[0:len((*c.CallOptions).MergeCapacityCommitments):len((*c.CallOptions).MergeCapacityCommitments)], opts...)
	var resp *reservationpb.CapacityCommitment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.MergeCapacityCommitments(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateAssignment(ctx context.Context, req *reservationpb.CreateAssignmentRequest, opts ...gax.CallOption) (*reservationpb.Assignment, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAssignment[0:len((*c.CallOptions).CreateAssignment):len((*c.CallOptions).CreateAssignment)], opts...)
	var resp *reservationpb.Assignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateAssignment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListAssignments(ctx context.Context, req *reservationpb.ListAssignmentsRequest, opts ...gax.CallOption) *AssignmentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAssignments[0:len((*c.CallOptions).ListAssignments):len((*c.CallOptions).ListAssignments)], opts...)
	it := &AssignmentIterator{}
	req = proto.Clone(req).(*reservationpb.ListAssignmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*reservationpb.Assignment, string, error) {
		resp := &reservationpb.ListAssignmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListAssignments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAssignments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteAssignment(ctx context.Context, req *reservationpb.DeleteAssignmentRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAssignment[0:len((*c.CallOptions).DeleteAssignment):len((*c.CallOptions).DeleteAssignment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteAssignment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) SearchAssignments(ctx context.Context, req *reservationpb.SearchAssignmentsRequest, opts ...gax.CallOption) *AssignmentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).SearchAssignments[0:len((*c.CallOptions).SearchAssignments):len((*c.CallOptions).SearchAssignments)], opts...)
	it := &AssignmentIterator{}
	req = proto.Clone(req).(*reservationpb.SearchAssignmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*reservationpb.Assignment, string, error) {
		resp := &reservationpb.SearchAssignmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.SearchAssignments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAssignments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) SearchAllAssignments(ctx context.Context, req *reservationpb.SearchAllAssignmentsRequest, opts ...gax.CallOption) *AssignmentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).SearchAllAssignments[0:len((*c.CallOptions).SearchAllAssignments):len((*c.CallOptions).SearchAllAssignments)], opts...)
	it := &AssignmentIterator{}
	req = proto.Clone(req).(*reservationpb.SearchAllAssignmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*reservationpb.Assignment, string, error) {
		resp := &reservationpb.SearchAllAssignmentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.SearchAllAssignments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAssignments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) MoveAssignment(ctx context.Context, req *reservationpb.MoveAssignmentRequest, opts ...gax.CallOption) (*reservationpb.Assignment, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).MoveAssignment[0:len((*c.CallOptions).MoveAssignment):len((*c.CallOptions).MoveAssignment)], opts...)
	var resp *reservationpb.Assignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.MoveAssignment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateAssignment(ctx context.Context, req *reservationpb.UpdateAssignmentRequest, opts ...gax.CallOption) (*reservationpb.Assignment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "assignment.name", url.QueryEscape(req.GetAssignment().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAssignment[0:len((*c.CallOptions).UpdateAssignment):len((*c.CallOptions).UpdateAssignment)], opts...)
	var resp *reservationpb.Assignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateAssignment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetBiReservation(ctx context.Context, req *reservationpb.GetBiReservationRequest, opts ...gax.CallOption) (*reservationpb.BiReservation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetBiReservation[0:len((*c.CallOptions).GetBiReservation):len((*c.CallOptions).GetBiReservation)], opts...)
	var resp *reservationpb.BiReservation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetBiReservation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateBiReservation(ctx context.Context, req *reservationpb.UpdateBiReservationRequest, opts ...gax.CallOption) (*reservationpb.BiReservation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 300000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "bi_reservation.name", url.QueryEscape(req.GetBiReservation().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateBiReservation[0:len((*c.CallOptions).UpdateBiReservation):len((*c.CallOptions).UpdateBiReservation)], opts...)
	var resp *reservationpb.BiReservation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateBiReservation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// AssignmentIterator manages a stream of *reservationpb.Assignment.
type AssignmentIterator struct {
	items    []*reservationpb.Assignment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*reservationpb.Assignment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AssignmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AssignmentIterator) Next() (*reservationpb.Assignment, error) {
	var item *reservationpb.Assignment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AssignmentIterator) bufLen() int {
	return len(it.items)
}

func (it *AssignmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// CapacityCommitmentIterator manages a stream of *reservationpb.CapacityCommitment.
type CapacityCommitmentIterator struct {
	items    []*reservationpb.CapacityCommitment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*reservationpb.CapacityCommitment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *CapacityCommitmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *CapacityCommitmentIterator) Next() (*reservationpb.CapacityCommitment, error) {
	var item *reservationpb.CapacityCommitment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *CapacityCommitmentIterator) bufLen() int {
	return len(it.items)
}

func (it *CapacityCommitmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ReservationIterator manages a stream of *reservationpb.Reservation.
type ReservationIterator struct {
	items    []*reservationpb.Reservation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*reservationpb.Reservation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ReservationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ReservationIterator) Next() (*reservationpb.Reservation, error) {
	var item *reservationpb.Reservation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ReservationIterator) bufLen() int {
	return len(it.items)
}

func (it *ReservationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
