// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/aiplatform/v1/tensorboard_time_series.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An enum representing the value type of a TensorboardTimeSeries.
type TensorboardTimeSeries_ValueType int32

const (
	// The value type is unspecified.
	TensorboardTimeSeries_VALUE_TYPE_UNSPECIFIED TensorboardTimeSeries_ValueType = 0
	// Used for TensorboardTimeSeries that is a list of scalars.
	// E.g. accuracy of a model over epochs/time.
	TensorboardTimeSeries_SCALAR TensorboardTimeSeries_ValueType = 1
	// Used for TensorboardTimeSeries that is a list of tensors.
	// E.g. histograms of weights of layer in a model over epoch/time.
	TensorboardTimeSeries_TENSOR TensorboardTimeSeries_ValueType = 2
	// Used for TensorboardTimeSeries that is a list of blob sequences.
	// E.g. set of sample images with labels over epochs/time.
	TensorboardTimeSeries_BLOB_SEQUENCE TensorboardTimeSeries_ValueType = 3
)

// Enum value maps for TensorboardTimeSeries_ValueType.
var (
	TensorboardTimeSeries_ValueType_name = map[int32]string{
		0: "VALUE_TYPE_UNSPECIFIED",
		1: "SCALAR",
		2: "TENSOR",
		3: "BLOB_SEQUENCE",
	}
	TensorboardTimeSeries_ValueType_value = map[string]int32{
		"VALUE_TYPE_UNSPECIFIED": 0,
		"SCALAR":                 1,
		"TENSOR":                 2,
		"BLOB_SEQUENCE":          3,
	}
)

func (x TensorboardTimeSeries_ValueType) Enum() *TensorboardTimeSeries_ValueType {
	p := new(TensorboardTimeSeries_ValueType)
	*p = x
	return p
}

func (x TensorboardTimeSeries_ValueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TensorboardTimeSeries_ValueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_enumTypes[0].Descriptor()
}

func (TensorboardTimeSeries_ValueType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_enumTypes[0]
}

func (x TensorboardTimeSeries_ValueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TensorboardTimeSeries_ValueType.Descriptor instead.
func (TensorboardTimeSeries_ValueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescGZIP(), []int{0, 0}
}

// TensorboardTimeSeries maps to times series produced in training runs
type TensorboardTimeSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the TensorboardTimeSeries.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. User provided name of this TensorboardTimeSeries.
	// This value should be unique among all TensorboardTimeSeries resources
	// belonging to the same TensorboardRun resource (parent resource).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of this TensorboardTimeSeries.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. Type of TensorboardTimeSeries value.
	ValueType TensorboardTimeSeries_ValueType `protobuf:"varint,4,opt,name=value_type,json=valueType,proto3,enum=google.cloud.aiplatform.v1.TensorboardTimeSeries_ValueType" json:"value_type,omitempty"`
	// Output only. Timestamp when this TensorboardTimeSeries was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this TensorboardTimeSeries was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Used to perform a consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// Immutable. Name of the plugin this time series pertain to. Such as Scalar, Tensor,
	// Blob
	PluginName string `protobuf:"bytes,8,opt,name=plugin_name,json=pluginName,proto3" json:"plugin_name,omitempty"`
	// Data of the current plugin, with the size limited to 65KB.
	PluginData []byte `protobuf:"bytes,9,opt,name=plugin_data,json=pluginData,proto3" json:"plugin_data,omitempty"`
	// Output only. Scalar, Tensor, or Blob metadata for this TensorboardTimeSeries.
	Metadata *TensorboardTimeSeries_Metadata `protobuf:"bytes,10,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *TensorboardTimeSeries) Reset() {
	*x = TensorboardTimeSeries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TensorboardTimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TensorboardTimeSeries) ProtoMessage() {}

func (x *TensorboardTimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TensorboardTimeSeries.ProtoReflect.Descriptor instead.
func (*TensorboardTimeSeries) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescGZIP(), []int{0}
}

func (x *TensorboardTimeSeries) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TensorboardTimeSeries) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TensorboardTimeSeries) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TensorboardTimeSeries) GetValueType() TensorboardTimeSeries_ValueType {
	if x != nil {
		return x.ValueType
	}
	return TensorboardTimeSeries_VALUE_TYPE_UNSPECIFIED
}

func (x *TensorboardTimeSeries) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TensorboardTimeSeries) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TensorboardTimeSeries) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *TensorboardTimeSeries) GetPluginName() string {
	if x != nil {
		return x.PluginName
	}
	return ""
}

func (x *TensorboardTimeSeries) GetPluginData() []byte {
	if x != nil {
		return x.PluginData
	}
	return nil
}

func (x *TensorboardTimeSeries) GetMetadata() *TensorboardTimeSeries_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Describes metadata for a TensorboardTimeSeries.
type TensorboardTimeSeries_Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Max step index of all data points within a TensorboardTimeSeries.
	MaxStep int64 `protobuf:"varint,1,opt,name=max_step,json=maxStep,proto3" json:"max_step,omitempty"`
	// Output only. Max wall clock timestamp of all data points within a
	// TensorboardTimeSeries.
	MaxWallTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=max_wall_time,json=maxWallTime,proto3" json:"max_wall_time,omitempty"`
	// Output only. The largest blob sequence length (number of blobs) of all data points in
	// this time series, if its ValueType is BLOB_SEQUENCE.
	MaxBlobSequenceLength int64 `protobuf:"varint,3,opt,name=max_blob_sequence_length,json=maxBlobSequenceLength,proto3" json:"max_blob_sequence_length,omitempty"`
}

func (x *TensorboardTimeSeries_Metadata) Reset() {
	*x = TensorboardTimeSeries_Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TensorboardTimeSeries_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TensorboardTimeSeries_Metadata) ProtoMessage() {}

func (x *TensorboardTimeSeries_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TensorboardTimeSeries_Metadata.ProtoReflect.Descriptor instead.
func (*TensorboardTimeSeries_Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TensorboardTimeSeries_Metadata) GetMaxStep() int64 {
	if x != nil {
		return x.MaxStep
	}
	return 0
}

func (x *TensorboardTimeSeries_Metadata) GetMaxWallTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MaxWallTime
	}
	return nil
}

func (x *TensorboardTimeSeries_Metadata) GetMaxBlobSequenceLength() int64 {
	if x != nil {
		return x.MaxBlobSequenceLength
	}
	return 0
}

var File_google_cloud_aiplatform_v1_tensorboard_time_series_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xd7, 0x07, 0x0a, 0x15, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x62, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x24, 0x0a, 0x0b,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0xad, 0x01, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a,
	0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x74, 0x65, 0x70, 0x12, 0x43, 0x0a,
	0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x57, 0x61, 0x6c, 0x6c, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x73,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x42, 0x6c,
	0x6f, 0x62, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x22, 0x52, 0x0a, 0x09, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a,
	0x16, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x43, 0x41,
	0x4c, 0x41, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x45, 0x4e, 0x53, 0x4f, 0x52, 0x10,
	0x02, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x4c, 0x4f, 0x42, 0x5f, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e,
	0x43, 0x45, 0x10, 0x03, 0x3a, 0xb6, 0x01, 0xea, 0x41, 0xb2, 0x01, 0x0a, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x7f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x7d,
	0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b,
	0x72, 0x75, 0x6e, 0x7d, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x7d, 0x42, 0xde, 0x01,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x42, 0x1a, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescData = file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_goTypes = []interface{}{
	(TensorboardTimeSeries_ValueType)(0),   // 0: google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType
	(*TensorboardTimeSeries)(nil),          // 1: google.cloud.aiplatform.v1.TensorboardTimeSeries
	(*TensorboardTimeSeries_Metadata)(nil), // 2: google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
	(*timestamppb.Timestamp)(nil),          // 3: google.protobuf.Timestamp
}
var file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_depIdxs = []int32{
	0, // 0: google.cloud.aiplatform.v1.TensorboardTimeSeries.value_type:type_name -> google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType
	3, // 1: google.cloud.aiplatform.v1.TensorboardTimeSeries.create_time:type_name -> google.protobuf.Timestamp
	3, // 2: google.cloud.aiplatform.v1.TensorboardTimeSeries.update_time:type_name -> google.protobuf.Timestamp
	2, // 3: google.cloud.aiplatform.v1.TensorboardTimeSeries.metadata:type_name -> google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
	3, // 4: google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.max_wall_time:type_name -> google.protobuf.Timestamp
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_init() }
func file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_init() {
	if File_google_cloud_aiplatform_v1_tensorboard_time_series_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TensorboardTimeSeries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TensorboardTimeSeries_Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_tensorboard_time_series_proto = out.File
	file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_tensorboard_time_series_proto_depIdxs = nil
}
