/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.micrometer.tagged.RetryMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedRetryMetrics;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableRetry;
import org.apache.servicecomb.governance.handler.ext.AbstractRetryExtension;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.RetryPolicy;
import org.apache.servicecomb.governance.properties.RetryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHandler
extends AbstractGovernanceHandler<Retry, RetryPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryHandler.class);
    private final RetryProperties retryProperties;
    private final AbstractRetryExtension retryExtension;

    public RetryHandler(RetryProperties retryProperties, AbstractRetryExtension retryExtension) {
        this.retryProperties = retryProperties;
        this.retryExtension = retryExtension;
    }

    @Override
    protected String createKey(GovernanceRequestExtractor requestExtractor, RetryPolicy policy) {
        return this.retryProperties.getConfigKey() + "." + policy.getName();
    }

    @Override
    public RetryPolicy matchPolicy(GovernanceRequestExtractor requestExtractor) {
        return (RetryPolicy)this.matchersManager.match(requestExtractor, this.retryProperties.getParsedEntity());
    }

    @Override
    public Disposable<Retry> createProcessor(String key, GovernanceRequestExtractor requestExtractor, RetryPolicy policy) {
        return this.getRetry(key, policy);
    }

    private Disposable<Retry> getRetry(String key, RetryPolicy retryPolicy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)retryPolicy.toString());
        RetryConfig config = RetryConfig.custom().maxAttempts(retryPolicy.getMaxAttempts() + 1).retryOnResult(response -> this.retryExtension.isFailedResult(retryPolicy.getRetryOnResponseStatus(), response)).retryOnException(this.retryExtension::isFailedResult).intervalFunction(this.getIntervalFunction(retryPolicy)).failAfterMaxAttempts(retryPolicy.isFailAfterMaxAttempts()).build();
        RetryRegistry registry = RetryRegistry.of((RetryConfig)config);
        if (this.meterRegistry != null) {
            TaggedRetryMetrics.ofRetryRegistry((RetryMetricNames)RetryMetricNames.custom().callsMetricName(this.retryProperties.getConfigKey() + ".calls").build(), (RetryRegistry)registry).bindTo(this.meterRegistry);
        }
        return new DisposableRetry(key, registry, registry.retry(key));
    }

    private IntervalFunction getIntervalFunction(RetryPolicy retryPolicy) {
        if ("RandomBackoff".equals(retryPolicy.getRetryStrategy())) {
            return IntervalFunction.ofExponentialRandomBackoff((Duration)Duration.parse(retryPolicy.getInitialInterval()), (double)retryPolicy.getMultiplier(), (double)retryPolicy.getRandomizationFactor());
        }
        return IntervalFunction.of((Duration)Duration.parse(retryPolicy.getWaitDuration()));
    }
}

