/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryConsistencyException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetAddress;
import java.util.Map;

public class ReadFailureException
extends QueryConsistencyException {
    private final int numFailures;
    private final boolean dataPresent;
    private final Map<InetAddress, Integer> reasonMap;

    public ReadFailureException(@NonNull Node coordinator, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, int numFailures, boolean dataPresent, @NonNull Map<InetAddress, Integer> reasonMap) {
        this(coordinator, String.format("Cassandra failure during read query at consistency %s (%d responses were required but only %d replica responded, %d failed)", consistencyLevel, blockFor, received, numFailures), consistencyLevel, received, blockFor, numFailures, dataPresent, reasonMap, null, false);
    }

    private ReadFailureException(@NonNull Node coordinator, @NonNull String message, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, int numFailures, boolean dataPresent, @NonNull Map<InetAddress, Integer> reasonMap, @Nullable ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, consistencyLevel, received, blockFor, executionInfo, writableStackTrace);
        this.numFailures = numFailures;
        this.dataPresent = dataPresent;
        this.reasonMap = reasonMap;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public boolean wasDataPresent() {
        return this.dataPresent;
    }

    @NonNull
    public Map<InetAddress, Integer> getReasonMap() {
        return this.reasonMap;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new ReadFailureException(this.getCoordinator(), this.getMessage(), this.getConsistencyLevel(), this.getReceived(), this.getBlockFor(), this.numFailures, this.dataPresent, this.reasonMap, this.getExecutionInfo(), true);
    }
}

