/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.allocation;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.storageengine.dataregion.wal.allocation.AbstractNodeAllocationStrategy;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;

public class RoundRobinStrategy
extends AbstractNodeAllocationStrategy {
    private final int maxWalNodeNum;
    private final Lock nodesLock = new ReentrantLock();
    private final List<WALNode> walNodes;
    private int nodeCursor = -1;
    private int nodeIdCounter = -1;

    public RoundRobinStrategy(int maxWalNodeNum) {
        this.maxWalNodeNum = maxWalNodeNum;
        this.walNodes = new ArrayList<WALNode>(maxWalNodeNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWALNode applyForWALNode(String applicantUniqueId) {
        WALNode selectedNode;
        this.nodesLock.lock();
        try {
            if (this.walNodes.size() < this.maxWalNodeNum) {
                ++this.nodeIdCounter;
                IWALNode node = this.createWALNode(String.valueOf(this.nodeIdCounter));
                if (!(node instanceof WALNode)) {
                    IWALNode iWALNode = node;
                    return iWALNode;
                }
                selectedNode = (WALNode)node;
                this.walNodes.add(selectedNode);
            } else {
                this.nodeCursor = (this.nodeCursor + 1) % this.maxWalNodeNum;
                selectedNode = this.walNodes.get(this.nodeCursor);
            }
        }
        finally {
            this.nodesLock.unlock();
        }
        return selectedNode;
    }

    @Override
    public List<WALNode> getNodesSnapshot() {
        List<WALNode> snapshot;
        if (this.walNodes.size() < this.maxWalNodeNum) {
            this.nodesLock.lock();
            try {
                snapshot = new ArrayList<WALNode>(this.walNodes);
            }
            finally {
                this.nodesLock.unlock();
            }
        } else {
            snapshot = this.walNodes;
        }
        return snapshot;
    }

    @Override
    public int getNodesNum() {
        return this.walNodes.size();
    }

    @Override
    public void clear() {
        this.nodesLock.lock();
        try {
            this.nodeCursor = -1;
            this.nodeIdCounter = -1;
            for (WALNode walNode : this.walNodes) {
                walNode.close();
            }
            this.walNodes.clear();
        }
        finally {
            this.nodesLock.unlock();
        }
    }
}

