## ACSF1
#
#The dataset is compiled from ACS-F1, the first version of the database of appliance consumption signatures. The dataset contains the power consumption of typical appliances. The recordings are characterized by long idle periods and some high bursts of energy consumption when the appliance is active.
#
#The classes correspond to 10 categories of home appliances: mobile phones (via chargers), coffee machines, computer stations (including monitor), fridges and freezers, Hi-Fi systems (CD players), lamp (CFL), laptops (via chargers), microwave ovens, printers, and televisions (LCD or LED).
#
#Train size: 100
#
#Test size: 100
#
#Missing value: No
#
#Number of classes: 10
#
#Time series length: 1460
#
#There is nothing to infer from the order of examples in the train and test set.
#
#Data created by Gisler, Christophe, et al. (see [1], [2]). Data edited by Patrick Schafer and Ulf Leser (see [3]).
#
#[1] Gisler, Christophe, et al. "Appliance consumption signature database and recognition test protocols." Systems, Signal Processing and their Applications (WoSSPA), 2013 8th International Workshop on. IEEE, 2013.
#
#[2] http://www.wattict.com/web/index.php/databases/acs-f1
#
#[3] Schäfer, Patrick, and Ulf Leser. "Fast and accurate time series classification with weasel." Proceedings of the 2017 ACM on Conference on Information and Knowledge Management. ACM, 2017.
@problemName ACSF1
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 1460
@classLabel true 0 1 2 3 4 5 6 7 8 9
@data
-0.58475375,-0.58475375,1.730991,-0.58475375,-0.58475375,-0.58475375,1.7299167,-0.58475375,-0.58475375,-0.58475375,1.7313853,-0.58475375,-0.58475375,-0.58475375,1.7306165,-0.58475375,-0.58475375,-0.58475375,1.7304883,-0.58475375,-0.58475375,-0.58475375,1.730922,-0.58475375,-0.58475375,-0.58475375,1.7305278,-0.58475375,-0.58475375,-0.58475375,1.7341647,-0.58475375,-0.58372869,-0.57757834,1.7305573,-0.58472418,-0.58475375,-0.57347811,1.7282312,-0.58471433,-0.58680387,-0.54269679,1.726191,-0.58457634,-0.5909041,-0.52526094,1.7245844,-0.58450734,-0.5909041,-0.52526094,1.7311783,-0.58450734,-0.59192916,-0.52526094,1.7336621,-0.58450734,-0.5909041,-0.52526094,1.7317795,-0.58450734,-0.5909041,-0.52526094,1.7326567,-0.58450734,-0.5909041,-0.52526094,1.730508,-0.58450734,-0.5909041,-0.52423588,1.7257573,-0.58449749,-0.5909041,-0.52526094,1.7278863,-0.58450734,-0.59192916,-0.52423588,1.7296111,-0.58449749,-0.59192916,-0.52116071,1.7287536,-0.58448763,-0.59192916,-0.52218577,1.7295914,-0.58448763,-0.59192916,-0.52321083,1.7300744,-0.58449749,-0.59192916,-0.52321083,1.7263684,-0.58449749,-0.5909041,-0.52423588,1.7306165,-0.58449749,-0.5909041,-0.52526094,1.7289212,-0.58450734,-0.5909041,-0.52526094,1.7305179,-0.58450734,-0.5909041,-0.526286,1.7297984,-0.58450734,-0.5909041,-0.526286,1.7299659,-0.58450734,-0.5909041,-0.52731106,1.7300941,-0.58450734,-0.5909041,-0.52731106,1.7329524,-0.5845172,-0.5909041,-0.52833612,1.7328736,-0.5845172,-0.5909041,-0.52833612,1.7335339,-0.5845172,-0.5909041,-0.52833612,1.7331495,-0.5845172,-0.5909041,-0.52936118,1.7358107,-0.5845172,-0.58987904,-0.52936118,1.7311388,-0.5845172,-0.58987904,-0.52936118,1.731405,-0.5845172,-0.58987904,-0.53038623,1.7315725,-0.58452706,-0.58987904,-0.53038623,1.7332185,-0.58452706,-0.58987904,-0.53141129,1.7314148,-0.58452706,-0.58987904,-0.53141129,1.731336,-0.58452706,-0.58987904,-0.53141129,1.7322033,-0.58452706,-0.58987904,-0.53243635,1.7309811,-0.58453691,-0.58987904,-0.53243635,1.7327257,-0.58453691,-0.58885398,-0.53347127,1.731543,-0.58453691,-0.58885398,-0.53347127,1.7312177,-0.58453691,-0.58885398,-0.53347127,1.7310206,-0.58453691,-0.58885398,-0.53449632,1.7264867,-0.58454677,-0.58885398,-0.53449632,1.7283791,-0.58454677,-0.58885398,-0.53449632,1.7279454,-0.58454677,-0.58885398,-0.53552138,1.7280637,-0.58454677,-0.58885398,-0.53552138,1.7252152,-0.58454677,-0.58885398,-0.53552138,1.7254123,-0.58454677,-0.58782893,-0.53654644,1.7234903,-0.58455662,-0.58782893,-0.53654644,1.7284776,-0.58455662,-0.58782893,-0.53654644,1.7300349,-0.58455662,-0.58782893,-0.5375715,1.7278074,-0.58455662,-0.58782893,-0.5375715,1.7286748,-0.58455662,-0.58782893,-0.5375715,1.7268711,-0.58455662,-0.58782893,-0.5375715,1.7297294,-0.58455662,-0.58782893,-0.53859656,1.7311684,-0.58455662,-0.58782893,-0.53859656,1.7300152,-0.58455662,-0.58782893,-0.53962162,1.7295717,-0.58456648,-0.58782893,-0.53962162,1.7288127,-0.58456648,-0.58475375,-0.58475375,1.7266739,-0.58475375,-0.58475375,-0.57962846,1.7297688,-0.58473404,-0.58680387,-0.54372185,1.729069,-0.58458619,-0.58987904,-0.53141129,1.7304785,-0.58452706,-0.58885398,-0.53449632,1.7299857,-0.58454677,-0.58782893,-0.5375715,1.724407,-0.58455662,-0.58782893,-0.53859656,1.7274624,-0.58455662,-0.58782893,-0.53962162,1.7250969,-0.58456648,-0.58782893,-0.54064667,1.7276004,-0.58456648,-0.58782893,-0.54167173,1.7309417,-0.58457634,-0.58680387,-0.54167173,1.7321146,-0.58457634,-0.58680387,-0.54269679,1.7333565,-0.58457634,-0.58680387,-0.54269679,1.7333368,-0.58457634,-0.58680387,-0.54372185,1.7315035,-0.58458619,-0.58680387,-0.54372185,1.7291774,-0.58458619,-0.58680387,-0.54372185,1.7284185,-0.58458619,-0.58680387,-0.54474691,1.7295027,-0.58458619,-0.58680387,-0.54474691,1.729621,-0.58458619,-0.58680387,-0.54474691,1.7299462,-0.58458619,-0.58680387,-0.54577197,1.7316612,-0.58459605,-0.58680387,-0.54577197,1.7307052,-0.58459605,-0.58680387,-0.54577197,1.7302616,-0.58459605,-0.58577881,-0.54680688,1.7283594,-0.58459605,-0.58680387,-0.54680688,1.7259248,-0.58459605,-0.58577881,-0.54680688,1.7252448,-0.58459605,-0.58577881,-0.54680688,1.7269105,-0.58459605,-0.58577881,-0.54783194,1.7282805,-0.58460591,-0.58577881,-0.54783194,1.7285861,-0.58460591,-0.58577881,-0.54783194,1.7313754,-0.58460591,-0.58577881,-0.548857,1.7318288,-0.58460591,-0.58577881,-0.548857,1.7304095,-0.58460591,-0.58577881,-0.548857,1.7293351,-0.58460591,-0.58577881,-0.548857,1.7289606,-0.58460591,-0.58577881,-0.54988206,1.7285959,-0.58460591,-0.58577881,-0.54988206,1.7289409,-0.58460591,-0.58577881,-0.54988206,1.7287635,-0.58460591,-0.58577881,-0.54988206,1.7309614,-0.58460591,-0.58475375,-0.54988206,1.7307742,-0.58460591,-0.58577881,-0.55090711,1.7296407,-0.58461576,-0.58577881,-0.55090711,1.7301926,-0.58461576,-0.58475375,-0.55090711,1.7300744,-0.58461576,-0.58475375,-0.55193217,1.7297294,-0.58461576,-0.58475375,-0.55193217,1.7281327,-0.58461576,-0.58475375,-0.55193217,1.7316021,-0.58461576,-0.58475375,-0.55193217,1.7312276,-0.58461576,-0.58475375,-0.55193217,1.7310206,-0.58461576,-0.58475375,-0.55295723,1.7312276,-0.58462562,-0.58475375,-0.55295723,1.7331003,-0.58462562,-0.58475375,-0.55295723,1.7327849,-0.58462562,-0.58475375,-0.55295723,1.7342239,-0.58462562,-0.58475375,-0.55398229,1.7349335,-0.58462562,-0.58475375,-0.55398229,1.7346871,-0.58462562,-0.58475375,-0.55398229,1.7362937,-0.58462562,-0.58475375,-0.55500735,1.7377919,-0.58463548,-0.58475375,-0.55500735,1.7372793,-0.58463548,-0.58475375,-0.55500735,1.7344801,-0.58463548,-0.58475375,-0.55500735,1.7333664,-0.58463548,-0.58475375,-0.55500735,1.7347758,-0.58463548,-0.58475375,-0.55603241,1.7316218,-0.58463548,-0.58475375,-0.55603241,1.7319076,-0.58463548,-0.58475375,-0.55603241,1.7352194,-0.58463548,-0.58475375,-0.55603241,1.7368752,-0.58463548,-0.58475375,-0.55603241,1.7347758,-0.58463548,-0.58475375,-0.55603241,1.7328637,-0.58463548,-0.58475375,-0.55705746,1.7311388,-0.58463548,-0.58475375,-0.55705746,1.7306953,-0.58463548,-0.58475375,-0.55705746,1.7312177,-0.58463548,-0.58475375,-0.55705746,1.7317696,-0.58464533,-0.58475375,-0.55808252,1.7318682,-0.58464533,-0.58475375,-0.55808252,1.7300152,-0.58464533,-0.58475375,-0.55808252,1.7293056,-0.58464533,-0.58475375,-0.55808252,1.7248702,-0.58464533,-0.58475375,-0.55808252,1.7279355,-0.58464533,-0.58475375,-0.55911744,1.7298674,-0.58464533,-0.58475375,-0.55911744,1.7335832,-0.58464533,-0.58475375,-0.55911744,1.7338789,-0.58464533,-0.58475375,-0.55911744,1.7319076,-0.58465519,-0.58475375,-0.56014249,1.7344801,-0.58465519,-0.58475375,-0.56014249,1.7337311,-0.58465519,-0.58475375,-0.56014249,1.7336325,-0.58465519,-0.58475375,-0.56014249,1.7351011,-0.58465519,-0.58475375,-0.56014249,1.7341155,-0.58465519,-0.58475375,-0.56014249,1.7385311,-0.58465519,-0.58475375,-0.56116755,1.7392013,-0.58465519,-0.58475375,-0.56116755,1.739911,-0.58465519,-0.58475375,-0.56116755,1.739704,-0.58465519,-0.58475375,-0.56116755,1.7389253,-0.58465519,-0.58475375,-0.56116755,1.7413007,-0.58465519,-0.58475375,-0.56219261,1.7425623,-0.58466504,-0.58475375,-0.56219261,1.7419217,-0.58466504,-0.58475375,-0.56219261,1.7402461,-0.58466504,-0.58475375,-0.56219261,1.7417837,-0.58466504,-0.58475375,-0.56219261,1.7429566,-0.58466504,-0.58475375,-0.56321767,1.7442872,-0.58466504,-0.58475375,-0.56321767,1.7438338,-0.58466504,-0.58475375,-0.56321767,1.7413007,-0.58466504,-0.58475375,-0.56321767,1.7414486,-0.58466504,-0.58475375,-0.56321767,1.7426116,-0.58466504,-0.58475375,-0.56424273,1.7411332,-0.5846749,-0.58475375,-0.56424273,1.7396547,-0.5846749,-0.58475375,-0.56424273,1.7408473,-0.5846749,-0.58475375,-0.56424273,1.7325483,-0.5846749,-0.58475375,-0.56424273,1.7367175,-0.5846749,-0.58475375,-0.56424273,1.7365303,-0.5846749,-0.58475375,-0.56526779,1.7359684,-0.5846749,-0.58475375,-0.56526779,1.7351997,-0.5846749,-0.58475375,-0.56526779,1.7374272,-0.5846749,-0.58475375,-0.56526779,1.7368752,-0.5846749,-0.58475375,-0.56526779,1.7346576,-0.5846749,-0.58372869,-0.56526779,1.7356629,-0.5846749,-0.58475375,-0.56526779,1.7360079,-0.5846749,-0.58475375,-0.56629284,1.7354066,-0.58468476,-0.58475375,-0.56629284,1.7351109,-0.58468476,-0.58475375,-0.56629284,1.7348251,-0.58468476,-0.58475375,-0.56629284,1.7371906,-0.58468476,-0.58475375,-0.56629284,1.7361064,-0.58468476,-0.58475375,-0.56629284,1.7385902,-0.58468476,-0.58372869,-0.56629284,1.7382847,-0.58468476,-0.58475375,-0.56629284,1.7394674,-0.58468476,-0.58475375,-0.56629284,1.7391225,-0.58468476,-0.58475375,-0.5673179,1.7388169,-0.58468476,-0.58475375,-0.5673179,1.7413599,-0.58468476,-0.58475375,-0.5673179,1.7462782,-0.58468476,-0.58372869,-0.5673179,1.7479636,-0.58468476,-0.58372869,-0.5673179,1.7438535,-0.58468476,-0.58475375,-0.5673179,1.7439422,-0.58468476,-0.58475375,-0.5673179,1.7439915,-0.58468476,-0.58475375,-0.56834296,1.739704,-0.58468476,-0.58372869,-0.56834296,1.7354559,-0.58468476,-0.58372869,-0.56834296,1.7319766,-0.58468476,-0.58372869,-0.56834296,1.7320653,-0.58468476,-0.58475375,-0.56834296,1.730991,-0.58468476,-0.58475375,-0.56834296,1.730646,-0.58468476,-0.58372869,-0.56834296,1.7295224,-0.58468476,-0.58372869,-0.56936802,1.7282115,-0.58469461,-0.58475375,-0.56936802,1.7284579,-0.58469461,-0.58372869,-0.56936802,1.7300448,-0.58469461,-0.58372869,-0.56936802,1.7284678,-0.58469461,-0.58372869,-0.56936802,1.7267626,-0.58469461,-0.58372869,-0.56936802,1.725777,-0.58469461,-0.58372869,-0.56936802,1.7247519,-0.58469461,-0.58372869,-0.56936802,1.722899,-0.58469461,-0.58372869,-0.56936802,1.7224948,-0.58469461,-0.58372869,-0.56936802,1.7233326,-0.58469461,-0.58372869,-0.56936802,1.7241113,-0.58469461,-0.58372869,-0.57039308,1.7260924,-0.58469461,-0.58372869,-0.57039308,1.723924,-0.58469461,-0.58372869,-0.57039308,1.7268218,-0.58469461,-0.58372869,-0.57039308,1.727492,-0.58469461,-0.58372869,-0.57039308,1.724062,-0.58469461,-0.58372869,-0.57039308,1.7252546,-0.58469461,-0.58475375,-0.57039308,1.719193,-0.58469461,-0.58372869,-0.57039308,1.7221597,-0.58469461,-0.58372869,-0.57039308,1.7200505,-0.58469461,-0.58372869,-0.57141814,1.7281721,-0.58470447,-0.58372869,-0.57141814,1.7293056,-0.58470447,-0.58372869,-0.57141814,1.7310698,-0.58470447,-0.58372869,-0.57141814,1.7314148,-0.58470447,-0.58372869,-0.57141814,1.730991,-0.58470447,-0.58372869,-0.57141814,1.7312276,-0.58470447,-0.58372869,-0.57141814,1.7322033,-0.58470447,-0.58372869,-0.57141814,1.7330214,-0.58470447,-0.58372869,-0.57141814,1.7309811,-0.58470447,-0.58372869,-0.57141814,1.7324694,-0.58470447,-0.58372869,-0.57141814,1.7322428,-0.58470447,-0.58372869,-0.57141814,1.732499,-0.58470447,-0.58372869,-0.57141814,1.7340267,-0.58470447,-0.58372869,-0.57245305,1.7333565,-0.58470447,-0.58372869,-0.57245305,1.7346576,-0.58470447,-0.58372869,-0.57245305,1.7361656,-0.58470447,-0.58372869,-0.57245305,1.7358797,-0.58470447,-0.58372869,-0.57245305,1.7347167,-0.58470447,-0.58372869,-0.57245305,1.7313754,-0.58470447,-0.58372869,-0.57245305,1.7347265,-0.58470447,-0.58372869,-0.57245305,1.7350912,-0.58470447,-0.58372869,-0.57245305,1.7361656,-0.58470447,-0.58475375,-0.58475375,1.7367964,-0.58475375,-0.58475375,-0.55808252,1.7383143,-0.58464533,-0.58372869,-0.57245305,1.736205,-0.58470447,-0.58372869,-0.57245305,1.7341746,-0.58470447,-0.58372869,-0.57245305,1.7340859,-0.58470447,-0.58372869,-0.57245305,1.7351602,-0.58470447,-0.58372869,-0.57347811,1.7332382,-0.58471433,-0.58372869,-0.57347811,1.7373779,-0.58471433,-0.58372869,-0.57347811,1.7375455,-0.58471433,-0.58372869,-0.57347811,1.7371413,-0.58471433,-0.58372869,-0.57347811,1.7377623,-0.58471433,-0.58372869,-0.57347811,1.7326173,-0.58471433,-0.58372869,-0.57347811,1.7364415,-0.58471433,-0.58372869,-0.57347811,1.735929,-0.58471433,-0.58372869,-0.57347811,1.7371808,-0.58471433,-0.58372869,-0.57450317,1.7318781,-0.58471433,-0.58372869,-0.57450317,1.7383044,-0.58471433,-0.58372869,-0.57450317,1.7377032,-0.58471433,-0.58372869,-0.57450317,1.737782,-0.58471433,-0.58372869,-0.57450317,1.7362838,-0.58471433,-0.58372869,-0.57450317,1.7376637,-0.58471433,-0.58372869,-0.57450317,1.741419,-0.58471433,-0.58372869,-0.57450317,1.7405122,-0.58471433,-0.58372869,-0.57450317,1.7417541,-0.58471433,-0.58372869,-0.57450317,1.7417541,-0.58471433,-0.58372869,-0.57450317,1.7418625,-0.58471433,-0.58372869,-0.57450317,1.7425525,-0.58471433,-0.58372869,-0.57450317,1.7406108,-0.58471433,-0.58372869,-0.57450317,1.7413204,-0.58471433,-0.58372869,-0.57450317,1.7424441,-0.58471433,-0.58372869,-0.57552823,1.7429369,-0.58472418,-0.58372869,-0.57552823,1.7433607,-0.58472418,-0.58372869,-0.57552823,1.743548,-0.58472418,-0.58475375,-0.57552823,1.7424441,-0.58472418,-0.58475375,-0.57552823,1.743479,-0.58472418,-0.58372869,-0.57552823,1.7432424,-0.58472418,-0.58372869,-0.57552823,1.7431044,-0.58472418,-0.58372869,-0.57552823,1.7432424,-0.58472418,-0.58372869,-0.57552823,1.7434987,-0.58472418,-0.58372869,-0.57552823,1.7420991,-0.58472418,-0.58372869,-0.57552823,1.7454404,-0.58472418,-0.58372869,-0.57552823,1.7461796,-0.58472418,-0.58372869,-0.57552823,1.7382551,-0.58472418,-0.58372869,-0.57552823,1.7417147,-0.58472418,-0.58372869,-0.57552823,1.7395167,-0.58472418,-0.58372869,-0.57552823,1.7398124,-0.58472418,-0.58372869,-0.57552823,1.7358896,-0.58472418,-0.58475375,-0.57655328,1.7357516,-0.58472418,-0.58372869,-0.57552823,1.7350419,-0.58472418,-0.58372869,-0.57655328,1.7366091,-0.58472418,-0.58372869,-0.57655328,1.7417738,-0.58472418,-0.58372869,-0.57655328,1.7418428,-0.58472418,-0.58372869,-0.57655328,1.7409459,-0.58472418,-0.58372869,-0.57655328,1.7347857,-0.58472418,-0.58372869,-0.57552823,1.7326764,-0.58472418,-0.58372869,-0.57552823,1.7391225,-0.58472418,-0.58372869,-0.57655328,1.7372005,-0.58472418,-0.58372869,-0.57655328,1.7302321,-0.58472418,-0.58372869,-0.57655328,1.7295323,-0.58472418,-0.58372869,-0.57655328,1.727492,-0.58472418,-0.58372869,-0.57655328,1.7234115,-0.58472418,-0.58372869,-0.57655328,1.7203067,-0.58472418,-0.58372869,-0.57655328,1.7208488,-0.58472418,-0.58372869,-0.57655328,1.7188776,-0.58472418,-0.58372869,-0.57655328,1.7173794,-0.58472418,-0.58372869,-0.57655328,1.7166599,-0.58472418,-0.58372869,-0.57655328,1.7139395,-0.58472418,-0.58372869,-0.57655328,1.7134862,-0.58472418,-0.58475375,-0.57655328,1.7133285,-0.58472418,-0.58372869,-0.57655328,1.7134467,-0.58472418,-0.58372869,-0.57655328,1.7172611,-0.58472418,-0.58372869,-0.57655328,1.7177244,-0.58472418,-0.58372869,-0.57655328,1.7150139,-0.58472418,-0.58372869,-0.57655328,1.7158517,-0.58472418,-0.58372869,-0.57757834,1.7150435,-0.58472418,-0.58372869,-0.57757834,1.7268316,-0.58472418,-0.58372869,-0.57757834,1.7276891,-0.58472418,-0.58372869,-0.57757834,1.7291183,-0.58472418,-0.58372869,-0.57757834,1.7281721,-0.58472418,-0.58372869,-0.57757834,1.7307446,-0.58472418,-0.58372869,-0.57757834,1.729,-0.58472418,-0.58475375,-0.57757834,1.7282805,-0.58472418,-0.58372869,-0.57757834,1.725708,-0.58472418,-0.58372869,-0.57757834,1.7292169,-0.58472418,-0.58372869,-0.57757834,1.7244661,-0.58472418,-0.58372869,-0.57757834,1.7244168,-0.58472418,-0.58372869,-0.57757834,1.7239142,-0.58472418,-0.58372869,-0.57757834,1.7234706,-0.58472418,-0.58372869,-0.57757834,1.724614,-0.58472418,-0.58372869,-0.57757834,1.7245252,-0.58472418,-0.58475375,-0.57757834,1.7237466,-0.58472418,-0.58372869,-0.57757834,1.7198238,-0.58472418,-0.58475375,-0.57757834,1.7235988,-0.58472418,-0.58372869,-0.57757834,1.7246632,-0.58472418,-0.58372869,-0.5786034,1.7205039,-0.58473404,-0.58372869,-0.5786034,1.7205137,-0.58473404,-0.58372869,-0.57757834,1.7250476,-0.58472418,-0.58475375,-0.57757834,1.7245055,-0.58472418,-0.58475375,-0.5786034,1.7268316,-0.58473404,-0.58372869,-0.5786034,1.7268218,-0.58473404,-0.58372869,-0.5786034,1.7268021,-0.58473404,-0.58475375,-0.5786034,1.7244858,-0.58473404,-0.58475375,-0.5786034,1.7257277,-0.58473404,-0.58475375,-0.5786034,1.7277778,-0.58473404,-0.58372869,-0.5786034,1.7285762,-0.58473404,-0.58372869,-0.5786034,1.7307446,-0.58473404,-0.58372869,-0.5786034,1.7298477,-0.58473404,-0.58475375,-0.5786034,1.7242,-0.58473404,-0.58372869,-0.5786034,1.7305967,-0.58473404,-0.58372869,-0.5786034,1.7302025,-0.58473404,-0.58475375,-0.5786034,1.7302123,-0.58473404,-0.58372869,-0.5786034,1.730439,-0.58473404,-0.58475375,-0.5786034,1.7250969,-0.58473404,-0.58475375,-0.5786034,1.7274723,-0.58473404,-0.58475375,-0.5786034,1.7319076,-0.58473404,-0.58372869,-0.5786034,1.7275906,-0.58473404,-0.58475375,-0.5786034,1.7314247,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404,-0.58372869,-0.5786034,1.7327257,-0.58473404:9
-0.59143435,-0.51110416,1.7268197,-0.58042175,-0.59143435,-0.51110416,1.727921,-0.58042175,-0.59143435,-0.51110416,1.7270256,-0.58042175,-0.59143435,-0.51110416,1.7266859,-0.58042175,-0.59143435,-0.51110416,1.7255641,-0.58042175,-0.59036397,-0.51110416,1.7247304,-0.58042175,-0.59036397,-0.51110416,1.7225588,-0.58042175,-0.59036397,-0.51110416,1.7232175,-0.58042175,-0.59036397,-0.51110416,1.7271696,-0.58042175,-0.59036397,-0.51217454,1.7303088,-0.58042175,-0.5882232,-0.51110416,1.7319658,-0.58046292,-0.5882232,-0.52181828,1.7280857,-0.58047322,-0.58715282,-0.52181828,1.7320893,-0.58047322,-0.58715282,-0.52181828,1.7324392,-0.58047322,-0.58715282,-0.52181828,1.733489,-0.58047322,-0.58715282,-0.52181828,1.7340448,-0.58047322,-0.5882232,-0.52181828,1.7338184,-0.58047322,-0.5882232,-0.52181828,1.7304426,-0.58047322,-0.58715282,-0.52288867,1.7340139,-0.58047322,-0.5882232,-0.52288867,1.7223426,-0.58047322,-0.5882232,-0.52288867,1.72683,-0.58047322,-0.58715282,-0.52288867,1.7332935,-0.58047322,-0.5882232,-0.52395905,1.7332729,-0.58048351,-0.5882232,-0.52395905,1.7102802,-0.58047322,-0.5882232,-0.52502943,1.7272314,-0.58048351,-0.58715282,-0.52502943,1.7263463,-0.58048351,-0.58715282,-0.52609982,1.726089,-0.5804938,-0.5882232,-0.52609982,1.7251215,-0.5804938,-0.5882232,-0.52609982,1.7218177,-0.5804938,-0.58715282,-0.52718049,1.7324495,-0.5804938,-0.58715282,-0.52718049,1.7354137,-0.5804938,-0.58608243,-0.52718049,1.7363502,-0.5804938,-0.58608243,-0.52825087,1.7321716,-0.58050409,-0.58608243,-0.52825087,1.7321099,-0.58050409,-0.58715282,-0.52825087,1.7364326,-0.58050409,-0.58501205,-0.52932126,1.738666,-0.58050409,-0.58501205,-0.52932126,1.733489,-0.58050409,-0.58501205,-0.52932126,1.7363708,-0.58050409,-0.58501205,-0.53039164,1.7425358,-0.58051438,-0.58501205,-0.53039164,1.7369163,-0.58051438,-0.58501205,-0.53039164,1.7391497,-0.58051438,-0.58608243,-0.53039164,1.738491,-0.58051438,-0.58501205,-0.53146202,1.7283532,-0.58051438,-0.58501205,-0.53146202,1.7365973,-0.58051438,-0.58394167,-0.53146202,1.7334273,-0.58051438,-0.58501205,-0.53146202,1.7287649,-0.58051438,-0.58501205,-0.53253241,1.730988,-0.58052468,-0.58501205,-0.53253241,1.7230425,-0.58051438,-0.58501205,-0.53253241,1.7276225,-0.58052468,-0.58501205,-0.53253241,1.730422,-0.58052468,-0.58501205,-0.53360279,1.7297221,-0.58052468,-0.58501205,-0.53360279,1.7318011,-0.58052468,-0.58501205,-0.53360279,1.7288781,-0.58052468,-0.58501205,-0.53360279,1.7328921,-0.58052468,-0.58501205,-0.53467317,1.7277563,-0.58052468,-0.58501205,-0.53467317,1.7273961,-0.58052468,-0.58501205,-0.53467317,1.7309777,-0.58052468,-0.58394167,-0.53467317,1.7320172,-0.58052468,-0.58394167,-0.53467317,1.7322128,-0.58052468,-0.58394167,-0.53574356,1.7421962,-0.58053497,-0.58394167,-0.53574356,1.7408582,-0.58053497,-0.58501205,-0.53574356,1.7435547,-0.58053497,-0.58501205,-0.53574356,1.7404568,-0.58053497,-0.58394167,-0.53574356,1.7422682,-0.58053497,-0.58394167,-0.53574356,1.743318,-0.58053497,-0.58394167,-0.53574356,1.7385425,-0.58053497,-0.58394167,-0.53681394,1.7367619,-0.58054526,-0.58394167,-0.53681394,1.7391909,-0.58054526,-0.58394167,-0.53681394,1.7406524,-0.58054526,-0.58394167,-0.53681394,1.7429681,-0.58054526,-0.58394167,-0.53681394,1.7349196,-0.58053497,-0.58394167,-0.53681394,1.7325216,-0.58053497,-0.58394167,-0.53681394,1.7331185,-0.58053497,-0.58394167,-0.53788432,1.7335508,-0.58054526,-0.58394167,-0.53788432,1.733067,-0.58054526,-0.58394167,-0.53788432,1.7375853,-0.58054526,-0.58394167,-0.53788432,1.7407656,-0.58054526,-0.58394167,-0.53788432,1.7440591,-0.58054526,-0.58394167,-0.53788432,1.7412802,-0.58054526,-0.58073052,-0.57002669,1.7440899,-0.58073052,-0.58073052,-0.58073052,1.7425667,-0.58073052,-0.58073052,-0.58073052,1.740251,-0.58073052,-0.58073052,-0.58073052,1.7418257,-0.58073052,-0.58073052,-0.58073052,1.7426079,-0.58073052,-0.58073052,-0.58073052,1.7414963,-0.58073052,-0.58073052,-0.58073052,1.7410538,-0.58073052,-0.58073052,-0.58073052,1.7385631,-0.58073052,-0.58073052,-0.58073052,1.7385219,-0.58073052,-0.58073052,-0.58073052,1.7375956,-0.58073052,-0.58073052,-0.58073052,1.7387483,-0.58073052,-0.58073052,-0.58073052,1.7415684,-0.58073052,-0.58073052,-0.58073052,1.7382337,-0.58073052,-0.58073052,-0.58073052,1.7390571,-0.58073052,-0.58073052,-0.58073052,1.7406112,-0.58073052,-0.58073052,-0.58073052,1.7403024,-0.58073052,-0.58073052,-0.58073052,1.7371839,-0.58073052,-0.58073052,-0.58073052,1.7395614,-0.58073052,-0.58073052,-0.58073052,1.7390159,-0.58073052,-0.58073052,-0.58073052,1.7392012,-0.58073052,-0.58073052,-0.58073052,1.7364943,-0.58073052,-0.58073052,-0.58073052,1.7412184,-0.58073052,-0.58073052,-0.58073052,1.7453353,-0.58073052,-0.58073052,-0.58073052,1.7432871,-0.58073052,-0.58073052,-0.58073052,1.7436782,-0.58073052,-0.58073052,-0.58073052,1.7424329,-0.58073052,-0.58073052,-0.58073052,1.7411773,-0.58073052,-0.58073052,-0.58073052,1.7359591,-0.58073052,-0.58073052,-0.58073052,1.7393761,-0.58073052,-0.58073052,-0.58073052,1.731904,-0.58073052,-0.58073052,-0.58073052,1.7353004,-0.58073052,-0.58073052,-0.58073052,1.7371942,-0.58073052,-0.58073052,-0.58073052,1.7397981,-0.58073052,-0.58073052,-0.58073052,1.7351358,-0.58073052,-0.58073052,-0.58073052,1.7373795,-0.58073052,-0.58073052,-0.58073052,1.7324701,-0.58073052,-0.58073052,-0.58073052,1.729825,-0.58073052,-0.58073052,-0.58073052,1.7282503,-0.58073052,-0.58073052,-0.58073052,1.7319761,-0.58073052,-0.58073052,-0.58073052,1.7306278,-0.58073052,-0.58073052,-0.58073052,1.729825,-0.58073052,-0.58073052,-0.58073052,1.7307925,-0.58073052,-0.58073052,-0.58073052,1.7329538,-0.58073052,-0.58073052,-0.58073052,1.7356195,-0.58073052,-0.58073052,-0.58073052,1.7358562,-0.58073052,-0.58073052,-0.58073052,1.7329641,-0.58073052,-0.58073052,-0.58073052,1.7367002,-0.58073052,-0.58073052,-0.58073052,1.7353107,-0.58073052,-0.58073052,-0.58073052,1.732326,-0.58073052,-0.58073052,-0.58073052,1.7336125,-0.58073052,-0.58073052,-0.58073052,1.733417,-0.58073052,-0.58073052,-0.58073052,1.7262228,-0.58073052,-0.58073052,-0.58073052,1.7356915,-0.58073052,-0.58073052,-0.58073052,1.7374103,-0.58073052,-0.58073052,-0.58073052,1.7437812,-0.58073052,-0.58073052,-0.58073052,1.740148,-0.58073052,-0.58073052,-0.58073052,1.7361959,-0.58073052,-0.58073052,-0.58073052,1.7378529,-0.58073052,-0.58073052,-0.58073052,1.7388204,-0.58073052,-0.58073052,-0.58073052,1.7403848,-0.58073052,-0.58073052,-0.58073052,1.7348888,-0.58073052,-0.58073052,-0.58073052,1.7353931,-0.58073052,-0.58073052,-0.58073052,1.7358974,-0.58073052,-0.58073052,-0.58073052,1.7343844,-0.58073052,-0.58073052,-0.58073052,1.7320996,-0.58073052,-0.58073052,-0.58073052,1.734755,-0.58073052,-0.58073052,-0.58073052,1.7372765,-0.58073052,-0.58073052,-0.58073052,1.7375956,-0.58073052,-0.58073052,-0.58073052,1.733489,-0.58073052,-0.58073052,-0.58073052,1.7383469,-0.58073052,-0.58073052,-0.58073052,1.7393658,-0.58073052,-0.58073052,-0.58073052,1.7354548,-0.58073052,-0.58073052,-0.58073052,1.7367825,-0.58073052,-0.58073052,-0.58073052,1.7390056,-0.58073052,-0.58073052,-0.58073052,1.7346315,-0.58073052,-0.58073052,-0.58073052,1.7343742,-0.58073052,-0.58073052,-0.58073052,1.7403539,-0.58073052,-0.58073052,-0.58073052,1.7392938,-0.58073052,-0.58073052,-0.58073052,1.7424535,-0.58073052,-0.58073052,-0.58073052,1.7361238,-0.58073052,-0.58073052,-0.58073052,1.7338595,-0.58073052,-0.58073052,-0.58073052,1.7363502,-0.58073052,-0.58073052,-0.58073052,1.734899,-0.58073052,-0.58073052,-0.58073052,1.7374309,-0.58073052,-0.58073052,-0.58073052,1.7326348,-0.58073052,-0.58073052,-0.58073052,1.7330259,-0.58073052,-0.58073052,-0.58073052,1.7308645,-0.58073052,-0.58073052,-0.58073052,1.7319864,-0.58073052,-0.58073052,-0.58073052,1.7332317,-0.58073052,-0.58073052,-0.58073052,1.7343227,-0.58073052,-0.58073052,-0.58073052,1.7328509,-0.58073052,-0.58073052,-0.58073052,1.7361444,-0.58073052,-0.58073052,-0.58073052,1.7334376,-0.58073052,-0.58073052,-0.58073052,1.7362473,-0.58073052,-0.58073052,-0.58073052,1.7337875,-0.58073052,-0.58073052,-0.58073052,1.7334273,-0.58073052,-0.58073052,-0.58073052,1.7333758,-0.58073052,-0.58073052,-0.58073052,1.7331597,-0.58073052,-0.58073052,-0.58073052,1.7342609,-0.58073052,-0.58073052,-0.58073052,1.7378426,-0.58073052,-0.58073052,-0.58073052,1.7343844,-0.58073052,-0.58073052,-0.58073052,1.7369369,-0.58073052,-0.58073052,-0.58073052,1.7386351,-0.58073052,-0.58073052,-0.58073052,1.7367928,-0.58073052,-0.58073052,-0.58073052,1.7382028,-0.58073052,-0.58073052,-0.58073052,1.7314306,-0.58073052,-0.58073052,-0.58073052,1.729084,-0.58073052,-0.58073052,-0.58073052,1.7276843,-0.58073052,-0.58073052,-0.58073052,1.7239379,-0.58073052,-0.58073052,-0.58073052,1.7271696,-0.58073052,-0.58073052,-0.58073052,1.7296192,-0.58073052,-0.58073052,-0.58073052,1.7319864,-0.58073052,-0.58073052,-0.58073052,1.7333552,-0.58073052,-0.58073052,-0.58073052,1.7318937,-0.58073052,-0.58073052,-0.58073052,1.731904,-0.58073052,-0.58073052,-0.58073052,1.7339419,-0.58073052,-0.58073052,-0.58073052,1.7322128,-0.58073052,-0.58073052,-0.58073052,1.731585,-0.58073052,-0.58073052,-0.58073052,1.7335817,-0.58073052,-0.58073052,-0.58073052,1.7330876,-0.58073052,-0.58073052,-0.58073052,1.7309469,-0.58073052,-0.58073052,-0.58073052,1.7340036,-0.58073052,-0.58073052,-0.58073052,1.7369884,-0.58073052,-0.58073052,-0.58073052,1.7365973,-0.58073052,-0.58073052,-0.58073052,1.7370707,-0.58073052,-0.58073052,-0.58073052,1.731832,-0.58073052,-0.58073052,-0.58073052,1.7300823,-0.58073052,-0.58073052,-0.58073052,1.7314821,-0.58073052,-0.58073052,-0.58073052,1.7306999,-0.58073052,-0.58073052,-0.58073052,1.7303396,-0.58073052,-0.58073052,-0.58073052,1.7303602,-0.58073052,-0.58073052,-0.58073052,1.7318217,-0.58073052,-0.58073052,-0.58073052,1.7331494,-0.58073052,-0.58073052,-0.58073052,1.7307925,-0.58073052,-0.58073052,-0.58073052,1.729331,-0.58073052,-0.58073052,-0.58073052,1.7274578,-0.58073052,-0.58073052,-0.58073052,1.7272932,-0.58073052,-0.58073052,-0.58073052,1.7269123,-0.58073052,-0.58073052,-0.58073052,1.7288473,-0.58073052,-0.58073052,-0.58073052,1.7286105,-0.58073052,-0.58073052,-0.58073052,1.7302264,-0.58073052,-0.58073052,-0.58073052,1.7290634,-0.58073052,-0.58073052,-0.58073052,1.7322334,-0.58073052,-0.58073052,-0.58073052,1.7334067,-0.58073052,-0.58073052,-0.58073052,1.7303088,-0.58073052,-0.58073052,-0.58073052,1.7290634,-0.58073052,-0.58073052,-0.58073052,1.7276122,-0.58073052,-0.58073052,-0.58073052,1.7280754,-0.58073052,-0.58073052,-0.58073052,1.7280239,-0.58073052,-0.58073052,-0.58073052,1.7207474,-0.58073052,-0.58073052,-0.58073052,1.7206547,-0.58073052,-0.58073052,-0.58073052,1.7290428,-0.58073052,-0.58073052,-0.58073052,1.7242055,-0.58073052,-0.58073052,-0.58073052,1.7278592,-0.58073052,-0.58073052,-0.58073052,1.7254303,-0.58073052,-0.58073052,-0.58073052,1.7309469,-0.58073052,-0.58073052,-0.58073052,1.7323363,-0.58073052,-0.58073052,-0.58073052,1.7350328,-0.58073052,-0.58073052,-0.58073052,1.7334684,-0.58073052,-0.58073052,-0.58073052,1.732501,-0.58073052,-0.58073052,-0.58073052,1.7280548,-0.58073052,-0.58073052,-0.58073052,1.7232689,-0.58073052,-0.58073052,-0.58073052,1.7259552,-0.58073052,-0.58073052,-0.58073052,1.72859,-0.58073052,-0.58073052,-0.58073052,1.7287238,-0.58073052,-0.58073052,-0.58073052,1.725173,-0.58073052,-0.58073052,-0.58073052,1.7285385,-0.58073052,-0.58073052,-0.58073052,1.7303602,-0.58073052,-0.58073052,-0.58073052,1.7286003,-0.58073052,-0.58073052,-0.58073052,1.7270256,-0.58073052,-0.58073052,-0.58073052,1.7286517,-0.58073052,-0.58073052,-0.58073052,1.7285488,-0.58073052,-0.58073052,-0.58073052,1.7282092,-0.58073052,-0.58073052,-0.58073052,1.7271388,-0.58073052,-0.58073052,-0.58073052,1.7261919,-0.58073052,-0.58073052,-0.58073052,1.7321305,-0.58073052,-0.58073052,-0.58073052,1.7320893,-0.58073052,-0.58073052,-0.58073052,1.7280445,-0.58073052,-0.58073052,-0.58073052,1.7305043,-0.58073052,-0.58073052,-0.58073052,1.7322848,-0.58073052,-0.58073052,-0.58073052,1.7329024,-0.58073052,-0.58073052,-0.58073052,1.7246378,-0.58073052,-0.58073052,-0.58073052,1.726758,-0.58073052,-0.58073052,-0.58073052,1.7307719,-0.58073052,-0.58073052,-0.58073052,1.7296398,-0.58073052,-0.58073052,-0.58073052,1.7273446,-0.58073052,-0.58073052,-0.58073052,1.7294339,-0.58073052,-0.58073052,-0.58073052,1.7322437,-0.58073052,-0.58073052,-0.58073052,1.7300206,-0.58073052,-0.58073052,-0.58073052,1.7326451,-0.58073052,-0.58073052,-0.58073052,1.7320275,-0.58073052,-0.58073052,-0.58073052,1.7341683,-0.58073052,-0.58073052,-0.58073052,1.7307101,-0.58073052,-0.58073052,-0.58073052,1.7290017,-0.58073052,-0.58073052,-0.58073052,1.7305866,-0.58073052,-0.58073052,-0.58073052,1.7270667,-0.58073052,-0.58073052,-0.58073052,1.7287546,-0.58073052,-0.58073052,-0.58073052,1.7290119,-0.58073052,-0.58073052,-0.58073052,1.73141,-0.58073052,-0.58073052,-0.58073052,1.7324289,-0.58073052,-0.58073052,-0.58073052,1.733417,-0.58073052,-0.58073052,-0.58073052,1.7368854,-0.58073052,-0.58073052,-0.58073052,1.7393555,-0.58073052,-0.58073052,-0.58073052,1.7346212,-0.58073052,-0.58073052,-0.58073052,1.73634,-0.58073052,-0.58073052,-0.58073052,1.7323878,-0.58073052,-0.58073052,-0.58073052,1.7332729,-0.58073052,-0.58073052,-0.58073052,1.7358871,-0.58073052,-0.58073052,-0.58073052,1.7317291,-0.58073052,-0.58073052,-0.58073052,1.7313586,-0.58073052,-0.58073052,-0.58073052,1.7335817,-0.58073052,-0.58073052,-0.58073052,1.7322231,-0.58073052,-0.58073052,-0.58073052,1.7298147,-0.58073052,-0.58073052,-0.58073052,1.7290634,-0.58073052,-0.58073052,-0.58073052,1.7286517,-0.58073052,-0.58073052,-0.58073052,1.732923,-0.58073052,-0.58073052,-0.58073052,1.733417,-0.58073052,-0.58073052,-0.58073052,1.7372765,-0.58073052,-0.58073052,-0.58073052,1.7298662,-0.58073052,-0.58073052,-0.58073052,1.7273343,-0.58073052,-0.58073052,-0.58073052,1.7257802,-0.58073052,-0.58073052,-0.58073052,1.7278489,-0.58073052,-0.58073052,-0.58073052,1.7279004,-0.58073052,-0.58073052,-0.58073052,1.7277357,-0.58073052,-0.58073052,-0.58073052,1.7261199,-0.58073052,-0.58073052,-0.58073052,1.7241232,-0.58073052,-0.58073052,-0.58073052,1.7284665,-0.58073052,-0.58073052,-0.58073052,1.7251627,-0.58073052,-0.58073052,-0.58073052,1.7279107,-0.58073052,-0.58073052,-0.58073052,1.7306999,-0.58073052,-0.58073052,-0.58073052,1.7276637,-0.58073052,-0.58073052,-0.58073052,1.7253582,-0.58073052,-0.58073052,-0.58073052,1.7212928,-0.58073052,-0.58073052,-0.58073052,1.7255847,-0.58073052,-0.58073052,-0.58073052,1.7244731,-0.58073052,-0.58073052,-0.58073052,1.7214369,-0.58073052,-0.58073052,-0.58073052,1.7252141,-0.58073052,-0.58073052,-0.58073052,1.7249363,-0.58073052,-0.58073052,-0.58073052,1.722497,-0.58073052,-0.58073052,-0.58073052,1.7221471,-0.58073052,-0.58073052,-0.58073052,1.7223426,-0.58073052,-0.58073052,-0.58073052,1.7222191,-0.58073052,-0.58073052,-0.58073052,1.7220647,-0.58073052,-0.58073052,-0.58073052,1.7139648,-0.58073052,-0.58073052,-0.58073052,1.7236497,-0.58073052,-0.58073052,-0.58073052,1.7231351,-0.58073052,-0.58073052,-0.58073052,1.724823,-0.58073052,-0.58073052,-0.58073052,1.7220956,-0.58073052,-0.58073052,-0.58073052,1.7244216,-0.58073052,-0.58073052,-0.58073052,1.724576,-0.58073052,-0.58073052,-0.58073052,1.7269123,-0.58073052,-0.58073052,-0.58073052,1.7237321,-0.58073052,-0.58073052,-0.58073052,1.7282194,-0.58073052,-0.58073052,-0.58073052,1.7269123,-0.58073052,-0.58073052,-0.58073052,1.7293722,-0.58073052,-0.58073052,-0.58073052,1.7287958,-0.58073052,-0.58073052,-0.58073052,1.7259758,-0.58073052,-0.58073052,-0.58073052,1.7283121,-0.58073052,-0.58073052,-0.58073052,1.7326451,-0.58073052,-0.58073052,-0.58073052,1.7275402,-0.58073052,-0.58073052,-0.58073052,1.7269021,-0.58073052,-0.58073052,-0.58073052,1.7290428,-0.58073052,-0.58073052,-0.58073052,1.7282092,-0.58073052,-0.58073052,-0.58073052,1.7280136,-0.58073052,-0.58073052,-0.58073052,1.7280651,-0.58073052,-0.58073052,-0.58073052,1.7262022,-0.58073052,-0.58073052,-0.58073052,1.7301132,-0.58073052,-0.58073052,-0.58073052,1.7326759,-0.58073052,-0.58073052,-0.58073052,1.7271902,-0.58073052,-0.58073052,-0.58073052,1.7269844,-0.58073052,-0.58073052,-0.58073052,1.7281886,-0.58073052,-0.58073052,-0.58073052,1.7310395,-0.58073052,-0.58073052,-0.58073052,1.7280342,-0.58073052,-0.58073052,-0.58073052,1.7293104,-0.58073052,-0.58073052,-0.58073052,1.7289914,-0.58073052,-0.58073052,-0.58073052,1.7281371,-0.58073052,-0.58073052,-0.58073052,1.7245554,-0.58073052,-0.58073052,-0.58073052,1.7250495,-0.58073052,-0.58073052,-0.58073052,1.7238556,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052,-0.58073052,-0.58073052,1.7273961,-0.58073052:9
-0.57794535,-0.57794535,1.7307931,-0.57794535,-0.57894577,-0.56488165,1.7310942,-0.5778288,-0.58095631,-0.54878757,1.7322986,-0.57774138,-0.57794535,-0.57794535,1.7319198,-0.57794535,-0.57794535,-0.57794535,1.7318906,-0.57794535,-0.57794535,-0.57794535,1.7311428,-0.57794535,-0.57794535,-0.57794535,1.7283455,-0.57794535,-0.57794535,-0.57794535,1.727889,-0.57794535,-0.57794535,-0.57794535,1.7269371,-0.57794535,-0.57794535,-0.57794535,1.7288117,-0.57794535,-0.57794535,-0.57794535,1.7284135,-0.57794535,-0.57794535,-0.57794535,1.7275393,-0.57794535,-0.57794535,-0.57794535,1.7275102,-0.57794535,-0.57794535,-0.57794535,1.7304823,-0.57794535,-0.57794535,-0.57794535,1.7316187,-0.57794535,-0.57794535,-0.57794535,1.7305891,-0.57794535,-0.57794535,-0.57794535,1.7298898,-0.57794535,-0.57794535,-0.57794535,1.7316284,-0.57794535,-0.57794535,-0.57794535,1.7310068,-0.57794535,-0.57794535,-0.57794535,1.7328716,-0.57794535,-0.57794535,-0.57794535,1.7327842,-0.57794535,-0.57794535,-0.57794535,1.7328231,-0.57794535,-0.57794535,-0.57794535,1.7332116,-0.57794535,-0.57794535,-0.57794535,1.7336584,-0.57794535,-0.57794535,-0.57794535,1.7324734,-0.57794535,-0.57794535,-0.57794535,1.7351833,-0.57794535,-0.57794535,-0.57794535,1.736242,-0.57794535,-0.57794535,-0.57794535,1.7344451,-0.57794535,-0.57794535,-0.57794535,1.7346879,-0.57794535,-0.57794535,-0.57794535,1.7346976,-0.57794535,-0.57794535,-0.57794535,1.7348045,-0.57794535,-0.57794535,-0.57794535,1.7342606,-0.57794535,-0.57794535,-0.57794535,1.7330659,-0.57794535,-0.57794535,-0.57794535,1.7341926,-0.57794535,-0.57794535,-0.57794535,1.7320655,-0.57794535,-0.57794535,-0.57794535,1.7334156,-0.57794535,-0.57794535,-0.57794535,1.7341926,-0.57794535,-0.57794535,-0.57794535,1.7336875,-0.57794535,-0.57794535,-0.57794535,1.7323763,-0.57794535,-0.57794535,-0.57794535,1.7303949,-0.57794535,-0.57794535,-0.57794535,1.7302589,-0.57794535,-0.57794535,-0.57794535,1.7299481,-0.57794535,-0.57794535,-0.57794535,1.7310651,-0.57794535,-0.57794535,-0.57794535,1.7308028,-0.57794535,-0.57794535,-0.57794535,1.7294236,-0.57794535,-0.57794535,-0.57794535,1.7307542,-0.57794535,-0.57794535,-0.57794535,1.7307737,-0.57794535,-0.57794535,-0.57794535,1.729307,-0.57794535,-0.57794535,-0.57794535,1.728462,-0.57794535,-0.57794535,-0.57794535,1.7290836,-0.57794535,-0.57794535,-0.57794535,1.7290157,-0.57794535,-0.57794535,-0.57794535,1.7272479,-0.57794535,-0.57794535,-0.57794535,1.7270245,-0.57794535,-0.57794535,-0.57794535,1.7279375,-0.57794535,-0.57794535,-0.57794535,1.7290836,-0.57794535,-0.57794535,-0.57794535,1.7301035,-0.57794535,-0.57794535,-0.57794535,1.729783,-0.57794535,-0.57794535,-0.57794535,1.7298218,-0.57794535,-0.57794535,-0.57794535,1.7288311,-0.57794535,-0.57794535,-0.57794535,1.7302006,-0.57794535,-0.57794535,-0.57794535,1.7290642,-0.57794535,-0.57794535,-0.57794535,1.7303172,-0.57794535,-0.57794535,-0.57794535,1.7289865,-0.57794535,-0.57794535,-0.57794535,1.7291031,-0.57794535,-0.57794535,-0.57794535,1.7299578,-0.57794535,-0.57794535,-0.57794535,1.73022,-0.57794535,-0.57794535,-0.57794535,1.7291128,-0.57794535,-0.57794535,-0.57794535,1.7303657,-0.57794535,-0.57794535,-0.57794535,1.7291516,-0.57794535,-0.57794535,-0.57794535,1.7283261,-0.57794535,-0.57794535,-0.57794535,1.728598,-0.57794535,-0.57794535,-0.57794535,1.7289574,-0.57794535,-0.57794535,-0.57794535,1.7276753,-0.57794535,-0.57794535,-0.57794535,1.7279764,-0.57794535,-0.57794535,-0.57794535,1.7270731,-0.57794535,-0.57794535,-0.57794535,1.7270148,-0.57794535,-0.57794535,-0.57794535,1.7281124,-0.57794535,-0.57794535,-0.57794535,1.7238873,-0.57794535,-0.57794535,-0.57794535,1.7227023,-0.57794535,-0.57794535,-0.57794535,1.7237416,-0.57794535,-0.57794535,-0.57794535,1.7270634,-0.57794535,-0.57794535,-0.57794535,1.7269468,-0.57794535,-0.57794535,-0.57794535,1.7265292,-0.57794535,-0.57794535,-0.57794535,1.7271702,-0.57794535,-0.57794535,-0.57794535,1.7255385,-0.57794535,-0.57794535,-0.57794535,1.7256259,-0.57794535,-0.57794535,-0.57794535,1.7250431,-0.57794535,-0.57794535,-0.57794535,1.7255773,-0.57794535,-0.57794535,-0.57794535,1.7267429,-0.57794535,-0.57794535,-0.57794535,1.7253928,-0.57794535,-0.57794535,-0.57794535,1.7292585,-0.57794535,-0.57794535,-0.57794535,1.7256065,-0.57794535,-0.57794535,-0.57794535,1.725927,-0.57794535,-0.57794535,-0.57794535,1.7275199,-0.57794535,-0.57794535,-0.57794535,1.7293362,-0.57794535,-0.57794535,-0.57794535,1.7336098,-0.57794535,-0.57794535,-0.57794535,1.733095,-0.57794535,-0.57794535,-0.57794535,1.7318129,-0.57794535,-0.57794535,-0.57794535,1.7319975,-0.57794535,-0.57794535,-0.57794535,1.7331047,-0.57794535,-0.57794535,-0.57794535,1.7328522,-0.57794535,-0.57794535,-0.57794535,1.7321432,-0.57794535,-0.57794535,-0.57794535,1.7326385,-0.57794535,-0.57794535,-0.57794535,1.7337846,-0.57794535,-0.57794535,-0.57794535,1.73394,-0.57794535,-0.57794535,-0.57794535,1.7327551,-0.57794535,-0.57794535,-0.57794535,1.7336098,-0.57794535,-0.57794535,-0.57794535,1.735057,-0.57794535,-0.57794535,-0.57794535,1.7348822,-0.57794535,-0.57794535,-0.57794535,1.7325705,-0.57794535,-0.57794535,-0.57794535,1.7308514,-0.57794535,-0.57794535,-0.57794535,1.7328911,-0.57794535,-0.57794535,-0.57794535,1.7316867,-0.57794535,-0.57794535,-0.57794535,1.7339498,-0.57794535,-0.57794535,-0.57794535,1.7339206,-0.57794535,-0.57794535,-0.57794535,1.7345228,-0.57794535,-0.57794535,-0.57794535,1.7328716,-0.57794535,-0.57794535,-0.57794535,1.7323277,-0.57794535,-0.57794535,-0.57794535,1.7313953,-0.57794535,-0.57794535,-0.57794535,1.7320946,-0.57794535,-0.57794535,-0.57794535,1.7327842,-0.57794535,-0.57794535,-0.57794535,1.7327357,-0.57794535,-0.57794535,-0.57794535,1.732386,-0.57794535,-0.57794535,-0.57794535,1.7334738,-0.57794535,-0.57794535,-0.57794535,1.7332504,-0.57794535,-0.57794535,-0.57794535,1.7340372,-0.57794535,-0.57794535,-0.57794535,1.7311622,-0.57794535,-0.57794535,-0.57794535,1.7334447,-0.57794535,-0.57794535,-0.57794535,1.7332504,-0.57794535,-0.57794535,-0.57794535,1.7294236,-0.57794535,-0.57794535,-0.57794535,1.7309874,-0.57794535,-0.57794535,-0.57794535,1.7302686,-0.57794535,-0.57794535,-0.57794535,1.7311622,-0.57794535,-0.57794535,-0.57794535,1.7299772,-0.57794535,-0.57794535,-0.57794535,1.7283746,-0.57794535,-0.57794535,-0.57794535,1.7279667,-0.57794535,-0.57794535,-0.57794535,1.7283066,-0.57794535,-0.57794535,-0.57794535,1.727112,-0.57794535,-0.57794535,-0.57794535,1.7277433,-0.57794535,-0.57794535,-0.57794535,1.7287923,-0.57794535,-0.57794535,-0.57794535,1.729307,-0.57794535,-0.57794535,-0.57794535,1.7301035,-0.57794535,-0.57794535,-0.57794535,1.7278696,-0.57794535,-0.57794535,-0.57794535,1.7279375,-0.57794535,-0.57794535,-0.57794535,1.7267623,-0.57794535,-0.57794535,-0.57794535,1.7282095,-0.57794535,-0.57794535,-0.57794535,1.727044,-0.57794535,-0.57794535,-0.57794535,1.7314536,-0.57794535,-0.57794535,-0.57794535,1.7290836,-0.57794535,-0.57794535,-0.57794535,1.7297927,-0.57794535,-0.57794535,-0.57794535,1.7302298,-0.57794535,-0.57794535,-0.57794535,1.7312885,-0.57794535,-0.57794535,-0.57794535,1.7305017,-0.57794535,-0.57794535,-0.57794535,1.7291711,-0.57794535,-0.57794535,-0.57794535,1.7294042,-0.57794535,-0.57794535,-0.57794535,1.7275005,-0.57794535,-0.57794535,-0.57794535,1.7281706,-0.57794535,-0.57794535,-0.57794535,1.7312205,-0.57794535,-0.57794535,-0.57794535,1.7301618,-0.57794535,-0.57794535,-0.57794535,1.7272771,-0.57794535,-0.57794535,-0.57794535,1.7301521,-0.57794535,-0.57794535,-0.57794535,1.7276656,-0.57794535,-0.57794535,-0.57794535,1.7277141,-0.57794535,-0.57794535,-0.57794535,1.7269663,-0.57794535,-0.57794535,-0.57794535,1.7308319,-0.57794535,-0.57794535,-0.57794535,1.7325511,-0.57794535,-0.57794535,-0.57794535,1.7321917,-0.57794535,-0.57794535,-0.57794535,1.7317158,-0.57794535,-0.57794535,-0.57794535,1.7316575,-0.57794535,-0.57794535,-0.57794535,1.7323666,-0.57794535,-0.57794535,-0.57794535,1.7345131,-0.57794535,-0.57794535,-0.57794535,1.7319683,-0.57794535,-0.57794535,-0.57794535,1.7363877,-0.57794535,-0.57794535,-0.57794535,1.7331339,-0.57794535,-0.57794535,-0.57794535,1.7354455,-0.57794535,-0.57794535,-0.57794535,1.7343965,-0.57794535,-0.57794535,-0.57794535,1.7331242,-0.57794535,-0.57794535,-0.57794535,1.7349696,-0.57794535,-0.57794535,-0.57794535,1.7357369,-0.57794535,-0.57794535,-0.57794535,1.7365431,-0.57794535,-0.57794535,-0.57794535,1.7352707,-0.57794535,-0.57794535,-0.57794535,1.7346976,-0.57794535,-0.57794535,-0.57794535,1.7375629,-0.57794535,-0.57794535,-0.57794535,1.7353872,-0.57794535,-0.57794535,-0.57794535,1.7326482,-0.57794535,-0.57794535,-0.57794535,1.7338332,-0.57794535,-0.57794535,-0.57794535,1.7342703,-0.57794535,-0.57794535,-0.57794535,1.735766,-0.57794535,-0.57794535,-0.57794535,1.7331339,-0.57794535,-0.57794535,-0.57794535,1.7354067,-0.57794535,-0.57794535,-0.57794535,1.7348822,-0.57794535,-0.57794535,-0.57794535,1.7326677,-0.57794535,-0.57794535,-0.57794535,1.7341149,-0.57794535,-0.57794535,-0.57794535,1.7359117,-0.57794535,-0.57794535,-0.57794535,1.736242,-0.57794535,-0.57794535,-0.57794535,1.7351347,-0.57794535,-0.57794535,-0.57794535,1.7318809,-0.57794535,-0.57794535,-0.57794535,1.7311622,-0.57794535,-0.57794535,-0.57794535,1.7312982,-0.57794535,-0.57794535,-0.57794535,1.7325997,-0.57794535,-0.57794535,-0.57794535,1.7327745,-0.57794535,-0.57794535,-0.57794535,1.733095,-0.57794535,-0.57794535,-0.57794535,1.7335807,-0.57794535,-0.57794535,-0.57794535,1.7332213,-0.57794535,-0.57794535,-0.57794535,1.7319295,-0.57794535,-0.57794535,-0.57794535,1.7318324,-0.57794535,-0.57794535,-0.57794535,1.732522,-0.57794535,-0.57794535,-0.57794535,1.7322112,-0.57794535,-0.57794535,-0.57794535,1.7319683,-0.57794535,-0.57794535,-0.57794535,1.7287728,-0.57794535,-0.57794535,-0.57794535,1.7310262,-0.57794535,-0.57794535,-0.57794535,1.7341246,-0.57794535,-0.57794535,-0.57794535,1.735261,-0.57794535,-0.57794535,-0.57794535,1.7329202,-0.57794535,-0.57794535,-0.57794535,1.7332213,-0.57794535,-0.57794535,-0.57794535,1.7338332,-0.57794535,-0.57794535,-0.57794535,1.732046,-0.57794535,-0.57794535,-0.57794535,1.7340177,-0.57794535,-0.57794535,-0.57794535,1.7327065,-0.57794535,-0.57794535,-0.57794535,1.736747,-0.57794535,-0.57794535,-0.57794535,1.7367179,-0.57794535,-0.57794535,-0.57794535,1.7374852,-0.57794535,-0.57794535,-0.57794535,1.7361837,-0.57794535,-0.57794535,-0.57794535,1.7355912,-0.57794535,-0.57794535,-0.57794535,1.7341052,-0.57794535,-0.57794535,-0.57794535,1.7336972,-0.57794535,-0.57794535,-0.57794535,1.7338818,-0.57794535,-0.57794535,-0.57794535,1.7334933,-0.57794535,-0.57794535,-0.57794535,1.737087,-0.57794535,-0.57794535,-0.57794535,1.7387673,-0.57794535,-0.57794535,-0.57794535,1.7389033,-0.57794535,-0.57794535,-0.57794535,1.7401271,-0.57794535,-0.57794535,-0.57794535,1.7385148,-0.57794535,-0.57794535,-0.57794535,1.7373687,-0.57794535,-0.57794535,-0.57794535,1.7358632,-0.57794535,-0.57794535,-0.57794535,1.7345617,-0.57794535,-0.57794535,-0.57794535,1.7362614,-0.57794535,-0.57794535,-0.57794535,1.7351056,-0.57794535,-0.57794535,-0.57794535,1.7354649,-0.57794535,-0.57794535,-0.57794535,1.735057,-0.57794535,-0.57794535,-0.57794535,1.7356981,-0.57794535,-0.57794535,-0.57794535,1.7354164,-0.57794535,-0.57794535,-0.57794535,1.7367179,-0.57794535,-0.57794535,-0.57794535,1.7347656,-0.57794535,-0.57794535,-0.57794535,1.7350667,-0.57794535,-0.57794535,-0.57794535,1.7311913,-0.57794535,-0.57794535,-0.57794535,1.7316575,-0.57794535,-0.57794535,-0.57794535,1.7355427,-0.57794535,-0.57794535,-0.57794535,1.7358923,-0.57794535,-0.57794535,-0.57794535,1.7361157,-0.57794535,-0.57794535,-0.57794535,1.7358243,-0.57794535,-0.57794535,-0.57794535,1.733571,-0.57794535,-0.57794535,-0.57794535,1.7332893,-0.57794535,-0.57794535,-0.57794535,1.7346199,-0.57794535,-0.57794535,-0.57794535,1.7329688,-0.57794535,-0.57794535,-0.57794535,1.7332213,-0.57794535,-0.57794535,-0.57794535,1.7336389,-0.57794535,-0.57794535,-0.57794535,1.732658,-0.57794535,-0.57794535,-0.57794535,1.7322792,-0.57794535,-0.57794535,-0.57794535,1.7331242,-0.57794535,-0.57794535,-0.57794535,1.7345131,-0.57794535,-0.57794535,-0.57794535,1.7373687,-0.57794535,-0.57794535,-0.57794535,1.7361448,-0.57794535,-0.57794535,-0.57794535,1.7347851,-0.57794535,-0.57794535,-0.57794535,1.7354941,-0.57794535,-0.57794535,-0.57794535,1.732386,-0.57794535,-0.57794535,-0.57794535,1.7311913,-0.57794535,-0.57794535,-0.57794535,1.7331824,-0.57794535,-0.57794535,-0.57794535,1.7314341,-0.57794535,-0.57794535,-0.57794535,1.7305697,-0.57794535,-0.57794535,-0.57794535,1.7313273,-0.57794535,-0.57794535,-0.57794535,1.7329202,-0.57794535,-0.57794535,-0.57794535,1.7308805,-0.57794535,-0.57794535,-0.57794535,1.7308028,-0.57794535,-0.57794535,-0.57794535,1.7313079,-0.57794535,-0.57794535,-0.57794535,1.7314147,-0.57794535,-0.57794535,-0.57794535,1.7335515,-0.57794535,-0.57794535,-0.57794535,1.7309097,-0.57794535,-0.57794535,-0.57794535,1.7317741,-0.57794535,-0.57794535,-0.57794535,1.7322306,-0.57794535,-0.57794535,-0.57794535,1.7342411,-0.57794535,-0.57794535,-0.57794535,1.731473,-0.57794535,-0.57794535,-0.57794535,1.7327745,-0.57794535,-0.57794535,-0.57794535,1.7308514,-0.57794535,-0.57794535,-0.57794535,1.7328813,-0.57794535,-0.57794535,-0.57794535,1.7328231,-0.57794535,-0.57794535,-0.57794535,1.735125,-0.57794535,-0.57794535,-0.57794535,1.733503,-0.57794535,-0.57794535,-0.57794535,1.7319101,-0.57794535,-0.57794535,-0.57794535,1.7327259,-0.57794535,-0.57794535,-0.57794535,1.7325414,-0.57794535,-0.57794535,-0.57794535,1.7330659,-0.57794535,-0.57794535,-0.57794535,1.7324346,-0.57794535,-0.57794535,-0.57794535,1.7291808,-0.57794535,-0.57794535,-0.57794535,1.7312885,-0.57794535,-0.57794535,-0.57794535,1.7327842,-0.57794535,-0.57794535,-0.57794535,1.7340857,-0.57794535,-0.57794535,-0.57794535,1.7328328,-0.57794535,-0.57794535,-0.57794535,1.7351639,-0.57794535,-0.57794535,-0.57794535,1.7343286,-0.57794535,-0.57794535,-0.57794535,1.7352124,-0.57794535,-0.57794535,-0.57794535,1.7362225,-0.57794535,-0.57794535,-0.57794535,1.7365042,-0.57794535,-0.57794535,-0.57794535,1.7353484,-0.57794535,-0.57794535,-0.57794535,1.734484,-0.57794535,-0.57794535,-0.57794535,1.7350473,-0.57794535,-0.57794535,-0.57794535,1.7337166,-0.57794535,-0.57794535,-0.57794535,1.7336972,-0.57794535,-0.57794535,-0.57794535,1.7346491,-0.57794535,-0.57794535,-0.57794535,1.7344937,-0.57794535,-0.57794535,-0.57794535,1.7355329,-0.57794535,-0.57794535,-0.57794535,1.7357466,-0.57794535,-0.57794535,-0.57794535,1.7367276,-0.57794535,-0.57794535,-0.57794535,1.7334835,-0.57794535,-0.57794535,-0.57794535,1.7350667,-0.57794535,-0.57794535,-0.57794535,1.7363682,-0.57794535,-0.57794535,-0.57794535,1.7338818,-0.57794535,-0.57794535,-0.57794535,1.7352513,-0.57794535,-0.57794535,-0.57794535,1.7332407,-0.57794535,-0.57794535,-0.57794535,1.733231,-0.57794535,-0.57794535,-0.57794535,1.7329008,-0.57794535,-0.57794535,-0.57794535,1.7304629,-0.57794535,-0.57794535,-0.57794535,1.7320849,-0.57794535,-0.57794535,-0.57794535,1.7316187,-0.57794535,-0.57794535,-0.57794535,1.731609,-0.57794535,-0.57794535,-0.57794535,1.731269,-0.57794535,-0.57794535,-0.57794535,1.7290157,-0.57794535,-0.57794535,-0.57794535,1.7301423,-0.57794535,-0.57794535,-0.57794535,1.7344742,-0.57794535,-0.57794535,-0.57794535,1.7325123,-0.57794535,-0.57794535,-0.57794535,1.7321723,-0.57794535,-0.57794535,-0.57794535,1.7320363,-0.57794535,-0.57794535,-0.57794535,1.7324248,-0.57794535,-0.57794535,-0.57794535,1.7303366,-0.57794535,-0.57794535,-0.57794535,1.7310165,-0.57794535,-0.57794535,-0.57794535,1.7300744,-0.57794535,-0.57794535,-0.57794535,1.7295887,-0.57794535,-0.57794535,-0.57794535,1.7300355,-0.57794535,-0.57794535,-0.57794535,1.7302686,-0.57794535,-0.57794535,-0.57794535,1.7303172,-0.57794535,-0.57794535,-0.57794535,1.7307154,-0.57794535,-0.58095631,-0.54878757,1.729715,-0.57773167,-0.58095631,-0.54878757,1.7320072,-0.57773167,-0.58095631,-0.54778716,1.7292682,-0.57772196,-0.58095631,-0.54778716,1.7297733,-0.57772196,-0.58095631,-0.54778716,1.7298801,-0.57773167,-0.58095631,-0.54878757,1.7312107,-0.57773167,-0.58095631,-0.54878757,1.7309679,-0.57774138,-0.58095631,-0.5497977,1.7310068,-0.57774138,-0.58095631,-0.5497977,1.7323374,-0.57775109,-0.58095631,-0.5497977,1.7337555,-0.57775109,-0.58095631,-0.5497977,1.7324151,-0.57775109,-0.58095631,-0.5497977,1.730492,-0.57775109,-0.58095631,-0.5497977,1.7312107,-0.57775109,-0.58095631,-0.5497977,1.7334738,-0.57775109,-0.58095631,-0.5497977,1.7355329,-0.57775109,-0.58095631,-0.5497977,1.7332116,-0.57775109,-0.58095631,-0.5497977,1.7343383,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109,-0.58095631,-0.5497977,1.7347268,-0.57775109:9
-0.58892545,-0.53808757,1.7357183,-0.58871607,-0.58996234,-0.52355107,1.7356186,-0.58864628,-0.58892545,-0.52459794,1.7358878,-0.58865625,-0.58996234,-0.52459794,1.7372238,-0.58865625,-0.58892545,-0.52459794,1.7339237,-0.58865625,-0.58892545,-0.52355107,1.7342028,-0.58864628,-0.58892545,-0.52459794,1.7346914,-0.58865625,-0.58996234,-0.52459794,1.7310124,-0.58865625,-0.58996234,-0.52459794,1.7355986,-0.58865625,-0.58892545,-0.52459794,1.7353295,-0.58865625,-0.58892545,-0.52459794,1.7355787,-0.58865625,-0.58892545,-0.52459794,1.7347512,-0.58865625,-0.58892545,-0.52459794,1.7355887,-0.58865625,-0.58892545,-0.52459794,1.7349107,-0.58865625,-0.58892545,-0.52459794,1.73514,-0.58865625,-0.58892545,-0.52459794,1.7356286,-0.58865625,-0.58996234,-0.54016137,1.7341131,-0.58871607,-0.58892545,-0.52459794,1.732817,-0.58865625,-0.58892545,-0.52459794,1.7339436,-0.58865625,-0.58892545,-0.52459794,1.7333254,-0.58865625,-0.58892545,-0.52563484,1.7353195,-0.58865625,-0.58892545,-0.52563484,1.7334551,-0.58865625,-0.58892545,-0.52563484,1.7329167,-0.58865625,-0.58892545,-0.52563484,1.732488,-0.58865625,-0.58892545,-0.52563484,1.7331958,-0.58865625,-0.58892545,-0.52563484,1.7358379,-0.58865625,-0.58892545,-0.52563484,1.7348908,-0.58865625,-0.58892545,-0.52563484,1.7361969,-0.58865625,-0.58892545,-0.52563484,1.7356684,-0.58865625,-0.58892545,-0.52563484,1.7362866,-0.58865625,-0.58892545,-0.52563484,1.7359376,-0.58865625,-0.58892545,-0.52563484,1.7353992,-0.58865625,-0.58892545,-0.52459794,1.7349506,-0.58865625,-0.58892545,-0.52459794,1.7332557,-0.58865625,-0.58892545,-0.52563484,1.7332457,-0.58865625,-0.58892545,-0.53393001,1.7336644,-0.58865625,-0.58892545,-0.52667173,1.7338838,-0.58865625,-0.58892545,-0.52667173,1.7326774,-0.58866622,-0.58892545,-0.52770863,1.7327472,-0.58866622,-0.58892545,-0.52770863,1.7320393,-0.58866622,-0.58892545,-0.52770863,1.7325677,-0.58866622,-0.58892545,-0.553651,1.7271041,-0.58866622,-0.58892545,-0.52770863,1.7307033,-0.58866622,-0.58892545,-0.52874553,1.7301749,-0.58867619,-0.58892545,-0.52874553,1.728789,-0.58867619,-0.58892545,-0.52874553,1.7295767,-0.58867619,-0.58892545,-0.52978243,1.7285298,-0.58867619,-0.58892545,-0.52978243,1.7297262,-0.58867619,-0.58892545,-0.53081932,1.7284401,-0.58867619,-0.58892545,-0.53081932,1.7310223,-0.58867619,-0.58892545,-0.53081932,1.7310423,-0.58867619,-0.58892545,-0.53185622,1.730474,-0.58868616,-0.58892545,-0.53185622,1.7308429,-0.58868616,-0.58892545,-0.53185622,1.7312317,-0.58868616,-0.58892545,-0.53289312,1.7313514,-0.58868616,-0.58892545,-0.53289312,1.7305837,-0.58868616,-0.58892545,-0.53393001,1.7325677,-0.58869613,-0.58892545,-0.53393001,1.7336046,-0.58869613,-0.58892545,-0.53393001,1.734143,-0.58869613,-0.58892545,-0.53393001,1.7345617,-0.58869613,-0.58892545,-0.53496691,1.7321191,-0.58869613,-0.58788855,-0.53496691,1.7347213,-0.58869613,-0.58892545,-0.53393001,1.7372936,-0.58869613,-0.58892545,-0.53496691,1.7380912,-0.58869613,-0.58892545,-0.53496691,1.7358778,-0.58869613,-0.58788855,-0.53496691,1.7368649,-0.58869613,-0.58892545,-0.53600381,1.7345219,-0.5887061,-0.58788855,-0.53600381,1.7346714,-0.5887061,-0.58892545,-0.53600381,1.7244321,-0.5887061,-0.58788855,-0.53705068,1.7275727,-0.5887061,-0.58788855,-0.53705068,1.7314511,-0.5887061,-0.58892545,-0.53600381,1.7169046,-0.5887061,-0.58788855,-0.53705068,1.7290084,-0.5887061,-0.58788855,-0.53705068,1.7123981,-0.5887061,-0.58788855,-0.53808757,1.7309625,-0.58871607,-0.58788855,-0.53808757,1.7301549,-0.58871607,-0.58788855,-0.53808757,1.7299157,-0.58871607,-0.58788855,-0.57855647,1.7303344,-0.58888556,-0.58788855,-0.53808757,1.7306834,-0.58871607,-0.58788855,-0.53912447,1.7263663,-0.58871607,-0.58788855,-0.54016137,1.7294869,-0.58871607,-0.58788855,-0.54016137,1.7313115,-0.58871607,-0.58788855,-0.54016137,1.7317003,-0.58871607,-0.58788855,-0.54016137,1.7280313,-0.58871607,-0.58788855,-0.54016137,1.7321191,-0.58871607,-0.58788855,-0.54016137,1.7278219,-0.58871607,-0.58788855,-0.54119826,1.7254889,-0.58872604,-0.58788855,-0.54119826,1.7279515,-0.58872604,-0.58788855,-0.54223516,1.7279416,-0.58872604,-0.58685165,-0.54223516,1.7265557,-0.58872604,-0.58788855,-0.54223516,1.7276026,-0.58872604,-0.58788855,-0.54223516,1.728121,-0.58872604,-0.58788855,-0.54327206,1.7290283,-0.58873601,-0.58685165,-0.54327206,1.7293972,-0.58873601,-0.58685165,-0.54327206,1.7206434,-0.58873601,-0.58685165,-0.54327206,1.7284301,-0.58873601,-0.58788855,-0.53912447,1.7303843,-0.58871607,-0.58685165,-0.54430896,1.7292975,-0.58873601,-0.58685165,-0.54430896,1.7307631,-0.58873601,-0.58685165,-0.54430896,1.72846,-0.58873601,-0.58685165,-0.54430896,1.7295468,-0.58873601,-0.58788855,-0.54223516,1.7300353,-0.58872604,-0.58685165,-0.54430896,1.7305737,-0.58873601,-0.58685165,-0.54534585,1.728799,-0.58874598,-0.58685165,-0.54534585,1.7329266,-0.58874598,-0.58685165,-0.54638275,1.7319695,-0.58874598,-0.58892545,-0.53185622,1.7326176,-0.58868616,-0.58685165,-0.54638275,1.7320293,-0.58874598,-0.58685165,-0.55987238,1.7308429,-0.5888058,-0.58685165,-0.54638275,1.7323384,-0.58874598,-0.58685165,-0.54638275,1.7315109,-0.58874598,-0.58685165,-0.54741965,1.7333055,-0.58875595,-0.58685165,-0.54741965,1.732488,-0.58875595,-0.58685165,-0.54741965,1.7322886,-0.58875595,-0.58685165,-0.54845654,1.7324182,-0.58875595,-0.58685165,-0.54741965,1.7227272,-0.58874598,-0.58685165,-0.54845654,1.7310921,-0.58875595,-0.58685165,-0.54845654,1.7302048,-0.58875595,-0.58685165,-0.54845654,1.7289984,-0.58875595,-0.58685165,-0.54949344,1.7276524,-0.58875595,-0.58685165,-0.54949344,1.7306834,-0.58875595,-0.58685165,-0.54949344,1.7308229,-0.58875595,-0.58685165,-0.54949344,1.7300851,-0.58875595,-0.58685165,-0.54949344,1.7260173,-0.58875595,-0.58685165,-0.55054031,1.7267751,-0.58876592,-0.58685165,-0.55054031,1.7278518,-0.58876592,-0.58685165,-0.55054031,1.7260073,-0.58876592,-0.58685165,-0.55054031,1.7268847,-0.58876592,-0.58685165,-0.55054031,1.7289087,-0.58876592,-0.58685165,-0.55054031,1.7277521,-0.58876592,-0.58685165,-0.54430896,1.7261569,-0.58873601,-0.58788855,-0.54534585,1.7234849,-0.58874598,-0.58788855,-0.54534585,1.7268648,-0.58874598,-0.58685165,-0.56817753,1.7259176,-0.58884568,-0.58685165,-0.5526141,1.7276724,-0.58877589,-0.58685165,-0.5526141,1.7274331,-0.58877589,-0.58685165,-0.5526141,1.7206733,-0.58877589,-0.58685165,-0.5526141,1.7288688,-0.58877589,-0.58685165,-0.5526141,1.7267751,-0.58877589,-0.58685165,-0.5526141,1.7260771,-0.58877589,-0.58685165,-0.5526141,1.7278917,-0.58877589,-0.58685165,-0.553651,1.7279116,-0.58877589,-0.58685165,-0.553651,1.7270442,-0.58877589,-0.58685165,-0.553651,1.7293573,-0.58877589,-0.58685165,-0.553651,1.7298259,-0.58877589,-0.58685165,-0.553651,1.7305039,-0.58877589,-0.58685165,-0.553651,1.7296365,-0.58877589,-0.58685165,-0.5546879,1.7241828,-0.58878586,-0.58685165,-0.5546879,1.7270941,-0.58878586,-0.58788855,-0.54016137,1.7266255,-0.58871607,-0.58685165,-0.5526141,1.727473,-0.58877589,-0.58685165,-0.5546879,1.7269645,-0.58878586,-0.58685165,-0.5557248,1.7257182,-0.58878586,-0.58685165,-0.5557248,1.7257481,-0.58878586,-0.58581475,-0.5557248,1.7194769,-0.58878586,-0.58581475,-0.5557248,1.7263563,-0.58878586,-0.58581475,-0.5557248,1.7259575,-0.58878586,-0.58685165,-0.55676169,1.7262865,-0.58879583,-0.58581475,-0.55676169,1.7281011,-0.58879583,-0.58581475,-0.55676169,1.7221987,-0.58879583,-0.58581475,-0.55676169,1.7184998,-0.58879583,-0.58581475,-0.55779859,1.7291479,-0.58879583,-0.58581475,-0.55676169,1.7289087,-0.58879583,-0.58581475,-0.55779859,1.7258379,-0.58879583,-0.58788855,-0.57855647,1.7246016,-0.58888556,-0.58685165,-0.55676169,1.7257581,-0.58879583,-0.58581475,-0.55779859,1.723435,-0.58879583,-0.58581475,-0.55779859,1.7237341,-0.58879583,-0.58685165,-0.55779859,1.722099,-0.58879583,-0.58581475,-0.55883549,1.7153492,-0.58879583,-0.58581475,-0.55883549,1.7239535,-0.58879583,-0.58581475,-0.55883549,1.7231359,-0.58879583,-0.58581475,-0.55883549,1.7231459,-0.58879583,-0.58581475,-0.55883549,1.7232955,-0.58879583,-0.58685165,-0.55987238,1.7216005,-0.5888058,-0.58581475,-0.55883549,1.7220093,-0.58879583,-0.58581475,-0.55883549,1.7208029,-0.58879583,-0.58581475,-0.55883549,1.7212117,-0.58879583,-0.58581475,-0.55987238,1.717782,-0.5888058,-0.58685165,-0.55987238,1.7184101,-0.5888058,-0.58581475,-0.55987238,1.7230761,-0.5888058,-0.58581475,-0.55779859,1.7249904,-0.58879583,-0.58581475,-0.56090928,1.7260672,-0.5888058,-0.58581475,-0.56090928,1.725469,-0.5888058,-0.58581475,-0.55987238,1.7258279,-0.5888058,-0.58581475,-0.56090928,1.7270742,-0.5888058,-0.58581475,-0.56090928,1.7267651,-0.5888058,-0.58581475,-0.56090928,1.7265158,-0.5888058,-0.58581475,-0.56090928,1.7269047,-0.5888058,-0.58685165,-0.56610374,1.7257082,-0.58883571,-0.58685165,-0.56090928,1.7264261,-0.5888058,-0.58581475,-0.56194618,1.7272237,-0.58881577,-0.58581475,-0.56194618,1.7251998,-0.58881577,-0.58581475,-0.56194618,1.7265557,-0.58881577,-0.58581475,-0.56194618,1.727782,-0.58881577,-0.58581475,-0.56194618,1.7272935,-0.58881577,-0.58581475,-0.56299305,1.7280313,-0.58881577,-0.58581475,-0.56194618,1.7257282,-0.58881577,-0.58581475,-0.56194618,1.7260871,-0.58881577,-0.58581475,-0.56299305,1.7148806,-0.58881577,-0.58581475,-0.56299305,1.7223483,-0.58881577,-0.58581475,-0.56194618,1.7216504,-0.58881577,-0.58581475,-0.56299305,1.7230861,-0.58881577,-0.58581475,-0.56299305,1.7233952,-0.58881577,-0.58581475,-0.56299305,1.7223483,-0.58881577,-0.58581475,-0.56299305,1.7235447,-0.58881577,-0.58581475,-0.56299305,1.7234151,-0.58881577,-0.58581475,-0.56402994,1.7243523,-0.58882574,-0.58685165,-0.56921443,1.7238139,-0.58884568,-0.58581475,-0.56299305,1.7242027,-0.58881577,-0.58581475,-0.56402994,1.7250203,-0.58882574,-0.58581475,-0.56402994,1.7250901,-0.58882574,-0.58685165,-0.56402994,1.7248807,-0.58882574,-0.58581475,-0.56402994,1.7273633,-0.58882574,-0.58685165,-0.56506684,1.7273334,-0.58882574,-0.58581475,-0.56506684,1.7278618,-0.58882574,-0.58581475,-0.56506684,1.7282706,-0.58882574,-0.58581475,-0.56506684,1.7282606,-0.58882574,-0.58581475,-0.56506684,1.7287192,-0.58882574,-0.58685165,-0.56610374,1.7271539,-0.58883571,-0.58685165,-0.56506684,1.7277023,-0.58882574,-0.58685165,-0.56506684,1.7296963,-0.58882574,-0.58581475,-0.56610374,1.7308329,-0.58883571,-0.58581475,-0.56506684,1.7295567,-0.58882574,-0.58685165,-0.56610374,1.7289485,-0.58883571,-0.58581475,-0.56610374,1.7302048,-0.58883571,-0.58581475,-0.56610374,1.7304042,-0.58883571,-0.58581475,-0.56610374,1.7301948,-0.58883571,-0.58685165,-0.56610374,1.7283204,-0.58883571,-0.58685165,-0.56714063,1.7195267,-0.58883571,-0.58685165,-0.56714063,1.7286395,-0.58883571,-0.58685165,-0.56610374,1.7274131,-0.58883571,-0.58685165,-0.56610374,1.7252895,-0.58883571,-0.58581475,-0.56610374,1.7282108,-0.58883571,-0.58685165,-0.56714063,1.7259675,-0.58883571,-0.58581475,-0.56714063,1.7252895,-0.58883571,-0.58581475,-0.56714063,1.7258379,-0.58883571,-0.58581475,-0.56714063,1.7263463,-0.58883571,-0.58685165,-0.56714063,1.7259874,-0.58883571,-0.58581475,-0.56714063,1.7250602,-0.58883571,-0.58685165,-0.55987238,1.7270542,-0.5888058,-0.58581475,-0.56817753,1.7268548,-0.58883571,-0.58685165,-0.56610374,1.7263663,-0.58883571,-0.58685165,-0.56817753,1.7242825,-0.58884568,-0.58581475,-0.56817753,1.7245716,-0.58883571,-0.58581475,-0.56817753,1.7244321,-0.58883571,-0.58685165,-0.56817753,1.723126,-0.58883571,-0.58685165,-0.56817753,1.7251699,-0.58884568,-0.58685165,-0.56817753,1.7239336,-0.58883571,-0.58685165,-0.56817753,1.7226973,-0.58883571,-0.58685165,-0.56817753,1.7253693,-0.58884568,-0.58685165,-0.56817753,1.7273134,-0.58884568,-0.58581475,-0.56817753,1.7274131,-0.58883571,-0.58685165,-0.56817753,1.7250103,-0.58884568,-0.58685165,-0.56817753,1.7270642,-0.58884568,-0.58685165,-0.56817753,1.7266753,-0.58884568,-0.58685165,-0.56817753,1.7262566,-0.58884568,-0.58685165,-0.56921443,1.7265258,-0.58884568,-0.58685165,-0.56921443,1.7249904,-0.58884568,-0.58685165,-0.56921443,1.72179,-0.58884568,-0.58685165,-0.56921443,1.7217501,-0.58884568,-0.58685165,-0.56921443,1.7237541,-0.58884568,-0.58685165,-0.56921443,1.7206633,-0.58884568,-0.58685165,-0.56921443,1.7219395,-0.58884568,-0.58685165,-0.56921443,1.7222187,-0.58884568,-0.58685165,-0.56921443,1.724462,-0.58884568,-0.58685165,-0.56921443,1.7285896,-0.58884568,-0.58685165,-0.57025133,1.7345418,-0.58884568,-0.58581475,-0.57025133,1.7370344,-0.58884568,-0.58685165,-0.57025133,1.7354092,-0.58884568,-0.58685165,-0.57025133,1.7357881,-0.58884568,-0.58685165,-0.57025133,1.7373634,-0.58884568,-0.58685165,-0.57025133,1.7375727,-0.58884568,-0.58685165,-0.56921443,1.738141,-0.58884568,-0.58685165,-0.57025133,1.7403444,-0.58884568,-0.58685165,-0.57025133,1.7403444,-0.58884568,-0.58685165,-0.57025133,1.7386695,-0.58884568,-0.58685165,-0.57128822,1.7434153,-0.58885565,-0.58685165,-0.57025133,1.7430962,-0.58884568,-0.58685165,-0.57128822,1.7402348,-0.58885565,-0.58685165,-0.57128822,1.7447313,-0.58885565,-0.58685165,-0.57128822,1.7457682,-0.58885565,-0.58685165,-0.57128822,1.7440833,-0.58885565,-0.58685165,-0.57128822,1.7442428,-0.58885565,-0.58685165,-0.57128822,1.742169,-0.58885565,-0.58685165,-0.56714063,1.7427473,-0.58883571,-0.58685165,-0.56714063,1.744512,-0.58883571,-0.58581475,-0.56714063,1.7445219,-0.58883571,-0.58581475,-0.56817753,1.7417602,-0.58883571,-0.58685165,-0.57232512,1.7399058,-0.58885565,-0.58685165,-0.58166717,1.7410723,-0.58889554,-0.58685165,-0.57232512,1.7388489,-0.58885565,-0.58685165,-0.57232512,1.7403345,-0.58885565,-0.58685165,-0.57232512,1.7400653,-0.58885565,-0.58685165,-0.57232512,1.7401849,-0.58885565,-0.58685165,-0.57232512,1.7413116,-0.58885565,-0.58685165,-0.57232512,1.7392876,-0.58885565,-0.58685165,-0.57232512,1.7397263,-0.58885565,-0.58685165,-0.57232512,1.7414212,-0.58885565,-0.58685165,-0.57232512,1.7394671,-0.58885565,-0.58685165,-0.57336202,1.7421291,-0.58886562,-0.58685165,-0.57336202,1.7430364,-0.58886562,-0.58685165,-0.57336202,1.7439138,-0.58886562,-0.58685165,-0.57336202,1.7426575,-0.58886562,-0.58685165,-0.57336202,1.7440533,-0.58886562,-0.58685165,-0.57232512,1.7426874,-0.58885565,-0.58685165,-0.57336202,1.7464562,-0.58886562,-0.58685165,-0.57336202,1.7455688,-0.58886562,-0.58685165,-0.57336202,1.7452298,-0.58886562,-0.58685165,-0.58166717,1.7444621,-0.58889554,-0.58685165,-0.57336202,1.7431361,-0.58886562,-0.58685165,-0.57336202,1.7421391,-0.58886562,-0.58685165,-0.57336202,1.7420194,-0.58886562,-0.58685165,-0.57336202,1.7436944,-0.58886562,-0.58685165,-0.57336202,1.7444123,-0.58886562,-0.58685165,-0.57336202,1.7457582,-0.58886562,-0.58685165,-0.57336202,1.7449108,-0.58886562,-0.58685165,-0.57336202,1.7431859,-0.58886562,-0.58685165,-0.57336202,1.7418499,-0.58886562,-0.58685165,-0.57336202,1.73848,-0.58886562,-0.58685165,-0.57336202,1.7409427,-0.58886562,-0.58685165,-0.57439891,1.7415409,-0.58886562,-0.58685165,-0.57336202,1.7413714,-0.58886562,-0.58685165,-0.57336202,1.7410723,-0.58886562,-0.58685165,-0.57439891,1.7408828,-0.58886562,-0.58685165,-0.57439891,1.7407333,-0.58886562,-0.58685165,-0.57439891,1.7410523,-0.58886562,-0.58685165,-0.57336202,1.7417104,-0.58886562,-0.58685165,-0.57439891,1.744821,-0.58886562,-0.58685165,-0.57439891,1.7444023,-0.58886562,-0.58685165,-0.57439891,1.7431361,-0.58886562,-0.58685165,-0.57439891,1.7406535,-0.58886562,-0.58685165,-0.57439891,1.7384401,-0.58886562,-0.58685165,-0.57439891,1.7394272,-0.58886562,-0.58788855,-0.57855647,1.7389686,-0.58888556,-0.58685165,-0.57439891,1.7385598,-0.58886562,-0.58685165,-0.57543581,1.7416804,-0.58887559,-0.58685165,-0.57543581,1.740165,-0.58887559,-0.58685165,-0.57439891,1.7395668,-0.58886562,-0.58685165,-0.57543581,1.7368748,-0.58887559,-0.58685165,-0.57543581,1.7348309,-0.58887559,-0.58685165,-0.57543581,1.7368848,-0.58887559,-0.58685165,-0.57543581,1.7406535,-0.58887559,-0.58685165,-0.57543581,1.741491,-0.58887559,-0.58685165,-0.57543581,1.7419297,-0.58887559,-0.58685165,-0.57543581,1.7396166,-0.58887559,-0.58685165,-0.57543581,1.7402747,-0.58887559,-0.58685165,-0.57543581,1.7392477,-0.58887559,-0.58685165,-0.57543581,1.7393175,-0.58887559,-0.58685165,-0.57543581,1.7410523,-0.58887559,-0.58685165,-0.57543581,1.7426077,-0.58887559,-0.58685165,-0.57543581,1.7419098,-0.58887559,-0.58685165,-0.57543581,1.7419496,-0.58887559,-0.58685165,-0.57543581,1.7422487,-0.58887559,-0.58685165,-0.57543581,1.7445917,-0.58887559,-0.58685165,-0.57543581,1.7427772,-0.58887559,-0.58685165,-0.57543581,1.7436944,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559,-0.58685165,-0.57648268,1.7436645,-0.58887559:9
-0.59663319,-0.53218799,1.7180674,-0.59211679,-0.59663319,-0.53218799,1.7152409,-0.59211679,-0.59560539,-0.53218799,1.7197771,-0.59211679,-0.59560539,-0.53218799,1.7195201,-0.59212667,-0.59560539,-0.53218799,1.7199747,-0.59211679,-0.59663319,-0.53116019,1.7190853,-0.59211679,-0.59560539,-0.53218799,1.7182452,-0.59211679,-0.59663319,-0.53218799,1.7208444,-0.59211679,-0.59560539,-0.53218799,1.7201328,-0.59211679,-0.59663319,-0.53218799,1.717425,-0.59211679,-0.59663319,-0.53218799,1.7161106,-0.59211679,-0.59663319,-0.53218799,1.7211903,-0.59211679,-0.59663319,-0.53218799,1.7210223,-0.59211679,-0.59663319,-0.53218799,1.7259636,-0.59210691,-0.59663319,-0.53218799,1.7338599,-0.59210691,-0.59663319,-0.53218799,1.7328816,-0.59210691,-0.59663319,-0.53218799,1.7317846,-0.59210691,-0.59663319,-0.53218799,1.7318043,-0.59210691,-0.59663319,-0.53218799,1.7317549,-0.59211679,-0.59663319,-0.53116019,1.7344826,-0.59210691,-0.59663319,-0.53116019,1.7337413,-0.59210691,-0.59663319,-0.53218799,1.7328519,-0.59211679,-0.59560539,-0.53218799,1.7300749,-0.59212667,-0.59560539,-0.53218799,1.7334152,-0.59211679,-0.59560539,-0.53218799,1.7311521,-0.59211679,-0.59663319,-0.53218799,1.732506,-0.59211679,-0.59663319,-0.53116019,1.7320514,-0.59211679,-0.59663319,-0.53218799,1.7319328,-0.59211679,-0.59663319,-0.53218799,1.7328816,-0.59211679,-0.59560539,-0.53218799,1.7324368,-0.59211679,-0.59663319,-0.53218799,1.7313497,-0.59210691,-0.59560539,-0.53218799,1.7307172,-0.59211679,-0.59663319,-0.53218799,1.7304603,-0.59211679,-0.59663319,-0.53218799,1.7248765,-0.59211679,-0.59663319,-0.53218799,1.7271693,-0.59211679,-0.59560539,-0.53218799,1.7303318,-0.59211679,-0.59560539,-0.53218799,1.7328914,-0.59211679,-0.59560539,-0.53218799,1.7316561,-0.59211679,-0.59560539,-0.53218799,1.7321305,-0.59211679,-0.59560539,-0.53218799,1.7310038,-0.59211679,-0.59663319,-0.53218799,1.7312311,-0.59211679,-0.59663319,-0.53218799,1.7308655,-0.59211679,-0.59663319,-0.53218799,1.7303911,-0.59210691,-0.59663319,-0.53218799,1.7305986,-0.59210691,-0.59663319,-0.53218799,1.7297883,-0.59210691,-0.59560539,-0.53218799,1.7305591,-0.59211679,-0.59663319,-0.53218799,1.7292052,-0.59210691,-0.59663319,-0.53218799,1.7297784,-0.59210691,-0.59663319,-0.53218799,1.731498,-0.59210691,-0.59663319,-0.53218799,1.7285332,-0.59211679,-0.59560539,-0.53218799,1.728464,-0.59210691,-0.59560539,-0.53218799,1.728296,-0.59211679,-0.59663319,-0.53218799,1.7282762,-0.59210691,-0.59663319,-0.53116019,1.7286122,-0.59211679,-0.59560539,-0.53116019,1.7302923,-0.59210691,-0.59560539,-0.53218799,1.729472,-0.59211679,-0.59663319,-0.53218799,1.7282663,-0.59211679,-0.59560539,-0.53218799,1.7297685,-0.59211679,-0.59560539,-0.53218799,1.7297586,-0.59210691,-0.59560539,-0.53218799,1.7294127,-0.59211679,-0.59560539,-0.53218799,1.726438,-0.59211679,-0.59560539,-0.53218799,1.7292744,-0.59211679,-0.59560539,-0.53218799,1.7312904,-0.59210691,-0.59663319,-0.53218799,1.7305295,-0.59210691,-0.59560539,-0.53218799,1.7294028,-0.59211679,-0.59663319,-0.53218799,1.7296005,-0.59211679,-0.59560539,-0.53218799,1.7244812,-0.59211679,-0.59560539,-0.53218799,1.7245998,-0.59210691,-0.59663319,-0.53218799,1.7237796,-0.59210691,-0.59560539,-0.53218799,1.723997,-0.59210691,-0.59663319,-0.53218799,1.7314881,-0.59210691,-0.59663319,-0.53218799,1.7273077,-0.59210691,-0.59560539,-0.53116019,1.7275745,-0.59211679,-0.59560539,-0.53218799,1.7275745,-0.59211679,-0.59663319,-0.53218799,1.725598,-0.59211679,-0.59560539,-0.53218799,1.7278117,-0.59211679,-0.59560539,-0.53218799,1.72374,-0.59211679,-0.59560539,-0.53218799,1.7266851,-0.59212667,-0.59560539,-0.53218799,1.730065,-0.59211679,-0.59560539,-0.53218799,1.7271199,-0.59211679,-0.59663319,-0.53218799,1.7294819,-0.59211679,-0.59663319,-0.53218799,1.7259933,-0.59211679,-0.59663319,-0.53218799,1.7265764,-0.59211679,-0.59560539,-0.53218799,1.7281378,-0.59211679,-0.59560539,-0.53218799,1.727278,-0.59211679,-0.59663319,-0.53218799,1.7283454,-0.59211679,-0.59560539,-0.53218799,1.727199,-0.59211679,-0.59663319,-0.53218799,1.7270606,-0.59211679,-0.59663319,-0.53218799,1.7301638,-0.59211679,-0.59560539,-0.53218799,1.7282663,-0.59211679,-0.59663319,-0.53218799,1.7289087,-0.59211679,-0.59560539,-0.53218799,1.7248667,-0.59210691,-0.59663319,-0.53218799,1.7262997,-0.59211679,-0.59663319,-0.53218799,1.7278216,-0.59210691,-0.59663319,-0.53218799,1.7251631,-0.59211679,-0.59663319,-0.53218799,1.7261811,-0.59210691,-0.59560539,-0.53218799,1.7272385,-0.59211679,-0.59663319,-0.53218799,1.7272978,-0.59210691,-0.59663319,-0.53218799,1.7265171,-0.59210691,-0.59663319,-0.53218799,1.7306481,-0.59210691,-0.59663319,-0.53218799,1.7304603,-0.59210691,-0.59663319,-0.53218799,1.7308754,-0.59210691,-0.59663319,-0.53218799,1.7297487,-0.59210691,-0.59663319,-0.53218799,1.7303812,-0.59210691,-0.59663319,-0.53218799,1.7292546,-0.59210691,-0.59663319,-0.53218799,1.7281181,-0.59210691,-0.59663319,-0.53116019,1.728128,-0.59210691,-0.59663319,-0.53218799,1.7280193,-0.59210691,-0.59663319,-0.53218799,1.732595,-0.59210691,-0.59663319,-0.53218799,1.7324862,-0.59210691,-0.59663319,-0.53218799,1.7316561,-0.59210691,-0.59663319,-0.53218799,1.7334449,-0.59210691,-0.59663319,-0.53218799,1.7323676,-0.59210691,-0.59663319,-0.53218799,1.7321206,-0.59210691,-0.59663319,-0.53218799,1.7328816,-0.59209703,-0.59663319,-0.53218799,1.7364887,-0.59209703,-0.59663319,-0.53218799,1.732595,-0.59209703,-0.59663319,-0.53218799,1.7309248,-0.59210691,-0.59663319,-0.53218799,1.728296,-0.59211679,-0.59663319,-0.53218799,1.7299661,-0.59209703,-0.59663319,-0.53218799,1.7298673,-0.59209703,-0.59663319,-0.53218799,1.729393,-0.59210691,-0.59663319,-0.53218799,1.7278414,-0.59210691,-0.59663319,-0.53218799,1.7304306,-0.59211679,-0.59663319,-0.53218799,1.7291854,-0.59210691,-0.59663319,-0.53218799,1.7309248,-0.59210691,-0.59663319,-0.53218799,1.729897,-0.59211679,-0.59560539,-0.53218799,1.7291755,-0.59211679,-0.59663319,-0.53218799,1.7296993,-0.59211679,-0.59560539,-0.53218799,1.7260427,-0.59211679,-0.59663319,-0.53218799,1.7260032,-0.59210691,-0.59663319,-0.53218799,1.7229395,-0.59211679,-0.59663319,-0.53218799,1.7251335,-0.59210691,-0.59663319,-0.53218799,1.7275646,-0.59211679,-0.59663319,-0.53218799,1.7281378,-0.59211679,-0.59663319,-0.53218799,1.7271693,-0.59210691,-0.59663319,-0.53218799,1.7256968,-0.59210691,-0.59663319,-0.53218799,1.7273868,-0.59211679,-0.59663319,-0.53218799,1.7291656,-0.59210691,-0.59663319,-0.53218799,1.7327234,-0.59210691,-0.59663319,-0.53218799,1.7281082,-0.59210691,-0.59663319,-0.53218799,1.7283651,-0.59210691,-0.59560539,-0.53218799,1.7304405,-0.59211679,-0.59663319,-0.53218799,1.7301144,-0.59210691,-0.59663319,-0.53218799,1.7276141,-0.59210691,-0.59663319,-0.53218799,1.7284047,-0.59210691,-0.59663319,-0.53218799,1.7279105,-0.59210691,-0.59663319,-0.53218799,1.7279501,-0.59210691,-0.59663319,-0.53218799,1.7281181,-0.59210691,-0.59663319,-0.53218799,1.7252027,-0.59210691,-0.59663319,-0.53218799,1.7277722,-0.59211679,-0.59663319,-0.53218799,1.7309643,-0.59210691,-0.59663319,-0.53218799,1.7261218,-0.59211679,-0.59663319,-0.53218799,1.7270705,-0.59210691,-0.59663319,-0.53218799,1.7265665,-0.59210691,-0.59663319,-0.53218799,1.7339192,-0.59210691,-0.59663319,-0.53218799,1.7353621,-0.59210691,-0.59663319,-0.53218799,1.7307666,-0.59210691,-0.59663319,-0.53218799,1.7344233,-0.59210691,-0.59663319,-0.53218799,1.7331978,-0.59210691,-0.59663319,-0.53218799,1.7335042,-0.59210691,-0.59663319,-0.53218799,1.7323084,-0.59210691,-0.59663319,-0.53218799,1.7306382,-0.59210691,-0.59663319,-0.53218799,1.733435,-0.59210691,-0.59560539,-0.53320591,1.7276239,-0.59211679,-0.59663319,-0.53218799,1.7329112,-0.59211679,-0.59663319,-0.53218799,1.7334844,-0.59210691,-0.59663319,-0.53320591,1.7307765,-0.59211679,-0.59663319,-0.53218799,1.7310236,-0.59210691,-0.59663319,-0.53320591,1.7271792,-0.59211679,-0.59663319,-0.53218799,1.7272385,-0.59210691,-0.59663319,-0.53218799,1.7283553,-0.59211679,-0.59663319,-0.53218799,1.7280884,-0.59211679,-0.59663319,-0.53218799,1.727535,-0.59211679,-0.59663319,-0.53320591,1.7275745,-0.59211679,-0.59663319,-0.53320591,1.7262898,-0.59211679,-0.59663319,-0.53320591,1.7259834,-0.59211679,-0.59663319,-0.53320591,1.7252126,-0.59211679,-0.59663319,-0.53320591,1.727871,-0.59211679,-0.59560539,-0.53320591,1.7281378,-0.59212667,-0.59560539,-0.53320591,1.7298574,-0.59211679,-0.59663319,-0.53320591,1.7288889,-0.59212667,-0.59663319,-0.53320591,1.7284047,-0.59212667,-0.59560539,-0.53320591,1.7292447,-0.59212667,-0.59560539,-0.53320591,1.7289581,-0.59212667,-0.59560539,-0.53320591,1.7307568,-0.59212667,-0.59560539,-0.53320591,1.7300254,-0.59212667,-0.59560539,-0.53320591,1.7289087,-0.59212667,-0.59560539,-0.53320591,1.7258549,-0.59212667,-0.59560539,-0.53423371,1.7303516,-0.59212667,-0.59560539,-0.53423371,1.7281378,-0.59213656,-0.59560539,-0.53423371,1.7271693,-0.59213656,-0.59560539,-0.53320591,1.7299661,-0.59211679,-0.59663319,-0.53218799,1.7288198,-0.59211679,-0.59560539,-0.53320591,1.7306678,-0.59212667,-0.59560539,-0.53320591,1.7293238,-0.59212667,-0.59560539,-0.53320591,1.7293633,-0.59212667,-0.59560539,-0.53320591,1.7254893,-0.59212667,-0.59560539,-0.53423371,1.7289087,-0.59213656,-0.59560539,-0.53423371,1.7286023,-0.59213656,-0.59560539,-0.53423371,1.727199,-0.59213656,-0.59560539,-0.53525163,1.7296697,-0.59213656,-0.59560539,-0.53525163,1.7313398,-0.59214644,-0.59560539,-0.53525163,1.7290965,-0.59214644,-0.59458747,-0.53627944,1.7304603,-0.59215632,-0.59560539,-0.53627944,1.7304109,-0.59215632,-0.59458747,-0.53627944,1.7321008,-0.59215632,-0.59560539,-0.53729735,1.7322688,-0.59215632,-0.59560539,-0.53729735,1.7301144,-0.59215632,-0.59458747,-0.53729735,1.7292546,-0.59216621,-0.59458747,-0.53729735,1.7288889,-0.59215632,-0.59458747,-0.53729735,1.7285332,-0.59215632,-0.59458747,-0.53729735,1.7310038,-0.59216621,-0.59458747,-0.53729735,1.7323578,-0.59216621,-0.59458747,-0.53832516,1.7301144,-0.59216621,-0.59458747,-0.53934308,1.7323182,-0.59217609,-0.59355967,-0.5424166,1.7324665,-0.59220574,-0.59355967,-0.54344441,1.7330199,-0.59220574,-0.59355967,-0.54344441,1.7351743,-0.59221562,-0.59355967,-0.54344441,1.7349965,-0.59221562,-0.59355967,-0.54446233,1.7357377,-0.59221562,-0.59355967,-0.54549013,1.7340378,-0.5922255,-0.59355967,-0.54549013,1.7355005,-0.5922255,-0.59355967,-0.54549013,1.7355697,-0.5922255,-0.59254175,-0.54650805,1.7349372,-0.5922255,-0.59254175,-0.54650805,1.7353127,-0.59223538,-0.59254175,-0.54753585,1.7340774,-0.59223538,-0.59254175,-0.54753585,1.7327135,-0.59223538,-0.59254175,-0.54855377,1.7320316,-0.59223538,-0.59254175,-0.54855377,1.733099,-0.59223538,-0.59254175,-0.54958157,1.7323281,-0.59224527,-0.59254175,-0.54958157,1.7331286,-0.59224527,-0.59254175,-0.54958157,1.7287308,-0.59224527,-0.59254175,-0.55059949,1.7338896,-0.59224527,-0.59458747,-0.54037088,1.7341268,-0.59218597,-0.59458747,-0.5413888,1.7322985,-0.59219585,-0.59355967,-0.54549013,1.7338698,-0.5922255,-0.59355967,-0.54549013,1.7354511,-0.5922255,-0.59355967,-0.54549013,1.7347691,-0.5922255,-0.59254175,-0.55264522,1.733267,-0.59225515,-0.59254175,-0.55264522,1.7268926,-0.59226503,-0.59254175,-0.55367302,1.7282268,-0.59225515,-0.59254175,-0.55367302,1.7306876,-0.59225515,-0.59254175,-0.55367302,1.7336326,-0.59226503,-0.59254175,-0.55469094,1.7338402,-0.59226503,-0.59254175,-0.55469094,1.7335635,-0.59226503,-0.59254175,-0.55571874,1.7335239,-0.59227491,-0.59254175,-0.55571874,1.7323578,-0.59226503,-0.59254175,-0.55571874,1.7344628,-0.59226503,-0.59254175,-0.55571874,1.7316956,-0.59226503,-0.59254175,-0.55571874,1.7293139,-0.59226503,-0.59254175,-0.55673666,1.7319229,-0.59226503,-0.59254175,-0.55673666,1.7326048,-0.59227491,-0.59254175,-0.55673666,1.731745,-0.59227491,-0.59254175,-0.55776446,1.7329705,-0.59227491,-0.59254175,-0.55776446,1.732763,-0.5922848,-0.59254175,-0.55776446,1.7330891,-0.5922848,-0.59254175,-0.55878238,1.7367951,-0.5922848,-0.59152383,-0.55878238,1.7350854,-0.5922848,-0.59254175,-0.55878238,1.7343738,-0.5922848,-0.59152383,-0.55878238,1.7343936,-0.5922848,-0.59152383,-0.55878238,1.7315276,-0.5922848,-0.59152383,-0.55981019,1.7342849,-0.59229468,-0.59152383,-0.55981019,1.7344924,-0.5922848,-0.59152383,-0.55981019,1.7330001,-0.5922848,-0.59152383,-0.55981019,1.7323182,-0.59229468,-0.59152383,-0.56082811,1.7330693,-0.59229468,-0.59152383,-0.56082811,1.7340181,-0.59229468,-0.59152383,-0.56082811,1.7333065,-0.59230456,-0.59152383,-0.56082811,1.7340576,-0.59230456,-0.59152383,-0.56185591,1.7332274,-0.59230456,-0.59152383,-0.56185591,1.7330496,-0.59230456,-0.59152383,-0.56185591,1.7311323,-0.59230456,-0.59152383,-0.56185591,1.7327827,-0.59230456,-0.59152383,-0.56287383,1.731073,-0.59230456,-0.59152383,-0.56287383,1.7273472,-0.59230456,-0.59152383,-0.56287383,1.7327926,-0.59231445,-0.59152383,-0.56287383,1.7327827,-0.59231445,-0.59152383,-0.56390163,1.7335239,-0.59231445,-0.59152383,-0.56390163,1.73301,-0.59231445,-0.59152383,-0.56390163,1.7334547,-0.59231445,-0.59152383,-0.56390163,1.7337809,-0.59231445,-0.59152383,-0.56390163,1.7333065,-0.59231445,-0.59152383,-0.56390163,1.7342256,-0.59232433,-0.59152383,-0.56491955,1.7343343,-0.59232433,-0.59152383,-0.56491955,1.7358365,-0.59232433,-0.59152383,-0.56491955,1.7355301,-0.59232433,-0.59152383,-0.56491955,1.7308457,-0.59232433,-0.59152383,-0.56491955,1.7296697,-0.59232433,-0.59152383,-0.56594735,1.7314683,-0.59232433,-0.59152383,-0.56594735,1.7284047,-0.59232433,-0.59152383,-0.56594735,1.7284541,-0.59232433,-0.59152383,-0.56594735,1.7310928,-0.59233421,-0.59152383,-0.56594735,1.7286221,-0.59233421,-0.59152383,-0.56594735,1.7285529,-0.59233421,-0.59152383,-0.56696527,1.7319822,-0.59233421,-0.59152383,-0.56696527,1.7338599,-0.59233421,-0.59152383,-0.56696527,1.7367655,-0.59233421,-0.59152383,-0.56696527,1.7363306,-0.59233421,-0.59152383,-0.56696527,1.7360045,-0.59234409,-0.59152383,-0.56491955,1.7380502,-0.59232433,-0.59152383,-0.56491955,1.7360539,-0.59232433,-0.59152383,-0.56491955,1.737645,-0.59232433,-0.59152383,-0.56594735,1.7391571,-0.59232433,-0.59152383,-0.56594735,1.7380897,-0.59232433,-0.59152383,-0.56594735,1.7380996,-0.59233421,-0.59152383,-0.56594735,1.7378031,-0.59233421,-0.59152383,-0.56594735,1.7393745,-0.59233421,-0.59152383,-0.56594735,1.7396907,-0.59233421,-0.59152383,-0.56594735,1.7402343,-0.59233421,-0.59152383,-0.56696527,1.7420824,-0.59233421,-0.59152383,-0.56696527,1.7405703,-0.59233421,-0.59152383,-0.56696527,1.7407778,-0.59233421,-0.59152383,-0.56696527,1.7402343,-0.59233421,-0.59152383,-0.56696527,1.7413214,-0.59234409,-0.59152383,-0.56799308,1.7386629,-0.59234409,-0.59152383,-0.56799308,1.7393547,-0.59234409,-0.59152383,-0.56799308,1.7310137,-0.59234409,-0.59152383,-0.56799308,1.7317747,-0.59234409,-0.59152383,-0.56799308,1.7313794,-0.59234409,-0.59152383,-0.56799308,1.7369928,-0.59234409,-0.59152383,-0.56799308,1.7379119,-0.59234409,-0.59152383,-0.56902088,1.7377043,-0.59234409,-0.59152383,-0.56902088,1.7362812,-0.59234409,-0.59152383,-0.56390163,1.7390286,-0.59231445,-0.59152383,-0.5710666,1.7399477,-0.59237374,-0.59049603,-0.5710666,1.7405407,-0.59237374,-0.59049603,-0.57208452,1.7333757,-0.59237374,-0.59152383,-0.5710666,1.7340576,-0.59237374,-0.59152383,-0.57208452,1.7396117,-0.59237374,-0.59152383,-0.57208452,1.7377043,-0.59237374,-0.59152383,-0.57208452,1.7363306,-0.59237374,-0.59152383,-0.57208452,1.7322589,-0.59237374,-0.59152383,-0.57208452,1.7404023,-0.59237374,-0.59152383,-0.57208452,1.7379217,-0.59237374,-0.59152383,-0.57311232,1.737981,-0.59237374,-0.59152383,-0.57311232,1.7382874,-0.59238362,-0.59049603,-0.57311232,1.7411139,-0.59238362,-0.59049603,-0.57311232,1.740936,-0.59238362,-0.59152383,-0.57311232,1.7371311,-0.59238362,-0.59152383,-0.57311232,1.741944,-0.59238362,-0.59152383,-0.57311232,1.7412917,-0.59238362,-0.59152383,-0.57413024,1.7437229,-0.59238362,-0.59152383,-0.57413024,1.7429323,-0.59238362,-0.59152383,-0.57413024,1.7432683,-0.59238362,-0.59049603,-0.57413024,1.7428236,-0.59239351,-0.59049603,-0.57413024,1.7393943,-0.59239351,-0.59049603,-0.57413024,1.7359155,-0.59239351,-0.59049603,-0.57413024,1.7437624,-0.59239351,-0.59049603,-0.57413024,1.7451559,-0.59239351,-0.59152383,-0.57413024,1.7431003,-0.59239351,-0.59152383,-0.57515805,1.7400861,-0.59239351,-0.59049603,-0.57515805,1.7400169,-0.59239351,-0.59152383,-0.57515805,1.7388804,-0.59239351,-0.59049603,-0.57515805,1.7429718,-0.59239351,-0.59049603,-0.57515805,1.744385,-0.59240339,-0.59049603,-0.57515805,1.74481,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339,-0.59152383,-0.57515805,1.7432584,-0.59240339:9
-0.59004451,-0.52707328,1.7533144,-0.58537058,-0.59004451,-0.52707328,1.752037,-0.58537058,-0.59004451,-0.52707328,1.7507798,-0.58537058,-0.59004451,-0.52707328,1.7482857,-0.58537058,-0.59004451,-0.52707328,1.7519964,-0.58537058,-0.59004451,-0.52707328,1.7512969,-0.58537058,-0.59004451,-0.52707328,1.7477686,-0.58537058,-0.59004451,-0.52707328,1.7491677,-0.58537058,-0.59004451,-0.52707328,1.7459943,-0.58537058,-0.59004451,-0.52707328,1.7444735,-0.58537058,-0.59004451,-0.52707328,1.7406006,-0.58537058,-0.59004451,-0.52707328,1.7380253,-0.58536044,-0.59004451,-0.52707328,1.7426587,-0.58537058,-0.59004451,-0.526029,1.7395461,-0.58536044,-0.59004451,-0.52707328,1.7416955,-0.58537058,-0.59004451,-0.526029,1.7398199,-0.58537058,-0.59004451,-0.526029,1.7422126,-0.58537058,-0.59004451,-0.526029,1.7416753,-0.58536044,-0.59004451,-0.526029,1.7417462,-0.58536044,-0.59004451,-0.526029,1.745021,-0.58537058,-0.59004451,-0.526029,1.742243,-0.58536044,-0.59004451,-0.526029,1.7418273,-0.58537058,-0.59004451,-0.526029,1.7419794,-0.58537058,-0.59004451,-0.526029,1.7419591,-0.58536044,-0.59004451,-0.526029,1.7413407,-0.58536044,-0.59004451,-0.526029,1.735805,-0.58536044,-0.59004451,-0.526029,1.747211,-0.58536044,-0.59004451,-0.526029,1.7430947,-0.58536044,-0.59004451,-0.526029,1.7279171,-0.58536044,-0.59004451,-0.526029,1.728566,-0.58536044,-0.59004451,-0.526029,1.7225335,-0.58536044,-0.59108879,-0.526029,1.7299246,-0.58535031,-0.59108879,-0.526029,1.7249363,-0.58535031,-0.59004451,-0.526029,1.7110768,-0.58536044,-0.59004451,-0.526029,1.7072951,-0.58536044,-0.59004451,-0.526029,1.7023373,-0.58535031,-0.59004451,-0.526029,1.6990929,-0.58535031,-0.59108879,-0.526029,1.6996911,-0.58535031,-0.59108879,-0.526029,1.6996505,-0.58535031,-0.59108879,-0.526029,1.6964873,-0.58535031,-0.59108879,-0.526029,1.7041622,-0.58535031,-0.59108879,-0.526029,1.7007354,-0.58534017,-0.59004451,-0.52917198,1.7052876,-0.58537058,-0.59108879,-0.52917198,1.7193601,-0.58536044,-0.59108879,-0.52917198,1.7198873,-0.58536044,-0.59108879,-0.52917198,1.7195527,-0.58536044,-0.59108879,-0.52917198,1.7214081,-0.58536044,-0.59004451,-0.52917198,1.7202523,-0.58536044,-0.59004451,-0.52917198,1.7203739,-0.58536044,-0.59004451,-0.52917198,1.7177277,-0.58536044,-0.59108879,-0.52917198,1.7203942,-0.58536044,-0.59108879,-0.52917198,1.7190863,-0.58536044,-0.59108879,-0.52917198,1.7154465,-0.58536044,-0.59004451,-0.52917198,1.7154364,-0.58536044,-0.59004451,-0.52917198,1.713287,-0.58536044,-0.59004451,-0.52917198,1.7172005,-0.58536044,-0.59108879,-0.52917198,1.7170789,-0.58536044,-0.59108879,-0.52917198,1.7169065,-0.58536044,-0.59108879,-0.52917198,1.7176568,-0.58536044,-0.59108879,-0.52917198,1.7177886,-0.58536044,-0.59004451,-0.52917198,1.7166632,-0.58536044,-0.59108879,-0.52917198,1.7163388,-0.58535031,-0.59108879,-0.52917198,1.7161461,-0.58536044,-0.59108879,-0.52917198,1.715477,-0.58535031,-0.59108879,-0.52917198,1.7153046,-0.58536044,-0.59004451,-0.52917198,1.7160549,-0.58535031,-0.59004451,-0.52917198,1.7148382,-0.58535031,-0.59108879,-0.52917198,1.7130741,-0.58535031,-0.59108879,-0.52917198,1.7111376,-0.58535031,-0.59108879,-0.52917198,1.7172107,-0.58535031,-0.59004451,-0.52917198,1.7175351,-0.58535031,-0.59108879,-0.52917198,1.7172107,-0.58535031,-0.59004451,-0.52917198,1.7159028,-0.58535031,-0.59108879,-0.52917198,1.7152742,-0.58535031,-0.59108879,-0.52917198,1.7168355,-0.58536044,-0.59108879,-0.52917198,1.7148078,-0.58535031,-0.59108879,-0.52917198,1.7155986,-0.58535031,-0.59108879,-0.52917198,1.715842,-0.58536044,-0.59004451,-0.52917198,1.7141995,-0.58536044,-0.59004451,-0.52917198,1.7209518,-0.58536044,-0.59108879,-0.52917198,1.7185997,-0.58535031,-0.59108879,-0.52917198,1.7184577,-0.58535031,-0.59108879,-0.5281277,1.7190154,-0.58535031,-0.59108879,-0.52917198,1.7171296,-0.58535031,-0.59108879,-0.5281277,1.7174844,-0.58535031,-0.59004451,-0.5281277,1.7209823,-0.58535031,-0.59108879,-0.5281277,1.7182347,-0.58535031,-0.59108879,-0.5281277,1.7137331,-0.58535031,-0.59108879,-0.5281277,1.7170383,-0.58535031,-0.59108879,-0.5281277,1.716653,-0.58535031,-0.59108879,-0.5281277,1.7175453,-0.58535031,-0.59108879,-0.52917198,1.7176872,-0.58535031,-0.59108879,-0.5281277,1.706119,-0.58535031,-0.59108879,-0.5281277,1.7051964,-0.58534017,-0.59108879,-0.5281277,1.7045779,-0.58535031,-0.59214321,-0.5281277,1.6939729,-0.58534017,-0.59108879,-0.5281277,1.7033106,-0.58534017,-0.59108879,-0.5281277,1.7025806,-0.58534017,-0.59108879,-0.5281277,1.7026617,-0.58534017,-0.59108879,-0.52917198,1.6934963,-0.58535031,-0.59108879,-0.5281277,1.7034829,-0.58534017,-0.59108879,-0.5281277,1.7020432,-0.58534017,-0.59108879,-0.5281277,1.7039088,-0.58534017,-0.59108879,-0.5281277,1.7037871,-0.58534017,-0.59108879,-0.5281277,1.7038783,-0.58534017,-0.59108879,-0.5281277,1.7039899,-0.58534017,-0.59214321,-0.5281277,1.7039392,-0.58534017,-0.59214321,-0.5281277,1.70327,-0.58534017,-0.59108879,-0.5281277,1.7043244,-0.58534017,-0.59108879,-0.5281277,1.703564,-0.58534017,-0.59108879,-0.5281277,1.7036654,-0.58534017,-0.59108879,-0.5281277,1.7046996,-0.58534017,-0.59108879,-0.5281277,1.7047807,-0.58534017,-0.59108879,-0.5281277,1.70546,-0.58534017,-0.59108879,-0.5281277,1.7055614,-0.58533003,-0.59108879,-0.5281277,1.7048111,-0.58534017,-0.59108879,-0.5281277,1.7055614,-0.58534017,-0.59214321,-0.5281277,1.7091707,-0.58533003,-0.59108879,-0.5281277,1.7084914,-0.58534017,-0.59108879,-0.5281277,1.708096,-0.58534017,-0.59108879,-0.5281277,1.7120805,-0.58534017,-0.59214321,-0.52707328,1.7239732,-0.58534017,-0.59108879,-0.5281277,1.7250073,-0.58534017,-0.59108879,-0.5281277,1.7246322,-0.58534017,-0.59108879,-0.52707328,1.7246626,-0.58534017,-0.59108879,-0.52707328,1.7247437,-0.58534017,-0.59108879,-0.5281277,1.724034,-0.58534017,-0.59108879,-0.52707328,1.7248045,-0.58534017,-0.59108879,-0.5281277,1.7244193,-0.58534017,-0.59214321,-0.52707328,1.7249769,-0.58533003,-0.59108879,-0.52707328,1.7259198,-0.58533003,-0.59108879,-0.52707328,1.7307965,-0.58534017,-0.59214321,-0.52707328,1.7330371,-0.58533003,-0.59108879,-0.52707328,1.7328242,-0.58533003,-0.59214321,-0.52707328,1.7310499,-0.58534017,-0.59214321,-0.52707328,1.7314048,-0.58533003,-0.59214321,-0.52707328,1.7317799,-0.58533003,-0.59214321,-0.52707328,1.731932,-0.58533003,-0.59108879,-0.52707328,1.7314048,-0.58534017,-0.59108879,-0.53232511,1.7301476,-0.58535031,-0.59004451,-0.54177434,1.730979,-0.585401,-0.59004451,-0.54177434,1.730685,-0.585401,-0.59004451,-0.54177434,1.7304112,-0.585401,-0.59004451,-0.54177434,1.7289107,-0.585401,-0.59004451,-0.54177434,1.7342538,-0.585401,-0.59004451,-0.54177434,1.731496,-0.585401,-0.59004451,-0.54177434,1.7329966,-0.585401,-0.59004451,-0.54177434,1.7332196,-0.58541114,-0.59004451,-0.54177434,1.7347607,-0.585401,-0.59004451,-0.54177434,1.7384917,-0.58541114,-0.58899008,-0.54387304,1.7389277,-0.58542128,-0.58899008,-0.54807045,1.7373765,-0.58545169,-0.58899008,-0.55121343,1.7387959,-0.58546183,-0.58899008,-0.55121343,1.7369101,-0.58546183,-0.58899008,-0.55121343,1.7383701,-0.58546183,-0.58899008,-0.55121343,1.7382281,-0.58546183,-0.58899008,-0.55016915,1.7332298,-0.58546183,-0.58899008,-0.55121343,1.7389885,-0.58546183,-0.5879458,-0.55121343,1.740337,-0.58547197,-0.58899008,-0.55121343,1.7377516,-0.58546183,-0.58899008,-0.55121343,1.741726,-0.58546183,-0.58899008,-0.55121343,1.7420707,-0.58547197,-0.5879458,-0.55331213,1.7419794,-0.58548211,-0.5879458,-0.55750954,1.7425979,-0.58551252,-0.5879458,-0.55856396,1.7415739,-0.58551252,-0.5879458,-0.55750954,1.742902,-0.58551252,-0.5879458,-0.55750954,1.7368493,-0.58551252,-0.5879458,-0.55856396,1.7378733,-0.58551252,-0.5879458,-0.55856396,1.7377415,-0.58551252,-0.5879458,-0.55750954,1.7387553,-0.58551252,-0.5879458,-0.55750954,1.7401646,-0.58551252,-0.5879458,-0.55750954,1.740631,-0.58551252,-0.58689138,-0.56276137,1.7412596,-0.58555308,-0.58689138,-0.56276137,1.7401241,-0.58554294,-0.58689138,-0.56276137,1.7398402,-0.58554294,-0.58689138,-0.56276137,1.7401747,-0.58554294,-0.58689138,-0.56276137,1.7388466,-0.58555308,-0.58689138,-0.56276137,1.7397996,-0.58554294,-0.58689138,-0.56276137,1.7225031,-0.58554294,-0.58689138,-0.56276137,1.7237298,-0.58554294,-0.58689138,-0.56276137,1.7242469,-0.58554294,-0.58689138,-0.56801319,1.7243179,-0.58558349,-0.5858471,-0.56695877,1.723669,-0.58558349,-0.58689138,-0.56695877,1.7255447,-0.58558349,-0.5858471,-0.56695877,1.7247944,-0.58558349,-0.5858471,-0.56801319,1.7256156,-0.58558349,-0.58689138,-0.56695877,1.7255244,-0.58558349,-0.5858471,-0.56695877,1.7232026,-0.58558349,-0.58689138,-0.56801319,1.7250276,-0.58558349,-0.58689138,-0.56695877,1.726447,-0.58557336,-0.5858471,-0.56695877,1.7243686,-0.58558349,-0.5858471,-0.56695877,1.7260516,-0.58558349,-0.58689138,-0.56695877,1.7258691,-0.58558349,-0.5858471,-0.56905748,1.7257069,-0.58560377,-0.5858471,-0.5743093,1.7247741,-0.58565446,-0.5858471,-0.57640801,1.7249363,-0.58568488,-0.5858471,-0.57640801,1.7199583,-0.58568488,-0.5858471,-0.57640801,1.7193094,-0.58568488,-0.5858471,-0.57535358,1.7202219,-0.5856646,-0.5858471,-0.57535358,1.7190762,-0.5856646,-0.5858471,-0.5743093,1.7197656,-0.58565446,-0.5858471,-0.5743093,1.7214486,-0.58565446,-0.5858471,-0.57325488,1.7185997,-0.58565446,-0.5858471,-0.57325488,1.7168558,-0.58564433,-0.5858471,-0.57325488,1.7171397,-0.58563419,-0.5858471,-0.5722106,1.7161157,-0.58563419,-0.5858471,-0.5722106,1.7179001,-0.58563419,-0.5858471,-0.5722106,1.7184172,-0.58562405,-0.5858471,-0.5722106,1.7173323,-0.58563419,-0.5858471,-0.5722106,1.7172715,-0.58563419,-0.5858471,-0.5722106,1.7198569,-0.58563419,-0.5858471,-0.5722106,1.7191472,-0.58563419,-0.5858471,-0.5743093,1.7188531,-0.5856646,-0.5858471,-0.5743093,1.719867,-0.58565446,-0.5858471,-0.5743093,1.7216311,-0.58565446,-0.5858471,-0.5743093,1.7205767,-0.58565446,-0.5858471,-0.5743093,1.7224321,-0.58565446,-0.5858471,-0.5743093,1.7235575,-0.58565446,-0.5858471,-0.5743093,1.722868,-0.58565446,-0.5858471,-0.5743093,1.7235271,-0.58565446,-0.5858471,-0.5743093,1.7210025,-0.58565446,-0.5858471,-0.5743093,1.7200191,-0.58565446,-0.5858471,-0.5743093,1.7221279,-0.58565446,-0.5858471,-0.5743093,1.7188531,-0.58565446,-0.5858471,-0.5743093,1.7249161,-0.5856646,-0.5858471,-0.5743093,1.7393941,-0.58565446,-0.5858471,-0.57955099,1.7366364,-0.5857153,-0.5858471,-0.57955099,1.7356123,-0.5857153,-0.5858471,-0.57955099,1.7366668,-0.58572544,-0.5858471,-0.57955099,1.7361193,-0.58572544,-0.5858471,-0.57955099,1.7361497,-0.58572544,-0.5858471,-0.57955099,1.7406513,-0.58572544,-0.5858471,-0.5858471,1.737559,-0.5858471,-0.5858471,-0.5858471,1.7375488,-0.5858471,-0.5858471,-0.5858471,1.7372244,-0.5858471,-0.5858471,-0.5858471,1.7341524,-0.5858471,-0.5858471,-0.5858471,1.7338178,-0.5858471,-0.5858471,-0.5858471,1.7338279,-0.5858471,-0.5858471,-0.5858471,1.7348925,-0.5858471,-0.5858471,-0.5858471,1.73325,-0.5858471,-0.5858471,-0.5858471,1.7339192,-0.5858471,-0.5858471,-0.5858471,1.7329966,-0.5858471,-0.5858471,-0.5858471,1.7328242,-0.5858471,-0.5858471,-0.5858471,1.7349837,-0.5858471,-0.5858471,-0.5858471,1.7350851,-0.5858471,-0.5858471,-0.5858471,1.7304011,-0.5858471,-0.5858471,-0.5858471,1.731273,-0.5858471,-0.5858471,-0.5858471,1.73032,-0.5858471,-0.5858471,-0.5858471,1.7310905,-0.5858471,-0.5858471,-0.5858471,1.7314656,-0.5858471,-0.5858471,-0.5858471,1.7324592,-0.5858471,-0.5858471,-0.5858471,1.7322666,-0.5858471,-0.5858471,-0.5858471,1.7384106,-0.5858471,-0.5858471,-0.5858471,1.7371331,-0.5858471,-0.5858471,-0.5858471,1.7365857,-0.5858471,-0.5858471,-0.5858471,1.7379747,-0.5858471,-0.5858471,-0.5858471,1.7365147,-0.5858471,-0.5858471,-0.5858471,1.7369405,-0.5858471,-0.5858471,-0.5858471,1.7367986,-0.5858471,-0.5858471,-0.5858471,1.7370216,-0.5858471,-0.5858471,-0.5858471,1.7287383,-0.5858471,-0.5858471,-0.5858471,1.7361598,-0.5858471,-0.5858471,-0.5858471,1.7341625,-0.5858471,-0.5858471,-0.5858471,1.735004,-0.5858471,-0.5858471,-0.5858471,1.7353285,-0.5858471,-0.5858471,-0.5858471,1.7355819,-0.5858471,-0.5858471,-0.5858471,1.7348722,-0.5858471,-0.5858471,-0.5858471,1.7358151,-0.5858471,-0.5858471,-0.5858471,1.7349533,-0.5858471,-0.5858471,-0.5858471,1.7350344,-0.5858471,-0.5858471,-0.5858471,1.7364437,-0.5858471,-0.5858471,-0.5858471,1.735663,-0.5858471,-0.5858471,-0.5858471,1.7351156,-0.5858471,-0.5858471,-0.5858471,1.7348418,-0.5858471,-0.5858471,-0.5858471,1.734781,-0.5858471,-0.5858471,-0.5858471,1.7343045,-0.5858471,-0.5858471,-0.5858471,1.7360584,-0.5858471,-0.5858471,-0.5858471,1.7337063,-0.5858471,-0.5858471,-0.5858471,1.7358455,-0.5858471,-0.5858471,-0.5858471,1.7352879,-0.5858471,-0.5858471,-0.5858471,1.736687,-0.5858471,-0.5858471,-0.5858471,1.7377719,-0.5858471,-0.5858471,-0.5858471,1.7360483,-0.5858471,-0.5858471,-0.5858471,1.7378124,-0.5858471,-0.5858471,-0.5858471,1.7396577,-0.5858471,-0.5858471,-0.5858471,1.740925,-0.5858471,-0.5858471,-0.5858471,1.7413306,-0.5858471,-0.5858471,-0.5858471,1.7406715,-0.5858471,-0.5858471,-0.5858471,1.7406614,-0.5858471,-0.5858471,-0.5858471,1.7400531,-0.5858471,-0.5858471,-0.5858471,1.7425675,-0.5858471,-0.5858471,-0.5858471,1.7402559,-0.5858471,-0.5858471,-0.5858471,1.7392217,-0.5858471,-0.5858471,-0.5858471,1.7346796,-0.5858471,-0.5858471,-0.5858471,1.7340206,-0.5858471,-0.5858471,-0.5858471,1.7352372,-0.5858471,-0.5858471,-0.5858471,1.7354298,-0.5858471,-0.5858471,-0.5858471,1.7389885,-0.5858471,-0.5858471,-0.5858471,1.7358962,-0.5858471,-0.5858471,-0.5858471,1.7353487,-0.5858471,-0.5858471,-0.5858471,1.7366262,-0.5858471,-0.5858471,-0.5858471,1.7367276,-0.5858471,-0.5858471,-0.5858471,1.7375083,-0.5858471,-0.5858471,-0.5858471,1.7372143,-0.5858471,-0.5858471,-0.5858471,1.7401747,-0.5858471,-0.5858471,-0.5858471,1.7374272,-0.5858471,-0.5858471,-0.5858471,1.736758,-0.5858471,-0.5858471,-0.5858471,1.7385526,-0.5858471,-0.5858471,-0.5858471,1.7375083,-0.5858471,-0.5858471,-0.5858471,1.7417969,-0.5858471,-0.5858471,-0.5858471,1.7421214,-0.5858471,-0.5858471,-0.5858471,1.742679,-0.5858471,-0.5858471,-0.5858471,1.7406411,-0.5858471,-0.5858471,-0.5858471,1.7425269,-0.5858471,-0.5858471,-0.5858471,1.7411987,-0.5858471,-0.5858471,-0.5858471,1.7404282,-0.5858471,-0.5858471,-0.5858471,1.738289,-0.5858471,-0.5858471,-0.5858471,1.7394143,-0.5858471,-0.5858471,-0.5858471,1.7384816,-0.5858471,-0.5858471,-0.5858471,1.7409858,-0.5858471,-0.5858471,-0.5858471,1.7439463,-0.5858471,-0.5858471,-0.5858471,1.7386033,-0.5858471,-0.5858471,-0.5858471,1.7440376,-0.5858471,-0.5858471,-0.5858471,1.7467547,-0.5858471,-0.5858471,-0.5858471,1.7466229,-0.5858471,-0.5858471,-0.5858471,1.7483769,-0.5858471,-0.5858471,-0.5858471,1.7461768,-0.5858471,-0.5858471,-0.5858471,1.759205,-0.5858471,-0.5858471,-0.5858471,1.7603405,-0.5858471,-0.5858471,-0.5858471,1.7618005,-0.5858471,-0.5858471,-0.5858471,1.762642,-0.5858471,-0.5858471,-0.5858471,1.7623784,-0.5858471,-0.5858471,-0.5858471,1.7632605,-0.5858471,-0.5858471,-0.5858471,1.7635241,-0.5858471,-0.5858471,-0.5858471,1.7634227,-0.5858471,-0.5858471,-0.5858471,1.7617093,-0.5858471,-0.5858471,-0.5858471,1.7624392,-0.5858471,-0.5858471,-0.5858471,1.7652983,-0.5858471,-0.5858471,-0.5858471,1.7637877,-0.5858471,-0.5858471,-0.5858471,1.7655417,-0.5858471,-0.5858471,-0.5858471,1.7638181,-0.5858471,-0.5858471,-0.5858471,1.7646089,-0.5858471,-0.5858471,-0.5858471,1.7655924,-0.5858471,-0.5858471,-0.5858471,1.7647306,-0.5858471,-0.5858471,-0.5858471,1.7634835,-0.5858471,-0.5858471,-0.5858471,1.7691916,-0.5858471,-0.5858471,-0.5858471,1.7669205,-0.5858471,-0.5858471,-0.5858471,1.7664035,-0.5858471,-0.5858471,-0.5858471,1.7666265,-0.5858471,-0.5858471,-0.5858471,1.7644771,-0.5858471,-0.5858471,-0.5858471,1.7641121,-0.5858471,-0.5858471,-0.5858471,1.7648522,-0.5858471,-0.5858471,-0.5858471,1.7635951,-0.5858471,-0.5858471,-0.5858471,1.7635139,-0.5858471,-0.5858471,-0.5858471,1.7657546,-0.5858471,-0.5858471,-0.5858471,1.7640513,-0.5858471,-0.5858471,-0.5858471,1.765055,-0.5858471,-0.5858471,-0.5858471,1.765349,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471,-0.5858471,-0.5858471,1.7644873,-0.5858471:9
-0.58646996,-0.58646996,1.7260746,-0.58646996,-0.58646996,-0.58646996,1.7145355,-0.58646996,-0.58646996,-0.58646996,1.7090761,-0.58646996,-0.58646996,-0.58646996,1.7144847,-0.58646996,-0.58646996,-0.58646996,1.7149523,-0.58646996,-0.58646996,-0.58646996,1.7192121,-0.58646996,-0.58646996,-0.58646996,1.7038708,-0.58646996,-0.58646996,-0.58646996,1.703637,-0.58646996,-0.58646996,-0.58646996,1.7114856,-0.58646996,-0.58646996,-0.58646996,1.7091472,-0.58646996,-0.58646996,-0.58646996,1.7220384,-0.58646996,-0.58646996,-0.58646996,1.7416802,-0.58646996,-0.58857444,-0.5538455,1.7152675,-0.58619547,-0.58857444,-0.5538455,1.7074698,-0.58619547,-0.58857444,-0.5538455,1.7200763,-0.58619547,-0.58857444,-0.5538455,1.7078968,-0.58619547,-0.58857444,-0.5538455,1.7051721,-0.58619547,-0.58857444,-0.5538455,1.7106112,-0.58619547,-0.58857444,-0.5538455,1.7166298,-0.58619547,-0.58857444,-0.5538455,1.7180023,-0.58619547,-0.58857444,-0.55490283,1.7147897,-0.58620563,-0.58857444,-0.55490283,1.7119634,-0.58620563,-0.58857444,-0.55490283,1.7149727,-0.58620563,-0.58857444,-0.55490283,1.7131325,-0.58620563,-0.58857444,-0.55490283,1.7102351,-0.58620563,-0.58857444,-0.55490283,1.7176871,-0.58620563,-0.58857444,-0.55490283,1.7103876,-0.58620563,-0.58857444,-0.55490283,1.7166298,-0.58620563,-0.58857444,-0.55490283,1.7187445,-0.58620563,-0.58857444,-0.55490283,1.7184903,-0.58620563,-0.58857444,-0.55490283,1.7241226,-0.58620563,-0.58857444,-0.55490283,1.72702,-0.5862158,-0.58857444,-0.55490283,1.7176566,-0.5862158,-0.58857444,-0.55490283,1.7300802,-0.5862158,-0.58857444,-0.55490283,1.7311477,-0.5862158,-0.58857444,-0.55490283,1.7241836,-0.58620563,-0.58857444,-0.55490283,1.7330285,-0.5862158,-0.58857444,-0.55594998,1.7241327,-0.5862158,-0.58857444,-0.55594998,1.7205541,-0.5862158,-0.58857444,-0.55594998,1.7235024,-0.5862158,-0.58857444,-0.55594998,1.7242446,-0.5862158,-0.58857444,-0.55594998,1.7401146,-0.5862158,-0.58857444,-0.55594998,1.7433679,-0.5862158,-0.58751712,-0.55594998,1.7171382,-0.5862158,-0.58857444,-0.55594998,1.720117,-0.5862158,-0.58857444,-0.55594998,1.7253222,-0.5862158,-0.58857444,-0.55594998,1.72641,-0.5862158,-0.58857444,-0.55594998,1.7315137,-0.5862158,-0.58857444,-0.55594998,1.7182565,-0.5862158,-0.58857444,-0.55594998,1.6968457,-0.5862158,-0.58857444,-0.55594998,1.7041758,-0.5862158,-0.58857444,-0.55594998,1.6971304,-0.5862158,-0.58857444,-0.55594998,1.703637,-0.5862158,-0.58751712,-0.55594998,1.7063108,-0.5862158,-0.58857444,-0.55594998,1.6990214,-0.5862158,-0.58857444,-0.55594998,1.704918,-0.5862158,-0.58857444,-0.55594998,1.7036268,-0.5862158,-0.58857444,-0.55594998,1.6951987,-0.5862158,-0.58857444,-0.55594998,1.6834767,-0.5862158,-0.58751712,-0.55594998,1.7261559,-0.58622597,-0.58751712,-0.55594998,1.7277114,-0.5862158,-0.58857444,-0.5570073,1.7307512,-0.5862158,-0.58751712,-0.5570073,1.7186936,-0.5862158,-0.58751712,-0.5570073,1.7179006,-0.5862158,-0.58857444,-0.5570073,1.73007,-0.5862158,-0.58751712,-0.5570073,1.7292262,-0.5862158,-0.58751712,-0.5570073,1.7188258,-0.58622597,-0.58751712,-0.5570073,1.7270404,-0.58622597,-0.58751712,-0.5570073,1.7305173,-0.58622597,-0.58751712,-0.5570073,1.7173517,-0.58622597,-0.58751712,-0.5570073,1.715054,-0.58622597,-0.58751712,-0.5570073,1.7412024,-0.58622597,-0.58751712,-0.5570073,1.745635,-0.58622597,-0.58857444,-0.5570073,1.7221604,-0.58622597,-0.58751712,-0.5570073,1.7252409,-0.58622597,-0.58751712,-0.5570073,1.7243971,-0.58622597,-0.58751712,-0.5570073,1.7214996,-0.58622597,-0.58751712,-0.5570073,1.7366173,-0.58622597,-0.58751712,-0.5570073,1.7343501,-0.58622597,-0.58751712,-0.5570073,1.7245394,-0.58622597,-0.58751712,-0.5570073,1.7352753,-0.58622597,-0.58751712,-0.5570073,1.733913,-0.58622597,-0.58751712,-0.5570073,1.7323168,-0.58622597,-0.58751712,-0.5570073,1.7347568,-0.58622597,-0.58751712,-0.5570073,1.7286874,-0.58622597,-0.58751712,-0.5570073,1.7230653,-0.58622597,-0.58751712,-0.5570073,1.7324286,-0.58622597,-0.58751712,-0.5570073,1.7273657,-0.58622597,-0.58751712,-0.5570073,1.7269285,-0.58622597,-0.58751712,-0.5570073,1.7302632,-0.58622597,-0.58751712,-0.5570073,1.7248241,-0.58622597,-0.58751712,-0.5570073,1.7249156,-0.58622597,-0.58751712,-0.5570073,1.7365563,-0.58623613,-0.58857444,-0.5570073,1.7286772,-0.58622597,-0.58751712,-0.5570073,1.7229229,-0.58622597,-0.58857444,-0.5570073,1.7230958,-0.58622597,-0.58751712,-0.5570073,1.7256882,-0.58622597,-0.58751712,-0.5570073,1.7343806,-0.58622597,-0.58857444,-0.5570073,1.7278435,-0.58622597,-0.58751712,-0.5570073,1.733364,-0.58622597,-0.58751712,-0.5570073,1.730741,-0.58623613,-0.58751712,-0.5570073,1.7228111,-0.58622597,-0.58751712,-0.5570073,1.7443438,-0.58623613,-0.58751712,-0.5570073,1.7434594,-0.58622597,-0.58857444,-0.5570073,1.7194968,-0.58622597,-0.58751712,-0.5570073,1.7208286,-0.58622597,-0.58751712,-0.5570073,1.7268472,-0.58622597,-0.58751712,-0.5570073,1.7216826,-0.58622597,-0.58751712,-0.5570073,1.7274572,-0.58622597,-0.58857444,-0.5570073,1.7235024,-0.58622597,-0.58751712,-0.5570073,1.714871,-0.58622597,-0.58751712,-0.5570073,1.7226993,-0.58622597,-0.58751712,-0.5570073,1.7252307,-0.58622597,-0.58751712,-0.55805446,1.719446,-0.58623613,-0.58751712,-0.5570073,1.7189986,-0.58622597,-0.58751712,-0.5570073,1.7287585,-0.58622597,-0.58857444,-0.5570073,1.7248546,-0.58622597,-0.58751712,-0.5570073,1.7265422,-0.58622597,-0.58857444,-0.5570073,1.7242446,-0.58622597,-0.58751712,-0.5570073,1.7206659,-0.58622597,-0.58751712,-0.5570073,1.7229738,-0.58623613,-0.58857444,-0.5570073,1.7232788,-0.58622597,-0.58857444,-0.5570073,1.7305377,-0.58623613,-0.58751712,-0.5570073,1.726959,-0.58622597,-0.58751712,-0.55805446,1.726715,-0.58623613,-0.58857444,-0.55805446,1.7324795,-0.58623613,-0.58857444,-0.5570073,1.7243767,-0.58622597,-0.58751712,-0.5570073,1.7294193,-0.58623613,-0.58857444,-0.5570073,1.7282502,-0.58622597,-0.58751712,-0.55805446,1.7284739,-0.58623613,-0.58751712,-0.5570073,1.7296125,-0.58622597,-0.58751712,-0.5570073,1.733547,-0.58623613,-0.58751712,-0.5570073,1.744781,-0.58623613,-0.58751712,-0.5570073,1.7540427,-0.58623613,-0.58751712,-0.55805446,1.7254544,-0.58623613,-0.58857444,-0.5570073,1.7254137,-0.58622597,-0.58751712,-0.5570073,1.7349601,-0.58622597,-0.58751712,-0.5570073,1.728972,-0.58622597,-0.58857444,-0.5570073,1.729338,-0.58622597,-0.58751712,-0.5570073,1.7349906,-0.58623613,-0.58751712,-0.5570073,1.7320423,-0.58623613,-0.58857444,-0.5570073,1.7303445,-0.58622597,-0.58751712,-0.5570073,1.7280164,-0.58622597,-0.58751712,-0.5570073,1.728118,-0.58622597,-0.58751712,-0.5570073,1.7235329,-0.58622597,-0.58751712,-0.55805446,1.7280265,-0.58622597,-0.58751712,-0.5570073,1.7321745,-0.58622597,-0.58751712,-0.5570073,1.7239701,-0.58622597,-0.58751712,-0.5570073,1.7270099,-0.58622597,-0.58751712,-0.5570073,1.726471,-0.58622597,-0.58751712,-0.55805446,1.7240717,-0.58623613,-0.58857444,-0.5570073,1.7094014,-0.58622597,-0.58751712,-0.5570073,1.7144034,-0.58622597,-0.58751712,-0.5570073,1.719934,-0.58622597,-0.58751712,-0.55805446,1.7092896,-0.58622597,-0.58751712,-0.5570073,1.7240819,-0.58622597,-0.58751712,-0.5570073,1.7152573,-0.58622597,-0.58751712,-0.5570073,1.7189885,-0.58622597,-0.58751712,-0.55805446,1.7104994,-0.58622597,-0.58751712,-0.5570073,1.7092692,-0.58622597,-0.58751712,-0.55805446,1.7165282,-0.58622597,-0.58751712,-0.5570073,1.7118617,-0.58622597,-0.58751712,-0.5570073,1.7351431,-0.58623613,-0.58751712,-0.5570073,1.730802,-0.58622597,-0.58751712,-0.55805446,1.7171077,-0.58622597,-0.58751712,-0.55805446,1.7195171,-0.58622597,-0.58751712,-0.55805446,1.7115161,-0.58622597,-0.58857444,-0.5570073,1.7234516,-0.58622597,-0.58751712,-0.5570073,1.7166502,-0.58622597,-0.58857444,-0.55805446,1.7144847,-0.58622597,-0.58751712,-0.5570073,1.7255154,-0.58622597,-0.58751712,-0.5570073,1.7207371,-0.58622597,-0.58751712,-0.5570073,1.7158978,-0.58622597,-0.58751712,-0.5570073,1.7202695,-0.58622597,-0.58857444,-0.55805446,1.7086186,-0.58622597,-0.58751712,-0.5570073,1.7158572,-0.58623613,-0.58751712,-0.55805446,1.7148812,-0.58623613,-0.58751712,-0.5570073,1.7134274,-0.58622597,-0.58751712,-0.5570073,1.7252612,-0.58622597,-0.58751712,-0.55805446,1.7049281,-0.58622597,-0.58751712,-0.5570073,1.7154607,-0.58622597,-0.58751712,-0.5570073,1.7214386,-0.58623613,-0.58751712,-0.5570073,1.7179718,-0.58622597,-0.58751712,-0.55805446,1.714322,-0.58622597,-0.58751712,-0.5570073,1.7218656,-0.58622597,-0.58751712,-0.5570073,1.7242954,-0.58622597,-0.58751712,-0.5570073,1.7284434,-0.58623613,-0.58751712,-0.55805446,1.7262677,-0.58623613,-0.58751712,-0.5570073,1.7223638,-0.58623613,-0.58751712,-0.5570073,1.7190596,-0.58623613,-0.58751712,-0.5570073,1.7183276,-0.58623613,-0.58751712,-0.55805446,1.7150743,-0.58623613,-0.58751712,-0.5570073,1.7285349,-0.58623613,-0.58751712,-0.5570073,1.7374611,-0.58623613,-0.58751712,-0.5570073,1.7341671,-0.58623613,-0.58751712,-0.5570073,1.7238786,-0.58622597,-0.58751712,-0.5570073,1.7239701,-0.58622597,-0.58751712,-0.55805446,1.7062396,-0.58622597,-0.58751712,-0.55805446,1.7257187,-0.58622597,-0.58751712,-0.5570073,1.7302428,-0.58623613,-0.58751712,-0.5570073,1.7281994,-0.58623613,-0.58751712,-0.5570073,1.705833,-0.58622597,-0.58751712,-0.5570073,1.7152472,-0.58623613,-0.58751712,-0.5570073,1.7207066,-0.58623613,-0.58751712,-0.55805446,1.7085271,-0.58623613,-0.58751712,-0.5570073,1.7102046,-0.58622597,-0.58751712,-0.5570073,1.7148202,-0.58623613,-0.58751712,-0.55805446,1.7102554,-0.58623613,-0.58751712,-0.55805446,1.7077748,-0.58622597,-0.58751712,-0.5570073,1.7168332,-0.58622597,-0.58751712,-0.5570073,1.7003837,-0.58622597,-0.58751712,-0.55805446,1.714322,-0.58622597,-0.58751712,-0.5570073,1.7207371,-0.58623613,-0.58751712,-0.5570073,1.7130614,-0.58622597,-0.58751712,-0.5570073,1.703576,-0.58622597,-0.58751712,-0.5570073,1.7095844,-0.58622597,-0.58751712,-0.5570073,1.7115364,-0.58622597,-0.58751712,-0.5570073,1.7259119,-0.58622597,-0.58857444,-0.5570073,1.7013495,-0.58622597,-0.58751712,-0.5570073,1.7186631,-0.58622597,-0.58751712,-0.5570073,1.7217334,-0.58622597,-0.58857444,-0.5570073,1.7156132,-0.58622597,-0.58751712,-0.5570073,1.7107332,-0.58622597,-0.58751712,-0.5570073,1.7463467,-0.58623613,-0.58751712,-0.5570073,1.747587,-0.58623613,-0.58857444,-0.5570073,1.720483,-0.58622597,-0.58751712,-0.5570073,1.7113229,-0.58622597,-0.58751712,-0.5570073,1.7257594,-0.58622597,-0.58751712,-0.5570073,1.7213369,-0.58622597,-0.58751712,-0.5570073,1.7210828,-0.58622597,-0.58751712,-0.5570073,1.7163147,-0.58622597,-0.58751712,-0.5570073,1.7266134,-0.58622597,-0.58751712,-0.5570073,1.7117905,-0.58622597,-0.58857444,-0.5570073,1.7169857,-0.58622597,-0.58751712,-0.5570073,1.7093709,-0.58622597,-0.58751712,-0.5570073,1.7103672,-0.58622597,-0.58857444,-0.5570073,1.7179616,-0.58622597,-0.58751712,-0.5570073,1.7172805,-0.58622597,-0.58857444,-0.5570073,1.7012987,-0.58622597,-0.58857444,-0.5570073,1.718043,-0.58622597,-0.58751712,-0.5570073,1.7262474,-0.58622597,-0.58751712,-0.5570073,1.7193138,-0.58623613,-0.58751712,-0.5570073,1.7262982,-0.58622597,-0.58751712,-0.5570073,1.7238684,-0.58622597,-0.58751712,-0.5570073,1.7228619,-0.58623613,-0.58751712,-0.5570073,1.7245496,-0.58622597,-0.58751712,-0.5570073,1.7367698,-0.58623613,-0.58751712,-0.5570073,1.7455028,-0.58623613,-0.58751712,-0.5570073,1.7476378,-0.58623613,-0.58751712,-0.5570073,1.7404704,-0.58623613,-0.58751712,-0.5570073,1.7357836,-0.58623613,-0.58751712,-0.5570073,1.7479123,-0.58623613,-0.58751712,-0.5570073,1.7519789,-0.58623613,-0.58751712,-0.5570073,1.7534124,-0.58623613,-0.58751712,-0.5570073,1.7412125,-0.58623613,-0.58751712,-0.5570073,1.7414972,-0.58623613,-0.58751712,-0.5570073,1.7383354,-0.58622597,-0.58751712,-0.5570073,1.7268879,-0.58622597,-0.58751712,-0.5570073,1.7435,-0.58623613,-0.58751712,-0.5570073,1.7511656,-0.58623613,-0.58751712,-0.5570073,1.7326625,-0.58622597,-0.58751712,-0.5570073,1.7511961,-0.58623613,-0.58751712,-0.5570073,1.741365,-0.58622597,-0.58751712,-0.5570073,1.7388336,-0.58622597,-0.58751712,-0.5570073,1.7465602,-0.58622597,-0.58751712,-0.5570073,1.7411922,-0.58622597,-0.58751712,-0.5570073,1.7459705,-0.58622597,-0.58857444,-0.5570073,1.7469566,-0.58622597,-0.58751712,-0.5570073,1.7510029,-0.58622597,-0.58751712,-0.5570073,1.7536767,-0.58623613,-0.58751712,-0.5570073,1.7421682,-0.58623613,-0.58857444,-0.5570073,1.7426664,-0.58623613,-0.58751712,-0.5570073,1.7502099,-0.58623613,-0.58751712,-0.5570073,1.7527007,-0.58623613,-0.58751712,-0.5570073,1.7468855,-0.58623613,-0.58751712,-0.5570073,1.7544392,-0.58623613,-0.58751712,-0.5570073,1.7520501,-0.58623613,-0.58751712,-0.5570073,1.7591565,-0.58622597,-0.58751712,-0.5570073,1.7497728,-0.58622597,-0.58751712,-0.5570073,1.7493458,-0.58622597,-0.58751712,-0.5570073,1.7609967,-0.58622597,-0.58857444,-0.5570073,1.7493458,-0.58622597,-0.58751712,-0.5570073,1.7527312,-0.58623613,-0.58751712,-0.5570073,1.7630503,-0.58622597,-0.58751712,-0.5570073,1.761566,-0.58623613,-0.58751712,-0.5570073,1.7532904,-0.58622597,-0.58751712,-0.5570073,1.7600207,-0.58623613,-0.58751712,-0.5570073,1.7547747,-0.58623613,-0.58751712,-0.5570073,1.7482885,-0.58622597,-0.58751712,-0.5570073,1.759675,-0.58623613,-0.58751712,-0.5570073,1.7630605,-0.58623613,-0.58751712,-0.5570073,1.7546426,-0.58623613,-0.58751712,-0.5570073,1.7569707,-0.58623613,-0.58751712,-0.5570073,1.762847,-0.58623613,-0.58751712,-0.5570073,1.7605392,-0.58623613,-0.58751712,-0.5570073,1.7564014,-0.58623613,-0.58751712,-0.5570073,1.7626131,-0.58623613,-0.58751712,-0.5570073,1.7577739,-0.58623613,-0.58751712,-0.5570073,1.7613016,-0.58623613,-0.58751712,-0.5570073,1.7646159,-0.58623613,-0.58751712,-0.5570073,1.7645549,-0.58623613,-0.58857444,-0.5570073,1.7500879,-0.58623613,-0.58857444,-0.5570073,1.7534327,-0.58622597,-0.58751712,-0.5570073,1.7655208,-0.58623613,-0.58751712,-0.5570073,1.7587193,-0.58622597,-0.58751712,-0.5570073,1.7681946,-0.58623613,-0.58751712,-0.5570073,1.7577332,-0.58623613,-0.58751712,-0.5570073,1.7609967,-0.58623613,-0.58751712,-0.5570073,1.7659071,-0.58623613,-0.58751712,-0.5570073,1.7459502,-0.58622597,-0.58751712,-0.5570073,1.7535751,-0.58622597,-0.58751712,-0.5570073,1.7523856,-0.58622597,-0.58751712,-0.5570073,1.7460112,-0.58622597,-0.58857444,-0.5570073,1.7515418,-0.58623613,-0.58751712,-0.5570073,1.7493051,-0.58622597,-0.58751712,-0.5570073,1.7570215,-0.58622597,-0.58751712,-0.5570073,1.7610882,-0.58622597,-0.58751712,-0.5570073,1.7603765,-0.58622597,-0.58751712,-0.5570073,1.7669848,-0.58622597,-0.58751712,-0.5570073,1.7645143,-0.58622597,-0.58751712,-0.5570073,1.7618608,-0.58622597,-0.58751712,-0.5570073,1.77036,-0.58622597,-0.58751712,-0.5570073,1.7498338,-0.58622597,-0.58857444,-0.5570073,1.7606408,-0.58622597,-0.58751712,-0.5570073,1.7513689,-0.58622597,-0.58857444,-0.5570073,1.7586177,-0.58622597,-0.58857444,-0.5570073,1.7628165,-0.58622597,-0.58751712,-0.5570073,1.7584143,-0.58622597,-0.58751712,-0.5570073,1.7628775,-0.58622597,-0.58751712,-0.5570073,1.7598987,-0.58622597,-0.58857444,-0.5570073,1.755588,-0.58622597,-0.58857444,-0.5570073,1.7562489,-0.58622597,-0.58857444,-0.5570073,1.7524771,-0.58622597,-0.58857444,-0.5570073,1.7538292,-0.58622597,-0.58857444,-0.5570073,1.7491831,-0.58622597,-0.58857444,-0.5570073,1.7423614,-0.58622597,-0.58857444,-0.5570073,1.746916,-0.58622597,-0.58857444,-0.5570073,1.7502709,-0.58622597,-0.58857444,-0.5570073,1.7459095,-0.58622597,-0.58857444,-0.5570073,1.7509419,-0.58622597,-0.58751712,-0.5570073,1.7591972,-0.58622597,-0.58751712,-0.5570073,1.7569402,-0.58622597,-0.58857444,-0.5570073,1.7610272,-0.58622597,-0.58751712,-0.5570073,1.7580687,-0.58622597,-0.58857444,-0.5570073,1.7520806,-0.58622597,-0.58857444,-0.5570073,1.7605188,-0.58622597,-0.58857444,-0.5570073,1.7619116,-0.58622597,-0.58751712,-0.5570073,1.7552119,-0.58622597,-0.58857444,-0.5570073,1.7603663,-0.58622597,-0.58751712,-0.5570073,1.7647583,-0.58623613,-0.58857444,-0.5570073,1.7549781,-0.58622597,-0.58857444,-0.5570073,1.7470278,-0.58622597,-0.58857444,-0.5570073,1.7537479,-0.58622597,-0.58751712,-0.5570073,1.7554152,-0.58622597,-0.58751712,-0.5570073,1.7535547,-0.58622597,-0.58857444,-0.5570073,1.7526499,-0.58622597,-0.58857444,-0.5570073,1.7539614,-0.58622597,-0.58857444,-0.5570073,1.7573164,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597,-0.58857444,-0.5570073,1.7553644,-0.58622597:9
-0.59347926,-0.59347926,1.7443112,-0.59347926,-0.59033618,-0.57668914,1.7398602,-0.59110674,-0.59347926,-0.59347926,1.7401948,-0.59347926,-0.59347926,-0.59347926,1.7429729,-0.59347926,-0.59347926,-0.59347926,1.7432669,-0.59347926,-0.60711616,-0.52316558,1.7430236,-0.59291148,-0.60501739,-0.53050618,1.7432365,-0.59297231,-0.60501739,-0.53050618,1.7425673,-0.59297231,-0.60501739,-0.53050618,1.7466939,-0.59297231,-0.60501739,-0.53050618,1.745244,-0.59297231,-0.60501739,-0.53050618,1.7500296,-0.59297231,-0.60501739,-0.53050618,1.7489244,-0.59297231,-0.60501739,-0.53050618,1.7491475,-0.59297231,-0.60501739,-0.53050618,1.7439259,-0.59297231,-0.60501739,-0.53050618,1.7429019,-0.59297231,-0.60501739,-0.53050618,1.7426282,-0.59297231,-0.60501739,-0.53050618,1.7434291,-0.59297231,-0.60501739,-0.53050618,1.74203,-0.59297231,-0.60501739,-0.53050618,1.7483161,-0.59297231,-0.60501739,-0.53050618,1.7379845,-0.59297231,-0.60501739,-0.53050618,1.7439158,-0.59297231,-0.60501739,-0.53050618,1.7452035,-0.59297231,-0.60501739,-0.53050618,1.737508,-0.59297231,-0.60501739,-0.53050618,1.734811,-0.59297231,-0.60501739,-0.53050618,1.734517,-0.59297231,-0.60501739,-0.53050618,1.7332192,-0.59297231,-0.60501739,-0.53050618,1.7398805,-0.59297231,-0.60501739,-0.53050618,1.7423443,-0.59297231,-0.60501739,-0.53050618,1.7390187,-0.59297231,-0.60501739,-0.53050618,1.738674,-0.59297231,-0.60501739,-0.53156064,1.739333,-0.59297231,-0.60501739,-0.53050618,1.7414216,-0.59297231,-0.60501739,-0.53050618,1.7412493,-0.59297231,-0.60501739,-0.53050618,1.7464708,-0.59297231,-0.60501739,-0.53156064,1.7437739,-0.59297231,-0.60501739,-0.53050618,1.741158,-0.59297231,-0.60501739,-0.53050618,1.7519154,-0.59297231,-0.60501739,-0.53156064,1.7428614,-0.59297231,-0.60501739,-0.53156064,1.7379135,-0.59297231,-0.60501739,-0.53050618,1.7440375,-0.59297231,-0.60501739,-0.53050618,1.7457611,-0.59298245,-0.60501739,-0.53050618,1.7400833,-0.59297231,-0.60607185,-0.52630866,1.7445748,-0.59293176,-0.60501739,-0.53156064,1.742983,-0.59298245,-0.60501739,-0.53156064,1.7428918,-0.59298245,-0.60501739,-0.53050618,1.7396676,-0.59297231,-0.60501739,-0.53156064,1.7346792,-0.59297231,-0.60501739,-0.53156064,1.7406409,-0.59297231,-0.60501739,-0.53050618,1.7408944,-0.59297231,-0.60501739,-0.53050618,1.7404686,-0.59297231,-0.60501739,-0.53156064,1.7417968,-0.59297231,-0.60501739,-0.53156064,1.7405699,-0.59297231,-0.60501739,-0.53156064,1.7421212,-0.59297231,-0.60501739,-0.53156064,1.7431148,-0.59298245,-0.60501739,-0.53050618,1.7440172,-0.59297231,-0.60501739,-0.53156064,1.7463492,-0.59298245,-0.60501739,-0.53156064,1.7457915,-0.59298245,-0.60501739,-0.53156064,1.7452339,-0.59298245,-0.60501739,-0.53050618,1.7446255,-0.59298245,-0.60501739,-0.53156064,1.7417765,-0.59298245,-0.60501739,-0.53156064,1.7405699,-0.59297231,-0.60501739,-0.53156064,1.7409552,-0.59297231,-0.60501739,-0.53156064,1.7412695,-0.59297231,-0.60501739,-0.53156064,1.74203,-0.59298245,-0.60501739,-0.53156064,1.7412797,-0.59297231,-0.60501739,-0.53156064,1.7447269,-0.59297231,-0.60501739,-0.53156064,1.7427397,-0.59297231,-0.60501739,-0.53156064,1.7344764,-0.59297231,-0.60501739,-0.53156064,1.7359466,-0.59297231,-0.60501739,-0.53156064,1.7335538,-0.59297231,-0.60501739,-0.53156064,1.7323878,-0.59297231,-0.60501739,-0.53156064,1.7333105,-0.59297231,-0.60501739,-0.53156064,1.7362102,-0.59297231,-0.60501739,-0.53156064,1.7355917,-0.59297231,-0.60501739,-0.53156064,1.726933,-0.59297231,-0.60501739,-0.53156064,1.7290115,-0.59297231,-0.60501739,-0.53156064,1.7285147,-0.59297231,-0.60501739,-0.53156064,1.7302181,-0.59297231,-0.60501739,-0.53156064,1.7231208,-0.59297231,-0.60501739,-0.53156064,1.7273893,-0.59297231,-0.60501739,-0.53156064,1.7262233,-0.59297231,-0.60501739,-0.53156064,1.724814,-0.59297231,-0.60501739,-0.53156064,1.6986454,-0.59296217,-0.60501739,-0.53156064,1.7260814,-0.59297231,-0.60501739,-0.53156064,1.7269128,-0.59297231,-0.60501739,-0.53156064,1.731597,-0.59297231,-0.60501739,-0.53156064,1.7291433,-0.59297231,-0.60501739,-0.53156064,1.7307047,-0.59297231,-0.60501739,-0.53156064,1.7318099,-0.59297231,-0.60501739,-0.53156064,1.7298328,-0.59297231,-0.60501739,-0.53156064,1.7287276,-0.59297231,-0.60501739,-0.53156064,1.7282511,-0.59297231,-0.60501739,-0.53156064,1.7334727,-0.59297231,-0.60501739,-0.53156064,1.7336957,-0.59298245,-0.60501739,-0.53156064,1.7338377,-0.59297231,-0.60501739,-0.53156064,1.7371633,-0.59297231,-0.60501739,-0.53156064,1.7379744,-0.59297231,-0.60501739,-0.53156064,1.7366867,-0.59298245,-0.60501739,-0.53156064,1.736413,-0.59298245,-0.60501739,-0.53156064,1.7378628,-0.59297231,-0.60501739,-0.53156064,1.7375485,-0.59298245,-0.60501739,-0.53156064,1.7379744,-0.59298245,-0.60501739,-0.53156064,1.7269837,-0.59297231,-0.60397308,-0.53156064,1.7318099,-0.59298245,-0.60501739,-0.53156064,1.7290318,-0.59298245,-0.60501739,-0.53156064,1.7291636,-0.59297231,-0.60501739,-0.53156064,1.728099,-0.59298245,-0.60397308,-0.53156064,1.7294576,-0.59298245,-0.60501739,-0.53156064,1.7284032,-0.59297231,-0.60501739,-0.53156064,1.7282714,-0.59298245,-0.60397308,-0.53156064,1.7300153,-0.59297231,-0.60501739,-0.53156064,1.7320634,-0.59297231,-0.60501739,-0.53156064,1.7325602,-0.59297231,-0.60501739,-0.53156064,1.7334828,-0.59297231,-0.60501739,-0.53156064,1.7337363,-0.59297231,-0.60397308,-0.53156064,1.7320431,-0.59297231,-0.60397308,-0.53156064,1.7316274,-0.59297231,-0.60501739,-0.53156064,1.7263348,-0.59297231,-0.60501739,-0.53156064,1.7363724,-0.59298245,-0.60397308,-0.53156064,1.7342027,-0.59298245,-0.60397308,-0.53156064,1.7333916,-0.59298245,-0.60501739,-0.53156064,1.7353585,-0.59298245,-0.60501739,-0.53156064,1.7348921,-0.59298245,-0.60397308,-0.53156064,1.7336653,-0.59298245,-0.60501739,-0.53156064,1.7334017,-0.59298245,-0.60501739,-0.53156064,1.7321647,-0.59298245,-0.60501739,-0.53156064,1.731232,-0.59298245,-0.60397308,-0.53156064,1.731455,-0.59298245,-0.60501739,-0.53156064,1.7314652,-0.59298245,-0.60397308,-0.53156064,1.7285147,-0.59298245,-0.60501739,-0.53050618,1.729995,-0.59298245,-0.60501739,-0.53050618,1.7296097,-0.59298245,-0.60501739,-0.53156064,1.7307352,-0.59298245,-0.60397308,-0.53156064,1.7290318,-0.59298245,-0.60397308,-0.53156064,1.7297821,-0.59298245,-0.60501739,-0.53156064,1.7335639,-0.59298245,-0.60501739,-0.53156064,1.7321749,-0.59298245,-0.60397308,-0.53156064,1.7312928,-0.59298245,-0.60397308,-0.53156064,1.7355714,-0.59298245,-0.60501739,-0.53156064,1.7339796,-0.59298245,-0.60397308,-0.53156064,1.7340912,-0.59298245,-0.60397308,-0.53156064,1.7343446,-0.59298245,-0.60397308,-0.53156064,1.7337059,-0.59298245,-0.60397308,-0.53156064,1.7341621,-0.59298245,-0.60501739,-0.53156064,1.734081,-0.59298245,-0.60501739,-0.53156064,1.7334625,-0.59298245,-0.60501739,-0.53156064,1.7354092,-0.59298245,-0.60501739,-0.53156064,1.7358756,-0.59298245,-0.60397308,-0.53156064,1.7354295,-0.59298245,-0.60397308,-0.53156064,1.735176,-0.59298245,-0.60397308,-0.53156064,1.7338377,-0.59299259,-0.60397308,-0.53156064,1.7314956,-0.59299259,-0.60397308,-0.53260495,1.737437,-0.59299259,-0.60397308,-0.53156064,1.7333105,-0.59298245,-0.60397308,-0.53156064,1.7358148,-0.59299259,-0.60397308,-0.53156064,1.735683,-0.59299259,-0.60397308,-0.53156064,1.7371633,-0.59298245,-0.60397308,-0.53156064,1.7369199,-0.59299259,-0.60397308,-0.53156064,1.7385624,-0.59299259,-0.60397308,-0.53156064,1.7390694,-0.59298245,-0.60397308,-0.53156064,1.7328136,-0.59298245,-0.60397308,-0.53260495,1.7341013,-0.59299259,-0.60397308,-0.53156064,1.7352064,-0.59298245,-0.60501739,-0.53156064,1.7340303,-0.59299259,-0.60397308,-0.53156064,1.7350138,-0.59298245,-0.60397308,-0.53156064,1.7338782,-0.59299259,-0.60397308,-0.53156064,1.733128,-0.59298245,-0.60397308,-0.53156064,1.7300153,-0.59299259,-0.60397308,-0.53156064,1.7312522,-0.59299259,-0.60397308,-0.53260495,1.7306642,-0.59299259,-0.60397308,-0.53156064,1.7304715,-0.59298245,-0.60501739,-0.53260495,1.731962,-0.59299259,-0.60397308,-0.53260495,1.7308061,-0.59299259,-0.60397308,-0.53260495,1.7296503,-0.59298245,-0.60397308,-0.53156064,1.7334828,-0.59298245,-0.60397308,-0.53260495,1.7308771,-0.59299259,-0.60397308,-0.53260495,1.7316375,-0.59299259,-0.60397308,-0.53260495,1.7317085,-0.59299259,-0.60397308,-0.53156064,1.7317186,-0.59299259,-0.60501739,-0.53156064,1.733858,-0.59298245,-0.60397308,-0.53156064,1.7334727,-0.59298245,-0.60397308,-0.53260495,1.7332598,-0.59299259,-0.60397308,-0.53260495,1.7266086,-0.59298245,-0.60397308,-0.53260495,1.7274501,-0.59299259,-0.60397308,-0.53260495,1.7290521,-0.59299259,-0.60397308,-0.53156064,1.7334118,-0.59299259,-0.60397308,-0.53260495,1.7349023,-0.59298245,-0.60397308,-0.53260495,1.7342534,-0.59299259,-0.60397308,-0.53260495,1.7352774,-0.59299259,-0.60397308,-0.53260495,1.7355816,-0.59299259,-0.60397308,-0.53260495,1.7357844,-0.59299259,-0.60397308,-0.53260495,1.7354701,-0.59299259,-0.60397308,-0.53260495,1.7342939,-0.59299259,-0.60397308,-0.53260495,1.7354802,-0.59299259,-0.60397308,-0.53260495,1.7358857,-0.59299259,-0.60397308,-0.53260495,1.7360885,-0.59298245,-0.60501739,-0.53260495,1.7328238,-0.59298245,-0.60501739,-0.53260495,1.733351,-0.59298245,-0.60501739,-0.53260495,1.7353991,-0.59297231,-0.60397308,-0.53260495,1.7369199,-0.59299259,-0.60501739,-0.53260495,1.737508,-0.59298245,-0.60501739,-0.53260495,1.735105,-0.59298245,-0.60397308,-0.53260495,1.7336552,-0.59298245,-0.60397308,-0.53260495,1.7332598,-0.59299259,-0.60397308,-0.53260495,1.7376905,-0.59299259,-0.60397308,-0.53260495,1.7299747,-0.59299259,-0.60501739,-0.53260495,1.7314854,-0.59298245,-0.60501739,-0.53260495,1.7344257,-0.59298245,-0.60397308,-0.53260495,1.737579,-0.59298245,-0.60501739,-0.53260495,1.7362102,-0.59298245,-0.60397308,-0.53260495,1.7368692,-0.59298245,-0.60501739,-0.53260495,1.7348313,-0.59298245,-0.60397308,-0.53260495,1.7368692,-0.59298245,-0.60501739,-0.53260495,1.735906,-0.59298245,-0.60397308,-0.53260495,1.7336045,-0.59298245,-0.60501739,-0.53260495,1.7368287,-0.59298245,-0.60397308,-0.53260495,1.7381873,-0.59298245,-0.60501739,-0.53260495,1.739992,-0.59298245,-0.60397308,-0.53260495,1.7367374,-0.59298245,-0.60397308,-0.53260495,1.7376398,-0.59299259,-0.60397308,-0.53260495,1.7346792,-0.59299259,-0.60397308,-0.53260495,1.7332699,-0.59299259,-0.60501739,-0.53260495,1.7307149,-0.59298245,-0.60397308,-0.53260495,1.7374573,-0.59299259,-0.60397308,-0.53260495,1.7368287,-0.59299259,-0.60397308,-0.53260495,1.7367678,-0.59299259,-0.60397308,-0.53260495,1.7329556,-0.59299259,-0.60397308,-0.53260495,1.7352673,-0.59299259,-0.60397308,-0.53260495,1.7363319,-0.59298245,-0.60501739,-0.53260495,1.7353281,-0.59298245,-0.60397308,-0.5336594,1.7356424,-0.59299259,-0.60397308,-0.53260495,1.7339593,-0.59298245,-0.60397308,-0.53260495,1.73328,-0.59298245,-0.60397308,-0.53260495,1.7353078,-0.59298245,-0.60397308,-0.53260495,1.7357032,-0.59298245,-0.60397308,-0.53260495,1.7352369,-0.59298245,-0.60397308,-0.5336594,1.7346285,-0.59298245,-0.60397308,-0.53260495,1.7354599,-0.59299259,-0.60397308,-0.53260495,1.7382278,-0.59299259,-0.60397308,-0.53260495,1.7337059,-0.59299259,-0.60397308,-0.5336594,1.7347603,-0.59299259,-0.60397308,-0.53260495,1.7335741,-0.59299259,-0.60397308,-0.5336594,1.7366867,-0.59300273,-0.60397308,-0.5336594,1.7353382,-0.59299259,-0.60397308,-0.5336594,1.7346589,-0.59299259,-0.60397308,-0.5336594,1.7324284,-0.59299259,-0.60397308,-0.5336594,1.7342635,-0.59299259,-0.60397308,-0.5336594,1.7350645,-0.59299259,-0.60397308,-0.53260495,1.7378121,-0.59299259,-0.60397308,-0.53260495,1.7347603,-0.59298245,-0.60397308,-0.5336594,1.7366664,-0.59299259,-0.60397308,-0.5336594,1.7372342,-0.59299259,-0.60397308,-0.5336594,1.7324588,-0.59299259,-0.60397308,-0.5336594,1.7318707,-0.59299259,-0.60397308,-0.5336594,1.7337566,-0.59299259,-0.60397308,-0.5336594,1.7356323,-0.59299259,-0.60397308,-0.5336594,1.7364535,-0.59299259,-0.60397308,-0.5336594,1.7371024,-0.59299259,-0.60397308,-0.5336594,1.7338073,-0.59299259,-0.60397308,-0.5336594,1.7355613,-0.59299259,-0.60397308,-0.5336594,1.7305831,-0.59299259,-0.60397308,-0.5336594,1.7336856,-0.59299259,-0.60397308,-0.5336594,1.7317896,-0.59299259,-0.60397308,-0.5336594,1.727511,-0.59299259,-0.60397308,-0.5336594,1.7291231,-0.59300273,-0.60397308,-0.5336594,1.7318403,-0.59299259,-0.60397308,-0.5336594,1.7284336,-0.59299259,-0.60397308,-0.5336594,1.7226443,-0.59299259,-0.60397308,-0.5336594,1.7261523,-0.59299259,-0.60397308,-0.5336594,1.725838,-0.59298245,-0.60397308,-0.5336594,1.72671,-0.59299259,-0.60397308,-0.5336594,1.7241144,-0.59299259,-0.60397308,-0.5336594,1.7146142,-0.59299259,-0.60397308,-0.5336594,1.7104877,-0.59299259,-0.60397308,-0.53470371,1.7096157,-0.59299259,-0.60397308,-0.5336594,1.7152428,-0.59299259,-0.60397308,-0.5336594,1.7098895,-0.59299259,-0.60397308,-0.53470371,1.7106499,-0.59300273,-0.60397308,-0.53470371,1.7174835,-0.59299259,-0.60397308,-0.53470371,1.7160134,-0.59299259,-0.60397308,-0.53470371,1.7089972,-0.59299259,-0.60397308,-0.53470371,1.716936,-0.59299259,-0.60397308,-0.53470371,1.71431,-0.59300273,-0.60397308,-0.53470371,1.7217825,-0.59300273,-0.60397308,-0.53470371,1.7195113,-0.59299259,-0.60397308,-0.53470371,1.7195519,-0.59300273,-0.60397308,-0.53470371,1.7259496,-0.59299259,-0.60397308,-0.53470371,1.716713,-0.59300273,-0.60397308,-0.53470371,1.719126,-0.59300273,-0.60397308,-0.53470371,1.7247937,-0.59299259,-0.60397308,-0.53470371,1.7191058,-0.59300273,-0.60397308,-0.53470371,1.7223502,-0.59300273,-0.60397308,-0.53470371,1.7237494,-0.59300273,-0.60397308,-0.53470371,1.7234757,-0.59300273,-0.60397308,-0.53470371,1.7313232,-0.59300273,-0.60397308,-0.53470371,1.7287479,-0.59300273,-0.60397308,-0.53470371,1.7297111,-0.59300273,-0.60397308,-0.53470371,1.7265985,-0.59300273,-0.60397308,-0.53575817,1.7257062,-0.59301287,-0.60397308,-0.53470371,1.7317491,-0.59300273,-0.60397308,-0.53575817,1.7278557,-0.59300273,-0.60397308,-0.53470371,1.7271054,-0.59300273,-0.60397308,-0.53470371,1.7250371,-0.59300273,-0.60397308,-0.53470371,1.725909,-0.59300273,-0.60397308,-0.53575817,1.7285553,-0.59301287,-0.60397308,-0.53575817,1.7304513,-0.59301287,-0.60397308,-0.53575817,1.7229484,-0.59300273,-0.60397308,-0.53575817,1.7205354,-0.59301287,-0.60397308,-0.53575817,1.7248444,-0.59301287,-0.60397308,-0.53575817,1.7234452,-0.59300273,-0.60397308,-0.53575817,1.7225834,-0.59300273,-0.60397308,-0.53575817,1.72233,-0.59301287,-0.60397308,-0.53575817,1.7196431,-0.59301287,-0.60397308,-0.53575817,1.7147764,-0.59301287,-0.60397308,-0.53575817,1.7223401,-0.59301287,-0.60397308,-0.53575817,1.7188929,-0.59301287,-0.60291863,-0.53575817,1.7156788,-0.59301287,-0.60291863,-0.53575817,1.7173517,-0.59301287,-0.60397308,-0.53575817,1.7183149,-0.59300273,-0.60291863,-0.53680248,1.7241043,-0.59301287,-0.60291863,-0.53680248,1.719268,-0.59301287,-0.60291863,-0.53680248,1.7235771,-0.59301287,-0.60291863,-0.53680248,1.7245909,-0.59301287,-0.60291863,-0.53785693,1.7227051,-0.59302301,-0.60291863,-0.53785693,1.7229079,-0.59302301,-0.60291863,-0.53785693,1.7174531,-0.59303315,-0.60291863,-0.53890124,1.7206266,-0.59303315,-0.60291863,-0.53890124,1.7229079,-0.59303315,-0.60291863,-0.53890124,1.7215188,-0.59303315,-0.60187432,-0.53995569,1.7169158,-0.59304328,-0.60187432,-0.53995569,1.7209105,-0.59304328,-0.60187432,-0.53995569,1.7203731,-0.59304328,-0.60187432,-0.54100001,1.7206469,-0.59304328,-0.60187432,-0.54100001,1.7201298,-0.59305342,-0.60187432,-0.54100001,1.7201298,-0.59305342,-0.60187432,-0.54205446,1.7240232,-0.59305342,-0.60187432,-0.54205446,1.7222894,-0.59305342,-0.60187432,-0.54205446,1.7239522,-0.59306356,-0.60187432,-0.54205446,1.7193897,-0.59306356,-0.60187432,-0.54310891,1.7231512,-0.5930737,-0.60187432,-0.54310891,1.7200588,-0.5930737,-0.60081987,-0.54415322,1.7204543,-0.5930737,-0.60081987,-0.54415322,1.7172808,-0.5930737,-0.60081987,-0.54415322,1.7090581,-0.59308384,-0.60081987,-0.54520768,1.7182135,-0.59308384,-0.60081987,-0.54520768,1.718538,-0.59308384,-0.60081987,-0.54520768,1.721022,-0.59309398,-0.60081987,-0.54520768,1.7192376,-0.59309398,-0.60081987,-0.54625199,1.7192072,-0.59310412,-0.60081987,-0.54625199,1.7180615,-0.59310412,-0.59977555,-0.54625199,1.7216202,-0.59310412,-0.59977555,-0.54730644,1.7187205,-0.59311426,-0.59977555,-0.54730644,1.7196837,-0.59311426,-0.59977555,-0.54730644,1.718974,-0.59311426,-0.59977555,-0.54835075,1.719927,-0.59311426,-0.60187432,-0.54205446,1.7202211,-0.59306356,-0.59977555,-0.54835075,1.7132252,-0.5931244,-0.59977555,-0.54835075,1.7141985,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244,-0.59977555,-0.5494052,1.7153746,-0.5931244:9
-0.58151211,-0.58151211,1.7318943,-0.58151211,-0.58151211,-0.58151211,1.7334786,-0.58151211,-0.58997501,-0.52755603,1.7376487,-0.58109305,-0.58574356,-0.53919762,1.7380882,-0.58120548,-0.58574356,-0.54131335,1.7333662,-0.58122592,-0.58997501,-0.52437733,1.7352264,-0.58107261,-0.58891203,-0.52967175,1.7354717,-0.58112371,-0.58997501,-0.52649306,1.7392227,-0.58109305,-0.58785928,-0.52967175,1.7387219,-0.58112371,-0.58891203,-0.52755603,1.7383642,-0.58109305,-0.58785928,-0.53073473,1.7391001,-0.58113394,-0.58679631,-0.5370819,1.7384562,-0.58118504,-0.58997501,-0.52649306,1.7359725,-0.58108283,-0.58891203,-0.52967175,1.7434235,-0.58111349,-0.58785928,-0.53073473,1.7387015,-0.58112371,-0.58891203,-0.52755603,1.7344393,-0.58110327,-0.58785928,-0.53285045,1.7341225,-0.58114416,-0.58679631,-0.5370819,1.7358192,-0.58118504,-0.58574356,-0.53813465,1.7390387,-0.58119526,-0.58785928,-0.53178748,1.7440776,-0.58113394,-0.58679631,-0.53601893,1.7373114,-0.58117482,-0.58574356,-0.53813465,1.7399075,-0.58119526,-0.58574356,-0.53919762,1.7366777,-0.58120548,-0.58468058,-0.5423661,1.7399382,-0.58122592,-0.58362783,-0.54766052,1.738773,-0.58126681,-0.58362783,-0.54766052,1.7331004,-0.58126681,-0.58362783,-0.54766052,1.7335808,-0.58127703,-0.58362783,-0.54766052,1.7361258,-0.58127703,-0.58362783,-0.54766052,1.7364631,-0.58127703,-0.58362783,-0.54871327,1.7332946,-0.58127703,-0.58362783,-0.54871327,1.7328551,-0.58127703,-0.58362783,-0.54871327,1.7338363,-0.58127703,-0.58362783,-0.54871327,1.7406945,-0.58127703,-0.58362783,-0.54871327,1.7422174,-0.58127703,-0.58362783,-0.54977624,1.7330595,-0.58128725,-0.58362783,-0.54977624,1.7300341,-0.58128725,-0.58362783,-0.54977624,1.7345416,-0.58128725,-0.58362783,-0.54977624,1.7349299,-0.58128725,-0.58362783,-0.550829,1.7347153,-0.58128725,-0.58256486,-0.550829,1.7334377,-0.58129747,-0.58362783,-0.550829,1.7345722,-0.58129747,-0.58362783,-0.550829,1.7403572,-0.58129747,-0.58256486,-0.550829,1.7389161,-0.58129747,-0.58256486,-0.550829,1.7370763,-0.58129747,-0.58256486,-0.55189197,1.7290529,-0.58129747,-0.58256486,-0.55189197,1.7364631,-0.58129747,-0.58256486,-0.55189197,1.7425547,-0.58130769,-0.58256486,-0.55189197,1.7397235,-0.58130769,-0.58256486,-0.55294472,1.7327529,-0.58130769,-0.58256486,-0.55294472,1.7362178,-0.58130769,-0.58256486,-0.55294472,1.7367186,-0.58130769,-0.58256486,-0.55294472,1.7370048,-0.58130769,-0.58256486,-0.55400769,1.7358192,-0.58131791,-0.58256486,-0.55400769,1.7351446,-0.58131791,-0.58256486,-0.55400769,1.7355228,-0.58131791,-0.58256486,-0.55400769,1.7383028,-0.58131791,-0.58256486,-0.55506044,1.7332537,-0.58131791,-0.58256486,-0.55506044,1.7330493,-0.58132813,-0.58256486,-0.55506044,1.7338159,-0.58132813,-0.58256486,-0.55506044,1.7392636,-0.58132813,-0.58256486,-0.55506044,1.7398155,-0.58132813,-0.58151211,-0.55612342,1.7355534,-0.58132813,-0.58256486,-0.55612342,1.7363302,-0.58132813,-0.58256486,-0.55612342,1.7395498,-0.58132813,-0.58151211,-0.55612342,1.7362382,-0.58132813,-0.58151211,-0.55612342,1.7366777,-0.58133835,-0.58151211,-0.55718639,1.7354308,-0.58133835,-0.58151211,-0.55718639,1.7368413,-0.58133835,-0.58151211,-0.55718639,1.7394067,-0.58133835,-0.58151211,-0.55718639,1.7332844,-0.58133835,-0.58151211,-0.55718639,1.738497,-0.58133835,-0.58151211,-0.55823914,1.7394169,-0.58133835,-0.58151211,-0.55718639,1.7393045,-0.58133835,-0.58151211,-0.55823914,1.7359623,-0.58133835,-0.58151211,-0.55823914,1.739744,-0.58134857,-0.58151211,-0.55823914,1.7396316,-0.58134857,-0.58151211,-0.55823914,1.7342554,-0.58134857,-0.58151211,-0.55930211,1.7347358,-0.58134857,-0.58151211,-0.55930211,1.7404594,-0.58134857,-0.58151211,-0.55930211,1.7373114,-0.58135879,-0.58151211,-0.55930211,1.7352468,-0.58135879,-0.58151211,-0.55930211,1.7408785,-0.58135879,-0.58151211,-0.55930211,1.7391614,-0.58135879,-0.58151211,-0.55930211,1.7374034,-0.58135879,-0.58151211,-0.55930211,1.7407967,-0.58135879,-0.58151211,-0.56035487,1.7385175,-0.58135879,-0.58151211,-0.56035487,1.7411954,-0.58135879,-0.58151211,-0.56035487,1.7442923,-0.58135879,-0.58151211,-0.56035487,1.7415735,-0.58135879,-0.58151211,-0.56035487,1.7384255,-0.58136902,-0.58151211,-0.56141784,1.7428,-0.58136902,-0.58151211,-0.56035487,1.7431067,-0.58136902,-0.58151211,-0.56141784,1.7386401,-0.58136902,-0.58151211,-0.56141784,1.7386912,-0.58136902,-0.58151211,-0.56141784,1.739744,-0.58136902,-0.58151211,-0.56141784,1.7452939,-0.58136902,-0.58151211,-0.56141784,1.7395293,-0.58136902,-0.58151211,-0.56141784,1.7407661,-0.58136902,-0.58151211,-0.56141784,1.7395191,-0.58136902,-0.58151211,-0.56141784,1.7437506,-0.58136902,-0.58151211,-0.56141784,1.7476141,-0.58136902,-0.58151211,-0.56141784,1.7441492,-0.58136902,-0.58151211,-0.56141784,1.7447011,-0.58136902,-0.58151211,-0.56141784,1.7463773,-0.58137924,-0.58151211,-0.56141784,1.7491779,-0.58137924,-0.58151211,-0.56247059,1.7456925,-0.58137924,-0.58151211,-0.56247059,1.7472155,-0.58137924,-0.58151211,-0.56247059,1.7503328,-0.58137924,-0.58151211,-0.56247059,1.750895,-0.58137924,-0.58151211,-0.56247059,1.7524179,-0.58137924,-0.58151211,-0.56247059,1.7499138,-0.58137924,-0.58151211,-0.56247059,1.7504657,-0.58137924,-0.58151211,-0.56247059,1.7480945,-0.58137924,-0.58151211,-0.56247059,1.7500262,-0.58137924,-0.58151211,-0.56247059,1.7460401,-0.58137924,-0.58151211,-0.56247059,1.7446602,-0.58137924,-0.58151211,-0.56353356,1.7450282,-0.58137924,-0.58151211,-0.56247059,1.7481149,-0.58137924,-0.58151211,-0.56247059,1.7462445,-0.58138946,-0.58151211,-0.56353356,1.7445989,-0.58138946,-0.58151211,-0.56353356,1.7451304,-0.58138946,-0.58151211,-0.56353356,1.7453348,-0.58138946,-0.58151211,-0.56353356,1.747379,-0.58138946,-0.58151211,-0.56353356,1.7476039,-0.58138946,-0.58151211,-0.56353356,1.7425445,-0.58138946,-0.58151211,-0.56247059,1.7420539,-0.58138946,-0.58151211,-0.56353356,1.744139,-0.58138946,-0.58151211,-0.56353356,1.7445887,-0.58138946,-0.58151211,-0.56353356,1.7400506,-0.58138946,-0.58151211,-0.56353356,1.7419721,-0.58138946,-0.58151211,-0.56458631,1.7408887,-0.58138946,-0.58151211,-0.56353356,1.7402857,-0.58138946,-0.58151211,-0.56458631,1.7417575,-0.58138946,-0.58151211,-0.56458631,1.7417166,-0.58138946,-0.58151211,-0.56458631,1.7428409,-0.58139968,-0.58151211,-0.56458631,1.7394169,-0.58139968,-0.58151211,-0.56458631,1.7391818,-0.58139968,-0.58151211,-0.56458631,1.7427285,-0.58139968,-0.58151211,-0.56458631,1.7411647,-0.58139968,-0.58151211,-0.56458631,1.7383437,-0.58139968,-0.58151211,-0.56458631,1.7375261,-0.58139968,-0.58151211,-0.56458631,1.7410216,-0.58139968,-0.58151211,-0.56458631,1.7407865,-0.58139968,-0.58151211,-0.56458631,1.7393556,-0.58139968,-0.58151211,-0.56458631,1.7393147,-0.58139968,-0.58151211,-0.56458631,1.7394169,-0.58139968,-0.58151211,-0.56564929,1.7407252,-0.58139968,-0.58151211,-0.56564929,1.7404288,-0.58139968,-0.58151211,-0.56564929,1.7401528,-0.58139968,-0.58151211,-0.56564929,1.7405719,-0.58139968,-0.58151211,-0.56564929,1.7408274,-0.58139968,-0.58151211,-0.56564929,1.736923,-0.58139968,-0.58151211,-0.56564929,1.7400302,-0.58139968,-0.58151211,-0.56564929,1.7250872,-0.58139968,-0.58151211,-0.56564929,1.7317819,-0.5814099,-0.58151211,-0.56564929,1.7293187,-0.5814099,-0.58151211,-0.56564929,1.7290836,-0.5814099,-0.58151211,-0.56564929,1.7285623,-0.5814099,-0.58151211,-0.56564929,1.7286237,-0.5814099,-0.58151211,-0.56564929,1.7275198,-0.5814099,-0.58151211,-0.56564929,1.7272234,-0.58145078,-0.58151211,-0.56670204,1.7249441,-0.58145078,-0.58151211,-0.56670204,1.7257414,-0.58145078,-0.58151211,-0.56670204,1.7286339,-0.58145078,-0.58151211,-0.56670204,1.7253632,-0.58145078,-0.58151211,-0.56670204,1.7257516,-0.58144056,-0.58151211,-0.56670204,1.7224298,-0.58145078,-0.58151211,-0.56670204,1.7225831,-0.58145078,-0.58151211,-0.56670204,1.7241162,-0.58145078,-0.58151211,-0.56670204,1.7262626,-0.58145078,-0.58151211,-0.56670204,1.7346029,-0.58145078,-0.58151211,-0.56670204,1.7282761,-0.58145078,-0.58151211,-0.56670204,1.7240549,-0.58145078,-0.58151211,-0.56670204,1.7225013,-0.58145078,-0.58151211,-0.56670204,1.7259458,-0.58145078,-0.58151211,-0.56670204,1.7249135,-0.58145078,-0.58151211,-0.56670204,1.7230022,-0.58145078,-0.58151211,-0.56776501,1.7259049,-0.58145078,-0.58151211,-0.56670204,1.7262422,-0.58145078,-0.58151211,-0.56776501,1.725353,-0.58145078,-0.58151211,-0.56776501,1.7201914,-0.58145078,-0.58151211,-0.56670204,1.722256,-0.58145078,-0.58151211,-0.56776501,1.7241674,-0.58145078,-0.58151211,-0.56458631,1.7238914,-0.58139968,-0.58151211,-0.56670204,1.7251077,-0.58145078,-0.58151211,-0.56670204,1.7210704,-0.5814099,-0.58151211,-0.56776501,1.7214895,-0.58145078,-0.58151211,-0.56776501,1.7247295,-0.58145078,-0.58151211,-0.56776501,1.7232884,-0.58145078,-0.58151211,-0.56776501,1.7248726,-0.58145078,-0.58151211,-0.56776501,1.7220312,-0.58145078,-0.58151211,-0.56776501,1.7270599,-0.58145078,-0.58151211,-0.56776501,1.7306576,-0.58145078,-0.58151211,-0.56776501,1.7357681,-0.58145078,-0.58151211,-0.56776501,1.7317615,-0.581461,-0.58151211,-0.56776501,1.7293493,-0.58145078,-0.58151211,-0.56564929,1.731046,-0.58139968,-0.58151211,-0.56776501,1.7306065,-0.58145078,-0.58151211,-0.56776501,1.7287668,-0.581461,-0.58151211,-0.56881776,1.7295129,-0.58145078,-0.58151211,-0.56881776,1.7296764,-0.581461,-0.58151211,-0.56881776,1.729288,-0.581461,-0.58151211,-0.58151211,1.7277549,-0.58151211,-0.58151211,-0.58151211,1.7289201,-0.58151211,-0.58151211,-0.56881776,1.7305758,-0.581461,-0.58151211,-0.58151211,1.7313731,-0.58151211,-0.58151211,-0.58151211,1.7310869,-0.58151211,-0.58151211,-0.58151211,1.7309029,-0.58151211,-0.58151211,-0.58151211,1.7337239,-0.58151211,-0.58151211,-0.56881776,1.7324667,-0.58151211,-0.58151211,-0.58151211,1.7320579,-0.58151211,-0.58151211,-0.58151211,1.7394067,-0.58151211,-0.58151211,-0.58151211,1.7318841,-0.58151211,-0.58151211,-0.58151211,1.7317921,-0.58151211,-0.58151211,-0.58151211,1.7267124,-0.58151211,-0.58151211,-0.58151211,1.7272847,-0.58151211,-0.58151211,-0.58151211,1.7249237,-0.58151211,-0.58151211,-0.58151211,1.7243309,-0.58151211,-0.58151211,-0.58151211,1.7257311,-0.58151211,-0.58151211,-0.58151211,1.7250463,-0.58151211,-0.58151211,-0.58151211,1.7258129,-0.58151211,-0.58151211,-0.58151211,1.7241674,-0.58151211,-0.58151211,-0.58151211,1.7218165,-0.58151211,-0.58151211,-0.58151211,1.7219699,-0.58151211,-0.58151211,-0.58151211,1.7202323,-0.58151211,-0.58151211,-0.58151211,1.7225116,-0.58151211,-0.58151211,-0.58151211,1.7216939,-0.58151211,-0.58151211,-0.58151211,1.7220721,-0.58151211,-0.58151211,-0.58151211,1.7209478,-0.58151211,-0.58151211,-0.58151211,1.7217041,-0.58151211,-0.58151211,-0.58151211,1.722532,-0.58151211,-0.58151211,-0.58151211,1.7221641,-0.58151211,-0.58151211,-0.58151211,1.7251179,-0.58151211,-0.58151211,-0.58151211,1.7246171,-0.58151211,-0.58151211,-0.58151211,1.7256698,-0.58151211,-0.58151211,-0.58151211,1.7253734,-0.58151211,-0.58151211,-0.58151211,1.7261502,-0.58151211,-0.58151211,-0.58151211,1.7260684,-0.58151211,-0.58151211,-0.58151211,1.7284703,-0.58151211,-0.58151211,-0.58151211,1.729288,-0.58151211,-0.58151211,-0.58151211,1.7286748,-0.58151211,-0.58151211,-0.58151211,1.7359009,-0.58151211,-0.58151211,-0.58151211,1.7341429,-0.58151211,-0.58151211,-0.58151211,1.7328551,-0.58151211,-0.58151211,-0.58151211,1.7330391,-0.58151211,-0.58151211,-0.58151211,1.7349402,-0.58151211,-0.58151211,-0.58151211,1.7326609,-0.58151211,-0.58151211,-0.58151211,1.7330391,-0.58151211,-0.58151211,-0.58151211,1.7316286,-0.58151211,-0.58151211,-0.58151211,1.7328858,-0.58151211,-0.58151211,-0.58151211,1.7313731,-0.58151211,-0.58151211,-0.58151211,1.7241162,-0.58151211,-0.58151211,-0.58151211,1.7371683,-0.58151211,-0.58151211,-0.58151211,1.7266306,-0.58151211,-0.58151211,-0.58151211,1.731925,-0.58151211,-0.58151211,-0.58151211,1.7266408,-0.58151211,-0.58151211,-0.58151211,1.7255676,-0.58151211,-0.58151211,-0.58151211,1.724198,-0.58151211,-0.58151211,-0.58151211,1.7256187,-0.58151211,-0.58151211,-0.58151211,1.7262626,-0.58151211,-0.58151211,-0.58151211,1.7268248,-0.58151211,-0.58151211,-0.58151211,1.7298399,-0.58151211,-0.58151211,-0.58151211,1.729196,-0.58151211,-0.58151211,-0.58151211,1.7310971,-0.58151211,-0.58151211,-0.58151211,1.7323645,-0.58151211,-0.58151211,-0.58151211,1.7337034,-0.58151211,-0.58151211,-0.58151211,1.7312198,-0.58151211,-0.58151211,-0.58151211,1.7308825,-0.58151211,-0.58151211,-0.58151211,1.7333866,-0.58151211,-0.58151211,-0.58151211,1.7322112,-0.58151211,-0.58151211,-0.58151211,1.7318432,-0.58151211,-0.58151211,-0.58151211,1.7317921,-0.58151211,-0.58151211,-0.58151211,1.7316286,-0.58151211,-0.58151211,-0.58151211,1.7304021,-0.58151211,-0.58151211,-0.58151211,1.7271212,-0.58151211,-0.58151211,-0.58151211,1.7288179,-0.58151211,-0.58151211,-0.58151211,1.7297684,-0.58151211,-0.58151211,-0.58151211,1.7286339,-0.58151211,-0.58151211,-0.58151211,1.7303919,-0.58151211,-0.58151211,-0.58151211,1.7309745,-0.58151211,-0.58151211,-0.58151211,1.7316388,-0.58151211,-0.58151211,-0.58151211,1.7333866,-0.58151211,-0.58151211,-0.58151211,1.7318126,-0.58151211,-0.58151211,-0.58151211,1.7324258,-0.58151211,-0.58151211,-0.58151211,1.7327427,-0.58151211,-0.58151211,-0.58151211,1.7317104,-0.58151211,-0.58151211,-0.58151211,1.7337443,-0.58151211,-0.58151211,-0.58151211,1.7336012,-0.58151211,-0.58151211,-0.58151211,1.7341532,-0.58151211,-0.58151211,-0.58151211,1.7333048,-0.58151211,-0.58151211,-0.58151211,1.733683,-0.58151211,-0.58151211,-0.58151211,1.7339487,-0.58151211,-0.58151211,-0.58151211,1.7336523,-0.58151211,-0.58151211,-0.58151211,1.7345824,-0.58151211,-0.58151211,-0.58151211,1.7401733,-0.58151211,-0.58151211,-0.58151211,1.7317615,-0.58151211,-0.58151211,-0.58151211,1.7334275,-0.58151211,-0.58151211,-0.58151211,1.7345416,-0.58151211,-0.58151211,-0.58151211,1.7371785,-0.58151211,-0.58151211,-0.58151211,1.735073,-0.58151211,-0.58151211,-0.58151211,1.7355943,-0.58151211,-0.58151211,-0.58151211,1.7364324,-0.58151211,-0.58151211,-0.58151211,1.7338976,-0.58151211,-0.58151211,-0.58151211,1.736412,-0.58151211,-0.58151211,-0.58151211,1.7318024,-0.58151211,-0.58151211,-0.58151211,1.7326098,-0.58151211,-0.58151211,-0.58151211,1.7342451,-0.58151211,-0.58151211,-0.58151211,1.7296662,-0.58151211,-0.58151211,-0.58151211,1.7312095,-0.58151211,-0.58151211,-0.58151211,1.7296355,-0.58151211,-0.58151211,-0.58151211,1.7302692,-0.58151211,-0.58151211,-0.58151211,1.7290121,-0.58151211,-0.58151211,-0.58151211,1.736504,-0.58151211,-0.58151211,-0.58151211,1.7275096,-0.58151211,-0.58151211,-0.58151211,1.7362484,-0.58151211,-0.58151211,-0.58151211,1.7301466,-0.58151211,-0.58151211,-0.58151211,1.728225,-0.58151211,-0.58151211,-0.58151211,1.729196,-0.58151211,-0.58151211,-0.58151211,1.7274278,-0.58151211,-0.58151211,-0.58151211,1.7223889,-0.58151211,-0.58151211,-0.58151211,1.7197621,-0.58151211,-0.58151211,-0.58151211,1.7199972,-0.58151211,-0.58151211,-0.58151211,1.7230124,-0.58151211,-0.58151211,-0.58151211,1.723227,-0.58151211,-0.58151211,-0.58151211,1.7236154,-0.58151211,-0.58151211,-0.58151211,1.7244638,-0.58151211,-0.58151211,-0.58151211,1.7217041,-0.58151211,-0.58151211,-0.58151211,1.7225831,-0.58151211,-0.58151211,-0.58151211,1.7243207,-0.58151211,-0.58151211,-0.58151211,1.7230226,-0.58151211,-0.58151211,-0.58151211,1.7235132,-0.58151211,-0.58151211,-0.58151211,1.7220005,-0.58151211,-0.58151211,-0.58151211,1.7227262,-0.58151211,-0.58151211,-0.58151211,1.7218881,-0.58151211,-0.58151211,-0.58151211,1.7225422,-0.58151211,-0.58151211,-0.58151211,1.718597,-0.58151211,-0.58151211,-0.58151211,1.7147335,-0.58151211,-0.58151211,-0.58151211,1.7194453,-0.58151211,-0.58151211,-0.58151211,1.7196191,-0.58151211,-0.58151211,-0.58151211,1.7181268,-0.58151211,-0.58151211,-0.58151211,1.714897,-0.58151211,-0.58151211,-0.58151211,1.7151014,-0.58151211,-0.58151211,-0.58151211,1.7131799,-0.58151211,-0.58151211,-0.58151211,1.7171047,-0.58151211,-0.58151211,-0.58151211,1.7115446,-0.58151211,-0.58151211,-0.58151211,1.7157045,-0.58151211,-0.58151211,-0.58151211,1.7131083,-0.58151211,-0.58151211,-0.58151211,1.7125666,-0.58151211,-0.58151211,-0.58151211,1.710175,-0.58151211,-0.58151211,-0.58151211,1.7130368,-0.58151211,-0.58151211,-0.58151211,1.7109722,-0.58151211,-0.58151211,-0.58151211,1.7131901,-0.58151211,-0.58151211,-0.58151211,1.7133945,-0.58151211,-0.58151211,-0.58151211,1.713834,-0.58151211,-0.58151211,-0.58151211,1.7126484,-0.58151211,-0.58151211,-0.58151211,1.7196599,-0.58151211,-0.58151211,-0.58151211,1.7143042,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211,-0.58151211,-0.58151211,1.7126893,-0.58151211:9
-0.59150057,-0.59150057,1.716297,-0.59150057,-0.5843259,-0.57508999,1.7161682,-0.58953844,-0.59150057,-0.59150057,1.7161385,-0.59150057,-0.59150057,-0.5668847,1.7169015,-0.59131229,-0.59047987,-0.57201796,1.7187348,-0.59134202,-0.59047987,-0.57406929,1.7201718,-0.59136184,-0.59047987,-0.57714132,1.7208357,-0.59138166,-0.59047987,-0.57714132,1.7233726,-0.59139157,-0.59047987,-0.57714132,1.7210934,-0.59138166,-0.59047987,-0.57817193,1.7208357,-0.59139157,-0.59047987,-0.57714132,1.7206375,-0.59138166,-0.59047987,-0.57714132,1.7210835,-0.59138166,-0.59047987,-0.57714132,1.7212321,-0.59138166,-0.59047987,-0.57714132,1.7210438,-0.59138166,-0.59047987,-0.57714132,1.7224312,-0.59138166,-0.59047987,-0.57714132,1.7217078,-0.59138166,-0.59047987,-0.57714132,1.7194682,-0.59139157,-0.59047987,-0.57817193,1.7210141,-0.59139157,-0.59047987,-0.57714132,1.7222528,-0.59138166,-0.59047987,-0.57714132,1.7216582,-0.59138166,-0.59047987,-0.57714132,1.7221438,-0.59138166,-0.59047987,-0.57714132,1.7225798,-0.59138166,-0.59047987,-0.57817193,1.7234222,-0.59138166,-0.59047987,-0.57714132,1.722778,-0.59138166,-0.59047987,-0.57714132,1.7230753,-0.59139157,-0.59047987,-0.57714132,1.7241159,-0.59139157,-0.59047987,-0.57714132,1.7236005,-0.59139157,-0.59047987,-0.57817193,1.7235014,-0.59139157,-0.59047987,-0.57714132,1.7250573,-0.59138166,-0.59047987,-0.57714132,1.7244528,-0.59138166,-0.59047987,-0.57714132,1.7234123,-0.59139157,-0.59047987,-0.57714132,1.723987,-0.59138166,-0.59047987,-0.57714132,1.7236996,-0.59138166,-0.59047987,-0.57817193,1.7226492,-0.59138166,-0.59047987,-0.57714132,1.7227979,-0.59139157,-0.59047987,-0.57714132,1.7213015,-0.59139157,-0.5945726,-0.54432015,1.7222033,-0.59115373,-0.59560322,-0.54432015,1.7175754,-0.59113391,-0.59560322,-0.54328953,1.7179718,-0.59113391,-0.59560322,-0.54328953,1.7189727,-0.59113391,-0.59560322,-0.54328953,1.7189231,-0.59113391,-0.59560322,-0.54226883,1.7189925,-0.59113391,-0.59560322,-0.54226883,1.7171295,-0.591124,-0.59560322,-0.54226883,1.7192402,-0.591124,-0.59560322,-0.54226883,1.7200429,-0.591124,-0.59560322,-0.54226883,1.7204393,-0.591124,-0.59560322,-0.54123821,1.7202114,-0.591124,-0.59560322,-0.54123821,1.718933,-0.591124,-0.59560322,-0.54123821,1.7197456,-0.59111409,-0.59560322,-0.54123821,1.7195276,-0.59111409,-0.59560322,-0.54123821,1.719161,-0.59111409,-0.59560322,-0.54123821,1.7183484,-0.591124,-0.59560322,-0.54123821,1.7199835,-0.591124,-0.59560322,-0.54123821,1.7213015,-0.59111409,-0.59560322,-0.54123821,1.7198844,-0.59111409,-0.59560322,-0.54123821,1.7229465,-0.59111409,-0.59560322,-0.54020759,1.7238978,-0.59111409,-0.59560322,-0.54020759,1.7232537,-0.59111409,-0.59560322,-0.54020759,1.7245122,-0.59111409,-0.59560322,-0.54020759,1.7260978,-0.59110418,-0.59560322,-0.54020759,1.7268113,-0.59110418,-0.59560322,-0.54020759,1.7259987,-0.59111409,-0.59560322,-0.54020759,1.7254834,-0.59111409,-0.59560322,-0.54020759,1.7232339,-0.59110418,-0.59560322,-0.54020759,1.7231645,-0.59110418,-0.59560322,-0.54020759,1.7227384,-0.59111409,-0.59560322,-0.54020759,1.726078,-0.59111409,-0.59560322,-0.54020759,1.7267122,-0.59111409,-0.59560322,-0.54020759,1.7249285,-0.59111409,-0.59560322,-0.54020759,1.7280401,-0.59111409,-0.59560322,-0.54020759,1.7264447,-0.59111409,-0.59560322,-0.54020759,1.7257311,-0.59110418,-0.59560322,-0.54020759,1.7268906,-0.59111409,-0.59560322,-0.54020759,1.7270888,-0.59110418,-0.59560322,-0.54020759,1.7240068,-0.59110418,-0.59560322,-0.54020759,1.7248591,-0.59111409,-0.59560322,-0.54020759,1.7227483,-0.59110418,-0.59560322,-0.54020759,1.7223816,-0.59111409,-0.59560322,-0.54020759,1.7224907,-0.59110418,-0.59560322,-0.54020759,1.7233825,-0.59110418,-0.59560322,-0.54020759,1.7237393,-0.59111409,-0.59560322,-0.54020759,1.7227285,-0.59110418,-0.59560322,-0.54020759,1.7199538,-0.59110418,-0.59662393,-0.54020759,1.7205483,-0.59110418,-0.59560322,-0.54020759,1.7190817,-0.59110418,-0.59560322,-0.54020759,1.7198646,-0.59110418,-0.59560322,-0.54020759,1.7192799,-0.59110418,-0.59560322,-0.54020759,1.7212024,-0.59111409,-0.59560322,-0.54020759,1.7201222,-0.59110418,-0.59560322,-0.54020759,1.722669,-0.59111409,-0.59560322,-0.54020759,1.720697,-0.59111409,-0.59560322,-0.54020759,1.7211429,-0.59110418,-0.59560322,-0.54020759,1.7218465,-0.59110418,-0.59560322,-0.54020759,1.7219456,-0.59111409,-0.59560322,-0.54020759,1.7232735,-0.59111409,-0.59560322,-0.54020759,1.7214402,-0.59110418,-0.59560322,-0.54020759,1.7219654,-0.59110418,-0.59560322,-0.54020759,1.7212519,-0.59111409,-0.59560322,-0.54020759,1.721688,-0.59110418,-0.59560322,-0.54020759,1.7204591,-0.59111409,-0.59560322,-0.54020759,1.7209546,-0.59111409,-0.59560322,-0.54020759,1.7243537,-0.59110418,-0.59560322,-0.54020759,1.7239771,-0.59110418,-0.59560322,-0.54020759,1.7270987,-0.59110418,-0.59560322,-0.54020759,1.7263555,-0.59111409,-0.59560322,-0.54020759,1.728278,-0.59111409,-0.59662393,-0.54020759,1.7266428,-0.59110418,-0.59560322,-0.54020759,1.727614,-0.59110418,-0.59560322,-0.54020759,1.7281095,-0.59111409,-0.59662393,-0.54020759,1.7263555,-0.59110418,-0.59560322,-0.54020759,1.7271482,-0.59110418,-0.59560322,-0.54020759,1.7285852,-0.59110418,-0.59560322,-0.54020759,1.7282284,-0.59110418,-0.59560322,-0.54020759,1.7316076,-0.59110418,-0.59560322,-0.54020759,1.7356013,-0.59110418,-0.59560322,-0.53918689,1.7363346,-0.59110418,-0.59560322,-0.53918689,1.7361265,-0.59109427,-0.59560322,-0.54020759,1.7355022,-0.59110418,-0.59560322,-0.54020759,1.7336689,-0.59110418,-0.59560322,-0.54020759,1.7303293,-0.59110418,-0.59560322,-0.54020759,1.7307752,-0.59110418,-0.59560322,-0.54020759,1.7305869,-0.59111409,-0.59560322,-0.54020759,1.730577,-0.59111409,-0.59560322,-0.54020759,1.732559,-0.59110418,-0.59560322,-0.54020759,1.7297248,-0.59110418,-0.59560322,-0.54020759,1.7241456,-0.59110418,-0.59560322,-0.54020759,1.7228375,-0.59110418,-0.59560322,-0.54020759,1.7233627,-0.59110418,-0.59560322,-0.54020759,1.7234123,-0.59111409,-0.59662393,-0.54020759,1.7214402,-0.59111409,-0.59560322,-0.54020759,1.7258203,-0.59110418,-0.59560322,-0.54020759,1.7257311,-0.59110418,-0.59560322,-0.54020759,1.7262762,-0.59110418,-0.59662393,-0.53918689,1.7248492,-0.59110418,-0.59560322,-0.54020759,1.7275843,-0.59110418,-0.59662393,-0.54020759,1.72696,-0.59110418,-0.59662393,-0.53918689,1.7284464,-0.59109427,-0.59662393,-0.54020759,1.7244131,-0.59111409,-0.59560322,-0.54020759,1.7291599,-0.59111409,-0.59560322,-0.54020759,1.7292888,-0.59111409,-0.59560322,-0.54020759,1.7291104,-0.59111409,-0.59560322,-0.54020759,1.7288329,-0.59111409,-0.59560322,-0.54020759,1.7283275,-0.59111409,-0.59560322,-0.54020759,1.7285653,-0.59111409,-0.59560322,-0.54020759,1.7302005,-0.59111409,-0.59560322,-0.54020759,1.7301014,-0.59111409,-0.59662393,-0.54020759,1.7308743,-0.59110418,-0.59560322,-0.54020759,1.7311518,-0.59111409,-0.59560322,-0.54020759,1.7345806,-0.59110418,-0.59560322,-0.54020759,1.7352049,-0.59110418,-0.59560322,-0.54020759,1.7345707,-0.59110418,-0.59560322,-0.54020759,1.7356013,-0.59110418,-0.59560322,-0.54020759,1.7360769,-0.59110418,-0.59560322,-0.54020759,1.7346896,-0.59110418,-0.59560322,-0.54020759,1.7358391,-0.59110418,-0.59560322,-0.54020759,1.7359382,-0.59111409,-0.59560322,-0.54020759,1.7362652,-0.59110418,-0.59560322,-0.54020759,1.7328959,-0.59110418,-0.59560322,-0.54020759,1.7354328,-0.59111409,-0.59560322,-0.54020759,1.734204,-0.59110418,-0.59560322,-0.54020759,1.7347887,-0.59110418,-0.59560322,-0.54020759,1.7335202,-0.59110418,-0.59560322,-0.54020759,1.7333121,-0.59110418,-0.59560322,-0.54020759,1.7339166,-0.59110418,-0.59560322,-0.54020759,1.734858,-0.59110418,-0.59560322,-0.54020759,1.7323806,-0.59111409,-0.59560322,-0.54020759,1.7332527,-0.59111409,-0.59560322,-0.54020759,1.7346599,-0.59111409,-0.59560322,-0.54020759,1.7325293,-0.59111409,-0.59560322,-0.54020759,1.7334905,-0.59111409,-0.59560322,-0.54020759,1.7319446,-0.59111409,-0.59560322,-0.54020759,1.73135,-0.59111409,-0.59560322,-0.54020759,1.7335599,-0.59111409,-0.59560322,-0.54020759,1.734422,-0.59111409,-0.59560322,-0.54020759,1.7343229,-0.59111409,-0.59662393,-0.54020759,1.7340752,-0.59110418,-0.59560322,-0.54020759,1.7351454,-0.59110418,-0.59560322,-0.54020759,1.736186,-0.59110418,-0.59560322,-0.54020759,1.7311617,-0.59111409,-0.59560322,-0.54020759,1.7308347,-0.59110418,-0.59560322,-0.54020759,1.7298239,-0.59110418,-0.59560322,-0.54020759,1.7308248,-0.59110418,-0.59560322,-0.54020759,1.7314986,-0.59110418,-0.59560322,-0.54020759,1.7309536,-0.59111409,-0.59560322,-0.54020759,1.7327076,-0.59110418,-0.59560322,-0.54020759,1.7319446,-0.59111409,-0.59560322,-0.54020759,1.732113,-0.59110418,-0.59560322,-0.54020759,1.7332031,-0.59111409,-0.59560322,-0.54020759,1.7319446,-0.59110418,-0.59560322,-0.54020759,1.7341545,-0.59110418,-0.59560322,-0.54020759,1.7346499,-0.59110418,-0.59560322,-0.54020759,1.7371968,-0.59111409,-0.59560322,-0.54020759,1.7372166,-0.59110418,-0.59560322,-0.54020759,1.738703,-0.59110418,-0.59560322,-0.54020759,1.7360373,-0.59111409,-0.59560322,-0.54020759,1.7374445,-0.59111409,-0.59560322,-0.54020759,1.7399616,-0.59110418,-0.59662393,-0.54020759,1.7408931,-0.59110418,-0.59560322,-0.54020759,1.7396246,-0.59111409,-0.59560322,-0.54020759,1.7388021,-0.59111409,-0.59560322,-0.54020759,1.7408436,-0.59110418,-0.59560322,-0.54020759,1.7409228,-0.59110418,-0.59560322,-0.54020759,1.7409327,-0.59111409,-0.59560322,-0.54020759,1.7426669,-0.59110418,-0.59560322,-0.54020759,1.738594,-0.59110418,-0.59560322,-0.54020759,1.7397138,-0.59110418,-0.59560322,-0.54020759,1.7406949,-0.59110418,-0.59560322,-0.53918689,1.7397138,-0.59110418,-0.59560322,-0.54020759,1.74123,-0.59111409,-0.59560322,-0.54020759,1.7402093,-0.59110418,-0.59560322,-0.54020759,1.7401003,-0.59110418,-0.59560322,-0.54020759,1.7402589,-0.59111409,-0.59560322,-0.54020759,1.738485,-0.59110418,-0.59560322,-0.54020759,1.7378706,-0.59111409,-0.59560322,-0.54020759,1.7379796,-0.59111409,-0.59560322,-0.54020759,1.741339,-0.59111409,-0.59662393,-0.54020759,1.7395949,-0.59110418,-0.59560322,-0.54020759,1.7377517,-0.59111409,-0.59560322,-0.54020759,1.7384157,-0.59111409,-0.59560322,-0.54020759,1.7373553,-0.59110418,-0.59560322,-0.54020759,1.7383265,-0.59110418,-0.59560322,-0.54020759,1.7371868,-0.59111409,-0.59560322,-0.53918689,1.7377517,-0.59110418,-0.59560322,-0.53918689,1.7368202,-0.59110418,-0.59560322,-0.54020759,1.7357103,-0.59111409,-0.59560322,-0.54020759,1.7327274,-0.59111409,-0.59560322,-0.54020759,1.7342635,-0.59110418,-0.59560322,-0.54020759,1.734977,-0.59111409,-0.59560322,-0.54020759,1.7351256,-0.59111409,-0.59560322,-0.54020759,1.7340454,-0.59111409,-0.59560322,-0.53918689,1.7362355,-0.59110418,-0.59560322,-0.54020759,1.7375436,-0.59111409,-0.59560322,-0.54020759,1.7370481,-0.59111409,-0.59560322,-0.54020759,1.7315581,-0.59111409,-0.59560322,-0.54020759,1.7307554,-0.59110418,-0.59560322,-0.54020759,1.732232,-0.59110418,-0.59662393,-0.53918689,1.7326482,-0.59110418,-0.59560322,-0.54020759,1.7341644,-0.59110418,-0.59560322,-0.54020759,1.7368896,-0.59110418,-0.59560322,-0.54020759,1.7374742,-0.59110418,-0.59662393,-0.53918689,1.7385841,-0.59110418,-0.59560322,-0.53918689,1.7354031,-0.59110418,-0.59560322,-0.54020759,1.7375535,-0.59110418,-0.59560322,-0.54020759,1.7380391,-0.59110418,-0.59560322,-0.54020759,1.7385048,-0.59110418,-0.59560322,-0.54020759,1.7356211,-0.59110418,-0.59560322,-0.54020759,1.736404,-0.59110418,-0.59560322,-0.54020759,1.7367805,-0.59111409,-0.59560322,-0.54020759,1.7394463,-0.59110418,-0.59662393,-0.54020759,1.7397039,-0.59110418,-0.59560322,-0.54020759,1.7379202,-0.59110418,-0.59560322,-0.54020759,1.737613,-0.59110418,-0.59560322,-0.54020759,1.7326383,-0.59110418,-0.59560322,-0.54020759,1.7341247,-0.59110418,-0.59560322,-0.54020759,1.7341545,-0.59110418,-0.59560322,-0.54020759,1.7338968,-0.59110418,-0.59662393,-0.53918689,1.7327274,-0.59110418,-0.59560322,-0.54020759,1.7338869,-0.59110418,-0.59560322,-0.54020759,1.7344517,-0.59111409,-0.59662393,-0.54020759,1.7355022,-0.59110418,-0.59560322,-0.54020759,1.7350959,-0.59110418,-0.59662393,-0.54020759,1.7359085,-0.59110418,-0.59662393,-0.53918689,1.7345608,-0.59110418,-0.59662393,-0.54020759,1.734759,-0.59110418,-0.59560322,-0.53918689,1.7343824,-0.59110418,-0.59662393,-0.53918689,1.7348382,-0.59110418,-0.59662393,-0.53918689,1.7350959,-0.59110418,-0.59662393,-0.54020759,1.7334112,-0.59110418,-0.59560322,-0.53918689,1.7352049,-0.59110418,-0.59560322,-0.53918689,1.7350067,-0.59111409,-0.59560322,-0.54020759,1.7342932,-0.59111409,-0.59560322,-0.53918689,1.7360968,-0.59111409,-0.59662393,-0.53918689,1.7399517,-0.59110418,-0.59560322,-0.53918689,1.7349968,-0.59110418,-0.59560322,-0.53918689,1.7360175,-0.59110418,-0.59662393,-0.53918689,1.7357499,-0.59110418,-0.59662393,-0.53918689,1.7361661,-0.59110418,-0.59560322,-0.53815627,1.7371472,-0.59110418,-0.59662393,-0.53815627,1.7338869,-0.59109427,-0.59662393,-0.53815627,1.735958,-0.59110418,-0.59662393,-0.53918689,1.7355022,-0.59110418,-0.59047987,-0.57406929,1.7365724,-0.59135193,-0.59150057,-0.56278206,1.7367706,-0.59128256,-0.59047987,-0.57201796,1.7371769,-0.59133211,-0.59047987,-0.57201796,1.7376823,-0.59133211,-0.59047987,-0.57201796,1.7375733,-0.59133211,-0.59047987,-0.57098735,1.7380391,-0.59133211,-0.59047987,-0.57098735,1.7377418,-0.5913222,-0.59047987,-0.56996664,1.7360076,-0.5913222,-0.59047987,-0.57098735,1.737058,-0.59133211,-0.59047987,-0.57098735,1.7374643,-0.5913222,-0.59047987,-0.57098735,1.7351355,-0.5913222,-0.59047987,-0.57098735,1.7337382,-0.5913222,-0.59047987,-0.57098735,1.7340752,-0.5913222,-0.59047987,-0.57098735,1.7332725,-0.5913222,-0.59047987,-0.57098735,1.7343725,-0.5913222,-0.59047987,-0.57098735,1.7340653,-0.5913222,-0.59047987,-0.57098735,1.734759,-0.5913222,-0.59150057,-0.59150057,1.7346103,-0.59150057,-0.59150057,-0.56175144,1.7328563,-0.59127265,-0.59150057,-0.56483338,1.7353833,-0.59129247,-0.59560322,-0.54020759,1.7355418,-0.59111409,-0.59560322,-0.54123821,1.7339067,-0.59111409,-0.59560322,-0.54123821,1.7338473,-0.59111409,-0.59560322,-0.54020759,1.737276,-0.59110418,-0.59560322,-0.54020759,1.7369986,-0.59111409,-0.59560322,-0.54020759,1.7356211,-0.59111409,-0.59560322,-0.54020759,1.7378211,-0.59111409,-0.59662393,-0.53918689,1.7376328,-0.59110418,-0.59662393,-0.54020759,1.7382076,-0.59110418,-0.59560322,-0.54020759,1.739585,-0.59110418,-0.59560322,-0.54020759,1.7409426,-0.59110418,-0.59560322,-0.54020759,1.7408733,-0.59110418,-0.59560322,-0.54020759,1.7409426,-0.59110418,-0.59662393,-0.54020759,1.7411012,-0.59110418,-0.59662393,-0.53918689,1.7403778,-0.59110418,-0.59662393,-0.54020759,1.7408237,-0.59110418,-0.59560322,-0.54020759,1.7420823,-0.59110418,-0.59662393,-0.54020759,1.7421615,-0.59110418,-0.59662393,-0.54020759,1.7419138,-0.59110418,-0.59560322,-0.54020759,1.7420525,-0.59110418,-0.59662393,-0.54020759,1.7408634,-0.59110418,-0.59662393,-0.54020759,1.7410219,-0.59110418,-0.59662393,-0.54020759,1.7408336,-0.59110418,-0.59662393,-0.54020759,1.7394066,-0.59110418,-0.59662393,-0.54020759,1.7413589,-0.59110418,-0.59560322,-0.53918689,1.7389904,-0.59110418,-0.59662393,-0.53918689,1.7399219,-0.59110418,-0.59662393,-0.53918689,1.740467,-0.59110418,-0.59662393,-0.54020759,1.7404075,-0.59110418,-0.59662393,-0.53918689,1.7411805,-0.59110418,-0.59662393,-0.54020759,1.7374247,-0.59110418,-0.59560322,-0.53918689,1.7391391,-0.59110418,-0.59662393,-0.53918689,1.7371769,-0.59110418,-0.59662393,-0.54020759,1.7387922,-0.59110418,-0.59560322,-0.54020759,1.7378409,-0.59110418,-0.59560322,-0.54020759,1.7382274,-0.59110418,-0.59662393,-0.53918689,1.7381778,-0.59110418,-0.59662393,-0.53918689,1.7389211,-0.59110418,-0.59662393,-0.53918689,1.7403679,-0.59110418,-0.59662393,-0.54020759,1.737504,-0.59110418,-0.59560322,-0.53918689,1.7374544,-0.59110418,-0.59662393,-0.53918689,1.7382967,-0.59110418,-0.59560322,-0.53918689,1.7401201,-0.59110418,-0.59662393,-0.53918689,1.7406057,-0.59110418,-0.59662393,-0.53918689,1.7389508,-0.59110418,-0.59662393,-0.53918689,1.7395256,-0.59110418,-0.59662393,-0.53918689,1.7391787,-0.59110418,-0.59662393,-0.53918689,1.7397039,-0.59110418,-0.59662393,-0.53918689,1.7390499,-0.59110418,-0.59662393,-0.53918689,1.7406255,-0.59110418,-0.59662393,-0.53918689,1.7399219,-0.59110418,-0.59662393,-0.53918689,1.7401895,-0.59110418,-0.59662393,-0.53918689,1.7412102,-0.59110418,-0.59662393,-0.54020759,1.7411706,-0.59110418,-0.59662393,-0.53918689,1.7393769,-0.59110418,-0.59662393,-0.53918689,1.7407048,-0.59110418,-0.59662393,-0.53918689,1.7423399,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418,-0.59662393,-0.53918689,1.7425282,-0.59110418:9
-0.54744598,-0.47151244,1.3429404,-0.47523497,-0.54744598,-0.47151244,1.340209,-0.47523497,-0.54744598,-0.47151244,1.3424956,-0.47523497,-0.54744598,-0.47151244,1.3423473,-0.47523497,-0.54744598,-0.47151244,1.3435179,-0.47523497,-0.54744598,-0.47151244,1.3403495,-0.47523497,-0.54744598,-0.47231625,1.3404977,-0.47523497,-0.54744598,-0.47151244,1.3404743,-0.47524278,-0.54744598,-0.47151244,1.3393896,-0.47523497,-0.54744598,-0.47231625,1.3394832,-0.47524278,-0.54744598,-0.47151244,1.3391788,-0.47523497,-0.54744598,-0.47151244,1.3393505,-0.47523497,-0.54744598,-0.47151244,1.339015,-0.47523497,-0.54744598,-0.47231625,1.3395925,-0.47523497,-0.54744598,-0.47231625,1.3400139,-0.47524278,-0.54744598,-0.47151244,1.3408021,-0.47523497,-0.54744598,-0.47231625,1.3396237,-0.47524278,-0.54744598,-0.47231625,1.3386872,-0.47524278,-0.54744598,-0.47151244,1.339015,-0.47524278,-0.54744598,-0.47231625,1.3395534,-0.47524278,-0.54744598,-0.47151244,1.3405602,-0.47523497,-0.54744598,-0.47231625,1.3411923,-0.47524278,-0.54744598,-0.47151244,1.3412157,-0.47524278,-0.54744598,-0.47151244,1.3396315,-0.47524278,-0.54744598,-0.47231625,1.3400685,-0.47523497,-0.54744598,-0.47151244,1.3403104,-0.47524278,-0.54744598,-0.47151244,1.3418088,-0.47524278,-0.54744598,-0.47151244,1.3428936,-0.47523497,-0.54744598,-0.47151244,1.342956,-0.47523497,-0.54744598,-0.47231625,1.3425424,-0.47523497,-0.54744598,-0.47151244,1.3424175,-0.47523497,-0.54744598,-0.47151244,1.3431433,-0.47523497,-0.54744598,-0.47151244,1.3430262,-0.47523497,-0.54744598,-0.47151244,1.3441032,-0.47523497,-0.54744598,-0.47231625,1.3412859,-0.47523497,-0.54744598,-0.47231625,1.3419415,-0.47523497,-0.54744598,-0.47151244,1.3417542,-0.47523497,-0.54744598,-0.47231625,1.3423473,-0.47523497,-0.54744598,-0.47151244,1.3426517,-0.47524278,-0.54744598,-0.47151244,1.3428624,-0.47523497,-0.54744598,-0.47231625,1.3420273,-0.47523497,-0.54744598,-0.47151244,1.3416371,-0.47523497,-0.54744598,-0.47231625,1.3415591,-0.47524278,-0.54744598,-0.47231625,1.3421522,-0.47523497,-0.54744598,-0.47151244,1.3423161,-0.47523497,-0.54744598,-0.47151244,1.3427843,-0.47524278,-0.54744598,-0.47151244,1.342238,-0.47524278,-0.54744598,-0.47151244,1.3441344,-0.47523497,-0.54744598,-0.47231625,1.3439627,-0.47523497,-0.54744598,-0.47151244,1.3436896,-0.47523497,-0.54744598,-0.47151244,1.3437208,-0.47523497,-0.54744598,-0.47151244,1.3441969,-0.47524278,-0.54744598,-0.47231625,1.3440018,-0.47523497,-0.54744598,-0.47151244,1.343674,-0.47523497,-0.54744598,-0.47151244,1.3422146,-0.47523497,-0.54744598,-0.47151244,1.342636,-0.47523497,-0.54744598,-0.47151244,1.3436896,-0.47523497,-0.54744598,-0.47151244,1.3403416,-0.47523497,-0.54744598,-0.47151244,1.3424956,-0.47523497,-0.54744598,-0.47151244,1.3424956,-0.47523497,-0.54744598,-0.47151244,1.3430575,-0.47523497,-0.54906143,10.392854,1.3097185,-0.42802038,-0.54744598,-0.47231625,1.3435881,-0.47523497,-0.54744598,-0.47151244,1.3439159,-0.47523497,-0.54744598,-0.47231625,1.343713,-0.47523497,-0.54744598,-0.47231625,1.3410986,-0.47524278,-0.54744598,-0.47231625,1.3410128,-0.47524278,-0.54744598,-0.47151244,1.3412313,-0.47523497,-0.54744598,-0.47151244,1.3395066,-0.47523497,-0.54744598,-0.47231625,1.3393583,-0.47523497,-0.54744598,-0.47231625,1.3408411,-0.47523497,-0.54744598,-0.47231625,1.3403182,-0.47524278,-0.54744598,-0.47231625,1.3410596,-0.47524278,-0.54744598,-0.47151244,1.3410908,-0.47523497,-0.54744598,-0.47151244,1.3405836,-0.47524278,-0.54744598,-0.47151244,1.3402324,-0.47524278,-0.54744598,-0.47231625,1.3398578,-0.47524278,-0.54744598,-0.47151244,1.3389369,-0.47524278,-0.54744598,-0.47231625,1.339928,-0.47524278,-0.54744598,-0.47151244,1.3412703,-0.47524278,-0.54744598,-0.47231625,1.3404353,-0.47524278,-0.54744598,-0.47231625,1.341005,-0.47524278,-0.54744598,-0.47151244,1.3427921,-0.47523497,-0.54744598,-0.47231625,1.3418244,-0.47523497,-0.54744598,-0.47231625,1.3423785,-0.47524278,-0.54744598,-0.47151244,1.343393,-0.47523497,-0.54744598,-0.47151244,1.3417542,-0.47523497,-0.54744598,-0.47151244,1.3438535,-0.47523497,-0.54744598,-0.47151244,1.3438535,-0.47523497,-0.54744598,-0.47231625,1.3437676,-0.47523497,-0.54744598,-0.47151244,1.3431589,-0.47523497,-0.54744598,-0.47151244,1.3429092,-0.47523497,-0.54744598,-0.47151244,1.3421834,-0.47523497,-0.54744598,-0.47151244,1.3421912,-0.47523497,-0.54744598,-0.47151244,1.3416059,-0.47524278,-0.5482498,-0.47231625,1.3449148,-0.47523497,-0.098267435,-0.0085987322,1.3422302,-0.47283913,-0.13301113,10.813766,1.3088444,-0.4261318,-0.54744598,-0.47231625,1.3427843,-0.47523497,-0.54744598,-0.47151244,1.3416683,-0.47524278,-0.54744598,-0.47151244,1.3420507,-0.47523497,-0.54744598,-0.47151244,1.3350037,-0.47523497,-0.54744598,-0.47151244,1.3401934,-0.47524278,-0.54744598,-0.47151244,1.3418166,-0.47523497,-0.54744598,-0.47151244,1.3424565,-0.47523497,-0.54744598,-0.47231625,1.3425424,-0.47523497,-0.54744598,-0.47231625,1.3423551,-0.47523497,-0.54744598,-0.47151244,1.3423395,-0.47523497,-0.54744598,-0.47151244,1.342519,-0.47524278,-0.54744598,-0.47231625,1.3416371,-0.47524278,-0.54744598,-0.47151244,1.341879,-0.47524278,-0.54744598,-0.47151244,1.3422927,-0.47523497,-0.54744598,-0.47151244,1.3415747,-0.47524278,-0.54744598,-0.47151244,1.3413562,-0.47523497,-0.54744598,-0.47231625,1.3408801,-0.47524278,-0.54744598,-0.47231625,1.3411767,-0.47524278,-0.54744598,-0.47151244,1.3394988,-0.47524278,-0.54744598,-0.47151244,1.3409582,-0.47524278,-0.54744598,-0.47231625,1.3412001,-0.47523497,-0.54744598,-0.47151244,1.3409113,-0.47523497,-0.54744598,-0.47151244,1.3394286,-0.47523497,-0.54744598,-0.47151244,1.341801,-0.47523497,-0.54744598,-0.47151244,1.3406772,-0.47523497,-0.54744598,-0.47151244,1.3395456,-0.47523497,-0.54744598,-0.47151244,1.3405914,-0.47523497,-0.54744598,-0.47231625,1.3399124,-0.47523497,-0.54744598,-0.47151244,1.3395144,-0.47523497,-0.54744598,-0.47231625,1.3400217,-0.47523497,-0.54744598,-0.47231625,1.3416059,-0.47523497,-0.54744598,-0.47231625,1.3412313,-0.47523497,-0.54744598,-0.47231625,1.339811,-0.47523497,-0.54744598,-0.47151244,1.3397641,-0.47524278,-0.54744598,-0.47151244,1.338414,-0.47524278,-0.54744598,-0.47151244,1.3392179,-0.47523497,-0.54744598,-0.47231625,1.3397095,-0.47523497,-0.54744598,-0.47231625,1.3413328,-0.47523497,-0.54744598,-0.47231625,1.339054,-0.47524278,-0.54744598,-0.47231625,1.3395925,-0.47524278,-0.54744598,-0.47151244,1.3386872,-0.47524278,-0.54744598,-0.47231625,1.3394832,-0.47523497,-0.54744598,-0.47151244,1.3391632,-0.47523497,-0.54744598,-0.47231625,1.3399046,-0.47523497,-0.54744598,-0.47151244,1.339054,-0.47524278,-0.54744598,-0.47231625,1.3384999,-0.47523497,-0.54744598,-0.47151244,1.3375868,-0.47524278,-0.54744598,-0.47231625,1.336502,-0.47524278,-0.54744598,-0.47151244,1.3375868,-0.47523497,-0.54744598,-0.47231625,1.3386716,-0.47524278,-0.54744598,-0.47231625,1.3386716,-0.47524278,-0.54744598,-0.47231625,1.3392257,-0.47524278,-0.54744598,-0.47151244,1.3403338,-0.47523497,-0.54744598,-0.47231625,1.3425034,-0.47523497,-0.54744598,-0.47231625,1.3414966,-0.47523497,-0.54744598,-0.47151244,1.3414264,-0.47523497,-0.54744598,-0.47151244,1.3417152,-0.47524278,-0.54744598,-0.47151244,1.3412391,-0.47523497,-0.54744598,-0.47231625,1.3430497,-0.47523497,-0.54744598,-0.47151244,1.3416918,-0.47524278,-0.54744598,-0.47151244,1.3407865,-0.47524278,-0.54744598,-0.47151244,1.3423317,-0.47523497,-0.54744598,-0.47151244,1.341325,-0.47524278,-0.54744598,-0.47151244,1.3419571,-0.47523497,-0.54744598,-0.47151244,1.3423941,-0.47523497,-0.54744598,-0.47231625,1.338773,-0.47524278,-0.54744598,-0.47151244,1.340248,-0.47524278,-0.54744598,-0.47151244,1.3391086,-0.47524278,-0.54744598,-0.47231625,1.3411611,-0.47524278,-0.54744598,-0.47151244,1.3399905,-0.47523497,-0.54744598,-0.47151244,1.3405524,-0.47523497,-0.54744598,-0.47151244,1.3420976,-0.47523497,-0.55471157,10.175534,1.3069793,-0.42850424,-0.54744598,-0.47151244,1.3381643,-0.47524278,-0.54744598,-0.47231625,1.3362835,-0.47524278,-0.54744598,-0.47151244,1.3396237,-0.47524278,-0.54744598,-0.47231625,1.3402168,-0.47524278,-0.54744598,-0.47231625,1.3400841,-0.47524278,-0.54744598,-0.47231625,1.343315,-0.47524278,-0.54744598,-0.47151244,1.3443529,-0.47524278,-0.54744598,-0.47231625,1.3445715,-0.47523497,-0.54744598,-0.47151244,1.3415279,-0.47523497,-0.54744598,-0.47151244,1.3434086,-0.47523497,-0.54744598,-0.47231625,1.3437286,-0.47523497,-0.54744598,-0.47231625,1.3427999,-0.47523497,-0.54744598,-0.47231625,1.3434555,-0.47523497,-0.54744598,-0.47151244,1.3437364,-0.47523497,-0.54744598,-0.47231625,1.3435335,-0.47523497,-0.54744598,-0.47231625,1.3430497,-0.47523497,-0.54744598,-0.47231625,1.3412313,-0.47524278,-0.54744598,-0.47151244,1.3400763,-0.47522717,-0.54744598,-0.47151244,1.340248,-0.47523497,-0.54744598,-0.47151244,1.3394832,-0.47523497,-0.54744598,-0.47151244,1.3398188,-0.47523497,-0.54744598,-0.47151244,1.3397563,-0.47523497,-0.54744598,-0.47151244,1.3399592,-0.47523497,-0.54744598,-0.47151244,1.3418244,-0.47523497,-0.54744598,-0.47231625,1.3420585,-0.47523497,-0.54744598,-0.47151244,1.342956,-0.47523497,-0.54744598,-0.47151244,1.3412469,-0.47523497,-0.54744598,-0.47231625,1.3405992,-0.47523497,-0.54744598,-0.47151244,1.3404821,-0.47523497,-0.54744598,-0.47231625,1.3414576,-0.47523497,-0.54744598,-0.47151244,1.3398656,-0.47523497,-0.54744598,-0.47231625,1.3408801,-0.47523497,-0.54744598,-0.47231625,1.3408645,-0.47523497,-0.54744598,-0.47231625,1.3412937,-0.47523497,-0.54744598,-0.47151244,1.340209,-0.47523497,-0.54744598,-0.47151244,1.3407631,-0.47523497,-0.54744598,-0.47151244,1.340927,-0.47523497,-0.54744598,-0.47151244,1.3407865,-0.47523497,-0.54744598,-0.47231625,1.342956,-0.47523497,-0.54744598,-0.47151244,1.3423707,-0.47523497,-0.54744598,-0.47231625,1.3418478,-0.47523497,-0.54744598,-0.47151244,1.3404977,-0.47523497,-0.54744598,-0.47151244,1.3407475,-0.47523497,-0.54744598,-0.47231625,1.3389759,-0.47523497,-0.54906143,10.36458,1.3073383,-0.42808282,-0.54744598,-0.47151244,1.3415903,-0.47523497,-0.54744598,-0.47151244,1.34248,-0.47523497,-0.54744598,-0.47231625,1.3403963,-0.47523497,-0.54744598,-0.47151244,1.342597,-0.47523497,-0.54744598,-0.47151244,1.3424331,-0.47523497,-0.54744598,-0.47231625,1.3429014,-0.47523497,-0.54744598,-0.47151244,1.3421834,-0.47523497,-0.54744598,-0.47151244,1.3420351,-0.47523497,-0.54744598,-0.47231625,1.3426907,-0.47523497,-0.54744598,-0.47151244,1.3421288,-0.47523497,-0.54744598,-0.47151244,1.3425424,-0.47523497,-0.54744598,-0.47151244,1.3415825,-0.47523497,-0.54744598,-0.47151244,1.3422771,-0.47523497,-0.54744598,-0.47151244,1.3426985,-0.47523497,-0.54744598,-0.47151244,1.342558,-0.47523497,-0.54744598,-0.47151244,1.3443529,-0.47523497,-0.54744598,-0.47151244,1.3426126,-0.47523497,-0.54744598,-0.47151244,1.3396003,-0.47523497,-0.54744598,-0.47231625,1.3404509,-0.47523497,-0.54744598,-0.47231625,1.3409972,-0.47523497,-0.54744598,-0.47151244,1.342597,-0.47523497,-0.54744598,-0.47231625,1.3418166,-0.47523497,-0.54744598,-0.47151244,1.3424644,-0.47523497,-0.5482498,-0.47151244,1.3427453,-0.47523497,-0.5482498,-0.47231625,1.3432213,-0.47523497,-0.5482498,-0.47151244,1.3470766,-0.47523497,-0.5482498,-0.47231625,1.3475214,-0.47523497,-0.5482498,-0.47231625,1.3478804,-0.47523497,-0.5482498,-0.47231625,1.3479506,-0.47523497,-0.5482498,-0.47231625,1.3478882,-0.47523497,-0.5482498,-0.47151244,1.3490822,-0.47523497,-0.5482498,-0.47151244,1.3484345,-0.47523497,-0.5482498,-0.47151244,1.3493319,-0.47523497,-0.5482498,-0.47151244,1.3481457,-0.47523497,-0.5482498,-0.47151244,1.3481457,-0.47523497,-0.5482498,-0.47151244,1.3472248,-0.47523497,-0.5482498,-0.47151244,1.3489886,-0.47523497,-0.5482498,-0.47151244,1.3492149,-0.47523497,-0.5482498,-0.47151244,1.3484111,-0.47523497,-0.5482498,-0.47151244,1.3501123,-0.47523497,-0.5482498,-0.47151244,1.3498938,-0.47523497,-0.5482498,-0.47151244,1.3512751,-0.47523497,-0.5482498,-0.47231625,1.3503543,-0.47523497,-0.5482498,-0.47231625,1.3502762,-0.47523497,-0.53532627,9.7376635,1.3204023,-0.42947974,-0.5482498,-0.47151244,1.3518058,-0.47523497,-0.5482498,-0.47151244,1.3515327,-0.47523497,-0.5482498,-0.47231625,1.3509084,-0.47523497,-0.5482498,-0.47151244,1.3495817,-0.47523497,-0.5482498,-0.47151244,1.3483018,-0.47523497,-0.5482498,-0.47151244,1.3477009,-0.47523497,-0.5482498,-0.47151244,1.3472951,-0.47523497,-0.5482498,-0.47151244,1.3458435,-0.47523497,-0.5482498,-0.47151244,1.3472639,-0.47523497,-0.5482498,-0.47151244,1.3473731,-0.47523497,-0.5482498,-0.47151244,1.3470297,-0.47523497,-0.5482498,-0.47151244,1.3494568,-0.47523497,-0.5482498,-0.47151244,1.3505103,-0.47523497,-0.5482498,-0.47231625,1.3465459,-0.47523497,-0.5482498,-0.47151244,1.3462805,-0.47523497,-0.5482498,-0.47151244,1.3456874,-0.47523497,-0.5482498,-0.47231625,1.3466864,-0.47524278,-0.5482498,-0.47151244,1.3462181,-0.47523497,-0.5482498,-0.47151244,1.3460932,-0.47523497,-0.5482498,-0.47151244,1.3468112,-0.47523497,-0.5482498,-0.47151244,1.3466942,-0.47523497,-0.5482498,-0.47151244,1.3463664,-0.47523497,-0.5482498,-0.47151244,1.3475604,-0.47523497,-0.5482498,-0.47151244,1.3490666,-0.47523497,-0.5482498,-0.47151244,1.3488949,-0.47523497,-0.5482498,-0.47151244,1.3480911,-0.47523497,-0.5482498,-0.47231625,1.347537,-0.47523497,-0.5482498,-0.47151244,1.3469517,-0.47523497,-0.5482498,-0.47231625,1.346741,-0.47523497,-0.5482498,-0.47151244,1.3463274,-0.47523497,-0.5482498,-0.47151244,1.3473107,-0.47523497,-0.5482498,-0.47231625,1.3474746,-0.47523497,-0.5482498,-0.47151244,1.34941,-0.47523497,-0.5482498,-0.47151244,1.3490744,-0.47523497,-0.5482498,-0.47151244,1.3474355,-0.47523497,-0.5482498,-0.47151244,1.3468034,-0.47523497,-0.5482498,-0.47231625,1.3465849,-0.47523497,-0.5482498,-0.47151244,1.3473575,-0.47523497,-0.5482498,-0.47151244,1.3476775,-0.47523497,-0.5482498,-0.47151244,1.3482472,-0.47523497,-0.5482498,-0.47231625,1.3493319,-0.47523497,-0.5482498,-0.47151244,1.3503387,-0.47523497,-0.5482498,-0.47151244,1.3491524,-0.47523497,-0.5482498,-0.47151244,1.3512908,-0.47523497,-0.5482498,-0.47231625,1.3500109,-0.47523497,-0.5482498,-0.47151244,1.3488715,-0.47523497,-0.5482498,-0.47231625,1.3479896,-0.47523497,-0.5482498,-0.47151244,1.3489964,-0.47523497,-0.5482498,-0.47151244,1.3495426,-0.47523497,-0.5482498,-0.47151244,1.3493944,-0.47523497,-0.5482498,-0.47151244,1.3492383,-0.47523497,-0.5482498,-0.47151244,1.3502528,-0.47523497,-0.5482498,-0.47151244,1.3503699,-0.47523497,-0.5482498,-0.47151244,1.3501904,-0.47523497,-0.5482498,-0.47151244,1.3479116,-0.47523497,-0.5482498,-0.47151244,1.3454845,-0.47523497,-0.5482498,-0.47151244,1.3458123,-0.47523497,-0.5482498,-0.47231625,1.3454221,-0.47523497,-0.5482498,-0.47151244,1.345984,-0.47523497,-0.5482498,-0.47231625,1.3464444,-0.47523497,-0.5482498,-0.47151244,1.3462493,-0.47523497,-0.5482498,-0.47231625,1.3453909,-0.47523497,-0.5482498,-0.47151244,1.3456952,-0.47523497,-0.5482498,-0.47151244,1.3449851,-0.47523497,-0.54744598,-0.47231625,1.3449148,-0.47523497,-0.54744598,-0.47231625,1.3435023,-0.47524278,-0.54744598,-0.47231625,1.3432526,-0.47524278,-0.55148069,-0.45777728,1.3439783,-0.47383024,-0.5482498,-0.47151244,1.3460776,-0.47524278,-0.54744598,-0.47151244,1.3445715,-0.47523497,-0.5482498,-0.47231625,1.3452426,-0.47524278,-0.54744598,-0.47231625,1.343315,-0.47524278,-0.5482498,-0.47151244,1.3457733,-0.47523497,-0.5482498,-0.47151244,1.3472951,-0.47523497,-0.5482498,-0.47151244,1.3473341,-0.47523497,-0.5482498,-0.47151244,1.3475448,-0.47523497,-0.5482498,-0.47231625,1.3463664,-0.47523497,-0.5482498,-0.47231625,1.3476775,-0.47523497,-0.5482498,-0.47151244,1.3451646,-0.47523497,-0.5482498,-0.47151244,1.346304,-0.47523497,-0.5482498,-0.47151244,1.3455782,-0.47523497,-0.5482498,-0.47151244,1.3463352,-0.47524278,-0.5482498,-0.47231625,1.3450085,-0.47523497,-0.5482498,-0.47231625,1.3475526,-0.47523497,-0.5482498,-0.47231625,1.3467176,-0.47523497,-0.5482498,-0.47151244,1.3462181,-0.47523497,-0.5482498,-0.47151244,1.3458279,-0.47523497,-0.5482498,-0.47151244,1.3477867,-0.47523497,-0.5482498,-0.47151244,1.3476463,-0.47523497,-0.5482498,-0.47151244,1.3479818,-0.47523497,-0.5482498,-0.47151244,1.3469049,-0.47523497,-0.5482498,-0.47231625,1.3473263,-0.47524278,-0.5482498,-0.47151244,1.3474824,-0.47523497,-0.5482498,-0.47151244,1.3472951,-0.47523497,-0.54744598,-0.47151244,1.3430419,-0.47524278,-0.5482498,-0.47151244,1.3441578,-0.47524278,-0.54744598,-0.47231625,1.3430341,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278,-0.54744598,-0.47231625,1.3428311,-0.47524278:3
-0.49707956,-0.49707956,0.94604916,-0.49707956,-0.49707956,-0.49707956,0.94758136,-0.49707956,-0.47773151,5.0377005,0.93786246,-0.47245535,-0.47839824,4.9409538,0.93186828,-0.47278231,-0.47839824,4.9509612,0.93485575,-0.47278872,-0.47839824,4.9235995,0.93254142,-0.47287206,-0.49707956,-0.48440524,0.94539525,-0.49702827,-0.49707956,-0.48440524,0.94538242,-0.49702827,-0.49707956,-0.48440524,0.94290141,-0.49702827,-0.49707956,-0.48440524,0.94408743,-0.49702827,-0.49707956,-0.48440524,0.95606937,-0.49702827,-0.49707956,-0.48373851,0.95896709,-0.49702186,-0.49707956,-0.48373851,0.95827471,-0.49702186,-0.49707956,-0.48373851,0.96121731,-0.49702186,-0.49707956,-0.48373851,0.9595056,-0.49702186,-0.49707956,-0.48440524,0.95656301,-0.49702827,-0.49707956,-0.48373851,0.95998642,-0.49702186,-0.49707956,-0.48373851,0.957031,-0.49702186,-0.18147809,-0.19548588,0.95977486,-0.49516271,-0.14277558,5.2832438,0.94454901,-0.47142961,-0.16012344,5.2932576,0.94613891,-0.47141679,-0.47773151,5.076403,0.95056883,-0.47250023,-0.47773151,5.0377005,0.946312,-0.47259639,-0.47773151,5.0637222,0.95049831,-0.47255151,-0.49707956,-0.48373851,0.95613989,-0.49702186,-0.49707956,-0.48373851,0.95858885,-0.49702186,-0.49707956,-0.48373851,0.96158914,-0.49702186,-0.49707956,-0.48440524,0.93727266,-0.49702827,-0.49707956,-0.48440524,0.94188849,-0.49702827,-0.49707956,-0.48440524,0.93787528,-0.49702827,-0.49707956,-0.48440524,0.9458953,-0.49702827,-0.19615902,-0.19949268,0.94137562,-0.49520758,-0.15745651,5.1898308,0.9328235,-0.47163476,-0.1714707,5.1931708,0.93372102,-0.47164117,-0.1734709,5.2045117,0.93509937,-0.47161553,-0.1754711,5.1991714,0.93256707,-0.47159629,-0.18014463,5.1624755,0.92979756,-0.47169246,-0.47773151,5.0517147,0.94734416,-0.47257075,-0.47839824,5.0430407,0.9440105,-0.47258357,-0.47839824,5.0116787,0.94220263,-0.47264768,-0.49707956,-0.48373851,0.95794135,-0.49702186,-0.49707956,-0.48440524,0.95206257,-0.49702827,-0.49707956,-0.48373851,0.95503722,-0.49702186,-0.49707956,-0.48440524,0.95212027,-0.49702827,-0.49707956,-0.48373851,0.95385762,-0.49702186,-0.49707956,-0.48373851,0.95756952,-0.49702186,-0.49707956,-0.48440524,0.95397301,-0.49702827,-0.49707956,-0.48373851,0.95682585,-0.49702186,-0.49707956,-0.48373851,0.95583217,-0.49702186,-0.49707956,-0.48373851,0.95865296,-0.49702186,-0.49707956,-0.48373851,0.95676175,-0.49702186,-0.49707956,-0.48373851,0.95293445,-0.49702186,-0.49707956,-0.48440524,0.95055601,-0.49702827,-0.49707956,-0.48440524,0.9496072,-0.49702827,-0.49707956,-0.48440524,0.94797883,-0.49702827,-0.49707956,-0.48440524,0.94976747,-0.49702827,-0.49707956,-0.48373851,0.95012007,-0.49702186,-0.49707956,-0.48440524,0.93682389,-0.49702827,-0.49707956,-0.48440524,0.93540709,-0.49702827,-0.49707956,-0.48440524,0.93604177,-0.49702827,-0.49707956,-0.48440524,0.93361845,-0.49702827,-0.49707956,-0.48440524,0.93534939,-0.49702827,-0.49707956,-0.48440524,0.93700981,-0.49702827,-0.49707956,-0.48440524,0.94453619,-0.49702827,-0.49707956,-0.48440524,0.94736339,-0.49702827,-0.49707956,-0.48440524,0.94374124,-0.49702827,-0.49707956,-0.48373851,0.95941585,-0.49702186,-0.49707956,-0.48373851,0.95817214,-0.49702186,-0.49707956,-0.48373851,0.95768491,-0.49702186,-0.49707956,-0.48373851,0.9599736,-0.49702186,-0.49707956,-0.48373851,0.95331269,-0.49702186,-0.47773151,5.0870771,0.94768393,-0.47240406,-0.47839824,5.0483746,0.94735698,-0.47257075,-0.47839824,5.0343668,0.94703002,-0.47262845,-0.49707956,-0.48373851,0.95789647,-0.49702186,-0.49707956,-0.48440524,0.9540243,-0.49702827,-0.49707956,-0.48373851,0.95837088,-0.49702186,-0.49707956,-0.48373851,0.96959634,-0.49702186,-0.49707956,-0.48373851,0.97035923,-0.49702186,-0.49707956,-0.48373851,0.97028871,-0.49702186,-0.49707956,-0.48440524,0.94851094,-0.49702827,-0.49707956,-0.48440524,0.94989569,-0.49702827,-0.49707956,-0.48440524,0.94752366,-0.49702827,-0.49707956,-0.48373851,0.9694553,-0.49702186,-0.49707956,-0.48373851,0.96711533,-0.49702186,-0.18881856,-0.18815183,0.96966686,-0.49516912,-0.14210885,5.4186994,0.9593838,-0.47109624,-0.16413024,5.2672358,0.94406819,-0.47149372,-0.17013083,5.2999249,0.94757495,-0.47141679,-0.17213744,5.2812436,0.94333094,-0.4714232,-0.17413763,5.3012648,0.94569015,-0.47137832,-0.47839824,4.9022513,0.94531191,-0.47287206,-0.49707956,-0.49707956,0.94846606,-0.49707956,-0.49707956,-0.49707956,0.95268442,-0.49707956,-0.49707956,-0.49707956,0.95540264,-0.49707956,-0.49707956,-0.49707956,0.95156252,-0.49707956,-0.49707956,-0.49707956,0.96326238,-0.49707956,-0.49707956,-0.49707956,0.96951941,-0.49707956,-0.49707956,-0.49707956,0.9672756,-0.49707956,-0.49707956,-0.49707956,0.96891678,-0.49707956,-0.49707956,-0.49707956,0.97079517,-0.49707956,-0.49707956,-0.49707956,0.9685129,-0.49707956,-0.49707956,-0.49707956,0.96964121,-0.49707956,-0.49707956,-0.49707956,0.95919147,-0.49707956,-0.49707956,-0.49707956,0.96214048,-0.49707956,-0.49707956,-0.49707956,0.96084548,-0.49707956,-0.49707956,-0.49707956,0.95965306,-0.49707956,-0.49707956,-0.49707956,0.96247384,-0.49707956,-0.49707956,-0.49707956,0.95781313,-0.49707956,-0.49707956,-0.49707956,0.97164141,-0.49707956,-0.49707956,-0.49707956,0.96842956,-0.49707956,-0.49707956,-0.49707956,0.95833882,-0.49707956,-0.49707956,-0.49707956,0.96139041,-0.49707956,-0.49707956,-0.49707956,0.95847345,-0.49707956,-0.49707956,-0.49707956,0.96076214,-0.49707956,-0.49707956,-0.49707956,0.95874271,-0.49707956,-0.49707956,-0.49707956,0.96044801,-0.49707956,-0.49707956,-0.49707956,0.96275592,-0.49707956,-0.49707956,-0.49707956,0.96490998,-0.49707956,-0.49707956,-0.49707956,0.96789104,-0.49707956,-0.49707956,-0.49707956,0.96673067,-0.49707956,-0.49707956,-0.49707956,0.96707045,-0.49707956,-0.49707956,-0.49707956,0.95172279,-0.49707956,-0.49707956,-0.49707956,0.95452435,-0.49707956,-0.49707956,-0.49707956,0.96218535,-0.49707956,-0.49707956,-0.49707956,0.96040313,-0.49707956,-0.49707956,-0.49707956,0.9605634,-0.49707956,-0.49707956,-0.49707956,0.9592107,-0.49707956,-0.49707956,-0.49707956,0.96175583,-0.49707956,-0.49707956,-0.49707956,0.95899915,-0.49707956,-0.49707956,-0.49707956,0.97225044,-0.49707956,-0.49707956,-0.49707956,0.97341081,-0.49707956,-0.49707956,-0.49707956,0.97141703,-0.49707956,-0.49707956,-0.49707956,0.97566104,-0.49707956,-0.49707956,-0.49707956,0.9678077,-0.49707956,-0.49707956,-0.49707956,0.96457662,-0.49707956,-0.49707956,-0.49707956,0.95987744,-0.49707956,-0.49707956,-0.49707956,0.95613348,-0.49707956,-0.49707956,-0.49707956,0.95743489,-0.49707956,-0.49707956,-0.49707956,0.96624345,-0.49707956,-0.49707956,-0.49707956,0.96348035,-0.49707956,-0.49707956,-0.49707956,0.96547414,-0.49707956,-0.49707956,-0.49707956,0.96358293,-0.49707956,-0.49707956,-0.49707956,0.96413426,-0.49707956,-0.49707956,-0.49707956,0.96670503,-0.49707956,-0.49707956,-0.49707956,0.96346753,-0.49707956,-0.49707956,-0.49707956,0.9642753,-0.49707956,-0.49707956,-0.49707956,0.9632111,-0.49707956,-0.49707956,-0.49707956,0.96493562,-0.49707956,-0.49707956,-0.49707956,0.95827471,-0.49707956,-0.49707956,-0.49707956,0.96223023,-0.49707956,-0.49707956,-0.49707956,0.96218535,-0.49707956,-0.49707956,-0.49707956,0.96039672,-0.49707956,-0.49707956,-0.49707956,0.96166607,-0.49707956,-0.49707956,-0.49707956,0.96237127,-0.49707956,-0.49707956,-0.49707956,0.95906966,-0.49707956,-0.49707956,-0.49707956,0.96273669,-0.49707956,-0.49707956,-0.49707956,0.96312134,-0.49707956,-0.49707956,-0.49707956,0.96523694,-0.49707956,-0.49707956,-0.49707956,0.96279439,-0.49707956,-0.49707956,-0.49707956,0.96521129,-0.49707956,-0.49707956,-0.49707956,0.95949919,-0.49707956,-0.49707956,-0.49707956,0.95637068,-0.49707956,-0.49707956,-0.49707956,0.95905684,-0.49707956,-0.49707956,-0.49707956,0.95964664,-0.49707956,-0.49707956,-0.49707956,0.95804392,-0.49707956,-0.49707956,-0.49707956,0.95815932,-0.49707956,-0.49707956,-0.49707956,0.95541546,-0.49707956,-0.49707956,-0.49707956,0.96157632,-0.49707956,-0.49707956,-0.49707956,0.97314156,-0.49707956,-0.49707956,-0.49707956,0.96489075,-0.49707956,-0.49707956,-0.49707956,0.96716661,-0.49707956,-0.49707956,-0.49707956,0.96487152,-0.49707956,-0.49707956,-0.49707956,0.96762179,-0.49707956,-0.49707956,-0.49707956,0.96660887,-0.49707956,-0.49707956,-0.49707956,0.96654476,-0.49707956,-0.49707956,-0.49707956,0.97012844,-0.49707956,-0.49707956,-0.49707956,0.96633961,-0.49707956,-0.49707956,-0.49707956,0.97093621,-0.49707956,-0.49707956,-0.49707956,0.96778206,-0.49707956,-0.49707956,-0.49707956,0.96660245,-0.49707956,-0.49707956,-0.49707956,0.97346851,-0.49707956,-0.49707956,-0.49707956,0.96837186,-0.49707956,-0.49707956,-0.49707956,0.97060285,-0.49707956,-0.49707956,-0.49707956,0.96705763,-0.49707956,-0.49707956,-0.49707956,0.96522411,-0.49707956,-0.49707956,-0.49707956,0.96871805,-0.49707956,-0.49707956,-0.49707956,0.96458303,-0.49707956,-0.49707956,-0.49707956,0.96513436,-0.49707956,-0.49707956,-0.49707956,0.96513436,-0.49707956,-0.49707956,-0.49707956,0.96816671,-0.49707956,-0.49707956,-0.49707956,0.96749357,-0.49707956,-0.49707956,-0.49707956,0.96569852,-0.49707956,-0.49707956,-0.49707956,0.96640372,-0.49707956,-0.49707956,-0.49707956,0.96628832,-0.49707956,-0.49707956,-0.49707956,0.9696925,-0.49707956,-0.49707956,-0.49707956,0.97132087,-0.49707956,-0.49707956,-0.49707956,0.96888473,-0.49707956,-0.49707956,-0.49707956,0.97235943,-0.49707956,-0.49707956,-0.49707956,0.97187861,-0.49707956,-0.49707956,-0.49707956,0.97434039,-0.49707956,-0.49707956,-0.49707956,0.97316079,-0.49707956,-0.49707956,-0.49707956,0.97421218,-0.49707956,-0.49707956,-0.49707956,0.97398779,-0.49707956,-0.49707956,-0.49707956,0.97025666,-0.49707956,-0.49707956,-0.49707956,0.97217992,-0.49707956,-0.49707956,-0.49707956,0.97097468,-0.49707956,-0.49707956,-0.49707956,0.97219916,-0.49707956,-0.49707956,-0.49707956,0.97366084,-0.49707956,-0.49707956,-0.49707956,0.97259663,-0.49707956,-0.49707956,-0.49707956,0.95837088,-0.49707956,-0.49707956,-0.49707956,0.96049929,-0.49707956,-0.49707956,-0.49707956,0.95971716,-0.49707956,-0.49707956,-0.49707956,0.95963382,-0.49707956,-0.49707956,-0.49707956,0.95847986,-0.49707956,-0.49707956,-0.49707956,0.95756952,-0.49707956,-0.49707956,-0.49707956,0.95982615,-0.49707956,-0.49707956,-0.49707956,0.95799264,-0.49707956,-0.49707956,-0.49707956,0.95670405,-0.49707956,-0.49707956,-0.49707956,0.95952484,-0.49707956,-0.49707956,-0.49707956,0.95830036,-0.49707956,-0.49707956,-0.49707956,0.95488977,-0.49707956,-0.49707956,-0.49707956,0.95787083,-0.49707956,-0.49707956,-0.49707956,0.97335953,-0.49707956,-0.49707956,-0.49707956,0.97484685,-0.49707956,-0.49707956,-0.49707956,0.97132087,-0.49707956,-0.49707956,-0.49707956,0.97069901,-0.49707956,-0.49707956,-0.49707956,0.9734621,-0.49707956,-0.49707956,-0.49707956,0.97291077,-0.49707956,-0.49707956,-0.49707956,0.97241713,-0.49707956,-0.49707956,-0.49707956,0.97230814,-0.49707956,-0.49707956,-0.49707956,0.97355827,-0.49707956,-0.49707956,-0.49707956,0.97452631,-0.49707956,-0.49707956,-0.49707956,0.97348133,-0.49707956,-0.49707956,-0.49707956,0.97019255,-0.49707956,-0.49707956,-0.49707956,0.97453913,-0.49707956,-0.49707956,-0.49707956,0.97178245,-0.49707956,-0.49707956,-0.49707956,0.97280178,-0.49707956,-0.49707956,-0.49707956,0.97509047,-0.49707956,-0.49707956,-0.49707956,0.97435322,-0.49707956,-0.49707956,-0.49707956,0.97575079,-0.49707956,-0.49707956,-0.49707956,0.9747571,-0.49707956,-0.49707956,-0.49707956,0.97480839,-0.49707956,-0.49707956,-0.49707956,0.97428911,-0.49707956,-0.49707956,-0.49707956,0.96014669,-0.49707956,-0.49707956,-0.49707956,0.95851192,-0.49707956,-0.49707956,-0.49707956,0.96115961,-0.49707956,-0.49707956,-0.49707956,0.95876835,-0.49707956,-0.49707956,-0.49707956,0.95978127,-0.49707956,-0.49707956,-0.49707956,0.95327422,-0.49707956,-0.49707956,-0.49707956,0.95229977,-0.49707956,-0.49707956,-0.49707956,0.95295368,-0.49707956,-0.49707956,-0.49707956,0.95663353,-0.49707956,-0.49707956,-0.49707956,0.96908347,-0.49707956,-0.49707956,-0.49707956,0.97076953,-0.49707956,-0.49707956,-0.49707956,0.97153884,-0.49707956,-0.49707956,-0.49707956,0.97292359,-0.49707956,-0.49707956,-0.49707956,0.9734044,-0.49707956,-0.49707956,-0.49707956,0.96946812,-0.49707956,-0.49707956,-0.49707956,0.97105161,-0.49707956,-0.49707956,-0.49707956,0.96950017,-0.49707956,-0.49707956,-0.49707956,0.96999381,-0.49707956,-0.49707956,-0.49707956,0.96870523,-0.49707956,-0.49707956,-0.49707956,0.96780129,-0.49707956,-0.49707956,-0.49707956,0.97143626,-0.49707956,-0.49707956,-0.49707956,0.96988483,-0.49707956,-0.49707956,-0.49707956,0.96815389,-0.49707956,-0.49707956,-0.49707956,0.96863471,-0.49707956,-0.49707956,-0.49707956,0.9693976,-0.49707956,-0.49707956,-0.49707956,0.96830775,-0.49707956,-0.49707956,-0.49707956,0.96782693,-0.49707956,-0.49707956,-0.49707956,0.96892961,-0.49707956,-0.49707956,-0.49707956,0.97403267,-0.49707956,-0.49707956,-0.49707956,0.97426987,-0.49707956,-0.49707956,-0.49707956,0.97030795,-0.49707956,-0.49707956,-0.49707956,0.97110931,-0.49707956,-0.49707956,-0.49707956,0.95710793,-0.49707956,-0.49707956,-0.49707956,0.95728103,-0.49707956,-0.49707956,-0.49707956,0.95515261,-0.49707956,-0.49707956,-0.49707956,0.95704383,-0.49707956,-0.49707956,-0.49707956,0.95746694,-0.49707956,-0.49707956,-0.49707956,0.95530006,-0.49707956,-0.49707956,-0.49707956,0.95484489,-0.49707956,-0.49707956,-0.49707956,0.95328705,-0.49707956,-0.49707956,-0.49707956,0.95413969,-0.49707956,-0.49707956,-0.49707956,0.96918604,-0.49707956,-0.49707956,-0.49707956,0.97015409,-0.49707956,-0.49707956,-0.49707956,0.96907065,-0.49707956,-0.49707956,-0.49707956,0.96915399,-0.49707956,-0.49707956,-0.49707956,0.96562159,-0.49707956,-0.49707956,-0.49707956,0.96777565,-0.49707956,-0.49707956,-0.49707956,0.96937196,-0.49707956,-0.49707956,-0.49707956,0.9682757,-0.49707956,-0.49707956,-0.49707956,0.96914117,-0.49707956,-0.49707956,-0.49707956,0.96800003,-0.49707956,-0.49707956,-0.49707956,0.96901936,-0.49707956,-0.49707956,-0.49707956,0.96955146,-0.49707956,-0.49707956,-0.49707956,0.97184656,-0.49707956,-0.49707956,-0.49707956,0.97271844,-0.49707956,-0.49707956,-0.49707956,0.97082082,-0.49707956,-0.49707956,-0.49707956,0.96944889,-0.49707956,-0.49707956,-0.49707956,0.96687171,-0.49707956,-0.49707956,-0.49707956,0.9673333,-0.49707956,-0.49707956,-0.49707956,0.96652552,-0.49707956,-0.49707956,-0.49707956,0.96622421,-0.49707956,-0.49707956,-0.49707956,0.9609737,-0.49707956,-0.49707956,-0.49707956,0.9633329,-0.49707956,-0.49707956,-0.49707956,0.96968609,-0.49707956,-0.49707956,-0.49707956,0.96894884,-0.49707956,-0.49707956,-0.49707956,0.96865394,-0.49707956,-0.49707956,-0.49707956,0.96614728,-0.49707956,-0.49707956,-0.49707956,0.96487793,-0.49707956,-0.49707956,-0.49707956,0.96714097,-0.49707956,-0.49707956,-0.49707956,0.96524976,-0.49707956,-0.49707956,-0.49707956,0.95076116,-0.49707956,-0.49707956,-0.49707956,0.95281905,-0.49707956,-0.49707956,-0.49707956,0.95072269,-0.49707956,-0.49707956,-0.49707956,0.95131249,-0.49707956,-0.49707956,-0.49707956,0.96389706,-0.49707956,-0.49707956,-0.49707956,0.96488434,-0.49707956,-0.49707956,-0.49707956,0.96520488,-0.49707956,-0.49707956,-0.49707956,0.96685889,-0.49707956,-0.49707956,-0.49707956,0.96653194,-0.49707956,-0.49707956,-0.49707956,0.96754485,-0.49707956,-0.49707956,-0.49707956,0.96465355,-0.49707956,-0.49707956,-0.49707956,0.96485869,-0.49707956,-0.49707956,-0.49707956,0.96448686,-0.49707956,-0.49707956,-0.49707956,0.96217894,-0.49707956,-0.49707956,-0.49707956,0.96400605,-0.49707956,-0.49707956,-0.49707956,0.96536515,-0.49707956,-0.49707956,-0.49707956,0.96438429,-0.49707956,-0.49707956,-0.49707956,0.9679231,-0.49707956,-0.49707956,-0.49707956,0.9640958,-0.49707956,-0.47839824,5.1518014,0.95287675,-0.47220533,-0.47773151,5.1424607,0.95605655,-0.47230149,-0.47773151,5.1124321,0.95365888,-0.47239124,-0.47839824,5.1144323,0.95507568,-0.47241047,-0.47839824,5.1117654,0.95558214,-0.47242971,-0.47839824,5.076403,0.9519023,-0.47252587,-0.47839824,5.0790699,0.95349861,-0.47253869,-0.49707956,-0.48373851,0.96376884,-0.49702186,-0.49707956,-0.48373851,0.96635243,-0.49702186,-0.49707956,-0.48373851,0.96394194,-0.49702186,-0.49707956,-0.48373851,0.96440352,-0.49702186,-0.49707956,-0.48373851,0.96407657,-0.49702186,-0.49707956,-0.48373851,0.96383936,-0.49702186,-0.49707956,-0.48373851,0.9661601,-0.49702186,-0.49707956,-0.48373851,0.96692941,-0.49702186,-0.49707956,-0.48373851,0.96610882,-0.49702186,-0.49707956,-0.48373851,0.96625627,-0.49702186,-0.49707956,-0.48373851,0.95558855,-0.49702186,-0.49707956,-0.48440524,0.952319,-0.49702827,-0.49707956,-0.48440524,0.95310113,-0.49702827,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186,-0.49707956,-0.48373851,0.95477437,-0.49702186:3
-0.51652215,-0.51652215,1.4409958,-0.51652215,-0.51652215,-0.51652215,1.4408368,-0.51652215,-0.51652215,-0.51652215,1.4410543,-0.51652215,-0.51652215,-0.51652215,1.4418909,-0.51652215,-0.51652215,-0.51652215,1.440979,-0.51652215,-0.59052681,8.7470616,1.3890938,-0.47530341,-0.62100375,-0.51043178,1.4408201,-0.51607876,-0.62100375,-0.51043178,1.4406109,-0.51607876,-0.58443644,6.4579365,1.3993671,-0.48075797,-0.62100375,-0.51043178,1.4409372,-0.51607876,-0.62100375,-0.51043178,1.4394899,-0.51607876,-0.5992357,4.2619823,1.4121418,-0.48692363,-0.62100375,-0.51043178,1.4415312,-0.51607876,-0.62100375,-0.51043178,1.441916,-0.51607876,-0.6218738,-0.51043178,1.4424012,-0.51607876,-0.62100375,-0.51043178,1.4415647,-0.51607876,-0.62100375,-0.51043178,1.4398496,-0.51607876,-0.6218738,-0.51043178,1.4434052,-0.51607876,-0.62100375,-0.51043178,1.4411045,-0.51607876,-0.62100375,-0.51043178,1.4391553,-0.51607876,-0.62100375,-0.51043178,1.4358424,-0.51607876,-0.62100375,-0.51043178,1.4376912,-0.51607876,-0.62100375,-0.51043178,1.4358842,-0.51607876,-0.62100375,-0.51043178,1.4364531,-0.51607876,-0.62100375,-0.51043178,1.4350895,-0.51607876,-0.62100375,-0.51043178,1.4343282,-0.51607876,-0.60184586,4.235864,1.4068546,-0.48699892,-0.6201337,-0.51043178,1.4346795,-0.51607876,-0.6201337,-0.51043178,1.4325797,-0.51607876,-0.62100375,-0.51043178,1.4349807,-0.51607876,-0.6201337,-0.51043178,1.4338095,-0.51607876,-0.62100375,-0.51043178,1.4354994,-0.51607876,-0.62100375,-0.51043178,1.4375658,-0.51607876,-0.62100375,-0.51043178,1.4373231,-0.51607876,-0.62100375,-0.51043178,1.4363443,-0.51607876,-0.62100375,-0.51043178,1.4351648,-0.51607876,-0.62100375,-0.51043178,1.4350309,-0.51607876,-0.62100375,-0.51043178,1.4373901,-0.51607876,-0.62100375,-0.51043178,1.4366622,-0.51607876,-0.62100375,-0.51043178,1.4353237,-0.51607876,-0.62100375,-0.51043178,1.4363778,-0.51607876,-0.6201337,-0.51043178,1.4350393,-0.51607876,-0.6201337,-0.51043178,1.433592,-0.51607876,-0.62100375,-0.51043178,1.4345373,-0.51607876,-0.6201337,-0.51043178,1.4331067,-0.51607876,-0.6218738,-0.51043178,1.4457141,-0.51607876,-0.6218738,-0.51043178,1.4462412,-0.51607876,-0.62100375,-0.51043178,1.4355663,-0.51607876,-0.6218738,-0.51043178,1.4428363,-0.51607876,-0.6201337,-0.51043178,1.434027,-0.51607876,-0.6218738,-0.51043178,1.4438318,-0.51607876,-0.62100375,-0.51043178,1.4390298,-0.51607876,-0.6218738,-0.51043178,1.4436227,-0.51607876,-0.6201337,-0.51043178,1.4346712,-0.51607876,-0.6218738,-0.51043178,1.4463667,-0.51607876,-0.62100375,-0.51043178,1.4353823,-0.51607876,-0.60271591,4.2193163,1.4081011,-0.48704912,-0.62100375,-0.51043178,1.4366706,-0.51607876,-0.62100375,-0.51043178,1.4361017,-0.51607876,-0.62100375,-0.51043178,1.4371391,-0.51607876,-0.62100375,-0.51043178,1.4397576,-0.51607876,-0.62100375,-0.51043178,1.4386366,-0.51607876,-0.62100375,-0.51043178,1.4384274,-0.51607876,-0.62100375,-0.51043178,1.4396238,-0.51607876,-0.62100375,-0.51043178,1.4398664,-0.51607876,-0.62100375,-0.51043178,1.4414224,-0.51607876,-0.62100375,-0.51043178,1.441046,-0.51607876,-0.62100375,-0.51043178,1.4412719,-0.51607876,-0.62100375,-0.51043178,1.4396991,-0.51607876,-0.62100375,-0.51043178,1.4389378,-0.51607876,-0.6201337,-0.51043178,1.4362523,-0.51607876,-0.62100375,-0.51043178,1.4367375,-0.51607876,-0.62100375,-0.51043178,1.4370471,-0.51607876,-0.62100375,-0.51043178,1.4380593,-0.51607876,-0.60533444,4.1714299,1.411414,-0.48720807,-0.62100375,-0.51043178,1.4361101,-0.51607876,-0.62100375,-0.51043178,1.438051,-0.51607876,-0.62100375,-0.51043178,1.436863,-0.51607876,-0.6201337,-0.51043178,1.4333577,-0.51607876,-0.6201337,-0.51043178,1.4317013,-0.51607876,-0.6201337,-0.51043178,1.4330984,-0.51607876,-0.62100375,-0.51043178,1.4382518,-0.51607876,-0.62100375,-0.51043178,1.4375407,-0.51607876,-0.62100375,-0.51043178,1.4378084,-0.51607876,-0.62100375,-0.51043178,1.4376996,-0.51607876,-0.62100375,-0.51043178,1.4380761,-0.51607876,-0.61229486,3.9772576,1.4127693,-0.48781878,-0.6201337,-0.51043178,1.4359009,-0.51607876,-0.62100375,-0.51043178,1.4361101,-0.51607876,-0.62100375,-0.51043178,1.4376578,-0.51607876,-0.62100375,-0.51043178,1.4359009,-0.51607876,-0.62100375,-0.51043178,1.4366957,-0.51607876,-0.62100375,-0.51043178,1.4372479,-0.51607876,-0.62100375,-0.51043178,1.4366371,-0.51607876,-0.6201337,-0.51043178,1.4354241,-0.51607876,-0.62100375,-0.51043178,1.435834,-0.51607876,-0.62100375,-0.51043178,1.4367877,-0.51607876,-0.62100375,-0.51043178,1.4362021,-0.51607876,-0.62100375,-0.51043178,1.4361101,-0.51607876,-0.62100375,-0.51043178,1.4362774,-0.51607876,-0.6201337,-0.51043178,1.4348887,-0.51607876,-0.62100375,3.4513443,1.414593,-0.48955888,-0.62100375,-0.51043178,1.4360264,-0.51607876,-0.62100375,-0.51043178,1.4358926,-0.51607876,-0.62100375,-0.51043178,1.4370136,-0.51607876,-0.62100375,-0.51043178,1.4356918,-0.51607876,-0.6201337,-0.51043178,1.4357671,-0.51607876,-0.62100375,-0.51043178,1.4356249,-0.51607876,-0.6201337,-0.51043178,1.4355161,-0.51607876,-0.62100375,-0.51043178,1.4360432,-0.51607876,-0.62100375,-0.51043178,1.4362439,-0.51607876,-0.6201337,-0.51043178,1.4355663,-0.51607876,-0.62100375,-0.51043178,1.4360432,-0.51607876,-0.62100375,-0.51043178,1.4361938,-0.51607876,-0.62100375,-0.51043178,1.4360432,-0.51607876,-0.62100375,-0.51043178,1.4357169,-0.51607876,-0.62100375,-0.51043178,1.4378669,-0.51607876,-0.6201337,-0.51043178,1.4358089,-0.51607876,-0.6201337,-0.51043178,1.4347716,-0.51607876,-0.6201337,-0.51043178,1.436177,-0.51607876,-0.6201337,-0.51043178,1.4348468,-0.51607876,-0.6201337,-0.51043178,1.4342696,-0.51607876,-0.62535401,2.415187,1.4178557,-0.49334027,-0.6201337,-0.51043178,1.434897,-0.51607876,-0.6201337,-0.51043178,1.4369467,-0.51607876,-0.6201337,-0.51043178,1.434621,-0.51607876,-0.6201337,-0.51043178,1.4342445,-0.51607876,-0.62100375,-0.51043178,1.4352066,-0.51607876,-0.62100375,-0.51043178,1.4322869,-0.51607876,-0.62100375,-0.51043178,1.4349891,-0.51607876,-0.6201337,-0.51043178,1.434964,-0.51607876,-0.6201337,-0.51043178,1.4345206,-0.51607876,-0.6201337,-0.51043178,1.4363109,-0.51607876,-0.6201337,-0.51043178,1.4345708,-0.51607876,-0.6201337,-0.51043178,1.4341106,-0.51607876,-0.62100375,-0.51043178,1.4378753,-0.51607876,-0.62100375,-0.51043178,1.4376243,-0.51607876,-0.62100375,-0.51043178,1.4373315,-0.51607876,-0.62100375,-0.51043178,1.4389712,-0.51607876,-0.62100375,-0.51043178,1.4389294,-0.51607876,-0.62100375,-0.51043178,1.4399751,-0.51607876,-0.62100375,-0.51043178,1.4387035,-0.51607876,-0.62100375,-0.51043178,1.4398831,-0.51607876,-0.19697024,9.347858,1.3845511,-0.47332906,-0.62100375,-0.50956173,1.439607,-0.51607876,-0.62100375,-0.51043178,1.4403683,-0.51607876,-0.62100375,-0.51043178,1.442602,-0.51607876,-0.62100375,-0.51043178,1.4415563,-0.51607876,-0.62100375,-0.51043178,1.4410543,-0.51607876,-0.62100375,-0.51043178,1.43995,-0.51607876,-0.62100375,-0.51043178,1.4416567,-0.51607876,-0.62100375,-0.51043178,1.4413722,-0.51607876,-0.62100375,-0.51043178,1.4411631,-0.51607876,-0.62100375,-0.51043178,1.4399166,-0.51607876,-0.62100375,-0.51043178,1.439674,-0.51607876,-0.6218738,-0.51043178,1.4424431,-0.51607876,-0.62100375,-0.51043178,1.4413053,-0.51607876,-0.62100375,-0.51043178,1.4408034,-0.51607876,-0.62100375,-0.51043178,1.440887,-0.51607876,-0.62100375,-0.51043178,1.4410794,-0.51607876,-0.62100375,-0.51043178,1.441046,-0.51607876,-0.62100375,-0.51043178,1.4418742,-0.51607876,-0.62100375,-0.51043178,1.4430705,-0.51607876,-0.61055475,4.098287,1.4182824,-0.48743395,-0.62100375,-0.51043178,1.4427442,-0.51607876,-0.62100375,-0.51043178,1.4374319,-0.51607876,-0.62100375,-0.51043178,1.4351062,-0.51607876,-0.62100375,-0.51043178,1.435491,-0.51607876,-0.62100375,-0.51043178,1.440293,-0.51607876,-0.6096847,4.0451719,1.4138652,-0.48760126,-0.62100375,-0.51043178,1.4400421,-0.51607876,-0.62100375,-0.51043178,1.4395066,-0.51607876,-0.62100375,-0.51043178,1.4386115,-0.51607876,-0.62100375,-0.51043178,1.4394899,-0.51607876,-0.62100375,-0.51043178,1.4399835,-0.51607876,-0.60881465,4.077389,1.4140911,-0.48750087,-0.62100375,-0.51043178,1.4414894,-0.51607876,-0.6201337,-0.51043178,1.4341943,-0.51607876,-0.62100375,-0.51043178,1.4361854,-0.51607876,-0.62100375,-0.51043178,1.4373148,-0.51607876,-0.62100375,-0.51043178,1.4373984,-0.51607876,-0.61055475,4.0443019,1.4108953,-0.48760126,-0.62100375,-0.51043178,1.4369885,-0.51607876,-0.62100375,-0.51043178,1.4402345,-0.51607876,-0.62100375,-0.51043178,1.4394565,-0.51607876,-0.62100375,-0.51043178,1.4391135,-0.51607876,-0.62100375,-0.51043178,1.4409874,-0.51607876,-0.62100375,-0.51043178,1.4394815,-0.51607876,-0.62100375,-0.51043178,1.439607,-0.51607876,-0.62100375,-0.51043178,1.4383187,-0.51607876,-0.62100375,-0.51043178,1.4395652,-0.51607876,-0.62100375,-0.51043178,1.4417822,-0.51607876,-0.62100375,-0.51043178,1.4413388,-0.51607876,-0.62100375,-0.51043178,1.4414224,-0.51607876,-0.62100375,-0.51043178,1.4406779,-0.51607876,-0.62100375,-0.51043178,1.4411631,-0.51607876,-0.62100375,-0.51043178,1.4414559,-0.51607876,-0.62100375,-0.51043178,1.4406779,-0.51607876,-0.62100375,-0.51043178,1.4400002,-0.51607876,-0.62100375,-0.51043178,1.4401006,-0.51607876,-0.62100375,-0.51043178,1.4388625,-0.51607876,-0.62100375,-0.51043178,1.4403265,-0.51607876,-0.62100375,-0.51043178,1.4399417,-0.51607876,-0.62100375,-0.51043178,1.4410125,-0.51607876,-0.62100375,-0.51043178,1.4430036,-0.51607876,-0.6218738,-0.51043178,1.442945,-0.51607876,-0.62100375,-0.51043178,1.4421001,-0.51607876,-0.62100375,-0.51043178,1.4415396,-0.51607876,-0.62100375,-0.51043178,1.4422423,-0.51607876,-0.62100375,-0.51043178,1.4405607,-0.51607876,-0.62100375,-0.51043178,1.441481,-0.51607876,-0.62100375,-0.51043178,1.4411798,-0.51607876,-0.62100375,-0.51043178,1.4406109,-0.51607876,-0.62100375,-0.51043178,1.4411129,-0.51607876,-0.62100375,-0.51043178,1.4421168,-0.51607876,-0.62100375,-0.51043178,1.4381095,-0.51607876,-0.62100375,-0.51043178,1.4415312,-0.51607876,-0.62100375,-0.51043178,1.4404687,-0.51607876,-0.62100375,-0.51043178,1.4412384,-0.51607876,-0.62100375,-0.51043178,1.4416483,-0.51607876,-0.62100375,-0.51043178,1.4408201,-0.51607876,-0.62100375,-0.51043178,1.4385948,-0.51607876,-0.62100375,-0.51043178,1.4392891,-0.51607876,-0.62100375,-0.51043178,1.4402679,-0.51607876,-0.62100375,-0.51043178,1.4398329,-0.51607876,-0.62100375,-0.51043178,1.4384107,-0.51607876,-0.62100375,-0.51043178,1.438394,-0.51607876,-0.62100375,-0.51043178,1.4395066,-0.51607876,-0.62100375,-0.51043178,1.4392138,-0.51607876,-0.62100375,-0.51043178,1.4398413,-0.51607876,-0.62100375,-0.51043178,1.4401341,-0.51607876,-0.62100375,-0.51043178,1.4407866,-0.51607876,-0.62100375,-0.51043178,1.4396489,-0.51607876,-0.62100375,-0.51043178,1.4406862,-0.51607876,-0.62100375,-0.51043178,1.4400923,-0.51607876,-0.62100375,-0.51043178,1.4412384,-0.51607876,-0.62100375,-0.51043178,1.4439573,-0.51607876,-0.6218738,-0.51043178,1.4444425,-0.51607876,-0.62100375,-0.51043178,1.4436729,-0.51607876,-0.62100375,-0.51043178,1.4417487,-0.51607876,-0.62100375,-0.51043178,1.4413639,-0.51607876,-0.62100375,-0.51043178,1.4420582,-0.51607876,-0.62100375,-0.51043178,1.4432295,-0.51607876,-0.62100375,-0.51043178,1.4388123,-0.51607876,-0.62100375,-0.51043178,1.4399333,-0.51607876,-0.62100375,-0.51043178,1.4422256,-0.51607876,-0.62100375,-0.51043178,1.4423594,-0.51607876,-0.62100375,-0.51043178,1.4415479,-0.51607876,-0.62100375,-0.51043178,1.4426941,-0.51607876,-0.62100375,-0.51043178,1.4438569,-0.51607876,-0.62100375,-0.51043178,1.4441079,-0.51607876,-0.62100375,-0.51043178,1.4433215,-0.51607876,-0.62100375,-0.51043178,1.4417152,-0.51607876,-0.6218738,-0.51043178,1.4456305,-0.51607876,-0.6218738,-0.51043178,1.444568,-0.51607876,-0.62100375,-0.51043178,1.4429283,-0.51607876,-0.6218738,-0.51043178,1.4453042,-0.51607876,-0.6218738,-0.51043178,1.4443923,-0.51607876,-0.6218738,-0.51043178,1.4448525,-0.51607876,-0.6218738,-0.51043178,1.4445764,-0.51607876,-0.6218738,-0.51043178,1.4440075,-0.51607876,-0.6218738,-0.51043178,1.4452791,-0.51607876,-0.6218738,-0.51043178,1.444819,-0.51607876,-0.6218738,-0.51043178,1.4444174,-0.51607876,-0.62100375,-0.51043178,1.4428781,-0.51607876,-0.62100375,-0.51043178,1.4418324,-0.51607876,-0.62100375,-0.51043178,1.4394983,-0.51607876,-0.62100375,-0.51043178,1.4389294,-0.51607876,-0.62100375,-0.51043178,1.4376494,-0.51607876,-0.6201337,-0.51043178,1.4371307,-0.51607876,-0.62100375,-0.51043178,1.4379673,-0.51607876,-0.62100375,-0.51043178,1.438829,-0.51607876,-0.62100375,-0.51043178,1.4383438,-0.51607876,-0.62100375,-0.51043178,1.437892,-0.51607876,-0.62100375,-0.51043178,1.4377833,-0.51607876,-0.62100375,-0.51043178,1.4384693,-0.51607876,-0.62100375,-0.51043178,1.4382852,-0.51607876,-0.6201337,-0.51043178,1.4357755,-0.51607876,-0.62100375,-0.51043178,1.439858,-0.51607876,-0.62100375,-0.51043178,1.4393142,-0.51607876,-0.62100375,-0.51043178,1.4378586,-0.51607876,-0.62100375,-0.51043178,1.4413722,-0.51607876,-0.62100375,-0.51043178,1.4421419,-0.51607876,-0.62100375,-0.51043178,1.4407281,-0.51607876,-0.62100375,-0.51043178,1.4406779,-0.51607876,-0.62100375,-0.51043178,1.4402512,-0.51607876,-0.62100375,-0.51043178,1.4428279,-0.51607876,-0.62100375,-0.51043178,1.4414057,-0.51607876,-0.62100375,-0.51043178,1.4409958,-0.51607876,-0.62100375,-0.51043178,1.4423678,-0.51607876,-0.62100375,-0.51043178,1.4397995,-0.51607876,-0.62100375,-0.51043178,1.4431876,-0.51607876,-0.62100375,-0.51043178,1.4425853,-0.51607876,-0.62100375,-0.51043178,1.4408787,-0.51607876,-0.62100375,-0.51043178,1.4421252,-0.51607876,-0.6218738,-0.51043178,1.4430956,-0.51607876,-0.6218738,-0.51043178,1.4445847,-0.51607876,-0.6218738,-0.51043178,1.4441581,-0.51607876,-0.6218738,-0.51043178,1.444041,-0.51607876,-0.6218738,-0.51043178,1.4436227,-0.51607876,-0.62100375,-0.51043178,1.4441832,-0.51607876,-0.62100375,-0.51043178,1.4441832,-0.51607876,-0.62100375,-0.51043178,1.4435306,-0.51607876,-0.62100375,-0.51043178,1.443539,-0.51607876,-0.62100375,-0.51043178,1.44466,-0.51607876,-0.6218738,-0.51043178,1.4455468,-0.51607876,-0.62100375,-0.51043178,1.4429952,-0.51607876,-0.6218738,-0.51043178,1.4458145,-0.51607876,-0.6218738,-0.51043178,1.4471112,-0.51607876,-0.6218738,-0.51043178,1.4459317,-0.51607876,-0.62100375,-0.51043178,1.4429199,-0.51607876,-0.62100375,-0.51043178,1.4426355,-0.51607876,-0.62100375,-0.51043178,1.4435306,-0.51607876,-0.6218738,-0.51043178,1.4443254,-0.51607876,-0.62100375,-0.51043178,1.4435306,-0.51607876,-0.6218738,-0.51043178,1.4460237,-0.51607876,-0.62100375,-0.51043178,1.443698,-0.51607876,-0.62100375,-0.51043178,1.4425184,-0.51607876,-0.62100375,-0.51043178,1.4413471,-0.51607876,-0.62100375,-0.51043178,1.4416483,-0.51607876,-0.62100375,-0.51043178,1.4400337,-0.51607876,-0.62100375,-0.51043178,1.4414392,-0.51607876,-0.62100375,-0.51043178,1.4398413,-0.51607876,-0.62100375,-0.51043178,1.4429032,-0.51607876,-0.6201337,-0.51043178,1.4350811,-0.51607876,-0.62100375,-0.51043178,1.437457,-0.51607876,-0.62100375,-0.51043178,1.4371642,-0.51607876,-0.62100375,-0.51043178,1.4417822,-0.51607876,-0.62100375,-0.51043178,1.4427526,-0.51607876,-0.62100375,-0.51043178,1.4415479,-0.51607876,-0.62100375,-0.51043178,1.4428697,-0.51607876,-0.6218738,-0.51043178,1.4433801,-0.51607876,-0.62100375,-0.51043178,1.4430789,-0.51607876,-0.62100375,-0.51043178,1.4422925,-0.51607876,-0.62100375,-0.51043178,1.4421419,-0.51607876,-0.62100375,-0.51043178,1.4428195,-0.51607876,-0.62100375,-0.51043178,1.4440744,-0.51607876,-0.6218738,-0.51043178,1.4450951,-0.51607876,-0.6218738,-0.51043178,1.4447772,-0.51607876,-0.62100375,-0.51043178,1.4422256,-0.51607876,-0.6218738,-0.51043178,1.4451034,-0.51607876,-0.6218738,-0.51043178,1.4442836,-0.51607876,-0.6218738,-0.51043178,1.4452373,-0.51607876,-0.6218738,-0.51043178,1.4454213,-0.51607876,-0.6218738,-0.51043178,1.4445931,-0.51607876,-0.6218738,-0.51043178,1.4457225,-0.51607876,-0.6218738,-0.51043178,1.4448943,-0.51607876,-0.6218738,-0.51043178,1.4438569,-0.51607876,-0.6218738,-0.51043178,1.4450616,-0.51607876,-0.6218738,-0.51043178,1.4450198,-0.51607876,-0.6218738,-0.51043178,1.4455301,-0.51607876,-0.6218738,-0.51043178,1.4475965,-0.51607876,-0.6218738,-0.51043178,1.4432295,-0.51607876,-0.6218738,-0.51043178,1.4434386,-0.51607876,-0.62100375,-0.51043178,1.4437733,-0.51607876,-0.62100375,-0.51043178,1.4406862,-0.51607876,-0.62100375,-0.51043178,1.4410878,-0.51607876,-0.62100375,-0.51043178,1.4414559,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876,-0.62100375,-0.51043178,1.4416149,-0.51607876:3
-0.45324544,-0.5535456,1.3825265,-0.5869734,-0.45586,-0.53086933,1.3848143,-0.58695664,-0.2317119,12.026888,1.3047434,-0.53175761,-0.45586,-0.52999781,1.3847975,-0.58695664,-0.24479307,10.913103,1.3112882,-0.53696997,-0.45324544,-0.55093104,1.3845629,-0.5869734,-0.45324544,-0.55005952,1.3846215,-0.5869734,-0.45586,-0.55093104,1.3813617,-0.58698178,-0.45324544,-0.55005952,1.3843953,-0.5869734,-0.45324544,-0.55005952,1.3847137,-0.5869734,-0.45498848,-0.55093104,1.3826019,-0.58698178,-0.4567399,-0.55093104,1.380046,-0.58698178,-0.4515024,-0.55005952,1.3877221,-0.58696502,-0.45237392,-0.55005952,1.3864819,-0.58696502,-0.45063088,-0.55005952,1.3889121,-0.58695664,-0.45063088,-0.55005952,1.3895238,-0.58695664,-0.44975936,-0.55005952,1.3905462,-0.58695664,-0.4515024,-0.55005952,1.3873199,-0.58696502,-0.45063088,-0.55005952,1.388711,-0.58695664,-0.45063088,-0.55005952,1.389021,-0.58695664,-0.44975936,-0.55005952,1.3903702,-0.58695664,-0.45063088,-0.55005952,1.3889037,-0.58695664,-0.4515024,-0.55005952,1.3875713,-0.58696502,-0.4515024,-0.55005952,1.3880238,-0.58696502,-0.4515024,-0.55005952,1.3881244,-0.58696502,-0.45063088,-0.55005952,1.389792,-0.58695664,-0.45237392,-0.55005952,1.3879735,-0.58696502,-0.45063088,-0.55005952,1.3894316,-0.58695664,-0.45237392,-0.55005952,1.386926,-0.58696502,-0.4515024,-0.55005952,1.3882165,-0.58696502,-0.4515024,-0.55005952,1.3889707,-0.58696502,-0.4515024,-0.55005952,1.3889707,-0.58696502,-0.45324544,-0.55005952,1.3853673,-0.5869734,-0.45324544,-0.55005952,1.3865238,-0.5869734,-0.45237392,-0.55005952,1.3872026,-0.58696502,-0.45063088,-0.55005952,1.388845,-0.58695664,-0.44975936,-0.549188,1.3908227,-0.58695664,-0.44975936,-0.55005952,1.3899679,-0.58695664,-0.44975936,-0.55005952,1.390697,-0.58695664,-0.44975936,-0.55005952,1.3907221,-0.58695664,-0.44975936,-0.55005952,1.3903702,-0.58695664,-0.4515024,-0.55005952,1.3888869,-0.58696502,-0.45411696,-0.55093104,1.3845293,-0.5869734,-0.45324544,-0.55005952,1.3849567,-0.5869734,-0.45324544,-0.55005952,1.3857109,-0.5869734,-0.45237392,-0.55005952,1.3867417,-0.58696502,-0.45237392,-0.55005952,1.3875629,-0.58696502,-0.45237392,-0.55005952,1.3872445,-0.58696502,-0.45237392,-0.55005952,1.3875042,-0.58696502,-0.45324544,-0.55005952,1.3866076,-0.5869734,-0.45324544,-0.55005952,1.38644,-0.5869734,-0.45237392,-0.55005952,1.3864819,-0.58696502,-0.4515024,-0.55005952,1.3886104,-0.58696502,-0.45063088,-0.55005952,1.3900936,-0.58695664,-0.45237392,-0.55005952,1.3874791,-0.58696502,-0.4515024,-0.55005952,1.3884931,-0.58696502,-0.45237392,-0.55005952,1.3878562,-0.58696502,-0.44975936,-0.55005952,1.3915769,-0.58695664,-0.45063088,-0.55005952,1.3901607,-0.58696502,-0.45063088,-0.55005952,1.3898171,-0.58695664,-0.4515024,-0.55005952,1.3889707,-0.58696502,-0.44975936,-0.55005952,1.3906886,-0.58695664,-0.44888784,-0.549188,1.3924233,-0.58695664,-0.44975936,-0.55005952,1.3923143,-0.58695664,-0.44888784,-0.549188,1.3931942,-0.58695664,-0.44975936,-0.55005952,1.3927585,-0.58695664,-0.45063088,-0.55005952,1.3913506,-0.58696502,-0.44888784,-0.549188,1.3932445,-0.58695664,-0.4515024,-0.549188,1.3894484,-0.58696502,-0.44888784,-0.549188,1.3931272,-0.58695664,-0.44975936,-0.55005952,1.3913925,-0.58695664,-0.45063088,-0.55005952,1.3902445,-0.58696502,-0.44975936,-0.55005952,1.3910741,-0.58695664,-0.44888784,-0.549188,1.3925657,-0.58695664,-0.45063088,-0.55005952,1.3906719,-0.58696502,-0.45063088,-0.55005952,1.3900685,-0.58695664,-0.45237392,-0.55005952,1.3876718,-0.58696502,-0.4515024,-0.55005952,1.3882836,-0.58696502,-0.44539339,-0.549188,1.3986999,-0.58693988,-0.44452187,-0.54831648,1.3992446,-0.58693988,-0.44627329,-0.549188,1.3962194,-0.58694826,-0.44452187,-0.549188,1.3981887,-0.58693988,-0.44452187,-0.549188,1.39901,-0.58693988,-0.44627329,-0.549188,1.3975518,-0.58694826,-0.44627329,-0.54657344,1.3967976,-0.58693988,-0.44539339,-0.549188,1.3976105,-0.58693988,-0.44539339,-0.549188,1.3980798,-0.58693988,-0.44627329,-0.549188,1.3973591,-0.58694826,-0.44627329,-0.549188,1.3973088,-0.58694826,-0.44714481,-0.549188,1.3958339,-0.58694826,-0.44714481,-0.549188,1.3953144,-0.58694826,-0.44539339,-0.549188,1.3973591,-0.58693988,-0.44627329,-0.54395889,1.3961105,-0.58693988,-0.44801633,-0.549188,1.3931859,-0.58694826,-0.44801633,-0.549188,1.3940993,-0.58694826,-0.44539339,-0.549188,1.3981217,-0.58693988,-0.44452187,-0.54831648,1.3985993,-0.58693988,-0.44452187,-0.54831648,1.3987502,-0.58693988,-0.44452187,-0.549188,1.3991105,-0.58693988,-0.44452187,-0.54831648,1.3988675,-0.58693988,-0.44539339,-0.53697835,1.3983647,-0.58692312,-0.44365035,-0.54831648,1.3998815,-0.5869315,-0.44452187,-0.54831648,1.3991524,-0.58693988,-0.44452187,-0.54831648,1.399429,-0.58693988,-0.44452187,-0.549188,1.398591,-0.58693988,-0.44539339,-0.549188,1.3974261,-0.58693988,-0.44627329,-0.549188,1.3961189,-0.58694826,-0.44539339,-0.549188,1.3971831,-0.58693988,-0.44452187,-0.5195312,1.3958675,-0.5868896,-0.44627329,-0.549188,1.3970574,-0.58694826,-0.44539339,-0.549188,1.3976524,-0.58693988,-0.44627329,-0.549188,1.3966636,-0.58694826,-0.44627329,-0.549188,1.3965295,-0.58694826,-0.44539339,-0.549188,1.3983898,-0.58693988,-0.44539339,-0.549188,1.3976356,-0.58693988,-0.44627329,-0.549188,1.397225,-0.58694826,-0.44627329,-0.549188,1.3968563,-0.58694826,-0.44627329,-0.549188,1.3967222,-0.58694826,-0.44539339,-0.549188,1.3977111,-0.58693988,-0.44714481,-0.549188,1.396211,-0.58694826,-0.44714481,-0.549188,1.3955071,-0.58694826,-0.44714481,-0.549188,1.3950462,-0.58694826,-0.44627329,-0.549188,1.3963451,-0.58694826,-0.44714481,-0.549188,1.3956663,-0.58694826,-0.44539339,-0.549188,1.3973926,-0.58693988,-0.44627329,-0.549188,1.3960351,-0.58694826,-0.44714481,-0.549188,1.394535,-0.58694826,-0.44627329,-0.549188,1.3964708,-0.58694826,-0.44627329,-0.549188,1.3967222,-0.58694826,-0.44627329,-0.549188,1.3958842,-0.58694826,-0.44627329,-0.549188,1.3965714,-0.58694826,-0.44714481,-0.549188,1.3943423,-0.58694826,-0.43929275,-0.2953831,1.3931188,-0.5861773,-0.44801633,-0.549188,1.3935127,-0.58694826,-0.44627329,-0.549188,1.3956915,-0.58694826,-0.44539339,-0.549188,1.3968731,-0.58693988,-0.44539339,-0.549188,1.3973088,-0.58693988,-0.44365035,-0.54831648,1.4002921,-0.5869315,-0.44452187,-0.54831648,1.3990854,-0.58693988,-0.44365035,-0.54831648,1.3999485,-0.5869315,-0.44365035,-0.54831648,1.4003843,-0.5869315,-0.44452187,-0.54831648,1.3990183,-0.58693988,-0.44365035,-0.54831648,1.399848,-0.5869315,-0.44365035,-0.54831648,1.3998396,-0.5869315,-0.44452187,-0.549188,1.3987167,-0.58693988,-0.44539339,-0.549188,1.397996,-0.58693988,-0.44452187,-0.549188,1.398725,-0.58693988,-0.44452187,-0.54831648,1.3984234,-0.58693988,-0.44452187,-0.54831648,1.3986831,-0.58693988,-0.44539339,-0.54831648,1.3980044,-0.58693988,-0.44539339,-0.549188,1.3974597,-0.58693988,-0.44627329,-0.549188,1.3969317,-0.58694826,-0.44539339,-0.549188,1.3982558,-0.58693988,-0.44452187,-0.54831648,1.3995714,-0.58693988,-0.44365035,-0.54831648,1.4000742,-0.5869315,-0.44365035,-0.54831648,1.4000239,-0.5869315,-0.44452187,-0.54831648,1.3990519,-0.58693988,-0.44539339,-0.549188,1.3985574,-0.58693988,-0.44539339,-0.549188,1.3988424,-0.58693988,-0.44452187,-0.54831648,1.3996468,-0.58693988,-0.44452187,-0.54831648,1.3988256,-0.58693988,-0.44452187,-0.549188,1.399739,-0.58693988,-0.44627329,-0.549188,1.3978619,-0.58694826,-0.44539339,-0.549188,1.3985407,-0.58693988,-0.44452187,-0.54831648,1.3995379,-0.58693988,-0.44452187,-0.54831648,1.3994541,-0.58693988,-0.44627329,-0.549188,1.3970323,-0.58694826,-0.44539339,-0.549188,1.3976273,-0.58693988,-0.44714481,-0.549188,1.3950211,-0.58694826,-0.44627329,-0.549188,1.3966803,-0.58694826,-0.44801633,-0.549188,1.3937725,-0.58694826,-0.44539339,-0.549188,1.3976189,-0.58693988,-0.44714481,-0.549188,1.3950881,-0.58694826,-0.44714481,-0.549188,1.3950881,-0.58694826,-0.44801633,-0.549188,1.3944429,-0.58694826,-0.44714481,-0.549188,1.3951133,-0.58694826,-0.44627329,-0.549188,1.39663,-0.58694826,-0.44714481,-0.549188,1.3956244,-0.58694826,-0.44627329,-0.549188,1.395901,-0.58694826,-0.44452187,-0.54831648,1.3988759,-0.58693988,-0.44539339,-0.549188,1.3980295,-0.58693988,-0.44539339,-0.549188,1.3976692,-0.58693988,-0.44627329,-0.549188,1.3971915,-0.58694826,-0.44452187,-0.54831648,1.398834,-0.58693988,-0.43580667,2.4406685,1.381831,-0.56190884,-0.44365035,-0.549188,1.3998815,-0.58693988,-0.44365035,-0.549188,1.3992027,-0.58693988,-0.44452187,-0.549188,1.3983479,-0.58693988,-0.44365035,-0.54744496,1.4003843,-0.5869315,-0.44452187,-0.54744496,1.399915,-0.58693988,-0.30584971,0.9832449,1.3936216,-0.58080572,0.036925598,11.394551,1.3279476,-0.53528559,0.058730345,0.019478449,1.3975351,-0.58380576,-0.44452187,-0.54046443,1.3995714,-0.5869315,-0.44452187,-0.54831648,1.4001664,-0.58693988,-0.44452187,-0.54831648,1.399672,-0.58693988,-0.46458358,2.0551636,1.385074,-0.56360997,-0.44452187,-0.54831648,1.3996301,-0.58693988,-0.44452187,-0.54831648,1.3995295,-0.58693988,-0.44452187,-0.54831648,1.3995882,-0.58693988,-0.44365035,-0.54744496,1.400929,-0.5869315,-0.44365035,-0.54744496,1.4002334,-0.5869315,-0.44365035,-0.54744496,1.4005519,-0.5869315,-0.44277883,-0.54744496,1.4019262,-0.5869315,-0.44365035,-0.54744496,1.4001329,-0.5869315,-0.44452187,-0.54744496,1.4007111,-0.5869315,-0.44452187,-0.54744496,1.3998061,-0.5869315,-0.44277883,-0.54744496,1.4004932,-0.5869315,-0.44539339,-0.54831648,1.3984736,-0.58693988,-0.44452187,-0.54831648,1.399915,-0.58693988,-0.44539339,-0.54831648,1.3977278,-0.58693988,-0.44888784,-0.54831648,1.394468,-0.58694826,-0.45063088,-0.549188,1.3908814,-0.58695664,-0.45237392,-0.549188,1.3877724,-0.58696502,-0.45237392,-0.549188,1.386859,-0.5869734,-0.45237392,-0.549188,1.3880908,-0.58696502,-0.4515024,-0.549188,1.3890378,-0.58696502,-0.45237392,-0.549188,1.3853422,-0.5869734,-0.45237392,-0.549188,1.3884596,-0.58696502,-0.45063088,-0.549188,1.3918115,-0.58695664,-0.43318373,0.51750154,1.3846634,-0.58283368,-0.44888784,-0.549188,1.3921719,-0.58695664,-0.45063088,-0.549188,1.3914931,-0.58696502,-0.45063088,-0.549188,1.3915769,-0.58695664,-0.44975936,-0.549188,1.392373,-0.58695664,-0.44888784,-0.549188,1.392306,-0.58695664,-0.44975936,-0.549188,1.3926495,-0.58695664,-0.44975936,-0.549188,1.3913925,-0.58695664,-0.43493515,0.19478794,1.3867417,-0.58419962,-0.44975936,-0.549188,1.391887,-0.58695664,-0.44975936,-0.549188,1.3930266,-0.58695664,-0.44801633,-0.54831648,1.3942166,-0.58694826,-0.44801633,-0.54831648,1.3950127,-0.58694826,-0.45237392,-0.549188,1.3933199,-0.58696502,-0.44975936,-0.549188,1.3922808,-0.58695664,-0.44975936,-0.549188,1.391468,-0.58695664,-0.44714481,-0.54831648,1.3957669,-0.58694826,-0.44801633,-0.54831648,1.3946272,-0.58694826,-0.44714481,-0.54831648,1.3949038,-0.58694826,-0.44801633,-0.54831648,1.3935797,-0.58694826,-0.44801633,-0.54831648,1.3946188,-0.58694826,-0.44801633,-0.54831648,1.3940574,-0.58694826,-0.44888784,-0.54831648,1.3937138,-0.58695664,-0.44888784,-0.549188,1.392792,-0.58695664,-0.45063088,-0.549188,1.3907221,-0.58696502,-0.45063088,-0.549188,1.3908227,-0.58696502,-0.44975936,-0.549188,1.3909819,-0.58695664,-0.45063088,-0.549188,1.3908227,-0.58696502,-0.44975936,-0.549188,1.3916104,-0.58695664,-0.45237392,-0.549188,1.3879065,-0.58696502,-0.45237392,-0.549188,1.3883925,-0.58696502,-0.4515024,-0.549188,1.389683,-0.58696502,-0.44539339,2.2548924,1.3722275,-0.56272169,-0.4515024,-0.549188,1.389507,-0.58696502,-0.45063088,-0.549188,1.3913255,-0.58696502,-0.44801633,-0.54831648,1.3948283,-0.58694826,-0.44888784,-0.549188,1.3936132,-0.58695664,-0.44801633,-0.54831648,1.3949121,-0.58694826,-0.44888784,-0.54831648,1.3944764,-0.58695664,-0.44888784,-0.549188,1.3934708,-0.58695664,-0.44801633,-0.54831648,1.3946105,-0.58694826,-0.44714481,-0.54831648,1.3967474,-0.58694826,-0.44714481,-0.54831648,1.3965127,-0.58694826,-0.44627329,-0.54831648,1.3978032,-0.58693988,-0.44539339,-0.54831648,1.3983647,-0.58693988,-0.44539339,-0.54831648,1.3991021,-0.58693988,-0.44539339,-0.54831648,1.3989429,-0.58693988,-0.44627329,-0.54831648,1.3979206,-0.58693988,-0.44539339,-0.54831648,1.398834,-0.58693988,-0.44539339,-0.54831648,1.3987921,-0.58693988,-0.44627329,-0.54831648,1.3978703,-0.58693988,-0.44452187,-0.54744496,1.4005854,-0.58693988,-0.44801633,2.6735485,1.3799958,-0.56091162,-0.44539339,-0.54831648,1.3987837,-0.58693988,-0.44452187,-0.54831648,1.399848,-0.58693988,-0.44539339,-0.54831648,1.3983563,-0.58693988,-0.44627329,-0.54831648,1.3978619,-0.58693988,-0.44627329,-0.54831648,1.3981971,-0.58693988,-0.44539339,-0.54831648,1.3996301,-0.58693988,-0.44452187,-0.54831648,1.4006105,-0.58693988,-0.44714481,2.5584158,1.3811522,-0.56141442,-0.44627329,-0.54831648,1.3977613,-0.58693988,-0.44539339,-0.54831648,1.3991608,-0.58693988,-0.44452187,-0.54831648,1.4002083,-0.58693988,-0.44539339,-0.54831648,1.3992362,-0.58693988,-0.44452187,-0.54831648,1.4007195,-0.58693988,-0.44452187,-0.54831648,1.4005267,-0.58693988,-0.44452187,-0.54831648,1.3996636,-0.58693988,-0.44888784,2.4397969,1.3801717,-0.56189208,-0.44627329,-0.54831648,1.3967138,-0.58693988,-0.44627329,-0.54831648,1.397334,-0.58693988,-0.44627329,-0.54831648,1.3968563,-0.58693988,-0.44627329,-0.54831648,1.3971496,-0.58693988,-0.44539339,-0.54831648,1.3981971,-0.58693988,-0.44627329,-0.54831648,1.3977362,-0.58693988,-0.44627329,-0.54831648,1.397753,-0.58693988,-0.45063088,2.4354393,1.3789231,-0.56191722,-0.44627329,-0.54831648,1.3976189,-0.58693988,-0.44801633,-0.54831648,1.3945434,-0.58694826,-0.44888784,-0.54831648,1.3928842,-0.58695664,-0.44888784,-0.54831648,1.3940155,-0.58695664,-0.44975936,-0.549188,1.3927333,-0.58695664,-0.44801633,-0.54831648,1.3948786,-0.58694826,-0.44539339,-0.54831648,1.3981301,-0.58693988,-0.44539339,-0.54831648,1.3974848,-0.58693988,-0.44627329,-0.54831648,1.3962948,-0.58693988,-0.44539339,-0.54831648,1.3976105,-0.58693988,-0.44539339,-0.54831648,1.3973759,-0.58693988,-0.44452187,-0.54831648,1.3987753,-0.58693988,-0.44539339,-0.54831648,1.3979206,-0.58693988,-0.44452187,-0.54831648,1.3984485,-0.58693988,-0.44539339,-0.54831648,1.3974345,-0.58693988,-0.44714481,2.3290302,1.3810935,-0.56239488,-0.44627329,-0.54831648,1.3965965,-0.58693988,-0.44539339,-0.54831648,1.3976273,-0.58693988,-0.44452187,-0.54744496,1.3992949,-0.58693988,-0.44452187,-0.54744496,1.3992027,-0.58693988,-0.44452187,-0.54744496,1.39901,-0.58693988,-0.44365035,-0.54744496,1.4007111,-0.5869315,-0.44190731,-0.54744496,1.4025463,-0.58692312,-0.44365035,-0.54744496,1.4004848,-0.5869315,-0.44365035,-0.54744496,1.4001832,-0.5869315,-0.44277883,-0.54744496,1.4018927,-0.5869315,-0.44365035,-0.54744496,1.4001161,-0.5869315,-0.44103579,-0.54744496,1.4037614,-0.58692312,-0.44190731,-0.54744496,1.4033257,-0.58692312,-0.44365035,-0.54744496,1.4010463,-0.5869315,-0.44365035,-0.54744496,1.4000826,-0.5869315,-0.44365035,-0.54744496,1.3999904,-0.5869315,-0.44452187,-0.54831648,1.3995379,-0.58693988,-0.44539339,-0.54831648,1.3975937,-0.58693988,-0.44539339,-0.54831648,1.3983228,-0.58693988,-0.44539339,-0.54831648,1.3980714,-0.58693988,-0.44539339,-0.54831648,1.3982977,-0.58693988,-0.44801633,-0.54831648,1.393697,-0.58694826,-0.44627329,-0.54831648,1.3977697,-0.58693988,-0.44714481,-0.54831648,1.3965714,-0.58694826,-0.44627329,-0.54831648,1.3970574,-0.58693988,-0.44539339,-0.54831648,1.3984066,-0.58693988,-0.44627329,-0.54831648,1.3982139,-0.58693988,-0.44627329,-0.54831648,1.3972585,-0.58693988,-0.44714481,-0.54831648,1.3965965,-0.58694826,-0.44452187,-0.54831648,1.3999904,-0.58693988,-0.44452187,-0.54744496,1.4005938,-0.58693988,-0.44365035,-0.54831648,1.4009709,-0.5869315,-0.44452187,-0.54831648,1.4002586,-0.58693988,-0.44277883,-0.54744496,1.4025296,-0.5869315,-0.44277883,-0.54744496,1.4025798,-0.5869315,-0.44452187,-0.54744496,1.4004932,-0.58693988,-0.44452187,-0.54744496,1.4003089,-0.58693988,-0.44539339,-0.54831648,1.3996636,-0.58693988,-0.44452187,-0.54831648,1.4004262,-0.58693988,-0.44452187,-0.54744496,1.3999485,-0.58693988,-0.44452187,-0.54744496,1.3991021,-0.58693988,-0.44452187,-0.54831648,1.399563,-0.58693988,-0.44452187,-0.54831648,1.3993954,-0.58693988,-0.44975936,2.666568,1.3779091,-0.56093676,-0.44627329,-0.54831648,1.3975854,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988,-0.44539339,-0.54831648,1.3987418,-0.58693988:3
-0.51832953,-0.51832953,1.3617312,-0.51832953,-0.51832953,-0.51832953,1.3602437,-0.51832953,-0.51832953,-0.51832953,1.3614051,-0.51832953,-0.51832953,-0.51832953,1.3662336,-0.51832953,-0.51832953,-0.51832953,1.3625187,-0.51832953,-0.51832953,-0.51832953,1.3636403,-0.51832953,-0.51832953,-0.51832953,1.363529,-0.51832953,-0.51832953,-0.51832953,1.3625108,-0.51832953,-0.51832953,-0.51832953,1.3667506,-0.51832953,-0.51832953,-0.51832953,1.3682461,-0.51832953,-0.51832953,-0.51832953,1.3645869,-0.51832953,-0.51832953,-0.51832953,1.364929,-0.51832953,-0.51832953,-0.51832953,1.3668063,-0.51832953,-0.51832953,-0.51832953,1.3651836,-0.51832953,-0.51832953,-0.51832953,1.3657802,-0.51832953,-0.51832953,-0.51832953,1.3671722,-0.51832953,-0.51832953,-0.51832953,1.3667904,-0.51832953,-0.51832953,-0.51832953,1.3640778,-0.51832953,-0.51832953,-0.51832953,1.3661779,-0.51832953,-0.51832953,-0.51832953,1.3646585,-0.51832953,-0.51832953,-0.51832953,1.362646,-0.51832953,-0.51832953,-0.51832953,1.364921,-0.51832953,-0.51832953,-0.51832953,1.3631392,-0.51832953,-0.51832953,-0.51832953,1.3633142,-0.51832953,-0.51832953,-0.51832953,1.3640063,-0.51832953,-0.51832953,-0.51832953,1.3655176,-0.51832953,-0.51832953,-0.51832953,1.3643006,-0.51832953,-0.51832953,-0.51832953,1.3666313,-0.51832953,-0.51832953,-0.51832953,1.3653267,-0.51832953,-0.51832953,-0.51832953,1.3632824,-0.51832953,-0.51832953,-0.51832953,1.3622164,-0.51832953,-0.51832953,-0.51832953,1.3642528,-0.51832953,-0.51832953,-0.51832953,1.3609437,-0.51832953,-0.51832953,-0.51832953,1.3632585,-0.51832953,-0.51832953,-0.51832953,1.3631392,-0.51832953,-0.51832953,-0.51832953,1.3650642,-0.51832953,-0.51832953,-0.51832953,1.3659552,-0.51832953,-0.51832953,-0.51832953,1.3666711,-0.51832953,-0.51832953,-0.51832953,1.3682143,-0.51832953,-0.51832953,-0.51832953,1.3667029,-0.51832953,-0.51832953,-0.51832953,1.3679995,-0.51832953,-0.51832953,-0.51832953,1.3710223,-0.51832953,-0.51832953,-0.51832953,1.3713962,-0.51832953,-0.51832953,-0.51832953,1.371253,-0.51832953,-0.51832953,-0.51832953,1.3669893,-0.51832953,-0.54879614,8.3365103,1.329427,-0.4802025,-0.54302896,-0.51338964,1.3702109,-0.51822611,-0.54302896,-0.51338964,1.3663211,-0.51822611,-0.54302896,-0.5125703,1.363704,-0.51822611,-0.54302896,-0.5125703,1.3660983,-0.51822611,-0.11153258,8.6988403,1.3210507,-0.47841269,-0.098359542,8.6724942,1.3248053,-0.4786036,-0.53479582,7.023065,1.333834,-0.48315371,-0.54302896,-0.5125703,1.3672836,-0.51822611,-0.54302896,-0.5125703,1.3678961,-0.51822611,-0.54302896,-0.5125703,1.3690416,-0.51822611,-0.54302896,-0.5125703,1.3698848,-0.51822611,-0.54302896,-0.5125703,1.3692802,-0.51822611,-0.54302896,-0.5125703,1.3695268,-0.51822611,-0.54302896,-0.5125703,1.3704496,-0.51822611,-0.54302896,-0.5125703,1.3683098,-0.51822611,-0.54302896,-0.5125703,1.3694393,-0.51822611,-0.54302896,-0.5125703,1.3689223,-0.51822611,-0.54302896,-0.5125703,1.3683098,-0.51822611,-0.54302896,-0.5125703,1.3708235,-0.51822611,-0.54302896,-0.5125703,1.3691211,-0.51822611,-0.54302896,-0.5125703,1.3704496,-0.51822611,-0.54302896,-0.5125703,1.3702666,-0.51822611,-0.54302896,-0.5125703,1.3695348,-0.51822611,-0.54302896,-0.5125703,1.3677052,-0.51822611,-0.54302896,-0.5125703,1.3685007,-0.51822611,-0.54302896,-0.5125703,1.367737,-0.51822611,-0.54302896,-0.5125703,1.3672995,-0.51822611,-0.54302896,-0.5125703,1.3675382,-0.51822611,-0.54302896,-0.5125703,1.3663609,-0.51822611,-0.54302896,-0.5125703,1.3734485,-0.51822611,-0.54302896,-0.5125703,1.3777202,-0.51822611,-0.54302896,-0.5125703,1.3798123,-0.51822611,-0.54302896,-0.5125703,1.3749122,-0.51822611,-0.54302896,-0.5125703,1.3723667,-0.51822611,-0.54302896,-0.5125703,1.3749997,-0.51822611,-0.54302896,-0.5125703,1.3717382,-0.51822611,-0.54302896,-0.5125703,1.3679836,-0.51822611,-0.54302896,-0.5125703,1.3707598,-0.51822611,-0.54302896,-0.5125703,1.3660983,-0.51822611,-0.54302896,-0.5125703,1.3648813,-0.51822611,-0.54302896,-0.5125703,1.3671563,-0.51822611,-0.54302896,-0.5125703,1.3637437,-0.51822611,-0.54302896,-0.5125703,1.3656688,-0.51822611,-0.54302896,-0.5125703,1.3740372,-0.51822611,-0.54302896,-0.5125703,1.3675143,-0.51822611,-0.54302896,-0.5125703,1.3665279,-0.51822611,-0.53396853,6.0670098,1.3377556,-0.48542081,-0.54302896,-0.5125703,1.3688427,-0.51822611,-0.54302896,-0.5125703,1.368095,-0.51822611,-0.54302896,-0.5125703,1.3699166,-0.51822611,-0.54302896,-0.5125703,1.3681984,-0.51822611,-0.54302896,-0.5125703,1.3651597,-0.51822611,-0.54302896,-0.5125703,1.3670529,-0.51822611,-0.51832953,-0.51832953,1.3675063,-0.51832953,-0.51832953,-0.51832953,1.3734724,-0.51832953,-0.51832953,-0.51832953,1.3730587,-0.51832953,-0.51832953,-0.51832953,1.3706564,-0.51832953,-0.51832953,-0.51832953,1.372836,-0.51832953,-0.51832953,-0.51832953,1.3707598,-0.51832953,-0.51832953,-0.51832953,1.36897,-0.51832953,-0.51832953,-0.51832953,1.3697098,-0.51832953,-0.51832953,-0.51832953,1.3698052,-0.51832953,-0.51832953,-0.51832953,1.3696859,-0.51832953,-0.51832953,-0.51832953,1.3697734,-0.51832953,-0.51832953,-0.51832953,1.3696382,-0.51832953,-0.51832953,-0.51832953,1.3693677,-0.51832953,-0.51832953,-0.51832953,1.3703064,-0.51832953,-0.51832953,-0.51832953,1.371086,-0.51832953,-0.51832953,-0.51832953,1.3689223,-0.51832953,-0.51832953,-0.51832953,1.3699882,-0.51832953,-0.51832953,-0.51832953,1.3694155,-0.51832953,-0.51832953,-0.51832953,1.3687473,-0.51832953,-0.51832953,-0.51832953,1.368612,-0.51832953,-0.51832953,-0.51832953,1.3672041,-0.51832953,-0.51832953,-0.51832953,1.3673313,-0.51832953,-0.51832953,-0.51832953,1.3664086,-0.51832953,-0.51832953,-0.51832953,1.3664961,-0.51832953,-0.51832953,-0.51832953,1.3663211,-0.51832953,-0.51832953,-0.51832953,1.3641256,-0.51832953,-0.51832953,-0.51832953,1.3672995,-0.51832953,-0.51832953,-0.51832953,1.3599732,-0.51832953,-0.51832953,-0.51832953,1.3637915,-0.51832953,-0.51832953,-0.51832953,1.3642847,-0.51832953,-0.51832953,-0.51832953,1.3645313,-0.51832953,-0.51832953,-0.51832953,1.3611744,-0.51832953,-0.51832953,-0.51832953,1.3641335,-0.51832953,-0.51832953,-0.51832953,1.3643403,-0.51832953,-0.51832953,-0.51832953,1.3664802,-0.51832953,-0.51832953,-0.51832953,1.3627574,-0.51832953,-0.51832953,-0.51832953,1.3616676,-0.51832953,-0.51832953,-0.51832953,1.3654938,-0.51832953,-0.51832953,-0.51832953,1.3648097,-0.51832953,-0.51832953,-0.51832953,1.3667109,-0.51832953,-0.51832953,-0.51832953,1.3648097,-0.51832953,-0.51832953,-0.51832953,1.3632426,-0.51832953,-0.51832953,-0.51832953,1.3645551,-0.51832953,-0.51832953,-0.51832953,1.3645074,-0.51832953,-0.51832953,-0.51832953,1.3626142,-0.51832953,-0.51832953,-0.51832953,1.3635051,-0.51832953,-0.51832953,-0.51832953,1.3641813,-0.51832953,-0.51832953,-0.51832953,1.3634335,-0.51832953,-0.51832953,-0.51832953,1.3638392,-0.51832953,-0.51832953,-0.51832953,1.3634574,-0.51832953,-0.51832953,-0.51832953,1.3626858,-0.51832953,-0.51832953,-0.51832953,1.3630199,-0.51832953,-0.51832953,-0.51832953,1.3639665,-0.51832953,-0.51832953,-0.51832953,1.3611425,-0.51832953,-0.51832953,-0.51832953,1.3663211,-0.51832953,-0.51832953,-0.51832953,1.363163,-0.51832953,-0.51832953,-0.51832953,1.363871,-0.51832953,-0.51832953,-0.51832953,1.3631551,-0.51832953,-0.51832953,-0.51832953,1.3671722,-0.51832953,-0.51832953,-0.51832953,1.3683973,-0.51832953,-0.51832953,-0.51832953,1.3709428,-0.51832953,-0.51832953,-0.51832953,1.3682063,-0.51832953,-0.51832953,-0.51832953,1.3677529,-0.51832953,-0.51832953,-0.51832953,1.3677291,-0.51832953,-0.51832953,-0.51832953,1.3685723,-0.51832953,-0.51832953,-0.51832953,1.3660983,-0.51832953,-0.51832953,-0.51832953,1.3667745,-0.51832953,-0.51832953,-0.51832953,1.3688189,-0.51832953,-0.51832953,-0.51832953,1.3655415,-0.51832953,-0.51832953,-0.51832953,1.364046,-0.51832953,-0.51832953,-0.51832953,1.362646,-0.51832953,-0.51832953,-0.51832953,1.3641653,-0.51832953,-0.51832953,-0.51832953,1.3662018,-0.51832953,-0.51832953,-0.51832953,1.3660904,-0.51832953,-0.51832953,-0.51832953,1.3662574,-0.51832953,-0.51832953,-0.51832953,1.3676177,-0.51832953,-0.51832953,-0.51832953,1.3679757,-0.51832953,-0.51832953,-0.51832953,1.367395,-0.51832953,-0.51832953,-0.51832953,1.3681268,-0.51832953,-0.51832953,-0.51832953,1.3696302,-0.51832953,-0.51832953,-0.51832953,1.3684768,-0.51832953,-0.51832953,-0.51832953,1.3690416,-0.51832953,-0.51832953,-0.51832953,1.366854,-0.51832953,-0.51832953,-0.51832953,1.3677052,-0.51832953,-0.51832953,-0.51832953,1.3684052,-0.51832953,-0.51832953,-0.51832953,1.3693121,-0.51832953,-0.51832953,-0.51832953,1.3693041,-0.51832953,-0.51832953,-0.51832953,1.3687155,-0.51832953,-0.51832953,-0.51832953,1.3698132,-0.51832953,-0.51832953,-0.51832953,1.3687552,-0.51832953,-0.51832953,-0.51832953,1.3692166,-0.51832953,-0.51832953,-0.51832953,1.3698132,-0.51832953,-0.51832953,-0.51832953,1.370195,-0.51832953,-0.51832953,-0.51832953,1.3686995,-0.51832953,-0.51832953,-0.51832953,1.3659552,-0.51832953,-0.51832953,-0.51832953,1.36757,-0.51832953,-0.51832953,-0.51832953,1.3683575,-0.51832953,-0.51832953,-0.51832953,1.3684689,-0.51832953,-0.51832953,-0.51832953,1.3659552,-0.51832953,-0.51832953,-0.51832953,1.3673631,-0.51832953,-0.51832953,-0.51832953,1.3679995,-0.51832953,-0.51832953,-0.51832953,1.3679677,-0.51832953,-0.51832953,-0.51832953,1.3658915,-0.51832953,-0.51832953,-0.51832953,1.3656688,-0.51832953,-0.51832953,-0.51832953,1.3675143,-0.51832953,-0.51832953,-0.51832953,1.3633142,-0.51832953,-0.51832953,-0.51832953,1.3620017,-0.51832953,-0.51832953,-0.51832953,1.3671961,-0.51832953,-0.51832953,-0.51832953,1.3668222,-0.51832953,-0.51832953,-0.51832953,1.3671245,-0.51832953,-0.51832953,-0.51832953,1.3670768,-0.51832953,-0.51832953,-0.51832953,1.3643403,-0.51832953,-0.51832953,-0.51832953,1.3681586,-0.51832953,-0.51832953,-0.51832953,1.37072,-0.51832953,-0.51832953,-0.51832953,1.3697973,-0.51832953,-0.51832953,-0.51832953,1.3709189,-0.51832953,-0.51832953,-0.51832953,1.3700678,-0.51832953,-0.51832953,-0.51832953,1.3677291,-0.51832953,-0.51832953,-0.51832953,1.3654142,-0.51832953,-0.51832953,-0.51832953,1.3673154,-0.51832953,-0.51832953,-0.51832953,1.3683177,-0.51832953,-0.51832953,-0.51832953,1.3666552,-0.51832953,-0.51832953,-0.51832953,1.36792,-0.51832953,-0.51832953,-0.51832953,1.3687473,-0.51832953,-0.51832953,-0.51832953,1.3658597,-0.51832953,-0.51832953,-0.51832953,1.368095,-0.51832953,-0.51832953,-0.51832953,1.3696621,-0.51832953,-0.51832953,-0.51832953,1.3690814,-0.51832953,-0.51832953,-0.51832953,1.3704098,-0.51832953,-0.51832953,-0.51832953,1.370728,-0.51832953,-0.51832953,-0.51832953,1.370195,-0.51832953,-0.51832953,-0.51832953,1.3650881,-0.51832953,-0.51832953,-0.51832953,1.3664006,-0.51832953,-0.51832953,-0.51832953,1.3677768,-0.51832953,-0.51832953,-0.51832953,1.3692166,-0.51832953,-0.51832953,-0.51832953,1.3702825,-0.51832953,-0.51832953,-0.51832953,1.37002,-0.51832953,-0.51832953,-0.51832953,1.368795,-0.51832953,-0.51832953,-0.51832953,1.3702666,-0.51832953,-0.51832953,-0.51832953,1.3686836,-0.51832953,-0.51832953,-0.51832953,1.3692007,-0.51832953,-0.51832953,-0.51832953,1.3688984,-0.51832953,-0.51832953,-0.51832953,1.3680313,-0.51832953,-0.51832953,-0.51832953,1.36757,-0.51832953,-0.51832953,-0.51832953,1.3685723,-0.51832953,-0.51832953,-0.51832953,1.3685961,-0.51832953,-0.51832953,-0.51832953,1.3681984,-0.51832953,-0.51832953,-0.51832953,1.3664722,-0.51832953,-0.51832953,-0.51832953,1.3642767,-0.51832953,-0.51832953,-0.51832953,1.3648733,-0.51832953,-0.51832953,-0.51832953,1.3652472,-0.51832953,-0.51832953,-0.51832953,1.3665677,-0.51832953,-0.51832953,-0.51832953,1.3657563,-0.51832953,-0.51832953,-0.51832953,1.369845,-0.51832953,-0.51832953,-0.51832953,1.3694075,-0.51832953,-0.51832953,-0.51832953,1.3690336,-0.51832953,-0.51832953,-0.51832953,1.3679359,-0.51832953,-0.51832953,-0.51832953,1.3685961,-0.51832953,-0.51832953,-0.51832953,1.36897,-0.51832953,-0.51832953,-0.51832953,1.3715473,-0.51832953,-0.54879614,8.3249839,1.3299759,-0.48025819,-0.54302896,-0.5125703,1.3709746,-0.51822611,-0.54302896,-0.5125703,1.3705053,-0.51822611,-0.54302896,-0.5125703,1.3698052,-0.51822611,-0.54302896,-0.5125703,1.3689541,-0.51822611,-0.54302896,-0.5125703,1.367745,-0.51822611,-0.54302896,-0.5125703,1.366862,-0.51822611,-0.54302896,-0.5125703,1.3678722,-0.51822611,-0.54302896,-0.5125703,1.3666234,-0.51822611,-0.54302896,-0.5125703,1.3641892,-0.51822611,-0.54302896,-0.5125703,1.3651438,-0.51822611,-0.54302896,-0.5125703,1.3650006,-0.51822611,-0.54302896,-0.5125703,1.3668222,-0.51822611,-0.54302896,-0.5125703,1.3649608,-0.51822611,-0.54302896,-0.5125703,1.3665836,-0.51822611,-0.54302896,-0.5125703,1.3681745,-0.51822611,-0.54302896,-0.5125703,1.3688825,-0.51822611,-0.54302896,-0.5125703,1.366679,-0.51822611,-0.54302896,-0.5125703,1.3667984,-0.51822611,-0.54302896,-0.5125703,1.3732417,-0.51822611,-0.54302896,-0.5125703,1.375119,-0.51822611,-0.54302896,-0.5125703,1.3766225,-0.51822611,-0.54302896,-0.5125703,1.3783804,-0.51822611,-0.54302896,-0.5125703,1.3788736,-0.51822611,-0.54302896,-0.5125703,1.3776247,-0.51822611,-0.54302896,-0.5125703,1.3772191,-0.51822611,-0.54302896,-0.5125703,1.3773702,-0.51822611,-0.54220963,-0.5125703,1.3504434,-0.51822611,-0.54302896,-0.5125703,1.3553038,-0.51822611,-0.54302896,-0.5125703,1.3540549,-0.51822611,-0.54302896,-0.5125703,1.3551606,-0.51822611,-0.54220963,-0.5125703,1.3502923,-0.51822611,-0.54220963,-0.5125703,1.3490752,-0.51822611,-0.54220963,-0.5125703,1.3474127,-0.51822611,-0.54220963,-0.5125703,1.3470547,-0.51822611,-0.54220963,-0.5125703,1.3445808,-0.51822611,-0.54220963,-0.5125703,1.3461638,-0.51822611,-0.54220963,-0.5125703,1.3447478,-0.51822611,-0.10988595,5.098601,1.3217189,-0.48762427,-0.11483379,8.4954458,1.3052208,-0.47895361,-0.54220963,-0.5125703,1.3424569,-0.51822611,-0.54220963,-0.5125703,1.3422421,-0.51822611,-0.54220963,-0.5125703,1.3423694,-0.51822611,-0.54220963,-0.5125703,1.3397443,-0.51822611,-0.54220963,-0.5125703,1.3416694,-0.51822611,-0.54220963,-0.5125703,1.3415262,-0.51822611,-0.54220963,-0.5125703,1.3428148,-0.51822611,-0.54220963,-0.5125703,1.3382647,-0.51822611,-0.55867592,1.9290387,1.3288225,-0.49825974,-0.54220963,-0.5125703,1.340683,-0.51822611,-0.54220963,-0.5125703,1.3413034,-0.51822611,-0.54220963,-0.5125703,1.3402852,-0.51822611,-0.54220963,-0.5125703,1.3378591,-0.51822611,-0.54220963,-0.5125703,1.3423932,-0.51822611,-0.54220963,-0.5125703,1.3412796,-0.51822611,-0.54220963,-0.5125703,1.3417171,-0.51822611,-0.54220963,-0.5125703,1.3408341,-0.51822611,-0.54220963,-0.5125703,1.3415262,-0.51822611,-0.54220963,-0.5125703,1.3385988,-0.51822611,-0.54220963,-0.5125703,1.3400705,-0.51822611,-0.54220963,-0.5125703,1.3408739,-0.51822611,-0.54220963,-0.5125703,1.339625,-0.51822611,-0.53150256,3.6641086,1.3206291,-0.49210278,-0.54220963,-0.5125703,1.3416853,-0.51822611,-0.54220963,-0.5125703,1.3410409,-0.51822611,-0.54220963,-0.5125703,1.3421228,-0.51822611,-0.54220963,-0.5125703,1.3399114,-0.51822611,-0.54220963,-0.5125703,1.3402057,-0.51822611,-0.54220963,-0.5125703,1.3427194,-0.51822611,-0.54220963,-0.5125703,1.3430058,-0.51822611,-0.54220963,-0.5125703,1.3427035,-0.51822611,-0.54220963,-0.5125703,1.3381772,-0.51822611,-0.54220963,-0.5125703,1.3377715,-0.51822611,-0.54220963,-0.5125703,1.3373977,-0.51822611,-0.54220963,-0.5125703,1.3382091,-0.51822611,-0.54220963,-0.5125703,1.3381613,-0.51822611,-0.54220963,-0.5125703,1.3387738,-0.51822611,-0.54220963,-0.50927704,1.3374534,-0.51758178,-0.54220963,-0.5125703,1.3382329,-0.51822611,-0.54220963,-0.5125703,1.3365783,-0.51822611,-0.54220963,-0.5125703,1.3371988,-0.51822611,-0.54220963,-0.5125703,1.3371431,-0.51822611,-0.53150256,-0.17906028,1.3349317,-0.51092367,-0.54220963,-0.5125703,1.3371272,-0.51822611,-0.54220963,-0.5125703,1.3357749,-0.51822611,-0.54220963,-0.5125703,1.3365942,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611,-0.54220963,-0.5125703,1.3352101,-0.51822611:3
-0.49254997,-0.49254997,1.2302396,-0.49254997,-0.48883466,-0.46800162,1.2289461,-0.49236312,-0.48957484,-0.46874899,1.2242103,-0.49237031,-0.48957484,-0.46800162,1.2233911,-0.49237031,-0.48808728,-0.46800162,1.2293054,-0.49236312,-0.48808728,-0.46800162,1.2290754,-0.49236312,-0.10645246,1.3018006,1.224893,-0.47554722,-0.12431037,-0.019419364,1.2177642,-0.48999165,-0.4910624,-0.46874899,1.2190362,-0.49237031,-0.48808728,-0.46874899,1.2307786,-0.49236312,-0.48808728,-0.46874899,1.2294778,-0.49236312,-0.48957484,-0.46874899,1.2245984,-0.49237031,-0.48957484,-0.46874899,1.2241025,-0.49237031,-0.48957484,-0.46651406,1.2246487,-0.49236312,-0.35121012,4.3846304,1.2206172,-0.46267658,-0.15406878,10.352416,1.2092341,-0.44671584,-0.14142092,8.738096,1.2055763,-0.45036648,-0.48808728,-0.46651406,1.2298012,-0.49235594,-0.48957484,-0.46651406,1.2240306,-0.49236312,-0.48957484,-0.46651406,1.2245409,-0.49236312,-0.48883466,-0.46651406,1.2267902,-0.49236312,-0.48808728,-0.46651406,1.2300599,-0.49235594,-0.48808728,-0.46651406,1.229909,-0.49235594,-0.48808728,-0.46651406,1.229909,-0.49235594,-0.48808728,-0.46651406,1.2298012,-0.49235594,-0.48808728,-0.46651406,1.2303114,-0.49235594,-0.4910624,-0.46726143,1.2198267,-0.49237031,-0.49032222,-0.46726143,1.2209837,-0.49236312,-0.4910624,-0.46726143,1.219956,-0.49237031,-0.51263563,5.0950809,1.2189571,-0.46011826,-0.48808728,-0.46651406,1.2298587,-0.49235594,-0.48808728,-0.46651406,1.2298731,-0.49235594,-0.48808728,-0.46651406,1.2299953,-0.49235594,-0.48808728,-0.46651406,1.2299018,-0.49235594,-0.48808728,-0.46651406,1.2297653,-0.49235594,-0.48808728,-0.46726143,1.2293629,-0.49236312,-0.48808728,-0.46726143,1.2302324,-0.49236312,-0.4910624,-0.46800162,1.2184253,-0.49237031,-0.5104007,1.9884429,1.2147819,-0.47099111,-0.48883466,-0.46800162,1.2264093,-0.49236312,-0.48808728,-0.46726143,1.229291,-0.49236312,-0.48957484,-0.46800162,1.2242606,-0.49236312,-0.49032222,-0.46800162,1.2236282,-0.49237031,-0.48883466,-0.46800162,1.2282705,-0.49236312,-0.49032222,-0.46800162,1.2237432,-0.49236312,-0.48883466,-0.46726143,1.2290323,-0.49236312,-0.48883466,-0.46726143,1.2291976,-0.49236312,-0.51932606,9.5006183,1.2098162,-0.44915918,-0.48957484,-0.46800162,1.2247205,-0.49236312,-0.48808728,-0.46726143,1.230527,-0.49236312,-0.4910624,-0.46800162,1.2199273,-0.49237031,-0.4910624,-0.46800162,1.2190937,-0.49237031,-0.48808728,-0.46726143,1.2306923,-0.49236312,-0.48808728,-0.46726143,1.231296,-0.49235594,-0.48883466,-0.46726143,1.2287808,-0.49236312,-0.48808728,-0.46726143,1.2313103,-0.49235594,-0.48808728,-0.46726143,1.2306061,-0.49236312,-0.48808728,-0.46800162,1.2296216,-0.49236312,-0.4910624,-0.46800162,1.2198554,-0.49237031,-0.48883466,-0.46800162,1.2264021,-0.49236312,-0.4873471,-0.46800162,1.2317271,-0.49235594,-0.4873471,-0.46726143,1.2315762,-0.49235594,-0.48957484,-0.46800162,1.2253888,-0.49236312,-0.48957484,-0.46800162,1.2254176,-0.49236312,-0.48883466,-0.46800162,1.2271998,-0.49236312,-0.4873471,-0.46726143,1.2323092,-0.49235594,-0.48213704,6.5070565,1.2121158,-0.45625923,-0.48808728,-0.46726143,1.2317559,-0.49236312,-0.4873471,-0.46726143,1.2326398,-0.49235594,-0.48957484,-0.46800162,1.2258847,-0.49236312,-0.49180978,-0.46800162,1.216715,-0.49237031,-0.4910624,-0.46800162,1.2177355,-0.49237031,-0.49032222,-0.46800162,1.2226221,-0.49237031,-0.48957484,-0.46800162,1.2235204,-0.49236312,-0.49254997,-0.46800162,1.2149256,-0.49237749,-0.4910624,-0.46800162,1.2206315,-0.49237031,-0.49032222,-0.46800162,1.221228,-0.49237031,-0.49032222,-0.46800162,1.2215298,-0.49237031,-0.4910624,-0.46800162,1.2208471,-0.49237031,-0.49032222,-0.46800162,1.2205525,-0.49237031,-0.49180978,-0.46800162,1.2165713,-0.49237031,-0.49180978,-0.46800162,1.2166575,-0.49237031,-0.49032222,-0.46800162,1.2206962,-0.49237031,-0.4910624,-0.46800162,1.2196039,-0.49237031,-0.49032222,-0.46800162,1.2198267,-0.49237031,-0.49032222,-0.46800162,1.2205884,-0.49237031,-0.4910624,-0.46800162,1.2192589,-0.49237031,-0.4910624,-0.46800162,1.2197261,-0.49237031,-0.4910624,-0.46800162,1.2182529,-0.49237031,-0.4910624,-0.46800162,1.2189643,-0.49237031,-0.4910624,-0.46800162,1.2181163,-0.49237031,-0.48957484,-0.46800162,1.2244259,-0.49237031,-0.48883466,-0.46800162,1.2268692,-0.49236312,-0.48883466,-0.46800162,1.2276382,-0.49236312,-0.48883466,-0.46800162,1.2264883,-0.49236312,-0.48808728,-0.46800162,1.2293054,-0.49236312,-0.48808728,-0.46800162,1.2289029,-0.49236312,-0.48957484,-0.46800162,1.2236929,-0.49236312,-0.48957484,-0.46800162,1.2230246,-0.49237031,-0.48808728,-0.46800162,1.2298515,-0.49236312,-0.48808728,-0.46800162,1.2291401,-0.49236312,-0.48957484,-0.46800162,1.2232545,-0.49237031,-0.48957484,-0.46800162,1.2246415,-0.49236312,-0.48808728,-0.46800162,1.229061,-0.49236312,-0.48883466,-0.46800162,1.2280909,-0.49236312,-0.48808728,-0.46800162,1.2292694,-0.49236312,-0.48808728,-0.46800162,1.2290467,-0.49236312,-0.48808728,-0.46800162,1.2290107,-0.49236312,-0.48957484,-0.46800162,1.2230749,-0.49236312,-0.48883466,-0.46800162,1.2282993,-0.49236312,-0.48808728,-0.46800162,1.2292335,-0.49236312,-0.48808728,-0.46800162,1.2291329,-0.49236312,-0.48808728,-0.46800162,1.2282634,-0.49236312,-0.48808728,-0.46800162,1.2282634,-0.49236312,-0.48808728,-0.46800162,1.2285149,-0.49236312,-0.48883466,-0.46800162,1.2280765,-0.49236312,-0.48883466,-0.46800162,1.2281196,-0.49236312,-0.48883466,-0.46800162,1.2282418,-0.49236312,-0.48808728,-0.46800162,1.2281196,-0.49236312,-0.48808728,-0.46800162,1.2288383,-0.49236312,-0.48883466,-0.46800162,1.2279975,-0.49236312,-0.48883466,-0.46800162,1.2283855,-0.49236312,-0.48883466,-0.46800162,1.226977,-0.49236312,-0.48883466,-0.46800162,1.2268189,-0.49236312,-0.48808728,-0.46800162,1.2290323,-0.49236312,-0.48808728,-0.46800162,1.229097,-0.49236312,-0.48808728,-0.46800162,1.2298372,-0.49236312,-0.48808728,-0.46800162,1.2298372,-0.49236312,-0.48808728,-0.46800162,1.2290323,-0.49236312,-0.48883466,-0.46726143,1.2283855,-0.49236312,-0.48808728,-0.46800162,1.2298084,-0.49236312,-0.4873471,-0.46800162,1.2325176,-0.49235594,-0.4873471,-0.46726143,1.2326111,-0.49235594,-0.4873471,-0.46800162,1.2318493,-0.49235594,-0.27234783,10.275788,1.2112175,-0.44708953,-0.4873471,-0.46651406,1.2321008,-0.49235594,-0.4873471,-0.46651406,1.2315259,-0.49235594,-0.48808728,-0.46726143,1.2310085,-0.49235594,-0.27607033,10.2624,1.2101108,-0.44711109,-0.4873471,-0.46651406,1.2316625,-0.49235594,-0.48808728,-0.46651406,1.2311307,-0.49235594,-0.48808728,-0.46651406,1.2311235,-0.49235594,-0.48808728,-0.46651406,1.2315547,-0.49235594,-0.4873471,-0.46651406,1.2324458,-0.49235594,-0.48808728,-0.46651406,1.2298875,-0.49235594,-0.48808728,-0.46651406,1.2304767,-0.49235594,-0.48808728,-0.46726143,1.2317631,-0.49235594,-0.4873471,-0.46651406,1.2313606,-0.49235594,-0.4873471,-0.46651406,1.2316768,-0.49235594,-0.48957484,-0.46726143,1.2231611,-0.49236312,-0.48808728,-0.46726143,1.2310301,-0.49235594,-0.48808728,-0.46726143,1.2312025,-0.49235594,-0.4873471,-0.46726143,1.2306851,-0.49235594,-0.48808728,-0.46651406,1.2304552,-0.49235594,-0.48808728,-0.46726143,1.2301893,-0.49235594,-0.4873471,-0.46726143,1.2313175,-0.49235594,-0.48808728,-0.46726143,1.2312097,-0.49235594,-0.4873471,-0.46800162,1.2306564,-0.49236312,-0.4873471,-0.46800162,1.2321152,-0.49235594,-0.4873471,-0.46800162,1.2318134,-0.49235594,-0.4873471,-0.46800162,1.2322877,-0.49235594,-0.4873471,-0.46726143,1.2316194,-0.49235594,-0.4873471,-0.46800162,1.2314469,-0.49235594,-0.4873471,-0.46800162,1.231799,-0.49235594,-0.4873471,-0.46800162,1.2319355,-0.49235594,-0.4873471,-0.46800162,1.2315834,-0.49235594,-0.4873471,-0.46800162,1.2310157,-0.49235594,-0.48808728,-0.46800162,1.2304624,-0.49236312,-0.4873471,-0.46800162,1.2327835,-0.49235594,-0.48659972,-0.46726143,1.2341202,-0.49235594,-0.4873471,-0.46800162,1.2331069,-0.49235594,-0.4873471,-0.46800162,1.2319571,-0.49235594,-0.4873471,-0.46800162,1.2323164,-0.49235594,-0.4873471,-0.46726143,1.2322589,-0.49235594,-0.4873471,-0.46800162,1.2318421,-0.49235594,-0.4873471,-0.46800162,1.2319715,-0.49235594,-0.51709831,8.7834702,1.2143723,-0.45074016,-0.4873471,-0.46800162,1.2320721,-0.49235594,-0.48659972,-0.46800162,1.2330997,-0.49235594,-0.48659972,-0.46726143,1.2337896,-0.49235594,-0.48659972,-0.46726143,1.2337393,-0.49235594,-0.48659972,-0.46726143,1.2334159,-0.49235594,-0.48659972,-0.46726143,1.2334662,-0.49235594,-0.48659972,-0.46726143,1.2340627,-0.49235594,-0.48659972,-0.46800162,1.2338758,-0.49235594,-0.48659972,-0.46726143,1.2347741,-0.49235594,-0.48659972,-0.46726143,1.2340268,-0.49235594,-0.48659972,-0.46726143,1.2340052,-0.49235594,-0.48659972,-0.46726143,1.2346663,-0.49235594,-0.48659972,-0.46726143,1.2343214,-0.49235594,-0.48659972,-0.46726143,1.2332938,-0.49235594,-0.48659972,-0.46726143,1.2335453,-0.49235594,-0.48659972,-0.46800162,1.2332363,-0.49235594,-0.48659972,-0.46800162,1.2338471,-0.49235594,-0.48659972,-0.46726143,1.2336531,-0.49235594,-0.48659972,-0.46800162,1.2328626,-0.49235594,-0.4873471,-0.46800162,1.2319355,-0.49235594,-0.4873471,-0.46800162,1.2318637,-0.49235594,-0.48659972,-0.46800162,1.2328626,-0.49235594,-0.48659972,-0.46800162,1.2334519,-0.49235594,-0.48659972,-0.46726143,1.2344364,-0.49235594,-0.48659972,-0.46726143,1.2350831,-0.49235594,-0.48883466,-0.46800162,1.2266824,-0.49236312,-0.48883466,-0.46800162,1.2266033,-0.49236312,-0.48883466,-0.46800162,1.2267758,-0.49236312,-0.48883466,-0.46800162,1.2271567,-0.49236312,-0.48883466,-0.46800162,1.2271567,-0.49236312,-0.48883466,-0.46800162,1.2275807,-0.49236312,-0.48883466,-0.46800162,1.2271279,-0.49236312,-0.48883466,-0.46800162,1.2271351,-0.49236312,-0.48883466,-0.46800162,1.2269698,-0.49236312,-0.48883466,-0.46800162,1.2264812,-0.49236312,-0.48883466,-0.46800162,1.2269123,-0.49236312,-0.48883466,-0.46800162,1.226589,-0.49236312,-0.48883466,-0.46800162,1.2253673,-0.49236312,-0.48957484,-0.46800162,1.2250511,-0.49236312,-0.48883466,-0.46800162,1.2267542,-0.49236312,-0.48883466,-0.46800162,1.2253385,-0.49236312,-0.48883466,-0.46800162,1.2255038,-0.49236312,-0.49254997,-0.49254997,1.2260069,-0.49254997,-0.49254997,-0.49254997,1.2255901,-0.49254997,-0.49254997,-0.49254997,1.2261506,-0.49254997,-0.49254997,-0.49254997,1.2270632,-0.49254997,-0.49254997,-0.49254997,1.2267686,-0.49254997,-0.49254997,-0.49254997,1.2276669,-0.49254997,-0.49254997,-0.49254997,1.2273291,-0.49254997,-0.49254997,-0.49254997,1.2271567,-0.49254997,-0.49254997,-0.49254997,1.2277675,-0.49254997,-0.49254997,-0.49254997,1.2259781,-0.49254997,-0.49254997,-0.49254997,1.2262943,-0.49254997,-0.49254997,-0.49254997,1.2257625,-0.49254997,-0.49254997,-0.49254997,1.2262081,-0.49254997,-0.49254997,-0.49254997,1.2266321,-0.49254997,-0.49254997,-0.49254997,1.2258703,-0.49254997,-0.49254997,-0.49254997,1.2252451,-0.49254997,-0.49254997,-0.49254997,1.225741,-0.49254997,-0.49254997,-0.49254997,1.2255038,-0.49254997,-0.49254997,-0.49254997,1.2263734,-0.49254997,-0.49254997,-0.49254997,1.2328841,-0.49254997,-0.49254997,-0.49254997,1.2329991,-0.49254997,-0.49254997,-0.49254997,1.2337321,-0.49254997,-0.49254997,-0.49254997,1.2338543,-0.49254997,-0.49254997,-0.49254997,1.2336674,-0.49254997,-0.49254997,-0.49254997,1.2335956,-0.49254997,-0.49254997,-0.49254997,1.2335453,-0.49254997,-0.49254997,-0.49254997,1.2340627,-0.49254997,-0.49254997,-0.49254997,1.2343789,-0.49254997,-0.49254997,-0.49254997,1.2354137,-0.49254997,-0.49254997,-0.49254997,1.2278897,-0.49254997,-0.49254997,-0.49254997,1.2275447,-0.49254997,-0.49254997,-0.49254997,1.2281268,-0.49254997,-0.49254997,-0.49254997,1.2263446,-0.49254997,-0.49254997,-0.49254997,1.2272429,-0.49254997,-0.49254997,-0.49254997,1.2269195,-0.49254997,-0.49254997,-0.49254997,1.227516,-0.49254997,-0.49254997,-0.49254997,1.2345801,-0.49254997,-0.49254997,-0.49254997,1.2341417,-0.49254997,-0.49254997,-0.49254997,1.2337249,-0.49254997,-0.49254997,-0.49254997,1.2337752,-0.49254997,-0.49254997,-0.49254997,1.2322014,-0.49254997,-0.49254997,-0.49254997,1.2320146,-0.49254997,-0.49254997,-0.49254997,1.2315906,-0.49254997,-0.49254997,-0.49254997,1.2317775,-0.49254997,-0.49254997,-0.49254997,1.2316912,-0.49254997,-0.49254997,-0.49254997,1.2323811,-0.49254997,-0.49254997,-0.49254997,1.232877,-0.49254997,-0.49254997,-0.49254997,1.2253457,-0.49254997,-0.49254997,-0.49254997,1.2244977,-0.49254997,-0.49254997,-0.49254997,1.2252379,-0.49254997,-0.49254997,-0.49254997,1.2256547,-0.49254997,-0.49254997,-0.49254997,1.2248211,-0.49254997,-0.49254997,-0.49254997,1.2265818,-0.49254997,-0.49254997,-0.49254997,1.2271495,-0.49254997,-0.49254997,-0.49254997,1.226977,-0.49254997,-0.49254997,-0.49254997,1.2267183,-0.49254997,-0.49254997,-0.49254997,1.2259063,-0.49254997,-0.49254997,-0.49254997,1.2328266,-0.49254997,-0.49254997,-0.49254997,1.2326398,-0.49254997,-0.49254997,-0.49254997,1.2327692,-0.49254997,-0.49254997,-0.49254997,1.2330494,-0.49254997,-0.49254997,-0.49254997,1.2270489,-0.49254997,-0.49254997,-0.49254997,1.2272142,-0.49254997,-0.49254997,-0.49254997,1.2265243,-0.49254997,-0.49254997,-0.49254997,1.2274226,-0.49254997,-0.49254997,-0.49254997,1.2278681,-0.49254997,-0.49254997,-0.49254997,1.2279687,-0.49254997,-0.49254997,-0.49254997,1.2281915,-0.49254997,-0.49254997,-0.49254997,1.227595,-0.49254997,-0.49254997,-0.49254997,1.2275878,-0.49254997,-0.49254997,-0.49254997,1.2271495,-0.49254997,-0.49254997,-0.49254997,1.2277388,-0.49254997,-0.49254997,-0.49254997,1.2276453,-0.49254997,-0.49254997,-0.49254997,1.2274513,-0.49254997,-0.49254997,-0.49254997,1.2280765,-0.49254997,-0.49254997,-0.49254997,1.2281843,-0.49254997,-0.49254997,-0.49254997,1.2273004,-0.49254997,-0.49254997,-0.49254997,1.2285508,-0.49254997,-0.49254997,-0.49254997,1.2282274,-0.49254997,-0.49254997,-0.49254997,1.2283568,-0.49254997,-0.49254997,-0.49254997,1.2274872,-0.49254997,-0.49254997,-0.49254997,1.226359,-0.49254997,-0.49254997,-0.49254997,1.2273004,-0.49254997,-0.49254997,-0.49254997,1.2282562,-0.49254997,-0.49254997,-0.49254997,1.2267614,-0.49254997,-0.49254997,-0.49254997,1.2267902,-0.49254997,-0.49254997,-0.49254997,1.2277531,-0.49254997,-0.49254997,-0.49254997,1.2266033,-0.49254997,-0.49254997,-0.49254997,1.2263374,-0.49254997,-0.49254997,-0.49254997,1.2265315,-0.49254997,-0.49254997,-0.49254997,1.2277028,-0.49254997,-0.49254997,-0.49254997,1.2263806,-0.49254997,-0.49254997,-0.49254997,1.2268117,-0.49254997,-0.49254997,-0.49254997,1.2267902,-0.49254997,-0.49254997,-0.49254997,1.2269914,-0.49254997,-0.49254997,-0.49254997,1.2270417,-0.49254997,-0.49254997,-0.49254997,1.2263302,-0.49254997,-0.49254997,-0.49254997,1.2260859,-0.49254997,-0.49254997,-0.49254997,1.2269411,-0.49254997,-0.49254997,-0.49254997,1.2265458,-0.49254997,-0.49254997,-0.49254997,1.2261937,-0.49254997,-0.49254997,-0.49254997,1.2263877,-0.49254997,-0.49254997,-0.49254997,1.2266752,-0.49254997,-0.49254997,-0.49254997,1.2266321,-0.49254997,-0.49254997,-0.49254997,1.2276094,-0.49254997,-0.49254997,-0.49254997,1.2274226,-0.49254997,-0.49254997,-0.49254997,1.2273363,-0.49254997,-0.49254997,-0.49254997,1.2269123,-0.49254997,-0.49254997,-0.49254997,1.2272285,-0.49254997,-0.49254997,-0.49254997,1.2264955,-0.49254997,-0.49254997,-0.49254997,1.2277172,-0.49254997,-0.49254997,-0.49254997,1.2272573,-0.49254997,-0.49254997,-0.49254997,1.2273579,-0.49254997,-0.49254997,-0.49254997,1.2275807,-0.49254997,-0.49254997,-0.49254997,1.2271495,-0.49254997,-0.49254997,-0.49254997,1.2268189,-0.49254997,-0.49254997,-0.49254997,1.22605,-0.49254997,-0.49254997,-0.49254997,1.225396,-0.49254997,-0.49254997,-0.49254997,1.2119649,-0.49254997,-0.49254997,-0.49254997,1.2133303,-0.49254997,-0.49254997,-0.49254997,1.2132943,-0.49254997,-0.49254997,-0.49254997,1.2129063,-0.49254997,-0.49254997,-0.49254997,1.2120439,-0.49254997,-0.49254997,-0.49254997,1.2126188,-0.49254997,-0.49254997,-0.49254997,1.2129638,-0.49254997,-0.49254997,-0.49254997,1.2126188,-0.49254997,-0.49254997,-0.49254997,1.2267974,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997,-0.49254997,-0.49254997,1.2242606,-0.49254997:3
-0.62357919,-0.50616955,1.5103063,-0.51196211,-0.62178687,-0.46493764,1.5095703,-0.50958101,-0.61371712,8.625685,1.4761397,-0.47056569,-0.62357919,-0.50616955,1.5114145,-0.51196211,-0.20499999,9.8662096,1.4708667,-0.46709362,-0.17900709,-0.15659882,1.5118561,-0.51023906,-0.21396157,9.8706947,1.4715334,-0.46709362,-0.62357919,-0.50616955,1.5131549,-0.51196211,-0.62357919,-0.50616955,1.512315,-0.51196211,-0.62357919,-0.50616955,1.5127566,-0.51196211,-0.62357919,-0.50616955,1.5116224,-0.51196211,-0.62357919,-0.50616955,1.5153282,-0.51196211,-0.62357919,-0.50616955,1.5162547,-0.51196211,-0.62357919,-0.50616955,1.5139342,-0.51196211,-0.62357919,-0.50616955,1.5122891,-0.51196211,-0.62357919,-0.50616955,1.5115271,-0.51196211,-0.62357919,-0.49900029,1.5133108,-0.51117418,-0.62357919,-0.50616955,1.5123756,-0.51196211,-0.62357919,-0.50616955,1.5103236,-0.51196211,-0.62357919,-0.50616955,1.5097954,-0.51196211,-0.62357919,-0.50616955,1.5100032,-0.51196211,-0.62357919,-0.50616955,1.5110595,-0.51196211,-0.62357919,-0.50706138,1.5106786,-0.51196211,-0.62357919,-0.50616955,1.5115011,-0.51196211,-0.62357919,-0.50616955,1.5110595,-0.51196211,-0.62357919,-0.50616955,1.5109816,-0.51196211,-0.62268736,-0.50616955,1.5058471,-0.51196211,-0.62268736,-0.50616955,1.5087737,-0.51196211,-0.62268736,-0.50616955,1.5057086,-0.51196211,-0.62268736,-0.50706138,1.5072498,-0.51196211,-0.62268736,-0.50616955,1.5050159,-0.51196211,-0.62357919,-0.50616955,1.5110942,-0.51196211,-0.62357919,-0.50616955,1.510947,-0.51196211,-0.62357919,-0.50616955,1.5109383,-0.51196211,-0.62357919,-0.50616955,1.5108431,-0.51196211,-0.62357919,-0.50616955,1.5109989,-0.51196211,-0.62357919,-0.50616955,1.5108604,-0.51196211,-0.62357919,-0.50706138,1.5135359,-0.51196211,-0.62357919,-0.50616955,1.514852,-0.51196211,-0.62357919,-0.50616955,1.515155,-0.51196211,-0.62357919,-0.50616955,1.5177093,-0.51196211,-0.62357919,-0.50616955,1.5163066,-0.51196211,-0.62357919,-0.50616955,1.5166876,-0.51196211,-0.62357919,-0.50616955,1.5167742,-0.51196211,-0.62357919,-0.50616955,1.5169733,-0.51196211,-0.62357919,-0.50616955,1.5156832,-0.51196211,-0.62357919,-0.50616955,1.5135705,-0.51196211,-0.62357919,-0.50616955,1.511328,-0.51196211,-0.62357919,-0.50616955,1.5124622,-0.51196211,-0.62268736,-0.50616955,1.5098647,-0.51196211,-0.62357919,-0.50616955,1.5105574,-0.51196211,-0.62357919,-0.50616955,1.5155793,-0.51196211,-0.62357919,-0.50616955,1.5135532,-0.51196211,-0.62357919,-0.50616955,1.5165664,-0.51196211,-0.62357919,-0.50616955,1.5162287,-0.51196211,-0.62268736,-0.48644543,1.5142632,-0.51042955,-0.62357919,-0.50616955,1.5149645,-0.51196211,-0.62357919,-0.50616955,1.5145489,-0.51196211,-0.62357919,-0.50616955,1.5153715,-0.51196211,-0.62357919,-0.50616955,1.5145056,-0.51196211,-0.62357919,-0.50616955,1.5138476,-0.51196211,-0.62357919,-0.50616955,1.513813,-0.51196211,-0.62357919,-0.50616955,1.5130337,-0.51196211,-0.62357919,-0.50616955,1.5109383,-0.51196211,-0.62357919,-0.50616955,1.5120639,-0.51196211,-0.62357919,-0.50616955,1.5131549,-0.51196211,-0.62357919,-0.50616955,1.5112674,-0.51196211,-0.62268736,-0.49630749,1.5103063,-0.51098369,-0.62357919,-0.50616955,1.5126787,-0.51196211,-0.62357919,-0.50616955,1.5135619,-0.51196211,-0.62357919,-0.50616955,1.5127653,-0.51196211,-0.62357919,-0.50616955,1.5110163,-0.51196211,-0.62268736,-0.50616955,1.510237,-0.51196211,-0.62357919,-0.50616955,1.5109124,-0.51196211,-0.62357919,-0.50616955,1.5137177,-0.51196211,-0.62357919,-0.50616955,1.5115617,-0.51196211,-0.62268736,-0.50616955,1.5091806,-0.51196211,-0.62357919,-0.50616955,1.5109816,-0.51196211,-0.62268736,-0.50616955,1.5103842,-0.51196211,-0.62268736,-0.50616955,1.5105314,-0.51196211,-0.62357919,-0.50616955,1.5116916,-0.51196211,-0.62268736,-0.50616955,1.5104881,-0.51196211,-0.62268736,-0.50616955,1.5102283,-0.51196211,-0.62268736,-0.50616955,1.5109903,-0.51196211,-0.62357919,-0.50616955,1.5147221,-0.51196211,-0.62357919,-0.50616955,1.5147048,-0.51196211,-0.62357919,-0.50616955,1.5167309,-0.51196211,-0.62357919,-0.50616955,1.5146095,-0.51196211,-0.62357919,-0.50616955,1.5140208,-0.51196211,-0.62268736,-0.50616955,1.5060722,-0.51196211,-0.62268736,-0.50616955,1.5081849,-0.51196211,-0.62268736,-0.50616955,1.5084187,-0.51196211,-0.62268736,-0.50706138,1.5067476,-0.51196211,-0.62357919,-0.50616955,1.5122891,-0.51196211,-0.62357919,-0.50616955,1.51409,-0.51196211,-0.62357919,-0.50616955,1.5133367,-0.51196211,-0.62357919,-0.50616955,1.5148173,-0.51196211,-0.62268736,-0.49900029,1.5132242,-0.51111357,-0.62357919,-0.50616955,1.5153542,-0.51196211,-0.62268736,-0.50616955,1.5125575,-0.51196211,-0.62357919,-0.50616955,1.5126267,-0.51196211,-0.62268736,-0.50616955,1.5130856,-0.51196211,-0.62357919,-0.50616955,1.5138995,-0.51196211,-0.62357919,-0.50616955,1.5137091,-0.51196211,-0.62357919,-0.50616955,1.5156659,-0.51196211,-0.62357919,-0.50616955,1.5132155,-0.51196211,-0.62357919,-0.50616955,1.5147048,-0.51196211,-0.62357919,-0.50616955,1.5141853,-0.51196211,-0.62357919,-0.50616955,1.5124449,-0.51196211,-0.62268736,-0.50616955,1.5122284,-0.51196211,-0.62357919,-0.50616955,1.5121159,-0.51196211,-0.62268736,-0.50616955,1.5083148,-0.51196211,-0.62178687,-0.46493764,1.5108085,-0.5095637,-0.62357919,-0.50616955,1.5121678,-0.51196211,-0.62268736,-0.50616955,1.5128345,-0.51196211,-0.62357919,-0.50616955,1.5130337,-0.51196211,-0.62357919,-0.50616955,1.5140208,-0.51196211,-0.62357919,-0.50706138,1.512696,-0.51196211,-0.62268736,-0.50616955,1.5102543,-0.51196211,-0.62268736,-0.50616955,1.5112327,-0.51196211,-0.62268736,-0.50616955,1.5114319,-0.51196211,-0.62268736,-0.50616955,1.511986,-0.51196211,-0.62357919,-0.50616955,1.512393,-0.51196211,-0.62268736,-0.50616955,1.5100552,-0.51196211,-0.62268736,-0.50616955,1.5114578,-0.51196211,-0.62268736,-0.50616955,1.512341,-0.51196211,-0.62268736,-0.50616955,1.5115704,-0.51196211,-0.61820224,-0.37261177,1.5106699,-0.50735577,-0.62268736,-0.50616955,1.5122371,-0.51196211,-0.62268736,-0.50616955,1.5110336,-0.51196211,-0.62268736,-0.50616955,1.5112674,-0.51196211,-0.62268736,-0.50616955,1.5108085,-0.51196211,-0.62268736,-0.50616955,1.5112067,-0.51196211,-0.62268736,-0.50616955,1.5087217,-0.51196211,-0.62268736,-0.50616955,1.5097781,-0.51196211,-0.62268736,-0.50616955,1.5088689,-0.51196211,-0.62268736,-0.50616955,1.5102716,-0.51196211,-0.62268736,-0.50706138,1.5114059,-0.51196211,-0.62357919,-0.50616955,1.51409,-0.51196211,-0.62268736,-0.50616955,1.5126094,-0.51196211,-0.62268736,-0.50616955,1.5128345,-0.51196211,-0.62268736,-0.50616955,1.5097781,-0.51196211,-0.62268736,-0.50616955,1.5112414,-0.51196211,-0.62268736,-0.50616955,1.5103755,-0.51196211,-0.62268736,-0.50616955,1.5111721,-0.51196211,-0.62268736,-0.50616955,1.5083581,-0.51196211,-0.62268736,-0.50616955,1.5115704,-0.51196211,-0.62268736,-0.50616955,1.5117782,-0.51196211,-0.62268736,-0.50616955,1.5112414,-0.51196211,-0.62268736,-0.50616955,1.5110076,-0.51196211,-0.62268736,-0.50616955,1.5111375,-0.51196211,-0.62268736,-0.50616955,1.5064792,-0.51196211,-0.62178687,-0.50616955,1.5050159,-0.51196211,-0.62268736,-0.50616955,1.5057952,-0.51196211,-0.62268736,-0.50616955,1.5099686,-0.51196211,-0.62268736,-0.50616955,1.5086871,-0.51196211,-0.62268736,-0.50616955,1.5081763,-0.51196211,-0.62268736,-0.50616955,1.511276,-0.51196211,-0.62268736,-0.50616955,1.5127306,-0.51196211,-0.62268736,-0.50616955,1.510947,-0.51196211,-0.62268736,-0.50616955,1.5098993,-0.51196211,-0.62268736,-0.50706138,1.5069121,-0.51196211,-0.62268736,-0.50616955,1.5080204,-0.51196211,-0.60654786,0.063899239,1.5055527,-0.50197017,-0.62268736,-0.50616955,1.510592,-0.51196211,-0.62268736,-0.50616955,1.5108344,-0.51196211,-0.62268736,-0.50616955,1.509198,-0.51196211,-0.62268736,-0.50616955,1.5105833,-0.51196211,-0.62268736,-0.50616955,1.5114838,-0.51196211,-0.62268736,-0.50616955,1.5092326,-0.51196211,-0.62268736,-0.50616955,1.5109297,-0.51196211,-0.62268736,-0.50706138,1.5107132,-0.51196211,-0.62268736,-0.50616955,1.5085919,-0.51196211,-0.62268736,-0.50616955,1.5084187,-0.51196211,-0.62268736,-0.50616955,1.5097435,-0.51196211,-0.62268736,-0.50616955,1.5093019,-0.51196211,-0.62268736,-0.50616955,1.5122544,-0.51196211,-0.62268736,-0.50616955,1.5100638,-0.51196211,-0.62268736,-0.50616955,1.5101764,-0.51196211,-0.62268736,-0.50616955,1.5097867,-0.51196211,-0.62268736,-0.50706138,1.5089988,-0.51196211,-0.62268736,-0.50616955,1.5107219,-0.51196211,-0.62268736,-0.50616955,1.51125,-0.51196211,-0.62268736,-0.50616955,1.5118734,-0.51196211,-0.60565603,0.64472192,1.5083408,-0.49756298,-0.62268736,-0.50616955,1.5090161,-0.51196211,-0.62268736,-0.50616955,1.5093971,-0.51196211,-0.62268736,-0.50616955,1.5069727,-0.51196211,-0.62268736,-0.50616955,1.5072152,-0.51196211,-0.62268736,-0.50616955,1.5067649,-0.51196211,-0.62268736,-0.50616955,1.5058211,-0.51196211,-0.62178687,-0.50616955,1.5064099,-0.51196211,-0.62268736,-0.50616955,1.5064099,-0.51196211,-0.62268736,-0.50616955,1.5065831,-0.51196211,-0.62268736,-0.50616955,1.5062887,-0.51196211,-0.62178687,-0.50616955,1.506358,-0.51197077,-0.62268736,-0.50616955,1.5078386,-0.51196211,-0.62268736,-0.50616955,1.5074749,-0.51196211,-0.62178687,-0.50616955,1.5060982,-0.51196211,-0.62178687,-0.50616955,1.50628,-0.51196211,-0.62178687,-0.50616955,1.5053709,-0.51197077,-0.62268736,-0.50706138,1.5066437,-0.51196211,-0.62178687,-0.50616955,1.5066177,-0.51196211,-0.62268736,-0.50616955,1.510592,-0.51196211,-0.62268736,-0.50616955,1.512038,-0.51196211,-0.60654786,1.7516973,1.4999593,-0.49161457,-0.62268736,-0.50616955,1.5069727,-0.51196211,-0.62268736,-0.50616955,1.5070853,-0.51196211,-0.62178687,-0.50616955,1.50557,-0.51197077,-0.62178687,-0.50616955,1.5059943,-0.51196211,-0.62178687,-0.50706138,1.5041847,-0.51196211,-0.62178687,-0.50616955,1.5058558,-0.51196211,-0.62178687,-0.50616955,1.5069381,-0.51196211,-0.62268736,-0.50616955,1.5071286,-0.51196211,-0.62268736,-0.50616955,1.5072758,-0.51196211,-0.62268736,-0.50706138,1.5068602,-0.51196211,-0.62178687,-0.50616955,1.5065225,-0.51196211,-0.62178687,-0.50706138,1.5060982,-0.51196211,-0.62178687,-0.50616955,1.506358,-0.51196211,-0.62178687,-0.50616955,1.5026608,-0.51197077,-0.62178687,-0.50616955,1.5022365,-0.51197077,-0.62178687,-0.50616955,1.5026521,-0.51196211,-0.62178687,-0.50616955,1.5033102,-0.51197077,-0.62268736,-0.50616955,1.5074576,-0.51196211,-0.62268736,-0.50616955,1.5071372,-0.51196211,-0.62268736,-0.50616955,1.507068,-0.51196211,-0.62268736,-0.50616955,1.5091547,-0.51196211,-0.62268736,-0.50616955,1.5065052,-0.51196211,-0.62178687,-0.50616955,1.5055441,-0.51196211,-0.62178687,-0.50706138,1.5046349,-0.51196211,-0.62178687,-0.50706138,1.5050592,-0.51196211,-0.62178687,-0.50616955,1.506306,-0.51196211,-0.60744835,3.3794399,1.488582,-0.48512067,-0.62178687,-0.50616955,1.5048427,-0.51196211,-0.62268736,-0.50616955,1.5065311,-0.51196211,-0.62178687,-0.50616955,1.5064532,-0.51196211,-0.62268736,-0.50616955,1.5077087,-0.51196211,-0.62268736,-0.50616955,1.5075615,-0.51196211,-0.62268736,-0.50616955,1.50912,-0.51196211,-0.62268736,-0.50706138,1.5081416,-0.51196211,-0.62268736,-0.50616955,1.5076394,-0.51196211,-0.62268736,-0.50616955,1.5076221,-0.51196211,-0.62268736,-0.50616955,1.5082975,-0.51196211,-0.62268736,-0.50616955,1.5073537,-0.51196211,-0.62178687,-0.50706138,1.5050505,-0.51196211,-0.62268736,-0.50616955,1.5093452,-0.51196211,-0.62178687,-0.50616955,1.5049899,-0.51196211,-0.62268736,-0.50616955,1.5071805,-0.51196211,-0.62268736,-0.50616955,1.5060722,-0.51196211,-0.62178687,-0.50706138,1.505951,-0.51196211,-0.62178687,-0.50616955,1.504557,-0.51196211,-0.62268736,-0.50616955,1.5067043,-0.51196211,-0.62268736,-0.50616955,1.5061502,-0.51196211,-0.62268736,-0.50616955,1.5066697,-0.51196211,-0.62268736,-0.50616955,1.5066697,-0.51196211,-0.62268736,-0.50616955,1.5068428,-0.51196211,-0.62268736,-0.50616955,1.5089469,-0.51196211,-0.62268736,-0.50616955,1.5072585,-0.51196211,-0.62268736,-0.50616955,1.5058385,-0.51196211,-0.61013249,3.9136537,1.4908073,-0.48330238,-0.62268736,-0.50616955,1.5099859,-0.51196211,-0.62268736,-0.50616955,1.5069641,-0.51196211,-0.62178687,-0.50616955,1.5058211,-0.51196211,-0.62268736,-0.50616955,1.507371,-0.51196211,-0.62178687,-0.50616955,1.5061848,-0.51196211,-0.62178687,-0.50616955,1.5066177,-0.51196211,-0.62178687,-0.50706138,1.5045743,-0.51197077,-0.62268736,-0.50616955,1.5098127,-0.51196211,-0.62268736,-0.50706138,1.508765,-0.51196211,-0.62268736,-0.50616955,1.5087217,-0.51196211,-0.62268736,-0.50616955,1.5089036,-0.51196211,-0.62268736,-0.50616955,1.5080897,-0.51196211,-0.62268736,-0.50706138,1.5079944,-0.51196211,-0.62268736,-0.50616955,1.5073797,-0.51196211,-0.62268736,-0.50706138,1.5087997,-0.51196211,-0.63791771,0.0065364944,1.5064532,-0.50249834,-0.62268736,-0.50616955,1.5089469,-0.51196211,-0.62268736,-0.50706138,1.5094837,-0.51196211,-0.62268736,-0.50616955,1.5097002,-0.51196211,-0.62268736,-0.50616955,1.5082022,-0.51196211,-0.62268736,-0.50706138,1.507778,-0.51196211,-0.62268736,-0.50616955,1.5065658,-0.51196211,-0.62178687,-0.50706138,1.5054835,-0.51197077,-0.62268736,-0.50706138,1.5074316,-0.51196211,-0.62268736,-0.50616955,1.5087737,-0.51196211,-0.62268736,-0.50706138,1.5119167,-0.51196211,-0.62357919,-0.50616955,1.5138909,-0.51196211,-0.62268736,-0.50616955,1.5138995,-0.51196211,-0.62268736,-0.50616955,1.5121938,-0.51196211,-0.62268736,-0.50616955,1.5115098,-0.51196211,-0.62268736,-0.50616955,1.5116916,-0.51196211,-0.62268736,-0.50616955,1.5109643,-0.51196211,-0.62268736,-0.50616955,1.5104448,-0.51196211,-0.62178687,-0.50616955,1.5051717,-0.51197077,-0.62268736,-0.50616955,1.5072238,-0.51196211,-0.62268736,-0.50616955,1.509553,-0.51196211,-0.62268736,-0.50616955,1.5087304,-0.51196211,-0.62268736,-0.50616955,1.5085226,-0.51196211,-0.62178687,-0.50706138,1.5051371,-0.51196211,-0.62178687,-0.50706138,1.501665,-0.51197077,-0.62268736,-0.50616955,1.5085139,-0.51196211,-0.62178687,-0.50706138,1.5028166,-0.51197077,-0.62268736,-0.50616955,1.512341,-0.51196211,-0.62357919,-0.50616955,1.5149905,-0.51196211,-0.62268736,-0.50616955,1.5137177,-0.51196211,-0.62268736,-0.50616955,1.5107392,-0.51196211,-0.62268736,-0.50616955,1.5121852,-0.51196211,-0.62268736,-0.50616955,1.5147741,-0.51196211,-0.63971002,0.62679877,1.5087737,-0.49767554,-0.62268736,-0.50616955,1.514523,-0.51196211,-0.62357919,-0.50616955,1.5160122,-0.51196211,-0.62357919,-0.50616955,1.5165404,-0.51196211,-0.62357919,-0.50616955,1.5158564,-0.51196211,-0.62357919,-0.50616955,1.5149905,-0.51196211,-0.62268736,-0.50616955,1.5140381,-0.51196211,-0.62268736,-0.50616955,1.511657,-0.51196211,-0.62357919,-0.50616955,1.5144017,-0.51196211,-0.62268736,-0.50616955,1.5126267,-0.51196211,-0.62357919,-0.50616955,1.5153715,-0.51196211,-0.62268736,-0.50616955,1.5140814,-0.51196211,-0.62268736,-0.50616955,1.5142026,-0.51196211,-0.62357919,-0.50616955,1.5165837,-0.51196211,-0.62268736,-0.50616955,1.5130077,-0.51196211,-0.62268736,-0.50616955,1.5129211,-0.51196211,-0.62268736,-0.50616955,1.5142719,-0.51196211,-0.62268736,-0.50616955,1.5114405,-0.51196211,-0.62268736,-0.50706138,1.511605,-0.51196211,-0.62357919,-0.50616955,1.5146961,-0.51196211,-0.62357919,-0.50616955,1.5148087,-0.51196211,-0.62268736,-0.50616955,1.5147048,-0.51196211,-0.62268736,-0.50616955,1.5148,-0.51196211,-0.62357919,-0.50616955,1.5153282,-0.51196211,-0.62268736,-0.50616955,1.5145143,-0.51196211,-0.62357919,-0.50706138,1.5145576,-0.51196211,-0.62268736,-0.50616955,1.5134839,-0.51196211,-0.62268736,-0.50616955,1.5102456,-0.51196211,-0.62268736,-0.50616955,1.5137004,-0.51196211,-0.62268736,-0.50616955,1.5142892,-0.51196211,-0.62357919,-0.50616955,1.5138822,-0.51196211,-0.62268736,-0.50616955,1.5133887,-0.51196211,-0.62268736,-0.50706138,1.5139515,-0.51196211,-0.64150234,1.2282374,1.5071546,-0.49417749,-0.62357919,-0.50616955,1.5144017,-0.51196211,-0.62268736,-0.50616955,1.512367,-0.51196211,-0.62268736,-0.50616955,1.5138303,-0.51196211,-0.62357919,-0.50616955,1.5153195,-0.51196211,-0.62357919,-0.50616955,1.5147741,-0.51196211,-0.62357919,-0.50616955,1.5157438,-0.51196211,-0.62357919,-0.50616955,1.5149732,-0.51196211,-0.62268736,-0.50616955,1.5150858,-0.51196211,-0.62268736,-0.50616955,1.5142199,-0.51196211,-0.62268736,-0.50616955,1.5140987,-0.51196211,-0.62268736,-0.50616955,1.5153542,-0.51196211,-0.62357919,-0.50616955,1.5151464,-0.51196211,-0.62357919,-0.50616955,1.5153888,-0.51196211,-0.62357919,-0.50616955,1.5187137,-0.51196211,-0.62357919,-0.50616955,1.5168002,-0.51196211,-0.62357919,-0.50616955,1.5171898,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211,-0.62357919,-0.50616955,1.5178478,-0.51196211:3
-0.6256465,-0.51728741,1.435305,-0.522284,-0.6256465,-0.51728741,1.4375746,-0.522284,-0.62474043,-0.51728741,1.427986,-0.522284,-0.6256465,-0.51728741,1.433616,-0.522284,-0.62200462,4.0477899,1.3966166,-0.4925156,-0.62474043,-0.51728741,1.4297806,-0.522284,-0.62382556,-0.51728741,1.4237284,-0.52229279,-0.6256465,-0.51728741,1.4352522,-0.522284,-0.6256465,-0.51728741,1.4347068,-0.522284,-0.6256465,-0.51728741,1.4337567,-0.522284,-0.62474043,-0.51728741,1.4229719,-0.522284,-0.62474043,-0.51728741,1.4294111,-0.522284,-0.6256465,-0.51728741,1.4320502,-0.522284,-0.6256465,-0.51728741,1.435129,-0.522284,-0.6256465,-0.51728741,1.4327011,-0.522284,-0.62474043,-0.51728741,1.4285578,-0.522284,-0.62474043,-0.51728741,1.4299125,-0.522284,-0.62474043,-0.51728741,1.4292352,-0.522284,-0.6256465,-0.51728741,1.4332025,-0.522284,-0.62474043,-0.51728741,1.4308186,-0.522284,-0.62474043,-0.51728741,1.4321205,-0.522284,-0.62474043,-0.51728741,1.4315663,-0.522284,-0.6256465,-0.51728741,1.4347596,-0.522284,-0.62474043,-0.51728741,1.4274582,-0.522284,-0.6256465,-0.51728741,1.4336248,-0.522284,-0.6256465,-0.51728741,1.4326307,-0.522284,-0.12662115,9.0982576,1.3632943,-0.47781613,-0.07471118,0.94430231,1.4167789,-0.50764611,-0.057416654,-0.04557615,1.4303436,-0.51958338,-0.62474043,-0.51728741,1.4262179,-0.522284,-0.6256465,-0.51728741,1.4345836,-0.522284,-0.62474043,-0.51728741,1.4271943,-0.522284,-0.62474043,-0.51728741,1.431839,-0.522284,-0.6256465,-0.51728741,1.4318302,-0.522284,-0.62474043,-0.51728741,1.4258924,-0.522284,-0.62474043,-0.51728741,1.4239043,-0.52229279,-0.6256465,-0.51728741,1.4326747,-0.522284,-0.6256465,-0.51728741,1.4322437,-0.522284,-0.62474043,-0.51728741,1.4281796,-0.522284,-0.62474043,-0.51728741,1.4281356,-0.522284,-0.6256465,-0.51728741,1.4336864,-0.522284,-0.62474043,-0.51728741,1.4323932,-0.522284,-0.63475999,-0.26231192,1.4249951,-0.51557203,-0.62474043,-0.51728741,1.4317071,-0.522284,-0.62474043,-0.51728741,1.4271767,-0.522284,-0.6256465,-0.51728741,1.4335192,-0.522284,-0.6256465,-0.51728741,1.4338623,-0.522284,-0.62474043,-0.51728741,1.4281268,-0.522284,-0.62474043,-0.51728741,1.4315223,-0.522284,-0.62474043,-0.51728741,1.4280036,-0.522284,-0.62474043,-0.51728741,1.4278277,-0.522284,-0.62474043,-0.51728741,1.4311705,-0.522284,-0.62474043,-0.51728741,1.43015,-0.522284,-0.6256465,-0.51728741,1.4354457,-0.522284,-0.62474043,-0.51728741,1.430326,-0.522284,-0.6256465,-0.51728741,1.4348212,-0.522284,-0.6256465,-0.51728741,1.4373546,-0.522284,-0.62656136,4.0823966,1.3991501,-0.49240124,-0.6256465,-0.51728741,1.436774,-0.522284,-0.6256465,-0.51728741,1.4327627,-0.522284,-0.6256465,-0.51728741,1.434135,-0.522284,-0.6256465,-0.51728741,1.4322349,-0.522284,-0.6256465,-0.51728741,1.4369764,-0.522284,-0.6256465,-0.51728741,1.4325076,-0.522284,-0.62474043,-0.51728741,1.4307658,-0.522284,-0.6256465,-0.51728741,1.4354985,-0.522284,-0.6256465,-0.51728741,1.440284,-0.522284,-0.6256465,-0.51728741,1.437944,-0.522284,-0.6256465,-0.51728741,1.4344957,-0.522284,-0.6256465,-0.51728741,1.4334488,-0.522284,-0.6256465,-0.51728741,1.4357448,-0.522284,-0.6256465,-0.51728741,1.4409261,-0.522284,-0.6256465,-0.51728741,1.4389557,-0.522284,-0.62656136,-0.51728741,1.4408909,-0.522284,-0.62656136,-0.51728741,1.4405215,-0.522284,-0.62656136,-0.51728741,1.4419554,-0.522284,-0.62656136,-0.51728741,1.4412428,-0.522284,-0.62656136,-0.51728741,1.4409437,-0.522284,-0.62656136,4.1170032,1.4064778,-0.49227808,-0.62656136,-0.51728741,1.4413836,-0.522284,-0.62656136,-0.51728741,1.441366,-0.522284,-0.6256465,-0.51728741,1.4381551,-0.522284,-0.6256465,-0.51728741,1.4364398,-0.522284,-0.6256465,-0.51728741,1.4353138,-0.522284,-0.6256465,-0.51728741,1.4390788,-0.522284,-0.6256465,-0.51728741,1.4390788,-0.522284,-0.6256465,-0.51728741,1.4408734,-0.522284,-0.62656136,-0.51728741,1.4415595,-0.522284,-0.6256465,-0.51728741,1.437944,-0.522284,-0.6256465,-0.51728741,1.4370467,-0.522284,-0.62474043,-0.51728741,1.4320062,-0.522284,-0.6256465,4.0796696,1.3987542,-0.49240124,-0.6256465,-0.51728741,1.4338711,-0.522284,-0.62382556,-0.51728741,1.420975,-0.52229279,-0.62474043,-0.51728741,1.428162,-0.522284,-0.62474043,-0.51728741,1.431795,-0.522284,-0.62474043,-0.51728741,1.4315839,-0.522284,-0.6256465,-0.51728741,1.4331058,-0.522284,-0.6256465,-0.51728741,1.4348651,-0.522284,-0.62474043,-0.51728741,1.4314256,-0.522284,-0.62474043,-0.51728741,1.4315136,-0.522284,-0.62474043,-0.51728741,1.4311529,-0.522284,-0.62474043,-0.51728741,1.430845,-0.522284,-0.62474043,-0.51728741,1.4294199,-0.522284,-0.62474043,-0.51728741,1.4287426,-0.522284,-0.62474043,-0.51728741,1.4312584,-0.522284,-0.62474043,-0.51728741,1.430713,-0.522284,-0.62474043,-0.51728741,1.4310121,-0.522284,-0.62474043,-0.51728741,1.4296926,-0.522284,-0.62474043,-0.51728741,1.4307218,-0.522284,-0.62474043,-0.51728741,1.4295958,-0.522284,-0.62474043,-0.51728741,1.4257604,-0.52229279,-0.62474043,-0.51728741,1.425954,-0.522284,-0.62474043,-0.51728741,1.4265522,-0.52229279,-0.62382556,-0.51728741,1.4204032,-0.52229279,-0.6256465,4.0068144,1.3854974,-0.49264755,-0.62474043,-0.51728741,1.424872,-0.52229279,-0.62382556,-0.51728741,1.4177377,-0.52229279,-0.62382556,-0.51728741,1.4168053,-0.52229279,-0.62474043,-0.51728741,1.424089,-0.522284,-0.62382556,-0.51728741,1.4222417,-0.522284,-0.62382556,-0.51728741,1.4217755,-0.52229279,-0.62382556,-0.51728741,1.4225232,-0.52229279,-0.62382556,-0.51728741,1.4203768,-0.522284,-0.62291949,-0.51728741,1.4134713,-0.52229279,-0.62291949,-0.51728741,1.4125564,-0.52229279,-0.62382556,-0.51728741,1.4185471,-0.52229279,-0.62382556,-0.51728741,1.4198754,-0.52229279,-0.62382556,-0.51728741,1.4205087,-0.52229279,-0.62382556,-0.51728741,1.4155561,-0.52229279,-0.40163577,4.362874,1.3815653,-0.49070345,-0.065606483,1.9569469,1.3946725,-0.50147955,-0.62382556,-0.51728741,1.4220394,-0.52229279,-0.62382556,-0.51728741,1.422444,-0.52229279,-0.62382556,-0.51728741,1.4233677,-0.52229279,-0.62291949,-0.51728741,1.414958,-0.52229279,-0.62382556,-0.51728741,1.4205439,-0.52229279,-0.62382556,-0.51728741,1.4229719,-0.52229279,-0.62382556,-0.51728741,1.4215995,-0.52229279,-0.62382556,-0.51728741,1.4218195,-0.522284,-0.62382556,-0.51728741,1.4227607,-0.52229279,-0.62474043,-0.51728741,1.427467,-0.522284,-0.101128,6.6759244,1.3677543,-0.48420261,-0.13936772,8.9625668,1.3514802,-0.4781768,-0.27323755,3.0488156,1.3917696,-0.49594635,-0.62291949,-0.51728741,1.4145093,-0.52229279,-0.62382556,-0.51728741,1.4226288,-0.52229279,-0.6256465,4.0095502,1.3857526,-0.49263875,-0.62291949,-0.51728741,1.413269,-0.52229279,-0.62382556,-0.51728741,1.4200601,-0.52229279,-0.62474043,4.0049935,1.3847409,-0.49265635,-0.62382556,-0.51728741,1.4168933,-0.52229279,-0.62291949,-0.51728741,1.4095039,-0.52229279,-0.62382556,-0.51728741,1.4211333,-0.52229279,-0.62291949,-0.51728741,1.4133305,-0.52229279,-0.62382556,-0.51728741,1.4224089,-0.52229279,-0.62382556,-0.51728741,1.4154154,-0.52229279,-0.62382556,-0.51728741,1.4207814,-0.52229279,-0.62291949,-0.51728741,1.4138584,-0.52229279,-0.62291949,-0.51728741,1.4151867,-0.52229279,-0.62291949,-0.51728741,1.4147908,-0.52229279,-0.62382556,-0.51728741,1.4182128,-0.52229279,-0.62382556,-0.51728741,1.4195851,-0.52229279,-0.62382556,-0.51728741,1.4195323,-0.52229279,-0.62200462,-0.51728741,1.4056421,-0.52229279,-0.62382556,-0.51728741,1.4196379,-0.52229279,-0.62382556,-0.51728741,1.4206935,-0.52229279,-0.62291949,-0.51728741,1.4148084,-0.52229279,-0.62382556,-0.51728741,1.4200161,-0.52229279,-0.62382556,-0.51728741,1.4219866,-0.52229279,-0.62382556,-0.51728741,1.4166557,-0.52229279,-0.62382556,-0.51728741,1.4171132,-0.52229279,-0.62382556,-0.51728741,1.4168933,-0.52229279,-0.62382556,-0.51728741,1.4225848,-0.52229279,-0.62382556,-0.51728741,1.4218195,-0.52229279,-0.62382556,-0.51728741,1.4188813,-0.52229279,-0.62382556,-0.51728741,1.4214588,-0.52229279,-0.62291949,-0.51728741,1.4122837,-0.52229279,-0.62382556,-0.51728741,1.4225056,-0.52229279,-0.62291949,-0.51728741,1.4150019,-0.52229279,-0.62382556,-0.51728741,1.4162159,-0.52229279,-0.62474043,-0.51728741,1.4260947,-0.52229279,-0.62382556,-0.51728741,1.4214676,-0.52229279,-0.62382556,-0.51728741,1.4181424,-0.52229279,-0.62291949,-0.51728741,1.4131458,-0.52229279,-0.62382556,-0.51728741,1.4185031,-0.52229279,-0.62382556,-0.51728741,1.419849,-0.52229279,-0.62382556,-0.51728741,1.4240802,-0.52229279,-0.62474043,-0.51728741,1.4256725,-0.52229279,-0.62474043,-0.51728741,1.4255845,-0.52229279,-0.62382556,-0.51728741,1.4166118,-0.52229279,-0.62474043,-0.51728741,1.4242826,-0.52229279,-0.62474043,-0.51728741,1.4233677,-0.52229279,-0.62382556,-0.51728741,1.4229455,-0.52229279,-0.62382556,-0.51728741,1.423183,-0.52229279,-0.63384512,3.8101178,1.3925349,-0.49331611,-0.62382556,-0.51728741,1.4226728,-0.52229279,-0.62382556,-0.51728741,1.4216083,-0.52229279,-0.62474043,-0.51728741,1.4267193,-0.522284,-0.62382556,-0.51728741,1.4233677,-0.52229279,-0.62382556,-0.51728741,1.42028,-0.52229279,-0.62474043,-0.51728741,1.4250215,-0.522284,-0.62474043,-0.51728741,1.4261035,-0.522284,-0.62382556,-0.51728741,1.4222065,-0.52229279,-0.62382556,-0.51728741,1.420236,-0.52229279,-0.62382556,-0.51728741,1.4222065,-0.52229279,-0.62382556,-0.51728741,1.4203768,-0.52229279,-0.63293025,3.8192225,1.3904764,-0.49328092,-0.62474043,-0.51728741,1.4245113,-0.52229279,-0.62474043,-0.51728741,1.4272471,-0.522284,-0.62382556,-0.51728741,1.4217227,-0.52229279,-0.62382556,-0.51728741,1.4233237,-0.52229279,-0.62474043,-0.51728741,1.4264202,-0.52229279,-0.62474043,-0.51728741,1.4250831,-0.52229279,-0.62474043,-0.51728741,1.4245289,-0.52229279,-0.62382556,-0.51728741,1.4221186,-0.52229279,-0.62474043,-0.51728741,1.4244937,-0.52229279,-0.62382556,-0.51728741,1.4231478,-0.52229279,-0.62382556,-0.51728741,1.4156529,-0.52229279,-0.62382556,-0.51728741,1.4181072,-0.52229279,-0.62382556,-0.51728741,1.4220746,-0.52229279,-0.62382556,-0.51728741,1.4205175,-0.52229279,-0.62382556,-0.51728741,1.4210629,-0.52229279,-0.62474043,-0.51728741,1.4267281,-0.522284,-0.62474043,-0.51728741,1.425778,-0.522284,-0.62474043,-0.51728741,1.4274758,-0.522284,-0.62474043,-0.51728741,1.4245465,-0.52229279,-0.62382556,-0.51728741,1.4226991,-0.52229279,-0.62474043,-0.51728741,1.4297982,-0.522284,-0.62474043,-0.51728741,1.4297806,-0.522284,-0.62474043,-0.51728741,1.4300357,-0.522284,-0.62474043,-0.51728741,1.4297982,-0.522284,-0.62474043,-0.51728741,1.4290856,-0.522284,-0.62474043,-0.51728741,1.4314784,-0.522284,-0.62474043,-0.51728741,1.430238,-0.522284,-0.62474043,-0.51728741,1.4300269,-0.522284,-0.62474043,-0.51728741,1.426429,-0.522284,-0.62474043,-0.51728741,1.4270712,-0.522284,-0.62474043,-0.51728741,1.4283555,-0.522284,-0.62474043,-0.51728741,1.4294991,-0.522284,-0.62474043,-0.51728741,1.4255669,-0.522284,-0.62474043,-0.51728741,1.426385,-0.522284,-0.62474043,-0.51728741,1.4272647,-0.522284,-0.62474043,-0.51728741,1.4252678,-0.52229279,-0.62474043,-0.51728741,1.4254526,-0.522284,-0.62382556,-0.51728741,1.4246257,-0.522284,-0.62474043,-0.51728741,1.4264818,-0.52229279,-0.62291949,-0.51728741,1.4151867,-0.52229279,-0.62474043,-0.51728741,1.4246784,-0.52229279,-0.62382556,-0.51728741,1.4210717,-0.52229279,-0.62474043,-0.51728741,1.4253558,-0.522284,-0.62474043,-0.51728741,1.4274054,-0.522284,-0.62382556,-0.51728741,1.4193036,-0.52229279,-0.62474043,-0.51728741,1.4281004,-0.522284,-0.62474043,-0.51728741,1.4272647,-0.52229279,-0.62474043,-0.51728741,1.4256021,-0.52229279,-0.62382556,-0.51728741,1.4205703,-0.52229279,-0.6256465,-0.51728741,1.4342142,-0.522284,-0.6256465,-0.51728741,1.4339503,-0.522284,-0.6256465,-0.51728741,1.4333345,-0.522284,-0.62474043,-0.51728741,1.4244585,-0.52229279,-0.62474043,-0.51728741,1.430845,-0.522284,-0.62474043,-0.51728741,1.4322437,-0.522284,-0.62382556,-0.51728741,1.4242914,-0.52229279,-0.6256465,-0.51728741,1.4352346,-0.522284,-0.62474043,-0.51728741,1.4318478,-0.522284,-0.6256465,-0.51728741,1.4336864,-0.522284,-0.62474043,-0.51728741,1.4289625,-0.522284,-0.6256465,-0.51728741,1.4364222,-0.522284,-0.6256465,-0.51728741,1.4339415,-0.522284,-0.6256465,-0.51728741,1.4360439,-0.522284,-0.62474043,-0.51728741,1.4253646,-0.52229279,-0.62474043,-0.51728741,1.4294111,-0.52229279,-0.64112888,2.0043001,1.41158,-0.50026559,-0.62474043,-0.51728741,1.4330442,-0.522284,-0.62474043,-0.51728741,1.4310913,-0.522284,-0.62474043,-0.51728741,1.4250039,-0.522284,-0.62474043,-0.51728741,1.4273703,-0.522284,-0.62474043,-0.51728741,1.4269744,-0.52229279,-0.62474043,-0.51728741,1.4296134,-0.522284,-0.62382556,-0.51728741,1.4228487,-0.52229279,-0.62474043,-0.51728741,1.428074,-0.522284,-0.62474043,-0.51728741,1.4284523,-0.522284,-0.62474043,-0.51728741,1.4272471,-0.522284,-0.62382556,-0.51728741,1.4232358,-0.52229279,-0.62474043,-0.51728741,1.4243442,-0.52229279,-0.62382556,-0.51728741,1.4170164,-0.52229279,-0.62382556,-0.51728741,1.4229894,-0.52229279,-0.62382556,-0.51728741,1.4196027,-0.52229279,-0.62474043,-0.51728741,1.4247312,-0.52229279,-0.62474043,-0.51728741,1.4267985,-0.522284,-0.62382556,-0.51728741,1.4177377,-0.52229279,-0.62382556,-0.51728741,1.4162775,-0.52229279,-0.62382556,-0.51728741,1.4224616,-0.52229279,-0.62382556,-0.51728741,1.4206935,-0.52229279,-0.62382556,-0.51728741,1.4228487,-0.52229279,-0.62291949,-0.51728741,1.4140431,-0.52229279,-0.62291949,-0.51728741,1.415257,-0.52229279,-0.62382556,-0.51728741,1.4168229,-0.52229279,-0.62382556,-0.51728741,1.42028,-0.52229279,-0.62382556,-0.51728741,1.4207551,-0.52229279,-0.62474043,-0.51728741,1.4257604,-0.52229279,-0.62382556,-0.51728741,1.4228399,-0.522284,-0.62474043,-0.51728741,1.4262619,-0.52229279,-0.62382556,-0.51728741,1.4233149,-0.52229279,-0.62474043,-0.51728741,1.4246608,-0.522284,-0.62474043,-0.51728741,1.4297806,-0.522284,-0.62382556,-0.51728741,1.4236668,-0.52229279,-0.62474043,-0.51728741,1.4250391,-0.522284,-0.63840187,0.30502945,1.4168317,-0.50988929,-0.62382556,-0.51728741,1.4217227,-0.52229279,-0.62382556,-0.51728741,1.4216699,-0.52229279,-0.62382556,-0.51728741,1.4212389,-0.52229279,-0.62382556,-0.51728741,1.4182656,-0.52229279,-0.62382556,-0.51728741,1.4211949,-0.52229279,-0.62382556,-0.51728741,1.4223473,-0.52229279,-0.62382556,-0.51728741,1.4190573,-0.52229279,-0.62382556,-0.51728741,1.4173683,-0.52229279,-0.62382556,-0.51728741,1.4167085,-0.52229279,-0.62382556,-0.51728741,1.4195323,-0.52229279,-0.62382556,-0.51728741,1.4188374,-0.52229279,-0.62382556,-0.51728741,1.4202712,-0.52229279,-0.62382556,-0.51728741,1.4213444,-0.52229279,-0.62382556,-0.51728741,1.420843,-0.52229279,-0.62382556,-0.51728741,1.4213181,-0.52229279,-0.62382556,-0.51728741,1.4203328,-0.52229279,-0.62382556,-0.51728741,1.4218019,-0.52229279,-0.62291949,-0.51728741,1.4121342,-0.52229279,-0.62474043,-0.51728741,1.4230246,-0.52229279,-0.62291949,-0.51728741,1.4116064,-0.52229279,-0.62382556,-0.51728741,1.4201833,-0.52229279,-0.62382556,-0.51728741,1.42028,-0.52229279,-0.62382556,-0.51728741,1.4146061,-0.52229279,-0.62382556,-0.51728741,1.4170604,-0.52229279,-0.62382556,-0.51728741,1.4198402,-0.52229279,-0.62382556,-0.51728741,1.4151603,-0.52229279,-0.62382556,-0.51728741,1.4162423,-0.52229279,-0.62382556,-0.51728741,1.4176058,-0.52229279,-0.62382556,-0.51728741,1.4189253,-0.52229279,-0.62382556,-0.51728741,1.4199106,-0.52229279,-0.62474043,-0.51728741,1.4267809,-0.522284,-0.62382556,-0.51728741,1.4215292,-0.52229279,-0.62382556,-0.51728741,1.4218459,-0.52229279,-0.62382556,-0.51728741,1.4200777,-0.52229279,-0.62474043,-0.51728741,1.4250567,-0.522284,-0.62474043,-0.51728741,1.4275726,-0.522284,-0.62474043,-0.51728741,1.431839,-0.522284,-0.62474043,-0.51728741,1.4326483,-0.522284,-0.62474043,-0.51728741,1.430933,-0.522284,-0.62474043,-0.51728741,1.4296926,-0.522284,-0.62474043,-0.51728741,1.4282675,-0.522284,-0.62474043,-0.51728741,1.4264114,-0.522284,-0.62382556,-0.51728741,1.4203504,-0.52229279,-0.62474043,-0.51728741,1.4238075,-0.52229279,-0.62382556,-0.51728741,1.4209486,-0.52229279,-0.62382556,-0.51728741,1.4216259,-0.52229279,-0.62382556,-0.51728741,1.4212653,-0.522284,-0.62382556,-0.51728741,1.4191276,-0.52229279,-0.62382556,-0.51728741,1.4226464,-0.52229279,-0.62382556,-0.51728741,1.4240451,-0.52229279,-0.62382556,-0.51728741,1.4240451,-0.52229279,-0.62382556,-0.51728741,1.4240451,-0.52229279,-0.62382556,-0.51728741,1.4240451,-0.52229279,-0.62382556,-0.51728741,1.4240451,-0.52229279,-0.62382556,-0.51728741,1.4240451,-0.52229279:3
-0.49482906,-0.49482906,1.0624658,-0.49482906,-0.49482906,-0.49482906,1.0696921,-0.49482906,-0.49482906,-0.49482906,1.0689943,-0.49482906,-0.49482906,-0.49482906,1.0613259,-0.49482906,-0.49482906,-0.49482906,1.0666593,-0.49482906,-0.49482906,-0.49482906,1.0692707,-0.49482906,-0.49482906,-0.49482906,1.060262,-0.49482906,-0.49482906,-0.49482906,1.0639995,-0.49482906,-0.49482906,-0.49482906,1.0648769,-0.49482906,-0.49482906,-0.49482906,1.0685867,-0.49482906,-0.49482906,-0.49482906,1.0621549,-0.49482906,-0.49482906,-0.49482906,1.0685107,-0.49482906,-0.49482906,-0.49482906,1.0735746,-0.49482906,-0.49482906,-0.49482906,1.0637508,-0.49482906,-0.49482906,-0.49482906,1.0646074,-0.49482906,-0.49482906,-0.49482906,1.0673294,-0.49482906,-0.49482906,-0.49482906,1.0667836,-0.49482906,-0.49482906,-0.49482906,1.0630807,-0.49482906,-0.49482906,-0.49482906,1.0635159,-0.49482906,-0.49482906,-0.49482906,1.0699891,-0.49482906,-0.49482906,-0.49482906,1.0645245,-0.49482906,-0.49482906,-0.49482906,1.0661757,-0.49482906,-0.49482906,-0.49482906,1.0723035,-0.49482906,-0.49482906,-0.49482906,1.0670185,-0.49482906,-0.49482906,-0.49482906,1.0618302,-0.49482906,-0.49482906,-0.49482906,1.0716817,-0.49482906,-0.49482906,-0.49482906,1.0713363,-0.49482906,-0.49482906,-0.49482906,1.0640755,-0.49482906,-0.49482906,-0.49482906,1.0659477,-0.49482906,-0.49482906,-0.49482906,1.0711014,-0.49482906,-0.49482906,-0.49482906,1.0749771,-0.49482906,-0.49482906,-0.49482906,1.0645245,-0.49482906,-0.49482906,-0.49482906,1.0714054,-0.49482906,-0.49482906,-0.49482906,1.0717992,-0.49482906,-0.49482906,-0.49482906,1.0655332,-0.49482906,-0.49482906,-0.49482906,1.0666316,-0.49482906,-0.49482906,-0.49482906,1.0713501,-0.49482906,-0.49482906,-0.49482906,1.0750876,-0.49482906,-0.49482906,-0.49482906,1.0720133,-0.49482906,-0.49482906,-0.49482906,1.0736714,-0.49482906,-0.49482906,-0.49482906,1.0767871,-0.49482906,-0.49482906,-0.49482906,1.0707422,-0.49482906,-0.49482906,-0.49482906,1.0748044,-0.49482906,-0.49482906,-0.49482906,1.0749632,-0.49482906,-0.49482906,-0.49482906,1.0748665,-0.49482906,-0.49482906,-0.49482906,1.0739062,-0.49482906,-0.49482906,-0.49482906,1.0787698,-0.49482906,-0.49482906,-0.49482906,1.0755228,-0.49482906,-0.49482906,-0.49482906,1.0724002,-0.49482906,-0.49482906,-0.49482906,1.0724762,-0.49482906,-0.53344744,7.2153965,1.0590738,-0.4605423,-0.53415902,7.1653376,1.0591428,-0.46076337,-0.53415902,7.0995413,1.0542516,-0.4609568,-0.53415902,7.1631891,1.0627767,-0.46085318,-0.53344744,6.9743874,1.0449114,-0.46130914,-0.52629026,-0.48481868,1.0553915,-0.4946978,-0.52128853,5.908071,1.0408768,-0.46365111,-0.52629026,-0.48410711,1.0549356,-0.49469089,-0.52629026,-0.48410711,1.0552879,-0.49469089,-0.54059772,2.0597458,1.0425763,-0.47513991,-0.52700874,-0.481247,1.0512326,-0.49468398,-0.2273605,7.243286,1.0371601,-0.45989981,-0.55775837,-0.028541465,1.0500098,-0.49089814,-0.52700874,-0.48195857,1.0519718,-0.49468398,-0.52700874,-0.481247,1.0526972,-0.49468398,-0.52700874,-0.48195857,1.0510116,-0.49468398,-0.52772032,-0.481247,1.0668112,-0.49468398,-0.52700874,-0.48195857,1.0671774,-0.49468398,0.068004489,0.02080578,1.0760133,-0.49109849,-0.43547144,5.3509507,1.0667491,-0.46470811,-0.21305305,7.4235074,1.0588043,-0.45958202,-0.32962667,7.3598596,1.0636195,-0.4599758,-0.52414864,-0.18659358,1.0781273,-0.49112612,-0.53415902,7.1131303,1.0535401,-0.4608739,-0.52772032,-0.481247,1.0777474,-0.49468398,-0.52772032,-0.48195857,1.0753225,-0.49468398,-0.54345783,3.7675695,1.0668458,-0.46939205,-0.52772032,-0.481247,1.0691049,-0.49468398,-0.52700874,-0.481247,1.0579269,-0.49468398,-0.52700874,-0.48195857,1.0605936,-0.49468398,-0.52700874,-0.48195857,1.0543553,-0.49468398,-0.52700874,-0.48195857,1.0525867,-0.49468398,-0.52772032,-0.481247,1.0667283,-0.49468398,-0.52700874,-0.48195857,1.058452,-0.49468398,-0.52700874,-0.48195857,1.0655401,-0.49468398,-0.53987924,3.8097664,1.0576921,-0.46924007,-0.52700874,-0.481247,1.0565867,-0.49468398,-0.52700874,-0.48195857,1.0548389,-0.49468398,-0.52700874,-0.48195857,1.0543276,-0.49468398,-0.52700874,-0.48195857,1.0603449,-0.49468398,-0.52772032,-0.481247,1.0630668,-0.49468398,-0.52700874,-0.48195857,1.0579822,-0.49468398,-0.52700874,-0.481247,1.0476817,-0.49468398,-0.52629026,-0.48195857,1.0477162,-0.49468398,-0.51913999,-0.22378191,1.0398406,-0.48856307,-0.52629026,-0.48195857,1.0425832,-0.49468398,-0.52629026,-0.481247,1.0455124,-0.49468398,-0.52700874,-0.48195857,1.0459131,-0.49468398,-0.52700874,-0.48195857,1.0478198,-0.49468398,-0.52629026,-0.48195857,1.0442896,-0.49468398,-0.52700874,-0.481247,1.0463414,-0.49468398,-0.52629026,-0.48195857,1.0438337,-0.49468398,-0.52629026,-0.48195857,1.0386592,-0.49468398,-0.52700874,-0.48195857,1.0611118,-0.49468398,-0.52700874,-0.481247,1.0581895,-0.49468398,-0.52700874,-0.48195857,1.0586109,-0.49468398,-0.52772032,-0.481247,1.0619062,-0.49468398,-0.52700874,-0.48195857,1.0564416,-0.49468398,-0.52700874,-0.481247,1.0593501,-0.49468398,-0.52700874,-0.48195857,1.0532775,-0.49468398,-0.52700874,-0.481247,1.0566765,-0.49468398,-0.52700874,-0.48195857,1.0587698,-0.49468398,-0.52700874,-0.481247,1.0527318,-0.49468398,-0.52772032,-0.48195857,1.0662517,-0.49468398,-0.52772032,-0.481247,1.0690703,-0.49468398,-0.52057004,-0.25668007,1.0638337,-0.48897067,-0.52700874,-0.481247,1.0614434,-0.49468398,-0.52700874,-0.48195857,1.0652776,-0.49468398,-0.52772032,-0.481247,1.0661895,-0.49468398,-0.52700874,-0.48195857,1.0534226,-0.49468398,-0.52700874,-0.481247,1.0558544,-0.49468398,-0.52700874,-0.48195857,1.0582378,-0.49468398,-0.52772032,-0.481247,1.0587629,-0.49468398,-0.52700874,-0.48195857,1.0478268,-0.49468398,-0.52700874,-0.481247,1.0565591,-0.49468398,-0.52700874,-0.48195857,1.0567041,-0.49468398,-0.52700874,-0.481247,1.0543207,-0.49468398,-0.52700874,-0.48195857,1.0590254,-0.49468398,-0.52700874,-0.481247,1.0569114,-0.49468398,-0.52772032,-0.48195857,1.0616782,-0.49468398,-0.52700874,-0.481247,1.0540651,-0.49468398,-0.52700874,-0.48195857,1.0612637,-0.49468398,-0.52700874,-0.481247,1.0619339,-0.49468398,-0.5220001,-0.31818624,1.0550392,-0.48983423,-0.52700874,-0.481247,1.0564762,-0.49468398,-0.52700874,-0.48195857,1.0587421,-0.49468398,-0.52700874,-0.481247,1.0590185,-0.49468398,-0.52700874,-0.48195857,1.0536851,-0.49468398,-0.52700874,-0.481247,1.0568216,-0.49468398,-0.52700874,-0.48195857,1.0591152,-0.49468398,-0.52700874,-0.481247,1.0533812,-0.49468398,-0.52700874,-0.48195857,1.0518889,-0.49468398,-0.52772032,-0.481247,1.06049,-0.49468398,-0.52700874,-0.48195857,1.0606212,-0.49468398,-0.52700874,-0.481247,1.0539408,-0.49468398,-0.43905003,0.17956947,1.0563794,-0.49132647,-0.3003071,0.047976816,1.0560547,-0.49087741,-0.22378191,7.2275554,1.0371739,-0.45996889,-0.22378191,7.2318455,1.0395573,-0.46001034,-0.77087795,7.7953976,1.0448768,-0.45735058,-0.52772032,-0.481247,1.0653259,-0.49468398,-0.52700874,-0.48195857,1.0573466,-0.49468398,-0.51699836,1.0957025,1.0560617,-0.4793748,-0.54345783,3.909891,1.0507145,-0.46896373,-0.52700874,-0.481247,1.0531601,-0.49468398,-0.52700874,-0.48195857,1.054148,-0.49468398,-0.52700874,-0.481247,1.0582447,-0.49468398,-0.52700874,-0.48195857,1.0633985,-0.49468398,-0.52700874,-0.481247,1.0523449,-0.49468398,-0.52700874,-0.48195857,1.0584174,-0.49468398,-0.52700874,-0.481247,1.059661,-0.49468398,-0.52700874,-0.48195857,1.0496713,-0.49468398,-0.52700874,-0.48195857,1.0470461,-0.49468398,-0.52700874,-0.48195857,1.0650565,-0.49468398,-0.52772032,-0.481247,1.0714814,-0.49468398,-0.52700874,-0.48195857,1.0636264,-0.49468398,-0.52772032,-0.481247,1.0668803,-0.49468398,-0.52700874,-0.48195857,1.0681515,-0.49468398,-0.52700874,-0.481247,1.0615746,-0.49468398,-0.52700874,-0.48195857,1.0569114,-0.49468398,-0.52772032,-0.481247,1.0671774,-0.49468398,-0.54273934,2.9887493,1.0672188,-0.47182384,-0.52700874,-0.481247,1.0616368,-0.49468398,-0.52772032,-0.48195857,1.0697819,-0.49468398,-0.54273934,2.8342758,1.0606351,-0.47233506,-0.52700874,-0.48195857,1.0584174,-0.49468398,-0.52700874,-0.481247,1.0548319,-0.49468398,-0.52700874,-0.48195857,1.0627007,-0.49468398,-0.52772032,-0.481247,1.0745349,-0.49468398,-0.52700874,-0.48195857,1.0619891,-0.49468398,-0.52772032,-0.481247,1.0629701,-0.49468398,-0.52772032,-0.48195857,1.0705073,-0.49468398,-0.52700874,-0.481247,1.0597646,-0.49468398,-0.52700874,-0.48195857,1.0551981,-0.49468398,-0.52772032,-0.481247,1.0700651,-0.49468398,-0.52772032,-0.48195857,1.0720202,-0.49468398,-0.54202777,2.4302059,1.0596402,-0.4737513,-0.52700874,-0.48195857,1.0684071,-0.49468398,-0.52772032,-0.481247,1.0638613,-0.49468398,-0.52700874,-0.48195857,1.0583138,-0.49468398,-0.52700874,-0.48195857,1.0437646,-0.49468398,-0.52700874,-0.48195857,1.0574433,-0.49468398,-0.54202777,2.2385372,1.0566834,-0.47446287,-0.52700874,-0.48195857,1.058832,-0.49468398,-0.52772032,-0.481247,1.0679166,-0.49468398,-0.52700874,-0.48195857,1.0618786,-0.49468398,-0.52700874,-0.481247,1.057091,-0.49468398,-0.52700874,-0.48195857,1.0554883,-0.49468398,-0.52700874,-0.481247,1.0624244,-0.49468398,-0.52772032,-0.48195857,1.0696161,-0.49468398,-0.52700874,-0.481247,1.0573604,-0.49468398,-0.54202777,2.0003882,1.0576161,-0.47536789,-0.52772032,-0.481247,1.0655746,-0.49468398,-0.52700874,-0.48195857,1.0556955,-0.49468398,-0.52700874,-0.481247,1.051654,-0.49468398,-0.52700874,-0.48195857,1.0671014,-0.49468398,-0.52772032,-0.481247,1.0658648,-0.49468398,-0.54202777,1.8194552,1.0530427,-0.47609328,-0.52772032,-0.481247,1.0633639,-0.49468398,-0.52700874,-0.48195857,1.0611394,-0.49468398,-0.52700874,-0.481247,1.0574779,-0.49468398,-0.52700874,-0.48195857,1.0486903,-0.49468398,-0.52772032,-0.481247,1.0620997,-0.49468398,-0.52772032,-0.48195857,1.0697543,-0.49468398,-0.52700874,-0.48195857,1.0529874,-0.49468398,-0.52700874,-0.48195857,1.0633501,-0.49468398,-0.54130929,1.4969122,1.0612637,-0.47745424,-0.52700874,-0.48195857,1.0544382,-0.49468398,-0.52700874,-0.481247,1.0522758,-0.49468398,-0.52700874,-0.48195857,1.0595297,-0.49468398,-0.52772032,-0.481247,1.0681446,-0.49468398,-0.52700874,-0.48195857,1.0540237,-0.49468398,-0.54130929,1.2430257,1.0547214,-0.47860796,-0.52772032,-0.48195857,1.0685729,-0.49468398,-0.52700874,-0.481247,1.0553639,-0.49468398,-0.52700874,-0.48195857,1.0521169,-0.49468398,-0.52772032,-0.481247,1.0640755,-0.49468398,-0.52700874,-0.48195857,1.064262,-0.49468398,-0.52700874,-0.48195857,1.0514606,-0.49468398,-0.52700874,-0.48195857,1.0596264,-0.49468398,-0.52772032,-0.481247,1.0639719,-0.49468398,-0.54059772,0.90761232,1.0548389,-0.48026599,-0.52700874,-0.48195857,1.0467767,-0.49468398,-0.52700874,-0.48195857,1.0594192,-0.49468398,-0.52700874,-0.48195857,1.0644071,-0.49468398,-0.52629026,-0.48195857,1.0439995,-0.49468398,-0.52700874,-0.481247,1.0590599,-0.49468398,-0.52700874,-0.48195857,1.06192,-0.49468398,-0.52700874,-0.48195857,1.0568838,-0.49468398,-0.52700874,-0.48195857,1.0478544,-0.49468398,-0.54059772,0.6480056,1.055205,-0.48169605,-0.52700874,-0.48195857,1.0631636,-0.49468398,-0.52700874,-0.48195857,1.0483103,-0.49468398,-0.52700874,-0.48195857,1.0602482,-0.49468398,-0.52772032,-0.481247,1.0699753,-0.49468398,-0.52700874,-0.48195857,1.0645591,-0.49468398,-0.52700874,-0.481247,1.0560617,-0.49468398,-0.52772032,-0.48195857,1.065851,-0.49468398,-0.52772032,-0.481247,1.0701757,-0.49468398,-0.52700874,-0.48195857,1.0568907,-0.49468398,-0.52700874,-0.48195857,1.0580651,-0.49468398,-0.52772032,-0.48195857,1.0687802,-0.49468398,-0.54059772,0.49281359,1.0632327,-0.48262869,-0.52700874,-0.48195857,1.056566,-0.49468398,-0.52772032,-0.481247,1.0716126,-0.49468398,-0.52772032,-0.48195857,1.0783346,-0.49468398,-0.52700874,-0.48195857,1.0615401,-0.49468398,-0.52772032,-0.48195857,1.0683587,-0.49468398,-0.52772032,-0.481247,1.0766213,-0.49468398,-0.52772032,-0.48195857,1.0728354,-0.49468398,-0.52772032,-0.48195857,1.063281,-0.49468398,-0.53987924,0.46993272,1.0696368,-0.48277377,-0.52772032,-0.481247,1.0792396,-0.49468398,-0.52700874,-0.48195857,1.060262,-0.49468398,-0.52772032,-0.481247,1.0665142,-0.49468398,-0.52772032,-0.48195857,1.0794745,-0.49468398,-0.52772032,-0.481247,1.0710461,-0.49468398,-0.52700874,-0.48195857,1.0620168,-0.49468398,-0.52772032,-0.481247,1.0752672,-0.49468398,-0.52772032,-0.481247,1.0787007,-0.49468398,-0.53987924,0.391259,1.0611601,-0.483285,-0.52772032,-0.48195857,1.0651878,-0.49468398,-0.52772032,-0.481247,1.0793363,-0.49468398,-0.52772032,-0.48195857,1.0734779,-0.49468398,-0.52700874,-0.48195857,1.0613743,-0.49468398,-0.52772032,-0.48195857,1.073471,-0.49468398,-0.53987924,0.39840927,1.0720341,-0.48323664,-0.52700874,-0.48195857,1.0596679,-0.49468398,-0.52772032,-0.481247,1.0684555,-0.49468398,-0.52772032,-0.48195857,1.0756265,-0.49468398,-0.52772032,-0.481247,1.074079,-0.49468398,-0.52700874,-0.48195857,1.0467905,-0.49468398,-0.54059772,0.43631608,1.066376,-0.48298793,-0.52772032,-0.48195857,1.078984,-0.49468398,-0.52700874,-0.48195857,1.0619477,-0.49468398,-0.52700874,-0.48195857,1.0697612,-0.49468398,-0.52772032,-0.481247,1.0797094,-0.49468398,-0.52772032,-0.48195857,1.0719511,-0.49468398,-0.52772032,-0.481247,1.0648769,-0.49468398,-0.52772032,-0.48195857,1.0722413,-0.49468398,-0.52772032,-0.481247,1.0764486,-0.49468398,-0.52700874,-0.48195857,1.0607249,-0.49468398,-0.52772032,-0.48195857,1.0642689,-0.49468398,-0.52772032,-0.48195857,1.0780306,-0.49468398,-0.52700874,-0.481247,1.0613052,-0.49468398,-0.52700874,-0.48195857,1.0498164,-0.49468398,-0.52772032,-0.481247,1.0653881,-0.49468398,-0.52700874,-0.48195857,1.0636333,-0.49468398,-0.52700874,-0.48195857,1.0483656,-0.49468398,-0.52700874,-0.48195857,1.0546109,-0.49468398,-0.54059772,0.6193976,1.0596195,-0.48186185,-0.52700874,-0.48195857,1.0628872,-0.49468398,-0.52700874,-0.48195857,1.0542171,-0.49468398,-0.52700874,-0.48195857,1.0679442,-0.49468398,-0.52772032,-0.481247,1.0676679,-0.49468398,-0.52700874,-0.48195857,1.0508665,-0.49468398,-0.52700874,-0.48195857,1.0568976,-0.49468398,-0.52772032,-0.48195857,1.0682068,-0.49468398,-0.52700874,-0.48195857,1.062148,-0.49468398,-0.53987924,0.66731479,1.055737,-0.48158551,-0.52772032,-0.481247,1.0704935,-0.49468398,-0.52700874,-0.48195857,1.0691878,-0.49468398,-0.52700874,-0.48195857,1.0506316,-0.49468398,-0.52700874,-0.48195857,1.0566074,-0.49468398,-0.52772032,-0.481247,1.0719995,-0.49468398,-0.52772032,-0.48195857,1.0686558,-0.49468398,-0.52700874,-0.481247,1.0557439,-0.49468398,-0.52772032,-0.48195857,1.0740582,-0.49468398,-0.54059772,0.70093144,1.0672603,-0.48139208,-0.52700874,-0.48195857,1.0620928,-0.49468398,-0.52700874,-0.481247,1.0643726,-0.49468398,-0.52772032,-0.48195857,1.0697335,-0.49468398,-0.52700874,-0.481247,1.0632119,-0.49468398,-0.52700874,-0.48195857,1.0545211,-0.49468398,-0.52700874,-0.481247,1.067357,-0.49468398,-0.52772032,-0.48195857,1.0714883,-0.49468398,-0.52700874,-0.48195857,1.0530219,-0.49468398,-0.52700874,-0.48195857,1.0677992,-0.49468398,-0.52772032,-0.481247,1.0818441,-0.49468398,-0.52772032,-0.48195857,1.0684555,-0.49468398,-0.52772032,-0.481247,1.0661342,-0.49468398,-0.52772032,-0.481247,1.0779615,-0.49468398,-0.52772032,-0.481247,1.0785349,-0.49468398,-0.52772032,-0.48195857,1.0681377,-0.49468398,-0.52700874,-0.48195857,1.0555435,-0.49468398,-0.52772032,-0.48195857,1.0690703,-0.49468398,-0.52700874,-0.48195857,1.0557853,-0.49468398,-0.52700874,-0.48195857,1.0520202,-0.49468398,-0.52772032,-0.481247,1.0701688,-0.49468398,-0.53916766,0.17456773,1.0651187,-0.48481868,-0.52700874,-0.48195857,1.0591497,-0.49468398,-0.52772032,-0.48195857,1.0635021,-0.49468398,-0.52772032,-0.48195857,1.0697957,-0.49468398,-0.52700874,-0.48195857,1.061851,-0.49468398,-0.49482906,-0.49482906,1.0570012,-0.49482906,-0.49482906,-0.49482906,1.0619684,-0.49482906,-0.49482906,-0.49482906,1.0650081,-0.49482906,-0.49482906,-0.49482906,1.054756,-0.49482906,-0.49482906,-0.49482906,1.0554606,-0.49482906,-0.49482906,-0.49482906,1.0655746,-0.49482906,-0.49482906,-0.49482906,1.0545072,-0.49482906,-0.49482906,-0.49482906,1.0511981,-0.49482906,-0.49482906,-0.49482906,1.0609459,-0.49482906,-0.49482906,-0.49482906,1.0674261,-0.49482906,-0.49482906,-0.49482906,1.0584796,-0.49482906,-0.49482906,-0.49482906,1.0550185,-0.49482906,-0.49482906,-0.49482906,1.0651048,-0.49482906,-0.49482906,-0.49482906,1.0547214,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906,-0.49482906,-0.49482906,1.0500098,-0.49482906:3
-0.56438473,-0.5163228,1.4181573,-0.5179134,-0.56438473,-0.5163228,1.417435,-0.5179134,-0.56705007,9.0179102,1.3950979,-0.47523371,-0.56705007,9.0009982,1.3937738,-0.4752853,-0.56438473,-0.5163228,1.4167816,-0.5179048,-0.56438473,-0.5163228,1.4147095,-0.5179134,-0.55191786,6.4803689,1.3980555,-0.48139836,-0.56438473,-0.5163228,1.4175554,-0.5179134,-0.56438473,-0.5163228,1.4161196,-0.5179134,-0.56438473,-0.5163228,1.4175898,-0.5179134,-0.56438473,-0.5163228,1.4197221,-0.5179134,-0.56438473,-0.5163228,1.4178735,-0.5179134,-0.56438473,-0.5163228,1.4185184,-0.5179134,-0.56438473,-0.5163228,1.4146493,-0.5179134,-0.56438473,-0.5163228,1.4184754,-0.5179134,-0.56438473,-0.5163228,1.4182862,-0.5179134,-0.56438473,-0.5163228,1.4155951,-0.5179134,-0.56438473,-0.5163228,1.4144602,-0.5179134,-0.56438473,-0.5163228,1.4163947,-0.5179134,-0.56438473,-0.5163228,1.4163947,-0.5179134,-0.56438473,-0.5163228,1.4150277,-0.5179134,-0.56438473,-0.5163228,1.4142796,-0.5179134,-0.56438473,-0.5163228,1.4156725,-0.5179134,-0.56438473,-0.5163228,1.4157327,-0.5179134,-0.56438473,-0.5163228,1.4186216,-0.5179134,-0.56438473,-0.5163228,1.4162829,-0.5179134,-0.56438473,-0.5163228,1.4170395,-0.5179134,-0.54925253,1.2450827,1.4120012,-0.49968597,-0.56438473,-0.5163228,1.4162142,-0.5179134,-0.56438473,-0.5163228,1.4155177,-0.5179134,-0.56438473,-0.5163228,1.4139443,-0.5179134,-0.56438473,-0.5163228,1.4101871,-0.5179134,-0.56438473,-0.5163228,1.4115283,-0.5179134,-0.56438473,-0.5163228,1.4100839,-0.5179134,-0.56438473,-0.5163228,1.4104622,-0.5179134,-0.56438473,-0.5163228,1.4115627,-0.5179134,-0.56438473,-0.5163228,1.4116315,-0.5179134,-0.56438473,-0.5163228,1.4140819,-0.5179134,-0.56438473,-0.5163228,1.4126546,-0.5179134,-0.56438473,-0.5163228,1.4160164,-0.5179134,-0.56438473,-0.5163228,1.4132909,-0.5179134,-0.56438473,-0.5163228,1.4107373,-0.5179134,-0.56438473,-0.5163228,1.4131275,-0.5179134,-0.56438473,-0.5163228,1.4191804,-0.5179134,-0.56438473,-0.5163228,1.4179509,-0.5179134,-0.56438473,-0.5163228,1.4182346,-0.5179134,-0.56438473,-0.5163228,1.4189483,-0.5179134,-0.56438473,-0.5163228,1.4196017,-0.5179134,-0.56438473,-0.5163228,1.4170825,-0.5179134,-0.56438473,-0.5163228,1.4165323,-0.5179134,-0.56438473,-0.5163228,1.4144344,-0.5179134,-0.56527031,-0.5163228,1.4244251,-0.5179134,-0.56527031,-0.5163228,1.4226539,-0.5179134,-0.56527031,-0.5163228,1.4243993,-0.5179134,-0.56438473,-0.5163228,1.4242187,-0.5179134,-0.56527031,-0.5163228,1.4246916,-0.5179134,-0.56527031,-0.5163228,1.4251645,-0.5179134,-0.56527031,-0.5163228,1.4259727,-0.5179134,-0.56527031,-0.5163228,1.4271076,-0.5179134,-0.56527031,-0.5163228,1.4260071,-0.5179134,-0.56527031,-0.5163228,1.4264284,-0.5179134,-0.56527031,-0.5163228,1.4261189,-0.5179134,-0.56527031,-0.5163228,1.4273999,-0.5179134,-0.56527031,-0.5163228,1.4281566,-0.5179048,-0.56527031,-0.5163228,1.4272194,-0.5179048,-0.56527031,-0.5163228,1.4281652,-0.5179134,-0.56527031,-0.5163228,1.4279588,-0.5179134,-0.56527031,-0.5163228,1.4281308,-0.5179134,-0.56527031,-0.5163228,1.4274257,-0.5179134,-0.56527031,-0.5163228,1.4266691,-0.5179134,-0.56527031,-0.5163228,1.4267035,-0.5179134,-0.56527031,-0.5163228,1.4266691,-0.5179048,-0.56171081,-0.43533113,1.4267035,-0.51413035,-0.56527031,-0.5163228,1.4267637,-0.5179134,-0.56527031,-0.5163228,1.4265402,-0.5179048,-0.56527031,-0.5163228,1.4261103,-0.5179048,-0.56527031,-0.5163228,1.4246486,-0.5179134,-0.56527031,-0.5163228,1.4244251,-0.5179048,-0.56527031,-0.5163228,1.4270474,-0.5179048,-0.56527031,-0.5163228,1.4257062,-0.5179048,-0.56527031,-0.5163228,1.4281652,-0.5179134,-0.56527031,-0.5163228,1.4272108,-0.5179134,-0.56527031,-0.5163228,1.4289562,-0.5179134,-0.56527031,-0.5163228,1.4272022,-0.5179134,-0.56527031,-0.5163228,1.4283371,-0.5179048,-0.56527031,-0.5163228,1.4295322,-0.5179048,-0.56527031,-0.5163228,1.4300309,-0.5179134,-0.56438473,-0.50831821,1.4298159,-0.51681287,-0.56527031,-0.5163228,1.4306241,-0.5179048,-0.56527031,-0.5163228,1.4290421,-0.5179048,-0.56527031,-0.5163228,1.4291883,-0.5179048,-0.56527031,-0.5163228,1.4297042,-0.5179048,-0.033915077,-0.006324602,1.4300911,-0.51490415,-0.56527031,-0.5163228,1.4305382,-0.5179048,-0.55459179,8.2435628,1.4095336,-0.47703926,-0.065959234,9.6249264,1.4074186,-0.47274893,-0.56527031,-0.5163228,1.4311228,-0.5179048,-0.56527031,-0.5163228,1.4308391,-0.5179048,-0.55103229,2.4359784,1.4251473,-0.49426073,-0.56527031,-0.5163228,1.4310024,-0.5179048,-0.56527031,-0.5163228,1.4315785,-0.5179048,-0.56527031,-0.5163228,1.4334528,-0.51781882,-0.56527031,-0.5163228,1.4346221,-0.5179048,-0.56527031,-0.5163228,1.433599,-0.5179134,-0.56527031,-0.5163228,1.4351724,-0.5179048,-0.56527031,-0.5163228,1.4346479,-0.5179048,-0.56527031,-0.5163228,1.4342094,-0.5179048,-0.56527031,-0.5163228,1.4346995,-0.5179048,-0.56527031,-0.5163228,1.4356625,-0.5179048,-0.56527031,-0.5163228,1.4357399,-0.5179048,-0.56527031,-0.5163228,1.435267,-0.5179048,-0.56527031,-0.5163228,1.436591,-0.5179048,-0.56527031,-0.5163228,1.4373047,-0.5179048,-0.56527031,-0.5163228,1.4379925,-0.51783602,-0.56616449,-0.5163228,1.4388609,-0.5179048,-0.56527031,-0.5163228,1.4384912,-0.5179048,-0.56616449,-0.5163228,1.4408126,-0.5179048,-0.56527031,-0.5163228,1.4359118,-0.5179048,-0.56527031,-0.5163228,1.4399528,-0.5179048,-0.56527031,-0.5163228,1.4398152,-0.5179048,-0.56616449,-0.5163228,1.4404601,-0.5179048,-0.56527031,-0.5163228,1.4396605,-0.5179048,-0.56527031,-0.5163228,1.437726,-0.5179048,-0.56616449,-0.5163228,1.4406148,-0.5179048,-0.56527031,-0.5163228,1.4387663,-0.5179048,-0.56616449,-0.5163228,1.4388609,-0.5179048,-0.56527031,-0.5163228,1.4379925,-0.5179048,-0.56527031,-0.5163228,1.4370639,-0.5179048,-0.56527031,-0.5163228,1.4373906,-0.51786181,-0.56527031,-0.5163228,1.4345448,-0.5179048,-0.56527031,-0.5163228,1.4334786,-0.5179048,-0.56527031,-0.5163228,1.433556,-0.5179048,-0.56527031,-0.5163228,1.4322233,-0.5179048,-0.56527031,-0.5163228,1.4307961,-0.5179048,-0.56527031,-0.5163228,1.428853,-0.5179048,-0.56527031,-0.5163228,1.4285177,-0.5179134,-0.56527031,-0.5163228,1.4284145,-0.5179048,-0.56527031,-0.5163228,1.4293689,-0.5179134,-0.56527031,-0.5163228,1.433599,-0.5179048,-0.56527031,-0.5163228,1.432894,-0.5179134,-0.56527031,-0.5163228,1.4333239,-0.5179048,-0.56527031,-0.5163228,1.4321374,-0.5179134,-0.56527031,-0.5163228,1.4330229,-0.5179048,-0.56527031,-0.5163228,1.4326016,-0.5179048,-0.56527031,-0.5163228,1.4339257,-0.5179048,-0.56527031,-0.5163228,1.4345276,-0.5179048,-0.56527031,-0.5163228,1.4330573,-0.5179134,-0.56527031,-0.5163228,1.4323953,-0.5179134,-0.56527031,-0.5163228,1.4312174,-0.5179048,-0.56527031,-0.5163228,1.4309423,-0.51780163,-0.56527031,-0.5163228,1.4335216,-0.5179048,-0.56527031,-0.5163228,1.4305296,-0.5179134,-0.56527031,-0.5163228,1.4336334,-0.5179048,-0.56527031,-0.5163228,1.4332465,-0.5179048,-0.56527031,-0.5163228,1.4331175,-0.5179048,-0.56527031,-0.5163228,1.434304,-0.5179048,-0.56527031,-0.5163228,1.433556,-0.5179048,-0.56527031,-0.5163228,1.4348629,-0.5179048,-0.56527031,-0.5163228,1.4355937,-0.5179048,-0.56527031,-0.5163228,1.4349575,-0.5179048,-0.56527031,-0.5163228,1.4356797,-0.5179134,-0.56527031,-0.5163228,1.4359462,-0.5179048,-0.56527031,-0.5163228,1.4363589,-0.5179048,-0.56527031,-0.5163228,1.4367888,-0.5179048,-0.56527031,-0.5163228,1.4345362,-0.5179048,-0.56527031,-0.5163228,1.439007,-0.5179048,-0.56527031,-0.5163228,1.4388523,-0.5179048,-0.56527031,-0.5163228,1.4384826,-0.5179048,-0.56527031,-0.5163228,1.4386975,-0.5179048,-0.56527031,-0.5163228,1.4372015,-0.5179048,-0.56527031,-0.51543722,1.4373305,-0.51765546,-0.56527031,-0.5163228,1.4372531,-0.5179048,-0.56527031,-0.5163228,1.4382074,-0.5179048,-0.56527031,-0.5163228,1.437468,-0.5179048,-0.56527031,-0.5163228,1.4369693,-0.5179048,-0.56527031,-0.5163228,1.4380785,-0.5179048,-0.56527031,-0.5163228,1.4380699,-0.5179048,-0.56616449,-0.5163228,1.4413456,-0.5179048,-0.56616449,-0.5163228,1.4398668,-0.5179048,-0.56616449,-0.5163228,1.4416552,-0.5179048,-0.56616449,-0.5163228,1.4415348,-0.5179048,-0.56616449,-0.5163228,1.442343,-0.5179048,-0.56616449,-0.5163228,1.4419819,-0.5179048,-0.56616449,-0.5163228,1.4411909,-0.5179048,-0.56527031,-0.5163228,1.4371327,-0.5179048,-0.56527031,-0.5163228,1.4377775,-0.5179048,-0.56527031,-0.5163228,1.4390844,-0.5179048,-0.56616449,-0.5163228,1.4390586,-0.5179048,-0.56527031,-0.5163228,1.4401505,-0.5179048,-0.56527031,-0.5163228,1.4401076,-0.5179048,-0.56527031,-0.5163228,1.4393166,-0.5179048,-0.56616449,-0.5163228,1.4401076,-0.5179048,-0.56527031,-0.5163228,1.4397293,-0.5179048,-0.56527031,-0.5163228,1.4370381,-0.5179048,-0.56527031,-0.5163228,1.4399098,-0.5179048,-0.56616449,-0.5163228,1.4411049,-0.5179048,-0.56527031,-0.5163228,1.4387749,-0.5179048,-0.56527031,-0.5163228,1.4388179,-0.51775004,-0.56616449,-0.5163228,1.4414488,-0.5179048,-0.56616449,-0.5163228,1.4415864,-0.5179048,-0.56616449,-0.5163228,1.4433919,-0.5179048,-0.56616449,-0.5163228,1.4427127,-0.5179048,-0.56616449,-0.5163228,1.4432286,-0.5179048,-0.56616449,-0.5163228,1.4452749,-0.5179048,-0.56616449,-0.5163228,1.4437444,-0.5179048,-0.56527031,-0.5163228,1.4414144,-0.5179048,-0.56527031,-0.5163228,1.4420163,-0.5179048,-0.56616449,-0.5163228,1.4423602,-0.5179048,-0.56616449,-0.5163228,1.4421624,-0.5179048,-0.56616449,-0.5163228,1.4429964,-0.5179048,-0.56616449,-0.5163228,1.4409244,-0.5179048,-0.56616449,-0.5163228,1.4417583,-0.5179048,-0.56616449,-0.5163228,1.4428675,-0.5179048,-0.56616449,-0.5163228,1.4431942,-0.5179048,-0.56616449,-0.5163228,1.443005,-0.5179048,-0.56616449,-0.5163228,1.4417669,-0.5179048,-0.56616449,-0.5163228,1.4435467,-0.5179048,-0.56616449,-0.5163228,1.4413714,-0.5179048,-0.56616449,-0.5163228,1.4429448,-0.5179048,-0.56616449,-0.5163228,1.4439938,-0.5179048,-0.56616449,-0.5163228,1.4425665,-0.5179048,-0.56616449,-0.5163228,1.4435295,-0.5179048,-0.56616449,-0.5163228,1.4435811,-0.5179048,-0.56616449,-0.5163228,1.4422742,-0.5179048,-0.56616449,-0.5163228,1.4424376,-0.51785321,-0.56616449,-0.5163228,1.4430566,-0.5179048,-0.56527031,-0.5163228,1.4431426,-0.5179048,-0.56527031,-0.5163228,1.438474,-0.5179048,-0.56527031,-0.5163228,1.4377861,-0.5179048,-0.56527031,-0.5163228,1.4371671,-0.5179048,-0.56527031,-0.5163228,1.4372875,-0.5179048,-0.56527031,-0.5163228,1.4381558,-0.5179048,-0.56527031,-0.5163228,1.4392478,-0.5179048,-0.56527031,-0.5163228,1.4375196,-0.5179048,-0.56616449,-0.5163228,1.4410447,-0.5179048,-0.56527031,-0.5163228,1.4388523,-0.5179048,-0.56527031,-0.5163228,1.4350348,-0.5179048,-0.56527031,-0.5163228,1.4362643,-0.5179048,-0.56527031,-0.5163228,1.4393595,-0.5179048,-0.56616449,-0.5163228,1.4394455,-0.5179048,-0.56527031,-0.5163228,1.4392478,-0.5179048,-0.56616449,-0.5163228,1.4402365,-0.5179048,-0.56616449,-0.5163228,1.4396089,-0.5179048,-0.56616449,-0.5163228,1.4411307,-0.5179048,-0.56616449,-0.5163228,1.440675,-0.5179048,-0.56616449,-0.5163228,1.4409415,-0.5179048,-0.56616449,-0.5163228,1.440847,-0.5179048,-0.56527031,-0.5163228,1.4396605,-0.5179048,-0.56616449,-0.5163228,1.441552,-0.5179048,-0.56527031,-0.5163228,1.4413199,-0.5179048,-0.56616449,-0.5163228,1.439308,-0.5179048,-0.56527031,-0.5163228,1.4402279,-0.5179048,-0.56616449,-0.5163228,1.4414144,-0.5179048,-0.56616449,-0.5163228,1.4402107,-0.5179048,-0.56616449,-0.5163228,1.4407266,-0.5179048,-0.56527031,-0.5163228,1.4398668,-0.5179048,-0.56527031,-0.5163228,1.4399098,-0.5179048,-0.56616449,-0.5163228,1.4409845,-0.5178876,-0.56616449,-0.5163228,1.4421023,-0.5179048,-0.56527031,-0.5163228,1.4387491,-0.5179048,-0.56527031,-0.5163228,1.4407094,-0.5179048,-0.56616449,-0.5163228,1.4414832,-0.5179048,-0.56527031,-0.5163228,1.4413285,-0.5179048,-0.56527031,-0.5163228,1.4404257,-0.5179048,-0.56527031,-0.5163228,1.4393681,-0.5179048,-0.56527031,-0.5163228,1.4385084,-0.5179048,-0.56527031,-0.5163228,1.4395487,-0.5179048,-0.56616449,-0.5163228,1.4400732,-0.5179048,-0.56616449,-0.5163228,1.4382848,-0.5179048,-0.56527031,-0.5163228,1.4379839,-0.5179048,-0.56527031,-0.5163228,1.4356711,-0.5179048,-0.56527031,-0.5163228,1.4371069,-0.5179134,-0.56527031,-0.5163228,1.4369521,-0.5179048,-0.56527031,-0.5163228,1.4363503,-0.5179048,-0.56527031,-0.5163228,1.4364707,-0.5179048,-0.56527031,-0.5163228,1.4355593,-0.5179048,-0.56527031,-0.5163228,1.4379151,-0.5179048,-0.56527031,-0.5163228,1.4328768,-0.5179134,-0.56527031,-0.5163228,1.4346737,-0.5179134,-0.56527031,-0.5163228,1.4341063,-0.5179048,-0.56527031,-0.5163228,1.4323093,-0.5179134,-0.56527031,-0.5163228,1.4358172,-0.5179134,-0.56527031,-0.5163228,1.4385513,-0.5179048,-0.56527031,-0.5163228,1.4387921,-0.5179048,-0.56527031,-0.5163228,1.4378205,-0.5179134,-0.56527031,-0.5163228,1.4358516,-0.5179048,-0.56527031,-0.5163228,1.4376572,-0.5179048,-0.56527031,-0.5163228,1.4367544,-0.5179048,-0.56527031,-0.5163228,1.4390758,-0.5179048,-0.56527031,-0.5163228,1.43764,-0.5179048,-0.56527031,-0.51365747,1.4370639,-0.51729435,-0.56527031,-0.5163228,1.4388609,-0.5179048,-0.56527031,-0.5163228,1.4380699,-0.5179048,-0.56527031,-0.5163228,1.4395487,-0.5179048,-0.56527031,-0.5163228,1.4382074,-0.5179048,-0.56527031,-0.5163228,1.439841,-0.5179048,-0.56616449,-0.5163228,1.4401419,-0.5179048,-0.56527031,-0.5163228,1.4393423,-0.5179048,-0.56527031,-0.5163228,1.4385256,-0.5179048,-0.56527031,-0.5163228,1.436015,-0.5179134,-0.56527031,-0.5163228,1.4369865,-0.5179134,-0.56527031,-0.5163228,1.4342954,-0.5179134,-0.56527031,-0.5163228,1.4355335,-0.5179134,-0.56527031,-0.5163228,1.4382074,-0.5179048,-0.56527031,-0.5163228,1.4340547,-0.5179134,-0.56527031,-0.5163228,1.4372015,-0.5179048,-0.57238933,4.2596925,1.4259469,-0.48777796,-0.56527031,-0.5163228,1.4366856,-0.5179048,-0.56527031,-0.5163228,1.4387921,-0.5179048,-0.56527031,-0.5163228,1.4372187,-0.5179048,-0.56527031,-0.5163228,1.43764,-0.5179048,-0.56527031,-0.5163228,1.438388,-0.5179048,-0.56527031,-0.5163228,1.4392822,-0.5179048,-0.56527031,-0.5163228,1.4375884,-0.5179048,-0.56527031,-0.5163228,1.439179,-0.5179048,-0.56616449,-0.5163228,1.4397808,-0.5179048,-0.56527031,-0.5163228,1.4391446,-0.5179048,-0.56527031,-0.5163228,1.4355421,-0.5179048,-0.56527031,-0.5163228,1.4344244,-0.5179134,-0.56527031,-0.5163228,1.437425,-0.5179048,-0.56527031,-0.5163228,1.4345104,-0.5179048,-0.56527031,-0.5163228,1.4343126,-0.5179134,-0.56527031,-0.5163228,1.4369865,-0.5179048,-0.55369762,-0.15140459,1.4349145,-0.50971965,-0.56527031,-0.5163228,1.4354475,-0.5179048,-0.56527031,-0.5163228,1.4359548,-0.5179048,-0.56527031,-0.5163228,1.4335216,-0.5179048,-0.56527031,-0.5163228,1.4340805,-0.5179048,-0.56527031,-0.5163228,1.4332293,-0.5179048,-0.56527031,-0.5163228,1.4331691,-0.5179134,-0.56527031,-0.5163228,1.4324985,-0.5179134,-0.56527031,-0.5163228,1.4329713,-0.5179134,-0.56527031,-0.5163228,1.4326618,-0.5179134,-0.56527031,-0.5163228,1.4318192,-0.5179134,-0.56527031,-0.5163228,1.4315527,-0.5179134,-0.56527031,-0.5163228,1.4324899,-0.5179048,-0.56527031,-0.5163228,1.4335044,-0.5179048,-0.56527031,-0.5163228,1.4334614,-0.5179134,-0.56527031,-0.5163228,1.4350606,-0.5179134,-0.58396202,3.4613141,1.4274257,-0.4904261,-0.56527031,-0.5163228,1.4370553,-0.5179048,-0.56527031,-0.5163228,1.4364449,-0.5179048,-0.56527031,-0.5163228,1.4356969,-0.5179048,-0.56527031,-0.5163228,1.4356797,-0.5179134,-0.56527031,-0.5163228,1.4363675,-0.5179048,-0.56527031,-0.5163228,1.435224,-0.5179048,-0.56527031,-0.5163228,1.4338913,-0.5179048,-0.56527031,-0.5163228,1.4343298,-0.5179048,-0.56527031,-0.5163228,1.4344416,-0.5179134,-0.56527031,-0.5163228,1.4371241,-0.5179048,-0.56527031,-0.5163228,1.4376572,-0.5179048,-0.56616449,-0.5163228,1.4398754,-0.5179048,-0.56527031,-0.5163228,1.4398324,-0.5179048,-0.56527031,-0.5163228,1.440847,-0.5179048,-0.56616449,-0.5163228,1.4429362,-0.5179048,-0.56616449,-0.5163228,1.4434607,-0.5179048,-0.56616449,-0.5163228,1.4436241,-0.5179048,-0.56616449,-0.5163228,1.4447934,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048,-0.56616449,-0.5163228,1.4458165,-0.5179048:3
-0.76691409,-0.57810341,1.6411681,-0.60109379,-0.76691409,-0.57810341,1.6424569,-0.60109379,-0.76691409,-0.57810341,1.6430716,-0.60109379,-0.76691409,-0.57810341,1.6427246,-0.60109379,-0.76691409,-0.57810341,1.6430815,-0.60109379,-0.76691409,-0.57810341,1.6422289,-0.60109379,-0.76588304,-0.57810341,1.6390168,-0.60110371,-0.76691409,-0.57810341,1.6441125,-0.60109379,-0.76897618,-0.57810341,1.6587951,-0.60109379,-0.76897618,-0.57707236,1.6607779,-0.60109379,-0.76897618,-0.57810341,1.6576153,-0.60109379,-0.77001714,-0.57707236,1.6616007,-0.60108388,-0.77001714,-0.57707236,1.660996,-0.60108388,-0.76897618,-0.57810341,1.6595584,-0.60109379,-0.77001714,-0.57810341,1.6594692,-0.60108388,-0.77001714,-0.57810341,1.662027,-0.60108388,-0.76897618,-0.57707236,1.658686,-0.60109379,-0.77001714,-0.57707236,1.6603119,-0.60108388,-0.77001714,-0.57707236,1.6613826,-0.60108388,-0.77001714,-0.57707236,1.6601632,-0.60108388,-0.76897618,-0.57707236,1.6582399,-0.60108388,-0.77001714,-0.57707236,1.6606391,-0.60108388,-0.76897618,-0.57810341,1.6563959,-0.60109379,-0.76897618,-0.57707236,1.6572386,-0.60108388,-0.76897618,-0.57707236,1.6549286,-0.60108388,-0.76897618,-0.57810341,1.65823,-0.60109379,-0.76897618,-0.57707236,1.6552657,-0.60108388,-0.76897618,-0.57810341,1.6575459,-0.60109379,-0.76897618,-0.57707236,1.6587257,-0.60109379,-0.76897618,-0.57810341,1.658339,-0.60109379,-0.76897618,-0.57810341,1.657417,-0.60109379,-0.76897618,-0.57810341,1.6577442,-0.60109379,-0.76794513,-0.57707236,1.6537786,-0.60109379,-0.76691409,-0.57707236,1.6441026,-0.60109379,-0.76691409,-0.57707236,1.6441125,-0.60109379,-0.76691409,-0.57810341,1.6453716,-0.60109379,-0.76691409,-0.57707236,1.6444298,-0.60109379,-0.76794513,-0.57707236,1.6486432,-0.60109379,-0.76691409,-0.57810341,1.6457483,-0.60109379,-0.76691409,-0.57707236,1.6438548,-0.60109379,-0.76691409,-0.57810341,1.6398198,-0.60109379,-0.76691409,-0.57810341,1.6422388,-0.60109379,-0.76691409,-0.57810341,1.6424768,-0.60109379,-0.76691409,-0.57810341,1.644866,-0.60109379,-0.76691409,-0.57810341,1.6424371,-0.60109379,-0.77104819,-0.57707236,1.6726646,-0.60108388,-0.77104819,-0.57810341,1.6718121,-0.60108388,-0.77207924,-0.57707236,1.6752125,-0.60108388,-0.77104819,-0.57707236,1.6727043,-0.60108388,-0.77001714,-0.57810341,1.6640296,-0.60108388,-0.77001714,-0.57707236,1.6625624,-0.60108388,-0.77001714,-0.57604131,1.6672516,-0.60108388,-0.77104819,-0.57810341,1.6682926,-0.60108388,-0.77104819,-0.57707236,1.6727935,-0.60108388,-0.77104819,-0.57707236,1.6701564,-0.60108388,-0.77207924,-0.57707236,1.6750242,-0.60108388,-0.77104819,-0.57707236,1.6731802,-0.60108388,-0.77207924,-0.57707236,1.6739138,-0.60108388,-0.77104819,-0.57707236,1.6723573,-0.60108388,-0.77104819,-0.57707236,1.672397,-0.60108388,-0.77104819,-0.57707236,1.6715146,-0.60108388,-0.77104819,-0.57707236,1.670434,-0.60108388,-0.77104819,-0.57810341,1.6675193,-0.60108388,-0.77104819,-0.57810341,1.6713064,-0.60108388,-0.77104819,-0.57810341,1.6697995,-0.60108388,-0.77104819,-0.57707236,1.6683719,-0.60108388,-0.77104819,-0.57810341,1.6705629,-0.60108388,-0.77104819,-0.57707236,1.6695715,-0.60108388,-0.77104819,-0.57810341,1.6709198,-0.60108388,-0.77104819,-0.57707236,1.6731009,-0.60108388,-0.77104819,-0.57707236,1.6714651,-0.60108388,-0.77104819,-0.57810341,1.6651202,-0.60108388,-0.77104819,-0.57707236,1.6729422,-0.60108388,-0.77207924,-0.57707236,1.6743897,-0.60108388,-0.77207924,-0.57707236,1.6752522,-0.60108388,-0.77104819,-0.57707236,1.672734,-0.60108388,-0.77104819,-0.57707236,1.673428,-0.60108388,-0.77104819,-0.57707236,1.671703,-0.60108388,-0.77104819,-0.57707236,1.6709198,-0.60108388,-0.77104819,-0.57707236,1.6714651,-0.60108388,-0.77104819,-0.57707236,1.6720103,-0.60108388,-0.77104819,-0.57707236,1.6718616,-0.60108388,-0.77104819,-0.57707236,1.6683422,-0.60108388,-0.77104819,-0.57707236,1.668134,-0.60108388,-0.77104819,-0.57707236,1.6684017,-0.60108388,-0.77104819,-0.57707236,1.6682629,-0.60108388,-0.77001714,-0.57707236,1.6665378,-0.60108388,-0.77104819,-0.57707236,1.6672219,-0.60108388,-0.77104819,-0.57707236,1.6704142,-0.60108388,-0.77104819,-0.57707236,1.6700077,-0.60108388,-0.77104819,-0.57707236,1.6711478,-0.60108388,-0.77104819,-0.57707236,1.6700474,-0.60108388,-0.77207924,-0.57707236,1.6741121,-0.60108388,-0.77104819,-0.57707236,1.6700375,-0.60108388,-0.77104819,-0.57707236,1.6697301,-0.60108388,-0.77001714,-0.57707236,1.6661809,-0.60108388,-0.77104819,-0.57707236,1.6700176,-0.60108388,-0.77001714,-0.57707236,1.6662702,-0.60108388,-0.77104819,-0.57707236,1.6679853,-0.60108388,-0.77104819,-0.57707236,1.667559,-0.60108388,-0.77104819,-0.57707236,1.6701663,-0.60108388,-0.77001714,-0.57707236,1.6660719,-0.60108388,-0.77104819,-0.57707236,1.6681736,-0.60108388,-0.77001714,-0.57707236,1.6663693,-0.60108388,-0.77104819,-0.57707236,1.668828,-0.60108388,-0.77104819,-0.57707236,1.6684413,-0.60108388,-0.77104819,-0.57707236,1.672169,-0.60108388,-0.77104819,-0.57810341,1.6684314,-0.60108388,-0.77001714,-0.57810341,1.6641783,-0.60108388,-0.76897618,-0.57707236,1.6590925,-0.60109379,-0.77001714,-0.57707236,1.661799,-0.60108388,-0.77104819,-0.57707236,1.6709396,-0.60108388,-0.77104819,-0.57707236,1.6712073,-0.60108388,-0.77104819,-0.57707236,1.6682629,-0.60108388,-0.77104819,-0.57707236,1.6706323,-0.60108388,-0.77104819,-0.57707236,1.6710685,-0.60108388,-0.77104819,-0.57707236,1.6728233,-0.60108388,-0.77001714,-0.57707236,1.6673805,-0.60108388,-0.77104819,-0.57707236,1.6709,-0.60108388,-0.77001714,-0.57707236,1.6673706,-0.60108388,-0.77104819,-0.57707236,1.6700672,-0.60108388,-0.77001714,-0.57707236,1.6616503,-0.60108388,-0.76897618,-0.57707236,1.6621162,-0.60109379,-0.77001714,-0.57810341,1.6636232,-0.60108388,-0.77104819,-0.57707236,1.6719508,-0.60108388,-0.77001714,-0.57707236,1.6655564,-0.60108388,-0.77104819,-0.57707236,1.6715245,-0.60108388,-0.77104819,-0.57707236,1.6707017,-0.60108388,-0.77104819,-0.57810341,1.6727142,-0.60108388,-0.77104819,-0.57707236,1.6717526,-0.60108388,-0.77104819,-0.57707236,1.6716733,-0.60108388,-0.77104819,-0.57707236,1.6692245,-0.60108388,-0.77104819,-0.57707236,1.6689668,-0.60108388,-0.77104819,-0.57810341,1.6690659,-0.60108388,-0.77104819,-0.57707236,1.6696012,-0.60108388,-0.77104819,-0.57707236,1.6684909,-0.60108388,-0.77104819,-0.57707236,1.6672715,-0.60108388,-0.77104819,-0.57707236,1.6691155,-0.60108388,-0.77104819,-0.57707236,1.6712668,-0.60108388,-0.77104819,-0.57707236,1.6705926,-0.60108388,-0.77104819,-0.57707236,1.6711875,-0.60108388,-0.77104819,-0.57707236,1.6708008,-0.60108388,-0.77104819,-0.57707236,1.6723771,-0.60108388,-0.77104819,-0.57707236,1.6717228,-0.60108388,-0.77104819,-0.57707236,1.6715741,-0.60108388,-0.77104819,-0.57707236,1.6700077,-0.60108388,-0.77104819,-0.57707236,1.6705728,-0.60108388,-0.77104819,-0.57707236,1.6694327,-0.60108388,-0.77104819,-0.57707236,1.6695715,-0.60108388,-0.77104819,-0.57810341,1.6686396,-0.60108388,-0.77104819,-0.57707236,1.6698094,-0.60108388,-0.76691409,-0.57810341,1.6431707,-0.60109379,-0.76794513,-0.57810341,1.6476122,-0.60109379,-0.76691409,-0.57810341,1.6444496,-0.60109379,-0.77104819,-0.57707236,1.6724069,-0.60108388,-0.77104819,-0.57707236,1.6705133,-0.60108388,-0.76691409,-0.57810341,1.6438548,-0.60109379,-0.77104819,-0.57707236,1.6686594,-0.60108388,-0.77001714,-0.57707236,1.6630779,-0.60108388,-0.77001714,-0.57707236,1.6633753,-0.60108388,-0.77001714,-0.57707236,1.664793,-0.60108388,-0.77001714,-0.57707236,1.6632365,-0.60108388,-0.77104819,-0.57810341,1.6684215,-0.60108388,-0.77001714,-0.57707236,1.6669939,-0.60108388,-0.76897618,-0.57604131,1.6575856,-0.60108388,-0.77001714,-0.57707236,1.6639602,-0.60108388,-0.77104819,-0.57810341,1.6656753,-0.60108388,-0.77001714,-0.57810341,1.6638313,-0.60108388,-0.76897618,-0.57707236,1.6552161,-0.60108388,-0.76794513,-0.57707236,1.6528665,-0.60109379,-0.77001714,-0.57707236,1.6658439,-0.60108388,-0.92788647,0.29070331,1.6607481,-0.59766358,-0.93097961,0.40008364,1.661333,-0.59720754,-0.92478341,0.21538723,1.6589537,-0.59798082,-0.92065922,0.14727858,1.660421,-0.59825841,-0.92375236,0.258721,1.6559894,-0.59778254,-0.92065922,0.1369681,1.6602425,-0.59830798,-0.91344188,0.0637042,1.6570502,-0.59859549,-0.91550398,0.06885944,1.6580416,-0.59857566,-0.92272131,0.23498706,1.6539372,-0.59788168,-0.92582437,0.22054248,1.6565843,-0.59794117,-0.92065922,0.14935059,1.6533821,-0.59823858,-0.93304171,0.44032425,1.6555532,-0.59701917,-0.92375236,0.183395,1.6543536,-0.59808988,-0.92272131,0.14109229,1.6572287,-0.59826833,-0.92375236,0.14418543,1.6571692,-0.59825841,-0.92272131,0.13593705,1.6596576,-0.59830798,-0.92478341,0.2019737,1.6587455,-0.59803039,-0.92685542,0.18856016,1.6597567,-0.59807996,-0.92788647,0.18752911,1.6549187,-0.59807005,-0.92582437,0.18752911,1.6587058,-0.59808988,-0.92582437,0.19887064,1.6584877,-0.59803039,-0.92891752,0.29380637,1.6586959,-0.59765366,-0.92478341,0.16791937,1.6546312,-0.59815927,-0.92375236,0.15966107,1.6608373,-0.59820884,-0.92478341,0.16482622,1.6586563,-0.59818901,-0.92272131,0.15450583,1.6583291,-0.59820884,-0.92169027,0.14315439,1.6583985,-0.59825841,-0.92065922,0.1225136,1.6571394,-0.59834764,-0.92065922,0.11529626,1.6575657,-0.59837738,-0.91962817,0.11632731,1.657883,-0.59837738,-0.92478341,0.16895042,1.6570106,-0.59814936,-0.92065922,0.1225136,1.6564058,-0.59834764,-0.92065922,0.11323416,1.6596179,-0.59839721,-0.92375236,0.15244373,1.6595783,-0.59823858,-0.92478341,0.15966107,1.6589636,-0.59820884,-0.92478341,0.15863002,1.6608373,-0.59820884,-0.92582437,0.16173308,1.6614718,-0.59819893,-0.91962817,0.10806901,1.6584977,-0.59840712,-0.92375236,0.14830963,1.6588347,-0.5982485,-0.92169027,0.14006124,1.656733,-0.59827824,-0.92478341,0.17927081,1.6589438,-0.59812953,-0.92375236,0.183395,1.6560588,-0.59808988,-0.92685542,0.18959121,1.6616602,-0.59807996,-0.92375236,0.15759897,1.6566437,-0.59819893,-0.92169027,0.11117207,1.6635934,-0.59840712,-0.92272131,0.1204515,1.663415,-0.59836747,-0.92375236,0.14935059,1.664218,-0.5982485,-0.92272131,0.14006124,1.661224,-0.59828815,-0.92272131,0.11942045,1.6638016,-0.59836747,-0.92065922,0.12561665,1.6580119,-0.59833772,-0.92272131,0.12355456,1.66399,-0.59835755,-0.92272131,0.1287098,1.6602028,-0.59833772,-0.92272131,0.12355456,1.6638016,-0.59835755,-0.92065922,0.11632731,1.6587058,-0.59838729,-0.92065922,0.11942045,1.6545321,-0.59835755,-0.91756607,0.12458561,1.6493174,-0.59834764,-0.92065922,0.11529626,1.6615511,-0.59838729,-0.91962817,0.1204515,1.658111,-0.59835755,-0.92169027,0.11735836,1.6643766,-0.59837738,-0.91962817,0.12458561,1.6580416,-0.59833772,-0.91962817,0.11014102,1.6613727,-0.59841704,-0.92272131,0.17101251,1.6574468,-0.59814936,-0.92272131,0.1266477,1.6638908,-0.59833772,-0.92169027,0.12458561,1.6589438,-0.59834764,-0.92272131,0.1183894,1.6631572,-0.59837738,-0.91962817,0.11014102,1.6596477,-0.59841704,-0.92169027,0.10600691,1.6643469,-0.59842695,-0.92169027,0.11323416,1.6611248,-0.59839721,-0.92582437,0.16688832,1.6650607,-0.5981791,-0.92375236,0.16585727,1.6601632,-0.5981791,-0.92478341,0.16069212,1.6612339,-0.59819893,-0.92272131,0.16173308,1.6552459,-0.59818901,-0.92169027,0.11942045,1.661799,-0.59836747,-0.91550398,0.11529626,1.6403651,-0.59836747,-0.92065922,0.15450583,1.6435574,-0.59819893,-0.92169027,0.16069212,1.6453022,-0.59816919,-0.92065922,0.16069212,1.6432897,-0.5981791,-0.91756607,0.10394482,1.6430518,-0.59840712,-0.91859712,0.11735836,1.643597,-0.59835755,-0.92065922,0.14727858,1.6436862,-0.59822867,-0.92582437,0.15244373,1.6607184,-0.59822867,-0.92478341,0.15656792,1.6605597,-0.59821876,-0.92582437,0.16998146,1.6606093,-0.59815927,-0.92169027,0.11117207,1.6621063,-0.59840712,-0.91962817,0.14935059,1.6415349,-0.59822867,-0.91962817,0.15038164,1.6411582,-0.59821876,-0.92065922,0.16482622,1.6395323,-0.59815927,-0.92065922,0.16998146,1.6408509,-0.59813945,-0.91962817,0.15863002,1.6396513,-0.59818901,-0.91756607,0.12767875,1.6398991,-0.5983179,-0.91859712,0.12458561,1.6428733,-0.59832781,-0.91859712,0.12148255,1.6415052,-0.59833772,-0.91653502,0.099820624,1.6399983,-0.59842695,-0.92065922,0.14624753,1.6420009,-0.59823858,-0.91962817,0.18236395,1.6355965,-0.59807005,-0.91962817,0.16173308,1.6388284,-0.59816919,-0.91859712,0.15038164,1.63634,-0.59820884,-0.91653502,0.11735836,1.6394827,-0.59835755,-0.91550398,0.10806901,1.6369547,-0.59838729,-0.91859712,0.10806901,1.6468587,-0.59839721,-0.92065922,0.15553688,1.6444694,-0.59819893,-0.92169027,0.16688832,1.6457186,-0.59814936,-0.92272131,0.17101251,1.6460259,-0.59812953,-0.92169027,0.15244373,1.6463928,-0.59820884,-0.91653502,0.06885944,1.6466109,-0.59855583,-0.91241083,0.047197516,1.6452626,-0.59864506,-0.91447293,0.052352757,1.646135,-0.59862523,-0.91447293,0.067828392,1.6451733,-0.59856574,-0.91241083,0.04513542,1.6459565,-0.59865497,-0.91241083,0.046166468,1.6448561,-0.59865497,-0.91241083,0.047197516,1.6481079,-0.59864506,-0.91344188,0.048228564,1.6464126,-0.59864506,-0.92065922,0.14624753,1.6479691,-0.59823858,-0.91344188,0.069890488,1.6374801,-0.59854592,-0.91241083,0.058548959,1.6381642,-0.59858557,-0.91653502,0.089500229,1.6401668,-0.59847652,-0.92065922,0.16069212,1.6455699,-0.5981791,-0.91859712,0.10806901,1.6485738,-0.59839721,-0.91447293,0.0637042,1.646819,-0.59857566,-0.91344188,0.053383805,1.6480385,-0.59862523,-0.91344188,0.055445901,1.6475031,-0.59861531,-0.91241083,0.051321709,1.6459268,-0.59863514,-0.92478341,0.26904139,1.6464225,-0.59772306,-0.91550398,0.077117739,1.6432401,-0.59852609,-0.91756607,0.09465547,1.6479592,-0.59844678,-0.91550398,0.075055642,1.6466208,-0.598536,-0.91653502,0.082272979,1.6475824,-0.59849635,-0.91550398,0.072993546,1.6485342,-0.598536,-0.91756607,0.088469181,1.6495156,-0.59848643,-0.91550398,0.072993546,1.6496049,-0.59855583,-0.91653502,0.07608669,1.6502988,-0.598536,-0.91653502,0.075055642,1.6502096,-0.59854592,-0.91756607,0.081241931,1.6499221,-0.59851617,-0.91756607,0.078148787,1.6508044,-0.59852609,-0.91653502,0.080210883,1.645788,-0.59850626,-0.92065922,0.11220312,1.6486531,-0.59838729,-0.91962817,0.096717566,1.647404,-0.59843686,-0.91859712,0.096717566,1.6473048,-0.59843686,-0.91756607,0.092593374,1.6442811,-0.59845669,-0.91447293,0.04513542,1.646819,-0.59865497,-0.91447293,0.04513542,1.6460259,-0.59865497,-0.91344188,0.04306341,1.6498131,-0.5986748,-0.91550398,0.0637042,1.6488712,-0.59859549,-0.91653502,0.080210883,1.6505764,-0.59852609,-0.91653502,0.077117739,1.651657,-0.598536,-0.91756607,0.093624422,1.6476221,-0.59845669,-0.91241083,0.046166468,1.6486432,-0.59866488,-0.91962817,0.14935059,1.6481574,-0.59822867,-0.91962817,0.10085167,1.6507152,-0.59843686,-0.91859712,0.096717566,1.6478798,-0.59843686,-0.91550398,0.057507997,1.650626,-0.59861531,-0.91550398,0.044094458,1.646819,-0.59865497,-0.91447293,0.044094458,1.6497337,-0.59866488,-0.91136987,0.04513542,1.6487523,-0.59866488,-0.91136987,0.04513542,1.6490695,-0.5986748,-0.91241083,0.051321709,1.6461746,-0.59863514,-0.91241083,0.04513542,1.6462044,-0.59865497,-0.91241083,0.044094458,1.6509135,-0.5986748,-0.91136987,0.042032362,1.6508738,-0.59868471,-0.91344188,0.044094458,1.6521527,-0.5986748,-0.91241083,0.044094458,1.6515381,-0.5986748,-0.91344188,0.047197516,1.6502889,-0.59866488,-0.91136987,0.041001314,1.6501997,-0.59868471,-0.91136987,0.04306341,1.6486333,-0.5986748,-0.91344188,0.042032362,1.648435,-0.5986748,-0.91447293,0.044094458,1.6488415,-0.5986748,-0.91447293,0.041001314,1.6527674,-0.59868471,-0.91344188,0.041001314,1.6505269,-0.59868471,-0.91447293,0.04306341,1.6525493,-0.5986748,-0.91344188,0.04513542,1.6525196,-0.59866488,-0.91653502,0.041001314,1.6525196,-0.59868471,-0.91136987,0.042032362,1.6520635,-0.59868471,-0.91136987,0.042032362,1.6445686,-0.59866488,-0.91241083,0.044094458,1.6411285,-0.59866488,-0.91550398,0.04513542,1.655008,-0.59866488,-0.91447293,0.05029066,1.6545321,-0.59864506,-0.91653502,0.07608669,1.655345,-0.598536,-0.92375236,0.075055642,1.654998,-0.59854592,-0.91756607,0.091562326,1.6554739,-0.59847652,-0.91756607,0.057507997,1.6559101,-0.59861531,-0.92272131,0.083304027,1.6554937,-0.59849635,-0.92065922,0.10188272,1.6561877,-0.59839721,-0.92169027,0.10291377,1.6548692,-0.59836747,-0.91859712,0.0637042,1.6557713,-0.59855583,-0.92582437,0.14727858,1.6534217,-0.59784203,-0.91962817,0.11220312,1.6531045,-0.59844678,-0.92272131,0.15553688,1.6536993,-0.59826833,-0.91962817,0.091562326,1.6547799,-0.59847652,-0.91962817,0.091562326,1.6547799,-0.59847652,-0.91962817,0.091562326,1.6547799,-0.59847652,-0.91962817,0.091562326,1.6547799,-0.59847652,-0.91962817,0.091562326,1.6547799,-0.59847652,-0.91962817,0.091562326,1.6547799,-0.59847652,-0.91962817,0.091562326,1.6547799,-0.59847652:4
-1.0053098,-0.79895241,1.5914932,-0.89065583,-1.0053098,-0.7795732,1.5956232,-0.89060105,-0.84912582,0.17818036,1.588634,-0.88656965,-0.82289981,0.24203644,1.5911207,-0.88628483,-0.86280849,0.15766184,1.589127,-0.88666825,-0.83087497,0.25344049,1.5917123,-0.88624101,-0.80123103,0.32641104,1.5958533,-0.88593427,-0.80123103,0.34351163,1.5867388,-0.88582472,-0.80237033,0.3400937,1.5900143,-0.88584663,-0.83087497,0.24773299,1.5905292,-0.88626292,-0.85937961,0.16792658,1.5918985,-0.88661347,-0.87306227,0.13029652,1.5921176,-0.88678875,-0.87306227,0.1280179,1.5896966,-0.88679971,-0.85710099,0.17248382,1.5840329,-0.88658061,-0.88104839,0.13599306,1.5890174,-0.88676684,-0.86964434,0.16563701,1.5883492,-0.88663538,-0.87534089,0.12573928,1.5878781,-0.88681066,-0.8764802,0.12687859,1.5921834,-0.88679971,-0.87763046,0.12687859,1.5907592,-0.88679971,-0.87990908,0.12687859,1.593739,-0.88679971,-0.88560562,0.12573928,1.5906825,-0.88681066,-0.8764802,0.12573928,1.5560651,-0.88674493,-0.86850503,0.12459997,1.5565033,-0.88675589,-0.86850503,0.12344971,1.5424701,-0.88673398,-0.84683625,0.18958441,1.5481776,-0.8864382,-0.85254375,0.16678727,1.5430616,-0.88653679,-0.86736572,0.12573928,1.5525266,-0.88674493,-0.86051891,0.15652253,1.5535455,-0.88660252,-0.87534089,0.12459997,1.5541918,-0.88675589,-0.86850503,0.12459997,1.5569415,-0.88675589,-0.86736572,0.12344971,1.5539289,-0.88675589,-0.86850503,0.1223104,1.5617726,-0.88676684,-0.86622641,0.12344971,1.5605128,-0.88675589,-0.86508711,0.12459997,1.5518803,-0.88675589,-0.86736572,0.12344971,1.5578726,-0.88675589,-0.87192296,0.12459997,1.5545204,-0.88675589,-0.87306227,0.12459997,1.5614001,-0.88675589,-0.86622641,0.12459997,1.5597131,-0.88675589,-0.86736572,0.12459997,1.5601074,-0.88675589,-0.86964434,0.12344971,1.5655849,-0.8867778,-0.86736572,0.12117109,1.5635692,-0.8867778,-0.86622641,0.12344971,1.5608852,-0.88675589,-0.8764802,0.1223104,1.5530415,-0.88676684,-0.86964434,0.12344971,1.553907,-0.88675589,-0.86736572,0.1223104,1.5535564,-0.88676684,-0.86964434,0.1223104,1.551705,-0.88676684,-0.87306227,0.12117109,1.5488129,-0.88674493,-0.86736572,0.1223104,1.5521213,-0.88676684,-0.86736572,0.12344971,1.5582013,-0.88675589,-0.88332701,0.1223104,1.5523514,-0.88676684,-0.87763046,0.1223104,1.5560432,-0.88676684,-0.86622641,0.1223104,1.5569415,-0.88676684,-0.8639478,0.13143583,1.557303,-0.88672302,-0.8764802,0.1223104,1.5565252,-0.88676684,-0.87420158,0.12117109,1.5566347,-0.88676684,-0.86508711,0.1223104,1.5581794,-0.88675589,-0.86508711,0.1223104,1.5575988,-0.88675589,-0.87420158,0.12003178,1.5494264,-0.88675589,-0.87420158,0.1223104,1.5548272,-0.88676684,-0.86736572,0.1223104,1.5577412,-0.88676684,-0.84455763,0.19984914,1.5598226,-0.88640533,-0.82403912,0.23632894,1.5641717,-0.88626292,-0.84569694,0.19529191,1.5643798,-0.88644915,-0.80693853,0.30588157,1.565563,-0.88594522,-0.81491369,0.24089713,1.5636349,-0.88624101,-0.85368306,0.13713237,1.5615863,-0.88669016,-0.86165822,0.14739711,1.5667461,-0.88666825,-0.87078365,0.11433524,1.5702517,-0.88682162,-0.86280849,0.11433524,1.5700216,-0.88682162,-0.8639478,0.11547454,1.5637992,-0.88681066,-0.86280849,0.11433524,1.5656177,-0.88682162,-0.8639478,0.11547454,1.5653001,-0.88681066,-0.8639478,0.11433524,1.5615973,-0.88679971,-0.86051891,0.12117109,1.5607976,-0.88676684,-0.85482237,0.13828264,1.5591653,-0.88669016,-0.86165822,0.11433524,1.5581027,-0.88679971,-0.85254375,0.14739711,1.5627585,-0.88666825,-0.85596168,0.14397918,1.5647961,-0.8866792,-0.86622641,0.11319593,1.5590119,-0.88679971,-0.8764802,0.11547454,1.5631858,-0.88681066,-0.8764802,0.11319593,1.5615973,-0.88679971,-0.86622641,0.11319593,1.5583875,-0.88679971,-0.87078365,0.12687859,1.5630653,-0.88676684,-0.80009172,0.31728561,1.563131,-0.88590141,-0.80807783,0.28308443,1.5664394,-0.88605477,-0.84912582,0.17134451,1.5651357,-0.8865587,-0.85026513,0.17248382,1.5615863,-0.88653679,-0.84797556,0.16335839,1.5595706,-0.88656965,-0.84113971,0.17476243,1.5605675,-0.88652583,-0.83658247,0.206685,1.5657273,-0.88640533,-0.85026513,0.15880115,1.5632734,-0.88661347,-0.84227902,0.17476243,1.5596145,-0.88652583,-0.81719231,0.23518963,1.5630105,-0.88626292,-0.85596168,0.1462578,1.5655192,-0.88666825,-0.84455763,0.17931967,1.5561856,-0.88650392,-0.82745704,0.25115091,1.5570729,-0.88617528,-0.85368306,0.16335839,1.5595378,-0.88658061,-0.83544316,0.22835378,1.5623532,-0.88628483,-0.82631773,0.23405032,1.567732,-0.88627387,-0.83544316,0.18388786,1.5609729,-0.88648201,-0.81947093,0.22835378,1.5584094,-0.88627387,-0.85596168,0.12573928,1.5632515,-0.88676684,-0.85710099,0.12344971,1.5591982,-0.88675589,-0.88332701,0.12459997,1.5612687,-0.88675589,-0.86850503,0.16221908,1.5603923,-0.88658061,-0.79667379,0.29105959,1.5561965,-0.88598904,-0.85254375,0.17590174,1.5531401,-0.88651488,-0.87420158,0.12117109,1.5628133,-0.88678875,-0.86850503,0.11775316,1.561915,-0.8867778,-0.79439517,0.29447752,1.5604799,-0.88597809,-0.81833162,0.22264628,1.5617835,-0.88630674,-0.80350964,0.28308443,1.5641936,-0.88605477,-0.816053,0.18616648,1.5612687,-0.88647106,-0.85710099,0.15424392,1.5590229,-0.88661347,-0.82745704,0.22607516,1.5609729,-0.88628483,-0.8582403,0.14170056,1.5591982,-0.8866792,-0.85368306,0.2500116,1.5629995,-0.88620814,-0.80009172,0.28992028,1.5610934,-0.88598904,-0.85937961,0.20212776,1.5593954,-0.88674493,-0.82403912,0.1644977,1.5600855,-0.88627387,-0.8639478,0.16906589,1.5642265,-0.88679971,-0.8639478,0.11775316,1.5628352,-0.88679971,-0.86508711,0.11889247,1.5616083,-0.8867778,-0.8639478,0.11889247,1.5612577,-0.8867778,-0.80579922,0.28308443,1.5644565,-0.88605477,-0.82973566,0.21353181,1.5658478,-0.88637247,-0.86051891,0.13257514,1.5650919,-0.88673398,-0.84227902,0.18730579,1.5659573,-0.88649297,-0.86850503,0.12344971,1.5653877,-0.8867778,-0.85368306,0.16792658,1.5598007,-0.8865587,-0.86508711,0.14511849,1.5629776,-0.8866792,-0.86736572,0.13143583,1.5617288,-0.88672302,-0.84797556,0.16107977,1.5593296,-0.88658061,-0.84341832,0.18388786,1.559735,-0.88648201,-0.84912582,0.16107977,1.5577521,-0.88658061,-0.80807783,0.27168039,1.5586504,-0.88607668,-0.84797556,0.17134451,1.5509711,-0.88651488,-0.85140444,0.15538323,1.5493059,-0.88659156,-0.83658247,0.20212776,1.5478818,-0.88637247,-0.7978131,0.28992028,1.5492073,-0.88596713,-0.85482237,0.16906589,1.55681,-0.88654774,-0.80693853,0.29105959,1.551716,-0.88598904,-0.86165822,0.13029652,1.5595816,-0.88672302,-0.86508711,0.12344971,1.5569634,-0.88675589,-0.8639478,0.12003178,1.5563499,-0.88676684,-0.86622641,0.12003178,1.5535016,-0.88676684,-0.86051891,0.13371444,1.5508067,-0.88669016,-0.8582403,0.14967573,1.5561418,-0.88663538,-0.86622641,0.12687859,1.5547286,-0.88674493,-0.80009172,0.30360295,1.5542027,-0.88593427,-0.86280849,0.13143583,1.5540713,-0.88672302,-0.86508711,0.14283987,1.5581465,-0.88666825,-0.86508711,0.14056125,1.5563718,-0.8866792,-0.86964434,0.12573928,1.5560432,-0.88674493,-0.86736572,0.12459997,1.5531839,-0.88675589,-0.87306227,0.13599306,1.5532059,-0.88670111,-0.87078365,0.12915721,1.5529648,-0.88673398,-0.86508711,0.12459997,1.5527129,-0.88675589,-0.8639478,0.13599306,1.5557803,-0.88670111,-0.86850503,0.14056125,1.5561199,-0.8866792,-0.84683625,0.20326707,1.5474984,-0.88637247,-0.81035645,0.27281969,1.5476517,-0.88605477,-0.87420158,0.13599306,1.5533702,-0.88670111,-0.85482237,0.18730579,1.5539289,-0.88647106,-0.86165822,0.14511849,1.5528224,-0.88665729,-0.87876977,0.12687859,1.5513764,-0.88672302,-0.87420158,0.12459997,1.5425796,-0.88673398,-0.83772178,0.20554569,1.5487472,-0.88636151,-0.87078365,0.1223104,1.5519241,-0.88676684,-0.87192296,0.11661385,1.5543999,-0.88678875,-0.86622641,0.12573928,1.5585628,-0.88674493,-0.86622641,0.12344971,1.5586723,-0.88675589,-0.86622641,0.1223104,1.5582999,-0.88676684,-0.86165822,0.13599306,1.556087,-0.88670111,-0.86280849,0.11547454,1.5518803,-0.88678875,-0.86508711,0.11775316,1.5579931,-0.8867778,-0.86508711,0.11547454,1.5564047,-0.88678875,-0.86736572,0.11547454,1.5579822,-0.88678875,-0.86736572,0.11547454,1.5550682,-0.88678875,-0.86508711,0.12003178,1.5546629,-0.88676684,-0.86736572,0.11547454,1.5574344,-0.88678875,-0.86850503,0.11433524,1.5581465,-0.88679971,-0.86736572,0.11433524,1.5581465,-0.88679971,-0.86622641,0.11775316,1.5532059,-0.8867778,-0.86850503,0.11547454,1.5484295,-0.88676684,-0.87990908,0.11433524,1.5483528,-0.8867778,-0.87534089,0.11547454,1.5556597,-0.88678875,-0.86736572,0.11889247,1.5563061,-0.8867778,-0.86850503,0.11547454,1.55268,-0.88678875,-0.86964434,0.11433524,1.5513326,-0.8867778,-0.86850503,0.11547454,1.5522637,-0.88678875,-0.81263507,0.273959,1.5548272,-0.88607668,-0.87420158,0.12117109,1.5513545,-0.88674493,-0.86736572,0.11661385,1.5509163,-0.88676684,-0.87420158,0.11889247,1.5507081,-0.88675589,-0.87306227,0.13485375,1.5518474,-0.88670111,-0.82062119,0.28878098,1.5534469,-0.88598904,-0.81377438,0.31158907,1.5538851,-0.88602191,-0.84455763,0.19643122,1.556558,-0.88649297,-0.83886109,0.22150697,1.5581794,-0.88639438,-0.81149576,0.273959,1.5516503,-0.88606573,-0.80807783,0.28764167,1.5558241,-0.88601095,-0.8400004,0.22493585,1.5586395,-0.88629578,-0.80464895,0.30246364,1.5558569,-0.88594522,-0.84683625,0.19072372,1.556317,-0.88644915,-0.84683625,0.18616648,1.5555392,-0.88647106,-0.84227902,0.19414164,1.5513107,-0.88641629,-0.8217605,0.24773299,1.5544438,-0.88618623,-0.84227902,0.19072372,1.5532387,-0.88644915,-0.82973566,0.22264628,1.5537865,-0.88630674,-0.84569694,0.18274855,1.5542685,-0.88648201,-0.84455763,0.18958441,1.5537426,-0.8864601,-0.84912582,0.17248382,1.554378,-0.88653679,-0.84227902,0.19414164,1.5554407,-0.8864382,-0.83772178,0.20212776,1.5564375,-0.88639438,-0.8217605,0.24773299,1.5597459,-0.88618623,-0.82517843,0.273959,1.5533921,-0.88607668,-0.81947093,0.27737693,1.5531073,-0.88605477,-0.82631773,0.23291101,1.5535126,-0.88626292,-0.84341832,0.1884451,1.5532606,-0.8864601,-0.8400004,0.19757052,1.5566676,-0.88641629,-0.84569694,0.18502717,1.5591653,-0.88648201,-0.83544316,0.2123925,1.5533264,-0.88635056,-0.84455763,0.17704105,1.5521761,-0.88651488,-0.83430385,0.21467111,1.5559774,-0.8863396,-0.86165822,0.1702052,1.5548491,-0.88654774,-0.86508711,0.16792658,1.5556817,-0.8865587,-0.87192296,0.13713237,1.5603046,-0.88670111,-0.86964434,0.12117109,1.5601732,-0.88676684,-0.86964434,0.12117109,1.5631858,-0.88678875,-0.86850503,0.12117109,1.5632953,-0.88678875,-0.86508711,0.12573928,1.5622875,-0.88674493,-0.86850503,0.12003178,1.5625394,-0.88676684,-0.86964434,0.11889247,1.5596583,-0.8867778,-0.86850503,0.11889247,1.5588148,-0.8867778,-0.86736572,0.1223104,1.5566676,-0.88676684,-0.86964434,0.11889247,1.5564814,-0.8867778,-0.86736572,0.12003178,1.554148,-0.88676684,-0.86964434,0.11889247,1.5587052,-0.8867778,-0.86850503,0.12003178,1.5575549,-0.88676684,-0.86850503,0.11775316,1.555594,-0.8867778,-0.87192296,0.11661385,1.5559117,-0.88678875,-0.87306227,0.11775316,1.5529539,-0.8867778,-0.87534089,0.12003178,1.5514421,-0.88675589,-0.86850503,0.13828264,1.5559994,-0.88669016,-0.83772178,0.22036766,1.5496455,-0.88629578,-0.84683625,0.20098845,1.5568757,-0.88640533,-0.82745704,0.25344049,1.5584313,-0.88616432,-0.81833162,0.29105959,1.5531182,-0.886,-0.81491369,0.30132433,1.5542575,-0.88594522,-0.81833162,0.28079486,1.5517489,-0.88604382,-0.81377438,0.30246364,1.557062,-0.88594522,-0.86051891,0.15652253,1.5583437,-0.88660252,-0.86051891,0.16107977,1.5574892,-0.88659156,-0.85596168,0.17931967,1.5634049,-0.88652583,-0.84341832,0.21125319,1.5607428,-0.88636151,-0.82631773,0.2500116,1.5629667,-0.88620814,-0.86051891,0.16221908,1.5613344,-0.88658061,-0.84797556,0.19529191,1.5624299,-0.88642724,-0.84569694,0.20782431,1.5604909,-0.88637247,-0.82745704,0.24659368,1.5599541,-0.88619719,-0.84341832,0.20326707,1.5559665,-0.88639438,-0.80579922,0.30018502,1.5537207,-0.88595618,-0.80921714,0.29676709,1.555112,-0.88596713,-0.84683625,0.19757052,1.5570182,-0.88641629,-0.8400004,0.21011388,1.5586395,-0.88636151,-0.82631773,0.17590174,1.5592858,-0.88652583,-0.84455763,0.21353181,1.5566457,-0.88635056,-0.86850503,0.1644977,1.5536002,-0.88656965,-0.86964434,0.15994046,1.5585518,-0.88659156,-0.8582403,0.19529191,1.5540494,-0.88642724,-0.87306227,0.15994046,1.5502042,-0.88656965,-0.87876977,0.16107977,1.5494045,-0.88656965,-0.86051891,0.15766184,1.5530306,-0.88660252,-0.83658247,0.22721447,1.554871,-0.8862191,-0.87192296,0.17818036,1.5518036,-0.88650392,-0.87192296,0.22721447,1.5487253,-0.88660252,-0.85026513,0.15994046,1.5497879,-0.88636151,-0.84341832,0.2317717,1.5515298,-0.88637247,-0.85937961,0.15766184,1.5479585,-0.88658061,-0.84113971,0.21808904,1.5562951,-0.88632865,-0.81035645,0.29676709,1.5570948,-0.88596713,-0.84455763,0.20440638,1.5579493,-0.88639438,-0.85482237,0.18160924,1.555112,-0.88649297,-0.8582403,0.17248382,1.5528991,-0.88653679,-0.85482237,0.1702052,1.5411555,-0.88652583,-0.86508711,0.17590174,1.5482761,-0.88650392,-0.85937961,0.18730579,1.5550463,-0.88647106,-0.8582403,0.17248382,1.5584752,-0.88653679,-0.84341832,0.20440638,1.5545971,-0.88639438,-0.84341832,0.20212776,1.5511135,-0.88637247,-0.8582403,0.16792658,1.5503576,-0.88653679,-0.86850503,0.1644977,1.5523623,-0.88656965,-0.86051891,0.17704105,1.5503028,-0.88649297,-0.80464895,0.31158907,1.5495469,-0.8858795,-0.84113971,0.22036766,1.5516831,-0.88631769,-0.84569694,0.20896361,1.5500399,-0.88635056,-0.84227902,0.21467111,1.5471588,-0.88631769,-0.84912582,0.20212776,1.5494812,-0.88638342,-0.84569694,0.20212776,1.5489882,-0.88638342,-0.84569694,0.20782431,1.5502152,-0.88635056,-0.84341832,0.21467111,1.5530196,-0.8863396,-0.84569694,0.22607516,1.5871879,-0.88636151,-0.85368306,0.20554569,1.5863663,-0.88644915,-0.85937961,0.22379654,1.5896747,-0.88637247,-0.8582403,0.21353181,1.5895323,-0.88641629,-0.85026513,0.20896361,1.5894446,-0.8864382,-0.85140444,0.21467111,1.5877466,-0.88641629,-0.85482237,0.206685,1.5927202,-0.88644915,-0.85254375,0.21467111,1.593246,-0.88641629,-0.84797556,0.22379654,1.5897733,-0.88637247,-0.85482237,0.20212776,1.5802535,-0.88644915,-0.81719231,0.30702087,1.5875494,-0.886,-0.85140444,0.22721447,1.5942319,-0.88635056,-0.83772178,0.25913703,1.5946044,-0.88620814,-0.85937961,0.20326707,1.5953932,-0.8864601,-0.85482237,0.21125319,1.594451,-0.88642724,-0.85596168,0.206685,1.5927421,-0.88644915,-0.81833162,0.30474226,1.591778,-0.88601095,-0.84227902,0.24887229,1.5926106,-0.88626292,-0.8400004,0.25115091,1.591296,-0.88625196,-0.85596168,0.20554569,1.5930817,-0.88644915,-0.85710099,0.20326707,1.5918109,-0.8864601,-0.86051891,0.19414164,1.5880643,-0.88650392,-0.8582403,0.20554569,1.5897623,-0.88644915,-0.85937961,0.206685,1.5920848,-0.88644915,-0.85937961,0.20440638,1.5959519,-0.88648201,-0.85026513,0.23746825,1.5845369,-0.88630674,-0.86165822,0.22150697,1.5889407,-0.88638342,-0.81833162,0.31158907,1.5879,-0.88597809,-0.87420158,0.19300233,1.5904744,-0.88651488,-0.85482237,0.22607516,1.5893132,-0.88636151,-0.83430385,0.25913703,1.5880205,-0.88620814,-0.8639478,0.17590174,1.5886121,-0.88658061,-0.86051891,0.18274855,1.5910988,-0.8865587,-0.81149576,0.32298216,1.5904087,-0.88592332,-0.86165822,0.1884451,1.5910988,-0.88652583,-0.86850503,0.17248382,1.5887983,-0.88660252,-0.81377438,0.32298216,1.589368,-0.88592332,-0.816053,0.31728561,1.5891489,-0.88594522,-0.81491369,0.31158907,1.5801987,-0.88595618,-0.85368306,0.21011388,1.584745,-0.88642724,-0.85710099,0.19529191,1.5799029,-0.88648201,-0.84113971,0.24317575,1.5852927,-0.88628483,-0.85937961,0.19300233,1.587407,-0.88650392,-0.85596168,0.19984914,1.5877247,-0.88648201,-0.86051891,0.18160924,1.5848326,-0.8865587,-0.85026513,0.19870983,1.5817324,-0.8864601,-0.86165822,0.18274855,1.5871551,-0.8865587,-0.8582403,0.1884451,1.5811956,-0.88650392,-0.86051891,0.18160924,1.5895542,-0.8865587,-0.86508711,0.19072372,1.5805274,-0.88649297,-0.86850503,0.19072372,1.5831565,-0.88649297,-0.82745704,0.25344049,1.584975,-0.88607668,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915,-0.85596168,0.21694973,1.5876261,-0.88644915:4
-0.86229128,0.072902991,1.6752982,-0.59302937,-0.86030187,0.11270074,1.6744429,-0.59288521,-0.85732257,0.1047335,1.6736356,-0.59292365,-0.85433365,0.10672291,1.6678019,-0.59290443,-0.86030187,0.052009412,1.6720594,-0.59310625,-0.85632306,0.05996704,1.672069,-0.59306781,-0.86329079,0.32062741,1.6723862,-0.59209714,-0.85732257,0.090807654,1.6741161,-0.59298132,-0.85632306,0.073892889,1.670983,-0.59303898,-0.85632306,0.075882296,1.672713,-0.59302937,-0.85433365,0.1027441,1.6712233,-0.59293326,-0.85433365,0.080860619,1.6712906,-0.59301976,-0.85732257,0.067924668,1.671156,-0.59304859,-0.85433365,0.065935261,1.6694357,-0.59306781,-0.85831246,0.10573301,1.6711464,-0.59290443,-0.85533316,0.071903482,1.6680902,-0.59303898,-0.86428069,-0.11712862,1.669157,-0.59355796,-0.86030187,0.2619351,1.6683593,-0.59235662,-0.77076895,-0.57975705,1.6718384,-0.59588374,-0.77076895,-0.57975705,1.6709446,-0.59588374,-0.77076895,-0.57875754,1.6702622,-0.59588374,-0.76976944,-0.57875754,1.6703391,-0.59588374,-0.76976944,-0.57875754,1.6699259,-0.59588374,-0.77076895,-0.57975705,1.6724919,-0.59588374,-0.77076895,-0.57975705,1.6755673,-0.59588374,-0.77175885,-0.57875754,1.6761344,-0.59588374,-0.77076895,-0.57875754,1.676019,-0.59588374,-0.77076895,-0.57975705,1.6761344,-0.59588374,-0.77175885,-0.57975705,1.6766918,-0.59588374,-0.77076895,-0.57875754,1.675798,-0.59588374,-0.77175885,-0.57875754,1.6768648,-0.59588374,-0.77076895,-0.57975705,1.6753078,-0.59588374,-0.77076895,-0.57975705,1.6751829,-0.59588374,-0.77175885,-0.57975705,1.6780757,-0.59588374,-0.77076895,-0.57975705,1.675971,-0.59588374,-0.77175885,-0.57975705,1.6771243,-0.59588374,-0.77076895,-0.57875754,1.6754616,-0.59588374,-0.76976944,-0.57875754,1.6695703,-0.59588374,-0.87821615,0.28680749,1.6665045,-0.59223168,-0.86030187,0.14354135,1.6677731,-0.59276027,-0.84339672,0.090807654,1.6664084,-0.59295248,-0.85533316,0.15348839,1.6714155,-0.592693,-0.85533316,0.072902991,1.671502,-0.59302937,-0.85632306,0.093796569,1.6718768,-0.59296209,-0.85533316,0.091807163,1.6715308,-0.59297171,-0.86229128,0.32361632,1.671156,-0.59210675,-0.85632306,0.069914075,1.6718384,-0.5930582,-0.85632306,0.081850517,1.6714828,-0.59301015,-0.85135435,0.043052276,1.6718192,-0.59312548,-0.85831246,0.052999311,1.6653608,-0.59309664,-0.85334375,0.054988718,1.6665333,-0.59309664,-0.85931197,0.035094648,1.6687149,-0.59315431,-0.85433365,0.046041191,1.6685035,-0.59312548,-0.85433365,0.048030598,1.6687438,-0.59312548,-0.86329079,0.036084546,1.6696183,-0.5931447,-0.85433365,0.046041191,1.6669562,-0.59312548,-0.86030187,0.035094648,1.6668216,-0.59315431,-0.85732257,0.039073462,1.6673887,-0.5931447,-0.85732257,0.27387154,1.6658798,-0.59225091,-0.85533316,0.033105241,1.6662258,-0.59316392,-0.87124842,0.041062869,1.6663507,-0.59311587,-0.85533316,0.049020497,1.6666102,-0.59311587,-0.85931197,0.06693477,1.6696087,-0.59304859,-0.85433365,0.041062869,1.6683113,-0.5931447,-0.85931197,0.048030598,1.6704641,-0.59311587,-0.85831246,0.049020497,1.6705506,-0.59310625,-0.85831246,0.042062378,1.6702911,-0.59313509,-0.85831246,0.048030598,1.6700508,-0.59311587,-0.86428069,0.040072971,1.6741161,-0.59313509,-0.85632306,0.046041191,1.6727033,-0.59312548,-0.85632306,0.067924668,1.6744044,-0.5930582,-0.87025852,0.43007362,1.6720787,-0.59175115,-0.85632306,0.06693477,1.6726072,-0.59306781,-0.85433365,0.041062869,1.6724919,-0.5931447,-0.85831246,0.04703109,1.6736644,-0.59312548,-0.85433365,0.053998819,1.6731551,-0.59310625,-0.85831246,0.038083564,1.6751733,-0.5931447,-0.85433365,0.04703109,1.6727995,-0.59312548,-0.85732257,0.055988226,1.6738759,-0.59309664,-0.85433365,0.12164827,1.6727514,-0.59285638,-0.85632306,0.128616,1.6730974,-0.59284677,-0.85931197,0.067924668,1.6721844,-0.59304859,-0.85732257,0.2350733,1.6713386,-0.59249117,-0.85632306,0.088818247,1.6726072,-0.59299093,-0.87025852,0.49672356,1.6717999,-0.59153011,-0.85632306,0.11270074,1.6702911,-0.59288521,-0.85632306,0.184329,1.6730686,-0.59264494,-0.85433365,0.089817756,1.6736548,-0.59297171,-0.85732257,0.30770107,1.6722997,-0.59218363,-0.86030187,0.051009904,1.673501,-0.59303898,-0.86528019,0.037084055,1.6753367,-0.59313509,-0.85632306,0.044051784,1.6742411,-0.59311587,-0.85732257,0.071903482,1.6732512,-0.59303898,-0.85433365,0.054988718,1.6730782,-0.59309664,-0.85334375,0.14354135,1.6693877,-0.59275066,-0.85632306,0.07986111,1.670022,-0.59300054,-0.85632306,0.11369064,1.6696568,-0.5928756,-0.85334375,0.27088262,1.6680133,-0.59226052,-0.86030187,0.061956447,1.6686477,-0.5930582,-0.85533316,0.13757313,1.6689264,-0.59280832,-0.85632306,0.068924177,1.6690225,-0.59304859,-0.84737553,0.054988718,1.6698394,-0.59308703,-0.85234424,0.040072971,1.6686477,-0.59313509,-0.85931197,0.052009412,1.6727706,-0.59309664,-0.85931197,0.21914843,1.6722132,-0.59245273,-0.85632306,0.06693477,1.6731262,-0.59303898,-0.85334375,0.05996704,1.6722516,-0.59307742,-0.86030187,0.069914075,1.6727033,-0.59300054,-0.85632306,0.21715902,1.6719249,-0.59252,-0.85334375,0.049020497,1.6727418,-0.59311587,-0.85732257,0.040072971,1.6726265,-0.59313509,-0.85632306,0.070913584,1.6739047,-0.59303898,-0.86329079,0.32560573,1.6748177,-0.59210675,-0.77076895,-0.57975705,1.6759133,-0.59588374,-0.77076895,-0.57975705,1.6766149,-0.59588374,-0.77076895,-0.57975705,1.6749234,-0.59588374,-0.76976944,-0.57875754,1.6710119,-0.59588374,-0.76976944,-0.57875754,1.6717807,-0.59588374,-0.76976944,-0.57975705,1.6711753,-0.59588374,-0.76976944,-0.57875754,1.6669273,-0.59588374,-0.76976944,-0.57975705,1.6665333,-0.59588374,-0.76976944,-0.57975705,1.6712618,-0.59588374,-0.77076895,-0.57975705,1.6722516,-0.59588374,-0.76976944,-0.57975705,1.6705313,-0.59588374,-0.76976944,-0.57875754,1.6715597,-0.59588374,-0.76976944,-0.57875754,1.6664276,-0.59588374,-0.77076895,-0.57975705,1.6728475,-0.59588374,-0.77076895,-0.57975705,1.672415,-0.59588374,-0.77076895,-0.57975705,1.6732127,-0.59588374,-0.77076895,-0.57975705,1.6728379,-0.59588374,-0.76976944,-0.57975705,1.671156,-0.59588374,-0.76976944,-0.57875754,1.6677442,-0.59588374,-0.76976944,-0.57875754,1.6717038,-0.59588374,-0.76976944,-0.57875754,1.6697625,-0.59588374,-0.76976944,-0.57875754,1.6706371,-0.59588374,-0.76976944,-0.57975705,1.6700508,-0.59588374,-0.76976944,-0.57975705,1.6701757,-0.59588374,-0.76976944,-0.57975705,1.671454,-0.59588374,-0.76976944,-0.57975705,1.6689167,-0.59588374,-0.76976944,-0.57975705,1.6697529,-0.59588374,-0.76976944,-0.57875754,1.672367,-0.59588374,-0.76976944,-0.57875754,1.6712329,-0.59588374,-0.77076895,-0.57975705,1.6736452,-0.59588374,-0.77076895,-0.57875754,1.6710791,-0.59588374,-0.77076895,-0.57975705,1.6751733,-0.59588374,-0.77076895,-0.57875754,1.6742603,-0.59588374,-0.77076895,-0.57975705,1.6744717,-0.59588374,-0.77076895,-0.57975705,1.6747312,-0.59588374,-0.77076895,-0.57875754,1.6762689,-0.59588374,-0.77076895,-0.57875754,1.6754904,-0.59588374,-0.77076895,-0.57875754,1.6768648,-0.59588374,-0.77076895,-0.57975705,1.6752213,-0.59588374,-0.77076895,-0.57975705,1.6763073,-0.59588374,-0.77076895,-0.57975705,1.6759037,-0.59588374,-0.77076895,-0.57875754,1.6755962,-0.59588374,-0.77076895,-0.57975705,1.6728091,-0.59588374,-0.77076895,-0.57875754,1.6726649,-0.59588374,-0.77076895,-0.57875754,1.6741738,-0.59588374,-0.77076895,-0.57875754,1.6741353,-0.59588374,-0.77076895,-0.57975705,1.6737125,-0.59588374,-0.77076895,-0.57975705,1.6729436,-0.59588374,-0.77076895,-0.57975705,1.6761151,-0.59588374,-0.77175885,-0.57975705,1.679056,-0.59588374,-0.77175885,-0.57975705,1.679056,-0.59588374,-0.77175885,-0.57975705,1.6789311,-0.59588374,-0.77175885,-0.57875754,1.6778162,-0.59588374,-0.77076895,-0.57875754,1.676932,-0.59588374,-0.77076895,-0.57875754,1.6765957,-0.59588374,-0.77076895,-0.57975705,1.6748946,-0.59588374,-0.77076895,-0.57975705,1.6755577,-0.59588374,-0.77076895,-0.57975705,1.6752886,-0.59588374,-0.77175885,-0.57975705,1.6767687,-0.59588374,-0.77175885,-0.57975705,1.6768936,-0.59588374,-0.77076895,-0.57975705,1.6735491,-0.59588374,-0.77076895,-0.57875754,1.6744237,-0.59588374,-0.77076895,-0.57875754,1.6735395,-0.59588374,-0.77076895,-0.57975705,1.6739431,-0.59588374,-0.77076895,-0.57975705,1.6728187,-0.59588374,-0.77076895,-0.57975705,1.6749619,-0.59588374,-0.77076895,-0.57975705,1.6748465,-0.59588374,-0.77076895,-0.57975705,1.6722997,-0.59588374,-0.77076895,-0.57875754,1.6727322,-0.59588374,-0.77076895,-0.57875754,1.6739239,-0.59588374,-0.77076895,-0.57875754,1.6762305,-0.59588374,-0.77175885,-0.57975705,1.679402,-0.59588374,-0.77175885,-0.57975705,1.6794308,-0.59588374,-0.77175885,-0.57975705,1.6790656,-0.59588374,-0.77175885,-0.57975705,1.6791041,-0.59588374,-0.77175885,-0.57975705,1.6765861,-0.59588374,-0.77076895,-0.57975705,1.6751445,-0.59588374,-0.77076895,-0.57875754,1.6751252,-0.59588374,-0.77076895,-0.57875754,1.6756827,-0.59588374,-0.77076895,-0.57875754,1.6726265,-0.59588374,-0.77076895,-0.57975705,1.6710215,-0.59588374,-0.76976944,-0.57975705,1.6684458,-0.59588374,-0.76976944,-0.57975705,1.6692147,-0.59588374,-0.77076895,-0.57975705,1.6728571,-0.59588374,-0.77076895,-0.57975705,1.6731551,-0.59588374,-0.77076895,-0.57975705,1.673328,-0.59588374,-0.77076895,-0.57875754,1.6777201,-0.59588374,-0.77175885,-0.57975705,1.6776528,-0.59588374,-0.77175885,-0.57975705,1.6776625,-0.59588374,-0.77175885,-0.57975705,1.6779508,-0.59588374,-0.77076895,-0.57975705,1.676317,-0.59588374,-0.77175885,-0.57975705,1.6769705,-0.59588374,-0.77175885,-0.57975705,1.6783736,-0.59588374,-0.77175885,-0.57875754,1.6791137,-0.59588374,-0.77175885,-0.57975705,1.6818911,-0.59588374,-0.77175885,-0.57975705,1.6806225,-0.59588374,-0.77175885,-0.57975705,1.6798345,-0.59588374,-0.77175885,-0.57875754,1.680536,-0.59588374,-0.77175885,-0.57875754,1.6793251,-0.59588374,-0.77175885,-0.57875754,1.6787485,-0.59588374,-0.77076895,-0.57875754,1.6737317,-0.59588374,-0.77175885,-0.57875754,1.6788542,-0.59588374,-0.77175885,-0.57875754,1.6797672,-0.59588374,-0.77175885,-0.57975705,1.679056,-0.59588374,-0.77175885,-0.57975705,1.6794789,-0.59588374,-0.77175885,-0.57975705,1.6773261,-0.59588374,-0.77175885,-0.57975705,1.678489,-0.59588374,-0.77175885,-0.57975705,1.6781334,-0.59588374,-0.77175885,-0.57975705,1.6772011,-0.59588374,-0.77175885,-0.57875754,1.6792098,-0.59588374,-0.77175885,-0.57875754,1.6834096,-0.59588374,-0.77175885,-0.57975705,1.6820834,-0.59588374,-0.77175885,-0.57975705,1.6811607,-0.59588374,-0.77175885,-0.57975705,1.6811415,-0.59588374,-0.77275835,-0.57975705,1.6843899,-0.59588374,-0.77275835,-0.57875754,1.6841016,-0.59588374,-0.77175885,-0.57975705,1.6824293,-0.59588374,-0.77175885,-0.57975705,1.6813433,-0.59588374,-0.77175885,-0.57875754,1.6818143,-0.59588374,-0.77175885,-0.57875754,1.6814202,-0.59588374,-0.77175885,-0.57875754,1.6794596,-0.59588374,-0.77175885,-0.57975705,1.6829579,-0.59588374,-0.77175885,-0.57975705,1.6807475,-0.59588374,-0.77076895,-0.58074694,1.6751637,-0.59588374,-0.77076895,-0.57875754,1.6771723,-0.59588374,-0.77076895,-0.57875754,1.6771819,-0.59588374,-0.77175885,-0.57875754,1.6793251,-0.59588374,-0.77175885,-0.57975705,1.6785082,-0.59588374,-0.77175885,-0.57975705,1.6796134,-0.59588374,-0.77175885,-0.57975705,1.6815067,-0.59588374,-0.77076895,-0.57975705,1.6744429,-0.59588374,-0.76976944,-0.57975705,1.6706947,-0.59588374,-0.76976944,-0.57975705,1.667898,-0.59588374,-0.76976944,-0.57975705,1.66933,-0.59588374,-0.76976944,-0.57875754,1.6688495,-0.59588374,-0.77076895,-0.57875754,1.6733184,-0.59588374,-0.77076895,-0.57975705,1.675106,-0.59588374,-0.77076895,-0.57975705,1.6746735,-0.59588374,-0.77175885,-0.57975705,1.6769032,-0.59588374,-0.77076895,-0.57975705,1.6737221,-0.59588374,-0.76976944,-0.57875754,1.6657452,-0.59588374,-0.77076895,-0.57875754,1.6752694,-0.59588374,-0.77076895,-0.57875754,1.6740585,-0.59588374,-0.77076895,-0.57975705,1.6740104,-0.59588374,-0.77076895,-0.57975705,1.6755097,-0.59588374,-0.77076895,-0.57975705,1.6731743,-0.59588374,-0.76976944,-0.57975705,1.6685515,-0.59588374,-0.76976944,-0.57975705,1.6658606,-0.59588374,-0.76976944,-0.57875754,1.6687438,-0.59588374,-0.76976944,-0.57875754,1.6663795,-0.59588374,-0.76976944,-0.57875754,1.6680518,-0.59588374,-0.76877954,-0.57975705,1.6649379,-0.59588374,-0.76976944,-0.57975705,1.6649379,-0.59588374,-0.76976944,-0.57975705,1.6671196,-0.59588374,-0.76976944,-0.57875754,1.6661297,-0.59588374,-0.76976944,-0.57875754,1.6698778,-0.59588374,-0.76976944,-0.57875754,1.6688591,-0.59588374,-0.77076895,-0.57875754,1.673799,-0.59588374,-0.76976944,-0.57875754,1.6683978,-0.59588374,-0.77076895,-0.57975705,1.6722805,-0.59588374,-0.77076895,-0.57875754,1.6713963,-0.59588374,-0.77076895,-0.57975705,1.6727706,-0.59588374,-0.77076895,-0.57975705,1.6736644,-0.59588374,-0.77076895,-0.57875754,1.6742122,-0.59588374,-0.77076895,-0.57875754,1.6729244,-0.59588374,-0.77076895,-0.57875754,1.6744621,-0.59588374,-0.77076895,-0.57875754,1.6728667,-0.59588374,-0.77076895,-0.57975705,1.6733088,-0.59588374,-0.77076895,-0.57975705,1.6721267,-0.59588374,-0.77076895,-0.57975705,1.6740008,-0.59588374,-0.77076895,-0.57975705,1.6736644,-0.59588374,-0.77076895,-0.57975705,1.6761247,-0.59588374,-0.77076895,-0.57875754,1.672588,-0.59588374,-0.77076895,-0.57875754,1.6714059,-0.59588374,-0.77076895,-0.57875754,1.6730109,-0.59588374,-0.77076895,-0.57975705,1.6706274,-0.59588374,-0.76579062,-0.55488465,1.6723958,-0.59579724,-0.86030187,0.31465919,1.6706082,-0.59209714,-0.85632306,0.21815853,1.6705698,-0.59252,-0.85931197,0.10672291,1.6708197,-0.59289482,-0.85334375,0.090807654,1.6693973,-0.59298132,-0.85533316,0.065935261,1.6692243,-0.5930582,-0.85732257,0.14950958,1.6696183,-0.59274105,-0.86528019,0.34947861,1.6683113,-0.59202986,-0.85533316,0.076881805,1.6707139,-0.59301015,-0.84936494,0.082850026,1.6694261,-0.59299093,-0.85533316,0.21616913,1.6710599,-0.59253923,-0.86030187,0.07986111,1.6719153,-0.59299093,-0.85831246,0.062955956,1.6731262,-0.59306781,-0.86229128,0.063945854,1.6720306,-0.59304859,-0.85931197,0.12662659,1.67254,-0.59284677,-0.85831246,0.12463718,1.6718096,-0.59285638,-0.85632306,0.22810557,1.6714059,-0.59249117,-0.85533316,0.12363767,1.6732896,-0.59285638,-0.85732257,0.10672291,1.6721075,-0.59291404,-0.85632306,0.046041191,1.6724727,-0.59312548,-0.85931197,0.27586094,1.672242,-0.59225091,-0.85433365,0.056978124,1.6718768,-0.59309664,-0.85632306,0.048030598,1.6731262,-0.59312548,-0.85234424,0.071903482,1.6715597,-0.59304859,-0.85533316,0.04703109,1.6710984,-0.59312548,-0.86826911,0.051009904,1.6723093,-0.59309664,-0.85831246,0.1296059,1.6719826,-0.59283716,-0.86528019,0.045041683,1.6723478,-0.59312548,-0.85433365,0.052009412,1.671454,-0.59311587,-0.85433365,0.056978124,1.6708293,-0.59309664,-0.86130138,0.041062869,1.6709927,-0.59313509,-0.85632306,0.052009412,1.6730013,-0.59310625,-0.85632306,0.094786468,1.6721075,-0.59293326,-0.85632306,0.27983976,1.6722805,-0.5922413,-0.85433365,0.052999311,1.673799,-0.59310625,-0.85433365,0.058967531,1.6729917,-0.59308703,-0.85533316,0.05996704,1.6718768,-0.59307742,-0.85533316,0.060956938,1.671502,-0.59308703,-0.86130138,0.061956447,1.6731166,-0.59306781,-0.85334375,0.052009412,1.6713867,-0.59310625,-0.85732257,0.15447829,1.6697144,-0.59270261,-0.85433365,0.052999311,1.662987,-0.59310625,-0.85334375,0.053998819,1.6601422,-0.59310625,-0.85234424,0.05996704,1.6584411,-0.59307742,-0.85632306,0.19726495,1.6631023,-0.59257767,-0.85334375,0.075882296,1.6648899,-0.59303898,-0.85234424,0.22710606,1.6643901,-0.59245273,-0.85533316,0.15945661,1.6645823,-0.59270261,-0.85433365,0.046041191,1.6678596,-0.59313509,-0.85433365,0.043052276,1.6658029,-0.59313509,-0.85831246,0.067924668,1.6678211,-0.59302937,-0.84239721,0.087828349,1.6692147,-0.59293326,-0.86030187,0.029126427,1.671156,-0.59316392,-0.86428069,0.23308389,1.6710503,-0.59236623,-0.85433365,0.052009412,1.6698586,-0.59311587,-0.86925901,0.031115834,1.6706467,-0.59316392,-0.85433365,0.040072971,1.6704929,-0.59315431,-0.85433365,0.049020497,1.6722709,-0.59312548,-0.86428069,0.035094648,1.6708004,-0.59315431,-0.85732257,0.044051784,1.673453,-0.59313509,-0.84339672,0.069914075,1.6754808,-0.59303898,-0.85433365,0.035094648,1.6740873,-0.59316392,-0.85433365,0.055988226,1.6747408,-0.59309664,-0.85732257,0.046041191,1.6743372,-0.59312548,-0.85632306,0.063945854,1.673972,-0.59306781,-0.85334375,0.049020497,1.6762689,-0.59311587,-0.85732257,0.24601023,1.6729821,-0.5923374,-0.85632306,0.038083564,1.6748369,-0.59315431,-0.85533316,0.048030598,1.6735491,-0.59312548,-0.86528019,0.029126427,1.6735683,-0.59316392,-0.86229128,0.044051784,1.6746447,-0.59310625,-0.86229128,0.044051784,1.6746447,-0.59310625,-0.86229128,0.044051784,1.6746447,-0.59310625,-0.86229128,0.044051784,1.6746447,-0.59310625,-0.86229128,0.044051784,1.6746447,-0.59310625,-0.86229128,0.044051784,1.6746447,-0.59310625:4
-0.90375432,0.074478585,1.6010579,-0.69269387,-0.90273716,0.030701636,1.6020164,-0.69286992,-0.90273716,0.028667318,1.602212,-0.6928797,-0.92003864,0.55698351,1.6022902,-0.69068889,-0.90273716,0.011365838,1.6027108,-0.69296772,-0.90375432,0.020530048,1.604569,-0.6929286,-0.90578864,0.23225556,1.6031509,-0.69204837,-0.90375432,0.067348693,1.6020164,-0.69272321,-0.90375432,0.091780065,1.6054297,-0.69263519,-0.90375432,0.031728575,1.6074053,-0.6928797,-0.90375432,0.0042359465,1.6076205,-0.69299706,-0.90578864,0.10196143,1.6070337,-0.69259607,-0.90273716,0.011365838,1.6063784,-0.69296772,-0.90375432,0.025615842,1.6068479,-0.69290904,-0.90477148,0.014417315,1.6058405,-0.69294816,-0.90375432,0.016451632,1.6066229,-0.69294816,-0.90375432,0.021547207,1.6056351,-0.6929286,-0.90273716,0.012382997,1.6035519,-0.69295794,-0.90375432,0.041900163,1.6052732,-0.69284058,-0.90375432,0.0032187877,1.6040898,-0.69299706,-0.90273716,0.01848595,1.6048038,-0.69293838,-0.90273716,0.020530048,1.6051461,-0.6929286,-0.90273716,0.026633001,1.6066914,-0.69290904,-0.90273716,0.033762893,1.6031802,-0.69286992,-0.90375432,0.077530062,1.6076988,-0.69269387,-0.91597001,0.45417223,1.6066034,-0.69111923,-0.90477148,0.11621144,1.6085888,-0.69253739,-0.90985727,0.28111831,1.6075814,-0.69184298,-0.90477148,0.023581524,1.6082269,-0.69291882,-0.90477148,0.017468791,1.6106035,-0.69293838,-0.90375432,0.0072972033,1.6100069,-0.6929775,-0.90477148,0.041900163,1.6096255,-0.69284058,-0.90375432,0.036814369,1.6094592,-0.69286014,-0.90273716,0.084659954,1.6080508,-0.69266453,-0.90375432,0.036814369,1.6106133,-0.69286014,-0.90375432,0.064297217,1.6089311,-0.69275255,-0.90375432,0.05309869,1.6074347,-0.69279168,-0.90273716,0.04496142,1.6062806,-0.6928308,-0.90477148,0.10909133,1.6075031,-0.69256673,-0.90375432,0.050047214,1.6090289,-0.69281124,-0.90477148,0.023581524,1.6106035,-0.69291882,-0.90578864,0.020530048,1.609068,-0.6929286,-0.90578864,0.032745734,1.6115033,-0.6928797,-0.90578864,0.025615842,1.6113077,-0.69290904,-0.9068058,0.012382997,1.6115033,-0.69295794,-0.90477148,0.024598683,1.6116402,-0.69290904,-0.9068058,-0.0049184826,1.6133616,-0.69303618,-0.90578864,0.045978578,1.6121488,-0.6928308,-0.90477148,0.0042359465,1.6129019,-0.69300684,-0.90578864,0.033762893,1.6128139,-0.69288948,-0.90578864,0.015434474,1.6132833,-0.69295794,-0.9068058,0.10196143,1.6135865,-0.69260585,-0.90477148,0.067348693,1.612765,-0.69275255,-0.90477148,0.029684477,1.6127259,-0.69289926,-0.90578864,0.03579721,1.6120217,-0.69286014,-0.90477148,0.0093315209,1.6118554,-0.69296772,-0.90578864,0.040883004,1.6128432,-0.69286014,-0.90578864,0.013400156,1.6147504,-0.69296772,-0.9068058,0.029684477,1.6126378,-0.69289926,-0.9068058,-0.0069625805,1.6114642,-0.69303618,-0.90477148,-0.0018670062,1.6110339,-0.69301662,-0.90578864,0.01034868,1.6127259,-0.6929775,-0.90578864,-0.030367013,1.6139289,-0.69314377,-0.90578864,-0.028332696,1.6100265,-0.69312421,-0.90477148,-0.027315537,1.6091071,-0.69312421,-0.90375432,-0.040548381,1.6076205,-0.69317311,-0.90375432,-0.021212584,1.6094201,-0.69309487,-0.90477148,-0.028332696,1.6083638,-0.69312421,-0.90477148,-0.036479746,1.6090387,-0.69316333,-0.90477148,-0.035462587,1.6077281,-0.69315355,-0.90477148,-0.025281219,1.6092538,-0.69311443,-0.90578864,-0.015099851,1.6073662,-0.69307531,-0.90578864,-0.043599858,1.6115327,-0.69318289,-0.9068058,-0.030367013,1.6123542,-0.69314377,-0.90578864,-0.039531223,1.6107209,-0.69317311,-0.9068058,-0.028332696,1.6115424,-0.69312421,-0.90578864,0.0083143621,1.6102319,-0.6929775,-0.90782296,-0.029349854,1.6086181,-0.69312421,-0.90782296,-0.040548381,1.6125792,-0.69318289,-0.90782296,-0.046661114,1.6119923,-0.69319267,-0.90782296,-0.027315537,1.6134985,-0.69313399,-0.90578864,-0.047678273,1.6122271,-0.69321223,-0.90578864,-0.002884165,1.6122662,-0.69303618,-0.9068058,-0.027315537,1.6152688,-0.69313399,-0.90782296,-0.028332696,1.6128432,-0.69313399,-0.9068058,-0.013065533,1.6142125,-0.69307531,-0.90884011,0.024598683,1.6152394,-0.69291882,-0.90782296,-0.011031216,1.6143788,-0.69306553,-0.90884011,0.023581524,1.6175476,-0.69291882,-0.90884011,-0.039531223,1.6163446,-0.69318289,-0.90884011,-0.045643956,1.6161979,-0.69320245,-0.90884011,0.071427109,1.6149167,-0.69272321,-0.90782296,-0.0039013238,1.6144179,-0.69303618,-0.90782296,-0.010014057,1.6164815,-0.69305575,-0.90782296,-0.012048374,1.6150732,-0.69306553,-0.91698716,-0.096541017,1.6179877,-0.69339806,-0.91189159,0.11519428,1.6155426,-0.69254717,-0.94650433,0.4714737,1.6126281,-0.69104099,-0.8660901,-0.60143321,1.6177139,-0.69527589,-0.84471021,-0.66556312,1.6168825,-0.69546172,-0.84471021,-0.66454596,1.61655,-0.69546172,-0.84572737,-0.66556312,1.6168434,-0.69545194,-0.84572737,-0.66658028,1.6174889,-0.69545194,-0.84572737,-0.66658028,1.6184963,-0.69545194,-0.84572737,-0.66658028,1.6173911,-0.69545194,-0.84572737,-0.66658028,1.6189364,-0.69545194,-0.84471021,-0.66454596,1.618242,-0.69546172,-0.84572737,-0.66556312,1.6170684,-0.69545194,-0.84572737,-0.66658028,1.6170488,-0.69545194,-0.84471021,-0.66658028,1.6168434,-0.69546172,-0.84471021,-0.66658028,1.6178899,-0.69546172,-0.84471021,-0.66658028,1.6172444,-0.69546172,-0.84572737,-0.66556312,1.6184376,-0.69546172,-0.84471021,-0.66454596,1.6171564,-0.69546172,-0.84471021,-0.66658028,1.6185061,-0.69545194,-0.84572737,-0.66658028,1.6194059,-0.69545194,-0.84572737,-0.66658028,1.6206969,-0.69545194,-0.84572737,-0.66658028,1.6213717,-0.69545194,-0.84572737,-0.66658028,1.6215771,-0.69545194,-0.84674453,-0.66556312,1.6238266,-0.69545194,-0.84674453,-0.66658028,1.6250491,-0.69545194,-0.84674453,-0.66658028,1.6268976,-0.69545194,-0.84674453,-0.66658028,1.6296166,-0.69545194,-0.84674453,-0.66658028,1.6319345,-0.69546172,-0.84674453,-0.66658028,1.6334016,-0.69545194,-0.84776169,-0.66556312,1.6329517,-0.69545194,-0.84674453,-0.66556312,1.6311032,-0.69545194,-0.84776169,-0.66658028,1.6315335,-0.69545194,-0.84776169,-0.66658028,1.6327169,-0.69545194,-0.9210558,0.26890262,1.6307315,-0.69192122,-0.91290875,0.068365852,1.6303794,-0.69274277,-0.91189159,0.020530048,1.6314846,-0.69294816,-0.91087443,0.0011844702,1.6321106,-0.69303618,-0.91087443,-8.4984742E-4,1.6316118,-0.6930264,-0.91290875,0.029684477,1.6316118,-0.69290904,-0.91189159,0.0011844702,1.6300469,-0.6930264,-0.90985727,0.01848595,1.6272008,-0.69295794,-0.90985727,-0.0049184826,1.6268487,-0.69304596,-0.90985727,-0.0049184826,1.6276018,-0.69304596,-0.91087443,-0.039531223,1.6300567,-0.69318289,-0.90985727,-0.038514064,1.6280322,-0.69314377,-0.91189159,-0.014082692,1.6281006,-0.69294816,-0.91393569,0.1956085,1.6268585,-0.69222441,-0.91087443,-0.035462587,1.6274845,-0.69319267,-0.91087443,-0.048695432,1.6276018,-0.69318289,-0.91087443,-0.015099851,1.6277876,-0.69317311,-0.91189159,-0.032401331,1.6286972,-0.69313399,-0.91087443,-0.015099851,1.629196,-0.69295794,-0.91189159,-0.025281219,1.6302425,-0.69316333,-0.91087443,-0.023246902,1.6291471,-0.69312421,-0.91087443,-0.03342827,1.6310934,-0.69316333,-0.91087443,-0.049712591,1.6297633,-0.69321223,-0.91087443,-0.035462587,1.6309858,-0.69315355,-0.91087443,-0.013065533,1.630976,-0.69301662,-0.91189159,-0.044617017,1.6328245,-0.69320245,-0.91698716,0.21902272,1.6335287,-0.69226353,-0.91189159,-0.035462587,1.6343209,-0.69312421,-0.91290875,-0.02426406,1.6356608,-0.69317311,-0.91189159,-0.05072975,1.635964,-0.69319267,-0.91189159,0.021547207,1.634585,-0.6928797,-0.91290875,0.027650159,1.6378125,-0.6929286,-0.91189159,-0.0049184826,1.6369323,-0.69305575,-0.91189159,-0.021212584,1.6368247,-0.69312421,-0.91189159,-0.022229743,1.6378908,-0.69313399,-0.91087443,-0.028332696,1.6368932,-0.69315355,-0.91189159,0.024598683,1.63748,-0.69293838,-0.91189159,-0.011031216,1.6364531,-0.69308509,-0.91290875,-0.017134168,1.637079,-0.69310465,-0.91800432,0.20680703,1.6370105,-0.69219507,-0.91393569,-0.013065533,1.6369616,-0.69309487,-0.91290875,-0.031384172,1.6355728,-0.69316333,-0.91290875,0.0093315209,1.637079,-0.69300684,-0.91393569,-0.027315537,1.6380277,-0.69314377,-0.91189159,0.0052531053,1.6364531,-0.69301662,-0.91189159,-0.030367013,1.6372159,-0.69316333,-0.91290875,-0.021212584,1.6374213,-0.69312421,-0.91290875,-0.042582699,1.6372648,-0.69321223,-0.91290875,0.026633001,1.636991,-0.6929286,-0.91290875,-0.040548381,1.6351131,-0.69320245,-0.91290875,0.033762893,1.6349469,-0.69289926,-0.91290875,-0.020195425,1.6349175,-0.69312421,-0.91800432,0.22310113,1.6340471,-0.69212661,-0.91189159,-0.038514064,1.6343503,-0.69319267,-0.91495285,-0.015099851,1.6354457,-0.69309487,-0.91393569,0.034780051,1.6333233,-0.69289926,-0.91495285,0.01848595,1.632492,-0.69295794,-0.91393569,-0.030367013,1.6321595,-0.69316333,-0.91290875,-0.036479746,1.6322768,-0.69318289,-0.91698716,0.17322123,1.6335581,-0.692332,-0.91393569,-0.011031216,1.6358369,-0.69308509,-0.91290875,-0.042582699,1.6357684,-0.69321223,-0.91393569,-0.014082692,1.6369323,-0.69309487,-0.91290875,-0.037496905,1.6351523,-0.69319267,-0.91290875,-0.012048374,1.6354066,-0.69308509,-0.91393569,-0.0049184826,1.6360716,-0.69305575,-0.91393569,-0.03342827,1.6360325,-0.69317311,-0.91495285,-0.038514064,1.6378027,-0.69319267,-0.91495285,-0.025281219,1.6364433,-0.69313399,-0.91495285,-0.045643956,1.6365998,-0.69322201,-0.91597001,-0.019168486,1.6379788,-0.69311443,-0.91597001,-0.031384172,1.6392405,-0.69316333,-0.9210558,0.22003988,1.637568,-0.69213639,-0.91393569,-0.04156554,1.6356608,-0.69320245,-0.91495285,-0.042582699,1.6383015,-0.69320245,-0.91495285,-0.035462587,1.6385363,-0.69318289,-0.91393569,-0.036479746,1.6376267,-0.69318289,-0.91393569,-0.03342827,1.6364433,-0.69317311,-0.91393569,0.0022016289,1.6368345,-0.6930264,-0.91393569,-0.023246902,1.6338026,-0.69313399,-0.91393569,-0.023246902,1.6345263,-0.69313399,-0.91495285,-0.037496905,1.6333331,-0.69318289,-0.91597001,-0.02426406,1.6348393,-0.69313399,-0.91597001,-0.03342827,1.636189,-0.69317311,-0.91597001,-0.02426406,1.6351718,-0.69313399,-0.9210558,0.16405702,1.6341155,-0.69237112,-0.91597001,-0.026298378,1.6348197,-0.69314377,-0.91495285,-0.013065533,1.6353185,-0.69308509,-0.91495285,0.028667318,1.6336754,-0.69291882,-0.91393569,0.0062800445,1.6335874,-0.69301662,-0.91597001,-0.036479746,1.634008,-0.69318289,-0.91495285,-0.04156554,1.6346046,-0.69320245,-0.91495285,-0.048695432,1.6356804,-0.69323179,-0.91597001,-0.043599858,1.6362966,-0.69321223,-0.91597001,-0.032401331,1.6353185,-0.69316333,-0.91495285,-0.036479746,1.6342525,-0.69318289,-0.91495285,-0.043599858,1.6345948,-0.69321223,-0.91597001,-0.031384172,1.6365802,-0.69316333,-0.92207296,0.19459135,1.6382526,-0.69224397,-0.91698716,-0.046661114,1.6398468,-0.69322201,-0.91597001,-0.045643956,1.6369225,-0.69322201,-0.91597001,-0.045643956,1.6395534,-0.69322201,-0.91495285,-0.035462587,1.6396023,-0.69318289,-0.91495285,0.014417315,1.6395241,-0.6929775,-0.91495285,-0.028332696,1.6392111,-0.69315355,-0.91393569,-0.027315537,1.6365411,-0.69314377,-0.91597001,-0.045643956,1.6366193,-0.69322201,-0.91495285,-0.0059356414,1.6370105,-0.69305575,-0.91495285,-0.032401331,1.6376071,-0.69316333,-0.91597001,-0.04156554,1.6377343,-0.69320245,-0.91597001,-0.021212584,1.6376365,-0.69312421,-0.92207296,0.25872125,1.6369616,-0.6919799,-0.91597001,0.021547207,1.6373137,-0.69294816,-0.91495285,0.019512889,1.63748,-0.69295794,-0.91698716,0.029684477,1.6386341,-0.69291882,-0.91495285,0.020530048,1.6379005,-0.69295794,-0.91597001,0.013400156,1.6388688,-0.6929775,-0.91495285,0.024598683,1.6410498,-0.69293838,-0.91800432,0.13759133,1.6382037,-0.6924787,-0.91495285,0.027650159,1.6386536,-0.6929286,-0.91597001,0.020530048,1.6393676,-0.69294816,-0.91597001,-0.010014057,1.640952,-0.69307531,-0.91698716,-0.030367013,1.6401598,-0.69315355,-0.91698716,-0.034445429,1.6397099,-0.69317311,-0.91698716,-0.034445429,1.6395339,-0.69317311,-0.91698716,-0.026298378,1.6382624,-0.69314377,-0.91698716,-0.040548381,1.6392796,-0.69319267,-0.91698716,-0.048695432,1.6386243,-0.69323179,-0.91597001,-0.040548381,1.638194,-0.69320245,-0.91495285,-0.018151327,1.6391622,-0.69310465,-0.92003864,0.21597124,1.6368051,-0.69215595,-0.92716853,0.36866242,1.6379397,-0.69152023,-0.91597001,0.090762906,1.6395828,-0.69267431,-0.91495285,0.027650159,1.6400424,-0.6929286,-0.91597001,0.057177105,1.6398077,-0.69280146,-0.91597001,0.050047214,1.639084,-0.6928308,-0.91495285,0.064297217,1.6417638,-0.69279168,-0.91698716,0.064297217,1.6417931,-0.69279168,-0.91800432,0.0052531053,1.6421354,-0.6930264,-0.92410728,0.29740263,1.6418812,-0.6918332,-0.91800432,0.096875639,1.6409325,-0.69264497,-0.91698716,0.049030055,1.6405999,-0.69284058,-0.91698716,0.077530062,1.6393676,-0.69272321,-0.91698716,0.056150166,1.6409814,-0.69281124,-0.92207296,0.24040261,1.6388981,-0.69205815,-0.91597001,0.061245741,1.6369616,-0.69279168,-0.91495285,0.098909957,1.6377636,-0.69263519,-0.91495285,0.079564379,1.6368247,-0.69271343,-0.91393569,0.060228582,1.6353381,-0.69279168,-0.91393569,0.083642795,1.6357293,-0.69270365,-0.91597001,0.072444268,1.6367562,-0.69274277,-0.91495285,0.085677112,1.6346241,-0.69269387,-0.91597001,0.065314376,1.6350153,-0.69277211,-0.91495285,0.07040995,1.6372159,-0.69275255,-0.91597001,0.07040995,1.6365117,-0.69275255,-0.91698716,0.072444268,1.636991,-0.69274277,-0.91698716,0.072444268,1.6350545,-0.69274277,-0.92309012,0.22207419,1.6341155,-0.69212661,-0.91597001,0.07040995,1.6338906,-0.69275255,-0.91597001,0.073461426,1.6361499,-0.69274277,-0.91597001,0.064297217,1.6359836,-0.69277211,-0.91393569,0.077530062,1.6343307,-0.69272321,-0.91597001,0.07040995,1.634497,-0.69275255,-0.91597001,0.084659954,1.6357782,-0.69269387,-0.91495285,0.067348693,1.6351523,-0.69276233,-0.91597001,0.081598697,1.6367367,-0.69270365,-0.91597001,0.077530062,1.6374017,-0.69272321,-0.91698716,0.071427109,1.6378908,-0.69274277,-0.91495285,0.068365852,1.6361303,-0.69276233,-0.91698716,0.077530062,1.6366291,-0.69272321,-0.92309012,0.22411829,1.6386928,-0.69211683,-0.91597001,0.07040995,1.6370594,-0.69275255,-0.91698716,0.088728589,1.6379299,-0.69267431,-0.91597001,0.069383011,1.638458,-0.69275255,-0.91495285,0.071427109,1.6368736,-0.69275255,-0.91597001,0.072444268,1.6384678,-0.69274277,-0.91597001,0.072444268,1.6374702,-0.69274277,-0.91902148,0.13759133,1.6367269,-0.6924787,-0.91597001,0.071427109,1.6374115,-0.69275255,-0.91597001,0.068365852,1.6372648,-0.69276233,-0.91495285,0.065314376,1.6359151,-0.69277211,-0.91698716,0.072444268,1.6369225,-0.69274277,-0.91597001,0.077530062,1.6373626,-0.69272321,-0.91698716,0.10399575,1.637079,-0.69261563,-0.91698716,0.07040995,1.6379788,-0.69275255,-0.91698716,0.040883004,1.6387025,-0.69286992,-0.92207296,0.24345409,1.6377245,-0.69203859,-0.91698716,0.11417712,1.6372355,-0.69257651,-0.91698716,0.12944428,1.6384189,-0.69250804,-0.91800432,0.13555701,1.6376071,-0.69248848,-0.92309012,0.25465262,1.6365117,-0.69199946,-0.91698716,0.0032187877,1.6380081,-0.69301662,-0.91698716,0.10297859,1.6384972,-0.69261563,-0.91800432,0.080581538,1.6380864,-0.69271343,-0.91597001,-0.035462587,1.6388297,-0.69317311,-0.91597001,-0.012048374,1.6381842,-0.69308509,-0.91495285,-0.020195425,1.6322866,-0.69311443,-0.91698716,-0.01611701,1.6382624,-0.69309487,-0.91698716,-0.011031216,1.6381451,-0.69307531,-0.91597001,-0.025281219,1.6377734,-0.69313399,-0.91597001,-0.034445429,1.6389862,-0.69317311,-0.91698716,-0.011031216,1.6388395,-0.69307531,-0.91698716,-0.02426406,1.6387808,-0.69313399,-0.91597001,-0.0059356414,1.6392111,-0.69305575,-0.92003864,0.17932418,1.6370105,-0.69230266,-0.91597001,-0.038514064,1.6400522,-0.69319267,-0.91597001,0.025615842,1.6412161,-0.6929286,-0.91698716,0.01034868,1.6413432,-0.69299706,-0.91800432,0.16507418,1.6387025,-0.69236134,-0.91597001,-0.019168486,1.6401989,-0.69311443,-0.91902148,-0.028332696,1.6431819,-0.69315355,-0.91800432,-0.039531223,1.6417442,-0.69320245,-0.91902148,-0.038514064,1.6416856,-0.69320245,-0.91902148,-0.032401331,1.6428005,-0.69317311,-0.91800432,-0.038514064,1.6422137,-0.69320245,-0.91800432,-0.026298378,1.6422626,-0.69315355,-0.91902148,-0.034445429,1.6416758,-0.69318289,-0.92309012,0.21190261,1.6420083,-0.69218529,-0.91698716,-0.026298378,1.641353,-0.69314377,-0.91800432,-0.045643956,1.6406391,-0.69321223,-0.91698716,-0.021212584,1.6412846,-0.69311443,-0.91698716,0.029684477,1.6403945,-0.69291882,-0.91800432,-0.013065533,1.6422528,-0.69309487,-0.91800432,-0.03342827,1.6411868,-0.69316333,-0.91800432,-0.044617017,1.6392502,-0.69321223,-0.91698716,-0.03342827,1.637568,-0.69316333,-0.91597001,-0.031384172,1.6382429,-0.69316333,-0.91495285,-0.035462587,1.6372844,-0.69318289,-0.91495285,-0.028332696,1.6372159,-0.69315355,-0.91495285,-0.022229743,1.6379886,-0.69312421,-0.91902148,0.15692713,1.6372453,-0.69240046,-0.91902148,0.15692713,1.6372453,-0.69240046,-0.91902148,0.15692713,1.6372453,-0.69240046,-0.91902148,0.15692713,1.6372453,-0.69240046,-0.91902148,0.15692713,1.6372453,-0.69240046,-0.91902148,0.15692713,1.6372453,-0.69240046:4
-1.0363637,0.71905011,1.3353642,-0.80113383,-1.0391899,0.766087,1.3347008,-0.80093391,-1.0382448,0.74068744,1.3371454,-0.80105204,-1.0382448,0.72375743,1.3382268,-0.80112474,-1.0382448,0.71999521,1.3380814,-0.80114292,-1.0382448,0.72751966,1.3377088,-0.80110657,-1.0382448,0.72187632,1.3371908,-0.80113383,-1.0354186,0.701175,1.3361639,-0.80121562,-1.0354186,0.70400121,1.3362094,-0.80120653,-1.0382448,0.72563854,1.3398262,-0.80112474,-1.0372997,0.71528788,1.3403896,-0.80117018,-1.0363637,0.70869945,1.340426,-0.80119744,-1.0382448,0.70964455,1.3409349,-0.80119744,-1.0372997,0.70681834,1.3404896,-0.80120653,-1.0363637,0.69647676,1.3391992,-0.80124288,-1.0382448,0.70023899,1.3407077,-0.80123379,-1.0372997,0.70023899,1.3393082,-0.80123379,-1.0372997,0.70305611,1.3377179,-0.80121562,-1.0372997,0.70305611,1.3393082,-0.80121562,-1.0363637,0.70305611,1.3377088,-0.80121562,-1.0363637,0.70400121,1.3394445,-0.80120653,-1.0372997,0.70588232,1.3402351,-0.80120653,-1.0372997,0.701175,1.3400625,-0.80123379,-1.0372997,0.69271454,1.3402442,-0.80126106,-1.0363637,0.69365055,1.3403169,-0.80126106,-1.0363637,0.69835788,1.3406532,-0.80124288,-1.0382448,0.701175,1.3425252,-0.80123379,-1.0372997,0.70023899,1.3418164,-0.80124288,-1.0363637,0.69082434,1.3412075,-0.80127923,-1.0382448,0.69365055,1.3426524,-0.80127014,-1.0382448,0.69459565,1.3437247,-0.80126106,-1.0382448,0.701175,1.3416073,-0.80123379,-1.0382448,0.70400121,1.3415256,-0.80122471,-1.0382448,0.70305611,1.3400897,-0.80122471,-1.0382448,0.71246167,1.3425524,-0.80118836,-1.0391899,0.70305611,1.342716,-0.80122471,-1.0382448,0.69929389,1.3427978,-0.80124288,-1.0372997,0.70400121,1.3414074,-0.80121562,-1.0391899,0.7021201,1.3425979,-0.80122471,-1.0401259,0.72375743,1.3431886,-0.80114292,-1.0382448,0.69647676,1.3437066,-0.80126106,-1.0391899,0.69553166,1.3436611,-0.80126106,-1.0391899,0.69647676,1.3414801,-0.80125197,-1.0391899,0.69929389,1.3444517,-0.80125197,-1.041071,0.70869945,1.3446153,-0.80120653,-1.041071,0.70023899,1.3458421,-0.80125197,-1.0401259,0.701175,1.346769,-0.80125197,-1.041071,0.70964455,1.3461147,-0.80121562,-1.0382448,0.67295832,1.3456513,-0.80136102,-1.0382448,0.67013211,1.3457967,-0.80137919,-1.0382448,0.67107721,1.3459421,-0.80137011,-1.0391899,0.67672054,1.3457603,-0.80135193,-1.0382448,0.67295832,1.3459512,-0.80136102,-1.0391899,0.68236388,1.3453605,-0.80131558,-1.0382448,0.67860165,1.3462783,-0.80134284,-1.0391899,0.68048277,1.3457785,-0.80132467,-1.0391899,0.68048277,1.3458149,-0.80133376,-1.0382448,0.68141878,1.3455422,-0.80132467,-1.0382448,0.67953767,1.3440428,-0.80132467,-1.0382448,0.69365055,1.3434248,-0.80127014,-1.0363637,0.66919609,1.342407,-0.80137011,-1.0372997,0.67577544,1.342089,-0.80133376,-1.0372997,0.66919609,1.3426524,-0.80137011,-1.0372997,0.67295832,1.342507,-0.80135193,-1.0372997,0.67483943,1.3411166,-0.80134284,-1.0372997,0.67483943,1.3398444,-0.80133376,-1.0372997,0.67765655,1.3411075,-0.80133376,-1.0372997,0.67107721,1.3417891,-0.80136102,-1.0372997,0.67765655,1.3425343,-0.80133376,-1.0363637,0.67295832,1.3414256,-0.80135193,-1.0363637,0.67107721,1.3392719,-0.80135193,-1.0363637,0.66825099,1.3391537,-0.80136102,-1.0372997,0.67483943,1.3416982,-0.80134284,-1.0382448,0.69647676,1.3420799,-0.80125197,-1.0372997,0.66919609,1.3438156,-0.80137011,-1.0382448,0.67201322,1.3449879,-0.80136102,-1.0372997,0.66919609,1.3432794,-0.80137011,-1.0372997,0.67107721,1.3447789,-0.80136102,-1.0372997,0.67013211,1.3443063,-0.80137011,-1.0372997,0.67013211,1.3442972,-0.80137011,-1.0372997,0.67483943,1.3456058,-0.80135193,-1.0372997,0.67295832,1.3476323,-0.80137011,-1.0391899,0.67953767,1.3458239,-0.80133376,-1.0372997,0.65132099,1.3495316,-0.80146098,-1.0382448,0.67672054,1.3473415,-0.80135193,-1.0175526,0.0530092,1.3501768,-0.80372377,-1.0297753,0.48669187,1.3493953,-0.80213346,-1.0448333,0.30324255,1.3502677,-0.80295133,-1.0438882,0.30983098,1.3467781,-0.80292407,-0.94793327,-0.77390769,1.3553749,-0.80706797,-0.94887837,-0.77390769,1.3555476,-0.80706797,-0.94887837,-0.77390769,1.3562564,-0.80706797,-0.94887837,-0.7748437,1.3552386,-0.80706797,-0.94887837,-0.7748437,1.3568289,-0.80706797,-0.94887837,-0.7748437,1.3567289,-0.80706797,-0.94887837,-0.7748437,1.3541117,-0.80706797,-0.94887837,-0.7748437,1.3557293,-0.80706797,-0.94793327,-0.77390769,1.3530394,-0.80706797,-0.94887837,-0.7748437,1.3540481,-0.80706797,-0.94793327,-0.77390769,1.3499587,-0.80706797,-0.94793327,-0.77390769,1.3535756,-0.80706797,-0.94887837,-0.7748437,1.3536755,-0.80706797,-0.94887837,-0.7748437,1.3534393,-0.80706797,-0.94793327,-0.7748437,1.3516218,-0.80706797,-0.94793327,-0.7748437,1.3520216,-0.80706797,-0.94793327,-0.7748437,1.350813,-0.80706797,-0.94887837,-0.7748437,1.3528849,-0.80706797,-0.94793327,-0.7748437,1.3532484,-0.80706797,-0.94793327,-0.7748437,1.351958,-0.80706797,-0.94793327,-0.7748437,1.353312,-0.80706797,-0.94887837,-0.7748437,1.3539754,-0.80706797,-0.94887837,-0.7748437,1.3540209,-0.80706797,-0.94887837,-0.7748437,1.353521,-0.80706797,-0.94887837,-0.7748437,1.3540118,-0.80706797,-0.94887837,-0.7748437,1.3540209,-0.80706797,-0.94887837,-0.77390769,1.3533666,-0.80706797,-0.94887837,-0.7748437,1.3555385,-0.80706797,-0.94887837,-0.7748437,1.3567471,-0.80706797,-0.94887837,-0.7748437,1.3556021,-0.80706797,-0.94981439,-0.7748437,1.3587464,-0.80706797,-0.94981439,-0.7748437,1.3599732,-0.80706797,-0.94981439,-0.7748437,1.3603639,-0.80706797,-0.94981439,-0.7748437,1.36349,-0.80706797,-0.95075949,-0.7748437,1.3655983,-0.80706797,-0.95075949,-0.7748437,1.3667161,-0.80706797,-0.95075949,-0.7748437,1.3661163,-0.80706797,-0.95075949,-0.7748437,1.3656074,-0.80706797,-0.95075949,-0.7748437,1.3656529,-0.80706797,-0.95075949,-0.7748437,1.3664253,-0.80706797,-1.0335375,-0.016610123,1.3642988,-0.80408727,-1.0438882,0.69459565,1.360891,-0.80131558,-1.0213148,-0.13420235,1.3655438,-0.80445986,-1.041071,0.65037589,1.3633901,-0.80150642,-1.041071,0.66636988,1.363281,-0.80143372,-1.0429522,0.66354367,1.3631901,-0.80145189,-1.041071,0.66260766,1.3617816,-0.80145189,-1.041071,0.69647676,1.3589917,-0.80129741,-1.041071,0.67577544,1.359537,-0.80138828,-1.0420071,0.67953767,1.3589372,-0.80137011,-1.0429522,0.68329989,1.3605457,-0.80136102,-1.0420071,0.69647676,1.3588554,-0.80129741,-1.0429522,0.70023899,1.3592371,-0.80128832,-1.0420071,0.69741278,1.3591826,-0.80129741,-1.0420071,0.69929389,1.3584828,-0.80128832,-1.0420071,0.69271454,1.3584101,-0.80131558,-1.0420071,0.69459565,1.3592007,-0.80130649,-1.0429522,0.68988833,1.3598732,-0.80133376,-1.0429522,0.69553166,1.3610455,-0.80131558,-1.0429522,0.69647676,1.360891,-0.80130649,-1.0438882,0.71246167,1.3609637,-0.80124288,-1.0438882,0.69553166,1.3613454,-0.80130649,-1.0438882,0.70400121,1.360582,-0.80127014,-1.0429522,0.69553166,1.3618725,-0.80131558,-1.0438882,0.69835788,1.3618088,-0.80130649,-1.0438882,0.69929389,1.3623995,-0.80129741,-1.0438882,0.69271454,1.3662072,-0.80133376,-1.0457693,0.69835788,1.36608,-0.80131558,-1.0448333,0.69741278,1.3674976,-0.80132467,-1.0438882,0.701175,1.367334,-0.80130649,-1.0438882,0.69459565,1.3665071,-0.80133376,-1.0448333,0.70023899,1.3683246,-0.80131558,-1.0485955,0.76891321,1.3677157,-0.80102478,-1.0457693,0.71905011,1.3675885,-0.80123379,-1.0457693,0.70400121,1.3662799,-0.80128832,-1.0457693,0.7021201,1.3667797,-0.80129741,-1.0448333,0.70493722,1.3655347,-0.80128832,-1.0438882,0.69929389,1.3676248,-0.80131558,-1.0457693,0.71435187,1.3674976,-0.80125197,-1.0448333,0.70400121,1.3688698,-0.80129741,-1.0457693,0.7021201,1.367325,-0.80129741,-1.0448333,0.70305611,1.3672977,-0.80129741,-1.0457693,0.7021201,1.3669796,-0.80129741,-1.0457693,0.70023899,1.3692061,-0.80131558,-1.0448333,0.70588232,1.3665343,-0.80127923,-1.0448333,0.70493722,1.36608,-0.80128832,-1.0476504,0.71999521,1.3660981,-0.80122471,-1.0448333,0.701175,1.3667888,-0.80130649,-1.0457693,0.70493722,1.366498,-0.80128832,-1.0448333,0.70023899,1.364526,-0.80130649,-1.0438882,0.7021201,1.3657619,-0.80129741,-1.0448333,0.70964455,1.3662345,-0.80127014,-1.0438882,0.70493722,1.3651621,-0.80128832,-1.0448333,0.71905011,1.3652167,-0.80122471,-1.0448333,0.71340677,1.3639989,-0.80124288,-1.0438882,0.71340677,1.3628266,-0.80124288,-1.0467144,0.72657456,1.3638535,-0.80118836,-1.0448333,0.71528788,1.3633992,-0.80124288,-1.0438882,0.71435187,1.3632992,-0.80124288,-1.0457693,0.717169,1.3621996,-0.80122471,-1.0457693,0.71435187,1.3622269,-0.80124288,-1.0457693,0.71528788,1.3631356,-0.80123379,-1.0467144,0.7021201,1.3626176,-0.80128832,-1.0448333,0.70776344,1.3622269,-0.80126106,-1.0457693,0.70869945,1.3624631,-0.80126106,-1.0457693,0.72093122,1.3632628,-0.80120653,-1.0448333,0.69647676,1.3638081,-0.80131558,-1.0438882,0.67860165,1.3656256,-0.80139737,-1.0448333,0.66919609,1.3654257,-0.80143372,-1.0438882,0.66730589,1.3662617,-0.80144281,-1.0448333,0.66919609,1.3658528,-0.80143372,-1.0438882,0.67201322,1.366707,-0.80142463,-1.0448333,0.66825099,1.3674067,-0.80144281,-1.0448333,0.68141878,1.3649986,-0.80137919,-1.0448333,0.67577544,1.3657074,-0.80140646,-1.0438882,0.67389433,1.365871,-0.80141554,-1.0438882,0.67483943,1.367225,-0.80141554,-1.0429522,0.66542478,1.3644533,-0.80144281,-1.0420071,0.67577544,1.3588827,-0.80138828,-1.0438882,0.6861261,1.3629175,-0.80135193,-1.0438882,0.67953767,1.3639444,-0.80138828,-1.0448333,0.68800721,1.3628357,-0.80134284,-1.0438882,0.67201322,1.3631811,-0.80141554,-1.0438882,0.67389433,1.3638899,-0.80140646,-1.0448333,0.67389433,1.365044,-0.80140646,-1.0448333,0.67483943,1.3640535,-0.80140646,-1.0448333,0.67483943,1.3645896,-0.80140646,-1.0438882,0.67672054,1.3630357,-0.80139737,-1.0438882,0.67389433,1.3645442,-0.80140646,-1.0448333,0.67577544,1.3644715,-0.80140646,-1.0438882,0.67389433,1.3642261,-0.80140646,-1.057056,0.49985965,1.3634173,-0.80217889,-1.057056,0.51209143,1.3649349,-0.80213346,-1.0561199,0.49515233,1.3649622,-0.80220616,-1.057056,0.50455789,1.3648713,-0.80216072,-1.057056,0.49609743,1.3641898,-0.80219707,-1.057056,0.49891456,1.3639171,-0.80218798,-1.057056,0.49891456,1.3647986,-0.80218798,-1.0580011,0.50550299,1.3678702,-0.80216981,-1.0589371,0.50926522,1.3677157,-0.80215163,-1.0580011,0.51302744,1.3667524,-0.80213346,-1.0589371,0.51209143,1.3687699,-0.80214254,-1.0580011,0.51302744,1.3684791,-0.80214254,-1.0580011,0.5083292,1.3688517,-0.80216072,-1.0589371,0.51490855,1.3673613,-0.80213346,-1.0589371,0.52996654,1.366598,-0.80206076,-1.0580011,0.51585365,1.3667524,-0.80212437,-1.0580011,0.51585365,1.3668433,-0.80212437,-1.0580011,0.51490855,1.366807,-0.80212437,-1.0580011,0.51021032,1.3677702,-0.80215163,-1.0580011,0.50926522,1.3669524,-0.80215163,-1.057056,0.51021032,1.3669796,-0.80214254,-1.0580011,0.51302744,1.3673613,-0.80213346,-1.0580011,0.5073841,1.3684882,-0.80216072,-1.0589371,0.51397254,1.3689698,-0.80213346,-1.0580011,0.50362188,1.369197,-0.80217889,-1.057056,0.50362188,1.3681065,-0.80217889,-1.0580011,0.50079567,1.3716324,-0.80219707,-1.0580011,0.50362188,1.3682246,-0.80217889,-1.057056,0.49421632,1.3681974,-0.80221524,-1.0580011,0.50362188,1.3682337,-0.80217889,-1.0580011,0.49515233,1.3700876,-0.80221524,-1.0580011,0.49421632,1.3702057,-0.80221524,-1.057056,0.49045409,1.3696695,-0.80223342,-1.057056,0.48950899,1.3700149,-0.80223342,-1.0580011,0.49985965,1.3686881,-0.80218798,-1.057056,0.49045409,1.3680883,-0.80223342,-1.057056,0.48762788,1.3698695,-0.80225159,-1.0561199,0.48103945,1.367743,-0.80226977,-1.057056,0.48481076,1.3689334,-0.80225159,-1.057056,0.49233521,1.3675521,-0.80222433,-1.0580011,0.49891456,1.3692969,-0.80219707,-1.0580011,0.49797854,1.3706055,-0.80220616,-1.0580011,0.50174077,1.371278,-0.80218798,-1.0457693,0.68706212,1.3703693,-0.80137919,-1.0457693,0.69176944,1.3687971,-0.80135193,-1.0467144,0.69553166,1.3701603,-0.80134284,-1.0514126,0.78208099,1.3702511,-0.80097934,-1.0514126,0.75385523,1.3703784,-0.80109748,-1.0485955,0.71246167,1.3726321,-0.80127923,-1.0532937,0.80183722,1.3705601,-0.80089756,-1.0485955,0.72093122,1.3696514,-0.80123379,-1.0457693,0.70400121,1.3698149,-0.80130649,-1.0467144,0.70681834,1.3699967,-0.80128832,-1.0457693,0.69835788,1.3675885,-0.80131558,-1.0457693,0.69929389,1.3664162,-0.80131558,-1.0467144,0.70776344,1.367743,-0.80127923,-1.0467144,0.71058056,1.3683791,-0.80127014,-1.0467144,0.72845567,1.3657074,-0.80118836,-1.0485955,0.750093,1.365462,-0.80109748,-1.0457693,0.67953767,1.3648441,-0.80138828,-1.0457693,0.7021201,1.365153,-0.80129741,-1.0448333,0.67860165,1.3657801,-0.80138828,-1.0467144,0.69459565,1.3669705,-0.80133376,-1.0448333,0.68048277,1.3668433,-0.80138828,-1.0467144,0.69929389,1.3660164,-0.80130649,-1.0467144,0.70681834,1.3641807,-0.80127014,-1.0457693,0.70493722,1.3644897,-0.80127923,-1.0467144,0.71340677,1.364008,-0.80124288,-1.0457693,0.6861261,1.365562,-0.80136102,-1.0448333,0.68988833,1.365253,-0.80134284,-1.0457693,0.70869945,1.363799,-0.80126106,-1.0467144,0.717169,1.3628266,-0.80122471,-1.0589371,0.52996654,1.3657801,-0.80206076,-1.0598822,0.55159478,1.3652803,-0.80196988,-1.0580011,0.52055189,1.3656892,-0.80209711,-1.0580011,0.51773476,1.3653621,-0.80210619,-1.0580011,0.52431411,1.3662435,-0.80208802,-1.057056,0.51490855,1.3647078,-0.80212437,-1.0589371,0.522433,1.3660527,-0.80209711,-1.0589371,0.5233781,1.367643,-0.80209711,-1.0580011,0.52055189,1.3660709,-0.80210619,-1.0589371,0.52619522,1.3682428,-0.80208802,-1.0589371,0.52149699,1.3678702,-0.80209711,-1.0589371,0.53090255,1.3670069,-0.80206076,-1.0589371,0.53184765,1.3661708,-0.80206076,-1.0589371,0.53560987,1.3664707,-0.80204258,-1.0598822,0.54313432,1.3666979,-0.80201532,-1.0589371,0.52431411,1.3670432,-0.80208802,-1.0589371,0.52525921,1.366607,-0.80207893,-1.0580011,0.522433,1.3658073,-0.80209711,-1.0589371,0.52902144,1.3671523,-0.80206984,-1.0589371,0.52149699,1.3670251,-0.80209711,-1.0589371,0.5233781,1.3677157,-0.80209711,-1.0608182,0.55536609,1.3664435,-0.80196079,-1.0589371,0.52525921,1.3678157,-0.80208802,-1.0580011,0.51961588,1.3668706,-0.80210619,-1.057056,0.51397254,1.3654893,-0.80213346,-1.057056,0.51302744,1.366289,-0.80213346,-1.0580011,0.51021032,1.3664162,-0.80214254,-1.0580011,0.50926522,1.3654438,-0.80215163,-1.0580011,0.51397254,1.3664435,-0.80213346,-1.0580011,0.51773476,1.3664253,-0.80211528,-1.0561199,0.5073841,1.365153,-0.80215163,-1.0580011,0.53560987,1.3654166,-0.80204258,-1.057056,0.5083292,1.3650894,-0.80215163,-1.057056,0.50926522,1.3640171,-0.80214254,-1.0580011,0.52807634,1.3639808,-0.80206984,-1.0580011,0.51397254,1.3657892,-0.80212437,-1.0580011,0.51114633,1.3665343,-0.80214254,-1.0589371,0.55253988,1.3659164,-0.80196988,-1.0580011,0.51773476,1.3667706,-0.80211528,-1.0580011,0.51773476,1.367434,-0.80211528,-1.057056,0.51302744,1.3644897,-0.80212437,-1.0589371,0.52431411,1.3674885,-0.80208802,-1.0589371,0.51585365,1.3685245,-0.80212437,-1.0589371,0.51961588,1.3691697,-0.80211528,-1.057056,0.51490855,1.368052,-0.80213346,-1.0589371,0.5233781,1.3690061,-0.80209711,-1.0589371,0.5233781,1.3693424,-0.80209711,-1.0598822,0.54407033,1.3690698,-0.80201532,-1.0589371,0.5233781,1.369824,-0.80209711,-1.0589371,0.52431411,1.3707237,-0.80209711,-1.0589371,0.51961588,1.3704238,-0.80211528,-1.0598822,0.52431411,1.3719232,-0.80210619,-1.0589371,0.51773476,1.3712053,-0.80212437,-1.0589371,0.52431411,1.3692788,-0.80209711,-1.0495315,0.74068744,1.3673613,-0.80113383,-1.0504766,0.750093,1.3660436,-0.80110657,-1.0495315,0.7350441,1.3671614,-0.80116109,-1.0485955,0.717169,1.3699331,-0.80124288,-1.0523577,0.77361145,1.3708873,-0.80101569,-1.0523577,0.78490721,1.3688426,-0.80096117,-1.0485955,0.72940077,1.367852,-0.80118836,-1.0476504,0.70681834,1.3663799,-0.80127014,-1.0457693,0.68424499,1.3655711,-0.80136102,-1.0467144,0.70776344,1.3665253,-0.80127014,-1.0467144,0.69835788,1.3667615,-0.80130649,-1.0467144,0.70588232,1.3685063,-0.80128832,-1.0467144,0.70776344,1.3672432,-0.80127014,-1.0467144,0.70776344,1.3672432,-0.80127014,-1.0467144,0.70776344,1.3672432,-0.80127014,-1.0467144,0.70776344,1.3672432,-0.80127014,-1.0467144,0.70776344,1.3672432,-0.80127014,-1.0467144,0.70776344,1.3672432,-0.80127014,-1.0467144,0.70776344,1.3672432,-0.80127014:4
-0.77330688,0.28559655,1.5454403,-0.93118036,-0.69828721,0.54325602,1.5425887,-0.93005225,-0.71459265,0.47585112,1.5402802,-0.93034472,-0.77439321,0.27037744,1.5407398,-0.93124304,-0.77547955,0.2692911,1.5413875,-0.93124304,-0.75807732,0.33452333,1.5428185,-0.93096101,-0.77330688,0.28776922,1.5399564,-0.93116992,-0.80265877,0.18449443,1.5396744,-0.93161907,-0.8070041,0.18013865,1.5398833,-0.93163997,-0.8004861,0.18232176,1.5422544,-0.93161907,-0.79178499,0.22036432,1.5411368,-0.93146239,-0.7689511,0.31060311,1.5403325,-0.93106546,-0.75264566,0.35843311,1.5414188,-0.93085655,-0.73416754,0.41497467,1.5414083,-0.93061631,-0.77765221,0.2758091,1.5431214,-0.93122214,-0.75590466,0.34974245,1.5393192,-0.93089833,-0.77982488,0.26494577,1.5394968,-0.93126393,-0.78852599,0.24211188,1.539267,-0.93136838,-0.79504399,0.21927799,1.5388805,-0.9314415,-0.78199755,0.26385944,1.5397893,-0.93127437,-0.79721666,0.21058732,1.5395908,-0.93150417,-0.79613033,0.21167366,1.5400609,-0.93149373,-0.7656921,0.31494844,1.5394237,-0.93104457,-0.79613033,0.21167366,1.5219901,-0.93145195,-0.80157244,0.1899261,1.5396326,-0.93158774,-0.80265877,0.19101243,1.5402802,-0.93158774,-0.80157244,0.19427143,1.5384418,-0.9315564,-0.80157244,0.19101243,1.5409905,-0.93158774,-0.79069866,0.22254743,1.5404474,-0.93145195,-0.79287133,0.22145066,1.5419828,-0.93145195,-0.80157244,0.19209876,1.541471,-0.93157729,-0.8004861,0.18883976,1.5425991,-0.93159818,-0.80157244,0.18883976,1.5413039,-0.93159818,-0.80157244,0.1931851,1.5414919,-0.93157729,-0.71350632,0.4834659,1.5398937,-0.93031339,-0.71459265,0.48563857,1.5433825,-0.93030294,-0.75481832,0.34539711,1.5461715,-0.93091923,-0.68849976,0.56391724,1.544072,-0.92995824,-0.70045987,0.51390413,1.5430483,-0.93017759,-0.67872276,0.58348169,1.5417008,-0.92987467,-0.70263254,0.51607679,1.5408965,-0.93016715,-0.69611454,0.52803691,1.5432676,-0.93011492,-0.69937354,0.51390413,1.5401235,-0.93017759,-0.69502821,0.53238224,1.5389328,-0.93007314,-0.68741343,0.54868769,1.5396117,-0.93002091,-0.67872276,0.57478058,1.5404474,-0.92990601,-0.69176921,0.53020957,1.5406667,-0.93010448,-0.69394187,0.52803691,1.5414188,-0.93011492,-0.69176921,0.53238224,1.5403742,-0.93009403,-0.69067243,0.53346857,1.5416277,-0.93009403,-0.69502821,0.53129591,1.5425051,-0.93010448,-0.79178499,0.20731788,1.5426827,-0.93151462,-0.76026043,0.32364955,1.5414815,-0.93101323,-0.79287133,0.20950099,1.5426827,-0.93150417,-0.79504399,0.20188621,1.5428289,-0.93153551,-0.79395766,0.19971354,1.5419933,-0.93154596,-0.79069866,0.21384632,1.5409383,-0.93148328,-0.78417021,0.23776655,1.541659,-0.93137883,-0.79613033,0.19536821,1.5402907,-0.93156685,-0.79395766,0.20079988,1.542432,-0.93154596,-0.79395766,0.20514521,1.5416799,-0.93152506,-0.79504399,0.19536821,1.5422335,-0.93156685,-0.79613033,0.19862721,1.5418157,-0.9315564,-0.79721666,0.19427143,1.5406145,-0.93156685,-0.79721666,0.19536821,1.5414919,-0.93156685,-0.79721666,0.19862721,1.540604,-0.9315564,-0.79938933,0.19101243,1.541565,-0.93158774,-0.79721666,0.19536821,1.542714,-0.93156685,-0.7624331,0.31712111,1.5413457,-0.93103413,-0.79613033,0.19862721,1.5418993,-0.9315564,-0.8004861,0.1899261,1.5410428,-0.93158774,-0.79721666,0.19862721,1.5387552,-0.93153551,-0.77003743,0.28776922,1.5401862,-0.93116992,-0.79613033,0.19754088,1.5399982,-0.9315564,-0.79938933,0.18775343,1.54262,-0.93159818,-0.75590466,0.336696,1.5404265,-0.93095056,-0.79504399,0.20188621,1.5405518,-0.93153551,-0.79721666,0.1931851,1.5388596,-0.9315564,-0.77330688,0.27799222,1.5401549,-0.9312117,-0.77765221,0.26494577,1.5405936,-0.93126393,-0.76351943,0.31386211,1.5407294,-0.93105502,-0.79721666,0.19536821,1.5407607,-0.93156685,-0.79938933,0.1899261,1.5404787,-0.93158774,-0.79613033,0.19862721,1.5418888,-0.9315564,-0.77765221,0.26276266,1.5411577,-0.93127437,-0.79938933,0.1899261,1.5371361,-0.93156685,-0.8004861,0.18883976,1.5384105,-0.93157729,-0.79938933,0.19101243,1.5384418,-0.93156685,-0.79830299,0.19427143,1.5405832,-0.93156685,-0.79938933,0.1931851,1.5386194,-0.9315564,-0.79830299,0.19754088,1.5361438,-0.93153551,-0.79830299,0.1931851,1.5368228,-0.9315564,-0.79938933,0.18883976,1.5355484,-0.93157729,-0.79287133,0.21058732,1.5379927,-0.93148328,-0.79613033,0.19754088,1.5398729,-0.9315564,-0.78091121,0.24862988,1.5390268,-0.93131615,-0.78634288,0.23668021,1.5382747,-0.93136838,-0.79069866,0.21493266,1.5357887,-0.93146239,-0.79938933,0.19209876,1.5373659,-0.9315564,-0.79613033,0.19427143,1.538703,-0.93154596,-0.79830299,0.19101243,1.5377524,-0.93156685,-0.79830299,0.1899261,1.5376584,-0.93156685,-0.76460577,0.30734411,1.5366556,-0.93105502,-0.78525655,0.24102555,1.5354231,-0.93134749,-0.79613033,0.20188621,1.537648,-0.93151462,-0.79830299,0.19101243,1.5366243,-0.93156685,-0.79721666,0.19645454,1.5362483,-0.93154596,-0.79938933,0.18775343,1.5372824,-0.93157729,-0.79287133,0.21493266,1.5384523,-0.93146239,-0.79287133,0.20950099,1.5417426,-0.93150417,-0.77982488,0.25624466,1.5401549,-0.93130571,-0.79504399,0.20731788,1.5426514,-0.93151462,-0.77765221,0.26385944,1.5420037,-0.93127437,-0.79830299,0.20188621,1.5393506,-0.93153551,-0.79938933,0.1931851,1.5410219,-0.93157729,-0.78961233,0.22254743,1.5375957,-0.93143106,-0.78852599,0.22580643,1.5400295,-0.93143106,-0.79178499,0.21601899,1.5380658,-0.93145195,-0.79830299,0.19862721,1.538494,-0.93153551,-0.77547955,0.2660321,1.5364363,-0.93123259,-0.79178499,0.21384632,1.539549,-0.93148328,-0.79830299,0.20079988,1.537554,-0.93152506,-0.79287133,0.21058732,1.5396744,-0.93150417,-0.79721666,0.20188621,1.536969,-0.93151462,-0.79613033,0.20297254,1.5416173,-0.93153551,-0.79613033,0.20079988,1.5403533,-0.93154596,-0.76677843,0.301902,1.5410428,-0.93110724,-0.77656588,0.2725501,1.5427558,-0.93123259,-0.79178499,0.22036432,1.5413352,-0.93146239,-0.79613033,0.20405888,1.5432468,-0.93152506,-0.79613033,0.20514521,1.5411577,-0.93152506,-0.79504399,0.20840421,1.5448763,-0.93151462,-0.79504399,0.20623154,1.5424947,-0.93151462,-0.79395766,0.20514521,1.5420769,-0.93152506,-0.79178499,0.21493266,1.5423067,-0.93148328,-0.79178499,0.20623154,1.4987071,-0.93143106,-0.79395766,0.20297254,1.5401131,-0.93153551,-0.79178499,0.21058732,1.5312031,-0.93148328,-0.79287133,0.20840421,1.5243195,-0.93147284,-0.79613033,0.20079988,1.541471,-0.93154596,-0.79613033,0.20297254,1.5408443,-0.93153551,-0.79613033,0.20405888,1.5374391,-0.93150417,-0.79395766,0.20405888,1.5369377,-0.93150417,-0.78417021,0.23885288,1.5369481,-0.93135794,-0.78961233,0.21819166,1.5374808,-0.9314415,-0.79395766,0.1931851,1.4950825,-0.93147284,-0.79830299,0.1931851,1.5352768,-0.9315564,-0.79178499,0.20188621,1.495375,-0.93143106,-0.79721666,0.1931851,1.5385149,-0.9315564,-0.79178499,0.20950099,1.5397997,-0.93150417,-0.79287133,0.20079988,1.539173,-0.93152506,-0.79613033,0.1931851,1.538494,-0.9315564,-0.79178499,0.21275999,1.5389432,-0.93147284,-0.79938933,0.1899261,1.5388387,-0.93156685,-0.8004861,0.18558076,1.5390894,-0.93158774,-0.8004861,0.18775343,1.5385045,-0.93157729,-0.79830299,0.18775343,1.5372092,-0.93157729,-0.79938933,0.1866671,1.5358513,-0.93158774,-0.79721666,0.1899261,1.5355484,-0.93156685,-0.78852599,0.21710532,1.5345456,-0.93145195,-0.79721666,0.1931851,1.534953,-0.9315564,-0.79069866,0.21493266,1.5337413,-0.93146239,-0.78961233,0.21167366,1.5331564,-0.93147284,-0.77547955,0.26058999,1.5322267,-0.93126393,-0.79069866,0.21058732,1.5282052,-0.93146239,-0.79287133,0.20514521,1.5301585,-0.93150417,-0.7624331,0.30298833,1.5306808,-0.93107591,-0.79395766,0.20405888,1.5297198,-0.93150417,-0.79287133,0.20840421,1.5305868,-0.93149373,-0.77547955,0.26167633,1.5302734,-0.93125348,-0.78308388,0.24102555,1.5299601,-0.93134749,-0.78199755,0.24537088,1.5312971,-0.9313266,-0.78308388,0.24211188,1.5324148,-0.93133705,-0.70481565,0.49215657,1.5307226,-0.93024027,-0.77439321,0.26385944,1.5299914,-0.93124304,-0.77873855,0.25189933,1.531224,-0.93129526,-0.77112377,0.27472277,1.5278501,-0.93118036,-0.77982488,0.25407199,1.5295005,-0.93128482,-0.77982488,0.25189933,1.5285708,-0.93127437,-0.78091121,0.24645721,1.5298661,-0.9313266,-0.77982488,0.24862988,1.5298243,-0.93131615,-0.69828721,0.52150846,1.531788,-0.93011492,-0.74503088,0.36930689,1.5320387,-0.93078343,-0.78091121,0.25081299,1.5330519,-0.93130571,-0.77330688,0.26711844,1.5296049,-0.93123259,-0.7624331,0.30408511,1.5296258,-0.93106546,-0.7624331,0.30517144,1.5303674,-0.93106546,-0.75264566,0.339955,1.5284455,-0.93088789,-0.75916366,0.31930422,1.5305972,-0.93100279,-0.72003476,0.43888445,1.5303674,-0.93048051,-0.75590466,0.32473589,1.5294691,-0.9309819,-0.72546643,0.42366534,1.5303883,-0.93054319,-0.77656588,0.25515833,1.5300959,-0.93128482,-0.77656588,0.25733099,1.5302212,-0.93127437,-0.77873855,0.25515833,1.5295736,-0.93128482,-0.78199755,0.24972666,1.528529,-0.93128482,-0.77873855,0.25407199,1.528529,-0.93126393,-0.77873855,0.25624466,1.5268473,-0.93125348,-0.7689511,0.28233755,1.5298869,-0.93116992,-0.77873855,0.25298566,1.5273069,-0.93127437,-0.77873855,0.24972666,1.5296989,-0.93130571,-0.77656588,0.25081299,1.5297094,-0.93130571,-0.77439321,0.25950366,1.5293229,-0.93126393,-0.77873855,0.25081299,1.5302734,-0.93130571,-0.77873855,0.24972666,1.5292289,-0.93130571,-0.77656588,0.24862988,1.5299287,-0.93130571,-0.77982488,0.24428455,1.5288842,-0.9313266,-0.78091121,0.24428455,1.5281112,-0.93130571,-0.77982488,0.25298566,1.5306704,-0.93129526,-0.74285821,0.27146377,1.5271293,-0.93116992,-0.78199755,0.19536821,1.5286648,-0.93151462,-0.73742654,0.23776655,1.5293647,-0.9313266,-0.73416754,0.23776655,1.5320074,-0.9313266,-1.0407329,-0.87006367,1.5354335,-0.93584951,-1.0407329,-0.87006367,1.5371152,-0.93584951,-1.0407329,-0.87115,1.5374391,-0.93585995,-1.0407329,-0.87115,1.536687,-0.93585995,-1.0418192,-0.87115,1.5381389,-0.93584951,-1.0407329,-0.87115,1.5363632,-0.93585995,-1.0407329,-0.87006367,1.5353604,-0.93584951,-1.0407329,-0.87115,1.5363423,-0.93585995,-1.0407329,-0.87115,1.5364885,-0.93585995,-1.0407329,-0.87223633,1.5371466,-0.93585995,-1.0418192,-0.87223633,1.5379195,-0.93584951,-1.0418192,-0.87223633,1.5379927,-0.93584951,-1.0418192,-0.87115,1.5401862,-0.93584951,-1.0418192,-0.87223633,1.5379927,-0.93584951,-1.0418192,-0.87332267,1.5369168,-0.93585995,-1.0418192,-0.87332267,1.5362796,-0.93585995,-1.0418192,-0.87332267,1.5349635,-0.93585995,-1.0418192,-0.87332267,1.5347754,-0.93585995,-1.0418192,-0.87223633,1.5347337,-0.93584951,-1.0418192,-0.87332267,1.5329684,-0.93585995,-1.0418192,-0.87332267,1.5304301,-0.93585995,-1.0418192,-0.87223633,1.5325923,-0.93584951,-1.0407329,-0.87223633,1.532937,-0.93585995,-1.0418192,-0.87332267,1.5327595,-0.93585995,-1.0418192,-0.87332267,1.5317358,-0.93585995,-1.0418192,-0.87332267,1.5339085,-0.93585995,-1.0418192,-0.87332267,1.5295422,-0.93585995,-1.0418192,-0.87332267,1.5301899,-0.93585995,-1.0418192,-0.87332267,1.5303048,-0.93585995,-1.0418192,-0.87332267,1.5290095,-0.93585995,-1.0418192,-0.874409,1.5278187,-0.93585995,-0.68415443,0.5921828,1.5203189,-0.92978066,-0.7722101,0.27690588,1.5204964,-0.93116992,-0.77656588,0.25950366,1.5215514,-0.93124304,-0.77003743,0.28233755,1.5229511,-0.93113858,-0.76786477,0.28668288,1.520956,-0.93112814,-0.76786477,0.28776922,1.5217499,-0.93111769,-0.7624331,0.31168944,1.5228676,-0.93101323,-0.76677843,0.29647033,1.5217394,-0.93108635,-0.76677843,0.28016488,1.4868619,-0.93105502,-0.77873855,0.25189933,1.5237868,-0.93127437,-0.77873855,0.25189933,1.5212798,-0.93127437,-0.77656588,0.25950366,1.5244971,-0.93124304,-0.77439321,0.2660321,1.5243926,-0.9312117,-0.77439321,0.26494577,1.5244971,-0.93122214,-0.76460577,0.29972933,1.5272129,-0.93106546,-0.77330688,0.27146377,1.5271398,-0.93119081,-0.68741343,0.5573888,1.5251133,-0.92993735,-0.67219431,0.58239536,1.5248,-0.92982245,-0.68958609,0.54434235,1.526816,-0.92998957,-0.77765221,0.24862988,1.5260848,-0.93129526,-0.78091121,0.25298566,1.525667,-0.93127437,-0.77982488,0.2758091,1.5263146,-0.93116992,-0.78199755,0.25081299,1.5270249,-0.93128482,-0.77982488,0.24211188,1.5274114,-0.93131615,-0.77765221,0.24754355,1.5275367,-0.93129526,-0.77873855,0.24862988,1.5264817,-0.93128482,-0.78091121,0.24211188,1.5271607,-0.93131615,-0.78091121,0.24211188,1.5271607,-0.93131615,-0.77982488,0.24211188,1.5258132,-0.93131615,-0.77982488,0.24428455,1.5258968,-0.93130571,-0.78091121,0.24211188,1.522878,-0.93131615,-0.77765221,0.24211188,1.5235465,-0.93131615,-0.77873855,0.24211188,1.5233063,-0.93131615,-0.77873855,0.24211188,1.5239017,-0.93131615,-0.77765221,0.24428455,1.522784,-0.93130571,-0.77765221,0.24645721,1.5232123,-0.93129526,-0.77765221,0.24102555,1.5227944,-0.9313266,-0.77982488,0.24211188,1.5249358,-0.93131615,-0.77765221,0.24211188,1.5235987,-0.93131615,-0.76460577,0.2660321,1.5242464,-0.9312117,-0.76026043,0.39539978,1.5231914,-0.93065809,-0.75807732,0.32039055,1.5247791,-0.93097145,-0.72655276,0.35082878,1.5231496,-0.93056408,-0.75807732,0.35517411,1.5236823,-0.93102368,-0.76786477,0.28559655,1.524518,-0.93116992,-0.68415443,0.57369424,1.5230138,-0.92997913,-0.68632709,0.53999702,1.5242777,-0.92998957,-0.68632709,0.53455491,1.5226482,-0.93000002,-0.68306809,0.53999702,1.5224915,-0.92990601,-0.68306809,0.54542869,1.5235987,-0.92995824,-0.6504572,0.65414558,1.5231078,-0.92949864,-0.68089543,0.55304346,1.5238494,-0.9299269,-0.68089543,0.55847513,1.5233481,-0.92993735,-0.65154354,0.65197292,1.5211127,-0.92951953,-0.67653965,0.56282046,1.5223662,-0.92988512,-0.67653965,0.56717624,1.5223348,-0.92986423,-0.67328065,0.56826258,1.5224393,-0.92986423,-0.77003743,0.26494577,1.5256461,-0.93122214,-0.77112377,0.25733099,1.5242359,-0.93123259,-0.7722101,0.26058999,1.5256043,-0.93125348,-0.7722101,0.25841733,1.5270458,-0.93124304,-0.7722101,0.25841733,1.527004,-0.93124304,-0.77439321,0.25733099,1.5275472,-0.93125348,-0.77765221,0.25081299,1.5272442,-0.93128482,-0.77765221,0.25298566,1.5286021,-0.93127437,-0.77656588,0.25407199,1.5298138,-0.93128482,-0.77873855,0.25298566,1.5278814,-0.93127437,-0.68632709,0.54868769,1.5257505,-0.92996868,-0.69067243,0.54108335,1.5250716,-0.93000002,-0.65480254,0.64435814,1.5256147,-0.92954042,-0.66132054,0.60957458,1.5230869,-0.9296971,-0.67980909,0.55304346,1.5199637,-0.92994779,-0.68198176,0.55521613,1.5190863,-0.92993735,-0.77330688,0.24645721,1.5215201,-0.93129526,-0.77439321,0.24102555,1.5212067,-0.93131615,-0.77656588,0.23885288,1.5201622,-0.9313266,-0.77656588,0.24537088,1.5226064,-0.93130571,-0.77982488,0.23885288,1.5237554,-0.93133705,-0.77439321,0.25189933,1.520862,-0.93127437,-0.77112377,0.26167633,1.5223871,-0.93123259,-0.72003476,0.43997079,1.5205487,-0.93044918,-0.75481832,0.31712111,1.5225229,-0.93099234,-0.77765221,0.23776655,1.5226587,-0.93133705,-0.77765221,0.24319821,1.5231391,-0.93131615,-0.77765221,0.25081299,1.5201308,-0.93128482,-0.78091121,0.23341077,1.5205591,-0.93135794,-0.77765221,0.24319821,1.5221886,-0.93131615,-0.77656588,0.24862988,1.5232749,-0.93128482,-0.77765221,0.24428455,1.5240792,-0.93130571,-0.77982488,0.24319821,1.526722,-0.93131615,-0.68524076,0.55521613,1.5248209,-0.92993735,-0.74503088,0.36061622,1.524309,-0.93079388,-0.78199755,0.23232443,1.5253745,-0.93135794,-0.77439321,0.25841733,1.5269935,-0.93124304,-0.77439321,0.25841733,1.5206322,-0.93124304,-0.77547955,0.25407199,1.5183029,-0.93124304,-0.77330688,0.25841733,1.518658,-0.93124304,-0.77656588,0.24754355,1.5218021,-0.93129526,-0.77439321,0.25733099,1.5205069,-0.93125348,-0.74612766,0.34974245,1.5206949,-0.93084611,-0.76786477,0.27690588,1.5209978,-0.93116992,-0.76351943,0.29103866,1.5206322,-0.93110724,-0.76677843,0.28451022,1.5227631,-0.93112814,-0.77112377,0.27037744,1.5211754,-0.93119081,-0.75590466,0.32256322,1.5195563,-0.93096101,-0.76351943,0.28885555,1.5189714,-0.93110724,-0.76134677,0.301902,1.5195459,-0.93105502,-0.73416754,0.38888178,1.5190549,-0.93066853,-0.7276391,0.41714734,1.5179582,-0.9305223,-0.76351943,0.295384,1.5211127,-0.93108635,-0.73851288,0.38018067,1.5198906,-0.93071031,-0.72872543,0.41279156,1.5197861,-0.93056408,-0.7211211,0.43562545,1.5218857,-0.93047007,-0.74394454,0.35734678,1.5215201,-0.93081477,-0.71894843,0.43345279,1.5231914,-0.93047007,-0.74068554,0.37257634,1.5230242,-0.93074165,-0.74068554,0.37257634,1.5230242,-0.93074165,-0.74068554,0.37257634,1.5230242,-0.93074165,-0.74068554,0.37257634,1.5230242,-0.93074165,-0.74068554,0.37257634,1.5230242,-0.93074165,-0.74068554,0.37257634,1.5230242,-0.93074165:4
-1.1117947,0.60367305,1.3338602,-0.80265638,-1.1117947,0.56014189,1.3357482,-0.80285323,-1.1108642,0.51568015,1.3320169,-0.80302324,-1.1117947,0.56755069,1.3313011,-0.8027906,-1.1117947,0.66388295,1.3303258,-0.80242374,-1.1117947,0.63979541,1.3315785,-0.80248637,-1.1108642,0.63609101,1.3301379,-0.80251322,-1.109012,0.58885545,1.3300753,-0.80272796,-1.109012,0.55921131,1.3291536,-0.80284428,-1.109012,0.57959446,1.3305763,-0.8027727,-1.109012,0.58236828,1.3308358,-0.80275481,-1.109012,0.62497782,1.3296279,-0.80257585,-1.1099425,0.62497782,1.3312743,-0.8025669,-1.1099425,0.62312562,1.3314085,-0.80257585,-1.1099425,0.63516939,1.3323659,-0.80252216,-1.1080903,0.51568015,1.3324017,-0.80301429,-1.1080903,0.58515105,1.3305674,-0.80271902,-1.1080903,0.59718588,1.3293415,-0.80268322,-1.1071598,0.53513272,1.3292431,-0.80294271,-1.1071598,0.54995032,1.3300395,-0.80287113,-1.1080903,0.53698492,1.3306927,-0.80293376,-1.1080903,0.53234995,1.3303795,-0.80294271,-1.1071598,0.58792488,1.3295205,-0.80271902,-1.1154991,0.87970446,1.3298695,-0.8015379,-1.1145686,0.85284309,1.3291178,-0.80161843,-1.1117947,0.81208576,1.3288852,-0.80180634,-1.1071598,0.58700325,1.3296547,-0.80273691,-1.1071598,0.51104518,1.3316769,-0.80304114,-1.1080903,0.50827135,1.3317217,-0.80305008,-1.1080903,0.51382795,1.3324912,-0.80303219,-1.1080903,0.51104518,1.3310774,-0.80304114,-1.1201252,0.97048013,1.3300574,-0.80115315,-1.1136469,0.81579016,1.3315427,-0.80180634,-1.1210557,0.9843761,1.3301468,-0.80110841,-1.1136469,0.8306167,1.3319364,-0.8017437,-1.1164208,0.894531,1.3321959,-0.80148422,-1.1136469,0.85469529,1.3266572,-0.80163633,-1.1136469,0.85562587,1.3269256,-0.80162738,-1.1136469,0.85377367,1.3304063,-0.80164528,-1.1108642,0.60460362,1.3333681,-0.80267428,-1.1154991,0.88063503,1.3324106,-0.8015558,-1.118273,0.89266986,1.3336365,-0.80150211,-1.1145686,0.87137404,1.3323033,-0.80159159,-1.1154991,0.89081766,1.3308895,-0.80150211,-1.1099425,0.53605435,1.3336902,-0.80294271,-1.109012,0.53883712,1.3339944,-0.80293376,-1.1080903,0.54716754,1.332527,-0.80289797,-1.109012,0.53142832,1.3325538,-0.80296061,-1.109012,0.53142832,1.3324733,-0.80296061,-1.109012,0.56569849,1.3347729,-0.80282639,-1.109012,0.58144666,1.3351129,-0.8027727,-1.1108642,0.72131009,1.3326522,-0.80219109,-1.1164208,0.84913869,1.3329028,-0.80167212,-1.1164208,0.87878283,1.3318738,-0.80156475,-1.1108642,0.61756902,1.3345223,-0.80262059,-1.1080903,0.58977708,1.3324554,-0.80273691,-1.1238296,1.0742212,1.3300216,-0.80059838,-1.1071598,0.62590839,1.3307821,-0.80257585,-1.109012,0.58515105,1.3320259,-0.80275481,-1.1117947,0.67037013,1.3317753,-0.802379,-1.1080903,0.53420215,1.3322406,-0.80296061,-1.1080903,0.56291571,1.3325807,-0.80284428,-1.1080903,0.56384629,1.3318201,-0.80284428,-1.1071598,0.56014189,1.3317843,-0.80285323,-1.1071598,0.56014189,1.3316769,-0.80285323,-1.1071598,0.55921131,1.3301468,-0.80285323,-1.1071598,0.55735911,1.3312564,-0.80287113,-1.1080903,0.58422048,1.3324375,-0.80275481,-1.1062381,0.56476791,1.3275699,-0.80282639,-1.1080903,0.56847231,1.3298068,-0.80281744,-1.1071598,0.55643749,1.3296726,-0.80286218,-1.1080903,0.55828969,1.3295384,-0.80285323,-1.1071598,0.55458529,1.32961,-0.80287113,-1.1062381,0.57588111,1.3292163,-0.80278165,-1.1071598,0.55828969,1.32927,-0.80285323,-1.1071598,0.55921131,1.3294937,-0.80285323,-1.1071598,0.55828969,1.3295921,-0.80285323,-1.1062381,0.56199409,1.3286705,-0.80283534,-1.1062381,0.55921131,1.3284915,-0.80285323,-1.109012,0.58236828,1.3288942,-0.80274586,-1.1071598,0.56014189,1.3284915,-0.80284428,-1.1071598,0.56106351,1.3291089,-0.80284428,-1.1080903,0.65091756,1.3292163,-0.80247742,-1.1071598,0.56291571,1.3292342,-0.80283534,-1.1071598,0.56291571,1.3290373,-0.80283534,-1.109012,0.71945789,1.3269346,-0.8021732,-1.1062381,0.57774226,1.329091,-0.80278165,-1.1062381,0.55828969,1.3278652,-0.80285323,-1.1062381,0.57125508,1.3293147,-0.80280849,-1.1062381,0.56384629,1.3270509,-0.80282639,-1.1062381,0.56291571,1.3283573,-0.80283534,-1.1062381,0.56476791,1.3279636,-0.80282639,-1.1062381,0.58977708,1.3272299,-0.80271902,-1.1053076,0.55921131,1.3271314,-0.80284428,-1.1062381,0.56755069,1.3290552,-0.80281744,-1.1062381,0.57402891,1.3274625,-0.80278165,-1.1062381,0.57032451,1.3283483,-0.80279955,-1.1062381,0.56291571,1.3271225,-0.80282639,-1.1071598,0.56291571,1.3285094,-0.80283534,-1.1062381,0.56847231,1.3257356,-0.80279955,-1.1053076,0.56476791,1.3260666,-0.80282639,-1.1062381,0.56199409,1.3265588,-0.80283534,-1.1062381,0.57310728,1.3254045,-0.80278165,-1.1062381,0.55828969,1.3257535,-0.80284428,-1.1053076,0.56014189,1.3260756,-0.80284428,-1.1062381,0.56291571,1.326183,-0.80282639,-1.1053076,0.56755069,1.3261919,-0.80280849,-1.1062381,0.56384629,1.3271672,-0.80283534,-1.1071598,0.56847231,1.3295921,-0.80281744,-1.1071598,0.56755069,1.3290194,-0.80281744,-1.1071598,0.56662011,1.3296547,-0.80282639,-1.1080903,0.56199409,1.329091,-0.80284428,-1.1053076,0.56662011,1.3274267,-0.80281744,-1.1062381,0.57310728,1.3292431,-0.80279955,-1.1071598,0.58051608,1.3279188,-0.80275481,-1.1062381,0.56291571,1.3283036,-0.80283534,-1.1053076,0.56199409,1.3276146,-0.80283534,-1.1053076,0.56847231,1.3270598,-0.80280849,-1.1053076,0.56940289,1.3275967,-0.80279955,-1.1053076,0.56940289,1.3289836,-0.80280849,-1.1053076,0.57866388,1.3274714,-0.80276375,-1.1071598,0.56014189,1.3290642,-0.80284428,-1.1062381,0.56569849,1.3274625,-0.80282639,-1.1062381,0.56755069,1.3303705,-0.80281744,-1.1053076,0.56291571,1.3298874,-0.80284428,-1.1062381,0.56476791,1.3297621,-0.80282639,-1.1053076,0.56755069,1.3254671,-0.80280849,-1.1071598,0.56291571,1.3269435,-0.80284428,-1.1062381,0.56662011,1.3271046,-0.80283534,-1.1062381,0.56662011,1.3281694,-0.80282639,-1.1043859,0.59162928,1.3210827,-0.80271007,-1.1043859,0.55735911,1.3215569,-0.80285323,-1.1043859,0.57588111,1.3223264,-0.80278165,-1.1053076,0.56291571,1.321709,-0.80283534,-1.1062381,0.56291571,1.3254403,-0.80284428,-1.1062381,0.56014189,1.3270867,-0.80286218,-1.1071598,0.55921131,1.3280799,-0.80286218,-1.1062381,0.56476791,1.3265946,-0.80283534,-1.1053076,0.56569849,1.3255119,-0.80283534,-1.1053076,0.55458529,1.324456,-0.80287113,-1.1034554,0.55643749,1.3221117,-0.80286218,-1.1043859,0.56847231,1.3214138,-0.80280849,-1.1053076,0.56476791,1.3212974,-0.80282639,-1.1025248,0.55735911,1.3208501,-0.80284428,-1.1025248,0.56662011,1.3222638,-0.80281744,-1.1062381,0.56199409,1.3202327,-0.80283534,-1.1071598,0.61108185,1.3214138,-0.80263848,-1.1043859,0.58051608,1.3205369,-0.80275481,-1.1043859,0.56569849,1.3217448,-0.80282639,-1.1043859,0.56662011,1.3211722,-0.80281744,-1.1043859,0.57125508,1.3205906,-0.80279955,-1.1053076,0.57217671,1.3224428,-0.80279955,-1.1043859,0.56291571,1.3237044,-0.80284428,-1.1071598,0.57125508,1.3247424,-0.80280849,-1.1062381,0.58329886,1.3216912,-0.80275481,-1.1099425,0.53328052,1.321897,-0.80289797,-1.1303167,0.77966779,1.3196421,-0.80203898,-1.1303167,0.76855459,1.3206174,-0.80208372,-0.95246979,-0.77000577,1.3248587,-0.80815034,-0.95246979,-0.7709274,1.3253866,-0.80815929,-0.95246979,-0.77185797,1.3234091,-0.80815929,-0.95246979,-0.77000577,1.3224965,-0.80815034,-0.95246979,-0.77185797,1.3217448,-0.80815929,-0.95246979,-0.77185797,1.3193826,-0.80815929,-0.95246979,-0.77000577,1.3212796,-0.80815034,-0.95246979,-0.77185797,1.3215659,-0.80815929,-0.95246979,-0.77000577,1.3206622,-0.80815929,-0.95246979,-0.77000577,1.3214585,-0.80815929,-1.1284645,0.72501449,1.3166804,-0.80212846,-1.109012,0.71297966,1.3159288,-0.80213741,-1.1053076,0.57681168,1.3166088,-0.80276375,-1.1080903,0.57588111,1.3180136,-0.80276375,-1.1062381,0.57588111,1.317253,-0.80276375,-1.1053076,0.55458529,1.3172441,-0.80285323,-1.1071598,0.56476791,1.3181747,-0.80280849,-1.1053076,0.60460362,1.3141481,-0.80262954,-1.1053076,0.55550692,1.3160898,-0.80284428,-1.1053076,0.56847231,1.3162061,-0.80279955,-1.1062381,0.56014189,1.3180852,-0.80282639,-1.1062381,0.57310728,1.3169309,-0.80276375,-1.1034554,0.55272414,1.3099248,-0.80284428,-1.1062381,0.69908369,1.3108732,-0.80220899,-1.1062381,0.66388295,1.3168772,-0.80240584,-1.1071598,0.57681168,1.3171993,-0.80275481,-1.1043859,0.56291571,1.3174588,-0.80281744,-1.1043859,0.60552525,1.3165998,-0.80262059,-1.1034554,0.56106351,1.3145955,-0.80281744,-1.1053076,0.57959446,1.3175125,-0.80274586,-1.1053076,0.56476791,1.3167877,-0.80279955,-1.1034554,0.57125508,1.3160003,-0.80278165,-1.1043859,0.56755069,1.3154008,-0.8027906,-1.1053076,0.57959446,1.3162419,-0.80275481,-1.1034554,0.56755069,1.313316,-0.80278165,-1.1043859,0.57588111,1.312806,-0.80275481,-1.1043859,0.57774226,1.3137097,-0.80274586,-1.1062381,0.67963112,1.3137723,-0.80229847,-1.1025248,0.56106351,1.3136381,-0.80281744,-1.1006726,0.55828969,1.3078578,-0.80280849,-1.1025248,0.56106351,1.3131639,-0.80281744,-1.1034554,0.55828969,1.3146045,-0.80282639,-1.1034554,0.56569849,1.3148371,-0.80279955,-1.1043859,0.59996865,1.3158751,-0.80265638,-1.1034554,0.56291571,1.3162956,-0.80281744,-1.1099425,0.81486853,1.3137723,-0.8017437,-1.1043859,0.59533368,1.315714,-0.80267428,-1.1034554,0.56940289,1.3142734,-0.8027906,-1.1034554,0.57217671,1.3132176,-0.8027727,-1.1025248,0.57217671,1.3123675,-0.8027727,-1.1025248,0.57310728,1.308851,-0.80274586,-1.1034554,0.56199409,1.3138797,-0.80280849,-1.1034554,0.56847231,1.315034,-0.8027906,-1.1034554,0.58700325,1.3160003,-0.80271007,-1.1034554,0.56569849,1.314694,-0.80279955,-1.1034554,0.56569849,1.3160719,-0.80279955,-1.1034554,0.56106351,1.3161167,-0.80281744,-1.1034554,0.55921131,1.314685,-0.80282639,-1.1043859,0.57032451,1.3156872,-0.80278165,-1.1025248,0.57217671,1.3159645,-0.8027727,-1.1034554,0.56476791,1.3165193,-0.80280849,-1.1034554,0.58329886,1.3173694,-0.80272796,-1.1025248,0.58885545,1.3153114,-0.80270112,-1.1043859,0.59533368,1.3160719,-0.80267428,-1.1034554,0.55550692,1.3170293,-0.80284428,-1.1034554,0.55735911,1.3167072,-0.80283534,-1.1043859,0.56199409,1.3188189,-0.80282639,-1.1043859,0.58051608,1.3176557,-0.80274586,-1.1034554,0.56847231,1.3159466,-0.8027906,-1.1043859,0.55921131,1.3163225,-0.80282639,-1.1043859,0.55828969,1.3133249,-0.80283534,-1.1062381,0.57681168,1.3128507,-0.80275481,-1.1025248,0.56106351,1.3116517,-0.80281744,-1.1043859,0.66758735,1.310399,-0.802379,-1.118273,1.1047959,1.3079205,-0.80055364,-1.1025248,0.61386462,1.3106764,-0.80259375,-1.1025248,0.56199409,1.3104079,-0.80280849,-1.1025248,0.55921131,1.3096116,-0.80281744,-1.1025248,0.55458529,1.3090121,-0.80283534,-1.1025248,0.57588111,1.3096921,-0.80273691,-1.1025248,0.55921131,1.308681,-0.80281744,-1.1006726,0.55643749,1.3103811,-0.80282639,-1.099751,0.56940289,1.3113206,-0.8027727,-1.1034554,0.68703992,1.30852,-0.80225373,-1.1016032,0.67407453,1.3040639,-0.80231636,-1.1043859,0.66295238,1.3054687,-0.80237005,-1.1062381,0.73242328,1.306462,-0.80207477,-1.1053076,0.66388295,1.3078668,-0.802379,-1.1053076,0.66203076,1.3043234,-0.802379,-1.1025248,0.66017856,1.3045561,-0.802379,-1.1034554,0.66295238,1.3058267,-0.80237005,-1.1053076,0.65924798,1.3071957,-0.80239689,-1.1034554,0.66110018,1.306963,-0.802379,-1.1053076,0.66110018,1.3089047,-0.80238795,-1.1043859,0.65924798,1.3090568,-0.80239689,-1.1053076,0.66017856,1.3076878,-0.80238795,-1.1053076,0.65924798,1.3091016,-0.80239689,-1.1043859,0.67222233,1.3081263,-0.80234321,-1.1025248,0.66295238,1.3072404,-0.80237005,-1.1043859,0.66017856,1.3102021,-0.80239689,-1.1053076,0.65924798,1.3090389,-0.80239689,-1.1043859,0.66388295,1.3095221,-0.802379,-1.1034554,0.66295238,1.3087526,-0.802379,-1.1043859,0.66203076,1.312278,-0.80239689,-1.1034554,0.66295238,1.3120007,-0.80238795,-1.1053076,0.66110018,1.3111327,-0.80239689,-1.1062381,0.66110018,1.3119201,-0.80239689,-1.1062381,0.66851793,1.3115175,-0.80237005,-1.1053076,0.66203076,1.3104974,-0.80239689,-1.1043859,0.65647416,1.3107748,-0.80241479,-1.1053076,0.66758735,1.3098442,-0.80237005,-1.1053076,0.65739578,1.3108553,-0.80241479,-1.1043859,0.66295238,1.3106137,-0.80238795,-1.1053076,0.66203076,1.3105601,-0.80239689,-1.1062381,0.66295238,1.3088779,-0.802379,-1.1053076,0.68425715,1.3090479,-0.80228952,-1.1043859,0.66203076,1.3097816,-0.80238795,-1.1034554,0.65832636,1.3089316,-0.80240584,-1.1025248,0.66480458,1.3083231,-0.802379,-1.1025248,0.65462196,1.3079026,-0.80241479,-1.1062381,0.7611458,1.3073209,-0.80195845,-1.1034554,0.64906536,1.3090747,-0.80245058,-1.1034554,0.65369138,1.3086273,-0.80243268,-1.1034554,0.65924798,1.3082336,-0.80240584,-1.1034554,0.65369138,1.3078936,-0.80242374,-1.1053076,0.70093589,1.3083052,-0.80221794,-1.1043859,0.65739578,1.3087168,-0.80241479,-1.1043859,0.66110018,1.3097637,-0.80239689,-1.1034554,0.65647416,1.3088331,-0.80241479,-1.1053076,0.66851793,1.310229,-0.80237005,-1.1043859,0.66851793,1.3102558,-0.80237005,-1.1053076,0.65924798,1.3091821,-0.80240584,-1.1043859,0.66203076,1.3090479,-0.80239689,-1.1062381,0.67684835,1.3107301,-0.80232531,-1.1062381,0.66388295,1.3104169,-0.80238795,-1.1053076,0.66295238,1.3106943,-0.80238795,-1.1062381,0.66110018,1.3116517,-0.80239689,-1.1043859,0.66203076,1.3098532,-0.80238795,-1.1043859,0.65924798,1.3109717,-0.80240584,-1.1053076,0.66017856,1.3115354,-0.80240584,-1.1053076,0.65739578,1.3084573,-0.80240584,-1.1071598,0.66573515,1.3117591,-0.80238795,-1.1062381,0.70741412,1.3103543,-0.80220004,-1.1062381,0.67684835,1.311598,-0.80233426,-1.1053076,0.69259652,1.3128865,-0.80225373,-1.1025248,0.60645582,1.3137455,-0.80262954,-1.1016032,0.60552525,1.3137544,-0.80263848,-1.1025248,0.60552525,1.312457,-0.80263848,-1.1016032,0.60460362,1.3133876,-0.80264743,-1.1034554,0.60645582,1.3135934,-0.80262954,-1.1006726,0.60830802,1.3123138,-0.80262954,-1.1034554,0.63053442,1.3134592,-0.80253111,-1.1043859,0.65647416,1.3112311,-0.80241479,-1.1034554,0.65462196,1.3113743,-0.80242374,-1.1034554,0.65647416,1.3123854,-0.80241479,-1.1025248,0.65462196,1.3090837,-0.80241479,-1.1016032,0.65554358,1.3073746,-0.80240584,-1.1006726,0.65183918,1.3072941,-0.80241479,-1.1006726,0.65462196,1.3070436,-0.80240584,-1.099751,0.65183918,1.3068199,-0.80241479,-1.1016032,0.65647416,1.3086273,-0.80240584,-1.1006726,0.64072599,1.3074999,-0.80245953,-1.1016032,0.63887379,1.3084126,-0.80245953,-1.1006726,0.60367305,1.30937,-0.80262954,-1.1006726,0.60737745,1.3070883,-0.80260269,-1.1006726,0.60182085,1.3076162,-0.80263848,-1.1016032,0.60089922,1.3086094,-0.80263848,-1.1025248,0.60275142,1.3102648,-0.80263848,-1.1034554,0.64628259,1.3082694,-0.80244163,-1.1016032,0.60645582,1.3078041,-0.80261164,-1.1025248,0.64072599,1.3080636,-0.80245953,-1.1034554,0.65276976,1.3086005,-0.80242374,-1.1034554,0.65462196,1.3075894,-0.80240584,-1.1053076,0.7611458,1.3022923,-0.80193161,-1.1025248,0.66758735,1.3037329,-0.80234321,-1.1025248,0.66851793,1.3053703,-0.80234321,-1.1034554,0.66573515,1.3051914,-0.8023611,-1.1043859,0.66943955,1.3103722,-0.8023611,-1.1025248,0.66943955,1.3074194,-0.80235215,-1.1016032,0.66851793,1.3039208,-0.80234321,-1.1016032,0.66758735,1.3048066,-0.80234321,-1.1025248,0.66573515,1.3063904,-0.8023611,-1.1025248,0.66943955,1.3052719,-0.80234321,-1.1025248,0.66758735,1.3049587,-0.80235215,-1.1025248,0.67129175,1.3016301,-0.80232531,-1.1016032,0.67037013,1.301317,-0.80232531,-1.1025248,0.66665678,1.3003953,-0.80234321,-1.1025248,0.66943955,1.3018091,-0.80233426,-1.1034554,0.66851793,1.3059161,-0.80235215,-1.1043859,0.74354543,1.3059788,-0.80201214,-1.1006726,0.67037013,1.3047708,-0.80234321,-1.1034554,0.66388295,1.3049856,-0.80237005,-1.1006726,0.66758735,1.3035897,-0.80235215,-1.1006726,0.66758735,1.3064351,-0.80235215,-1.1016032,0.66943955,1.3060146,-0.80234321,-1.1006726,0.67592673,1.306283,-0.80232531,-1.1006726,0.66851793,1.3065335,-0.8023611,-1.1006726,0.66851793,1.3074552,-0.80235215,-1.1006726,0.67870055,1.3074015,-0.80231636,-1.1025248,0.67129175,1.307831,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321,-1.1016032,0.67222233,1.3098621,-0.80234321:4
-1.0994591,-0.88272322,1.3837168,-0.93469107,-1.0994591,-0.88272322,1.381821,-0.93469107,-1.0994591,-0.88380654,1.3821439,-0.93469107,-1.0994591,-0.88272322,1.3825293,-0.93469107,-1.0994591,-0.88163991,1.3828835,-0.93468066,-1.0983757,-0.88163991,1.3813835,-0.93468066,-1.0983757,-0.88163991,1.3819356,-0.93468066,-1.0983757,-0.88163991,1.3808523,-0.93468066,-1.0983757,-0.88272322,1.3781127,-0.93468066,-1.0973028,-0.88163991,1.3738316,-0.93468066,-1.0973028,-0.88272322,1.373467,-0.93469107,-1.0973028,-0.88163991,1.374342,-0.93468066,-1.0973028,-0.88272322,1.3705712,-0.93469107,-1.0973028,-0.88380654,1.3701545,-0.93469107,-1.0973028,-0.88272322,1.3705608,-0.93469107,-1.0973028,-0.88272322,1.3728212,-0.93468066,-1.0973028,-0.88380654,1.3713941,-0.93469107,-1.0973028,-0.88163991,1.371717,-0.93468066,-1.0951466,-0.87409837,1.3541861,-0.93463899,-1.0973028,-0.88272322,1.3686858,-0.93468066,-1.0973028,-0.88163991,1.3684879,-0.93469107,-1.0940633,-0.87409837,1.3530507,-0.93463899,-1.0973028,-0.88596275,1.3680712,-0.93470149,-1.0973028,-0.88272322,1.3739357,-0.93468066,-1.0940633,-0.88272322,1.3439883,-0.93469107,-1.0940633,-0.88272322,1.3491862,-0.93469107,-1.0983757,-0.88272322,1.379144,-0.93468066,-1.0962195,-0.89027517,1.3592485,-0.93471191,-1.0983757,-0.88163991,1.3751128,-0.93467024,-1.0940633,-0.88272322,1.3496341,-0.93469107,-1.0983757,-0.88272322,1.3797273,-0.93468066,-1.0983757,-0.88272322,1.3806439,-0.93469107,-1.0983757,-0.87625458,1.3806231,-0.93464941,-1.0983757,-0.88272322,1.3813731,-0.93468066,-0.84390097,0.82748683,1.3683837,-0.92442042,-0.87625458,0.72073867,1.3691441,-0.92499332,-0.87948369,0.69809323,1.3654567,-0.92511832,-0.87517127,0.7088743,1.3693108,-0.92506624,-0.88596275,0.65711477,1.3712587,-0.9253579,-0.88919186,0.6452504,1.3768836,-0.92546207,-0.88380654,0.677604,1.3725295,-0.92524332,-0.88487943,0.67868732,1.3719045,-0.92525374,-0.88919186,0.64740661,1.3731441,-0.92540998,-0.87517127,0.69162459,1.3749565,-0.92518082,-0.88596275,0.6452504,1.3737274,-0.92544123,-0.88056701,0.67329158,1.3748836,-0.92530582,-0.87301506,0.70564519,1.3760086,-0.92512874,-0.88919186,0.63446933,1.3593318,-0.92537873,-0.88596275,0.63986507,1.3559881,-0.92538915,-0.88703565,0.63124022,1.3779877,-0.92553498,-0.88163991,0.63339643,1.3775815,-0.92549332,-0.89134807,0.62692779,1.3767273,-0.92556623,-0.88919186,0.62692779,1.380144,-0.92556623,-0.88703565,0.62584448,1.3766544,-0.92556623,-0.88811896,0.62477158,1.375769,-0.92557665,-0.88703565,0.62153205,1.3769669,-0.92559748,-0.88811896,0.62153205,1.3833522,-0.92558706,-0.89027517,0.62044874,1.379769,-0.92558706,-0.8956605,0.60428235,1.3759982,-0.9256704,-0.89674381,0.60643857,1.3794981,-0.9256704,-0.88919186,0.60643857,1.3738628,-0.92563915,-0.88380654,0.61182389,1.3720295,-0.9256079,-0.85576535,0.72720731,1.3707795,-0.92501416,-0.82880749,0.82210151,1.3696962,-0.92449333,-0.85792157,0.71858246,1.3710191,-0.92504541,-0.87948369,0.64202128,1.3750295,-0.92547248,-0.85145293,0.72181157,1.3691025,-0.92502457,-0.8784108,0.62800069,1.3706233,-0.92555581,-0.88163991,0.61829253,1.3747899,-0.92562873,-0.86762973,0.66682294,1.369967,-0.92532665,-0.88272322,0.60859478,1.374894,-0.92565998,-0.87194216,0.6452504,1.3762274,-0.92546207,-0.88596275,0.61721963,1.3765294,-0.92562873,-0.88487943,0.61506342,1.3765503,-0.92564956,-0.87948369,0.63662554,1.3759461,-0.92551415,-0.82880749,0.82964304,1.376894,-0.9244725,-0.8471405,0.76494624,1.3794773,-0.92483708,-0.85145293,0.74769654,1.3774253,-0.92490999,-0.88272322,0.64093797,1.381571,-0.9254829,-0.89134807,0.61182389,1.3832585,-0.92564956,-0.88919186,0.61721963,1.3873105,-0.92563915,-0.88380654,0.63662554,1.3870501,-0.9255454,-0.88919186,0.59781371,1.3862793,-0.92574331,-0.88163991,0.5967304,1.3856439,-0.92570165,-0.88919186,0.59241797,1.3853939,-0.92577456,-0.8784108,0.62260495,1.382946,-0.92556623,-0.78891234,0.96443238,1.3812273,-0.92376418,-0.86331731,0.68191643,1.3811544,-0.92522249,-0.87732748,0.65711477,1.388498,-0.92543082,-0.86978594,0.67652069,1.388123,-0.92527457,-0.85684867,0.73798838,1.3864251,-0.92498291,-0.87517127,0.67652069,1.3903625,-0.92533707,-0.87085884,0.6614272,1.389873,-0.92539957,-0.87409837,0.64740661,1.3858418,-0.92547248,-0.87194216,0.65711477,1.3828731,-0.9254204,-0.86654642,0.64848992,1.3846855,-0.92544123,-0.82125553,0.81563287,1.3825814,-0.924535,-0.87085884,0.64956282,1.3840397,-0.92546207,-0.87194216,0.65604188,1.3793523,-0.92539957,-0.87625458,0.64848992,1.3841856,-0.9254829,-0.87625458,0.65172945,1.3851751,-0.92547248,-0.86978594,0.65711477,1.3763836,-0.92538915,-0.86762973,0.6452504,1.3821648,-0.92540998,-0.86762973,0.6452504,1.3821648,-0.92540998,-0.87625458,0.64740661,1.3806127,-0.92544123,-0.87625458,0.63339643,1.3806023,-0.92551415,-0.86547352,0.65064614,1.3822481,-0.92536832,-0.88163991,0.63015691,1.3864876,-0.92555581,-0.87301506,0.64956282,1.3798835,-0.92536832,-0.88056701,0.64309418,1.3781232,-0.92545165,-0.87517127,0.63446933,1.3799877,-0.92543082,-0.87625458,0.64309418,1.3788106,-0.9254204,-0.87625458,0.62908401,1.3791961,-0.92546207,-0.87409837,0.64309418,1.3838418,-0.92539957,-0.88487943,0.62477158,1.3846439,-0.92555581,-0.87732748,0.64848992,1.3845501,-0.92544123,-0.8784108,0.64202128,1.381821,-0.92545165,-0.88163991,0.63446933,1.3837585,-0.92551415,-0.87948369,0.64740661,1.3834668,-0.9254204,-0.88163991,0.62908401,1.3863001,-0.92553498,-0.88487943,0.64309418,1.3837897,-0.92546207,-0.88056701,0.64848992,1.3787481,-0.92538915,-0.88272322,0.6452504,1.3793731,-0.9254204,-0.86978594,0.67329158,1.3723524,-0.92520165,-0.87301506,0.64848992,1.3772482,-0.92536832,-0.87194216,0.65604188,1.3743836,-0.92532665,-0.88163991,0.6452504,1.3762899,-0.92543082,-0.88056701,0.65172945,1.3773315,-0.92540998,-0.88056701,0.6441775,1.379894,-0.92544123,-0.8784108,0.65280235,1.380946,-0.92540998,-0.88056701,0.65495856,1.3811439,-0.9254204,-0.88056701,0.65172945,1.3795294,-0.9254204,-0.87732748,0.65711477,1.3781544,-0.92537873,-0.88272322,0.6452504,1.3757899,-0.92545165,-0.88596275,0.65819809,1.3801648,-0.92539957,-0.88596275,0.6452504,1.3769253,-0.92547248,-0.88919186,0.64309418,1.3828522,-0.92547248,-0.88596275,0.65819809,1.3798315,-0.92538915,-0.88811896,0.63878176,1.3829668,-0.92549332,-0.88380654,0.6603543,1.3843835,-0.92537873,-0.88919186,0.64202128,1.385623,-0.9254829,-0.88703565,0.64633371,1.388873,-0.92547248,-0.88596275,0.64956282,1.3859876,-0.92544123,-0.88380654,0.65604188,1.3864876,-0.92540998,-0.88163991,0.65172945,1.3861022,-0.9254204,-0.88919186,0.64309418,1.3875292,-0.9254829,-0.88380654,0.6603543,1.3885501,-0.92540998,-0.88703565,0.64740661,1.3887063,-0.92546207,-0.88596275,0.65172945,1.392675,-0.92546207,-0.88703565,0.64740661,1.3896855,-0.9254829,-0.87948369,0.66466673,1.3895084,-0.92536832,-0.8784108,0.66466673,1.3906229,-0.92536832,-0.88380654,0.6441775,1.3875292,-0.92546207,-0.88163991,0.6614272,1.3886438,-0.92540998,-0.88163991,0.65064614,1.3889042,-0.92543082,-0.88056701,0.6614272,1.3820502,-0.92538915,-0.88056701,0.64740661,1.3777898,-0.92544123,-0.89350428,0.60104283,1.3761857,-0.92568081,-0.89350428,0.59241797,1.3738524,-0.92571206,-0.89350428,0.59133466,1.3746024,-0.92571206,-0.88811896,0.58917845,1.3741024,-0.9256704,-0.8945876,0.57516827,1.3733524,-0.92578498,-0.89027517,0.5967304,1.3739982,-0.9256704,-0.89781671,0.57192874,1.3725191,-0.92583706,-0.88919186,0.58379312,1.3739253,-0.92572248,-0.89027517,0.59133466,1.3731545,-0.9257329,-0.89134807,0.58594934,1.373842,-0.92572248,-0.8956605,0.59349087,1.3731024,-0.92570165,-0.8945876,0.58163691,1.3600089,-0.92569123,-0.89997292,0.58486602,1.3808523,-0.92577456,-0.90644156,0.57732448,1.3848418,-0.92583706,-0.90212914,0.58486602,1.3788523,-0.92578498,-0.89781671,0.59888661,1.3824356,-0.92569123,-0.90321245,0.57732448,1.3839251,-0.92581623,-0.89674381,0.58270981,1.384623,-0.92578498,-0.88811896,0.57301206,1.3830918,-0.92574331,-0.88380654,0.58702223,1.3821127,-0.92564956,-0.88380654,0.57732448,1.3818523,-0.92569123,-0.89781671,0.5805536,1.3815918,-0.92580581,-0.89781671,0.58810555,1.382821,-0.92576414,-0.90212914,0.57192874,1.3841335,-0.92585789,-0.90536866,0.57732448,1.3860709,-0.92582664,-0.90428535,0.57516827,1.3859772,-0.92584748,-0.89890003,0.58702223,1.3843418,-0.92576414,-0.90428535,0.57516827,1.3835189,-0.92582664,-0.90321245,0.56977253,1.3797481,-0.92585789,-0.89674381,0.58810555,1.3794356,-0.92577456,-0.8956605,0.57085585,1.3748107,-0.92584748,-0.89890003,0.57624117,1.3733628,-0.92579539,-0.90105624,0.566533,1.3743836,-0.92587873,-0.89781671,0.58379312,1.3758315,-0.92576414,-0.90105624,0.57192874,1.3754774,-0.92582664,-0.89674381,0.5805536,1.3736545,-0.92577456,-0.8956605,0.58379312,1.372592,-0.92575373,-0.90105624,0.56546011,1.3743316,-0.92586831,-0.8945876,0.58594934,1.3771857,-0.92576414,-0.89781671,0.56868922,1.3739982,-0.92584748,-0.89674381,0.5805536,1.3740295,-0.92574331,-0.90212914,0.57301206,1.379394,-0.92581623,-0.90212914,0.57732448,1.3798106,-0.92581623,-0.90536866,0.57516827,1.3830918,-0.92583706,-0.90752488,0.56330389,1.3823314,-0.92586831,-0.90321245,0.58486602,1.3814564,-0.92574331,-0.90644156,0.56546011,1.3831647,-0.92586831,-0.90428535,0.57624117,1.3825502,-0.92581623,-0.90752488,0.56222058,1.3832585,-0.92587873,-0.90428535,0.57085585,1.3857689,-0.92583706,-0.90428535,0.5794807,1.3877063,-0.92580581,-0.90859777,0.56437679,1.3892792,-0.92589956,-0.90428535,0.5805536,1.384571,-0.92579539,-0.90536866,0.56437679,1.3814877,-0.92586831,-0.89997292,0.58702223,1.3793106,-0.92577456,-0.89997292,0.56437679,1.3798731,-0.92585789,-0.90321245,0.57301206,1.3807794,-0.92584748,-0.89890003,0.58810555,1.3795085,-0.92575373,-0.90644156,0.56868922,1.382821,-0.92587873,-0.90536866,0.5794807,1.3765503,-0.92576414,-0.88703565,0.62692779,1.3762482,-0.92552457,-0.90212914,0.57192874,1.3767169,-0.92583706,-0.90428535,0.55790815,1.3762274,-0.92589956,-0.90536866,0.56437679,1.3721024,-0.92585789,-0.90536866,0.56437679,1.3726233,-0.92585789,-0.9118373,0.55252283,1.3763732,-0.92593081,-0.90752488,0.56437679,1.3745086,-0.92585789,-0.90968109,0.54712709,1.3754045,-0.92595164,-0.9107644,0.56006437,1.371842,-0.92589956,-0.91399351,0.54497088,1.3810294,-0.92598289,-0.90968109,0.55790815,1.3805919,-0.92590998,-0.90859777,0.56330389,1.3790502,-0.92588914,-0.91399351,0.55143951,1.3810085,-0.92596206,-0.90968109,0.56437679,1.3835293,-0.92586831,-0.91399351,0.54712709,1.3862897,-0.92596206,-0.91399351,0.56006437,1.3877792,-0.92588914,-0.91723304,0.54497088,1.3843939,-0.92596206,-0.91292062,0.55899147,1.3888001,-0.92589956,-0.91507683,0.56222058,1.3919354,-0.92589956,-0.91399351,0.55143951,1.3816335,-0.92589956,-0.91292062,0.566533,1.3928312,-0.92586831,-0.91723304,0.5482104,1.3908,-0.92596206,-0.91723304,0.56114768,1.400404,-0.92595164,-0.91938925,0.5482104,1.3979353,-0.92600372,-0.9118373,0.55467904,1.3944354,-0.92593081,-0.91507683,0.56330389,1.3962062,-0.92592039,-0.9118373,0.55252283,1.3947895,-0.92595164,-0.91507683,0.56006437,1.3968624,-0.92593081,-0.92154547,0.54712709,1.3949979,-0.92601414,-0.9118373,0.56330389,1.3913729,-0.92588914,-0.92046215,0.5492833,1.3980082,-0.92599331,-0.91399351,0.55683526,1.3935083,-0.92593081,-0.91292062,0.56546011,1.3922271,-0.92589956,-0.91830594,0.55036662,1.3929667,-0.92598289,-0.91292062,0.56437679,1.3904146,-0.92587873,-0.91723304,0.54712709,1.39155,-0.92600372,-0.90968109,0.55899147,1.3883105,-0.92592039,-0.91614973,0.54497088,1.3876438,-0.92600372,-0.91399351,0.55575194,1.3887376,-0.92595164,-0.91292062,0.56222058,1.3895813,-0.92593081,-0.91399351,0.5492833,1.3868209,-0.92597247,-0.90968109,0.56437679,1.3904875,-0.92590998,-0.91507683,0.54497088,1.3867376,-0.92599331,-0.9118373,0.55790815,1.3866334,-0.92593081,-0.91292062,0.54605419,1.3847168,-0.92598289,-0.91292062,0.55467904,1.3810294,-0.92589956,-0.91399351,0.56222058,1.3882896,-0.92588914,-0.91830594,0.55143951,1.3923,-0.92595164,-0.91507683,0.56222058,1.3920292,-0.92589956,-0.92154547,0.54497088,1.3874147,-0.92598289,-0.91507683,0.55899147,1.3890084,-0.92589956,-0.91938925,0.54388756,1.3901959,-0.92596206,-0.91614973,0.55467904,1.3883521,-0.92589956,-0.91830594,0.56114768,1.3917479,-0.92588914,-0.91938925,0.55036662,1.394352,-0.92595164,-0.91614973,0.56330389,1.3928,-0.92588914,-0.91938925,0.5482104,1.3945395,-0.92596206,-0.9118373,0.56006437,1.3924875,-0.92587873,-0.92046215,0.54497088,1.3917479,-0.92598289,-0.91507683,0.55899147,1.3939875,-0.92589956,-0.91507683,0.56006437,1.3900917,-0.92587873,-0.92154547,0.5492833,1.3939146,-0.92596206,-0.91399351,0.56437679,1.3916229,-0.92584748,-0.91938925,0.54388756,1.3900605,-0.92596206,-0.91507683,0.55899147,1.3902271,-0.92586831,-0.9118373,0.5482104,1.3857584,-0.92586831,-0.90536866,0.56330389,1.3865709,-0.92575373,-0.90968109,0.56222058,1.3851439,-0.92580581,-0.90321245,0.5492833,1.3844251,-0.92580581,-0.90321245,0.56330389,1.3821648,-0.92574331,-0.90644156,0.54388756,1.3849668,-0.92585789,-0.90644156,0.56006437,1.3882792,-0.92580581,-0.90752488,0.54388756,1.3892375,-0.92585789,-0.90644156,0.55575194,1.3863209,-0.92582664,-0.90105624,0.56114768,1.3817898,-0.92574331,-0.91830594,0.5492833,1.3883834,-0.92594122,-0.90968109,0.56330389,1.3821335,-0.92581623,-0.91723304,0.54388756,1.3831752,-0.92594122,-0.9118373,0.55790815,1.3877897,-0.92584748,-0.91507683,0.54065845,1.3850501,-0.92597247,-0.90859777,0.55467904,1.3853209,-0.92586831,-0.90536866,0.55790815,1.3845293,-0.92584748,-0.90968109,0.54712709,1.3867897,-0.92588914,-0.90644156,0.55899147,1.3782169,-0.92582664,-0.91292062,0.54173135,1.3790294,-0.92592039,-0.91399351,0.55899147,1.3761857,-0.92585789,-0.91614973,0.54065845,1.3592068,-0.92587873,-0.91723304,0.55252283,1.3669567,-0.92587873,-0.9107644,0.55575194,1.3554465,-0.92577456,-0.91723304,0.55036662,1.3701233,-0.92588914,-0.90644156,0.55899147,1.371467,-0.92578498,-0.91399351,0.54388756,1.3708524,-0.92590998,-0.90859777,0.55575194,1.3697691,-0.92580581,-0.91723304,0.53741892,1.3713837,-0.92593081,-0.90859777,0.55252283,1.3647588,-0.92578498,-0.91399351,0.55683526,1.3643838,-0.92579539,-0.91399351,0.5482104,1.3621547,-0.92581623,-0.91399351,0.55899147,1.3599256,-0.92578498,-0.91507683,0.54388756,1.3612901,-0.92583706,-0.91614973,0.55790815,1.3620505,-0.92580581,-0.91399351,0.53850224,1.358561,-0.92585789,-0.90752488,0.55252283,1.3626755,-0.92579539,-0.89997292,0.55790815,1.3584256,-0.92570165,-0.90644156,0.54605419,1.3568944,-0.92581623,-0.90536866,0.56006437,1.3599985,-0.92576414,-0.91614973,0.54281466,1.3583006,-0.92585789,-0.90968109,0.55575194,1.355686,-0.92576414,-0.90968109,0.54173135,1.3604776,-0.92583706,-0.90968109,0.55252283,1.3639776,-0.92581623,-0.90644156,0.55790815,1.360311,-0.92575373,-0.9107644,0.5482104,1.3617276,-0.92583706,-0.9118373,0.55790815,1.3628734,-0.92578498,-0.91292062,0.53850224,1.3586131,-0.92586831,-0.90859777,0.55899147,1.3602901,-0.92578498,-0.90859777,0.53957514,1.3614568,-0.92585789,-0.90644156,0.55252283,1.3618318,-0.92580581,-0.90644156,0.55683526,1.363488,-0.92579539,-0.90968109,0.54605419,1.3625922,-0.92586831,-0.90644156,0.56761632,1.3658942,-0.92575373,-0.90536866,0.55899147,1.3659671,-0.92579539,-0.89890003,0.5794807,1.3671338,-0.92569123,-0.90968109,0.5482104,1.3712066,-0.92588914,-0.90968109,0.56114768,1.3678317,-0.92582664,-0.90644156,0.566533,1.3665088,-0.92577456,-0.90105624,0.59457419,1.3649984,-0.92562873,-0.88596275,0.65172945,1.3646859,-0.92531624,-0.90105624,0.58486602,1.3605089,-0.9256704,-0.89781671,0.58810555,1.3686442,-0.92565998,-0.89997292,0.57732448,1.363863,-0.92571206,-0.86223399,0.72828021,1.3678421,-0.92489958,-0.89890003,0.58594934,1.3671442,-0.92565998,-0.89134807,0.60319904,1.3616651,-0.92552457,-0.89134807,0.62044874,1.3599985,-0.92547248,-0.8945876,0.60966768,1.3616234,-0.9255454,-0.89027517,0.64093797,1.3631651,-0.92539957,-0.89781671,0.61182389,1.3636234,-0.9255454,-0.8956605,0.61721963,1.3594568,-0.92551415,-0.89027517,0.63770886,1.3589568,-0.92536832,-0.90428535,0.59349087,1.3609672,-0.92562873,-0.88272322,0.66251051,1.3618214,-0.92524332,-0.90536866,0.58486602,1.3635088,-0.92568081,-0.90212914,0.58486602,1.3584777,-0.92562873,-0.90859777,0.57301206,1.3593943,-0.92572248,-0.90859777,0.57301206,1.3593943,-0.92572248,-0.90859777,0.57301206,1.3593943,-0.92572248,-0.90859777,0.57301206,1.3593943,-0.92572248,-0.90859777,0.57301206,1.3593943,-0.92572248,-0.90859777,0.57301206,1.3593943,-0.92572248:4
-0.96373235,0.5940266,1.1671565,-1.0805462,-0.9331169,0.70589587,1.1628543,-1.0799141,-0.91518396,0.7956013,1.1673604,-1.0794553,-0.97639449,0.5845249,1.1632009,-1.0805768,-0.97955493,0.57924391,1.1683086,-1.0806073,-0.96373235,0.62146123,1.1640267,-1.0803933,-0.86979601,0.93807583,1.1588476,-1.0787009,-0.98483592,0.56658177,1.1595307,-1.0806685,-0.97428413,0.58768533,1.1602342,-1.0805564,-0.95528073,0.64784578,1.1602851,-1.0802301,-0.9521203,0.6467957,1.1521598,-1.0802097,-0.95634101,0.64151471,1.1582156,-1.0802505,-0.97533422,0.58346462,1.1568596,-1.0805768,-0.90673235,0.81881522,1.1635373,-1.079333,-0.9088427,0.81143407,1.1607541,-1.0793534,-0.94894966,0.67211997,1.1643937,-1.0801384,-0.94789958,0.67634069,1.1651481,-1.080118,-0.95634101,0.66050792,1.1680741,-1.0802199,-0.95528073,0.65734748,1.1649136,-1.0802097,-0.96056172,0.64257499,1.1696441,-1.0802913,-0.9711135,0.59613695,1.1660861,-1.0805462,-0.97850485,0.5750232,1.1648117,-1.0806481,-0.92678583,0.75760469,1.1616003,-1.0796796,-0.96900315,0.61619044,1.1664327,-1.080434,-0.98377564,0.55814035,1.1636699,-1.0807297,-0.98483592,0.56130078,1.1666978,-1.0807501,-0.98377564,0.5750232,1.1651481,-1.0806583,-0.98694627,0.55708007,1.1590719,-1.0807399,-0.97850485,0.58979569,1.1593166,-1.0805768,-0.9806152,0.56764205,1.1564314,-1.0806583,-0.97639449,0.57080248,1.1522617,-1.0806583,-0.97744457,0.57080248,1.1561358,-1.0806685,-0.94894966,0.68162167,1.1579913,-1.0800874,-0.91412369,0.79138059,1.1635985,-1.0795267,-0.9521203,0.67318025,1.1658516,-1.0801588,-0.93522725,0.71961828,1.1648627,-1.0799141,-0.88668906,0.88636701,1.1680027,-1.0790271,-0.9426186,0.71961828,1.1685736,-1.0799243,-0.98800655,0.54652829,1.1693688,-1.080852,-0.98905663,0.54336785,1.1637208,-1.0808112,-0.97850485,0.56869213,1.1593982,-1.0806787,-0.99116698,0.5412575,1.1678396,-1.0808622,-0.985886,0.55602999,1.1675643,-1.0807807,-0.97744457,0.58241454,1.1659841,-1.0806379,-0.98694627,0.54336785,1.1580422,-1.0808011,-0.98483592,0.55602999,1.1623955,-1.0807705,-0.97955493,0.60773882,1.1577772,-1.0804442,-0.99644797,0.54441793,1.1577874,-1.0807807,-0.99749805,0.54336785,1.1520782,-1.0807807,-0.9901169,0.55180928,1.154423,-1.0807195,-1.0017188,0.53069552,1.1595307,-1.0808826,-0.9901169,0.57608347,1.1574917,-1.0806277,-1.0038291,0.52331437,1.1560542,-1.080903,-0.95845137,0.67740096,1.161845,-1.0800772,-0.99855833,0.53702659,1.1600812,-1.080852,-0.98483592,0.59191624,1.1616003,-1.080587,-0.99116698,0.5697524,1.1599283,-1.0806889,-0.9901169,0.5697524,1.1583889,-1.0806787,-0.98905663,0.56341114,1.1599283,-1.0807093,-0.9901169,0.54863865,1.1604381,-1.0807909,-0.97322386,0.60140775,1.1630887,-1.0805258,-0.98694627,0.56130078,1.1582665,-1.0806991,-0.98694627,0.56553169,1.1601016,-1.0806787,-0.96478243,0.63623372,1.1577058,-1.0802913,-0.96056172,0.64784578,1.1578689,-1.0802403,-0.98905663,0.54652829,1.1602953,-1.0808011,-0.95634101,0.65839756,1.1583175,-1.0801792,-0.99222726,0.54336785,1.1578791,-1.0808112,-0.96373235,0.63201301,1.1609988,-1.0803219,-0.95317038,0.66789926,1.160122,-1.080118,-0.96478243,0.62990265,1.1584704,-1.0803525,-0.97322386,0.60457838,1.1586132,-1.0804748,-0.97744457,0.60668873,1.1572165,-1.0805156,-0.9616118,0.63096293,1.1559115,-1.0803321,-0.96478243,0.63623372,1.1603361,-1.0803321,-0.96478243,0.64257499,1.1628135,-1.0803219,-0.97850485,0.6035181,1.1654846,-1.0805054,-0.97006342,0.62463186,1.1598467,-1.0803831,-0.95317038,0.68373203,1.1601832,-1.0800568,-0.9806152,0.58557498,1.1539643,-1.080536,-0.96056172,0.65206649,1.1549736,-1.0802097,-0.98377564,0.57080248,1.1602749,-1.0806379,-0.97955493,0.60246802,1.1588069,-1.0804544,-0.98272556,0.58241454,1.153587,-1.0805666,-0.96056172,0.6467957,1.1505184,-1.0801894,-0.95423065,0.65839756,1.1516092,-1.0801588,-0.97744457,0.58768533,1.161845,-1.0805462,-0.9806152,0.58135426,1.160173,-1.0805666,-0.96689279,0.62463186,1.1596938,-1.0803525,-0.9901169,0.55285936,1.158185,-1.0807195,-0.97533422,0.62041115,1.1559217,-1.0804034,-0.97217378,0.62885257,1.1619877,-1.0804034,-0.99116698,0.56553169,1.1656477,-1.0807705,-0.97850485,0.60457838,1.1589394,-1.0805258,-0.99116698,0.55708007,1.1524044,-1.0807501,-0.98905663,0.54441793,1.1511708,-1.0808418,-0.9953877,0.52436445,1.1570431,-1.0809642,-0.97006342,0.61195953,1.1583175,-1.0805156,-0.93522725,0.69639417,1.1616513,-1.080016,-0.94683931,0.66050792,1.1515175,-1.0801894,-0.94578923,0.64890605,1.1510791,-1.0802607,-0.94472895,0.65734748,1.1487648,-1.0801996,-0.9521203,0.64573542,1.1587865,-1.0803219,-0.95000994,0.65101641,1.1574509,-1.0803015,-0.95950145,0.60984917,1.1514869,-1.080485,-0.96689279,0.58874561,1.1513645,-1.0806379,-0.96584271,0.58979569,1.1498863,-1.080587,-0.96584271,0.5845249,1.1492746,-1.0806277,-0.95317038,0.64468534,1.1501819,-1.0803117,-0.92678583,0.71644765,1.1538011,-1.0799141,-0.94367887,0.66261827,1.1553406,-1.0802199,-0.96478243,0.5940266,1.158919,-1.0805564,-0.97850485,0.55602999,1.1629664,-1.0808011,-0.96373235,0.57080248,1.1611925,-1.0806685,-0.97006342,0.5602507,1.1643529,-1.0807501,-0.97217378,0.55391963,1.1643631,-1.0808112,-0.96478243,0.57924391,1.1605502,-1.0806583,-0.97850485,0.54652829,1.1661574,-1.0808622,-0.94683931,0.67529061,1.1652501,-1.0801894,-0.97744457,0.59085597,1.1656987,-1.0806583,-0.97006342,0.60984917,1.1649544,-1.0805666,-0.94050824,0.67529061,1.1645466,-1.0802301,-0.98905663,0.50431097,1.1578995,-1.0811273,-0.9183444,0.74177192,1.1541274,-1.0798325,-0.985886,0.51487295,1.1559421,-1.0810559,-0.89724084,0.80404273,1.1499067,-1.0794859,-0.96267208,0.52331437,1.1545148,-1.0809336,-0.86030451,0.85470147,1.152017,-1.0791495,-0.85818396,0.86209281,1.1522107,-1.0791189,-0.86768566,0.83042728,1.1512422,-1.079282,-0.86241486,0.85154103,1.1447582,-1.0791597,-0.85818396,0.86420317,1.154107,-1.0791189,-0.85924423,0.84626005,1.1512116,-1.0792004,-0.85818396,0.84414969,1.1514767,-1.0792208,-0.8560736,0.86103254,1.1523637,-1.0791393,-0.85291316,0.87581523,1.1491318,-1.0790577,-0.8560736,0.85998246,1.1418221,-1.0791087,-0.85713388,0.87475495,1.1392122,-1.0790475,-0.85713388,0.84943068,1.1334316,-1.0791087,-0.85713388,0.85470147,1.1469195,-1.0791291,-0.84552182,0.87792558,1.1399258,-1.0789864,-0.96689279,0.49270911,1.1494173,-1.0810967,-0.93839788,0.60035767,1.1412715,-1.080485,-0.9616118,0.52014374,1.1605604,-1.0809948,-0.96795307,0.49586954,1.1615391,-1.0811273,-0.93628753,0.60668873,1.1591637,-1.0805666,-0.96900315,0.4884884,1.1604686,-1.0811987,-0.96267208,0.51381267,1.1599589,-1.0810559,-0.8560736,0.8631429,1.1579301,-1.0791699,-0.8560736,0.85470147,1.1554731,-1.0791801,-0.85291316,0.86736361,1.1532812,-1.0791291,-0.84447174,0.89374816,1.1544434,-1.0789864,-0.84447174,0.90853085,1.1444829,-1.0788946,-0.85818396,0.85998246,1.1441975,-1.0791495,-0.85185289,0.87369468,1.1516908,-1.0790883,-0.85713388,0.86736361,1.1537706,-1.0791393,-0.83708039,0.92752405,1.1502635,-1.0787926,-0.85291316,0.8726446,1.1486629,-1.0790679,-0.84341146,0.90536022,1.1506815,-1.0789252,-0.83391996,0.91908263,1.1500902,-1.078813,-0.83919075,0.92647397,1.1461651,-1.078813,-0.85502352,0.87686531,1.1522719,-1.0790883,-0.8560736,0.8726446,1.1486833,-1.0791189,-0.83919075,0.90431013,1.1465321,-1.078915,-0.82546834,0.95707924,1.1495702,-1.0786193,-0.8560736,0.87792558,1.1494479,-1.0791087,-0.84552182,0.9011395,1.1493561,-1.0789456,-0.85185289,0.88425665,1.1476944,-1.0790271,-0.85185289,0.87369468,1.1491115,-1.0790781,-0.83603031,0.90747057,1.1464812,-1.0788436,-0.82968905,0.91908263,1.1516908,-1.0788436,-0.84341146,0.9011395,1.1527613,-1.0789252,-0.84341146,0.90747057,1.1554017,-1.0788946,-0.84869245,0.88108602,1.1523127,-1.0790373,-0.84658209,0.8821463,1.1434431,-1.0789354,-0.84130111,0.90007923,1.1527409,-1.0789456,-0.84974253,0.88108602,1.1511505,-1.0790169,-0.85185289,0.88530673,1.1529855,-1.0790067,-0.84974253,0.89585851,1.1548104,-1.0789456,-0.85185289,0.88847737,1.153373,-1.078966,-0.84025103,0.91697227,1.1509771,-1.0788436,-0.84236138,0.91275156,1.1531385,-1.0788538,-0.85291316,0.87792558,1.1532404,-1.0790475,-0.84869245,0.88741709,1.146471,-1.078966,-0.84130111,0.92330334,1.1548104,-1.0788028,-0.85713388,0.87792558,1.1505591,-1.0790475,-0.85396324,0.88741709,1.1566048,-1.0790067,-0.85080281,0.90958093,1.1556158,-1.0789048,-0.85502352,0.89058772,1.1557382,-1.0789762,-0.84763218,0.96129995,1.1546983,-1.0785582,-0.84552182,0.98029315,1.1540458,-1.0784868,-0.84447174,0.96974137,1.1574917,-1.0785582,-0.85080281,0.96235003,1.1549634,-1.0786193,-0.83814067,0.9876845,1.1596327,-1.0784868,-0.84025103,0.98135343,1.1574203,-1.0785072,-0.84763218,0.96446039,1.1573898,-1.0785989,-0.84974253,0.95073797,1.1541784,-1.0786397,-0.85185289,0.93807583,1.1519457,-1.0787111,-0.84236138,0.9634103,1.152486,-1.078548,-0.83708039,0.96974137,1.1490401,-1.0784868,-0.85502352,0.92752405,1.1512014,-1.0787621,-0.83814067,0.96763102,1.1482653,-1.0784868,-0.8560736,0.93702575,1.1508038,-1.0787009,-0.83497004,0.99612592,1.148357,-1.0783543,-0.84025103,0.97712252,1.1499474,-1.0784562,-0.84552182,0.97079145,1.1539643,-1.0785582,-0.84341146,0.9686811,1.151232,-1.0785276,-0.84869245,0.96129995,1.1560746,-1.0786091,-0.84869245,0.96129995,1.1444931,-1.078548,-0.84447174,0.96763102,1.1553406,-1.0785276,-0.83814067,0.99084494,1.156829,-1.078446,-0.84236138,0.95812932,1.1569616,-1.0785989,-0.8560736,0.93280504,1.1565334,-1.0787621,-0.83497004,0.97290181,1.1531385,-1.0785174,-0.84341146,0.95179825,1.1554833,-1.0786397,-0.84130111,0.97185173,1.1590719,-1.0785786,-0.84869245,0.94124647,1.1597448,-1.0787315,-0.82124762,1.0404536,1.1621916,-1.0781911,-0.84763218,0.94229655,1.1613862,-1.0787213,-0.84658209,0.94546718,1.156829,-1.0786703,-0.85185289,0.94546718,1.1527918,-1.0786805,-0.84552182,0.96974137,1.1494479,-1.0785174,-0.86030451,0.92647397,1.1560746,-1.0787621,-0.84763218,0.94651726,1.1545046,-1.0786601,-0.85291316,0.93913611,1.1527001,-1.0786805,-0.85185289,0.96552066,1.1552794,-1.0785786,-0.84341146,0.97924307,1.1545148,-1.0784868,-0.84447174,0.9686811,1.1581646,-1.0785684,-0.79803371,1.0900521,1.1524656,-1.0778853,-0.84025103,0.98346379,1.1529448,-1.078446,-0.81491656,1.0699986,1.1428518,-1.0779567,-0.84236138,0.97079145,1.140303,-1.0784664,-0.83814067,0.96763102,1.1433717,-1.0784868,-0.83603031,0.97290181,1.1452272,-1.0784562,-0.83708039,0.98451387,1.1574509,-1.078446,-0.84552182,0.96552066,1.1546269,-1.0785582,-0.84025103,0.97290181,1.1594491,-1.0785174,-0.80014406,1.1037745,1.1599487,-1.0778445,-0.84658209,0.96023967,1.1614881,-1.0786193,-0.84341146,0.98135343,1.1638941,-1.0785072,-0.84236138,0.97924307,1.1618755,-1.0785276,-0.84869245,0.95918959,1.162997,-1.0785989,-0.85924423,0.93596548,1.1554527,-1.0787009,-0.82968905,1.0161794,1.1564212,-1.0782625,-0.83708039,1.007738,1.1616309,-1.0783441,-0.82652861,1.0204001,1.1562071,-1.0782625,-0.84025103,1.0066777,1.1672075,-1.0783645,-0.83708039,1.0330623,1.1710816,-1.0782727,-0.84763218,1.0130088,1.1696747,-1.0783645,-0.83919075,1.0404536,1.1711733,-1.0782217,-0.84658209,1.0204001,1.167075,-1.0783543,-0.83919075,1.0267312,1.1730492,-1.0783645,-0.84341146,1.0182898,1.1625688,-1.0783747,-0.82546834,1.0721089,1.1598773,-1.0780892,-0.86452522,0.95918959,1.1632315,-1.0786907,-0.86346494,0.95601896,1.1558605,-1.0787009,-0.84869245,0.98451387,1.1550143,-1.0785072,-0.84447174,0.97501217,1.1513034,-1.0785276,-0.84974253,0.95496888,1.1551469,-1.0786397,-0.84025103,0.97185173,1.1160798,-1.0783339,-0.8655753,0.92752405,1.1500188,-1.078813,-0.85291316,0.95073797,1.156513,-1.0786703,-0.84552182,0.95918959,1.1311377,-1.0784868,-0.85080281,0.9444069,1.1550041,-1.0786703,-0.85185289,0.95707924,1.1554629,-1.0786091,-0.85396324,0.94124647,1.126652,-1.0785989,-0.85502352,0.94862762,1.1502125,-1.0786601,-0.85818396,0.92963441,1.1316169,-1.0786601,-0.84341146,0.9686811,1.145217,-1.0785276,-0.85185289,0.95812932,1.1658312,-1.0786397,-0.95000994,0.63834408,1.1618348,-1.0803321,-0.86874593,0.90747057,1.1507528,-1.0788538,-0.91729432,0.76815647,1.1634354,-1.0796286,-0.8655753,0.92224307,1.1567985,-1.0787825,-0.86241486,0.9444069,1.1583481,-1.0786499,-0.85713388,0.93174477,1.1578078,-1.0787315,-0.86874593,0.92647397,1.1630582,-1.0787723,-0.8655753,0.93174477,1.1646588,-1.0787621,-0.87085629,0.92013271,1.1635169,-1.0788334,-0.92151503,0.75338398,1.1568188,-1.079649,-0.88034779,0.87686531,1.1489076,-1.0789965,-0.97428413,0.56869213,1.1514359,-1.0806277,-0.93945816,0.68689247,1.1593574,-1.0800262,-0.87929771,0.8726446,1.1542293,-1.0790067,-0.85818396,0.94757754,1.1564416,-1.0786091,-0.95106002,0.63096293,1.1544128,-1.0802913,-0.91729432,0.76077533,1.1559421,-1.0795879,-0.86979601,0.9106412,1.1544536,-1.0787926,-0.86979601,0.91486192,1.1550143,-1.0788028,-0.86135459,0.94229655,1.1542191,-1.0786499,-0.86241486,0.93174477,1.153322,-1.0787519,-0.83391996,1.0225105,1.1547187,-1.0782829,-0.82441826,1.042564,1.1539643,-1.0781504,-0.80964576,1.089002,1.1515073,-1.0778955,-0.84658209,0.95601896,1.147939,-1.0785582,-0.85502352,0.9254137,1.1566761,-1.0787417,-0.85080281,0.93174477,1.1581544,-1.0787417,-0.83814067,0.9634103,1.1649544,-1.0785887,-0.85080281,0.93385512,1.1577874,-1.0787213,-0.84130111,0.93913611,1.1309848,-1.0785684,-0.84236138,0.97396209,1.143912,-1.0784664,-0.84869245,0.96974137,1.160489,-1.0786295,-0.82863897,1.0214502,1.1511199,-1.0783033,-0.85818396,0.92224307,1.1376931,-1.0787417,-0.85502352,0.94229655,1.1502431,-1.0787009,-0.86030451,0.92647397,1.1487648,-1.0787417,-0.8560736,0.94229655,1.1538215,-1.0786805,-0.85924423,0.92963441,1.1577874,-1.0787519,-0.84869245,0.96446039,1.1573388,-1.0785684,-0.82757869,1.0309519,1.1560848,-1.0782013,-0.86030451,0.94229655,1.158032,-1.0786907,-0.87296665,0.92858433,1.1462671,-1.0787111,-0.86979601,0.91802235,1.1502227,-1.0787519,-0.85818396,0.94546718,1.147307,-1.0786397,-0.86768566,0.94651726,1.1402215,-1.0785786,-0.85713388,0.95812932,1.1541172,-1.0786091,-0.85291316,0.96974137,1.1535463,-1.0785786,-0.82019754,1.0678882,1.1470419,-1.0779669,-0.81597683,1.0710589,1.1507223,-1.0779465,-0.85291316,0.95496888,1.1545862,-1.0785684,-0.82652861,1.0309519,1.1556872,-1.0781708,-0.80964576,1.0963831,1.1545963,-1.0778445,-0.86663558,0.92752405,1.1435144,-1.0786703,-0.81808719,1.089002,1.1503247,-1.0778343,-0.85924423,0.95918959,1.1558911,-1.0785989,-0.82124762,1.0541658,1.1357663,-1.0779872,-0.85396324,0.9634103,1.1381213,-1.078497,-0.84869245,0.98029315,1.141557,-1.0784256,-0.86979601,0.93385512,1.1439426,-1.0786907,-0.85818396,0.96023967,1.1394059,-1.0785276,-0.86768566,0.91697227,1.1428823,-1.0787417,-0.86346494,0.93385512,1.1391,-1.0786703,-0.85396324,0.95707924,1.1396098,-1.0785378,-0.85818396,0.93913611,1.1394364,-1.0786601,-0.85713388,0.93913611,1.1390185,-1.0786499,-0.84869245,0.97079145,1.1447786,-1.0784868,-0.81597683,1.0752796,1.1409861,-1.0779363,-0.85080281,0.95601896,1.1395996,-1.0785582,-0.85185289,0.96552066,1.1414652,-1.0785174,-0.85713388,0.9349154,1.1435654,-1.0787009,-0.85185289,0.96129995,1.1419546,-1.078548,-0.85502352,0.93280504,1.1427192,-1.0786601,-0.85924423,0.94018619,1.1447276,-1.0786703,-0.85713388,0.93807583,1.1473579,-1.0786907,-0.85713388,0.9254137,1.1476026,-1.0787519,-0.85502352,0.93807583,1.1485303,-1.0786703,-0.84658209,0.96657074,1.1508038,-1.0785378,-0.85291316,0.96129995,1.1451252,-1.078548,-0.86663558,0.91380164,1.1509771,-1.0788028,-0.85185289,0.95179825,1.1441975,-1.0786091,-0.82441826,1.0605071,1.1501513,-1.0780688,-0.86346494,0.92330334,1.1528224,-1.0788028,-0.84869245,0.97396209,1.1512014,-1.0785378,-0.85185289,0.95601896,1.149662,-1.0785989,-0.86874593,0.91697227,1.1427396,-1.0787926,-0.86241486,0.92858433,1.145635,-1.0787111,-0.85924423,0.9349154,1.1439528,-1.0786703,-0.85502352,0.95707924,1.1410065,-1.0785276,-0.86030451,0.93913611,1.147572,-1.0786907,-0.86030451,0.93913611,1.147572,-1.0786907,-0.86030451,0.93913611,1.147572,-1.0786907,-0.86030451,0.93913611,1.147572,-1.0786907,-0.86030451,0.93913611,1.147572,-1.0786907,-0.86030451,0.93913611,1.147572,-1.0786907,-0.86030451,0.93913611,1.147572,-1.0786907:4
-0.86231831,0.46087717,1.5070935,-0.86433309,-0.8073666,0.62347919,1.5081876,-0.86339069,-0.85110699,0.47994183,1.5043421,-0.86419228,-0.84325365,0.5203134,1.5038655,-0.86400813,-0.81073541,0.62459491,1.5019374,-0.86345569,-0.81409339,0.61562585,1.504483,-0.86349902,-0.91613263,0.25230333,1.5092058,-0.8655138,-0.92397514,0.21866938,1.5046238,-0.86568712,-0.92173288,0.22876498,1.5063894,-0.86563296,-0.92510169,0.20857377,1.5099857,-0.86575211,-0.92173288,0.22651188,1.5084259,-0.86566545,-0.91949061,0.23436522,1.5065952,-0.86560046,-0.92285942,0.22651188,1.5133437,-0.86565462,-0.90827929,0.28370585,1.5127696,-0.86531882,-0.9284705,0.20408925,1.5108198,-0.86577378,-0.9183749,0.24894535,1.513907,-0.86553547,-0.92285942,0.22763843,1.5037355,-0.86562213,-0.9262174,0.21081604,1.5053279,-0.86570878,-0.92734395,0.21530056,1.5110906,-0.86570878,-0.93071276,0.20408925,1.5129429,-0.86577378,-0.92734395,0.21978509,1.5175358,-0.86569795,-0.92958621,0.20857377,1.5167775,-0.86576294,-0.9262174,0.21866938,1.5149577,-0.86569795,-0.9262174,0.21866938,1.5122821,-0.86569795,-0.92285942,0.23100724,1.5124121,-0.86562213,-0.86567629,0.44855014,1.5138095,-0.86439809,-0.93071276,0.20297353,1.5090975,-0.86577378,-0.92734395,0.21530056,1.5094333,-0.86569795,-0.92958621,0.20521579,1.5114372,-0.86576294,-0.9284705,0.20857377,1.5141019,-0.86575211,-0.92397514,0.23212296,1.5093141,-0.86562213,-0.92510169,0.23100724,1.5126179,-0.86562213,-0.92734395,0.21194259,1.5142753,-0.86573045,-0.92510169,0.23324951,1.5125638,-0.86561129,-0.92285942,0.22763843,1.511578,-0.86563296,-0.92510169,0.21754283,1.5036922,-0.86567629,-0.9262174,0.2130583,1.5104515,-0.86570878,-0.9183749,0.24221856,1.5118705,-0.8655463,-0.92397514,0.22763843,1.5148494,-0.86564379,-0.92510169,0.22988069,1.5101482,-0.86563296,-0.92173288,0.23212296,1.5084475,-0.86561129,-0.92173288,0.2231539,1.5047321,-0.86563296,-0.92510169,0.20857377,1.5032698,-0.86570878,-0.92510169,0.22202736,1.5023923,-0.86565462,-0.92397514,0.2130583,1.5015474,-0.86569795,-0.92173288,0.22651188,1.5049054,-0.86563296,-0.92397514,0.23100724,1.5073318,-0.86563296,-0.9262174,0.20745806,1.5050029,-0.86575211,-0.91613263,0.26801001,1.5381819,-0.86548131,-0.91164811,0.29267491,1.5327441,-0.86534049,-0.91276382,0.28259014,1.54011,-0.86541631,-0.91276382,0.28594811,1.5394493,-0.86540548,-0.91276382,0.2848324,1.5338815,-0.86538382,-0.91389037,0.28146359,1.5324083,-0.86539465,-0.91389037,0.28033704,1.5365462,-0.86541631,-0.91052156,0.2848324,1.5343365,-0.86538382,-0.91164811,0.28259014,1.5354955,-0.86540548,-0.91164811,0.28931693,1.5322025,-0.86535132,-0.91500608,0.28370585,1.5330583,-0.86539465,-0.91500608,0.27585251,1.5358313,-0.86543798,-0.9284705,0.22876498,1.5298195,-0.86566545,-0.92958621,0.21978509,1.5384202,-0.86573045,-0.92958621,0.20970032,1.5316934,-0.86577378,-0.89369916,0.3543534,1.5363621,-0.86496136,-0.92734395,0.22763843,1.5393518,-0.86568712,-0.90379477,0.32519314,1.5416374,-0.86513468,-0.92173288,0.25006107,1.5346181,-0.86555713,-0.91613263,0.28707466,1.543728,-0.86539465,-0.9183749,0.27025227,1.5388752,-0.86547047,-0.92397514,0.24557654,1.5402075,-0.86560046,-0.92510169,0.24333428,1.5389727,-0.86561129,-0.92173288,0.26128322,1.541724,-0.86552464,-0.9183749,0.26912572,1.5409116,-0.86547047,-0.93182848,0.21642711,1.5356472,-0.86575211,-0.91949061,0.2646412,1.5368387,-0.86549214,-0.92397514,0.2478188,1.5422981,-0.86560046,-0.91949061,0.27136799,1.5397526,-0.86544881,-0.92958621,0.23100724,1.5433489,-0.86568712,-0.91613263,0.2848324,1.540045,-0.86538382,-0.93182848,0.22539617,1.5393626,-0.86569795,-0.93295503,0.21866938,1.5409874,-0.86574128,-0.92061716,0.26015667,1.5396226,-0.8655138,-0.92734395,0.23660748,1.5457211,-0.86566545,-0.90716358,0.31062385,1.5405433,-0.865243,-0.89258345,0.36332246,1.5436847,-0.86496136,-0.93295503,0.21418485,1.5444321,-0.86578461,-0.93855527,0.18615114,1.5470751,-0.86593626,-0.93295503,0.21194259,1.5474976,-0.86580627,-0.93295503,0.21866938,1.5509747,-0.86577378,-0.936313,0.19399364,1.5507797,-0.86591459,-0.93071276,0.2130583,1.550314,-0.86580627,-0.93519729,0.20633151,1.5484725,-0.8658496,-0.93407074,0.20633151,1.5500323,-0.8658496,-0.93743955,0.19175138,1.5478226,-0.86591459,-0.92958621,0.21642711,1.5426664,-0.86576294,-0.9284705,0.21978509,1.5441179,-0.86575211,-0.93407074,0.21081604,1.5378569,-0.86579544,-0.93071276,0.20745806,1.5398609,-0.8658171,-0.93295503,0.19512019,1.5415399,-0.8658821,-0.93295503,0.20633151,1.5413557,-0.86582794,-0.93295503,0.20408925,1.5400234,-0.86583877,-0.93295503,0.20073127,1.5411066,-0.86586043,-0.92397514,0.2399763,1.5439013,-0.86564379,-0.93407074,0.19287793,1.5445296,-0.86590376,-0.92958621,0.22202736,1.5429372,-0.86574128,-0.9262174,0.23100724,1.5442371,-0.86570878,-0.9284705,0.21754283,1.5429697,-0.86576294,-0.93519729,0.19512019,1.538756,-0.86587127,-0.93519729,0.19287793,1.5374453,-0.8658821,-0.93407074,0.20521579,1.5394493,-0.86582794,-0.93743955,0.19063567,1.5465227,-0.86591459,-0.92285942,0.23773403,1.5452878,-0.86566545,-0.89258345,0.34874233,1.5376078,-0.86500469,-0.8174622,0.62459491,1.5427206,-0.86355318,-0.82755781,0.59096095,1.5452662,-0.86374816,-0.9262174,0.23884975,1.5455045,-0.86565462,-0.82531554,0.59880346,1.5398826,-0.86371566,-0.93295503,0.21530056,1.5530762,-0.8658171,-0.93407074,0.20521579,1.5441288,-0.86587127,-0.93968182,0.19175138,1.5398826,-0.86592543,-0.93295503,0.2130583,1.5418324,-0.86582794,-0.936313,0.18615114,1.5393951,-0.86594709,-0.92958621,0.22763843,1.5387885,-0.86573045,-0.83204233,0.57749654,1.5359938,-0.86384565,-0.80960886,0.65375517,1.536113,-0.86341236,-0.76026823,0.81634635,1.53243,-0.86251329,-0.84549591,0.51582888,1.5274255,-0.86412728,-0.83540031,0.50349101,1.5378569,-0.86414895,-0.83540031,0.50237529,1.5314551,-0.86412728,-0.82194673,0.56292724,1.534434,-0.86384565,-0.81521994,0.57076975,1.5301011,-0.86376982,-0.81521994,0.56516951,1.5345856,-0.86382398,-0.81409339,0.56965403,1.5346073,-0.86380232,-0.81073541,0.58871869,1.5379111,-0.86370483,-0.86456057,0.40705201,1.5428614,-0.86467972,-0.9183749,0.21418485,1.5302744,-0.86574128,-0.89482571,0.28594811,1.5364271,-0.86534049,-0.92061716,0.20297353,1.5312168,-0.86580627,-0.92397514,0.19960472,1.5252916,-0.86580627,-0.92173288,0.21194259,1.5356363,-0.86577378,-0.92397514,0.20408925,1.5366654,-0.8658171,-0.9262174,0.21418485,1.5319859,-0.86577378,-0.93071276,0.19847817,1.5375645,-0.86587127,-0.9284705,0.20633151,1.532365,-0.8658171,-0.83540031,0.54273604,1.5316393,-0.86398646,-0.9262174,0.21642711,1.5421032,-0.86577378,-0.92510169,0.20970032,1.5370229,-0.86580627,-0.93182848,0.18950912,1.5379869,-0.86591459,-0.9262174,0.2231539,1.5417782,-0.86575211,-0.92285942,0.20184698,1.5448329,-0.86583877,-0.89931024,0.28033704,1.5454828,-0.86541631,-0.90492131,0.25904095,1.5424931,-0.86553547,-0.91164811,0.23212296,1.5473459,-0.86569795,-0.91276382,0.20970032,1.5426556,-0.86579544,-0.91613263,0.20857377,1.5462627,-0.86580627,-0.91276382,0.22651188,1.5436197,-0.86570878,-0.91613263,0.20745806,1.5394384,-0.86580627,-0.91724835,0.20297353,1.5432189,-0.86583877,-0.89931024,0.27697906,1.5460136,-0.86544881,-0.92173288,0.21194259,1.5419623,-0.86579544,-0.92285942,0.21081604,1.5471943,-0.8658171,-0.92510169,0.19623591,1.5423306,-0.8658821,-0.91949061,0.20857377,1.5371095,-0.86580627,-0.91949061,0.20970032,1.5455153,-0.8658171,-0.92397514,0.20297353,1.5466527,-0.8658496,-0.92173288,0.20408925,1.5295378,-0.86580627,-0.92173288,0.20297353,1.5282163,-0.8658171,-0.90379477,0.24446082,1.5363729,-0.8655788,-0.91276382,0.21866938,1.5353114,-0.86574128,-0.91613263,0.21530056,1.54011,-0.86576294,-0.9183749,0.20073127,1.5369145,-0.86583877,-0.9183749,0.20073127,1.5368279,-0.86583877,-0.91613263,0.21418485,1.5319101,-0.86576294,-0.91724835,0.19736246,1.5332208,-0.8658496,-0.91389037,0.20857377,1.5325708,-0.86578461,-0.9183749,0.19063567,1.5256924,-0.86586043,-0.91052156,0.20970032,1.5296895,-0.86575211,-0.91724835,0.19287793,1.5308918,-0.86586043,-0.91276382,0.20745806,1.528043,-0.86577378,-0.89931024,0.25455643,1.5248366,-0.86550297,-0.91500608,0.19960472,1.5264073,-0.86582794,-0.91613263,0.20857377,1.531141,-0.86578461,-0.91949061,0.20633151,1.5284113,-0.86580627,-0.91949061,0.20073127,1.5290612,-0.86582794,-0.9183749,0.19960472,1.5334482,-0.86583877,-0.9183749,0.20073127,1.5384419,-0.8658496,-0.91613263,0.20745806,1.5381277,-0.86580627,-0.9183749,0.19736246,1.5348781,-0.86583877,-0.91613263,0.20184698,1.5222261,-0.86580627,-0.9183749,0.19623591,1.5347481,-0.86586043,-0.82418899,0.52367138,1.5369145,-0.86405146,-0.84998044,0.43732799,1.5387993,-0.86448475,-0.91500608,0.20857377,1.5371528,-0.86579544,-0.91164811,0.20073127,1.5309243,-0.86580627,-0.91500608,0.19736246,1.5374886,-0.86586043,-0.90940584,0.20521579,1.5334374,-0.86580627,-0.91052156,0.19960472,1.5330691,-0.86582794,-0.91052156,0.20970032,1.5348131,-0.86578461,-0.91949061,0.1883934,1.5477034,-0.86594709,-0.91389037,0.20633151,1.5466094,-0.8658496,-0.91613263,0.19847817,1.5438363,-0.86587127,-0.91389037,0.20073127,1.5383336,-0.8658496,-0.90267905,0.21530056,1.532105,-0.86574128,-0.89931024,0.24221856,1.5352247,-0.86561129,-0.90827929,0.21530056,1.535983,-0.86577378,-0.91500608,0.19175138,1.5382361,-0.86590376,-0.91052156,0.20970032,1.5381386,-0.86580627,-0.91164811,0.19623591,1.5314335,-0.86586043,-0.91052156,0.20633151,1.5335566,-0.86579544,-0.91164811,0.20521579,1.5370012,-0.8658171,-0.91500608,0.18950912,1.5360696,-0.86589293,-0.91164811,0.21754283,1.5351164,-0.86574128,-0.9183749,0.18502459,1.5325817,-0.86592543,-0.91500608,0.20073127,1.5279347,-0.86582794,-0.91389037,0.20633151,1.5260824,-0.86578461,-0.90043679,0.24894535,1.5230818,-0.86553547,-0.91052156,0.2130583,1.5308268,-0.86577378,-0.92061716,0.19063567,1.5240026,-0.8658821,-0.91389037,0.20745806,1.5271006,-0.86579544,-0.91949061,0.1883934,1.5342607,-0.86591459,-0.91164811,0.24221856,1.529852,-0.86558963,-0.91613263,0.22988069,1.5258874,-0.86564379,-0.91389037,0.2231539,1.5176549,-0.86565462,-0.91389037,0.23436522,1.531401,-0.86564379,-0.92173288,0.21642711,1.5353872,-0.86574128,-0.91724835,0.23212296,1.539211,-0.86566545,-0.91949061,0.20970032,1.4795039,-0.8655463,-0.8914569,0.27249453,1.4774458,-0.86517801,-0.91500608,0.22988069,1.4850283,-0.86540548,-0.92285942,0.21754283,1.5410633,-0.86574128,-0.91724835,0.23549177,1.5347806,-0.86563296,-0.92173288,0.2231539,1.5402292,-0.86570878,-0.92061716,0.2399763,1.545472,-0.86563296,-0.92397514,0.21754283,1.5391243,-0.86574128,-0.9183749,0.22539617,1.5347264,-0.86568712,-0.91500608,0.25006107,1.5365896,-0.8655463,-0.92397514,0.22091164,1.5367196,-0.86571962,-0.91724835,0.23549177,1.5337515,-0.86563296,-0.92285942,0.22651188,1.5332533,-0.86566545,-0.90827929,0.28146359,1.5355822,-0.86537298,-0.92285942,0.22763843,1.540305,-0.86568712,-0.92285942,0.22763843,1.5377703,-0.86567629,-0.92173288,0.23549177,1.5386802,-0.86563296,-0.92285942,0.22651188,1.5364488,-0.86567629,-0.9183749,0.24221856,1.5396984,-0.86560046,-0.92510169,0.21642711,1.5392001,-0.86574128,-0.92061716,0.23100724,1.5392976,-0.86566545,-0.92285942,0.21754283,1.536113,-0.86573045,-0.91949061,0.22651188,1.5316176,-0.86567629,-0.91724835,0.22876498,1.530686,-0.86566545,-0.91949061,0.23324951,1.5369795,-0.86565462,-0.90043679,0.30501277,1.5291262,-0.86522133,-0.92285942,0.22988069,1.5380736,-0.86567629,-0.92061716,0.23100724,1.5377486,-0.86566545,-0.92061716,0.23212296,1.5408466,-0.86565462,-0.92285942,0.22876498,1.5383227,-0.86567629,-0.9183749,0.23324951,1.5335566,-0.86564379,-0.92285942,0.22426962,1.535463,-0.86569795,-0.92285942,0.22988069,1.5344773,-0.86565462,-0.92734395,0.22091164,1.5366329,-0.86570878,-0.91949061,0.23549177,1.5365246,-0.86562213,-0.92510169,0.22763843,1.5366654,-0.86567629,-0.92397514,0.23884975,1.5357772,-0.86561129,-0.92061716,0.25118761,1.5359288,-0.86553547,-0.92510169,0.23324951,1.533784,-0.86564379,-0.9262174,0.22988069,1.5372395,-0.86566545,-0.92734395,0.21866938,1.5321484,-0.86570878,-0.9183749,0.2478188,1.5282921,-0.86553547,-0.9262174,0.22539617,1.529852,-0.86567629,-0.92510169,0.22651188,1.5316501,-0.86566545,-0.92397514,0.22426962,1.5272631,-0.86565462,-0.90940584,0.25006107,1.527848,-0.86553547,-0.91949061,0.20745806,1.5225944,-0.86574128,-0.92510169,0.19399364,1.5256166,-0.86583877,-0.92061716,0.21866938,1.5359396,-0.86573045,-0.91052156,0.25118761,1.535593,-0.86553547,-0.90827929,0.25567214,1.5307402,-0.8655138,-0.91500608,0.23436522,1.5311843,-0.86561129,-0.9262174,0.20297353,1.5335782,-0.86580627,-0.92173288,0.21530056,1.535593,-0.86574128,-0.92285942,0.21194259,1.5356688,-0.86575211,-0.92173288,0.21530056,1.5356472,-0.86574128,-0.9262174,0.19399364,1.5330258,-0.86583877,-0.92397514,0.20408925,1.533979,-0.86579544,-0.92285942,0.21081604,1.5324517,-0.86575211,-0.9262174,0.20297353,1.533719,-0.86580627,-0.9183749,0.2231539,1.5326792,-0.86569795,-0.91949061,0.2231539,1.5348673,-0.86569795,-0.92173288,0.21194259,1.5318342,-0.86576294,-0.92510169,0.19847817,1.5249341,-0.8658171,-0.91613263,0.23436522,1.5336432,-0.86563296,-0.92285942,0.20633151,1.5242409,-0.86577378,-0.90603703,0.27361025,1.5334157,-0.86540548,-0.92173288,0.20970032,1.5327766,-0.86577378,-0.92734395,0.19175138,1.5333832,-0.86587127,-0.92397514,0.20745806,1.5262773,-0.86577378,-0.92734395,0.19063567,1.5302527,-0.86586043,-0.92285942,0.20521579,1.5339249,-0.86579544,-0.92510169,0.20857377,1.5348998,-0.86577378,-0.91949061,0.22091164,1.530751,-0.86569795,-0.92285942,0.20408925,1.5322242,-0.86578461,-0.9262174,0.19063567,1.5292237,-0.86586043,-0.92397514,0.20297353,1.5309352,-0.86579544,-0.92734395,0.18726685,1.5332858,-0.8658821,-0.92061716,0.20970032,1.5246525,-0.86573045,-0.92285942,0.19960472,1.5305235,-0.86582794,-0.92285942,0.19287793,1.5192797,-0.86583877,-0.92397514,0.20184698,1.5154126,-0.86580627,-0.9284705,0.18615114,1.5256924,-0.86589293,-0.92397514,0.20073127,1.529657,-0.86582794,-0.92734395,0.18390887,1.5266998,-0.86589293,-0.91389037,0.23660748,1.5276314,-0.86561129,-0.9183749,0.20745806,1.5193339,-0.86575211,-0.92285942,0.19512019,1.5273714,-0.86583877,-0.92397514,0.20297353,1.5292237,-0.86580627,-0.92397514,0.19399364,1.5252266,-0.8658496,-0.92285942,0.20184698,1.5248583,-0.86580627,-0.92734395,0.19063567,1.5259632,-0.86586043,-0.9183749,0.22876498,1.5241867,-0.86565462,-0.92173288,0.20970032,1.5234176,-0.86576294,-0.91724835,0.2231539,1.5284438,-0.86568712,-0.87016081,0.40705201,1.5256707,-0.86466889,-0.81858875,0.57301201,1.5201355,-0.86374816,-0.90603703,0.2646412,1.5235368,-0.86545964,-0.92285942,0.19960472,1.5223669,-0.86580627,-0.91949061,0.19847817,1.5212404,-0.86580627,-0.90827929,0.25006107,1.5246742,-0.86552464,-0.92397514,0.19736246,1.5284438,-0.86582794,-0.92397514,0.19847817,1.5294512,-0.86582794,-0.92397514,0.1883934,1.5280105,-0.86589293,-0.91949061,0.20633151,1.5283138,-0.86579544,-0.92397514,0.1883934,1.5269923,-0.8658821,-0.92061716,0.19623591,1.5272631,-0.8658496,-0.9183749,0.20633151,1.5281621,-0.86578461,-0.85446497,0.43284346,1.5281838,-0.86448475,-0.89482571,0.28146359,1.5271656,-0.86534049,-0.90603703,0.2399763,1.5259524,-0.86560046,-0.92173288,0.19960472,1.5289637,-0.86582794,-0.89706798,0.28259014,1.529332,-0.86532966,-0.9183749,0.20857377,1.5293862,-0.86579544,-0.8914569,0.30164396,1.5297328,-0.86522133,-0.92510169,0.19736246,1.5307077,-0.8658496,-0.92061716,0.21642711,1.5323542,-0.86574128,-0.92173288,0.20633151,1.5296786,-0.86579544,-0.92397514,0.20408925,1.5326792,-0.86579544,-0.90043679,0.27697906,1.5291695,-0.86537298,-0.91613263,0.23324951,1.5337515,-0.86566545,-0.90603703,0.2646412,1.5327766,-0.86548131,-0.92510169,0.19847817,1.5371853,-0.86586043,-0.91164811,0.2478188,1.5354522,-0.86555713,-0.92285942,0.20184698,1.537337,-0.86583877,-0.92285942,0.20184698,1.5348998,-0.86583877,-0.9262174,0.18615114,1.5363729,-0.86592543,-0.92734395,0.19399364,1.535983,-0.86589293,-0.92734395,0.19847817,1.5360046,-0.86586043,-0.92397514,0.22426962,1.538496,-0.86571962,-0.93407074,0.19960472,1.5388968,-0.8658821,-0.93519729,0.18950912,1.5400017,-0.86594709,-0.92734395,0.21530056,1.5380628,-0.86579544,-0.92734395,0.21530056,1.5380628,-0.86579544,-0.92734395,0.21530056,1.5380628,-0.86579544,-0.92734395,0.21530056,1.5380628,-0.86579544,-0.92734395,0.21530056,1.5380628,-0.86579544,-0.92734395,0.21530056,1.5380628,-0.86579544,-0.92734395,0.21530056,1.5380628,-0.86579544:4
0.88563802,0.49951804,1.3280854,-0.94878254,0.86976228,0.4942329,1.3193954,-0.94880287,0.87611461,0.49211885,1.3236438,-0.9487927,0.88139975,0.48789074,1.3263169,-0.94878254,0.87822866,0.48259543,1.3242537,-0.94881303,0.87822866,0.48153841,1.3245586,-0.94881303,0.8835138,0.47942435,1.3272824,-0.94880287,0.88245677,0.47519624,1.3269572,-0.94881303,0.87400055,0.46884391,1.3230747,-0.94886385,0.88669505,0.46672986,1.3301994,-0.94887401,0.87611461,0.46144472,1.3241419,-0.94887401,0.86976228,0.46038769,1.3208285,-0.94890451,0.87081931,0.45403536,1.3219058,-0.94891467,0.87400055,0.45614942,1.3237251,-0.94889434,0.87400055,0.45297833,1.3231966,-0.94890451,0.87400055,0.45086428,1.3232576,-0.94891467,0.87294353,0.45192131,1.3226275,-0.94891467,0.87294353,0.44980725,1.3235524,-0.94891467,0.86447714,0.44451195,1.3187043,-0.94896549,0.85283967,0.44028384,1.3124942,-0.94896549,0.85813498,0.43816978,1.3162853,-0.94895532,0.86553417,0.43711276,1.3198223,-0.94897565,0.859192,0.4297034,1.3167731,-0.94897565,0.8665912,0.43394167,1.3204626,-0.94898582,0.86447714,0.43181746,1.3195783,-0.94899598,0.86342011,0.43287448,1.3183282,-0.94900614,0.86447714,0.42124718,1.3195987,-0.94902647,0.86236309,0.42441826,1.3195072,-0.94901631,0.86553417,0.41912296,1.3181148,-0.9490468,0.86870525,0.41912296,1.321855,-0.94901631,0.87294353,0.42124718,1.3233389,-0.94900614,0.88139975,0.41278079,1.3291831,-0.94902647,0.87928569,0.41278079,1.3287765,-0.9490468,0.87822866,0.40855268,1.3281769,-0.94905696,0.8835138,0.40749566,1.3305857,-0.9490468,0.8835138,0.40220036,1.3305145,-0.94905696,0.87822866,0.4000863,1.3284716,-0.94907729,0.88034272,0.39585819,1.3289391,-0.94907729,0.88245677,0.39902927,1.3295591,-0.94906713,0.87822866,0.38950586,1.3274857,-0.94905696,0.8835138,0.39267694,1.3299352,-0.94907729,0.87505758,0.38739181,1.3259307,-0.94907729,0.88563802,0.39374413,1.3313683,-0.94906713,0.87400055,0.38104964,1.3254123,-0.94909762,0.87400055,0.38316369,1.3255444,-0.94909762,0.88034272,0.38633478,1.3292949,-0.94910778,0.8835138,0.37892542,1.3309414,-0.94911794,0.88139975,0.37998245,1.3291221,-0.94911794,0.88139975,0.37892542,1.329864,-0.94911794,0.89303721,0.37786839,1.3363383,-0.94908745,0.89303721,0.37152623,1.3363383,-0.94909762,0.89726532,0.36941217,1.3380865,-0.94913827,0.89938954,0.37786839,1.3397533,-0.94910778,0.8888091,0.37258326,1.3342446,-0.94910778,0.89833252,0.37152623,1.3394179,-0.94912811,0.89409424,0.36623093,1.3369888,-0.94910778,0.89833252,0.36623093,1.3393163,-0.94913827,0.89833252,0.36411687,1.339174,-0.94914844,0.87717164,0.35988876,1.3295083,-0.94918909,0.8835138,0.36200282,1.3323237,-0.9491586,0.89198019,0.36094579,1.3369075,-0.94912811,0.89303721,0.36305984,1.3374157,-0.94911794,0.89303721,0.35883173,1.3369786,-0.94912811,0.89303721,0.35777471,1.3372022,-0.94913827,0.89198019,0.35566065,1.3366737,-0.94914844,0.89409424,0.35036535,1.3376901,-0.94914844,0.88034272,0.3524794,1.3305653,-0.94919925,0.88775208,0.35353643,1.3349256,-0.94916876,0.88563802,0.34930832,1.3336246,-0.94917893,0.88669505,0.35142238,1.3344479,-0.94917893,0.88775208,0.35036535,1.3351898,-0.94916876,0.88986613,0.34719427,1.3364908,-0.94916876,0.89303721,0.34508021,1.3384219,-0.94920942,0.89092316,0.33872788,1.3372531,-0.94918909,0.89198019,0.34402318,1.3374157,-0.94917893,0.88986613,0.34508021,1.3363891,-0.94917893,0.88775208,0.33978491,1.3350882,-0.94919925,0.89303721,0.33767085,1.3375275,-0.94918909,0.8835138,0.32921463,1.3331469,-0.94923991,0.88458099,0.33344274,1.3337669,-0.94922974,-0.9571168,-0.85874209,1.3349357,-0.95879381,-0.9571168,-0.85874209,1.339672,-0.95879381,-0.9571168,-0.85874209,1.342152,-0.95879381,-0.9571168,-0.85768506,1.3463801,-0.95878365,-0.9571168,-0.85768506,1.3461158,-0.95878365,-0.9571168,-0.85874209,1.3411864,-0.95879381,-0.9571168,-0.85768506,1.3452722,-0.95878365,-0.9571168,-0.85768506,1.345689,-0.95878365,-0.9571168,-0.85768506,1.3467561,-0.95878365,-0.9571168,-0.85768506,1.3490836,-0.95878365,-0.9571168,-0.85768506,1.347244,-0.95878365,-0.9571168,-0.85768506,1.3485653,-0.95878365,-0.9571168,-0.85768506,1.3485958,-0.95878365,-0.9571168,-0.85768506,1.3458516,-0.95878365,-0.9571168,-0.85768506,1.3451909,-0.95878365,-0.9571168,-0.85768506,1.3498053,-0.95878365,-0.9571168,-0.85768506,1.3514823,-0.95878365,-0.9571168,-0.85768506,1.3515636,-0.95878365,-0.9571168,-0.85768506,1.3525088,-0.95878365,-0.9571168,-0.85768506,1.3548668,-0.95878365,-0.9571168,-0.85768506,1.3555478,-0.95878365,-0.9571168,-0.85768506,1.3560966,-0.95878365,-0.9571168,-0.85662803,1.3569809,-0.95878365,-0.9571168,-0.85768506,1.3519295,-0.95878365,-0.9571168,-0.85768506,1.3528036,-0.95878365,-0.9571168,-0.85768506,1.3548058,-0.95878365,-0.9571168,-0.85768506,1.3548668,-0.95878365,-0.9571168,-0.85662803,1.3573163,-0.95878365,-0.9571168,-0.85768506,1.3559442,-0.95878365,-0.9571168,-0.85768506,1.3557206,-0.95878365,-0.9571168,-0.85768506,1.3545212,-0.95878365,-0.9571168,-0.85662803,1.3553953,-0.95878365,-0.9571168,-0.85768506,1.3544196,-0.95878365,-0.9571168,-0.85768506,1.3553547,-0.95878365,-0.9571168,-0.85768506,1.3526613,-0.95878365,-0.9571168,-0.85768506,1.3533524,-0.95878365,-0.9571168,-0.85768506,1.3556799,-0.95878365,-0.9571168,-0.85874209,1.3434631,-0.95879381,-0.9571168,-0.85874209,1.3399871,-0.95879381,-0.9571168,-0.85874209,1.3400074,-0.95879381,-0.9571168,-0.85874209,1.3413694,-0.95879381,-0.9571168,-0.85874209,1.3415015,-0.95879381,-0.9571168,-0.85874209,1.3381881,-0.95879381,-0.9571168,-0.85874209,1.3402717,-0.95879381,-0.9571168,-0.85874209,1.341349,-0.95879381,-0.9571168,-0.85874209,1.3398143,-0.95879381,-0.9571168,-0.85874209,1.3396619,-0.95879381,-0.9571168,-0.85874209,1.3395094,-0.95879381,-0.9571168,-0.85874209,1.339916,-0.95879381,-0.9571168,-0.85874209,1.3337771,-0.95879381,-0.9571168,-0.85874209,1.3366026,-0.95879381,-0.9571168,-0.85874209,1.3373649,-0.95879381,-0.9571168,-0.85874209,1.3411559,-0.95879381,-0.9571168,-0.85874209,1.3416946,-0.95879381,-0.9571168,-0.85874209,1.3409527,-0.95879381,-0.9571168,-0.85874209,1.3416438,-0.95879381,-0.9571168,-0.85874209,1.3399058,-0.95879381,-0.9571168,-0.85874209,1.3401192,-0.95879381,-0.9571168,-0.85874209,1.3410136,-0.95879381,-0.9571168,-0.85874209,1.3417353,-0.95879381,-0.9571168,-0.85874209,1.3384829,-0.95879381,-0.9571168,-0.85874209,1.337873,-0.95879381,-0.9571168,-0.85874209,1.3356574,-0.95879381,-0.9571168,-0.85874209,1.3336043,-0.95879381,-0.9571168,-0.85874209,1.3377308,-0.95879381,-0.9571168,-0.85874209,1.3390622,-0.95879381,-0.9571168,-0.85874209,1.3389402,-0.95879381,-0.9571168,-0.85874209,1.3418776,-0.95879381,-0.9571168,-0.85874209,1.3403835,-0.95879381,-0.9571168,-0.85874209,1.3411356,-0.95879381,-0.9571168,-0.85874209,1.3396924,-0.95879381,-0.9571168,-0.85874209,1.3392756,-0.95879381,-0.9571168,-0.85768506,1.3445405,-0.95878365,-0.9571168,-0.85874209,1.342772,-0.95879381,-0.9571168,-0.85874209,1.3376799,-0.95879381,-0.9571168,-0.85874209,1.3361147,-0.95879381,-0.9571168,-0.85874209,1.3360537,-0.95879381,-0.9571168,-0.85874209,1.3374157,-0.95879381,-0.9571168,-0.85874209,1.3419894,-0.95879381,-0.9571168,-0.85874209,1.3406376,-0.95879381,-0.9571168,-0.85874209,1.3427415,-0.95879381,-0.9571168,-0.85874209,1.3416438,-0.95879381,-0.9571168,-0.85874209,1.3428431,-0.95879381,-0.9571168,-0.85768506,1.3447437,-0.95878365,-0.9571168,-0.85874209,1.3449165,-0.95879381,-0.9571168,-0.85768506,1.3462175,-0.95878365,-0.9571168,-0.85768506,1.345567,-0.95878365,-0.9571168,-0.85768506,1.3466545,-0.95878365,-0.9571168,-0.85768506,1.3464512,-0.95878365,-0.9571168,-0.85768506,1.346187,-0.95878365,-0.9571168,-0.85768506,1.3483518,-0.95878365,-0.9571168,-0.85768506,1.3453637,-0.95878365,-0.9571168,-0.85768506,1.3478742,-0.95878365,-0.9571168,-0.85979911,1.3222616,-0.95879381,-0.9571168,-0.85874209,1.3375376,-0.95879381,-0.9571168,-0.85874209,1.3428634,-0.95879381,-0.9571168,-0.85874209,1.3423044,-0.95879381,-0.9571168,-0.85874209,1.3373547,-0.95879381,-0.9571168,-0.85874209,1.3370803,-0.95879381,-0.9571168,-0.85874209,1.3386048,-0.95879381,-0.9571168,-0.85874209,1.335139,-0.95879381,-0.9571168,-0.85874209,1.3374563,-0.95879381,-0.9571168,-0.85874209,1.3395399,-0.95879381,-0.9571168,-0.85874209,1.337619,-0.95879381,-0.9571168,-0.85874209,1.3388793,-0.95879381,-0.9571168,-0.85874209,1.3417454,-0.95879381,-0.9571168,-0.85874209,1.3422943,-0.95879381,-0.9571168,-0.85768506,1.3425687,-0.95878365,-0.9571168,-0.85874209,1.3424467,-0.95879381,-0.9571168,-0.85874209,1.3411966,-0.95879381,-0.9571168,-0.85874209,1.3401497,-0.95879381,-0.9571168,-0.85874209,1.3380458,-0.95879381,-0.9571168,-0.85874209,1.3408409,-0.95879381,-0.9571168,-0.85874209,1.3417353,-0.95879381,-0.9571168,-0.85874209,1.3375478,-0.95879381,-0.9571168,-0.85874209,1.3388894,-0.95879381,-0.9571168,-0.85874209,1.340414,-0.95879381,-0.9571168,-0.85874209,1.3432192,-0.95879381,-0.9571168,-0.85874209,1.3433411,-0.95879381,-0.9571168,-0.85874209,1.343209,-0.95879381,-0.9571168,-0.85874209,1.3421723,-0.95879381,-0.9571168,-0.85874209,1.3430464,-0.95879381,-0.9571168,-0.85874209,1.3434224,-0.95879381,-0.9571168,-0.85874209,1.3446726,-0.95879381,-0.9571168,-0.85874209,1.3441542,-0.95879381,-0.9571168,-0.85874209,1.3433615,-0.95879381,-0.9571168,-0.85874209,1.3433919,-0.95879381,-0.9571168,-0.85874209,1.3446523,-0.95879381,-0.9571168,-0.85768506,1.3465935,-0.95878365,-0.9571168,-0.85874209,1.3432293,-0.95879381,-0.9571168,-0.85874209,1.3433005,-0.95879381,-0.9571168,-0.85768506,1.3455975,-0.95878365,-0.9571168,-0.85874209,1.3430159,-0.95879381,-0.9571168,-0.85874209,1.3424366,-0.95879381,-0.9571168,-0.85874209,1.3433005,-0.95879381,-0.9571168,-0.85768506,1.3447945,-0.95878365,-0.9571168,-0.85874209,1.3418572,-0.95879381,-0.9571168,-0.85768506,1.3447132,-0.95878365,-0.9571168,-0.85768506,1.3450283,-0.95878365,-0.9571168,-0.85874209,1.3425484,-0.95879381,-0.9571168,-0.85874209,1.3422434,-0.95879381,-0.9571168,-0.85874209,1.3423756,-0.95879381,-0.9571168,-0.85874209,1.3432903,-0.95879381,-0.9571168,-0.85874209,1.3419792,-0.95879381,-0.9571168,-0.85874209,1.3413694,-0.95879381,-0.9571168,-0.85874209,1.3406173,-0.95879381,-0.9571168,-0.85874209,1.3428025,-0.95879381,-0.9571168,-0.85874209,1.3437172,-0.95879381,-0.9571168,-0.85874209,1.3428025,-0.95879381,-0.9571168,-0.85874209,1.3431887,-0.95879381,-0.9571168,-0.85874209,1.343087,-0.95879381,-0.9571168,-0.86085614,1.3200154,-0.95879381,-0.9571168,-0.86085614,1.3200459,-0.95879381,-0.9571168,-0.86085614,1.3185416,-0.95879381,-0.9571168,-0.86085614,1.3156348,-0.95879381,-0.9571168,-0.86085614,1.315645,-0.95879381,-0.9571168,-0.86085614,1.3156145,-0.95879381,-0.9571168,-0.86085614,1.3162446,-0.95879381,-0.9571168,-0.86085614,1.3164987,-0.95879381,-0.9571168,-0.86085614,1.3164581,-0.95879381,-0.9571168,-0.86085614,1.3168951,-0.95879381,-0.9571168,-0.86085614,1.3173423,-0.95879381,-0.9571168,-0.86085614,1.314344,-0.95879381,-0.9571168,-0.86085614,1.3143237,-0.95879381,-0.9571168,-0.86085614,1.3163666,-0.95879381,-0.9571168,-0.86085614,1.316143,-0.95879381,-0.9571168,-0.86085614,1.3154214,-0.95879381,-0.9571168,-0.86085614,1.315025,-0.95879381,-0.9571168,-0.86085614,1.314903,-0.95879381,-0.9571168,-0.86085614,1.3136732,-0.95879381,-0.9571168,-0.86085614,1.3137139,-0.95879381,-0.9571168,-0.86085614,1.3134801,-0.95879381,-0.9571168,-0.86085614,1.3152486,-0.95879381,-0.9571168,-0.86085614,1.3139171,-0.95879381,-0.9571168,-0.86085614,1.3119759,-0.95879381,-0.9571168,-0.86085614,1.3116913,-0.95879381,-0.9571168,-0.86085614,1.3129516,-0.95879381,-0.9571168,-0.86085614,1.3108884,-0.95879381,-0.9571168,-0.86085614,1.3081441,-0.95879381,-0.9571168,-0.86191317,1.3086727,-0.95880398,-0.9571168,-0.86085614,1.3131955,-0.95879381,-0.9571168,-0.86085614,1.3131345,-0.95879381,-0.9571168,-0.86085614,1.3131447,-0.95879381,-0.9571168,-0.86085614,1.3137037,-0.95879381,-0.9571168,-0.86085614,1.312545,-0.95879381,-0.9571168,-0.86085614,1.3096179,-0.95879381,-0.9571168,-0.86085614,1.3109392,-0.95879381,-0.9571168,-0.86085614,1.3068534,-0.95879381,-0.9571168,-0.86085614,1.3072599,-0.95879381,-0.9571168,-0.86085614,1.3082255,-0.95879381,-0.95817382,-0.71804561,1.3060911,-0.9581535,-0.9571168,-0.86085614,1.3105733,-0.95879381,-0.9571168,-0.86085614,1.3086625,-0.95879381,-0.9571168,-0.86085614,1.3110002,-0.95879381,-0.9571168,-0.86085614,1.3118539,-0.95879381,-0.9571168,-0.86085614,1.3129211,-0.95879381,0.84966859,0.57251393,1.3097297,-0.94860976,0.85283967,0.61905363,1.3103192,-0.9484573,0.8538967,0.59578886,1.3117014,-0.94852845,0.85495373,0.58943653,1.312047,-0.94853861,0.85495373,0.58203734,1.312728,-0.94855894,0.85706779,0.59261778,1.3139578,-0.94852845,0.85601076,0.58626545,1.3135208,-0.94854878,0.85601076,0.57779906,1.3134598,-0.9485691,0.85495373,0.56722879,1.313104,-0.94859959,0.85813498,0.56087646,1.3147404,-0.94860976,0.85706779,0.55664835,1.3142221,-0.94863009,0.85495373,0.54395385,1.313785,-0.94867074,0.85706779,0.53972574,1.3150961,-0.9486809,0.8538967,0.53125936,1.3130431,-0.94871139,0.8538967,0.52808828,1.3133073,-0.94872156,0.85706779,0.52596406,1.3152791,-0.94871139,0.85072562,0.52279297,1.3121283,-0.94874189,0.85283967,0.51645081,1.3132362,-0.94875205,0.84861156,0.51433675,1.3107257,-0.94877238,0.84861156,0.50798442,1.3111018,-0.9487927,0.84544048,0.50058523,1.3095976,-0.9488232,0.85178265,0.49846101,1.3126365,-0.94881303,0.84966859,0.49528993,1.3118946,-0.9488232,0.85072562,0.49634696,1.3121588,-0.9488232,0.85072562,0.49317587,1.3120978,-0.94883336,0.85178265,0.49106182,1.3132158,-0.94883336,0.84649751,0.48365246,1.3108172,-0.94887401,0.85072562,0.48259543,1.3133683,-0.94886385,0.85072562,0.4773103,1.313165,-0.94887401,0.85072562,0.47836732,1.3132057,-0.94887401,0.8538967,0.47942435,1.3147404,-0.94885369,0.84755454,0.47625327,1.3114575,-0.94888418,0.85178265,0.47201499,1.3134801,-0.94888418,0.85178265,0.46778688,1.3139781,-0.94889434,0.85072562,0.46355877,1.313348,-0.94891467,0.84437329,0.46038769,1.310431,-0.94894516,0.84544048,0.45826347,1.3107054,-0.94894516,0.84966859,0.45403536,1.3124942,-0.94894516,0.85178265,0.45720644,1.3141611,-0.94892483,0.85706779,0.45826347,1.3164377,-0.94890451,0.85706779,0.45509239,1.3151165,-0.94892483,0.84437329,0.44980725,1.3133886,-0.94895532,0.84331626,0.4476932,1.3099126,-0.94898582,0.85283967,0.4476932,1.3138968,-0.94895532,0.84755454,0.44345492,1.3123214,-0.94898582,0.84966859,0.44134087,1.3130431,-0.94897565,0.84861156,0.43922681,1.3125145,-0.94898582,0.8538967,0.4349987,1.3160312,-0.94897565,0.85283967,0.43076043,1.3156958,-0.94899598,0.84966859,0.42864637,1.3141509,-0.94901631,0.84437329,0.42441826,1.3114067,-0.9490468,0.84966859,0.42336123,1.3140696,-0.94902647,0.84966859,0.41700891,1.3142017,-0.9490468,0.84861156,0.41278079,1.3135614,-0.94905696,0.84649751,0.40960971,1.3127178,-0.94907729,0.84437329,0.40855268,1.3118234,-0.94908745,0.84755454,0.40537144,1.3130736,-0.94908745,0.84649751,0.40220036,1.3128703,-0.94909762,0.84331626,0.40220036,1.3115592,-0.94910778,0.84331626,0.40325738,1.3111221,-0.94910778,0.84861156,0.39902927,1.3145676,-0.94909762,0.84649751,0.39585819,1.3127483,-0.94910778,0.84649751,0.39797224,1.3128906,-0.94910778,0.84966859,0.39267694,1.3149945,-0.94910778,0.84966859,0.38844883,1.3146591,-0.94911794,0.85495373,0.38950586,1.3175964,-0.94914844,0.85601076,0.39056289,1.3179217,-0.94913827,0.85706779,0.38633478,1.3186128,-0.94914844,0.85813498,0.38633478,1.3187551,-0.94913827,0.859192,0.38422072,1.3195478,-0.94913827,0.85813498,0.38104964,1.3186331,-0.9491586,0.85706779,0.52385,1.3192124,-0.94877238,0.85601076,0.52596406,1.3183993,-0.94876221,0.85813498,0.38104964,1.3188567,-0.9491586,0.86024903,0.38104964,1.3198019,-0.94914844,0.86236309,0.38422072,1.3210724,-0.94912811,0.86236309,0.37786839,1.320676,-0.94914844,0.86024903,0.37786839,1.3199137,-0.9491586,0.86236309,0.37469731,1.3209199,-0.9491586,0.86236309,0.3704692,1.3209301,-0.94916876,0.86024903,0.36941217,1.3195783,-0.94917893,0.86130606,0.36411687,1.3207268,-0.94918909,0.84120221,0.36200282,1.3100956,-0.94921958,0.84120221,0.36200282,1.3100956,-0.94921958,0.84120221,0.36200282,1.3100956,-0.94921958,0.84120221,0.36200282,1.3100956,-0.94921958,0.84120221,0.36200282,1.3100956,-0.94921958,0.84120221,0.36200282,1.3100956,-0.94921958,0.84120221,0.36200282,1.3100956,-0.94921958:0
-0.65002337,-0.65002337,1.7111461,-0.65002337,-0.65002337,-0.65002337,1.712099,-0.65002337,-0.65002337,-0.65002337,1.7127579,-0.65002337,-0.65002337,-0.65002337,1.7089462,-0.65002337,-0.65002337,-0.65002337,1.7065842,-0.65002337,-0.65002337,-0.65002337,1.7083684,-0.65002337,-0.65002337,-0.65002337,1.7098992,-0.65002337,-0.65002337,-0.65002337,1.7110042,-0.65002337,-0.65002337,-0.65002337,1.7097775,-0.65002337,-0.65002337,-0.65002337,1.7101425,-0.65002337,-0.65002337,-0.65002337,1.7101121,-0.65002337,-0.65002337,-0.65002337,1.7114806,-0.65002337,-0.65002337,-0.65002337,1.7077399,-0.65002337,1.7017689,5.2835054,1.6971563,-0.62242905,-0.45797826,-0.10851781,1.7076892,-0.64751941,-0.45797826,-0.11167057,1.7101121,-0.64752954,-0.45797826,-0.10956197,1.7090273,-0.64751941,-0.4569341,-0.11061627,1.7127681,-0.64752954,-0.4558798,-0.11167057,1.7146435,-0.64752954,-0.4569341,-0.11376904,1.7118861,-0.64753968,-0.4569341,-0.11691167,1.7110853,-0.64754982,-0.4558798,-0.1148132,1.7132445,-0.64754982,-0.4558798,-0.11691167,1.7130722,-0.64754982,-0.4558798,-0.11586751,1.7143901,-0.64754982,-0.45483563,-0.11691167,1.7153126,-0.64754982,-0.4558798,-0.11796597,1.7119672,-0.64755996,-0.4558798,-0.11901014,1.7115516,-0.64755996,-0.4558798,-0.1211086,1.7116834,-0.64757009,-0.45483563,-0.12006444,1.7153734,-0.64757009,-0.45483563,-0.11796597,1.7145827,-0.64755996,-0.4558798,-0.12006444,1.7114603,-0.64755996,-0.45483563,-0.1211086,1.7149476,-0.64757009,-0.45483563,-0.12006444,1.7146638,-0.64757009,-0.45378133,-0.11691167,1.7157282,-0.64755996,-0.45483563,-0.11901014,1.714086,-0.64755996,-0.45378133,-0.11901014,1.7135284,-0.64755996,-0.45378133,-0.1148132,1.7143698,-0.64754982,-0.45378133,-0.11376904,1.7160628,-0.64753968,-0.45273717,-0.1148132,1.7183944,-0.64754982,-0.45273717,-0.11691167,1.7189621,-0.64754982,-0.45273717,-0.11901014,1.7194082,-0.64755996,-0.45378133,-0.11901014,1.7162047,-0.64755996,-0.45273717,-0.1211086,1.71881,-0.64757009,-0.45378133,-0.1211086,1.7167318,-0.64757009,-0.45273717,-0.12006444,1.7175327,-0.64757009,-0.45378133,-0.11901014,1.7119875,-0.64755996,-0.45378133,-0.11796597,1.7164277,-0.64755996,-0.45378133,-0.11691167,1.7148564,-0.64754982,-0.45378133,-0.11586751,1.7134574,-0.64754982,-0.45273717,-0.1211086,1.717553,-0.64757009,-0.4558798,-0.12006444,1.7085509,-0.64755996,-0.4558798,-0.12320707,1.7087029,-0.64757009,-0.4558798,-0.12426137,1.7070911,-0.64758023,-0.4558798,-0.12530553,1.7065132,-0.64758023,-0.4569341,-0.1211086,1.7039079,-0.64755996,-0.4558798,-0.11901014,1.7067667,-0.64754982,-0.4558798,-0.12320707,1.7052663,-0.64757009,-0.46007673,-0.020361965,1.6968015,-0.64715445,-0.45797826,-0.127404,1.6969637,-0.64759037,-0.46007673,-0.12635983,1.6905162,-0.64757009,-0.46007673,-0.12320707,1.6904858,-0.64755996,-0.46007673,-0.1221629,1.6914286,-0.64755996,-0.46113103,-0.12426137,1.6875358,-0.64757009,-0.46113103,-0.12530553,1.6894315,-0.64757009,-0.46113103,-0.1284583,1.6869782,-0.64758023,-0.46113103,-0.12950246,1.6876169,-0.64759037,-0.45903257,-0.1284583,1.69522,-0.64758023,-0.45903257,-0.1284583,1.6954228,-0.64759037,-0.45903257,-0.12950246,1.6962743,-0.64759037,-0.45797826,-0.1284583,1.6971766,-0.64759037,-0.45797826,-0.13160093,1.6962034,-0.64760051,-0.45903257,-0.13160093,1.6951998,-0.64760051,-0.45797826,-0.13160093,1.7000556,-0.64760051,-0.4569341,-0.12950246,1.7026002,-0.64759037,-0.4569341,-0.13055677,1.7009781,-0.64760051,-0.4558798,-0.12950246,1.7057631,-0.64759037,-0.4569341,-0.1284583,1.7015053,-0.64759037,-0.4569341,-0.13055677,1.7027421,-0.64760051,-0.4569341,-0.12950246,1.7017892,-0.64759037,-0.4558798,-0.13160093,1.7053677,-0.64760051,-0.45797826,-0.13265523,1.7009072,-0.64760051,-0.45797826,-0.13265523,1.6991433,-0.64761064,-0.4569341,-0.1336994,1.7034213,-0.64761064,-0.4558798,-0.1336994,1.7040397,-0.64761064,-0.4558798,-0.1347537,1.7034923,-0.64761064,-0.4558798,-0.1347537,1.704212,-0.64761064,-0.4558798,-0.135808,1.7043235,-0.64762078,-0.4558798,-0.13685216,1.7058036,-0.64762078,-0.45483563,-0.13685216,1.7066349,-0.64763092,-0.45483563,-0.13685216,1.7095038,-0.64763092,-0.4569341,-0.13895063,1.7001874,-0.64763092,-0.4569341,-0.13895063,1.7017587,-0.64763092,-0.45797826,-0.1410491,1.6986871,-0.64764106,-0.45797826,-0.14000493,1.7008464,-0.64763092,-0.46007673,-0.1421034,1.6927363,-0.64764106,-0.46113103,-0.14524603,1.6895126,-0.64765119,-0.45903257,-0.14420186,1.6936487,-0.64765119,-0.45903257,-0.14524603,1.6926451,-0.64765119,-0.46007673,-0.14630033,1.6902932,-0.64765119,-0.46113103,-0.14630033,1.6855184,-0.64765119,-0.46113103,-0.14630033,1.6866538,-0.64765119,-0.46113103,-0.14734449,1.6852853,-0.64766133,-0.4621752,-0.14944296,1.6834605,-0.64766133,-0.4621752,-0.14839879,1.6822846,-0.64766133,-0.46113103,-0.14944296,1.6866234,-0.64766133,-0.46007673,-0.14944296,1.6887523,-0.64767147,-0.46113103,-0.14839879,1.6848088,-0.64766133,-0.46113103,-0.14944296,1.6842006,-0.64766133,-0.46113103,-0.15154142,1.6860861,-0.64767147,-0.46113103,-0.15154142,1.6851231,-0.64767147,-0.46113103,-0.15049726,1.6835822,-0.64767147,-0.4621752,-0.15363989,1.6799834,-0.64768161,-0.4632295,-0.15154142,1.6741847,-0.64766133,-0.4632295,-0.15363989,1.6778342,-0.64768161,-0.4632295,-0.075986516,1.6798414,-0.6473572,-0.4621752,-0.15259573,1.6805409,-0.64767147,-0.4621752,-0.15154142,1.6824164,-0.64767147,-0.4632295,-0.15049726,1.6788175,-0.64766133,-0.4621752,-0.15049726,1.6815243,-0.64767147,-0.4632295,-0.15259573,1.676638,-0.64767147,-0.4632295,-0.15469419,1.675756,-0.64768161,-0.4621752,-0.15679266,1.6777227,-0.64769174,-0.4621752,-0.15573836,1.680916,-0.64769174,-0.46113103,-0.15573836,1.6820615,-0.64768161,-0.4621752,-0.15783682,1.6802773,-0.64769174,-0.4621752,-0.15573836,1.6774692,-0.64768161,-0.46113103,-0.15573836,1.6789291,-0.64768161,-0.46007673,-0.15679266,1.6806423,-0.64769174,-0.46007673,-0.15469419,1.6803483,-0.64768161,-0.46007673,-0.15259573,1.6804497,-0.64767147,-0.46007673,-0.15469419,1.6802368,-0.64768161,-0.46113103,-0.15363989,1.6790304,-0.64767147,-0.46007673,-0.15573836,1.6806524,-0.64768161,-0.46113103,-0.15363989,1.6801962,-0.64768161,-0.46113103,-0.15573836,1.6802165,-0.64769174,-0.65002337,-0.65002337,1.6801456,-0.65002337,-0.65002337,-0.65002337,1.677449,-0.65002337,-0.65002337,-0.65002337,1.6776112,-0.65002337,-0.65002337,-0.65002337,1.6705352,-0.65002337,-0.65002337,-0.65002337,1.6739921,-0.65002337,-0.65002337,-0.65002337,1.6708697,-0.65002337,-0.65002337,-0.65002337,1.6737589,-0.65002337,-0.65002337,-0.65002337,1.6748943,-0.65002337,-0.65002337,-0.65002337,1.6754924,-0.65002337,-0.65002337,-0.65002337,1.6747423,-0.65002337,-0.65002337,-0.65002337,1.6772057,-0.65002337,-0.65002337,-0.65002337,1.6766684,-0.65002337,-0.65002337,-0.65002337,1.677449,-0.65002337,-0.65002337,-0.65002337,1.6791926,-0.65002337,-0.65002337,-0.65002337,1.6792332,-0.65002337,-0.65002337,-0.65002337,1.680987,-0.65002337,-0.65002337,-0.65002337,1.6792737,-0.65002337,-0.65002337,-0.65002337,1.6829739,-0.65002337,-0.65002337,-0.65002337,1.683937,-0.65002337,-0.65002337,-0.65002337,1.678412,-0.65002337,-0.65002337,-0.65002337,1.6797096,-0.65002337,-0.65002337,-0.65002337,1.6806423,-0.65002337,-0.65002337,-0.65002337,1.6831361,-0.65002337,-0.65002337,-0.65002337,1.684454,-0.65002337,-0.65002337,-0.65002337,1.6836329,-0.65002337,-0.65002337,-0.65002337,1.6830854,-0.65002337,-0.65002337,-0.65002337,1.6811796,-0.65002337,-0.65002337,-0.65002337,1.6823048,-0.65002337,-0.65002337,-0.65002337,1.6870087,-0.65002337,-0.65002337,-0.65002337,1.6878805,-0.65002337,-0.65002337,-0.65002337,1.6887929,-0.65002337,-0.65002337,-0.65002337,1.6905568,-0.65002337,-0.65002337,-0.65002337,1.6892592,-0.65002337,-0.65002337,-0.65002337,1.6925843,-0.65002337,-0.65002337,-0.65002337,1.6895329,-0.65002337,-0.65002337,-0.65002337,1.6897965,-0.65002337,-0.65002337,-0.65002337,1.6866437,-0.65002337,-0.65002337,-0.65002337,1.6883975,-0.65002337,-0.65002337,-0.65002337,1.6872824,-0.65002337,-0.65002337,-0.65002337,1.6888841,-0.65002337,-0.65002337,-0.65002337,1.6872215,-0.65002337,-0.65002337,-0.65002337,1.6882252,-0.65002337,-0.65002337,-0.65002337,1.6892997,-0.65002337,-0.65002337,-0.65002337,1.6872621,-0.65002337,-0.65002337,-0.65002337,1.6791419,-0.65002337,-0.65002337,-0.65002337,1.6814837,-0.65002337,-0.65002337,-0.65002337,1.6771651,-0.65002337,-0.65002337,-0.65002337,1.6771955,-0.65002337,-0.65002337,-0.65002337,1.6787364,-0.65002337,-0.65002337,-0.65002337,1.6770637,-0.65002337,-0.65002337,-0.65002337,1.6779863,-0.65002337,-0.65002337,-0.65002337,1.6762021,-0.65002337,-0.65002337,-0.65002337,1.6773577,-0.65002337,-0.65002337,-0.65002337,1.6781586,-0.65002337,-0.65002337,-0.65002337,1.6796285,-0.65002337,-0.65002337,-0.65002337,1.6754316,-0.65002337,-0.65002337,-0.65002337,1.6788885,-0.65002337,-0.65002337,-0.65002337,1.6787973,-0.65002337,-0.65002337,-0.65002337,1.6829435,-0.65002337,-0.65002337,-0.65002337,1.6805105,-0.65002337,-0.65002337,-0.65002337,1.6806017,-0.65002337,-0.65002337,-0.65002337,1.685853,-0.65002337,-0.65002337,-0.65002337,1.6833591,-0.65002337,-0.65002337,-0.65002337,1.6836835,-0.65002337,-0.65002337,-0.65002337,1.6792636,-0.65002337,-0.65002337,-0.65002337,1.6843628,-0.65002337,-0.65002337,-0.65002337,1.6759892,-0.65002337,-0.65002337,-0.65002337,1.6829638,-0.65002337,-0.65002337,-0.65002337,1.6783614,-0.65002337,-0.65002337,-0.65002337,1.6851433,-0.65002337,-0.65002337,-0.65002337,1.6844844,-0.65002337,-0.65002337,-0.65002337,1.6824265,-0.65002337,-0.65002337,-0.65002337,1.6797401,-0.65002337,-0.65002337,-0.65002337,1.6861267,-0.65002337,-0.65002337,-0.65002337,1.6817067,-0.65002337,-0.65002337,-0.65002337,1.6819399,-0.65002337,-0.65002337,-0.65002337,1.6835213,-0.65002337,-0.65002337,-0.65002337,1.6867451,-0.65002337,-0.65002337,-0.65002337,1.6843932,-0.65002337,-0.65002337,-0.65002337,1.6820007,-0.65002337,-0.65002337,-0.65002337,1.68416,-0.65002337,-0.65002337,-0.65002337,1.6852751,-0.65002337,-0.65002337,-0.65002337,1.6881643,-0.65002337,-0.65002337,-0.65002337,1.6852549,-0.65002337,-0.65002337,-0.65002337,1.6809464,-0.65002337,-0.65002337,-0.65002337,1.6813316,-0.65002337,-0.65002337,-0.65002337,1.6833085,-0.65002337,-0.65002337,-0.65002337,1.6838356,-0.65002337,-0.65002337,-0.65002337,1.6848291,-0.65002337,-0.65002337,-0.65002337,1.6842411,-0.65002337,-0.65002337,-0.65002337,1.6837038,-0.65002337,-0.65002337,-0.65002337,1.6850825,-0.65002337,-0.65002337,-0.65002337,1.6809566,-0.65002337,-0.65002337,-0.65002337,1.6804902,-0.65002337,-0.65002337,-0.55138534,1.6832071,-0.64960773,-0.65002337,-0.55138534,1.6840079,-0.64960773,-0.65002337,-0.55138534,1.6828725,-0.64960773,-0.65002337,-0.65002337,1.6842614,-0.65002337,-0.65002337,-0.65002337,1.6855894,-0.65002337,-0.65002337,-0.65002337,1.6848899,-0.65002337,-0.65002337,-0.65002337,1.6841093,-0.65002337,-0.65002337,-0.65002337,1.6855488,-0.65002337,-0.65002337,-0.65002337,1.6854779,-0.65002337,-0.65002337,-0.65002337,1.6847784,-0.65002337,-0.65002337,-0.65002337,1.6811289,-0.65002337,-0.65002337,-0.65002337,1.6863599,-0.65002337,-0.65002337,-0.65002337,1.6866944,-0.65002337,-0.65002337,-0.65002337,1.6883671,-0.65002337,-0.65002337,-0.65002337,1.6897863,-0.65002337,-0.65002337,-0.65002337,1.6873128,-0.65002337,-0.65002337,-0.65002337,1.6893403,-0.65002337,-0.65002337,-0.65002337,1.6863497,-0.65002337,-0.65002337,-0.65002337,1.6864004,-0.65002337,-0.65002337,-0.65002337,1.68416,-0.65002337,-0.65002337,-0.65002337,1.6876473,-0.65002337,-0.65002337,-0.65002337,1.6859442,-0.65002337,-0.65002337,-0.65002337,1.6848899,-0.65002337,-0.65002337,-0.65002337,1.6846973,-0.65002337,-0.65002337,-0.65002337,1.6854373,-0.65002337,-0.65002337,-0.65002337,1.6824062,-0.65002337,-0.65002337,-0.65002337,1.686664,-0.65002337,-0.65002337,-0.65002337,1.6842107,-0.65002337,-0.65002337,-0.65002337,1.686958,-0.65002337,-0.65002337,-0.65002337,1.6912157,-0.65002337,-0.65002337,-0.65002337,1.6858732,-0.65002337,-0.65002337,-0.65002337,1.6849305,-0.65002337,-0.65002337,-0.65002337,1.6841296,-0.65002337,-0.65002337,-0.65002337,1.686593,-0.65002337,-0.65002337,-0.65002337,1.6844743,-0.65002337,-0.65002337,-0.65002337,1.6857415,-0.65002337,-0.65002337,-0.65002337,1.6864105,-0.65002337,-0.65002337,-0.65002337,1.6832983,-0.65002337,-0.65002337,-0.65002337,1.6851433,-0.65002337,-0.65002337,-0.65002337,1.6788074,-0.65002337,-0.65002337,-0.65002337,1.6786351,-0.65002337,-0.65002337,-0.65002337,1.6748639,-0.65002337,-0.65002337,-0.65002337,1.6775199,-0.65002337,-0.65002337,-0.65002337,1.6805206,-0.65002337,-0.65002337,-0.65002337,1.6796488,-0.65002337,-0.65002337,-0.65002337,1.6750667,-0.65002337,-0.65002337,-0.65002337,1.6765062,-0.65002337,-0.65002337,-0.65002337,1.6746307,-0.65002337,-0.65002337,-0.65002337,1.6725019,-0.65002337,-0.65002337,-0.65002337,1.6743368,-0.65002337,-0.65002337,-0.65002337,1.6732419,-0.65002337,-0.65002337,-0.65002337,1.6711637,-0.65002337,-0.65002337,-0.65002337,1.6728161,-0.65002337,-0.65002337,-0.65002337,1.6759283,-0.65002337,-0.65002337,-0.65002337,1.6747017,-0.65002337,-0.65002337,-0.65002337,1.6743368,-0.65002337,-0.65002337,-0.65002337,1.6737082,-0.65002337,-0.65002337,-0.65002337,1.6767799,-0.65002337,-0.65002337,-0.65002337,1.6822643,-0.65002337,-0.65002337,-0.65002337,1.6836937,-0.65002337,-0.65002337,-0.65002337,1.682315,-0.65002337,-0.65002337,-0.65002337,1.6860354,-0.65002337,-0.65002337,-0.65002337,1.6828421,-0.65002337,-0.65002337,-0.65002337,1.6779761,-0.65002337,-0.65002337,-0.65002337,1.6838052,-0.65002337,-0.65002337,-0.65002337,1.6877183,-0.65002337,-0.65002337,-0.65002337,1.6863193,-0.65002337,-0.65002337,-0.65002337,1.6885496,-0.65002337,-0.65002337,-0.65002337,1.6868059,-0.65002337,-0.65002337,-0.65002337,1.6846669,-0.65002337,-0.65002337,-0.65002337,1.6837444,-0.65002337,-0.65002337,-0.65002337,1.6835518,-0.65002337,-0.65002337,-0.65002337,1.6847987,-0.65002337,-0.65002337,-0.65002337,1.6857921,-0.65002337,-0.65002337,-0.65002337,1.6868566,-0.65002337,-0.65002337,-0.65002337,1.6831665,-0.65002337,-0.65002337,-0.65002337,1.6833085,-0.65002337,-0.65002337,-0.65002337,1.6836227,-0.65002337,-0.65002337,-0.65002337,1.6837444,-0.65002337,-0.65002337,-0.65002337,1.6857313,-0.65002337,-0.65002337,-0.65002337,1.688063,-0.65002337,-0.65002337,-0.65002337,1.6839573,-0.65002337,-0.65002337,-0.65002337,1.6888131,-0.65002337,-0.65002337,-0.65002337,1.6861368,-0.65002337,-0.65002337,-0.65002337,1.690719,-0.65002337,-0.65002337,-0.65002337,1.689249,-0.65002337,-0.65002337,-0.65002337,1.6909015,-0.65002337,-0.65002337,-0.65002337,1.6902222,-0.65002337,-0.65002337,-0.65002337,1.6932331,-0.65002337,-0.65002337,-0.65002337,1.6890666,-0.65002337,-0.65002337,-0.65002337,1.6897863,-0.65002337,-0.65002337,-0.65002337,1.6918747,-0.65002337,-0.65002337,-0.65002337,1.6921078,-0.65002337,-0.65002337,-0.65002337,1.6951896,-0.65002337,-0.65002337,-0.65002337,1.6937501,-0.65002337,-0.65002337,-0.65002337,1.6949565,-0.65002337,-0.65002337,-0.65002337,1.6952505,-0.65002337,-0.65002337,-0.65002337,1.6938717,-0.65002337,-0.65002337,-0.65002337,1.6962034,-0.65002337,-0.65002337,-0.65002337,1.6926248,-0.65002337,-0.65002337,-0.65002337,1.6936589,-0.65002337,-0.65002337,-0.65002337,1.6865322,-0.65002337,-0.65002337,-0.65002337,1.6947943,-0.65002337,-0.65002337,-0.65002337,1.6902324,-0.65002337,-0.65002337,-0.65002337,1.6911042,-0.65002337,-0.65002337,-0.65002337,1.6952099,-0.65002337,-0.65002337,-0.65002337,1.6942975,-0.65002337,-0.65002337,-0.65002337,1.6908609,-0.65002337,-0.65002337,-0.65002337,1.6897661,-0.65002337,-0.65002337,-0.65002337,1.6925133,-0.65002337,-0.65002337,-0.65002337,1.6915503,-0.65002337,-0.65002337,-0.65002337,1.6892186,-0.65002337,-0.65002337,-0.65002337,1.6880325,-0.65002337,-0.65002337,-0.65002337,1.6890362,-0.65002337,-0.65002337,-0.65002337,1.6940542,-0.65002337,-0.65002337,-0.65002337,1.6943584,-0.65002337,-0.65002337,-0.65002337,1.6937501,-0.65002337,-0.65002337,-0.65002337,1.6946625,-0.65002337,-0.65002337,-0.65002337,1.6939427,-0.65002337,-0.65002337,-0.65002337,1.6948044,-0.65002337,-0.65002337,-0.65002337,1.6922396,-0.65002337,-0.65002337,-0.65002337,1.6932838,-0.65002337,-0.65002337,-0.65002337,1.6955242,-0.65002337,-0.65002337,-0.65002337,1.6931824,-0.65002337,-0.65002337,-0.65002337,1.6924322,-0.65002337,-0.65002337,-0.65002337,1.6948348,-0.65002337,-0.65002337,-0.65002337,1.6945408,-0.65002337,-0.65002337,-0.65002337,1.6934257,-0.65002337,-0.65002337,-0.65002337,1.6949362,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337,-0.65002337,-0.65002337,1.6954938,-0.65002337:0
-0.90923309,-0.90923309,1.5293518,-0.90923309,-0.90923309,-0.90923309,1.5275775,-0.90923309,-0.90923309,-0.90923309,1.530012,-0.90923309,-0.90923309,-0.90923309,1.528836,-0.90923309,-0.90923309,-0.90923309,1.5281139,-0.90923309,-0.90923309,-0.90923309,1.5258444,-0.90923309,-0.90923309,-0.90923309,1.5264943,-0.90923309,-0.90923309,-0.90923309,1.5262158,-0.90923309,-0.90923309,-0.90923309,1.5242868,-0.90923309,-0.90923309,-0.90923309,1.5251842,-0.90923309,-0.90923309,-0.90923309,1.5248335,-0.90923309,-0.90923309,-0.90923309,1.5245653,-0.90923309,-0.90923309,-0.90923309,1.5245034,-0.90923309,-0.90923309,-0.90923309,1.5241733,-0.90923309,-0.90923309,-0.90923309,1.5260507,-0.90923309,-0.90923309,-0.90923309,1.5260714,-0.90923309,-0.90923309,-0.90923309,1.5239257,-0.90923309,-0.90923309,-0.90923309,1.5232449,-0.90923309,-0.90923309,-0.90923309,1.5235234,-0.90923309,-0.90923309,-0.90923309,1.5226465,-0.90923309,-0.90923309,-0.90923309,1.5250295,-0.90923309,-0.90923309,-0.90923309,1.526123,-0.90923309,-0.90923309,-0.90923309,1.5231623,-0.90923309,-0.90923309,-0.90923309,1.5255143,-0.90923309,-0.90923309,-0.90923309,1.5258547,-0.90923309,-0.90923309,-0.90923309,1.5254318,-0.90923309,-0.90923309,-0.90923309,1.5274331,-0.90923309,-0.90923309,-0.90923309,1.5280623,-0.90923309,-0.90923309,-0.90923309,1.5287432,-0.90923309,-0.90923309,-0.90923309,1.5288773,-0.90923309,-0.90923309,-0.90923309,1.528248,-0.90923309,-0.90923309,-0.90923309,1.5295272,-0.90923309,-0.90923309,-0.90923309,1.5297747,-0.90923309,-0.90923309,-0.90923309,1.5297232,-0.90923309,-0.90923309,-0.90923309,1.5257206,-0.90923309,-0.90923309,-0.90923309,1.5285162,-0.90923309,-0.90923309,-0.90923309,1.5266594,-0.90923309,-0.90923309,-0.90923309,1.5275259,-0.90923309,-0.90923309,-0.90923309,1.5276497,-0.90923309,-0.90923309,-0.90923309,1.5285368,-0.90923309,-0.90923309,-0.90923309,1.5278354,-0.90923309,-0.90923309,-0.90923309,1.528279,-0.90923309,-0.90923309,-0.90923309,1.5276291,-0.90923309,-0.90923309,-0.90923309,1.5273608,-0.90923309,-0.90923309,-0.90923309,1.5280623,-0.90923309,-0.90923309,-0.90923309,1.5287741,-0.90923309,-0.90923309,-0.90923309,1.5283305,-0.90923309,-0.90923309,-0.90923309,1.5275568,-0.90923309,-0.90923309,-0.90923309,1.5275981,-0.90923309,-0.90923309,-0.90923309,1.5287947,-0.90923309,-0.90923309,-0.90923309,1.5291042,-0.90923309,-0.90923309,-0.90923309,1.5300533,-0.90923309,-0.90923309,-0.90923309,1.5297128,-0.90923309,-0.90923309,-0.90923309,1.530012,-0.90923309,-0.90923309,-0.90923309,1.5284337,-0.90923309,-0.90923309,-0.90923309,1.5292796,-0.90923309,-0.90923309,-0.90923309,1.5286297,-0.90923309,-0.90923309,-0.90923309,1.5257619,-0.90923309,-0.90923309,-0.90923309,1.5275053,-0.90923309,-0.90923309,-0.90923309,1.5283202,-0.90923309,-0.90923309,-0.90923309,1.5287638,-0.90923309,-0.90923309,-0.90923309,1.5259063,-0.90923309,-0.90923309,-0.90923309,1.5303421,-0.90923309,-0.90923309,-0.90923309,1.5293208,-0.90923309,-0.90923309,-0.90923309,1.5306516,-0.90923309,-0.90923309,-0.90923309,1.5273712,-0.90923309,-0.90923309,-0.90923309,1.5267832,-0.90923309,-0.90923309,-0.90923309,1.5267213,-0.90923309,-0.90923309,-0.90923309,1.5349223,-0.90923309,-0.90923309,-0.90923309,1.5338495,-0.90923309,-0.90923309,-0.90923309,1.5352834,-0.90923309,-0.90923309,-0.90923309,1.5343137,-0.90923309,-0.90923309,-0.90923309,1.5345922,-0.90923309,-0.90923309,-0.90923309,1.532168,-0.90923309,-0.90923309,-0.90923309,1.5321061,-0.90923309,-0.90923309,-0.90923309,1.5317244,-0.90923309,-0.90923309,-0.90923309,1.5321577,-0.90923309,-0.90923309,-0.90923309,1.5359745,-0.90923309,-0.90923309,-0.90923309,1.5362427,-0.90923309,-0.90923309,-0.90923309,1.526907,-0.90923309,-0.90923309,-0.90923309,1.5267213,-0.90923309,-0.90923309,-0.90923309,1.5258341,-0.90923309,-0.90923309,-0.90923309,1.5263602,-0.90923309,-0.90923309,-0.90923309,1.5264427,-0.90923309,-0.90923309,-0.90923309,1.525731,-0.90923309,-0.90923309,-0.90923309,1.5263809,-0.90923309,-0.90923309,-0.90923309,1.5261023,-0.90923309,-0.90923309,-0.90923309,1.5303627,-0.90923309,-0.90923309,-0.90923309,1.5287638,-0.90923309,-0.90923309,-0.90923309,1.5218213,-0.90923309,-0.90923309,-0.90923309,1.5238122,-0.90923309,-0.90923309,-0.90923309,1.5246375,-0.90923309,-0.90923309,-0.90923309,1.5232036,-0.90923309,-0.90923309,-0.90923309,1.5223371,-0.90923309,-0.90923309,-0.90923309,1.5218832,-0.90923309,-0.90923309,-0.7406735,1.5239876,-0.9085213,-0.90923309,-0.90923309,1.5258754,-0.90923309,-0.90923309,-0.90923309,1.5258857,-0.90923309,-0.90923309,-0.90923309,1.5262364,-0.90923309,-0.90923309,-0.90923309,1.5258444,-0.90923309,-0.90923309,-0.90923309,1.5220998,-0.90923309,-0.90923309,-0.90923309,1.5246478,-0.90923309,-0.90923309,-0.90923309,1.523771,-0.90923309,-0.90923309,-0.90923309,1.5250604,-0.90923309,-0.90923309,-0.90923309,1.5276187,-0.90923309,-0.90923309,-0.90923309,1.5255969,-0.90923309,-0.90923309,-0.90923309,1.5264118,-0.90923309,-0.90923309,-0.90923309,1.5275156,-0.90923309,-0.90923309,-0.90923309,1.5277116,-0.90923309,-0.90923309,-0.90923309,1.5268451,-0.90923309,-0.90923309,-0.90923309,1.5266594,-0.90923309,-0.90923309,-0.90923309,1.5275156,-0.90923309,-0.90923309,-0.90923309,1.5275672,-0.90923309,-0.90923309,-0.90923309,1.5265975,-0.90923309,-0.90923309,-0.90923309,1.5276084,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.525112,-0.90923309,-0.90923309,-0.90923309,1.5248438,-0.90923309,-0.90923309,-0.90923309,1.5237297,-0.90923309,-0.90923309,-0.90923309,1.5261539,-0.90923309,-0.90923309,-0.90923309,1.5255556,-0.90923309,-0.90923309,-0.90923309,1.5265046,-0.90923309,-0.90923309,-0.90923309,1.5254318,-0.90923309,-0.90923309,-0.90923309,1.5259785,-0.90916088,-0.90923309,-0.90923309,1.5267935,-0.90923309,-0.90923309,-0.90923309,1.527299,-0.90923309,-0.91030593,-0.74174634,1.5250501,-0.9085213,-0.91030593,-0.74174634,1.5245446,-0.9085213,-0.91030593,-0.74174634,1.5254627,-0.90853162,-0.90923309,-0.90923309,1.5261539,-0.90923309,-0.90923309,-0.90923309,1.5248025,-0.90923309,-0.90923309,-0.90923309,1.5248644,-0.90923309,-0.90923309,-0.90923309,1.523348,-0.90923309,-0.90923309,-0.90923309,1.5230695,-0.90923309,-0.90923309,-0.90923309,1.5234615,-0.90923309,-0.90923309,-0.90923309,1.525308,-0.90923309,-0.90923309,-0.90923309,1.5234099,-0.90923309,-0.90923309,-0.90923309,1.5238432,-0.90923309,-0.90923309,-0.90923309,1.522007,-0.90923309,-0.90923309,-0.90923309,1.5195415,-0.90923309,-0.90923309,-0.90923309,1.523348,-0.90923309,-0.90923309,-0.90923309,1.5242145,-0.90923309,-0.90923309,-0.90923309,1.5230592,-0.90923309,-0.90923309,-0.90923309,1.5219451,-0.90923309,-0.90923309,-0.90923309,1.5192217,-0.90923309,1.0319462,3.651676,1.5057081,-0.883062,0.33406413,0.13757976,1.5181179,-0.90232153,0.33406413,0.18052429,1.5192733,-0.90220806,0.33513697,0.16334854,1.5195724,-0.90224932,0.33835549,0.14509996,1.521192,-0.90229058,0.33620981,0.13436125,1.5194383,-0.90232153,0.34157401,0.14295428,1.5238432,-0.90228027,0.34157401,0.13006989,1.5238638,-0.90232153,0.34050117,0.12792421,1.522987,-0.90233184,0.34050117,0.13543409,1.5231211,-0.90231121,0.34050117,0.12576821,1.5226053,-0.90233184,0.34050117,0.12362253,1.5224299,-0.90234216,0.34157401,0.1171855,1.522956,-0.90235248,0.34157401,0.1171855,1.5238122,-0.90235248,0.33728265,0.11396698,1.5202223,-0.90237311,0.33728265,0.10644679,1.5200986,-0.90239374,0.34157401,0.10430111,1.5229148,-0.90238342,0.33835549,0.10108259,1.5203255,-0.90240406,0.34157401,0.098926594,1.5232449,-0.90240406,0.34373001,0.096780915,1.5244518,-0.90240406,0.33942833,0.096780915,1.521615,-0.90241437,0.34157401,0.099999433,1.5239566,-0.90240406,0.34264685,0.10322827,1.5244621,-0.90238342,0.34050117,0.099999433,1.5227084,-0.90240406,0.34264685,0.099999433,1.5245962,-0.90239374,0.34587569,0.096780915,1.5270823,-0.90242469,0.34157401,0.093562396,1.523379,-0.90241437,0.33942833,0.089271038,1.5214912,-0.902435,0.34157401,0.089271038,1.5226878,-0.90242469,0.33728265,0.083896525,1.5193764,-0.90245563,0.34050117,0.081750846,1.5223783,-0.90245563,0.34587569,0.080678006,1.5271133,-0.90246595,0.34587569,0.079605167,1.5268347,-0.90246595,0.33620981,0.069939295,1.5184583,-0.9024969,0.34802136,0.072084974,1.5276497,-0.90247627,0.34157401,0.066720776,1.523183,-0.90248658,0.34480285,0.063502258,1.5254009,-0.90251753,0.34694852,0.061356579,1.5265769,-0.90251753,0.34694852,0.058127744,1.5267625,-0.90251753,0.34802136,0.055982065,1.5272267,-0.90251753,0.34587569,0.054909226,1.5260817,-0.90252784,0.34480285,0.051690707,1.525339,-0.90254848,0.34264685,0.047399349,1.5232449,-0.90253816,0.34157401,0.042024836,1.5230282,-0.90254848,0.34050117,0.039879157,1.5217388,-0.90255879,0.33942833,0.040951996,1.5216665,-0.90255879,0.34050117,0.037733478,1.5221411,-0.90256911,0.34050117,0.035587798,1.5219451,-0.90256911,0.34157401,0.031286125,1.5224402,-0.90257942,0.34373001,0.032358964,1.5245034,-0.90256911,0.34480285,0.026994766,1.524524,-0.90257942,0.34587569,0.026994766,1.5258238,-0.90260005,0.34480285,0.022703408,1.5254112,-0.90262069,0.34264685,0.021630569,1.5242764,-0.90260005,0.34264685,0.018401734,1.5233583,-0.90261037,0.34050117,0.016256055,1.5215943,-0.90262069,0.34373001,0.014110376,1.5236472,-0.90261037,0.34264685,0.011964697,1.5226569,-0.90262069,0.34157401,0.0098190182,1.5216356,-0.902631,0.34373001,0.0076733392,1.5236575,-0.902631,0.34480285,0.0044445048,1.5242661,-0.902631,0.34480285,0.0022988258,1.5246684,-0.90264132,0.34373001,0.0012259862,1.5237194,-0.90265163,0.34373001,1.5314671E-4,1.5230592,-0.90265163,0.34802136,-0.0030653719,1.5267729,-0.90267227,0.34587569,-0.0041382114,1.5254421,-0.90268258,0.34587569,-0.0073670458,1.5251636,-0.90266195,0.34373001,-0.010585564,1.5229663,-0.90267227,0.34373001,-0.011658404,1.5233583,-0.90268258,0.34157401,-0.013804083,1.5222339,-0.9026929,0.34373001,-0.013804083,1.5241423,-0.90268258,0.34480285,-0.017022602,1.5242042,-0.9026929,0.34157401,-0.017022602,1.5219657,-0.90270321,0.34373001,-0.018095441,1.5233893,-0.9026929,0.34480285,-0.021324275,1.5241939,-0.90270321,0.34587569,-0.022397115,1.5248232,-0.90270321,0.34694852,-0.022397115,1.5256381,-0.90272384,0.34587569,-0.026688473,1.5251223,-0.90271353,0.34373001,-0.027761313,1.5237813,-0.90272384,0.34264685,-0.029906992,1.5221514,-0.90272384,0.34802136,-0.030979831,1.5260198,-0.90274448,0.34694852,-0.032052671,1.5250501,-0.90272384,0.34480285,-0.03312551,1.5244209,-0.90273416,0.34802136,-0.03419835,1.5267729,-0.90274448,0.34694852,-0.036354345,1.5258032,-0.90275479,0.34802136,-0.036354345,1.5264118,-0.90275479,0.3490942,-0.037427184,1.527268,-0.90275479,0.34373001,-0.040645703,1.5226569,-0.90275479,0.34264685,-0.041718542,1.5228425,-0.90275479,0.34480285,-0.040645703,1.5240392,-0.90274448,0.34264685,-0.041718542,1.5232139,-0.90275479,0.34694852,-0.043864221,1.5263086,-0.90277542,0.34694852,-0.043864221,1.5263705,-0.90277542,0.34694852,-0.044937061,1.5262364,-0.90277542,0.34802136,-0.048165895,1.5270307,-0.90278574,0.34802136,-0.048165895,1.5271648,-0.90278574,0.35231272,-0.048165895,1.5302286,-0.90276511,0.35338556,-0.050311574,1.5309301,-0.90276511,0.3544584,-0.050311574,1.5316109,-0.90276511,0.35231272,-0.052457253,1.5301255,-0.90277542,0.35553124,-0.051384414,1.5320236,-0.90276511,0.35553124,-0.053530093,1.5320958,-0.90276511,0.35553124,-0.053530093,1.5325806,-0.90276511,0.35553124,-0.054602932,1.532168,-0.90277542,0.3544584,-0.055675772,1.5316109,-0.90277542,0.35338556,-0.05889429,1.5308785,-0.90278574,0.35338556,-0.05889429,1.5311571,-0.90278574,0.3566144,-0.05889429,1.5326838,-0.90277542,0.35553124,-0.06103997,1.531745,-0.90278574,0.35553124,-0.062123125,1.5318173,-0.90278574,0.3566144,-0.063195964,1.5327869,-0.90278574,0.3566144,-0.064268804,1.5328901,-0.90278574,0.35876008,-0.063195964,1.534489,-0.90277542,0.3566144,-0.065341643,1.5329829,-0.90279605,0.35768724,-0.065341643,1.533344,-0.90278574,0.35983291,-0.066414483,1.5345406,-0.90278574,0.35983291,-0.068560162,1.5345406,-0.90278574,0.35983291,-0.069633002,1.5346954,-0.90278574,0.35768724,-0.069633002,1.5327869,-0.90279605,0.35876008,-0.070705841,1.5336431,-0.90279605,0.3566144,-0.071778681,1.5321474,-0.90280637,0.3566144,-0.07392436,1.531776,-0.90281669,0.3544584,-0.075007515,1.5305072,-0.902827,0.35123988,-0.077153194,1.5279076,-0.90283732,0.35338556,-0.077153194,1.5298263,-0.902827,0.37164447,0.091416717,1.5310642,-0.90235248,0.36734279,0.091416717,1.5278663,-0.90236279,0.37271731,0.091416717,1.5319926,-0.90235248,0.37379014,0.090343878,1.5327044,-0.90234216,0.36841563,0.090343878,1.5284027,-0.90236279,0.36734279,0.089271038,1.5280107,-0.90237311,0.36519711,0.089271038,1.5263293,-0.90237311,0.36519711,0.088198199,1.5259166,-0.90238342,0.35231272,-0.078226034,1.5285265,-0.90283732,0.35231272,-0.080371713,1.5286297,-0.90284763,0.35231272,-0.079298873,1.5280726,-0.90283732,0.35231272,-0.080371713,1.5289288,-0.90284763,0.35123988,-0.081444552,1.5280314,-0.90284763,0.35338556,-0.080371713,1.5296922,-0.90283732,0.35338556,-0.081444552,1.5292796,-0.90283732,0.3544584,-0.081444552,1.5299811,-0.90283732,0.3544584,-0.081444552,1.5300636,-0.90283732,0.35231272,-0.082517392,1.5283202,-0.90284763,0.35123988,-0.083590231,1.527268,-0.90285795,0.35123988,-0.082517392,1.5272061,-0.90284763,0.35123988,-0.084663071,1.5270101,-0.90285795,0.35338556,-0.084663071,1.5298985,-0.90284763,0.35338556,-0.084663071,1.5282171,-0.90284763,0.3566144,-0.084663071,1.5308785,-0.90283732,0.35768724,-0.084663071,1.5320133,-0.90283732,0.35553124,-0.08680875,1.5304968,-0.90284763,0.3544584,-0.08573591,1.5296819,-0.90284763,0.35338556,-0.08680875,1.5293931,-0.90284763,0.3544584,-0.08680875,1.5305897,-0.90283732,0.3544584,-0.08680875,1.5293208,-0.90284763,0.35338556,-0.088964745,1.5269895,-0.90286826,0.3566144,-0.090037584,1.5261849,-0.90286826,0.34802136,-0.087881589,1.5285781,-0.90285795,0.3566144,-0.090037584,1.5279901,-0.90286826,0.35338556,-0.090037584,1.5321577,-0.90283732,0.3566144,-0.091110424,1.5282686,-0.90286826,0.3544584,-0.091110424,1.5260095,-0.90285795,0.35016704,-0.093256103,1.5259063,-0.90287858,0.35016704,-0.091110424,1.5285678,-0.90287858,0.35123988,-0.093256103,1.5247613,-0.90287858,0.36519711,0.059200584,1.525339,-0.90241437,0.35231272,-0.092183263,1.52766,-0.90286826,0.35553124,-0.093256103,1.5299811,-0.90285795,0.3490942,-0.094328942,1.5256175,-0.9028889,0.35123988,-0.094328942,1.5269173,-0.90287858,0.34802136,-0.095401782,1.5242145,-0.90286826,0.34694852,-0.095401782,1.5235028,-0.90286826,0.34694852,-0.096474621,1.5243074,-0.90286826,0.34264685,-0.097547461,1.5208103,-0.9028889,0.34373001,-0.097547461,1.5217388,-0.9028889,0.34373001,-0.0986203,1.5214602,-0.9028889,0.34264685,-0.09969314,1.5209651,-0.90289921,0.34587569,-0.0986203,1.523152,-0.90287858,0.34802136,-0.0986203,1.5242661,-0.90286826,0.34802136,-0.0986203,1.5248851,-0.90286826,0.3490942,-0.097547461,1.5254627,-0.9028889,0.34694852,-0.09969314,1.5234615,-0.90287858,0.34587569,-0.10076598,1.5233377,-0.9028889,0.34802136,-0.10076598,1.5246169,-0.90287858,0.35231272,-0.10076598,1.5273815,-0.9028889,0.34802136,-0.10076598,1.5247819,-0.90287858,0.3490942,-0.10076598,1.5257516,-0.90289921,0.34587569,-0.10184913,1.5237503,-0.9028889,0.3490942,-0.10292197,1.5258032,-0.90290953,0.35231272,-0.10076598,1.5279592,-0.9028889,0.35338556,-0.10292197,1.528867,-0.9028889,0.3544584,-0.10292197,1.529032,-0.9028889,0.35231272,-0.10399481,1.527299,-0.90289921,0.34587569,-0.10506765,1.5228219,-0.90289921,0.35016704,-0.10506765,1.5260301,-0.90290953,0.35123988,-0.10506765,1.5267832,-0.90289921,0.34694852,-0.10721333,1.5236265,-0.90289921,0.35231272,-0.10506765,1.5275259,-0.90289921,0.35123988,-0.10614049,1.5261642,-0.90290953,0.3544584,-0.10614049,1.5283512,-0.9028889,0.35338556,-0.10721333,1.5285987,-0.90289921,-0.90923309,-0.90923309,1.5306413,-0.90923309,-0.90923309,-0.90923309,1.5300739,-0.90923309,-0.90923309,-0.90923309,1.5317141,-0.90923309,-0.90923309,-0.90923309,1.5306722,-0.90923309,-0.90923309,-0.90923309,1.5325703,-0.90923309,-0.90923309,-0.90923309,1.5316625,-0.90923309,-0.90923309,-0.90923309,1.5326838,-0.90923309,-0.90923309,-0.90923309,1.5316419,-0.90923309,-0.90923309,-0.90923309,1.5328798,-0.90923309,-0.90923309,-0.90923309,1.5292589,-0.90923309,-0.90923309,-0.90923309,1.5286297,-0.90923309,-0.90923309,-0.90923309,1.5275775,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309,-0.90923309,-0.90923309,1.5270514,-0.90923309:0
-0.72916433,-0.72916433,1.6543343,-0.72916433,-0.72916433,-0.72916433,1.6559783,-0.72916433,-0.72916433,-0.72916433,1.655948,-0.72916433,-0.72916433,-0.72916433,1.6561498,-0.72916433,-0.72916433,-0.72916433,1.6545864,-0.72916433,-0.72916433,-0.72916433,1.6531239,-0.72916433,-0.72916433,-0.72916433,1.6570777,-0.72916433,-0.72916433,-0.72916433,1.6589436,-0.72916433,-0.72916433,-0.72916433,1.6558068,-0.72916433,-0.72916433,-0.72916433,1.6551714,-0.72916433,-0.72916433,-0.72916433,1.6540418,-0.72916433,-0.72916433,-0.72916433,1.6495837,-0.72916433,-0.72916433,-0.72916433,1.6529928,-0.72916433,-0.72916433,-0.72916433,1.6498056,-0.72916433,-0.72916433,-0.72916433,1.649039,-0.72916433,-0.72916433,-0.72916433,1.6509756,-0.72916433,-0.72916433,-0.72916433,1.6508949,-0.72916433,-0.72916433,-0.72916433,1.6498459,-0.72916433,-0.72916433,-0.72916433,1.6527104,-0.72916433,-0.72916433,-0.72916433,1.6512782,-0.72916433,-0.72916433,-0.72916433,1.6508142,-0.72916433,-0.72916433,-0.72916433,1.6506327,-0.72916433,-0.72916433,-0.72916433,1.6507436,-0.72916433,-0.72916433,-0.72916433,1.6561598,-0.72916433,-0.72916433,-0.72916433,1.6556959,-0.72916433,-0.72916433,-0.72916433,1.6558068,-0.72916433,-0.72916433,-0.72916433,1.6579552,-0.72916433,-0.72916433,-0.72916433,1.6576728,-0.72916433,-0.72916433,-0.72916433,1.659105,-0.72916433,-0.72916433,-0.72916433,1.6599119,-0.72916433,-0.72916433,-0.72916433,1.6606078,-0.72916433,-0.72916433,-0.72916433,1.6587822,-0.72916433,-0.72916433,-0.72916433,1.6617274,-0.72916433,-0.72916433,-0.72916433,1.6632201,-0.72916433,-0.72916433,-0.72916433,1.6612432,-0.72916433,-0.72916433,-0.72916433,1.6622619,-0.72916433,-0.72916433,-0.72916433,1.6603859,-0.72916433,-0.72916433,-0.72916433,1.6596093,-0.72916433,-0.72916433,-0.72916433,1.6617173,-0.72916433,-0.72916433,-0.72916433,1.6612836,-0.72916433,-0.72916433,-0.72916433,1.6626351,-0.72916433,-0.72916433,-0.72916433,1.6602044,-0.72916433,-0.72916433,-0.72916433,1.6610314,-0.72916433,-0.72916433,-0.72916433,1.6608297,-0.72916433,-0.72916433,-0.72916433,1.6592159,-0.72916433,-0.72916433,-0.72916433,1.6607793,-0.72916433,-0.72916433,-0.72916433,1.6574105,-0.72916433,-0.72916433,-0.72916433,1.6616669,-0.72916433,0.28279505,0.034001023,1.6563212,-0.72379852,0.28279505,0.022462515,1.6564624,-0.72382878,0.28490304,0.025609381,1.6585402,-0.72380861,0.283844,0.018256608,1.6577232,-0.72383887,0.283844,0.00775697,1.6574105,-0.72385904,0.27964818,-0.001683627,1.6534668,-0.72389938,0.27964818,-0.0079874444,1.653134,-0.72391955,0.27859923,-0.014281176,1.6525389,-0.72392964,0.27964818,-0.018487083,1.6532752,-0.72393973,0.27964818,-0.023731859,1.6536585,-0.72394981,0.27859923,-0.02792768,1.6518934,-0.72396999,0.27859923,-0.032133587,1.651137,-0.7239599,0.27859923,-0.035280452,1.651843,-0.72399016,0.28069714,-0.038427318,1.6543242,-0.72399016,0.28279505,-0.041574184,1.6549495,-0.72399016,0.283844,-0.043672094,1.6558774,-0.72399016,0.28279505,-0.045780091,1.6548285,-0.72400024,0.283844,-0.045780091,1.6565229,-0.72399016,0.28490304,-0.047878001,1.65735,-0.72399016,0.28490304,-0.049975912,1.6574811,-0.72400024,0.285952,-0.052073822,1.6575316,-0.72400024,0.28490304,-0.053122777,1.6577333,-0.72401033,0.28700095,-0.055220688,1.6580863,-0.72400024,0.285952,-0.056269643,1.6589335,-0.72401033,0.28490304,-0.058377639,1.656997,-0.72402042,0.28700095,-0.06047555,1.6579047,-0.72402042,0.28069714,-0.06047555,1.6526499,-0.72404059,0.28174609,-0.059426595,1.6549697,-0.7240305,0.28700095,-0.063622416,1.6589133,-0.72402042,0.28804991,-0.06257346,1.6602044,-0.72402042,0.28804991,-0.063622416,1.6593672,-0.72402042,0.28909886,-0.064671371,1.6604061,-0.72402042,0.28804991,-0.064671371,1.6598312,-0.72402042,0.28279505,-0.068867192,1.655948,-0.72405067,0.285952,-0.068867192,1.6579552,-0.72404059,0.28490304,-0.070965102,1.6571987,-0.72405067,0.285952,-0.070965102,1.6572996,-0.72404059,0.28909886,-0.072024143,1.6597808,-0.7240305,0.28490304,-0.073073099,1.6568054,-0.72405067,0.28490304,-0.074122054,1.6568054,-0.72405067,0.28069714,-0.076219964,1.6539308,-0.72407085,0.28490304,-0.076219964,1.6569365,-0.72406076,0.283844,-0.07936683,1.655242,-0.72407085,0.28174609,-0.080415785,1.6540619,-0.72408093,0.28174609,-0.07936683,1.6542737,-0.72408093,0.283844,-0.080415785,1.6552017,-0.72407085,0.28279505,-0.080415785,1.6556858,-0.72408093,0.283844,-0.083562651,1.6544553,-0.72408093,0.283844,-0.082513696,1.6565835,-0.72408093,0.28490304,-0.085670647,1.6553731,-0.72408093,0.27964818,-0.089866468,1.6530231,-0.72411119,0.28174609,-0.088817513,1.653366,-0.7241011,0.28490304,-0.089866468,1.6554135,-0.72409102,0.285952,-0.089866468,1.658167,-0.72409102,0.27964818,-0.091964379,1.6525389,-0.72411119,0.28909886,-0.091964379,1.6589537,-0.72408093,0.28700095,-0.091964379,1.658056,-0.72409102,0.285952,-0.093013334,1.6575316,-0.72409102,0.29014782,-0.091964379,1.6602447,-0.72408093,0.28804991,-0.094062289,1.6597303,-0.72409102,-0.72916433,-0.72916433,1.6624536,-0.72916433,-0.72916433,-0.72916433,1.6646826,-0.72916433,-0.72916433,-0.72916433,1.6554942,-0.72916433,-0.72916433,-0.72916433,1.6586309,-0.72916433,-0.72916433,-0.72916433,1.6605977,-0.72916433,-0.72916433,-0.72916433,1.6580359,-0.72916433,-0.72916433,-0.72916433,1.6585603,-0.72916433,-0.72916433,-0.72916433,1.6607994,-0.72916433,-0.72916433,-0.72916433,1.658752,-0.72916433,-0.72916433,-0.72916433,1.6580459,-0.72916433,-0.72916433,-0.72916433,1.6581165,-0.72916433,-0.72916433,-0.72916433,1.657471,-0.72916433,-0.72916433,-0.72916433,1.65969,-0.72916433,-0.72916433,-0.72916433,1.6593571,-0.72916433,-0.72916433,-0.72916433,1.6577534,-0.72916433,-0.72916433,-0.72916433,1.658641,-0.72916433,-0.72916433,-0.72916433,1.6590747,-0.72916433,-0.72916433,-0.72916433,1.6576526,-0.72916433,-0.72916433,-0.72916433,1.6567953,-0.72916433,-0.72916433,-0.72916433,1.6575719,-0.72916433,-0.72916433,-0.72916433,1.6580359,-0.72916433,-0.72916433,-0.72916433,1.6556858,-0.72916433,-0.72916433,-0.72916433,1.6578644,-0.72916433,-0.72916433,-0.72916433,1.6552924,-0.72916433,-0.72916433,-0.72916433,1.6588932,-0.72916433,-0.72916433,-0.72916433,1.6559783,-0.72916433,-0.72916433,-0.72916433,1.6565129,-0.72916433,-0.72916433,-0.72916433,1.658288,-0.72916433,-0.72916433,-0.72916433,1.6569566,-0.72916433,-0.72916433,-0.72916433,1.6556959,-0.72916433,-0.72916433,-0.72916433,1.65618,-0.72916433,-0.72916433,-0.72916433,1.6552823,-0.72916433,-0.72916433,-0.72916433,1.6462956,-0.72916433,-0.72916433,-0.72916433,1.6502292,-0.72916433,-0.72916433,-0.72916433,1.6475362,-0.72916433,-0.72916433,-0.72916433,1.6526902,-0.72916433,-0.72916433,-0.72916433,1.6535677,-0.72916433,-0.72916433,-0.72916433,1.6528415,-0.72916433,-0.72916433,-0.72916433,1.6523977,-0.72916433,-0.72916433,-0.72916433,1.6541628,-0.72916433,-0.72916433,-0.72916433,1.658994,-0.72916433,-0.72916433,-0.72916433,1.6567953,-0.72916433,-0.72916433,-0.72916433,1.6563515,-0.72916433,-0.72916433,-0.72916433,1.6574609,-0.72916433,-0.72916433,-0.72916433,1.6577938,-0.72916433,-0.72916433,-0.72916433,1.6580661,-0.72916433,-0.72916433,-0.72916433,1.6587923,-0.72916433,-0.72916433,-0.72916433,1.6586713,-0.72916433,-0.72916433,-0.72916433,1.6559682,-0.72916433,-0.72916433,-0.72916433,1.6560287,-0.72916433,-0.72916433,-0.72916433,1.6543443,-0.72916433,-0.72916433,-0.72916433,1.655474,-0.72916433,-0.72916433,-0.72916433,1.6566641,-0.72916433,-0.72916433,-0.72916433,1.655948,-0.72916433,-0.72916433,-0.72916433,1.656765,-0.72916433,-0.72916433,-0.72916433,1.6566944,-0.72916433,-0.72916433,-0.72916433,1.6560186,-0.72916433,-0.72916433,-0.72916433,1.6559783,-0.72916433,-0.72916433,-0.72916433,1.6516211,-0.72916433,-0.72916433,-0.72916433,1.6573702,-0.72916433,-0.72916433,-0.72916433,1.6576627,-0.72916433,-0.72916433,-0.72916433,1.6577434,-0.72916433,-0.72916433,-0.72916433,1.6562405,-0.72916433,-0.72916433,-0.72916433,1.655474,-0.72916433,-0.72916433,-0.72916433,1.6523876,-0.72916433,-0.72916433,-0.72916433,1.6529424,-0.72916433,-0.72916433,-0.72916433,1.6496644,-0.72916433,-0.72916433,-0.72916433,1.6484742,-0.72916433,-0.72916433,-0.72916433,1.6511672,-0.72916433,-0.72916433,-0.72916433,1.6499771,-0.72916433,-0.72916433,-0.72916433,1.6495938,-0.72916433,-0.72916433,-0.72916433,1.6509958,-0.72916433,-0.72916433,-0.72916433,1.6487163,-0.72916433,-0.72916433,-0.72916433,1.6484036,-0.72916433,-0.72916433,-0.72916433,1.6484742,-0.72916433,-0.72916433,-0.72916433,1.6558371,-0.72916433,-0.72916433,-0.72916433,1.6558875,-0.72916433,-0.72916433,-0.72916433,1.6524179,-0.72916433,-0.72916433,-0.72916433,1.6563716,-0.72916433,-0.72916433,-0.72916433,1.6545461,-0.72916433,-0.72916433,-0.72916433,1.6506024,-0.72916433,-0.72916433,-0.72916433,1.6544553,-0.72916433,-0.72916433,-0.72916433,1.6540115,-0.72916433,-0.72916433,-0.72916433,1.6572491,-0.72916433,-0.72916433,-0.72916433,1.656997,-0.72916433,-0.72916433,-0.72916433,1.6585906,-0.72916433,-0.72916433,-0.72916433,1.6580258,-0.72916433,-0.72916433,-0.72916433,1.6592563,-0.72916433,-0.72916433,-0.72916433,1.6607591,-0.72916433,-0.72916433,-0.72916433,1.6616265,-0.72916433,-0.72916433,-0.72916433,1.6627461,-0.72916433,-0.72916433,-0.72916433,1.6595084,-0.72916433,-0.72916433,-0.72916433,1.6626956,-0.72916433,-0.72916433,-0.72916433,1.6648642,-0.72916433,-0.72916433,-0.72916433,1.6610718,-0.72916433,-0.72916433,-0.72916433,1.650794,-0.72916433,-0.72916433,-0.72916433,1.6488373,-0.72916433,-0.72916433,-0.72916433,1.6489886,-0.72916433,-0.72916433,-0.72916433,1.6505923,-0.72916433,-0.72916433,-0.72916433,1.6508747,-0.72916433,-0.72916433,-0.72916433,1.6492105,-0.72916433,-0.72916433,-0.72916433,1.6496442,-0.72916433,-0.72916433,-0.72916433,1.6489684,-0.72916433,-0.72916433,-0.72916433,1.6465579,-0.72916433,-0.72916433,-0.72916433,1.64798,-0.72916433,-0.72916433,-0.72916433,1.6445104,-0.72916433,-0.72916433,-0.72916433,1.643996,-0.72916433,-0.72916433,-0.72916433,1.644228,-0.72916433,-0.72916433,-0.72916433,1.645872,-0.72916433,-0.72916433,-0.72916433,1.6476673,-0.72916433,-0.72916433,-0.72916433,1.6462452,-0.72916433,-0.72916433,-0.72916433,1.6477178,-0.72916433,-0.72916433,-0.72916433,1.6497249,-0.72916433,-0.72916433,-0.72916433,1.6488272,-0.72916433,-0.72916433,-0.72916433,1.6489483,-0.72916433,-0.72916433,-0.72916433,1.6474051,-0.72916433,-0.72916433,-0.72916433,1.6486154,-0.72916433,-0.72916433,-0.72916433,1.6501485,-0.72916433,-0.72916433,-0.72916433,1.6506932,-0.72916433,-0.72916433,-0.72916433,1.6501687,-0.72916433,-0.72916433,-0.72916433,1.6472135,-0.72916433,-0.72916433,-0.72916433,1.6490895,-0.72916433,-0.72916433,-0.72916433,1.6461847,-0.72916433,-0.72916433,-0.72916433,1.6433101,-0.72916433,-0.72916433,-0.72916433,1.6420897,-0.72916433,-0.72916433,-0.72916433,1.6456905,-0.72916433,-0.72916433,-0.72916433,1.6438548,-0.72916433,-0.72916433,-0.72916433,1.6439254,-0.72916433,-0.72916433,-0.72916433,1.6408491,-0.72916433,-0.72916433,-0.72916433,1.6430176,-0.72916433,-0.72916433,-0.72916433,1.6433807,-0.72916433,-0.72916433,-0.72916433,1.6417972,-0.72916433,-0.72916433,-0.72916433,1.6422713,-0.72916433,-0.72916433,-0.72916433,1.6450752,-0.72916433,-0.72916433,-0.72916433,1.6427857,-0.72916433,-0.72916433,-0.72916433,1.6448029,-0.72916433,-0.72916433,-0.72916433,1.6456299,-0.72916433,-0.72916433,-0.72916433,1.6423419,-0.72916433,-0.72916433,-0.72916433,1.6420695,-0.72916433,-0.72916433,-0.72916433,1.6441069,-0.72916433,-0.72916433,-0.72916433,1.6423721,-0.72916433,-0.72916433,-0.72916433,1.6426646,-0.72916433,-0.72916433,-0.72916433,1.6445608,-0.72916433,-0.72916433,-0.72916433,1.6440767,-0.72916433,-0.72916433,-0.72916433,1.6461242,-0.72916433,-0.72916433,-0.72916433,1.6448533,-0.72916433,0.26705063,0.027707291,1.6432799,-0.72384895,0.26600168,0.014060787,1.6421301,-0.7238893,0.26809959,0.013011832,1.6442683,-0.72387921,0.26495272,0.0067080147,1.6403247,-0.72387921,0.26180586,-0.0037815375,1.6379746,-0.72391955,0.26390377,-0.0079874444,1.6393261,-0.72392964,0.26180586,-0.015330131,1.6376922,-0.72394981,0.26390377,-0.021633948,1.6400624,-0.7239599,0.26390377,-0.025829769,1.6396691,-0.72396999,0.26390377,-0.03002559,1.6397195,-0.72398007,0.26705063,-0.033182542,1.6427554,-0.72400024,0.26809959,-0.037378363,1.6432395,-0.72400024,0.27125654,-0.038427318,1.6467596,-0.72400024,0.26809959,-0.042623139,1.6439456,-0.72402042,0.26914854,-0.045780091,1.6439859,-0.72402042,0.2701975,-0.047878001,1.6447121,-0.72402042,0.27125654,-0.049975912,1.6454988,-0.72402042,0.27125654,-0.051024867,1.6455795,-0.7240305,0.27230549,-0.052073822,1.6463158,-0.72402042,0.2701975,-0.056269643,1.6448331,-0.72404059,0.27125654,-0.057318598,1.64564,-0.72404059,0.26914854,-0.058377639,1.6435219,-0.72405067,0.26809959,-0.06047555,1.6429874,-0.72406076,0.27125654,-0.06047555,1.6446718,-0.72405067,0.27230549,-0.06257346,1.646689,-0.72405067,0.27230549,-0.064671371,1.6460939,-0.72405067,0.2701975,-0.064671371,1.6444499,-0.72406076,0.26285481,-0.066769281,1.6382671,-0.72407085,0.25865899,-0.070965102,1.6334358,-0.7241011,0.25970794,-0.068867192,1.6351303,-0.72409102,0.26495272,-0.070965102,1.6395985,-0.72407085,0.26495272,-0.070965102,1.6387512,-0.72407085,0.26705063,-0.073073099,1.6405768,-0.72407085,0.26285481,-0.074122054,1.6375812,-0.72409102,0.26390377,-0.076219964,1.6385394,-0.72409102,0.26390377,-0.07726892,1.6386705,-0.72409102,0.26705063,-0.078317875,1.6408592,-0.72408093,0.26809959,-0.07726892,1.6436531,-0.7241011,0.26809959,-0.08146474,1.6419889,-0.72411119,0.26809959,-0.080415785,1.6408996,-0.72409102,0.26600168,-0.083562651,1.6392354,-0.7241011,0.26600168,-0.083562651,1.6403953,-0.7241011,0.26600168,-0.082513696,1.6402944,-0.7241011,0.2607569,-0.086719603,1.6366836,-0.72412128,0.26809959,-0.086719603,1.6410408,-0.72411119,0.26705063,-0.086719603,1.6400523,-0.7241011,0.26285481,-0.085670647,1.6382267,-0.72412128,0.26285481,-0.088817513,1.6369055,-0.72412128,0.26390377,-0.088817513,1.6372686,-0.72412128,0.26390377,-0.090915423,1.6386907,-0.72412128,0.2607569,-0.091964379,1.6369055,-0.72414145,0.26285481,-0.091964379,1.6365524,-0.72413136,0.25865899,-0.094062289,1.6338998,-0.72415153,0.25970794,-0.097209155,1.634394,-0.72415153,0.2607569,-0.097209155,1.634747,-0.72415153,0.25865899,-0.098268196,1.6339301,-0.72416162,-0.0069384892,-0.26622206,1.6298956,-0.72549299,-0.72916433,-0.72916433,1.6354531,-0.72916433,-0.72916433,-0.72916433,1.6384789,-0.72916433,-0.72916433,-0.72916433,1.6403247,-0.72916433,-0.72916433,-0.72916433,1.6387613,-0.72916433,-0.72916433,-0.72916433,1.6387109,-0.72916433,-0.72916433,-0.72916433,1.641182,-0.72916433,-0.72916433,-0.72916433,1.6394774,-0.72916433,-0.72916433,-0.72916433,1.6399515,-0.72916433,-0.72916433,-0.72916433,1.6390235,-0.72916433,-0.72916433,-0.72916433,1.6411013,-0.72916433,-0.72916433,-0.72916433,1.6405163,-0.72916433,-0.72916433,-0.72916433,1.6400624,-0.72916433,-0.72916433,-0.72916433,1.6428664,-0.72916433,-0.72916433,-0.72916433,1.6436127,-0.72916433,-0.72916433,-0.72916433,1.646568,-0.72916433,-0.72916433,-0.72916433,1.6433404,-0.72916433,-0.72916433,-0.72916433,1.643643,-0.72916433,-0.72916433,-0.72916433,1.6437136,-0.72916433,-0.72916433,-0.72916433,1.6423923,-0.72916433,-0.72916433,-0.72916433,1.6431689,-0.72916433,-0.72916433,-0.72916433,1.637904,-0.72916433,-0.72916433,-0.72916433,1.6417771,-0.72916433,-0.72916433,-0.72916433,1.6392757,-0.72916433,-0.72916433,-0.72916433,1.6426646,-0.72916433,-0.72916433,-0.72916433,1.642705,-0.72916433,-0.72916433,-0.72916433,1.6415753,-0.72916433,-0.72916433,-0.72916433,1.6426445,-0.72916433,-0.72916433,-0.72916433,1.6407382,-0.72916433,-0.72916433,-0.72916433,1.6434009,-0.72916433,-0.72916433,-0.72916433,1.6453072,-0.72916433,-0.72916433,-0.72916433,1.641071,-0.72916433,-0.72916433,-0.72916433,1.6452366,-0.72916433,-0.72916433,-0.72916433,1.6429269,-0.72916433,-0.72916433,-0.72916433,1.6436228,-0.72916433,-0.72916433,-0.72916433,1.6445306,-0.72916433,-0.72916433,-0.72916433,1.6384991,-0.72916433,-0.72916433,-0.72916433,1.6387411,-0.72916433,-0.72916433,-0.72916433,1.637672,-0.72916433,-0.72916433,-0.72916433,1.6378132,-0.72916433,-0.72916433,-0.72916433,1.6378132,-0.72916433,-0.72916433,-0.72916433,1.6331534,-0.72916433,-0.72916433,-0.72916433,1.6348782,-0.72916433,-0.72916433,-0.72916433,1.6319935,-0.72916433,-0.72916433,-0.72916433,1.6385697,-0.72916433,-0.72916433,-0.72916433,1.6370467,-0.72916433,-0.72916433,-0.72916433,1.6394169,-0.72916433,-0.72916433,-0.72916433,1.6365424,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433,-0.72916433,-0.72916433,1.6379242,-0.72916433:0
-0.88109628,-0.77448996,1.4683921,-0.78122403,-0.88211629,-0.77448996,1.4692438,-0.78122403,-0.88211629,-0.77448996,1.4719572,-0.78122403,-0.88211629,-0.77448996,1.4729871,-0.78122403,-0.88109628,-0.77448996,1.467689,-0.78122403,-0.88211629,-0.77448996,1.4706302,-0.78122403,-0.88109628,-0.77448996,1.4655499,-0.78122403,-0.88109628,-0.77448996,1.4627969,-0.78122403,-0.88109628,-0.77448996,1.4594199,-0.78122403,-0.87699642,-0.77448996,1.4162823,-0.78123394,-0.88211629,-0.77448996,1.4741656,-0.78122403,-0.88314621,-0.77448996,1.4874951,-0.78122403,-0.88006636,-0.77448996,1.4502299,-0.78122403,-0.88109628,-0.77448996,1.4655697,-0.78122403,0.81964338,0.73353638,1.4778396,-0.77193497,0.82990294,0.6166606,1.4843261,-0.77229148,0.79504421,0.62179038,1.4642526,-0.77230139,0.82682309,0.62897009,1.4812958,-0.77225187,0.83707275,0.62897009,1.487099,-0.77225187,0.80632378,0.61871053,1.4704816,-0.77230139,0.80529387,0.603341,1.4682138,-0.772341,0.80222392,0.57360214,1.4675107,-0.77244003,0.82169332,0.54080325,1.4801272,-0.77251925,0.82477316,0.52132395,1.4834843,-0.77257867,0.79709414,0.50799445,1.4673226,-0.77264799,0.80939373,0.5049245,1.4739873,-0.77263809,0.81144366,0.50287457,1.476067,-0.77264799,0.80632378,0.49979472,1.4728089,-0.7726579,0.80939373,0.49774479,1.4745023,-0.7726678,0.78376464,0.49466494,1.4593308,-0.77269751,0.78171471,0.49261501,1.4562213,-0.77269751,0.76018548,0.48646522,1.4464271,-0.77274702,0.78684449,0.48851515,1.4606578,-0.77270741,0.79299428,0.48646522,1.4652627,-0.77270741,0.81042365,0.48646522,1.4757402,-0.77269751,0.80632378,0.48339527,1.4734228,-0.77270741,0.81247358,0.48236536,1.4764136,-0.77270741,0.80632378,0.47929541,1.473512,-0.77271731,0.81144366,0.47724548,1.4769582,-0.77271731,0.81247358,0.47826549,1.4775821,-0.77271731,0.80222392,0.47313571,1.47167,-0.77274702,0.80529387,0.47108578,1.4734724,-0.77274702,0.81144366,0.47006577,1.4770969,-0.77273712,0.78376464,0.46391598,1.4618561,-0.77279654,-0.88314621,-0.77448996,1.4810482,-0.78122403,-0.88314621,-0.77448996,1.485049,-0.78122403,-0.88211629,-0.77448996,1.4670948,-0.78122403,-0.88006636,-0.77448996,1.4505072,-0.78122403,-0.87801643,-0.77448996,1.4326916,-0.78123394,-0.88314621,-0.77448996,1.4808402,-0.78122403,-0.8759665,-0.77448996,1.4082707,-0.78123394,-0.8759665,-0.77448996,1.4017743,-0.78123394,-0.87699642,-0.77448996,1.4128954,-0.78123394,-0.88109628,-0.77448996,1.4596873,-0.78122403,-0.88109628,-0.77448996,1.4641437,-0.78122403,-0.88109628,-0.77448996,1.4651538,-0.78122403,-0.88109628,-0.77448996,1.4652825,-0.78122403,-0.88109628,-0.77448996,1.462173,-0.78122403,-0.88211629,-0.77448996,1.4688377,-0.78122403,-0.88211629,-0.77448996,1.4705312,-0.78122403,-0.88109628,-0.77448996,1.4648369,-0.78122403,-0.88109628,-0.77448996,1.4616877,-0.78122403,-0.88109628,-0.77448996,1.4660055,-0.78122403,-0.88211629,-0.77448996,1.4686496,-0.78122403,-0.88109628,-0.77448996,1.4607668,-0.78122403,-0.88109628,-0.77448996,1.4650152,-0.78122403,-0.88109628,-0.77448996,1.4688377,-0.78122403,-0.88211629,-0.77448996,1.4701945,-0.78122403,-0.88211629,-0.77448996,1.4680554,-0.78122403,-0.88211629,-0.77448996,1.4691843,-0.78122403,-0.88211629,-0.77448996,1.4733238,-0.78122403,-0.88211629,-0.77448996,1.4747003,-0.78122403,-0.88211629,-0.77448996,1.476572,-0.78122403,-0.88211629,-0.77448996,1.4753341,-0.78122403,-0.88314621,-0.77448996,1.4835735,-0.78122403,-0.88519614,-0.77448996,1.5099453,-0.78121413,-0.88519614,-0.77448996,1.5063604,-0.78121413,-0.88519614,-0.77448996,1.5090738,-0.78121413,-0.88519614,-0.77346004,1.5124508,-0.78121413,-0.88622606,-0.77448996,1.5129261,-0.78120423,-0.88519614,-0.77448996,1.5066179,-0.78121413,-0.88519614,-0.77448996,1.5110346,-0.78121413,-0.88622606,-0.77346004,1.5132727,-0.78121413,-0.88519614,-0.77346004,1.506915,-0.78121413,-0.88417613,-0.77448996,1.5022704,-0.78121413,-0.88417613,-0.77448996,1.4981904,-0.78121413,-0.88519614,-0.77448996,1.5041619,-0.78121413,-0.88314621,-0.77448996,1.4816028,-0.78122403,-0.88314621,-0.77448996,1.4828406,-0.78122403,-0.88314621,-0.77448996,1.4808204,-0.78122403,-0.88314621,-0.77448996,1.4887429,-0.78121413,-0.88314621,-0.77448996,1.4883665,-0.78122403,-0.88417613,-0.77448996,1.4976853,-0.78121413,-0.88417613,-0.77448996,1.4973189,-0.78121413,-0.88417613,-0.77448996,1.5001314,-0.78121413,-0.88314621,-0.77448996,1.4808996,-0.78122403,-0.88211629,-0.77448996,1.4713333,-0.78122403,-0.88211629,-0.77448996,1.4744726,-0.78122403,-0.88314621,-0.77448996,1.4852372,-0.78122403,-0.88314621,-0.77448996,1.4809789,-0.78122403,-0.88314621,-0.77448996,1.4816028,-0.78122403,-0.88211629,-0.77448996,1.47371,-0.78122403,-0.88211629,-0.77448996,1.4728089,-0.78122403,-0.88211629,-0.77448996,1.4710164,-0.78122403,-0.88211629,-0.77448996,1.47576,-0.78122403,-0.88211629,-0.77448996,1.47882,-0.78122403,-0.88314621,-0.77448996,1.4878318,-0.78122403,-0.88314621,-0.77448996,1.4869801,-0.78122403,0.81247358,0.89243079,1.4727692,-0.7713705,0.81759345,0.6105108,1.4766512,-0.77232119,0.81964338,0.62179038,1.4767503,-0.77228158,0.82579318,0.62692016,1.4803154,-0.77226177,0.81759345,0.62897009,1.4738784,-0.77225187,0.81452351,0.62076046,1.4732347,-0.77229148,0.81247358,0.60641094,1.4722642,-0.7723311,0.81452351,0.57873192,1.473819,-0.77241032,0.81144366,0.54080325,1.4745716,-0.77253906,0.80939373,0.52029403,1.4740467,-0.77259848,0.81247358,0.50902436,1.4767206,-0.77262819,0.81657344,0.50184465,1.4790874,-0.77264799,0.79504421,0.4987648,1.4657777,-0.7726777,0.80324394,0.4987648,1.4715512,-0.7726678,0.80837372,0.49364493,1.4738883,-0.7726777,0.80632378,0.49364493,1.4735714,-0.7726777,0.80837372,0.49364493,1.4753143,-0.7726777,0.81247358,0.49364493,1.476473,-0.7726678,0.81247358,0.491595,1.4762452,-0.7726777,0.81759345,0.49056508,1.4806521,-0.7726777,0.80837372,0.48646522,1.475146,-0.77269751,0.80324394,0.48441529,1.4719176,-0.77270741,0.81247358,0.48339527,1.4775623,-0.77270741,0.80427385,0.47826549,1.4731951,-0.77272722,0.78684449,0.47519555,1.4605885,-0.77274702,0.78376464,0.47313571,1.4607172,-0.77275693,0.80837372,0.47519555,1.4758986,-0.77273712,0.8206733,0.47416563,1.4831873,-0.77271731,0.81349359,0.4721157,1.4780179,-0.77272722,0.79299428,0.46698592,1.4660649,-0.77276683,-0.88109628,-0.77448996,1.4643219,-0.78122403,-0.88211629,-0.77448996,1.4688278,-0.78122403,-0.88211629,-0.77448996,1.4737001,-0.78122403,-0.88211629,-0.77448996,1.4735219,-0.78122403,-0.88314621,-0.77448996,1.4837319,-0.78122403,-0.88314621,-0.77448996,1.484029,-0.78122403,-0.88211629,-0.77448996,1.4790874,-0.78122403,-0.88314621,-0.77448996,1.4804045,-0.78122403,-0.88314621,-0.77448996,1.4856234,-0.78122403,-0.88314621,-0.77448996,1.4849104,-0.78122403,-0.88314621,-0.77448996,1.4811967,-0.78122403,-0.88314621,-0.77448996,1.4827713,-0.78122403,-0.88314621,-0.77448996,1.4808204,-0.78122403,-0.88314621,-0.77448996,1.4846925,-0.78122403,-0.88211629,-0.77448996,1.4714224,-0.78122403,-0.88211629,-0.77448996,1.4735615,-0.78122403,-0.88314621,-0.77448996,1.487396,-0.78122403,-0.88417613,-0.77448996,1.4942093,-0.78121413,-0.88211629,-0.77448996,1.4738685,-0.78122403,-0.88006636,-0.77448996,1.4515371,-0.78122403,-0.88006636,-0.77448996,1.456043,-0.78122403,-0.88006636,-0.77448996,1.4524878,-0.78122403,-0.87904635,-0.77448996,1.4419113,-0.78122403,-0.88006636,-0.77448996,1.4476452,-0.78122403,-0.88109628,-0.77448996,1.4607271,-0.78122403,-0.88109628,-0.77448996,1.4639555,-0.78122403,-0.88006636,-0.77448996,1.4541119,-0.78122403,-0.88006636,-0.77448996,1.4534484,-0.78122403,-0.88109628,-0.77448996,1.4585188,-0.78122403,-0.88211629,-0.77448996,1.4760769,-0.78122403,-0.88211629,-0.77448996,1.4723434,-0.78122403,-0.88211629,-0.77448996,1.4729475,-0.78122403,-0.88211629,-0.77448996,1.4735813,-0.78122403,-0.88211629,-0.77448996,1.4698776,-0.78122403,-0.88211629,-0.77448996,1.4702242,-0.78122403,-0.88314621,-0.77448996,1.4830387,-0.78122403,-0.88211629,-0.77448996,1.4710659,-0.78122403,-0.88314621,-0.77448996,1.4825931,-0.78122403,-0.88109628,-0.77448996,1.4664313,-0.78122403,-0.88109628,-0.77448996,1.4623116,-0.78122403,-0.88211629,-0.77448996,1.4731059,-0.78122403,-0.88211629,-0.77448996,1.4704915,-0.78122403,-0.88211629,-0.77448996,1.4696102,-0.78122403,-0.88109628,-0.77448996,1.4683525,-0.78122403,-0.88109628,-0.77448996,1.4612916,-0.78122403,-0.88109628,-0.77448996,1.4597368,-0.78122403,-0.87904635,-0.77448996,1.4398812,-0.78123394,-0.87904635,-0.77448996,1.44511,-0.78122403,-0.88109628,-0.77448996,1.4663026,-0.78122403,-0.88006636,-0.77448996,1.4481998,-0.78122403,-0.87699642,-0.77448996,1.4199167,-0.78123394,-0.87801643,-0.77448996,1.4276807,-0.78123394,-0.87801643,-0.77448996,1.4341276,-0.78123394,-0.87904635,-0.77448996,1.4383165,-0.78123394,-0.87904635,-0.77448996,1.4414855,-0.78123394,-0.87904635,-0.77448996,1.4381581,-0.78123394,-0.87904635,-0.77448996,1.442555,-0.78122403,-0.87904635,-0.77448996,1.4360884,-0.78123394,-0.87904635,-0.77448996,1.4350287,-0.78123394,-0.87904635,-0.77448996,1.4368905,-0.78123394,-0.88006636,-0.77448996,1.448378,-0.78122403,-0.87904635,-0.77448996,1.4448327,-0.78122403,0.73045653,0.60744086,1.4216299,-0.77238061,0.74070618,0.60539093,1.4261754,-0.77238061,0.774535,0.61154072,1.4485761,-0.772341,0.79094435,0.61769051,1.4591327,-0.77231129,0.77864476,0.61871053,1.4504577,-0.77231129,0.79914407,0.61256074,1.4639258,-0.77232119,0.78684449,0.59001149,1.4570432,-0.77240042,0.7878645,0.55925262,1.4595289,-0.77249945,0.7612154,0.52439389,1.4438622,-0.77262819,0.76223541,0.50799445,1.4428026,-0.7726678,0.78171471,0.49979472,1.4572215,-0.7726876,0.77146505,0.49364493,1.4513985,-0.77270741,0.76531526,0.48954507,1.4471996,-0.77272722,0.7550656,0.48646522,1.4398515,-0.77273712,0.77248507,0.4854452,1.4509627,-0.77272722,0.77248507,0.4854452,1.4518243,-0.77272722,0.76223541,0.4854452,1.4447139,-0.77274702,0.75608562,0.48339527,1.4407527,-0.77274702,0.75095584,0.48031542,1.4380987,-0.77276683,0.76838521,0.48031542,1.4486454,-0.77274702,0.76223541,0.47724548,1.4447634,-0.77275693,0.78376464,0.47826549,1.4593308,-0.77274702,0.79504421,0.47826549,1.4672037,-0.77273712,0.79709414,0.47519555,1.46759,-0.77273712,0.77248507,0.46903585,1.4518738,-0.77277673,0.77966478,0.47108578,1.4572413,-0.77276683,0.78991443,0.47006577,1.4644507,-0.77275693,0.78479456,0.46596591,1.461252,-0.77277673,0.7878645,0.46493599,1.4628563,-0.77278664,-0.88109628,-0.77448996,1.4662629,-0.78122403,-0.88109628,-0.77448996,1.4678771,-0.78122403,-0.88109628,-0.77448996,1.4642229,-0.78122403,-0.88109628,-0.77448996,1.4638169,-0.78122403,-0.88109628,-0.77448996,1.4634505,-0.78122403,-0.88109628,-0.77448996,1.4650647,-0.78122403,-0.88109628,-0.77448996,1.4609252,-0.78122403,-0.87904635,-0.77448996,1.4434958,-0.78122403,-0.88006636,-0.77448996,1.4480809,-0.78122403,-0.88006636,-0.77448996,1.452369,-0.78122403,-0.88109628,-0.77448996,1.4641932,-0.78122403,-0.88109628,-0.77448996,1.4616382,-0.78122403,-0.88211629,-0.77448996,1.4695111,-0.78122403,-0.88211629,-0.77448996,1.4716007,-0.78122403,-0.88211629,-0.77448996,1.4708877,-0.78122403,-0.88109628,-0.77448996,1.4645299,-0.78122403,-0.88314621,-0.77448996,1.4852174,-0.78122403,-0.88211629,-0.77448996,1.4761957,-0.78122403,-0.88211629,-0.77448996,1.4759283,-0.78122403,-0.88109628,-0.77448996,1.464619,-0.78122403,-0.88109628,-0.77448996,1.4633713,-0.78122403,-0.88211629,-0.77448996,1.4728386,-0.78122403,-0.88211629,-0.77448996,1.4786913,-0.78122403,-0.88211629,-0.77448996,1.475037,-0.78122403,-0.88417613,-0.77448996,1.496081,-0.78121413,-0.88314621,-0.77448996,1.4845638,-0.78121413,-0.88211629,-0.77448996,1.4780179,-0.78122403,-0.88211629,-0.77448996,1.4768691,-0.78122403,-0.88211629,-0.77448996,1.4753737,-0.78122403,-0.88314621,-0.77448996,1.4812958,-0.78122403,-0.88211629,-0.77448996,1.4793548,-0.78122403,-0.88109628,-0.77448996,1.4677682,-0.78122403,-0.88109628,-0.77448996,1.4608262,-0.78122403,-0.88211629,-0.77448996,1.4696003,-0.78122403,-0.88211629,-0.77448996,1.4743933,-0.78122403,-0.88109628,-0.77448996,1.464015,-0.78122403,-0.88211629,-0.77448996,1.4720859,-0.78122403,-0.88109628,-0.77448996,1.465748,-0.78122403,-0.88211629,-0.77448996,1.4709372,-0.78122403,-0.88109628,-0.77448996,1.4609945,-0.78122403,-0.88314621,-0.77448996,1.4845638,-0.78122403,-0.88211629,-0.77448996,1.4776415,-0.78122403,-0.88314621,-0.77448996,1.4832764,-0.78122403,-0.88211629,-0.77448996,1.4743735,-0.78122403,-0.88211629,-0.77448996,1.4763244,-0.78122403,-0.88211629,-0.77448996,1.4780377,-0.78122403,-0.88314621,-0.77448996,1.4837913,-0.78122403,-0.88211629,-0.77448996,1.4797113,-0.78122403,-0.88211629,-0.77448996,1.478919,-0.78122403,-0.88417613,-0.77448996,1.4965366,-0.78121413,-0.88314621,-0.77448996,1.4806026,-0.78122403,-0.88211629,-0.77448996,1.4741359,-0.78122403,-0.88211629,-0.77448996,1.4779089,-0.78122403,-0.88417613,-0.77448996,1.4994183,-0.78121413,-0.88314621,-0.77448996,1.4815433,-0.78122403,-0.88211629,-0.77448996,1.4780278,-0.78122403,-0.88211629,-0.77448996,1.4722147,-0.78122403,-0.88211629,-0.77448996,1.4748489,-0.78122403,-0.88211629,-0.77448996,1.4784635,-0.78122403,-0.88211629,-0.77448996,1.4736902,-0.78122403,-0.88109628,-0.77448996,1.4662927,-0.78122403,-0.88211629,-0.77448996,1.4696201,-0.78122403,0.79299428,0.87808127,1.4620145,-0.77142992,0.77966478,0.60231108,1.4534583,-0.77237071,0.81144366,0.61564058,1.4725217,-0.77231129,0.81144366,0.62076046,1.4723731,-0.77229148,0.81862337,0.62486032,1.4764334,-0.77227168,0.78581457,0.61564058,1.4551814,-0.77232119,0.79606423,0.5971813,1.4630445,-0.77237071,0.78889442,0.56950228,1.4597071,-0.77245983,0.80222392,0.53567347,1.4690952,-0.77255887,0.80529387,0.51722409,1.4706401,-0.77260838,0.80632378,0.5049245,1.4732842,-0.77263809,0.8073438,0.50184465,1.4737695,-0.7726579,0.80119401,0.4987648,1.4703529,-0.7726678,0.80016409,0.49466494,1.4695309,-0.7726777,0.80324394,0.49466494,1.4724325,-0.7726777,0.81554352,0.49466494,1.4794538,-0.7726678,0.81657344,0.49056508,1.4798004,-0.7726777,0.80016409,0.48851515,1.4699073,-0.77269751,0.80427385,0.48646522,1.4729475,-0.77270741,0.81247358,0.48646522,1.4780476,-0.77269751,0.82169332,0.4854452,1.4839498,-0.7726876,0.81554352,0.48236536,1.4799688,-0.77270741,0.81657344,0.48134534,1.4811274,-0.77270741,0.80324394,0.47621556,1.4731852,-0.77273712,0.80324394,0.47519555,1.4731951,-0.77273712,0.80222392,0.47416563,1.472185,-0.77273712,0.78684449,0.46801584,1.4617769,-0.77276683,0.82477316,0.47006577,1.4858908,-0.77272722,0.81657344,0.47006577,1.4812165,-0.77273712,-0.88314621,-0.77448996,1.481989,-0.78122403,-0.88314621,-0.77448996,1.4808501,-0.78122403,-0.88314621,-0.77448996,1.4794043,-0.78122403,-0.88314621,-0.77448996,1.4888221,-0.78122403,-0.88211629,-0.77448996,1.4798103,-0.78122403,-0.88314621,-0.77448996,1.4868217,-0.78121413,-0.88211629,-0.77448996,1.478107,-0.78122403,-0.88314621,-0.77448996,1.4798103,-0.78122403,-0.88211629,-0.77448996,1.4765621,-0.78122403,-0.88314621,-0.77448996,1.4828406,-0.78122403,-0.88314621,-0.77448996,1.4868811,-0.78122403,-0.88314621,-0.77448996,1.4902184,-0.78121413,-0.88211629,-0.77448996,1.4706302,-0.78122403,-0.88211629,-0.77448996,1.4714323,-0.78122403,-0.88211629,-0.77448996,1.4746112,-0.78122403,-0.88211629,-0.77448996,1.4778693,-0.78122403,-0.88211629,-0.77448996,1.4771167,-0.78122403,-0.88314621,-0.77448996,1.4838706,-0.78122403,-0.88211629,-0.77448996,1.4810383,-0.78122403,-0.88314621,-0.77448996,1.4828704,-0.78122403,-0.88314621,-0.77448996,1.4826426,-0.78122403,-0.88314621,-0.77448996,1.4815532,-0.78122403,-0.88314621,-0.77448996,1.483316,-0.78122403,-0.88314621,-0.77448996,1.4879407,-0.78122403,-0.88109628,-0.77448996,1.4621334,-0.78122403,-0.88109628,-0.77448996,1.4665006,-0.78122403,-0.88211629,-0.77448996,1.4704717,-0.78122403,-0.88211629,-0.77448996,1.4755421,-0.78122403,-0.88211629,-0.77448996,1.4706995,-0.78122403,-0.88314621,-0.77448996,1.4836329,-0.78122403,-0.88314621,-0.77448996,1.482187,-0.78122403,-0.88314621,-0.77448996,1.4808105,-0.78122403,-0.88211629,-0.77448996,1.4759976,-0.78122403,-0.88314621,-0.77448996,1.4828208,-0.78122403,-0.88314621,-0.77448996,1.4879011,-0.78122403,-0.88417613,-0.77448996,1.492001,-0.78121413,-0.88314621,-0.77448996,1.4800876,-0.78122403,-0.88314621,-0.77448996,1.4793548,-0.78122403,-0.88314621,-0.77448996,1.4908126,-0.78121413,-0.88417613,-0.77448996,1.4925258,-0.78121413,-0.88417613,-0.77448996,1.4925258,-0.78121413,-0.88417613,-0.77448996,1.4925258,-0.78121413,-0.88417613,-0.77448996,1.4925258,-0.78121413,-0.88417613,-0.77448996,1.4925258,-0.78121413,-0.88417613,-0.77448996,1.4925258,-0.78121413:0
-0.66486296,-0.60815397,1.6946963,-0.62617471,-0.66486296,-0.60815397,1.6949238,-0.62617471,-0.66486296,-0.60815397,1.6977359,-0.62617471,-0.66486296,-0.60815397,1.6991834,-0.62617471,-0.66486296,-0.60815397,1.6942,-0.62617471,-0.66486296,-0.60815397,1.6965366,-0.62617471,-0.66486296,-0.60815397,1.6913878,-0.62617471,-0.66486296,-0.60815397,1.6888548,-0.62617471,-0.66486296,-0.60815397,1.684864,-0.62617471,-0.66379805,-0.60921888,1.6399103,-0.62617471,-0.66486296,-0.60707872,1.7037945,-0.62616437,-0.66486296,-0.60815397,1.6843367,-0.62616437,-0.66486296,-0.60815397,1.6854223,-0.62617471,-0.66486296,-0.60815397,1.7097188,-0.62617471,-0.66486296,-0.60815397,1.7002586,-0.62617471,-0.66486296,-0.60815397,1.6828789,-0.62617471,-0.6659382,-0.60707872,1.7088399,-0.62616437,-0.66486296,-0.60707872,1.7081783,-0.62616437,-0.66486296,-0.60815397,1.6892684,-0.62617471,-0.66486296,-0.60707872,1.7156946,-0.62617471,-0.66486296,-0.60815397,1.6927319,-0.62617471,-0.66486296,-0.60815397,1.7050766,-0.62617471,-0.66486296,-0.60815397,1.6992764,-0.62617471,-0.66486296,-0.60707872,1.7000829,-0.62616437,-0.66486296,-0.60815397,1.7049628,-0.62617471,-0.66486296,-0.60815397,1.7012512,-0.62617471,-0.66486296,-0.60815397,1.70396,-0.62617471,-0.66486296,-0.60815397,1.7040117,-0.62617471,-0.66486296,-0.60815397,1.7016234,-0.62617471,-0.66486296,-0.60815397,1.6907365,-0.62617471,-0.66486296,-0.60815397,1.6869938,-0.62617471,-0.66486296,-0.60815397,1.6896199,-0.62617471,-0.66486296,-0.60815397,1.6865906,-0.62617471,-0.66486296,-0.60815397,1.6857118,-0.62617471,-0.66486296,-0.60815397,1.7026366,-0.62617471,-0.66486296,-0.60815397,1.6984907,-0.62617471,-0.66486296,-0.60707872,1.7019439,-0.62616437,-0.66486296,-0.60815397,1.7000415,-0.62617471,-0.66486296,-0.60815397,1.7032466,-0.62617471,-0.66486296,-0.60815397,1.7069376,-0.62617471,-0.66486296,-0.60707872,1.6981081,-0.62617471,-0.66486296,-0.60815397,1.7005895,-0.62617471,-0.66486296,-0.60815397,1.7047561,-0.62617471,-0.66486296,-0.60707872,1.7065033,-0.62616437,-0.66486296,-0.60707872,1.707682,-0.62616437,-0.6659382,-0.60815397,1.7116004,-0.62616437,-0.6659382,-0.60815397,1.7118382,-0.62617471,-0.66486296,-0.60815397,1.7004447,-0.62616437,-0.66379805,-0.60815397,1.6589546,-0.62617471,-0.66486296,-0.60815397,1.688648,-0.62617471,-0.66486296,-0.60815397,1.6742562,-0.62617471,-0.66379805,-0.60921888,1.6248776,-0.62617471,-0.66379805,-0.60815397,1.635568,-0.62617471,-0.66379805,-0.60815397,1.6578174,-0.62617471,-0.66486296,-0.60815397,1.6845848,-0.62617471,-0.66486296,-0.60815397,1.6717542,-0.62617471,-0.66486296,-0.60815397,1.6912224,-0.62617471,-0.66486296,-0.60815397,1.6913051,-0.62617471,-0.66486296,-0.60815397,1.6956268,-0.62617471,-0.66486296,-0.60815397,1.6965573,-0.62617471,-0.66486296,-0.60707872,1.6895889,-0.62616437,-0.66486296,-0.60815397,1.6871179,-0.62617471,-0.66486296,-0.60815397,1.6919772,-0.62617471,-0.66486296,-0.60815397,1.6932385,-0.62616437,-0.66486296,-0.60815397,1.6658197,-0.62617471,-0.66486296,-0.60815397,1.6915119,-0.62617471,-0.66486296,-0.60815397,1.6941173,-0.62617471,-0.66486296,-0.60815397,1.6957198,-0.62617471,-0.66486296,-0.60707872,1.6936624,-0.62616437,-0.66486296,-0.60815397,1.6951512,-0.62617471,-0.66486296,-0.60815397,1.6990386,-0.62617471,-0.66486296,-0.60815397,1.7007549,-0.62616437,-0.66486296,-0.60707872,1.7017268,-0.62616437,-0.66486296,-0.60815397,1.7020679,-0.62617471,-0.66486296,-0.60815397,1.707134,-0.62617471,-0.6659382,-0.60707872,1.7341289,-0.62616437,-0.66486296,-0.60707872,1.7130582,-0.62616437,-0.6659382,-0.60707872,1.7366516,-0.62616437,-0.6659382,-0.60707872,1.7392777,-0.62616437,-0.6659382,-0.60707872,1.7407562,-0.62616437,-0.6659382,-0.60707872,1.7338395,-0.62616437,-0.6659382,-0.60707872,1.7379233,-0.62616437,-0.6659382,-0.60707872,1.7432272,-0.62616437,-0.6659382,-0.60707872,1.7341083,-0.62616437,-0.6659382,-0.60707872,1.7296832,-0.62616437,-0.73764897,0.13784065,1.703929,-0.62266981,-0.71409691,0.26413059,1.7318854,-0.62218388,-0.71089184,0.26842125,1.7087469,-0.62213219,-0.713032,0.25556997,1.7095327,-0.62218388,-0.71731231,0.2341684,1.7074959,-0.6222666,-0.71945247,0.22025221,1.7156636,-0.62233897,-0.72159262,0.20847617,1.7150433,-0.62239066,-0.72693785,0.19349507,1.7262197,-0.62246303,-0.73229341,0.16031747,1.7247205,-0.62259744,-0.73443357,0.14319622,1.7056866,-0.6226388,-0.73550881,0.13784065,1.7101633,-0.62266981,-0.73336866,0.13463559,1.6976429,-0.62266981,-0.73657372,0.12392446,1.700848,-0.62271117,-0.73871388,0.11964415,1.7123862,-0.62275252,-0.73871388,0.11857924,1.7068652,-0.62274219,-0.73871388,0.11750399,1.7081576,-0.62276286,-0.73978913,0.11429893,1.7018198,-0.62276286,-0.73871388,0.11215877,1.6982322,-0.62276286,-0.73657372,0.11322368,1.6764584,-0.62273185,-0.73978913,0.11215877,1.7011064,-0.6227732,-0.73978913,0.10894337,1.7035568,-0.62278354,-0.73978913,0.11429893,1.7142162,-0.6227732,-0.73978913,0.11429893,1.7147125,-0.62278354,-0.73550881,0.10680321,1.6620667,-0.62274219,-0.73871388,0.11001861,1.7025125,-0.6227732,-0.73764897,0.11429893,1.7039703,-0.62276286,-0.73871388,0.11322368,1.707103,-0.6227732,-0.73764897,0.10894337,1.6803252,-0.62276286,-0.73764897,0.11322368,1.6993695,-0.62276286,-0.73871388,0.11108352,1.6994832,-0.6227732,-0.73657372,0.10786812,1.6775647,-0.62276286,-0.73764897,0.11429893,1.7007342,-0.62276286,-0.73871388,0.11108352,1.7006825,-0.6227732,-0.73871388,0.11001861,1.7032569,-0.62278354,-0.73978913,0.11108352,1.7055935,-0.6227732,-0.73871388,0.10786812,1.6940243,-0.6227732,-0.73764897,0.11215877,1.6979944,-0.62276286,-0.73764897,0.11001861,1.7000932,-0.6227732,-0.73764897,0.11108352,1.699049,-0.6227732,-0.73764897,0.11215877,1.7004551,-0.62276286,-0.73871388,0.11001861,1.7026986,-0.6227732,-0.73871388,0.11108352,1.7035981,-0.6227732,-0.73871388,0.11108352,1.7066688,-0.6227732,-0.73978913,0.10572796,1.7016234,-0.62278354,-0.73764897,0.11001861,1.6968571,-0.6227732,-0.73764897,0.11215877,1.7035464,-0.6227732,-0.73871388,0.11001861,1.7020783,-0.6227732,-0.73764897,0.10894337,1.6879553,-0.62276286,-0.73764897,0.10786812,1.690447,-0.6227732,-0.73871388,0.11001861,1.7026676,-0.6227732,-0.73764897,0.10894337,1.7054074,-0.62278354,-0.73657372,0.10572796,1.6818657,-0.6227732,-0.73764897,0.11429893,1.7029054,-0.62276286,-0.73764897,0.10572796,1.6914189,-0.62278354,-0.73871388,0.10786812,1.6944378,-0.62278354,-0.73764897,0.11429893,1.7007549,-0.62276286,-0.73871388,0.10680321,1.6994212,-0.62279388,-0.73978913,0.10786812,1.7089433,-0.62279388,-0.73978913,0.11001861,1.7102977,-0.62279388,-0.73871388,0.10572796,1.7053661,-0.62280422,-0.73657372,0.10466305,1.6824033,-0.6227732,-0.73871388,0.10894337,1.7120553,-0.62279388,-0.73764897,0.11536384,1.7106079,-0.62276286,-0.73764897,0.11429893,1.707072,-0.6227732,-0.73871388,0.10894337,1.7088399,-0.62278354,-0.73978913,0.10786812,1.7074028,-0.62279388,-0.73978913,0.10680321,1.7104632,-0.62280422,-0.73764897,0.11108352,1.6971259,-0.6227732,-0.73764897,0.10786812,1.6992041,-0.62280422,-0.73871388,0.10786812,1.6946756,-0.6227732,-0.74085404,0.10680321,1.7197475,-0.6228249,-0.73978913,0.10572796,1.7000622,-0.62279388,-0.73550881,0.10786812,1.6764067,-0.62276286,-0.73550881,0.10144765,1.6781127,-0.62279388,-0.73657372,0.1035878,1.6785469,-0.62278354,-0.73550881,0.10786812,1.6733774,-0.62276286,-0.73550881,0.10144765,1.6701517,-0.62278354,-0.73657372,0.1035878,1.6857841,-0.62279388,-0.73657372,0.098242581,1.667629,-0.62278354,-0.73550881,0.10466305,1.6782057,-0.6227732,-0.73657372,0.10466305,1.6833235,-0.62278354,-0.73657372,0.10466305,1.683582,-0.62278354,-0.73657372,0.10680321,1.6986664,-0.62279388,-0.73871388,0.1025229,1.6980875,-0.62281456,-0.73764897,0.10144765,1.6981081,-0.62281456,-0.73871388,0.1035878,1.6958026,-0.62280422,-0.73764897,0.1025229,1.6945309,-0.62280422,-0.73764897,0.1025229,1.6950271,-0.62280422,-0.73871388,0.10466305,1.7059967,-0.62281456,-0.73871388,0.10680321,1.7021507,-0.62279388,-0.73978913,0.1025229,1.7067411,-0.62280422,-0.73978913,0.098242581,1.692339,-0.6228249,-0.73871388,0.09930749,1.6877072,-0.62280422,-0.73764897,0.10786812,1.6982219,-0.62279388,-0.73871388,0.1025229,1.6950685,-0.62280422,-0.73871388,0.10038274,1.6947583,-0.62281456,-0.73871388,0.10038274,1.6907261,-0.62281456,-0.73764897,0.09930749,1.685567,-0.62280422,-0.73764897,0.1025229,1.6879657,-0.6227732,-0.73764897,0.097167333,1.670803,-0.62280422,-0.73871388,0.093962267,1.6741735,-0.62283524,-0.73978913,0.097167333,1.6924424,-0.62283524,-0.73871388,0.098242581,1.6819691,-0.62281456,-0.73336866,0.095027176,1.642402,-0.62278354,-0.73443357,0.095027176,1.6505594,-0.62279388,-0.73550881,0.09930749,1.6590477,-0.62278354,-0.73550881,0.097167333,1.6587996,-0.62279388,-0.73550881,0.093962267,1.6613843,-0.62281456,-0.73657372,0.095027176,1.6615084,-0.62280422,-0.73657372,0.093962267,1.6647755,-0.62281456,-0.73550881,0.096102424,1.6599885,-0.62279388,-0.73443357,0.097167333,1.6585411,-0.62279388,-0.73657372,0.093962267,1.661529,-0.62281456,-0.66486296,-0.60815397,1.6726951,-0.62617471,-0.66486296,-0.60815397,1.6670293,-0.62617471,-0.66379805,-0.60815397,1.6440563,-0.62617471,-0.66379805,-0.60921888,1.6497323,-0.62617471,-0.66486296,-0.60815397,1.6737807,-0.62617471,-0.66486296,-0.60815397,1.6850294,-0.62617471,-0.66486296,-0.60815397,1.6753832,-0.62617471,-0.66486296,-0.60815397,1.6884929,-0.62617471,-0.66486296,-0.60815397,1.6826825,-0.62617471,-0.66486296,-0.60815397,1.6854843,-0.62617471,-0.66486296,-0.60815397,1.6668122,-0.62617471,-0.66486296,-0.60815397,1.6705032,-0.62617471,-0.66486296,-0.60815397,1.6829823,-0.62617471,-0.66486296,-0.60815397,1.678123,-0.62617471,-0.66486296,-0.60815397,1.671992,-0.62617471,-0.66379805,-0.60815397,1.6668019,-0.62617471,-0.66379805,-0.60815397,1.6543228,-0.62617471,-0.66486296,-0.60815397,1.6773683,-0.62617471,-0.66486296,-0.60815397,1.6754659,-0.62617471,-0.66486296,-0.60815397,1.6677427,-0.62617471,-0.66379805,-0.60815397,1.6626767,-0.62617471,-0.66486296,-0.60815397,1.6691592,-0.62616437,-0.66486296,-0.60815397,1.6676807,-0.62617471,-0.66486296,-0.60815397,1.6857945,-0.62617471,-0.66486296,-0.60815397,1.6932075,-0.62617471,-0.66486296,-0.60815397,1.6722608,-0.62617471,-0.66486296,-0.60815397,1.6764998,-0.62617471,-0.66486296,-0.60815397,1.6819587,-0.62617471,-0.66486296,-0.60815397,1.6958853,-0.62617471,-0.66486296,-0.60815397,1.6868387,-0.62617471,-0.66486296,-0.60815397,1.689289,-0.62617471,-0.66486296,-0.60815397,1.6921322,-0.62617471,-0.66486296,-0.60815397,1.693466,-0.62617471,-0.66486296,-0.60815397,1.6904677,-0.62617471,-0.66486296,-0.60815397,1.6893511,-0.62617471,-0.66486296,-0.60815397,1.688586,-0.62617471,-0.66486296,-0.60815397,1.6873246,-0.62617471,-0.66486296,-0.60815397,1.6922253,-0.62616437,-0.66486296,-0.60815397,1.6689007,-0.62617471,-0.66486296,-0.60815397,1.6729535,-0.62617471,-0.66486296,-0.60815397,1.6714647,-0.62617471,-0.66486296,-0.60815397,1.689258,-0.62616437,-0.66486296,-0.60815397,1.686756,-0.62617471,-0.66486296,-0.60815397,1.6877072,-0.62617471,-0.66486296,-0.60815397,1.697312,-0.62617471,-0.66486296,-0.60707872,1.6954097,-0.62616437,-0.66486296,-0.60815397,1.6911811,-0.62617471,-0.66486296,-0.60815397,1.7007859,-0.62616437,-0.66486296,-0.60815397,1.7024298,-0.62617471,-0.66486296,-0.60707872,1.7016337,-0.62617471,-0.66486296,-0.60815397,1.6899817,-0.62616437,-0.66486296,-0.60815397,1.6901162,-0.62617471,-0.66486296,-0.60815397,1.6970949,-0.62617471,-0.66486296,-0.60707872,1.70518,-0.62616437,-0.66486296,-0.60815397,1.6998244,-0.62616437,-0.6659382,-0.60815397,1.713234,-0.62616437,-0.66486296,-0.60815397,1.7114867,-0.62616437,-0.66486296,-0.60707872,1.7038462,-0.62616437,-0.66486296,-0.60707872,1.7017164,-0.62616437,-0.66486296,-0.60815397,1.7002793,-0.62616437,-0.66486296,-0.60815397,1.7069169,-0.62616437,-0.66486296,-0.60707872,1.7050145,-0.62616437,-0.66486296,-0.60815397,1.6943758,-0.62616437,-0.66486296,-0.60815397,1.6846779,-0.62617471,-0.66486296,-0.60815397,1.6924941,-0.62617471,-0.66486296,-0.60707872,1.6996693,-0.62616437,-0.66486296,-0.60815397,1.6893718,-0.62616437,-0.66486296,-0.60815397,1.6958646,-0.62617471,-0.66486296,-0.60815397,1.6895889,-0.62617471,-0.66486296,-0.60815397,1.6968261,-0.62617471,-0.66486296,-0.60815397,1.6852465,-0.62617471,-0.66486296,-0.60815397,1.710732,-0.62617471,-0.66486296,-0.60815397,1.7038876,-0.62617471,-0.66486296,-0.60707872,1.7084057,-0.62616437,-0.66486296,-0.60815397,1.7001449,-0.62616437,-0.66486296,-0.60815397,1.7024505,-0.62617471,-0.66486296,-0.60815397,1.7035774,-0.62617471,-0.66486296,-0.60707872,1.7105665,-0.62616437,-0.66486296,-0.60815397,1.7051696,-0.62616437,-0.66486296,-0.60815397,1.7043425,-0.62617471,-0.66486296,-0.60815397,1.7070203,-0.62617471,-0.66486296,-0.60815397,1.7067825,-0.62616437,-0.66486296,-0.60815397,1.6997727,-0.62617471,-0.66486296,-0.60815397,1.7047871,-0.62617471,-0.66486296,-0.60815397,1.7153224,-0.62616437,-0.66486296,-0.60707872,1.7069583,-0.62616437,-0.66486296,-0.60707872,1.7055935,-0.62616437,-0.66486296,-0.60707872,1.6976222,-0.62617471,-0.66486296,-0.60815397,1.7010134,-0.62617471,-0.66486296,-0.60707872,1.7055211,-0.62616437,-0.66486296,-0.60815397,1.6995969,-0.62616437,-0.66486296,-0.60815397,1.6906021,-0.62617471,-0.66486296,-0.60815397,1.6903953,-0.62616437,-0.66486296,-0.60815397,1.6877382,-0.62617471,-0.66486296,-0.60815397,1.6779162,-0.62617471,-0.66486296,-0.60815397,1.6983253,-0.62617471,-0.66486296,-0.60815397,1.69847,-0.62617471,-0.66486296,-0.60815397,1.702771,-0.62617471,-0.66486296,-0.60815397,1.6794671,-0.62617471,-0.66486296,-0.60815397,1.688555,-0.62617471,-0.66486296,-0.60815397,1.6848123,-0.62617471,-0.66486296,-0.60815397,1.6947687,-0.62617471,-0.66486296,-0.60815397,1.6933522,-0.62617471,-0.66486296,-0.60707872,1.699659,-0.62616437,-0.66486296,-0.60815397,1.7006412,-0.62617471,-0.66486296,-0.60815397,1.6958853,-0.62616437,-0.66486296,-0.60815397,1.6955648,-0.62617471,-0.66486296,-0.60707872,1.6987078,-0.62616437,-0.66486296,-0.60815397,1.7057279,-0.62617471,-0.66486296,-0.60707872,1.7064517,-0.62616437,-0.66486296,-0.60815397,1.6963815,-0.62617471,-0.66486296,-0.60707872,1.6989353,-0.62616437,-0.66486296,-0.60815397,1.7042598,-0.62617471,-0.66486296,-0.60815397,1.7104425,-0.62617471,-0.66486296,-0.60815397,1.7063172,-0.62617471,-0.66486296,-0.60707872,1.7074752,-0.62616437,-0.66486296,-0.60815397,1.6992971,-0.62617471,-0.66486296,-0.60815397,1.6990076,-0.62617471,-0.66486296,-0.60815397,1.6979117,-0.62617471,-0.66486296,-0.60815397,1.6829926,-0.62617471,-0.6659382,-0.60707872,1.7120864,-0.62617471,-0.66486296,-0.60815397,1.7074959,-0.62617471,-0.66486296,-0.60707872,1.7074649,-0.62616437,-0.66486296,-0.60707872,1.7072374,-0.62616437,-0.66486296,-0.60815397,1.7051903,-0.62616437,-0.6659382,-0.60815397,1.7149502,-0.62617471,-0.66486296,-0.60815397,1.7056866,-0.62616437,-0.6659382,-0.60707872,1.7127894,-0.62616437,-0.66486296,-0.60815397,1.7029985,-0.62617471,-0.66486296,-0.60815397,1.7056556,-0.62617471,-0.66486296,-0.60815397,1.7022851,-0.62616437,-0.6659382,-0.60707872,1.7087779,-0.62616437,-0.6659382,-0.60815397,1.7133167,-0.62617471,-0.6659382,-0.60707872,1.7173489,-0.62616437,-0.66486296,-0.60707872,1.7037945,-0.62616437,-0.66486296,-0.60815397,1.6956888,-0.62617471,-0.66486296,-0.60815397,1.6999795,-0.62617471,-0.66486296,-0.60815397,1.7034637,-0.62617471,-0.66486296,-0.60815397,1.7024505,-0.62617471,-0.6659382,-0.60707872,1.7097394,-0.62616437,-0.66486296,-0.60815397,1.7067928,-0.62617471,-0.66486296,-0.60815397,1.7084781,-0.62617471,-0.66486296,-0.60815397,1.7076716,-0.62616437,-0.66486296,-0.60707872,1.7067308,-0.62616437,-0.66486296,-0.60815397,1.7090054,-0.62616437,-0.6659382,-0.60815397,1.7140921,-0.62617471,-0.66486296,-0.60815397,1.686818,-0.62617471,-0.66486296,-0.60815397,1.6913672,-0.62617471,-0.66486296,-0.60815397,1.6955854,-0.62617471,-0.66486296,-0.60815397,1.701003,-0.62617471,-0.66486296,-0.60815397,1.6959887,-0.62616437,-0.66486296,-0.60707872,1.7094913,-0.62616437,-0.66486296,-0.60815397,1.7079611,-0.62616437,-0.66486296,-0.60815397,1.7065964,-0.62617471,-0.66486296,-0.60815397,1.7019232,-0.62617471,-0.66486296,-0.60707872,1.7086745,-0.62616437,-0.66486296,-0.60707872,1.7139577,-0.62616437,-0.6659382,-0.60815397,1.7184551,-0.62617471,-0.66486296,-0.60707872,1.7056762,-0.62616437,-0.66486296,-0.60707872,1.7048491,-0.62616437,-0.6659382,-0.60707872,1.7170077,-0.62616437,-0.66486296,-0.60707872,1.7186516,-0.62617471,-0.66486296,-0.60707872,1.7186516,-0.62617471,-0.66486296,-0.60707872,1.7186516,-0.62617471,-0.66486296,-0.60707872,1.7186516,-0.62617471,-0.66486296,-0.60707872,1.7186516,-0.62617471,-0.66486296,-0.60707872,1.7186516,-0.62617471:0
-0.21262489,0.15610006,1.6480025,-0.70156232,-0.21696197,0.14416786,1.6421464,-0.70160422,-0.21479343,0.13983078,1.6487777,-0.70162518,-0.21370392,0.1354937,1.652151,-0.70164613,-0.21262489,0.11705588,1.657389,-0.70171946,-0.20502976,0.11380831,1.6733335,-0.70174041,-0.20936684,0.11055027,1.6658117,-0.70175089,-0.20502976,0.11163977,1.6745906,-0.70175089,-0.20502976,0.10947123,1.6758163,-0.70176137,-0.20611927,0.10838173,1.6735325,-0.70176137,-0.2071983,0.10296562,1.6712278,-0.70178232,-0.20395073,0.10404465,1.6769896,-0.70177184,-0.2071983,0.10079708,1.6744963,-0.70178232,-0.20828781,0.099707571,1.6720869,-0.70179279,-0.2071983,0.097539032,1.6743602,-0.70180327,-0.19852415,0.09862854,1.6906504,-0.70180327,-0.20069269,0.09862854,1.6894666,-0.70180327,-0.20069269,0.094291462,1.6874761,-0.70182422,-0.19743464,0.092122923,1.6938141,-0.70182422,-0.20936684,0.088864876,1.6736478,-0.7018347,-0.20286123,0.088864876,1.6834219,-0.70184517,-0.20395073,0.086696338,1.68646,-0.70184517,-0.19635561,0.086696338,1.6988636,-0.70185565,-0.19960318,0.08235926,1.6919913,-0.70186613,-0.21045635,0.081269752,1.672904,-0.70186613,-0.21045635,0.078022182,1.6744335,-0.7018766,-0.20936684,0.074764135,1.6745068,-0.70188708,-0.20828781,0.075853643,1.6775553,-0.70188708,-0.2071983,0.076932674,1.6807191,-0.70188708,-0.2071983,0.075853643,1.6801848,-0.70188708,-0.2071983,0.071516565,1.6796296,-0.70190803,-0.70605654,-0.70605654,1.6849724,-0.70605654,-0.70605654,-0.70605654,1.6802791,-0.70605654,-0.70605654,-0.70605654,1.6847943,-0.70605654,-0.70605654,-0.70605654,1.6787182,-0.70605654,-0.70605654,-0.70605654,1.6814943,-0.70605654,-0.70605654,-0.70605654,1.6773982,-0.70605654,-0.70605654,-0.70605654,1.6795248,-0.70605654,-0.70605654,-0.70605654,1.6780268,-0.70605654,-0.70605654,-0.70605654,1.6739725,-0.70605654,-0.70605654,-0.70605654,1.6741716,-0.70605654,-0.70605654,-0.70605654,1.6680431,-0.70605654,-0.70605654,-0.70605654,1.6672155,-0.70605654,-0.70605654,-0.70605654,1.6721811,-0.70605654,-0.70605654,-0.70605654,1.6655812,-0.70605654,-0.70605654,-0.70605654,1.6657174,-0.70605654,-0.70605654,-0.70605654,1.6664507,-0.70605654,-0.70605654,-0.70605654,1.6678022,-0.70605654,-0.70605654,-0.70605654,1.6507053,-0.70605654,-0.70605654,-0.70605654,1.6495215,-0.70605654,-0.70605654,-0.70605654,1.6720345,-0.70605654,-0.70605654,-0.70605654,1.6645546,-0.70605654,-0.70605654,-0.70605654,1.6653089,-0.70605654,-0.70605654,-0.70605654,1.6632556,-0.70605654,-0.70605654,-0.70605654,1.6572947,-0.70605654,-0.70605654,-0.70605654,1.6595575,-0.70605654,-0.70605654,-0.70605654,1.6640517,-0.70605654,-0.70605654,-0.70605654,1.6616213,-0.70605654,-0.70605654,-0.70605654,1.6682317,-0.70605654,-0.70605654,-0.70605654,1.6621032,-0.70605654,-0.70605654,-0.70605654,1.6721497,-0.70605654,-0.70605654,-0.70605654,1.6658117,-0.70605654,-0.70605654,-0.70605654,1.6649003,-0.70605654,-0.70605654,-0.70605654,1.6688183,-0.70605654,-0.70605654,-0.70605654,1.667666,-0.70605654,-0.70605654,-0.70605654,1.6742344,-0.70605654,-0.70605654,-0.70605654,1.6629622,-0.70605654,-0.70605654,-0.70605654,1.6634127,-0.70605654,-0.70605654,-0.70605654,1.6837572,-0.70605654,-0.70605654,-0.70605654,1.6722964,-0.70605654,-0.70605654,-0.70605654,1.6789277,-0.70605654,-0.70605654,-0.70605654,1.6862505,-0.70605654,-0.70605654,-0.70605654,1.6885971,-0.70605654,-0.70605654,-0.70605654,1.6820915,-0.70605654,-0.70605654,-0.70605654,1.6861038,-0.70605654,-0.70605654,-0.70605654,1.6883142,-0.70605654,-0.70605654,-0.70605654,1.6879895,-0.70605654,-0.70605654,-0.70605654,1.6962236,-0.70605654,-0.70605654,-0.70605654,1.6967474,-0.70605654,-0.70605654,-0.70605654,1.6901371,-0.70605654,-0.70605654,-0.70605654,1.6926094,-0.70605654,-0.70605654,-0.70605654,1.6959094,-0.70605654,-0.70605654,-0.70605654,1.6976589,-0.70605654,-0.70605654,-0.70605654,1.7010845,-0.70605654,-0.70605654,-0.70605654,1.6936361,-0.70605654,-0.70605654,-0.70605654,1.6918656,-0.70605654,-0.70605654,-0.70605654,1.679462,-0.70605654,-0.70605654,-0.70605654,1.6823324,-0.70605654,-0.70605654,-0.70605654,1.690818,-0.70605654,-0.70605654,-0.70605654,1.6843124,-0.70605654,-0.70605654,-0.70605654,1.694317,-0.70605654,-0.70605654,-0.70605654,1.6905456,-0.70605654,-0.70605654,-0.70605654,1.6804886,-0.70605654,-0.70605654,-0.70605654,1.6839562,-0.70605654,-0.70605654,-0.70605654,1.6781839,-0.70605654,-0.70605654,-0.70605654,1.6839248,-0.70605654,-0.70605654,-0.70605654,1.6889114,-0.70605654,-0.69521384,-0.52386784,1.6742973,-0.70526036,-0.69521384,-0.52278881,1.6867952,-0.70526036,-0.69521384,-0.52278881,1.6859676,-0.70526036,-0.69521384,-0.56832813,1.6622394,-0.7053756,-0.70605654,-0.70605654,1.6715211,-0.70605654,-0.70605654,-0.70605654,1.6775449,-0.70605654,-0.70605654,-0.70605654,1.6807715,-0.70605654,-0.70605654,-0.70605654,1.6708821,-0.70605654,-0.70605654,-0.70605654,1.675303,-0.70605654,-0.70605654,-0.70605654,1.6861247,-0.70605654,-0.70605654,-0.70605654,1.6753659,-0.70605654,-0.70605654,-0.70605654,1.6715002,-0.70605654,-0.70605654,-0.70605654,1.6859362,-0.70605654,-0.70605654,-0.70605654,1.6836105,-0.70605654,-0.70605654,-0.70605654,1.6773458,-0.70605654,-0.70605654,-0.70605654,1.6768325,-0.70605654,-0.70605654,-0.70605654,1.6887018,-0.70605654,-0.70605654,-0.70605654,1.6782782,-0.70605654,-0.70605654,-0.70605654,1.6729564,-0.70605654,-0.70605654,-0.70605654,1.6811905,-0.70605654,-0.70605654,-0.70605654,1.6790429,-0.70605654,-0.70605654,-0.70605654,1.6770106,-0.70605654,-0.70605654,-0.70605654,1.6830657,-0.70605654,-0.70605654,-0.70605654,1.6755125,-0.70605654,-0.70605654,-0.70605654,1.6874761,-0.70605654,-0.70605654,-0.70605654,1.6835581,-0.70605654,-0.70605654,-0.70605654,1.6830972,-0.70605654,-0.70605654,-0.70605654,1.6874238,-0.70605654,-0.70605654,-0.70605654,1.6749363,-0.70605654,-0.70605654,-0.70605654,1.6861771,-0.70605654,-0.70605654,-0.70605654,1.6870047,-0.70605654,-0.20069269,0.19514424,1.6711545,-0.70142613,-0.1952661,0.182133,1.6826886,-0.70148899,-0.19852415,0.182133,1.6789382,-0.70148899,-0.19635561,0.1929757,1.6812743,-0.70144708,-0.19852415,0.18538057,1.6777649,-0.70146804,-0.20502976,0.17562739,1.6667336,-0.70149946,-0.1952661,0.18971765,1.6796925,-0.70145756,-0.20286123,0.17562739,1.6697717,-0.70150994,-0.20611927,0.17887496,1.6640413,-0.70148899,-0.19418707,0.17453788,1.6864181,-0.70152042,-0.19960318,0.1702008,1.6770211,-0.70153089,-0.20611927,0.16477421,1.667865,-0.70155184,-0.19960318,0.1582686,1.6821124,-0.70158327,-0.20178219,0.15393152,1.6770839,-0.70159375,-0.20069269,0.14416786,1.6805305,-0.70163565,-0.20611927,0.13007759,1.6749573,-0.70168803,-0.20395073,0.12357198,1.6825105,-0.70171946,-0.19960318,0.12140344,1.6877904,-0.70171946,-0.2071983,0.11597685,1.6736373,-0.70174041,-0.20178219,0.11597685,1.6828353,-0.70174041,-0.20502976,0.11380831,1.6785296,-0.70175089,-0.21045635,0.11055027,1.6696355,-0.70176137,-0.20936684,0.11055027,1.6699707,-0.70176137,-0.20502976,0.10838173,1.6798286,-0.70177184,-0.2071983,0.1073027,1.6761097,-0.70177184,-0.2071983,0.10513416,1.6766963,-0.70178232,-0.20828781,0.10621319,1.6757954,-0.70178232,-0.20828781,0.10404465,1.6777544,-0.70179279,-0.20936684,0.10187611,1.6730087,-0.70179279,-0.21153538,0.10079708,1.6703164,-0.70179279,-0.21479343,0.095370493,1.6635698,-0.70181375,-0.21153538,0.095370493,1.6719402,-0.70181375,-0.21153538,0.092122923,1.6717621,-0.7018347,-0.21370392,0.092122923,1.6679069,-0.7018347,-0.21153538,0.087775369,1.6731345,-0.70184517,-0.21696197,0.086696338,1.6625432,-0.70184517,-0.218041,0.083438291,1.6609299,-0.70185565,-0.21370392,0.084527799,1.6706726,-0.70185565,-0.21587246,0.08235926,1.6655079,-0.70186613,-0.21479343,0.080190721,1.6687136,-0.7018766,-0.21370392,0.078022182,1.6702221,-0.70188708,-0.21479343,0.076932674,1.6715526,-0.70189755,-0.21153538,0.073685104,1.6749049,-0.70189755,-0.21370392,0.076932674,1.6695831,-0.70188708,-0.21153538,0.072595597,1.6775763,-0.70190803,-0.21262489,0.074764135,1.6731659,-0.70189755,-0.70605654,-0.70605654,1.6728621,-0.70605654,-0.70605654,-0.70605654,1.6676136,-0.70605654,-0.70605654,-0.70605654,1.6764554,-0.70605654,-0.70605654,-0.70605654,1.6695831,-0.70605654,-0.70605654,-0.70605654,1.6805305,-0.70605654,-0.70605654,-0.70605654,1.679902,-0.70605654,-0.70605654,-0.70605654,1.6714897,-0.70605654,-0.70605654,-0.70605654,1.6722754,-0.70605654,-0.70605654,-0.70605654,1.6763192,-0.70605654,-0.70605654,-0.70605654,1.6776287,-0.70605654,-0.70605654,-0.70605654,1.6753344,-0.70605654,-0.70605654,-0.70605654,1.6774611,-0.70605654,-0.70605654,-0.70605654,1.6857162,-0.70605654,-0.70605654,-0.70605654,1.6772201,-0.70605654,-0.70605654,-0.70605654,1.6661574,-0.70605654,-0.70605654,-0.70605654,1.6722754,-0.70605654,-0.70605654,-0.70605654,1.6742973,-0.70605654,-0.70605654,-0.70605654,1.6708507,-0.70605654,-0.70605654,-0.70605654,1.6652879,-0.70605654,-0.70605654,-0.70605654,1.6767173,-0.70605654,-0.70605654,-0.70605654,1.6770106,-0.70605654,-0.70605654,-0.70605654,1.6747163,-0.70605654,-0.70605654,-0.70605654,1.6668907,-0.70605654,-0.70605654,-0.70605654,1.6782572,-0.70605654,-0.70605654,-0.70605654,1.6733964,-0.70605654,-0.70605654,-0.70605654,1.6599137,-0.70605654,-0.70605654,-0.70605654,1.6784772,-0.70605654,-0.70605654,-0.70605654,1.6753554,-0.70605654,-0.70605654,-0.70605654,1.6756906,-0.70605654,-0.70605654,-0.70605654,1.6793991,-0.70605654,-0.70605654,-0.70605654,1.6862924,-0.70605654,-0.70605654,-0.70605654,1.6782468,-0.70605654,-0.70605654,-0.70605654,1.678341,-0.70605654,-0.70605654,-0.70605654,1.6776496,-0.70605654,-0.70605654,-0.70605654,1.6803315,-0.70605654,-0.70605654,-0.70605654,1.6762668,-0.70605654,-0.70605654,-0.70605654,1.6826991,-0.70605654,-0.70605654,-0.70605654,1.6834114,-0.70605654,-0.70605654,-0.70605654,1.6808448,-0.70605654,-0.70605654,-0.70605654,1.6820181,-0.70605654,-0.70605654,-0.70605654,1.680981,-0.70605654,-0.70605654,-0.70605654,1.6760154,-0.70605654,-0.70605654,-0.70605654,1.6774611,-0.70605654,-0.70605654,-0.70605654,1.6800696,-0.70605654,-0.70605654,-0.70605654,1.6796401,-0.70605654,-0.70605654,-0.70605654,1.6838829,-0.70605654,-0.70605654,-0.70605654,1.6800277,-0.70605654,-0.70605654,-0.70605654,1.6797029,-0.70605654,-0.70605654,-0.70605654,1.6803315,-0.70605654,-0.70605654,-0.70605654,1.6782572,-0.70605654,-0.70605654,-0.70605654,1.6772201,-0.70605654,-0.70605654,-0.70605654,1.6890266,-0.70605654,-0.70605654,-0.70605654,1.680562,-0.70605654,-0.70605654,-0.70605654,1.6790534,-0.70605654,-0.70605654,-0.70605654,1.6881466,-0.70605654,-0.70605654,-0.70605654,1.6812848,-0.70605654,-0.70605654,-0.70605654,1.6596832,-0.70605654,-0.70605654,-0.70605654,1.6907551,-0.70605654,-0.70605654,-0.70605654,1.6897914,-0.70605654,-0.70605654,-0.70605654,1.6931856,-0.70605654,-0.70605654,-0.70605654,1.6869838,-0.70605654,-0.70605654,-0.70605654,1.6935837,-0.70605654,-0.70605654,-0.70605654,1.6880942,-0.70605654,-0.70605654,-0.70605654,1.6837362,-0.70605654,-0.70605654,-0.70605654,1.6946313,-0.70605654,-0.70605654,-0.70605654,1.6920332,-0.70605654,-0.70605654,-0.70605654,1.6919704,-0.70605654,-0.70605654,-0.70605654,1.6941284,-0.70605654,-0.70605654,-0.70605654,1.6920542,-0.70605654,-0.70605654,-0.70605654,1.6971141,-0.70605654,-0.70605654,-0.70605654,1.6875285,-0.70605654,-0.70605654,-0.70605654,1.6846476,-0.70605654,-0.70605654,-0.70605654,1.6893723,-0.70605654,-0.70605654,-0.70605654,1.685559,-0.70605654,-0.70605654,-0.70605654,1.6912266,-0.70605654,-0.70605654,-0.70605654,1.6806772,-0.70605654,-0.70605654,-0.70605654,1.6832962,-0.70605654,-0.70605654,-0.70605654,1.6856952,-0.70605654,-0.70605654,-0.70605654,1.676602,-0.70605654,-0.70605654,-0.70605654,1.6851086,-0.70605654,-0.70605654,-0.70605654,1.6909123,-0.70605654,-0.70605654,-0.70605654,1.6860619,-0.70605654,-0.70605654,-0.70605654,1.6839457,-0.70605654,-0.69521384,-0.52278881,1.6875076,-0.70526036,-0.69521384,-0.52278881,1.6849514,-0.70526036,-0.70605654,-0.70605654,1.6926513,-0.70605654,-0.70605654,-0.70605654,1.6856743,-0.70605654,-0.70605654,-0.70605654,1.691698,-0.70605654,-0.70605654,-0.70605654,1.6921799,-0.70605654,-0.70605654,-0.70605654,1.6893095,-0.70605654,-0.70605654,-0.70605654,1.6897599,-0.70605654,-0.70605654,-0.70605654,1.6875181,-0.70605654,-0.70605654,-0.70605654,1.6579337,-0.70605654,-0.70605654,-0.70605654,1.6875704,-0.70605654,-0.70605654,-0.70605654,1.6731764,-0.70605654,-0.70605654,-0.70605654,1.6869419,-0.70605654,-0.70605654,-0.70605654,1.6877171,-0.70605654,-0.70605654,-0.70605654,1.6785191,-0.70605654,-0.70605654,-0.70605654,1.6923161,-0.70605654,-0.70605654,-0.70605654,1.6950922,-0.70605654,-0.70605654,-0.70605654,1.6949456,-0.70605654,-0.19418707,0.18971765,1.6872038,-0.70146804,-0.19201853,0.19840228,1.6889428,-0.70142613,-0.19743464,0.17996446,1.6835581,-0.70149946,-0.19852415,0.17236934,1.6832019,-0.70153089,-0.19852415,0.17345885,1.6823953,-0.70152042,-0.19418707,0.17887496,1.6838619,-0.70149946,-0.19418707,0.17562739,1.6852552,-0.70150994,-0.19418707,0.17345885,1.6880104,-0.70152042,-0.19743464,0.17670642,1.6820286,-0.70150994,-0.21045635,0.16911129,1.6565404,-0.70152042,-0.20936684,0.16152664,1.6596309,-0.70155184,-0.21370392,0.15718957,1.6549271,-0.7015728,-0.21153538,0.15285249,1.6594004,-0.70159375,-0.21153538,0.1474259,1.6600918,-0.7016147,-0.21262489,0.14199932,1.6605108,-0.70163565,-0.21370392,0.12790905,1.6611708,-0.70168803,-0.21696197,0.12248247,1.657368,-0.70170899,-0.21587246,0.11705588,1.6593899,-0.70172994,-0.21587246,0.11380831,1.6609508,-0.70175089,-0.22020954,0.11055027,1.6529052,-0.70175089,-0.21370392,0.11055027,1.6632241,-0.70176137,-0.22020954,0.1073027,1.6532195,-0.70176137,-0.218041,0.1073027,1.6569595,-0.70177184,-0.21696197,0.10404465,1.6605318,-0.70178232,-0.2071983,0.10296562,1.679001,-0.70179279,-0.20286123,0.10404465,1.6866904,-0.70179279,-0.20286123,0.10187611,1.6858209,-0.70179279,-0.21045635,0.09862854,1.6734487,-0.70180327,-0.2071983,0.09862854,1.681201,-0.70181375,-0.20178219,0.10079708,1.6901894,-0.70180327,-0.20286123,0.096460001,1.6861352,-0.70181375,-0.20069269,0.096460001,1.6925256,-0.70182422,-0.20178219,0.094291462,1.6905037,-0.7018347,-0.20828781,0.091033415,1.6814943,-0.70184517,-0.19960318,0.091033415,1.6951341,-0.70184517,-0.20611927,0.084527799,1.6863866,-0.70186613,-0.2071983,0.083438291,1.6841971,-0.70186613,-0.2071983,0.084527799,1.6828981,-0.70186613,-0.2071983,0.08235926,1.6848048,-0.7018766,-0.20069269,0.081269752,1.6949875,-0.7018766,-0.20936684,0.074764135,1.6813581,-0.70190803,-0.2071983,0.076932674,1.6856219,-0.70189755,-0.21479343,0.073685104,1.6731135,-0.70190803,-0.70605654,-0.70605654,1.6840714,-0.70605654,-0.70605654,-0.70605654,1.6970093,-0.70605654,-0.70605654,-0.70605654,1.6861352,-0.70605654,-0.70605654,-0.70605654,1.6889533,-0.70605654,-0.70605654,-0.70605654,1.693877,-0.70605654,-0.70605654,-0.70605654,1.6928084,-0.70605654,-0.70605654,-0.70605654,1.6892466,-0.70605654,-0.70605654,-0.70605654,1.6927875,-0.70605654,-0.70605654,-0.70605654,1.6914989,-0.70605654,-0.70605654,-0.70605654,1.6965798,-0.70605654,-0.70605654,-0.70605654,1.6910066,-0.70605654,-0.70605654,-0.70605654,1.6943484,-0.70605654,-0.70605654,-0.70605654,1.6924208,-0.70605654,-0.70605654,-0.70605654,1.6905247,-0.70605654,-0.70605654,-0.70605654,1.6859781,-0.70605654,-0.70605654,-0.70605654,1.6862924,-0.70605654,-0.70605654,-0.70605654,1.6827515,-0.70605654,-0.70605654,-0.70605654,1.6922951,-0.70605654,-0.70605654,-0.70605654,1.6867847,-0.70605654,-0.70605654,-0.70605654,1.6877695,-0.70605654,-0.70605654,-0.70605654,1.6948513,-0.70605654,-0.70605654,-0.70605654,1.6960036,-0.70605654,-0.70605654,-0.70605654,1.6829086,-0.70605654,-0.70605654,-0.70605654,1.6848886,-0.70605654,-0.70605654,-0.70605654,1.697575,-0.70605654,-0.70605654,-0.70605654,1.6849933,-0.70605654,-0.70605654,-0.70605654,1.68756,-0.70605654,-0.70605654,-0.70605654,1.6959722,-0.70605654,-0.70605654,-0.70605654,1.6893409,-0.70605654,-0.70605654,-0.70605654,1.6825419,-0.70605654,-0.70605654,-0.70605654,1.6798391,-0.70605654,-0.70605654,-0.70605654,1.6853809,-0.70605654,-0.70605654,-0.70605654,1.6818296,-0.70605654,-0.70605654,-0.70605654,1.6732183,-0.70605654,-0.70605654,-0.70605654,1.6793048,-0.70605654,-0.70605654,-0.70605654,1.6816724,-0.70605654,-0.70605654,-0.70605654,1.6747163,-0.70605654,-0.70605654,-0.70605654,1.6814524,-0.70605654,-0.70605654,-0.70605654,1.678781,-0.70605654,-0.70605654,-0.70605654,1.6842181,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654,-0.70605654,-0.70605654,1.6788334,-0.70605654:0
-0.68400196,-0.68400196,1.6510315,-0.68400196,-0.68400196,-0.68400196,1.6246461,-0.68400196,-0.68400196,-0.68400196,1.6524399,-0.68400196,-0.68400196,-0.68400196,1.6521518,-0.68400196,-0.68400196,-0.68400196,1.6550966,-0.68400196,-0.68400196,-0.68400196,1.6532188,-0.68400196,-0.68400196,-0.68400196,1.6507541,-0.68400196,-0.68400196,-0.68400196,1.6494205,-0.68400196,-0.68400196,-0.68400196,1.6597058,-0.68400196,-0.68400196,-0.68400196,1.6607194,-0.68400196,-0.68400196,-0.68400196,1.6459636,-0.68400196,-0.68400196,-0.68400196,1.6606233,-0.68400196,-0.68400196,-0.68400196,1.6576893,-0.68400196,-0.68400196,-0.68400196,1.6583081,-0.68400196,-0.68400196,-0.68400196,1.6572838,-0.68400196,-0.68400196,-0.68400196,1.6621491,-0.68400196,-0.68400196,-0.68400196,1.6589589,-0.68400196,-0.68400196,-0.68400196,1.6269293,-0.68400196,-0.68400196,-0.68400196,1.6607087,-0.68400196,-0.68400196,-0.68400196,1.6519491,-0.68400196,-0.68400196,-0.68400196,1.6539976,-0.68400196,-0.68400196,-0.68400196,1.6559501,-0.68400196,-0.68400196,-0.68400196,1.6530907,-0.68400196,-0.68400196,-0.68400196,1.6531974,-0.68400196,-0.68400196,-0.68400196,1.6512876,-0.68400196,-0.68400196,-0.68400196,1.6468278,-0.68400196,-0.68400196,-0.68400196,1.6548512,-0.68400196,-0.68400196,-0.68400196,1.6538163,-0.68400196,-0.68400196,-0.68400196,1.6531974,-0.68400196,-0.68400196,-0.68400196,1.6318373,-0.68400196,-0.68400196,-0.68400196,1.6502527,-0.68400196,-0.68400196,-0.68400196,1.6552246,-0.68400196,-0.68400196,-0.68400196,1.6521092,-0.68400196,-0.68400196,-0.68400196,1.6457502,-0.68400196,-0.68400196,-0.68400196,1.647596,-0.68400196,-0.68400196,-0.68400196,1.663152,-0.68400196,-0.68400196,-0.68400196,1.6607621,-0.68400196,-0.68400196,-0.68400196,1.6509782,-0.68400196,-0.68400196,-0.68400196,1.658052,-0.68400196,-0.68400196,-0.68400196,1.6553847,-0.68400196,-0.68400196,-0.68400196,1.6523332,-0.68400196,-0.68400196,-0.68400196,1.6516717,-0.68400196,-0.68400196,-0.68400196,1.6482575,-0.68400196,-0.68400196,-0.68400196,1.6467104,-0.68400196,-0.68400196,-0.68400196,1.6484389,-0.68400196,-0.68400196,-0.68400196,1.641045,-0.68400196,-0.68400196,-0.68400196,1.6474573,-0.68400196,-0.68400196,-0.68400196,1.6534535,-0.68400196,-0.68400196,-0.68400196,1.6537949,-0.68400196,-0.68400196,-0.68400196,1.6505941,-0.68400196,-0.68400196,-0.68400196,1.6538163,-0.68400196,-0.68400196,-0.68400196,1.657828,-0.68400196,-0.68400196,-0.68400196,1.6483215,-0.68400196,-0.68400196,-0.68400196,1.6570278,-0.68400196,-0.68400196,-0.68400196,1.6571558,-0.68400196,-0.68400196,-0.68400196,1.635977,-0.68400196,-0.68400196,-0.68400196,1.6546271,-0.68400196,-0.68400196,-0.68400196,1.6481081,-0.68400196,-0.68400196,-0.68400196,1.6346967,-0.68400196,-0.68400196,-0.68400196,1.6555981,-0.68400196,-0.68400196,-0.68400196,1.6547872,-0.68400196,-0.68400196,-0.68400196,1.65037,-0.68400196,-0.68400196,-0.68400196,1.6500926,-0.68400196,-0.68400196,-0.68400196,1.6500606,-0.68400196,-0.68400196,-0.68400196,1.651597,-0.68400196,-0.68400196,-0.68400196,1.6518638,-0.68400196,-0.68400196,-0.68400196,1.6520771,-0.68400196,-0.68400196,-0.68400196,1.6516504,-0.68400196,-0.68400196,-0.68400196,1.6516397,-0.68400196,-0.68400196,-0.68400196,1.6562916,-0.68400196,-0.68400196,-0.68400196,1.6552566,-0.68400196,-0.68400196,-0.68400196,1.6572305,-0.68400196,-0.68400196,-0.68400196,1.6617223,-0.68400196,-0.68400196,-0.68400196,1.6613595,-0.68400196,-0.68400196,-0.68400196,1.6642616,-0.68400196,-0.68400196,-0.68400196,1.6537202,-0.68400196,-0.68400196,-0.68400196,1.6571024,-0.68400196,-0.68400196,-0.68400196,1.6569957,-0.68400196,-0.68400196,-0.68400196,1.6544458,-0.68400196,-0.68400196,-0.68400196,1.6395619,-0.68400196,-0.68400196,-0.68400196,1.6532615,-0.68400196,-0.68400196,-0.68400196,1.6517997,-0.68400196,-0.68400196,-0.68400196,1.6191833,-0.68400196,-0.68400196,-0.68400196,1.6544991,-0.68400196,-0.68400196,-0.68400196,1.6546058,-0.68400196,-0.68400196,-0.68400196,1.6533255,-0.68400196,-0.68400196,-0.68400196,1.6513836,-0.68400196,-0.68400196,-0.68400196,1.6215626,-0.68400196,-0.68400196,-0.68400196,1.6236752,-0.68400196,-0.68400196,-0.68400196,1.6642616,-0.68400196,-0.68400196,-0.68400196,1.6658407,-0.68400196,-0.68400196,-0.68400196,1.6662461,-0.68400196,-0.68400196,-0.68400196,1.6634401,-0.68400196,-0.68400196,-0.68400196,1.6646457,-0.68400196,-0.68400196,-0.68400196,1.6598658,-0.68400196,-0.68400196,-0.68400196,1.6258731,-0.68400196,-0.68400196,-0.68400196,1.6544778,-0.68400196,-0.68400196,-0.68400196,1.6535602,-0.68400196,-0.68400196,-0.68400196,1.6549366,-0.68400196,-0.68400196,-0.68400196,1.6542004,-0.68400196,-0.68400196,-0.68400196,1.6576999,-0.68400196,-0.68400196,-0.68400196,1.6525573,-0.68400196,-0.68400196,-0.68400196,1.656825,-0.68400196,-0.68400196,-0.68400196,1.6570918,-0.68400196,-0.68400196,-0.68400196,1.6577213,-0.68400196,-0.68400196,-0.68400196,1.6622131,-0.68400196,-0.68400196,-0.68400196,1.6598018,-0.68400196,0.31004611,0.40392629,1.6477667,-0.67723755,0.32329752,0.41166162,1.6598978,-0.67720554,0.32771466,0.4271216,1.6620957,-0.6771522,0.32882428,0.40282734,1.6651579,-0.67723755,0.32771466,0.39950915,1.6649445,-0.67724822,0.32882428,0.39288345,1.6675265,-0.67728023,0.32992323,0.38073098,1.6689882,-0.67731224,0.32992323,0.37521489,1.6691269,-0.67733358,0.33103285,0.37631384,1.670802,-0.67733358,0.32992323,0.37852241,1.6694576,-0.67732291,0.32550609,0.37521489,1.6643363,-0.67733358,0.32440714,0.36747957,1.6645604,-0.67736558,0.30783754,0.34760245,1.6482468,-0.67744027,0.32550609,0.34981102,1.6671957,-0.6774296,0.32661571,0.34428426,1.6694256,-0.67745094,0.30783754,0.33434037,1.6491217,-0.67748295,0.32440714,0.3321318,1.6687428,-0.67749362,0.31225468,0.32440714,1.6559501,-0.67752562,0.32329752,0.31004611,1.6691802,-0.6775683,0.32108895,0.30783754,1.6678679,-0.67757897,0.31999,0.30783754,1.6660221,-0.67757897,0.30893649,0.29458612,1.6543071,-0.67762165,0.31999,0.29237756,1.6673237,-0.67763232,0.31888038,0.28132404,1.667025,-0.67766433,0.31778143,0.28464223,1.6657127,-0.67765366,0.31556219,0.27580795,1.6636215,-0.67768567,0.31888038,0.26807263,1.6677825,-0.67770701,0.31556219,0.25592016,1.6661181,-0.67776035,0.30783754,0.25592016,1.6573692,-0.67776035,0.31556219,0.25040408,1.6661501,-0.67777102,0.31446325,0.2415698,1.6655099,-0.67780303,0.31114506,0.24046018,1.6626399,-0.6778137,0.30893649,0.22720877,1.6601005,-0.67785638,0.30783754,0.22609915,1.6589056,-0.67785638,0.28022509,0.21395735,1.6283697,-0.67790972,0.29237756,0.21284774,1.6437337,-0.67790972,-0.68400196,-0.68400196,1.6481188,-0.68400196,-0.68400196,-0.68400196,1.6600792,-0.68400196,-0.68400196,-0.68400196,1.6476707,-0.68400196,-0.68400196,-0.68400196,1.6617543,-0.68400196,-0.68400196,-0.68400196,1.6611248,-0.68400196,-0.68400196,-0.68400196,1.6581801,-0.68400196,-0.68400196,-0.68400196,1.6611035,-0.68400196,-0.68400196,-0.68400196,1.6418985,-0.68400196,-0.68400196,-0.68400196,1.6553313,-0.68400196,-0.68400196,-0.68400196,1.6583828,-0.68400196,-0.68400196,-0.68400196,1.6551713,-0.68400196,-0.68400196,-0.68400196,1.6428801,-0.68400196,-0.68400196,-0.68400196,1.6561849,-0.68400196,-0.68400196,-0.68400196,1.6554807,-0.68400196,-0.68400196,-0.68400196,1.6572411,-0.68400196,-0.68400196,-0.68400196,1.6541897,-0.68400196,-0.68400196,-0.68400196,1.6401594,-0.68400196,-0.68400196,-0.68400196,1.6559501,-0.68400196,-0.68400196,-0.68400196,1.6564409,-0.68400196,-0.68400196,-0.68400196,1.6569744,-0.68400196,-0.68400196,-0.68400196,1.6577853,-0.68400196,-0.68400196,-0.68400196,1.6567824,-0.68400196,-0.68400196,-0.68400196,1.659183,-0.68400196,-0.68400196,-0.68400196,1.6637708,-0.68400196,-0.68400196,-0.68400196,1.6659047,-0.68400196,-0.68400196,-0.68400196,1.6668116,-0.68400196,-0.68400196,-0.68400196,1.6632053,-0.68400196,-0.68400196,-0.68400196,1.6667583,-0.68400196,-0.68400196,-0.68400196,1.6530481,-0.68400196,-0.68400196,-0.68400196,1.6664702,-0.68400196,-0.68400196,-0.68400196,1.665798,-0.68400196,-0.68400196,-0.68400196,1.6637922,-0.68400196,-0.68400196,-0.68400196,1.659375,-0.68400196,-0.68400196,-0.68400196,1.6622984,-0.68400196,-0.68400196,-0.68400196,1.6655526,-0.68400196,-0.68400196,-0.68400196,1.6675158,-0.68400196,-0.68400196,-0.68400196,1.6653819,-0.68400196,-0.68400196,-0.68400196,1.6671744,-0.68400196,-0.68400196,-0.68400196,1.6684974,-0.68400196,-0.68400196,-0.68400196,1.6620957,-0.68400196,-0.68400196,-0.68400196,1.667153,-0.68400196,-0.68400196,-0.68400196,1.6682306,-0.68400196,-0.68400196,-0.68400196,1.6689562,-0.68400196,-0.68400196,-0.68400196,1.6676652,-0.68400196,-0.68400196,-0.68400196,1.6681346,-0.68400196,-0.68400196,-0.68400196,1.6715595,-0.68400196,-0.68400196,-0.68400196,1.668508,-0.68400196,-0.68400196,-0.68400196,1.6573905,-0.68400196,-0.68400196,-0.68400196,1.6704179,-0.68400196,-0.68400196,-0.68400196,1.6663742,-0.68400196,-0.68400196,-0.68400196,1.6520451,-0.68400196,-0.68400196,-0.68400196,1.6712287,-0.68400196,-0.68400196,-0.68400196,1.6575612,-0.68400196,-0.68400196,-0.68400196,1.6687214,-0.68400196,-0.68400196,-0.68400196,1.6708767,-0.68400196,-0.68400196,-0.68400196,1.6705886,-0.68400196,-0.68400196,-0.68400196,1.6619784,-0.68400196,-0.68400196,-0.68400196,1.66822,-0.68400196,-0.68400196,-0.68400196,1.6678999,-0.68400196,-0.68400196,-0.68400196,1.6276122,-0.68400196,-0.68400196,-0.68400196,1.6646884,-0.68400196,-0.68400196,-0.68400196,1.6414824,-0.68400196,-0.68400196,-0.68400196,1.6600365,-0.68400196,-0.68400196,-0.68400196,1.6642723,-0.68400196,-0.68400196,-0.68400196,1.6638775,-0.68400196,-0.68400196,-0.68400196,1.6634081,-0.68400196,-0.68400196,-0.68400196,1.6659047,-0.68400196,-0.68400196,-0.68400196,1.6616476,-0.68400196,-0.68400196,-0.68400196,1.6649018,-0.68400196,-0.68400196,-0.68400196,1.6644323,-0.68400196,-0.68400196,-0.68400196,1.6618503,-0.68400196,-0.68400196,-0.68400196,1.6604206,-0.68400196,-0.68400196,-0.68400196,1.646337,-0.68400196,-0.68400196,-0.68400196,1.666897,-0.68400196,-0.68400196,-0.68400196,1.665734,-0.68400196,-0.68400196,-0.68400196,1.6699484,-0.68400196,-0.68400196,-0.68400196,1.6552353,-0.68400196,-0.68400196,-0.68400196,1.6659154,-0.68400196,-0.68400196,-0.68400196,1.6701725,-0.68400196,-0.68400196,-0.68400196,1.6680279,-0.68400196,-0.68400196,-0.68400196,1.6498259,-0.68400196,-0.68400196,-0.68400196,1.6661288,-0.68400196,-0.68400196,-0.68400196,1.6338004,-0.68400196,-0.68400196,-0.68400196,1.6538376,-0.68400196,-0.68400196,-0.68400196,1.6216586,-0.68400196,-0.68400196,-0.68400196,1.6665662,-0.68400196,-0.68400196,-0.68400196,1.6496339,-0.68400196,-0.68400196,-0.68400196,1.6611568,-0.68400196,-0.68400196,-0.68400196,1.663088,-0.68400196,-0.68400196,-0.68400196,1.6624158,-0.68400196,-0.68400196,-0.68400196,1.666961,-0.68400196,-0.68400196,-0.68400196,1.6658727,-0.68400196,-0.68400196,-0.68400196,1.6222988,-0.68400196,-0.68400196,-0.68400196,1.6615729,-0.68400196,-0.68400196,-0.68400196,1.6648271,-0.68400196,-0.68400196,-0.68400196,1.6631093,-0.68400196,-0.68400196,-0.68400196,1.6630666,-0.68400196,-0.68400196,-0.68400196,1.6290419,-0.68400196,-0.68400196,-0.68400196,1.6609114,-0.68400196,-0.68400196,-0.68400196,1.660698,-0.68400196,-0.68400196,-0.68400196,1.6602926,-0.68400196,-0.68400196,-0.68400196,1.6472866,-0.68400196,-0.68400196,-0.68400196,1.6305889,-0.68400196,-0.68400196,-0.68400196,1.6286898,-0.68400196,-0.68400196,-0.68400196,1.6622878,-0.68400196,-0.68400196,-0.68400196,1.6631307,-0.68400196,-0.68400196,-0.68400196,1.6615836,-0.68400196,-0.68400196,-0.68400196,1.6628639,-0.68400196,-0.68400196,-0.68400196,1.6511169,-0.68400196,-0.68400196,-0.68400196,1.6634507,-0.68400196,-0.68400196,-0.68400196,1.6538269,-0.68400196,-0.68400196,-0.68400196,1.6564516,-0.68400196,-0.68400196,-0.68400196,1.6603886,-0.68400196,-0.68400196,-0.68400196,1.6603459,-0.68400196,-0.68400196,-0.68400196,1.6472332,-0.68400196,-0.68400196,-0.68400196,1.6569317,-0.68400196,-0.68400196,-0.68400196,1.6482575,-0.68400196,-0.68400196,-0.68400196,1.6588842,-0.68400196,-0.68400196,-0.68400196,1.6616049,-0.68400196,-0.68400196,-0.68400196,1.6609754,-0.68400196,-0.68400196,-0.68400196,1.6636108,-0.68400196,-0.68400196,-0.68400196,1.6472973,-0.68400196,-0.68400196,-0.68400196,1.6630026,-0.68400196,-0.68400196,-0.68400196,1.6626825,-0.68400196,-0.68400196,-0.68400196,1.6488443,-0.68400196,-0.68400196,-0.68400196,1.6594604,-0.68400196,-0.68400196,-0.68400196,1.6613169,-0.68400196,-0.68400196,-0.68400196,1.6575292,-0.68400196,-0.68400196,-0.68400196,1.6192153,-0.68400196,-0.68400196,-0.68400196,1.6300341,-0.68400196,-0.68400196,-0.68400196,1.6613595,-0.68400196,-0.68400196,-0.68400196,1.660506,-0.68400196,-0.68400196,-0.68400196,1.6604313,-0.68400196,-0.68400196,-0.68400196,1.6606233,-0.68400196,-0.68400196,-0.68400196,1.6620424,-0.68400196,-0.68400196,-0.68400196,1.6572305,-0.68400196,-0.68400196,-0.68400196,1.6497192,-0.68400196,-0.68400196,-0.68400196,1.664603,-0.68400196,-0.68400196,-0.68400196,1.6602926,-0.68400196,-0.68400196,-0.68400196,1.6606874,-0.68400196,-0.68400196,-0.68400196,1.6627786,-0.68400196,0.31667181,0.4602608,1.6544671,-0.6770455,0.32329752,0.40503591,1.659215,-0.67722688,0.30121183,0.40834343,1.6321787,-0.67720554,0.31667181,0.4171777,1.6497192,-0.6771842,0.32329752,0.40171772,1.6597911,-0.67723755,0.32108895,0.39288345,1.65786,-0.67726956,0.31888038,0.38625774,1.6553953,-0.6772909,0.29458612,0.37631384,1.6276762,-0.67732291,0.31778143,0.37521489,1.6568997,-0.67733358,0.32108895,0.37300633,1.6603353,-0.67734424,0.32108895,0.36857852,1.6600685,-0.67736558,0.31556219,0.36195281,1.6550326,-0.67738692,0.31888038,0.35311854,1.6603033,-0.67741893,0.31667181,0.34207569,1.657796,-0.67745094,0.31556219,0.34539388,1.6567183,-0.67744027,0.31004611,0.33765855,1.6512023,-0.67747228,0.29568507,0.32771466,1.6344193,-0.67750429,0.29237756,0.32329752,1.6309197,-0.67751496,0.31004611,0.31446325,1.6528453,-0.67754696,0.31335363,0.31004611,1.6564729,-0.6775683,0.31225468,0.3034204,1.6569744,-0.67758964,0.30783754,0.30121183,1.6519918,-0.67760031,0.30783754,0.29347651,1.6533041,-0.67763232,0.30451935,0.28353261,1.6511276,-0.67766433,0.30010221,0.28243366,1.6446939,-0.67766433,0.30562897,0.2702812,1.6528453,-0.67770701,0.30562897,0.27248977,1.6515757,-0.67769634,0.30451935,0.2603373,1.6517251,-0.67773901,0.29458612,0.24819551,1.6409489,-0.67778169,0.30451935,0.24377837,1.6537736,-0.67779236,0.30893649,0.24598694,1.6580734,-0.67779236,0.30783754,0.24046018,1.6580093,-0.67780303,0.29568507,0.23162591,1.6447793,-0.67784571,0.30783754,0.22830772,1.6587455,-0.67784571,0.3034204,0.22389058,1.6542217,-0.67786705,0.30672792,0.22279163,1.6581267,-0.67786705,-0.68400196,-0.68400196,1.6449286,-0.68400196,-0.68400196,-0.68400196,1.6601539,-0.68400196,-0.68400196,-0.68400196,1.6601539,-0.68400196,-0.68400196,-0.68400196,1.6633654,-0.68400196,-0.68400196,-0.68400196,1.6620104,-0.68400196,-0.68400196,-0.68400196,1.6654993,-0.68400196,-0.68400196,-0.68400196,1.6645817,-0.68400196,-0.68400196,-0.68400196,1.6498899,-0.68400196,-0.68400196,-0.68400196,1.6322,-0.68400196,-0.68400196,-0.68400196,1.6638775,-0.68400196,-0.68400196,-0.68400196,1.6608047,-0.68400196,-0.68400196,-0.68400196,1.6630987,-0.68400196,-0.68400196,-0.68400196,1.6602072,-0.68400196,-0.68400196,-0.68400196,1.6601966,-0.68400196,-0.68400196,-0.68400196,1.6582334,-0.68400196,-0.68400196,-0.68400196,1.6654246,-0.68400196,-0.68400196,-0.68400196,1.665702,-0.68400196,-0.68400196,-0.68400196,1.6628959,-0.68400196,-0.68400196,-0.68400196,1.6478947,-0.68400196,-0.68400196,-0.68400196,1.6596098,-0.68400196,-0.68400196,-0.68400196,1.6609434,-0.68400196,-0.68400196,-0.68400196,1.6352195,-0.68400196,-0.68400196,-0.68400196,1.6598658,-0.68400196,-0.68400196,-0.68400196,1.6603673,-0.68400196,-0.68400196,-0.68400196,1.6575719,-0.68400196,-0.68400196,-0.68400196,1.6604846,-0.68400196,-0.68400196,-0.68400196,1.6599085,-0.68400196,-0.68400196,-0.68400196,1.6594604,-0.68400196,-0.68400196,-0.68400196,1.6587669,-0.68400196,-0.68400196,-0.68400196,1.6586175,-0.68400196,-0.68400196,-0.68400196,1.6456648,-0.68400196,-0.68400196,-0.68400196,1.6531228,-0.68400196,-0.68400196,-0.68400196,1.6603993,-0.68400196,-0.68400196,-0.68400196,1.6553633,-0.68400196,-0.68400196,-0.68400196,1.6563876,-0.68400196,-0.68400196,-0.68400196,1.6535709,-0.68400196,-0.68400196,-0.68400196,1.651661,-0.68400196,-0.68400196,-0.68400196,1.6370226,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196,-0.68400196,-0.68400196,1.6491324,-0.68400196:0
-0.88049202,-0.88049202,1.609209,-0.88049202,-0.88049202,-0.88049202,1.6158578,-0.88049202,-0.88049202,-0.88049202,1.6018362,-0.88049202,-0.88049202,-0.88049202,1.6087189,-0.88049202,-0.88049202,-0.88049202,1.6065361,-0.88049202,-0.88049202,-0.88049202,1.6042641,-0.88049202,-0.88049202,-0.88049202,1.5996422,-0.88049202,-0.88049202,-0.88049202,1.6047987,-0.88049202,-0.88049202,-0.88049202,1.6076943,-0.88049202,-0.88049202,-0.88049202,1.6108461,-0.88049202,-0.88049202,-0.88049202,1.6007559,-0.88049202,-0.88049202,-0.88049202,1.6032172,-0.88049202,-0.88049202,-0.88049202,1.6072377,-0.88049202,-0.88049202,-0.88049202,1.6121603,-0.88049202,-0.88049202,-0.88049202,1.6112248,-0.88049202,-0.88049202,-0.88049202,1.6051439,-0.88049202,-0.88049202,-0.88049202,1.6052107,-0.88049202,-0.88049202,-0.88049202,1.6045537,-0.88049202,-0.88049202,-0.88049202,1.6087523,-0.88049202,-0.88049202,-0.88049202,1.6059792,-0.88049202,-0.88049202,-0.88049202,1.6088303,-0.88049202,-0.88049202,-0.88049202,1.6098438,-0.88049202,-0.88049202,-0.88049202,1.6107236,-0.88049202,-0.88049202,-0.88049202,1.6043866,-0.88049202,-0.88049202,-0.88049202,1.6093538,-0.88049202,-0.88049202,-0.88049202,1.6092312,-0.88049202,-0.88049202,-0.88049202,1.5335546,-0.88049202,-0.88049202,-0.88049202,1.5267944,-0.88049202,-0.88049202,-0.88049202,1.6056785,-0.88049202,-0.88049202,-0.88049202,1.6003661,-0.88049202,-0.88049202,-0.88049202,1.6107682,-0.88049202,-0.88049202,-0.88049202,1.5984951,-0.88049202,-0.88049202,-0.88049202,1.6079727,-0.88049202,-0.88049202,-0.88049202,1.5990853,-0.88049202,-0.88049202,-0.88049202,1.5995865,-0.88049202,-0.88049202,-0.88049202,1.5937729,-0.88049202,-0.88049202,-0.88049202,1.6079505,-0.88049202,-0.88049202,-0.88049202,1.6059012,-0.88049202,-0.88049202,-0.88049202,1.6091199,-0.88049202,-0.88049202,-0.88049202,1.602304,-0.88049202,-0.88049202,-0.88049202,1.6086632,-0.88049202,-0.88049202,-0.88049202,1.6077611,-0.88049202,-0.88049202,-0.88049202,1.6007448,-0.88049202,-0.88049202,-0.88049202,1.6065249,-0.88049202,-0.88049202,-0.88049202,1.6023819,-0.88049202,-0.88049202,-0.88049202,1.6100108,-0.88049202,-0.88049202,-0.88049202,1.60726,-0.88049202,-0.88049202,-0.88049202,1.6024822,-0.88049202,-0.88049202,-0.88049202,1.6080062,-0.88049202,-0.88049202,-0.88049202,1.6027494,-0.88049202,-0.88049202,-0.88049202,1.6018362,-0.88049202,-0.88049202,-0.88049202,1.6078948,-0.88049202,-0.88049202,-0.88049202,1.6051996,-0.88049202,-0.88049202,-0.88049202,1.6081844,-0.88049202,-0.88049202,-0.88049202,1.604175,-0.88049202,-0.88049202,-0.88049202,1.6112248,-0.88049202,-0.88049202,-0.88049202,1.6120935,-0.88049202,-0.88049202,-0.88049202,1.6107793,-0.88049202,-0.88049202,-0.88049202,1.6113584,-0.88049202,-0.88049202,-0.88049202,1.6076609,-0.88049202,-0.88049202,-0.88049202,1.6096545,-0.88049202,-0.88049202,-0.88049202,1.6076832,-0.88049202,-0.88049202,-0.88049202,1.6115923,-0.88049202,-0.88049202,-0.88049202,1.6079059,-0.88049202,-0.88049202,-0.88049202,1.6074939,-0.88049202,-0.88049202,-0.88049202,1.6112471,-0.88049202,-0.88049202,-0.88049202,1.6158578,-0.88049202,-0.88049202,-0.88049202,1.6135413,-0.88049202,-0.88049202,-0.88049202,1.608964,-0.88049202,-0.88049202,-0.88049202,1.6099552,-0.88049202,-0.88049202,-0.88049202,1.6143432,-0.88049202,-0.88049202,-0.88049202,1.6186866,-0.88049202,-0.88049202,-0.88049202,1.6196667,-0.88049202,-0.88049202,-0.88049202,1.6189985,-0.88049202,-0.88049202,-0.88049202,1.6205465,-0.88049202,-0.88049202,-0.88049202,1.6204797,-0.88049202,-0.88049202,-0.88049202,1.6198672,-0.88049202,-0.88049202,-0.88049202,1.6188983,-0.88049202,-0.88049202,-0.88049202,1.6187201,-0.88049202,-0.88049202,-0.88049202,1.6191878,-0.88049202,-0.88049202,-0.88049202,1.616927,-0.88049202,-0.88049202,-0.88049202,1.6147218,-0.88049202,-0.88049202,-0.88049202,1.6098995,-0.88049202,-0.88049202,-0.88049202,1.6120267,-0.88049202,-0.88049202,-0.88049202,1.6160472,-0.88049202,-0.88049202,-0.88049202,1.6194662,-0.88049202,-0.88049202,-0.88049202,1.6151673,-0.88049202,-0.88049202,-0.88049202,1.579161,-0.88049202,-0.88049202,-0.88049202,1.6068924,-0.88049202,-0.88049202,-0.88049202,1.6082846,-0.88049202,-0.88049202,-0.88049202,1.6016914,-0.88049202,-0.88049202,-0.88049202,1.603039,-0.88049202,-0.88049202,-0.88049202,1.6017694,-0.88049202,-0.88049202,-0.88049202,1.6036293,-0.88049202,-0.88049202,-0.88049202,1.6109018,-0.88049202,-0.88049202,-0.88049202,1.6079727,-0.88049202,-0.88049202,-0.88049202,1.6113807,-0.88049202,-0.88049202,-0.88049202,1.6068145,-0.88049202,-0.88049202,-0.88049202,1.6064581,-0.88049202,-0.88049202,-0.88049202,1.6069593,-0.88049202,-0.88049202,-0.88049202,1.6052998,-0.88049202,-0.88049202,-0.88049202,1.6047207,-0.88049202,-0.88049202,-0.88049202,1.6031058,-0.88049202,-0.88049202,-0.88049202,1.6065695,-0.88049202,-0.88049202,-0.88049202,1.6069147,-0.88049202,-0.88049202,-0.88049202,1.6065138,-0.88049202,-0.88049202,-0.88049202,1.6046539,-0.88049202,-0.88049202,-0.88049202,1.6042195,-0.88049202,-0.88049202,-0.88049202,1.6024042,-0.88049202,-0.88049202,-0.88049202,1.6009341,-0.88049202,-0.88049202,-0.88049202,1.6029499,-0.88049202,-0.88049202,-0.88049202,1.6005443,-0.88049202,-0.88049202,-0.88049202,1.5992747,-0.88049202,-0.88049202,-0.88049202,1.5916792,-0.88049202,-0.88049202,-0.88049202,1.5981387,-0.88049202,-0.88049202,-0.88049202,1.5903093,-0.88049202,-0.88049202,-0.88049202,1.5889283,-0.88049202,-0.88049202,-0.88049202,1.5970918,-0.88049202,-0.88049202,-0.88049202,1.5945414,-0.88049202,-0.88049202,-0.88049202,1.5922249,-0.88049202,-0.88049202,-0.88049202,1.5927038,-0.88049202,-0.88049202,-0.88049202,1.5922806,-0.88049202,-0.88049202,-0.88049202,1.5839055,-0.88049202,-0.88049202,-0.88049202,1.5778135,-0.88049202,-0.88049202,-0.88049202,1.5911,-0.88049202,-0.88049202,-0.88049202,1.5949869,-0.88049202,-0.88049202,-0.88049202,1.5917905,-0.88049202,-0.88049202,-0.88049202,1.5866006,-0.88049202,-0.88049202,-0.88049202,1.5171051,-0.88049202,-0.88049202,-0.88049202,1.5830479,-0.88049202,-0.88049202,-0.88049202,1.5937061,-0.88049202,-0.88049202,-0.88049202,1.5936727,-0.88049202,-0.88049202,-0.88049202,1.5968134,-0.88049202,-0.88049202,-0.88049202,1.585331,-0.88049202,-0.88049202,-0.88049202,1.5929154,-0.88049202,-0.88049202,-0.88049202,1.5961006,-0.88049202,-0.88049202,-0.88049202,1.5953878,-0.88049202,-0.88049202,-0.88049202,1.589964,-0.88049202,-0.88049202,-0.88049202,1.59678,-0.88049202,-0.88049202,-0.88049202,1.6015021,-0.88049202,-0.88049202,-0.88049202,1.5885608,-0.88049202,-0.88049202,-0.88049202,1.5361495,-0.88049202,-0.88049202,-0.88049202,1.5898415,-0.88049202,-0.88049202,-0.88049202,1.584763,-0.88049202,0.011857796,2.869941,1.5724454,-0.84875126,0.13637069,0.074114242,1.5895854,-0.87419956,0.13406531,0.011857796,1.5864781,-0.87438889,0.13522357,-0.0077435183,1.5870684,-0.87444457,0.13868721,-0.02041755,1.5893181,-0.87447799,0.13868721,-0.034260978,1.5898861,-0.8745114,0.12945454,-0.046935009,1.5795954,-0.87455594,0.14213971,-0.053851155,1.5918462,-0.87456708,0.13637069,-0.055009414,1.5866118,-0.87457822,0.14560335,-0.059620178,1.595644,-0.87457822,0.13637069,-0.066536323,1.5854201,-0.87460049,0.14444509,-0.071147087,1.5935502,-0.87461163,0.13522357,-0.074610728,1.5838609,-0.87462277,0.13752895,-0.073452469,1.5860326,-0.87462277,0.13291818,-0.079221492,1.5817671,-0.87464504,0.13868721,-0.073452469,1.5889283,-0.87462277,0.14099259,-0.078063232,1.5913228,-0.8746339,0.14790873,-0.082673996,1.5977266,-0.8746339,0.12600204,-0.095359165,1.5737261,-0.87468959,0.14329797,-0.095359165,1.5923251,-0.87467845,0.14444509,-0.097664546,1.5927595,-0.87467845,0.13868721,-0.096517424,1.5879705,-0.87467845,0.14329797,-0.10343357,1.5921803,-0.87470073,0.14329797,-0.10227531,1.5926035,-0.87468959,0.13868721,-0.10688607,1.5864113,-0.87471186,0.13522357,-0.10227531,1.5836048,-0.87470073,0.13983433,-0.098822806,1.5888281,-0.87468959,0.14675047,-0.097664546,1.5961674,-0.87467845,0.14444509,-0.1161076,1.5931493,-0.87473414,0.14329797,-0.11149684,1.5923362,-0.874723,0.14444509,-0.10458069,1.59443,-0.87470073,0.13406531,-0.11034971,1.5820456,-0.874723,0.14560335,-0.12303488,1.5938954,-0.87474528,0.13752895,-0.12648739,1.5849412,-0.87476755,0.13983433,-0.12187662,1.5878257,-0.87475641,0.14675047,-0.11726586,1.5958667,-0.87473414,0.14213971,-0.12418201,1.5899306,-0.87475641,0.14099259,-0.12418201,1.5887724,-0.87475641,0.13637069,-0.13340353,1.5842618,-0.87478982,0.14329797,-0.13570891,1.5907214,-0.87478982,0.14329797,-0.13570891,1.5919576,-0.87478982,0.15021412,-0.13917256,1.5989851,-0.87477869,0.14560335,-0.13570891,1.5948087,-0.87477869,0.15021412,-0.13570891,1.5990742,-0.87477869,0.14213971,-0.14378332,1.5895965,-0.87480096,0.15021412,-0.14724696,1.5979382,-0.87480096,0.14675047,-0.15069947,1.5953655,-0.87482324,0.14790873,-0.15300485,1.5953655,-0.87482324,0.14790873,-0.15531023,1.5963233,-0.87482324,0.14444509,-0.15992099,1.589719,-0.87483437,0.14905586,-0.16222637,1.596134,-0.87484551,0.14790873,-0.16453176,1.5944523,-0.87484551,0.1525195,-0.16569002,1.600355,-0.87484551,0.15021412,-0.16569002,1.5977155,-0.87484551,0.14790873,-0.1679954,1.5945971,-0.87485665,0.14560335,-0.16338463,1.593049,-0.87484551,0.15021412,-0.16569002,1.5973702,-0.87485665,0.14675047,-0.1714479,1.59394,-0.87486778,0.14675047,-0.17260616,1.5933163,-0.87487892,0.14675047,-0.17491154,1.5934611,-0.87487892,0.14560335,-0.17721692,1.5917014,-0.87489006,0.14329797,-0.17721692,1.5875918,-0.87487892,0.15136124,-0.17837518,1.597838,-0.87487892,0.15482488,-0.17952231,1.6016357,-0.87487892,0.14905586,-0.18182769,1.5948532,-0.87489006,0.15021412,-0.18298595,1.5964458,-0.87489006,0.1525195,-0.18298595,1.5995976,-0.87489006,0.1525195,-0.18529133,1.5986955,-0.87489006,0.14560335,-0.18759671,1.5918351,-0.87491233,0.15136124,-0.18874383,1.5970472,-0.8749012,0.15021412,-0.18990209,1.5959669,-0.87491233,0.14790873,-0.19104922,1.5940179,-0.87491233,0.14675047,-0.19220748,1.5917348,-0.87492347,0.14560335,-0.19451286,1.5904429,-0.87492347,0.14560335,-0.19565998,1.5914119,-0.87492347,0.14790873,-0.19681824,1.5930267,-0.87492347,0.14905586,-0.19681824,1.5939066,-0.87492347,0.15366662,-0.19681824,1.5990185,-0.87492347,0.15482488,-0.19912362,1.6002659,-0.87492347,0.155972,-0.19912362,1.6014798,-0.87492347,0.15136124,-0.201429,1.5973479,-0.87493461,0.15482488,-0.201429,1.6005443,-0.87493461,0.15943564,-0.201429,1.6056785,-0.87492347,0.15827738,-0.20258726,1.6044089,-0.87492347,0.15827738,-0.20489264,1.6042975,-0.87493461,0.15943564,-0.20603977,1.6047207,-0.87493461,0.15943564,-0.20603977,1.6054335,-0.87493461,0.16058277,-0.20719803,1.6069259,-0.87493461,0.15943564,-0.20834515,1.6054224,-0.87493461,0.15943564,-0.20950341,1.6054001,-0.87494574,0.15482488,-0.21180879,1.5999318,-0.87495688,0.15021412,-0.21295591,1.5955103,-0.87496802,0.15943564,-0.21295591,1.6041973,-0.87494574,0.15482488,-0.21411417,1.6006223,-0.87495688,0.1525195,-0.21526129,1.5978268,-0.87496802,0.155972,-0.21641955,1.6016357,-0.87495688,0.155972,-0.21641955,1.6008895,-0.87496802,0.15482488,-0.21872493,1.5996645,-0.87496802,0.1525195,-0.21872493,1.5977377,-0.87497916,0.14905586,-0.22103032,1.5939845,-0.87497916,0.15482488,-0.22103032,1.5996199,-0.87497916,0.14329797,-0.22448282,1.5875473,-0.87500143,0.15136124,-0.2233357,1.596212,-0.87499029,0.1525195,-0.2233357,1.5967465,-0.87497916,0.15366662,-0.22448282,1.5982278,-0.87499029,0.15943564,-0.22448282,1.6044868,-0.87497916,0.15021412,-0.2267882,1.5949869,-0.87500143,0.15827738,-0.22564108,1.6027049,-0.87497916,0.155972,-0.2267882,1.6011123,-0.87499029,0.15827738,-0.22794646,1.6025044,-0.87499029,0.15366662,-0.23025184,1.5975707,-0.87500143,0.16404641,-0.22794646,1.6096099,-0.87497916,0.16520467,-0.22909358,1.6099217,-0.87497916,0.16288815,-0.23025184,1.607995,-0.87499029,0.15713026,-0.23255723,1.6019364,-0.87500143,0.15943564,-0.23371548,1.6034177,-0.87500143,0.16288815,-0.23255723,1.6073713,-0.87499029,0.15366662,-0.23602087,1.5983057,-0.87501257,0.16288815,-0.23371548,1.6074716,-0.87499029,0.16520467,-0.23371548,1.609944,-0.87499029,0.16635179,-0.23602087,1.6102336,-0.87499029,0.15943564,-0.23832625,1.6033063,-0.87500143,0.155972,-0.23947337,1.5997201,-0.87501257,0.16288815,-0.23832625,1.6069704,-0.87500143,0.16751005,-0.23832625,1.6116257,-0.87500143,0.15943564,-0.24063163,1.601981,-0.87501257,0.155972,-0.24177875,1.5990185,-0.8750237,0.14675047,-0.24408413,1.5868791,-0.87503484,0.16404641,-0.24177875,1.6076052,-0.87501257,0.16404641,-0.24293701,1.607672,-0.87501257,0.155972,-0.24524239,1.5989183,-0.8750237,0.16058277,-0.24408413,1.6039634,-0.8750237,0.15021412,-0.24754778,1.5927038,-0.87504598,0.15943564,-0.24638952,1.6023262,-0.8750237,0.1525195,-0.24754778,1.595399,-0.87503484,0.16288815,-0.24638952,1.6057565,-0.8750237,0.15482488,-0.2486949,1.5983837,-0.87503484,0.15943564,-0.2486949,1.6030724,-0.87503484,0.15713026,-0.2486949,1.5996756,-0.87503484,0.15713026,-0.24985316,1.5998092,-0.87503484,0.14675047,-0.25215854,1.5894963,-0.87505711,0.15136124,-0.25215854,1.5941405,-0.87504598,0.15136124,-0.25215854,1.5938732,-0.87504598,0.15366662,-0.25330566,1.5962676,-0.87504598,0.1525195,-0.25446392,1.5944077,-0.87505711,0.1525195,-0.25215854,1.5943298,-0.87504598,0.14905586,-0.25561104,1.5918239,-0.87505711,0.15366662,-0.25446392,1.5956551,-0.87505711,0.15482488,-0.25561104,1.5967243,-0.87505711,0.15021412,-0.25561104,1.5930936,-0.87505711,0.14329797,-0.25791643,1.5848855,-0.87507939,0.14905586,-0.25791643,1.5901979,-0.87506825,0.14675047,-0.26023294,1.5882267,-0.87507939,0.15021412,-0.25907468,1.5917348,-0.87506825,0.15136124,-0.25907468,1.5934722,-0.87506825,0.155972,-0.25907468,1.5986176,-0.87505711,0.15482488,-0.25907468,1.5965015,-0.87505711,0.155972,-0.26023294,1.5985285,-0.87505711,0.15482488,-0.26023294,1.5974259,-0.87506825,0.15713026,-0.26023294,1.599542,-0.87505711,0.16174103,-0.26023294,1.6037406,-0.87505711,0.155972,-0.26253833,1.5978157,-0.87506825,0.15482488,-0.26253833,1.5970027,-0.87506825,0.12139127,-0.26945447,1.5602168,-0.87513507,0.1525195,-0.26368545,1.5946416,-0.87507939,0.15021412,-0.26484371,1.5927038,-0.87507939,0.15136124,-0.26599083,1.5932384,-0.87507939,0.14905586,-0.26599083,1.5908439,-0.87509053,0.14905586,-0.26714909,1.5911668,-0.87509053,0.15482488,-0.26599083,1.5964236,-0.87507939,0.14905586,-0.26714909,1.5911112,-0.87509053,0.14905586,-0.26829621,1.5914898,-0.87509053,0.14675047,-0.26829621,1.5883714,-0.87509053,0.15021412,-0.26829621,1.5921024,-0.87509053,0.15021412,-0.26829621,1.5922806,-0.87509053,0.15021412,-0.26945447,1.5929711,-0.87509053,0.1525195,-0.26945447,1.5944523,-0.87509053,0.15136124,-0.26829621,1.5936504,-0.87509053,0.15366662,-0.27060159,1.5957331,-0.87509053,0.15136124,-0.27175985,1.5932049,-0.87510166,0.15366662,-0.27175985,1.5951428,-0.87509053,0.14099259,-0.27290698,1.5822683,-0.8751128,0.15482488,-0.27175985,1.596134,-0.87509053,0.13983433,-0.27406524,1.5810098,-0.87512394,0.15021412,-0.27290698,1.5922917,-0.87510166,0.14905586,-0.27290698,1.5906657,-0.87510166,0.14444509,-0.27406524,1.5859101,-0.8751128,0.14675047,-0.27406524,1.5879816,-0.8751128,0.15021412,-0.27406524,1.5915344,-0.87510166,0.15021412,-0.27406524,1.5925813,-0.87510166,0.15021412,-0.27406524,1.5918685,-0.87510166,0.14560335,-0.27637062,1.5866563,-0.8751128,0.14675047,-0.27637062,1.5879371,-0.8751128,0.14790873,-0.27637062,1.5894963,-0.8751128,0.155972,-0.27521236,1.5979382,-0.87510166,0.15366662,-0.27521236,1.5953321,-0.87510166,0.1525195,-0.27521236,1.5951428,-0.87510166,0.15366662,-0.27637062,1.5952096,-0.87510166,0.15827738,-0.27637062,1.6000209,-0.87509053,0.15827738,-0.27637062,1.6008895,-0.87509053,0.16635179,-0.27521236,1.6084182,-0.87507939,0.16288815,-0.27751774,1.604253,-0.87509053,0.16174103,-0.27637062,1.6033508,-0.87509053,0.16174103,-0.27751774,1.6032952,-0.87509053,0.155972,-0.278676,1.5977934,-0.87510166,0.155972,-0.27982312,1.5969025,-0.87510166,0.15482488,-0.27982312,1.5964458,-0.87510166,0.15482488,-0.278676,1.5962788,-0.87510166,0.15136124,-0.27982312,1.591913,-0.8751128,0.15366662,-0.27982312,1.5951094,-0.87510166,0.15136124,-0.27982312,1.5926481,-0.8751128,0.15021412,-0.27175985,1.5916346,-0.87510166,0.15482488,-0.27751774,1.5967354,-0.87510166,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128,0.15366662,-0.27982312,1.5954101,-0.8751128:0
-0.60789785,-0.60789785,1.7258635,-0.60789785,-0.60789785,-0.60789785,1.7264015,-0.60789785,-0.60789785,-0.60789785,1.7241099,-0.60789785,-0.60789785,-0.60789785,1.723801,-0.60789785,-0.60789785,-0.60789785,1.7221171,-0.60789785,-0.60789785,-0.60789785,1.7237611,-0.60789785,-0.60789785,-0.60789785,1.7257638,-0.60789785,-0.60789785,-0.60789785,1.7253753,-0.60789785,-0.60789785,-0.60789785,1.7265011,-0.60789785,-0.60789785,-0.60789785,1.7249468,-0.60789785,-0.60789785,-0.60789785,1.7204034,-0.60789785,-0.60789785,-0.60789785,1.7263318,-0.60789785,-0.60789785,-0.60789785,1.7273182,-0.60789785,-0.60789785,-0.60789785,1.7261823,-0.60789785,-0.60789785,-0.60789785,1.7297792,-0.60789785,-0.60789785,-0.60789785,1.7295899,-0.60789785,-0.60789785,-0.60789785,1.7281053,-0.60789785,-0.60789785,-0.60789785,1.7279558,-0.60789785,-0.60789785,-0.60789785,1.728723,-0.60789785,-0.60789785,-0.60789785,1.7270491,-0.60789785,-0.60789785,-0.60789785,1.7255546,-0.60789785,-0.60789785,-0.60789785,1.7270093,-0.60789785,-0.60789785,-0.60789785,1.7270292,-0.60789785,-0.60789785,-0.60789785,1.724897,-0.60789785,-0.60789785,-0.60789785,1.7230836,-0.60789785,-0.60789785,-0.60789785,1.7255247,-0.60789785,-0.60789785,-0.60789785,1.7253254,-0.60789785,-0.60789785,-0.60789785,1.7262022,-0.60789785,-0.60789785,-0.60789785,1.7245782,-0.60789785,-0.60789785,-0.60789785,1.7227448,-0.60789785,-0.7213542,-0.037517407,1.7228943,-0.6053073,-0.72650542,-0.079803237,1.7235818,-0.60546672,-0.72650542,-0.083928197,1.7236416,-0.60548664,-0.72650542,-0.088053158,1.7217784,-0.60549661,-0.72650542,-0.092178119,1.7220075,-0.60551654,-0.72754164,-0.10042804,1.723263,-0.60554643,-0.72754164,-0.10558922,1.7233128,-0.60556635,-0.7285679,-0.11177666,1.7244785,-0.60559624,-0.7285679,-0.11693785,1.72408,-0.60560621,-0.7285679,-0.11900033,1.7276868,-0.60562614,-0.7285679,-0.12312529,1.7278263,-0.6056361,-0.72960412,-0.12725025,1.7292412,-0.60565603,-0.72960412,-0.12931273,1.7291316,-0.60566599,-0.72960412,-0.13447391,1.7240999,-0.60568592,-0.72960412,-0.13859887,1.7207123,-0.60569588,-0.72960412,-0.14066135,1.7195664,-0.60570585,-0.72960412,-0.14168761,1.7209613,-0.60570585,-0.72960412,-0.14581257,1.7212503,-0.60572577,-0.72960412,-0.14478631,1.7212403,-0.60571581,-0.72960412,-0.14787505,1.7190682,-0.60573574,-0.72960412,-0.14993753,1.7215093,-0.6057457,-0.72960412,-0.15200001,1.7210709,-0.60575566,-0.72960412,-0.15509872,1.7197258,-0.60576563,-0.72960412,-0.15613494,1.7190981,-0.60576563,-0.72960412,-0.1571612,1.7222467,-0.60577559,-0.73063038,-0.15819742,1.7231135,-0.60577559,-0.72960412,-0.15922368,1.7220872,-0.60578555,-0.72960412,-0.1602599,1.7220773,-0.60578555,-0.73063038,-0.16232238,1.7225356,-0.60579552,-0.72960412,-0.16541112,1.7201344,-0.60580548,-0.73063038,-0.16541112,1.7216588,-0.60580548,-0.73063038,-0.16644734,1.7196262,-0.60580548,-0.73063038,-0.16850982,1.7195565,-0.60581545,-0.73063038,-0.16850982,1.720782,-0.60581545,-0.73063038,-0.17159856,1.718052,-0.60582541,-0.73063038,-0.17263478,1.7179125,-0.60583537,-0.73063038,-0.17469726,1.7173047,-0.60583537,-0.73063038,-0.17469726,1.7182612,-0.60583537,-0.60789785,-0.60789785,1.7195864,-0.60789785,-0.60789785,-0.60789785,1.7154514,-0.60789785,-0.60789785,-0.60789785,1.7175139,-0.60789785,-0.60789785,-0.60789785,1.7201144,-0.60789785,-0.60789785,-0.60789785,1.717484,-0.60789785,-0.60789785,-0.60789785,1.7190682,-0.60789785,-0.60789785,-0.60789785,1.7174242,-0.60789785,-0.60789785,-0.60789785,1.7180221,-0.60789785,-0.60789785,-0.60789785,1.7212901,-0.60789785,-0.60789785,-0.60789785,1.7212005,-0.60789785,-0.60789785,-0.60789785,1.7175538,-0.60789785,-0.60789785,-0.60789785,1.7182413,-0.60789785,-0.60789785,-0.60789785,1.7173445,-0.60789785,-0.60789785,-0.60789785,1.7201344,-0.60789785,-0.60789785,-0.60789785,1.7197159,-0.60789785,-0.60789785,-0.60789785,1.7206525,-0.60789785,-0.60789785,-0.60789785,1.7169659,-0.60789785,-0.60789785,-0.60789785,1.7179424,-0.60789785,-0.60789785,-0.60789785,1.7172748,-0.60789785,-0.60789785,-0.60789785,1.7173844,-0.60789785,-0.60789785,-0.60789785,1.7148337,-0.60789785,-0.60789785,-0.60789785,1.7178626,-0.60789785,-0.60789785,-0.60789785,1.7159994,-0.60789785,-0.60789785,-0.60789785,1.7146543,-0.60789785,-0.60789785,-0.60789785,1.7152621,-0.60789785,-0.60789785,-0.60789785,1.7134089,-0.60789785,-0.60789785,-0.60789785,1.7146942,-0.60789785,-0.60789785,-0.60789785,1.7135683,-0.60789785,-0.60789785,-0.60789785,1.7142558,-0.60789785,-0.60789785,-0.60789785,1.7163681,-0.60789785,-0.60789785,-0.60789785,1.720792,-0.60789785,-0.60789785,-0.60789785,1.7205429,-0.60789785,-0.60789785,-0.60789785,1.718849,-0.60789785,-0.60789785,-0.60789785,1.7181914,-0.60789785,-0.60789785,-0.60789785,1.7190583,-0.60789785,-0.60789785,-0.60789785,1.716388,-0.60789785,-0.60789785,-0.60789785,1.7145647,-0.60789785,-0.60789785,-0.60789785,1.7152721,-0.60789785,-0.60789785,-0.60789785,1.7159596,-0.60789785,-0.60789785,-0.60789785,1.7151127,-0.60789785,-0.60789785,-0.60789785,1.7146244,-0.60789785,-0.60789785,-0.60789785,1.7133292,-0.60789785,-0.60789785,-0.60789785,1.714206,-0.60789785,-0.60789785,-0.60789785,1.7128708,-0.60789785,-0.60789785,-0.60789785,1.7131199,-0.60789785,-0.60789785,-0.60789785,1.7121036,-0.60789785,-0.60789785,-0.60789785,1.712542,-0.60789785,-0.60789785,-0.60789785,1.7139868,-0.60789785,-0.60789785,-0.60789785,1.7124025,-0.60789785,-0.60789785,-0.60789785,1.7127812,-0.60789785,-0.60789785,-0.60789785,1.7118446,-0.60789785,-0.60789785,-0.60789785,1.71311,-0.60789785,-0.60789785,-0.60789785,1.7126616,-0.60789785,-0.60789785,-0.60789785,1.7126716,-0.60789785,-0.60789785,-0.60789785,1.7138373,-0.60789785,-0.60789785,-0.60789785,1.7134986,-0.60789785,-0.60789785,-0.60789785,1.7128609,-0.60789785,-0.60789785,-0.60789785,1.7129804,-0.60789785,-0.60789785,-0.60789785,1.7136978,-0.60789785,-0.60789785,-0.60789785,1.7132694,-0.60789785,-0.60789785,-0.60789785,1.7125321,-0.60789785,-0.60789785,-0.60789785,1.7151725,-0.60789785,-0.60789785,-0.60789785,1.7147839,-0.60789785,-0.60789785,-0.60789785,1.7164478,-0.60789785,-0.60789785,-0.60789785,1.71585,-0.60789785,-0.60789785,-0.60789785,1.7164976,-0.60789785,-0.60789785,-0.60789785,1.7172947,-0.60789785,-0.60789785,-0.60789785,1.7165175,-0.60789785,-0.60789785,-0.60789785,1.7203336,-0.60789785,-0.60789785,-0.60789785,1.7197059,-0.60789785,-0.60789785,-0.60789785,1.7197856,-0.60789785,-0.60789785,-0.60789785,1.71859,-0.60789785,-0.60789785,-0.60789785,1.7186398,-0.60789785,-0.60789785,-0.60789785,1.71584,-0.60789785,-0.60789785,-0.60789785,1.717215,-0.60789785,-0.60789785,-0.60789785,1.7180221,-0.60789785,-0.60789785,-0.60789785,1.7155013,-0.60789785,-0.60789785,-0.60789785,1.7154016,-0.60789785,-0.60789785,-0.60789785,1.7141063,-0.60789785,-0.60789785,-0.60789785,1.7175637,-0.60789785,-0.60789785,-0.60789785,1.7123328,-0.60789785,-0.60789785,-0.60789785,1.7123627,-0.60789785,-0.60789785,-0.60789785,1.7112667,-0.60789785,-0.60789785,-0.60789785,1.7129506,-0.60789785,-0.60789785,-0.60789785,1.714186,-0.60789785,-0.60789785,-0.60789785,1.714196,-0.60789785,-0.60789785,-0.60789785,1.7140366,-0.60789785,-0.60789785,-0.60789785,1.7148337,-0.60789785,-0.60789785,-0.60789785,1.7127612,-0.60789785,-0.60789785,-0.60789785,1.7129007,-0.60789785,-0.60789785,-0.60789785,1.7135683,-0.60789785,-0.60789785,-0.60789785,1.7140366,-0.60789785,-0.60789785,-0.60789785,1.7123527,-0.60789785,-0.60789785,-0.60789785,1.7115955,-0.60789785,-0.60789785,-0.60789785,1.712004,-0.60789785,-0.60789785,-0.60789785,1.7123129,-0.60789785,-0.60789785,-0.60789785,1.7147241,-0.60789785,-0.60789785,-0.60789785,1.7138174,-0.60789785,-0.60789785,-0.60789785,1.7135284,-0.60789785,-0.60789785,-0.60789785,1.7138971,-0.60789785,-0.60789785,-0.60789785,1.7138672,-0.60789785,-0.60789785,-0.60789785,1.7106888,-0.60789785,-0.60789785,-0.60789785,1.7098817,-0.60789785,-0.60789785,-0.60789785,1.7139071,-0.60789785,-0.60789785,-0.60789785,1.7143156,-0.60789785,-0.60789785,-0.60789785,1.7142658,-0.60789785,-0.60789785,-0.60789785,1.7180121,-0.60789785,-0.60789785,-0.60789785,1.7156407,-0.60789785,-0.72444294,-0.081865717,1.7146942,-0.60546672,-0.72547916,-0.082901939,1.7146942,-0.60547668,-0.72650542,-0.092178119,1.7131199,-0.60550657,-0.72650542,-0.092178119,1.719945,-0.60551654,-0.72650542,-0.09630308,1.7178228,-0.6055265,-0.72650542,-0.10250048,1.715571,-0.60554643,-0.72650542,-0.1076517,1.7148536,-0.60556635,-0.72650542,-0.11177666,1.7140565,-0.60558628,-0.72754164,-0.11796411,1.714206,-0.60561617,-0.72754164,-0.12208907,1.7145148,-0.60562614,-0.72754164,-0.12621403,1.7145547,-0.60564606,-0.72754164,-0.12931273,1.7136978,-0.60565603,-0.7285679,-0.13343769,1.7134388,-0.60566599,-0.7285679,-0.13550017,1.7119542,-0.60567595,-0.72754164,-0.14066135,1.7105792,-0.60569588,-0.72754164,-0.14066135,1.7107984,-0.60569588,-0.7285679,-0.14272383,1.7134587,-0.60570585,-0.7285679,-0.14478631,1.7159397,-0.60571581,-0.7285679,-0.14891128,1.7153119,-0.60572577,-0.7285679,-0.14787505,1.7148337,-0.60572577,-0.7285679,-0.15200001,1.7149134,-0.6057457,-0.7285679,-0.15200001,1.7151127,-0.60575566,-0.72960412,-0.15509872,1.7167268,-0.60575566,-0.72960412,-0.15613494,1.7180021,-0.60576563,-0.72960412,-0.1571612,1.7172549,-0.60576563,-0.72960412,-0.1602599,1.7173047,-0.60577559,-0.72960412,-0.16128616,1.7171951,-0.60578555,-0.72960412,-0.16232238,1.7168165,-0.60579552,-0.72960412,-0.16334864,1.7161987,-0.60579552,-0.72960412,-0.16541112,1.7153518,-0.60580548,-0.72960412,-0.16541112,1.7179324,-0.60579552,-0.72960412,-0.16850982,1.7188889,-0.60581545,-0.72960412,-0.16850982,1.7180121,-0.60581545,-0.72960412,-0.1705723,1.7138373,-0.60581545,-0.72960412,-0.1705723,1.7151426,-0.60582541,-0.72960412,-0.17263478,1.7138871,-0.60582541,-0.72960412,-0.12415155,1.7181117,-0.60562614,-0.60789785,-0.60789785,1.7186498,-0.60789785,-0.60789785,-0.60789785,1.7190882,-0.60789785,-0.60789785,-0.56458577,1.7200048,-0.60760891,-0.60789785,-0.60789785,1.7220374,-0.60789785,-0.60789785,-0.60789785,1.7214595,-0.60789785,-0.60789785,-0.60789785,1.7211905,-0.60789785,-0.60789785,-0.60789785,1.7237312,-0.60789785,-0.60789785,-0.60789785,1.7198255,-0.60789785,-0.60789785,-0.60789785,1.7179424,-0.60789785,-0.60789785,-0.60789785,1.7196362,-0.60789785,-0.60789785,-0.60789785,1.7171951,-0.60789785,-0.60789785,-0.60789785,1.7207222,-0.60789785,-0.60789785,-0.60789785,1.7186697,-0.60789785,-0.60789785,-0.60789785,1.7195764,-0.60789785,-0.60789785,-0.60789785,1.7209713,-0.60789785,-0.60789785,-0.60789785,1.7197856,-0.60789785,-0.60789785,-0.60789785,1.7172947,-0.60789785,-0.60789785,-0.60789785,1.714475,-0.60789785,-0.60789785,-0.60789785,1.7129207,-0.60789785,-0.60789785,-0.60789785,1.7151326,-0.60789785,-0.60789785,-0.60789785,1.7177331,-0.60789785,-0.60789785,-0.60789785,1.7122431,-0.60789785,-0.60789785,-0.60789785,1.7110475,-0.60789785,-0.60789785,-0.60789785,1.710091,-0.60789785,-0.60789785,-0.60789785,1.7107785,-0.60789785,-0.60789785,-0.60789785,1.7166371,-0.60789785,-0.60789785,-0.60789785,1.7168762,-0.60789785,-0.60789785,-0.60789785,1.7129904,-0.60789785,-0.60789785,-0.60789785,1.712821,-0.60789785,-0.60789785,-0.60789785,1.7132295,-0.60789785,-0.60789785,-0.60789785,1.7133491,-0.60789785,-0.60789785,-0.60789785,1.7136281,-0.60789785,-0.60789785,-0.60789785,1.7137377,-0.60789785,-0.60789785,-0.60789785,1.7150628,-0.60789785,-0.60789785,-0.60789785,1.7145348,-0.60789785,-0.60789785,-0.60789785,1.7163482,-0.60789785,-0.60789785,-0.60789785,1.7133391,-0.60789785,-0.60789785,-0.60789785,1.7138572,-0.60789785,-0.60789785,-0.60789785,1.7152322,-0.60789785,-0.60789785,-0.60789785,1.7145946,-0.60789785,-0.60789785,-0.60789785,1.713379,-0.60789785,-0.60789785,-0.60789785,1.7111969,-0.60789785,-0.60789785,-0.60789785,1.7083174,-0.60789785,-0.60789785,-0.60789785,1.7095729,-0.60789785,-0.60789785,-0.60789785,1.7110973,-0.60789785,-0.60789785,-0.60789785,1.7129007,-0.60789785,-0.60789785,-0.60789785,1.7127712,-0.60789785,-0.60789785,-0.60789785,1.7177132,-0.60789785,-0.60789785,-0.60789785,1.7207421,-0.60789785,-0.60789785,-0.60789785,1.7122531,-0.60789785,-0.60789785,-0.60789785,1.7116453,-0.60789785,-0.60789785,-0.60789785,1.716119,-0.60789785,-0.60789785,-0.60789785,1.7139569,-0.60789785,-0.60789785,-0.60789785,1.712831,-0.60789785,-0.60789785,-0.60789785,1.7135384,-0.60789785,-0.60789785,-0.60789785,1.7140366,-0.60789785,-0.60789785,-0.60789785,1.7124823,-0.60789785,-0.60789785,-0.60789785,1.7131299,-0.60789785,-0.60789785,-0.60789785,1.7101906,-0.60789785,-0.60789785,-0.60789785,1.7113763,-0.60789785,-0.60789785,-0.60789785,1.7099415,-0.60789785,-0.60789785,-0.60789785,1.709254,-0.60789785,-0.60789785,-0.60789785,1.7086064,-0.60789785,-0.60789785,-0.60789785,1.7120538,-0.60789785,-0.60789785,-0.60789785,1.7124723,-0.60789785,-0.60789785,-0.60789785,1.7126217,-0.60789785,-0.60789785,-0.60789785,1.7146344,-0.60789785,-0.60789785,-0.60789785,1.707331,-0.60789785,-0.60789785,-0.60789785,1.7104098,-0.60789785,-0.60789785,-0.60789785,1.7158301,-0.60789785,-0.60789785,-0.60789785,1.7126018,-0.60789785,-0.60789785,-0.60789785,1.7126616,-0.60789785,-0.60789785,-0.60789785,1.7142159,-0.60789785,-0.60789785,-0.60789785,1.7159496,-0.60789785,-0.60789785,-0.60789785,1.7137676,-0.60789785,-0.60789785,-0.60789785,1.7154714,-0.60789785,-0.60789785,-0.60789785,1.7143654,-0.60789785,-0.60789785,-0.60789785,1.7152422,-0.60789785,-0.60789785,-0.60789785,1.7162685,-0.60789785,-0.60789785,-0.60789785,1.7179822,-0.60789785,-0.60789785,-0.60789785,1.7171951,-0.60789785,-0.60789785,-0.60789785,1.7146244,-0.60789785,-0.60789785,-0.60789785,1.7137676,-0.60789785,-0.60789785,-0.60789785,1.7111372,-0.60789785,-0.60789785,-0.60789785,1.714754,-0.60789785,-0.60789785,-0.60789785,1.7138274,-0.60789785,-0.60789785,-0.60789785,1.7171154,-0.60789785,-0.60789785,-0.60789785,1.716657,-0.60789785,-0.60789785,-0.60789785,1.7176036,-0.60789785,-0.60789785,-0.60789785,1.7193472,-0.60789785,-0.60789785,-0.60789785,1.7184804,-0.60789785,-0.60789785,-0.60789785,1.7187893,-0.60789785,-0.60789785,-0.60789785,1.7197956,-0.60789785,-0.60789785,-0.60789785,1.7171154,-0.60789785,-0.60789785,-0.60789785,1.7166371,-0.60789785,-0.60789785,-0.60789785,1.716936,-0.60789785,-0.60789785,-0.60789785,1.7183808,-0.60789785,-0.60789785,-0.60789785,1.7198056,-0.60789785,-0.60789785,-0.60789785,1.7190085,-0.60789785,-0.60789785,-0.60789785,1.7174342,-0.60789785,-0.60789785,-0.60789785,1.7183309,-0.60789785,-0.60789785,-0.60789785,1.7186597,-0.60789785,-0.60789785,-0.60789785,1.7185601,-0.60789785,-0.60789785,-0.60789785,1.7186398,-0.60789785,-0.60789785,-0.60789785,1.7162485,-0.60789785,-0.60789785,-0.60789785,1.7186797,-0.60789785,-0.60789785,-0.60789785,1.7189686,-0.60789785,-0.60789785,-0.60789785,1.7183608,-0.60789785,-0.60789785,-0.60789785,1.719397,-0.60789785,-0.71722924,-0.01173142,1.7179822,-0.6051977,-0.72547916,-0.078776978,1.7180221,-0.60545675,-0.72650542,-0.0870269,1.7161589,-0.60548664,-0.72650542,-0.094240599,1.7120837,-0.60551654,-0.72650542,-0.094240599,1.710081,-0.60551654,-0.72754164,-0.099401782,1.7148835,-0.60553646,-0.72754164,-0.10352674,1.7154913,-0.60554643,-0.72754164,-0.10868793,1.7135982,-0.60557632,-0.72754164,-0.11383914,1.7138274,-0.60558628,-0.72754164,-0.11693785,1.712273,-0.60560621,-0.72754164,-0.12208907,1.7088057,-0.60561617,-0.72650542,-0.12518777,1.7082975,-0.6056361,-0.72754164,-0.13034895,1.7111172,-0.60565603,-0.72754164,-0.13343769,1.708168,-0.60566599,-0.7285679,-0.13550017,1.7140864,-0.60567595,-0.7285679,-0.13756265,1.7140964,-0.60568592,-0.7285679,-0.14066135,1.7159895,-0.60569588,-0.7285679,-0.14375009,1.7174242,-0.60571581,-0.72960412,-0.14478631,1.720513,-0.60572577,-0.72960412,-0.14787505,1.7199251,-0.60572577,-0.72960412,-0.15097376,1.719417,-0.6057457,-0.72960412,-0.15097376,1.7200048,-0.60573574,-0.73063038,-0.15200001,1.7208816,-0.6057457,-0.73063038,-0.15407246,1.7217883,-0.60575566,-0.73063038,-0.15613494,1.7216688,-0.60576563,-0.73063038,-0.1571612,1.723253,-0.60577559,-0.73063038,-0.15819742,1.7194967,-0.60577559,-0.73063038,-0.15922368,1.7233028,-0.60577559,-0.73063038,-0.16232238,1.7206824,-0.60578555,-0.73063038,-0.16232238,1.7185202,-0.60579552,-0.73063038,-0.16438486,1.7219577,-0.60579552,-0.73063038,-0.16541112,1.7239803,-0.60580548,-0.73063038,-0.1674736,1.7219976,-0.60581545,-0.73063038,-0.1674736,1.7232331,-0.60581545,-0.73063038,-0.16953608,1.7251361,-0.60581545,-0.60789785,-0.60789785,1.7235619,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785,-0.60789785,-0.60789785,1.7218581,-0.60789785:0
-0.56262837,-0.59193738,1.7284392,-0.60585134,-0.56262837,-0.59193738,1.7320168,-0.60585134,-0.56262837,-0.59193738,1.7284914,-0.60585134,-0.56262837,-0.59193738,1.7260507,-0.60585134,-0.56262837,-0.59193738,1.7242358,-0.60585134,-0.56262837,-0.59193738,1.7267912,-0.60585134,-0.56262837,-0.59193738,1.7284914,-0.60585134,-0.56262837,-0.59193738,1.7239438,-0.60585134,-0.56262837,-0.59193738,1.7260611,-0.60585134,-0.56262837,-0.59193738,1.7259255,-0.60585134,-0.56262837,-0.59193738,1.721889,-0.60585134,-0.56262837,-0.59193738,1.7266452,-0.60585134,-0.56262837,-0.59193738,1.7277717,-0.60585134,-0.56262837,-0.59193738,1.7297117,-0.60585134,-0.56262837,-0.59193738,1.7266765,-0.60585134,-0.56262837,-0.59193738,1.7280637,-0.60585134,-0.56371312,-0.59193738,1.7240481,-0.60585134,-0.56262837,-0.59193738,1.7296491,-0.60585134,-0.56262837,-0.59193738,1.7211276,-0.60585134,-0.56262837,-0.59193738,1.7257587,-0.60585134,-0.56371312,-0.59193738,1.7166739,-0.60585134,-0.56371312,-0.58542891,1.7118864,-0.60584091,-0.56262837,-0.58542891,1.7218577,-0.60584091,-0.56262837,-0.58542891,1.7290129,-0.60584091,-0.56371312,-0.58542891,1.7213675,-0.60584091,-0.56262837,-0.58542891,1.7284705,-0.60584091,-0.56262837,-0.58542891,1.725404,-0.60584091,-0.56262837,-0.58542891,1.7239751,-0.60584091,-0.56371312,-0.58542891,1.7209503,-0.60584091,-0.56262837,-0.58542891,1.7253206,-0.60584091,-0.56371312,-0.58542891,1.720627,-0.60584091,-0.56262837,-0.58542891,1.7247991,-0.60584091,-0.56262837,-0.58542891,1.7266869,-0.60584091,-0.56262837,-0.58542891,1.7311511,-0.60584091,-0.56262837,-0.58542891,1.72676,-0.60584091,-0.56262837,-0.58542891,1.7272085,-0.60584091,-0.56262837,-0.58542891,1.7249764,-0.60584091,-0.56262837,-0.58542891,1.7304418,-0.60584091,-0.56262837,-0.58542891,1.725477,-0.60584091,-0.56262837,-0.58542891,1.7280742,-0.60584091,-0.56262837,-0.58542891,1.7280324,-0.60584091,-0.56262837,-0.58542891,1.7291589,-0.60584091,-0.56262837,-0.58542891,1.7301498,-0.60584091,-0.56262837,-0.58542891,1.7311407,-0.60584091,-0.56262837,-0.58542891,1.7319647,-0.60584091,-0.56154363,-0.58542891,1.7354379,-0.60584091,-0.56262837,-0.58542891,1.7320585,-0.60584091,-0.56262837,-0.58542891,1.7302019,-0.60584091,-0.56262837,-0.58542891,1.7241211,-0.60584091,-0.56262837,-0.58542891,1.7291068,-0.60584091,-0.56262837,-0.58542891,1.7253102,-0.60584091,-0.56262837,-0.58542891,1.7271563,-0.60584091,-0.56371312,-0.58542891,1.7184783,-0.60584091,-0.56262837,-0.58542891,1.7234118,-0.60584091,-0.56371312,-0.58542891,1.7190311,-0.60584091,-0.56371312,-0.58542891,1.7220455,-0.60584091,-0.56371312,-0.58542891,1.7179151,-0.60584091,-0.56262837,-0.58542891,1.7272397,-0.60584091,-0.56262837,-0.58542891,1.7275214,-0.60584091,-0.56262837,-0.58542891,1.7314014,-0.60584091,-0.56262837,-0.56371312,1.7304105,-0.60578876,-0.56262837,-0.56154363,1.7315266,-0.60577833,-0.56262837,-0.56045888,1.7293154,-0.6057679,-0.56262837,-0.56154363,1.7304418,-0.60577833,-0.56371312,-0.56262837,1.7161315,-0.60577833,-0.56262837,-0.56045888,1.730567,-0.60577833,-0.56262837,-0.56262837,1.7278864,-0.60577833,-0.56262837,-0.55828939,1.7238291,-0.6057679,-0.56262837,-0.56262837,1.7254562,-0.60577833,-0.56262837,-0.56045888,1.7300142,-0.6057679,-0.56262837,-0.56262837,1.7254249,-0.60577833,-0.56262837,-0.56045888,1.7302124,-0.6057679,-0.56262837,-0.56154363,1.7254979,-0.60577833,-0.56262837,-0.56154363,1.7351354,-0.60577833,-0.56262837,-0.56154363,1.7225044,-0.60577833,-0.56262837,-0.56262837,1.7326218,-0.60577833,-0.56262837,-0.55937413,1.7288147,-0.6057679,-0.56262837,-0.56045888,1.7286478,-0.6057679,-0.56371312,-0.56045888,1.7171328,-0.60577833,-0.56262837,-0.56154363,1.7263219,-0.60577833,-0.56262837,-0.55937413,1.7205018,-0.6057679,-0.56262837,-0.56262837,1.7285227,-0.60577833,-0.56262837,-0.56154363,1.7244862,-0.60577833,-0.56262837,-0.56154363,1.7274379,-0.60577833,-0.56262837,-0.56262837,1.7273441,-0.60577833,-0.56262837,-0.55937413,1.7311407,-0.6057679,-0.56262837,-0.55937413,1.7341967,-0.6057679,-0.56262837,-0.56045888,1.7286374,-0.6057679,-0.56262837,-0.56045888,1.73064,-0.60577833,-0.56154363,-0.55937413,1.7348225,-0.6057679,-0.56262837,-0.56045888,1.7345618,-0.60577833,-0.56154363,-0.55937413,1.7394744,-0.6057679,-0.56154363,-0.55828939,1.7406113,-0.6057679,-0.56154363,-0.56154363,1.7393076,-0.60577833,-0.56154363,-0.55828939,1.7414979,-0.6057679,-0.56154363,-0.56154363,1.7410285,-0.60577833,-0.56154363,-0.56154363,1.7443558,-0.60577833,-0.56154363,-0.56045888,1.7406739,-0.6057679,-0.56154363,-0.56262837,1.741258,-0.60577833,-0.56154363,-0.55937413,1.7402046,-0.6057679,-0.56262837,-0.56045888,1.7377117,-0.60577833,-0.56154363,-0.55937413,1.7411954,-0.6057679,-0.56154363,-0.56045888,1.7441576,-0.6057679,-0.56154363,-0.55937413,1.7455344,-0.6057679,-0.56154363,-0.56045888,1.7470677,-0.6057679,-0.56154363,-0.55937413,1.7474744,-0.6057679,-0.56154363,-0.55720464,1.7481003,-0.60575747,-0.56045888,-0.55937413,1.74979,-0.6057679,-0.56045888,-0.55937413,1.7553388,-0.6057679,-0.56045888,-0.55937413,1.7512502,-0.6057679,-0.56045888,-0.56154363,1.750009,-0.6057679,-0.56045888,-0.55937413,1.7501759,-0.6057679,-0.56154363,-0.55828939,1.7470989,-0.6057679,-0.56045888,-0.55937413,1.750082,-0.6057679,-0.56154363,-0.55828939,1.7412476,-0.60575747,-0.56154363,-0.56045888,1.7436048,-0.6057679,-0.56154363,-0.55828939,1.7413727,-0.6057679,-0.56154363,-0.56045888,1.7444601,-0.6057679,-0.56154363,-0.55720464,1.7472971,-0.60575747,-0.56154363,-0.56045888,1.7446896,-0.6057679,-0.56154363,-0.56045888,1.7429894,-0.6057679,-0.56154363,-0.55828939,1.7395579,-0.6057679,-0.56154363,-0.56045888,1.7403193,-0.6057679,-0.56154363,-0.55720464,1.7386609,-0.60575747,-0.56154363,-0.56045888,1.7457847,-0.6057679,-0.56154363,-0.55937413,1.7477769,-0.6057679,-0.56045888,-0.55828939,1.752919,-0.6057679,-0.56154363,-0.55828939,1.7440325,-0.6057679,-0.56154363,-0.55937413,1.7471615,-0.6057679,-0.56154363,-0.55720464,1.7445435,-0.60575747,-0.56045888,-0.56154363,1.7512711,-0.60577833,-0.56154363,-0.55720464,1.7475787,-0.60575747,-0.56045888,-0.55503515,1.7522724,-0.60575747,-0.56045888,-0.55828939,1.7545461,-0.6057679,-0.56045888,-0.55937413,1.7538056,-0.6057679,-0.56154363,-0.56154363,1.7467339,-0.60577833,-0.56154363,-0.55937413,1.7475683,-0.6057679,-0.56154363,-0.55828939,1.7403297,-0.6057679,-0.56154363,-0.55828939,1.7414353,-0.6057679,-0.56154363,-0.56045888,1.7405488,-0.6057679,-0.56154363,-0.56154363,1.7433441,-0.60577833,-0.56154363,-0.56045888,1.7400898,-0.6057679,-0.56154363,-0.55937413,1.7439177,-0.6057679,-0.56045888,-0.55937413,1.750687,-0.6057679,-0.56045888,-0.55937413,1.756288,-0.6057679,-0.56154363,-0.56045888,1.7449086,-0.6057679,-0.56045888,-0.56154363,1.750979,-0.6057679,-0.56154363,-0.55720464,1.7482671,-0.60575747,-0.56154363,-0.5561199,1.7481315,-0.60575747,-0.56154363,-0.55828939,1.7478186,-0.6057679,-0.56154363,-0.55828939,1.748434,-0.60575747,-0.56154363,-0.56154363,1.7448147,-0.60577833,-0.56154363,-0.55937413,1.7418004,-0.6057679,-0.56262837,-0.55937413,1.7327052,-0.6057679,-0.56262837,-0.55937413,1.7285435,-0.6057679,-0.56262837,-0.55937413,1.7282411,-0.6057679,-0.56262837,-0.56045888,1.7343428,-0.60577833,-0.56262837,-0.56045888,1.7319021,-0.60577833,-0.56262837,-0.55720464,1.7323193,-0.6057679,-0.56371312,-0.55720464,1.7239125,-0.6057679,-0.56371312,-0.55828939,1.7195631,-0.60577833,-0.56371312,-0.56045888,1.7183949,-0.6057679,-0.56371312,-0.56262837,1.7183115,-0.60577833,-0.56371312,-0.55937413,1.7170494,-0.6057679,-0.56371312,-0.55937413,1.7145566,-0.6057679,-0.56262837,-0.56045888,1.7219829,-0.6057679,-0.56371312,-0.55937413,1.7186765,-0.6057679,-0.56371312,-0.56045888,1.7130025,-0.60577833,-0.56371312,-0.56045888,1.7205957,-0.60577833,-0.56371312,-0.55937413,1.7219307,-0.6057679,-0.56262837,-0.55828939,1.7238708,-0.6057679,-0.56371312,-0.55828939,1.7196674,-0.6057679,-0.56371312,-0.55937413,1.7220976,-0.6057679,-0.56371312,-0.56154363,1.7204184,-0.60577833,-0.56371312,-0.56154363,1.7206687,-0.60577833,-0.56371312,-0.55720464,1.7154849,-0.6057679,-0.56262837,-0.55720464,1.7266869,-0.60575747,-0.56262837,-0.55828939,1.7224418,-0.6057679,-0.56262837,-0.56045888,1.7285018,-0.6057679,-0.56262837,-0.56045888,1.7209712,-0.6057679,-0.56262837,-0.56154363,1.724434,-0.60577833,-0.56262837,-0.55828939,1.7231928,-0.6057679,-0.56262837,-0.5561199,1.7284392,-0.60575747,-0.56262837,-0.55828939,1.727876,-0.6057679,-0.56262837,-0.56045888,1.7232763,-0.6057679,-0.56262837,-0.56154363,1.7272606,-0.60577833,-0.56262837,-0.56045888,1.7217534,-0.6057679,-0.56262837,-0.55720464,1.7311615,-0.6057679,-0.56262837,-0.5561199,1.7276987,-0.60575747,-0.56262837,-0.5561199,1.7273336,-0.60575747,-0.56262837,-0.55937413,1.724966,-0.6057679,-0.56262837,-0.55937413,1.7281263,-0.6057679,-0.56262837,-0.55937413,1.7243819,-0.6057679,-0.56262837,-0.55720464,1.732653,-0.6057679,-0.56262837,-0.55720464,1.7263323,-0.60575747,-0.56262837,-0.55937413,1.7241628,-0.6057679,-0.56371312,-0.56045888,1.7210442,-0.60577833,-0.56371312,-0.56045888,1.71876,-0.60577833,-0.56371312,-0.56045888,1.7120116,-0.60577833,-0.56371312,-0.55828939,1.7201785,-0.6057679,-0.56262837,-0.55720464,1.7242463,-0.60575747,-0.56262837,-0.55937413,1.734833,-0.6057679,-0.56262837,-0.55937413,1.7269164,-0.6057679,-0.56262837,-0.56045888,1.7263427,-0.6057679,-0.56262837,-0.56154363,1.7279594,-0.60577833,-0.56262837,-0.55828939,1.7270833,-0.6057679,-0.56262837,-0.55828939,1.727271,-0.6057679,-0.56262837,-0.56045888,1.7291485,-0.6057679,-0.56262837,-0.56045888,1.7271354,-0.6057679,-0.56262837,-0.55937413,1.7298056,-0.6057679,-0.56371312,-0.56154363,1.721524,-0.60577833,-0.56262837,-0.55828939,1.7253102,-0.6057679,-0.56262837,-0.55828939,1.725863,-0.6057679,-0.56262837,-0.55828939,1.7284601,-0.6057679,-0.56262837,-0.55503515,1.7282619,-0.60575747,-0.56371312,-0.55937413,1.7226609,-0.6057679,-0.56371312,-0.55828939,1.7195944,-0.6057679,-0.56371312,-0.55720464,1.7214301,-0.6057679,-0.56371312,-0.55720464,1.7168616,-0.6057679,-0.56371312,-0.55720464,1.7156204,-0.6057679,-0.56371312,-0.55828939,1.7151824,-0.6057679,-0.56371312,-0.55937413,1.7135865,-0.6057679,-0.56371312,-0.55937413,1.7201367,-0.6057679,-0.56371312,-0.55937413,1.7210233,-0.6057679,-0.56371312,-0.55828939,1.7180924,-0.6057679,-0.56371312,-0.55828939,1.7178108,-0.6057679,-0.56371312,-0.55937413,1.7213675,-0.6057679,-0.56371312,-0.55828939,1.7190729,-0.6057679,-0.56371312,-0.55720464,1.7236517,-0.6057679,-0.56262837,-0.55937413,1.7236517,-0.6057679,-0.56262837,-0.55828939,1.7279907,-0.6057679,-0.56371312,-0.55828939,1.7212736,-0.6057679,-0.56262837,-0.55828939,1.7223271,-0.6057679,-0.56371312,-0.55720464,1.7249242,-0.6057679,-0.56262837,-0.55937413,1.7259881,-0.6057679,-0.56262837,-0.55828939,1.7252163,-0.6057679,-0.56262837,-0.55937413,1.725331,-0.6057679,-0.56262837,-0.55828939,1.7276152,-0.6057679,-0.56262837,-0.55720464,1.7269268,-0.60575747,-0.56262837,-0.55828939,1.7298369,-0.6057679,-0.56371312,-0.55503515,1.7258838,-0.60575747,-0.56371312,-0.55937413,1.7215135,-0.6057679,-0.56262837,-0.55828939,1.7241315,-0.6057679,-0.56262837,-0.55937413,1.7265305,-0.6057679,-0.56262837,-0.55720464,1.729065,-0.60575747,-0.56371312,-0.55828939,1.7223793,-0.6057679,-0.56262837,-0.55937413,1.7277821,-0.6057679,-0.56371312,-0.55503515,1.7263219,-0.60575747,-0.56371312,-0.55720464,1.7226504,-0.6057679,-0.56262837,-0.55937413,1.7268121,-0.6057679,-0.56262837,-0.55828939,1.727052,-0.6057679,-0.56262837,-0.55720464,1.7289294,-0.60575747,-0.56262837,-0.55720464,1.7322358,-0.6057679,-0.56262837,-0.55937413,1.7310051,-0.6057679,-0.56262837,-0.55720464,1.7345201,-0.6057679,-0.56262837,-0.55937413,1.7317248,-0.6057679,-0.56154363,-0.55937413,1.7419986,-0.6057679,-0.56154363,-0.55828939,1.7414666,-0.6057679,-0.56262837,-0.55720464,1.7379933,-0.6057679,-0.56262837,-0.55720464,1.7326739,-0.6057679,-0.56262837,-0.55937413,1.73767,-0.6057679,-0.56262837,-0.55720464,1.732069,-0.6057679,-0.56262837,-0.55828939,1.7341654,-0.6057679,-0.56262837,-0.56045888,1.7303271,-0.60577833,-0.56262837,-0.55720464,1.7320377,-0.6057679,-0.56262837,-0.55720464,1.7294823,-0.60575747,-0.56262837,-0.55503515,1.7280012,-0.60575747,-0.56262837,-0.55828939,1.7283245,-0.6057679,-0.56262837,-0.55828939,1.7274588,-0.6057679,-0.56262837,-0.55720464,1.7273336,-0.60575747,-0.56262837,-0.55937413,1.7316309,-0.6057679,-0.56262837,-0.55937413,1.7291693,-0.6057679,-0.56262837,-0.55720464,1.7274066,-0.60575747,-0.56262837,-0.55720464,1.7281785,-0.60575747,-0.56262837,-0.55720464,1.7300768,-0.60575747,-0.56262837,-0.55937413,1.7303688,-0.6057679,-0.56262837,-0.55828939,1.7350207,-0.6057679,-0.56262837,-0.55937413,1.7279803,-0.6057679,-0.56262837,-0.55828939,1.7330181,-0.6057679,-0.56371312,-0.55720464,1.7262489,-0.6057679,-0.56262837,-0.55828939,1.728846,-0.6057679,-0.56262837,-0.55937413,1.7263115,-0.6057679,-0.56371312,-0.55720464,1.725404,-0.6057679,-0.56262837,-0.55828939,1.7292945,-0.6057679,-0.56262837,-0.55828939,1.7304627,-0.6057679,-0.56262837,-0.55937413,1.7383584,-0.6057679,-0.56262837,-0.55720464,1.7336544,-0.6057679,-0.56262837,-0.55720464,1.7368669,-0.6057679,-0.56154363,-0.55828939,1.7414666,-0.6057679,-0.56154363,-0.55720464,1.7405592,-0.60575747,-0.56154363,-0.55828939,1.7405592,-0.6057679,-0.56154363,-0.55720464,1.7404549,-0.60575747,-0.56154363,-0.55828939,1.7428538,-0.6057679,-0.56154363,-0.55828939,1.7413206,-0.6057679,-0.56154363,-0.5561199,1.7415396,-0.60575747,-0.56262837,-0.55828939,1.7367417,-0.6057679,-0.56262837,-0.55286566,1.7409555,-0.60575747,-0.56154363,-0.55503515,1.7422072,-0.60575747,-0.56262837,-0.55828939,1.7386504,-0.6057679,-0.56262837,-0.55828939,1.7348643,-0.6057679,-0.56262837,-0.55937413,1.7371068,-0.6057679,-0.56154363,-0.55503515,1.741477,-0.60575747,-0.56262837,-0.55720464,1.7385983,-0.6057679,-0.56154363,-0.55503515,1.739172,-0.60575747,-0.56262837,-0.5561199,1.7398291,-0.60575747,-0.56262837,-0.55828939,1.7369607,-0.6057679,-0.56262837,-0.55720464,1.7409764,-0.6057679,-0.56154363,-0.55828939,1.7397769,-0.6057679,-0.56154363,-0.55828939,1.7440116,-0.6057679,-0.56154363,-0.55720464,1.7425826,-0.60575747,-0.56154363,-0.55720464,1.741185,-0.60575747,-0.56262837,-0.55720464,1.7325905,-0.6057679,-0.56154363,-0.55720464,1.7416126,-0.60575747,-0.56154363,-0.55720464,1.7443767,-0.60575747,-0.56154363,-0.55828939,1.7405905,-0.6057679,-0.56154363,-0.55720464,1.7440533,-0.60575747,-0.56262837,-0.55720464,1.7373884,-0.6057679,-0.56262837,-0.55937413,1.7369607,-0.6057679,-0.56262837,-0.55720464,1.7372945,-0.6057679,-0.56262837,-0.55937413,1.737065,-0.6057679,-0.56262837,-0.55828939,1.7398395,-0.6057679,-0.56262837,-0.55828939,1.7385879,-0.6057679,-0.56262837,-0.55828939,1.7336961,-0.6057679,-0.56154363,-0.55503515,1.7418108,-0.60575747,-0.56262837,-0.55503515,1.7404444,-0.60575747,-0.56154363,-0.55828939,1.7415292,-0.6057679,-0.56262837,-0.55286566,1.7353858,-0.60574704,-0.56154363,-0.55720464,1.74664,-0.60575747,-0.56262837,-0.55720464,1.737962,-0.6057679,-0.56154363,-0.55720464,1.7447104,-0.60575747,-0.56262837,-0.55720464,1.7418108,-0.6057679,-0.56154363,-0.5561199,1.7436048,-0.60575747,-0.56262837,-0.55720464,1.7346348,-0.6057679,-0.56262837,-0.55828939,1.7372945,-0.6057679,-0.56262837,-0.55828939,1.7317352,-0.6057679,-0.56262837,-0.5561199,1.7382437,-0.60575747,-0.56262837,-0.55828939,1.7323401,-0.6057679,-0.56262837,-0.55720464,1.7361576,-0.6057679,-0.56262837,-0.55503515,1.7319647,-0.60575747,-0.56262837,-0.55503515,1.7388799,-0.60575747,-0.56262837,-0.55937413,1.7279281,-0.6057679,-0.56371312,-0.5561199,1.7211693,-0.60575747,-0.56371312,-0.55720464,1.7199699,-0.6057679,-0.56371312,-0.55828939,1.7270729,-0.6057679,-0.56371312,-0.55720464,1.7247261,-0.6057679,-0.56262837,-0.55937413,1.7287,-0.6057679,-0.56371312,-0.5561199,1.7246635,-0.60575747,-0.56371312,-0.55828939,1.7277821,-0.6057679,-0.56371312,-0.55720464,1.7218473,-0.6057679,-0.56262837,-0.55720464,1.7285018,-0.60575747,-0.56371312,-0.55720464,1.7194171,-0.6057679,-0.56371312,-0.55720464,1.7258942,-0.6057679,-0.56371312,-0.55720464,1.7279281,-0.6057679,-0.56371312,-0.55828939,1.7276674,-0.6057679,-0.56371312,-0.55828939,1.7241315,-0.6057679,-0.56262837,-0.55720464,1.7309008,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679,-0.56154363,-0.55720464,1.7397769,-0.6057679:6
-0.6131903,-0.51008941,1.7343845,-0.60720405,-0.6131903,-0.51008941,1.7336374,-0.60721401,-0.6131903,-0.50906348,1.7389264,-0.60721401,-0.61216437,-0.50906348,1.7372332,-0.60721401,-0.6131903,-0.51008941,1.7368646,-0.60721401,-0.6131903,-0.51008941,1.7332291,-0.60721401,-0.6131903,-0.51008941,1.7315059,-0.60721401,-0.61216437,-0.51008941,1.7341155,-0.60721401,-0.6131903,-0.51008941,1.7399125,-0.60721401,-0.6131903,-0.51008941,1.7405201,-0.60721401,-0.6131903,-0.51008941,1.7332091,-0.60722397,-0.6131903,-0.51008941,1.7345638,-0.60721401,-0.6131903,-0.51008941,1.7366953,-0.60721401,-0.6131903,-0.51008941,1.7365758,-0.60722397,-0.6131903,-0.51008941,1.7401914,-0.60721401,-0.61422619,-0.51008941,1.7415261,-0.60723393,-0.6131903,-0.51008941,1.7356196,-0.60721401,-0.6131903,-0.50906348,1.7377511,-0.60721401,-0.6131903,-0.5111253,1.7288066,-0.60721401,-0.61422619,-0.51008941,1.7331892,-0.60722397,-0.6131903,-0.50906348,1.7407891,-0.60722397,-0.6131903,-0.51008941,1.7332888,-0.60722397,-0.6131903,-0.51008941,1.7323924,-0.60721401,-0.6131903,-0.51008941,1.7335179,-0.60721401,-0.6131903,-0.51008941,1.7337669,-0.60721401,-0.6131903,-0.51008941,1.7325219,-0.60721401,-0.6131903,-0.51008941,1.7367053,-0.60721401,-0.6131903,-0.51008941,1.736526,-0.60722397,-0.6131903,-0.51008941,1.7340259,-0.60721401,-0.6131903,-0.51008941,1.7324521,-0.60721401,-0.6131903,-0.51008941,1.7300815,-0.60721401,-0.6131903,-0.51008941,1.7233184,-0.60720405,-0.6131903,-0.51008941,1.7273225,-0.60721401,-0.61216437,-0.51008941,1.73299,-0.60721401,-0.61216437,-0.51008941,1.7293345,-0.60720405,-0.6131903,-0.51008941,1.7312967,-0.60721401,-0.6131903,-0.51008941,1.7304302,-0.60721401,-0.6131903,-0.51008941,1.7219837,-0.60720405,-0.6131903,-0.5111253,1.7190354,-0.60720405,-0.61216437,-0.51008941,1.7225713,-0.60719409,-0.61216437,-0.5111253,1.7195234,-0.60719409,-0.6131903,-0.51008941,1.7353506,-0.60721401,-0.61216437,-0.51008941,1.7347132,-0.60720405,-0.61216437,-0.51008941,1.7307091,-0.60721401,-0.61216437,-0.51008941,1.7320438,-0.60721401,-0.61216437,-0.51008941,1.7300118,-0.60721401,-0.61216437,-0.51008941,1.7303704,-0.60721401,-0.61216437,-0.51008941,1.7305298,-0.60721401,-0.61216437,-0.50906348,1.7291652,-0.60720405,-0.61216437,-0.51008941,1.7330398,-0.60721401,-0.61216437,-0.51008941,1.733,-0.60721401,-0.61216437,-0.50906348,1.7262468,-0.60720405,-0.61216437,-0.51008941,1.7282986,-0.60721401,-0.61216437,-0.51008941,1.7306194,-0.60720405,-0.61216437,-0.51008941,1.7371336,-0.60720405,-0.61216437,-0.51008941,1.7363467,-0.60720405,-0.61216437,-0.51008941,1.7359582,-0.60720405,-0.61216437,-0.51008941,1.7335179,-0.60721401,-0.61216437,-0.51008941,1.7321533,-0.60720405,-0.61216437,-0.51008941,1.732741,-0.60720405,-0.61216437,-0.51008941,1.7334781,-0.60722397,-0.61216437,-0.51008941,1.737522,-0.60721401,-0.61112848,-0.51008941,1.7376615,-0.60721401,-0.61216437,-0.51008941,1.7379503,-0.60721401,-0.61216437,-0.51008941,1.7326513,-0.60721401,-0.61216437,-0.51008941,1.7301712,-0.60720405,-0.61216437,-0.51008941,1.7267946,-0.60721401,-0.61216437,-0.51008941,1.7307688,-0.60721401,-0.61216437,-0.51008941,1.733,-0.60721401,-0.61216437,-0.51008941,1.7316055,-0.60721401,-0.61216437,-0.51008941,1.7284281,-0.60721401,-0.61216437,-0.51008941,1.7291453,-0.60721401,-0.61216437,-0.51008941,1.7284879,-0.60721401,-0.6131903,-0.51008941,1.7285974,-0.60721401,-0.61216437,-0.51008941,1.7325816,-0.60721401,-0.61216437,-0.51008941,1.7298525,-0.60720405,-0.6131903,-0.51008941,1.7310079,-0.60721401,-0.6131903,-0.51008941,1.7353805,-0.60721401,-0.61216437,-0.51008941,1.7292449,-0.60721401,-0.61216437,-0.51008941,1.7317848,-0.60721401,-0.6131903,-0.5111253,1.7300815,-0.60721401,-0.61216437,-0.51008941,1.7352909,-0.60721401,-0.61216437,-0.51008941,1.7364463,-0.60721401,-0.61216437,-0.51008941,1.7315756,-0.60721401,-0.61216437,-0.51008941,1.7308585,-0.60721401,-0.61216437,-0.51008941,1.7318545,-0.60721401,-0.61216437,-0.51008941,1.7289859,-0.60720405,-0.61216437,-0.51008941,1.7295536,-0.60721401,-0.6131903,-0.51008941,1.7350219,-0.60720405,-0.61216437,-0.51008941,1.7343944,-0.60720405,-0.61216437,-0.5111253,1.7323326,-0.60721401,-0.61216437,-0.51008941,1.7319442,-0.60720405,-0.6131903,-0.51008941,1.7352809,-0.60721401,-0.61216437,-0.51008941,1.7349821,-0.60721401,-0.61216437,-0.51008941,1.7383089,-0.60720405,-0.61216437,-0.51008941,1.736775,-0.60721401,-0.61216437,-0.51008941,1.7329103,-0.60722397,-0.61216437,-0.51008941,1.7371435,-0.60721401,-0.61216437,-0.51008941,1.735759,-0.60721401,-0.61216437,-0.51008941,1.7321832,-0.60721401,-0.61216437,-0.50906348,1.7374623,-0.60720405,-0.6131903,-0.51008941,1.7384782,-0.60721401,-0.6131903,-0.51008941,1.7376914,-0.60722397,-0.6131903,-0.51008941,1.7378507,-0.60721401,-0.6131903,-0.51008941,1.7351614,-0.60721401,-0.6131903,-0.51008941,1.7369144,-0.60721401,-0.61216437,-0.51008941,1.7371734,-0.60721401,-0.6131903,-0.51008941,1.7378806,-0.60721401,-0.6131903,-0.51008941,1.7315657,-0.60721401,-0.6131903,-0.51008941,1.729215,-0.60722397,-0.6131903,-0.51008941,1.7303405,-0.60721401,-0.6131903,-0.51008941,1.7282189,-0.60721401,-0.6131903,-0.51008941,1.7278803,-0.60721401,-0.6131903,-0.51008941,1.7263862,-0.60721401,-0.6131903,-0.51008941,1.7373826,-0.60721401,-0.6131903,-0.51008941,1.7349024,-0.60721401,-0.6131903,-0.51008941,1.7373627,-0.60722397,-0.6131903,-0.50906348,1.7309083,-0.60722397,-0.61422619,-0.51008941,1.731217,-0.60722397,-0.61422619,-0.51008941,1.7333087,-0.60723393,-0.61422619,-0.51008941,1.7396237,-0.60723393,-0.61422619,-0.51008941,1.7356793,-0.60723393,-0.61422619,-0.51008941,1.7369642,-0.60723393,-0.61422619,-0.51008941,1.7294042,-0.60722397,-0.6131903,-0.51008941,1.7330298,-0.60722397,-0.61422619,-0.51008941,1.7343247,-0.60722397,-0.61422619,-0.51008941,1.7336374,-0.60721401,-0.6131903,-0.51008941,1.7374224,-0.60721401,-0.61422619,-0.51008941,1.7380599,-0.60722397,-0.6131903,-0.51008941,1.7402412,-0.60722397,-0.6131903,-0.51008941,1.7366654,-0.60721401,-0.6131903,-0.51008941,1.7346733,-0.60722397,-0.6131903,-0.51008941,1.7302509,-0.60722397,-0.61422619,-0.51008941,1.730211,-0.60722397,-0.61422619,-0.51008941,1.7295238,-0.60722397,-0.61422619,-0.50906348,1.7331095,-0.60722397,-0.61422619,-0.50906348,1.7317649,-0.60721401,-0.61422619,-0.51008941,1.7301911,-0.60720405,-0.61422619,-0.50906348,1.732492,-0.60722397,-0.61422619,-0.51008941,1.7298325,-0.60722397,-0.6131903,-0.51008941,1.7315358,-0.60720405,-0.6131903,-0.50906348,1.73299,-0.60722397,-0.6131903,-0.50906348,1.7356694,-0.60722397,-0.6131903,-0.51008941,1.7321035,-0.60722397,-0.6131903,-0.50906348,1.7323027,-0.60722397,-0.61422619,-0.50906348,1.7269141,-0.60722397,-0.6131903,-0.51008941,1.7270635,-0.60722397,-0.6131903,-0.51008941,1.7264061,-0.60722397,-0.6131903,-0.51008941,1.7279102,-0.60722397,-0.61422619,-0.51008941,1.7197525,-0.60722397,-0.6131903,-0.51008941,1.7253304,-0.60722397,-0.6131903,-0.51008941,1.7264659,-0.60722397,-0.6131903,-0.51008941,1.723667,-0.60722397,-0.6131903,-0.51008941,1.7248324,-0.60722397,-0.61216437,-0.51008941,1.7252806,-0.60720405,-0.6131903,-0.51008941,1.7270038,-0.60722397,-0.61216437,-0.51008941,1.7298823,-0.60720405,-0.6131903,-0.51008941,1.7308983,-0.60722397,-0.6131903,-0.51008941,1.7287966,-0.60722397,-0.6131903,-0.51008941,1.7346036,-0.60722397,-0.6131903,-0.51008941,1.7293445,-0.60722397,-0.6131903,-0.51008941,1.7289261,-0.60722397,-0.6131903,-0.51008941,1.7272129,-0.60720405,-0.61422619,-0.51008941,1.7323525,-0.60722397,-0.6131903,-0.51008941,1.7327111,-0.60720405,-0.61422619,-0.50906348,1.7340857,-0.60720405,-0.61422619,-0.50906348,1.7319342,-0.60722397,-0.61422619,-0.51008941,1.7300019,-0.60722397,-0.61422619,-0.50906348,1.7320836,-0.60722397,-0.6131903,-0.50906348,1.7305895,-0.60722397,-0.61422619,-0.50906348,1.7294042,-0.60722397,-0.61422619,-0.50906348,1.7375121,-0.60723393,-0.6131903,-0.51008941,1.7322828,-0.60722397,-0.6131903,-0.50906348,1.7348925,-0.60722397,-0.6131903,-0.50906348,1.7361375,-0.60722397,-0.61422619,-0.50906348,1.7358188,-0.60722397,-0.61422619,-0.50906348,1.7377412,-0.60723393,-0.61422619,-0.50906348,1.7409584,-0.60723393,-0.61422619,-0.50906348,1.7363168,-0.60723393,-0.61422619,-0.50906348,1.736516,-0.60723393,-0.61422619,-0.51008941,1.7305796,-0.60723393,-0.61422619,-0.51008941,1.7340757,-0.60723393,-0.61422619,-0.51008941,1.7309979,-0.60723393,-0.61422619,-0.51008941,1.7313067,-0.60723393,-0.61422619,-0.51008941,1.732482,-0.60722397,-0.61422619,-0.51008941,1.7334681,-0.60723393,-0.61422619,-0.50906348,1.7349522,-0.60723393,-0.61422619,-0.51008941,1.7354403,-0.60724389,-0.61422619,-0.51008941,1.7306194,-0.60723393,-0.61422619,-0.50906348,1.7299819,-0.60723393,-0.61422619,-0.51008941,1.7318047,-0.60723393,-0.61422619,-0.51008941,1.7323625,-0.60723393,-0.61422619,-0.51008941,1.7337669,-0.60723393,-0.61422619,-0.51008941,1.7325717,-0.60722397,-0.61422619,-0.51008941,1.7359582,-0.60723393,-0.61422619,-0.51008941,1.7323625,-0.60723393,-0.61422619,-0.51008941,1.7349223,-0.60723393,-0.61422619,-0.51008941,1.7348626,-0.60722397,-0.61422619,-0.51008941,1.735759,-0.60723393,-0.61422619,-0.51008941,1.735251,-0.60723393,-0.61422619,-0.51008941,1.732731,-0.60723393,-0.61422619,-0.51008941,1.7302608,-0.60723393,-0.6131903,-0.51008941,1.7285178,-0.60722397,-0.6131903,-0.51008941,1.7357989,-0.60722397,-0.6131903,-0.51008941,1.7324621,-0.60722397,-0.6131903,-0.51008941,1.7359184,-0.60721401,-0.6131903,-0.51008941,1.7299421,-0.60721401,-0.61422619,-0.50906348,1.7296632,-0.60715425,-0.6131903,-0.51008941,1.7320836,-0.60721401,-0.61422619,-0.51008941,1.7316951,-0.60722397,-0.61422619,-0.51008941,1.7287966,-0.60722397,-0.6131903,-0.51008941,1.728209,-0.60722397,-0.6131903,-0.51008941,1.7291851,-0.60722397,-0.6131903,-0.51008941,1.7175811,-0.60722397,-0.61422619,-0.51008941,1.7189358,-0.60722397,-0.61216437,-0.51008941,1.7194836,-0.60720405,-0.6131903,-0.5111253,1.7214857,-0.60722397,-0.6131903,-0.51008941,1.7231092,-0.60721401,-0.61422619,-0.51008941,1.7238961,-0.60722397,-0.61422619,-0.51008941,1.7255296,-0.60722397,-0.6131903,-0.51008941,1.7240455,-0.60722397,-0.6131903,-0.51008941,1.7210175,-0.60722397,-0.61422619,-0.51008941,1.720898,-0.60722397,-0.61422619,-0.51008941,1.7270436,-0.60722397,-0.6131903,-0.51008941,1.7297429,-0.60722397,-0.61422619,-0.51008941,1.7284879,-0.60722397,-0.61422619,-0.50906348,1.7350319,-0.60722397,-0.6131903,-0.51008941,1.7341355,-0.60720405,-0.61422619,-0.51008941,1.7297329,-0.60722397,-0.61422619,-0.51008941,1.7322629,-0.60723393,-0.61422619,-0.51008941,1.7313166,-0.60722397,-0.61422619,-0.51008941,1.7344642,-0.60723393,-0.61422619,-0.51008941,1.7348626,-0.60722397,-0.6131903,-0.51008941,1.7319641,-0.60722397,-0.61422619,-0.51008941,1.7318047,-0.60722397,-0.6131903,-0.51008941,1.7244738,-0.60722397,-0.6131903,-0.51008941,1.7252408,-0.60721401,-0.6131903,-0.51008941,1.7258284,-0.60721401,-0.61216437,-0.51008941,1.728199,-0.60719409,-0.6131903,-0.51008941,1.7267846,-0.60720405,-0.6131903,-0.51008941,1.7285875,-0.60720405,-0.6131903,-0.51008941,1.7259778,-0.60720405,-0.61525212,-0.51008941,1.7240953,-0.60720405,-0.6131903,-0.51008941,1.7275117,-0.60721401,-0.6131903,-0.51008941,1.7293843,-0.60722397,-0.6131903,-0.51008941,1.7281592,-0.60721401,-0.6131903,-0.5111253,1.7121328,-0.60721401,-0.61422619,-0.51008941,1.7176409,-0.60721401,-0.61422619,-0.51008941,1.7186469,-0.60720405,-0.6131903,-0.51008941,1.719623,-0.60720405,-0.61422619,-0.51008941,1.7188262,-0.60721401,-0.61422619,-0.51008941,1.7186967,-0.60721401,-0.61422619,-0.5111253,1.7149018,-0.60722397,-0.61422619,-0.5111253,1.7122025,-0.60723393,-0.61422619,-0.5111253,1.7144237,-0.60722397,-0.61525212,-0.51008941,1.7120033,-0.60722397,-0.61422619,-0.51008941,1.7168142,-0.60720405,-0.61422619,-0.51008941,1.7171827,-0.60721401,-0.61525212,-0.51008941,1.7168142,-0.60723393,-0.6131903,-0.51008941,1.7120033,-0.60720405,-0.61422619,-0.51008941,1.7140253,-0.60722397,-0.61525212,-0.51008941,1.7136468,-0.60720405,-0.61422619,-0.5111253,1.7153699,-0.60722397,-0.6131903,-0.5111253,1.7123718,-0.60722397,-0.61422619,-0.51008941,1.7233084,-0.60722397,-0.6131903,-0.51008941,1.7267747,-0.60721401,-0.6131903,-0.51008941,1.7260675,-0.60722397,-0.6131903,-0.51008941,1.7200414,-0.60721401,-0.6131903,-0.51008941,1.7233283,-0.60720405,-0.6131903,-0.51008941,1.7239658,-0.60720405,-0.6131903,-0.51008941,1.7272428,-0.60720405,-0.6131903,-0.51008941,1.7276811,-0.60722397,-0.6131903,-0.51008941,1.719394,-0.60721401,-0.6131903,-0.51008941,1.7263464,-0.60720405,-0.6131903,-0.51008941,1.7285875,-0.60720405,-0.6131903,-0.51008941,1.726177,-0.60721401,-0.6131903,-0.51008941,1.7268344,-0.60720405,-0.61216437,-0.51008941,1.7268842,-0.60720405,-0.61216437,-0.51008941,1.7269241,-0.60720405,-0.61422619,-0.51008941,1.7259479,-0.60721401,-0.6131903,-0.51008941,1.727442,-0.60720405,-0.61216437,-0.51008941,1.726197,-0.60720405,-0.61525212,-0.51008941,1.7213462,-0.60721401,-0.61216437,-0.51008941,1.7236072,-0.60721401,-0.6131903,-0.51008941,1.7299421,-0.60720405,-0.61216437,-0.51008941,1.7346434,-0.60721401,-0.6131903,-0.51008941,1.7340259,-0.60721401,-0.6131903,-0.5111253,1.7238562,-0.60723393,-0.6131903,-0.51008941,1.7318545,-0.60722397,-0.6131903,-0.51008941,1.7290257,-0.60722397,-0.6131903,-0.50906348,1.7390559,-0.60722397,-0.6131903,-0.50906348,1.7390061,-0.60722397,-0.6131903,-0.50906348,1.7435581,-0.60722397,-0.6131903,-0.51008941,1.7427314,-0.60721401,-0.6131903,-0.51008941,1.7320936,-0.60721401,-0.6131903,-0.51008941,1.7300616,-0.60722397,-0.6131903,-0.51008941,1.7333585,-0.60722397,-0.6131903,-0.51008941,1.7310577,-0.60721401,-0.6131903,-0.51008941,1.7320836,-0.60721401,-0.6131903,-0.51008941,1.7371933,-0.60722397,-0.6131903,-0.51008941,1.7355797,-0.60722397,-0.6131903,-0.51008941,1.7353606,-0.60722397,-0.6131903,-0.51008941,1.7293744,-0.60721401,-0.6131903,-0.51008941,1.7294839,-0.60721401,-0.61422619,-0.51008941,1.7272827,-0.60722397,-0.61422619,-0.51008941,1.7280695,-0.60722397,-0.61422619,-0.51008941,1.7312967,-0.60722397,-0.61422619,-0.51008941,1.7308385,-0.60722397,-0.61422619,-0.51008941,1.7312071,-0.60722397,-0.61422619,-0.51008941,1.7270038,-0.60722397,-0.61422619,-0.51008941,1.7279799,-0.60722397,-0.6131903,-0.51008941,1.7264659,-0.60721401,-0.61525212,-0.51008941,1.7303306,-0.60722397,-0.6131903,-0.51008941,1.7306095,-0.60722397,-0.61422619,-0.51008941,1.7275117,-0.60722397,-0.61422619,-0.51008941,1.7243045,-0.60722397,-0.6131903,-0.51008941,1.7227706,-0.60721401,-0.61422619,-0.51008941,1.7218144,-0.60722397,-0.61422619,-0.5111253,1.7203302,-0.60721401,-0.61525212,-0.51008941,1.719882,-0.60717417,-0.6131903,-0.51008941,1.723926,-0.60721401,-0.6131903,-0.51008941,1.7277707,-0.60722397,-0.61525212,-0.51008941,1.7240256,-0.60722397,-0.61422619,-0.51008941,1.7252009,-0.60722397,-0.61422619,-0.51008941,1.7266153,-0.60723393,-0.61422619,-0.51008941,1.7267149,-0.60722397,-0.61422619,-0.50906348,1.735002,-0.60723393,-0.6131903,-0.51008941,1.7319143,-0.60721401,-0.6131903,-0.51008941,1.7295437,-0.60721401,-0.61422619,-0.51008941,1.7348626,-0.60722397,-0.61422619,-0.51008941,1.7307688,-0.60722397,-0.61422619,-0.51008941,1.7306891,-0.60722397,-0.61422619,-0.51008941,1.7280197,-0.60722397,-0.61422619,-0.51008941,1.7280197,-0.60722397,-0.6131903,-0.51008941,1.7289162,-0.60721401,-0.61422619,-0.51008941,1.7315159,-0.60721401,-0.6131903,-0.51008941,1.734006,-0.60721401,-0.61216437,-0.51008941,1.7301712,-0.60720405,-0.6131903,-0.51008941,1.732482,-0.60722397,-0.6131903,-0.50906348,1.7349024,-0.60721401,-0.6131903,-0.50906348,1.7376117,-0.60721401,-0.6131903,-0.50906348,1.7383487,-0.60722397,-0.61422619,-0.50906348,1.7377611,-0.60722397,-0.61422619,-0.50906348,1.7421636,-0.60722397,-0.61422619,-0.51008941,1.7376117,-0.60722397,-0.6131903,-0.50906348,1.735759,-0.60721401,-0.61422619,-0.50906348,1.73552,-0.60722397,-0.6131903,-0.50906348,1.7317449,-0.60722397,-0.61422619,-0.51008941,1.7337968,-0.60722397,-0.61422619,-0.50906348,1.7358686,-0.60722397,-0.61422619,-0.51008941,1.7327111,-0.60722397,-0.61422619,-0.51008941,1.7378806,-0.60721401,-0.61422619,-0.51008941,1.7272428,-0.60722397,-0.61422619,-0.51008941,1.7298724,-0.60721401,-0.6131903,-0.51008941,1.7278305,-0.60721401,-0.61422619,-0.51008941,1.7274221,-0.60721401,-0.61422619,-0.51008941,1.7294441,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401,-0.61422619,-0.50906348,1.7356395,-0.60721401:6
-0.64347669,-0.56904754,1.7312104,-0.57277818,-0.64347669,-0.56904754,1.7327374,-0.57277818,-0.64347669,-0.56904754,1.7312877,-0.57277818,-0.64347669,-0.56904754,1.7321962,-0.57277818,-0.64347669,-0.56904754,1.7347864,-0.57277818,-0.64347669,-0.56904754,1.7345061,-0.57277818,-0.64347669,-0.56904754,1.7358785,-0.57277818,-0.64347669,-0.56904754,1.7355113,-0.57277818,-0.64347669,-0.56904754,1.7307658,-0.57277818,-0.64347669,-0.56904754,1.7299346,-0.57277818,-0.64347669,-0.56904754,1.7327954,-0.57277818,-0.64347669,-0.56904754,1.729838,-0.57277818,-0.64347669,-0.56904754,1.7306885,-0.57277818,-0.64347669,-0.56904754,1.7315293,-0.57277818,-0.64347669,-0.56904754,1.7294127,-0.57277818,-0.64347669,-0.56904754,1.7316067,-0.57277818,-0.64347669,-0.56904754,1.7321286,-0.57277818,-0.64347669,-0.56904754,1.7247929,-0.57277818,-0.64247154,-0.56904754,1.7221158,-0.57277818,-0.64347669,-0.56904754,1.7248509,-0.57277818,-0.64347669,-0.56904754,1.7306692,-0.57277818,-0.64347669,-0.56904754,1.7321672,-0.57277818,-0.64347669,-0.56904754,1.7305242,-0.57277818,-0.64247154,-0.56904754,1.7159979,-0.57277818,-0.64347669,-0.56904754,1.7312394,-0.57277818,-0.64247154,-0.56904754,1.717032,-0.57277818,-0.64347669,-0.56904754,1.7271705,-0.57277818,-0.64347669,-0.56904754,1.7295384,-0.57277818,-0.64247154,-0.56904754,1.7167421,-0.57277818,-0.64347669,-0.56904754,1.7281563,-0.57277818,-0.64347669,-0.56904754,1.7266389,-0.57277818,-0.64247154,-0.56904754,1.7132821,-0.57277818,-0.64247154,-0.56904754,1.7204631,-0.57277818,-0.64347669,-0.56904754,1.7288328,-0.57277818,-0.64347669,-0.56904754,1.7275667,-0.57277818,-0.64247154,-0.56904754,1.7164715,-0.57277818,-0.64347669,-0.56904754,1.7285429,-0.57277818,-0.64347669,-0.56904754,1.7277117,-0.57277818,-0.64247154,-0.56904754,1.7176892,-0.57277818,-0.64347669,-0.56904754,1.7279243,-0.57277818,-0.64347669,-0.56904754,1.7283206,-0.57277818,-0.64247154,-0.56904754,1.7171673,-0.57277818,-0.64347669,-0.56904754,1.7311331,-0.57277818,-0.64347669,-0.56904754,1.7325441,-0.57277818,-0.64347669,-0.56904754,1.729664,-0.57277818,-0.64247154,-0.56904754,1.7201151,-0.57277818,-0.64347669,-0.56904754,1.72632,-0.57277818,-0.64347669,-0.56904754,1.7316743,-0.57277818,-0.64247154,-0.56904754,1.7192163,-0.57277818,-0.64347669,-0.56904754,1.7281853,-0.57277818,-0.64347669,-0.56904754,1.7316163,-0.57277818,-0.64247154,-0.56904754,1.720869,-0.57277818,-0.64347669,-0.56904754,1.7309011,-0.57277818,-0.64347669,-0.56904754,1.7310461,-0.57277818,-0.64347669,-0.56904754,1.7312201,-0.57277818,-0.64247154,-0.56904754,1.7161429,-0.57277818,-0.64247154,-0.56703725,1.7275957,-0.57277818,-0.64347669,-0.56904754,1.729751,-0.57277818,-0.6414664,-0.5660321,1.720608,-0.57278784,-0.63341556,-0.49661902,1.7299056,-0.5726622,-0.63341556,-0.47952187,1.731278,-0.57260421,-0.63442071,-0.47248584,1.7207917,-0.57257522,-0.63442071,-0.47248584,1.7237201,-0.57257522,-0.63442071,-0.47248584,1.7341678,-0.57257522,-0.63442071,-0.47349099,1.731568,-0.57258488,-0.63542585,-0.47147103,1.7200765,-0.57256555,-0.63442071,-0.47349099,1.7332207,-0.57258488,-0.63442071,-0.47248584,1.7340809,-0.57257522,-0.63542585,-0.47349099,1.7199798,-0.57257522,-0.63442071,-0.47349099,1.733559,-0.57258488,-0.63442071,-0.47449614,1.7206854,-0.57258488,-0.63442071,-0.47349099,1.735289,-0.57258488,-0.63442071,-0.47349099,1.7338682,-0.57258488,-0.63442071,-0.47349099,1.7259527,-0.57257522,-0.63442071,-0.47449614,1.733385,-0.57258488,-0.63442071,-0.47449614,1.73353,-0.57258488,-0.63542585,-0.47449614,1.7227246,-0.57258488,-0.63744581,-0.47550128,1.7234978,-0.57257522,-0.63542585,-0.47449614,1.7325248,-0.57258488,-0.63442071,-0.47550128,1.7336943,-0.57258488,-0.63542585,-0.47550128,1.7232465,-0.57258488,-0.63442071,-0.47449614,1.7343225,-0.57258488,-0.63442071,-0.47449614,1.7245416,-0.57258488,-0.63442071,-0.47550128,1.7359075,-0.57258488,-0.63442071,-0.47449614,1.731423,-0.57258488,-0.63442071,-0.47550128,1.7223091,-0.57258488,-0.63442071,-0.47550128,1.7232175,-0.57258488,-0.63442071,-0.47550128,1.7342838,-0.57258488,-0.63442071,-0.47550128,1.7362265,-0.57258488,-0.63442071,-0.47449614,1.7258174,-0.57258488,-0.63442071,-0.47550128,1.7238361,-0.57258488,-0.63442071,-0.47449614,1.7155436,-0.57258488,-0.63341556,-0.47449614,1.7245126,-0.57258488,-0.63442071,-0.47147103,1.7260783,-0.57257522,-0.63341556,-0.47449614,1.7270642,-0.57258488,-0.63442071,-0.47550128,1.7131274,-0.57258488,-0.63341556,-0.47449614,1.7213716,-0.57258488,-0.63341556,-0.47449614,1.7264553,-0.57258488,-0.63442071,-0.47449614,1.7188104,-0.57258488,-0.63442071,-0.47550128,1.7292968,-0.57258488,-0.63442071,-0.47449614,1.7302342,-0.57258488,-0.63442071,-0.47449614,1.7152247,-0.57258488,-0.63442071,-0.47550128,1.7147898,-0.57258488,-0.63341556,-0.47449614,1.727818,-0.57258488,-0.63341556,-0.47650643,1.7279823,-0.57259455,-0.63442071,-0.47550128,1.7161719,-0.57258488,-0.63341556,-0.47449614,1.7292291,-0.57258488,-0.63442071,-0.47449614,1.72949,-0.57258488,-0.63442071,-0.47550128,1.717003,-0.57258488,-0.63442071,-0.47550128,1.7188297,-0.57258488,-0.63442071,-0.47550128,1.7287265,-0.57258488,-0.63442071,-0.47449614,1.7302342,-0.57258488,-0.63442071,-0.47650643,1.7144998,-0.57258488,-0.63442071,-0.47650643,1.7301956,-0.57259455,-0.63442071,-0.47248584,1.7309011,-0.57257522,-0.63442071,-0.47550128,1.7202794,-0.57258488,-0.63442071,-0.47449614,1.733385,-0.57258488,-0.63442071,-0.47650643,1.7352503,-0.57259455,-0.63542585,-0.47650643,1.7211106,-0.57258488,-0.63542585,-0.47550128,1.7219418,-0.57258488,-0.6414664,-0.47550128,1.7326795,-0.57257522,-0.63442071,-0.47248584,1.7321092,-0.57257522,-0.63442071,-0.47550128,1.7233722,-0.57258488,-0.63341556,-0.47550128,1.7354823,-0.57259455,-0.63442071,-0.47650643,1.7352503,-0.57259455,-0.63442071,-0.47650643,1.7229856,-0.57259455,-0.63644067,-0.47550128,1.7234205,-0.57258488,-0.63341556,-0.47550128,1.7343611,-0.57259455,-0.63442071,-0.47349099,1.7359075,-0.57258488,-0.63644067,-0.47550128,1.7219611,-0.57258488,-0.63442071,-0.47650643,1.7359269,-0.57259455,-0.63442071,-0.47550128,1.7375699,-0.57259455,-0.63542585,-0.47650643,1.7271512,-0.57258488,-0.63442071,-0.47650643,1.738778,-0.57259455,-0.63442071,-0.47650643,1.7362361,-0.57259455,-0.63542585,-0.47650643,1.7306402,-0.57259455,-0.63442071,-0.47550128,1.7269482,-0.57258488,-0.63644067,-0.47550128,1.7333657,-0.57258488,-0.63644067,-0.47550128,1.7346124,-0.57258488,-0.63341556,-0.47550128,1.7226763,-0.57258488,-0.63542585,-0.47650643,1.7318289,-0.57259455,-0.63341556,-0.47550128,1.7336653,-0.57259455,-0.63845096,-0.47550128,1.7183561,-0.57257522,-0.63341556,-0.47550128,1.7220964,-0.57259455,-0.63341556,-0.47550128,1.7305918,-0.57259455,-0.63341556,-0.47550128,1.7330467,-0.57259455,-0.63442071,-0.47650643,1.7203084,-0.57259455,-0.63442071,-0.47650643,1.7307465,-0.57259455,-0.63442071,-0.47449614,1.7324088,-0.57258488,-0.63442071,-0.47650643,1.719197,-0.57259455,-0.63341556,-0.47650643,1.7307948,-0.57259455,-0.63341556,-0.47550128,1.7300796,-0.57259455,-0.63442071,-0.47650643,1.7165391,-0.57258488,-0.63644067,-0.47449614,1.7184818,-0.57257522,-0.63341556,-0.47550128,1.7325635,-0.57259455,-0.63341556,-0.47248584,1.7299636,-0.57258488,-0.63442071,-0.47550128,1.7178149,-0.57258488,-0.63442071,-0.47650643,1.7320802,-0.57259455,-0.63341556,-0.47550128,1.7312007,-0.57259455,-0.63341556,-0.47650643,1.7317323,-0.57259455,-0.63341556,-0.47650643,1.7345931,-0.57259455,-0.63341556,-0.47550128,1.7181435,-0.57258488,-0.63542585,-0.47550128,1.7292001,-0.57258488,-0.63542585,-0.47550128,1.73497,-0.57258488,-0.63442071,-0.47650643,1.7216228,-0.57259455,-0.63442071,-0.47550128,1.7329791,-0.57258488,-0.63442071,-0.47650643,1.7306498,-0.57259455,-0.63442071,-0.47751158,1.7239231,-0.57259455,-0.63341556,-0.47650643,1.7337812,-0.57259455,-0.63442071,-0.47550128,1.733356,-0.57258488,-0.63442071,-0.47550128,1.7334623,-0.57258488,-0.63442071,-0.47650643,1.7223767,-0.57259455,-0.63542585,-0.47650643,1.733356,-0.57259455,-0.63241042,-0.47650643,1.733385,-0.57259455,-0.63542585,-0.47650643,1.7220481,-0.57258488,-0.63442071,-0.47650643,1.7291518,-0.57259455,-0.63442071,-0.47650643,1.7358979,-0.57259455,-0.63442071,-0.47650643,1.722541,-0.57259455,-0.63542585,-0.47650643,1.7333947,-0.57259455,-0.63845096,-0.47751158,1.7295094,-0.57258488,-0.63845096,-0.47650643,1.7307658,-0.57258488,-0.63442071,-0.47650643,1.7223477,-0.57259455,-0.63442071,-0.47751158,1.7316646,-0.57259455,-0.63442071,-0.47751158,1.7318773,-0.57259455,-0.63542585,-0.47650643,1.7225507,-0.57258488,-0.63442071,-0.47650643,1.7331627,-0.57259455,-0.63442071,-0.47650643,1.7328921,-0.57259455,-0.63442071,-0.47550128,1.7186171,-0.57258488,-0.63442071,-0.47650643,1.717177,-0.57258488,-0.63442071,-0.47650643,1.735057,-0.57259455,-0.63442071,-0.47650643,1.7347864,-0.57259455,-0.63542585,-0.47751158,1.7231209,-0.57259455,-0.63442071,-0.47550128,1.7354823,-0.57258488,-0.63442071,-0.47650643,1.7337619,-0.57259455,-0.63341556,-0.47550128,1.7323798,-0.57259455,-0.63341556,-0.47248584,1.7270158,-0.57257522,-0.63241042,-0.47751158,1.73151,-0.57260421,-0.63542585,-0.47650643,1.7327084,-0.57259455,-0.63341556,-0.47751158,1.7213812,-0.57259455,-0.63241042,-0.47550128,1.7331047,-0.57259455,-0.63341556,-0.47751158,1.7342162,-0.57259455,-0.63341556,-0.47650643,1.7223574,-0.57259455,-0.63241042,-0.47650643,1.7311137,-0.57259455,-0.63241042,-0.47650643,1.7310461,-0.57259455,-0.63341556,-0.47751158,1.7339166,-0.57259455,-0.63341556,-0.47550128,1.7345351,-0.57259455,-0.63542585,-0.47650643,1.7338006,-0.57259455,-0.63341556,-0.47650643,1.7348637,-0.57259455,-0.63341556,-0.47349099,1.7354629,-0.57259455,-0.63341556,-0.47751158,1.7336846,-0.57259455,-0.63341556,-0.47650643,1.7349217,-0.57259455,-0.63341556,-0.47650643,1.7358979,-0.57259455,-0.63341556,-0.47650643,1.7342452,-0.57259455,-0.63341556,-0.47550128,1.7354146,-0.57259455,-0.63341556,-0.47550128,1.7351537,-0.57259455,-0.63341556,-0.47751158,1.7371156,-0.57260421,-0.63140527,-0.47650643,1.7346608,-0.57260421,-0.63241042,-0.47751158,1.7340229,-0.57260421,-0.63241042,-0.47751158,1.7333463,-0.57260421,-0.63341556,-0.47751158,1.7358399,-0.57259455,-0.63241042,-0.47751158,1.7351343,-0.57260421,-0.63341556,-0.47650643,1.735376,-0.57259455,-0.63341556,-0.47650643,1.7302536,-0.57259455,-0.63341556,-0.47650643,1.7328341,-0.57259455,-0.63341556,-0.47650643,1.7313167,-0.57259455,-0.63341556,-0.47851672,1.7336459,-0.57260421,-0.63341556,-0.47650643,1.7282046,-0.57259455,-0.63341556,-0.47650643,1.729925,-0.57259455,-0.63341556,-0.47751158,1.7293064,-0.57259455,-0.63341556,-0.47751158,1.7299733,-0.57259455,-0.63644067,-0.47751158,1.7315873,-0.57259455,-0.63241042,-0.47650643,1.7277504,-0.57259455,-0.63241042,-0.47751158,1.7256048,-0.57259455,-0.63542585,-0.47650643,1.7275667,-0.57259455,-0.63241042,-0.47751158,1.7257594,-0.57259455,-0.63241042,-0.47650643,1.7273734,-0.57259455,-0.63241042,-0.47751158,1.7288715,-0.57260421,-0.63341556,-0.47650643,1.7302052,-0.57259455,-0.63341556,-0.47449614,1.7301956,-0.57258488,-0.63341556,-0.47650643,1.7355499,-0.57259455,-0.63341556,-0.47550128,1.7336846,-0.57259455,-0.63341556,-0.47751158,1.7321962,-0.57259455,-0.63341556,-0.47650643,1.7335396,-0.57259455,-0.63341556,-0.47650643,1.7313457,-0.57259455,-0.63442071,-0.47449614,1.7322349,-0.57258488,-0.63442071,-0.47650643,1.7320899,-0.57259455,-0.63442071,-0.47650643,1.7316936,-0.57259455,-0.63341556,-0.47650643,1.729809,-0.57259455,-0.63442071,-0.47550128,1.7306692,-0.57258488,-0.63442071,-0.47650643,1.7318773,-0.57259455,-0.63542585,-0.47550128,1.731452,-0.57258488,-0.63542585,-0.49661902,1.7321865,-0.5726622,-0.63442071,-0.5107104,1.7325925,-0.57271053,-0.63442071,-0.50969559,1.7320416,-0.57270086,-0.63442071,-0.50969559,1.7323025,-0.57270086,-0.63442071,-0.50165442,1.7330177,-0.57268153,-0.63442071,-0.51171554,1.7335976,-0.57271053,-0.63542585,-0.51171554,1.7335686,-0.57271053,-0.64347669,-0.57005269,1.7321865,-0.57277818,-0.64347669,-0.57005269,1.7315487,-0.57277818,-0.64347669,-0.57005269,1.7307851,-0.57277818,-0.64347669,-0.57005269,1.7323025,-0.57277818,-0.64347669,-0.57005269,1.7320706,-0.57277818,-0.64347669,-0.57005269,1.7330177,-0.57277818,-0.64347669,-0.57005269,1.7324572,-0.57277818,-0.64347669,-0.57005269,1.7309204,-0.57277818,-0.64347669,-0.57005269,1.7308625,-0.57277818,-0.64347669,-0.57005269,1.7316743,-0.57277818,-0.64347669,-0.57005269,1.7317033,-0.57277818,-0.64347669,-0.57005269,1.730012,-0.57277818,-0.64347669,-0.57005269,1.7304662,-0.57277818,-0.64347669,-0.56904754,1.7312974,-0.57277818,-0.64347669,-0.57005269,1.7316453,-0.57277818,-0.64347669,-0.57005269,1.7319643,-0.57277818,-0.64347669,-0.57005269,1.7347671,-0.57277818,-0.64347669,-0.56904754,1.7392129,-0.57277818,-0.64347669,-0.57005269,1.7367774,-0.57277818,-0.64347669,-0.57005269,1.7374442,-0.57277818,-0.64347669,-0.56904754,1.7361975,-0.57277818,-0.64347669,-0.57005269,1.7350184,-0.57277818,-0.64347669,-0.57005269,1.7369997,-0.57277818,-0.64347669,-0.57005269,1.7362555,-0.57277818,-0.64347669,-0.57005269,1.7353953,-0.57277818,-0.64347669,-0.57005269,1.7351633,-0.57277818,-0.64347669,-0.56904754,1.7338006,-0.57277818,-0.64347669,-0.57005269,1.735057,-0.57277818,-0.64347669,-0.56904754,1.7353373,-0.57277818,-0.64347669,-0.57005269,1.7343805,-0.57277818,-0.64347669,-0.57005269,1.7345254,-0.57277818,-0.64347669,-0.56904754,1.7343128,-0.57277818,-0.64347669,-0.57005269,1.7317226,-0.57277818,-0.64347669,-0.56904754,1.7328244,-0.57277818,-0.64347669,-0.56904754,1.7324282,-0.57277818,-0.64347669,-0.57005269,1.7339939,-0.57277818,-0.64347669,-0.57005269,1.7336266,-0.57277818,-0.64347669,-0.57005269,1.733414,-0.57277818,-0.64347669,-0.56904754,1.7312587,-0.57277818,-0.64347669,-0.56904754,1.7291614,-0.57277818,-0.64347669,-0.56904754,1.7303309,-0.57277818,-0.64347669,-0.56904754,1.729751,-0.57277818,-0.64347669,-0.56904754,1.7288038,-0.57277818,-0.64347669,-0.56904754,1.7294804,-0.57277818,-0.64347669,-0.57005269,1.7298863,-0.57277818,-0.64347669,-0.56904754,1.731742,-0.57277818,-0.64347669,-0.56904754,1.7321672,-0.57277818,-0.64347669,-0.56904754,1.7304855,-0.57277818,-0.64347669,-0.56904754,1.7345448,-0.57277818,-0.64347669,-0.56904754,1.7355789,-0.57277818,-0.64347669,-0.56904754,1.7359945,-0.57277818,-0.64347669,-0.57005269,1.7339745,-0.57277818,-0.64347669,-0.56904754,1.7350184,-0.57277818,-0.64347669,-0.57005269,1.7345254,-0.57277818,-0.64347669,-0.57005269,1.7355113,-0.57277818,-0.64347669,-0.57005269,1.7359558,-0.57277818,-0.64347669,-0.56904754,1.7350957,-0.57277818,-0.64347669,-0.56904754,1.735289,-0.57277818,-0.64347669,-0.56904754,1.7339552,-0.57277818,-0.64347669,-0.56904754,1.7355693,-0.57277818,-0.64347669,-0.57005269,1.7350377,-0.57277818,-0.64347669,-0.57005269,1.7356562,-0.57277818,-0.64347669,-0.56904754,1.7351247,-0.57277818,-0.64347669,-0.56904754,1.735202,-0.57277818,-0.64347669,-0.56904754,1.7357819,-0.57277818,-0.64347669,-0.57005269,1.7338779,-0.57277818,-0.64347669,-0.56904754,1.7342452,-0.57277818,-0.64347669,-0.56904754,1.7338972,-0.57277818,-0.64347669,-0.56904754,1.7338682,-0.57277818,-0.64347669,-0.56904754,1.7337039,-0.57277818,-0.64347669,-0.57005269,1.7350377,-0.57277818,-0.64347669,-0.56904754,1.7326021,-0.57277818,-0.64347669,-0.57005269,1.7338586,-0.57277818,-0.64347669,-0.56904754,1.7344675,-0.57277818,-0.64347669,-0.56904754,1.7353566,-0.57277818,-0.64347669,-0.57005269,1.7342355,-0.57277818,-0.64347669,-0.56904754,1.7364391,-0.57277818,-0.64347669,-0.56904754,1.7356659,-0.57277818,-0.64347669,-0.56904754,1.7336266,-0.57277818,-0.64347669,-0.56904754,1.7350667,-0.57277818,-0.64347669,-0.56904754,1.7303116,-0.57277818,-0.64347669,-0.56904754,1.7307368,-0.57277818,-0.64347669,-0.56904754,1.7284656,-0.57277818,-0.64347669,-0.56904754,1.7260397,-0.57277818,-0.64347669,-0.56904754,1.7290745,-0.57277818,-0.64347669,-0.57005269,1.7291518,-0.57277818,-0.64347669,-0.57005269,1.7290551,-0.57277818,-0.64347669,-0.56904754,1.7312297,-0.57277818,-0.64347669,-0.56904754,1.7313747,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818,-0.64347669,-0.56904754,1.731771,-0.57277818:6
-0.58044913,-0.51899703,1.732647,-0.66916632,-0.58044913,-0.51796075,1.7363997,-0.66915626,-0.58044913,-0.51796075,1.7375667,-0.66916632,-0.58044913,-0.51796075,1.735303,-0.66916632,-0.5814854,-0.51796075,1.7345988,-0.66916632,-0.57940279,-0.51796075,1.7393676,-0.66916632,-0.58044913,-0.51796075,1.7363393,-0.66916632,-0.58044913,-0.51796075,1.736289,-0.66916632,-0.58044913,-0.51796075,1.7352125,-0.66915626,-0.58044913,-0.51796075,1.7360274,-0.66916632,-0.58044913,-0.51796075,1.7384119,-0.66916632,-0.5814854,-0.51796075,1.7327979,-0.66916632,-0.58044913,-0.51796075,1.7379792,-0.66915626,-0.58044913,-0.51796075,1.7368323,-0.66915626,-0.58044913,-0.51796075,1.7366713,-0.66915626,-0.58044913,-0.51796075,1.7384119,-0.66915626,-0.58044913,-0.51796075,1.737275,-0.66915626,-0.5814854,-0.51691442,1.7344277,-0.66915626,-0.58044913,-0.51796075,1.7360073,-0.66915626,-0.5814854,-0.51796075,1.7343976,-0.66915626,-0.58044913,-0.51691442,1.7355546,-0.66915626,-0.58044913,-0.51691442,1.7370536,-0.66915626,-0.58044913,-0.51691442,1.7365204,-0.66915626,-0.58044913,-0.51691442,1.7359469,-0.66915626,-0.58044913,-0.51691442,1.7355546,-0.66915626,-0.58044913,-0.51691442,1.7357256,-0.66915626,-0.58044913,-0.51691442,1.7330796,-0.66915626,-0.5814854,-0.51691442,1.7304336,-0.66915626,-0.5814854,-0.51691442,1.7318421,-0.66915626,-0.5814854,-0.51691442,1.7316207,-0.66915626,-0.58253174,-0.51691442,1.7272845,-0.66915626,-0.5814854,-0.51691442,1.7284314,-0.66915626,-0.5814854,-0.51691442,1.7315403,-0.66915626,-0.58044913,-0.51691442,1.7327777,-0.66915626,-0.58044913,-0.51691442,1.7326872,-0.66915626,-0.5814854,-0.51691442,1.7323149,-0.66915626,-0.5814854,-0.51691442,1.7335726,-0.66915626,-0.58044913,-0.51691442,1.7344881,-0.66915626,-0.58044913,-0.51691442,1.7334216,-0.66915626,-0.58044913,-0.51691442,1.733814,-0.66915626,-0.5814854,-0.51691442,1.7325665,-0.66915626,-0.58044913,-0.51586808,1.7356753,-0.66915626,-0.5814854,-0.51586808,1.729518,-0.6691462,-0.5814854,-0.51691442,1.7297997,-0.66915626,-0.58253174,-0.51586808,1.7314698,-0.66915626,-0.58044913,-0.51586808,1.7346893,-0.66915626,-0.5814854,-0.51586808,1.7327174,-0.66915626,-0.58044913,-0.51586808,1.7337134,-0.66915626,-0.58044913,-0.51586808,1.7342768,-0.66915626,-0.58044913,-0.51586808,1.7357357,-0.66915626,-0.5814854,-0.51586808,1.7336631,-0.66915626,-0.58044913,-0.51586808,1.7353936,-0.66915626,-0.58044913,-0.51586808,1.7339146,-0.66915626,-0.58044913,-0.51586808,1.7354238,-0.66915626,-0.58044913,-0.51586808,1.7358262,-0.66915626,-0.58044913,-0.51586808,1.7359469,-0.66915626,-0.5814854,-0.51586808,1.7356451,-0.6691462,-0.58044913,-0.51586808,1.7359168,-0.6691462,-0.5814854,-0.51586808,1.7342265,-0.6691462,-0.5814854,-0.51586808,1.7321137,-0.66915626,-0.5814854,-0.51586808,1.7338543,-0.6691462,-0.58044913,-0.51483181,1.7363091,-0.6691462,-0.58044913,-0.51483181,1.7338844,-0.6691462,-0.58253174,-0.51483181,1.7341561,-0.6691462,-0.5814854,-0.51483181,1.7325866,-0.6691462,-0.5814854,-0.51483181,1.7331299,-0.6691462,-0.5814854,-0.51483181,1.7334317,-0.6691462,-0.5814854,-0.51483181,1.7345384,-0.6691462,-0.5814854,-0.51483181,1.7346591,-0.6691462,-0.58044913,-0.51483181,1.7355344,-0.6691462,-0.58253174,-0.51483181,1.731329,-0.6691462,-0.58253174,-0.51483181,1.7307253,-0.6691462,-0.5814854,-0.51483181,1.7320131,-0.6691462,-0.58253174,-0.51483181,1.7337738,-0.6691462,-0.5814854,-0.51483181,1.7315403,-0.6691462,-0.5814854,-0.51483181,1.7354137,-0.6691462,-0.58044913,-0.51483181,1.7345585,-0.6691462,-0.58044913,-0.51483181,1.7347698,-0.6691462,-0.5814854,-0.51483181,1.7345585,-0.6691462,-0.58253174,-0.51483181,1.7292765,-0.6691462,-0.58253174,-0.51483181,1.7296589,-0.6691462,-0.5814854,-0.51586808,1.7266909,-0.66915626,-0.58356802,-0.51586808,1.723079,-0.6691462,-0.58356802,-0.51586808,1.720433,-0.6691462,-0.58356802,-0.51586808,1.7217208,-0.6691462,-0.58356802,-0.51586808,1.7211876,-0.66915626,-0.58253174,-0.51586808,1.7234613,-0.6691462,-0.58461435,-0.51586808,1.7215699,-0.6691462,-0.58253174,-0.51586808,1.7245379,-0.6691462,-0.5814854,-0.51586808,1.7273448,-0.6691462,-0.58356802,-0.51586808,1.725715,-0.6691462,-0.58253174,-0.51483181,1.7250308,-0.6691462,-0.58253174,-0.51586808,1.7231595,-0.6691462,-0.58253174,-0.51483181,1.7240348,-0.6691462,-0.58356802,-0.51586808,1.725051,-0.6691462,-0.58253174,-0.51483181,1.7261375,-0.6691462,-0.58253174,-0.51483181,1.7223144,-0.6691462,-0.58253174,-0.51586808,1.7235016,-0.6691462,-0.58253174,-0.51586808,1.7224955,-0.6691462,-0.58253174,-0.51483181,1.7244574,-0.6691462,-0.58253174,-0.51483181,1.7256949,-0.6691462,-0.5814854,-0.51483181,1.7298198,-0.6691462,-0.58253174,-0.51483181,1.72819,-0.6691462,-0.5814854,-0.51483181,1.7298098,-0.6691462,-0.58253174,-0.51483181,1.7278177,-0.6691462,-0.5814854,-0.51483181,1.7289244,-0.6691462,-0.58253174,-0.51483181,1.7269625,-0.6691462,-0.58253174,-0.51483181,1.725222,-0.6691462,-0.58253174,-0.51483181,1.7278881,-0.6691462,-0.58253174,-0.51483181,1.7271134,-0.6691462,-0.58773324,-0.51483181,1.7210769,-0.66912608,-0.58253174,-0.51483181,1.727697,-0.6691462,-0.58253174,-0.51483181,1.7279686,-0.6691462,-0.58253174,-0.51483181,1.727204,-0.6691462,-0.58253174,-0.51483181,1.7274354,-0.6691462,-0.5814854,-0.51483181,1.7283107,-0.6691462,-0.58253174,-0.51483181,1.7255238,-0.6691462,-0.58253174,-0.51483181,1.7253226,-0.6691462,-0.58253174,-0.51483181,1.7266305,-0.6691462,-0.5814854,-0.51483181,1.728854,-0.6691462,-0.58253174,-0.51483181,1.7294979,-0.6691462,-0.58253174,-0.51483181,1.7270128,-0.6691462,-0.58253174,-0.51483181,1.7256144,-0.6691462,-0.5814854,-0.51378547,1.72984,-0.6691462,-0.58253174,-0.51378547,1.7294878,-0.6691462,-0.58253174,-0.51483181,1.7268317,-0.6691462,-0.58461435,-0.51483181,1.7255138,-0.6691462,-0.58253174,-0.51483181,1.7267814,-0.6691462,-0.58253174,-0.51378547,1.7301015,-0.6691462,-0.5814854,-0.51378547,1.7288037,-0.6691462,-0.5814854,-0.51378547,1.7294174,-0.6691462,-0.5814854,-0.51378547,1.7280391,-0.6691462,-0.5814854,-0.51378547,1.7298198,-0.6691462,-0.58253174,-0.51483181,1.7277171,-0.66913614,-0.58253174,-0.51378547,1.7272141,-0.6691462,-0.5814854,-0.51378547,1.7303028,-0.6691462,-0.58253174,-0.51483181,1.7285522,-0.6691462,-0.5814854,-0.51378547,1.7293269,-0.6691462,-0.58253174,-0.51378547,1.7275259,-0.6691462,-0.58253174,-0.51483181,1.7277372,-0.6691462,-0.58253174,-0.51483181,1.7273549,-0.6691462,-0.5814854,-0.51378547,1.7282805,-0.6691462,-0.58253174,-0.51483181,1.7245982,-0.6691462,-0.58253174,-0.51483181,1.7259665,-0.6691462,-0.58253174,-0.51483181,1.7276266,-0.6691462,-0.58253174,-0.51483181,1.7259967,-0.6691462,-0.58253174,-0.51483181,1.7264695,-0.6691462,-0.5814854,-0.51483181,1.7278278,-0.6691462,-0.58253174,-0.51483181,1.7249403,-0.6691462,-0.58253174,-0.51483181,1.7241254,-0.6691462,-0.58356802,-0.51483181,1.7276467,-0.6691462,-0.58253174,-0.51378547,1.7268519,-0.6691462,-0.58253174,-0.51378547,1.7256546,-0.6691462,-0.58253174,-0.51378547,1.7263589,-0.6691462,-0.58253174,-0.51378547,1.7257552,-0.6691462,-0.58253174,-0.51378547,1.725725,-0.6691462,-0.58253174,-0.51483181,1.7273448,-0.6691462,-0.58253174,-0.51691442,1.7222037,-0.66915626,-0.58356802,-0.50545503,1.7228275,-0.6690959,-0.58253174,-0.47108693,1.724065,-0.66892486,-0.58356802,-0.45442604,1.7199199,-0.66884437,-0.5814854,-0.45442604,1.7210568,-0.66884437,-0.5814854,-0.44193038,1.7208958,-0.66878401,-0.5814854,-0.44296666,1.7235217,-0.66879407,-0.5814854,-0.44921449,1.7234714,-0.66882425,-0.58044913,-0.44504927,1.7252019,-0.66880413,-0.5814854,-0.44504927,1.7247391,-0.66880413,-0.5814854,-0.44401299,1.723572,-0.66880413,-0.58044913,-0.43880144,1.7251516,-0.66877395,-0.5814854,-0.4460956,1.7252522,-0.66881419,-0.5814854,-0.44088405,1.7242561,-0.66878401,-0.5814854,-0.44088405,1.7242863,-0.66878401,-0.5814854,-0.43880144,1.7232601,-0.66877395,-0.5814854,-0.44193038,1.7234613,-0.66878401,-0.5814854,-0.4377551,1.7233205,-0.66877395,-0.5814854,-0.44296666,1.7249403,-0.66879407,-0.5814854,-0.44504927,1.7232601,-0.66880413,-0.5814854,-0.44193038,1.7248095,-0.66879407,-0.58253174,-0.44193038,1.7210568,-0.66878401,-0.5814854,-0.44401299,1.7237732,-0.66880413,-0.58253174,-0.44296666,1.7205537,-0.66879407,-0.58253174,-0.44401299,1.7210668,-0.66879407,-0.58253174,-0.44921449,1.7208153,-0.66882425,-0.5814854,-0.44713188,1.7221434,-0.66881419,-0.58253174,-0.44921449,1.7193665,-0.66882425,-0.58253174,-0.45442604,1.7183504,-0.66885443,-0.58253174,-0.44817821,1.7193766,-0.66881419,-0.5814854,-0.45442604,1.7214693,-0.66885443,-0.58253174,-0.4460956,1.7189037,-0.66880413,-0.5814854,-0.4512971,1.7226263,-0.66883431,-0.5814854,-0.44193038,1.7218013,-0.66878401,-0.5814854,-0.44088405,1.7224452,-0.66878401,-0.5814854,-0.44088405,1.7218918,-0.66878401,-0.5814854,-0.43880144,1.7219522,-0.66877395,-0.5814854,-0.4377551,1.7217812,-0.66877395,-0.5814854,-0.44817821,1.7231394,-0.66882425,-0.5814854,-0.44401299,1.7218113,-0.66879407,-0.5814854,-0.44296666,1.7196281,-0.66879407,-0.58253174,-0.45337971,1.7181894,-0.66884437,-0.58356802,-0.44401299,1.7201312,-0.66879407,-0.58253174,-0.45442604,1.7190345,-0.66885443,-0.5814854,-0.45442604,1.7239543,-0.66885443,-0.58253174,-0.44401299,1.7196583,-0.66879407,-0.58253174,-0.44817821,1.71828,-0.66881419,-0.58253174,-0.43983771,1.7198696,-0.66877395,-0.58461435,-0.4460956,1.7171934,-0.66880413,-0.58461435,-0.44193038,1.7174047,-0.66878401,-0.58253174,-0.45442604,1.7197187,-0.66884437,-0.58253174,-0.45442604,1.7190748,-0.66885443,-0.58253174,-0.45337971,1.7191452,-0.66884437,-0.58253174,-0.44713188,1.7176562,-0.66881419,-0.5814854,-0.44921449,1.7224754,-0.66882425,-0.58461435,-0.43983771,1.7149297,-0.66877395,-0.58253174,-0.44088405,1.7173242,-0.66878401,-0.58253174,-0.44504927,1.717133,-0.66880413,-0.58253174,-0.45442604,1.7173443,-0.66884437,-0.58253174,-0.45442604,1.7170827,-0.66884437,-0.58253174,-0.44088405,1.7167608,-0.66878401,-0.58253174,-0.4512971,1.7169016,-0.66883431,-0.5814854,-0.4377551,1.7171431,-0.66876389,-0.58253174,-0.44193038,1.7160967,-0.66878401,-0.58253174,-0.45337971,1.7170827,-0.66884437,-0.58253174,-0.45546232,1.7175958,-0.66885443,-0.58253174,-0.45234343,1.7173745,-0.66884437,-0.5814854,-0.44193038,1.7223043,-0.66879407,-0.5814854,-0.44296666,1.7218214,-0.66879407,-0.5814854,-0.43880144,1.7216403,-0.66877395,-0.5814854,-0.4460956,1.7246284,-0.66881419,-0.58044913,-0.45442604,1.7306448,-0.66885443,-0.58044913,-0.4512971,1.7275058,-0.66883431,-0.58044913,-0.44713188,1.730011,-0.66882425,-0.58044913,-0.4377551,1.7286628,-0.66877395,-0.58044913,-0.45234343,1.7288238,-0.66884437,-0.58044913,-0.45337971,1.7301217,-0.66885443,-0.58044913,-0.44713188,1.7299003,-0.66882425,-0.58044913,-0.45337971,1.7318018,-0.66885443,-0.5814854,-0.4460956,1.7249,-0.66880413,-0.5814854,-0.4460956,1.7266909,-0.66881419,-0.5814854,-0.44401299,1.7263891,-0.66880413,-0.58461435,-0.45337971,1.7220729,-0.66884437,-0.5814854,-0.45234343,1.7234714,-0.66884437,-0.58253174,-0.44193038,1.723069,-0.66878401,-0.5814854,-0.44401299,1.7244071,-0.66880413,-0.58253174,-0.45337971,1.7252723,-0.66884437,-0.58044913,-0.44193038,1.7307253,-0.66879407,-0.58044913,-0.44921449,1.7319326,-0.66883431,-0.58044913,-0.45234343,1.7332104,-0.66884437,-0.5814854,-0.45234343,1.7315604,-0.66884437,-0.57940279,-0.4512971,1.7358966,-0.66884437,-0.5814854,-0.45234343,1.7307555,-0.66884437,-0.58044913,-0.45234343,1.732486,-0.66884437,-0.5814854,-0.45234343,1.7303732,-0.66884437,-0.58253174,-0.45234343,1.7256244,-0.66884437,-0.5814854,-0.45337971,1.726218,-0.66884437,-0.58044913,-0.45234343,1.728532,-0.66884437,-0.5814854,-0.4512971,1.7289546,-0.66884437,-0.5814854,-0.45234343,1.7284012,-0.66884437,-0.5814854,-0.45234343,1.7305342,-0.66884437,-0.58044913,-0.45234343,1.732496,-0.66884437,-0.58044913,-0.4512971,1.7312082,-0.66884437,-0.58044913,-0.45234343,1.7317616,-0.66884437,-0.58044913,-0.45234343,1.7322143,-0.66884437,-0.5814854,-0.45234343,1.7278278,-0.66884437,-0.5814854,-0.45337971,1.7281195,-0.66884437,-0.5814854,-0.45337971,1.7277473,-0.66885443,-0.5814854,-0.43983771,1.7274455,-0.66878401,-0.58044913,-0.44504927,1.7313994,-0.66881419,-0.5814854,-0.45337971,1.7278479,-0.66885443,-0.58044913,-0.43983771,1.7296991,-0.66878401,-0.5814854,-0.43880144,1.7261577,-0.66878401,-0.58356802,-0.44296666,1.7240247,-0.66879407,-0.5814854,-0.44504927,1.7260872,-0.66880413,-0.5814854,-0.45546232,1.7248699,-0.6688645,-0.5814854,-0.44817821,1.7282503,-0.66882425,-0.58044913,-0.44296666,1.7303128,-0.66880413,-0.5814854,-0.45337971,1.7284616,-0.66885443,-0.58044913,-0.44921449,1.7311982,-0.66883431,-0.58044913,-0.45026082,1.7317817,-0.66883431,-0.58044913,-0.43671883,1.7310976,-0.66876389,-0.5814854,-0.45337971,1.7289647,-0.66884437,-0.5814854,-0.45442604,1.7279586,-0.66885443,-0.58044913,-0.44296666,1.7282604,-0.66879407,-0.5814854,-0.44088405,1.7256647,-0.66878401,-0.58044913,-0.44713188,1.7291156,-0.66882425,-0.58044913,-0.45337971,1.7286025,-0.66885443,-0.5814854,-0.44193038,1.7258558,-0.66878401,-0.58044913,-0.43880144,1.7322043,-0.66878401,-0.58044913,-0.44713188,1.7318622,-0.66882425,-0.5814854,-0.45442604,1.7307656,-0.66885443,-0.58044913,-0.44504927,1.7317616,-0.66880413,-0.57940279,-0.44088405,1.734146,-0.66879407,-0.57940279,-0.45337971,1.7342265,-0.66885443,-0.57940279,-0.45442604,1.734468,-0.66885443,-0.57940279,-0.44088405,1.734639,-0.66878401,-0.57940279,-0.44088405,1.7314195,-0.66878401,-0.57940279,-0.4460956,1.7343674,-0.66881419,-0.5814854,-0.45337971,1.733653,-0.66884437,-0.57940279,-0.4460956,1.7337436,-0.66881419,-0.57940279,-0.44817821,1.7341058,-0.66882425,-0.58044913,-0.44713188,1.7317515,-0.66882425,-0.58044913,-0.44088405,1.7302625,-0.66878401,-0.58044913,-0.43880144,1.7317314,-0.66878401,-0.57940279,-0.44713188,1.7322043,-0.66881419,-0.57940279,-0.45442604,1.7334116,-0.66885443,-0.58044913,-0.4460956,1.7311881,-0.66881419,-0.57940279,-0.44504927,1.7329689,-0.66881419,-0.57940279,-0.45442604,1.7349207,-0.66885443,-0.57940279,-0.45337971,1.7351018,-0.66885443,-0.57940279,-0.43880144,1.7343573,-0.66878401,-0.58044913,-0.44193038,1.7315,-0.66879407,-0.58044913,-0.45546232,1.7281598,-0.66885443,-0.58044913,-0.45442604,1.7315503,-0.66885443,-0.58356802,-0.44193038,1.7291659,-0.66878401,-0.5814854,-0.4512971,1.7304537,-0.66883431,-0.58044913,-0.44401299,1.7309265,-0.66880413,-0.58044913,-0.44193038,1.7292564,-0.66879407,-0.57940279,-0.4460956,1.7337637,-0.66881419,-0.58044913,-0.45546232,1.7285924,-0.66885443,-0.58044913,-0.44713188,1.7276769,-0.66881419,-0.58044913,-0.4460956,1.7317918,-0.66881419,-0.58044913,-0.45546232,1.7292464,-0.66885443,-0.58044913,-0.4460956,1.7302122,-0.66881419,-0.58044913,-0.44713188,1.7315805,-0.66882425,-0.58044913,-0.45442604,1.7306348,-0.66885443,-0.58044913,-0.45442604,1.7309567,-0.66885443,-0.58044913,-0.4460956,1.7296689,-0.66881419,-0.58044913,-0.45546232,1.7290753,-0.66885443,-0.58253174,-0.44817821,1.7204934,-0.66882425,-0.58565063,-0.44504927,1.7175254,-0.66880413,-0.58253174,-0.44921449,1.7202318,-0.66882425,-0.5814854,-0.44296666,1.7217912,-0.66879407,-0.5814854,-0.44193038,1.7213988,-0.66879407,-0.5814854,-0.45442604,1.7219824,-0.66885443,-0.58253174,-0.45546232,1.722244,-0.6688645,-0.5814854,-0.44088405,1.7242662,-0.66879407,-0.5814854,-0.45442604,1.721258,-0.66885443,-0.5814854,-0.45650865,1.7238537,-0.6688645,-0.5814854,-0.44921449,1.720936,-0.66882425,-0.58356802,-0.45442604,1.7204531,-0.66885443,-0.58253174,-0.45650865,1.7190748,-0.6688645,-0.5814854,-0.44296666,1.7205437,-0.66879407,-0.58253174,-0.44817821,1.7216806,-0.66882425,-0.58356802,-0.45650865,1.7220629,-0.66885443,-0.5814854,-0.44921449,1.7267814,-0.66882425,-0.58044913,-0.44713188,1.7269625,-0.66881419,-0.58253174,-0.45546232,1.7279183,-0.66885443,-0.5814854,-0.44088405,1.7259363,-0.66878401,-0.5814854,-0.4512971,1.7275863,-0.66883431,-0.5814854,-0.45546232,1.7264394,-0.6688645,-0.5814854,-0.44504927,1.7264695,-0.66880413,-0.58044913,-0.44504927,1.7274756,-0.66880413,-0.5814854,-0.45546232,1.7265802,-0.6688645,-0.58044913,-0.44921449,1.728522,-0.66882425,-0.58044913,-0.4460956,1.7277775,-0.66881419,-0.5814854,-0.44713188,1.7240046,-0.66881419,-0.5814854,-0.44088405,1.7253125,-0.66878401,-0.5814854,-0.4512971,1.7269324,-0.66883431,-0.58044913,-0.44401299,1.72654,-0.66880413,-0.5814854,-0.4460956,1.7263287,-0.66881419,-0.5814854,-0.4460956,1.7263287,-0.66881419,-0.5814854,-0.4460956,1.7263287,-0.66881419,-0.5814854,-0.4460956,1.7263287,-0.66881419,-0.5814854,-0.4460956,1.7263287,-0.66881419,-0.5814854,-0.4460956,1.7263287,-0.66881419,-0.5814854,-0.4460956,1.7263287,-0.66881419:6
-0.54398168,-0.61562593,1.7283834,-0.70147986,-0.54398168,-0.61562593,1.7285786,-0.70147986,-0.54398168,-0.61562593,1.7285581,-0.70147986,-0.54398168,-0.61562593,1.7281471,-0.70147986,-0.54611878,-0.61669448,1.7225783,-0.70149013,-0.54718733,-0.61669448,1.7190747,-0.7015004,-0.54505023,-0.61669448,1.7234105,-0.70149013,-0.54505023,-0.61669448,1.7247668,-0.70149013,-0.54505023,-0.61669448,1.725784,-0.70149013,-0.54398168,-0.61669448,1.727808,-0.70147986,-0.54398168,-0.61562593,1.7279724,-0.70147986,-0.54398168,-0.61562593,1.7291745,-0.70147986,-0.54718733,-0.61669448,1.7194548,-0.70149013,-0.54825588,-0.61669448,1.7134545,-0.7015004,-0.54825588,-0.61669448,1.7152423,-0.7015004,-0.54825588,-0.61669448,1.7157457,-0.7015004,-0.54825588,-0.61776303,1.7128072,-0.7015004,-0.54825588,-0.61669448,1.7150265,-0.7015004,-0.54825588,-0.61669448,1.7139785,-0.7015004,-0.54825588,-0.61669448,1.7128586,-0.7015004,-0.54825588,-0.61669448,1.7138861,-0.7015004,-0.54825588,-0.61669448,1.7147286,-0.7015004,-0.54825588,-0.61776303,1.713023,-0.7015004,-0.54825588,-0.61776303,1.7126737,-0.7015004,-0.54611878,-0.61669448,1.7227324,-0.70149013,-0.54611878,-0.61669448,1.7216947,-0.70149013,-0.54505023,-0.61669448,1.725075,-0.70149013,-0.54505023,-0.61669448,1.725784,-0.70149013,-0.54505023,-0.61669448,1.7252908,-0.70149013,-0.54505023,-0.61669448,1.7259175,-0.70149013,-0.54398168,-0.61669448,1.7270477,-0.70147986,-0.54611878,-0.61669448,1.7227016,-0.70149013,-0.54505023,-0.61669448,1.7232975,-0.70149013,-0.54505023,-0.61669448,1.7234516,-0.70149013,-0.54505023,-0.61669448,1.7238626,-0.70149013,-0.54505023,-0.61669448,1.7226605,-0.70149013,-0.54611878,-0.61669448,1.7222392,-0.70149013,-0.54611878,-0.61669448,1.7208727,-0.70149013,-0.54611878,-0.61669448,1.7209446,-0.70149013,-0.54611878,-0.61669448,1.7208008,-0.70149013,-0.54505023,-0.61669448,1.7229893,-0.70149013,-0.54932443,-0.61776303,1.7104852,-0.7015004,-0.54825588,-0.61776303,1.7119031,-0.7015004,-0.54825588,-0.61776303,1.7141429,-0.7015004,-0.54825588,-0.61776303,1.713249,-0.7015004,-0.54825588,-0.61669448,1.7139169,-0.7015004,-0.54932443,-0.61776303,1.7098379,-0.7015004,-0.54825588,-0.61776303,1.7122113,-0.7015004,-0.54825588,-0.61669448,1.7137319,-0.7015004,-0.54825588,-0.61776303,1.7124682,-0.7015004,-0.54505023,-0.61669448,1.7231434,-0.70149013,-0.54505023,-0.61669448,1.7233386,-0.70149013,-0.54505023,-0.61669448,1.7228763,-0.70149013,-0.54505023,-0.61669448,1.7231845,-0.70149013,-0.54505023,-0.61669448,1.7241606,-0.70149013,-0.54505023,-0.61669448,1.7243969,-0.70149013,-0.54505023,-0.61669448,1.7255168,-0.70149013,-0.54505023,-0.61669448,1.7254449,-0.70149013,-0.54505023,-0.61669448,1.7228454,-0.70149013,-0.54505023,-0.61669448,1.7230715,-0.70149013,-0.54505023,-0.61669448,1.7238523,-0.70149013,-0.54505023,-0.61669448,1.7249106,-0.70149013,-0.54505023,-0.61669448,1.7237701,-0.70149013,-0.54505023,-0.61669448,1.7237393,-0.70149013,-0.54611878,-0.61669448,1.721633,-0.70149013,-0.54505023,-0.61669448,1.7239243,-0.70149013,-0.5375601,-0.49371871,1.7229379,-0.70112025,-0.535423,-0.45415152,1.7224447,-0.7009764,-0.5375601,-0.50868869,1.7221776,-0.70116135,-0.53862865,-0.50868869,1.7232564,-0.70117162,-0.53862865,-0.50441449,1.7230098,-0.70116135,-0.53649155,-0.48729713,1.7238112,-0.7010997,-0.5375601,-0.50548304,1.7244174,-0.70116135,-0.535423,-0.50548304,1.7241606,-0.70116135,-0.535423,-0.48302293,1.7259278,-0.70107915,-0.53649155,-0.4733957,1.7254141,-0.70104833,-0.535423,-0.48409148,1.7252291,-0.70108942,-0.53649155,-0.50548304,1.7253319,-0.70116135,-0.5375601,-0.50548304,1.7265443,-0.70115107,-0.53649155,-0.50120883,1.7247154,-0.7011408,-0.535423,-0.49158161,1.7231948,-0.70096613,-0.53649155,-0.48729713,1.7247976,-0.7010997,-0.535423,-0.44880876,1.723914,-0.70098668,-0.5375601,-0.50548304,1.7240784,-0.70116135,-0.53649155,-0.50548304,1.7275512,-0.70115107,-0.5332859,-0.41137867,1.7271813,-0.70082229,-0.53435445,-0.44880876,1.7268422,-0.70095585,-0.53435445,-0.46164164,1.7285067,-0.70100723,-0.53435445,-0.46164164,1.7296369,-0.70100723,-0.5332859,-0.46271019,1.7296985,-0.70100723,-0.53435445,-0.46164164,1.7283218,-0.70100723,-0.53435445,-0.46164164,1.7290821,-0.70100723,-0.53435445,-0.46271019,1.7283526,-0.70100723,-0.53435445,-0.46271019,1.7294828,-0.70100723,-0.53435445,-0.46377874,1.7277978,-0.70100723,-0.53435445,-0.46591585,1.7260716,-0.7010175,-0.53435445,-0.46805295,1.7266778,-0.70102778,-0.53435445,-0.46591585,1.728743,-0.7010175,-0.53435445,-0.46591585,1.7256607,-0.7010175,-0.535423,-0.46591585,1.7258353,-0.7010175,-0.535423,-0.46805295,1.7249209,-0.70102778,-0.53435445,-0.46805295,1.7267806,-0.70102778,-0.53649155,-0.46591585,1.7260511,-0.7010175,-0.535423,-0.4669844,1.7251161,-0.70102778,-0.53435445,-0.46271019,1.7259278,-0.70100723,-0.53435445,-0.46377874,1.7255065,-0.70100723,-0.53649155,-0.46805295,1.7256812,-0.70102778,-0.535423,-0.46484729,1.7254346,-0.7010175,-0.53435445,-0.46484729,1.7258661,-0.7010175,-0.53435445,-0.46377874,1.7258764,-0.70100723,-0.535423,-0.46591585,1.7254654,-0.7010175,-0.53435445,-0.46271019,1.7264107,-0.70100723,-0.53435445,-0.46484729,1.727058,-0.7010175,-0.53435445,-0.46271019,1.726123,-0.70100723,-0.53435445,-0.46484729,1.7268936,-0.7010175,-0.5332859,-0.4669844,1.7299965,-0.7010175,-0.53435445,-0.46271019,1.7281574,-0.70100723,-0.53435445,-0.46591585,1.7280032,-0.7010175,-0.53435445,-0.46484729,1.7280443,-0.7010175,-0.53435445,-0.46484729,1.7261949,-0.7010175,-0.53435445,-0.46484729,1.7280854,-0.7010175,-0.5332859,-0.46484729,1.7303767,-0.70100723,-0.5332859,-0.46377874,1.7309007,-0.70100723,-0.5332859,-0.46484729,1.732185,-0.70100723,-0.5332859,-0.4669844,1.7307568,-0.7010175,-0.53221735,-0.46377874,1.7343529,-0.70100723,-0.53221735,-0.46271019,1.7325754,-0.70099695,-0.5332859,-0.46271019,1.7293903,-0.70100723,-0.5332859,-0.44774021,1.7281985,-0.70095585,-0.5332859,-0.45735717,1.7284861,-0.70098668,-0.53435445,-0.45415152,1.7282704,-0.7009764,-0.53435445,-0.45735717,1.7287327,-0.70098668,-0.53435445,-0.45735717,1.7287019,-0.70098668,-0.5332859,-0.45735717,1.728332,-0.70098668,-0.5332859,-0.44987731,1.729678,-0.70095585,-0.535423,-0.45201441,1.7243044,-0.7009764,-0.53435445,-0.45415152,1.7253319,-0.7009764,-0.535423,-0.45735717,1.7243352,-0.70098668,-0.535423,-0.45628862,1.7239859,-0.70098668,-0.535423,-0.45094586,1.7237393,-0.70096613,-0.535423,-0.45415152,1.7231331,-0.7009764,-0.53649155,-0.45415152,1.7210577,-0.7009764,-0.53649155,-0.45308296,1.7213351,-0.70096613,-0.53649155,-0.45308296,1.7205542,-0.7009764,-0.53649155,-0.45415152,1.7175746,-0.7009764,-0.53649155,-0.45842572,1.7179856,-0.70098668,-0.535423,-0.45308296,1.7196192,-0.70096613,-0.535423,-0.45522007,1.7201021,-0.7009764,-0.535423,-0.45415152,1.7203179,-0.7009764,-0.535423,-0.45522007,1.7206159,-0.7009764,-0.535423,-0.45308296,1.7205439,-0.7009764,-0.53649155,-0.45308296,1.7191774,-0.7009764,-0.535423,-0.45308296,1.7223728,-0.70096613,-0.53435445,-0.44987731,1.7242428,-0.70096613,-0.53649155,-0.45201441,1.7206775,-0.70096613,-0.535423,-0.46164164,1.7234722,-0.70100723,-0.53435445,-0.45628862,1.7240578,-0.70098668,-0.53435445,-0.45842572,1.7234722,-0.70098668,-0.535423,-0.45842572,1.7225577,-0.70099695,-0.535423,-0.46056282,1.7228865,-0.70099695,-0.53435445,-0.45842572,1.7222906,-0.70098668,-0.53435445,-0.46164164,1.722044,-0.70099695,-0.53435445,-0.45415152,1.7226708,-0.7009764,-0.535423,-0.45949427,1.721818,-0.70098668,-0.53435445,-0.45201441,1.721931,-0.70096613,-0.535423,-0.45415152,1.7200405,-0.7009764,-0.535423,-0.45094586,1.7210474,-0.70096613,-0.535423,-0.45628862,1.7205439,-0.7009764,-0.535423,-0.44559284,1.7218385,-0.70094558,-0.53649155,-0.45201441,1.7186534,-0.70096613,-0.535423,-0.45522007,1.7200199,-0.7009764,-0.535423,-0.45201441,1.7203487,-0.70096613,-0.535423,-0.45201441,1.7198966,-0.70096613,-0.53649155,-0.44880876,1.7191877,-0.70095585,-0.53649155,-0.45308296,1.7189617,-0.7009764,-0.535423,-0.44987731,1.7192596,-0.70095585,-0.535423,-0.45308296,1.719537,-0.70096613,-0.53649155,-0.45522007,1.7182835,-0.7009764,-0.53649155,-0.45415152,1.7198864,-0.7009764,-0.535423,-0.45842572,1.7207392,-0.70098668,-0.535423,-0.45735717,1.7231228,-0.70098668,-0.53435445,-0.45735717,1.7233181,-0.70098668,-0.535423,-0.45735717,1.722229,-0.70098668,-0.535423,-0.45735717,1.7213248,-0.70098668,-0.535423,-0.45735717,1.721633,-0.70098668,-0.53649155,-0.45735717,1.7199275,-0.70098668,-0.535423,-0.45735717,1.7226297,-0.70098668,-0.53435445,-0.45735717,1.7223523,-0.70098668,-0.53435445,-0.45735717,1.7228454,-0.70098668,-0.535423,-0.45735717,1.7222701,-0.70098668,-0.53435445,-0.45735717,1.7222392,-0.70098668,-0.53435445,-0.45735717,1.7235955,-0.70098668,-0.535423,-0.45735717,1.721407,-0.70098668,-0.53435445,-0.45735717,1.7226913,-0.70098668,-0.53649155,-0.45842572,1.7171225,-0.70098668,-0.535423,-0.45842572,1.7190336,-0.70098668,-0.535423,-0.45842572,1.7189925,-0.70098668,-0.53649155,-0.45842572,1.7181089,-0.70098668,-0.53649155,-0.45842572,1.7189308,-0.70098668,-0.535423,-0.45842572,1.7195987,-0.70098668,-0.535423,-0.45842572,1.719835,-0.70098668,-0.535423,-0.45735717,1.7196295,-0.70098668,-0.535423,-0.45735717,1.7199994,-0.70098668,-0.535423,-0.45842572,1.7190644,-0.70098668,-0.53649155,-0.45842572,1.7173897,-0.70098668,-0.535423,-0.45842572,1.7200302,-0.70098668,-0.535423,-0.45842572,1.7203282,-0.70098668,-0.53649155,-0.45842572,1.7199583,-0.70098668,-0.53649155,-0.45842572,1.7193418,-0.70098668,-0.535423,-0.45735717,1.7228043,-0.70098668,-0.535423,-0.45842572,1.7218283,-0.70098668,-0.53435445,-0.45735717,1.7252291,-0.70098668,-0.535423,-0.45735717,1.7263799,-0.70098668,-0.53435445,-0.45735717,1.7248592,-0.70098668,-0.53435445,-0.45735717,1.7256298,-0.70098668,-0.53435445,-0.45735717,1.7269861,-0.70098668,-0.53435445,-0.45735717,1.7268217,-0.70098668,-0.5332859,-0.45735717,1.7279621,-0.70098668,-0.5332859,-0.45628862,1.7296369,-0.7009764,-0.5332859,-0.45735717,1.729565,-0.7009764,-0.5332859,-0.45735717,1.7275101,-0.70098668,-0.53435445,-0.45735717,1.7264929,-0.70098668,-0.53435445,-0.45735717,1.7272429,-0.70098668,-0.5332859,-0.45735717,1.7278286,-0.70098668,-0.53435445,-0.45735717,1.726647,-0.70098668,-0.53435445,-0.45735717,1.7260716,-0.70098668,-0.53435445,-0.45735717,1.7262771,-0.70098668,-0.53435445,-0.45735717,1.7258148,-0.70098668,-0.53435445,-0.45735717,1.726832,-0.70098668,-0.53435445,-0.45735717,1.7262566,-0.70098668,-0.53435445,-0.45735717,1.725784,-0.70098668,-0.53435445,-0.45735717,1.7275923,-0.70098668,-0.53435445,-0.45735717,1.7271505,-0.70098668,-0.5332859,-0.45735717,1.7282396,-0.70098668,-0.535423,-0.45735717,1.7254038,-0.70098668,-0.53435445,-0.45735717,1.7273662,-0.70098668,-0.53435445,-0.45735717,1.7260408,-0.70098668,-0.53435445,-0.45735717,1.7275614,-0.70098668,-0.53435445,-0.45735717,1.7279416,-0.70098668,-0.5332859,-0.45735717,1.7282601,-0.70098668,-0.53435445,-0.45735717,1.7277361,-0.70098668,-0.53435445,-0.45735717,1.7261333,-0.70098668,-0.53435445,-0.45735717,1.7275409,-0.70098668,-0.53435445,-0.45735717,1.7266676,-0.70098668,-0.53435445,-0.45735717,1.7274073,-0.70098668,-0.53435445,-0.45735717,1.72676,-0.70098668,-0.53435445,-0.45735717,1.7284759,-0.70098668,-0.53435445,-0.45735717,1.7284759,-0.70098668,-0.53435445,-0.45735717,1.7280032,-0.70098668,-0.53435445,-0.45735717,1.7274484,-0.70098668,-0.5332859,-0.45735717,1.7287019,-0.70098668,-0.5332859,-0.45628862,1.7310651,-0.7009764,-0.5332859,-0.45735717,1.7297294,-0.70098668,-0.5332859,-0.45735717,1.7298116,-0.70098668,-0.5332859,-0.45735717,1.7299143,-0.70098668,-0.535423,-0.45628862,1.7294211,-0.70098668,-0.5332859,-0.45628862,1.7308904,-0.7009764,-0.53221735,-0.45628862,1.7331611,-0.70098668,-0.53221735,-0.45628862,1.7336748,-0.70098668,-0.53221735,-0.45628862,1.7326473,-0.7009764,-0.53221735,-0.45628862,1.7342193,-0.70098668,-0.53221735,-0.45628862,1.73387,-0.70098668,-0.5332859,-0.45735717,1.7315274,-0.70098668,-0.5332859,-0.45735717,1.7326062,-0.70098668,-0.5332859,-0.45628862,1.7332227,-0.70098668,-0.5332859,-0.45628862,1.7327295,-0.7009764,-0.5332859,-0.45628862,1.7326782,-0.7009764,-0.5332859,-0.45735717,1.7308082,-0.70098668,-0.53435445,-0.45628862,1.7307157,-0.70098668,-0.5332859,-0.45735717,1.7303356,-0.70098668,-0.5332859,-0.45735717,1.7314863,-0.70098668,-0.53435445,-0.45735717,1.729976,-0.70098668,-0.5332859,-0.45735717,1.731137,-0.70098668,-0.53435445,-0.45735717,1.7294725,-0.70098668,-0.53435445,-0.45735717,1.7279621,-0.70098668,-0.53435445,-0.45735717,1.7296369,-0.70098668,-0.53435445,-0.45735717,1.7283731,-0.70098668,-0.53435445,-0.45628862,1.7287841,-0.70098668,-0.53435445,-0.45628862,1.7297088,-0.70098668,-0.5332859,-0.45735717,1.7308904,-0.70098668,-0.5332859,-0.45735717,1.7304794,-0.70098668,-0.5332859,-0.45735717,1.7303869,-0.70098668,-0.5332859,-0.45735717,1.7307363,-0.70098668,-0.5332859,-0.45735717,1.7315377,-0.70098668,-0.5332859,-0.45735717,1.7302431,-0.70098668,-0.5332859,-0.45735717,1.7316404,-0.70098668,-0.5332859,-0.45735717,1.7306746,-0.70098668,-0.5332859,-0.45735717,1.7317124,-0.70098668,-0.5332859,-0.45735717,1.7300273,-0.70098668,-0.5332859,-0.45735717,1.7307979,-0.70098668,-0.5332859,-0.45735717,1.731887,-0.70098668,-0.53435445,-0.45735717,1.7283115,-0.70098668,-0.535423,-0.45735717,1.7274792,-0.70098668,-0.53435445,-0.45735717,1.7280032,-0.70098668,-0.53435445,-0.45735717,1.728106,-0.70098668,-0.5332859,-0.45735717,1.7292465,-0.70098668,-0.53435445,-0.45735717,1.7289382,-0.70098668,-0.5332859,-0.45735717,1.7288355,-0.70098668,-0.53435445,-0.45735717,1.728106,-0.70098668,-0.5332859,-0.45735717,1.7295033,-0.70098668,-0.5332859,-0.45735717,1.7293698,-0.70098668,-0.53435445,-0.45735717,1.7274279,-0.70098668,-0.5332859,-0.45735717,1.7305,-0.70098668,-0.5332859,-0.45735717,1.7314041,-0.70098668,-0.5332859,-0.45735717,1.7306027,-0.70098668,-0.5332859,-0.45735717,1.7299657,-0.70098668,-0.5332859,-0.45735717,1.7299965,-0.70098668,-0.5332859,-0.45735717,1.7306335,-0.70098668,-0.5332859,-0.45735717,1.7318048,-0.70098668,-0.5332859,-0.45735717,1.731887,-0.70098668,-0.5332859,-0.45735717,1.7317637,-0.70098668,-0.5332859,-0.45735717,1.7310856,-0.70098668,-0.5332859,-0.45735717,1.7321644,-0.70098668,-0.5332859,-0.45735717,1.7315274,-0.70098668,-0.5332859,-0.45735717,1.7306233,-0.70098668,-0.53435445,-0.45842572,1.7273868,-0.70098668,-0.53435445,-0.45842572,1.7273662,-0.70098668,-0.5332859,-0.45735717,1.7298527,-0.70098668,-0.5332859,-0.45735717,1.729452,-0.70098668,-0.5332859,-0.45735717,1.7301814,-0.70098668,-0.5332859,-0.45735717,1.7296985,-0.70098668,-0.5332859,-0.45735717,1.7308596,-0.70098668,-0.5332859,-0.45735717,1.7299451,-0.70098668,-0.5332859,-0.45735717,1.7310137,-0.70098668,-0.5332859,-0.45735717,1.7307054,-0.70098668,-0.53221735,-0.45735717,1.7307465,-0.70098668,-0.53221735,-0.45735717,1.7314144,-0.70098668,-0.5332859,-0.45735717,1.7310445,-0.70098668,-0.53221735,-0.45735717,1.729791,-0.70098668,-0.53221735,-0.45735717,1.729791,-0.70098668,-0.5332859,-0.45735717,1.7321028,-0.70098668,-0.53221735,-0.45735717,1.7315377,-0.70098668,-0.5332859,-0.45628862,1.7329145,-0.70098668,-0.5311488,-0.45735717,1.7335926,-0.70098668,-0.5311488,-0.45735717,1.7335412,-0.70098668,-0.53221735,-0.45735717,1.7313527,-0.70098668,-0.5332859,-0.45735717,1.7297499,-0.70098668,-0.53221735,-0.45735717,1.7313733,-0.70098668,-0.53221735,-0.45735717,1.7320309,-0.70098668,-0.53221735,-0.45735717,1.7324213,-0.70098668,-0.53221735,-0.45735717,1.731548,-0.70098668,-0.5332859,-0.45735717,1.7310548,-0.70098668,-0.5332859,-0.45735717,1.7310959,-0.70098668,-0.5332859,-0.45735717,1.7301506,-0.70098668,-0.5332859,-0.45735717,1.7315171,-0.70098668,-0.5332859,-0.45735717,1.731548,-0.70098668,-0.5332859,-0.45735717,1.7307774,-0.70098668,-0.5332859,-0.45735717,1.7317843,-0.70098668,-0.53435445,-0.45735717,1.7306849,-0.70098668,-0.5332859,-0.45735717,1.7303356,-0.70098668,-0.5332859,-0.45735717,1.7294109,-0.70098668,-0.53435445,-0.45735717,1.7297499,-0.70098668,-0.5332859,-0.45735717,1.7321953,-0.70098668,-0.53435445,-0.45735717,1.7291232,-0.70098668,-0.5332859,-0.45735717,1.7310034,-0.70098668,-0.53435445,-0.45735717,1.731887,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668,-0.5332859,-0.45735717,1.7317226,-0.70098668:6
-0.56377688,-0.59495338,1.7578393,-0.6119362,-0.56592556,-0.59602772,1.7419205,-0.61194653,-0.56377688,-0.59602772,1.7467137,-0.6119362,-0.56377688,-0.59602772,1.7612173,-0.6119362,-0.56592556,-0.59602772,1.7388214,-0.61194653,-0.56592556,-0.59602772,1.7366521,-0.61194653,-0.56592556,-0.59602772,1.7361872,-0.61194653,-0.5669999,-0.59602772,1.7210742,-0.61194653,-0.56592556,-0.59602772,1.7371686,-0.61194653,-0.56592556,-0.59602772,1.7356191,-0.61194653,-0.56592556,-0.59602772,1.7339766,-0.61194653,-0.56592556,-0.59602772,1.7331192,-0.61194653,-0.56592556,-0.59602772,1.7359909,-0.61194653,-0.56485122,-0.59602772,1.7342245,-0.61194653,-0.56377688,-0.5799023,1.7572815,-0.61190521,-0.56377688,-0.5799023,1.7560418,-0.61190521,-0.56270254,-0.5799023,1.7585521,-0.61190521,-0.56377688,-0.5799023,1.7581802,-0.61190521,-0.56270254,-0.5799023,1.7595851,-0.61190521,-0.56377688,-0.5799023,1.7585624,-0.61190521,-0.56377688,-0.5799023,1.7565583,-0.61190521,-0.56377688,-0.5799023,1.7544716,-0.61190521,-0.56377688,-0.5799023,1.7550088,-0.61190521,-0.56377688,-0.5799023,1.7539861,-0.61190521,-0.56377688,-0.5799023,1.7555357,-0.61190521,-0.56377688,-0.5799023,1.7558352,-0.61190521,-0.56377688,-0.5799023,1.7563621,-0.61190521,-0.56377688,-0.5799023,1.7538828,-0.61190521,-0.56377688,-0.5799023,1.7562174,-0.61190521,-0.56377688,-0.5799023,1.7556183,-0.61190521,-0.56377688,-0.5799023,1.7550915,-0.61190521,-0.56377688,-0.5799023,1.7552567,-0.61190521,-0.56377688,-0.5799023,1.7554633,-0.61190521,-0.56377688,-0.5799023,1.755608,-0.61190521,-0.56377688,-0.5799023,1.7545956,-0.61190521,-0.56377688,-0.5799023,1.75317,-0.61190521,-0.56377688,-0.5799023,1.7568166,-0.61190521,-0.56377688,-0.5799023,1.7552464,-0.61190521,-0.56377688,-0.5799023,1.7557216,-0.61190521,-0.56377688,-0.5799023,1.755484,-0.61190521,-0.56377688,-0.5799023,1.7578496,-0.61190521,-0.56377688,-0.5799023,1.7572401,-0.61190521,-0.56377688,-0.5799023,1.7573641,-0.61190521,-0.56377688,-0.5799023,1.7568889,-0.61190521,-0.56377688,-0.5799023,1.7585417,-0.61190521,-0.56377688,-0.5799023,1.757767,-0.61190521,-0.56377688,-0.5799023,1.7577153,-0.61190521,-0.56485122,-0.5799023,1.7364558,-0.61190521,-0.56485122,-0.5799023,1.7376644,-0.61190521,-0.56485122,-0.5799023,1.7364042,-0.61190521,-0.56485122,-0.5799023,1.7385941,-0.61190521,-0.56485122,-0.5799023,1.7373029,-0.61190521,-0.56592556,-0.58097664,1.7254645,-0.61191554,-0.56592556,-0.58097664,1.7272309,-0.61191554,-0.56592556,-0.5799023,1.7275718,-0.61190521,-0.56592556,-0.5799023,1.7355674,-0.61190521,-0.56377688,-0.5799023,1.7577463,-0.61190521,-0.56377688,-0.5799023,1.7572195,-0.61190521,-0.56377688,-0.5799023,1.7586967,-0.61190521,-0.56377688,-0.5799023,1.7576843,-0.61190521,-0.56377688,-0.5799023,1.7576533,-0.61190521,-0.56377688,-0.5799023,1.7580975,-0.61190521,-0.56377688,-0.5799023,1.7576533,-0.61190521,-0.56377688,-0.5799023,1.7568579,-0.61190521,-0.56270254,-0.5799023,1.7641304,-0.61190521,-0.56270254,-0.5799023,1.7643576,-0.61190521,-0.56270254,-0.5799023,1.763087,-0.61190521,-0.56270254,-0.5799023,1.7615788,-0.61190521,-0.56270254,-0.5799023,1.763087,-0.61190521,-0.56270254,-0.5799023,1.7636035,-0.61190521,-0.56270254,-0.5799023,1.7622606,-0.61190521,-0.56270254,-0.5799023,1.7617131,-0.61190521,-0.56270254,-0.5799023,1.7625292,-0.61190521,-0.56270254,-0.5799023,1.7613102,-0.61190521,-0.56270254,-0.5799023,1.7613929,-0.61190521,-0.56270254,-0.5799023,1.7592855,-0.61190521,-0.56270254,-0.5799023,1.760897,-0.61190521,-0.56270254,-0.5799023,1.7608454,-0.61190521,-0.56270254,-0.5799023,1.7596367,-0.61190521,-0.56270254,-0.5799023,1.7610416,-0.61190521,-0.56270254,-0.5799023,1.7606284,-0.61190521,-0.56270254,-0.5799023,1.7593268,-0.61190521,-0.56270254,-0.5799023,1.7610003,-0.61190521,-0.5616282,-0.54119509,1.758738,-0.61178125,-0.5616282,-0.54226943,1.7592029,-0.61178125,-0.5616282,-0.54226943,1.7590686,-0.61178125,-0.5616282,-0.54226943,1.7599983,-0.61178125,-0.5616282,-0.54226943,1.7604115,-0.61178125,-0.5616282,-0.54226943,1.7610107,-0.61178125,-0.5616282,-0.54012075,1.7597297,-0.61177092,-0.5616282,-0.53904642,1.7591615,-0.61177092,-0.5616282,-0.54012075,1.7601429,-0.61177092,-0.5616282,-0.54119509,1.759833,-0.61178125,-0.5616282,-0.54012075,1.7591925,-0.61177092,-0.5616282,-0.54119509,1.7604632,-0.61178125,-0.5616282,-0.54012075,1.7585211,-0.61177092,-0.5616282,-0.54012075,1.7590273,-0.61177092,-0.5616282,-0.54119509,1.7548229,-0.61178125,-0.5616282,-0.54226943,1.7550708,-0.61178125,-0.56270254,-0.54334377,1.7524573,-0.61179158,-0.56377688,-0.54012075,1.7305056,-0.61177092,-0.56377688,-0.54226943,1.7295966,-0.61178125,-0.56377688,-0.54226943,1.7310841,-0.61178125,-0.56377688,-0.54119509,1.7328712,-0.61178125,-0.56377688,-0.54226943,1.7316729,-0.61178125,-0.56377688,-0.54226943,1.7324477,-0.61178125,-0.56485122,-0.54334377,1.724855,-0.61179158,-0.56485122,-0.54550278,1.72282,-0.61180191,-0.56377688,-0.54119509,1.730454,-0.61178125,-0.56377688,-0.54226943,1.7356191,-0.61178125,-0.56377688,-0.54119509,1.7355261,-0.61178125,-0.56377688,-0.54334377,1.7343588,-0.61179158,-0.56377688,-0.54226943,1.7359186,-0.61178125,-0.56377688,-0.54441811,1.7343588,-0.61179158,-0.56377688,-0.54119509,1.7347617,-0.61179158,-0.56377688,-0.54226943,1.7333567,-0.61178125,-0.56377688,-0.54226943,1.7307122,-0.61178125,-0.56485122,-0.54226943,1.7290491,-0.61178125,-0.56485122,-0.54441811,1.7283673,-0.61179158,-0.56485122,-0.54550278,1.724979,-0.61179158,-0.56485122,-0.54119509,1.7265595,-0.61178125,-0.56485122,-0.54226943,1.7277165,-0.61178125,-0.56485122,-0.54226943,1.7273446,-0.61179158,-0.56485122,-0.54226943,1.725981,-0.61178125,-0.56485122,-0.54550278,1.7258984,-0.61179158,-0.56485122,-0.54119509,1.7252785,-0.61179158,-0.56485122,-0.54334377,1.7258054,-0.61179158,-0.56485122,-0.54334377,1.7250203,-0.61178125,-0.56485122,-0.54441811,1.7229749,-0.61179158,-0.56485122,-0.54119509,1.7233158,-0.61179158,-0.56485122,-0.54441811,1.7224791,-0.61179158,-0.56485122,-0.54334377,1.7217043,-0.61178125,-0.56485122,-0.54334377,1.7221175,-0.61178125,-0.56485122,-0.54441811,1.7223241,-0.61179158,-0.56485122,-0.54226943,1.7199482,-0.61178125,-0.56485122,-0.54226943,1.7235947,-0.61179158,-0.56485122,-0.54226943,1.724762,-0.61178125,-0.56485122,-0.54441811,1.7255781,-0.61179158,-0.56485122,-0.54226943,1.7259087,-0.61179158,-0.56485122,-0.54334377,1.7266421,-0.61179158,-0.56485122,-0.54226943,1.7255161,-0.61178125,-0.56485122,-0.54550278,1.7263322,-0.61180191,-0.56485122,-0.54226943,1.7283466,-0.61179158,-0.56485122,-0.54334377,1.7286255,-0.61178125,-0.56485122,-0.54226943,1.7279024,-0.61178125,-0.56485122,-0.54441811,1.7291317,-0.61180191,-0.56485122,-0.54119509,1.7274892,-0.61179158,-0.56485122,-0.54226943,1.727014,-0.61179158,-0.56485122,-0.54226943,1.7261669,-0.61179158,-0.56485122,-0.54441811,1.7273756,-0.61179158,-0.56485122,-0.54226943,1.7267764,-0.61178125,-0.56485122,-0.54226943,1.727985,-0.61179158,-0.56485122,-0.54226943,1.7264149,-0.61178125,-0.56485122,-0.54550278,1.7267558,-0.61180191,-0.56485122,-0.54226943,1.7267144,-0.61178125,-0.56485122,-0.54226943,1.7266215,-0.61178125,-0.56485122,-0.54334377,1.7256194,-0.61178125,-0.56485122,-0.54441811,1.7280574,-0.61179158,-0.56485122,-0.54334377,1.7252062,-0.61178125,-0.56485122,-0.54226943,1.7261669,-0.61178125,-0.56485122,-0.54441811,1.7177685,-0.61179158,-0.56592556,-0.54441811,1.7183676,-0.61180191,-0.56592556,-0.54334377,1.7171797,-0.61179158,-0.56485122,-0.54334377,1.7295242,-0.61179158,-0.56485122,-0.54441811,1.7293693,-0.61179158,-0.56485122,-0.54226943,1.72814,-0.61178125,-0.56485122,-0.54334377,1.7283776,-0.61178125,-0.56485122,-0.54441811,1.7285945,-0.61179158,-0.56485122,-0.54119509,1.7265285,-0.61179158,-0.56485122,-0.54226943,1.7272309,-0.61179158,-0.56485122,-0.54441811,1.7276338,-0.61179158,-0.56485122,-0.54550278,1.7276028,-0.61179158,-0.56485122,-0.54226943,1.7283776,-0.61178125,-0.56485122,-0.54119509,1.7278921,-0.61178125,-0.56485122,-0.54334377,1.7283156,-0.61179158,-0.56485122,-0.54226943,1.7279747,-0.61178125,-0.56485122,-0.54226943,1.7282536,-0.61178125,-0.56485122,-0.54441811,1.7283363,-0.61179158,-0.56485122,-0.54226943,1.7279024,-0.61178125,-0.56485122,-0.54334377,1.7284292,-0.61178125,-0.56485122,-0.54441811,1.7264562,-0.61179158,-0.56485122,-0.54119509,1.7284189,-0.61178125,-0.56485122,-0.54119509,1.7267248,-0.61178125,-0.56485122,-0.54334377,1.7277475,-0.61179158,-0.56485122,-0.54334377,1.7280367,-0.61179158,-0.56485122,-0.54334377,1.7283363,-0.61179158,-0.56485122,-0.54334377,1.7286049,-0.61178125,-0.56485122,-0.54441811,1.7285842,-0.61179158,-0.56485122,-0.54334377,1.719442,-0.61179158,-0.56485122,-0.54226943,1.7226857,-0.61178125,-0.56377688,-0.54334377,1.7307535,-0.61179158,-0.56485122,-0.54226943,1.7208779,-0.61179158,-0.56485122,-0.54334377,1.7199792,-0.61179158,-0.56377688,-0.54441811,1.7319312,-0.61179158,-0.56377688,-0.54334377,1.7317039,-0.61178125,-0.56377688,-0.54226943,1.7329849,-0.61178125,-0.56485122,-0.54441811,1.7307949,-0.61180191,-0.56377688,-0.54334377,1.7317452,-0.61178125,-0.56377688,-0.54226943,1.7296482,-0.61178125,-0.56485122,-0.54334377,1.7296482,-0.61180191,-0.56485122,-0.54119509,1.7283259,-0.61178125,-0.56485122,-0.54441811,1.7283053,-0.61179158,-0.56377688,-0.54119509,1.7286565,-0.61178125,-0.56485122,-0.54334377,1.7297825,-0.61178125,-0.56485122,-0.54441811,1.7300924,-0.61179158,-0.56485122,-0.54226943,1.7285842,-0.61178125,-0.56485122,-0.54334377,1.7288425,-0.61178125,-0.56485122,-0.54550278,1.7276235,-0.61180191,-0.56485122,-0.54334377,1.7273033,-0.61178125,-0.56485122,-0.54226943,1.7279541,-0.61179158,-0.56485122,-0.54119509,1.7269934,-0.61179158,-0.56485122,-0.54226943,1.7270863,-0.61179158,-0.56485122,-0.54441811,1.7270863,-0.61179158,-0.56485122,-0.54226943,1.7241112,-0.61178125,-0.56485122,-0.54334377,1.7169731,-0.61179158,-0.56485122,-0.54550278,1.7177995,-0.61179158,-0.56485122,-0.54334377,1.7279024,-0.61179158,-0.56485122,-0.54334377,1.7270657,-0.61179158,-0.56485122,-0.54550278,1.7273239,-0.61180191,-0.56485122,-0.54334377,1.7267454,-0.61179158,-0.56485122,-0.54334377,1.7265078,-0.61179158,-0.56485122,-0.54119509,1.7264768,-0.61178125,-0.56485122,-0.54226943,1.7275099,-0.61178125,-0.56485122,-0.54441811,1.7279747,-0.61179158,-0.56485122,-0.54226943,1.7260223,-0.61178125,-0.56485122,-0.54334377,1.726952,-0.61179158,-0.56485122,-0.54550278,1.7274995,-0.61180191,-0.56485122,-0.54334377,1.7274892,-0.61179158,-0.56485122,-0.54334377,1.7250719,-0.61179158,-0.56485122,-0.54119509,1.7273446,-0.61178125,-0.56485122,-0.54226943,1.7281503,-0.61178125,-0.56377688,-0.54441811,1.7296999,-0.61179158,-0.56485122,-0.54226943,1.7308672,-0.61178125,-0.56485122,-0.54226943,1.7311358,-0.61178125,-0.56485122,-0.54334377,1.7274479,-0.61179158,-0.56485122,-0.54226943,1.730361,-0.61178125,-0.56485122,-0.54334377,1.7293073,-0.61179158,-0.56485122,-0.54226943,1.7295759,-0.61178125,-0.56485122,-0.54334377,1.7286668,-0.61179158,-0.56485122,-0.54441811,1.7272826,-0.61179158,-0.56485122,-0.54334377,1.7287495,-0.61179158,-0.56485122,-0.54334377,1.7277268,-0.61179158,-0.56485122,-0.54119509,1.7265388,-0.61178125,-0.56485122,-0.54226943,1.7265182,-0.61178125,-0.56485122,-0.54441811,1.7259707,-0.61179158,-0.56485122,-0.54334377,1.7244934,-0.61179158,-0.56485122,-0.54334377,1.7245141,-0.61179158,-0.56377688,-0.54119509,1.729297,-0.61178125,-0.56485122,-0.54226943,1.7291317,-0.61178125,-0.56485122,-0.54550278,1.7267971,-0.61180191,-0.56485122,-0.54334377,1.726983,-0.61179158,-0.56485122,-0.54334377,1.7276338,-0.61179158,-0.56485122,-0.54226943,1.7208676,-0.61178125,-0.56485122,-0.54334377,1.7220245,-0.61179158,-0.56485122,-0.54550278,1.7234501,-0.61180191,-0.56485122,-0.54441811,1.7198242,-0.61179158,-0.56485122,-0.54441811,1.7240492,-0.61179158,-0.56485122,-0.54119509,1.7252579,-0.61178125,-0.56485122,-0.54226943,1.727076,-0.61178125,-0.56485122,-0.54550278,1.7271483,-0.61180191,-0.56485122,-0.54334377,1.7287495,-0.61179158,-0.56485122,-0.54334377,1.7277681,-0.61179158,-0.56485122,-0.54226943,1.7279747,-0.61178125,-0.56485122,-0.54226943,1.7273859,-0.61178125,-0.56485122,-0.54226943,1.7266318,-0.61178125,-0.56485122,-0.54226943,1.7261256,-0.61178125,-0.56485122,-0.54441811,1.7254335,-0.61179158,-0.56485122,-0.54334377,1.7280677,-0.61179158,-0.56592556,-0.54334377,1.7167045,-0.61179158,-0.56485122,-0.54226943,1.7186672,-0.61178125,-0.56485122,-0.54334377,1.7173966,-0.61179158,-0.56485122,-0.54441811,1.7266421,-0.61179158,-0.56485122,-0.54226943,1.7249273,-0.61178125,-0.56485122,-0.54550278,1.7238323,-0.61180191,-0.56485122,-0.54334377,1.7246484,-0.61179158,-0.56485122,-0.54441811,1.7260017,-0.61179158,-0.56485122,-0.54226943,1.7254955,-0.61178125,-0.56485122,-0.54334377,1.7272826,-0.61179158,-0.56485122,-0.54441811,1.7256917,-0.61179158,-0.56485122,-0.54226943,1.7273962,-0.61178125,-0.56592556,-0.57238192,1.7271793,-0.61188455,-0.56592556,-0.57238192,1.728233,-0.61188455,-0.56592556,-0.57238192,1.727107,-0.61188455,-0.56592556,-0.57238192,1.7307432,-0.61188455,-0.56592556,-0.57238192,1.7295449,-0.61188455,-0.56592556,-0.57238192,1.729111,-0.61188455,-0.56592556,-0.57238192,1.7288115,-0.61188455,-0.56592556,-0.57238192,1.7277681,-0.61188455,-0.56592556,-0.57238192,1.7288425,-0.61188455,-0.56592556,-0.57238192,1.7187602,-0.61188455,-0.56592556,-0.57238192,1.719256,-0.61188455,-0.56592556,-0.57238192,1.721446,-0.61188455,-0.56592556,-0.57238192,1.7210535,-0.61188455,-0.56592556,-0.57238192,1.720537,-0.61188455,-0.56592556,-0.57238192,1.7200618,-0.61188455,-0.56592556,-0.57238192,1.7186362,-0.61188455,-0.5669999,-0.57238192,1.7188842,-0.61189488,-0.56592556,-0.57345626,1.7186052,-0.61189488,-0.5669999,-0.57238192,1.7166115,-0.61189488,-0.5669999,-0.57345626,1.7153409,-0.61189488,-0.5669999,-0.57345626,1.7155372,-0.61189488,-0.5669999,-0.57238192,1.7169627,-0.61189488,-0.5669999,-0.57238192,1.7162603,-0.61189488,-0.5669999,-0.57238192,1.7164462,-0.61189488,-0.5669999,-0.57345626,1.7157438,-0.61189488,-0.5669999,-0.57238192,1.7174276,-0.61189488,-0.5669999,-0.57345626,1.7167975,-0.61189488,-0.56592556,-0.57345626,1.7205163,-0.61189488,-0.56592556,-0.57238192,1.7244521,-0.61188455,-0.56592556,-0.57238192,1.7241319,-0.61188455,-0.56592556,-0.57238192,1.7265905,-0.61188455,-0.56592556,-0.57238192,1.7276751,-0.61188455,-0.56592556,-0.57238192,1.7271586,-0.61188455,-0.56592556,-0.57238192,1.7277888,-0.61188455,-0.56592556,-0.57238192,1.7244211,-0.61188455,-0.56592556,-0.57238192,1.726074,-0.61188455,-0.56485122,-0.54226943,1.7234398,-0.61178125,-0.56485122,-0.54334377,1.7243901,-0.61179158,-0.56485122,-0.54226943,1.7251752,-0.61178125,-0.56592556,-0.54441811,1.7158884,-0.61179158,-0.56592556,-0.54441811,1.7157231,-0.61179158,-0.56592556,-0.54441811,1.7136158,-0.61179158,-0.5669999,-0.54441811,1.6993085,-0.61179158,-0.5669999,-0.54226943,1.7015708,-0.61178125,-0.5669999,-0.54334377,1.6992052,-0.61179158,-0.56592556,-0.54334377,1.7098349,-0.61179158,-0.56592556,-0.54226943,1.7104651,-0.61178125,-0.56592556,-0.54441811,1.7092254,-0.61179158,-0.56592556,-0.54334377,1.7083164,-0.61179158,-0.56592556,-0.54334377,1.7152066,-0.61179158,-0.56592556,-0.54334377,1.7165599,-0.61179158,-0.56592556,-0.54334377,1.7156198,-0.61179158,-0.56592556,-0.54550278,1.7137191,-0.61180191,-0.56592556,-0.54226943,1.712903,-0.61178125,-0.56592556,-0.54334377,1.7147418,-0.61179158,-0.56592556,-0.54441811,1.7162913,-0.61179158,-0.56592556,-0.54226943,1.7164152,-0.61178125,-0.56592556,-0.54334377,1.7169937,-0.61179158,-0.56592556,-0.54334377,1.7170351,-0.61179158,-0.56592556,-0.54441811,1.716095,-0.61179158,-0.56592556,-0.54550278,1.7083887,-0.61179158,-0.56592556,-0.54226943,1.7104547,-0.61178125,-0.56592556,-0.54441811,1.7109299,-0.61179158,-0.56592556,-0.54334377,1.7111778,-0.61179158,-0.56592556,-0.54441811,1.7114877,-0.61179158,-0.56592556,-0.54334377,1.7100415,-0.61179158,-0.56592556,-0.54550278,1.710496,-0.61179158,-0.56592556,-0.54226943,1.7111055,-0.61178125,-0.56592556,-0.54334377,1.7086883,-0.61179158,-0.5669999,-0.54441811,1.7068908,-0.61179158,-0.56592556,-0.54334377,1.7112708,-0.61179158,-0.56592556,-0.54441811,1.710713,-0.61179158,-0.5669999,-0.54550278,1.705176,-0.61180191,-0.5669999,-0.54334377,1.7054343,-0.61179158,-0.5669999,-0.54441811,1.7055169,-0.61179158,-0.5669999,-0.54441811,1.7041636,-0.61179158,-0.5669999,-0.54441811,1.7027587,-0.61179158,-0.5669999,-0.54550278,1.7048454,-0.61180191,-0.56592556,-0.54226943,1.7036471,-0.61178125,-0.56592556,-0.54226943,1.7036471,-0.61178125,-0.56592556,-0.54226943,1.7036471,-0.61178125,-0.56592556,-0.54226943,1.7036471,-0.61178125,-0.56592556,-0.54226943,1.7036471,-0.61178125,-0.56592556,-0.54226943,1.7036471,-0.61178125,-0.56592556,-0.54226943,1.7036471,-0.61178125:6
-0.54016483,-0.58008942,1.7295203,-0.6175408,-0.53911498,-0.57903957,1.7365765,-0.61753071,-0.53805503,-0.57903957,1.7394535,-0.61753071,-0.53911498,-0.57903957,1.7351027,-0.61753071,-0.53911498,-0.57903957,1.7348099,-0.61753071,-0.53911498,-0.57903957,1.7359506,-0.61753071,-0.53911498,-0.57903957,1.7370711,-0.61753071,-0.53911498,-0.57903957,1.7357083,-0.61753071,-0.54016483,-0.57903957,1.7275013,-0.61753071,-0.54016483,-0.57903957,1.7290761,-0.61753071,-0.54016483,-0.57903957,1.7288641,-0.61753071,-0.54016483,-0.57903957,1.7307417,-0.61753071,-0.54016483,-0.57903957,1.7303581,-0.61753071,-0.54016483,-0.57378022,1.7301159,-0.61752061,-0.54016483,-0.57587992,1.7321651,-0.61753071,-0.53911498,-0.57587992,1.7347998,-0.61753071,-0.53911498,-0.57587992,1.7344465,-0.61753071,-0.53911498,-0.57587992,1.7335784,-0.61752061,-0.54016483,-0.57587992,1.7316906,-0.61753071,-0.53911498,-0.57587992,1.7354661,-0.61753071,-0.53911498,-0.57587992,1.73908,-0.61753071,-0.53805503,-0.57587992,1.7432188,-0.61752061,-0.53805503,-0.57587992,1.7420983,-0.61752061,-0.53805503,-0.57587992,1.7442081,-0.61752061,-0.53700518,-0.57587992,1.7444907,-0.61752061,-0.53700518,-0.57483007,1.7478725,-0.61752061,-0.53700518,-0.57587992,1.7477009,-0.61752061,-0.53700518,-0.57903957,1.7491949,-0.61753071,-0.53700518,-0.57903957,1.7490838,-0.61753071,-0.53700518,-0.57903957,1.747186,-0.61753071,-0.53805503,-0.57903957,1.7452277,-0.61753071,-0.53700518,-0.57903957,1.7508201,-0.61753071,-0.53700518,-0.57903957,1.7497097,-0.61753071,-0.53700518,-0.57903957,1.7501135,-0.61753071,-0.53700518,-0.57903957,1.7481854,-0.61753071,-0.53805503,-0.57903957,1.7425727,-0.61753071,-0.53700518,-0.57903957,1.7456415,-0.61753071,-0.53805503,-0.57903957,1.7394131,-0.61753071,-0.53805503,-0.57903957,1.7409778,-0.61753071,-0.53911498,-0.57903957,1.7351733,-0.61753071,-0.53911498,-0.57903957,1.7396554,-0.61753071,-0.53805503,-0.57903957,1.7451166,-0.61753071,-0.53700518,-0.57903957,1.7446321,-0.61753071,-0.53805503,-0.57903957,1.7429664,-0.61753071,-0.53805503,-0.57903957,1.7437639,-0.61753071,-0.53805503,-0.57903957,1.7404327,-0.61753071,-0.53805503,-0.57903957,1.742169,-0.61753071,-0.53805503,-0.57903957,1.741957,-0.61753071,-0.53805503,-0.57903957,1.7423103,-0.61753071,-0.53805503,-0.57903957,1.7435418,-0.61753071,-0.53911498,-0.57903957,1.7351329,-0.61753071,-0.53911498,-0.57903957,1.735032,-0.61753071,-0.53911498,-0.57903957,1.7347796,-0.61753071,-0.53911498,-0.57903957,1.7358194,-0.61753071,-0.53911498,-0.57903957,1.7340124,-0.61753071,-0.53911498,-0.57483007,1.7360617,-0.61752061,-0.53805503,-0.57483007,1.7405437,-0.61752061,-0.53805503,-0.57483007,1.744945,-0.61752061,-0.53805503,-0.57483007,1.7411494,-0.61752061,-0.53700518,-0.57378022,1.7453791,-0.61752061,-0.53805503,-0.57483007,1.7427242,-0.61752061,-0.53805503,-0.57378022,1.7426838,-0.61752061,-0.53911498,-0.57483007,1.7379494,-0.61752061,-0.53911498,-0.57483007,1.7390497,-0.61752061,-0.53911498,-0.57483007,1.7383229,-0.61752061,-0.53805503,-0.57797962,1.7398371,-0.61753071,-0.53805503,-0.57903957,1.7451267,-0.61753071,-0.53700518,-0.57903957,1.7469639,-0.61753071,-0.53805503,-0.57903957,1.7456617,-0.61753071,-0.53805503,-0.57903957,1.7450056,-0.61753071,-0.53805503,-0.57903957,1.7429967,-0.61753071,-0.53805503,-0.57903957,1.7395847,-0.61753071,-0.53700518,-0.57903957,1.7461059,-0.61753071,-0.53700518,-0.57903957,1.7464996,-0.61753071,-0.53700518,-0.57903957,1.7473274,-0.61753071,-0.53805503,-0.57903957,1.7417854,-0.61753071,-0.53911498,-0.57903957,1.7399683,-0.61753071,-0.53911498,-0.57903957,1.7403519,-0.61753071,-0.53911498,-0.57903957,1.7392516,-0.61753071,-0.53805503,-0.57903957,1.74228,-0.61753071,-0.53700518,-0.57903957,1.7480239,-0.61753071,-0.53700518,-0.57903957,1.7478321,-0.61753071,-0.53805503,-0.57903957,1.7435217,-0.61753071,-0.53805503,-0.57903957,1.7422699,-0.61753071,-0.53805503,-0.57903957,1.744309,-0.61753071,-0.53805503,-0.57903957,1.7445614,-0.61753071,-0.53805503,-0.57903957,1.7447734,-0.61753071,-0.53805503,-0.57903957,1.7425627,-0.61753071,-0.53805503,-0.57903957,1.7416037,-0.61753071,-0.53805503,-0.57903957,1.7438346,-0.61753071,-0.53911498,-0.57903957,1.737061,-0.61753071,-0.53911498,-0.57903957,1.738121,-0.61753071,-0.53911498,-0.57903957,1.7385349,-0.61753071,-0.53911498,-0.57903957,1.7402106,-0.61753071,-0.54121468,-0.58008942,1.726936,-0.6175408,-0.54226453,-0.58008942,1.7193145,-0.6175408,-0.54226453,-0.58008942,1.7200212,-0.6175408,-0.54121468,-0.58008942,1.7226155,-0.6175408,-0.54226453,-0.58008942,1.7183656,-0.6175408,-0.54226453,-0.58008942,1.721394,-0.6175408,-0.54121468,-0.57903957,1.727461,-0.6175408,-0.54226453,-0.58008942,1.7198697,-0.6175408,-0.54226453,-0.58008942,1.7204552,-0.6175408,-0.54226453,-0.58008942,1.7186887,-0.6175408,-0.54121468,-0.58008942,1.7233928,-0.6175408,-0.54121468,-0.58008942,1.7248363,-0.6175408,-0.54016483,-0.57903957,1.7278547,-0.61753071,-0.54016483,-0.57903957,1.7293991,-0.61753071,-0.54016483,-0.58008942,1.7282484,-0.6175408,-0.54121468,-0.58008942,1.7249676,-0.6175408,-0.54226453,-0.58008942,1.7199303,-0.6175408,-0.54121468,-0.58008942,1.7215455,-0.6175408,-0.54226453,-0.57483007,1.7147214,-0.61753071,-0.54121468,-0.57587992,1.7247657,-0.61753071,-0.54016483,-0.57378022,1.7317209,-0.61752061,-0.54016483,-0.57378022,1.7328919,-0.61752061,-0.54016483,-0.57587992,1.7339922,-0.61753071,-0.54016483,-0.57483007,1.733437,-0.61753071,-0.54016483,-0.57483007,1.7332452,-0.61753071,-0.54016483,-0.57483007,1.7309638,-0.61753071,-0.54016483,-0.57378022,1.7331342,-0.61752061,-0.54016483,-0.57483007,1.7330433,-0.61753071,-0.54016483,-0.57587992,1.7330534,-0.61753071,-0.53911498,-0.57587992,1.7358396,-0.61753071,-0.53911498,-0.57587992,1.7373639,-0.61753071,-0.53911498,-0.56327162,1.7357083,-0.61750042,-0.53805503,-0.56327162,1.74228,-0.61749033,-0.53700518,-0.56327162,1.7439052,-0.61749033,-0.53805503,-0.56327162,1.7396554,-0.61749033,-0.53805503,-0.56327162,1.7386863,-0.61749033,-0.53805503,-0.56327162,1.7398472,-0.61749033,-0.53805503,-0.56327162,1.7427746,-0.61749033,-0.53805503,-0.56327162,1.7423809,-0.61749033,-0.53805503,-0.56327162,1.7406245,-0.61749033,-0.53805503,-0.56327162,1.7425526,-0.61749033,-0.53805503,-0.56327162,1.7412201,-0.61749033,-0.53805503,-0.56327162,1.7401601,-0.61749033,-0.53805503,-0.56327162,1.7389185,-0.61749033,-0.53805503,-0.56327162,1.7389487,-0.61749033,-0.53911498,-0.56327162,1.7362837,-0.61750042,-0.54016483,-0.56327162,1.7335582,-0.61750042,-0.53911498,-0.56327162,1.7373639,-0.61750042,-0.53805503,-0.56327162,1.7400995,-0.61749033,-0.53911498,-0.56327162,1.7387469,-0.61750042,-0.53911498,-0.56327162,1.7372528,-0.61750042,-0.53911498,-0.56327162,1.7371519,-0.61750042,-0.53911498,-0.56327162,1.7367481,-0.61750042,-0.53805503,-0.56327162,1.7398068,-0.61749033,-0.53805503,-0.56327162,1.7408869,-0.61749033,-0.53805503,-0.56327162,1.7406749,-0.61749033,-0.53805503,-0.56327162,1.7424617,-0.61749033,-0.53805503,-0.56327162,1.7413412,-0.61749033,-0.54016483,-0.56327162,1.7302875,-0.61750042,-0.54016483,-0.56327162,1.7317512,-0.61750042,-0.54016483,-0.56327162,1.726714,-0.61750042,-0.54121468,-0.56327162,1.7249878,-0.61750042,-0.54121468,-0.56327162,1.7239177,-0.61750042,-0.54226453,-0.56432148,1.7151656,-0.61751052,-0.54226453,-0.56432148,1.7181032,-0.61751052,-0.54226453,-0.56432148,1.714994,-0.61751052,-0.54331438,-0.56432148,1.7125713,-0.61751052,-0.54331438,-0.56432148,1.712753,-0.61751052,-0.54331438,-0.56432148,1.7111277,-0.61751052,-0.54226453,-0.56432148,1.7168413,-0.61751052,-0.54226453,-0.56432148,1.7152363,-0.61751052,-0.54226453,-0.56432148,1.717558,-0.61751052,-0.54226453,-0.56432148,1.7163669,-0.61751052,-0.54226453,-0.56432148,1.7169827,-0.61751052,-0.54226453,-0.56432148,1.7157814,-0.61751052,-0.54226453,-0.56432148,1.7155189,-0.61751052,-0.54121468,-0.56432148,1.7218382,-0.61750042,-0.54121468,-0.56432148,1.7222521,-0.61750042,-0.54226453,-0.56432148,1.7210104,-0.61751052,-0.54016483,-0.56327162,1.7283493,-0.61750042,-0.54016483,-0.56327162,1.7284401,-0.61750042,-0.54016483,-0.56327162,1.7295809,-0.61750042,-0.54016483,-0.56432148,1.7279354,-0.61750042,-0.54121468,-0.56432148,1.7216868,-0.61750042,-0.54226453,-0.56432148,1.7198596,-0.61751052,-0.53911498,-0.56327162,1.7369803,-0.61750042,-0.53911498,-0.56327162,1.7404024,-0.61750042,-0.53911498,-0.56327162,1.7365967,-0.61750042,-0.53911498,-0.56327162,1.7387166,-0.61750042,-0.53911498,-0.56327162,1.7387771,-0.61750042,-0.53911498,-0.56327162,1.7388478,-0.61750042,-0.53805503,-0.56327162,1.7399077,-0.61749033,-0.53911498,-0.56327162,1.7355771,-0.61750042,-0.54016483,-0.56327162,1.7314484,-0.61750042,-0.53911498,-0.56327162,1.7351632,-0.61750042,-0.54016483,-0.56327162,1.7303682,-0.61750042,-0.54016483,-0.56327162,1.7302774,-0.61750042,-0.54121468,-0.56327162,1.7267543,-0.61750042,-0.54016483,-0.56327162,1.7307417,-0.61750042,-0.54016483,-0.56327162,1.7305499,-0.61750042,-0.54016483,-0.56327162,1.7333664,-0.61750042,-0.54016483,-0.56327162,1.7331241,-0.61750042,-0.53911498,-0.56327162,1.7393122,-0.61750042,-0.54016483,-0.56327162,1.733003,-0.61750042,-0.54016483,-0.56327162,1.7328919,-0.61750042,-0.54016483,-0.56327162,1.7325487,-0.61750042,-0.53911498,-0.56327162,1.7342749,-0.61750042,-0.54016483,-0.56327162,1.7318925,-0.61750042,-0.54016483,-0.56327162,1.7310042,-0.61750042,-0.54016483,-0.56327162,1.7291367,-0.61750042,-0.54016483,-0.56327162,1.7323872,-0.61750042,-0.54121468,-0.56327162,1.7271278,-0.61750042,-0.54121468,-0.56432148,1.7251695,-0.61751052,-0.54121468,-0.56432148,1.7255632,-0.61751052,-0.54121468,-0.56432148,1.7249575,-0.61751052,-0.54121468,-0.56327162,1.7280162,-0.61750042,-0.54121468,-0.56327162,1.7271783,-0.61750042,-0.54016483,-0.56327162,1.7331039,-0.61750042,-0.54016483,-0.56327162,1.7330736,-0.61750042,-0.54016483,-0.56327162,1.7319935,-0.61750042,-0.54121468,-0.56432148,1.7228679,-0.61750042,-0.54121468,-0.56327162,1.7266534,-0.61750042,-0.54121468,-0.56327162,1.7272894,-0.61750042,-0.54016483,-0.56327162,1.7273196,-0.61750042,-0.54121468,-0.56327162,1.7259871,-0.61750042,-0.54016483,-0.56327162,1.7276326,-0.61750042,-0.54016483,-0.56327162,1.7274912,-0.61750042,-0.54121468,-0.56327162,1.7248868,-0.61750042,-0.54121468,-0.56327162,1.7269259,-0.61750042,-0.54121468,-0.56327162,1.7260679,-0.61750042,-0.54016483,-0.56327162,1.7273297,-0.61750042,-0.54121468,-0.56432148,1.7259569,-0.61751052,-0.54121468,-0.56327162,1.727673,-0.61750042,-0.54121468,-0.56432148,1.7239985,-0.61750042,-0.54121468,-0.56432148,1.720435,-0.61750042,-0.54226453,-0.56748112,1.7187997,-0.61752061,-0.54121468,-0.57587992,1.723837,-0.61753071,-0.54016483,-0.57587992,1.7272187,-0.61753071,-0.54016483,-0.57587992,1.7284906,-0.61753071,-0.54016483,-0.57587992,1.7283089,-0.61753071,-0.54016483,-0.57587992,1.7278244,-0.61753071,-0.54121468,-0.57587992,1.7260174,-0.61753071,-0.54016483,-0.57587992,1.7286118,-0.61753071,-0.54121468,-0.57587992,1.7244023,-0.61753071,-0.54121468,-0.57587992,1.7211215,-0.61753071,-0.54226453,-0.57587992,1.7212224,-0.61753071,-0.54121468,-0.57587992,1.7219997,-0.61753071,-0.54121468,-0.57587992,1.7255127,-0.61753071,-0.54121468,-0.57587992,1.7223631,-0.61753071,-0.54226453,-0.57587992,1.7167505,-0.61753071,-0.54226453,-0.57587992,1.7183858,-0.61753071,-0.54226453,-0.57587992,1.7179013,-0.61753071,-0.54121468,-0.57587992,1.7226256,-0.61753071,-0.54121468,-0.57587992,1.7241398,-0.61753071,-0.54121468,-0.57587992,1.7260275,-0.61753071,-0.54016483,-0.57587992,1.7278042,-0.61753071,-0.54016483,-0.57587992,1.7318623,-0.61753071,-0.54016483,-0.57587992,1.7333866,-0.61753071,-0.54016483,-0.57587992,1.7326597,-0.61753071,-0.54016483,-0.57587992,1.7315796,-0.61753071,-0.54016483,-0.57587992,1.7335885,-0.61753071,-0.54016483,-0.57587992,1.7349512,-0.61753071,-0.54016483,-0.57587992,1.7332553,-0.61753071,-0.54016483,-0.57587992,1.7344465,-0.61753071,-0.54016483,-0.57587992,1.7332856,-0.61753071,-0.53911498,-0.57587992,1.7351834,-0.61753071,-0.53911498,-0.57587992,1.7363443,-0.61753071,-0.54016483,-0.57587992,1.73269,-0.61753071,-0.54016483,-0.57587992,1.730873,-0.61753071,-0.54016483,-0.57587992,1.7308225,-0.61753071,-0.54016483,-0.57587992,1.7315594,-0.61753071,-0.53911498,-0.57587992,1.7343859,-0.61753071,-0.54016483,-0.57903957,1.7312061,-0.61753071,-0.54016483,-0.57903957,1.7322156,-0.61753071,-0.53911498,-0.57903957,1.733225,-0.61753071,-0.54016483,-0.58008942,1.7301563,-0.6175408,-0.54121468,-0.58008942,1.7277537,-0.6175408,-0.54016483,-0.58008942,1.7279657,-0.6175408,-0.54121468,-0.58008942,1.7279657,-0.6175408,-0.54121468,-0.57903957,1.7301966,-0.61753071,-0.54121468,-0.57903957,1.7280364,-0.61753071,-0.54016483,-0.57903957,1.7271985,-0.61753071,-0.54016483,-0.57903957,1.7287733,-0.61753071,-0.54016483,-0.57903957,1.7275518,-0.61753071,-0.54121468,-0.58008942,1.7253209,-0.6175408,-0.54016483,-0.57903957,1.7273903,-0.61753071,-0.54016483,-0.57903957,1.7300351,-0.61753071,-0.54016483,-0.57903957,1.7324578,-0.61753071,-0.54016483,-0.57903957,1.7299544,-0.61753071,-0.54016483,-0.58008942,1.7300755,-0.6175408,-0.54016483,-0.57903957,1.7305399,-0.61753071,-0.54016483,-0.57903957,1.7306509,-0.61753071,-0.54016483,-0.57903957,1.7302875,-0.61753071,-0.54016483,-0.58008942,1.730338,-0.6175408,-0.53911498,-0.57903957,1.7335077,-0.61753071,-0.54016483,-0.57903957,1.7329626,-0.61753071,-0.54016483,-0.57903957,1.7320036,-0.61753071,-0.54016483,-0.57903957,1.7313171,-0.61753071,-0.54016483,-0.57903957,1.7344364,-0.61753071,-0.54016483,-0.58008942,1.7322055,-0.6175408,-0.53911498,-0.57903957,1.735143,-0.61753071,-0.54016483,-0.58008942,1.7271682,-0.6175408,-0.54016483,-0.58008942,1.727249,-0.6175408,-0.54121468,-0.58008942,1.7261991,-0.6175408,-0.54016483,-0.57903957,1.7285007,-0.6175408,-0.54016483,-0.57903957,1.7329525,-0.6175408,-0.54016483,-0.57903957,1.7314787,-0.6175408,-0.54016483,-0.57903957,1.7329222,-0.61753071,-0.54016483,-0.57903957,1.7315493,-0.61753071,-0.54016483,-0.58008942,1.7298332,-0.61753071,-0.54121468,-0.57903957,1.7262496,-0.6175408,-0.54121468,-0.56327162,1.7265222,-0.61751052,-0.54016483,-0.56432148,1.7289247,-0.61750042,-0.54121468,-0.57587992,1.7263203,-0.61753071,-0.54121468,-0.57587992,1.7261083,-0.61753071,-0.54016483,-0.57587992,1.7273095,-0.61753071,-0.54121468,-0.57587992,1.725442,-0.61753071,-0.54016483,-0.57587992,1.7287632,-0.61753071,-0.54121468,-0.57587992,1.7260477,-0.61753071,-0.54016483,-0.57587992,1.7299947,-0.61753071,-0.54016483,-0.57587992,1.7303178,-0.61753071,-0.54016483,-0.57587992,1.7307316,-0.61753071,-0.54016483,-0.57587992,1.7296818,-0.61753071,-0.54016483,-0.57587992,1.7323266,-0.61753071,-0.54121468,-0.57587992,1.7248262,-0.61753071,-0.54121468,-0.57587992,1.7235341,-0.61753071,-0.54016483,-0.57587992,1.7284401,-0.61753071,-0.54121468,-0.57587992,1.7236452,-0.61753071,-0.54121468,-0.58008942,1.7232111,-0.6175408,-0.54226453,-0.58008942,1.7196477,-0.6175408,-0.54121468,-0.58008942,1.7214647,-0.6175408,-0.54226453,-0.58008942,1.7156703,-0.6175408,-0.54226453,-0.58008942,1.7167707,-0.6175408,-0.54226453,-0.58008942,1.7191126,-0.6175408,-0.54226453,-0.58008942,1.7156401,-0.6175408,-0.54226453,-0.58008942,1.7166394,-0.6175408,-0.54331438,-0.58008942,1.7088867,-0.6175509,-0.54226453,-0.58008942,1.7178912,-0.6175408,-0.54331438,-0.58008942,1.7126217,-0.6175509,-0.54331438,-0.58008942,1.7135101,-0.6175509,-0.54226453,-0.58008942,1.7189915,-0.6175408,-0.54226453,-0.58008942,1.7201726,-0.6175408,-0.54226453,-0.58008942,1.7207985,-0.6175408,-0.54226453,-0.58008942,1.7175681,-0.6175408,-0.54121468,-0.58008942,1.7234635,-0.6175408,-0.54121468,-0.58008942,1.7259871,-0.6175408,-0.54121468,-0.58008942,1.7231606,-0.6175408,-0.54226453,-0.58008942,1.7210609,-0.6175408,-0.54121468,-0.58008942,1.7247556,-0.6175408,-0.54016483,-0.57903957,1.730338,-0.61753071,-0.54016483,-0.57903957,1.7322055,-0.61753071,-0.54016483,-0.57903957,1.7295102,-0.61753071,-0.54016483,-0.57903957,1.7319228,-0.61753071,-0.54016483,-0.57903957,1.7304389,-0.61753071,-0.54016483,-0.57903957,1.7301159,-0.61753071,-0.54016483,-0.58008942,1.730025,-0.6175408,-0.54016483,-0.57903957,1.7312364,-0.61753071,-0.54016483,-0.58008942,1.7298837,-0.6175408,-0.54121468,-0.58008942,1.72629,-0.6175408,-0.54121468,-0.58008942,1.7257651,-0.6175408,-0.54121468,-0.58008942,1.7216868,-0.6175408,-0.54121468,-0.58008942,1.7228376,-0.6175408,-0.54121468,-0.58008942,1.7219694,-0.6175408,-0.54121468,-0.57903957,1.7250483,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408,-0.54121468,-0.58008942,1.7226761,-0.6175408:6
-0.69376888,-0.45324608,1.6964589,-0.72363679,-0.69270908,-0.45641528,1.6989657,-0.72365717,-0.69376888,-0.45535549,1.6990778,-0.72365717,-0.69376888,-0.45219648,1.6999032,-0.72364698,-0.69481848,-0.45430588,1.6994344,-0.72366736,-0.69481848,-0.45430588,1.6994344,-0.72366736,-0.69481848,-0.45535549,1.6995669,-0.72367755,-0.69165948,-0.45535549,1.7008407,-0.72366736,-0.69270908,-0.45430588,1.6990778,-0.72365717,-0.69165948,-0.45324608,1.699944,-0.72364698,-0.69270908,-0.45430588,1.7034596,-0.72366736,-0.67900306,-0.28657275,1.7027259,-0.72291327,-0.67794327,-0.30450776,1.7012585,-0.72298461,-0.67900306,-0.28446334,1.7006063,-0.7228827,-0.68005267,-0.28446334,1.699516,-0.72290308,-0.67583386,-0.28129415,1.7060684,-0.7228827,-0.67689366,-0.28446334,1.7062722,-0.72291327,-0.67794327,-0.28235394,1.7054977,-0.72289289,-0.67689366,-0.28446334,1.705569,-0.72290308,-0.67478426,-0.28024454,1.7091662,-0.7228827,-0.67689366,-0.28446334,1.7067613,-0.72289289,-0.67689366,-0.28235394,1.7068734,-0.72289289,-0.67583386,-0.28129415,1.705192,-0.72287251,-0.67689366,-0.28446334,1.7042137,-0.72289289,-0.67689366,-0.28551295,1.7040405,-0.72289289,-0.67689366,-0.28340355,1.7044277,-0.7228827,-0.67794327,-0.28446334,1.7045704,-0.72289289,-0.67689366,-0.28340355,1.7044685,-0.72289289,-0.67372446,-0.28024454,1.7061805,-0.7228827,-0.67583386,-0.28129415,1.7062824,-0.72289289,-0.67794327,-0.28446334,1.7039284,-0.72290308,-0.67794327,-0.27707534,1.7031947,-0.72285213,-0.67794327,-0.28551295,1.702196,-0.72290308,-0.67794327,-0.28657275,1.7025527,-0.72291327,-0.67794327,-0.28340355,1.701982,-0.72289289,-0.68005267,-0.28446334,1.7002497,-0.72290308,-0.67794327,-0.28235394,1.7029603,-0.72289289,-0.67794327,-0.28446334,1.7032252,-0.72289289,-0.67794327,-0.28024454,1.7020534,-0.72287251,-0.67689366,-0.27813514,1.7047742,-0.72286232,-0.67689366,-0.28129415,1.7057117,-0.72289289,-0.68322187,-0.28340355,1.6911089,-0.7228827,-0.67794327,-0.28235394,1.7009324,-0.7228827,-0.67794327,-0.28024454,1.7006675,-0.72287251,-0.67900306,-0.28024454,1.7006165,-0.72287251,-0.67689366,-0.28340355,1.7024406,-0.7228827,-0.67900306,-0.27707534,1.7021451,-0.72285213,-0.67900306,-0.28235394,1.7014419,-0.7228827,-0.67794327,-0.28024454,1.7016967,-0.72287251,-0.68111247,-0.28024454,1.696143,-0.72286232,-0.68322187,-0.28446334,1.6946246,-0.7228827,-0.68322187,-0.28340355,1.6942985,-0.7228827,-0.68216207,-0.28235394,1.6943698,-0.72287251,-0.68216207,-0.28129415,1.6940132,-0.72286232,-0.68216207,-0.28235394,1.6947367,-0.72287251,-0.68322187,-0.28129415,1.6957048,-0.72287251,-0.68322187,-0.28446334,1.6921076,-0.72287251,-0.68322187,-0.28340355,1.693524,-0.7228827,-0.68216207,-0.28235394,1.6940641,-0.72287251,-0.68322187,-0.28024454,1.6937075,-0.72286232,-0.68216207,-0.28340355,1.6942068,-0.7228827,-0.68216207,-0.28024454,1.69545,-0.72286232,-0.68111247,-0.28235394,1.6954908,-0.72287251,-0.68216207,-0.28235394,1.6966525,-0.7228827,-0.68216207,-0.28340355,1.6965506,-0.7228827,-0.68111247,-0.28551295,1.6958678,-0.72289289,-0.67794327,-0.28129415,1.7015438,-0.7228827,-0.67794327,-0.28129415,1.7012585,-0.72287251,-0.68005267,-0.28446334,1.6989147,-0.72289289,-0.67794327,-0.28024454,1.7022368,-0.72287251,-0.67794327,-0.28235394,1.7006063,-0.72287251,-0.67794327,-0.28129415,1.7026546,-0.72287251,-0.67794327,-0.28235394,1.7009732,-0.7228827,-0.67689366,-0.28129415,1.7022877,-0.7228827,-0.67689366,-0.28551295,1.7021451,-0.72289289,-0.67794327,-0.28235394,1.7013808,-0.72289289,-0.67794327,-0.28235394,1.7020941,-0.7228827,-0.67689366,-0.28340355,1.7033068,-0.72289289,-0.67794327,-0.28235394,1.6996484,-0.72287251,-0.67900306,-0.28024454,1.7021858,-0.72286232,-0.67900306,-0.28235394,1.6995873,-0.72287251,-0.67794327,-0.28129415,1.7014317,-0.72287251,-0.67794327,-0.28024454,1.7025833,-0.72286232,-0.67794327,-0.28235394,1.701982,-0.7228827,-0.68005267,-0.27918474,1.6999847,-0.72287251,-0.67900306,-0.27918474,1.6999134,-0.72287251,-0.68005267,-0.28024454,1.7001376,-0.72287251,-0.67900306,-0.27918474,1.7031233,-0.72287251,-0.67794327,-0.27602574,1.7036431,-0.72285213,-0.67900306,-0.28129415,1.7023081,-0.7228827,-0.67794327,-0.28024454,1.7021043,-0.72287251,-0.67900306,-0.28129415,1.7026852,-0.7228827,-0.67900306,-0.28024454,1.7016865,-0.72287251,-0.67689366,-0.28024454,1.705569,-0.7228827,-0.67794327,-0.27813514,1.702838,-0.72286232,-0.67794327,-0.28129415,1.7027565,-0.72287251,-0.67794327,-0.27918474,1.7033475,-0.72287251,-0.67583386,-0.27707534,1.7062518,-0.72286232,-0.67583386,-0.27602574,1.7065575,-0.72284194,-0.67583386,-0.28024454,1.7065269,-0.72287251,-0.67689366,-0.27813514,1.7063843,-0.72286232,-0.67689366,-0.28024454,1.7045296,-0.72287251,-0.67478426,-0.27918474,1.7079943,-0.72286232,-0.67794327,-0.27918474,1.7048149,-0.72287251,-0.67794327,-0.27602574,1.704978,-0.72285213,-0.67689366,-0.27496594,1.7046825,-0.72284194,-0.67583386,-0.27918474,1.7079943,-0.72287251,-0.67583386,-0.27918474,1.7054977,-0.72286232,-0.67583386,-0.27918474,1.7063129,-0.72287251,-0.67583386,-0.27707534,1.7054671,-0.72286232,-0.67583386,-0.27707534,1.7074237,-0.72286232,-0.67583386,-0.27918474,1.7072402,-0.72287251,-0.67583386,-0.27602574,1.7051716,-0.72285213,-0.67478426,-0.27602574,1.7072504,-0.72285213,-0.67583386,-0.27918474,1.7078007,-0.72287251,-0.67689366,-0.27918474,1.7060887,-0.72287251,-0.67689366,-0.27707534,1.7049168,-0.72286232,-0.67583386,-0.27813514,1.705569,-0.72287251,-0.67689366,-0.27813514,1.7045602,-0.72286232,-0.67689366,-0.27707534,1.7065575,-0.72286232,-0.67478426,-0.28129415,1.706904,-0.7228827,-0.67689366,-0.28235394,1.7052022,-0.7228827,-0.67689366,-0.27813514,1.7064658,-0.72287251,-0.67689366,-0.27707534,1.7061703,-0.72287251,-0.67478426,-0.27918474,1.7078109,-0.72287251,-0.67583386,-0.27813514,1.7063843,-0.72287251,-0.67689366,-0.27391633,1.7064046,-0.72285213,-0.67583386,-0.28129415,1.706476,-0.7228827,-0.67583386,-0.27707534,1.7069651,-0.72286232,-0.67689366,-0.27707534,1.7066594,-0.72286232,-0.67689366,-0.27918474,1.7070262,-0.72287251,-0.67689366,-0.27918474,1.7060174,-0.72287251,-0.67689366,-0.27602574,1.7069651,-0.72285213,-0.67583386,-0.27813514,1.7086465,-0.72286232,-0.67794327,-0.27813514,1.7071995,-0.7228827,-0.67689366,-0.27918474,1.7070161,-0.7228827,-0.67900306,-0.27813514,1.7058238,-0.7228827,-0.67689366,-0.27707534,1.709156,-0.72287251,-0.67794327,-0.27918474,1.7076886,-0.7228827,-0.67794327,-0.27918474,1.7063333,-0.7228827,-0.67689366,-0.28024454,1.7066186,-0.7228827,-0.67900306,-0.27918474,1.705355,-0.7228827,-0.67794327,-0.27813514,1.7059155,-0.72287251,-0.67794327,-0.27918474,1.7046825,-0.7228827,-0.67794327,-0.28024454,1.7044685,-0.7228827,-0.67689366,-0.27496594,1.7069447,-0.72286232,-0.67794327,-0.28024454,1.703959,-0.7228827,-0.67689366,-0.28024454,1.7073931,-0.7228827,-0.67900306,-0.27707534,1.703317,-0.72286232,-0.67794327,-0.28024454,1.7049372,-0.7228827,-0.67794327,-0.28129415,1.7051716,-0.7228827,-0.67583386,-0.27813514,1.706853,-0.72286232,-0.67794327,-0.27813514,1.7032864,-0.72285213,-0.67583386,-0.28235394,1.7072402,-0.7228827,-0.67794327,-0.28024454,1.7046723,-0.72287251,-0.67900306,-0.28024454,1.7024304,-0.72287251,-0.67689366,-0.28129415,1.7044073,-0.72287251,-0.67900306,-0.27918474,1.7015133,-0.72286232,-0.67900306,-0.28024454,1.7015438,-0.72287251,-0.67900306,-0.27918474,1.7017069,-0.72286232,-0.67794327,-0.28340355,1.7029705,-0.7228827,-0.67583386,-0.27918474,1.7051716,-0.72286232,-0.67689366,-0.28129415,1.7037144,-0.72287251,-0.67794327,-0.27813514,1.7029297,-0.72287251,-0.67689366,-0.28024454,1.7050799,-0.72287251,-0.67794327,-0.28235394,1.7026954,-0.7228827,-0.68111247,-0.28235394,1.6988026,-0.72287251,-0.67794327,-0.27813514,1.7039182,-0.72286232,-0.67689366,-0.28024454,1.7060887,-0.72287251,-0.67794327,-0.27918474,1.7031845,-0.72286232,-0.67689366,-0.27918474,1.7060072,-0.72286232,-0.67794327,-0.27813514,1.7044583,-0.72285213,-0.68005267,-0.27813514,1.700749,-0.72285213,-0.67794327,-0.28024454,1.7058136,-0.72286232,-0.67794327,-0.28024454,1.7057932,-0.72287251,-0.67583386,-0.27813514,1.7077701,-0.72286232,-0.67689366,-0.27918474,1.7065779,-0.72286232,-0.67689366,-0.27813514,1.7062416,-0.72285213,-0.67900306,-0.28024454,1.701177,-0.72286232,-0.68322187,-0.28235394,1.7025629,-0.72286232,-0.68216207,-0.28024454,1.7045908,-0.72285213,-0.68111247,-0.28024454,1.706048,-0.72285213,-0.68111247,-0.28024454,1.7078007,-0.72285213,-0.68111247,-0.28024454,1.7069345,-0.72285213,-0.68111247,-0.27813514,1.7064352,-0.72284194,-0.68111247,-0.28024454,1.7063333,-0.72285213,-0.68111247,-0.28129415,1.7055486,-0.72285213,-0.68005267,-0.28024454,1.7068326,-0.72284194,-0.68216207,-0.28024454,1.7048659,-0.72285213,-0.68322187,-0.28129415,1.7031233,-0.72286232,-0.68322187,-0.28024454,1.7034494,-0.72284194,-0.68216207,-0.28129415,1.7039284,-0.72285213,-0.68427147,-0.28024454,1.7023998,-0.72285213,-0.68533127,-0.28024454,1.7013298,-0.72286232,-0.68533127,-0.28129415,1.699037,-0.72285213,-0.68427147,-0.27918474,1.7009732,-0.72284194,-0.68322187,-0.28340355,1.7023285,-0.72287251,-0.68427147,-0.27918474,1.7019107,-0.72285213,-0.68322187,-0.28235394,1.7018597,-0.72286232,-0.68427147,-0.28129415,1.7023489,-0.72286232,-0.68322187,-0.28340355,1.7014012,-0.72286232,-0.68533127,-0.28129415,1.6994752,-0.72286232,-0.68638088,-0.27918474,1.6979059,-0.72285213,-0.68638088,-0.28129415,1.6978957,-0.72286232,-0.68533127,-0.27918474,1.6997911,-0.72285213,-0.68533127,-0.27918474,1.7008305,-0.72285213,-0.68427147,-0.28024454,1.702461,-0.72286232,-0.68533127,-0.27813514,1.7005146,-0.72285213,-0.68533127,-0.27813514,1.69973,-0.72283175,-0.68533127,-0.27918474,1.7000662,-0.72284194,-0.68427147,-0.28024454,1.7008407,-0.72286232,-0.68427147,-0.27918474,1.7018801,-0.72285213,-0.68427147,-0.28024454,1.7015744,-0.72286232,-0.68533127,-0.28235394,1.7011057,-0.72286232,-0.68216207,-0.27602574,1.7045092,-0.72282156,-0.68005267,-0.27813514,1.7096248,-0.72285213,-0.67689366,-0.27602574,1.7090032,-0.72286232,-0.67583386,-0.27496594,1.710277,-0.72285213,-0.67478426,-0.27813514,1.7110616,-0.72287251,-0.67372446,-0.27813514,1.7103891,-0.72286232,-0.67478426,-0.27918474,1.7123354,-0.7228827,-0.67372446,-0.27707534,1.7119788,-0.72286232,-0.67266467,-0.27602574,1.7137213,-0.72286232,-0.67266467,-0.27496594,1.7140168,-0.72286232,-0.67266467,-0.27813514,1.7127532,-0.72287251,-0.67478426,-0.27496594,1.7102872,-0.72286232,-0.67478426,-0.27813514,1.7105521,-0.7228827,-0.67583386,-0.27813514,1.709635,-0.72287251,-0.67478426,-0.27918474,1.7099407,-0.72287251,-0.67372446,-0.27813514,1.7115813,-0.72287251,-0.67266467,-0.27707534,1.7151683,-0.72287251,-0.67478426,-0.27813514,1.7110616,-0.72287251,-0.67372446,-0.27918474,1.711887,-0.7228827,-0.67478426,-0.27813514,1.7113877,-0.72287251,-0.67478426,-0.27707534,1.7108476,-0.72287251,-0.66633646,-0.062935361,1.7109393,-0.72168024,-0.66422706,-0.085089179,1.7105012,-0.72176176,-0.66633646,-0.049219152,1.7108476,-0.7216191,-0.66211766,-0.075591774,1.70937,-0.72170062,-0.66211766,-0.07137297,1.7117648,-0.72168024,-0.66106805,-0.059766163,1.709635,-0.72160891,-0.66317745,-0.066094369,1.7099509,-0.72165986,-0.65895865,-0.053437957,1.7111941,-0.72157834,-0.66000825,-0.066094369,1.712101,-0.72165986,-0.66000825,-0.060825959,1.7102566,-0.7216191,-0.66106805,-0.065044763,1.7108578,-0.72165986,-0.65578945,-0.024955933,1.7119686,-0.72141529,-0.65684925,-0.019677332,1.7130589,-0.7214051,-0.65473984,-0.018627727,1.7152295,-0.7214051,-0.65684925,-0.015458528,1.7111228,-0.72136434,-0.66422706,-0.051328554,1.6963366,-0.72153758,-0.66422706,-0.069263568,1.6981199,-0.72164967,-0.66422706,-0.07137297,1.7013808,-0.72168024,-0.66528685,-0.068203771,1.6994242,-0.72164967,-0.66317745,-0.029174737,1.6981505,-0.72142548,-0.66422706,-0.045000348,1.6976715,-0.72152739,-0.66422706,-0.043940552,1.6983746,-0.72152739,-0.66317745,-0.037612346,1.6986396,-0.72148663,-0.66317745,-0.033393541,1.6986498,-0.72145605,-0.66528685,-0.058716557,1.6984664,-0.72160891,-0.66106805,-0.066094369,1.7127532,-0.72167005,-0.66000825,-0.072422576,1.7149849,-0.72170062,-0.66106805,-0.07137297,1.7121622,-0.72169043,-0.65895865,-0.058716557,1.7132729,-0.7216191,-0.65789885,-0.048159356,1.7122743,-0.72155796,-0.66106805,-0.046049954,1.7048761,-0.72152739,-0.65578945,-0.04183115,1.7145467,-0.72152739,-0.66422706,-0.062935361,1.6979466,-0.7216191,-0.66528685,-0.059766163,1.6956946,-0.72158853,-0.66633646,-0.053437957,1.6977225,-0.72156815,-0.66528685,-0.049219152,1.6955519,-0.72152739,-0.66844586,-0.062935361,1.6897128,-0.72159872,-0.66739626,-0.067154166,1.697111,-0.72163948,-0.66739626,-0.11251141,1.6970295,-0.72187386,-0.69270908,-0.44797767,1.6992001,-0.72360622,-0.69376888,-0.45219648,1.6984664,-0.72365717,-0.69376888,-0.45219648,1.697753,-0.72365717,-0.69587828,-0.45430588,1.6920057,-0.72366736,-0.69059968,-0.44902728,1.7102464,-0.72364698,-0.69059968,-0.44902728,1.7101445,-0.72363679,-0.68955007,-0.44902728,1.7103279,-0.72363679,-0.68955007,-0.44902728,1.7122845,-0.72364698,-0.69270908,-0.44902728,1.7048048,-0.72364698,-0.69059968,-0.44797767,1.7073931,-0.7236266,-0.69165948,-0.44902728,1.7059155,-0.72364698,-0.69165948,-0.45008708,1.7046315,-0.72364698,-0.69165948,-0.45008708,1.7062008,-0.72364698,-0.69165948,-0.45008708,1.7064658,-0.72364698,-0.69587828,-0.45219648,1.6915573,-0.72364698,-0.69587828,-0.45008708,1.6916083,-0.7236266,-0.69587828,-0.45008708,1.6913841,-0.72363679,-0.69587828,-0.45113668,1.6919649,-0.72364698,-0.69059968,-0.44586827,1.7081879,-0.7236266,-0.69270908,-0.44797767,1.7059359,-0.72364698,-0.69270908,-0.44691788,1.7061601,-0.72363679,-0.69270908,-0.44691788,1.7063537,-0.72363679,-0.69165948,-0.44902728,1.7067919,-0.72364698,-0.69165948,-0.44797767,1.7075663,-0.72363679,-0.69165948,-0.44691788,1.7081268,-0.72363679,-0.69059968,-0.44586827,1.7100222,-0.72363679,-0.69059968,-0.44691788,1.71044,-0.7236266,-0.69059968,-0.44269907,1.7101139,-0.72361641,-0.69165948,-0.44691788,1.7105623,-0.72363679,-0.69059968,-0.44586827,1.7113979,-0.7236266,-0.69059968,-0.44691788,1.7116934,-0.72363679,-0.68955007,-0.44058967,1.7142206,-0.72359603,-0.69059968,-0.44375887,1.712101,-0.7236266,-0.69165948,-0.44586827,1.7124068,-0.72363679,-0.69270908,-0.44375887,1.7098694,-0.7236266,-0.69165948,-0.44269907,1.7120705,-0.72361641,-0.69165948,-0.44586827,1.7114692,-0.72363679,-0.69059968,-0.44480848,1.7117036,-0.72361641,-0.69059968,-0.44480848,1.713171,-0.7236266,-0.69059968,-0.44480848,1.7122437,-0.7236266,-0.68744067,-0.44058967,1.7209565,-0.72360622,-0.68849028,-0.44164947,1.7194075,-0.72360622,-0.68744067,-0.44269907,1.7203858,-0.72360622,-0.68638088,-0.44058967,1.7208546,-0.72359603,-0.68744067,-0.44375887,1.7201005,-0.72361641,-0.68955007,-0.44375887,1.7141187,-0.72361641,-0.68849028,-0.44586827,1.7145569,-0.72361641,-0.68955007,-0.44480848,1.7135073,-0.72361641,-0.68955007,-0.44375887,1.7157288,-0.72361641,-0.68849028,-0.44164947,1.7169109,-0.72359603,-0.69270908,-0.44375887,1.7128042,-0.7236266,-0.68955007,-0.44375887,1.7149238,-0.72361641,-0.69059968,-0.44480848,1.7144856,-0.7236266,-0.69059968,-0.44586827,1.7148626,-0.72364698,-0.68955007,-0.44375887,1.7162893,-0.7236266,-0.68744067,-0.44164947,1.7199782,-0.72361641,-0.68849028,-0.44269907,1.7197642,-0.7236266,-0.68849028,-0.44269907,1.721252,-0.72363679,-0.68744067,-0.44058967,1.7229945,-0.72361641,-0.68849028,-0.44269907,1.7208036,-0.7236266,-0.69059968,-0.44375887,1.7179197,-0.72364698,-0.68955007,-0.44269907,1.716381,-0.7236266,-0.68955007,-0.44164947,1.7177057,-0.7236266,-0.69059968,-0.44375887,1.7167275,-0.72363679,-0.69059968,-0.44375887,1.7164625,-0.72363679,-0.69059968,-0.44269907,1.7178178,-0.72363679,-0.68955007,-0.44058967,1.7177974,-0.72361641,-0.69059968,-0.44269907,1.7159632,-0.7236266,-0.68955007,-0.44164947,1.7170536,-0.72361641,-0.68955007,-0.44164947,1.7202533,-0.72361641,-0.68744067,-0.44164947,1.7218634,-0.72361641,-0.68744067,-0.44164947,1.7213131,-0.7236266,-0.68849028,-0.44375887,1.7195604,-0.7236266,-0.69376888,-0.44480848,1.7169109,-0.72364698,-0.69059968,-0.44269907,1.7142818,-0.7236266,-0.68955007,-0.44691788,1.7183375,-0.72365717,-0.69692789,-0.44480848,1.7114489,-0.72361641,-0.69165948,-0.44375887,1.7103687,-0.72364698,-0.69165948,-0.44269907,1.7103483,-0.72363679,-0.69165948,-0.44480848,1.7116221,-0.72365717,-0.69270908,-0.44902728,1.7104298,-0.72367755,-0.69165948,-0.44480848,1.7117648,-0.72365717,-0.68955007,-0.44480848,1.7177567,-0.72365717,-0.69059968,-0.44480848,1.7136602,-0.72365717,-0.68955007,-0.44269907,1.7146792,-0.72363679,-0.68955007,-0.44269907,1.7146792,-0.72363679,-0.68955007,-0.44269907,1.7146792,-0.72363679,-0.68955007,-0.44269907,1.7146792,-0.72363679,-0.68955007,-0.44269907,1.7146792,-0.72363679,-0.68955007,-0.44269907,1.7146792,-0.72363679,-0.68955007,-0.44269907,1.7146792,-0.72363679:6
-0.61212965,-0.49542006,1.7319475,-0.69865018,-0.61212965,-0.49542006,1.7311724,-0.69865018,-0.61212965,-0.49542006,1.7317059,-0.69865018,-0.62254836,-0.4005847,1.7284242,-0.69823746,-0.62359526,-0.39850096,1.7308502,-0.69823746,-0.62359526,-0.4016316,1.7277297,-0.69825759,-0.62359526,-0.40266844,1.7285048,-0.69825759,-0.62359526,-0.40266844,1.7277901,-0.69825759,-0.62359526,-0.4016316,1.7300248,-0.69824753,-0.62254836,-0.4005847,1.7302865,-0.69824753,-0.62254836,-0.4005847,1.7290785,-0.69824753,-0.62359526,-0.4016316,1.7305281,-0.69824753,-0.62359526,-0.39538038,1.7313435,-0.69821733,-0.62359526,-0.39954786,1.7309106,-0.69823746,-0.62254836,-0.4005847,1.7303771,-0.69824753,-0.62359526,-0.39746412,1.7288168,-0.69823746,-0.62359526,-0.39641722,1.7236226,-0.69822739,-0.6246321,-0.40371535,1.7224549,-0.69825759,-0.6246321,-0.39850096,1.7211966,-0.69822739,-0.6246321,-0.39954786,1.7156701,-0.69823746,-0.6246321,-0.40579909,1.7136569,-0.69825759,-0.6246321,-0.4016316,1.7142206,-0.69824753,-0.6246321,-0.4016316,1.7138481,-0.69824753,-0.62359526,-0.40579909,1.7129119,-0.69825759,-0.62359526,-0.40371535,1.7133045,-0.69824753,-0.6246321,-0.40371535,1.7128817,-0.69825759,-0.6246321,-0.39850096,1.7128314,-0.69822739,-0.62359526,-0.40683592,1.7133247,-0.69825759,-0.6246321,-0.39954786,1.7148044,-0.69823746,-0.6246321,-0.4005847,1.7145427,-0.69823746,-0.6246321,-0.40371535,1.7155091,-0.69825759,-0.6246321,-0.4005847,1.7146031,-0.69823746,-0.6246321,-0.4005847,1.7147843,-0.69823746,-0.62359526,-0.40266844,1.7155896,-0.69824753,-0.62359526,-0.40371535,1.7152876,-0.69824753,-0.62359526,-0.40266844,1.7159117,-0.69824753,-0.62359526,-0.39746412,1.7191229,-0.69822739,-0.62254836,-0.39850096,1.7175022,-0.69822739,-0.62254836,-0.40475218,1.7178445,-0.69824753,-0.62254836,-0.4005847,1.7180055,-0.69823746,-0.62359526,-0.39954786,1.7171096,-0.69823746,-0.62359526,-0.4016316,1.7179955,-0.69823746,-0.62254836,-0.39954786,1.7185491,-0.69823746,-0.62359526,-0.4016316,1.7178243,-0.69824753,-0.62359526,-0.39641722,1.719143,-0.69821733,-0.62254836,-0.40371535,1.7173915,-0.69824753,-0.62359526,-0.39850096,1.7170794,-0.69822739,-0.62359526,-0.39850096,1.7166365,-0.69822739,-0.62359526,-0.4005847,1.7171298,-0.69823746,-0.62359526,-0.4005847,1.7174619,-0.69823746,-0.62254836,-0.4005847,1.7175223,-0.69823746,-0.62359526,-0.39538038,1.7176834,-0.69821733,-0.62359526,-0.40266844,1.716415,-0.69824753,-0.62254836,-0.39954786,1.7163949,-0.69822739,-0.62359526,-0.39954786,1.7156601,-0.69823746,-0.62359526,-0.39954786,1.7165358,-0.69822739,-0.62254836,-0.40266844,1.7183579,-0.69824753,-0.62254836,-0.39746412,1.7183377,-0.69822739,-0.62359526,-0.39850096,1.7184686,-0.69822739,-0.62254836,-0.40266844,1.7184283,-0.69824753,-0.62359526,-0.39954786,1.717925,-0.69823746,-0.62359526,-0.4016316,1.7185693,-0.69823746,-0.62359526,-0.39641722,1.7191128,-0.69822739,-0.62254836,-0.40371535,1.7190424,-0.69824753,-0.62359526,-0.39954786,1.7178445,-0.69822739,-0.62359526,-0.39850096,1.7182874,-0.69822739,-0.62254836,-0.4005847,1.7189518,-0.69823746,-0.62254836,-0.4016316,1.7187706,-0.69824753,-0.62254836,-0.39641722,1.71869,-0.69821733,-0.62359526,-0.39746412,1.7173814,-0.69822739,-0.62254836,-0.39954786,1.7178948,-0.69822739,-0.62254836,-0.39850096,1.7167674,-0.69822739,-0.62254836,-0.4016316,1.7167372,-0.69823746,-0.6246321,-0.39746412,1.711553,-0.69821733,-0.62359526,-0.40266844,1.7113718,-0.69824753,-0.62359526,-0.39954786,1.7111403,-0.69822739,-0.62359526,-0.40266844,1.71261,-0.69824753,-0.62359526,-0.39746412,1.713375,-0.69821733,-0.62359526,-0.40475218,1.712469,-0.69824753,-0.6246321,-0.39954786,1.7133448,-0.69823746,-0.62359526,-0.40266844,1.713375,-0.69824753,-0.62359526,-0.39850096,1.7126905,-0.69822739,-0.6246321,-0.40371535,1.7126301,-0.69825759,-0.62359526,-0.4005847,1.7131535,-0.69823746,-0.62359526,-0.40266844,1.7127106,-0.69824753,-0.62359526,-0.39850096,1.7119456,-0.69822739,-0.62359526,-0.40475218,1.7121268,-0.69825759,-0.62359526,-0.4016316,1.7117946,-0.69823746,-0.62254836,-0.4005847,1.7178143,-0.69823746,-0.62359526,-0.39641722,1.7175324,-0.69822739,-0.62359526,-0.40371535,1.718076,-0.69824753,-0.62254836,-0.4005847,1.7173814,-0.69823746,-0.62254836,-0.4016316,1.7174317,-0.69823746,-0.62046462,-0.4005847,1.7174619,-0.69822739,-0.62150145,-0.40579909,1.7161835,-0.69825759,-0.62150145,-0.4005847,1.7163144,-0.69823746,-0.62254836,-0.4016316,1.7151366,-0.69823746,-0.62254836,-0.40266844,1.7116838,-0.69823746,-0.62359526,-0.40579909,1.7098014,-0.69825759,-0.62359526,-0.4005847,1.7141501,-0.69823746,-0.62254836,-0.40266844,1.7140595,-0.69823746,-0.62254836,-0.39954786,1.7130831,-0.69822739,-0.62254836,-0.40475218,1.7149554,-0.69824753,-0.62150145,-0.4005847,1.7211362,-0.69823746,-0.62150145,-0.4016316,1.7226361,-0.69824753,-0.62254836,-0.39746412,1.7215086,-0.69821733,-0.62150145,-0.40371535,1.7211462,-0.69824753,-0.62254836,-0.4005847,1.7216898,-0.69823746,-0.62254836,-0.40266844,1.7212469,-0.69824753,-0.62150145,-0.39850096,1.7224045,-0.69822739,-0.62150145,-0.40371535,1.7218509,-0.69824753,-0.62150145,-0.4016316,1.7234011,-0.69824753,-0.62150145,-0.4005847,1.7228978,-0.69823746,-0.62150145,-0.39850096,1.7245386,-0.69822739,-0.62150145,-0.40266844,1.723834,-0.69824753,-0.62150145,-0.4016316,1.7247701,-0.69824753,-0.62150145,-0.39850096,1.7251426,-0.69822739,-0.62150145,-0.39954786,1.7256761,-0.69823746,-0.62150145,-0.4005847,1.7255855,-0.69823746,-0.62150145,-0.40266844,1.7252332,-0.69824753,-0.62150145,-0.4005847,1.7203409,-0.69823746,-0.62150145,-0.40266844,1.7193645,-0.69824753,-0.62254836,-0.39850096,1.716707,-0.69822739,-0.62046462,-0.40579909,1.7173512,-0.69825759,-0.62254836,-0.4016316,1.7165761,-0.69823746,-0.62254836,-0.40475218,1.7164956,-0.69824753,-0.62254836,-0.4005847,1.7163848,-0.69823746,-0.62254836,-0.40371535,1.7140092,-0.69824753,-0.62359526,-0.40371535,1.7144823,-0.69824753,-0.62359526,-0.39954786,1.7149856,-0.69823746,-0.62254836,-0.40266844,1.7140796,-0.69823746,-0.62150145,-0.39954786,1.7158614,-0.69822739,-0.62254836,-0.40579909,1.7152171,-0.69825759,-0.62254836,-0.4016316,1.7158513,-0.69823746,-0.62254836,-0.40475218,1.7158513,-0.69825759,-0.62254836,-0.39954786,1.7155594,-0.69822739,-0.62254836,-0.40475218,1.7162439,-0.69824753,-0.62254836,-0.40266844,1.7153883,-0.69824753,-0.62254836,-0.39954786,1.7160225,-0.69822739,-0.62254836,-0.4005847,1.715197,-0.69823746,-0.62254836,-0.40371535,1.7148145,-0.69824753,-0.62359526,-0.40475218,1.7147642,-0.69824753,-0.62254836,-0.4005847,1.7168882,-0.69823746,-0.62254836,-0.40266844,1.7185994,-0.69824753,-0.62254836,-0.39954786,1.7177237,-0.69822739,-0.62254836,-0.40266844,1.7186699,-0.69824753,-0.62254836,-0.40266844,1.7187907,-0.69824753,-0.62254836,-0.39850096,1.7194048,-0.69822739,-0.62254836,-0.4005847,1.7204013,-0.69823746,-0.62254836,-0.39746412,1.7210959,-0.69822739,-0.62254836,-0.40475218,1.7201698,-0.69825759,-0.62254836,-0.39954786,1.7201396,-0.69823746,-0.62254836,-0.39746412,1.7201799,-0.69822739,-0.62254836,-0.39954786,1.7208946,-0.69822739,-0.62254836,-0.40266844,1.721408,-0.69824753,-0.62254836,-0.40475218,1.7172103,-0.69825759,-0.62150145,-0.4016316,1.7166264,-0.69823746,-0.62254836,-0.40371535,1.7163546,-0.69824753,-0.62254836,-0.39954786,1.7163043,-0.69822739,-0.62150145,-0.40475218,1.7171398,-0.69824753,-0.62254836,-0.40371535,1.7169284,-0.69824753,-0.62254836,-0.4005847,1.7161433,-0.69822739,-0.62150145,-0.40266844,1.7151467,-0.69823746,-0.62254836,-0.39954786,1.7157406,-0.69822739,-0.62254836,-0.40683592,1.7165761,-0.69825759,-0.62254836,-0.4016316,1.7158513,-0.69823746,-0.62254836,-0.39954786,1.7161131,-0.69822739,-0.62150145,-0.4016316,1.7172304,-0.69823746,-0.62150145,-0.40475218,1.7169385,-0.69824753,-0.62150145,-0.40579909,1.7177841,-0.69825759,-0.62254836,-0.4016316,1.7171096,-0.69823746,-0.62254836,-0.40371535,1.7181364,-0.69824753,-0.62254836,-0.4016316,1.717472,-0.69823746,-0.62150145,-0.40266844,1.7184283,-0.69824753,-0.62150145,-0.40475218,1.7187404,-0.69825759,-0.62254836,-0.4016316,1.716868,-0.69823746,-0.62150145,-0.40266844,1.7222636,-0.69824753,-0.62254836,-0.39850096,1.723683,-0.69823746,-0.62150145,-0.40266844,1.7261392,-0.69824753,-0.62046462,-0.40371535,1.7258674,-0.69824753,-0.62150145,-0.4005847,1.726109,-0.69823746,-0.62046462,-0.40266844,1.7259479,-0.69824753,-0.62150145,-0.39850096,1.7258271,-0.69823746,-0.62150145,-0.4016316,1.7263506,-0.69824753,-0.62150145,-0.40371535,1.7258976,-0.69825759,-0.62150145,-0.4005847,1.7260284,-0.69823746,-0.62150145,-0.4016316,1.7260083,-0.69824753,-0.62046462,-0.39850096,1.7269646,-0.69822739,-0.62150145,-0.40371535,1.726874,-0.69825759,-0.62150145,-0.4016316,1.7263506,-0.69824753,-0.62150145,-0.39954786,1.7274277,-0.69823746,-0.62150145,-0.4016316,1.7273371,-0.69824753,-0.62150145,-0.39746412,1.7270351,-0.69822739,-0.62150145,-0.40266844,1.727176,-0.69824753,-0.62046462,-0.40266844,1.7271055,-0.69824753,-0.62150145,-0.39954786,1.7276894,-0.69823746,-0.62150145,-0.40266844,1.7240957,-0.69824753,-0.62150145,-0.39850096,1.7243675,-0.69822739,-0.62150145,-0.40371535,1.7240353,-0.69824753,-0.62046462,-0.40266844,1.7238843,-0.69824753,-0.62046462,-0.39954786,1.7243474,-0.69823746,-0.62046462,-0.4016316,1.7246997,-0.69823746,-0.61941771,-0.4005847,1.7236125,-0.69822739,-0.62150145,-0.40266844,1.7225153,-0.69824753,-0.62046462,-0.40475218,1.724136,-0.69824753,-0.61941771,-0.4005847,1.7271055,-0.69823746,-0.62046462,-0.40266844,1.7258472,-0.69824753,-0.62046462,-0.39954786,1.7267834,-0.69822739,-0.61941771,-0.40371535,1.7268639,-0.69824753,-0.62046462,-0.40475218,1.7250117,-0.69824753,-0.62046462,-0.4016316,1.7240353,-0.69823746,-0.62046462,-0.40371535,1.7241561,-0.69824753,-0.62046462,-0.39954786,1.7298033,-0.69823746,-0.61941771,-0.40371535,1.7309308,-0.69824753,-0.62046462,-0.40266844,1.7307898,-0.69824753,-0.62046462,-0.4005847,1.7284746,-0.69823746,-0.62150145,-0.4005847,1.7291087,-0.69823746,-0.62046462,-0.39954786,1.7288571,-0.69823746,-0.62046462,-0.4016316,1.7299745,-0.69824753,-0.62046462,-0.40371535,1.7299845,-0.69825759,-0.62046462,-0.39954786,1.7298235,-0.69823746,-0.62046462,-0.39746412,1.7298537,-0.69822739,-0.62150145,-0.39954786,1.7288571,-0.69823746,-0.62046462,-0.39641722,1.7295517,-0.69822739,-0.62046462,-0.40266844,1.7296221,-0.69824753,-0.62150145,-0.4005847,1.7292799,-0.69823746,-0.62046462,-0.39850096,1.7294309,-0.69822739,-0.62046462,-0.4005847,1.7290383,-0.69823746,-0.62046462,-0.39746412,1.7282934,-0.69822739,-0.62046462,-0.4016316,1.730961,-0.69824753,-0.62046462,-0.4016316,1.7284041,-0.69824753,-0.62150145,-0.39954786,1.7283336,-0.69823746,-0.62150145,-0.4016316,1.7289477,-0.69824753,-0.62046462,-0.39850096,1.7287162,-0.69822739,-0.62150145,-0.4005847,1.7278907,-0.69823746,-0.62046462,-0.40475218,1.7277599,-0.69825759,-0.62150145,-0.39954786,1.7279209,-0.69823746,-0.62046462,-0.39746412,1.7283638,-0.69822739,-0.62046462,-0.39954786,1.7279008,-0.69823746,-0.62150145,-0.39746412,1.728686,-0.69822739,-0.62046462,-0.40371535,1.7295315,-0.69824753,-0.62046462,-0.4005847,1.7290081,-0.69823746,-0.62150145,-0.39746412,1.7288772,-0.69822739,-0.62046462,-0.4005847,1.7316857,-0.69823746,-0.62046462,-0.39746412,1.7308704,-0.69822739,-0.62046462,-0.4005847,1.7305583,-0.69823746,-0.62046462,-0.40371535,1.7292295,-0.69824753,-0.62046462,-0.39954786,1.7289578,-0.69823746,-0.61941771,-0.39954786,1.7288068,-0.69822739,-0.61941771,-0.39954786,1.7290383,-0.69822739,-0.62046462,-0.39641722,1.731112,-0.69821733,-0.62046462,-0.4016316,1.731424,-0.69824753,-0.61941771,-0.4016316,1.7327226,-0.69823746,-0.61941771,-0.4005847,1.7324307,-0.69823746,-0.61941771,-0.39746412,1.7339003,-0.69822739,-0.62046462,-0.39954786,1.7339507,-0.69823746,-0.61941771,-0.39641722,1.7337896,-0.69821733,-0.61941771,-0.4005847,1.7349976,-0.69823746,-0.61941771,-0.39641722,1.7338701,-0.69821733,-0.61838088,-0.39954786,1.7334675,-0.69822739,-0.62046462,-0.4005847,1.7318871,-0.69823746,-0.61941771,-0.39746412,1.7323199,-0.69822739,-0.62046462,-0.39850096,1.7266928,-0.69822739,-0.61941771,-0.40475218,1.7250117,-0.69824753,-0.62046462,-0.4016316,1.7246695,-0.69823746,-0.62046462,-0.39954786,1.7239145,-0.69822739,-0.62046462,-0.4016316,1.7245789,-0.69823746,-0.62046462,-0.39850096,1.7254949,-0.69822739,-0.62046462,-0.4016316,1.7249312,-0.69824753,-0.62046462,-0.39746412,1.7250218,-0.69822739,-0.61941771,-0.4005847,1.7258875,-0.69823746,-0.62046462,-0.39746412,1.7257466,-0.69821733,-0.61941771,-0.39954786,1.7248909,-0.69822739,-0.62150145,-0.39641722,1.7263606,-0.69821733,-0.62046462,-0.40266844,1.7254949,-0.69824753,-0.61941771,-0.4016316,1.725968,-0.69823746,-0.62046462,-0.39954786,1.7254043,-0.69822739,-0.61941771,-0.40371535,1.7251829,-0.69824753,-0.61941771,-0.4005847,1.72627,-0.69822739,-0.62150145,-0.4016316,1.7249111,-0.69824753,-0.62046462,-0.40371535,1.7250017,-0.69824753,-0.62046462,-0.4016316,1.7255654,-0.69823746,-0.62046462,-0.39850096,1.7248406,-0.69822739,-0.62046462,-0.4005847,1.7229079,-0.69823746,-0.62046462,-0.39850096,1.7234816,-0.69822739,-0.62046462,-0.40266844,1.7246594,-0.69824753,-0.62046462,-0.40266844,1.7237534,-0.69824753,-0.62046462,-0.4005847,1.7231797,-0.69823746,-0.62046462,-0.39850096,1.7222535,-0.69822739,-0.62046462,-0.39954786,1.7248909,-0.69822739,-0.62150145,-0.39641722,1.7251325,-0.69821733,-0.62150145,-0.40371535,1.7256761,-0.69824753,-0.62046462,-0.4005847,1.7281424,-0.69823746,-0.62046462,-0.39850096,1.7292396,-0.69822739,-0.61941771,-0.4016316,1.7291188,-0.69823746,-0.62046462,-0.39746412,1.7291792,-0.69822739,-0.62046462,-0.39641722,1.7291188,-0.69821733,-0.61941771,-0.40266844,1.7301657,-0.69824753,-0.62046462,-0.39850096,1.7291289,-0.69822739,-0.62046462,-0.39746412,1.7287262,-0.69822739,-0.62046462,-0.4005847,1.7280719,-0.69823746,-0.62046462,-0.39746412,1.7279612,-0.69822739,-0.62046462,-0.4016316,1.7278303,-0.69823746,-0.62046462,-0.40266844,1.7279712,-0.69824753,-0.61941771,-0.39954786,1.7281826,-0.69822739,-0.62150145,-0.39954786,1.7203208,-0.69822739,-0.62046462,-0.4016316,1.7239044,-0.69823746,-0.62046462,-0.39954786,1.7248205,-0.69822739,-0.62046462,-0.4016316,1.7245487,-0.69824753,-0.62046462,-0.40371535,1.7243474,-0.69825759,-0.62046462,-0.4005847,1.7245487,-0.69823746,-0.62046462,-0.4005847,1.7245487,-0.69823746,-0.62150145,-0.39954786,1.7184887,-0.69822739,-0.62150145,-0.40266844,1.7177337,-0.69823746,-0.62150145,-0.4005847,1.7186598,-0.69823746,-0.62046462,-0.40579909,1.7185994,-0.69824753,-0.62254836,-0.4005847,1.7154789,-0.69823746,-0.62254836,-0.40266844,1.7170996,-0.69824753,-0.62150145,-0.4005847,1.7166969,-0.69822739,-0.62150145,-0.40266844,1.7172808,-0.69824753,-0.62150145,-0.4005847,1.7174519,-0.69823746,-0.62150145,-0.40475218,1.7168479,-0.69824753,-0.62150145,-0.40475218,1.7170492,-0.69824753,-0.62150145,-0.4016316,1.7166164,-0.69823746,-0.62150145,-0.39954786,1.7157607,-0.69822739,-0.62150145,-0.40266844,1.7174921,-0.69823746,-0.62150145,-0.39954786,1.7168076,-0.69822739,-0.62150145,-0.40475218,1.7175022,-0.69825759,-0.62150145,-0.40579909,1.7190222,-0.69825759,-0.62150145,-0.40475218,1.7182975,-0.69825759,-0.62150145,-0.4016316,1.7176129,-0.69823746,-0.62150145,-0.39954786,1.7185491,-0.69822739,-0.62150145,-0.40266844,1.7179653,-0.69824753,-0.62150145,-0.39954786,1.7180961,-0.69822739,-0.62150145,-0.40475218,1.7176834,-0.69824753,-0.62150145,-0.40475218,1.7186196,-0.69825759,-0.62150145,-0.39954786,1.7244078,-0.69823746,-0.62150145,-0.39954786,1.7233608,-0.69822739,-0.62150145,-0.40266844,1.720965,-0.69824753,-0.62150145,-0.39954786,1.7224045,-0.69822739,-0.62150145,-0.40371535,1.7213375,-0.69824753,-0.62150145,-0.40475218,1.7231797,-0.69824753,-0.62150145,-0.4016316,1.7205825,-0.69823746,-0.62150145,-0.4005847,1.7203812,-0.69823746,-0.62150145,-0.40266844,1.7201195,-0.69824753,-0.62150145,-0.39954786,1.7199685,-0.69822739,-0.62150145,-0.39746412,1.719737,-0.69822739,-0.62150145,-0.4016316,1.7194048,-0.69823746,-0.62150145,-0.40266844,1.7183478,-0.69823746,-0.62150145,-0.4016316,1.7190524,-0.69823746,-0.62150145,-0.40371535,1.7182371,-0.69824753,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739,-0.62046462,-0.4005847,1.718992,-0.69822739:6
-0.67242787,-0.67242787,1.7286156,-0.67242787,-0.67242787,-0.67242787,1.737582,-0.67242787,-0.67242787,-0.67242787,1.7360176,-0.67242787,-0.67242787,-0.67242787,1.7239435,-0.67242787,-0.67242787,-0.67242787,1.7230301,-0.67242787,-0.67242787,-0.67242787,1.7290671,-0.67242787,-0.67242787,-0.67242787,1.729886,-0.67242787,-0.67242787,-0.67242787,1.7253819,-0.67242787,-0.67242787,-0.67242787,1.7294871,-0.67242787,-0.67242787,-0.67242787,1.7334558,-0.67242787,-0.67242787,-0.67242787,1.7415402,-0.67242787,-0.67242787,-0.67242787,1.7293191,-0.67242787,-0.67242787,-0.67242787,1.7378969,-0.67242787,-0.67242787,-0.67242787,1.7464118,-0.67242787,-0.67242787,-0.67242787,1.7390833,-0.67242787,-0.67242787,-0.67242787,1.7398288,-0.67242787,-0.67242787,-0.67242787,1.7312824,-0.67242787,-0.67242787,-0.67242787,1.7264108,-0.67242787,-0.67242787,-0.67242787,1.7224421,-0.67242787,-0.67242787,-0.67242787,1.7187359,-0.67242787,-0.67242787,-0.67242787,1.7308415,-0.67242787,-0.67242787,-0.67242787,1.7248149,-0.67242787,-0.67242787,-0.67242787,1.7110925,-0.67242787,-0.67242787,-0.67242787,1.7321854,-0.67242787,-0.67242787,-0.67242787,1.7232715,-0.67242787,-0.67242787,-0.67242787,1.7187464,-0.67242787,-0.67242787,-0.67242787,1.73754,-0.67242787,-0.67242787,-0.67242787,1.7297076,-0.67242787,-0.67242787,-0.67242787,1.7320594,-0.67242787,-0.67242787,-0.67242787,1.7316394,-0.67242787,-0.67242787,-0.67242787,1.7203948,-0.67242787,-0.67242787,-0.67242787,1.7306315,-0.67242787,-0.67242787,-0.67242787,1.7221271,-0.67242787,-0.67242787,-0.67242787,1.7244054,-0.67242787,-0.67242787,-0.67242787,1.7285106,-0.67242787,-0.67242787,-0.67242787,1.7118904,-0.67242787,-0.67242787,-0.67242787,1.7313979,-0.67242787,-0.67242787,-0.67242787,1.7324268,-0.67242787,-0.67242787,-0.67242787,1.7206047,-0.67242787,-0.67242787,-0.67242787,1.7269253,-0.67242787,-0.67242787,-0.67242787,1.7272822,-0.67242787,-0.67242787,-0.67242787,1.7198173,-0.67242787,-0.67242787,-0.67242787,1.7320594,-0.67242787,-0.67242787,-0.67242787,1.7233135,-0.67242787,-0.67242787,-0.67242787,1.7271247,-0.67242787,-0.67242787,-0.67242787,1.7220326,-0.67242787,-0.67242787,-0.67242787,1.7147357,-0.67242787,-0.67242787,-0.67242787,1.7296131,-0.67242787,-0.67242787,-0.67242787,1.723681,-0.67242787,-0.67242787,-0.67242787,1.7145047,-0.67242787,-0.67242787,-0.67242787,1.7286996,-0.67242787,-0.67242787,-0.67242787,1.7272087,-0.67242787,-0.67242787,-0.67242787,1.7217177,-0.67242787,-0.67242787,-0.67242787,1.7147252,-0.67242787,-0.67242787,-0.67242787,1.7103995,-0.67242787,-0.67242787,-0.67242787,1.7119219,-0.67242787,-0.67242787,-0.67242787,1.7083942,-0.67242787,-0.67242787,-0.67242787,1.7088456,-0.67242787,-0.67242787,-0.67242787,1.7118694,-0.67242787,-0.67242787,-0.67242787,1.7048139,-0.67242787,-0.67242787,-0.67242787,1.6990709,-0.67242787,-0.67242787,-0.67242787,1.6957426,-0.67242787,-0.67242787,-0.67242787,1.7010657,-0.67242787,-0.67242787,-0.67242787,1.6971285,-0.67242787,-0.67242787,-0.67242787,1.6963306,-0.67242787,-0.67242787,-0.67242787,1.7008347,-0.67242787,-0.67242787,-0.67242787,1.6941992,-0.67242787,-0.67242787,-0.67242787,1.6990079,-0.67242787,-0.67242787,-0.67242787,1.6987034,-0.67242787,-0.67242787,-0.67242787,1.6943987,-0.67242787,-0.67242787,-0.67242787,1.7004567,-0.67242787,-0.67242787,-0.67242787,1.6972335,-0.67242787,-0.67242787,-0.67242787,1.6948817,-0.67242787,-0.67242787,-0.67242787,1.689905,-0.67242787,-0.67242787,-0.67242787,1.6846974,-0.67242787,-0.67242787,-0.67242787,1.6995643,-0.67242787,-0.67242787,-0.67242787,1.6968765,-0.67242787,-0.67242787,-0.67242787,1.6946087,-0.67242787,-0.67242787,-0.67242787,1.7130138,-0.67242787,-0.67242787,-0.67242787,1.7028086,-0.67242787,-0.67242787,-0.67242787,1.7082157,-0.67242787,-0.67242787,-0.67242787,1.7033545,-0.67242787,-0.67242787,-0.67242787,1.7033125,-0.67242787,-0.67242787,-0.67242787,1.7080897,-0.67242787,-0.67242787,-0.67242787,1.7073757,-0.67242787,-0.67242787,-0.67242787,1.7084991,-0.67242787,-0.67242787,-0.67242787,1.7041735,-0.67242787,-0.67242787,-0.67242787,1.7003308,-0.67242787,-0.67242787,-0.67242787,1.703197,-0.67242787,-0.67242787,-0.67242787,1.7128143,-0.67242787,-0.67242787,-0.67242787,1.7139062,-0.67242787,-0.67242787,-0.67242787,1.7098115,-0.67242787,-0.67242787,-0.67242787,1.7092341,-0.67242787,-0.67242787,-0.67242787,1.7088351,-0.67242787,-0.67242787,-0.67242787,1.7054754,-0.67242787,-0.67242787,-0.67242787,1.7017797,-0.67242787,-0.67242787,-0.67242787,1.7062838,-0.67242787,-0.67242787,-0.67242787,1.7057694,-0.67242787,-0.67242787,-0.67242787,1.7078377,-0.67242787,-0.67242787,-0.67242787,1.7122684,-0.67242787,-0.67242787,-0.67242787,1.7069978,-0.67242787,-0.67242787,-0.67242787,1.7097171,-0.67242787,-0.67242787,-0.67242787,1.7043205,-0.67242787,-0.67242787,-0.67242787,1.7143787,-0.67242787,-0.67242787,-0.67242787,1.7113129,-0.67242787,-0.67242787,-0.67242787,1.7132763,-0.67242787,-0.67242787,-0.67242787,1.7114284,-0.67242787,-0.67242787,-0.67242787,1.7148827,-0.67242787,-0.67242787,-0.67242787,1.7155231,-0.67242787,-0.67242787,-0.67242787,1.7075647,-0.67242787,-0.67242787,-0.67242787,1.7037745,-0.67242787,-0.67242787,-0.67242787,1.7128248,-0.67242787,-0.67242787,-0.67242787,1.7127198,-0.67242787,-0.67242787,-0.67242787,1.6946192,-0.67242787,-0.67242787,-0.67242787,1.7072812,-0.67242787,-0.67242787,-0.67242787,1.7072917,-0.67242787,-0.67242787,-0.67242787,1.7019686,-0.67242787,-0.67242787,-0.67242787,1.7011287,-0.67242787,-0.67242787,-0.67242787,1.7056959,-0.67242787,-0.67242787,-0.67242787,1.7000683,-0.67242787,-0.67242787,-0.67242787,1.697139,-0.67242787,-0.67242787,-0.67242787,1.6981889,-0.67242787,-0.67242787,-0.67242787,1.7010867,-0.67242787,-0.67242787,-0.67242787,1.6926033,-0.67242787,-0.67242787,-0.67242787,1.697475,-0.67242787,-0.67242787,-0.67242787,1.6935903,-0.67242787,-0.67242787,-0.67242787,1.7134548,-0.67242787,-0.67242787,-0.67242787,1.7082367,-0.67242787,-0.67242787,-0.67242787,1.7045829,-0.67242787,-0.67242787,-0.67242787,1.710221,-0.67242787,-0.67242787,-0.67242787,1.7160061,-0.67242787,-0.49962136,-0.4365841,1.7102525,-0.67097898,-0.50396803,-0.39418829,1.7105465,-0.67080049,-0.50504945,-0.371363,1.7135073,-0.670706,-0.50504945,-0.36484299,1.7151346,-0.6706745,-0.50504945,-0.38876019,1.7101895,-0.67078999,-0.50396803,-0.39201495,1.7111239,-0.67080049,-0.50070278,-0.38984161,1.7169615,-0.67077949,-0.49852944,-0.38766828,1.7205522,-0.67076899,-0.50070278,-0.39093353,1.7160271,-0.67078999,-0.49962136,-0.38658686,1.7194288,-0.67076899,-0.50287612,-0.39201495,1.7125833,-0.67080049,-0.5017947,-0.38984161,1.7151556,-0.67078999,-0.49852944,-0.38984161,1.7208042,-0.67077949,-0.49744802,-0.38984161,1.7220956,-0.67077949,-0.49635611,-0.38549494,1.7252454,-0.67075849,-0.49200943,-0.38441352,1.7328468,-0.670748,-0.50504945,-0.38876019,1.7112499,-0.67078999,-0.50722279,-0.39093353,1.7079007,-0.67080049,-0.50939613,-0.39310687,1.703659,-0.67081099,-0.49527469,-0.38876019,1.7261588,-0.67077949,-0.49852944,-0.38766828,1.7214867,-0.67076899,-0.50504945,-0.39418829,1.7098325,-0.67081099,-0.49852944,-0.39093353,1.7213817,-0.67078999,-0.49852944,-0.39093353,1.7219486,-0.67077949,-0.5017947,-0.38766828,1.7170455,-0.67077949,-0.50070278,-0.38984161,1.7186414,-0.67077949,-0.50287612,-0.39201495,1.7151346,-0.67080049,-0.49962136,-0.39093353,1.7193973,-0.67078999,-0.50396803,-0.39093353,1.7130138,-0.67080049,-0.5017947,-0.39201495,1.7161426,-0.67080049,-0.49418277,-0.38766828,1.7277757,-0.67076899,-0.49418277,-0.38658686,1.7285106,-0.67075849,-0.5017947,-0.39201495,1.7170875,-0.67080049,-0.49418277,-0.39093353,1.7297285,-0.67077949,-0.49635611,-0.39093353,1.7255919,-0.67077949,-0.49744802,-0.39093353,1.7245524,-0.67077949,-0.49852944,-0.39093353,1.7217911,-0.67078999,-0.4898361,-0.38658686,1.7353141,-0.67075849,-0.49418277,-0.38766828,1.7289201,-0.67076899,-0.5017947,-0.39418829,1.7143367,-0.67081099,-0.5017947,-0.39418829,1.7154181,-0.67081099,-0.50614137,-0.39418829,1.7078692,-0.67081099,-0.50614137,-0.39636162,1.7091291,-0.67082149,-0.51809997,-0.3952802,1.6877842,-0.67083199,-0.51266138,-0.39745354,1.69737,-0.67083199,-0.51156946,-0.3952802,1.6977375,-0.67082149,-0.50722279,-0.39745354,1.7058008,-0.67083199,-0.50722279,-0.3952802,1.7068298,-0.67082149,-0.50504945,-0.39310687,1.7116804,-0.67080049,-0.50722279,-0.3952802,1.7062628,-0.67082149,-0.5017947,-0.39418829,1.7154181,-0.67081099,-0.50504945,-0.3952802,1.710893,-0.67081099,-0.49744802,-0.38876019,1.7247939,-0.67077949,-0.49635611,-0.38876019,1.7269778,-0.67077949,-0.50287612,-0.3952802,1.7169405,-0.67081099,-0.49527469,-0.38876019,1.7285946,-0.67077949,-0.49527469,-0.39201495,1.7275657,-0.67078999,-0.49962136,-0.38984161,1.7224421,-0.67077949,-0.49200943,-0.38984161,1.7335083,-0.67077949,-0.49200943,-0.39310687,1.7324583,-0.67078999,-0.49744802,-0.39418829,1.7256234,-0.67080049,-0.49310135,-0.38658686,1.7313559,-0.67076899,-0.49744802,-0.39201495,1.7260643,-0.67078999,-0.4898361,-0.39201495,1.7362171,-0.67077949,-0.49418277,-0.39201495,1.729907,-0.67078999,-0.49527469,-0.38876019,1.7286891,-0.67077949,-0.49635611,-0.39201495,1.7272822,-0.67078999,-0.49852944,-0.39093353,1.723408,-0.67078999,-0.49418277,-0.39201495,1.7299385,-0.67077949,-0.48658134,-0.38658686,1.7427371,-0.670748,-0.50831471,-0.39745354,1.7069873,-0.67083199,-0.49852944,-0.39093353,1.723513,-0.67078999,-0.49527469,-0.39310687,1.7291091,-0.67078999,-0.49527469,-0.38984161,1.7295816,-0.67077949,-0.49200943,-0.39093353,1.7340437,-0.67077949,-0.49092801,-0.38984161,1.7356396,-0.67076899,-0.49310135,-0.38984161,1.7325528,-0.67076899,-0.49200943,-0.39093353,1.7339912,-0.67077949,-0.49418277,-0.39093353,1.730516,-0.67077949,-0.4898361,-0.39201495,1.7355661,-0.67077949,-0.4898361,-0.38876019,1.736448,-0.67076899,-0.49852944,-0.39418829,1.723072,-0.67080049,-0.49200943,-0.39201495,1.7324478,-0.67077949,-0.49310135,-0.38876019,1.7312509,-0.67077949,-0.49527469,-0.39310687,1.7280382,-0.67078999,-0.49418277,-0.39201495,1.730537,-0.67078999,-0.4898361,-0.39093353,1.737099,-0.67076899,-0.48875468,-0.38876019,1.7389154,-0.67076899,-0.49200943,-0.39418829,1.7323744,-0.67078999,-0.49092801,-0.39201495,1.7345897,-0.67077949,-0.49092801,-0.38876019,1.7352931,-0.67076899,-0.49310135,-0.39310687,1.7317654,-0.67078999,-0.49852944,-0.39201495,1.7231875,-0.67078999,-0.49310135,-0.38984161,1.7323534,-0.67077949,-0.49200943,-0.39093353,1.7332353,-0.67077949,-0.49744802,-0.39418829,1.7250564,-0.67080049,-0.49310135,-0.39201495,1.7316604,-0.67078999,-0.50070278,-0.39310687,1.7202583,-0.67080049,-0.50614137,-0.39636162,1.7111449,-0.67082149,-0.50287612,-0.39636162,1.7159431,-0.67082149,-0.4898361,-0.38876019,1.7367735,-0.67076899,-0.49310135,-0.39418829,1.7311984,-0.67078999,-0.4898361,-0.39310687,1.7360281,-0.67077949,-0.48658134,-0.38984161,1.7407947,-0.67075849,-0.49200943,-0.39201495,1.7329728,-0.67077949,-0.49092801,-0.39093353,1.7359756,-0.67076899,-0.49527469,-0.3952802,1.7287941,-0.67080049,-0.48875468,-0.39093353,1.7375715,-0.67076899,-0.49418277,-0.3952802,1.7297076,-0.67080049,-0.49418277,-0.39418829,1.7282797,-0.67080049,-0.49092801,-0.39093353,1.7353876,-0.67077949,-0.49200943,-0.39201495,1.7324373,-0.67077949,-0.49418277,-0.39310687,1.7297285,-0.67078999,-0.49310135,-0.38984161,1.7324583,-0.67077949,-0.49852944,-0.39745354,1.7216967,-0.67082149,-0.49527469,-0.3952802,1.7271982,-0.67080049,-0.49418277,-0.39093353,1.7295291,-0.67077949,-0.49527469,-0.3952802,1.7284161,-0.67080049,-0.49200943,-0.39310687,1.7326053,-0.67078999,-0.49635611,-0.39093353,1.7268833,-0.67078999,-0.49635611,-0.39418829,1.7255709,-0.67080049,-0.48548942,-0.39201495,1.7427791,-0.67076899,-0.49527469,-0.39201495,1.7285736,-0.67078999,-0.49527469,-0.3952802,1.7293191,-0.67080049,-0.49200943,-0.39310687,1.7335083,-0.67078999,-0.49310135,-0.39093353,1.7328993,-0.67077949,-0.49418277,-0.39310687,1.7306315,-0.67078999,-0.49635611,-0.3952802,1.7268833,-0.67080049,-0.49527469,-0.39310687,1.7281012,-0.67078999,-0.49418277,-0.39636162,1.7282272,-0.67080049,-0.49852944,-0.39636162,1.7235025,-0.67081099,-0.49635611,-0.39310687,1.7270513,-0.67078999,-0.49527469,-0.39418829,1.7286681,-0.67080049,-0.49852944,-0.39636162,1.723513,-0.67081099,-0.49635611,-0.39310687,1.7269988,-0.67080049,-0.49310135,-0.39310687,1.7321749,-0.67078999,-0.49744802,-0.3952802,1.7241745,-0.67080049,-0.49744802,-0.39418829,1.7244474,-0.67080049,-0.49527469,-0.39310687,1.7292456,-0.67078999,-0.49962136,-0.39201495,1.7220851,-0.67080049,-0.50070278,-0.39636162,1.7191978,-0.67082149,-0.49744802,-0.3952802,1.7246574,-0.67080049,-0.5017947,-0.39310687,1.7177909,-0.67081099,-0.49527469,-0.39636162,1.7291511,-0.67080049,-0.49744802,-0.39853496,1.7246784,-0.67082149,-0.49962136,-0.3952802,1.7216232,-0.67081099,-0.49635611,-0.3952802,1.7278072,-0.67080049,-0.49635611,-0.3952802,1.7267888,-0.67080049,-0.49744802,-0.3952802,1.7260328,-0.67080049,-0.49527469,-0.39636162,1.7280172,-0.67081099,-0.5017947,-0.39310687,1.7203108,-0.67080049,-0.49310135,-0.3952802,1.7315659,-0.67080049,-0.49418277,-0.39636162,1.7296341,-0.67080049,-0.49635611,-0.39418829,1.7263478,-0.67080049,-0.49744802,-0.39636162,1.7253399,-0.67081099,-0.49852944,-0.39310687,1.72387,-0.67080049,-0.4898361,-0.39310687,1.7366475,-0.67078999,-0.49744802,-0.39745354,1.7247414,-0.67081099,-0.5017947,-0.39310687,1.7191768,-0.67081099,-0.49092801,-0.39310687,1.7362066,-0.67078999,-0.49200943,-0.38984161,1.7345582,-0.67077949,-0.49962136,-0.39636162,1.7224001,-0.67081099,-0.49418277,-0.39418829,1.7319859,-0.67078999,-0.49310135,-0.39201495,1.7327733,-0.67078999,-0.4898361,-0.39310687,1.7376765,-0.67078999,-0.49310135,-0.39201495,1.7334873,-0.67078999,-0.49418277,-0.3952802,1.7323639,-0.67080049,-0.4898361,-0.39418829,1.7384009,-0.67078999,-0.49744802,-0.39201495,1.7271247,-0.67080049,-0.49418277,-0.39418829,1.7315659,-0.67080049,-0.49418277,-0.3952802,1.7319754,-0.67080049,-0.49527469,-0.3952802,1.7291721,-0.67081099,-0.49418277,-0.3952802,1.7313034,-0.67080049,-0.49200943,-0.39201495,1.7345372,-0.67078999,-0.49418277,-0.39418829,1.7315029,-0.67080049,-0.49200943,-0.39093353,1.7346422,-0.67077949,-0.49527469,-0.3952802,1.7284476,-0.67080049,-0.49200943,-0.39310687,1.7347892,-0.67078999,-0.49092801,-0.39201495,1.7356711,-0.67077949,-0.49635611,-0.39201495,1.7273347,-0.67078999,-0.49744802,-0.3952802,1.7257074,-0.67081099,-0.49418277,-0.39201495,1.7313034,-0.67078999,-0.49527469,-0.39310687,1.7295396,-0.67078999,-0.49527469,-0.39093353,1.7289096,-0.67078999,-0.49200943,-0.39310687,1.7333613,-0.67078999,-0.49310135,-0.39093353,1.7332773,-0.67077949,-0.50396803,-0.39745354,1.7152396,-0.67083199,-0.49744802,-0.3952802,1.7255289,-0.67081099,-0.49744802,-0.39636162,1.7250249,-0.67081099,-0.50396803,-0.39636162,1.7158276,-0.67082149,-0.49852944,-0.39418829,1.72429,-0.67081099,-0.48658134,-0.39093353,1.7415297,-0.67076899,-0.4898361,-0.39093353,1.737246,-0.67076899,-0.4898361,-0.39093353,1.737603,-0.67077949,-0.49200943,-0.38876019,1.7340752,-0.67076899,-0.48658134,-0.39310687,1.7401963,-0.67077949,-0.49418277,-0.39093353,1.7313244,-0.67077949,-0.4898361,-0.39310687,1.7359336,-0.67077949,-0.48875468,-0.39093353,1.737582,-0.67076899,-0.48766276,-0.39093353,1.7383589,-0.67076899,-0.49092801,-0.38984161,1.7360071,-0.67076899,-0.48658134,-0.39201495,1.7407737,-0.67076899,-0.48658134,-0.39201495,1.7409207,-0.67076899,-0.48766276,-0.38984161,1.7401753,-0.67075849,-0.48766276,-0.38984161,1.7404587,-0.67076899,-0.48875468,-0.38984161,1.7382644,-0.67076899,-0.48766276,-0.39093353,1.7402173,-0.67076899,-0.4898361,-0.38984161,1.7368365,-0.67076899,-0.48875468,-0.39093353,1.7391673,-0.67076899,-0.48658134,-0.38766828,1.7425166,-0.67075849,-0.49310135,-0.39093353,1.7323114,-0.67077949,-0.4898361,-0.38876019,1.7381174,-0.67076899,-0.48548942,-0.39093353,1.7433565,-0.67076899,-0.48658134,-0.38766828,1.7425901,-0.67075849,-0.49092801,-0.39310687,1.7352091,-0.67078999,-0.48766276,-0.38876019,1.7411622,-0.67075849,-0.50070278,-0.39853496,1.7212767,-0.67083199,-0.48548942,-0.38876019,1.7446479,-0.67075849,-0.48875468,-0.39418829,1.7383799,-0.67077949,-0.48114275,-0.38766828,1.750412,-0.6707375,-0.4843975,-0.39201495,1.7447214,-0.67076899,-0.48658134,-0.39310687,1.7412882,-0.67077949,-0.48222417,-0.38876019,1.7484801,-0.670748,-0.48331609,-0.39310687,1.7459288,-0.67076899,-0.48114275,-0.39093353,1.7494566,-0.67075849,-0.4843975,-0.39201495,1.743703,-0.67076899,-0.48658134,-0.38984161,1.7423696,-0.67075849,-0.48766276,-0.39201495,1.7393458,-0.67076899,-0.48766276,-0.39201495,1.7393458,-0.67076899,-0.48766276,-0.39201495,1.7393458,-0.67076899,-0.48766276,-0.39201495,1.7393458,-0.67076899,-0.48766276,-0.39201495,1.7393458,-0.67076899,-0.48766276,-0.39201495,1.7393458,-0.67076899,-0.48766276,-0.39201495,1.7393458,-0.67076899:6
-0.59080305,-0.59080305,1.7204455,-0.59080305,-0.59080305,-0.59080305,1.7207759,-0.59080305,-0.59080305,-0.59080305,1.7206417,-0.59080305,-0.59080305,-0.59080305,1.7218498,-0.59080305,-0.59080305,-0.59080305,1.7217878,-0.59080305,-0.62518787,-0.5155798,1.7196297,-0.59044165,-0.62411399,-0.51665368,1.7212096,-0.59044165,-0.62626175,-0.51450592,1.7199189,-0.59043132,-0.62840951,-0.51128428,1.7201873,-0.59041067,-0.63271536,-0.50590455,1.7215297,-0.59037969,-0.63486312,-0.50160903,1.7205178,-0.59035904,-0.635937,-0.50160903,1.7176575,-0.59035904,-0.63486312,-0.50268291,1.7202286,-0.59036937,-0.63271536,-0.50375679,1.7186798,-0.59037969,-0.63271536,-0.50590455,1.7185249,-0.59037969,-0.63164148,-0.50697843,1.7208998,-0.59039002,-0.63055727,-0.50805231,1.7209514,-0.59040034,-0.62948339,-0.50805231,1.7172238,-0.59040034,-0.62948339,-0.50912619,1.7187107,-0.59040034,-0.62948339,-0.5102104,1.7165733,-0.59041067,-0.62840951,-0.5102104,1.7160983,-0.59041067,-0.62840951,-0.51128428,1.7131761,-0.59041067,-0.62840951,-0.51128428,1.7133517,-0.59041067,-0.62840951,-0.51235816,1.7166146,-0.590421,-0.62733563,-0.51235816,1.7161293,-0.590421,-0.62733563,-0.51235816,1.7190308,-0.590421,-0.62733563,-0.51343204,1.7169141,-0.590421,-0.62626175,-0.51343204,1.7199189,-0.59043132,-0.62626175,-0.51450592,1.7181532,-0.59043132,-0.62626175,-0.51450592,1.7171929,-0.59043132,-0.62518787,-0.51450592,1.7221699,-0.59043132,-0.62518787,-0.5155798,1.7207243,-0.59044165,-0.62518787,-0.5155798,1.7166146,-0.59044165,-0.62411399,-0.51665368,1.718876,-0.59044165,-0.62411399,-0.51665368,1.7185662,-0.59044165,-0.62411399,-0.51665368,1.7167592,-0.59044165,-0.62411399,-0.51665368,1.7165114,-0.59044165,-0.62411399,-0.51772756,1.7164907,-0.59045197,-0.62411399,-0.51772756,1.7194336,-0.59045197,-0.62304011,-0.51772756,1.7163565,-0.59045197,-0.62411399,-0.51772756,1.7168418,-0.59045197,-0.62304011,-0.51880144,1.7152723,-0.59045197,-0.62304011,-0.51880144,1.7176162,-0.59045197,-0.62304011,-0.51880144,1.7198569,-0.59045197,-0.62304011,-0.51880144,1.7149212,-0.59045197,-0.62304011,-0.51880144,1.7244209,-0.59045197,-0.62304011,-0.51880144,1.7239769,-0.59045197,-0.62304011,-0.51880144,1.7252263,-0.59045197,-0.62304011,-0.51880144,1.7227275,-0.59045197,-0.62304011,-0.51880144,1.7222835,-0.59045197,-0.62304011,-0.51880144,1.7232747,-0.59045197,-0.62304011,-0.51987532,1.7144875,-0.5904623,-0.62304011,-0.51987532,1.7190412,-0.5904623,-0.62304011,-0.51987532,1.7203835,-0.5904623,-0.62304011,-0.51987532,1.7209721,-0.5904623,-0.62304011,-0.51987532,1.7277045,-0.5904623,-0.62304011,-0.51987532,1.7244519,-0.5904623,-0.62304011,-0.51880144,1.7253812,-0.59045197,-0.62304011,-0.51880144,1.7225623,-0.59045197,-0.62304011,-0.51880144,1.7267029,-0.59045197,-0.62304011,-0.51880144,1.7262382,-0.59045197,-0.62304011,-0.51880144,1.7192683,-0.59045197,-0.62304011,-0.51880144,1.7253089,-0.59045197,-0.62304011,-0.51880144,1.7232438,-0.59045197,-0.62304011,-0.51880144,1.7175439,-0.59045197,-0.62411399,-0.51880144,1.7184113,-0.59045197,-0.62411399,-0.51880144,1.7112865,-0.59045197,-0.62411399,-0.51772756,1.7190412,-0.59045197,-0.62411399,-0.51772756,1.7145598,-0.59045197,-0.62411399,-0.51665368,1.7248649,-0.59044165,-0.62518787,-0.51665368,1.7235329,-0.59044165,-0.62518787,-0.51665368,1.7134446,-0.59044165,-0.62518787,-0.51665368,1.7241111,-0.59044165,-0.62518787,-0.5155798,1.7249062,-0.59044165,-0.62518787,-0.5155798,1.7261763,-0.59044165,-0.62518787,-0.5155798,1.725185,-0.59044165,-0.62626175,-0.5155798,1.7239459,-0.59044165,-0.62626175,-0.51450592,1.7239046,-0.59043132,-0.62626175,-0.51450592,1.7244106,-0.59043132,-0.62626175,-0.51450592,1.7245861,-0.59043132,-0.62626175,-0.51450592,1.725598,-0.59043132,-0.62626175,-0.51343204,1.7269301,-0.59043132,-0.62626175,-0.51343204,1.7266719,-0.59043132,-0.62733563,-0.51343204,1.7258768,-0.59043132,-0.62733563,-0.51343204,1.7271985,-0.59043132,-0.62733563,-0.51235816,1.7267958,-0.590421,-0.62733563,-0.51235816,1.7267339,-0.590421,-0.62733563,-0.51235816,1.7275599,-0.590421,-0.62733563,-0.51235816,1.7253399,-0.590421,-0.62840951,-0.51235816,1.7260627,-0.590421,-0.62840951,-0.51128428,1.7285306,-0.590421,-0.62840951,-0.51128428,1.7269404,-0.590421,-0.62840951,-0.51128428,1.7268784,-0.590421,-0.62948339,-0.51128428,1.7264964,-0.59041067,-0.62840951,-0.5102104,1.7271572,-0.59041067,-0.62948339,-0.5102104,1.7282311,-0.59041067,-0.62948339,-0.5102104,1.7292534,-0.59041067,-0.62948339,-0.5102104,1.7305544,-0.59041067,-0.62948339,-0.5102104,1.7307403,-0.59041067,-0.62948339,-0.50912619,1.7320723,-0.59040034,-0.63055727,-0.50912619,1.7296457,-0.59040034,-0.62948339,-0.50912619,1.7234193,-0.59040034,-0.62948339,-0.50912619,1.723409,-0.59040034,-0.63055727,-0.50912619,1.7276942,-0.59040034,-0.63055727,-0.50805231,1.7237807,-0.59040034,-0.63055727,-0.50912619,1.7255258,-0.59040034,-0.63055727,-0.50805231,1.7271056,-0.59040034,-0.63055727,-0.50805231,1.7278594,-0.59040034,-0.63164148,-0.50805231,1.7282518,-0.59040034,-0.63164148,-0.50697843,1.7282724,-0.59039002,-0.63164148,-0.50697843,1.7275393,-0.59039002,-0.63164148,-0.50697843,1.7289023,-0.59039002,-0.63164148,-0.50697843,1.7297903,-0.59039002,-0.63271536,-0.50697843,1.7270643,-0.59039002,-0.63271536,-0.50697843,1.7278078,-0.59039002,-0.63164148,-0.50697843,1.7240905,-0.59039002,-0.63271536,-0.50590455,1.7299968,-0.59039002,-0.63271536,-0.50590455,1.7282931,-0.59039002,-0.63271536,-0.50590455,1.7280039,-0.59039002,-0.63271536,-0.50590455,1.730193,-0.59039002,-0.63271536,-0.50590455,1.7318555,-0.59039002,-0.63271536,-0.50590455,1.7320207,-0.59039002,-0.63271536,-0.50590455,1.7324544,-0.59039002,-0.63271536,-0.50590455,1.7310913,-0.59039002,-0.63271536,-0.50483067,1.7350151,-0.59037969,-0.63271536,-0.50483067,1.7327022,-0.59037969,-0.63271536,-0.50483067,1.731143,-0.59037969,-0.63271536,-0.50483067,1.7304202,-0.59037969,-0.63271536,-0.50483067,1.7307403,-0.59037969,-0.63378924,-0.50483067,1.7302343,-0.59037969,-0.63378924,-0.50483067,1.7307403,-0.59037969,-0.63378924,-0.50483067,1.7304615,-0.59037969,-0.63378924,-0.50483067,1.7308126,-0.59037969,-0.63378924,-0.50483067,1.7314528,-0.59037969,-0.63378924,-0.50483067,1.7318555,-0.59037969,-0.63378924,-0.50483067,1.7310191,-0.59037969,-0.63378924,-0.50375679,1.7317419,-0.59037969,-0.63378924,-0.50375679,1.7322169,-0.59037969,-0.63378924,-0.50375679,1.7331565,-0.59037969,-0.63378924,-0.50375679,1.7316593,-0.59037969,-0.63378924,-0.50375679,1.7302859,-0.59037969,-0.63378924,-0.50375679,1.7328054,-0.59037969,-0.63378924,-0.50375679,1.7327435,-0.59037969,-0.63378924,-0.50375679,1.7299452,-0.59037969,-0.63378924,-0.50375679,1.729811,-0.59037969,-0.63378924,-0.50375679,1.729274,-0.59037969,-0.63378924,-0.50375679,1.7291398,-0.59037969,-0.63378924,-0.50375679,1.729811,-0.59037969,-0.63378924,-0.50375679,1.729687,-0.59037969,-0.63378924,-0.50375679,1.7298832,-0.59037969,-0.63486312,-0.50268291,1.7299762,-0.59036937,-0.63378924,-0.50375679,1.72978,-0.59037969,-0.63378924,-0.50375679,1.7280349,-0.59037969,-0.63486312,-0.50375679,1.7276116,-0.59036937,-0.63486312,-0.50375679,1.72788,-0.59036937,-0.63486312,-0.50268291,1.728448,-0.59036937,-0.63486312,-0.50375679,1.7295735,-0.59036937,-0.63486312,-0.50375679,1.7182977,-0.59036937,-0.63486312,-0.50375679,1.718814,-0.59036937,-0.63486312,-0.50375679,1.719764,-0.59036937,-0.63486312,-0.50268291,1.7201357,-0.59036937,-0.63486312,-0.50375679,1.7166146,-0.59036937,-0.63486312,-0.50268291,1.7178434,-0.59036937,-0.63486312,-0.50268291,1.7190205,-0.59036937,-0.63486312,-0.50268291,1.7196607,-0.59036937,-0.63486312,-0.50268291,1.7207036,-0.59036937,-0.63486312,-0.50268291,1.7216846,-0.59036937,-0.63486312,-0.50268291,1.722934,-0.59036937,-0.63486312,-0.50268291,1.7212715,-0.59036937,-0.63486312,-0.50268291,1.7215194,-0.59036937,-0.63486312,-0.50268291,1.7201667,-0.59036937,-0.63486312,-0.50268291,1.7200324,-0.59036937,-0.63486312,-0.50268291,1.7197537,-0.59036937,-0.63486312,-0.50268291,1.7200324,-0.59036937,-0.63486312,-0.50268291,1.719733,-0.59036937,-0.63486312,-0.50268291,1.7196607,-0.59036937,-0.63486312,-0.50268291,1.7207139,-0.59036937,-0.63486312,-0.50268291,1.7219427,-0.59036937,-0.63486312,-0.50268291,1.7224074,-0.59036937,-0.63486312,-0.50268291,1.7219221,-0.59036937,-0.63486312,-0.50268291,1.7231508,-0.59036937,-0.63486312,-0.50268291,1.7237084,-0.59036937,-0.63486312,-0.50268291,1.7227068,-0.59036937,-0.63486312,-0.50268291,1.7230476,-0.59036937,-0.63486312,-0.50268291,1.7251437,-0.59036937,-0.63486312,-0.50268291,1.7233264,-0.59036937,-0.63271536,-0.50483067,1.726166,-0.59037969,-0.63486312,-0.50268291,1.7250095,-0.59036937,-0.63486312,-0.50268291,1.7242557,-0.59036937,-0.63486312,-0.50268291,1.7231199,-0.59036937,-0.63486312,-0.50268291,1.7265583,-0.59036937,-0.63486312,-0.50268291,1.7214161,-0.59036937,-0.635937,-0.50268291,1.7227791,-0.59036937,-0.63486312,-0.50160903,1.7240285,-0.59036937,-0.63486312,-0.50268291,1.7253502,-0.59036937,-0.63486312,-0.50268291,1.7264861,-0.59036937,-0.63486312,-0.50160903,1.7268784,-0.59036937,-0.63486312,-0.50160903,1.7275186,-0.59036937,-0.63486312,-0.50268291,1.7271469,-0.59036937,-0.63486312,-0.50268291,1.7273637,-0.59036937,-0.63486312,-0.50268291,1.7267752,-0.59036937,-0.63486312,-0.50268291,1.7266719,-0.59036937,-0.63486312,-0.50268291,1.7257013,-0.59036937,-0.63486312,-0.50268291,1.7234709,-0.59036937,-0.59080305,-0.59080305,1.7233057,-0.59080305,-0.59080305,-0.59080305,1.7206107,-0.59080305,-0.59080305,-0.59080305,1.721953,-0.59080305,-0.59080305,-0.59080305,1.7216329,-0.59080305,-0.59080305,-0.59080305,1.7226965,-0.59080305,-0.59080305,-0.59080305,1.7202493,-0.59080305,-0.59080305,-0.59080305,1.7191961,-0.59080305,-0.59080305,-0.59080305,1.7208172,-0.59080305,-0.59080305,-0.59080305,1.7200324,-0.59080305,-0.62411399,-0.51772756,1.7228204,-0.59045197,-0.62518787,-0.51665368,1.7206417,-0.59044165,-0.62626175,-0.51450592,1.721571,-0.59043132,-0.62840951,-0.51128428,1.7221079,-0.59041067,-0.62948339,-0.5102104,1.7236671,-0.59041067,-0.63055727,-0.50805231,1.7200841,-0.59040034,-0.63164148,-0.50697843,1.71932,-0.59039002,-0.63164148,-0.50697843,1.7205797,-0.59039002,-0.63271536,-0.50590455,1.7189999,-0.59037969,-0.63271536,-0.50590455,1.720652,-0.59037969,-0.63271536,-0.50483067,1.7169967,-0.59037969,-0.63271536,-0.50483067,1.7151793,-0.59037969,-0.63378924,-0.50483067,1.7108838,-0.59037969,-0.63378924,-0.50375679,1.7164391,-0.59036937,-0.63378924,-0.50375679,1.7179363,-0.59036937,-0.63378924,-0.50375679,1.7228307,-0.59037969,-0.63378924,-0.50375679,1.722903,-0.59037969,-0.63486312,-0.50268291,1.7226242,-0.59036937,-0.63378924,-0.50268291,1.7227275,-0.59036937,-0.63486312,-0.50268291,1.7223454,-0.59036937,-0.63486312,-0.50268291,1.7234503,-0.59036937,-0.63486312,-0.50268291,1.721984,-0.59036937,-0.63486312,-0.50268291,1.7204455,-0.59036937,-0.63486312,-0.50268291,1.7216846,-0.59036937,-0.63486312,-0.50268291,1.7201254,-0.59036937,-0.63486312,-0.50268291,1.7237084,-0.59036937,-0.63486312,-0.50268291,1.7261866,-0.59036937,-0.63486312,-0.50160903,1.7274464,-0.59036937,-0.63486312,-0.50268291,1.7163874,-0.59036937,-0.63486312,-0.50160903,1.7359961,-0.59036937,-0.63486312,-0.50160903,1.7367912,-0.59036937,-0.63486312,-0.50160903,1.7387427,-0.59036937,-0.63486312,-0.50160903,1.7375656,-0.59036937,-0.63486312,-0.50160903,1.7393003,-0.59036937,-0.63486312,-0.50160903,1.7401987,-0.59036937,-0.63486312,-0.50160903,1.7406737,-0.59036937,-0.63486312,-0.50160903,1.7436268,-0.59036937,-0.63486312,-0.50160903,1.742522,-0.59036937,-0.63486312,-0.50160903,1.7400438,-0.59036937,-0.63486312,-0.50160903,1.7398063,-0.59036937,-0.63486312,-0.50160903,1.7307299,-0.59036937,-0.63486312,-0.50160903,1.7299452,-0.59036937,-0.63486312,-0.50160903,1.7303892,-0.59036937,-0.63486312,-0.50160903,1.7310604,-0.59036937,-0.63486312,-0.50160903,1.7302137,-0.59036937,-0.63486312,-0.50160903,1.7303892,-0.59036937,-0.635937,-0.50160903,1.7399096,-0.59036937,-0.63486312,-0.50160903,1.7398889,-0.59036937,-0.63486312,-0.50160903,1.7399302,-0.59036937,-0.635937,-0.50160903,1.7434306,-0.59036937,-0.635937,-0.50160903,1.7431622,-0.59036937,-0.63486312,-0.50160903,1.742429,-0.59036937,-0.63486312,-0.50160903,1.7408905,-0.59036937,-0.635937,-0.50160903,1.7415514,-0.59036937,-0.63486312,-0.50160903,1.7409628,-0.59036937,-0.63486312,-0.50160903,1.7417062,-0.59036937,-0.63486312,-0.50160903,1.7398166,-0.59036937,-0.63486312,-0.50160903,1.739827,-0.59036937,-0.63486312,-0.50160903,1.7405394,-0.59036937,-0.63486312,-0.50160903,1.7422742,-0.59036937,-0.635937,-0.50160903,1.7420883,-0.59036937,-0.63486312,-0.50160903,1.7433171,-0.59036937,-0.63486312,-0.50160903,1.742078,-0.59036937,-0.635937,-0.50160903,1.7439986,-0.59036937,-0.63486312,-0.50160903,1.7427182,-0.59036937,-0.63486312,-0.50160903,1.7423361,-0.59036937,-0.63486312,-0.50160903,1.7427491,-0.59036937,-0.63486312,-0.50160903,1.7429144,-0.59036937,-0.63486312,-0.50160903,1.7431312,-0.59036937,-0.635937,-0.50160903,1.7444426,-0.59036937,-0.635937,-0.50160903,1.7443393,-0.59036937,-0.63486312,-0.50160903,1.744298,-0.59036937,-0.63486312,-0.50160903,1.7437507,-0.59036937,-0.63486312,-0.50160903,1.744267,-0.59036937,-0.63486312,-0.50160903,1.7435339,-0.59036937,-0.635937,-0.50160903,1.7446801,-0.59036937,-0.63486312,-0.50160903,1.7454235,-0.59036937,-0.63486312,-0.50160903,1.7452273,-0.59036937,-0.63486312,-0.50160903,1.743379,-0.59036937,-0.63486312,-0.50160903,1.7447007,-0.59036937,-0.63486312,-0.50160903,1.7456404,-0.59036937,-0.63486312,-0.50160903,1.747468,-0.59036937,-0.63486312,-0.50160903,1.7472202,-0.59036937,-0.63486312,-0.50160903,1.7462702,-0.59036937,-0.63486312,-0.50160903,1.7374417,-0.59036937,-0.63486312,-0.50160903,1.7330223,-0.59036937,-0.63486312,-0.50268291,1.7354385,-0.59036937,-0.635937,-0.50160903,1.7443806,-0.59036937,-0.635937,-0.50160903,1.7443496,-0.59036937,-0.63486312,-0.50160903,1.7463528,-0.59036937,-0.63486312,-0.50160903,1.74436,-0.59036937,-0.63486312,-0.50160903,1.7438643,-0.59036937,-0.63486312,-0.50160903,1.7432345,-0.59036937,-0.63486312,-0.50160903,1.7434203,-0.59036937,-0.63486312,-0.50160903,1.7438437,-0.59036937,-0.63486312,-0.50160903,1.7436268,-0.59036937,-0.63486312,-0.50160903,1.7446904,-0.59036937,-0.63486312,-0.50160903,1.7460844,-0.59036937,-0.63486312,-0.50160903,1.7473028,-0.59036937,-0.63486312,-0.50160903,1.7470447,-0.59036937,-0.63486312,-0.50160903,1.7473544,-0.59036937,-0.63486312,-0.50160903,1.7486555,-0.59036937,-0.63486312,-0.50160903,1.7475403,-0.59036937,-0.63486312,-0.50160903,1.7469208,-0.59036937,-0.63486312,-0.50160903,1.7488104,-0.59036937,-0.63486312,-0.50160903,1.7490479,-0.59036937,-0.63486312,-0.50160903,1.7449176,-0.59036937,-0.63486312,-0.50053515,1.7482012,-0.59035904,-0.63486312,-0.50160903,1.7478811,-0.59036937,-0.63486312,-0.50160903,1.749781,-0.59036937,-0.63486312,-0.50160903,1.7484077,-0.59036937,-0.63486312,-0.50160903,1.7499978,-0.59036937,-0.63486312,-0.50160903,1.7481599,-0.59036937,-0.635937,-0.50053515,1.748449,-0.59035904,-0.63486312,-0.50160903,1.745692,-0.59036937,-0.63486312,-0.50160903,1.7479224,-0.59036937,-0.63486312,-0.50160903,1.7495022,-0.59036937,-0.635937,-0.50160903,1.7490995,-0.59036937,-0.63486312,-0.50160903,1.7485832,-0.59036937,-0.63486312,-0.50160903,1.7477778,-0.59036937,-0.63486312,-0.50160903,1.736533,-0.59036937,-0.63486312,-0.50160903,1.7369667,-0.59036937,-0.63486312,-0.50160903,1.7378238,-0.59036937,-0.63486312,-0.50160903,1.7473338,-0.59036937,-0.63486312,-0.50160903,1.7495848,-0.59036937,-0.63486312,-0.50160903,1.7494196,-0.59036937,-0.63486312,-0.50160903,1.7494299,-0.59036937,-0.63486312,-0.50160903,1.7473338,-0.59036937,-0.63486312,-0.50160903,1.7461153,-0.59036937,-0.63486312,-0.50160903,1.7460947,-0.59036937,-0.63486312,-0.50160903,1.7465387,-0.59036937,-0.63486312,-0.50160903,1.7480669,-0.59036937,-0.63486312,-0.50160903,1.7462599,-0.59036937,-0.63486312,-0.50160903,1.7486142,-0.59036937,-0.63486312,-0.50160903,1.7489033,-0.59036937,-0.63486312,-0.50160903,1.7484283,-0.59036937,-0.63486312,-0.50160903,1.7438953,-0.59036937,-0.63486312,-0.50160903,1.7466936,-0.59036937,-0.63486312,-0.50160903,1.7447214,-0.59036937,-0.63486312,-0.50160903,1.7445045,-0.59036937,-0.63486312,-0.50160903,1.7437507,-0.59036937,-0.63486312,-0.50160903,1.7422845,-0.59036937,-0.63486312,-0.50160903,1.7445045,-0.59036937,-0.63486312,-0.50160903,1.7447523,-0.59036937,-0.63486312,-0.50053515,1.7452583,-0.59035904,-0.63486312,-0.50160903,1.7455474,-0.59036937,-0.63486312,-0.50160903,1.7455474,-0.59036937,-0.63486312,-0.50160903,1.7455474,-0.59036937,-0.63486312,-0.50160903,1.7455474,-0.59036937,-0.63486312,-0.50160903,1.7455474,-0.59036937,-0.63486312,-0.50160903,1.7455474,-0.59036937,-0.63486312,-0.50160903,1.7455474,-0.59036937:5
-0.60957259,-0.60957259,1.7239525,-0.60957259,-0.60957259,-0.60957259,1.7268006,-0.60957259,-0.60957259,-0.60957259,1.7270181,-0.60957259,-0.60957259,-0.60957259,1.7273703,-0.60957259,-0.60957259,-0.60957259,1.7272978,-0.60957259,-0.60957259,-0.60957259,1.7285717,-0.60957259,-0.60957259,-0.60957259,1.7274531,-0.60957259,-0.69149682,-0.43063393,1.7203586,-0.6087026,-0.69580535,-0.42417113,1.723476,-0.60867153,-0.69580535,-0.423094,1.7225646,-0.60866117,-0.69903674,-0.41985224,1.7258996,-0.60865081,-0.70011388,-0.41662085,1.7251435,-0.6086301,-0.70011388,-0.41662085,1.7267178,-0.6086301,-0.70011388,-0.41662085,1.7276603,-0.6086301,-0.70011388,-0.41662085,1.7246153,-0.6086301,-0.70119101,-0.41662085,1.726811,-0.6086301,-0.70119101,-0.41554371,1.7278156,-0.60861974,-0.70226814,-0.41446658,1.7265003,-0.60861974,-0.70334527,-0.41231232,1.7298974,-0.60860939,-0.70443276,-0.41123518,1.7244807,-0.60859903,-0.7055099,-0.40908092,1.7252057,-0.60858867,-0.70658703,-0.40692665,1.7247292,-0.60857831,-0.70766416,-0.40583916,1.7234864,-0.60856796,-0.70874129,-0.4036849,1.7261792,-0.6085576,-0.70981843,-0.40260776,1.7222332,-0.6085576,-0.71089556,-0.4004535,1.7220675,-0.60854724,-0.71197269,-0.39937637,1.72069,-0.60853689,-0.71304983,-0.39829923,1.7203275,-0.60852653,-0.71412696,-0.3972221,1.723186,-0.60852653,-0.71412696,-0.3972221,1.7184529,-0.60851617,-0.71520409,-0.39614497,1.7205657,-0.60851617,-0.71520409,-0.39506784,1.7221711,-0.60851617,-0.71628122,-0.39506784,1.7220053,-0.60851617,-0.71520409,-0.39506784,1.7210525,-0.60851617,-0.71628122,-0.3939907,1.7210525,-0.60850582,-0.71628122,-0.3939907,1.7195507,-0.60850582,-0.71628122,-0.39290321,1.7219121,-0.60850582,-0.71628122,-0.3939907,1.7201204,-0.60850582,-0.71628122,-0.3939907,1.7216118,-0.60850582,-0.71628122,-0.3939907,1.7220778,-0.60850582,-0.71628122,-0.39290321,1.7218811,-0.60850582,-0.71628122,-0.3939907,1.7220882,-0.60850582,-0.71520409,-0.3939907,1.7249467,-0.60851617,-0.71520409,-0.3939907,1.7259721,-0.60851617,-0.71520409,-0.3939907,1.7254542,-0.60851617,-0.71520409,-0.39506784,1.7257546,-0.60851617,-0.71412696,-0.39506784,1.7246153,-0.60851617,-0.71412696,-0.39614497,1.724895,-0.60852653,-0.71412696,-0.39614497,1.7259099,-0.60852653,-0.71304983,-0.3972221,1.72504,-0.60852653,-0.71304983,-0.3972221,1.7234346,-0.60852653,-0.71304983,-0.3972221,1.7246464,-0.60852653,-0.71304983,-0.3972221,1.7268214,-0.60852653,-0.71304983,-0.3972221,1.722285,-0.60852653,-0.71304983,-0.3972221,1.7183597,-0.60852653,-0.71412696,-0.3972221,1.7184425,-0.60852653,-0.71304983,-0.3972221,1.7187947,-0.60852653,-0.71412696,-0.3972221,1.71837,-0.60852653,-0.71304983,-0.3972221,1.7178314,-0.60852653,-0.71304983,-0.3972221,1.7190225,-0.60852653,-0.71304983,-0.3972221,1.7238178,-0.60852653,-0.71304983,-0.3972221,1.7260653,-0.60852653,-0.71304983,-0.39829923,1.7233828,-0.60853689,-0.71304983,-0.39829923,1.7256924,-0.60853689,-0.71197269,-0.39829923,1.725216,-0.60853689,-0.71197269,-0.39829923,1.7242839,-0.60853689,-0.71197269,-0.39829923,1.7248639,-0.60853689,-0.71089556,-0.39937637,1.7236521,-0.60853689,-0.71197269,-0.39829923,1.7283749,-0.60853689,-0.71197269,-0.39937637,1.7290067,-0.60853689,-0.71089556,-0.39937637,1.7276189,-0.60853689,-0.71089556,-0.4004535,1.7215082,-0.60854724,-0.71089556,-0.39937637,1.7256303,-0.60853689,-0.71197269,-0.39937637,1.7218603,-0.60853689,-0.71304983,-0.39937637,1.7193539,-0.60853689,-0.71197269,-0.39829923,1.7191572,-0.60852653,-0.71304983,-0.39829923,1.7208246,-0.60853689,-0.71304983,-0.39829923,1.7209593,-0.60853689,-0.71304983,-0.39829923,1.7245014,-0.60853689,-0.71304983,-0.39829923,1.7205139,-0.60852653,-0.71304983,-0.39829923,1.7211353,-0.60853689,-0.71197269,-0.39829923,1.7237246,-0.60853689,-0.71197269,-0.39829923,1.7175,-0.60852653,-0.71197269,-0.39829923,1.71721,-0.60852653,-0.71197269,-0.39829923,1.7156668,-0.60852653,-0.71197269,-0.39937637,1.7175829,-0.60853689,-0.71197269,-0.39829923,1.7202654,-0.60852653,-0.71197269,-0.39829923,1.7194161,-0.60852653,-0.71197269,-0.39829923,1.7181939,-0.60852653,-0.71197269,-0.39937637,1.7170547,-0.60853689,-0.71089556,-0.39937637,1.7168786,-0.60853689,-0.71089556,-0.39937637,1.7150454,-0.60853689,-0.71089556,-0.4004535,1.7131708,-0.60853689,-0.71197269,-0.4004535,1.7105919,-0.60853689,-0.71089556,-0.4004535,1.7089762,-0.60853689,-0.71089556,-0.4004535,1.7130672,-0.60853689,-0.70981843,-0.4004535,1.7098669,-0.60853689,-0.70981843,-0.40153063,1.7075573,-0.60854724,-0.70981843,-0.40153063,1.7046676,-0.60854724,-0.71089556,-0.4004535,1.7070291,-0.60853689,-0.70981843,-0.40153063,1.7101155,-0.60854724,-0.70981843,-0.40153063,1.7082098,-0.60854724,-0.70981843,-0.40260776,1.7040462,-0.60854724,-0.70981843,-0.4036849,1.6979149,-0.60854724,-0.70981843,-0.40260776,1.7016123,-0.60854724,-0.70981843,-0.40260776,1.704678,-0.60854724,-0.70981843,-0.40260776,1.7032694,-0.60854724,-0.70981843,-0.40260776,1.6994063,-0.60854724,-0.70981843,-0.40260776,1.7003695,-0.60854724,-0.70981843,-0.40260776,1.700183,-0.60854724,-0.70981843,-0.4036849,1.6997791,-0.60854724,-0.70981843,-0.4036849,1.6967756,-0.60854724,-0.70981843,-0.4036849,1.6973038,-0.60854724,-0.70874129,-0.4036849,1.6975316,-0.60854724,-0.70981843,-0.4036849,1.6989713,-0.60854724,-0.70981843,-0.40260776,1.7010427,-0.60854724,-0.70874129,-0.4036849,1.6967238,-0.60854724,-0.70874129,-0.4036849,1.6976663,-0.60854724,-0.70874129,-0.4036849,1.6989713,-0.60854724,-0.70766416,-0.40583916,1.6855382,-0.6085576,-0.70874129,-0.4036849,1.7022234,-0.6085576,-0.70874129,-0.4036849,1.7013948,-0.6085576,-0.70874129,-0.4036849,1.6987331,-0.60854724,-0.70874129,-0.4036849,1.6992923,-0.60854724,-0.70874129,-0.4036849,1.7017159,-0.6085576,-0.70874129,-0.40476203,1.7020162,-0.6085576,-0.70874129,-0.40476203,1.7030519,-0.6085576,-0.70766416,-0.4036849,1.7012084,-0.6085576,-0.70766416,-0.4036849,1.7029691,-0.6085576,-0.70766416,-0.4036849,1.7031555,-0.6085576,-0.70766416,-0.40476203,1.7009598,-0.6085576,-0.70766416,-0.40476203,1.7020473,-0.6085576,-0.70766416,-0.40476203,1.7012705,-0.6085576,-0.70766416,-0.40476203,1.7017884,-0.6085576,-0.70766416,-0.40476203,1.700038,-0.6085576,-0.70766416,-0.40476203,1.7026998,-0.6085576,-0.70766416,-0.4036849,1.7068944,-0.6085576,-0.70766416,-0.40476203,1.7047401,-0.6085576,-0.70766416,-0.4036849,1.7062108,-0.6085576,-0.70766416,-0.4036849,1.7088622,-0.6085576,-0.70766416,-0.4036849,1.709639,-0.6085576,-0.70766416,-0.4036849,1.706273,-0.6085576,-0.70766416,-0.4036849,1.7057758,-0.6085576,-0.70766416,-0.4036849,1.7055066,-0.6085576,-0.70766416,-0.4036849,1.7075883,-0.6085576,-0.70766416,-0.4036849,1.7076608,-0.6085576,-0.70766416,-0.40260776,1.7133572,-0.6085576,-0.70766416,-0.40260776,1.7133779,-0.6085576,-0.70874129,-0.40260776,1.7131086,-0.6085576,-0.70874129,-0.40260776,1.7126426,-0.6085576,-0.70874129,-0.40260776,1.7115447,-0.6085576,-0.70874129,-0.40260776,1.7145483,-0.6085576,-0.70766416,-0.40260776,1.7103226,-0.60854724,-0.70874129,-0.4036849,1.7095562,-0.6085576,-0.70874129,-0.4036849,1.7099601,-0.6085576,-0.70874129,-0.4036849,1.7100326,-0.6085576,-0.70874129,-0.40260776,1.7105504,-0.6085576,-0.70874129,-0.40260776,1.7101569,-0.60854724,-0.70981843,-0.40260776,1.7114308,-0.60854724,-0.70874129,-0.40260776,1.7122076,-0.6085576,-0.70874129,-0.40260776,1.7132951,-0.6085576,-0.70874129,-0.40260776,1.7101155,-0.60854724,-0.70874129,-0.40260776,1.7051234,-0.60854724,-0.70874129,-0.40260776,1.7118969,-0.6085576,-0.70874129,-0.40260776,1.7087897,-0.60854724,-0.70874129,-0.40260776,1.7096183,-0.60854724,-0.70874129,-0.40260776,1.7111822,-0.6085576,-0.70874129,-0.40153063,1.7128704,-0.60854724,-0.70874129,-0.40153063,1.7129015,-0.60854724,-0.70874129,-0.40260776,1.7132226,-0.6085576,-0.70874129,-0.40260776,1.7120108,-0.6085576,-0.70981843,-0.40153063,1.7127254,-0.60854724,-0.70981843,-0.40260776,1.7118451,-0.60854724,-0.70981843,-0.40153063,1.7113479,-0.60854724,-0.70874129,-0.40260776,1.7113065,-0.6085576,-0.70981843,-0.40260776,1.710654,-0.60854724,-0.70981843,-0.40260776,1.7135229,-0.60854724,-0.70981843,-0.40153063,1.7125079,-0.60854724,-0.70981843,-0.40153063,1.71576,-0.60854724,-0.70981843,-0.40153063,1.7157497,-0.60854724,-0.70981843,-0.40153063,1.7160915,-0.60854724,-0.70981843,-0.40153063,1.7145897,-0.60854724,-0.70981843,-0.40153063,1.7200996,-0.60854724,-0.70981843,-0.4004535,1.7194161,-0.60854724,-0.70981843,-0.4004535,1.7211561,-0.60854724,-0.71089556,-0.4004535,1.7210836,-0.60854724,-0.71089556,-0.4004535,1.7206796,-0.60853689,-0.70981843,-0.4004535,1.7210836,-0.60854724,-0.70981843,-0.4004535,1.7173032,-0.60854724,-0.70981843,-0.4004535,1.718225,-0.60854724,-0.70981843,-0.4004535,1.7189293,-0.60854724,-0.70981843,-0.4004535,1.7208868,-0.60854724,-0.70981843,-0.4004535,1.7196025,-0.60854724,-0.70981843,-0.4004535,1.717179,-0.60854724,-0.70981843,-0.4004535,1.717065,-0.60854724,-0.71089556,-0.4004535,1.7177382,-0.60853689,-0.70981843,-0.4004535,1.7191157,-0.60854724,-0.70981843,-0.4004535,1.7136783,-0.60854724,-0.70981843,-0.4004535,1.715004,-0.60854724,-0.70981843,-0.4004535,1.7162675,-0.60854724,-0.71089556,-0.4004535,1.719965,-0.60853689,-0.70981843,-0.4004535,1.7183804,-0.60854724,-0.70981843,-0.4004535,1.7166611,-0.60854724,-0.71089556,-0.39937637,1.7207936,-0.60853689,-0.70981843,-0.4004535,1.7189397,-0.60854724,-0.70981843,-0.39937637,1.7227096,-0.60854724,-0.70981843,-0.39937637,1.7213011,-0.60854724,-0.71089556,-0.4004535,1.7201514,-0.60853689,-0.71089556,-0.39937637,1.720835,-0.60853689,-0.71089556,-0.39937637,1.7251332,-0.60853689,-0.71089556,-0.39937637,1.7256407,-0.60853689,-0.71089556,-0.39937637,1.7259514,-0.60853689,-0.71089556,-0.39937637,1.7263139,-0.60853689,-0.71089556,-0.39937637,1.7275878,-0.60853689,-0.71089556,-0.39937637,1.7258789,-0.60853689,-0.71089556,-0.39937637,1.7245325,-0.60853689,-0.71089556,-0.39937637,1.7267903,-0.60853689,-0.71089556,-0.39937637,1.7273392,-0.60853689,-0.71089556,-0.39937637,1.727536,-0.60853689,-0.71089556,-0.39829923,1.7276396,-0.60853689,-0.71089556,-0.39829923,1.727536,-0.60853689,-0.71089556,-0.39937637,1.724315,-0.60853689,-0.71089556,-0.39937637,1.7241285,-0.60853689,-0.71089556,-0.39937637,1.7258892,-0.60853689,-0.71089556,-0.39937637,1.7257753,-0.60853689,-0.71089556,-0.39937637,1.7261482,-0.60853689,-0.71089556,-0.39937637,1.7246567,-0.60853689,-0.71089556,-0.39829923,1.7259617,-0.60853689,-0.71089556,-0.39937637,1.7245428,-0.60853689,-0.71089556,-0.39829923,1.7277535,-0.60853689,-0.71089556,-0.39829923,1.7272253,-0.60853689,-0.71089556,-0.39937637,1.7235693,-0.60853689,-0.71089556,-0.39937637,1.723155,-0.60853689,-0.71089556,-0.39937637,1.7218396,-0.60853689,-0.71089556,-0.39937637,1.72359,-0.60853689,-0.71089556,-0.39937637,1.7246464,-0.60853689,-0.71089556,-0.39829923,1.7310781,-0.60853689,-0.71089556,-0.39829923,1.7294831,-0.60853689,-0.71089556,-0.39829923,1.7308192,-0.60853689,-0.71197269,-0.39829923,1.7319481,-0.60853689,-0.71089556,-0.39829923,1.7330667,-0.60853689,-0.71089556,-0.3972221,1.7355006,-0.60853689,-0.71089556,-0.39829923,1.7326835,-0.60853689,-0.71089556,-0.39829923,1.7308503,-0.60853689,-0.71089556,-0.3972221,1.7336777,-0.60853689,-0.71197269,-0.3972221,1.7342991,-0.60853689,-0.71089556,-0.39829923,1.7293485,-0.60853689,-0.71197269,-0.39829923,1.7295971,-0.60853689,-0.71197269,-0.39829923,1.7320724,-0.60853689,-0.71089556,-0.39829923,1.7302392,-0.60853689,-0.71197269,-0.3972221,1.7338642,-0.60853689,-0.71089556,-0.3972221,1.7364327,-0.60853689,-0.71197269,-0.3972221,1.7371059,-0.60853689,-0.71197269,-0.3972221,1.7376755,-0.60853689,-0.71089556,-0.3972221,1.7342577,-0.60853689,-0.71089556,-0.39829923,1.7328388,-0.60853689,-0.71197269,-0.39829923,1.729711,-0.60853689,-0.71197269,-0.39829923,1.7304567,-0.60853689,-0.71197269,-0.39829923,1.7319895,-0.60853689,-0.71089556,-0.39829923,1.7299492,-0.60853689,-0.71089556,-0.39829923,1.7313163,-0.60853689,-0.71089556,-0.39829923,1.7318238,-0.60853689,-0.71197269,-0.39829923,1.7322588,-0.60853689,-0.71197269,-0.39829923,1.7327249,-0.60853689,-0.71197269,-0.39829923,1.7306535,-0.60853689,-0.71197269,-0.39829923,1.730902,-0.60853689,-0.71197269,-0.39829923,1.7279917,-0.60853689,-0.71197269,-0.39829923,1.7290688,-0.60853689,-0.71197269,-0.39829923,1.7261274,-0.60853689,-0.71197269,-0.39829923,1.7278364,-0.60853689,-0.71197269,-0.39829923,1.7271735,-0.60853689,-0.71197269,-0.39829923,1.7245325,-0.60853689,-0.71089556,-0.39937637,1.7208661,-0.60853689,-0.71197269,-0.39829923,1.7280953,-0.60853689,-0.71197269,-0.39829923,1.7256614,-0.60853689,-0.71197269,-0.39829923,1.72417,-0.60853689,-0.71197269,-0.39829923,1.7271114,-0.60853689,-0.71197269,-0.39829923,1.7258167,-0.60853689,-0.71089556,-0.39829923,1.7280849,-0.60853689,-0.71197269,-0.3972221,1.7336984,-0.60853689,-0.71197269,-0.3972221,1.7330874,-0.60853689,-0.71197269,-0.3972221,1.7314613,-0.60853689,-0.71197269,-0.39829923,1.7303531,-0.60853689,-0.71197269,-0.39829923,1.7295142,-0.60853689,-0.71089556,-0.39829923,1.730146,-0.60853689,-0.71197269,-0.3972221,1.7308399,-0.60852653,-0.71197269,-0.39829923,1.7282299,-0.60853689,-0.71197269,-0.39829923,1.7312024,-0.60853689,-0.71197269,-0.39829923,1.7296903,-0.60853689,-0.71197269,-0.39829923,1.729566,-0.60853689,-0.71197269,-0.3972221,1.7303117,-0.60852653,-0.71197269,-0.3972221,1.7315027,-0.60853689,-0.71197269,-0.3972221,1.7339988,-0.60853689,-0.71089556,-0.3972221,1.7332013,-0.60853689,-0.71197269,-0.39829923,1.731917,-0.60853689,-0.71197269,-0.39829923,1.7304049,-0.60853689,-0.71197269,-0.3972221,1.732932,-0.60853689,-0.71197269,-0.3972221,1.7331806,-0.60853689,-0.71197269,-0.3972221,1.7332634,-0.60853689,-0.71197269,-0.3972221,1.7351174,-0.60853689,-0.71197269,-0.3972221,1.7360702,-0.60853689,-0.71197269,-0.3972221,1.7367745,-0.60853689,-0.71197269,-0.3972221,1.7363809,-0.60853689,-0.71197269,-0.3972221,1.7338538,-0.60853689,-0.71197269,-0.3972221,1.7339367,-0.60853689,-0.71197269,-0.39829923,1.7313785,-0.60853689,-0.71197269,-0.3972221,1.7345477,-0.60853689,-0.71197269,-0.39829923,1.7322692,-0.60853689,-0.71197269,-0.39829923,1.732062,-0.60853689,-0.71197269,-0.39829923,1.7300631,-0.60853689,-0.71197269,-0.39829923,1.7297213,-0.60853689,-0.71197269,-0.39829923,1.730902,-0.60853689,-0.71197269,-0.39829923,1.7303013,-0.60853689,-0.71197269,-0.39829923,1.7301045,-0.60853689,-0.71089556,-0.3972221,1.7315752,-0.60853689,-0.71089556,-0.39829923,1.7307985,-0.60853689,-0.71089556,-0.3972221,1.7348481,-0.60853689,-0.71089556,-0.3972221,1.7348066,-0.60853689,-0.71089556,-0.3972221,1.7349516,-0.60853689,-0.71089556,-0.3972221,1.7378516,-0.60853689,-0.71197269,-0.3972221,1.7378516,-0.60853689,-0.71197269,-0.3972221,1.7389598,-0.60853689,-0.71089556,-0.3972221,1.7371681,-0.60853689,-0.71089556,-0.3972221,1.7355627,-0.60853689,-0.71089556,-0.39829923,1.7275256,-0.60853689,-0.70981843,-0.39829923,1.7256717,-0.60853689,-0.71089556,-0.39829923,1.7298767,-0.60853689,-0.71089556,-0.39829923,1.7295453,-0.60853689,-0.71089556,-0.39829923,1.729131,-0.60853689,-0.71089556,-0.39829923,1.7306742,-0.60853689,-0.71089556,-0.39829923,1.7245946,-0.60853689,-0.71089556,-0.39829923,1.7241285,-0.60853689,-0.71089556,-0.39829923,1.7285924,-0.60853689,-0.71089556,-0.39829923,1.7257132,-0.60853689,-0.71089556,-0.39829923,1.7253817,-0.60853689,-0.71089556,-0.39829923,1.7280228,-0.60853689,-0.71089556,-0.39829923,1.7267903,-0.60853689,-0.71089556,-0.39829923,1.7262517,-0.60853689,-0.71089556,-0.39829923,1.7275671,-0.60853689,-0.71089556,-0.39829923,1.7260653,-0.60853689,-0.71089556,-0.39829923,1.724025,-0.60853689,-0.71089556,-0.39829923,1.727101,-0.60853689,-0.71089556,-0.39829923,1.7253817,-0.60853689,-0.71089556,-0.39829923,1.7258996,-0.60853689,-0.70981843,-0.39829923,1.7288513,-0.60853689,-0.71089556,-0.39829923,1.7268524,-0.60853689,-0.71089556,-0.39829923,1.724895,-0.60853689,-0.71089556,-0.39829923,1.7294935,-0.60853689,-0.71089556,-0.39829923,1.7277328,-0.60853689,-0.71089556,-0.39829923,1.7267799,-0.60853689,-0.71089556,-0.39829923,1.728986,-0.60853689,-0.71089556,-0.39829923,1.7280435,-0.60853689,-0.71089556,-0.39829923,1.7275878,-0.60853689,-0.71089556,-0.3972221,1.7299492,-0.60853689,-0.71089556,-0.39829923,1.7246153,-0.60853689,-0.71089556,-0.39829923,1.7270181,-0.60853689,-0.71089556,-0.39829923,1.7307778,-0.60853689,-0.71089556,-0.3972221,1.729421,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689,-0.71089556,-0.39829923,1.7231343,-0.60853689:5
-0.58082379,-0.58082379,1.7214358,-0.58082379,-0.58082379,-0.58082379,1.7311466,-0.58082379,-0.58082379,-0.58082379,1.7261622,-0.58082379,-0.58082379,-0.58082379,1.719083,-0.58082379,-0.58082379,-0.58082379,1.7145527,-0.58082379,-0.58082379,-0.58082379,1.7217248,-0.58082379,-0.58082379,-0.58082379,1.7200633,-0.58082379,-0.58082379,-0.58082379,1.7180201,-0.58082379,-0.58082379,-0.58082379,1.7189901,-0.58082379,-0.58082379,-0.58082379,1.7206309,-0.58082379,-0.58082379,-0.58082379,1.7160593,-0.58082379,-0.58082379,-0.58082379,1.721539,-0.58082379,-0.58082379,-0.58082379,1.7150687,-0.58082379,-0.58082379,-0.58082379,1.7177208,-0.58082379,-0.6087486,-0.52927742,1.7231695,-0.5805658,-0.60982184,-0.52820419,1.7280713,-0.58055548,-0.60982184,-0.52713095,1.7232727,-0.58055548,-0.61089508,-0.52604739,1.727834,-0.58054516,-0.61304155,-0.52390092,1.7222201,-0.58053484,-0.61304155,-0.52390092,1.7253057,-0.58053484,-0.61304155,-0.52390092,1.7207341,-0.58053484,-0.61304155,-0.52390092,1.7253882,-0.58053484,-0.61304155,-0.52390092,1.7233243,-0.58053484,-0.61196831,-0.52497415,1.7238816,-0.58054516,-0.61196831,-0.52497415,1.7182058,-0.58054516,-0.61196831,-0.52497415,1.7259971,-0.58054516,-0.61196831,-0.52497415,1.7252438,-0.58054516,-0.61196831,-0.52497415,1.7286802,-0.58054516,-0.61196831,-0.52497415,1.7261106,-0.58054516,-0.61196831,-0.52497415,1.7294438,-0.58054516,-0.61304155,-0.52390092,1.7284016,-0.58053484,-0.61089508,-0.52497415,1.7294542,-0.58054516,-0.61089508,-0.52497415,1.7234585,-0.58054516,-0.61089508,-0.52604739,1.7263789,-0.58054516,-0.61089508,-0.52604739,1.7206516,-0.58054516,-0.61089508,-0.52604739,1.7221273,-0.58054516,-0.61089508,-0.52604739,1.7165444,-0.58054516,-0.61089508,-0.52604739,1.7198569,-0.58054516,-0.61089508,-0.52713095,1.7175144,-0.58055548,-0.61089508,-0.52604739,1.719279,-0.58054516,-0.61089508,-0.52713095,1.7082061,-0.58055548,-0.61089508,-0.52604739,1.719537,-0.58054516,-0.61089508,-0.52713095,1.7078656,-0.58055548,-0.61089508,-0.52713095,1.7218177,-0.58055548,-0.60982184,-0.52713095,1.7177621,-0.58055548,-0.61089508,-0.52713095,1.723799,-0.58055548,-0.60982184,-0.52713095,1.7203316,-0.58055548,-0.60982184,-0.52713095,1.7208373,-0.58055548,-0.61089508,-0.52713095,1.7167301,-0.58055548,-0.60982184,-0.52713095,1.7190004,-0.58055548,-0.60982184,-0.52713095,1.7167095,-0.58055548,-0.60982184,-0.52820419,1.7197125,-0.58055548,-0.60982184,-0.52820419,1.7147384,-0.58055548,-0.60982184,-0.52820419,1.7158323,-0.58055548,-0.60982184,-0.52820419,1.7204658,-0.58055548,-0.60982184,-0.52820419,1.7183503,-0.58055548,-0.60982184,-0.52820419,1.7253986,-0.58055548,-0.60982184,-0.52820419,1.7190933,-0.58055548,-0.60982184,-0.52820419,1.717081,-0.58055548,-0.6087486,-0.52820419,1.7107757,-0.5805658,-0.6087486,-0.52820419,1.7122308,-0.5805658,-0.6087486,-0.52820419,1.7056985,-0.58055548,-0.60982184,-0.52820419,1.7073496,-0.58055548,-0.6087486,-0.52820419,1.7018389,-0.58055548,-0.6087486,-0.52820419,1.705296,-0.58055548,-0.6087486,-0.52820419,1.7087015,-0.58055548,-0.6087486,-0.52820419,1.7097231,-0.58055548,-0.6087486,-0.52820419,1.706524,-0.58055548,-0.6087486,-0.52820419,1.7105487,-0.5805658,-0.6087486,-0.52820419,1.710074,-0.58055548,-0.6087486,-0.52820419,1.7149242,-0.5805658,-0.6087486,-0.52820419,1.7140573,-0.5805658,-0.6087486,-0.52820419,1.7197022,-0.5805658,-0.6087486,-0.52820419,1.7212707,-0.5805658,-0.6087486,-0.52820419,1.7181336,-0.5805658,-0.6087486,-0.52820419,1.721281,-0.5805658,-0.58297026,-0.58082379,1.7140161,-0.58081347,-0.58082379,-0.56042195,1.7234894,-0.58082379,-0.58082379,-0.58082379,1.7218796,-0.58082379,-0.58082379,-0.58082379,1.7258939,-0.58082379,-0.58082379,-0.58082379,1.7225607,-0.58082379,-0.58082379,-0.58082379,1.7243047,-0.58082379,-0.58082379,-0.58082379,1.7175866,-0.58082379,-0.58082379,-0.58082379,1.7224781,-0.58082379,-0.58082379,-0.58082379,1.7189695,-0.58082379,-0.58082379,-0.58082379,1.7177414,-0.58082379,-0.58082379,-0.58082379,1.7222717,-0.58082379,-0.58082379,-0.58082379,1.7220447,-0.58082379,-0.58082379,-0.58082379,1.7166372,-0.58082379,-0.58082379,-0.58082379,1.7204761,-0.58082379,-0.58082379,-0.58082379,1.7188043,-0.58082379,-0.58082379,-0.58082379,1.722282,-0.58082379,-0.58082379,-0.58082379,1.7186908,-0.58082379,-0.58082379,-0.58082379,1.7166888,-0.58082379,-0.58082379,-0.58082379,1.7098676,-0.58082379,-0.58082379,-0.58082379,1.714532,-0.58082379,-0.58082379,-0.58082379,1.7117148,-0.58082379,-0.58082379,-0.58082379,1.7153163,-0.58082379,-0.58082379,-0.58082379,1.7104868,-0.58082379,-0.58082379,-0.58082379,1.7135517,-0.58082379,-0.58082379,-0.58082379,1.7143669,-0.58082379,-0.58082379,-0.58082379,1.7180304,-0.58082379,-0.58082379,-0.58082379,1.7124578,-0.58082379,-0.58082379,-0.58082379,1.7187321,-0.58082379,-0.58082379,-0.58082379,1.7173183,-0.58082379,-0.58082379,-0.58082379,1.7197744,-0.58082379,-0.58082379,-0.58082379,1.7143772,-0.58082379,-0.58082379,-0.58082379,1.7181026,-0.58082379,-0.58082379,-0.58082379,1.7141812,-0.58082379,-0.58082379,-0.58082379,1.7193306,-0.58082379,-0.58082379,-0.58082379,1.7164618,-0.58082379,-0.58082379,-0.58082379,1.7188147,-0.58082379,-0.58082379,-0.58082379,1.7168539,-0.58082379,-0.58082379,-0.58082379,1.7130254,-0.58082379,-0.58082379,-0.58082379,1.7139541,-0.58082379,-0.58082379,-0.58082379,1.7258423,-0.58082379,-0.58082379,-0.58082379,1.7223027,-0.58082379,-0.58082379,-0.58082379,1.7247278,-0.58082379,-0.58082379,-0.58082379,1.7204761,-0.58082379,-0.58082379,-0.58082379,1.7227258,-0.58082379,-0.58082379,-0.58082379,1.7145733,-0.58082379,-0.58082379,-0.58082379,1.7185051,-0.58082379,-0.58082379,-0.58082379,1.7153989,-0.58082379,-0.58082379,-0.58082379,1.7176382,-0.58082379,-0.58082379,-0.58082379,1.7172977,-0.58082379,-0.58082379,-0.58082379,1.7194338,-0.58082379,-0.58082379,-0.58082379,1.7164515,-0.58082379,-0.58082379,-0.58082379,1.7210334,-0.58082379,-0.58082379,-0.58082379,1.7200737,-0.58082379,-0.58082379,-0.58082379,1.7195267,-0.58082379,-0.58082379,-0.58082379,1.7229528,-0.58082379,-0.58082379,-0.58082379,1.7241912,-0.58082379,-0.58082379,-0.58082379,1.7199911,-0.58082379,-0.58082379,-0.58082379,1.7322508,-0.58082379,-0.58082379,-0.58082379,1.7271632,-0.58082379,-0.58082379,-0.58082379,1.7322095,-0.58082379,-0.58082379,-0.58082379,1.7325294,-0.58082379,-0.58082379,-0.58082379,1.7243769,-0.58082379,-0.58082379,-0.58082379,1.7206722,-0.58082379,-0.58082379,-0.58082379,1.7290104,-0.58082379,-0.58082379,-0.58082379,1.7287937,-0.58082379,-0.58082379,-0.58082379,1.7271116,-0.58082379,-0.58082379,-0.58082379,1.7259352,-0.58082379,-0.58082379,-0.58082379,1.7270291,-0.58082379,-0.58082379,-0.58082379,1.7255534,-0.58082379,-0.58082379,-0.58082379,1.7274522,-0.58082379,-0.58082379,-0.58082379,1.7276379,-0.58082379,-0.58082379,-0.58082379,1.7226742,-0.58082379,-0.58082379,-0.58082379,1.7231179,-0.58082379,-0.58082379,-0.58082379,1.7198363,-0.58082379,-0.58082379,-0.58082379,1.724088,-0.58082379,-0.58082379,-0.58082379,1.7232727,-0.58082379,-0.58082379,-0.58082379,1.725605,-0.58082379,-0.58082379,-0.58082379,1.7247691,-0.58082379,-0.58082379,-0.58082379,1.729093,-0.58082379,-0.58082379,-0.58082379,1.7283809,-0.58082379,-0.58082379,-0.58082379,1.7352744,-0.58082379,-0.58082379,-0.58082379,1.7323746,-0.58082379,-0.58082379,-0.58082379,1.7338194,-0.58082379,-0.58082379,-0.58082379,1.7353983,-0.58082379,-0.58082379,-0.58082379,1.7353983,-0.58082379,-0.58082379,-0.58082379,1.7321373,-0.58082379,-0.58082379,-0.58082379,1.7337574,-0.58082379,-0.58082379,-0.58082379,1.7344385,-0.58082379,-0.58082379,-0.58082379,1.7303313,-0.58082379,-0.58082379,-0.58082379,1.7385148,-0.58082379,-0.58082379,-0.58082379,1.7357491,-0.58082379,-0.58082379,-0.58082379,1.7379988,-0.58082379,-0.58082379,-0.58082379,1.7380194,-0.58082379,-0.58082379,-0.58082379,1.7407644,-0.58082379,-0.58082379,-0.58082379,1.7373693,-0.58082379,-0.58082379,-0.58082379,1.7351506,-0.58082379,-0.58082379,-0.58082379,1.7375654,-0.58082379,-0.58082379,-0.58082379,1.7387624,-0.58082379,-0.58082379,-0.58082379,1.7382155,-0.58082379,-0.58082379,-0.58082379,1.7401349,-0.58082379,-0.58082379,-0.58082379,1.7399801,-0.58082379,-0.58082379,-0.58082379,1.7435817,-0.58082379,-0.58082379,-0.58082379,1.740589,-0.58082379,-0.58082379,-0.58082379,1.7415074,-0.58082379,-0.58082379,-0.58082379,1.7328596,-0.58082379,-0.58082379,-0.58082379,1.735326,-0.58082379,-0.58082379,-0.58082379,1.742075,-0.58082379,-0.58082379,-0.58082379,1.7323952,-0.58082379,-0.58082379,-0.58082379,1.7330247,-0.58082379,-0.58082379,-0.58082379,1.7346759,-0.58082379,-0.58082379,-0.58082379,1.7301146,-0.58082379,-0.58082379,-0.58082379,1.7289175,-0.58082379,-0.58082379,-0.58082379,1.7389069,-0.58082379,-0.58082379,-0.58082379,1.7374209,-0.58082379,-0.58082379,-0.58082379,1.7344179,-0.58082379,-0.58082379,-0.58082379,1.7355634,-0.58082379,-0.58082379,-0.58082379,1.7345624,-0.58082379,-0.58082379,-0.58082379,1.7377821,-0.58082379,-0.58082379,-0.58082379,1.7345211,-0.58082379,-0.58082379,-0.58082379,1.742591,-0.58082379,-0.58082379,-0.58082379,1.7384632,-0.58082379,-0.58082379,-0.58082379,1.7426323,-0.58082379,-0.58082379,-0.58082379,1.739103,-0.58082379,-0.58082379,-0.58082379,1.7433959,-0.58082379,-0.58082379,-0.58082379,1.738329,-0.58082379,-0.58082379,-0.58082379,1.7380504,-0.58082379,-0.58082379,-0.58082379,1.7270291,-0.58082379,-0.58082379,-0.58082379,1.7329628,-0.58082379,-0.58082379,-0.58082379,1.7342321,-0.58082379,-0.58082379,-0.58082379,1.7332105,-0.58082379,-0.58082379,-0.58082379,1.7345211,-0.58082379,-0.58082379,-0.58082379,1.7342734,-0.58082379,-0.58082379,-0.58082379,1.7389482,-0.58082379,-0.58082379,-0.58082379,1.7354911,-0.58082379,-0.58082379,-0.58082379,1.7393094,-0.58082379,-0.58082379,-0.58082379,1.7345108,-0.58082379,-0.58082379,-0.58082379,1.7394642,-0.58082379,-0.58082379,-0.58082379,1.7327977,-0.58082379,-0.58082379,-0.58082379,1.7406509,-0.58082379,-0.58082379,-0.58082379,1.7364818,-0.58082379,-0.58082379,-0.58082379,1.7390307,-0.58082379,-0.58082379,-0.58082379,1.7393094,-0.58082379,-0.58082379,-0.58082379,1.7436126,-0.58082379,-0.58082379,-0.58082379,1.7380194,-0.58082379,-0.58082379,-0.58082379,1.7434475,-0.58082379,-0.58082379,-0.58082379,1.7378337,-0.58082379,-0.58082379,-0.58082379,1.738587,-0.58082379,-0.58082379,-0.58082379,1.7349339,-0.58082379,-0.58082379,-0.58082379,1.7456456,-0.58082379,-0.58082379,-0.58082379,1.7317038,-0.58082379,-0.58082379,-0.58082379,1.7452741,-0.58082379,-0.58082379,-0.58082379,1.7304139,-0.58082379,-0.58082379,-0.58082379,1.7391443,-0.58082379,-0.58082379,-0.58082379,1.7413011,-0.58082379,-0.58082379,-0.58082379,1.7471729,-0.58082379,-0.58082379,-0.58082379,1.7402485,-0.58082379,-0.58082379,-0.58082379,1.7446343,-0.58082379,-0.58082379,-0.58082379,1.7417551,-0.58082379,-0.58082379,-0.58082379,1.7454702,-0.58082379,-0.58082379,-0.58082379,1.7467188,-0.58082379,-0.58082379,-0.58082379,1.7452225,-0.58082379,-0.58082379,-0.58082379,1.7440048,-0.58082379,-0.58082379,-0.58082379,1.7450883,-0.58082379,-0.58082379,-0.58082379,1.7450677,-0.58082379,-0.58082379,-0.58082379,1.7405168,-0.58082379,-0.58082379,-0.58082379,1.7424053,-0.58082379,-0.58082379,-0.58082379,1.7363477,-0.58082379,-0.58082379,-0.58082379,1.7413733,-0.58082379,-0.58082379,-0.58082379,1.7413114,-0.58082379,-0.58082379,-0.58082379,1.7416106,-0.58082379,-0.58082379,-0.58082379,1.7434579,-0.58082379,-0.58082379,-0.58082379,1.7448923,-0.58082379,-0.58082379,-0.58082379,1.7437365,-0.58082379,-0.58082379,-0.58082379,1.7409296,-0.58082379,-0.58082379,-0.58082379,1.7412185,-0.58082379,-0.58082379,-0.58082379,1.7425084,-0.58082379,-0.58082379,-0.58082379,1.7457075,-0.58082379,-0.58082379,-0.58082379,1.7411463,-0.58082379,-0.58082379,-0.58082379,1.7434063,-0.58082379,-0.58082379,-0.58082379,1.7463061,-0.58082379,-0.58082379,-0.58082379,1.7461513,-0.58082379,-0.58082379,-0.58082379,1.7459965,-0.58082379,-0.58082379,-0.58082379,1.7458623,-0.58082379,-0.58082379,-0.58082379,1.7475754,-0.58082379,-0.58082379,-0.58082379,1.7475547,-0.58082379,-0.58082379,-0.58082379,1.7499902,-0.58082379,-0.58082379,-0.58082379,1.7492781,-0.58082379,-0.60982184,-0.52713095,1.7409708,-0.58055548,-0.60982184,-0.52713095,1.7436333,-0.58055548,-0.61089508,-0.52604739,1.7446962,-0.58055548,-0.61089508,-0.52497415,1.7445311,-0.58054516,-0.61196831,-0.52390092,1.7433134,-0.58054516,-0.61196831,-0.52390092,1.7429212,-0.58054516,-0.61196831,-0.52282768,1.7421885,-0.58053484,-0.61196831,-0.52390092,1.7414971,-0.58054516,-0.61196831,-0.52390092,1.7430141,-0.58054516,-0.61196831,-0.52390092,1.7433134,-0.58054516,-0.61196831,-0.52390092,1.7419512,-0.58054516,-0.61196831,-0.52390092,1.7443453,-0.58054516,-0.61196831,-0.52390092,1.7403723,-0.58054516,-0.61196831,-0.52390092,1.7416416,-0.58054516,-0.61196831,-0.52390092,1.739361,-0.58054516,-0.61196831,-0.52497415,1.7423124,-0.58054516,-0.61196831,-0.52497415,1.7373074,-0.58054516,-0.61196831,-0.52497415,1.7414971,-0.58054516,-0.61089508,-0.52497415,1.7378543,-0.58054516,-0.61089508,-0.52497415,1.7409811,-0.58054516,-0.61089508,-0.52497415,1.7340257,-0.58054516,-0.61089508,-0.52497415,1.7411566,-0.58054516,-0.61089508,-0.52604739,1.7365437,-0.58055548,-0.61089508,-0.52604739,1.7423124,-0.58055548,-0.61089508,-0.52604739,1.7371216,-0.58055548,-0.61089508,-0.52604739,1.7429316,-0.58055548,-0.61089508,-0.52604739,1.735842,-0.58055548,-0.61089508,-0.52604739,1.7427561,-0.58055548,-0.61089508,-0.52604739,1.7355427,-0.58055548,-0.60982184,-0.52604739,1.7411256,-0.58055548,-0.61089508,-0.52604739,1.7326016,-0.58055548,-0.60982184,-0.52604739,1.7405168,-0.58055548,-0.60982184,-0.52604739,1.7367604,-0.58055548,-0.60982184,-0.52604739,1.7425291,-0.58055548,-0.60982184,-0.52713095,1.7344695,-0.58055548,-0.60982184,-0.52713095,1.7378543,-0.58055548,-0.60982184,-0.52713095,1.7344076,-0.58055548,-0.60982184,-0.52713095,1.7347688,-0.58055548,-0.60982184,-0.52713095,1.7333859,-0.58055548,-0.60982184,-0.52713095,1.7356872,-0.58055548,-0.60982184,-0.52713095,1.7344695,-0.58055548,-0.60982184,-0.52713095,1.7337162,-0.58055548,-0.60982184,-0.52713095,1.7349751,-0.58055548,-0.60982184,-0.52713095,1.7349339,-0.58055548,-0.60982184,-0.52713095,1.7401762,-0.58055548,-0.60982184,-0.52713095,1.7431276,-0.58055548,-0.60982184,-0.52713095,1.7400421,-0.58055548,-0.60982184,-0.52820419,1.7323849,-0.5805658,-0.6087486,-0.52713095,1.738102,-0.58055548,-0.6087486,-0.52820419,1.7336336,-0.5805658,-0.6087486,-0.52713095,1.7366779,-0.58055548,-0.6087486,-0.52713095,1.7382361,-0.58055548,-0.6087486,-0.52820419,1.7391855,-0.5805658,-0.6087486,-0.52820419,1.735326,-0.5805658,-0.6087486,-0.52820419,1.7373177,-0.5805658,-0.60982184,-0.52820419,1.7373177,-0.5805658,-0.6087486,-0.52820419,1.7366572,-0.5805658,-0.6087486,-0.52820419,1.7377821,-0.5805658,-0.6087486,-0.52820419,1.7384735,-0.5805658,-0.6087486,-0.52820419,1.7354602,-0.5805658,-0.6087486,-0.52820419,1.7392578,-0.5805658,-0.6087486,-0.52820419,1.7366985,-0.5805658,-0.6087486,-0.52820419,1.7394539,-0.5805658,-0.6087486,-0.52820419,1.7397428,-0.5805658,-0.6087486,-0.52820419,1.7403001,-0.5805658,-0.6087486,-0.52820419,1.7363889,-0.5805658,-0.6087486,-0.52820419,1.7390307,-0.5805658,-0.6087486,-0.52820419,1.7386799,-0.5805658,-0.6087486,-0.52820419,1.740331,-0.5805658,-0.6087486,-0.52820419,1.7420853,-0.5805658,-0.6087486,-0.52820419,1.7422092,-0.5805658,-0.6087486,-0.52820419,1.7403413,-0.5805658,-0.6087486,-0.52820419,1.7440461,-0.5805658,-0.6087486,-0.52820419,1.7466466,-0.5805658,-0.6087486,-0.52927742,1.7323746,-0.5805658,-0.6087486,-0.52820419,1.7489582,-0.5805658,-0.6087486,-0.52820419,1.7478953,-0.5805658,-0.6087486,-0.52820419,1.7478437,-0.5805658,-0.6087486,-0.52820419,1.7437778,-0.5805658,-0.6087486,-0.52820419,1.7489788,-0.5805658,-0.6087486,-0.52820419,1.7480088,-0.5805658,-0.6087486,-0.52820419,1.7467085,-0.5805658,-0.6087486,-0.52820419,1.749371,-0.5805658,-0.6087486,-0.52820419,1.7523533,-0.5805658,-0.61089508,-0.52497415,1.7500521,-0.58054516,-0.6087486,-0.52927742,1.751373,-0.5805658,-0.6087486,-0.52927742,1.7503926,-0.5805658,-0.6087486,-0.52820419,1.7454289,-0.5805658,-0.6087486,-0.52820419,1.7517238,-0.5805658,-0.6087486,-0.52927742,1.7516413,-0.5805658,-0.6087486,-0.52820419,1.7505371,-0.5805658,-0.6087486,-0.52927742,1.7510737,-0.5805658,-0.6087486,-0.52927742,1.7513523,-0.5805658,-0.6087486,-0.52927742,1.7512595,-0.5805658,-0.60766504,-0.52927742,1.7497838,-0.58057611,-0.58082379,-0.58082379,1.7508776,-0.58082379,-0.58082379,-0.58082379,1.7508776,-0.58082379,-0.58082379,-0.58082379,1.7508776,-0.58082379,-0.58082379,-0.58082379,1.7508776,-0.58082379,-0.58082379,-0.58082379,1.7508776,-0.58082379,-0.58082379,-0.58082379,1.7508776,-0.58082379,-0.58082379,-0.58082379,1.7508776,-0.58082379:5
-0.58779261,-0.58779261,1.7292623,-0.58779261,-0.58779261,-0.58779261,1.7270885,-0.58779261,-0.58779261,-0.58779261,1.7285019,-0.58779261,-0.58779261,-0.58779261,1.7272737,-0.58779261,-0.58779261,-0.58779261,1.7262306,-0.58779261,-0.58779261,-0.58779261,1.7277123,-0.58779261,-0.58779261,-0.58779261,1.7285702,-0.58779261,-0.58779261,-0.58779261,1.7285799,-0.58779261,-0.58779261,-0.58779261,1.7287554,-0.58779261,-0.58779261,-0.58779261,1.727995,-0.58779261,-0.58779261,-0.58779261,1.7278683,-0.58779261,-0.58779261,-0.58779261,1.7277903,-0.58779261,-0.64866026,-0.46097853,1.7266498,-0.58720772,-0.65171144,-0.45488591,1.7265816,-0.58717848,-0.65475287,-0.44880305,1.7290771,-0.58714923,-0.65576668,-0.44676568,1.7280633,-0.58713949,-0.58779261,-0.58779261,1.727956,-0.58779261,-0.58779261,-0.58779261,1.7278001,-0.58779261,-0.58779261,-0.58779261,1.7274686,-0.58779261,-0.58779261,-0.58779261,1.7276149,-0.58779261,-0.58779261,-0.58779261,1.7273419,-0.58779261,-0.65373906,-0.44981686,1.7276928,-0.58714923,-0.65576668,-0.44676568,1.7287262,-0.58713949,-0.65678049,-0.44676568,1.7293403,-0.58713949,-0.65576668,-0.44676568,1.7286384,-0.58713949,-0.65576668,-0.44777949,1.7296815,-0.58713949,-0.65475287,-0.44880305,1.7278781,-0.58714923,-0.65475287,-0.44981686,1.7271275,-0.58714923,-0.65373906,-0.45083067,1.728034,-0.58715898,-0.65272525,-0.45184448,1.7261916,-0.58715898,-0.65272525,-0.45285829,1.7276539,-0.58716873,-0.65171144,-0.4538721,1.728151,-0.58716873,-0.58779261,-0.58779261,1.728385,-0.58779261,-0.58779261,-0.58779261,1.7288236,-0.58779261,-0.58779261,-0.58779261,1.7290283,-0.58779261,-0.58779261,-0.58779261,1.7283167,-0.58779261,-0.58779261,-0.58779261,1.7285019,-0.58779261,-0.58779261,-0.58779261,1.7289504,-0.58779261,-0.58779261,-0.58779261,1.729545,-0.58779261,-0.58779261,-0.58779261,1.7286482,-0.58779261,-0.58779261,-0.58779261,1.7298764,-0.58779261,-0.58779261,-0.58779261,1.7301494,-0.58779261,-0.58779261,-0.58779261,1.7290186,-0.58779261,-0.58779261,-0.58779261,1.729701,-0.58779261,-0.58779261,-0.58779261,1.7277318,-0.58779261,-0.58779261,-0.58779261,1.7300617,-0.58779261,-0.58779261,-0.58779261,1.7294573,-0.58779261,-0.58779261,-0.58779261,1.7303541,-0.58779261,-0.58779261,-0.58779261,1.731056,-0.58779261,-0.58779261,-0.58779261,1.7300324,-0.58779261,-0.58779261,-0.58779261,1.7319723,-0.58779261,-0.58779261,-0.58779261,1.7315239,-0.58779261,-0.58779261,-0.58779261,1.7303639,-0.58779261,-0.58779261,-0.58779261,1.7303736,-0.58779261,-0.58779261,-0.58779261,1.7293598,-0.58779261,-0.58779261,-0.58779261,1.7307343,-0.58779261,-0.58779261,-0.58779261,1.7301396,-0.58779261,-0.58779261,-0.58779261,1.7296522,-0.58779261,-0.58779261,-0.58779261,1.7302079,-0.58779261,-0.58779261,-0.58779261,1.7293793,-0.58779261,-0.58779261,-0.58779261,1.7304126,-0.58779261,-0.58779261,-0.58779261,1.7305198,-0.58779261,-0.58779261,-0.58779261,1.7301104,-0.58779261,-0.58779261,-0.58779261,1.7314654,-0.58779261,-0.58779261,-0.58779261,1.7307538,-0.58779261,-0.58779261,-0.58779261,1.7304418,-0.58779261,-0.58779261,-0.58779261,1.7308708,-0.58779261,-0.58779261,-0.58779261,1.7308708,-0.58779261,-0.58779261,-0.58779261,1.7322355,-0.58779261,-0.58779261,-0.58779261,1.7318943,-0.58779261,-0.58779261,-0.58779261,1.7340974,-0.58779261,-0.58779261,-0.58779261,1.7350332,-0.58779261,-0.58779261,-0.58779261,1.7331128,-0.58779261,-0.58779261,-0.58779261,1.7319138,-0.58779261,-0.58779261,-0.58779261,1.728346,-0.58779261,-0.58779261,-0.58779261,1.7300812,-0.58779261,-0.58779261,-0.58779261,1.7304418,-0.58779261,-0.58779261,-0.58779261,1.7301494,-0.58779261,-0.58779261,-0.58779261,1.692034,-0.58779261,-0.58779261,-0.58779261,1.7302859,-0.58779261,-0.58779261,-0.58779261,1.7282387,-0.58779261,-0.58779261,-0.58779261,1.7299447,-0.58779261,-0.58779261,-0.58779261,1.7304028,-0.58779261,-0.58779261,-0.58779261,1.7296815,-0.58779261,-0.58779261,-0.58779261,1.7291063,-0.58779261,-0.58779261,-0.58779261,1.7293403,-0.58779261,-0.58779261,-0.58779261,1.7288334,-0.58779261,-0.58779261,-0.58779261,1.7288334,-0.58779261,-0.58779261,-0.58779261,1.7302566,-0.58779261,-0.58779261,-0.58779261,1.7311145,-0.58779261,-0.58779261,-0.58779261,1.7300909,-0.58779261,-0.58779261,-0.58779261,1.7333175,-0.58779261,-0.58779261,-0.58779261,1.7330349,-0.58779261,-0.58779261,-0.58779261,1.7339414,-0.58779261,-0.58779261,-0.58779261,1.7330251,-0.58779261,-0.58779261,-0.58779261,1.7340097,-0.58779261,-0.58779261,-0.58779261,1.7339902,-0.58779261,-0.58779261,-0.58779261,1.7354816,-0.58779261,-0.58779261,-0.58779261,1.7346238,-0.58779261,-0.58779261,-0.58779261,1.734887,-0.58779261,-0.58779261,-0.58779261,1.7341559,-0.58779261,-0.58779261,-0.58779261,1.7342339,-0.58779261,-0.58779261,-0.58779261,1.7332201,-0.58779261,-0.58779261,-0.58779261,1.7336587,-0.58779261,-0.58779261,-0.58779261,1.7334345,-0.58779261,-0.58779261,-0.58779261,1.7341851,-0.58779261,-0.58779261,-0.58779261,1.7349552,-0.58779261,-0.58779261,-0.58779261,1.7332103,-0.58779261,-0.58779261,-0.58779261,1.7339609,-0.58779261,-0.58779261,-0.58779261,1.7331518,-0.58779261,-0.58779261,-0.58779261,1.7325767,-0.58779261,-0.58779261,-0.58779261,1.7344678,-0.58779261,-0.58779261,-0.58779261,1.7326547,-0.58779261,-0.58779261,-0.58779261,1.7333273,-0.58779261,-0.58779261,-0.58779261,1.7340194,-0.58779261,-0.58779261,-0.58779261,1.7341656,-0.58779261,-0.58779261,-0.58779261,1.733727,-0.58779261,-0.58779261,-0.58779261,1.7347993,-0.58779261,-0.58779261,-0.58779261,1.7349552,-0.58779261,-0.58779261,-0.58779261,1.7266595,-0.58779261,-0.58779261,-0.58779261,1.730939,-0.58779261,-0.58779261,-0.58779261,1.7304516,-0.58779261,-0.58779261,-0.58779261,1.7302761,-0.58779261,-0.58779261,-0.58779261,1.7306563,-0.58779261,-0.58779261,-0.58779261,1.7309487,-0.58779261,-0.58779261,-0.58779261,1.7290771,-0.58779261,-0.58779261,-0.58779261,1.7291453,-0.58779261,-0.58779261,-0.58779261,1.7291746,-0.58779261,-0.58779261,-0.58779261,1.7282485,-0.58779261,-0.58779261,-0.58779261,1.729818,-0.58779261,-0.58779261,-0.58779261,1.7294768,-0.58779261,-0.58779261,-0.58779261,1.7311924,-0.58779261,-0.58779261,-0.58779261,1.7321868,-0.58779261,-0.58779261,-0.58779261,1.7318846,-0.58779261,-0.58779261,-0.58779261,1.7328204,-0.58779261,-0.58779261,-0.58779261,1.7333663,-0.58779261,-0.58779261,-0.58779261,1.7330349,-0.58779261,-0.58779261,-0.58779261,1.733376,-0.58779261,-0.58779261,-0.58779261,1.7346628,-0.58779261,-0.58779261,-0.58779261,1.7340487,-0.58779261,-0.58779261,-0.58779261,1.7334443,-0.58779261,-0.58779261,-0.58779261,1.7340292,-0.58779261,-0.58779261,-0.58779261,1.7325864,-0.58779261,-0.58779261,-0.58779261,1.7326254,-0.58779261,-0.58779261,-0.58779261,1.7325962,-0.58779261,-0.58779261,-0.58779261,1.7335223,-0.58779261,-0.58779261,-0.58779261,1.7133923,-0.58779261,-0.58779261,-0.58779261,1.7324695,-0.58779261,-0.58779261,-0.58779261,1.7327522,-0.58779261,-0.58779261,-0.58779261,1.732489,-0.58779261,-0.64866026,-0.46097853,1.7311827,-0.58720772,-0.65068788,-0.45792735,1.7306465,-0.58718823,-0.65272525,-0.4538721,1.7301299,-0.58716873,-0.65373906,-0.45083067,1.7317676,-0.58715898,-0.65576668,-0.44777949,1.7314167,-0.58713949,-0.65678049,-0.44676568,1.732489,-0.58713949,-0.65576668,-0.44676568,1.7312607,-0.58713949,-0.65576668,-0.44777949,1.7305686,-0.58713949,-0.65576668,-0.44880305,1.7301689,-0.58714923,-0.65475287,-0.44981686,1.7313777,-0.58714923,-0.65373906,-0.45083067,1.732216,-0.58715898,-0.65373906,-0.45184448,1.7331226,-0.58715898,-0.65272525,-0.45285829,1.7313874,-0.58716873,-0.65272525,-0.45285829,1.7315434,-0.58716873,-0.65272525,-0.4538721,1.7318846,-0.58716873,-0.65171144,-0.45488591,1.731134,-0.58717848,-0.65171144,-0.45589972,1.7323232,-0.58717848,-0.65171144,-0.45589972,1.7307635,-0.58717848,-0.65171144,-0.45589972,1.7276539,-0.58717848,-0.65068788,-0.45691353,1.7270982,-0.58718823,-0.65068788,-0.45691353,1.7266498,-0.58718823,-0.65068788,-0.45792735,1.7264158,-0.58718823,-0.65068788,-0.45792735,1.726874,-0.58718823,-0.64967407,-0.45792735,1.726718,-0.58718823,-0.65068788,-0.45894116,1.7270885,-0.58718823,-0.64967407,-0.45894116,1.7304321,-0.58719797,-0.64967407,-0.45894116,1.7318066,-0.58719797,-0.64967407,-0.45894116,1.7308415,-0.58719797,-0.64967407,-0.45894116,1.7315044,-0.58719797,-0.64967407,-0.45894116,1.7317578,-0.58719797,-0.64967407,-0.45894116,1.7314264,-0.58719797,-0.64967407,-0.45894116,1.7314556,-0.58719797,-0.64967407,-0.45894116,1.729623,-0.58719797,-0.64967407,-0.45894116,1.7306173,-0.58719797,-0.64967407,-0.45894116,1.7305003,-0.58719797,-0.64967407,-0.45894116,1.7301884,-0.58719797,-0.65068788,-0.45894116,1.7308708,-0.58718823,-0.65068788,-0.45792735,1.7332883,-0.58718823,-0.65068788,-0.45691353,1.7341266,-0.58718823,-0.65068788,-0.45691353,1.7328496,-0.58718823,-0.65068788,-0.45691353,1.732489,-0.58718823,-0.64967407,-0.45894116,1.6931648,-0.58718823,-0.65068788,-0.45792735,1.7326254,-0.58718823,-0.65068788,-0.45792735,1.7322647,-0.58718823,-0.65068788,-0.45691353,1.7322258,-0.58718823,-0.65068788,-0.45691353,1.7320015,-0.58718823,-0.65068788,-0.45691353,1.7327327,-0.58718823,-0.65068788,-0.45691353,1.73206,-0.58718823,-0.65068788,-0.45691353,1.7331226,-0.58718823,-0.65068788,-0.45691353,1.7332981,-0.58718823,-0.65068788,-0.45691353,1.733571,-0.58718823,-0.65068788,-0.45691353,1.7341169,-0.58718823,-0.65068788,-0.45691353,1.7339804,-0.58718823,-0.65068788,-0.45691353,1.7343119,-0.58718823,-0.65068788,-0.45691353,1.736047,-0.58718823,-0.65068788,-0.45691353,1.7349942,-0.58718823,-0.65068788,-0.45691353,1.7335613,-0.58718823,-0.65068788,-0.45691353,1.7336587,-0.58718823,-0.65068788,-0.45691353,1.7338829,-0.58718823,-0.65068788,-0.45691353,1.7338829,-0.58718823,-0.65068788,-0.45691353,1.7347115,-0.58718823,-0.65068788,-0.45691353,1.735004,-0.58718823,-0.65068788,-0.45691353,1.7345653,-0.58718823,-0.65068788,-0.45691353,1.7343119,-0.58718823,-0.65068788,-0.45691353,1.7339512,-0.58718823,-0.65068788,-0.45691353,1.7334735,-0.58718823,-0.65068788,-0.45691353,1.735082,-0.58718823,-0.65068788,-0.45691353,1.7353062,-0.58718823,-0.65068788,-0.45792735,1.7320795,-0.58718823,-0.65068788,-0.45792735,1.7330836,-0.58718823,-0.65068788,-0.45792735,1.7319528,-0.58718823,-0.65068788,-0.45792735,1.7304808,-0.58718823,-0.65068788,-0.45792735,1.7309975,-0.58718823,-0.65068788,-0.45792735,1.7312607,-0.58718823,-0.65068788,-0.45792735,1.732177,-0.58718823,-0.65068788,-0.45691353,1.7317286,-0.58718823,-0.65068788,-0.45691353,1.7320113,-0.58718823,-0.65068788,-0.45792735,1.7336295,-0.58718823,-0.65068788,-0.45792735,1.7342826,-0.58718823,-0.65068788,-0.45691353,1.7355011,-0.58718823,-0.65068788,-0.45691353,1.7353549,-0.58718823,-0.65068788,-0.45691353,1.735121,-0.58718823,-0.65068788,-0.45792735,1.7349747,-0.58718823,-0.65068788,-0.45792735,1.7350235,-0.58718823,-0.65068788,-0.45691353,1.7343119,-0.58718823,-0.65171144,-0.45691353,1.7343996,-0.58718823,-0.65068788,-0.45691353,1.7366807,-0.58718823,-0.65068788,-0.45691353,1.7373728,-0.58718823,-0.65068788,-0.45691353,1.7356766,-0.58718823,-0.65068788,-0.45691353,1.7377042,-0.58718823,-0.65068788,-0.45691353,1.7376945,-0.58718823,-0.65068788,-0.45691353,1.7378407,-0.58718823,-0.65068788,-0.45691353,1.7380259,-0.58718823,-0.65068788,-0.45792735,1.7378894,-0.58718823,-0.65068788,-0.45792735,1.7382696,-0.58718823,-0.65068788,-0.45691353,1.7388058,-0.58718823,-0.65068788,-0.45792735,1.739147,-0.58718823,-0.65068788,-0.45792735,1.7373046,-0.58718823,-0.65068788,-0.45792735,1.7366514,-0.58718823,-0.65068788,-0.45792735,1.7383671,-0.58718823,-0.65068788,-0.45691353,1.7395369,-0.58718823,-0.65068788,-0.45691353,1.7396149,-0.58718823,-0.65068788,-0.45792735,1.7383866,-0.58718823,-0.65068788,-0.45792735,1.7383964,-0.58718823,-0.65068788,-0.45792735,1.7370414,-0.58718823,-0.65068788,-0.45792735,1.7372753,-0.58718823,-0.65068788,-0.45792735,1.7388253,-0.58718823,-0.65068788,-0.45691353,1.7396636,-0.58718823,-0.65068788,-0.45691353,1.7410771,-0.58718823,-0.65171144,-0.45691353,1.7404532,-0.58718823,-0.65068788,-0.45691353,1.740502,-0.58718823,-0.65068788,-0.45691353,1.7415938,-0.58718823,-0.65068788,-0.45691353,1.7412233,-0.58718823,-0.65068788,-0.45691353,1.7406482,-0.58718823,-0.65068788,-0.45691353,1.7372168,-0.58718823,-0.65068788,-0.45691353,1.7373143,-0.58718823,-0.65068788,-0.45691353,1.7382891,-0.58718823,-0.65068788,-0.45691353,1.7375775,-0.58718823,-0.65068788,-0.45691353,1.7370706,-0.58718823,-0.65068788,-0.45691353,1.7371583,-0.58718823,-0.65068788,-0.45792735,1.7359106,-0.58718823,-0.64967407,-0.45792735,1.7344971,-0.58719797,-0.65068788,-0.45792735,1.7345946,-0.58718823,-0.65068788,-0.45792735,1.7349065,-0.58718823,-0.65068788,-0.45792735,1.7356181,-0.58718823,-0.65068788,-0.45792735,1.7363005,-0.58718823,-0.65068788,-0.45792735,1.7359008,-0.58718823,-0.65068788,-0.45792735,1.7376262,-0.58718823,-0.65068788,-0.45792735,1.7380454,-0.58718823,-0.65068788,-0.45792735,1.7369341,-0.58718823,-0.65068788,-0.45691353,1.7384353,-0.58718823,-0.65068788,-0.45691353,1.7390885,-0.58718823,-0.65068788,-0.45691353,1.7399073,-0.58718823,-0.65068788,-0.45691353,1.7401803,-0.58718823,-0.65068788,-0.45691353,1.7404435,-0.58718823,-0.65068788,-0.45691353,1.7403362,-0.58718823,-0.65068788,-0.45691353,1.7408334,-0.58718823,-0.65068788,-0.45691353,1.7411161,-0.58718823,-0.65068788,-0.45691353,1.7404142,-0.58718823,-0.65068788,-0.45691353,1.740229,-0.58718823,-0.65068788,-0.45792735,1.7398586,-0.58718823,-0.65068788,-0.45792735,1.7395661,-0.58718823,-0.65068788,-0.45691353,1.7403557,-0.58718823,-0.65068788,-0.45691353,1.7402485,-0.58718823,-0.65068788,-0.45792735,1.7370219,-0.58718823,-0.65068788,-0.45792735,1.737441,-0.58718823,-0.64967407,-0.45792735,1.7357643,-0.58719797,-0.65068788,-0.45691353,1.7347895,-0.58718823,-0.65068788,-0.45691353,1.7361348,-0.58718823,-0.65068788,-0.45691353,1.7361348,-0.58718823,-0.64967407,-0.45792735,1.7243005,-0.58718823,-0.64967407,-0.45792735,1.7213955,-0.58718823,-0.64967407,-0.45894116,1.7204694,-0.58718823,-0.64967407,-0.45792735,1.7197286,-0.58718823,-0.65068788,-0.45792735,1.7182079,-0.58718823,-0.64967407,-0.45792735,1.7174768,-0.58718823,-0.65068788,-0.45792735,1.7178082,-0.58718823,-0.65068788,-0.45691353,1.717701,-0.58717848,-0.65068788,-0.45691353,1.7169991,-0.58717848,-0.65068788,-0.45691353,1.7168139,-0.58717848,-0.65068788,-0.45691353,1.7084499,-0.58717848,-0.65068788,-0.45691353,1.7137919,-0.58717848,-0.65068788,-0.45691353,1.7151177,-0.58717848,-0.58779261,-0.58779261,1.7156441,-0.58779261,-0.58779261,-0.58779261,1.7157806,-0.58779261,-0.58779261,-0.58779261,1.7175742,-0.58779261,-0.58779261,-0.58779261,1.7168334,-0.58779261,-0.58779261,-0.58779261,1.7165994,-0.58779261,-0.58779261,-0.58779261,1.7167359,-0.58779261,-0.58779261,-0.58779261,1.7172915,-0.58779261,-0.58779261,-0.58779261,1.7164532,-0.58779261,-0.58779261,-0.58779261,1.7183054,-0.58779261,-0.58779261,-0.58779261,1.7176522,-0.58779261,-0.58779261,-0.58779261,1.7176327,-0.58779261,-0.58779261,-0.58779261,1.7176815,-0.58779261,-0.58779261,-0.58779261,1.7183833,-0.58779261,-0.58779261,-0.58779261,1.7185491,-0.58779261,-0.58779261,-0.58779261,1.7184613,-0.58779261,-0.58779261,-0.58779261,1.717701,-0.58779261,-0.58779261,-0.58779261,1.7195336,-0.58779261,-0.58779261,-0.58779261,1.7200308,-0.58779261,-0.58779261,-0.58779261,1.7195824,-0.58779261,-0.58779261,-0.58779261,1.7208009,-0.58779261,-0.58779261,-0.58779261,1.7204694,-0.58779261,-0.58779261,-0.58779261,1.7198846,-0.58779261,-0.58779261,-0.58779261,1.7203525,-0.58779261,-0.58779261,-0.58779261,1.7205864,-0.58779261,-0.58779261,-0.58779261,1.7208204,-0.58779261,-0.58779261,-0.58779261,1.7211616,-0.58779261,-0.58779261,-0.58779261,1.7224581,-0.58779261,-0.58779261,-0.58779261,1.7202745,-0.58779261,-0.58779261,-0.58779261,1.7203525,-0.58779261,-0.58779261,-0.58779261,1.7202355,-0.58779261,-0.58779261,-0.58779261,1.7192607,-0.58779261,-0.58779261,-0.58779261,1.7199723,-0.58779261,-0.58779261,-0.58779261,1.7205669,-0.58779261,-0.58779261,-0.58779261,1.7202257,-0.58779261,-0.58779261,-0.58779261,1.7199138,-0.58779261,-0.58779261,-0.58779261,1.7201185,-0.58779261,-0.58779261,-0.58779261,1.7199625,-0.58779261,-0.58779261,-0.58779261,1.6813597,-0.58779261,-0.58779261,-0.58779261,1.7205864,-0.58779261,-0.58779261,-0.58779261,1.7189,-0.58779261,-0.58779261,-0.58779261,1.7188415,-0.58779261,-0.58779261,-0.58779261,1.7195239,-0.58779261,-0.58779261,-0.58779261,1.7200113,-0.58779261,-0.58779261,-0.58779261,1.7208594,-0.58779261,-0.58779261,-0.58779261,1.7181396,-0.58779261,-0.58779261,-0.58779261,1.717701,-0.58779261,-0.58779261,-0.58779261,1.7192217,-0.58779261,-0.58779261,-0.58779261,1.7192217,-0.58779261,-0.58779261,-0.58779261,1.7192217,-0.58779261,-0.58779261,-0.58779261,1.7192217,-0.58779261,-0.58779261,-0.58779261,1.7192217,-0.58779261,-0.58779261,-0.58779261,1.7192217,-0.58779261:5
-1.352876,-1.352876,1.2354872,-1.352876,-1.352876,-1.352876,1.2407519,-1.352876,-1.352876,-1.352876,1.2390439,-1.352876,-1.2857315,1.3900675,1.2313576,-1.3413735,-1.2868558,1.3833541,1.2298116,-1.3413951,-1.2857315,1.3788786,1.2278441,-1.341406,-0.32553701,-0.18676177,1.2303414,-1.3444329,-0.32441271,-0.17669713,1.2307414,-1.3444005,-0.32441271,-0.17333504,1.2309684,-1.3444005,-0.32329922,-0.17221074,1.2310441,-1.3444005,-0.32441271,-0.16997296,1.231163,-1.3443897,-0.32329922,-0.16773517,1.2321467,-1.3443897,-0.32329922,-0.16549738,1.2325792,-1.3443789,-0.4172971,0.51604398,1.2312495,-1.3428546,-0.4172971,0.51491969,1.2318765,-1.342887,-0.4184214,0.51044411,1.2296603,-1.3428978,-0.4184214,0.50931981,1.2286657,-1.3428978,-1.2857315,1.3766408,1.2290117,-1.3414168,-1.2857315,1.374403,1.2285792,-1.3414276,-1.2857315,1.3755165,1.2294333,-1.3414276,-1.2857315,1.3710409,1.2270225,-1.3414276,-1.2868558,1.3497765,1.2141039,-1.34146,-0.44192357,0.51828177,1.2154012,-1.3428762,-0.47101481,0.59661514,1.2152066,-1.3427357,-0.46653923,0.61787952,1.2273901,-1.3427032,-0.46877702,0.61899301,1.2271739,-1.3426924,-0.46766353,0.6212308,1.2284171,-1.3426924,-0.46766353,0.61899301,1.2290009,-1.3426924,-0.47101481,0.60780407,1.2192713,-1.3427248,-0.47101481,0.60892837,1.2201686,-1.342714,-0.4721391,0.6044528,1.2171741,-1.3427248,-0.47101481,0.60780407,1.2195524,-1.3427248,-0.4721391,0.60892837,1.2196281,-1.342714,-0.47101481,0.61004186,1.2209037,-1.342714,-0.47101481,0.61004186,1.2202659,-1.342714,-0.4721391,0.60780407,1.2188065,-1.3427248,-0.4721391,0.60556629,1.218666,-1.3427248,-0.47101481,0.61116616,1.2205146,-1.342714,-0.4721391,0.61004186,1.2206875,-1.342714,-0.4721391,0.61004186,1.221001,-1.342714,-0.47325259,0.6044528,1.2179525,-1.3427248,-0.47325259,0.60669059,1.2178335,-1.3427248,-0.47325259,0.6044528,1.217239,-1.3427248,-0.46990132,0.6234794,1.2280495,-1.3426924,-0.46990132,0.61899301,1.2255523,-1.3427032,-0.47101481,0.61899301,1.2256928,-1.3427032,-0.47325259,0.60780407,1.2186551,-1.3427248,-0.4721391,0.60780407,1.2186443,-1.342714,-0.47325259,0.60780407,1.2189038,-1.3427248,-0.47325259,0.60669059,1.2177687,-1.3427357,-0.47101481,0.60669059,1.2204065,-1.3427248,-0.47437689,0.6033285,1.2158228,-1.3427248,-0.47325259,0.60669059,1.2177579,-1.3427248,-0.4721391,0.59661514,1.2159525,-1.3427573,-0.47325259,0.60556629,1.217293,-1.3427248,-0.47437689,0.6033285,1.2157363,-1.3427248,-0.47325259,0.60556629,1.2176822,-1.3427248,-0.4721391,0.60780407,1.2190551,-1.3427248,-0.47325259,0.60556629,1.2173471,-1.3427248,-0.47325259,0.60556629,1.21712,-1.3427248,-0.47437689,0.6044528,1.2166552,-1.3427248,-0.47437689,0.60221501,1.2153039,-1.3427357,-0.4721391,0.61004186,1.2200929,-1.342714,-0.47437689,0.60556629,1.2166228,-1.3427248,-0.47550119,0.59661514,1.2116607,-1.3427465,-0.47437689,0.59885293,1.2132499,-1.3427357,-0.47437689,0.59997722,1.2137255,-1.3427357,-0.47550119,0.59661514,1.2118985,-1.3427465,-0.47550119,0.59773944,1.2121364,-1.3427357,-0.47550119,0.59773944,1.2117364,-1.3427465,-0.47437689,0.59997722,1.2138444,-1.3427357,-0.47437689,0.59885293,1.2133363,-1.3427357,-0.47437689,0.59773944,1.2122769,-1.3427357,-0.47437689,0.60109071,1.214785,-1.3427357,-0.47325259,0.60221501,1.2153471,-1.3427357,-0.47325259,0.60109071,1.2162011,-1.3427357,-0.47437689,0.60221501,1.2152931,-1.3427357,-0.47325259,0.60669059,1.2180498,-1.3427248,-0.47325259,0.60556629,1.2181579,-1.3427248,-0.4721391,0.61675522,1.2239956,-1.3427032,-0.47101481,0.61564174,1.2247091,-1.342714,-0.4721391,0.61451744,1.2231848,-1.342714,-0.47101481,0.61787952,1.2248064,-1.3427032,-0.47101481,0.61899301,1.2253685,-1.3427032,-0.47101481,0.61899301,1.2251307,-1.3426924,-0.4721391,0.61564174,1.2233469,-1.3427032,-0.4721391,0.61564174,1.2234767,-1.3427032,-0.47101481,0.61451744,1.2240929,-1.342714,-0.47101481,0.61787952,1.2253685,-1.3427032,-0.47101481,0.61787952,1.2249685,-1.3427032,-0.47101481,0.62011731,1.2264496,-1.3427032,-0.46877702,0.63019276,1.2325575,-1.3426816,-0.46877702,0.63243055,1.2341899,-1.3426708,-0.46877702,0.63130625,1.2331089,-1.3426816,-0.47101481,0.61899301,1.2255631,-1.3427032,-0.4721391,0.61227965,1.2215308,-1.342714,-0.47101481,0.61451744,1.2239415,-1.342714,-0.46766353,0.63354403,1.2344602,-1.3426708,-0.46877702,0.62906846,1.2318981,-1.3426816,-0.46877702,0.63130625,1.2339953,-1.3426816,-0.46877702,0.62906846,1.2321684,-1.3426816,-0.46877702,0.63354403,1.2341791,-1.3426708,-0.46766353,0.63690612,1.2365358,-1.3426708,-0.46990132,0.6234794,1.228136,-1.3426924,-0.46990132,0.62459288,1.2288171,-1.3426924,-0.46766353,0.63801961,1.2368709,-1.3426708,-0.46766353,0.63690612,1.2358656,-1.3426708,-0.46653923,0.63466833,1.236471,-1.3426708,-0.46766353,0.63466833,1.2350548,-1.3426708,-0.46766353,0.63801961,1.2373034,-1.3426708,-0.46653923,0.64473297,1.2408709,-1.3426492,-0.46653923,0.64138169,1.2397682,-1.34266,-0.46766353,0.6212308,1.2303522,-1.3427032,-0.46877702,0.62795497,1.2309143,-1.3426924,-0.46653923,0.64249518,1.2403952,-1.34266,-0.46766353,0.63801961,1.2369034,-1.3426708,-0.46653923,0.64473297,1.2405357,-1.3426492,-0.46542574,0.64585727,1.2415735,-1.3426492,-0.46990132,0.63578182,1.2317359,-1.34266,-0.46877702,0.62571718,1.2302225,-1.3427032,-0.46877702,0.64697076,1.238806,-1.3426384,-0.46766353,0.64138169,1.2382547,-1.34266,-0.46653923,0.64138169,1.2392385,-1.34266,-0.46653923,0.63466833,1.2358764,-1.3426708,-0.46990132,0.6212308,1.2274982,-1.3426924,-0.46990132,0.62011731,1.2268604,-1.3427032,-0.46766353,0.63578182,1.2351629,-1.3426708,-0.46766353,0.63354403,1.2335089,-1.3426708,-0.46766353,0.63466833,1.2345683,-1.3426708,-0.46990132,0.61787952,1.2257685,-1.3427032,-0.47101481,0.62011731,1.2254226,-1.3427032,-0.47101481,0.62459288,1.2277036,-1.3426924,-0.46990132,0.6402574,1.2347737,-1.3426492,-0.46766353,0.63578182,1.2352494,-1.3426708,-0.46990132,0.6402574,1.2345467,-1.3426492,-0.47101481,0.61899301,1.2251307,-1.3426816,-0.47101481,0.6212308,1.2262334,-1.3426924,-0.47101481,0.62011731,1.2260712,-1.3427032,-0.46877702,0.63801961,1.2349791,-1.3426708,-0.46877702,0.63130625,1.2327521,-1.3426816,-0.46877702,0.63466833,1.2348061,-1.3426708,-0.46877702,0.63243055,1.2342224,-1.3426816,-0.46877702,0.63019276,1.2324386,-1.3426816,-0.47101481,0.62011731,1.226028,-1.3427032,-0.47101481,0.62011731,1.2255523,-1.3427032,-0.46766353,0.63801961,1.2363412,-1.34266,-0.46766353,0.63914391,1.237552,-1.34266,-0.46877702,0.63019276,1.2328927,-1.3426816,-0.46877702,0.63019276,1.2318981,-1.3426816,-0.46877702,0.63019276,1.2317467,-1.3426816,-0.46877702,0.63243055,1.2335953,-1.3426816,-0.4721391,0.61564174,1.2227848,-1.342714,-0.4721391,0.61564174,1.2228929,-1.3427032,-0.46990132,0.6234794,1.2280928,-1.3426924,-0.47101481,0.6234794,1.2280387,-1.3426924,-0.46990132,0.6234794,1.2275631,-1.3426924,-0.47101481,0.6223551,1.2269901,-1.3426924,-0.47325259,0.61004186,1.2196281,-1.342714,-0.47325259,0.60892837,1.2190984,-1.3427248,-0.46990132,0.6223551,1.2279198,-1.3426924,-0.47101481,0.6223551,1.2275847,-1.3426924,-0.46990132,0.62459288,1.2290765,-1.3426924,-0.47101481,0.6234794,1.2282009,-1.3426924,-0.47101481,0.62011731,1.2260604,-1.3427032,-0.4721391,0.60780407,1.2198551,-1.3427248,-0.47325259,0.60892837,1.2187957,-1.3427248,-0.47101481,0.6234794,1.2281684,-1.3426924,-0.46990132,0.62459288,1.2288603,-1.3426924,-0.46990132,0.62459288,1.2289144,-1.3426924,-0.47325259,0.60892837,1.2192389,-1.3427248,-0.47325259,0.61227965,1.2207092,-1.342714,-0.4721391,0.61451744,1.2221145,-1.342714,-0.4721391,0.61564174,1.2232064,-1.3427032,-0.4721391,0.61451744,1.2226226,-1.342714,-0.4721391,0.61564174,1.2228388,-1.342714,-0.4721391,0.61564174,1.2233686,-1.3427032,-0.4721391,0.61340395,1.2219091,-1.342714,-0.4721391,0.61675522,1.2238442,-1.3427032,-0.47325259,0.61451744,1.2221578,-1.342714,-0.46990132,0.62683067,1.2293576,-1.3426816,-0.46990132,0.62571718,1.2290873,-1.3426924,-0.46990132,0.62795497,1.2306873,-1.3426816,-0.47661468,0.59213956,1.2083527,-1.3427465,-0.47661468,0.59325305,1.2091094,-1.3427465,-0.47325259,0.60780407,1.2181795,-1.3427248,-0.47325259,0.60780407,1.2182984,-1.3427248,-0.47325259,0.61116616,1.21992,-1.342714,-0.47437689,0.60780407,1.2173038,-1.3427248,-0.4721391,0.61451744,1.2215848,-1.3427032,-0.47437689,0.60669059,1.217293,-1.3427248,-0.47437689,0.60780407,1.2181146,-1.3427248,-0.47773898,0.59325305,1.2085473,-1.3427465,-0.4721391,0.61451744,1.2218659,-1.342714,-0.46990132,0.62683067,1.2302441,-1.3426924,-0.46877702,0.62011731,1.2293252,-1.3427032,-0.46990132,0.6223551,1.2290009,-1.3426924,-0.4721391,0.62795497,1.2275198,-1.34266,-0.4721391,0.60669059,1.2209902,-1.3427465,-0.47325259,0.61116616,1.2204713,-1.342714,-0.47101481,0.62683067,1.229509,-1.3426816,-0.47101481,0.62795497,1.2294765,-1.3426816,-0.47101481,0.62459288,1.228709,-1.3426924,-0.46990132,0.62571718,1.2291522,-1.3426924,-0.47325259,0.61451744,1.2222118,-1.342714,-0.47437689,0.60556629,1.2168065,-1.3427248,-0.4721391,0.61564174,1.2226442,-1.3427032,-0.47101481,0.62683067,1.22899,-1.3426816,-0.47101481,0.62683067,1.2294873,-1.3426924,-0.46990132,0.62683067,1.2302008,-1.3426924,-0.47325259,0.61340395,1.2208497,-1.342714,-0.47437689,0.60556629,1.2162444,-1.3427248,-0.47325259,0.61227965,1.2200173,-1.342714,-0.46990132,0.62795497,1.2302116,-1.3426816,-0.47101481,0.62571718,1.2289576,-1.3427032,-0.47101481,0.6234794,1.2278225,-1.3426924,-0.47325259,0.61340395,1.221001,-1.342714,-0.47550119,0.60109071,1.2137796,-1.3427357,-0.4721391,0.62011731,1.2258982,-1.3427032,-0.4721391,0.6223551,1.2265252,-1.3426924,-0.4721391,0.61899301,1.2248712,-1.3427032,-0.4721391,0.62011731,1.2245469,-1.3427032,-0.4721391,0.62011731,1.2253793,-1.3427032,-0.47661468,0.59997722,1.213185,-1.3427465,-0.47437689,0.60780407,1.2183741,-1.3427248,-0.47101481,0.6212308,1.2265793,-1.3427032,-0.47101481,0.6234794,1.2271522,-1.3426924,-0.47101481,0.62459288,1.2282225,-1.3426924,-0.47101481,0.6234794,1.2275522,-1.3426924,-0.47325259,0.61675522,1.2228929,-1.3427032,-0.47101481,0.62683067,1.2293792,-1.3426816,-0.46990132,0.63130625,1.2314657,-1.3426816,-0.46990132,0.62683067,1.2300711,-1.3426924,-0.47325259,0.61451744,1.2217578,-1.342714,-0.4721391,0.61675522,1.2239307,-1.3427032,-0.46877702,0.63243055,1.2331413,-1.3426816,-0.46877702,0.63354403,1.2336386,-1.3426708,-0.46990132,0.63130625,1.2321575,-1.3426816,-0.46877702,0.63690612,1.2354115,-1.3426708,-0.4721391,0.61899301,1.2241253,-1.3427032,-0.47101481,0.6223551,1.2269252,-1.3426924,-0.4721391,0.61787952,1.224082,-1.3427032,-0.46990132,0.62906846,1.2303197,-1.3426816,-0.46990132,0.62795497,1.2296279,-1.3426924,-0.46990132,0.63130625,1.2314116,-1.3426816,-0.47325259,0.61340395,1.2221253,-1.3427357,-0.47437689,0.62011731,1.2223632,-1.3426924,-0.46990132,0.63130625,1.2315305,-1.3426816,-0.46990132,0.63130625,1.2323521,-1.3426816,-0.46990132,0.63243055,1.2319413,-1.3426816,-0.46990132,0.63130625,1.2317035,-1.3426816,-0.46877702,0.63690612,1.2355521,-1.3426708,-0.46877702,0.63466833,1.2344278,-1.3426708,-0.46877702,0.63801961,1.2358007,-1.3426708,-0.46990132,0.63578182,1.2340926,-1.3426708,-0.46766353,0.63466833,1.2363845,-1.3426708,-0.46990132,0.63466833,1.2337791,-1.3426708,-0.46877702,0.63801961,1.2357034,-1.3426708,-0.46877702,0.63466833,1.2343521,-1.3426708,-0.46877702,0.63466833,1.2353575,-1.3426708,-0.46990132,0.63354403,1.2333575,-1.3426708,-0.46877702,0.63354403,1.2346764,-1.3426816,-0.46766353,0.63019276,1.2345899,-1.3427032,-0.46877702,0.63914391,1.2361358,-1.34266,-0.47101481,0.63466833,1.2328386,-1.3426708,-0.46990132,0.63690612,1.2351196,-1.3426708,-0.46990132,0.63130625,1.2315954,-1.3426816,-0.46990132,0.63466833,1.233844,-1.3426708,-0.46990132,0.63690612,1.2348278,-1.3426708,-0.46877702,0.64138169,1.237325,-1.34266,-0.47101481,0.63466833,1.231844,-1.3426708,-0.47101481,0.62906846,1.22979,-1.3426816,-0.46990132,0.63354403,1.2321575,-1.3426708,-0.47101481,0.62906846,1.2306333,-1.3426816,-0.46990132,0.63466833,1.234071,-1.3426708,-0.47101481,0.62906846,1.230417,-1.3426816,-0.47101481,0.63019276,1.230417,-1.3426816,-0.47101481,0.62795497,1.2294225,-1.3426816,-0.4721391,0.63801961,1.2312062,-1.3426492,-0.46990132,0.62683067,1.23099,-1.3427032,-0.47101481,0.62795497,1.2292495,-1.3426816,-0.46990132,0.63019276,1.2310873,-1.3426816,-0.46990132,0.63130625,1.2316494,-1.3426708,-0.47101481,0.62906846,1.2299738,-1.3426816,-0.47101481,0.63130625,1.2317359,-1.3426816,-0.47101481,0.63466833,1.2332494,-1.3426708,-0.46990132,0.63578182,1.234644,-1.3426708,-0.46990132,0.63578182,1.2341683,-1.3426708,-0.46877702,0.6402574,1.2368277,-1.34266,-0.46990132,0.63801961,1.2357467,-1.3426708,-0.46877702,0.64138169,1.2372385,-1.34266,-0.46990132,0.63578182,1.2337143,-1.3426708,-0.46877702,0.6402574,1.2362872,-1.34266,-0.46990132,0.63690612,1.2346224,-1.3426708,-0.46877702,0.63914391,1.2360493,-1.34266,-0.47101481,0.63130625,1.2311846,-1.3426816,-0.46877702,0.6402574,1.2365574,-1.34266,-0.47101481,0.63354403,1.2323846,-1.3426816,-0.47101481,0.62906846,1.2298441,-1.3426816,-0.4721391,0.62459288,1.2273793,-1.3426924,-0.47101481,0.62795497,1.2293036,-1.3426816,-0.4721391,0.6223551,1.2263631,-1.3426924,-0.47101481,0.62906846,1.2295522,-1.3426816,-0.47101481,0.62795497,1.2288819,-1.3426924,-0.4721391,0.62683067,1.2282441,-1.3426924,-0.47101481,0.62795497,1.2290333,-1.3426816,-0.47101481,0.62571718,1.2283522,-1.3426924,-0.47101481,0.62683067,1.2288063,-1.3426924,-0.4721391,0.6223551,1.2255847,-1.3426924,-0.4721391,0.6234794,1.2262225,-1.3426924,-0.4721391,0.6223551,1.2257253,-1.3426924,-0.4721391,0.62571718,1.2280495,-1.3426924,-0.47101481,0.62683067,1.2283738,-1.3426924,-0.4721391,0.61564174,1.2238226,-1.3427248,-0.47101481,0.63130625,1.2308278,-1.34266,-0.46990132,0.63243055,1.2319305,-1.3426816,-0.46877702,0.63914391,1.2362115,-1.3426708,-0.46877702,0.64138169,1.2372818,-1.34266,-0.46990132,0.63019276,1.2314224,-1.3426816,-0.46766353,0.63801961,1.2384493,-1.3426816,-0.46990132,0.63801961,1.2353467,-1.3426708,-0.46877702,0.64249518,1.2383628,-1.34266,-0.46877702,0.62906846,1.2316819,-1.3426816,-0.46877702,0.63578182,1.2354007,-1.3426708,-0.46877702,0.64138169,1.2374872,-1.34266,-0.46877702,0.63801961,1.235498,-1.3426708,-0.46766353,0.64361948,1.2390547,-1.34266,-0.46877702,0.64249518,1.2381682,-1.34266,-0.47101481,0.63243055,1.2318008,-1.3426816,-0.46877702,0.64138169,1.2372493,-1.34266,-0.47101481,0.62795497,1.2292279,-1.3426924,-0.46877702,0.64138169,1.237498,-1.34266,-0.46877702,0.6402574,1.2367412,-1.34266,-0.46877702,0.6402574,1.2365034,-1.34266,-0.4721391,0.62795497,1.2285252,-1.3426816,-0.47101481,0.63130625,1.2308495,-1.3426816,-0.46990132,0.63914391,1.2358331,-1.34266,-0.46877702,0.63801961,1.2354007,-1.3426708,-0.46990132,0.63578182,1.2337899,-1.3426708,-0.47101481,0.63354403,1.2323305,-1.3426816,-0.4721391,0.6212308,1.2254442,-1.3427032,-0.46990132,0.63690612,1.2342116,-1.3426708,-0.46990132,0.63801961,1.2346656,-1.3426708,-0.46990132,0.63801961,1.2346224,-1.3426708,-0.47101481,0.63130625,1.2306981,-1.3426816,-0.47101481,0.63243055,1.2316386,-1.3426816,-0.46990132,0.63801961,1.2344926,-1.3426708,-0.46990132,0.63578182,1.2333251,-1.3426708,-0.46990132,0.63243055,1.2319413,-1.3426816,-0.47101481,0.63243055,1.2318224,-1.3426816,-0.47101481,0.63466833,1.2327413,-1.3426708,-0.46990132,0.63801961,1.2350332,-1.3426708,-0.47101481,0.63130625,1.23099,-1.3426816,-0.47101481,0.62571718,1.2294008,-1.3426924,-0.47101481,0.63466833,1.2326656,-1.3426708,-0.47101481,0.63466833,1.2327305,-1.3426708,-0.4721391,0.62571718,1.2270009,-1.3426924,-0.47101481,0.63466833,1.2321359,-1.3426708,-0.47101481,0.63130625,1.2306765,-1.3426816,-0.47101481,0.63466833,1.2330332,-1.3426708,-0.47101481,0.63801961,1.2342224,-1.3426708,-0.47101481,0.63801961,1.2342224,-1.3426708,-0.47101481,0.63801961,1.2342224,-1.3426708,-0.47101481,0.63801961,1.2342224,-1.3426708,-0.47101481,0.63801961,1.2342224,-1.3426708,-0.47101481,0.63801961,1.2342224,-1.3426708:5
-0.57882627,-0.57882627,1.726624,-0.57882627,-0.57882627,-0.57882627,1.7255944,-0.57882627,-0.57882627,-0.57882627,1.7222017,-0.57882627,-0.57882627,-0.57882627,1.7255944,-0.57882627,-0.57882627,-0.57882627,1.7241334,-0.57882627,-0.57882627,-0.57882627,1.7261925,-0.57882627,-0.57882627,-0.57882627,1.7264279,-0.57882627,-0.57882627,-0.57882627,1.7267024,-0.57882627,-0.57882627,-0.57882627,1.7290655,-0.57882627,-0.57882627,-0.57882627,1.7288106,-0.57882627,-0.57882627,-0.57882627,1.7280359,-0.57882627,-0.57882627,-0.57882627,1.7288106,-0.57882627,-0.57882627,-0.57882627,1.7267122,-0.57882627,-0.57882627,-0.57882627,1.7260651,-0.57882627,-0.57882627,-0.57882627,1.7273986,-0.57882627,-0.57882627,-0.57882627,1.7254767,-0.57882627,-0.57882627,-0.57882627,1.7266926,-0.57882627,-0.57882627,-0.57882627,1.7253296,-0.57882627,-0.57882627,-0.57882627,1.7247511,-0.57882627,-0.57882627,-0.57882627,1.7248492,-0.57882627,-0.57882627,-0.57882627,1.7260062,-0.57882627,-0.57882627,-0.57882627,1.72531,-0.57882627,-0.57882627,-0.57882627,1.7285164,-0.57882627,-0.57882627,-0.57882627,1.7283693,-0.57882627,-0.57882627,-0.57882627,1.7288498,-0.57882627,-0.57882627,-0.57882627,1.7280654,-0.57882627,-0.57882627,-0.57882627,1.728487,-0.57882627,-0.57882627,-0.57882627,1.7286145,-0.57882627,-0.57882627,-0.57882627,1.729546,-0.57882627,-0.57882627,-0.57882627,1.7273005,-0.57882627,-0.57882627,-0.57882627,1.7252218,-0.57882627,-0.57882627,-0.57882627,1.7273692,-0.57882627,-0.57882627,-0.57882627,1.7261435,-0.57882627,-0.57882627,-0.57882627,1.7304971,-0.57882627,-0.57882627,-0.57882627,1.7312619,-0.57882627,-0.57882627,-0.57882627,1.7316934,-0.57882627,-0.57882627,-0.57882627,1.7316934,-0.57882627,-0.57882627,-0.57882627,1.7312031,-0.57882627,-0.57882627,-0.57882627,1.7308403,-0.57882627,-0.57882627,-0.57882627,1.7317032,-0.57882627,-0.57882627,-0.57882627,1.7325464,-0.57882627,-0.57882627,-0.57882627,1.7303598,-0.57882627,-0.57882627,-0.57882627,1.7311541,-0.57882627,-0.57882627,-0.57882627,1.7318993,-0.57882627,-0.57882627,-0.57882627,1.7295852,-0.57882627,-0.57882627,-0.57882627,1.7288792,-0.57882627,-0.57882627,-0.57882627,1.729242,-0.57882627,-0.57882627,-0.57882627,1.7272613,-0.57882627,-0.57882627,-0.57882627,1.727732,-0.57882627,-0.57882627,-0.57882627,1.7283889,-0.57882627,-0.57882627,-0.57882627,1.7278006,-0.57882627,-0.57882627,-0.57882627,1.7278693,-0.57882627,-0.57882627,-0.57882627,1.7280261,-0.57882627,-0.57882627,-0.57882627,1.729497,-0.57882627,-0.57882627,-0.57882627,1.7280752,-0.57882627,-0.57882627,-0.57882627,1.728134,-0.57882627,-0.57882627,-0.57882627,1.7264377,-0.57882627,-0.57882627,-0.57882627,1.7260847,-0.57882627,-0.57882627,-0.57882627,1.7279575,-0.57882627,-0.57882627,-0.57882627,1.7267612,-0.57882627,-0.57882627,-0.57882627,1.7247119,-0.57882627,-0.57882627,-0.57882627,1.7251532,-0.57882627,-0.57882627,-0.57882627,1.7279575,-0.57882627,-0.57882627,-0.57882627,1.7278594,-0.57882627,-0.57882627,-0.57882627,1.7239765,-0.57882627,-0.57882627,-0.57882627,1.722741,-0.57882627,-0.57882627,-0.57882627,1.7222311,-0.57882627,-0.57882627,-0.57882627,1.7224076,-0.57882627,-0.57882627,-0.57882627,1.7240844,-0.57882627,-0.57882627,-0.57882627,1.7226528,-0.57882627,-0.57882627,-0.57882627,1.7256042,-0.57882627,-0.57882627,-0.57882627,1.7242118,-0.57882627,-0.57882627,-0.57882627,1.7243687,-0.57882627,-0.57882627,-0.57882627,1.7247413,-0.57882627,-0.57882627,-0.57882627,1.7245452,-0.57882627,-0.57882627,-0.57882627,1.7240353,-0.57882627,-0.57882627,-0.57882627,1.7239177,-0.57882627,-0.57882627,-0.57882627,1.7261925,-0.57882627,-0.57882627,-0.57882627,1.7267416,-0.57882627,-0.57882627,-0.57882627,1.7257611,-0.57882627,-0.57882627,-0.57882627,1.724506,-0.57882627,-0.57882627,-0.57882627,1.7252218,-0.57882627,-0.57882627,-0.57882627,1.7258493,-0.57882627,-0.57882627,-0.57882627,1.725614,-0.57882627,-0.57882627,-0.57882627,1.7276535,-0.57882627,-0.57882627,-0.57882627,1.7280065,-0.57882627,-0.57882627,-0.57882627,1.7281242,-0.57882627,-0.57882627,-0.57882627,1.7270358,-0.57882627,-0.57882627,-0.57882627,1.7277124,-0.57882627,-0.57882627,-0.57882627,1.7239961,-0.57882627,-0.57882627,-0.57882627,1.7282517,-0.57882627,-0.57882627,-0.57882627,1.7266926,-0.57882627,-0.57882627,-0.57882627,1.7254767,-0.57882627,-0.57882627,-0.57882627,1.7250845,-0.57882627,-0.57882627,-0.57882627,1.7276143,-0.57882627,-0.57882627,-0.57882627,1.7265651,-0.57882627,-0.57882627,-0.57882627,1.7264573,-0.57882627,-0.57882627,-0.57882627,1.726977,-0.57882627,-0.57882627,-0.57882627,1.7276535,-0.57882627,-0.57882627,-0.57882627,1.7289086,-0.57882627,-0.57882627,-0.57882627,1.7292616,-0.57882627,-0.57882627,-0.57882627,1.7296146,-0.57882627,-0.57882627,-0.57882627,1.7289282,-0.57882627,-0.57882627,-0.57882627,1.7278398,-0.57882627,-0.57882627,-0.57882627,1.7298794,-0.57882627,-0.57882627,-0.57882627,1.7285458,-0.57882627,-0.57882627,-0.57882627,1.7283105,-0.57882627,-0.57882627,-0.57882627,1.7264279,-0.57882627,-0.57882627,-0.57882627,1.7279379,-0.57882627,-0.57882627,-0.57882627,1.7287223,-0.57882627,-0.57882627,-0.57882627,1.7280556,-0.57882627,-0.57882627,-0.57882627,1.7260356,-0.57882627,-0.57882627,-0.57882627,1.7266338,-0.57882627,-0.57882627,-0.57882627,1.7268593,-0.57882627,-0.57882627,-0.57882627,1.7246727,-0.57882627,-0.57882627,-0.57882627,1.7262416,-0.57882627,-0.57882627,-0.57882627,1.7266436,-0.57882627,-0.57882627,-0.57882627,1.7277712,-0.57882627,-0.57882627,-0.57882627,1.7269573,-0.57882627,-0.57882627,-0.57882627,1.7276633,-0.57882627,-0.57882627,-0.57882627,1.7277222,-0.57882627,-0.57882627,-0.57882627,1.7286537,-0.57882627,-0.57882627,-0.57882627,1.7277712,-0.57882627,-0.57882627,-0.57882627,1.7272613,-0.57882627,-0.57882627,-0.57882627,1.7273103,-0.57882627,-0.57882627,-0.57882627,1.7270358,-0.57882627,-0.57882627,-0.57882627,1.7275163,-0.57882627,-0.57882627,-0.57882627,1.725918,-0.57882627,-0.57882627,-0.57882627,1.7231038,-0.57882627,-0.57882627,-0.57882627,1.7256238,-0.57882627,-0.57882627,-0.57882627,1.726624,-0.57882627,-0.57882627,-0.57882627,1.7280065,-0.57882627,-0.57882627,-0.57882627,1.7263004,-0.57882627,-0.57882627,-0.57882627,1.7270162,-0.57882627,-0.57882627,-0.57882627,1.7282615,-0.57882627,-0.57882627,-0.57882627,1.7282615,-0.57882627,-0.57882627,-0.57882627,1.7280457,-0.57882627,-0.57882627,-0.57882627,1.7270848,-0.57882627,-0.57882627,-0.57882627,1.7287027,-0.57882627,-0.57882627,-0.57882627,1.7277516,-0.57882627,-0.57882627,-0.57882627,1.7310952,-0.57882627,-0.57882627,-0.57882627,1.7289184,-0.57882627,-0.57882627,-0.57882627,1.7293989,-0.57882627,-0.57882627,-0.57882627,1.7313502,-0.57882627,-0.57882627,-0.57882627,1.7304775,-0.57882627,-0.57882627,-0.57882627,1.7300559,-0.57882627,-0.57882627,-0.57882627,1.7303892,-0.57882627,-0.57882627,-0.57882627,1.7303598,-0.57882627,-0.57882627,-0.57882627,1.7328406,-0.57882627,-0.57882627,-0.57882627,1.7335662,-0.57882627,-0.57882627,-0.57882627,1.7302029,-0.57882627,-0.57882627,-0.57882627,1.7307226,-0.57882627,-0.57882627,-0.57882627,1.7311639,-0.57882627,-0.57882627,-0.57882627,1.7303892,-0.57882627,-0.57882627,-0.57882627,1.7303696,-0.57882627,-0.57882627,-0.57882627,1.7293695,-0.57882627,-0.57882627,-0.57882627,1.7293008,-0.57882627,-0.57882627,-0.57882627,1.7288792,-0.57882627,-0.57882627,-0.57882627,1.7298794,-0.57882627,-0.57882627,-0.57882627,1.7292714,-0.57882627,-0.57882627,-0.57882627,1.7292714,-0.57882627,-0.57882627,-0.57882627,1.7297813,-0.57882627,-0.57882627,-0.57882627,1.729193,-0.57882627,-0.57882627,-0.57882627,1.7300951,-0.57882627,-0.57882627,-0.57882627,1.7316051,-0.57882627,-0.57882627,-0.57882627,1.7315953,-0.57882627,-0.57882627,-0.57882627,1.7300559,-0.57882627,-0.57882627,-0.57882627,1.7298598,-0.57882627,-0.57882627,-0.57882627,1.7304285,-0.57882627,-0.57882627,-0.57882627,1.7305559,-0.57882627,-0.57882627,-0.57882627,1.7287714,-0.57882627,-0.57882627,-0.57882627,1.7288302,-0.57882627,-0.57882627,-0.57882627,1.7283987,-0.57882627,-0.57882627,-0.57882627,1.7303402,-0.57882627,-0.57882627,-0.57882627,1.7318012,-0.57882627,-0.57882627,-0.57882627,1.730752,-0.57882627,-0.57882627,-0.57882627,1.7304775,-0.57882627,-0.57882627,-0.57882627,1.731105,-0.57882627,-0.57882627,-0.57882627,1.7276928,-0.57882627,-0.57882627,-0.57882627,1.7296538,-0.57882627,-0.57882627,-0.57882627,1.7293597,-0.57882627,-0.57882627,-0.57882627,1.7297127,-0.57882627,-0.57882627,-0.57882627,1.7288498,-0.57882627,-0.57882627,-0.57882627,1.7276045,-0.57882627,-0.57882627,-0.57882627,1.7298499,-0.57882627,-0.57882627,-0.57882627,1.7296636,-0.57882627,-0.57882627,-0.57882627,1.7309089,-0.57882627,-0.57882627,-0.57882627,1.7299872,-0.57882627,-0.57882627,-0.57882627,1.7287615,-0.57882627,-0.57882627,-0.57882627,1.7297911,-0.57882627,-0.57882627,-0.57882627,1.7282222,-0.57882627,-0.57882627,-0.57882627,1.7284576,-0.57882627,-0.57882627,-0.57882627,1.7302618,-0.57882627,-0.57882627,-0.57882627,1.7290361,-0.57882627,-0.57882627,-0.57882627,1.7284772,-0.57882627,-0.57882627,-0.57882627,1.7291342,-0.57882627,-0.57882627,-0.57882627,1.7287615,-0.57882627,-0.57882627,-0.57882627,1.7289478,-0.57882627,-0.57882627,-0.57882627,1.7322523,-0.57882627,-0.57882627,-0.57882627,1.7315757,-0.57882627,-0.57882627,-0.57882627,1.7305755,-0.57882627,-0.57882627,-0.57882627,1.7319679,-0.57882627,-0.57882627,-0.57882627,1.7275849,-0.57882627,-0.57882627,-0.57882627,1.7272221,-0.57882627,-0.57882627,-0.57882627,1.7264671,-0.57882627,-0.57882627,-0.57882627,1.7276731,-0.57882627,-0.57882627,-0.57882627,1.72783,-0.57882627,-0.57882627,-0.57882627,1.727075,-0.57882627,-0.57882627,-0.57882627,1.7264082,-0.57882627,-0.57882627,-0.57882627,1.7270946,-0.57882627,-0.57882627,-0.57882627,1.7273692,-0.57882627,-0.57882627,-0.57882627,1.7251826,-0.57882627,-0.57882627,-0.57882627,1.7268103,-0.57882627,-0.57882627,-0.57882627,1.7272907,-0.57882627,-0.57882627,-0.57882627,1.7268593,-0.57882627,-0.57882627,-0.57882627,1.7274574,-0.57882627,-0.57882627,-0.57882627,1.7278104,-0.57882627,-0.57882627,-0.57882627,1.726771,-0.57882627,-0.57882627,-0.57882627,1.7274182,-0.57882627,-0.57882627,-0.57882627,1.7249668,-0.57882627,-0.57882627,-0.57882627,1.7286929,-0.57882627,-0.57882627,-0.57882627,1.7312815,-0.57882627,-0.57882627,-0.57882627,1.7305755,-0.57882627,-0.57882627,-0.57882627,1.7316345,-0.57882627,-0.57882627,-0.57882627,1.7311639,-0.57882627,-0.57882627,-0.57882627,1.7290557,-0.57882627,-0.57882627,-0.57882627,1.7289675,-0.57882627,-0.57882627,-0.57882627,1.7289478,-0.57882627,-0.57882627,-0.57882627,1.727026,-0.57882627,-0.57882627,-0.57882627,1.7273692,-0.57882627,-0.57882627,-0.57882627,1.7279967,-0.57882627,-0.57882627,-0.57882627,1.7273594,-0.57882627,-0.57882627,-0.57882627,1.7294381,-0.57882627,-0.57882627,-0.57882627,1.7284085,-0.57882627,-0.57882627,-0.57882627,1.7299578,-0.57882627,-0.57882627,-0.57882627,1.7311148,-0.57882627,-0.57882627,-0.57882627,1.7302814,-0.57882627,-0.57882627,-0.57882627,1.7313011,-0.57882627,-0.57882627,-0.57882627,1.7311443,-0.57882627,-0.57882627,-0.57882627,1.7297323,-0.57882627,-0.57882627,-0.57882627,1.7311737,-0.57882627,-0.57882627,-0.57882627,1.7317228,-0.57882627,-0.57882627,-0.57882627,1.7314384,-0.57882627,-0.57882627,-0.57882627,1.7305363,-0.57882627,-0.57882627,-0.57882627,1.7310952,-0.57882627,-0.57882627,-0.57882627,1.733527,-0.57882627,-0.57882627,-0.57882627,1.7341643,-0.57882627,-0.57882627,-0.57882627,1.7333211,-0.57882627,-0.57882627,-0.57882627,1.7309972,-0.57882627,-0.57882627,-0.57882627,1.7324386,-0.57882627,-0.57882627,-0.57882627,1.7326543,-0.57882627,-0.57882627,-0.57882627,1.7344193,-0.57882627,-0.57882627,-0.57882627,1.7344879,-0.57882627,-0.57882627,-0.57882627,1.7312423,-0.57882627,-0.57882627,-0.57882627,1.7341349,-0.57882627,-0.57882627,-0.57882627,1.7350272,-0.57882627,-0.57882627,-0.57882627,1.7353704,-0.57882627,-0.57882627,-0.57882627,1.7372236,-0.57882627,-0.57882627,-0.57882627,1.7371648,-0.57882627,-0.57882627,-0.57882627,1.737606,-0.57882627,-0.57882627,-0.57882627,1.7376551,-0.57882627,-0.57882627,-0.57882627,1.7367235,-0.57882627,-0.57882627,-0.57882627,1.7374982,-0.57882627,-0.57882627,-0.57882627,1.7373021,-0.57882627,-0.57882627,-0.57882627,1.7377923,-0.57882627,-0.57882627,-0.57882627,1.736047,-0.57882627,-0.57882627,-0.57882627,1.7364686,-0.57882627,-0.57882627,-0.57882627,1.7370863,-0.57882627,-0.57882627,-0.57882627,1.7365176,-0.57882627,-0.57882627,-0.57882627,1.7350762,-0.57882627,-0.57882627,-0.57882627,1.7353116,-0.57882627,-0.57882627,-0.57882627,1.7355763,-0.57882627,-0.57882627,-0.57882627,1.7330073,-0.57882627,-0.59506405,-0.53518235,1.7356646,-0.57854191,-0.596074,-0.53214267,1.7326151,-0.5785223,-0.59709377,-0.53011295,1.7312423,-0.5785125,-0.59810373,-0.53011295,1.7314482,-0.57850269,-0.59709377,-0.53011295,1.7318306,-0.5785125,-0.59709377,-0.53112291,1.7320856,-0.5785125,-0.59709377,-0.53214267,1.7316443,-0.5785223,-0.596074,-0.53214267,1.7301637,-0.5785223,-0.596074,-0.53214267,1.7299284,-0.5785223,-0.596074,-0.53315263,1.7324288,-0.5785223,-0.57882627,-0.57882627,1.731762,-0.57882627,-0.57882627,-0.57882627,1.7323601,-0.57882627,-0.57882627,-0.57882627,1.7340369,-0.57882627,-0.57882627,-0.57882627,1.7344683,-0.57882627,-0.57882627,-0.57882627,1.7337427,-0.57882627,-0.57882627,-0.57882627,1.7331152,-0.57882627,-0.57882627,-0.57882627,1.7345664,-0.57882627,-0.57882627,-0.57882627,1.7347429,-0.57882627,-0.57882627,-0.57882627,1.7323209,-0.57882627,-0.57882627,-0.57882627,1.735792,-0.57882627,-0.57882627,-0.57882627,1.7359783,-0.57882627,-0.57882627,-0.57882627,1.7365667,-0.57882627,-0.57882627,-0.57882627,1.7358607,-0.57882627,-0.57882627,-0.57882627,1.7351743,-0.57882627,-0.57882627,-0.57882627,1.7362725,-0.57882627,-0.57882627,-0.57882627,1.7375864,-0.57882627,-0.57882627,-0.57882627,1.7377433,-0.57882627,-0.57882627,-0.57882627,1.7388317,-0.57882627,-0.57882627,-0.57882627,1.7387435,-0.57882627,-0.57882627,-0.57882627,1.7394004,-0.57882627,-0.57882627,-0.57882627,1.7384003,-0.57882627,-0.57882627,-0.57882627,1.738714,-0.57882627,-0.57882627,-0.57882627,1.7394887,-0.57882627,-0.57882627,-0.57882627,1.7388023,-0.57882627,-0.57882627,-0.57882627,1.7396554,-0.57882627,-0.57882627,-0.57882627,1.7383611,-0.57882627,-0.57882627,-0.57882627,1.7379786,-0.57882627,-0.57882627,-0.57882627,1.7381846,-0.57882627,-0.57882627,-0.57882627,1.7364392,-0.57882627,-0.57882627,-0.57882627,1.7374197,-0.57882627,-0.57882627,-0.57882627,1.7363509,-0.57882627,-0.57882627,-0.57882627,1.7346154,-0.57882627,-0.57882627,-0.57882627,1.7356548,-0.57882627,-0.57882627,-0.57882627,1.7344781,-0.57882627,-0.59709377,-0.53214267,1.7352331,-0.5785223,-0.59810373,-0.53011295,1.7348801,-0.57850269,-0.59810373,-0.53011295,1.7361548,-0.57850269,-0.59709377,-0.53112291,1.7355567,-0.5785125,-0.59709377,-0.53112291,1.7355567,-0.5785125,-0.59709377,-0.53214267,1.7369393,-0.5785125,-0.596074,-0.53214267,1.7372138,-0.5785223,-0.596074,-0.53214267,1.7379786,-0.5785223,-0.596074,-0.53315263,1.7383905,-0.5785223,-0.596074,-0.53315263,1.7375276,-0.5785223,-0.596074,-0.53315263,1.740126,-0.57853211,-0.596074,-0.53417239,1.7414596,-0.57853211,-0.596074,-0.53417239,1.7409987,-0.57853211,-0.596074,-0.53417239,1.7418028,-0.57853211,-0.59506405,-0.53417239,1.7462446,-0.57853211,-0.59506405,-0.53417239,1.7470781,-0.57853211,-0.59506405,-0.53417239,1.7488136,-0.57853211,-0.59506405,-0.53417239,1.7507453,-0.57853211,-0.59506405,-0.53417239,1.7509022,-0.57853211,-0.59506405,-0.53518235,1.7506865,-0.57853211,-0.59506405,-0.53518235,1.7509218,-0.57853211,-0.59506405,-0.53518235,1.7517651,-0.57853211,-0.59506405,-0.53518235,1.7524612,-0.57854191,-0.59506405,-0.53518235,1.752324,-0.57854191,-0.59506405,-0.53518235,1.7525103,-0.57854191,-0.59506405,-0.53518235,1.7529417,-0.57854191,-0.59506405,-0.53518235,1.7525691,-0.57854191,-0.59506405,-0.53518235,1.751716,-0.57854191,-0.59506405,-0.53518235,1.7499314,-0.57854191,-0.59506405,-0.53518235,1.7511669,-0.57854191,-0.59506405,-0.53518235,1.7482841,-0.57854191,-0.59506405,-0.53518235,1.7486175,-0.57854191,-0.59404428,-0.53518235,1.7488332,-0.57854191,-0.59506405,-0.53518235,1.7492941,-0.57854191,-0.59404428,-0.53620211,1.74799,-0.57854191,-0.59404428,-0.53620211,1.7488038,-0.57854191,-0.59404428,-0.53620211,1.7479802,-0.57854191,-0.59404428,-0.53620211,1.7461956,-0.57854191,-0.59404428,-0.53620211,1.7490784,-0.57854191,-0.59404428,-0.53620211,1.7498628,-0.57854191,-0.59404428,-0.53620211,1.7503041,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191,-0.59404428,-0.53620211,1.7509904,-0.57854191:5
-0.62082804,-0.62082804,1.7246317,-0.62082804,-0.62082804,-0.62082804,1.72402,-0.62082804,-0.62082804,-0.62082804,1.7223724,-0.62082804,-0.62082804,-0.62082804,1.7194027,-0.62082804,-0.74746725,-0.3522278,1.7151308,-0.61883512,-0.75462006,-0.33894824,1.7127827,-0.61874632,-0.761763,-0.32873699,1.7104938,-0.61867726,-0.76483131,-0.32465249,1.7146276,-0.61864766,-0.76278906,-0.32771093,1.7160483,-0.61867726,-0.75972075,-0.33077924,1.7158312,-0.61869699,-0.75870456,-0.33486374,1.7152788,-0.61871672,-0.75666231,-0.33792218,1.7169066,-0.61873646,-0.75462006,-0.33996443,1.7130195,-0.61875619,-0.75257781,-0.34099049,1.7166205,-0.61875619,-0.75155175,-0.34303274,1.7161272,-0.61876605,-0.75053556,-0.34303274,1.7151209,-0.61877592,-0.75053556,-0.34404893,1.7137989,-0.61877592,-0.75053556,-0.34404893,1.7145881,-0.61878579,-0.7495095,-0.34507499,1.7133352,-0.61878579,-0.7495095,-0.34610105,1.7139962,-0.61879565,-0.7495095,-0.34610105,1.7129899,-0.61879565,-0.74746725,-0.3481433,1.7021472,-0.61881538,-0.74746725,-0.3481433,1.7011113,-0.61881538,-0.74849331,-0.3481433,1.701723,-0.61880552,-0.7495095,-0.34610105,1.7127629,-0.61878579,-0.7495095,-0.34610105,1.7140751,-0.61878579,-0.7495095,-0.34610105,1.7146572,-0.61878579,-0.7495095,-0.34610105,1.7142527,-0.61878579,-0.7495095,-0.3481433,1.7056792,-0.61879565,-0.74849331,-0.3481433,1.7058075,-0.61878579,-0.74849331,-0.3481433,1.7047715,-0.61879565,-0.7495095,-0.34711724,1.7061528,-0.61878579,-0.74849331,-0.3481433,1.7055115,-0.61879565,-0.7495095,-0.34711724,1.7064882,-0.61878579,-0.7495095,-0.3481433,1.7066559,-0.61878579,-0.74849331,-0.3481433,1.7048406,-0.61879565,-0.74849331,-0.3481433,1.704811,-0.61879565,-0.7495095,-0.34711724,1.7064981,-0.61878579,-0.7495095,-0.34711724,1.7090435,-0.61878579,-0.7495095,-0.34711724,1.7053536,-0.61878579,-0.7495095,-0.3481433,1.704071,-0.61878579,-0.7495095,-0.34711724,1.7038145,-0.61878579,-0.7495095,-0.34610105,1.7047419,-0.61877592,-0.7495095,-0.34507499,1.7139765,-0.61878579,-0.7495095,-0.34507499,1.7122203,-0.61877592,-0.7495095,-0.34507499,1.7123979,-0.61878579,-0.7495095,-0.34610105,1.7056003,-0.61877592,-0.75053556,-0.34610105,1.7048998,-0.61877592,-0.75053556,-0.34610105,1.7070407,-0.61877592,-0.7495095,-0.34610105,1.7041006,-0.61878579,-0.7495095,-0.34610105,1.7061133,-0.61877592,-0.7495095,-0.34610105,1.7023741,-0.61877592,-0.7495095,-0.34610105,1.7033607,-0.61878579,-0.7495095,-0.34610105,1.702749,-0.61878579,-0.7495095,-0.34610105,1.7016736,-0.61878579,-0.7495095,-0.34610105,1.7024629,-0.61878579,-0.7495095,-0.34610105,1.7039428,-0.61878579,-0.7495095,-0.34610105,1.7018019,-0.61878579,-0.7495095,-0.34610105,1.703341,-0.61878579,-0.7495095,-0.34610105,1.7037159,-0.61878579,-0.7495095,-0.34610105,1.7008054,-0.61878579,-0.7495095,-0.34610105,1.7028773,-0.61878579,-0.7495095,-0.34610105,1.7053043,-0.61878579,-0.75053556,-0.34711724,1.6998682,-0.61877592,-0.7495095,-0.34711724,1.6990197,-0.61878579,-0.7495095,-0.34711724,1.6988125,-0.61878579,-0.7495095,-0.34711724,1.7002529,-0.61878579,-0.7495095,-0.34711724,1.6980232,-0.61878579,-0.75053556,-0.34711724,1.6981712,-0.61877592,-0.7495095,-0.3481433,1.6986546,-0.61878579,-0.7495095,-0.34610105,1.7003319,-0.61878579,-0.75053556,-0.34711724,1.7002036,-0.61878579,-0.7495095,-0.34711724,1.6988717,-0.61878579,-0.75053556,-0.34610105,1.7011902,-0.61878579,-0.7495095,-0.34711724,1.7016638,-0.61877592,-0.75053556,-0.34711724,1.7025122,-0.61877592,-0.75053556,-0.34610105,1.7027095,-0.61876605,-0.7495095,-0.34610105,1.7048011,-0.61877592,-0.7495095,-0.34610105,1.7040119,-0.61877592,-0.7495095,-0.34404893,1.7100991,-0.61876605,-0.7495095,-0.34507499,1.7107207,-0.61876605,-0.7495095,-0.34610105,1.7090829,-0.61877592,-0.7495095,-0.34507499,1.7102373,-0.61878579,-0.74849331,-0.34507499,1.711214,-0.61878579,-0.7495095,-0.34404893,1.7112041,-0.61877592,-0.7495095,-0.34507499,1.7086587,-0.61877592,-0.7495095,-0.34507499,1.709152,-0.61877592,-0.7495095,-0.34507499,1.709152,-0.61877592,-0.7495095,-0.34507499,1.7098624,-0.61877592,-0.7495095,-0.34507499,1.7109673,-0.61877592,-0.7495095,-0.34507499,1.7099117,-0.61878579,-0.7495095,-0.34404893,1.71077,-0.61877592,-0.7495095,-0.34303274,1.7188996,-0.61877592,-0.7495095,-0.34303274,1.7174098,-0.61876605,-0.7495095,-0.34404893,1.7114902,-0.61877592,-0.7495095,-0.34507499,1.708856,-0.61877592,-0.7495095,-0.34507499,1.710474,-0.61877592,-0.7495095,-0.34303274,1.7189193,-0.61877592,-0.7495095,-0.34303274,1.7168968,-0.61877592,-0.7495095,-0.34303274,1.7188601,-0.61877592,-0.7495095,-0.34303274,1.7172717,-0.61876605,-0.7495095,-0.34303274,1.719235,-0.61877592,-0.7495095,-0.34303274,1.7213266,-0.61877592,-0.7495095,-0.34404893,1.7144796,-0.61877592,-0.74849331,-0.34404893,1.7140652,-0.61878579,-0.7495095,-0.34303274,1.7213364,-0.61877592,-0.7495095,-0.34303274,1.7207741,-0.61877592,-0.7495095,-0.34303274,1.7215634,-0.61877592,-0.7495095,-0.34303274,1.7198861,-0.61877592,-0.75053556,-0.34303274,1.7224612,-0.61877592,-0.7495095,-0.34200668,1.725273,-0.61877592,-0.7495095,-0.34200668,1.7241778,-0.61877592,-0.7495095,-0.34303274,1.7154859,-0.61877592,-0.7495095,-0.34303274,1.7161667,-0.61877592,-0.75053556,-0.34200668,1.7251546,-0.61877592,-0.75053556,-0.34303274,1.7217311,-0.61878579,-0.75053556,-0.34200668,1.7250658,-0.61877592,-0.75053556,-0.34200668,1.7256577,-0.61877592,-0.7495095,-0.34404893,1.7170053,-0.61877592,-0.75053556,-0.34303274,1.715338,-0.61878579,-0.7495095,-0.34200668,1.7235069,-0.61877592,-0.7495095,-0.34200668,1.7228065,-0.61877592,-0.7495095,-0.34200668,1.723872,-0.61876605,-0.7495095,-0.34303274,1.7206064,-0.61877592,-0.7495095,-0.34404893,1.7131082,-0.61878579,-0.74849331,-0.34507499,1.7124374,-0.61878579,-0.7495095,-0.34303274,1.7201131,-0.61878579,-0.7495095,-0.34303274,1.7183668,-0.61879565,-0.74849331,-0.34303274,1.7194915,-0.61878579,-0.7495095,-0.34404893,1.7112337,-0.61878579,-0.7495095,-0.34404893,1.7111449,-0.61878579,-0.74849331,-0.34507499,1.7144895,-0.61879565,-0.7495095,-0.34303274,1.7203696,-0.61878579,-0.7495095,-0.34200668,1.7202315,-0.61877592,-0.7495095,-0.34303274,1.7196296,-0.61877592,-0.74849331,-0.34507499,1.7110759,-0.61878579,-0.7495095,-0.34404893,1.7118059,-0.61877592,-0.7495095,-0.34200668,1.7202808,-0.61877592,-0.75053556,-0.34303274,1.7180215,-0.61877592,-0.7495095,-0.34200668,1.7200045,-0.61877592,-0.7495095,-0.34303274,1.719235,-0.61877592,-0.7495095,-0.34303274,1.7176564,-0.61877592,-0.7495095,-0.34404893,1.7116777,-0.61877592,-0.7495095,-0.34404893,1.7115001,-0.61877592,-0.7495095,-0.34200668,1.7209517,-0.61877592,-0.7495095,-0.34200668,1.7226387,-0.61876605,-0.75053556,-0.34200668,1.7180412,-0.61875619,-0.7495095,-0.34303274,1.7171927,-0.61877592,-0.7495095,-0.34303274,1.7169165,-0.61878579,-0.7495095,-0.34200668,1.718791,-0.61877592,-0.74849331,-0.34404893,1.7091915,-0.61878579,-0.74849331,-0.34404893,1.7089251,-0.61878579,-0.74849331,-0.34303274,1.7136706,-0.61877592,-0.74849331,-0.34303274,1.7137495,-0.61876605,-0.74849331,-0.34303274,1.713197,-0.61876605,-0.74849331,-0.34303274,1.712467,-0.61877592,-0.74849331,-0.34404893,1.7058765,-0.61877592,-0.74849331,-0.34404893,1.705324,-0.61876605,-0.74849331,-0.34303274,1.7131477,-0.61876605,-0.7495095,-0.34303274,1.7132661,-0.61875619,-0.74849331,-0.34303274,1.7156931,-0.61876605,-0.74849331,-0.34303274,1.7139666,-0.61876605,-0.74849331,-0.34303274,1.7118947,-0.61876605,-0.74849331,-0.34507499,1.7048209,-0.61877592,-0.7495095,-0.34404893,1.7046531,-0.61876605,-0.74849331,-0.34303274,1.7131872,-0.61876605,-0.74849331,-0.34303274,1.7142527,-0.61877592,-0.74849331,-0.34303274,1.71445,-0.61878579,-0.74849331,-0.34404893,1.7063007,-0.61878579,-0.74849331,-0.34404893,1.7083726,-0.61878579,-0.74849331,-0.34404893,1.7091224,-0.61878579,-0.74746725,-0.34404893,1.708639,-0.61878579,-0.74849331,-0.34404893,1.7091421,-0.61877592,-0.74849331,-0.34404893,1.7097933,-0.61878579,-0.7495095,-0.34404893,1.7097637,-0.61878579,-0.74849331,-0.34404893,1.7089448,-0.61877592,-0.7495095,-0.34404893,1.7093789,-0.61877592,-0.74849331,-0.34404893,1.7089646,-0.61878579,-0.74849331,-0.34404893,1.7146375,-0.61878579,-0.74849331,-0.34303274,1.7146868,-0.61877592,-0.74849331,-0.34303274,1.7152196,-0.61878579,-0.74849331,-0.34711724,1.695685,-0.61879565,-0.74746725,-0.34610105,1.6975299,-0.61879565,-0.74746725,-0.34507499,1.7043276,-0.61878579,-0.74849331,-0.34507499,1.7034988,-0.61879565,-0.74849331,-0.34404893,1.7084811,-0.61878579,-0.74746725,-0.34507499,1.7038244,-0.61879565,-0.74746725,-0.34507499,1.7050872,-0.61879565,-0.74746725,-0.34507499,1.703854,-0.61880552,-0.74746725,-0.34404893,1.7045939,-0.61879565,-0.74849331,-0.34507499,1.7005884,-0.61879565,-0.74849331,-0.34404893,1.7125558,-0.61878579,-0.7495095,-0.34200668,1.7161568,-0.61877592,-0.74849331,-0.34303274,1.7149334,-0.61878579,-0.7495095,-0.34303274,1.7146079,-0.61878579,-0.74849331,-0.34303274,1.7129997,-0.61878579,-0.74849331,-0.34404893,1.707169,-0.61878579,-0.74849331,-0.34507499,1.7067053,-0.61879565,-0.74849331,-0.34303274,1.7155057,-0.61878579,-0.74849331,-0.34303274,1.7139765,-0.61878579,-0.74849331,-0.34303274,1.7136805,-0.61878579,-0.74849331,-0.34404893,1.7074156,-0.61878579,-0.74849331,-0.34404893,1.7086094,-0.61877592,-0.74849331,-0.34404893,1.7103162,-0.61877592,-0.7495095,-0.34303274,1.7140455,-0.61876605,-0.7495095,-0.34303274,1.7147855,-0.61876605,-0.7495095,-0.34303274,1.7162555,-0.61876605,-0.7495095,-0.34404893,1.7069026,-0.61877592,-0.74849331,-0.34404893,1.7059456,-0.61878579,-0.74849331,-0.34404893,1.7063303,-0.61877592,-0.7495095,-0.34200668,1.7156734,-0.61876605,-0.7495095,-0.34303274,1.714746,-0.61876605,-0.74849331,-0.34303274,1.7138581,-0.61876605,-0.74849331,-0.34404893,1.7076031,-0.61877592,-0.74849331,-0.34507499,1.704811,-0.61877592,-0.74849331,-0.34303274,1.7126643,-0.61876605,-0.74849331,-0.34303274,1.7124374,-0.61876605,-0.74849331,-0.34303274,1.7104938,-0.61876605,-0.74849331,-0.34404893,1.7111548,-0.61876605,-0.74849331,-0.34507499,1.7111449,-0.61877592,-0.7495095,-0.34507499,1.7042585,-0.61876605,-0.7495095,-0.34507499,1.7037455,-0.61876605,-0.74849331,-0.34404893,1.7118059,-0.61877592,-0.74849331,-0.34303274,1.7132858,-0.61877592,-0.7495095,-0.34303274,1.7117467,-0.61876605,-0.7495095,-0.34303274,1.7132464,-0.61876605,-0.7495095,-0.34303274,1.7130589,-0.61876605,-0.7495095,-0.34200668,1.714746,-0.61876605,-0.74849331,-0.34200668,1.7172125,-0.61876605,-0.7495095,-0.34303274,1.7158115,-0.61876605,-0.7495095,-0.34404893,1.7077609,-0.61876605,-0.7495095,-0.34303274,1.7096058,-0.61876605,-0.7495095,-0.34200668,1.7180807,-0.61875619,-0.7495095,-0.34200668,1.7170842,-0.61875619,-0.7495095,-0.34200668,1.7178044,-0.61875619,-0.7495095,-0.34200668,1.7200835,-0.61876605,-0.7495095,-0.34404893,1.7100498,-0.61876605,-0.7495095,-0.34507499,1.7112929,-0.61877592,-0.75053556,-0.34200668,1.7170546,-0.61875619,-0.75053556,-0.34200668,1.7177156,-0.61875619,-0.75053556,-0.34200668,1.7145191,-0.61875619,-0.75053556,-0.34200668,1.716512,-0.61875619,-0.7495095,-0.34404893,1.7076918,-0.61876605,-0.7495095,-0.34404893,1.708935,-0.61877592,-0.7495095,-0.34303274,1.7168573,-0.61876605,-0.7495095,-0.34303274,1.7167882,-0.61876605,-0.7495095,-0.34200668,1.7165515,-0.61876605,-0.7495095,-0.34303274,1.7154169,-0.61876605,-0.7495095,-0.34099049,1.7187121,-0.61876605,-0.7495095,-0.34200668,1.7187713,-0.61876605,-0.7495095,-0.34200668,1.7205176,-0.61876605,-0.75053556,-0.34099049,1.7192646,-0.61875619,-0.7495095,-0.34200668,1.7198072,-0.61876605,-0.75053556,-0.34200668,1.7188206,-0.61876605,-0.7495095,-0.34200668,1.7205373,-0.61876605,-0.7495095,-0.34200668,1.7192646,-0.61876605,-0.7495095,-0.34200668,1.7206261,-0.61875619,-0.7495095,-0.34200668,1.7187812,-0.61876605,-0.75053556,-0.34099049,1.7220961,-0.61875619,-0.7495095,-0.34303274,1.718722,-0.61876605,-0.7495095,-0.34099049,1.7197875,-0.61875619,-0.7495095,-0.34200668,1.7195803,-0.61875619,-0.75053556,-0.34200668,1.7187318,-0.61875619,-0.7495095,-0.34200668,1.7162851,-0.61875619,-0.7495095,-0.34200668,1.7183865,-0.61876605,-0.7495095,-0.34200668,1.7190969,-0.61876605,-0.75053556,-0.34200668,1.718574,-0.61876605,-0.75053556,-0.34200668,1.71666,-0.61876605,-0.74849331,-0.34303274,1.7166304,-0.61878579,-0.7495095,-0.34200668,1.7190377,-0.61877592,-0.7495095,-0.34303274,1.7147164,-0.61877592,-0.7495095,-0.34200668,1.7206064,-0.61876605,-0.7495095,-0.34200668,1.7148644,-0.61876605,-0.7495095,-0.34200668,1.7163048,-0.61876605,-0.7495095,-0.34303274,1.7146177,-0.61877592,-0.7495095,-0.34200668,1.7164824,-0.61877592,-0.7495095,-0.34303274,1.714894,-0.61877592,-0.7495095,-0.34303274,1.7149038,-0.61876605,-0.7495095,-0.34303274,1.7168573,-0.61877592,-0.7495095,-0.34303274,1.7182287,-0.61877592,-0.7495095,-0.34303274,1.7145881,-0.61876605,-0.7495095,-0.34200668,1.7178439,-0.61876605,-0.75053556,-0.34200668,1.7176762,-0.61875619,-0.75053556,-0.34200668,1.7197974,-0.61875619,-0.75053556,-0.34200668,1.7192942,-0.61876605,-0.75053556,-0.34200668,1.7215634,-0.61876605,-0.7495095,-0.34200668,1.7191561,-0.61875619,-0.7495095,-0.34200668,1.721662,-0.61876605,-0.7495095,-0.34200668,1.7185444,-0.61876605,-0.7495095,-0.34200668,1.7201229,-0.61876605,-0.7495095,-0.34200668,1.7196296,-0.61876605,-0.7495095,-0.34200668,1.7199157,-0.61876605,-0.75053556,-0.34200668,1.7174986,-0.61876605,-0.7495095,-0.34099049,1.7210898,-0.61876605,-0.7495095,-0.34200668,1.7171829,-0.61876605,-0.75053556,-0.34303274,1.7143908,-0.61875619,-0.7495095,-0.34303274,1.7133056,-0.61876605,-0.7495095,-0.34303274,1.7153084,-0.61876605,-0.7495095,-0.34303274,1.7134536,-0.61876605,-0.7495095,-0.34303274,1.7146572,-0.61876605,-0.7495095,-0.34303274,1.7141836,-0.61876605,-0.7495095,-0.34303274,1.7132365,-0.61876605,-0.7495095,-0.34303274,1.714085,-0.61877592,-0.7495095,-0.34200668,1.7136706,-0.61876605,-0.7495095,-0.34303274,1.7128419,-0.61876605,-0.7495095,-0.34303274,1.7106319,-0.61876605,-0.75053556,-0.34303274,1.7117665,-0.61876605,-0.7495095,-0.34303274,1.7124275,-0.61876605,-0.7495095,-0.34303274,1.7132562,-0.61876605,-0.7495095,-0.34200668,1.7157227,-0.61875619,-0.7495095,-0.34303274,1.7102669,-0.61875619,-0.7495095,-0.34200668,1.715259,-0.61875619,-0.7495095,-0.34200668,1.7179426,-0.61875619,-0.7495095,-0.34200668,1.7202019,-0.61875619,-0.7495095,-0.34099049,1.7218001,-0.61876605,-0.7495095,-0.34200668,1.7166896,-0.61875619,-0.75053556,-0.34099049,1.7221159,-0.61875619,-0.75053556,-0.34200668,1.719896,-0.61876605,-0.75053556,-0.34099049,1.7241482,-0.61875619,-0.75053556,-0.34099049,1.7215436,-0.61875619,-0.75053556,-0.34099049,1.7202315,-0.61875619,-0.7495095,-0.34099049,1.7200144,-0.61875619,-0.75053556,-0.34099049,1.7205176,-0.61875619,-0.75053556,-0.34099049,1.723211,-0.61876605,-0.75053556,-0.34099049,1.7219185,-0.61875619,-0.75053556,-0.34099049,1.7226289,-0.61875619,-0.75053556,-0.34099049,1.721297,-0.61876605,-0.7495095,-0.34200668,1.7180905,-0.61875619,-0.75053556,-0.34099049,1.7222342,-0.61875619,-0.7495095,-0.34099049,1.7212871,-0.61876605,-0.75053556,-0.34200668,1.7209319,-0.61875619,-0.75053556,-0.34200668,1.7179031,-0.61876605,-0.7495095,-0.34303274,1.716216,-0.61876605,-0.7495095,-0.34099049,1.7222934,-0.61876605,-0.7495095,-0.34200668,1.7198467,-0.61877592,-0.7495095,-0.34200668,1.7185345,-0.61876605,-0.7495095,-0.34303274,1.717025,-0.61877592,-0.7495095,-0.34200668,1.7168968,-0.61877592,-0.7495095,-0.34200668,1.7190673,-0.61876605,-0.75053556,-0.34200668,1.7198763,-0.61876605,-0.75053556,-0.34200668,1.719748,-0.61876605,-0.75053556,-0.34303274,1.7157918,-0.61876605,-0.7495095,-0.34200668,1.7157326,-0.61877592,-0.75053556,-0.34200668,1.7189686,-0.61876605,-0.75053556,-0.34200668,1.7181201,-0.61876605,-0.75053556,-0.34303274,1.7167981,-0.61876605,-0.75053556,-0.34200668,1.7180314,-0.61876605,-0.75053556,-0.34200668,1.7181596,-0.61877592,-0.75053556,-0.34200668,1.7204288,-0.61876605,-0.75053556,-0.34303274,1.7163541,-0.61876605,-0.75053556,-0.34303274,1.7143612,-0.61876605,-0.75053556,-0.34200668,1.7194718,-0.61876605,-0.75053556,-0.34200668,1.7169954,-0.61876605,-0.7495095,-0.34303274,1.7111548,-0.61877592,-0.75053556,-0.34200668,1.7185246,-0.61876605,-0.7495095,-0.34303274,1.7166501,-0.61877592,-0.7495095,-0.34200668,1.7172125,-0.61876605,-0.75053556,-0.34200668,1.7195112,-0.61876605,-0.7495095,-0.34303274,1.7151801,-0.61877592,-0.7495095,-0.34303274,1.715555,-0.61876605,-0.7495095,-0.34303274,1.715555,-0.61876605,-0.7495095,-0.34303274,1.715555,-0.61876605,-0.7495095,-0.34303274,1.715555,-0.61876605,-0.7495095,-0.34303274,1.715555,-0.61876605,-0.7495095,-0.34303274,1.715555,-0.61876605:5
-0.59947986,-0.59947986,1.7272992,-0.59947986,-0.59947986,-0.59947986,1.7092323,-0.59947986,-0.59947986,-0.59947986,1.7198247,-0.59947986,-0.59947986,-0.59947986,1.7216628,-0.59947986,-0.59947986,-0.59947986,1.7265477,-0.59947986,-0.59947986,-0.59947986,1.704449,-0.59947986,-0.59947986,-0.59947986,1.6993001,-0.59947986,-0.59947986,-0.59947986,1.7118322,-0.59947986,-0.59947986,-0.59947986,1.6991579,-0.59947986,-0.59947986,-0.59947986,1.702032,-0.59947986,-0.59947986,-0.59947986,1.7279187,-0.59947986,-0.59947986,-0.59947986,1.7111416,-0.59947986,-0.59947986,-0.59947986,1.7222417,-0.59947986,-0.59947986,-0.59947986,1.7163108,-0.59947986,-0.59947986,-0.59947986,1.7241306,-0.59947986,-0.59947986,-0.59947986,1.7043068,-0.59947986,-0.59947986,-0.59947986,1.7168389,-0.59947986,-0.59947986,-0.59947986,1.7275734,-0.59947986,-0.59947986,-0.59947986,1.7284976,-0.59947986,-0.59947986,-0.59947986,1.7150007,-0.59947986,-0.59947986,-0.59947986,1.7197129,-0.59947986,-0.59947986,-0.59947986,1.7313716,-0.59947986,-0.59947986,-0.59947986,1.720302,-0.59947986,-0.59947986,-0.59947986,1.7190325,-0.59947986,-0.59947986,-0.59947986,1.7258977,-0.59947986,-0.59947986,-0.59947986,1.7302748,-0.59947986,-0.59947986,-0.59947986,1.7217542,-0.59947986,-0.59947986,-0.59947986,1.7218659,-0.59947986,-0.59947986,-0.59947986,1.728528,-0.59947986,-0.59947986,-0.59947986,1.7201293,-0.59947986,-0.59947986,-0.59947986,1.7102073,-0.59947986,-0.59947986,-0.59947986,1.7244353,-0.59947986,-0.59947986,-0.59947986,1.7236635,-0.59947986,-0.59947986,-0.59947986,1.7172248,-0.59947986,-0.59947986,-0.59947986,1.7269539,-0.59947986,-0.59947986,-0.59947986,1.7244556,-0.59947986,-0.59947986,-0.59947986,1.7094151,-0.59947986,-0.59947986,-0.59947986,1.7164834,-0.59947986,-0.59947986,-0.59947986,1.7196825,-0.59947986,-0.59947986,-0.59947986,1.7194692,-0.59947986,-0.59947986,-0.59947986,1.7177123,-0.59947986,-0.59947986,-0.59947986,1.7259993,-0.59947986,-0.59947986,-0.59947986,1.7157726,-0.59947986,-0.59947986,-0.59947986,1.7197942,-0.59947986,-0.59947986,-0.59947986,1.7204746,-0.59947986,-0.59947986,-0.59947986,1.7269742,-0.59947986,-0.59947986,-0.59947986,1.7268828,-0.59947986,-0.59947986,-0.59947986,1.7141984,-0.59947986,-0.59947986,-0.59947986,1.7193372,-0.59947986,-0.59947986,-0.59947986,1.7254509,-0.59947986,-0.59947986,-0.59947986,1.7187583,-0.59947986,-0.59947986,-0.59947986,1.7226479,-0.59947986,-0.59947986,-0.59947986,1.7257149,-0.59947986,-0.59947986,-0.59947986,1.7235416,-0.59947986,-0.59947986,-0.59947986,1.7173873,-0.59947986,-0.59947986,-0.59947986,1.7237346,-0.59947986,-0.59947986,-0.59947986,1.7301936,-0.59947986,-0.59947986,-0.59947986,1.7163311,-0.59947986,-0.59947986,-0.59947986,1.719327,-0.59947986,-0.59947986,-0.59947986,1.725979,-0.59947986,-0.59947986,-0.59947986,1.7118322,-0.59947986,-0.59947986,-0.59947986,1.7144828,-0.59947986,-0.59947986,-0.59947986,1.7255626,-0.59947986,-0.59947986,-0.59947986,1.721612,-0.59947986,-0.59947986,-0.59947986,1.7179662,-0.59947986,-0.59947986,-0.59947986,1.709801,-0.59947986,-0.59947986,-0.59947986,1.7117408,-0.59947986,-0.59947986,-0.59947986,1.706927,-0.59947986,-0.59947986,-0.59947986,1.7022046,-0.59947986,-0.59947986,-0.59947986,1.707191,-0.59947986,-0.59947986,-0.59947986,1.7103901,-0.59947986,-0.59947986,-0.59947986,1.7003563,-0.59947986,-0.59947986,-0.59947986,1.7076785,-0.59947986,-0.59947986,-0.59947986,1.7146351,-0.59947986,-0.59947986,-0.59947986,1.7135891,-0.59947986,-0.59947986,-0.59947986,1.7120861,-0.59947986,-0.59947986,-0.59947986,1.7205152,-0.59947986,-0.59947986,-0.59947986,1.7203832,-0.59947986,-0.59947986,-0.59947986,1.7046826,-0.59947986,-0.59947986,-0.59947986,1.708755,-0.59947986,-0.59947986,-0.59947986,1.7261212,-0.59947986,-0.59947986,-0.59947986,1.7175701,-0.59947986,-0.59947986,-0.59947986,1.7171131,-0.59947986,-0.59947986,-0.59947986,1.7289546,-0.59947986,-0.59947986,-0.59947986,1.7221097,-0.59947986,-0.59947986,-0.59947986,1.7177834,-0.59947986,-0.59947986,-0.59947986,1.7176717,-0.59947986,-0.59947986,-0.59947986,1.7196114,-0.59947986,-0.59947986,-0.59947986,1.7166053,-0.59947986,-0.59947986,-0.59947986,1.7094659,-0.59947986,-0.66150035,-0.44283926,1.7303154,-0.59840336,-0.66360257,-0.43968086,1.7252985,-0.59838305,-0.66465876,-0.43757864,1.714757,-0.59836274,-0.66676098,-0.43443039,1.7129696,-0.59834243,-0.66780701,-0.43232817,1.7201293,-0.59832212,-0.66886319,-0.43127199,1.7189005,-0.59832212,-0.66990922,-0.43127199,1.7075668,-0.59831196,-0.66990922,-0.43022596,1.7224448,-0.59831196,-0.66990922,-0.43022596,1.7217034,-0.59831196,-0.66990922,-0.43127199,1.7128376,-0.59831196,-0.66990922,-0.43127199,1.7115681,-0.59831196,-0.66990922,-0.43127199,1.7209316,-0.59831196,-0.66886319,-0.43232817,1.6972994,-0.59832212,-0.66886319,-0.43337421,1.6985384,-0.59832212,-0.66886319,-0.43127199,1.7134571,-0.59832212,-0.66990922,-0.43232817,1.7193778,-0.59832212,-0.66886319,-0.43337421,1.7003664,-0.59832212,-0.66886319,-0.43337421,1.7079324,-0.59832212,-0.66886319,-0.43232817,1.7214496,-0.59832212,-0.66886319,-0.43337421,1.7094862,-0.59832212,-0.66886319,-0.43232817,1.7064903,-0.59831196,-0.66990922,-0.43022596,1.7246384,-0.59831196,-0.66886319,-0.43232817,1.7149601,-0.59832212,-0.66886319,-0.43232817,1.7085925,-0.59832212,-0.66886319,-0.43232817,1.7157015,-0.59832212,-0.66886319,-0.43337421,1.7132336,-0.59832212,-0.66780701,-0.43443039,1.7060333,-0.59832212,-0.66780701,-0.43443039,1.7100245,-0.59833227,-0.66780701,-0.43443039,1.7183622,-0.59833227,-0.66780701,-0.43547642,1.7155288,-0.59833227,-0.66676098,-0.43653261,1.7057794,-0.59833227,-0.66676098,-0.43653261,1.7170623,-0.59834243,-0.66570479,-0.43653261,1.7172654,-0.59834243,-0.66465876,-0.43968086,1.6963245,-0.59835258,-0.66570479,-0.43863483,1.7087347,-0.59835258,-0.66570479,-0.43757864,1.7187989,-0.59835258,-0.66676098,-0.43757864,1.7125227,-0.59834243,-0.66570479,-0.43757864,1.709405,-0.59834243,-0.66570479,-0.43757864,1.7111924,-0.59834243,-0.66676098,-0.43757864,1.7156812,-0.59834243,-0.66676098,-0.43757864,1.7039006,-0.59833227,-0.66780701,-0.43547642,1.7098213,-0.59832212,-0.66780701,-0.43443039,1.7241713,-0.59832212,-0.66780701,-0.43547642,1.7145945,-0.59833227,-0.66780701,-0.43653261,1.7081558,-0.59833227,-0.66780701,-0.43653261,1.7200887,-0.59833227,-0.66780701,-0.43653261,1.7164733,-0.59833227,-0.66676098,-0.43757864,1.7019507,-0.59834243,-0.66570479,-0.43757864,1.7138938,-0.59834243,-0.66676098,-0.43757864,1.7233182,-0.59834243,-0.66570479,-0.43863483,1.7196926,-0.59834243,-0.66570479,-0.43968086,1.7047131,-0.59835258,-0.66465876,-0.43968086,1.7168897,-0.59835258,-0.66465876,-0.43968086,1.7200684,-0.59835258,-0.66465876,-0.44073705,1.7031999,-0.59835258,-0.66465876,-0.44073705,1.7141477,-0.59836274,-0.66465876,-0.44073705,1.7261516,-0.59836274,-0.66360257,-0.44073705,1.717631,-0.59836274,-0.66360257,-0.44178308,1.7138836,-0.59836274,-0.66465876,-0.44178308,1.7184841,-0.59836274,-0.66360257,-0.44073705,1.7219472,-0.59836274,-0.66360257,-0.44178308,1.7057185,-0.59836274,-0.66360257,-0.44178308,1.7080035,-0.59836274,-0.66255654,-0.44178308,1.72931,-0.59837289,-0.66360257,-0.44283926,1.716321,-0.59837289,-0.66255654,-0.44388529,1.7128071,-0.59837289,-0.66255654,-0.44283926,1.7213582,-0.59837289,-0.66255654,-0.44283926,1.7174685,-0.59837289,-0.66255654,-0.44388529,1.7081761,-0.59837289,-0.66255654,-0.44388529,1.7100955,-0.59837289,-0.66360257,-0.44178308,1.727675,-0.59837289,-0.66255654,-0.44388529,1.7195505,-0.59838305,-0.66150035,-0.44388529,1.7140156,-0.59838305,-0.66255654,-0.44388529,1.7241002,-0.59838305,-0.66255654,-0.44388529,1.7238869,-0.59837289,-0.66255654,-0.44599767,1.7170014,-0.59838305,-0.66150035,-0.44494148,1.7271367,-0.59838305,-0.66150035,-0.44388529,1.7401766,-0.59839321,-0.66255654,-0.44494148,1.7293608,-0.59838305,-0.66150035,-0.44494148,1.7278171,-0.59838305,-0.66150035,-0.44494148,1.7344792,-0.59838305,-0.66150035,-0.44388529,1.7402273,-0.59838305,-0.66045432,-0.4470437,1.7179459,-0.59840336,-0.66045432,-0.44599767,1.7277359,-0.59839321,-0.66150035,-0.44494148,1.7393641,-0.59839321,-0.66150035,-0.44599767,1.7251361,-0.59839321,-0.66045432,-0.4470437,1.7252275,-0.59839321,-0.66045432,-0.44599767,1.7279289,-0.59839321,-0.66150035,-0.44599767,1.7326309,-0.59839321,-0.66045432,-0.4470437,1.7201293,-0.59839321,-0.66045432,-0.4470437,1.7216527,-0.59839321,-0.66150035,-0.44494148,1.75019,-0.59839321,-0.66045432,-0.4470437,1.7276343,-0.59839321,-0.66045432,-0.44599767,1.7340019,-0.59839321,-0.66150035,-0.44599767,1.7375666,-0.59839321,-0.66045432,-0.44494148,1.7393946,-0.59839321,-0.66045432,-0.4470437,1.7236026,-0.59839321,-0.65939814,-0.4470437,1.7294928,-0.59840336,-0.66045432,-0.44599767,1.7389376,-0.59839321,-0.66045432,-0.4470437,1.7352104,-0.59839321,-0.66045432,-0.4470437,1.7284062,-0.59840336,-0.66045432,-0.44809988,1.7278375,-0.59839321,-0.66045432,-0.44599767,1.7457723,-0.59839321,-0.65939814,-0.44914592,1.714564,-0.59840336,-0.65939814,-0.44809988,1.7216222,-0.59839321,-0.66045432,-0.4470437,1.732895,-0.59839321,-0.66045432,-0.44809988,1.7209722,-0.59839321,-0.65939814,-0.44809988,1.7220995,-0.59840336,-0.65939814,-0.44809988,1.7293506,-0.59840336,-0.65939814,-0.4470437,1.7332301,-0.59840336,-0.65939814,-0.44914592,1.7170725,-0.59840336,-0.66045432,-0.44914592,1.7243236,-0.59840336,-0.66045432,-0.44809988,1.7380337,-0.59840336,-0.65939814,-0.44914592,1.7192864,-0.59840336,-0.65835211,-0.44914592,1.7166866,-0.59840336,-0.65939814,-0.44809988,1.7368252,-0.59840336,-0.65939814,-0.44809988,1.7438427,-0.59840336,-0.65939814,-0.44914592,1.7240088,-0.59840336,-0.65939814,-0.44914592,1.7299498,-0.59840336,-0.65939814,-0.44809988,1.7412531,-0.59840336,-0.65939814,-0.44914592,1.7273703,-0.59840336,-0.65939814,-0.44914592,1.7182607,-0.59840336,-0.66045432,-0.44809988,1.7347027,-0.59840336,-0.65939814,-0.44809988,1.7308638,-0.59840336,-0.65939814,-0.44809988,1.7232573,-0.59840336,-0.65939814,-0.4470437,1.7339207,-0.59840336,-0.66045432,-0.44494148,1.7471027,-0.59839321,-0.66045432,-0.44809988,1.7281929,-0.59839321,-0.65939814,-0.44809988,1.723044,-0.59840336,-0.65939814,-0.44599767,1.732895,-0.59839321,-0.66045432,-0.44599767,1.7501596,-0.59839321,-0.65939814,-0.44809988,1.7268422,-0.59839321,-0.66045432,-0.4470437,1.7372111,-0.59840336,-0.66045432,-0.44494148,1.7526477,-0.59839321,-0.65939814,-0.4470437,1.7363783,-0.59839321,-0.66045432,-0.44914592,1.7266899,-0.59840336,-0.66045432,-0.4470437,1.7438631,-0.59839321,-0.66045432,-0.44599767,1.7496721,-0.59838305,-0.66045432,-0.44809988,1.7328848,-0.59840336,-0.65939814,-0.44809988,1.7199161,-0.59840336,-0.66045432,-0.44599767,1.7469402,-0.59839321,-0.66045432,-0.44809988,1.7287819,-0.59839321,-0.65939814,-0.44809988,1.7239174,-0.59839321,-0.66045432,-0.4470437,1.7427866,-0.59839321,-0.65939814,-0.44599767,1.7505658,-0.59839321,-0.65939814,-0.44809988,1.7208301,-0.59840336,-0.66045432,-0.44809988,1.7430404,-0.59840336,-0.66045432,-0.44599767,1.7515813,-0.59839321,-0.65939814,-0.44809988,1.7310873,-0.59840336,-0.65939814,-0.44809988,1.7273398,-0.59840336,-0.65835211,-0.44809988,1.735312,-0.59840336,-0.66045432,-0.4470437,1.7523024,-0.59840336,-0.65939814,-0.44914592,1.7246994,-0.59840336,-0.65939814,-0.4470437,1.7400242,-0.59839321,-0.65939814,-0.4470437,1.7488495,-0.59840336,-0.65835211,-0.44809988,1.730224,-0.59840336,-0.65835211,-0.44914592,1.7245876,-0.59840336,-0.65939814,-0.44809988,1.7420757,-0.59840336,-0.65939814,-0.4470437,1.7437513,-0.59840336,-0.65939814,-0.44914592,1.7260602,-0.59840336,-0.65939814,-0.4470437,1.7396789,-0.59840336,-0.65835211,-0.4470437,1.7479862,-0.59840336,-0.65939814,-0.44809988,1.7389782,-0.59840336,-0.65835211,-0.44914592,1.7213683,-0.59840336,-0.65939814,-0.44809988,1.7446552,-0.59840336,-0.65939814,-0.4470437,1.7487276,-0.59840336,-0.65835211,-0.44809988,1.7262329,-0.59840336,-0.65939814,-0.44809988,1.746077,-0.59840336,-0.65939814,-0.44809988,1.7464629,-0.59840336,-0.65939814,-0.44809988,1.7396383,-0.59840336,-0.65939814,-0.44914592,1.7284062,-0.59840336,-0.65939814,-0.44809988,1.7416085,-0.59840336,-0.65939814,-0.4470437,1.7493674,-0.59840336,-0.65939814,-0.44914592,1.7342152,-0.59840336,-0.65939814,-0.44809988,1.7398922,-0.59840336,-0.65939814,-0.4470437,1.7548616,-0.59840336,-0.65835211,-0.44914592,1.7381353,-0.59841352,-0.65835211,-0.44914592,1.7336769,-0.59840336,-0.65939814,-0.4470437,1.7503627,-0.59840336,-0.65939814,-0.44809988,1.7464223,-0.59840336,-0.65939814,-0.44914592,1.7325192,-0.59840336,-0.65835211,-0.44809988,1.7466355,-0.59840336,-0.65939814,-0.44809988,1.7468285,-0.59840336,-0.65835211,-0.44809988,1.7469707,-0.59840336,-0.65835211,-0.44914592,1.7303662,-0.59841352,-0.65835211,-0.44809988,1.7442591,-0.59840336,-0.65835211,-0.44809988,1.7502408,-0.59840336,-0.65835211,-0.44914592,1.7276851,-0.59840336,-0.65835211,-0.44809988,1.7482097,-0.59841352,-0.65835211,-0.4470437,1.7526071,-0.59840336,-0.65835211,-0.44809988,1.7465645,-0.59840336,-0.65835211,-0.44914592,1.7309045,-0.59841352,-0.65939814,-0.44914592,1.742035,-0.59840336,-0.65939814,-0.44809988,1.7461887,-0.59840336,-0.65835211,-0.44914592,1.7329661,-0.59841352,-0.65835211,-0.44809988,1.7451325,-0.59840336,-0.65835211,-0.44809988,1.7526274,-0.59840336,-0.65939814,-0.44809988,1.7462395,-0.59840336,-0.65835211,-0.44914592,1.7319911,-0.59840336,-0.65939814,-0.44809988,1.7455387,-0.59840336,-0.65835211,-0.44809988,1.7441576,-0.59840336,-0.65939814,-0.44914592,1.7384095,-0.59840336,-0.65835211,-0.44809988,1.7468387,-0.59840336,-0.65939814,-0.4470437,1.758477,-0.59840336,-0.65835211,-0.44809988,1.7485346,-0.59840336,-0.65835211,-0.4502021,1.7308841,-0.59840336,-0.65939814,-0.44809988,1.7528508,-0.59840336,-0.65835211,-0.44809988,1.7463613,-0.59840336,-0.65835211,-0.44914592,1.7297061,-0.59840336,-0.65835211,-0.44809988,1.7502814,-0.59840336,-0.65835211,-0.44809988,1.7510837,-0.59840336,-0.65835211,-0.44914592,1.7472246,-0.59840336,-0.65835211,-0.4502021,1.7317068,-0.59840336,-0.65835211,-0.44914592,1.7474378,-0.59840336,-0.65939814,-0.44809988,1.7523633,-0.59840336,-0.65835211,-0.4502021,1.7291374,-0.59840336,-0.65835211,-0.44914592,1.7382267,-0.59840336,-0.65939814,-0.44809988,1.7513376,-0.59840336,-0.65835211,-0.44914592,1.7422991,-0.59840336,-0.65835211,-0.4502021,1.734134,-0.59841352,-0.65835211,-0.44914592,1.7448075,-0.59840336,-0.65835211,-0.44914592,1.7430912,-0.59840336,-0.65835211,-0.4502021,1.7303865,-0.59840336,-0.65835211,-0.44914592,1.7349362,-0.59841352,-0.65835211,-0.44809988,1.7568724,-0.59840336,-0.65835211,-0.44914592,1.7466152,-0.59840336,-0.65835211,-0.4502021,1.7360432,-0.59841352,-0.65835211,-0.44914592,1.7492049,-0.59841352,-0.65835211,-0.44809988,1.7447771,-0.59840336,-0.65835211,-0.4502021,1.7321333,-0.59840336,-0.65835211,-0.44914592,1.7402476,-0.59840336,-0.65939814,-0.44809988,1.7557959,-0.59840336,-0.65835211,-0.44809988,1.7472347,-0.59840336,-0.65835211,-0.44914592,1.738704,-0.59840336,-0.65835211,-0.44914592,1.7499666,-0.59840336,-0.65835211,-0.44809988,1.7535617,-0.59840336,-0.65835211,-0.4502021,1.7303459,-0.59841352,-0.65835211,-0.44914592,1.7360026,-0.59840336,-0.65939814,-0.44809988,1.756517,-0.59840336,-0.65835211,-0.44914592,1.7374142,-0.59840336,-0.65835211,-0.4502021,1.7331387,-0.59840336,-0.65835211,-0.44914592,1.7440052,-0.59840336,-0.65835211,-0.44914592,1.7444216,-0.59840336,-0.65835211,-0.4502021,1.7285991,-0.59840336,-0.65835211,-0.44914592,1.7303662,-0.59840336,-0.65939814,-0.44914592,1.7412327,-0.59840336,-0.65939814,-0.44914592,1.7436396,-0.59840336,-0.65835211,-0.45124813,1.7236736,-0.59841352,-0.65835211,-0.4502021,1.7347534,-0.59841352,-0.65835211,-0.4502021,1.7368557,-0.59841352,-0.65835211,-0.4502021,1.7297264,-0.59841352,-0.65835211,-0.4502021,1.7353729,-0.59841352,-0.65835211,-0.44914592,1.7447161,-0.59840336,-0.65835211,-0.44914592,1.7399633,-0.59840336,-0.65835211,-0.4502021,1.7316661,-0.59841352,-0.65835211,-0.44914592,1.738572,-0.59840336,-0.65835211,-0.44914592,1.7381962,-0.59840336,-0.65835211,-0.4502021,1.730092,-0.59841352,-0.65835211,-0.4502021,1.7336566,-0.59841352,-0.65835211,-0.44914592,1.7492963,-0.59841352,-0.65835211,-0.44914592,1.7396891,-0.59841352,-0.65729592,-0.4502021,1.7328239,-0.59841352,-0.65939814,-0.44914592,1.7421569,-0.59840336,-0.65939814,-0.44914592,1.7462598,-0.59840336,-0.65835211,-0.4502021,1.7370283,-0.59840336,-0.65835211,-0.4502021,1.7352917,-0.59841352,-0.65835211,-0.44914592,1.7479355,-0.59840336,-0.65835211,-0.44914592,1.7448075,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352,-0.65835211,-0.4502021,1.7367541,-0.59841352:5
-0.97290194,1.2193231,0.77739449,-1.0029646,-0.97290194,1.2185131,0.77685976,-1.0029725,-0.97290194,1.2233965,0.77952554,-1.0029646,-0.97290194,1.2176953,0.77653736,-1.0029725,-0.97290194,1.2176953,0.77643513,-1.0029725,-0.97290194,1.2079287,0.77159113,-1.0029882,-0.97290194,1.2233965,0.77943117,-1.0029646,-0.97290194,1.2176953,0.77652949,-1.0029725,-0.97290194,1.2225865,0.77937613,-1.0029646,-0.97290194,1.2176953,0.77662386,-1.0029725,-0.97290194,1.2185131,0.77682831,-1.0029725,-0.97290194,1.2144398,0.77507472,-1.0029725,-0.97290194,1.2136298,0.77457931,-1.0029804,-0.97290194,1.2144398,0.77496463,-1.0029725,-0.97290194,1.2136298,0.77438272,-1.0029804,-0.97290194,1.212812,0.77397381,-1.0029804,-0.97290194,1.212812,0.77423331,-1.0029804,-0.97290194,1.2168854,0.77619136,-1.0029725,-0.97290194,1.2136298,0.77466581,-1.0029804,-0.97290194,1.212812,0.77407604,-1.0029804,-0.97290194,1.2144398,0.77493317,-1.0029725,-0.97290194,1.212812,0.77393449,-1.0029804,-0.97290194,1.2144398,0.77513763,-1.0029725,-0.97290194,1.2103743,0.77282572,-1.0029804,-0.97290194,1.2168854,0.77617563,-1.0029725,-0.97290194,1.212002,0.77361995,-1.0029804,-0.97290194,1.2160675,0.77586895,-1.0029725,-0.97290194,1.2160675,0.77574313,-1.0029725,-0.97290194,1.2152576,0.77540499,-1.0029725,-0.97290194,1.212812,0.77424117,-1.0029804,-0.97290194,1.212812,0.77397381,-1.0029804,-0.97290194,1.2176953,0.77647445,-1.0029725,-0.97290194,1.2136298,0.77432767,-1.0029804,-0.97290194,1.2111842,0.7731324,-1.0029804,-0.97290194,1.212002,0.77373004,-1.0029804,-0.97290194,1.212812,0.77394235,-1.0029804,-0.97290194,1.212002,0.77367499,-1.0029804,-0.97290194,1.212812,0.77409176,-1.0029804,-0.97290194,1.2160675,0.77545217,-1.0029725,-0.97290194,1.2095565,0.77208654,-1.0029804,-0.97290194,1.2095565,0.77203149,-1.0029804,-0.97290194,1.198972,0.76689654,-1.0029961,-0.97290194,1.2071187,0.77080476,-1.0029882,-0.97290194,1.1973442,0.76581135,-1.0030039,-0.97290194,1.2046731,0.76975104,-1.0029882,-0.97290194,1.2136298,0.77416254,-1.0029804,-0.97290194,1.1924609,0.76342867,-1.0030118,-0.97290194,1.1916509,0.76297258,-1.0030118,-0.97290194,1.1965343,0.76551253,-1.0030039,-0.97290194,1.1940887,0.76438017,-1.0030118,-0.97290194,1.1957164,0.76537885,-1.0030039,-0.97290194,1.1924609,0.76336576,-1.0030118,-0.97290194,1.1949065,0.76476549,-1.0030039,-0.97290194,1.1867676,0.76023603,-1.0030197,-0.97290194,1.1867676,0.76044049,-1.0030197,-0.97290194,1.1867676,0.76033826,-1.0030197,-0.97290194,1.1867676,0.76026749,-1.0030197,-0.97290194,1.1875776,0.76096735,-1.0030197,-0.97290194,1.1883954,0.76139985,-1.0030197,-0.97290194,1.1908331,0.76273667,-1.0030118,-0.97290194,1.1859498,0.75985858,-1.0030197,-0.97290194,1.1859498,0.76027535,-1.0030197,-0.97290194,1.1729276,0.75319808,-1.0030433,-0.97290194,1.1623432,0.7477643,-1.003059,-0.97290194,1.1826943,0.75832517,-1.0030275,-0.97290194,1.1802487,0.7571299,-1.0030275,-0.97290194,1.1826943,0.75864758,-1.0030275,-0.97290194,1.184322,0.75923735,-1.0030197,-0.97290194,1.184322,0.75939462,-1.0030197,-0.97290194,1.1835121,0.75863972,-1.0030275,-0.97290194,1.1802487,0.75709844,-1.0030275,-0.97290194,1.1867676,0.76058203,-1.0030197,-0.97290194,1.1835121,0.75870262,-1.0030275,-0.97290194,1.1867676,0.76030681,-1.0030197,-0.97290194,1.1826943,0.7584274,-1.0030275,-0.97290194,1.1826943,0.75823081,-1.0030275,-0.97290194,1.1835121,0.75902503,-1.0030197,-0.97290194,1.1794387,0.75665021,-1.0030275,-0.97290194,1.1778109,0.75590317,-1.0030354,-0.97290194,1.1794387,0.75657944,-1.0030275,-0.97371976,1.1818843,0.75784549,-1.0030275,-0.97371976,1.1818843,0.75768035,-1.0030275,-0.97290194,1.1810665,0.7574759,-1.0030275,-0.97290194,1.1802487,0.75690185,-1.0030275,-0.97290194,1.1753654,0.75452703,-1.0030354,-0.97290194,1.1826943,0.75831731,-1.0030275,-0.97290194,1.1786209,0.75646935,-1.0030354,-0.97290194,1.1778109,0.75592676,-1.0030354,-0.97290194,1.1745554,0.75420462,-1.0030354,-0.97290194,1.1729276,0.7531273,-1.0030433,-0.97290194,1.1786209,0.75614694,-1.0030354,-0.97290194,1.1753654,0.75428326,-1.0030354,-0.97290194,1.1745554,0.7541653,-1.0030354,-0.97290194,1.1810665,0.75739726,-1.0030275,-0.97290194,1.1802487,0.75710631,-1.0030275,-0.97290194,1.1786209,0.75629635,-1.0030354,-0.97290194,1.1940887,0.76410494,-1.0030039,-0.97290194,1.1997898,0.76743126,-1.0029961,-0.97290194,1.1949065,0.76482053,-1.0030039,-0.97290194,1.1957164,0.76493063,-1.0030039,-0.97290194,1.1924609,0.76323208,-1.0030118,-0.97290194,1.1916509,0.76287035,-1.0030118,-0.97290194,1.1900232,0.76203681,-1.0030118,-0.97290194,1.1940887,0.76444308,-1.0030039,-0.97290194,1.1957164,0.76504072,-1.0030039,-0.97290194,1.1924609,0.76360953,-1.0030118,-0.97290194,1.1949065,0.76474976,-1.0030039,-0.97290194,1.1940887,0.76437231,-1.0030039,-0.97290194,1.2038632,0.76938144,-1.0029882,-0.97290194,1.2022354,0.76836704,-1.0029961,-0.97290194,1.198162,0.76649549,-1.0030039,-0.97290194,1.2030454,0.76875235,-1.0029961,-0.97290194,1.1997898,0.76731331,-1.0029961,-0.97290194,1.1957164,0.76530022,-1.0030039,-0.97290194,1.198972,0.76676285,-1.0029961,-0.97290194,1.198162,0.76636967,-1.0030039,-0.97290194,1.1997898,0.76721108,-1.0029961,-0.97290194,1.198972,0.76677858,-1.0029961,-0.97290194,1.2030454,0.76897254,-1.0029961,-0.97290194,1.2030454,0.76898826,-1.0029882,-0.97290194,1.198972,0.76698304,-1.0029961,-0.97290194,1.1973442,0.76600794,-1.0030039,-0.97290194,1.198972,0.76686508,-1.0029961,-0.97290194,1.1965343,0.76548108,-1.0030039,-0.97290194,1.1949065,0.76489917,-1.0030039,-0.97290194,1.184322,0.75889135,-1.0030197,-0.97290194,1.1818843,0.75774326,-1.0030275,-0.97290194,1.1940887,0.76421503,-1.0030039,-0.97290194,1.1957164,0.76497781,-1.0030039,-0.97290194,1.198162,0.76648763,-1.0029961,-0.97290194,1.1940887,0.7641364,-1.0030039,-0.97290194,1.1908331,0.76232776,-1.0030118,-0.97290194,1.205491,0.76978249,-1.0029882,-0.97290194,1.1957164,0.76511149,-1.0030039,-0.97290194,1.1867676,0.76057417,-1.0030197,-0.97290194,1.1859498,0.76019672,-1.0030197,-0.97290194,1.1761832,0.75491235,-1.0030354,-0.97290194,1.1696721,0.75160962,-1.0030433,-0.97371976,1.1835121,0.75861612,-1.0030275,-0.97371976,1.1867676,0.76042476,-1.0030197,-0.97290194,1.1867676,0.76047194,-1.0030197,-0.97371976,1.1932787,0.76369603,-1.0030118,-0.97371976,1.1908331,0.76257153,-1.0030118,-0.97371976,1.1818843,0.75775899,-1.0030275,-0.97371976,1.1867676,0.76048767,-1.0030197,-0.97371976,1.1859498,0.75974062,-1.0030197,-0.97371976,1.1851399,0.75923735,-1.0030197,-0.97371976,1.1883954,0.7613684,-1.0030197,-0.97371976,1.1940887,0.7642229,-1.0030039,-0.97371976,1.1908331,0.76227272,-1.0030118,-0.97371976,1.1949065,0.76460035,-1.0030039,-0.97371976,1.1957164,0.76476549,-1.0030039,-0.97371976,1.1957164,0.76513508,-1.0030039,-0.97371976,1.1965343,0.76520585,-1.0030039,-0.97371976,1.2014176,0.76772222,-1.0029961,-0.97371976,1.1940887,0.76415999,-1.0030039,-0.97371976,1.198162,0.76632249,-1.0029961,-0.97290194,1.1908331,0.76242999,-1.0030118,-0.97371976,1.1940887,0.76433299,-1.0030039,-0.97290194,1.1957164,0.76489131,-1.0030039,-0.97290194,1.1932787,0.76368817,-1.0030118,-0.97290194,1.1924609,0.7633579,-1.0030118,-0.97290194,1.1892054,0.76186381,-1.0030118,-0.97290194,1.2030454,0.76883099,-1.0029882,-0.97290194,1.1949065,0.76458463,-1.0030039,-0.97290194,1.1908331,0.76250863,-1.0030118,-0.97290194,1.1908331,0.76237494,-1.0030118,-0.97290194,1.1949065,0.76450599,-1.0030039,-0.97290194,1.1940887,0.76438017,-1.0030039,-0.97290194,1.2022354,0.76824908,-1.0029961,-0.97290194,1.2063009,0.77041158,-1.0029882,-0.97290194,1.1997898,0.76729758,-1.0029961,-0.97290194,1.1916509,0.76283103,-1.0030118,-0.97290194,1.1940887,0.76421503,-1.0030039,-0.97290194,1.1957164,0.76502499,-1.0030039,-0.97290194,1.1973442,0.76592931,-1.0030039,-0.97290194,1.2014176,0.76807608,-1.0029961,-0.97290194,1.1949065,0.76484413,-1.0030039,-0.97290194,1.1957164,0.7650879,-1.0030039,-0.97290194,1.2022354,0.76853217,-1.0029961,-0.97290194,1.2005998,0.76761213,-1.0029961,-0.97290194,1.2144398,0.77457145,-1.0029725,-0.97290194,1.212002,0.77354131,-1.0029804,-0.97290194,1.2152576,0.77510617,-1.0029725,-0.97290194,1.2185131,0.77669463,-1.0029725,-0.97290194,1.2160675,0.77547576,-1.0029725,-0.97290194,1.2111842,0.77312454,-1.0029804,-0.97290194,1.2103743,0.77266845,-1.0029804,-0.97290194,1.2071187,0.77089126,-1.0029882,-0.97290194,1.2005998,0.76778513,-1.0029961,-0.97290194,1.2046731,0.76974317,-1.0029882,-0.97290194,1.2005998,0.7676829,-1.0029961,-0.97290194,1.2038632,0.76929494,-1.0029882,-0.97290194,1.2063009,0.77038799,-1.0029882,-0.97290194,1.2014176,0.76791881,-1.0029961,-0.97290194,1.2038632,0.76937358,-1.0029882,-0.97290194,1.2022354,0.76830413,-1.0029961,-0.97290194,1.2014176,0.76764358,-1.0029961,-0.97290194,1.2111842,0.77320317,-1.0029804,-0.97290194,1.205491,0.7700184,-1.0029882,-0.97290194,1.2046731,0.76954658,-1.0029882,-0.97290194,1.1965343,0.76551253,-1.0030039,-0.97290194,1.1965343,0.76551253,-1.0030039,-0.97290194,1.2071187,0.77090699,-1.0029882,-0.97290194,1.2071187,0.77068681,-1.0029882,-0.97290194,1.2005998,0.76745485,-1.0029961,-0.97290194,1.2030454,0.76881526,-1.0029961,-0.97290194,1.2022354,0.76841422,-1.0029961,-0.97290194,1.1949065,0.76493063,-1.0030039,-0.97290194,1.1957164,0.76535526,-1.0030039,-0.97290194,1.2005998,0.76730544,-1.0029961,-0.97290194,1.198972,0.76693585,-1.0029961,-0.97290194,1.1940887,0.76449813,-1.0030039,-0.97290194,1.198972,0.76678644,-1.0029961,-0.97290194,1.1916509,0.76290181,-1.0030118,-0.97290194,1.1916509,0.76298831,-1.0030118,-0.97290194,1.1859498,0.76020458,-1.0030197,-0.97290194,1.1908331,0.76256367,-1.0030118,-0.97290194,1.1818843,0.75815217,-1.0030275,-0.97290194,1.184322,0.75914299,-1.0030197,-0.97290194,1.1900232,0.76222553,-1.0030118,-0.97290194,1.1818843,0.75812858,-1.0030275,-0.97290194,1.1778109,0.7559189,-1.0030354,-0.97290194,1.1916509,0.76304335,-1.0030118,-0.97290194,1.1900232,0.76220194,-1.0030118,-0.97290194,1.1900232,0.7620604,-1.0030118,-0.97290194,1.1973442,0.76582708,-1.0030039,-0.97290194,1.1957164,0.7649149,-1.0030039,-0.97290194,1.1997898,0.76714031,-1.0029961,-0.97290194,1.198162,0.76643258,-1.0030039,-0.97290194,1.2030454,0.76892535,-1.0029961,-0.97290194,1.198972,0.76666849,-1.0029961,-0.97290194,1.2022354,0.76841422,-1.0029961,-0.97290194,1.2046731,0.7699319,-1.0029882,-0.97290194,1.2079287,0.77148104,-1.0029882,-0.97290194,1.1949065,0.76495422,-1.0030039,-0.97290194,1.2046731,0.76955444,-1.0029882,-0.97290194,1.2063009,0.77063963,-1.0029882,-0.97290194,1.1932787,0.76349158,-1.0030039,-0.97290194,1.2022354,0.76852431,-1.0029961,-0.97290194,1.1957164,0.76510363,-1.0030039,-0.97290194,1.1997898,0.76676285,-1.0029961,-0.97290194,1.205491,0.76986113,-1.0029882,-0.97290194,1.2046731,0.76946794,-1.0029882,-0.97290194,1.2046731,0.76945222,-1.0029882,-0.97290194,1.198972,0.76679431,-1.0029961,-0.97290194,1.2063009,0.77050594,-1.0029882,-0.97290194,1.2022354,0.76813113,-1.0029961,-0.97290194,1.2225865,0.77894363,-1.0029568,-0.97290194,1.225842,0.78059499,-1.0029568,-0.97290194,1.2282798,0.7816959,-1.0029568,-0.97290194,1.2250242,0.78026472,-1.0029568,-0.97290194,1.2282798,0.78156222,-1.0029489,-0.97290194,1.2242143,0.77974572,-1.0029568,-0.97290194,1.2233965,0.77909304,-1.0029568,-0.97290194,1.2242143,0.77977717,-1.0029568,-0.97290194,1.2242143,0.77980863,-1.0029568,-0.97290194,1.2282798,0.78155436,-1.0029489,-0.97290194,1.2307254,0.78304845,-1.0029489,-0.97290194,1.2290976,0.78209695,-1.0029489,-0.97290194,1.226652,0.78076013,-1.0029568,-0.97290194,1.2225865,0.7788414,-1.0029568,-0.97290194,1.225842,0.78061858,-1.0029568,-0.97290194,1.226652,0.78073654,-1.0029568,-0.97290194,1.2242143,0.77972999,-1.0029568,-0.97290194,1.2242143,0.77967495,-1.0029568,-0.97290194,1.2242143,0.77965922,-1.0029568,-0.97290194,1.212002,0.7730459,-1.0029804,-0.97290194,1.2160675,0.77523986,-1.0029725,-0.97208412,1.2103743,0.7726134,-1.0029804,-0.97290194,1.2071187,0.77101708,-1.0029882,-0.97290194,1.2144398,0.77481522,-1.0029725,-0.97290194,1.2160675,0.77526345,-1.0029725,-0.97290194,1.2087465,0.77132376,-1.0029804,-0.97290194,1.2022354,0.76800531,-1.0029961,-0.97290194,1.2005998,0.76728972,-1.0029961,-0.97290194,1.2087465,0.77152035,-1.0029804,-0.97290194,1.2063009,0.77030149,-1.0029882,-0.97290194,1.2005998,0.76741554,-1.0029961,-0.97290194,1.2038632,0.76904331,-1.0029882,-0.97290194,1.2193231,0.77715858,-1.0029646,-0.97290194,1.2079287,0.77126085,-1.0029804,-0.97290194,1.2136298,0.77435913,-1.0029725,-0.97290194,1.2103743,0.77277067,-1.0029804,-0.97290194,1.2063009,0.77038799,-1.0029882,-0.97290194,1.2103743,0.7723539,-1.0029804,-0.97290194,1.2087465,0.77144172,-1.0029804,-0.97290194,1.2136298,0.77395808,-1.0029725,-0.97290194,1.2136298,0.77412322,-1.0029725,-0.97290194,1.212002,0.77317958,-1.0029804,-0.97290194,1.2144398,0.77446922,-1.0029725,-0.97290194,1.2160675,0.77520054,-1.0029725,-0.97290194,1.2160675,0.77533422,-1.0029725,-0.97290194,1.2046731,0.76940504,-1.0029882,-0.97290194,1.2063009,0.77028576,-1.0029882,-0.97290194,1.2079287,0.77129231,-1.0029804,-0.97290194,1.2071187,0.77077331,-1.0029882,-0.97290194,1.2079287,0.77133949,-1.0029804,-0.97290194,1.2087465,0.77161472,-1.0029804,-0.97290194,1.205491,0.76986113,-1.0029882,-0.97290194,1.2022354,0.76816258,-1.0029961,-0.97290194,1.2046731,0.76956231,-1.0029882,-0.97290194,1.212002,0.77331326,-1.0029725,-0.97290194,1.212812,0.77393449,-1.0029725,-0.97290194,1.2176953,0.77606554,-1.0029646,-0.97290194,1.2185131,0.77674181,-1.0029646,-0.97290194,1.2046731,0.76948367,-1.0029882,-0.97290194,1.2185131,0.77653736,-1.0029646,-0.97290194,1.212812,0.77343122,-1.0029725,-0.97290194,1.2168854,0.77550722,-1.0029725,-0.97290194,1.2103743,0.7721809,-1.0029804,-0.97290194,1.2144398,0.77435913,-1.0029725,-0.97290194,1.2168854,0.77575886,-1.0029725,-0.97290194,1.212812,0.7736514,-1.0029725,-0.97290194,1.2201409,0.77731586,-1.0029646,-0.97290194,1.2201409,0.77720576,-1.0029646,-0.97290194,1.2201409,0.77730799,-1.0029646,-0.97290194,1.2242143,0.77929749,-1.0029568,-0.97290194,1.2209509,0.77795281,-1.0029646,-0.97290194,1.2152576,0.7752084,-1.0029725,-0.97290194,1.212002,0.77335258,-1.0029725,-0.97290194,1.2152576,0.77487813,-1.0029725,-0.97290194,1.2160675,0.77553867,-1.0029725,-0.97290194,1.2046731,0.76959376,-1.0029882,-0.97290194,1.226652,0.78095672,-1.0029568,-0.97290194,1.2209509,0.77803145,-1.0029646,-0.97290194,1.2185131,0.77674181,-1.0029646,-0.97290194,1.2299075,0.78251372,-1.0029489,-0.97290194,1.2290976,0.78212054,-1.0029489,-0.97290194,1.226652,0.78078372,-1.0029568,-0.97290194,1.2307254,0.78291477,-1.0029489,-0.97290194,1.2225865,0.77862122,-1.0029646,-0.97290194,1.226652,0.78088595,-1.0029568,-0.97290194,1.2339809,0.78435381,-1.002941,-0.97290194,1.2307254,0.78301699,-1.0029489,-0.97290194,1.226652,0.78076799,-1.0029568,-0.97290194,1.2323531,0.78366181,-1.0029489,-0.97290194,1.2331631,0.78423586,-1.002941,-0.97208412,1.2356087,0.7857614,-1.002941,-0.97290194,1.2388642,0.78734199,-1.0029332,-0.97290194,1.2388642,0.78712181,-1.0029332,-0.97290194,1.2388642,0.78732627,-1.0029332,-0.97290194,1.2323531,0.78374831,-1.0029489,-0.97290194,1.2437476,0.78975613,-1.0029253,-0.97290194,1.2421198,0.78900909,-1.0029332,-0.97290194,1.240492,0.78804972,-1.0029332,-0.97290194,1.2437476,0.78976399,-1.0029253,-0.97290194,1.2307254,0.78309563,-1.0029489,-0.97290194,1.241302,0.78832495,-1.0029332,-0.97290194,1.2518864,0.79396318,-1.0029174,-0.97290194,1.2535142,0.79474168,-1.0029096,-0.97290194,1.2461931,0.79121877,-1.0029253,-0.97290194,1.2364186,0.78631972,-1.002941,-0.97208412,1.2518864,0.79407327,-1.0029174,-0.97290194,1.2470031,0.79128168,-1.0029253,-0.97290194,1.254332,0.79503263,-1.0029096,-0.97290194,1.2502586,0.7931139,-1.0029174,-0.97290194,1.2453753,0.79075481,-1.0029253,-0.97290194,1.2518864,0.79402609,-1.0029174,-0.97290194,1.2518864,0.79392386,-1.0029174,-0.97290194,1.2518864,0.79392386,-1.0029174,-0.97290194,1.2518864,0.79392386,-1.0029174,-0.97290194,1.2518864,0.79392386,-1.0029174,-0.97290194,1.2518864,0.79392386,-1.0029174,-0.97290194,1.2518864,0.79392386,-1.0029174:5
-0.59200165,-0.59200165,1.7254667,-0.59200165,-0.59200165,-0.59200165,1.711444,-0.59200165,-0.59200165,-0.59200165,1.7174217,-0.59200165,-0.59200165,-0.59200165,1.7238068,-0.59200165,-0.59200165,-0.59200165,1.7290615,-0.59200165,-0.59200165,-0.59200165,1.7066883,-0.59200165,-0.59200165,-0.59200165,1.7014539,-0.59200165,-0.59200165,-0.59200165,1.7215563,-0.59200165,-0.59200165,-0.59200165,1.6998246,-0.59200165,-0.59200165,-0.59200165,1.7038471,-0.59200165,-0.59200165,-0.59200165,1.7293059,-0.59200165,-0.59200165,-0.59200165,1.7235522,-0.59200165,-0.59200165,-0.59200165,1.7190918,-0.59200165,-0.59200165,-0.59200165,1.7183586,-0.59200165,-0.59200165,-0.59200165,1.7192548,-0.59200165,-0.59200165,-0.59200165,1.7150795,-0.59200165,-0.59200165,-0.59200165,1.7183179,-0.59200165,-0.59200165,-0.59200165,1.7296013,-0.59200165,-0.59200165,-0.59200165,1.7309862,-0.59200165,-0.59200165,-0.59200165,1.7184605,-0.59200165,-0.59200165,-0.59200165,1.7221163,-0.59200165,-0.59200165,-0.59200165,1.7343875,-0.59200165,-0.59200165,-0.59200165,1.7211082,-0.59200165,-0.59200165,-0.59200165,1.7210878,-0.59200165,-0.59200165,-0.59200165,1.7279515,-0.59200165,-0.59200165,-0.59200165,1.7321471,-0.59200165,-0.59200165,-0.59200165,1.7238068,-0.59200165,-0.59200165,-0.59200165,1.7241836,-0.59200165,-0.59200165,-0.59200165,1.7358336,-0.59200165,-0.59200165,-0.59200165,1.7220756,-0.59200165,-0.59200165,-0.59200165,1.7123096,-0.59200165,-0.59200165,-0.59200165,1.7271572,-0.59200165,-0.59200165,-0.59200165,1.7250085,-0.59200165,-0.59200165,-0.59200165,1.7190715,-0.59200165,-0.59200165,-0.59200165,1.7248863,-0.59200165,-0.59200165,-0.59200165,1.7344588,-0.59200165,-0.59200165,-0.59200165,1.720324,-0.59200165,-0.59200165,-0.59200165,1.7171875,-0.59200165,-0.59200165,-0.59200165,1.7226968,-0.59200165,-0.59200165,-0.59200165,1.7174727,-0.59200165,-0.59200165,-0.59200165,1.7214137,-0.59200165,-0.59200165,-0.59200165,1.7283589,-0.59200165,-0.59200165,-0.59200165,1.7292041,-0.59200165,-0.59200165,-0.59200165,1.7238272,-0.59200165,-0.59200165,-0.59200165,1.7241123,-0.59200165,-0.59200165,-0.59200165,1.7285014,-0.59200165,-0.59200165,-0.59200165,1.7231347,-0.59200165,-0.59200165,-0.59200165,1.7193872,-0.59200165,-0.59200165,-0.59200165,1.7305992,-0.59200165,-0.59200165,-0.59200165,1.7310168,-0.59200165,-0.59200165,-0.59200165,1.7163525,-0.59200165,-0.59200165,-0.59200165,1.72676,-0.59200165,-0.59200165,-0.59200165,1.7243567,-0.59200165,-0.59200165,-0.59200165,1.7184095,-0.59200165,-0.59200165,-0.59200165,1.7184706,-0.59200165,-0.59200165,-0.59200165,1.7263222,-0.59200165,-0.59200165,-0.59200165,1.7324119,-0.59200165,-0.59200165,-0.59200165,1.7186438,-0.59200165,-0.59200165,-0.59200165,1.7177272,-0.59200165,-0.59200165,-0.59200165,1.7262509,-0.59200165,-0.59200165,-0.59200165,1.718155,-0.59200165,-0.59200165,-0.59200165,1.7169737,-0.59200165,-0.59200165,-0.59200165,1.7262203,-0.59200165,-0.59200165,-0.59200165,1.7244076,-0.59200165,-0.59200165,-0.59200165,1.7203953,-0.59200165,-0.59200165,-0.59200165,1.7083991,-0.59200165,-0.59200165,-0.59200165,1.7147944,-0.59200165,-0.59200165,-0.59200165,1.7051811,-0.59200165,-0.59200165,-0.59200165,1.7021872,-0.59200165,-0.59200165,-0.59200165,1.7164136,-0.59200165,-0.59200165,-0.59200165,1.713939,-0.59200165,-0.59200165,-0.59200165,1.7030222,-0.59200165,-0.59200165,-0.59200165,1.7080936,-0.59200165,-0.59200165,-0.59200165,1.7160877,-0.59200165,-0.59200165,-0.59200165,1.7131956,-0.59200165,-0.59200165,-0.59200165,1.7121772,-0.59200165,-0.59200165,-0.59200165,1.7200695,-0.59200165,-0.59200165,-0.59200165,1.7225848,-0.59200165,-0.59200165,-0.59200165,1.7160062,-0.59200165,-0.59200165,-0.59200165,1.7114542,-0.59200165,-0.59200165,-0.59200165,1.7285931,-0.59200165,-0.59200165,-0.59200165,1.7176152,-0.59200165,-0.59200165,-0.59200165,1.716658,-0.59200165,-0.59200165,-0.59200165,1.726648,-0.59200165,-0.59200165,-0.59200165,1.724041,-0.59200165,-0.59200165,-0.59200165,1.7196825,-0.59200165,-0.59200165,-0.59200165,1.7166682,-0.59200165,-0.59200165,-0.59200165,1.728756,-0.59200165,-0.59200165,-0.59200165,1.7160368,-0.59200165,-0.59200165,-0.59200165,1.7108635,-0.59200165,-0.59200165,-0.59200165,1.7266073,-0.59200165,-0.59200165,-0.59200165,1.7259759,-0.59200165,-0.59200165,-0.59200165,1.7187965,-0.59200165,-0.62257264,-0.52348678,1.7144583,-0.59136008,-0.63837749,-0.48553273,1.7234504,-0.59126843,-0.64154457,-0.48131674,1.7180429,-0.59123788,-0.64471165,-0.47710076,1.71677,-0.59121751,-0.64681965,-0.47393367,1.7202833,-0.59119715,-0.64786855,-0.47288477,1.7238068,-0.59118696,-0.64786855,-0.47288477,1.7125235,-0.59117678,-0.64786855,-0.47393367,1.7154054,-0.59118696,-0.64681965,-0.47393367,1.7236948,-0.59119715,-0.64471165,-0.47710076,1.6974314,-0.59120733,-0.64471165,-0.47710076,1.7019733,-0.59120733,-0.64365257,-0.47710076,1.7135113,-0.59121751,-0.64365257,-0.47814966,1.7192751,-0.59121751,-0.64365257,-0.48025765,1.7019122,-0.5912277,-0.64259348,-0.48025765,1.7047025,-0.5912277,-0.64259348,-0.47920875,1.7218007,-0.5912277,-0.64259348,-0.48025765,1.7121059,-0.5912277,-0.64259348,-0.48025765,1.7094786,-0.5912277,-0.64259348,-0.47920875,1.7269637,-0.5912277,-0.64259348,-0.47920875,1.7153748,-0.5912277,-0.64259348,-0.47920875,1.7139288,-0.5912277,-0.64365257,-0.47920875,1.7242549,-0.59121751,-0.64259348,-0.47920875,1.7149268,-0.5912277,-0.64259348,-0.48025765,1.7118615,-0.5912277,-0.64259348,-0.48025765,1.7104969,-0.5912277,-0.64259348,-0.48025765,1.7224626,-0.5912277,-0.64259348,-0.48025765,1.7141834,-0.5912277,-0.64259348,-0.48131674,1.7070345,-0.5912277,-0.64259348,-0.48025765,1.717768,-0.5912277,-0.64154457,-0.48025765,1.7191326,-0.5912277,-0.64154457,-0.48131674,1.7063217,-0.59123788,-0.64154457,-0.48131674,1.7107515,-0.59123788,-0.64154457,-0.48131674,1.7193566,-0.59123788,-0.64154457,-0.48131674,1.711332,-0.59123788,-0.64154457,-0.48131674,1.7118513,-0.59123788,-0.64154457,-0.48131674,1.7153036,-0.59123788,-0.64154457,-0.48131674,1.7179411,-0.59123788,-0.64154457,-0.48236565,1.7078594,-0.59123788,-0.64154457,-0.48236565,1.7108839,-0.59123788,-0.64154457,-0.48131674,1.7266989,-0.59123788,-0.64154457,-0.48131674,1.7142343,-0.59123788,-0.64154457,-0.48236565,1.7142648,-0.59123788,-0.64154457,-0.48131674,1.7236948,-0.59123788,-0.64154457,-0.48236565,1.7183688,-0.59123788,-0.64048548,-0.48236565,1.7053644,-0.59123788,-0.64048548,-0.48236565,1.7132669,-0.59123788,-0.64154457,-0.48131674,1.7238068,-0.59123788,-0.64154457,-0.48236565,1.7160368,-0.59123788,-0.64048548,-0.48236565,1.7069531,-0.59123788,-0.64048548,-0.48236565,1.7190511,-0.59123788,-0.64048548,-0.48236565,1.7216683,-0.59124806,-0.64048548,-0.48342473,1.7053339,-0.59123788,-0.64048548,-0.48236565,1.7182873,-0.59123788,-0.64048548,-0.48236565,1.7255482,-0.59123788,-0.64048548,-0.48236565,1.7156905,-0.59123788,-0.64048548,-0.48236565,1.7170449,-0.59123788,-0.64048548,-0.48236565,1.721373,-0.59123788,-0.64048548,-0.48236565,1.724316,-0.59123788,-0.64048548,-0.48342473,1.7048145,-0.59124806,-0.63943658,-0.48342473,1.7090916,-0.59124806,-0.64048548,-0.48236565,1.7310066,-0.59124806,-0.63943658,-0.48342473,1.7126864,-0.59124806,-0.64048548,-0.48342473,1.7157516,-0.59124806,-0.63943658,-0.48342473,1.7241429,-0.59124806,-0.63943658,-0.48236565,1.7206805,-0.59124806,-0.64048548,-0.48447364,1.7112403,-0.59124806,-0.63943658,-0.48342473,1.7116782,-0.59124806,-0.64048548,-0.48236565,1.7323203,-0.59124806,-0.64048548,-0.48342473,1.7193159,-0.59124806,-0.63943658,-0.48342473,1.7147027,-0.59124806,-0.64048548,-0.48342473,1.7266888,-0.59124806,-0.64048548,-0.48342473,1.7240614,-0.59124806,-0.64048548,-0.48447364,1.7175949,-0.59124806,-0.63943658,-0.48342473,1.7292245,-0.59124806,-0.63943658,-0.48236565,1.7416993,-0.59124806,-0.64048548,-0.48342473,1.7312815,-0.59124806,-0.63943658,-0.48342473,1.7303752,-0.59124806,-0.64048548,-0.48342473,1.7360372,-0.59124806,-0.64048548,-0.48342473,1.7376768,-0.59124806,-0.63943658,-0.48447364,1.7206703,-0.59125825,-0.63943658,-0.48342473,1.7317296,-0.59124806,-0.64048548,-0.48236565,1.7411901,-0.59124806,-0.63943658,-0.48342473,1.7272794,-0.59124806,-0.63943658,-0.48342473,1.7266888,-0.59124806,-0.63943658,-0.48342473,1.7289393,-0.59124806,-0.64048548,-0.48342473,1.7257621,-0.59124806,-0.64048548,-0.48447364,1.722931,-0.59124806,-0.63943658,-0.48342473,1.7235522,-0.59124806,-0.63943658,-0.48236565,1.7522698,-0.59124806,-0.63943658,-0.48342473,1.7299169,-0.59124806,-0.63943658,-0.48342473,1.7355281,-0.59125825,-0.63943658,-0.48342473,1.7373815,-0.59125825,-0.63943658,-0.48342473,1.7341227,-0.59124806,-0.63943658,-0.48342473,1.7303141,-0.59125825,-0.63943658,-0.48342473,1.7281348,-0.59125825,-0.63943658,-0.48342473,1.7422492,-0.59124806,-0.63943658,-0.48342473,1.7379721,-0.59124806,-0.63943658,-0.48342473,1.7306094,-0.59124806,-0.63943658,-0.48342473,1.7292245,-0.59124806,-0.63943658,-0.48342473,1.745345,-0.59124806,-0.63837749,-0.48447364,1.7175338,-0.59125825,-0.63943658,-0.48447364,1.7212202,-0.59124806,-0.63943658,-0.48342473,1.7362817,-0.59124806,-0.63943658,-0.48447364,1.724815,-0.59124806,-0.63943658,-0.48342473,1.7270044,-0.59124806,-0.63837749,-0.48447364,1.72676,-0.59124806,-0.63943658,-0.48342473,1.7406198,-0.59124806,-0.63943658,-0.48447364,1.7184605,-0.59124806,-0.63943658,-0.48447364,1.7284607,-0.59124806,-0.63943658,-0.48342473,1.7410679,-0.59124806,-0.63943658,-0.48447364,1.72343,-0.59124806,-0.63943658,-0.48447364,1.7293059,-0.59124806,-0.63943658,-0.48342473,1.7405282,-0.59124806,-0.63943658,-0.48342473,1.7446016,-0.59124806,-0.63943658,-0.48447364,1.7288273,-0.59124806,-0.63943658,-0.48342473,1.7344894,-0.59125825,-0.63943658,-0.48342473,1.7436138,-0.59124806,-0.63943658,-0.48447364,1.729143,-0.59124806,-0.63943658,-0.48447364,1.7253649,-0.59124806,-0.63943658,-0.48342473,1.7394487,-0.59124806,-0.63943658,-0.48342473,1.7390108,-0.59125825,-0.63837749,-0.48447364,1.7239799,-0.59125825,-0.63943658,-0.48342473,1.7442757,-0.59125825,-0.63943658,-0.48236565,1.7493981,-0.59124806,-0.63943658,-0.48447364,1.7308946,-0.59125825,-0.63943658,-0.48447364,1.7282672,-0.59125825,-0.63837749,-0.48342473,1.7349883,-0.59124806,-0.63943658,-0.48342473,1.7530743,-0.59125825,-0.63943658,-0.48447364,1.7300493,-0.59125825,-0.63943658,-0.48342473,1.7443572,-0.59124806,-0.63837749,-0.48236565,1.7590011,-0.59125825,-0.63837749,-0.48447364,1.733084,-0.59125825,-0.63943658,-0.48447364,1.7299169,-0.59125825,-0.63943658,-0.48342473,1.7467911,-0.59124806,-0.63943658,-0.48342473,1.750447,-0.59124806,-0.63943658,-0.48447364,1.7349069,-0.59125825,-0.63837749,-0.48447364,1.7352735,-0.59125825,-0.63943658,-0.48342473,1.7469846,-0.59124806,-0.63943658,-0.48447364,1.7329618,-0.59125825,-0.63837749,-0.48447364,1.7250288,-0.59125825,-0.63943658,-0.48342473,1.7468318,-0.59125825,-0.63837749,-0.48342473,1.7481964,-0.59125825,-0.63837749,-0.48447364,1.7246622,-0.59125825,-0.63943658,-0.48342473,1.7488685,-0.59125825,-0.63943658,-0.48342473,1.7512616,-0.59124806,-0.63837749,-0.48447364,1.7292041,-0.59125825,-0.63837749,-0.48447364,1.7306298,-0.59125825,-0.63837749,-0.48342473,1.7399986,-0.59125825,-0.63943658,-0.48342473,1.7471271,-0.59125825,-0.63943658,-0.48447364,1.729754,-0.59125825,-0.63943658,-0.48447364,1.729754,-0.59125825,-0.63943658,-0.48342473,1.7415465,-0.59125825,-0.63943658,-0.48342473,1.7519236,-0.59124806,-0.63837749,-0.48342473,1.7324628,-0.59125825,-0.63837749,-0.48447364,1.728919,-0.59125825,-0.63943658,-0.48342473,1.7440619,-0.59125825,-0.63837749,-0.48342473,1.7374222,-0.59125825,-0.63837749,-0.48447364,1.7287153,-0.59125825,-0.63837749,-0.48342473,1.7405078,-0.59125825,-0.63837749,-0.48342473,1.7508543,-0.59125825,-0.63837749,-0.48447364,1.7373815,-0.59125825,-0.63837749,-0.48447364,1.7239799,-0.59125825,-0.63837749,-0.48342473,1.7459255,-0.59125825,-0.63837749,-0.48342473,1.7456505,-0.59125825,-0.63837749,-0.48447364,1.7237865,-0.59125825,-0.63943658,-0.48342473,1.7486343,-0.59125825,-0.63943658,-0.48342473,1.7484408,-0.59124806,-0.63943658,-0.48447364,1.7417298,-0.59125825,-0.63837749,-0.48447364,1.7305891,-0.59125825,-0.63837749,-0.48342473,1.7440822,-0.59125825,-0.63837749,-0.48342473,1.7502127,-0.59125825,-0.63943658,-0.48447364,1.7361493,-0.59125825,-0.63837749,-0.48342473,1.7412818,-0.59125825,-0.63943658,-0.48342473,1.75783,-0.59125825,-0.63837749,-0.48447364,1.7398153,-0.59125825,-0.63837749,-0.48447364,1.7360576,-0.59125825,-0.63837749,-0.48342473,1.7525448,-0.59125825,-0.63837749,-0.48342473,1.7480538,-0.59125825,-0.63943658,-0.48342473,1.7336849,-0.59125825,-0.63943658,-0.48342473,1.7452737,-0.59125825,-0.63943658,-0.48342473,1.7553554,-0.59125825,-0.63837749,-0.48342473,1.7420659,-0.59125825,-0.63837749,-0.48447364,1.7321166,-0.59125825,-0.63837749,-0.48342473,1.7502637,-0.59125825,-0.63837749,-0.48342473,1.7518319,-0.59125825,-0.63837749,-0.48447364,1.7306196,-0.59125825,-0.63837749,-0.48342473,1.7443776,-0.59125825,-0.63837749,-0.48342473,1.7546222,-0.59125825,-0.63837749,-0.48342473,1.7427686,-0.59125825,-0.63837749,-0.48447364,1.7331044,-0.59125825,-0.63837749,-0.48342473,1.7424427,-0.59125825,-0.63837749,-0.48342473,1.7482168,-0.59125825,-0.63837749,-0.48447364,1.733746,-0.59125825,-0.63943658,-0.48342473,1.749785,-0.59125825,-0.63837749,-0.48342473,1.754724,-0.59125825,-0.63837749,-0.48342473,1.7476669,-0.59125825,-0.63837749,-0.48447364,1.7346217,-0.59125825,-0.63943658,-0.48342473,1.7477076,-0.59124806,-0.63943658,-0.48342473,1.7425038,-0.59125825,-0.63837749,-0.48447364,1.7404467,-0.59125825,-0.63943658,-0.48342473,1.7513126,-0.59124806,-0.63943658,-0.48236565,1.7594798,-0.59125825,-0.63943658,-0.48342473,1.7528401,-0.59124806,-0.63837749,-0.48447364,1.7356808,-0.59124806,-0.63837749,-0.48342473,1.7550499,-0.59125825,-0.63837749,-0.48342473,1.7452228,-0.59125825,-0.63837749,-0.48447364,1.7332775,-0.59125825,-0.63837749,-0.48342473,1.752392,-0.59125825,-0.63837749,-0.48342473,1.7534409,-0.59125825,-0.63943658,-0.48342473,1.7501415,-0.59125825,-0.63837749,-0.48447364,1.73397,-0.59125825,-0.63837749,-0.48342473,1.7487361,-0.59125825,-0.63943658,-0.48342473,1.7545,-0.59125825,-0.63837749,-0.48447364,1.7314445,-0.59125825,-0.63943658,-0.48342473,1.7507321,-0.59125825,-0.63943658,-0.48342473,1.7531761,-0.59125825,-0.63943658,-0.48342473,1.7440924,-0.59125825,-0.63943658,-0.48342473,1.7393673,-0.59125825,-0.63837749,-0.48342473,1.7465467,-0.59125825,-0.63943658,-0.48342473,1.7450701,-0.59125825,-0.63837749,-0.48447364,1.7322897,-0.59125825,-0.63837749,-0.48342473,1.7369436,-0.59125825,-0.63943658,-0.48236565,1.7587669,-0.59125825,-0.63837749,-0.48342473,1.7484408,-0.59125825,-0.63837749,-0.48447364,1.7383896,-0.59125825,-0.63943658,-0.48342473,1.7510172,-0.59125825,-0.63837749,-0.48342473,1.7455589,-0.59125825,-0.63837749,-0.48447364,1.7341227,-0.59125825,-0.63943658,-0.48342473,1.7420863,-0.59125825,-0.63837749,-0.48342473,1.7547546,-0.59125825,-0.63943658,-0.48342473,1.7488583,-0.59125825,-0.63837749,-0.48342473,1.7388072,-0.59125825,-0.63943658,-0.48342473,1.7505386,-0.59125825,-0.63943658,-0.48342473,1.7520661,-0.59125825,-0.63943658,-0.48447364,1.7325647,-0.59125825,-0.63837749,-0.48342473,1.7379518,-0.59124806,-0.63943658,-0.48342473,1.7526568,-0.59124806,-0.63943658,-0.48342473,1.7424529,-0.59125825,-0.63837749,-0.48447364,1.734968,-0.59125825,-0.63837749,-0.48342473,1.7440313,-0.59125825,-0.63943658,-0.48342473,1.7476567,-0.59124806,-0.63837749,-0.48447364,1.7274729,-0.59124806,-0.63943658,-0.48447364,1.733359,-0.59124806,-0.63943658,-0.48342473,1.7390516,-0.59124806,-0.63943658,-0.48342473,1.7433694,-0.59124806,-0.63943658,-0.48447364,1.7274322,-0.59124806,-0.63943658,-0.48342473,1.7374018,-0.59124806,-0.63943658,-0.48342473,1.7386239,-0.59125825,-0.63837749,-0.48447364,1.7297031,-0.59125825,-0.63943658,-0.48342473,1.7332266,-0.59124806,-0.63943658,-0.48342473,1.7417298,-0.59125825,-0.63837749,-0.48342473,1.7422696,-0.59125825,-0.63837749,-0.48447364,1.7323814,-0.59125825,-0.63943658,-0.48342473,1.7443165,-0.59124806,-0.63943658,-0.48342473,1.7425751,-0.59125825,-0.63837749,-0.48447364,1.7266378,-0.59125825,-0.63837749,-0.48447364,1.7343773,-0.59125825,-0.63837749,-0.48342473,1.7438277,-0.59124806,-0.63837749,-0.48342473,1.7440517,-0.59125825,-0.63837749,-0.48447364,1.7358845,-0.59125825,-0.63943658,-0.48342473,1.7435018,-0.59125825,-0.63943658,-0.48342473,1.7474734,-0.59124806,-0.63943658,-0.48447364,1.7326767,-0.59125825,-0.63943658,-0.48447364,1.737911,-0.59125825,-0.63943658,-0.48342473,1.7495203,-0.59124806,-0.63837749,-0.48342473,1.7426056,-0.59125825,-0.63943658,-0.48342473,1.7419946,-0.59125825,-0.63943658,-0.48342473,1.7419946,-0.59125825,-0.63943658,-0.48342473,1.7419946,-0.59125825,-0.63943658,-0.48342473,1.7419946,-0.59125825,-0.63943658,-0.48342473,1.7419946,-0.59125825,-0.63943658,-0.48342473,1.7419946,-0.59125825:5
-0.8455854,-0.052047139,1.6587487,-0.69821344,-0.8455854,-0.036448574,1.658349,-0.69814349,-0.84454616,-0.061400282,1.659608,-0.69825341,-0.8455854,-0.05724333,1.6592383,-0.69823342,-0.84454616,-0.063488751,1.6604674,-0.69825341,-0.84454616,-0.065567227,1.6595281,-0.6982634,-0.84454616,-0.063488751,1.6617365,-0.69825341,-0.84454616,-0.067645704,1.6628956,-0.69827339,-0.84454616,-0.065567227,1.6616166,-0.6982634,-0.84454616,-0.066606465,1.6592483,-0.69827339,-0.84454616,-0.062449513,1.6594881,-0.69825341,-0.84454616,-0.065567227,1.6638449,-0.6982634,-0.84454616,-0.065567227,1.6636151,-0.6982634,-0.84454616,-0.063488751,1.6627657,-0.69825341,-0.8455854,-0.053086377,1.6636751,-0.69821344,-0.84766387,-0.014604588,1.6641247,-0.69805355,-0.84454616,-0.071802656,1.6644945,-0.69829338,-0.8455854,-0.062449513,1.6636251,-0.69825341,-0.8455854,-0.065567227,1.6643446,-0.6982634,-0.84454616,-0.06972418,1.6641547,-0.69828338,-0.84454616,-0.06972418,1.6654038,-0.69828338,-0.84454616,-0.067645704,1.6655937,-0.69827339,-0.84454616,-0.063488751,1.6640048,-0.69825341,-0.84454616,-0.072841894,1.6643046,-0.69829338,-0.8455854,-0.063488751,1.6655537,-0.69825341,-0.84454616,-0.070763418,1.6652439,-0.69828338,-0.84454616,-0.073881132,1.6645244,-0.69830337,-0.84454616,-0.06972418,1.6646643,-0.69828338,-0.84662464,-0.0093984046,1.6568301,-0.69802357,-0.8455854,-0.055164853,1.6614567,-0.69822343,-0.84454616,-0.05724333,1.6609671,-0.69823342,-0.8455854,-0.045801717,1.6602476,-0.69818346,-0.8455854,-0.055164853,1.6614067,-0.69822343,-0.84454616,-0.054125615,1.6602876,-0.69822343,-0.84454616,-0.054125615,1.6607772,-0.69822343,-0.85597778,0.18196131,1.6590585,-0.69722416,-0.85597778,0.17259817,1.6582291,-0.69726413,-0.85182083,0.10603697,1.6578693,-0.69754393,-0.85078159,0.07483984,1.6574296,-0.69767383,-0.84870311,0.025955677,1.6599378,-0.69788368,-0.8455854,-0.051007901,1.6615067,-0.69820344,-0.8455854,-0.049968663,1.6601377,-0.69820344,-0.84454616,-0.054125615,1.6598179,-0.69822343,-0.84454616,-0.054125615,1.6574796,-0.69822343,-0.84454616,-0.059321806,1.6582091,-0.69824341,-0.84454616,-0.053086377,1.6602076,-0.69821344,-0.8455854,-0.033320867,1.6592783,-0.69813349,-0.84454616,-0.055164853,1.6590984,-0.69822343,-0.84454616,-0.05724333,1.6612868,-0.69823342,-0.84454616,-0.064527989,1.6632054,-0.6982634,-0.8455854,-0.05724333,1.6649042,-0.69823342,-0.84454616,-0.063488751,1.6636451,-0.69825341,-0.8455854,-0.056204091,1.663755,-0.69822343,-0.8455854,-0.059321806,1.6625759,-0.69824341,-0.84454616,-0.068684942,1.6630755,-0.69828338,-0.84454616,-0.067645704,1.6626158,-0.69827339,-0.84454616,-0.073881132,1.6645644,-0.69830337,-0.84454616,-0.065567227,1.6630255,-0.6982634,-0.84349693,-0.072841894,1.662376,-0.69829338,-0.84454616,-0.063488751,1.6625659,-0.69825341,-0.84454616,-0.072841894,1.6632654,-0.69829338,-0.84454616,-0.07492037,1.6624959,-0.69830337,-0.84454616,-0.06972418,1.6629056,-0.69828338,-0.84454616,-0.070763418,1.6635851,-0.69828338,-0.84454616,-0.072841894,1.6658435,-0.69829338,-0.84349693,-0.080126554,1.6608771,-0.69832335,-0.84454616,-0.071802656,1.6612169,-0.69829338,-0.84349693,-0.079087316,1.6626358,-0.69832335,-0.84349693,-0.08220503,1.6626958,-0.69833335,-0.84454616,-0.073881132,1.6636551,-0.69830337,-0.84349693,-0.081165792,1.6650241,-0.69833335,-0.84349693,-0.081165792,1.663715,-0.69833335,-0.84349693,-0.083244268,1.6643446,-0.69834334,-0.84349693,-0.080126554,1.6652539,-0.69832335,-0.84349693,-0.086361983,1.6673624,-0.69836333,-0.84349693,-0.086361983,1.6660533,-0.69835333,-0.84349693,-0.081165792,1.6671625,-0.69833335,-0.84245769,-0.088450452,1.6673024,-0.69837332,-0.84349693,-0.083244268,1.6680918,-0.69835333,-0.84349693,-0.085322745,1.6682517,-0.69836333,-0.84349693,-0.08220503,1.6677021,-0.69834334,-0.84349693,-0.090528928,1.6672924,-0.69838331,-0.84245769,-0.092607404,1.665104,-0.69838331,-0.84245769,-0.09468588,1.6646244,-0.6983933,-0.84245769,-0.10508825,1.6652839,-0.69843327,-0.84349693,-0.093646642,1.6671625,-0.69838331,-0.84245769,-0.099882071,1.6669427,-0.6983933,-0.84349693,-0.092607404,1.6670526,-0.69838331,-0.84349693,0.0062001602,1.6671425,-0.69836333,-0.84245769,-0.095725119,1.6667728,-0.69843327,-0.84245769,-0.098842833,1.6669527,-0.69841329,-0.84245769,-0.10716673,1.6676122,-0.69845326,-0.84245769,-0.10197054,1.6673823,-0.69841329,-0.84245769,-0.10716673,1.6673624,-0.69845326,-0.84245769,-0.098842833,1.6672425,-0.69842328,-0.84245769,-0.10716673,1.6669127,-0.69844327,-0.84245769,-0.11132368,1.6673624,-0.69846325,-0.84141845,-0.1227653,1.6674423,-0.69851322,-0.84141845,-0.12797148,1.6672924,-0.6985332,-0.84141845,-0.12172606,1.6672924,-0.69851322,-0.84037921,-0.12692225,1.667822,-0.6985332,-0.84141845,-0.12172606,1.6686015,-0.69851322,-0.84037921,-0.12797148,1.6661433,-0.69852321,-0.84037921,-0.13212843,1.6648642,-0.69854319,-0.84037921,-0.13108919,1.6640648,-0.69854319,-0.83933998,-0.13628538,1.6641547,-0.69856318,-0.84037921,-0.12901072,1.6641547,-0.6985332,-0.84037921,-0.13316767,1.6650141,-0.69855319,-0.84037921,-0.12588301,1.6640548,-0.69852321,-0.84037921,-0.13316767,1.6645344,-0.69855319,-0.83933998,-0.13836386,1.6645844,-0.69857317,-0.84037921,-0.13108919,1.6644945,-0.69854319,-0.83933998,-0.1394031,1.6644445,-0.69857317,-0.84037921,-0.13316767,1.6647643,-0.69855319,-0.84037921,-0.14045233,1.6649641,-0.69858316,-0.84349693,-0.078048078,1.6662132,-0.69832335,-0.83933998,-0.14149157,1.6671325,-0.69858316,-0.84141845,-0.1227653,1.6659734,-0.69850322,-0.84454616,-0.06972418,1.6663231,-0.69828338,-0.85078159,0.06964365,1.6662332,-0.69770381,-0.85078159,0.061319752,1.6645444,-0.69773379,-0.84974235,0.039475766,1.667902,-0.69784371,-0.85078159,0.043642711,1.6680918,-0.69782372,-0.85078159,0.06235899,1.6659034,-0.69773379,-0.85078159,0.065476705,1.6668328,-0.6977138,-0.85078159,0.066515943,1.6667228,-0.6977138,-0.84037921,-0.13316767,1.6687414,-0.69856318,-0.83933998,-0.14876623,1.6686714,-0.69862313,-0.84037921,-0.14876623,1.669201,-0.69862313,-0.83933998,-0.14668776,1.6684316,-0.69861314,-0.83933998,-0.15188395,1.6688313,-0.69863313,-0.83933998,-0.15292319,1.6687713,-0.69864312,-0.83830074,-0.15709013,1.6662332,-0.69865311,-0.83933998,-0.14876623,1.6686214,-0.69862313,-0.85078159,0.075879079,1.667912,-0.69768382,-0.85493854,0.15284266,1.6696007,-0.69736406,-0.85286006,0.11332163,1.6691411,-0.69753393,-0.85493854,0.13620485,1.6697806,-0.69743401,-0.8538993,0.12995943,1.6659434,-0.697444,-0.85078159,0.09355612,1.6650341,-0.69760388,-0.85182083,0.090438405,1.6660433,-0.69761387,-0.85182083,0.092516881,1.6658235,-0.69760388,-0.85286006,0.09460535,1.6666229,-0.69759389,-0.85182083,0.09460535,1.6655037,-0.69759389,-0.85078159,0.092516881,1.6655937,-0.69760388,-0.85078159,0.092516881,1.6658235,-0.69760388,-0.85182083,0.091477643,1.6656336,-0.69760388,-0.85182083,0.098762303,1.6662632,-0.6975739,-0.85078159,0.0925168