/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tool.common.ImportTsFileOperation;
import org.apache.iotdb.tool.tsfile.AbstractTsFileTool;
import org.apache.iotdb.tool.tsfile.ImportTsFileBase;
import org.apache.iotdb.tool.tsfile.ImportTsFileLocally;
import org.apache.iotdb.tool.tsfile.ImportTsFileRemotely;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;

public class ImportTsFile
extends AbstractTsFileTool {
    private static final String SOURCE_ARGS = "s";
    private static final String SOURCE_NAME = "source";
    private static final String ON_SUCCESS_ARGS = "os";
    private static final String ON_SUCCESS_NAME = "on_success";
    private static final String SUCCESS_DIR_ARGS = "sd";
    private static final String SUCCESS_DIR_NAME = "success_dir";
    private static final String FAIL_DIR_ARGS = "fd";
    private static final String FAIL_DIR_NAME = "fail_dir";
    private static final String ON_FAIL_ARGS = "of";
    private static final String ON_FAIL_NAME = "on_fail";
    private static final String THREAD_NUM_ARGS = "tn";
    private static final String THREAD_NUM_NAME = "thread_num";
    protected static final String VERIFY_ARGS = "v";
    protected static final String VERIFY_NAME = "verify";
    private static final IoTPrinter IOT_PRINTER = new IoTPrinter(System.out);
    private static final String TS_FILE_CLI_PREFIX = "ImportTsFile";
    protected static String timestampPrecision = "ms";
    private static final String TIMESTAMP_PRECISION_ARGS = "tp";
    private static final String TIMESTAMP_PRECISION_NAME = "timestamp_precision";
    private static final String TIMESTAMP_PRECISION_ARGS_NAME = "timestamp precision (ms/us/ns)";
    private static String source;
    private static String successDir;
    private static String failDir;
    private static ImportTsFileOperation successOperation;
    private static ImportTsFileOperation failOperation;
    private static int threadNum;
    private static boolean isRemoteLoad;
    protected static boolean verify;
    private static SessionPool sessionPool;

    private static void createOptions() {
        ImportTsFile.createBaseOptions();
        Option opSource = Option.builder((String)SOURCE_ARGS).longOpt(SOURCE_NAME).argName(SOURCE_NAME).required().hasArg().desc("The source file or directory path, which can be a tsfile or a directory containing tsfiles. (required)").build();
        options.addOption(opSource);
        Option opOnSuccess = Option.builder((String)ON_SUCCESS_ARGS).longOpt(ON_SUCCESS_NAME).argName(ON_SUCCESS_NAME).required().hasArg().desc("When loading tsfile successfully, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnSuccess);
        Option opOnFail = Option.builder((String)ON_FAIL_ARGS).longOpt(ON_FAIL_NAME).argName(ON_FAIL_NAME).required().hasArg().desc("When loading tsfile fail, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnFail);
        Option opSuccessDir = Option.builder((String)SUCCESS_DIR_ARGS).longOpt(SUCCESS_DIR_NAME).argName(SUCCESS_DIR_NAME).hasArg().desc("The target folder when 'os' is 'mv' or 'cp'.").build();
        options.addOption(opSuccessDir);
        Option opFailDir = Option.builder((String)FAIL_DIR_ARGS).longOpt(FAIL_DIR_NAME).argName(FAIL_DIR_NAME).hasArg().desc("The target folder when 'of' is 'mv' or 'cp'.").build();
        options.addOption(opFailDir);
        Option opThreadNum = Option.builder((String)THREAD_NUM_ARGS).longOpt(THREAD_NUM_NAME).argName(THREAD_NUM_NAME).hasArgs().desc("The number of threads used to import tsfile, default is 8.").build();
        options.addOption(opThreadNum);
        Option opTimestampPrecision = Option.builder((String)TIMESTAMP_PRECISION_ARGS).longOpt(TIMESTAMP_PRECISION_NAME).argName(TIMESTAMP_PRECISION_ARGS_NAME).hasArg().desc("Timestamp precision (ms/us/ns) (optional)").build();
        options.addOption(opTimestampPrecision);
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        ImportTsFile.createOptions();
        DefaultParser parser = new DefaultParser();
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(null);
        helpFormatter.setWidth(92);
        if (args == null || args.length == 0) {
            IOT_PRINTER.println("Too few arguments, please check the following hint.");
            helpFormatter.printHelp(TS_FILE_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            if (parser.parse(helpOptions, args, true).hasOption("help")) {
                helpFormatter.printHelp(TS_FILE_CLI_PREFIX, options, true);
                System.exit(0);
            }
        }
        catch (ParseException e) {
            IOT_PRINTER.println("Failed to parse the provided options: " + e.getMessage());
            helpFormatter.printHelp(TS_FILE_CLI_PREFIX, options, true);
            System.exit(1);
        }
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args, true);
        }
        catch (ParseException e) {
            IOT_PRINTER.println("Failed to parse the provided options: " + e.getMessage());
            helpFormatter.printHelp(TS_FILE_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            ImportTsFile.parseBasicParams(commandLine);
            ImportTsFile.parseSpecialParams(commandLine);
        }
        catch (Exception e) {
            IOT_PRINTER.println("Encounter an error when parsing the provided options: " + e.getMessage());
            System.exit(1);
        }
        IOT_PRINTER.println(isRemoteLoad ? "Load remotely." : "Load locally.");
        int resultCode = ImportTsFile.importFromTargetPath();
        ImportTsFileBase.printResult(startTime);
        System.exit(resultCode);
    }

    private static void checkTimePrecision() {
        String precision = null;
        if (!isRemoteLoad) {
            try {
                precision = sessionPool.getTimestampPrecision();
            }
            catch (Exception e) {
                IOT_PRINTER.println("Encounter an error when get IoTDB server timestampPrecision : " + e.getMessage());
                System.exit(1);
            }
            if (!timestampPrecision.equalsIgnoreCase(precision)) {
                IOT_PRINTER.println(String.format("Encounter an error The time accuracy of the iotdb server is \"%s\", but the client time accuracy is %s", precision, timestampPrecision));
                System.exit(1);
            }
        }
    }

    public static void importData(CommandLine commandLine) {
        long startTime = System.currentTimeMillis();
        ImportTsFile.createOptions();
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(null);
        helpFormatter.setWidth(92);
        try {
            ImportTsFile.parseBasicParams(commandLine);
            ImportTsFile.parseSpecialParams(commandLine);
        }
        catch (Exception e) {
            IOT_PRINTER.println("Encounter an error when parsing the provided options: " + e.getMessage());
            System.exit(1);
        }
        IOT_PRINTER.println(isRemoteLoad ? "Load remotely." : "Load locally.");
        int resultCode = ImportTsFile.importFromTargetPath();
        ImportTsFileBase.printResult(startTime);
        System.exit(resultCode);
    }

    private static void parseSpecialParams(CommandLine commandLine) {
        source = commandLine.getOptionValue(SOURCE_ARGS);
        if (!Files.exists(Paths.get(source, new String[0]), new LinkOption[0])) {
            IOT_PRINTER.println(String.format("Source file or directory %s does not exist", source));
            System.exit(1);
        }
        String onSuccess = commandLine.getOptionValue(ON_SUCCESS_ARGS).trim().toLowerCase();
        String onFail = commandLine.getOptionValue(ON_FAIL_ARGS).trim().toLowerCase();
        if (!ImportTsFileOperation.isValidOperation(onSuccess) || !ImportTsFileOperation.isValidOperation(onFail)) {
            IOT_PRINTER.println("Args error: os/of must be one of none, mv, cp, delete");
            System.exit(1);
        }
        boolean isSuccessDirEqualsSourceDir = false;
        if (ImportTsFileOperation.MV.name().equalsIgnoreCase(onSuccess) || ImportTsFileOperation.CP.name().equalsIgnoreCase(onSuccess)) {
            File dir = ImportTsFile.createSuccessDir(commandLine);
            isSuccessDirEqualsSourceDir = ImportTsFile.isFileStoreEquals(source, dir);
        }
        boolean isFailDirEqualsSourceDir = false;
        if (ImportTsFileOperation.MV.name().equalsIgnoreCase(onFail) || ImportTsFileOperation.CP.name().equalsIgnoreCase(onFail)) {
            File dir = ImportTsFile.createFailDir(commandLine);
            isFailDirEqualsSourceDir = ImportTsFile.isFileStoreEquals(source, dir);
        }
        successOperation = ImportTsFileOperation.getOperation(onSuccess, isSuccessDirEqualsSourceDir);
        failOperation = ImportTsFileOperation.getOperation(onFail, isFailDirEqualsSourceDir);
        if (commandLine.getOptionValue(THREAD_NUM_ARGS) != null) {
            threadNum = Integer.parseInt(commandLine.getOptionValue(THREAD_NUM_ARGS));
        }
        try {
            isRemoteLoad = !NodeUrlUtils.containsLocalAddress(Collections.singletonList(host));
        }
        catch (UnknownHostException e) {
            IOT_PRINTER.println("Unknown host: " + host + ". Exception: " + e.getMessage() + ". Will use remote load.");
        }
        if (commandLine.getOptionValue(TIMESTAMP_PRECISION_ARGS) != null) {
            timestampPrecision = commandLine.getOptionValue(TIMESTAMP_PRECISION_ARGS);
        }
        verify = null != commandLine.getOptionValue(VERIFY_ARGS) ? Boolean.parseBoolean(commandLine.getOptionValue(VERIFY_ARGS)) : verify;
    }

    public static boolean isFileStoreEquals(String pathString, File dir) {
        try {
            return Objects.equals(Files.getFileStore(Paths.get(pathString, new String[0])), Files.getFileStore(dir.toPath()));
        }
        catch (IOException e) {
            IOT_PRINTER.println("IOException when checking file store: " + e.getMessage());
            return false;
        }
    }

    public static File createSuccessDir(CommandLine commandLine) {
        File file;
        if (commandLine.getOptionValue(SUCCESS_DIR_ARGS) != null) {
            successDir = commandLine.getOptionValue(SUCCESS_DIR_ARGS);
        }
        if (!(file = new File(successDir)).isDirectory() && !file.mkdirs()) {
            IOT_PRINTER.println(String.format("Failed to create %s %s", SUCCESS_DIR_NAME, successDir));
            System.exit(1);
        }
        return file;
    }

    public static File createFailDir(CommandLine commandLine) {
        File file;
        if (commandLine.getOptionValue(FAIL_DIR_ARGS) != null) {
            failDir = commandLine.getOptionValue(FAIL_DIR_ARGS);
        }
        if (!(file = new File(failDir)).isDirectory() && !file.mkdirs()) {
            IOT_PRINTER.println(String.format("Failed to create %s %s", FAIL_DIR_NAME, failDir));
            System.exit(1);
        }
        return file;
    }

    public static int importFromTargetPath() {
        try {
            sessionPool = new SessionPool.Builder().host(host).port(Integer.parseInt(port)).user(username).password(password).maxSize(threadNum + 1).enableCompression(false).enableRedirection(false).enableAutoFetch(false).build();
            sessionPool.setEnableQueryRedirection(false);
            ImportTsFile.checkTimePrecision();
            ImportTsFile.processSetParams();
            ImportTsFileScanTool.traverseAndCollectFiles();
            ImportTsFileScanTool.addNoResourceOrModsToQueue();
            ImportTsFile.asyncImportTsFiles();
            int n = 0;
            return n;
        }
        catch (InterruptedException e) {
            IOT_PRINTER.println(String.format("Import tsfile fail: %s", e.getMessage()));
            Thread.currentThread().interrupt();
            int n = 1;
            return n;
        }
        catch (Exception e) {
            IOT_PRINTER.println(String.format("Import tsfile fail: %s", e.getMessage()));
            int n = 1;
            return n;
        }
        finally {
            if (sessionPool != null) {
                sessionPool.close();
            }
        }
    }

    private static void processSetParams() {
        File file = new File(source);
        ImportTsFileScanTool.setSourceFullPath(file.getAbsolutePath());
        if (!file.isFile() && !file.isDirectory()) {
            IOT_PRINTER.println(String.format("Source file or directory %s does not exist", source));
            System.exit(1);
        }
        ImportTsFileLocally.setSessionPool(sessionPool);
        ImportTsFileLocally.setVerify(verify);
        ImportTsFileRemotely.setHost(host);
        ImportTsFileRemotely.setPort(port);
        ImportTsFileRemotely.setUsername(username);
        ImportTsFileRemotely.setPassword(password);
        ImportTsFileRemotely.setValidateTsFile(verify);
        ImportTsFileBase.setSuccessAndFailDirAndOperation(successDir, successOperation, failDir, failOperation);
    }

    public static void asyncImportTsFiles() {
        ArrayList<Thread> list = new ArrayList<Thread>(threadNum);
        for (int i = 0; i < threadNum; ++i) {
            Thread thread2 = new Thread(isRemoteLoad ? new ImportTsFileRemotely(timestampPrecision) : new ImportTsFileLocally());
            thread2.start();
            list.add(thread2);
        }
        list.forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                IOT_PRINTER.println("ImportTsFile thread join interrupted: " + e.getMessage());
            }
        });
    }

    static {
        successDir = "success/";
        failDir = "fail/";
        threadNum = 8;
        isRemoteLoad = true;
        verify = true;
    }
}

