/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TablePrivilege {
    private String tableName;
    private Set<PrivilegeType> privileges;
    private Set<PrivilegeType> grantOption;

    public TablePrivilege(String tableName) {
        this.tableName = tableName;
        this.privileges = new HashSet<PrivilegeType>();
        this.grantOption = new HashSet<PrivilegeType>();
    }

    public TablePrivilege() {
    }

    public String getTableName() {
        return this.tableName;
    }

    public Set<PrivilegeType> getPrivileges() {
        return this.privileges;
    }

    public Set<PrivilegeType> getGrantOption() {
        return this.grantOption;
    }

    public Set<Integer> getPrivilegesIntSet() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType type : this.privileges) {
            res.add(type.ordinal());
        }
        return res;
    }

    public Set<Integer> getGrantOptionIntSet() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType type : this.grantOption) {
            res.add(type.ordinal());
        }
        return res;
    }

    public void grantPrivilege(PrivilegeType priv) {
        this.privileges.add(priv);
    }

    public void revokePrivilege(PrivilegeType priv) {
        this.privileges.remove((Object)priv);
    }

    public void grantOption(PrivilegeType priv) {
        this.grantOption.add(priv);
    }

    public void revokeGrantOption(PrivilegeType priv) {
        this.grantOption.remove((Object)priv);
    }

    public void setPrivileges(int mask) {
        int PRI_SIZE = PrivilegeType.getPrivilegeCount(PrivilegeModelType.RELATIONAL);
        for (int i = 0; i < PRI_SIZE; ++i) {
            if ((1 << i & mask) == 0) continue;
            this.privileges.add(AuthUtils.posToObjPri(i));
            if ((1 << i + 16 & mask) == 0) continue;
            this.grantOption.add(AuthUtils.posToObjPri(i));
        }
    }

    public int getAllPrivileges() {
        int privilege = 0;
        for (PrivilegeType pri : this.privileges) {
            privilege |= 1 << AuthUtils.objPriToPos(pri);
        }
        for (PrivilegeType pri : this.grantOption) {
            privilege |= 1 << AuthUtils.objPriToPos(pri) + 16;
        }
        return privilege;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TablePrivilege that = (TablePrivilege)o;
        return this.tableName.equals(that.tableName) && this.privileges.equals(that.privileges) && this.grantOption.equals(that.grantOption);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.privileges, this.grantOption);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tableName).append("(");
        ArrayList<PrivilegeType> privs = new ArrayList<PrivilegeType>(this.privileges);
        Collections.sort(privs);
        for (PrivilegeType type : privs) {
            builder.append((Object)type);
            if (this.grantOption.contains((Object)type)) {
                builder.append("_with_grant_option");
            }
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)outputStream);
        SerializeUtils.serializePrivilegeTypeSet(this.privileges, (DataOutputStream)outputStream);
        SerializeUtils.serializePrivilegeTypeSet(this.grantOption, (DataOutputStream)outputStream);
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.privileges = new HashSet<PrivilegeType>();
        this.grantOption = new HashSet<PrivilegeType>();
        this.tableName = SerializeUtils.deserializeString(byteBuffer);
        SerializeUtils.deserializePrivilegeTypeSet(this.privileges, byteBuffer);
        SerializeUtils.deserializePrivilegeTypeSet(this.grantOption, byteBuffer);
    }
}

