/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.marshaller.optimized.OptimizedClassDescriptor;
import org.apache.ignite.internal.marshaller.optimized.OptimizedFieldType;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerIdMapper;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerUtils;
import org.apache.ignite.internal.util.GridHandleTable;
import org.apache.ignite.internal.util.io.GridDataOutput;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.MarshallerContext;

public class OptimizedObjectOutputStream
extends ObjectOutputStream {
    private final GridHandleTable handles = new GridHandleTable(10, 3.0f);
    private final GridDataOutput out;
    private MarshallerContext ctx;
    private OptimizedMarshallerIdMapper mapper;
    private boolean requireSer;
    private Object curObj;
    private OptimizedClassDescriptor.ClassFields curFields;
    private PutFieldImpl curPut;
    private ConcurrentMap<Class, OptimizedClassDescriptor> clsMap;

    OptimizedObjectOutputStream(GridDataOutput out) throws IOException {
        this.out = out;
    }

    void context(ConcurrentMap<Class, OptimizedClassDescriptor> clsMap, MarshallerContext ctx, OptimizedMarshallerIdMapper mapper, boolean requireSer) {
        this.clsMap = clsMap;
        this.ctx = ctx;
        this.mapper = mapper;
        this.requireSer = requireSer;
    }

    boolean requireSerializable() {
        return this.requireSer;
    }

    public GridDataOutput out() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        this.reset();
        this.ctx = null;
        this.clsMap = null;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        Object oldObj = this.curObj;
        OptimizedClassDescriptor.ClassFields oldFields = this.curFields;
        PutFieldImpl oldPut = this.curPut;
        try {
            this.writeObject0(obj);
        }
        finally {
            this.curObj = oldObj;
            this.curFields = oldFields;
            this.curPut = oldPut;
        }
    }

    private void writeObject0(Object obj) throws IOException {
        this.curObj = null;
        this.curFields = null;
        this.curPut = null;
        if (obj == null) {
            this.writeByte(0);
        } else {
            if (obj instanceof Throwable && !(obj instanceof Externalizable) || U.isEnum(obj.getClass())) {
                this.writeByte(-2);
                try {
                    this.ctx.jdkMarshaller().marshal(obj, this);
                }
                catch (IgniteCheckedException e) {
                    IOException ioEx = e.getCause(IOException.class);
                    if (ioEx != null) {
                        throw ioEx;
                    }
                    throw new IOException("Failed to serialize object with JDK marshaller: " + obj, e);
                }
            }
            OptimizedClassDescriptor desc = OptimizedMarshallerUtils.classDescriptor(this.clsMap, obj instanceof Object[] ? Object[].class : obj.getClass(), GridBinaryMarshaller.USE_CACHE.get(), this.ctx, this.mapper);
            if (desc.excluded()) {
                this.writeByte(0);
                return;
            }
            Object obj0 = desc.replace(obj);
            if (obj0 == null) {
                this.writeByte(0);
                return;
            }
            int handle = -1;
            if (!(desc.isPrimitive() || desc.isEnum() || desc.isClass() || desc.isProxy())) {
                handle = this.handles.putIfAbsent(obj);
            }
            if (obj0 != obj) {
                obj = obj0;
                desc = OptimizedMarshallerUtils.classDescriptor(this.clsMap, obj instanceof Object[] ? Object[].class : obj.getClass(), GridBinaryMarshaller.USE_CACHE.get(), this.ctx, this.mapper);
            }
            try {
                if (handle >= 0) {
                    this.writeByte(-1);
                    this.writeInt(handle);
                } else {
                    desc.write(this, obj);
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to serialize object [typeName=" + desc.describedClass().getName() + "]", e);
            }
        }
    }

    void writeArray(Object[] arr) throws IOException {
        int len = arr.length;
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            Object obj = arr[i];
            this.writeObject0(obj);
        }
    }

    void writeUuid(UUID uuid) throws IOException {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    void writeProperties(Properties props, long dfltsFieldOff) throws IOException {
        Properties dflts = (Properties)OptimizedMarshallerUtils.getObject(props, dfltsFieldOff);
        if (dflts == null) {
            this.writeBoolean(true);
        } else {
            this.writeBoolean(false);
            this.writeObject0(dflts);
        }
        Set<String> names = props.stringPropertyNames();
        this.writeInt(names.size());
        for (String name : names) {
            this.writeUTF(name);
            this.writeUTF(props.getProperty(name));
        }
    }

    void writeExternalizable(Object obj) throws IOException {
        Externalizable extObj = (Externalizable)obj;
        extObj.writeExternal(this);
    }

    void writeSerializable(Object obj, List<Method> mtds, OptimizedClassDescriptor.Fields fields) throws IOException {
        for (int i = 0; i < mtds.size(); ++i) {
            Method mtd = mtds.get(i);
            if (mtd != null) {
                this.curObj = obj;
                this.curFields = fields.fields(i);
                try {
                    mtd.invoke(obj, this);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IOException(e.getCause());
                }
            }
            this.writeFields(obj, fields.fields(i));
        }
    }

    void writeArrayList(ArrayList<?> list) throws IOException {
        int size = list.size();
        this.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.writeObject0(list.get(i));
        }
    }

    void writeHashMap(HashMap<?, ?> map, long loadFactorFieldOff, boolean set) throws IOException {
        int size = map.size();
        this.writeInt(size);
        this.writeFloat(OptimizedMarshallerUtils.getFloat(map, loadFactorFieldOff));
        for (Map.Entry<?, ?> e : map.entrySet()) {
            this.writeObject0(e.getKey());
            if (set) continue;
            this.writeObject0(e.getValue());
        }
    }

    void writeHashSet(HashSet<?> set, long mapFieldOff, long loadFactorFieldOff) throws IOException {
        this.writeHashMap((HashMap)OptimizedMarshallerUtils.getObject(set, mapFieldOff), loadFactorFieldOff, true);
    }

    void writeLinkedList(LinkedList<?> list) throws IOException {
        int size = list.size();
        this.writeInt(size);
        for (Object obj : list) {
            this.writeObject0(obj);
        }
    }

    void writeLinkedHashMap(LinkedHashMap<?, ?> map, long loadFactorFieldOff, long accessOrderFieldOff, boolean set) throws IOException {
        int size = map.size();
        this.writeInt(size);
        this.writeFloat(OptimizedMarshallerUtils.getFloat(map, loadFactorFieldOff));
        if (accessOrderFieldOff >= 0L) {
            this.writeBoolean(OptimizedMarshallerUtils.getBoolean(map, accessOrderFieldOff));
        } else {
            this.writeBoolean(false);
        }
        for (Map.Entry<?, ?> e : map.entrySet()) {
            this.writeObject0(e.getKey());
            if (set) continue;
            this.writeObject0(e.getValue());
        }
    }

    void writeLinkedHashSet(LinkedHashSet<?> set, long mapFieldOff, long loadFactorFieldOff) throws IOException {
        LinkedHashMap map = (LinkedHashMap)OptimizedMarshallerUtils.getObject(set, mapFieldOff);
        this.writeLinkedHashMap(map, loadFactorFieldOff, -1L, true);
    }

    void writeDate(Date date) throws IOException {
        this.writeLong(date.getTime());
    }

    private void writeFields(Object obj, OptimizedClassDescriptor.ClassFields fields) throws IOException {
        for (int i = 0; i < fields.size(); ++i) {
            OptimizedClassDescriptor.FieldInfo t = fields.get(i);
            try {
                switch (t.type()) {
                    case BYTE: {
                        if (t.field() == null) break;
                        this.writeByte(OptimizedMarshallerUtils.getByte(obj, t.offset()));
                        break;
                    }
                    case SHORT: {
                        if (t.field() == null) break;
                        this.writeShort(OptimizedMarshallerUtils.getShort(obj, t.offset()));
                        break;
                    }
                    case INT: {
                        if (t.field() == null) break;
                        this.writeInt(OptimizedMarshallerUtils.getInt(obj, t.offset()));
                        break;
                    }
                    case LONG: {
                        if (t.field() == null) break;
                        this.writeLong(OptimizedMarshallerUtils.getLong(obj, t.offset()));
                        break;
                    }
                    case FLOAT: {
                        if (t.field() == null) break;
                        this.writeFloat(OptimizedMarshallerUtils.getFloat(obj, t.offset()));
                        break;
                    }
                    case DOUBLE: {
                        if (t.field() == null) break;
                        this.writeDouble(OptimizedMarshallerUtils.getDouble(obj, t.offset()));
                        break;
                    }
                    case CHAR: {
                        if (t.field() == null) break;
                        this.writeChar(OptimizedMarshallerUtils.getChar(obj, t.offset()));
                        break;
                    }
                    case BOOLEAN: {
                        if (t.field() == null) break;
                        this.writeBoolean(OptimizedMarshallerUtils.getBoolean(obj, t.offset()));
                        break;
                    }
                    case OTHER: {
                        if (t.field() == null) break;
                        this.writeObject0(OptimizedMarshallerUtils.getObject(obj, t.offset()));
                    }
                }
                continue;
            }
            catch (IOException e) {
                throw new IOException("Failed to serialize field [name=" + t.name() + "]", e);
            }
        }
    }

    void writeByteArray(byte[] arr) throws IOException {
        this.out.writeByteArray(arr);
    }

    void writeShortArray(short[] arr) throws IOException {
        this.out.writeShortArray(arr);
    }

    void writeIntArray(int[] arr) throws IOException {
        this.out.writeIntArray(arr);
    }

    void writeLongArray(long[] arr) throws IOException {
        this.out.writeLongArray(arr);
    }

    void writeFloatArray(float[] arr) throws IOException {
        this.out.writeFloatArray(arr);
    }

    void writeDoubleArray(double[] arr) throws IOException {
        this.out.writeDoubleArray(arr);
    }

    void writeCharArray(char[] arr) throws IOException {
        this.out.writeCharArray(arr);
    }

    void writeBooleanArray(boolean[] arr) throws IOException {
        this.out.writeBooleanArray(arr);
    }

    void writeString(String str) throws IOException {
        this.out.writeUTF(str);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }

    @Override
    public void useProtocolVersion(int ver) throws IOException {
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.writeObject0(obj);
    }

    @Override
    public void defaultWriteObject() throws IOException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in writeObject() call.");
        }
        this.writeFields(this.curObj, this.curFields);
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in writeObject() call or fields already written.");
        }
        if (this.curPut == null) {
            this.curPut = new PutFieldImpl(this);
        }
        return this.curPut;
    }

    @Override
    public void writeFields() throws IOException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in writeObject() call.");
        }
        if (this.curPut == null) {
            throw new NotActiveException("putFields() was not called.");
        }
        block11: for (IgniteBiTuple<OptimizedFieldType, Object> t : this.curPut.objs) {
            switch (t.get1()) {
                case BYTE: {
                    this.writeByte(((Byte)t.get2()).byteValue());
                    continue block11;
                }
                case SHORT: {
                    this.writeShort(((Short)t.get2()).shortValue());
                    continue block11;
                }
                case INT: {
                    this.writeInt((Integer)t.get2());
                    continue block11;
                }
                case LONG: {
                    this.writeLong((Long)t.get2());
                    continue block11;
                }
                case FLOAT: {
                    this.writeFloat(((Float)t.get2()).floatValue());
                    continue block11;
                }
                case DOUBLE: {
                    this.writeDouble((Double)t.get2());
                    continue block11;
                }
                case CHAR: {
                    this.writeChar(((Character)t.get2()).charValue());
                    continue block11;
                }
                case BOOLEAN: {
                    this.writeBoolean((Boolean)t.get2());
                    continue block11;
                }
                case OTHER: {
                    this.writeObject0(t.get2());
                }
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.out.reset();
        this.handles.clear();
        this.curObj = null;
        this.curFields = null;
        this.curPut = null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void drain() throws IOException {
    }

    Object[] handledObjects() {
        return this.handles.objects();
    }

    private static class PutFieldImpl
    extends ObjectOutputStream.PutField {
        private final OptimizedObjectOutputStream out;
        private final OptimizedClassDescriptor.ClassFields curFields;
        private final IgniteBiTuple<OptimizedFieldType, Object>[] objs;

        private PutFieldImpl(OptimizedObjectOutputStream out) {
            this.out = out;
            this.curFields = out.curFields;
            this.objs = new IgniteBiTuple[this.curFields.size()];
        }

        @Override
        public void put(String name, boolean val) {
            this.value(name, val);
        }

        @Override
        public void put(String name, byte val) {
            this.value(name, val);
        }

        @Override
        public void put(String name, char val) {
            this.value(name, Character.valueOf(val));
        }

        @Override
        public void put(String name, short val) {
            this.value(name, val);
        }

        @Override
        public void put(String name, int val) {
            this.value(name, val);
        }

        @Override
        public void put(String name, long val) {
            this.value(name, val);
        }

        @Override
        public void put(String name, float val) {
            this.value(name, Float.valueOf(val));
        }

        @Override
        public void put(String name, double val) {
            this.value(name, val);
        }

        @Override
        public void put(String name, Object val) {
            this.value(name, val);
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            if (out != this.out) {
                throw new IllegalArgumentException("Wrong stream.");
            }
            this.out.writeFields();
        }

        private void value(String name, Object val) {
            int i = this.curFields.getIndex(name);
            OptimizedClassDescriptor.FieldInfo info = this.curFields.get(i);
            this.objs[i] = F.t(info.type(), val);
        }
    }
}

