/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.storage.file.assit;

import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.assit.Checkpoint;
import org.apache.ignite3.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite3.raft.jraft.util.Bits;

public class FlushStatusCheckpoint
extends Checkpoint {
    public String fileName;
    public long flushPosition;
    public long lastLogIndex;

    public FlushStatusCheckpoint(String path, RaftOptions raftOptions) {
        super(path, raftOptions);
    }

    @Override
    public byte[] encode() {
        byte[] ps = AsciiStringUtil.unsafeEncode(this.fileName);
        byte[] bs = new byte[20 + ps.length];
        Bits.putLong(bs, 0, this.flushPosition);
        Bits.putLong(bs, 8, this.lastLogIndex);
        Bits.putInt(bs, 16, ps.length);
        System.arraycopy(ps, 0, bs, 20, ps.length);
        return bs;
    }

    @Override
    public boolean decode(byte[] bs) {
        if (bs.length < 20) {
            return false;
        }
        this.flushPosition = Bits.getLong(bs, 0);
        this.lastLogIndex = Bits.getLong(bs, 8);
        int len = Bits.getInt(bs, 16);
        this.fileName = AsciiStringUtil.unsafeDecode(bs, 20, len);
        return this.flushPosition >= 0L && this.lastLogIndex >= 0L && !this.fileName.isEmpty();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFlushPosition(long flushPosition) {
        this.flushPosition = flushPosition;
    }

    public void setLastLogIndex(long lastLogIndex) {
        this.lastLogIndex = lastLogIndex;
    }

    public String toString() {
        return "FlushStatusCheckpoint{segFilename='" + this.fileName + "', flushPosition=" + this.flushPosition + ", lastLogIndex=" + this.lastLogIndex + "}";
    }
}

