/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.partition.replicator.schema.ColumnDefinitionDiff;
import org.apache.ignite3.internal.partition.replicator.schema.TableDefinitionDiff;
import org.apache.ignite3.internal.util.CollectionUtils;

public class FullTableSchema {
    private final int schemaVersion;
    private final int tableId;
    private final String tableName;
    private final List<CatalogTableColumnDescriptor> columns;

    public FullTableSchema(int schemaVersion, int tableId, String tableName, List<CatalogTableColumnDescriptor> columns) {
        this.schemaVersion = schemaVersion;
        this.tableId = tableId;
        this.tableName = tableName;
        this.columns = List.copyOf(columns);
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public int tableId() {
        return this.tableId;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<CatalogTableColumnDescriptor> columns() {
        return this.columns;
    }

    public TableDefinitionDiff diffFrom(FullTableSchema prevSchema) {
        Map<String, CatalogTableColumnDescriptor> prevColumnsByName = FullTableSchema.toMapByName(prevSchema.columns, CatalogTableColumnDescriptor::name);
        Map<String, CatalogTableColumnDescriptor> thisColumnsByName = FullTableSchema.toMapByName(this.columns, CatalogTableColumnDescriptor::name);
        List<CatalogTableColumnDescriptor> addedColumns = FullTableSchema.subtractKeyed(thisColumnsByName, prevColumnsByName);
        List<CatalogTableColumnDescriptor> removedColumns = FullTableSchema.subtractKeyed(prevColumnsByName, thisColumnsByName);
        Set<String> intersectionColumnNames = CollectionUtils.intersect(thisColumnsByName.keySet(), prevColumnsByName.keySet());
        ArrayList<ColumnDefinitionDiff> changedColumns = new ArrayList<ColumnDefinitionDiff>();
        for (String commonColumnName : intersectionColumnNames) {
            CatalogTableColumnDescriptor thisColumn;
            CatalogTableColumnDescriptor prevColumn = prevColumnsByName.get(commonColumnName);
            if (!FullTableSchema.columnChanged(prevColumn, thisColumn = thisColumnsByName.get(commonColumnName))) continue;
            changedColumns.add(new ColumnDefinitionDiff(prevColumn, thisColumn));
        }
        return new TableDefinitionDiff(prevSchema.schemaVersion(), this.schemaVersion, prevSchema.tableName(), this.tableName(), addedColumns, removedColumns, changedColumns);
    }

    private static <T> Map<String, T> toMapByName(List<T> elements, Function<T, String> nameExtractor) {
        return elements.stream().collect(Collectors.toMap(nameExtractor, Function.identity()));
    }

    private static <T> List<T> subtractKeyed(Map<String, T> minuend, Map<String, T> subtrahend) {
        return minuend.entrySet().stream().filter(entry -> !subtrahend.containsKey(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static boolean columnChanged(CatalogTableColumnDescriptor prevColumn, CatalogTableColumnDescriptor newColumn) {
        return !prevColumn.equals(newColumn);
    }
}

