/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.storage.DropZoneEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class DropZoneCommand
extends AbstractZoneCommand {
    private final boolean ifExists;

    public static DropZoneCommandBuilder builder() {
        return new Builder();
    }

    private DropZoneCommand(String zoneName, boolean ifExists) throws CatalogValidationException {
        super(zoneName);
        this.ifExists = ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogZoneDescriptor zone = CatalogUtils.zone(catalog, this.zoneName, !this.ifExists);
        if (zone == null) {
            return List.of();
        }
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        if (defaultZone != null && zone.id() == defaultZone.id()) {
            throw new CatalogValidationException("Default distribution zone can't be dropped: zoneName={}.", this.zoneName);
        }
        catalog.schemas().stream().flatMap(s -> Arrays.stream(s.tables())).filter(t -> t.zoneId() == zone.id()).findAny().ifPresent(t -> {
            throw new CatalogValidationException("Distribution zone '{}' is assigned to the table '{}'.", zone.name(), t.name());
        });
        return List.of(new DropZoneEntry(zone.id()));
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    private static class Builder
    implements DropZoneCommandBuilder {
        private String zoneName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public DropZoneCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropZoneCommand(this.zoneName, this.ifExists);
        }
    }
}

