/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.ChunkedOutputStream;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.impl.io.TimeoutByteArrayInputStream;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestChunkCoding {
    private static final String CHUNKED_INPUT = "10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\nFooter2: fghij\r\n";
    private static final String CHUNKED_RESULT = "123456789012345612345";

    TestChunkCoding() {
    }

    @Test
    void testChunkedInputStreamLargeBuffer() throws IOException {
        int len;
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(CHUNKED_INPUT.getBytes(StandardCharsets.US_ASCII));
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        byte[] buffer = new byte[300];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        Assertions.assertEquals((int)-1, (int)in.read(buffer));
        Assertions.assertEquals((int)-1, (int)in.read(buffer));
        in.close();
        String result = new String(out.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)CHUNKED_RESULT, (Object)result);
        Header[] footers = in.getFooters();
        Assertions.assertNotNull((Object)footers);
        Assertions.assertEquals((int)2, (int)footers.length);
        Assertions.assertEquals((Object)"Footer1", (Object)footers[0].getName());
        Assertions.assertEquals((Object)"abcde", (Object)footers[0].getValue());
        Assertions.assertEquals((Object)"Footer2", (Object)footers[1].getName());
        Assertions.assertEquals((Object)"fghij", (Object)footers[1].getValue());
    }

    @Test
    void testChunkedInputStreamSmallBuffer() throws IOException {
        int len;
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(CHUNKED_INPUT.getBytes(StandardCharsets.US_ASCII));
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        byte[] buffer = new byte[7];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        Assertions.assertEquals((int)-1, (int)in.read(buffer));
        Assertions.assertEquals((int)-1, (int)in.read(buffer));
        in.close();
        Header[] footers = in.getFooters();
        Assertions.assertNotNull((Object)footers);
        Assertions.assertEquals((int)2, (int)footers.length);
        Assertions.assertEquals((Object)"Footer1", (Object)footers[0].getName());
        Assertions.assertEquals((Object)"abcde", (Object)footers[0].getValue());
        Assertions.assertEquals((Object)"Footer2", (Object)footers[1].getName());
        Assertions.assertEquals((Object)"fghij", (Object)footers[1].getValue());
    }

    @Test
    void testChunkedInputStreamOneByteRead() throws IOException {
        String s = "5\r\n01234\r\n5\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r\n01234\r\n5\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            int ch;
            int i = 48;
            while ((ch = in.read()) != -1) {
                Assertions.assertEquals((int)i, (int)ch);
                ++i;
            }
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    void testAvailable() throws IOException {
        String s = "5\r\n12345\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r\n12345\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            Assertions.assertEquals((int)0, (int)in.available());
            in.read();
            Assertions.assertEquals((int)4, (int)in.available());
        }
    }

    @Test
    void testChunkedInputStreamClose() throws IOException {
        String s = "5\r\n01234\r\n5\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r\n01234\r\n5\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        in.close();
        in.close();
        Assertions.assertThrows(StreamClosedException.class, () -> in.read());
        byte[] tmp = new byte[10];
        Assertions.assertThrows(StreamClosedException.class, () -> in.read(tmp));
        Assertions.assertThrows(StreamClosedException.class, () -> in.read(tmp, 0, tmp.length));
    }

    @Test
    void testChunkedInputStreamNoClosingChunk() throws IOException {
        String s = "5\r\n01234\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r\n01234\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] tmp = new byte[5];
            Assertions.assertEquals((int)5, (int)in.read(tmp));
            Assertions.assertThrows(ConnectionClosedException.class, () -> in.read());
            Assertions.assertThrows(ConnectionClosedException.class, () -> in.close());
        }
    }

    @Test
    void testCorruptChunkedInputStreamTruncatedCRLF() throws IOException {
        String s = "5\r\n01234";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r\n01234".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] tmp = new byte[5];
            Assertions.assertEquals((int)5, (int)in.read(tmp));
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> in.read());
        }
    }

    @Test
    void testCorruptChunkedInputStreamMissingCRLF() throws IOException {
        String s = "5\r\n012345\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r\n012345\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] buffer = new byte[300];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> {
                int len;
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            });
        }
    }

    @Test
    void testCorruptChunkedInputStreamMissingLF() throws IOException {
        String s = "5\r01234\r\n5\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("5\r01234\r\n5\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> ((ChunkedInputStream)in).read());
        }
    }

    @Test
    void testCorruptChunkedInputStreamInvalidSize() throws IOException {
        String s = "whatever\r\n01234\r\n5\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("whatever\r\n01234\r\n5\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> ((ChunkedInputStream)in).read());
        }
    }

    @Test
    void testCorruptChunkedInputStreamNegativeSize() throws IOException {
        String s = "-5\r\n01234\r\n5\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("-5\r\n01234\r\n5\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> ((ChunkedInputStream)in).read());
        }
    }

    @Test
    void testCorruptChunkedInputStreamTruncatedChunk() throws IOException {
        String s = "3\r\n12";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("3\r\n12".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] buffer = new byte[300];
            Assertions.assertEquals((int)2, (int)in.read(buffer));
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> in.read(buffer));
        }
    }

    @Test
    void testCorruptChunkedInputStreamInvalidFooter() throws IOException {
        String s = "1\r\n0\r\n0\r\nstuff\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("1\r\n0\r\n0\r\nstuff\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            in.read();
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> ((ChunkedInputStream)in).read());
        }
    }

    @Test
    void testCorruptChunkedInputStreamClose() throws IOException {
        String s = "whatever\r\n01234\r\n5\r\n56789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("whatever\r\n01234\r\n5\r\n56789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            Assertions.assertThrows(MalformedChunkCodingException.class, () -> ((ChunkedInputStream)in).read());
        }
    }

    @Test
    void testEmptyChunkedInputStream() throws IOException {
        String s = "0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            int len;
            byte[] buffer = new byte[300];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            Assertions.assertEquals((int)0, (int)out.size());
        }
    }

    @Test
    void testTooLongChunkHeader() throws IOException {
        String s = "5; and some very looooong commend\r\n12345\r\n0\r\n";
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(16);
        byte[] buffer = new byte[300];
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream("5; and some very looooong commend\r\n12345\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        try (ChunkedInputStream in1 = new ChunkedInputStream((SessionInputBuffer)inBuffer1, (InputStream)inputStream1);){
            Assertions.assertEquals((int)5, (int)in1.read(buffer));
        }
        SessionInputBufferImpl inBuffer2 = new SessionInputBufferImpl(16, 10);
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream("5; and some very looooong commend\r\n12345\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
        ChunkedInputStream in2 = new ChunkedInputStream((SessionInputBuffer)inBuffer2, (InputStream)inputStream2);
        Assertions.assertThrows(MessageConstraintException.class, () -> in2.read(buffer));
    }

    @Test
    void testChunkedOutputStreamClose() throws IOException {
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ChunkedOutputStream out = new ChunkedOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 2048);
        out.close();
        out.close();
        Assertions.assertThrows(IOException.class, () -> out.write(new byte[]{1, 2, 3}));
        Assertions.assertThrows(IOException.class, () -> out.write(1));
    }

    @Test
    void testChunkedConsistence() throws IOException {
        String input = "76126;27823abcd;:q38a-\nkjc\rk%1ad\tkh/asdui\r\njkh+?\\suweb";
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ChunkedOutputStream out = new ChunkedOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 2048);){
            out.write("76126;27823abcd;:q38a-\nkjc\rk%1ad\tkh/asdui\r\njkh+?\\suweb".getBytes(StandardCharsets.US_ASCII));
            out.flush();
            out.close();
        }
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try (ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] d = new byte[10];
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            int len = 0;
            while ((len = in.read(d)) > 0) {
                result.write(d, 0, len);
            }
            String output = new String(result.toByteArray(), StandardCharsets.US_ASCII);
            Assertions.assertEquals((Object)"76126;27823abcd;:q38a-\nkjc\rk%1ad\tkh/asdui\r\njkh+?\\suweb", (Object)output);
        }
    }

    @Test
    void testChunkedOutputStreamWithTrailers() throws IOException {
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ChunkedOutputStream out = new ChunkedOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 2, () -> Arrays.asList(new BasicHeader("E", (Object)""), new BasicHeader("Y", (Object)"Z")));){
            out.write(120);
            out.finish();
        }
        String content = new String(outputStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"1\r\nx\r\n0\r\nE: \r\nY: Z\r\n\r\n", (Object)content);
    }

    @Test
    void testChunkedOutputStream() throws IOException {
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ChunkedOutputStream out = new ChunkedOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 2);){
            out.write(49);
            out.write(50);
            out.write(51);
            out.write(52);
            out.finish();
        }
        String content = new String(outputStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"2\r\n12\r\n2\r\n34\r\n0\r\n\r\n", (Object)content);
    }

    @Test
    void testChunkedOutputStreamLargeChunk() throws IOException {
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ChunkedOutputStream out = new ChunkedOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 2);){
            out.write(new byte[]{49, 50, 51, 52});
            out.finish();
        }
        String content = new String(outputStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"4\r\n1234\r\n0\r\n\r\n", (Object)content);
    }

    @Test
    void testChunkedOutputStreamSmallChunk() throws IOException {
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ChunkedOutputStream out = new ChunkedOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 2);){
            out.write(49);
            out.finish();
        }
        String content = new String(outputStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"1\r\n1\r\n0\r\n\r\n", (Object)content);
    }

    @Test
    void testResumeOnSocketTimeoutInData() throws IOException {
        String s = "5\r\n01234\r\n5\r\n5\u00006789\r\na\r\n0123\u0000456789\r\n0\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        try (TimeoutByteArrayInputStream inputStream = new TimeoutByteArrayInputStream("5\r\n01234\r\n5\r\n5\u00006789\r\na\r\n0123\u0000456789\r\n0\r\n".getBytes(StandardCharsets.US_ASCII));
             ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] tmp = new byte[3];
            int bytesRead = 0;
            int timeouts = 0;
            int i = 0;
            while (i != -1) {
                try {
                    i = in.read(tmp);
                    if (i <= 0) continue;
                    bytesRead += i;
                }
                catch (InterruptedIOException ex) {
                    ++timeouts;
                }
            }
            Assertions.assertEquals((int)20, (int)bytesRead);
            Assertions.assertEquals((int)2, (int)timeouts);
        }
    }

    @Test
    void testResumeOnSocketTimeoutInChunk() throws IOException {
        String s = "5\u0000\r\u0000\n\u000001234\r\n\u00005\r\n56789\r\na\r\n0123456789\r\n\u00000\r\n";
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        try (TimeoutByteArrayInputStream inputStream = new TimeoutByteArrayInputStream("5\u0000\r\u0000\n\u000001234\r\n\u00005\r\n56789\r\na\r\n0123456789\r\n\u00000\r\n".getBytes(StandardCharsets.US_ASCII));
             ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);){
            byte[] tmp = new byte[3];
            int bytesRead = 0;
            int timeouts = 0;
            int i = 0;
            while (i != -1) {
                try {
                    i = in.read(tmp);
                    if (i <= 0) continue;
                    bytesRead += i;
                }
                catch (InterruptedIOException ex) {
                    ++timeouts;
                }
            }
            Assertions.assertEquals((int)20, (int)bytesRead);
            Assertions.assertEquals((int)5, (int)timeouts);
        }
    }

    @Test
    void testHugeChunk() throws IOException {
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("1234567890abcdef\r\n01234567".getBytes(StandardCharsets.US_ASCII));
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < 8; ++i) {
            out.write(in.read());
        }
        String result = new String(out.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"01234567", (Object)result);
    }
}

