/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.QuantilesDoublesUnionBuilder;
import org.apache.datasketches.quantiles.QuantilesDoublesUnionImpl;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesUnionImplTest {
    @Test
    public void checkUnion1() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build();
        UpdatableQuantilesDoublesSketch qs0 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 500);
        union.union((QuantilesDoublesSketch)qs0);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)500L);
        Assert.assertEquals((int)result.getK(), (int)256);
        union.reset();
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000);
        union.union((QuantilesDoublesSketch)qs1);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)1000L);
        Assert.assertEquals((int)result.getK(), (int)256);
        UpdatableQuantilesDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000, 1000);
        union.union((QuantilesDoublesSketch)qs2);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)2000L);
        Assert.assertEquals((int)result.getK(), (int)256);
    }

    @Test
    public void checkUnion1Direct() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build();
        UpdatableQuantilesDoublesSketch qs0 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 500);
        union.union((QuantilesDoublesSketch)qs0);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)500L);
        Assert.assertEquals((int)result.getK(), (int)256);
        union.reset();
        UpdatableQuantilesDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        union.union((QuantilesDoublesSketch)qs1);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)1000L);
        Assert.assertEquals((int)result.getK(), (int)256);
        CompactQuantilesDoublesSketch qs2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000L, 1000).compact();
        union.union((QuantilesDoublesSketch)qs2);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)2000L);
        Assert.assertEquals((int)result.getK(), (int)256);
    }

    @Test
    public void checkUnion2() {
        CompactQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000).compact();
        UpdatableQuantilesDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build();
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        union.union((QuantilesDoublesSketch)qs1);
        UpdatableQuantilesDoublesSketch res1 = union.getResult();
        Assert.assertEquals((long)res1.getN(), (long)1000L);
        Assert.assertEquals((int)res1.getK(), (int)256);
        union.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch res2 = union.getResult();
        Assert.assertEquals((long)res2.getN(), (long)2000L);
        Assert.assertEquals((int)res2.getK(), (int)128);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        DoublesUnionImplTest.println(union.toString());
    }

    @Test
    public void checkUnion2Direct() {
        UpdatableQuantilesDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        UpdatableQuantilesDoublesSketch qs2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 1000);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build();
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        union.union((QuantilesDoublesSketch)qs1);
        UpdatableQuantilesDoublesSketch res1 = union.getResult();
        Assert.assertEquals((long)res1.getN(), (long)1000L);
        Assert.assertEquals((int)res1.getK(), (int)256);
        union.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch res2 = union.getResult();
        Assert.assertEquals((long)res2.getN(), (long)2000L);
        Assert.assertEquals((int)res2.getK(), (int)128);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        DoublesUnionImplTest.println(union.toString());
    }

    @Test
    public void checkUnion3() {
        int k1 = 128;
        int n1 = 256;
        int k2 = 256;
        int n2 = 2000;
        UpdatableQuantilesDoublesSketch sketchIn1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 256);
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)2000L);
        MemorySegment seg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build(seg, null);
        union.union((QuantilesDoublesSketch)sketchIn1);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)256.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkUnion3Direct() {
        int k1 = 128;
        int n1 = 256;
        int k2 = 256;
        int n2 = 2000;
        UpdatableQuantilesDoublesSketch sketchIn1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 256);
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)2000L);
        MemorySegment seg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build(seg, null);
        union.union((QuantilesDoublesSketch)sketchIn1);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)256.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkUnion4() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 4;
        int n2 = 8;
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        MemorySegment skSeg = MemorySegment.ofArray(new byte[bytes]);
        UpdatableQuantilesDoublesSketch sketchIn1 = QuantilesDoublesSketch.builder().setK(8).build(skSeg);
        for (int i = 0; i < 16; ++i) {
            sketchIn1.update((double)(i + 1));
        }
        MemorySegment uSeg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build(uSeg, null);
        union.union((QuantilesDoublesSketch)sketchIn1);
        Assert.assertEquals((long)union.getResult().getN(), (long)16L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)8);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)16L);
        Assert.assertEquals((double)result.getMaxItem(), (double)16.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)8);
        UpdatableQuantilesDoublesSketch sketchIn2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(4, 8, 17);
        union.reset();
        union.union((QuantilesDoublesSketch)sketchIn2);
        result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)25.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)18.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion4Direct() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 4;
        int n2 = 8;
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        MemorySegment skSeg = MemorySegment.ofArray(new byte[bytes]);
        UpdatableQuantilesDoublesSketch sketchIn1 = QuantilesDoublesSketch.builder().setK(8).build(skSeg);
        for (int i = 0; i < 16; ++i) {
            sketchIn1.update((double)(i + 1));
        }
        MemorySegment uSeg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build(uSeg, null);
        union.union((QuantilesDoublesSketch)sketchIn1);
        Assert.assertEquals((long)union.getResult().getN(), (long)16L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)8);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)16L);
        Assert.assertEquals((double)result.getMaxItem(), (double)16.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)8);
        UpdatableQuantilesDoublesSketch sketchIn2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(4, 8L, 17);
        union.reset();
        union.union((QuantilesDoublesSketch)sketchIn2);
        result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)25.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)18.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion4DirectCompact() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 4;
        int n2 = 20;
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        MemorySegment skSeg = MemorySegment.ofArray(new byte[bytes]);
        UpdatableQuantilesDoublesSketch sketchIn0 = QuantilesDoublesSketch.builder().setK(8).build(skSeg);
        for (int i = 0; i < 16; ++i) {
            sketchIn0.update((double)(i + 1));
        }
        CompactQuantilesDoublesSketch sketchIn1 = sketchIn0.compact();
        MemorySegment uSeg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build(uSeg, null);
        union.union((QuantilesDoublesSketch)sketchIn1);
        Assert.assertEquals((long)union.getResult().getN(), (long)16L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)8);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)16L);
        Assert.assertEquals((double)result.getMaxItem(), (double)16.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)8);
        CompactQuantilesDoublesSketch sketchIn2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(4, 20L, 17).compact();
        union.reset();
        union.union((QuantilesDoublesSketch)sketchIn2);
        result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)37.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)18.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion5() {
        int k2 = 4;
        int n2 = 8;
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        MemorySegment skSeg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesSketch.builder().setK(256).build(skSeg);
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapifyInstance((MemorySegment)skSeg);
        Assert.assertEquals((long)union.getResult().getN(), (long)0L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)256);
        UpdatableQuantilesDoublesSketch sketchIn2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(4, 8, 17);
        union.union((QuantilesDoublesSketch)sketchIn2);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
        Assert.assertEquals((long)union.getResult().getN(), (long)8L);
    }

    @Test
    public void checkUnion5Direct() {
        int k2 = 4;
        int n2 = 8;
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        MemorySegment skSeg = MemorySegment.ofArray(new byte[bytes]);
        QuantilesDoublesSketch.builder().setK(256).build(skSeg);
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapifyInstance((MemorySegment)skSeg);
        Assert.assertEquals((long)union.getResult().getN(), (long)0L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)256);
        UpdatableQuantilesDoublesSketch sketchIn2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(4, 8L, 17);
        union.union((QuantilesDoublesSketch)sketchIn2);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
        Assert.assertEquals((long)union.getResult().getN(), (long)8L);
    }

    @Test
    public void checkUnion6() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 16;
        int n2 = 32;
        UpdatableQuantilesDoublesSketch sk1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(8, 16, 0);
        UpdatableQuantilesDoublesSketch sk2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(16, 32, 16);
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapifyInstance((QuantilesDoublesSketch)sk1);
        union.union((QuantilesDoublesSketch)sk2);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)48.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion6Direct() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 16;
        int n2 = 32;
        UpdatableQuantilesDoublesSketch sk1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(8, 16L, 0);
        UpdatableQuantilesDoublesSketch sk2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(16, 32L, 16);
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapifyInstance((QuantilesDoublesSketch)sk1);
        union.union((QuantilesDoublesSketch)sk2);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)48.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion7() {
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapInstance((int)16);
        UpdatableQuantilesDoublesSketch skEst = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 64);
        union.union((QuantilesDoublesSketch)skEst);
        DoublesUnionImplTest.println(skEst.toString(true, true));
        DoublesUnionImplTest.println(union.toString(true, true));
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)64.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkUnionQuantiles() {
        int k = 128;
        int n1 = 1664;
        int n2 = 1088;
        int n = 2752;
        double errorTolerance = 48.160000000000004;
        UpdatableQuantilesDoublesSketch sketch1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1664);
        CompactQuantilesDoublesSketch sketch2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1088, 1664).compact();
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(256).build();
        union.union((QuantilesDoublesSketch)sketch2);
        union.union((QuantilesDoublesSketch)sketch1);
        MemorySegment seg = MemorySegment.ofArray(union.getResult().toByteArray(true));
        QuantilesDoublesSketch result = QuantilesDoublesSketch.wrap((MemorySegment)seg);
        Assert.assertEquals((long)result.getN(), (long)2752L);
        Assert.assertEquals((int)result.getK(), (int)128);
        for (double fraction = 0.05; fraction < 1.0; fraction += 0.05) {
            Assert.assertEquals((double)result.getQuantile(fraction), (double)(fraction * 2752.0), (double)48.160000000000004);
        }
    }

    @Test
    public void checkUnion7Direct() {
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapInstance((int)16);
        UpdatableQuantilesDoublesSketch skEst = DirectUpdateDoublesSketchTest.buildAndLoadDQS(32, 64);
        union.union((QuantilesDoublesSketch)skEst);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)64.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkUpdateMemory() {
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000);
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[bytes]);
        qs1.putIntoMemorySegment(dstSeg);
        MemorySegment srcSeg = dstSeg;
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        union.union(srcSeg);
        for (int i = 1000; i < 2000; ++i) {
            union.update((double)i);
        }
        UpdatableQuantilesDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((double)qs2.getMaxItem(), (double)1999.0, (double)0.0);
        String s = union.toString();
        DoublesUnionImplTest.println(s);
        union.reset();
    }

    @Test
    public void checkUpdateMemoryDirect() {
        UpdatableQuantilesDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[bytes]);
        qs1.putIntoMemorySegment(dstSeg);
        MemorySegment srcSeg = dstSeg;
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        union.union(srcSeg);
        for (int i = 1000; i < 2000; ++i) {
            union.update((double)i);
        }
        UpdatableQuantilesDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((double)qs2.getMaxItem(), (double)1999.0, (double)0.0);
        String s = union.toString();
        DoublesUnionImplTest.println(s);
        union.reset();
    }

    @Test
    public void checkUnionUpdateLogic() {
        QuantilesDoublesSketch qs1 = null;
        HeapUpdateDoublesSketch qs2 = (HeapUpdateDoublesSketch)HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 0);
        QuantilesDoublesUnionImpl.updateLogic((int)256, qs1, (QuantilesDoublesSketch)qs2);
        QuantilesDoublesUnionImpl.updateLogic((int)256, (UpdatableQuantilesDoublesSketch)qs2, qs1);
        qs2.update(1.0);
        UpdatableQuantilesDoublesSketch result = QuantilesDoublesUnionImpl.updateLogic((int)256, (UpdatableQuantilesDoublesSketch)qs2, qs1);
        Assert.assertEquals((double)result.getMaxItem(), (double)result.getMinItem(), (double)0.0);
    }

    @Test
    public void checkUnionUpdateLogicDirect() {
        QuantilesDoublesSketch qs1 = null;
        DirectUpdateDoublesSketch qs2 = (DirectUpdateDoublesSketch)DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 0);
        QuantilesDoublesUnionImpl.updateLogic((int)256, qs1, (QuantilesDoublesSketch)qs2);
        QuantilesDoublesUnionImpl.updateLogic((int)256, (UpdatableQuantilesDoublesSketch)qs2, qs1);
        qs2.update(1.0);
        UpdatableQuantilesDoublesSketch result = QuantilesDoublesUnionImpl.updateLogic((int)256, (UpdatableQuantilesDoublesSketch)qs2, qs1);
        Assert.assertEquals((double)result.getMaxItem(), (double)result.getMinItem(), (double)0.0);
    }

    @Test
    public void checkUnionUpdateLogicDirectDownsampled() {
        DirectUpdateDoublesSketch qs1 = (DirectUpdateDoublesSketch)DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        DirectUpdateDoublesSketch qs2 = (DirectUpdateDoublesSketch)DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 2000);
        UpdatableQuantilesDoublesSketch result = QuantilesDoublesUnionImpl.updateLogic((int)128, (UpdatableQuantilesDoublesSketch)qs1, (QuantilesDoublesSketch)qs2);
        Assert.assertEquals((double)result.getMaxItem(), (double)2000.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
        Assert.assertEquals((long)result.getN(), (long)3000L);
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkUnionUpdateLogic2() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().build();
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        union.union((QuantilesDoublesSketch)qs1);
        union.union((QuantilesDoublesSketch)qs2);
        qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000);
        union.union((QuantilesDoublesSketch)qs1);
        union.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)1000.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkUnionUpdateLogic2Direct() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().build();
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        union.union((QuantilesDoublesSketch)qs1);
        union.union((QuantilesDoublesSketch)qs2);
        qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 1000);
        union.union((QuantilesDoublesSketch)qs1);
        union.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxItem(), (double)1000.0, (double)0.0);
        Assert.assertEquals((double)result.getMinItem(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkResultAndReset() {
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 0);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs1);
        UpdatableQuantilesDoublesSketch qs2 = union.getResultAndReset();
        Assert.assertEquals((int)qs2.getK(), (int)256);
    }

    @Test
    public void checkResultAndResetDirect() {
        UpdatableQuantilesDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 0);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs1);
        UpdatableQuantilesDoublesSketch qs2 = union.getResultAndReset();
        Assert.assertEquals((int)qs2.getK(), (int)256);
    }

    @Test
    public void checkResultViaMemory() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        MemorySegment seg = MemorySegment.ofArray(new byte[1]);
        try {
            union.getResult(seg, null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg = MemorySegment.ofArray(new byte[8]);
        UpdatableQuantilesDoublesSketch result = union.getResult(seg, null);
        Assert.assertTrue((boolean)result.isEmpty());
        int k = 128;
        int n = 1392;
        seg = MemorySegment.ofArray(new byte[QuantilesDoublesSketch.getUpdatableStorageBytes((int)128, (long)1392L)]);
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1392);
        union.union((QuantilesDoublesSketch)qs);
        result = union.getResult(seg, null);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)result, (QuantilesDoublesSketch)qs);
    }

    @Test
    public void updateWithDoubleValueOnly() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        union.update(123.456);
        UpdatableQuantilesDoublesSketch qs = union.getResultAndReset();
        Assert.assertEquals((long)qs.getN(), (long)1L);
    }

    @Test
    public void checkEmptyUnion() {
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapInstance((int)128);
        UpdatableQuantilesDoublesSketch sk = union.getResult();
        Assert.assertNotNull((Object)sk);
        byte[] bytes = union.toByteArray();
        Assert.assertEquals((int)bytes.length, (int)8);
        String s = union.toString();
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void checkUnionNulls() {
        QuantilesDoublesUnionImpl union = QuantilesDoublesUnionImpl.heapInstance((int)128);
        UpdatableQuantilesDoublesSketch sk1 = union.getResultAndReset();
        UpdatableQuantilesDoublesSketch sk2 = union.getResultAndReset();
        Assert.assertNull((Object)sk1);
        Assert.assertNull((Object)sk2);
        try {
            union.union((QuantilesDoublesSketch)sk2);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        UpdatableQuantilesDoublesSketch sk3 = union.getResultAndReset();
        Assert.assertNull((Object)sk3);
    }

    @Test
    public void differentLargerK() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(128).build();
        UpdatableQuantilesDoublesSketch sketch1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentLargerKDirect() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(128).build();
        UpdatableQuantilesDoublesSketch sketch1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentEmptySmallerK() {
        int k128 = 128;
        int k64 = 64;
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(128).build();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.hasMemorySegment());
        Assert.assertFalse((boolean)union.isOffHeap());
        UpdatableQuantilesDoublesSketch sketch1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(64, 0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.hasMemorySegment());
        Assert.assertFalse((boolean)union.isOffHeap());
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentEmptySmallerKDirect() {
        int k128 = 128;
        int k64 = 64;
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(128).build();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.hasMemorySegment());
        Assert.assertFalse((boolean)union.isOffHeap());
        UpdatableQuantilesDoublesSketch sketch1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(64, 0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.hasMemorySegment());
        Assert.assertFalse((boolean)union.isOffHeap());
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.union((QuantilesDoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void checkDirectInstance() {
        int k = 128;
        int n = 1000;
        QuantilesDoublesUnionBuilder bldr = QuantilesDoublesUnion.builder();
        bldr.setMaxK(128);
        Assert.assertEquals((int)bldr.getMaxK(), (int)128);
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)128, (long)1000L);
        byte[] byteArr = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        QuantilesDoublesUnion union = bldr.build(seg, null);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertTrue((boolean)union.hasMemorySegment());
        Assert.assertFalse((boolean)union.isOffHeap());
        for (int i = 1; i <= 1000; ++i) {
            union.update((double)i);
        }
        Assert.assertFalse((boolean)union.isEmpty());
        UpdatableQuantilesDoublesSketch res = union.getResult();
        double median = res.getQuantile(0.5);
        Assert.assertEquals((double)median, (double)500.0, (double)10.0);
        DoublesUnionImplTest.println(union.toString());
    }

    @Test
    public void checkWrapInstance() {
        int k = 128;
        int n = 1000;
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().setK(128).build();
        for (int i = 1; i <= 1000; ++i) {
            sketch.update((double)i);
        }
        double skMedian = sketch.getQuantile(0.5);
        Assert.assertEquals((double)skMedian, (double)500.0, (double)10.0);
        byte[] byteArr = sketch.toByteArray(false);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.wrap((MemorySegment)seg, null);
        Assert.assertFalse((boolean)union.isEmpty());
        Assert.assertTrue((boolean)union.hasMemorySegment());
        Assert.assertFalse((boolean)union.isOffHeap());
        UpdatableQuantilesDoublesSketch sketch2 = union.getResult();
        double uMedian = sketch2.getQuantile(0.5);
        Assert.assertEquals((double)skMedian, (double)uMedian, (double)0.0);
        byte[] bytesOut = union.toByteArray();
        Assert.assertEquals((int)bytesOut.length, (int)byteArr.length);
        Assert.assertEquals((byte[])bytesOut, (byte[])byteArr);
    }

    @Test
    public void isSameResourceHeap() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        Assert.assertFalse((boolean)union.isSameResource(null));
    }

    @Test
    public void isSameResourceDirect() {
        MemorySegment seg1 = MemorySegment.ofArray(new byte[1000000]);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build(seg1, null);
        Assert.assertTrue((boolean)union.isSameResource(seg1));
        MemorySegment seg2 = MemorySegment.ofArray(new byte[1000000]);
        Assert.assertFalse((boolean)union.isSameResource(seg2));
    }

    @Test
    public void emptyUnionSerDeIssue195() {
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().build();
        byte[] byteArr = union.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        QuantilesDoublesUnion union2 = QuantilesDoublesUnion.heapify((MemorySegment)seg);
        Assert.assertEquals((long)seg.byteSize(), (long)8L);
        Assert.assertTrue((boolean)union2.isEmpty());
    }

    @Test
    public void printlnTest() {
        DoublesUnionImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

