/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.util.xml.QNameMapEntry;

public final class QNameMap<V> {
    private QNameMapEntry<V>[] buckets = this.createBuckets(16);
    private int size;

    private QNameMapEntry<V>[] createBuckets(int count) {
        return new QNameMapEntry[count];
    }

    public void put(QName qname, V value) {
        if (this.buckets.length < this.size * 4 / 3) {
            QNameMapEntry<V>[] oldBuckets = this.buckets;
            this.buckets = this.createBuckets(this.buckets.length * 2);
            for (QNameMapEntry<V> entry : oldBuckets) {
                while (entry != null) {
                    QNameMapEntry next = entry.next;
                    int index = this.index(entry.qname);
                    entry.next = this.buckets[index];
                    this.buckets[index] = entry;
                    entry = next;
                }
            }
        }
        int index = this.index(qname);
        QNameMapEntry<V> entry = this.buckets[index];
        while (entry != null) {
            if (entry.qname.equals(qname)) {
                entry.value = value;
                break;
            }
            entry = entry.next;
        }
        if (entry == null) {
            entry = new QNameMapEntry();
            entry.qname = qname;
            entry.next = this.buckets[index];
            this.buckets[index] = entry;
            ++this.size;
        }
        entry.value = value;
    }

    public V get(QName qname) {
        return this.get(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public V get(String namespaceURI, String localPart) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (localPart == null) {
            throw new IllegalArgumentException("localPart cannot be null");
        }
        int index = this.index(namespaceURI, localPart);
        QNameMapEntry<V> entry = this.buckets[index];
        while (entry != null) {
            if (entry.qname.getLocalPart().equals(localPart) && entry.qname.getNamespaceURI().equals(namespaceURI)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private int index(QName qname) {
        return this.index(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private int index(String namespaceURI, String localPart) {
        return (namespaceURI.hashCode() ^ localPart.hashCode()) & this.buckets.length - 1;
    }
}

