/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message;

import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.XMLFaultCode;
import org.apache.axis2.jaxws.message.XMLFaultReason;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLFault {
    private static Log log = LogFactory.getLog(XMLFault.class);
    private XMLFaultCode code;
    private XMLFaultReason reason;
    private Block[] detailBlocks;
    private String role;
    private String node;
    private QName[] subCodes = null;
    private XMLFaultReason[] secondaryReasons = null;

    public XMLFault(XMLFaultCode code, XMLFaultReason reason, Block[] detailBlocks) {
        if (code == null) {
            code = XMLFaultCode.RECEIVER;
        }
        this.code = code;
        this.reason = reason;
        this.detailBlocks = detailBlocks;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created XMLFault:" + this.dump("")));
        }
    }

    public XMLFault(XMLFaultCode code, XMLFaultReason reason) {
        this(code, reason, null);
    }

    public XMLFaultCode getCode() {
        return this.code;
    }

    public Block[] getDetailBlocks() {
        return this.detailBlocks;
    }

    public XMLFaultReason getReason() {
        return this.reason;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public XMLFaultReason[] getSecondaryReasons() {
        return this.secondaryReasons;
    }

    public void setSecondaryReasons(XMLFaultReason[] secondaryReasons) {
        this.secondaryReasons = secondaryReasons;
    }

    public QName[] getSubCodes() {
        return this.subCodes;
    }

    public void setSubCodes(QName[] subCodes) {
        this.subCodes = subCodes;
    }

    public String dump(String indent) {
        Object text = "";
        String NL = "\n";
        try {
            text = (String)text + indent + "XMLFault " + String.valueOf(this) + "\n";
            text = (String)text + indent + " code=   " + String.valueOf(this.code.toQName("")) + "\n";
            text = this.reason != null ? (String)text + indent + " reason= " + this.reason.getText() + "\n" : (String)text + indent + " reason= null\n";
            text = (String)text + indent + " role   =" + this.role + "\n";
            text = (String)text + indent + " node   =" + this.node + "\n";
            if (this.detailBlocks == null) {
                text = (String)text + indent + " no detail blocks\n";
            } else {
                for (int i = 0; i < this.detailBlocks.length; ++i) {
                    text = (String)text + indent + " detail= " + String.valueOf(this.detailBlocks[i].getQName());
                }
            }
        }
        catch (Exception e) {
            text = (String)text + "Could not dump the XMLFault due to exception " + String.valueOf(e);
        }
        return text;
    }
}

