/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantModule;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPackage;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;

public class ConstantPoolGen {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    @Deprecated
    protected int size;
    @Deprecated
    protected Constant[] constants;
    @Deprecated
    protected int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private final Map<String, Index> stringTable = new HashMap<String, Index>();
    private final Map<String, Index> classTable = new HashMap<String, Index>();
    private final Map<String, Index> utf8Table = new HashMap<String, Index>();
    private final Map<String, Index> natTable = new HashMap<String, Index>();
    private final Map<String, Index> cpTable = new HashMap<String, Index>();

    public ConstantPoolGen(Constant[] cs) {
        StringBuilder sb = new StringBuilder(256);
        this.size = Math.max(256, cs.length + 64);
        this.constants = new Constant[this.size];
        System.arraycopy(cs, 0, this.constants, 0, cs.length);
        if (cs.length > 0) {
            this.index = cs.length;
        }
        for (int i = 1; i < this.index; ++i) {
            String key;
            ConstantUtf8 u8;
            Constant s;
            Constant c = this.constants[i];
            if (c instanceof ConstantString) {
                s = (ConstantString)c;
                u8 = (ConstantUtf8)this.constants[((ConstantString)s).getStringIndex()];
                key = u8.getBytes();
                if (this.stringTable.containsKey(key)) continue;
                this.stringTable.put(key, new Index(i));
                continue;
            }
            if (c instanceof ConstantClass) {
                s = (ConstantClass)c;
                u8 = (ConstantUtf8)this.constants[((ConstantClass)s).getNameIndex()];
                key = u8.getBytes();
                if (this.classTable.containsKey(key)) continue;
                this.classTable.put(key, new Index(i));
                continue;
            }
            if (c instanceof ConstantNameAndType) {
                ConstantNameAndType n = (ConstantNameAndType)c;
                u8 = (ConstantUtf8)this.constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                sb.append(u8.getBytes());
                sb.append(NAT_DELIM);
                sb.append(u8_2.getBytes());
                String key2 = sb.toString();
                sb.delete(0, sb.length());
                if (this.natTable.containsKey(key2)) continue;
                this.natTable.put(key2, new Index(i));
                continue;
            }
            if (c instanceof ConstantUtf8) {
                ConstantUtf8 u = (ConstantUtf8)c;
                String key3 = u.getBytes();
                if (this.utf8Table.containsKey(key3)) continue;
                this.utf8Table.put(key3, new Index(i));
                continue;
            }
            if (c instanceof ConstantCP) {
                ConstantUtf8 u82;
                String class_name;
                ConstantCP m = (ConstantCP)c;
                if (c instanceof ConstantInvokeDynamic) {
                    class_name = Integer.toString(((ConstantInvokeDynamic)m).getBootstrapMethodAttrIndex());
                } else {
                    ConstantClass clazz = (ConstantClass)this.constants[m.getClassIndex()];
                    u82 = (ConstantUtf8)this.constants[clazz.getNameIndex()];
                    class_name = u82.getBytes().replace('/', '.');
                }
                ConstantNameAndType n = (ConstantNameAndType)this.constants[m.getNameAndTypeIndex()];
                u82 = (ConstantUtf8)this.constants[n.getNameIndex()];
                String method_name = u82.getBytes();
                u82 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                String signature = u82.getBytes();
                String delim = METHODREF_DELIM;
                if (c instanceof ConstantInterfaceMethodref) {
                    delim = IMETHODREF_DELIM;
                } else if (c instanceof ConstantFieldref) {
                    delim = FIELDREF_DELIM;
                }
                sb.append(class_name);
                sb.append(delim);
                sb.append(method_name);
                sb.append(delim);
                sb.append(signature);
                String key4 = sb.toString();
                sb.delete(0, sb.length());
                if (this.cpTable.containsKey(key4)) continue;
                this.cpTable.put(key4, new Index(i));
                continue;
            }
            if (c != null && !(c instanceof ConstantInteger) && !(c instanceof ConstantLong) && !(c instanceof ConstantFloat) && !(c instanceof ConstantDouble) && !(c instanceof ConstantMethodType) && !(c instanceof ConstantMethodHandle) && !(c instanceof ConstantModule) && !(c instanceof ConstantPackage)) assert (false) : "Unexpected constant type: " + c.getClass().getName();
        }
    }

    public ConstantPoolGen(ConstantPool cp) {
        this(cp.getConstantPool());
    }

    public ConstantPoolGen() {
        this.size = 256;
        this.constants = new Constant[this.size];
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] cs = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(cs, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String str) {
        Index index = this.stringTable.get(str);
        return index != null ? index.index : -1;
    }

    public int addString(String str) {
        int ret = this.lookupString(str);
        if (ret != -1) {
            return ret;
        }
        int utf8 = this.addUtf8(str);
        this.adjustSize();
        ConstantString s = new ConstantString(utf8);
        ret = this.index;
        this.constants[this.index++] = s;
        if (!this.stringTable.containsKey(str)) {
            this.stringTable.put(str, new Index(ret));
        }
        return ret;
    }

    public int lookupClass(String str) {
        Index index = this.classTable.get(str.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private int addClass_(String clazz) {
        int ret = this.lookupClass(clazz);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantClass c = new ConstantClass(this.addUtf8(clazz));
        ret = this.index;
        this.constants[this.index++] = c;
        if (!this.classTable.containsKey(clazz)) {
            this.classTable.put(clazz, new Index(ret));
        }
        return ret;
    }

    public int addClass(String str) {
        return this.addClass_(str.replace('.', '/'));
    }

    public int addClass(ObjectType type) {
        return this.addClass(type.getClassName());
    }

    public int addArrayClass(ArrayType type) {
        return this.addClass_(type.getSignature());
    }

    public int lookupInteger(int n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger c;
            if (!(this.constants[i] instanceof ConstantInteger) || (c = (ConstantInteger)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int addInteger(int n) {
        int ret = this.lookupInteger(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return ret;
    }

    public int lookupFloat(float n) {
        int bits = Float.floatToIntBits(n);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat c;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((c = (ConstantFloat)this.constants[i]).getBytes()) != bits) continue;
            return i;
        }
        return -1;
    }

    public int addFloat(float n) {
        int ret = this.lookupFloat(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantFloat(n);
        return ret;
    }

    public int lookupUtf8(String n) {
        Index index = this.utf8Table.get(n);
        return index != null ? index.index : -1;
    }

    public int addUtf8(String n) {
        int ret = this.lookupUtf8(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantUtf8(n);
        if (!this.utf8Table.containsKey(n)) {
            this.utf8Table.put(n, new Index(ret));
        }
        return ret;
    }

    public int lookupLong(long n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong c;
            if (!(this.constants[i] instanceof ConstantLong) || (c = (ConstantLong)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int addLong(long n) {
        int ret = this.lookupLong(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantLong(n);
        this.index += 2;
        return ret;
    }

    public int lookupDouble(double n) {
        long bits = Double.doubleToLongBits(n);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble c;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((c = (ConstantDouble)this.constants[i]).getBytes()) != bits) continue;
            return i;
        }
        return -1;
    }

    public int addDouble(double n) {
        int ret = this.lookupDouble(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantDouble(n);
        this.index += 2;
        return ret;
    }

    public int lookupNameAndType(String name, String signature) {
        Index _index = this.natTable.get(name + NAT_DELIM + signature);
        return _index != null ? _index.index : -1;
    }

    public int addNameAndType(String name, String signature) {
        int ret = this.lookupNameAndType(name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_index = this.addUtf8(name);
        int signature_index = this.addUtf8(signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantNameAndType(name_index, signature_index);
        String key = name + NAT_DELIM + signature;
        if (!this.natTable.containsKey(key)) {
            this.natTable.put(key, new Index(ret));
        }
        return ret;
    }

    public int lookupMethodref(String class_name, String method_name, String signature) {
        Index index = this.cpTable.get(class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupMethodref(MethodGen method) {
        return this.lookupMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int addMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_and_type_index = this.addNameAndType(method_name, signature);
        int class_index = this.addClass(class_name);
        ret = this.index;
        this.constants[this.index++] = new ConstantMethodref(class_index, name_and_type_index);
        String key = class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature;
        if (!this.cpTable.containsKey(key)) {
            this.cpTable.put(key, new Index(ret));
        }
        return ret;
    }

    public int addMethodref(MethodGen method) {
        return this.addMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int lookupInterfaceMethodref(String class_name, String method_name, String signature) {
        Index index = this.cpTable.get(class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen method) {
        return this.lookupInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int addInterfaceMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupInterfaceMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(method_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(class_index, name_and_type_index);
        String key = class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature;
        if (!this.cpTable.containsKey(key)) {
            this.cpTable.put(key, new Index(ret));
        }
        return ret;
    }

    public int addInterfaceMethodref(MethodGen method) {
        return this.addInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int lookupFieldref(String class_name, String field_name, String signature) {
        Index index = this.cpTable.get(class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int addFieldref(String class_name, String field_name, String signature) {
        int ret = this.lookupFieldref(class_name, field_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(field_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantFieldref(class_index, name_and_type_index);
        String key = class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature;
        if (!this.cpTable.containsKey(key)) {
            this.cpTable.put(key, new Index(ret));
        }
        return ret;
    }

    public Constant getConstant(int i) {
        return this.constants[i];
    }

    public void setConstant(int i, Constant c) {
        this.constants[i] = c;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] cs = new Constant[this.index];
        System.arraycopy(this.constants, 0, cs, 0, this.index);
        return new ConstantPool(cs);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.index; ++i) {
            buf.append(i).append(")").append(this.constants[i]).append("\n");
        }
        return buf.toString();
    }

    public int addConstant(Constant c, ConstantPoolGen cp) {
        Constant[] constants = cp.getConstantPool().getConstantPool();
        switch (c.getTag()) {
            case 8: {
                ConstantString s = (ConstantString)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s.getStringIndex()];
                return this.addString(u8.getBytes());
            }
            case 7: {
                ConstantClass s = (ConstantClass)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s.getNameIndex()];
                return this.addClass(u8.getBytes());
            }
            case 12: {
                ConstantNameAndType n = (ConstantNameAndType)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)constants[n.getSignatureIndex()];
                return this.addNameAndType(u8.getBytes(), u8_2.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)c).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)c).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)c).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)c).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)c).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP m = (ConstantCP)c;
                ConstantClass clazz = (ConstantClass)constants[m.getClassIndex()];
                ConstantNameAndType n = (ConstantNameAndType)constants[m.getNameAndTypeIndex()];
                ConstantUtf8 u8 = (ConstantUtf8)constants[clazz.getNameIndex()];
                String class_name = u8.getBytes().replace('/', '.');
                u8 = (ConstantUtf8)constants[n.getNameIndex()];
                String name = u8.getBytes();
                u8 = (ConstantUtf8)constants[n.getSignatureIndex()];
                String signature = u8.getBytes();
                switch (c.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(class_name, name, signature);
                    }
                    case 10: {
                        return this.addMethodref(class_name, name, signature);
                    }
                    case 9: {
                        return this.addFieldref(class_name, name, signature);
                    }
                }
                throw new IllegalArgumentException("Unknown constant type " + c);
            }
        }
        throw new IllegalArgumentException("Unknown constant type " + c);
    }

    private static class Index {
        final int index;

        Index(int i) {
            this.index = i;
        }
    }
}

