/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "chr" locale.
 */
public class LocalizedNamesImpl_chr extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "UM",
        "VI",
        "XA",
        "XB",
        "AM",
        "AL",
        "DZ",
        "AW",
        "AS",
        "GF",
        "PF",
        "TF",
        "AI",
        "AO",
        "PH",
        "MX",
        "ES",
        "SZ",
        "AD",
        "TC",
        "DE",
        "QO",
        "AT",
        "AZ",
        "CK",
        "VA",
        "AR",
        "AF",
        "IE",
        "AU",
        "SV",
        "ER",
        "EC",
        "GQ",
        "EE",
        "CV",
        "IQ",
        "IR",
        "ID",
        "IN",
        "IL",
        "IT",
        "ET",
        "NC",
        "GL",
        "NZ",
        "EG",
        "CI",
        "AX",
        "OM",
        "AC",
        "UZ",
        "IM",
        "KN",
        "SH",
        "LC",
        "SM",
        "BL",
        "PM",
        "MF",
        "VC",
        "AG",
        "GH",
        "FR",
        "GM",
        "CP",
        "GA",
        "GY",
        "KI",
        "BQ",
        "HR",
        "CM",
        "KH",
        "CD",
        "CG",
        "KZ",
        "QA",
        "KY",
        "CA",
        "KE",
        "GN",
        "GW",
        "GB",
        "KG",
        "GR",
        "CC",
        "CO",
        "KM",
        "CR",
        "XK",
        "CW",
        "CU",
        "KW",
        "CF",
        "GG",
        "TR",
        "HN",
        "HT",
        "HK",
        "HU",
        "HM",
        "LR",
        "LV",
        "LA",
        "LB",
        "LS",
        "RE",
        "LI",
        "LY",
        "LT",
        "RO",
        "RW",
        "LU",
        "FM",
        "MO",
        "MW",
        "MY",
        "ML",
        "MT",
        "MV",
        "MD",
        "MC",
        "MN",
        "MS",
        "MH",
        "MK",
        "MG",
        "MR",
        "MQ",
        "MM",
        "YT",
        "MU",
        "MA",
        "ME",
        "MZ",
        "NE",
        "NA",
        "BS",
        "NP",
        "NL",
        "NI",
        "NG",
        "NU",
        "NR",
        "NF",
        "NO",
        "PK",
        "BH",
        "PY",
        "PW",
        "PS",
        "GU",
        "PA",
        "BJ",
        "BD",
        "PG",
        "BB",
        "BM",
        "BR",
        "BW",
        "PR",
        "BY",
        "BZ",
        "BE",
        "PE",
        "PN",
        "VG",
        "IO",
        "PL",
        "BO",
        "BA",
        "PT",
        "BG",
        "BN",
        "BT",
        "BV",
        "BF",
        "BI",
        "GD",
        "CY",
        "ST",
        "SA",
        "ZM",
        "WS",
        "UN",
        "AE",
        "US",
        "LK",
        "SK",
        "SI",
        "SJ",
        "CH",
        "SE",
        "SL",
        "SC",
        "SY",
        "ZW",
        "SN",
        "SG",
        "SX",
        "SB",
        "SO",
        "EA",
        "SD",
        "SR",
        "RS",
        "CN",
        "CX",
        "TW",
        "TJ",
        "TH",
        "TZ",
        "DK",
        "DG",
        "TL",
        "TK",
        "TG",
        "DM",
        "DO",
        "TO",
        "TN",
        "TV",
        "TM",
        "TT",
        "TA",
        "GE",
        "JM",
        "TD",
        "JP",
        "CZ",
        "CL",
        "GI",
        "DJ",
        "IC",
        "JO",
        "ZA",
        "SS",
        "KR",
        "GS",
        "AQ",
        "IS",
        "KP",
        "MP",
        "JE",
        "FK",
        "WF",
        "VU",
        "GP",
        "GT",
        "FO",
        "VE",
        "VN",
        "FI",
        "FJ",
        "EH",
        "YE",
        "RU",
        "UG",
        "UA",
        "EU",
        "EZ",
        "UY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ᎡᎶᎯ");
    namesMap.put("002", "ᎬᎿᎨᏍᏛ");
    namesMap.put("003", "ᏧᏴᏢ ᎠᎹᏰᏟ");
    namesMap.put("005", "ᏧᎦᏃᏮ ᎠᎺᎵᎦ");
    namesMap.put("009", "ᎣᏏᏰᏂᎠ");
    namesMap.put("011", "ᏭᏕᎵᎬ ᏗᏜ ᎬᎿᎨᏍᏛ");
    namesMap.put("013", "ᎠᏰᏟ ᎠᎹᏰᏟ");
    namesMap.put("014", "ᏗᎧᎸᎬ ᏗᏜ ᎬᎿᎨᏍᏛ");
    namesMap.put("015", "ᏧᏴᏢ ᏗᏜ ᎬᎿᎨᏍᏛ");
    namesMap.put("017", "ᎠᏰᏟ ᎬᎿᎨᏍᏛ");
    namesMap.put("018", "ᏧᎦᎾᏮ ᏗᏜ ᎬᎿᎨᏍᏛ");
    namesMap.put("019", "ᎠᎺᎵᎦᎢ");
    namesMap.put("021", "ᏧᏴᏢ ᏗᏜ ᎠᎹᏰᏟ");
    namesMap.put("029", "ᎨᏆᏙᏯ");
    namesMap.put("030", "ᏗᎧᎸᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("034", "ᏧᎦᎾᏮ ᏗᏜ ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("035", "ᏧᎦᎾᏮ ᏗᎧᎸᎬ ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("039", "ᏧᎦᎾᏮ ᏗᏜ ᏳᎳᏛ");
    namesMap.put("053", "ᎠᏍᏔᎴᏏᎠ");
    namesMap.put("054", "ᎺᎳᏁᏏᎠ");
    namesMap.put("057", "ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ ᎢᎬᎾᏕᎾ");
    namesMap.put("061", "ᏆᎵᏂᏏᎠ");
    namesMap.put("142", "ᏓᎶᎾᎨᏍᏛ");
    namesMap.put("143", "ᎠᏰᏟ ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("145", "ᏭᏕᎵᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("150", "ᏳᎳᏛ");
    namesMap.put("151", "ᏗᎧᎸᎬ ᏗᏜ ᏳᎳᏛ");
    namesMap.put("154", "ᏧᏴᏢ ᏗᏜ ᏳᎳᏛ");
    namesMap.put("155", "ᏭᏕᎵᎬ ᏗᏜ ᏳᎳᏛ");
    namesMap.put("202", "ᎭᏫᏂ-ᏌᎭᏩ ᎬᎿᎨᏍᏛ");
    namesMap.put("419", "ᎳᏘᏂ ᎠᎹᏰᏟ");
    namesMap.put("AC", "ᎤᎵᏌᎳᏓᏅ ᎤᎦᏚᏛᎢ");
    namesMap.put("AD", "ᎠᏂᏙᎳ");
    namesMap.put("AE", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ");
    namesMap.put("AF", "ᎠᏫᎨᏂᏍᏖᏂ");
    namesMap.put("AG", "ᎤᏪᏘ & ᏆᏊᏓ");
    namesMap.put("AI", "ᎠᏂᎩᎳ");
    namesMap.put("AL", "ᎠᎵᏇᏂᏯ");
    namesMap.put("AM", "ᎠᎵᎻᏂᎠ");
    namesMap.put("AO", "ᎠᏂᎪᎳ");
    namesMap.put("AQ", "ᏧᏁᏍᏓᎸ");
    namesMap.put("AR", "ᎠᏥᏂᏘᏂᎠ");
    namesMap.put("AS", "ᎠᎺᎵᎧ ᏌᎼᎠ");
    namesMap.put("AT", "ᎠᏍᏟᏯ");
    namesMap.put("AU", "ᎡᎳᏗᏜ");
    namesMap.put("AW", "ᎠᎷᏆ");
    namesMap.put("AX", "ᎣᎴᏅᏓ ᏚᎦᏚᏛᎢ");
    namesMap.put("AZ", "ᎠᏎᏆᏣᏂ");
    namesMap.put("BA", "ᏉᏏᏂᎠ & ᎲᏤᎪᏫ");
    namesMap.put("BB", "ᏆᏇᏙᏍ");
    namesMap.put("BD", "ᏆᏂᎦᎵᏕᏍ");
    namesMap.put("BE", "ᏇᎵᏥᎥᎻ");
    namesMap.put("BF", "ᏋᎩᎾ ᏩᏐ");
    namesMap.put("BG", "ᏊᎵᎨᎵᎠ");
    namesMap.put("BH", "ᏆᎭᎴᎢᏂ");
    namesMap.put("BI", "ᏋᎷᏂᏗ");
    namesMap.put("BJ", "ᏆᏂᎢᏂ");
    namesMap.put("BL", "ᎤᏓᏅᏘ ᏆᏕᎳᎻ");
    namesMap.put("BM", "ᏆᏊᏓ");
    namesMap.put("BN", "ᏊᎾᎢ");
    namesMap.put("BO", "ᏉᎵᏫᎠ");
    namesMap.put("BQ", "ᎧᎵᏈᎢᏂᎯ ᎾᏍᎩᏁᏛᎳᏂ");
    namesMap.put("BR", "ᏆᏏᎵ");
    namesMap.put("BS", "ᎾᏍᎩ ᏆᎭᎹᏍ");
    namesMap.put("BT", "ᏊᏔᏂ");
    namesMap.put("BV", "ᏊᏪ ᎤᎦᏚᏛᎢ");
    namesMap.put("BW", "ᏆᏣᏩᎾ");
    namesMap.put("BY", "ᏇᎳᎷᏍ");
    namesMap.put("BZ", "ᏇᎵᏍ");
    namesMap.put("CA", "ᎨᎾᏓ");
    namesMap.put("CC", "ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛᎢ");
    namesMap.put("CD", "ᎧᏂᎪ - ᎨᏂᏝᏌ");
    namesMap.put("CF", "ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ");
    namesMap.put("CG", "ᎧᏂᎪ - ᏆᏌᏩᎵ");
    namesMap.put("CH", "ᏍᏫᏍ");
    namesMap.put("CI", "ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ");
    namesMap.put("CK", "ᎠᏓᏍᏓᏴᎲᏍᎩ ᏚᎦᏚᏛᎢ");
    namesMap.put("CL", "ᏥᎵ");
    namesMap.put("CM", "ᎧᎹᎷᏂ");
    namesMap.put("CN", "ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("CO", "ᎪᎸᎻᏈᎢᎠ");
    namesMap.put("CP", "ᎦᏂᏴᏔᏅᎣᏓᎸ ᎤᎦᏚᏛᎢ");
    namesMap.put("CR", "ᎪᏍᏓ ᎵᎧ");
    namesMap.put("CU", "ᎫᏆ");
    namesMap.put("CV", "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ");
    namesMap.put("CW", "ᎫᎳᎨᎣ");
    namesMap.put("CX", "ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛᎢ");
    namesMap.put("CY", "ᏌᎢᏆᏍ");
    namesMap.put("CZ", "ᏤᎩᎠ");
    namesMap.put("DE", "ᎠᏂᏛᏥ");
    namesMap.put("DG", "ᏗᏰᎪ ᎦᏏᏯ");
    namesMap.put("DJ", "ᏥᏊᏗ");
    namesMap.put("DK", "ᏗᏂᎹᎦ");
    namesMap.put("DM", "ᏙᎻᏂᎧ");
    namesMap.put("DO", "ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ");
    namesMap.put("DZ", "ᎠᎵᏥᎵᏯ");
    namesMap.put("EA", "ᏑᏔ ᎠᎴ ᎺᎵᏯ");
    namesMap.put("EC", "ᎡᏆᏙᎵ");
    namesMap.put("EE", "ᎡᏍᏙᏂᏯ");
    namesMap.put("EG", "ᎢᏥᏈᎢ");
    namesMap.put("EH", "ᏭᏕᎵᎬ ᏗᏜ ᏌᎮᎳ");
    namesMap.put("ER", "ᎡᎵᏟᏯ");
    namesMap.put("ES", "ᎠᏂᏍᏆᏂᏱ");
    namesMap.put("ET", "ᎢᏗᎣᏈᎠ");
    namesMap.put("EU", "ᏳᎳᏛ ᎠᏂᎤᎾᏓᏡᎬ");
    namesMap.put("EZ", "ᏳᎶᎠᏍᏓᏅᏅ");
    namesMap.put("FI", "ᏫᏂᎦᏙᎯ");
    namesMap.put("FJ", "ᏫᏥ");
    namesMap.put("FK", "ᏩᎩ ᏚᎦᏚᏛᎢ");
    namesMap.put("FM", "ᎹᎢᏉᏂᏏᏯ");
    namesMap.put("FO", "ᏪᎶ ᏚᎦᏚᏛᎢ");
    namesMap.put("FR", "ᎦᎸᏥᏱ");
    namesMap.put("GA", "ᎦᏉᏂ");
    namesMap.put("GB", "ᎩᎵᏏᏲ");
    namesMap.put("GD", "ᏋᎾᏓ");
    namesMap.put("GE", "ᏣᎠᏥᎢ");
    namesMap.put("GF", "ᎠᏂᎦᎸᏥ ᎩᎠ");
    namesMap.put("GG", "ᎬᏂᏏ");
    namesMap.put("GH", "ᎦᎠᎾ");
    namesMap.put("GI", "ᏥᏆᎵᏓ");
    namesMap.put("GL", "ᎢᏤᏍᏛᏱ");
    namesMap.put("GM", "ᎦᎹᏈᎢᎠ");
    namesMap.put("GN", "ᎩᎢᏂ");
    namesMap.put("GP", "ᏩᏓᎷᏇ");
    namesMap.put("GQ", "ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ");
    namesMap.put("GR", "ᎪᎢᎯ");
    namesMap.put("GS", "ᏧᎦᏃᏮ ᏣᎠᏥᎢ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛᎢ");
    namesMap.put("GT", "ᏩᏔᎹᎳ");
    namesMap.put("GU", "ᏆᎻ");
    namesMap.put("GW", "ᎩᎢᏂ-ᏈᏌᎤᏫ");
    namesMap.put("GY", "ᎦᏯᎾ");
    namesMap.put("HK", "ᎰᏂᎩ ᎪᏂᎩ ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("HM", "ᎲᏗ ᎤᎦᏚᏛᎢ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛᎢ");
    namesMap.put("HN", "ᎭᏂᏚᎳᏍ");
    namesMap.put("HR", "ᎧᎶᎡᏏᎠ");
    namesMap.put("HT", "ᎮᎢᏘ");
    namesMap.put("HU", "ᎲᏂᎦᎵ");
    namesMap.put("IC", "ᏥᏍᏆ ᏚᎦᏚᏛᎢ");
    namesMap.put("ID", "ᎢᏂᏙᏂᏍᏯ");
    namesMap.put("IE", "ᎠᏲᎳᏂ");
    namesMap.put("IL", "ᎢᏏᎵᏱ");
    namesMap.put("IM", "ᎤᏍᏗ ᎤᎦᏚᏛᎢ ᎾᎿ ᎠᏍᎦᏯ");
    namesMap.put("IN", "ᎢᏅᏗᎾ");
    namesMap.put("IO", "ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ");
    namesMap.put("IQ", "ᎢᎳᎩ");
    namesMap.put("IR", "ᎢᎴᏂ");
    namesMap.put("IS", "ᏧᏁᏍᏓᎸᎯ");
    namesMap.put("IT", "ᎢᏔᎵ");
    namesMap.put("JE", "ᏨᎵᏏ");
    namesMap.put("JM", "ᏣᎺᎢᎧ");
    namesMap.put("JO", "ᏦᏓᏂ");
    namesMap.put("JP", "ᏣᏩᏂᏏ");
    namesMap.put("KE", "ᎨᏂᏯ");
    namesMap.put("KG", "ᎩᎵᏣᎢᏍ");
    namesMap.put("KH", "ᎧᎹᏉᏗᎠᏂ");
    namesMap.put("KI", "ᎧᎵᏆᏘ");
    namesMap.put("KM", "ᎪᎼᎳᏍ");
    namesMap.put("KN", "ᎤᏓᏅᏘ ᎨᏘᏏ ᎠᎴ ᏁᏪᏏ");
    namesMap.put("KP", "ᏧᏴᏢ ᎪᎵᎠ");
    namesMap.put("KR", "ᏧᎦᏃᏮ ᎪᎵᎠ");
    namesMap.put("KW", "ᎫᏪᎢᏘ");
    namesMap.put("KY", "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ");
    namesMap.put("KZ", "ᎧᏎᎧᏍᏕᏂ");
    namesMap.put("LA", "ᎴᎣᏍ");
    namesMap.put("LB", "ᎴᏆᎾᏂ");
    namesMap.put("LC", "ᎤᏓᏅᏘ ᎷᏏᏯ");
    namesMap.put("LI", "ᎵᎦᏗᏂᏍᏓᏂ");
    namesMap.put("LK", "ᏍᎵ ᎳᏂᎧ");
    namesMap.put("LR", "ᎳᏈᎵᏯ");
    namesMap.put("LS", "ᎴᏐᏙ");
    namesMap.put("LT", "ᎵᏗᏪᏂᎠ");
    namesMap.put("LU", "ᎸᎧᏎᏋᎩ");
    namesMap.put("LV", "ᎳᏘᏫᎠ");
    namesMap.put("LY", "ᎵᏈᏯ");
    namesMap.put("MA", "ᎼᎶᎪ");
    namesMap.put("MC", "ᎹᎾᎪ");
    namesMap.put("MD", "ᎹᎵᏙᏫᎠ");
    namesMap.put("ME", "ᎼᏂᏔᏁᎦᎶ");
    namesMap.put("MF", "ᎤᏓᏅᏘ ᏡᏡ");
    namesMap.put("MG", "ᎹᏓᎦᏍᎧᎵ");
    namesMap.put("MH", "ᎹᏌᎵ ᏚᎦᏚᏛᎢ");
    namesMap.put("MK", "ᎹᏎᏙᏂᏯ");
    namesMap.put("ML", "ᎹᎵ");
    namesMap.put("MM", "ᎹᏯᎹᎵ (ᏇᎵᎹ)");
    namesMap.put("MN", "ᎹᏂᎪᎵᎠ");
    namesMap.put("MO", "ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ");
    namesMap.put("MP", "ᏧᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛᎢ");
    namesMap.put("MQ", "ᎹᏘᏂᎨ");
    namesMap.put("MR", "ᎹᏘᎢᏯ");
    namesMap.put("MS", "ᎹᏂᏘᏌᎳᏗ");
    namesMap.put("MT", "ᎹᎵᏔ");
    namesMap.put("MU", "ᎼᎵᏏᎥᏍ");
    namesMap.put("MV", "ᎹᎵᏗᏫᏍ");
    namesMap.put("MW", "ᎹᎳᏫ");
    namesMap.put("MX", "ᎠᏂᏍᏆᏂ");
    namesMap.put("MY", "ᎹᎴᏏᎢᎠ");
    namesMap.put("MZ", "ᎼᏎᎻᏇᎩ");
    namesMap.put("NA", "ᎾᎻᏈᎢᏯ");
    namesMap.put("NC", "ᎢᏤ ᎧᎵᏙᏂᎠᏂ");
    namesMap.put("NE", "ᎾᎢᏨ");
    namesMap.put("NF", "ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛᎢ");
    namesMap.put("NG", "ᏂᏥᎵᏯ");
    namesMap.put("NI", "ᏂᎧᎳᏆ");
    namesMap.put("NL", "ᏁᏛᎳᏂ");
    namesMap.put("NO", "ᏃᏪ");
    namesMap.put("NP", "ᏁᏆᎵ");
    namesMap.put("NR", "ᏃᎤᎷ");
    namesMap.put("NU", "ᏂᏳ");
    namesMap.put("NZ", "ᎢᏤ ᏏᎢᎴᏂᏗ");
    namesMap.put("OM", "ᎣᎺᏂ");
    namesMap.put("PA", "ᏆᎾᎹ");
    namesMap.put("PE", "ᏇᎷ");
    namesMap.put("PF", "ᎠᏂᎦᎸᏥ ᏆᎵᏂᏏᎠ");
    namesMap.put("PG", "ᏆᏇ ᎢᏤ ᎩᎢᏂ");
    namesMap.put("PH", "ᎠᏂᏈᎵᎩᏃ");
    namesMap.put("PK", "ᏆᎩᏍᏖᏂ");
    namesMap.put("PL", "ᏉᎳᏂ");
    namesMap.put("PM", "ᎤᏓᏅᏘ ᏈᏰ ᎠᎴ ᎻᏇᎶᏂ");
    namesMap.put("PN", "ᏈᎧᎵᏂ ᏚᎦᏚᏛᎢ");
    namesMap.put("PR", "ᏇᎡᏙ ᎵᎢᎪ");
    namesMap.put("PS", "ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ");
    namesMap.put("PT", "ᏉᏥᎦᎳ");
    namesMap.put("PW", "ᏆᎴᎠᏫ");
    namesMap.put("PY", "ᏆᎳᏇᎢᏯ");
    namesMap.put("QA", "ᎧᏔᎵ");
    namesMap.put("QO", "ᎠᏍᏛ ᎣᏏᏰᏂᎠ");
    namesMap.put("RE", "ᎴᏳᏂᎠᏂ");
    namesMap.put("RO", "ᎶᎹᏂᏯ");
    namesMap.put("RS", "ᏒᏈᏯ");
    namesMap.put("RU", "ᏲᏂᎢ");
    namesMap.put("RW", "ᎶᏩᏂᏓ");
    namesMap.put("SA", "ᏌᎤᏗ ᎡᎴᏈᎠ");
    namesMap.put("SB", "ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ");
    namesMap.put("SC", "ᏏᎡᏥᎵᏍ");
    namesMap.put("SD", "ᏑᏕᏂ");
    namesMap.put("SE", "ᏍᏫᏕᏂ");
    namesMap.put("SG", "ᏏᏂᎦᏉᎵ");
    namesMap.put("SH", "ᎤᏓᏅᏘ ᎮᎵᎾ");
    namesMap.put("SI", "ᏍᎶᏫᏂᎠ");
    namesMap.put("SJ", "ᏍᏩᎵᏆᎵᏗ ᎠᎴ ᏤᏂ ᎹᏰᏂ");
    namesMap.put("SK", "ᏍᎶᏩᎩᎠ");
    namesMap.put("SL", "ᏏᎡᎳ ᎴᎣᏂ");
    namesMap.put("SM", "ᎤᏓᏅᏘ ᎹᎵᎢᏃ");
    namesMap.put("SN", "ᏏᏂᎦᎵ");
    namesMap.put("SO", "ᏐᎹᎵ");
    namesMap.put("SR", "ᏒᎵᎾᎻ");
    namesMap.put("SS", "ᏧᎦᎾᏮ ᏑᏕᏂ");
    namesMap.put("ST", "ᏌᎣ ᏙᎺ ᎠᎴ ᏈᏂᏏᏇ");
    namesMap.put("SV", "ᎡᎵᏌᎵᏆᏙᎵ");
    namesMap.put("SX", "ᏏᏂᏘ ᎹᏘᏂ");
    namesMap.put("SY", "ᏏᎵᎠ");
    namesMap.put("SZ", "ᎠᏂᏍᏩᏏᎢ");
    namesMap.put("TA", "ᏟᏍᏛᏂ Ꮣ ᎫᎾᎭ");
    namesMap.put("TC", "ᎠᏂᏛᎵᎩ ᎠᎴ ᎨᎢᎪ ᏚᎦᏚᏛᎢ");
    namesMap.put("TD", "ᏣᏗ");
    namesMap.put("TF", "ᎠᏂᎦᎸᏥ ᏧᎦᎾᏮ ᎦᏙᎯ ᎤᎵᏍᏛᎢ");
    namesMap.put("TG", "ᏙᎪ");
    namesMap.put("TH", "ᏔᏯᎴᏂ");
    namesMap.put("TJ", "ᏔᏥᎩᏍᏕᏂ");
    namesMap.put("TK", "ᏙᎨᎳᏭ");
    namesMap.put("TL", "ᏘᎼᎵ-ᎴᏍᏖ");
    namesMap.put("TM", "ᏛᎵᎩᎺᏂᏍᏔᏂ");
    namesMap.put("TN", "ᏚᏂᏏᏍᎠ");
    namesMap.put("TO", "ᏙᎾᎦ");
    namesMap.put("TR", "ᎬᏃ");
    namesMap.put("TT", "ᏟᏂᏕᏗ ᎠᎴ ᏙᏆᎪ");
    namesMap.put("TV", "ᏚᏩᎷ");
    namesMap.put("TW", "ᏔᎢᏩᏂ");
    namesMap.put("TZ", "ᏖᏂᏏᏂᏯ");
    namesMap.put("UA", "ᏳᎧᎴᏂ");
    namesMap.put("UG", "ᏳᎦᏂᏓ");
    namesMap.put("UM", "U.S. ᎠᏍᏛ ᏚᎦᏚᏛᎢ");
    namesMap.put("UN", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎠᏰᎵ ᏚᎾᏙᏢᏒ");
    namesMap.put("US", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ");
    namesMap.put("UY", "ᏳᎷᏇ");
    namesMap.put("UZ", "ᎤᏍᏇᎩᏍᏖᏂ");
    namesMap.put("VA", "ᎠᏥᎳᏁᏠ ᎦᏚᎲ");
    namesMap.put("VC", "ᎤᏓᏅᏘ ᏫᏂᏏᏂᏗ ᎠᎴ ᎾᏍᎩ ᏇᎾᏗᏁᏍ");
    namesMap.put("VE", "ᏪᏁᏑᏪᎳ");
    namesMap.put("VG", "ᏈᏗᏍ ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ");
    namesMap.put("VI", "U.S. ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ");
    namesMap.put("VN", "ᏫᎡᏘᎾᎻ");
    namesMap.put("VU", "ᏩᏂᎤᏩᏚ");
    namesMap.put("WF", "ᏩᎵᏍ ᎠᎴ ᏊᏚᎾ");
    namesMap.put("WS", "ᏌᎼᎠ");
    namesMap.put("XK", "ᎪᏐᏉ");
    namesMap.put("YE", "ᏰᎺᏂ");
    namesMap.put("YT", "ᎺᏯᏖ");
    namesMap.put("ZA", "ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ");
    namesMap.put("ZM", "ᏌᎻᏈᏯ");
    namesMap.put("ZW", "ᏏᎻᏆᏇ");
    namesMap.put("ZZ", "ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ᎡᎶᎯ",
        "002": "ᎬᎿᎨᏍᏛ",
        "003": "ᏧᏴᏢ ᎠᎹᏰᏟ",
        "005": "ᏧᎦᏃᏮ ᎠᎺᎵᎦ",
        "009": "ᎣᏏᏰᏂᎠ",
        "011": "ᏭᏕᎵᎬ ᏗᏜ ᎬᎿᎨᏍᏛ",
        "013": "ᎠᏰᏟ ᎠᎹᏰᏟ",
        "014": "ᏗᎧᎸᎬ ᏗᏜ ᎬᎿᎨᏍᏛ",
        "015": "ᏧᏴᏢ ᏗᏜ ᎬᎿᎨᏍᏛ",
        "017": "ᎠᏰᏟ ᎬᎿᎨᏍᏛ",
        "018": "ᏧᎦᎾᏮ ᏗᏜ ᎬᎿᎨᏍᏛ",
        "019": "ᎠᎺᎵᎦᎢ",
        "021": "ᏧᏴᏢ ᏗᏜ ᎠᎹᏰᏟ",
        "029": "ᎨᏆᏙᏯ",
        "030": "ᏗᎧᎸᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ",
        "034": "ᏧᎦᎾᏮ ᏗᏜ ᏓᎶᏂᎨᏍᏛ",
        "035": "ᏧᎦᎾᏮ ᏗᎧᎸᎬ ᏓᎶᏂᎨᏍᏛ",
        "039": "ᏧᎦᎾᏮ ᏗᏜ ᏳᎳᏛ",
        "053": "ᎠᏍᏔᎴᏏᎠ",
        "054": "ᎺᎳᏁᏏᎠ",
        "057": "ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ ᎢᎬᎾᏕᎾ",
        "061": "ᏆᎵᏂᏏᎠ",
        "142": "ᏓᎶᎾᎨᏍᏛ",
        "143": "ᎠᏰᏟ ᏓᎶᏂᎨᏍᏛ",
        "145": "ᏭᏕᎵᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ",
        "150": "ᏳᎳᏛ",
        "151": "ᏗᎧᎸᎬ ᏗᏜ ᏳᎳᏛ",
        "154": "ᏧᏴᏢ ᏗᏜ ᏳᎳᏛ",
        "155": "ᏭᏕᎵᎬ ᏗᏜ ᏳᎳᏛ",
        "202": "ᎭᏫᏂ-ᏌᎭᏩ ᎬᎿᎨᏍᏛ",
        "419": "ᎳᏘᏂ ᎠᎹᏰᏟ",
        "AC": "ᎤᎵᏌᎳᏓᏅ ᎤᎦᏚᏛᎢ",
        "AD": "ᎠᏂᏙᎳ",
        "AE": "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ",
        "AF": "ᎠᏫᎨᏂᏍᏖᏂ",
        "AG": "ᎤᏪᏘ & ᏆᏊᏓ",
        "AI": "ᎠᏂᎩᎳ",
        "AL": "ᎠᎵᏇᏂᏯ",
        "AM": "ᎠᎵᎻᏂᎠ",
        "AO": "ᎠᏂᎪᎳ",
        "AQ": "ᏧᏁᏍᏓᎸ",
        "AR": "ᎠᏥᏂᏘᏂᎠ",
        "AS": "ᎠᎺᎵᎧ ᏌᎼᎠ",
        "AT": "ᎠᏍᏟᏯ",
        "AU": "ᎡᎳᏗᏜ",
        "AW": "ᎠᎷᏆ",
        "AX": "ᎣᎴᏅᏓ ᏚᎦᏚᏛᎢ",
        "AZ": "ᎠᏎᏆᏣᏂ",
        "BA": "ᏉᏏᏂᎠ & ᎲᏤᎪᏫ",
        "BB": "ᏆᏇᏙᏍ",
        "BD": "ᏆᏂᎦᎵᏕᏍ",
        "BE": "ᏇᎵᏥᎥᎻ",
        "BF": "ᏋᎩᎾ ᏩᏐ",
        "BG": "ᏊᎵᎨᎵᎠ",
        "BH": "ᏆᎭᎴᎢᏂ",
        "BI": "ᏋᎷᏂᏗ",
        "BJ": "ᏆᏂᎢᏂ",
        "BL": "ᎤᏓᏅᏘ ᏆᏕᎳᎻ",
        "BM": "ᏆᏊᏓ",
        "BN": "ᏊᎾᎢ",
        "BO": "ᏉᎵᏫᎠ",
        "BQ": "ᎧᎵᏈᎢᏂᎯ ᎾᏍᎩᏁᏛᎳᏂ",
        "BR": "ᏆᏏᎵ",
        "BS": "ᎾᏍᎩ ᏆᎭᎹᏍ",
        "BT": "ᏊᏔᏂ",
        "BV": "ᏊᏪ ᎤᎦᏚᏛᎢ",
        "BW": "ᏆᏣᏩᎾ",
        "BY": "ᏇᎳᎷᏍ",
        "BZ": "ᏇᎵᏍ",
        "CA": "ᎨᎾᏓ",
        "CC": "ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛᎢ",
        "CD": "ᎧᏂᎪ - ᎨᏂᏝᏌ",
        "CF": "ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ",
        "CG": "ᎧᏂᎪ - ᏆᏌᏩᎵ",
        "CH": "ᏍᏫᏍ",
        "CI": "ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ",
        "CK": "ᎠᏓᏍᏓᏴᎲᏍᎩ ᏚᎦᏚᏛᎢ",
        "CL": "ᏥᎵ",
        "CM": "ᎧᎹᎷᏂ",
        "CN": "ᏓᎶᏂᎨᏍᏛ",
        "CO": "ᎪᎸᎻᏈᎢᎠ",
        "CP": "ᎦᏂᏴᏔᏅᎣᏓᎸ ᎤᎦᏚᏛᎢ",
        "CR": "ᎪᏍᏓ ᎵᎧ",
        "CU": "ᎫᏆ",
        "CV": "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ",
        "CW": "ᎫᎳᎨᎣ",
        "CX": "ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛᎢ",
        "CY": "ᏌᎢᏆᏍ",
        "CZ": "ᏤᎩᎠ",
        "DE": "ᎠᏂᏛᏥ",
        "DG": "ᏗᏰᎪ ᎦᏏᏯ",
        "DJ": "ᏥᏊᏗ",
        "DK": "ᏗᏂᎹᎦ",
        "DM": "ᏙᎻᏂᎧ",
        "DO": "ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ",
        "DZ": "ᎠᎵᏥᎵᏯ",
        "EA": "ᏑᏔ ᎠᎴ ᎺᎵᏯ",
        "EC": "ᎡᏆᏙᎵ",
        "EE": "ᎡᏍᏙᏂᏯ",
        "EG": "ᎢᏥᏈᎢ",
        "EH": "ᏭᏕᎵᎬ ᏗᏜ ᏌᎮᎳ",
        "ER": "ᎡᎵᏟᏯ",
        "ES": "ᎠᏂᏍᏆᏂᏱ",
        "ET": "ᎢᏗᎣᏈᎠ",
        "EU": "ᏳᎳᏛ ᎠᏂᎤᎾᏓᏡᎬ",
        "EZ": "ᏳᎶᎠᏍᏓᏅᏅ",
        "FI": "ᏫᏂᎦᏙᎯ",
        "FJ": "ᏫᏥ",
        "FK": "ᏩᎩ ᏚᎦᏚᏛᎢ",
        "FM": "ᎹᎢᏉᏂᏏᏯ",
        "FO": "ᏪᎶ ᏚᎦᏚᏛᎢ",
        "FR": "ᎦᎸᏥᏱ",
        "GA": "ᎦᏉᏂ",
        "GB": "ᎩᎵᏏᏲ",
        "GD": "ᏋᎾᏓ",
        "GE": "ᏣᎠᏥᎢ",
        "GF": "ᎠᏂᎦᎸᏥ ᎩᎠ",
        "GG": "ᎬᏂᏏ",
        "GH": "ᎦᎠᎾ",
        "GI": "ᏥᏆᎵᏓ",
        "GL": "ᎢᏤᏍᏛᏱ",
        "GM": "ᎦᎹᏈᎢᎠ",
        "GN": "ᎩᎢᏂ",
        "GP": "ᏩᏓᎷᏇ",
        "GQ": "ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ",
        "GR": "ᎪᎢᎯ",
        "GS": "ᏧᎦᏃᏮ ᏣᎠᏥᎢ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛᎢ",
        "GT": "ᏩᏔᎹᎳ",
        "GU": "ᏆᎻ",
        "GW": "ᎩᎢᏂ-ᏈᏌᎤᏫ",
        "GY": "ᎦᏯᎾ",
        "HK": "ᎰᏂᎩ ᎪᏂᎩ ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ ᏓᎶᏂᎨᏍᏛ",
        "HM": "ᎲᏗ ᎤᎦᏚᏛᎢ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛᎢ",
        "HN": "ᎭᏂᏚᎳᏍ",
        "HR": "ᎧᎶᎡᏏᎠ",
        "HT": "ᎮᎢᏘ",
        "HU": "ᎲᏂᎦᎵ",
        "IC": "ᏥᏍᏆ ᏚᎦᏚᏛᎢ",
        "ID": "ᎢᏂᏙᏂᏍᏯ",
        "IE": "ᎠᏲᎳᏂ",
        "IL": "ᎢᏏᎵᏱ",
        "IM": "ᎤᏍᏗ ᎤᎦᏚᏛᎢ ᎾᎿ ᎠᏍᎦᏯ",
        "IN": "ᎢᏅᏗᎾ",
        "IO": "ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ",
        "IQ": "ᎢᎳᎩ",
        "IR": "ᎢᎴᏂ",
        "IS": "ᏧᏁᏍᏓᎸᎯ",
        "IT": "ᎢᏔᎵ",
        "JE": "ᏨᎵᏏ",
        "JM": "ᏣᎺᎢᎧ",
        "JO": "ᏦᏓᏂ",
        "JP": "ᏣᏩᏂᏏ",
        "KE": "ᎨᏂᏯ",
        "KG": "ᎩᎵᏣᎢᏍ",
        "KH": "ᎧᎹᏉᏗᎠᏂ",
        "KI": "ᎧᎵᏆᏘ",
        "KM": "ᎪᎼᎳᏍ",
        "KN": "ᎤᏓᏅᏘ ᎨᏘᏏ ᎠᎴ ᏁᏪᏏ",
        "KP": "ᏧᏴᏢ ᎪᎵᎠ",
        "KR": "ᏧᎦᏃᏮ ᎪᎵᎠ",
        "KW": "ᎫᏪᎢᏘ",
        "KY": "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ",
        "KZ": "ᎧᏎᎧᏍᏕᏂ",
        "LA": "ᎴᎣᏍ",
        "LB": "ᎴᏆᎾᏂ",
        "LC": "ᎤᏓᏅᏘ ᎷᏏᏯ",
        "LI": "ᎵᎦᏗᏂᏍᏓᏂ",
        "LK": "ᏍᎵ ᎳᏂᎧ",
        "LR": "ᎳᏈᎵᏯ",
        "LS": "ᎴᏐᏙ",
        "LT": "ᎵᏗᏪᏂᎠ",
        "LU": "ᎸᎧᏎᏋᎩ",
        "LV": "ᎳᏘᏫᎠ",
        "LY": "ᎵᏈᏯ",
        "MA": "ᎼᎶᎪ",
        "MC": "ᎹᎾᎪ",
        "MD": "ᎹᎵᏙᏫᎠ",
        "ME": "ᎼᏂᏔᏁᎦᎶ",
        "MF": "ᎤᏓᏅᏘ ᏡᏡ",
        "MG": "ᎹᏓᎦᏍᎧᎵ",
        "MH": "ᎹᏌᎵ ᏚᎦᏚᏛᎢ",
        "MK": "ᎹᏎᏙᏂᏯ",
        "ML": "ᎹᎵ",
        "MM": "ᎹᏯᎹᎵ (ᏇᎵᎹ)",
        "MN": "ᎹᏂᎪᎵᎠ",
        "MO": "ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ",
        "MP": "ᏧᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛᎢ",
        "MQ": "ᎹᏘᏂᎨ",
        "MR": "ᎹᏘᎢᏯ",
        "MS": "ᎹᏂᏘᏌᎳᏗ",
        "MT": "ᎹᎵᏔ",
        "MU": "ᎼᎵᏏᎥᏍ",
        "MV": "ᎹᎵᏗᏫᏍ",
        "MW": "ᎹᎳᏫ",
        "MX": "ᎠᏂᏍᏆᏂ",
        "MY": "ᎹᎴᏏᎢᎠ",
        "MZ": "ᎼᏎᎻᏇᎩ",
        "NA": "ᎾᎻᏈᎢᏯ",
        "NC": "ᎢᏤ ᎧᎵᏙᏂᎠᏂ",
        "NE": "ᎾᎢᏨ",
        "NF": "ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛᎢ",
        "NG": "ᏂᏥᎵᏯ",
        "NI": "ᏂᎧᎳᏆ",
        "NL": "ᏁᏛᎳᏂ",
        "NO": "ᏃᏪ",
        "NP": "ᏁᏆᎵ",
        "NR": "ᏃᎤᎷ",
        "NU": "ᏂᏳ",
        "NZ": "ᎢᏤ ᏏᎢᎴᏂᏗ",
        "OM": "ᎣᎺᏂ",
        "PA": "ᏆᎾᎹ",
        "PE": "ᏇᎷ",
        "PF": "ᎠᏂᎦᎸᏥ ᏆᎵᏂᏏᎠ",
        "PG": "ᏆᏇ ᎢᏤ ᎩᎢᏂ",
        "PH": "ᎠᏂᏈᎵᎩᏃ",
        "PK": "ᏆᎩᏍᏖᏂ",
        "PL": "ᏉᎳᏂ",
        "PM": "ᎤᏓᏅᏘ ᏈᏰ ᎠᎴ ᎻᏇᎶᏂ",
        "PN": "ᏈᎧᎵᏂ ᏚᎦᏚᏛᎢ",
        "PR": "ᏇᎡᏙ ᎵᎢᎪ",
        "PS": "ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ",
        "PT": "ᏉᏥᎦᎳ",
        "PW": "ᏆᎴᎠᏫ",
        "PY": "ᏆᎳᏇᎢᏯ",
        "QA": "ᎧᏔᎵ",
        "QO": "ᎠᏍᏛ ᎣᏏᏰᏂᎠ",
        "RE": "ᎴᏳᏂᎠᏂ",
        "RO": "ᎶᎹᏂᏯ",
        "RS": "ᏒᏈᏯ",
        "RU": "ᏲᏂᎢ",
        "RW": "ᎶᏩᏂᏓ",
        "SA": "ᏌᎤᏗ ᎡᎴᏈᎠ",
        "SB": "ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ",
        "SC": "ᏏᎡᏥᎵᏍ",
        "SD": "ᏑᏕᏂ",
        "SE": "ᏍᏫᏕᏂ",
        "SG": "ᏏᏂᎦᏉᎵ",
        "SH": "ᎤᏓᏅᏘ ᎮᎵᎾ",
        "SI": "ᏍᎶᏫᏂᎠ",
        "SJ": "ᏍᏩᎵᏆᎵᏗ ᎠᎴ ᏤᏂ ᎹᏰᏂ",
        "SK": "ᏍᎶᏩᎩᎠ",
        "SL": "ᏏᎡᎳ ᎴᎣᏂ",
        "SM": "ᎤᏓᏅᏘ ᎹᎵᎢᏃ",
        "SN": "ᏏᏂᎦᎵ",
        "SO": "ᏐᎹᎵ",
        "SR": "ᏒᎵᎾᎻ",
        "SS": "ᏧᎦᎾᏮ ᏑᏕᏂ",
        "ST": "ᏌᎣ ᏙᎺ ᎠᎴ ᏈᏂᏏᏇ",
        "SV": "ᎡᎵᏌᎵᏆᏙᎵ",
        "SX": "ᏏᏂᏘ ᎹᏘᏂ",
        "SY": "ᏏᎵᎠ",
        "SZ": "ᎠᏂᏍᏩᏏᎢ",
        "TA": "ᏟᏍᏛᏂ Ꮣ ᎫᎾᎭ",
        "TC": "ᎠᏂᏛᎵᎩ ᎠᎴ ᎨᎢᎪ ᏚᎦᏚᏛᎢ",
        "TD": "ᏣᏗ",
        "TF": "ᎠᏂᎦᎸᏥ ᏧᎦᎾᏮ ᎦᏙᎯ ᎤᎵᏍᏛᎢ",
        "TG": "ᏙᎪ",
        "TH": "ᏔᏯᎴᏂ",
        "TJ": "ᏔᏥᎩᏍᏕᏂ",
        "TK": "ᏙᎨᎳᏭ",
        "TL": "ᏘᎼᎵ-ᎴᏍᏖ",
        "TM": "ᏛᎵᎩᎺᏂᏍᏔᏂ",
        "TN": "ᏚᏂᏏᏍᎠ",
        "TO": "ᏙᎾᎦ",
        "TR": "ᎬᏃ",
        "TT": "ᏟᏂᏕᏗ ᎠᎴ ᏙᏆᎪ",
        "TV": "ᏚᏩᎷ",
        "TW": "ᏔᎢᏩᏂ",
        "TZ": "ᏖᏂᏏᏂᏯ",
        "UA": "ᏳᎧᎴᏂ",
        "UG": "ᏳᎦᏂᏓ",
        "UM": "U.S. ᎠᏍᏛ ᏚᎦᏚᏛᎢ",
        "UN": "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎠᏰᎵ ᏚᎾᏙᏢᏒ",
        "US": "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ",
        "UY": "ᏳᎷᏇ",
        "UZ": "ᎤᏍᏇᎩᏍᏖᏂ",
        "VA": "ᎠᏥᎳᏁᏠ ᎦᏚᎲ",
        "VC": "ᎤᏓᏅᏘ ᏫᏂᏏᏂᏗ ᎠᎴ ᎾᏍᎩ ᏇᎾᏗᏁᏍ",
        "VE": "ᏪᏁᏑᏪᎳ",
        "VG": "ᏈᏗᏍ ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ",
        "VI": "U.S. ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ",
        "VN": "ᏫᎡᏘᎾᎻ",
        "VU": "ᏩᏂᎤᏩᏚ",
        "WF": "ᏩᎵᏍ ᎠᎴ ᏊᏚᎾ",
        "WS": "ᏌᎼᎠ",
        "XK": "ᎪᏐᏉ",
        "YE": "ᏰᎺᏂ",
        "YT": "ᎺᏯᏖ",
        "ZA": "ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ",
        "ZM": "ᏌᎻᏈᏯ",
        "ZW": "ᏏᎻᏆᏇ",
        "ZZ": "ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ"
    };
  }-*/;
}
