/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class B64
extends Bin {
    public static final B64 EMPTY = new B64(new byte[0]);
    private static final B64[] B64S;

    private B64(byte[] data) {
        super(data, AtomType.BASE64_BINARY);
    }

    B64() {
        this((byte[])null);
    }

    public static B64 get(byte value) {
        return B64S[value & 0xFF];
    }

    public static B64 get(byte[] value) {
        return value.length == 1 ? B64.get(value[0]) : new B64(value);
    }

    public static B64 get(Bin bin, InputInfo info) throws QueryException {
        return B64.get(bin.binary(info));
    }

    public static B64 get(byte[] value, InputInfo info) throws QueryException {
        return B64.get(B64.parse(value, info));
    }

    @Override
    public final void write(DataOutput out) throws IOException, QueryException {
        out.writeToken(this.binary(null));
    }

    @Override
    public final byte[] string(InputInfo ii) throws QueryException {
        return Base64.encode(this.binary(ii));
    }

    public int hashCode() {
        try {
            return Token.hashCode(this.binary(null));
        }
        catch (QueryException ex) {
            Util.stack(ex);
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public final byte[] parse(Item item, InputInfo info) throws QueryException {
        return B64.parse(item.string(info), info);
    }

    public static byte[] parse(byte[] value, InputInfo info) throws QueryException {
        try {
            return Base64.decode(value);
        }
        catch (IllegalArgumentException ex) {
            Util.debug(ex);
            throw AtomType.BASE64_BINARY.castError(value, info);
        }
    }

    @Override
    public void toString(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(34);
        if (this.data.length > 128) {
            tb.add(Base64.encode(Arrays.copyOf(this.data, 128))).add("...");
        } else {
            tb.add(Base64.encode(this.data));
        }
        qs.token(tb.add(34).finish());
    }

    static {
        int nl = 256;
        B64S = new B64[256];
        for (int n = 0; n < 256; ++n) {
            B64.B64S[n] = new B64(new byte[]{(byte)n});
        }
    }
}

