/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.index.ValueAccess;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

abstract class Ids
extends ContextFn {
    private final Map<Data, Boolean> indexed = Collections.synchronizedMap(new IdentityHashMap());

    Ids() {
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.ids(qc);
    }

    private Value ids(QueryContext qc) throws QueryException {
        TokenSet idSet = this.ids(this.arg(0).atomIter(qc, this.info), qc);
        ANode node = this.toNodeOrNull(this.arg(1), qc);
        ANode root = (node != null ? node : this.toNode(this.context(qc), qc)).root();
        if (root.type != NodeType.DOCUMENT_NODE) {
            throw QueryError.IDDOC.get(this.info, new Object[0]);
        }
        ANodeBuilder results = new ANodeBuilder();
        boolean idref = this.idref();
        if (this.index(root, idref)) {
            Item item;
            Data data = root.data();
            ValueAccess va = new ValueAccess(this.info, idSet, idref ? IndexType.TOKEN : IndexType.ATTRIBUTE, null, (IndexDb)new IndexStaticDb(data, this.info));
            Iter iter = va.iter(qc);
            while ((item = iter.next()) != null) {
                ANode attr = (ANode)item;
                if (!XMLToken.isId(attr.name(), idref) || !idref && idSet.remove(attr.string()) == 0 || data.meta.ndocs != 1 && !attr.root().is(root)) continue;
                results.add(idref ? attr : attr.parent());
            }
        } else {
            this.add(idSet, results, root);
        }
        return results.value(this);
    }

    private boolean index(ANode root, boolean idref) {
        Data data = root.data();
        if (data == null || (idref ? !data.meta.tokenindex : !data.meta.attrindex)) {
            return false;
        }
        return this.indexed.computeIfAbsent(data, d -> new IndexNames(IndexType.ATTRIBUTE, (Data)d).containsIds(idref));
    }

    private void add(TokenSet idSet, ANodeBuilder results, ANode node) {
        boolean idref = this.idref();
        for (ANode attr : node.attributeIter()) {
            if (!XMLToken.isId(attr.name(), idref)) continue;
            boolean found = false;
            for (byte[] id : Token.distinctTokens(attr.string())) {
                if (!(idref ? idSet.contains(id) : idSet.remove(id) != 0) || found) continue;
                results.add(idref ? attr.finish() : node.finish());
                found = true;
            }
        }
        for (ANode child : node.childIter()) {
            this.add(idSet, results, child);
        }
    }

    private TokenSet ids(Iter iter, QueryContext qc) throws QueryException {
        Item ids;
        TokenSet ts = new TokenSet();
        while ((ids = qc.next(iter)) != null) {
            for (byte[] id : Token.distinctTokens(this.toToken(ids))) {
                if (!XMLToken.isNCName(id)) continue;
                ts.put(id);
            }
        }
        return ts;
    }

    boolean idref() {
        return false;
    }

    @Override
    public final int contextIndex() {
        return 1;
    }

    @Override
    public final boolean ddo() {
        return true;
    }
}

