/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.basex.local;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.xml.xquery.XQException;
import net.xqj.basex.Constants;
import net.xqj.basex.util.CityHash;
import net.xqj.basic.BasicQuery;
import org.basex.core.Context;
import org.basex.query.QueryProcessor;

public class BasicQueryImpl
extends BasicQuery {
    private static final HashMap<Long, SoftReference<QueryProcessor>> cachedXQProcessors = new HashMap();
    private StringWriter writer;
    private QueryProcessor qp;
    private final Context ctx;
    private boolean dirty = true;

    public BasicQueryImpl(Context ctx) {
        this.ctx = ctx;
        this.writer = new StringWriter();
    }

    @Override
    public void hint(String name, String value) throws XQException {
    }

    public QueryProcessor createQueryProcessor() {
        if (this.dirty) {
            if (this.qp != null) {
                this.qp.close();
            }
            String XQuery = this.toString();
            if (Constants.CACHE_QUERY_PROCESSORS) {
                Long hash = CityHash.cityHash64(XQuery.getBytes());
                SoftReference<QueryProcessor> ref = cachedXQProcessors.get(hash);
                if (ref == null || (this.qp = ref.get()) == null) {
                    cachedXQProcessors.put(hash, new SoftReference<QueryProcessor>(this.setNewQueryProcessor(XQuery)));
                } else if (this.ctx != this.qp.qc.context) {
                    this.setNewQueryProcessor(XQuery);
                }
            } else {
                this.setNewQueryProcessor(XQuery);
            }
            this.dirty = false;
        }
        return this.qp;
    }

    private final QueryProcessor setNewQueryProcessor(String XQuery) {
        this.qp = new QueryProcessor(XQuery, this.ctx);
        return this.qp;
    }

    @Override
    public ByteBuffer getCompleteQuery() throws XQException {
        byte[] buffer = this.toString().getBytes(Constants.UTF8);
        return ByteBuffer.wrap(buffer);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        this.dirty = true;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
        this.dirty = true;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.writer.toString();
    }
}

